/*
 * MTPVTTest.cpp
 *
 *  Created on: Dec 26, 2013
 *      Author: din3kor
 */
/*lint -save -e1773 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPVTTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <stdlib.h>
#include <errno.h>
#include <memory.h>
#include <sqlite3.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <vector>

using namespace std;

#include "LocalSPM.h"
#include "MTPVTTest.h"
#include "TypeDefinitions.h"
#include <FunctionTracer.h>

enum {
    SORT = 0,
    DONT_SORT = 1,
    ALL = 2,
    WO_UNKNOWN = 4
};

static sqlite3 *mDBHandle;                  // data base handle for all tests
static tMountPoint mMountPoint;

void MTPVTTest::InitTestSuite()
{
    ENTRY

    ETG_TRACE_USR4(("MTPControlTestRealDevice::setUp: check if real MTP devices are connected "));

    tDeviceID           m_deviceID;
    bool                m_bRealDeviceConnected = false;
    tDeviceName         m_strModelname;
    tDeviceName         m_strFriendlyname;
    tDeviceSerialNumber m_strSerialnumber;
    tDeviceVersion      m_strDeviceversion;
    tDeviceName         m_strManufacturername;
    tMemorySize         m_totalSize = 0;
    tMemorySize         m_freeSize = 0;

    util_getConnectedMTPDevice( OUT m_bRealDeviceConnected,IN m_strModelname,IN m_strFriendlyname,
                                IN m_strSerialnumber ,IN m_strDeviceversion,IN m_strManufacturername);

    ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strModelname        : %s",m_strModelname));
    ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strFriendlyname     : %s",m_strFriendlyname));
    ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strSerialnumber     : %s",m_strSerialnumber));
    ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strDeviceversion    : %s",m_strDeviceversion));
    ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strManufacturername : %s",m_strManufacturername));

    if(true == m_bRealDeviceConnected)
    {
        ETG_TRACE_USR4(("************ MTPControlTestRealDevice:: FOUND REAL MTP DEVICE **********************"));
        LocalSPM::GetMTPControl().TestIF_setWrapper(eMTPWrapper_realLib);

        //----------------------------------------------------------------------------
        //recreate DB and fill detected device since a real device has been detected
        //----------------------------------------------------------------------------
        util_recreateDB();
        util_InsertNewMTPDevicetoDB(m_strSerialnumber, m_strDeviceversion, m_strFriendlyname, EMPTY_STRING,m_totalSize, m_freeSize);
        util_showdevicesDB();

        //-----------------------------------------------------------------------
        //delete tmp-files on target  i.e. last uploaded MTP-File plus info file
        //-----------------------------------------------------------------------
        util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
        util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

        snprintf(mMountPoint , sizeof (mMountPoint ),"%s/%s/%s/",m_strFriendlyname,m_strDeviceversion,m_strSerialnumber);
        util_InitDeviceConnection(OUT m_deviceID,IN mMountPoint);
        sleep(3); ///@todo add mechanism to get real feedback from MTPControl
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPVTTest::EndTestSuite()
{
    ENTRY

    //care that stub MTPLib is used for stubbed test
    LocalSPM::GetMTPControl().TestIF_setWrapper(eMTPWrapper_stubLib);

    //renew database of 'connected' devices
    util_recreateDB();

    //delete tmp-files on target  i.e. last uploaded MTP-File plus info file
    util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);
}

int MTPVTTest::Query(char *mountPoint, char *path, char *comparePath, int flags, vector<char *> expectedNames, vector<int> expectedTypes, int doAssert)
{
    (void)comparePath;
    (void)expectedNames;
    (void)expectedTypes;
    (void)flags;

    ENTRY

    char query[1024];
    int res;
    int ncols;
    unsigned int rowCounter;
    sqlite3_stmt *stmt;
    const char *tail;

    /* setup the query */
    sprintf(query, "select mountpoint,path,filename,itemid,type,format,rowid from f where mountpoint match '%s' AND path match '%s';", mountPoint, path);
#if 0
    printf("Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Query='%s'", query));
#endif

    /* search for files in path */
    res = sqlite3_prepare(mDBHandle, query, (int)strlen_r(query), &stmt, &tail);
    if (doAssert)
    {
        if(res)
        {
#if 0
            printf("sqlite3_prepare result='%d',%s\n", res, sqlite3_errmsg(mDBHandle));
#else
            ETG_TRACE_USR2(("sqlite3_prepare result='%d',%s", res, sqlite3_errmsg(mDBHandle)));
#endif
        }

        CPPUNIT_ASSERT(res == SQLITE_OK);
    }
    else if (res) return res;

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt);
    if (doAssert) CPPUNIT_ASSERT(ncols == 7);

    /* do the first step */
    res = sqlite3_step(stmt);
    if (doAssert) CPPUNIT_ASSERT(res == SQLITE_ROW);
    else if (res != SQLITE_ROW) return res;

    rowCounter = 0;

    /* loop over all results */
    while(res == SQLITE_ROW)
    {
        const char* stype = NULL;

        /* get the element type */
        int ntype = sqlite3_column_int(stmt,  4);
        switch (ntype)
        {
            case FILE_TYPE_DIRECTORY:
                stype = "DIR";
                break;
            case FILE_TYPE_AUDIOOBJECT:
                stype = "MEDIAOBJECT";
                break;
            case FILE_TYPE_PLAYLIST:
                stype = "PLAYLIST";
                break;
            default:
                stype = "Unexpected";
                break;
        }

        /* print all other columns */
#if 0
        printf( "mountpoint=%s type=%d/%s path=%s name=%s uid=%d format=%d rowid=%d\n",
                 sqlite3_column_text(stmt, 0),
                 ntype,
                 stype,
                 sqlite3_column_text(stmt, 1),
                 sqlite3_column_text(stmt, 2),
                 sqlite3_column_int (stmt, 4),
                 sqlite3_column_int (stmt, 5),
                 sqlite3_column_int (stmt, 6));
#else
        ETG_TRACE_USR2(("mountpoint=%40s type=%d/%40s",
                (char *)sqlite3_column_text(stmt, 0),
                ntype,
                stype));
        ETG_TRACE_USR2(("path=%40s name=%40s itemid=%d uid=%d format=%d rowid=%d",
                (char *)sqlite3_column_text(stmt, 1),
                (char *)sqlite3_column_text(stmt, 2),
                sqlite3_column_int (stmt, 3),
                sqlite3_column_int (stmt, 4),
                sqlite3_column_int (stmt, 5),
                sqlite3_column_int (stmt, 6)));
#endif

        /* next row */
        res = sqlite3_step(stmt);
        rowCounter++;
    }

    /* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    if (doAssert) CPPUNIT_ASSERT(res == SQLITE_OK);
    else if (res) return res;

    return 0;
}

void MTPVTTest::QueryCount(char *mountPoint, char *path, int countDirectories,
        int countMediaObjects, int countPlaylists)
{
    ENTRY

    char query[1024];
    int res;
    int ncols;
    sqlite3_stmt *stmt;
    const char *tail;
    int testedDirectoires = 0;
    int testedMediaObjects = 0;
    int testedPlaylists = 0;
    int mediaObjectCount = 0;

    sprintf(query, "select type,COUNT(rowid) from f where mountpoint match '%s' AND path match '%s' group by type order by type;", mountPoint, path);
#if 0
    printf("Count Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Count Query='%s'", query));
#endif

    /* search for files in mount point */
    res = sqlite3_prepare(mDBHandle, query, (int)strlen_r(query), &stmt, &tail);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt);
    CPPUNIT_ASSERT(ncols == 2);

    /* do the first step */
    res = sqlite3_step(stmt);
    CPPUNIT_ASSERT(res == SQLITE_ROW);

    /* loop over all results */
    while(res == SQLITE_ROW)
    {

#if 0
        printf("type=%d, count=%d\n", sqlite3_column_int(stmt, 0), sqlite3_column_int(stmt, 1));
#else
        ETG_TRACE_USR2(("type=%d, count=%d", sqlite3_column_int(stmt, 0), sqlite3_column_int(stmt, 1)));
#endif
        /* compare after type id */
        switch(sqlite3_column_int (stmt,  0)) {
        case FILE_TYPE_DIRECTORY:
            CPPUNIT_ASSERT(sqlite3_column_int (stmt, 1) == countDirectories); // check the count
            testedDirectoires = 1;
            break;
        case FILE_TYPE_AUDIOOBJECT:
        case FILE_TYPE_VIDEOOBJECT: // add values to one media object count and check it later
            mediaObjectCount += sqlite3_column_int (stmt, 1);
            break;
        case FILE_TYPE_PLAYLIST:
            CPPUNIT_ASSERT(sqlite3_column_int (stmt, 1) == countPlaylists); // check the count
            testedPlaylists = 1;
            break;
        default:
            break;
        };
        /* next row */
        res = sqlite3_step(stmt);
    }

    // if media object count, check it
    if (mediaObjectCount) {
        CPPUNIT_ASSERT(mediaObjectCount == countMediaObjects); // check the count
        testedMediaObjects = 1;
    }

    /* check all non tested */
    if (!testedDirectoires) CPPUNIT_ASSERT(countDirectories == 0);
    if (!testedMediaObjects) CPPUNIT_ASSERT(countMediaObjects == 0);
    if (!testedPlaylists) CPPUNIT_ASSERT(countPlaylists == 0);

    /* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

void MTPVTTest::GetStorages()
{
    ENTRY

    if(gMTPConnected == REALDEVICECONNECTED_NO) return ; // test is valid only when real device is connected

    vector<char *> expectedNames;
    vector<int> expectedTypes;

    char path[1024];
    char comparePath[1024];

    strcpy(path, "/");
    strcpy(comparePath, "");
    /* do a count query */
    //QueryCount(mMountPoint, path, 0, 8, 0);
    /* do the query */
    Query(mMountPoint, path, comparePath, DONT_SORT, expectedNames, expectedTypes);

}

void MTPVTTest::GetStorageContents()
{
    ENTRY

    if(gMTPConnected == REALDEVICECONNECTED_NO) return ; // test is valid only when real device is connected

    vector<char *> expectedNames;
    vector<int> expectedTypes;

    char path[1024];
    char comparePath[1024];

    strcpy(path, "/Mass memory");
    strcpy(comparePath, "Mass memory");
    /* do a count query */
//  QueryCount(mMountPoint, path, 0, 8, 0);

    /* do the query */
    Query(mMountPoint, path, comparePath, DONT_SORT, expectedNames, expectedTypes);
}

void MTPVTTest::GetLevel2Contents()
{
    ENTRY

    if(gMTPConnected == REALDEVICECONNECTED_NO) return ;

    vector<char *> expectedNames;
    vector<int> expectedTypes;

    char path[1024];
    char comparePath[1024];

    strcpy(path, "");
    strcpy(comparePath, "");
    /* do a count query */
    QueryCount(mMountPoint, path, 0, 8, 0);
    /* do the query */
    Query(mMountPoint, path, comparePath, DONT_SORT, expectedNames, expectedTypes);

}

void MTPVTTest::GetLevel3Contents()
{
    ENTRY
}

void MTPVTTest::CreateVT()
{
    ENTRY

    int res;
    char *msg = NULL;

    /* Open an in-memory database */
    res = sqlite3_open(":memory:", &mDBHandle);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Enable loadable modules (DSOs) */
    res = sqlite3_enable_load_extension(mDBHandle, 1);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Load the fs virtual table. */
    res = sqlite3_load_extension(mDBHandle, "libVTMTP.so", "sqlite3_extension_init", &msg);
    if (msg) CPPUNIT_FAIL(msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    res = sqlite3_exec(mDBHandle, "create virtual table f using MTPVT", NULL, NULL, &msg);
    if (msg) CPPUNIT_FAIL(msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

void MTPVTTest::DeleteVT()
{
    ENTRY

    sqlite3_close(mDBHandle);
}
