#ifndef _IPODVTTest_H_
#define _IPODVTTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include <sqlite3.h>
#include <vector>

typedef tUInt tIPODID;
#ifndef IPOD_MARKER_BIT
#define IPOD_MARKER_BIT (1 << ((sizeof(tIPODID)*8)-1)) // sets the top most bit in the ipod id field
#endif
#define IPOD_MARKER_MASK (~IPOD_MARKER_BIT) // sets the mask to hide the ipod marker bit

class IPODVTTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( IPODVTTest );
	CPPUNIT_TEST( CreateVT );
	CPPUNIT_TEST( GetViaView );
	CPPUNIT_TEST( GetWithOffsetLimit );
	CPPUNIT_TEST( GetGenre );
	CPPUNIT_TEST( GetGenreArtist );
	CPPUNIT_TEST( GetGenreArtistAlbum );
	CPPUNIT_TEST( GetGenreArtistAlbumSong );
	CPPUNIT_TEST( DeleteVT );
    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();
    void Query(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, vector<char *> expectedNames);
    void QueryView(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, vector<char *> expectedNames);
    void QueryOffsetLimit(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, int offset, int limit, vector<char *> expectedNames);

    /*test cases*/	
	void CreateVT();
	void GetViaView();
	void GetWithOffsetLimit();
	void GetGenre();
	void GetGenreArtist();
	void GetGenreArtistAlbum();
	void GetGenreArtistAlbumSong();
	void DeleteVT();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};

#endif  // _IPODVTTest_H_
