/*lint -save -e1773 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/IPODVTTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <errno.h>
#include <memory.h>
#include <sqlite3.h>

#include <vector>

using namespace std;

#include "IPODVTTest.h"
#include "TypeDefinitions.h"
#include <FunctionTracer.h>

#define TEST_PRINT 0

extern int globalFakeTheIpod;
static sqlite3 *mDBHandleIPOD;					// data base handle for all tests

void IPODVTTest::setUp()
{
	pthread_mutex_init(&mutex,NULL);
	pthread_cond_init(&condition,NULL);
	ticks.begin();
}

void IPODVTTest::tearDown()
{
	ticks.elapsed();
	pthread_mutex_destroy(&mutex);
	pthread_cond_destroy(&condition);
}

void IPODVTTest::Query(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, vector<char *> expectedNames)
{
    ENTRY_INTERNAL

    char query[1024];
	int res;
	int ncols;
	unsigned int rowCounter;
    sqlite3_stmt *stmt;
	const char *tail;

	/* setup the first query */
	sprintf(query, "select LTY, tag1, tag2, tag3, tag4, count, ID, name, url, rowid from f "
			"where mountpoint = '%s' AND LTY = %d AND tag1 = %d AND tag2 = %d AND tag3 = %d AND tag4 = %d AND _limit=-1 AND _offset=0;",
			"/dev/usb/hiddev0",
			listType,
			tag1.tag,
			tag2.tag,
			tag3.tag,
			tag4.tag,
			"/dev/usb/hiddev0");
#if 0
	printf("Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Query='%s'", query));
#endif

	/* search for files in mount point */
    res = sqlite3_prepare(mDBHandleIPOD, query, (int)strlen_r(query), &stmt, &tail);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt);
    CPPUNIT_ASSERT(ncols == 10);

    /* do the first step */
    res = sqlite3_step(stmt);
    CPPUNIT_ASSERT(res == SQLITE_ROW);

    rowCounter = 0;

	/* loop over all results */
    while(res == SQLITE_ROW)
    {
#if TEST_PRINT // test print

		/* print all other columns */
#if 0
        printf( "Result: LTY=%d, tag1=0x%x, tag2=0x%x, tag3=0x%x, tag4=0x%x, count=%d, ID=0x%x, name='%s', url='%s', rowid=0x%x\n",
				sqlite3_column_int (stmt, 0), // LTY
				sqlite3_column_int (stmt, 1), // tag1
				sqlite3_column_int (stmt, 2), // tag2
				sqlite3_column_int (stmt, 3), // tag3
				sqlite3_column_int (stmt, 4), // tag4
				sqlite3_column_int (stmt, 5), // count
				sqlite3_column_int (stmt, 6), // ID
				sqlite3_column_text(stmt, 7), // name
				sqlite3_column_text(stmt, 8), // url
				sqlite3_column_int (stmt, 9)  // rowid
                );
#else
        ETG_TRACE_USR2(("Result: LTY=%d, tag1=0x%x, tag2=0x%x, tag3=0x%x, tag4=0x%x, count=%d",
                sqlite3_column_int (stmt, 0), // LTY
                sqlite3_column_int (stmt, 1), // tag1
                sqlite3_column_int (stmt, 2), // tag2
                sqlite3_column_int (stmt, 3), // tag3
                sqlite3_column_int (stmt, 4), // tag4
                sqlite3_column_int (stmt, 5)  // count
                ));
        ETG_TRACE_USR2(("Result: ID=0x%x, name='%40s', url='%40s', rowid=0x%x",
                sqlite3_column_int (stmt, 6), // ID
                (char *)sqlite3_column_text(stmt, 7), // name
                (char *)sqlite3_column_text(stmt, 8), // url
                sqlite3_column_int (stmt, 9)  // rowid
                ));
#endif
#endif
#if 1
		/* compare result with expectations */
		if (rowCounter < expectedNames.size()) {
			CPPUNIT_ASSERT((unsigned int)sqlite3_column_int (stmt,  5) == expectedNames.size()); // check the size column
			CPPUNIT_ASSERT(strcmp((char *)sqlite3_column_text(stmt,  7), expectedNames[rowCounter]) == 0); // check the name
		} else {
			CPPUNIT_ASSERT(rowCounter < expectedNames.size()); // check number of expected items against number of read ones
		}
#endif
		/* next row */
        res = sqlite3_step(stmt);
        rowCounter++;
    }

    CPPUNIT_ASSERT(rowCounter == expectedNames.size()); // check number of expected items against number of read ones

	/* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

/**********************************************************************
 * Test cases
 *********************************************************************/
void IPODVTTest::GetGenre()
{ 
    ENTRY_TEST

	vector<char *> expectedNames;
	tFilterTag1 tag1;
	tFilterTag2 tag2;
	tFilterTag3 tag3;
	tFilterTag4 tag4;

	tag1.genre = 0 | IPOD_MARKER_BIT;
	tag2.tag = 0 | IPOD_MARKER_BIT;
	tag3.tag = 0 | IPOD_MARKER_BIT;
	tag4.tag = 0 | IPOD_MARKER_BIT;

	expectedNames.push_back((char *)"Rock");
	expectedNames.push_back((char *)"Pop");
	expectedNames.push_back((char *)"Classic");
	expectedNames.push_back((char *)"Neue Deutsche Härte");
	Query(LTY_GENRE, tag1, tag2, tag3, tag4, expectedNames);
}

void IPODVTTest::GetGenreArtist()
{ 
    ENTRY_TEST

	vector<char *> expectedNames;
	tFilterTag1 tag1;
	tFilterTag2 tag2;
	tFilterTag3 tag3;
	tFilterTag4 tag4;

	tag1.genre = 4 | IPOD_MARKER_BIT; // Neue Deutsche Härte
	tag2.tag = 0 | IPOD_MARKER_BIT;
	tag3.tag = 0 | IPOD_MARKER_BIT;
	tag4.tag = 0 | IPOD_MARKER_BIT;

	expectedNames.push_back((char *)"Unheilig");
	expectedNames.push_back((char *)"Rammstein");
	expectedNames.push_back((char *)"Megaherz");
	Query(LTY_GENRE_ARTIST, tag1, tag2, tag3, tag4, expectedNames);
}

void IPODVTTest::GetGenreArtistAlbum()
{ 
    ENTRY_TEST

	vector<char *> expectedNames;
	tFilterTag1 tag1;
	tFilterTag2 tag2;
	tFilterTag3 tag3;
	tFilterTag4 tag4;

	tag1.genre = 4 | IPOD_MARKER_BIT; // Neue Deutsche Härte
	tag2.artist = 2 | IPOD_MARKER_BIT; // Rammstein
	tag3.tag = 0 | IPOD_MARKER_BIT;
	tag4.tag = 0 | IPOD_MARKER_BIT;

	expectedNames.push_back((char *)"1997 - Herzeild");
	expectedNames.push_back((char *)"1997 - Sehnsucht");
	expectedNames.push_back((char *)"1998 - Brachiale Gewalt");
	expectedNames.push_back((char *)"1999 - Live Aus Berlin");
	expectedNames.push_back((char *)"2001 - Mutter");
	expectedNames.push_back((char *)"2002 - Der Musikalische Staub");
	expectedNames.push_back((char *)"Maxi Cd");
	Query(LTY_GENRE_ARTIST_ALBUM, tag1, tag2, tag3, tag4, expectedNames);
}

void IPODVTTest::GetGenreArtistAlbumSong()
{ 
    ENTRY_TEST

	vector<char *> expectedNames;
	tFilterTag1 tag1;
	tFilterTag2 tag2;
	tFilterTag3 tag3;
	tFilterTag4 tag4;

	tag1.genre = 4 | IPOD_MARKER_BIT; // Neue Deutsche Härte
	tag2.artist = 2 | IPOD_MARKER_BIT; // Rammstein
	tag3.tag = 0 | IPOD_MARKER_BIT;
	tag4.album = 3 | IPOD_MARKER_BIT; // 1998 - Brachiale Gewalt

	expectedNames.push_back((char *)"Intro (TV-Promo-Trailer)");
	expectedNames.push_back((char *)"Engel (Speed-Metal-House-Mix)");
	expectedNames.push_back((char *)"Das Modell (Extended Promo Version)");
	expectedNames.push_back((char *)"Kokain (Non-Album-Track)");
	expectedNames.push_back((char *)"Alter Mann (Special Version)");
	expectedNames.push_back((char *)"Wollt Ihr das Bett in Flammen sehen (Bedtime Mix)");
	expectedNames.push_back((char *)"Hallo Hallo (Demo Version von ''Altes Leid'')");
	expectedNames.push_back((char *)"Du riechst so gut (Scall Remix)");
	expectedNames.push_back((char *)"Bck Dich (Massive Hardcore Terror Mix)");
	expectedNames.push_back((char *)"Feuerr„der (Demo ï94)");
	expectedNames.push_back((char *)"Wilder Wein (Demo ï94)");
	expectedNames.push_back((char *)"Rammstein (Kompletter ''Eskimo & Egyp''-Mix)");
	expectedNames.push_back((char *)"Engel (Alien-Space-Informer-Mix)");
	expectedNames.push_back((char *)"Du hast (Brachial-Mix)");
	Query(LTY_GENRE_ARTIST_ALBUM_SONG, tag1, tag2, tag3, tag4, expectedNames);
}

void IPODVTTest::CreateVT()
{ 
    ENTRY_TEST

	int res;
	char *msg = NULL;

    /* Open an in-memory database */
    res = sqlite3_open(":memory:", &mDBHandleIPOD);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Enable loadable modules (DSOs) */
    res = sqlite3_enable_load_extension(mDBHandleIPOD, 1);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Load the fs virtual table. */
    res = sqlite3_load_extension(mDBHandleIPOD, "libVTIPOD.so", "sqlite3_extension_init", &msg);
    if (msg) CPPUNIT_FAIL(msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);
	
	res = sqlite3_exec(mDBHandleIPOD, "create virtual table f using IPODVT", NULL, NULL, &msg);
    if (msg) CPPUNIT_FAIL(msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

void IPODVTTest::QueryView(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, vector<char *> expectedNames)
{
    (void)expectedNames;

    ENTRY_INTERNAL

    char query[1024];
    int res;
    //int ncols;
    unsigned int rowCounter;
    sqlite3_stmt *stmt;
    const char *tail;

    /* setup the first query */
    sprintf(query, "select rowid,0,url,name,0,id,name,id,name,id,name,id,name,0,'' from f "
            "where mountpoint = '%s' AND LTY = %d AND tag1 = %d AND tag2 = %d AND tag3 = %d AND tag4 = %d AND _limit = %d AND _offset = %d;",
            "/dev/usb/hiddev0",
            listType,
            tag1.tag,
            tag2.tag,
            tag3.tag,
            tag4.tag,
            -1,
            0);
#if 0
    printf("Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Query='%s'", query));
#endif

    /* search for files in mount point */
    res = sqlite3_prepare(mDBHandleIPOD, query, (int)strlen_r(query), &stmt, &tail);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Iterate over results */
    /*ncols = */sqlite3_column_count(stmt);
    //CPPUNIT_ASSERT(ncols == 9);

    /* do the first step */
    res = sqlite3_step(stmt);
    //CPPUNIT_ASSERT(res == SQLITE_ROW);

    rowCounter = 0;

    /* loop over all results */
    while(res == SQLITE_ROW)
    {
#if TEST_PRINT // test print

        /* print all columns */
#if 0 // debug
        printf( "ResultView: ID=%d, DeviceID=%d, URL=%s, Title=%s, TrackNumber=%d, GenreID=%p, Genre=%s, "
                "ArtistID=%p, Artist=%s, AlbumID=%p, Album=%s, ComposerID=%p, Composer=%s, TotalPlayTime=%d, "
                "AlbumArt=%s\n",
                sqlite3_column_int  (stmt,  0), // ID
                sqlite3_column_int  (stmt,  1), // DeviceID
                sqlite3_column_text (stmt,  2), // URL
                sqlite3_column_text (stmt,  3), // Title
                sqlite3_column_int  (stmt,  4), // TrackNumber
                sqlite3_column_int  (stmt,  5), // GenreID
                sqlite3_column_text (stmt,  6), // Genre
                sqlite3_column_int  (stmt,  7), // ArtistID
                sqlite3_column_text (stmt,  8), // Artist
                sqlite3_column_int  (stmt,  9), // AlbumID
                sqlite3_column_text (stmt, 10), // Album
                sqlite3_column_int  (stmt, 11), // ComposerID
                sqlite3_column_text (stmt, 12), // Composer
                sqlite3_column_int  (stmt, 13), // TotalPlayTime
                sqlite3_column_text (stmt, 14)  // AlbumArt
                ); // rowid
#else
        ETG_TRACE_USR2(("ResultView: ID=%d, DeviceID=%d, URL=%40s, Title=%40s, TrackNumber=%d, GenreID=%p",
                sqlite3_column_int  (stmt,  0), // ID
                sqlite3_column_int  (stmt,  1), // DeviceID
                (char *)sqlite3_column_text (stmt,  2), // URL
                (char *)sqlite3_column_text (stmt,  3), // Title
                sqlite3_column_int  (stmt,  4), // TrackNumber
                sqlite3_column_int  (stmt,  5)  // GenreID
                ));
        ETG_TRACE_USR2(("ResultView: Genre=%40s, ArtistID=%p, Artist=%40s, AlbumID=%p, Album=%40s",
                (char *)sqlite3_column_text (stmt,  6), // Genre
                sqlite3_column_int  (stmt,  7), // ArtistID
                (char *)sqlite3_column_text (stmt,  8), // Artist
                sqlite3_column_int  (stmt,  9), // AlbumID
                (char *)sqlite3_column_text (stmt, 10)  // Album
                ));
        ETG_TRACE_USR2(("ResultView: ComposerID=%p, Composer=%40s, TotalPlayTime=%d, AlbumArt=%40s",
                sqlite3_column_int  (stmt, 11), // ComposerID
                (char *)sqlite3_column_text (stmt, 12), // Composer
                sqlite3_column_int  (stmt, 13), // TotalPlayTime
                (char *)sqlite3_column_text (stmt, 14)  // AlbumArt
                ));
#endif
#endif
#if 0
        /* compare result with expectations */
        if (rowCounter < expectedNames.size()) {
            CPPUNIT_ASSERT((unsigned int)sqlite3_column_int (stmt,  4) == expectedNames.size()); // check the size column
            CPPUNIT_ASSERT(strcmp((char *)sqlite3_column_text(stmt,  6), expectedNames[rowCounter]) == 0); // check the name
        } else {
            CPPUNIT_ASSERT(rowCounter < expectedNames.size()); // check number of expected items against number of read ones
        }
#endif
        /* next row */
        res = sqlite3_step(stmt);
        rowCounter++;
    }

    //CPPUNIT_ASSERT(rowCounter == expectedNames.size()); // check number of expected items against number of read ones

    /* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    //CPPUNIT_ASSERT(res == SQLITE_OK);
}

void IPODVTTest::GetViaView()
{ 
    ENTRY_TEST

    vector<char *> expectedNames;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.genre = 4 | IPOD_MARKER_BIT; // Neue Deutsche Härte
    tag2.artist = 2 | IPOD_MARKER_BIT; // Rammstein
    tag3.tag = 0 | IPOD_MARKER_BIT;
    tag4.tag = 0 | IPOD_MARKER_BIT;

    expectedNames.push_back((char *)"1997 - Herzeild");
    expectedNames.push_back((char *)"1997 - Sehnsucht");
    expectedNames.push_back((char *)"1998 - Brachiale Gewalt");
    expectedNames.push_back((char *)"1999 - Live Aus Berlin");
    expectedNames.push_back((char *)"2001 - Mutter");
    expectedNames.push_back((char *)"2002 - Der Musikalische Staub");
    expectedNames.push_back((char *)"Maxi Cd");
    QueryView(LTY_GENRE_ARTIST_ALBUM, tag1, tag2, tag3, tag4, expectedNames);
}

void IPODVTTest::GetWithOffsetLimit()
{ 
    ENTRY_TEST

    vector<char *> expectedNames;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.genre = 4 | IPOD_MARKER_BIT; // Neue Deutsche Härte
    tag2.artist = 2 | IPOD_MARKER_BIT; // Rammstein
    tag3.tag = 0 | IPOD_MARKER_BIT;
    tag4.tag = 0 | IPOD_MARKER_BIT;

    expectedNames.push_back((char *)"1999 - Live Aus Berlin");
    expectedNames.push_back((char *)"2001 - Mutter");
    QueryOffsetLimit(LTY_GENRE_ARTIST_ALBUM, tag1, tag2, tag3, tag4, 3, 2, expectedNames);

}

void IPODVTTest::QueryOffsetLimit(tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, int offset, int limit, vector<char *> expectedNames)
{
    ENTRY_INTERNAL

    char query[1024];
    int res;
    int ncols;
    unsigned int rowCounter;
    sqlite3_stmt *stmt;
    const char *tail;

    /* setup the first query */
    sprintf(query, "select LTY, tag1, tag2, tag3, tag4, count, ID, name, url, rowid, uuid from f "
            "where mountpoint = '%s' AND LTY = %d AND tag1 = %d AND tag2 = %d AND tag3 = %d AND tag4 = %d AND _limit=%d AND _offset=%d;",
            "/dev/usb/hiddev0",
            listType,
            tag1.tag,
            tag2.tag,
            tag3.tag,
            tag4.tag,
            limit,
            offset);
#if 0
    printf("Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Query='%s'", query));
#endif

    /* search for files in mount point */
    res = sqlite3_prepare(mDBHandleIPOD, query, (int)strlen_r(query), &stmt, &tail);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt);
    CPPUNIT_ASSERT(ncols == 11);

    /* do the first step */
    res = sqlite3_step(stmt);
    CPPUNIT_ASSERT(res == SQLITE_ROW);

    rowCounter = 0;

    /* loop over all results */
    while(res == SQLITE_ROW)
    {
#if TEST_PRINT // test print

        /* print all other columns */
#if 0
        printf( "Result: LTY=%d, tag1=0x%x, tag2=0x%x, tag3=0x%x, tag4=0x%x, count=%d, ID=0x%x, name='%s', url='%s', rowid=0x%x, uuid=%s\n",
                sqlite3_column_int (stmt,  0), // LTY
                sqlite3_column_int (stmt,  1), // tag1
                sqlite3_column_int (stmt,  2), // tag2
                sqlite3_column_int (stmt,  3), // tag3
                sqlite3_column_int (stmt,  4), // tag4
                sqlite3_column_int (stmt,  5), // count
                sqlite3_column_int (stmt,  6), // ID
                sqlite3_column_text(stmt,  7), // name
                sqlite3_column_text(stmt,  8), // url
                sqlite3_column_int (stmt,  9), // rowid
                sqlite3_column_text(stmt, 10)  // name
                );
#else
        ETG_TRACE_USR2(("Result: LTY=%d, tag1=0x%x, tag2=0x%x, tag3=0x%x, tag4=0x%x, count=%d",
                sqlite3_column_int (stmt,  0), // LTY
                sqlite3_column_int (stmt,  1), // tag1
                sqlite3_column_int (stmt,  2), // tag2
                sqlite3_column_int (stmt,  3), // tag3
                sqlite3_column_int (stmt,  4), // tag4
                sqlite3_column_int (stmt,  5)  // count
                ));
        ETG_TRACE_USR2(("Result: ID=0x%x, name='%40s', url='%40s', rowid=0x%x, uuid=%40s",
                sqlite3_column_int (stmt,  6), // ID
                (char *)sqlite3_column_text(stmt,  7), // name
                (char *)sqlite3_column_text(stmt,  8), // url
                sqlite3_column_int (stmt,  9), // rowid
                (char *)sqlite3_column_text(stmt, 10)  // uuid
                ));
#endif
#endif
#if 1
        /* compare result with expectations */
        if (rowCounter < expectedNames.size()) {
        	char *name = (char *)sqlite3_column_text(stmt,  7);
#if 0
            printf("sqlite3_column_text(stmt, 7)=%s expectedNames[%d]=%s\n", name, rowCounter, expectedNames[rowCounter]);
#else
            ETG_TRACE_USR2(("sqlite3_column_text(stmt, 7)=%40s expectedNames[%d]=%40s", name, rowCounter, expectedNames[rowCounter]));
#endif
        	//fflush(stdout);
            CPPUNIT_ASSERT(strcmp(name, expectedNames[rowCounter]) == 0); // check the name
        } else {
            CPPUNIT_ASSERT(rowCounter < expectedNames.size()); // check number of expected items against number of read ones
        }
#endif
        /* next row */
        res = sqlite3_step(stmt);
        rowCounter++;
    }

    CPPUNIT_ASSERT(rowCounter == expectedNames.size()); // check number of expected items against number of read ones

    /* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

void IPODVTTest::DeleteVT()
{
    ENTRY_TEST

    sqlite3_close(mDBHandleIPOD);
}
