/*
 * FakeTheIPOD.h
 *
 *  Created on: Oct 3, 2012
 *      Author: matthias
 */

#ifndef FAKETHEIPOD_H_
#define FAKETHEIPOD_H_

#include "TypeDefinitions.h"
#include <iostream>
#include <vector>

using namespace std;

typedef char tIPODName[1024];
typedef char tIPODURL[1024];

class FakeTheIPOD {
public:
	FakeTheIPOD()
	{
		// known genres
		mGenres.push_back((char *)"Rock");
		mGenres.push_back((char *)"Pop");
		mGenres.push_back((char *)"Classic");
		mGenres.push_back((char *)"Neue Deutsche Härte");

		// Neue Deutsche Härte Artists
		mNDHArtists.push_back((char *)"Unheilig");
		mNDHArtists.push_back((char *)"Rammstein");
		mNDHArtists.push_back((char *)"Megaherz");

		// all albums of rammstein
		mRammsteinAlbums.push_back((char *)"1997 - Herzeild");
		mRammsteinAlbums.push_back((char *)"1997 - Sehnsucht");
		mRammsteinAlbums.push_back((char *)"1998 - Brachiale Gewalt");
		mRammsteinAlbums.push_back((char *)"1999 - Live Aus Berlin");
		mRammsteinAlbums.push_back((char *)"2001 - Mutter");
		mRammsteinAlbums.push_back((char *)"2002 - Der Musikalische Staub");
		mRammsteinAlbums.push_back((char *)"Maxi Cd");

		// Rammsteins Brachial songs
		mBrachialSongs.push_back((char *)"Intro (TV-Promo-Trailer)");
		mBrachialSongs.push_back((char *)"Engel (Speed-Metal-House-Mix)");
		mBrachialSongs.push_back((char *)"Das Modell (Extended Promo Version)");
		mBrachialSongs.push_back((char *)"Kokain (Non-Album-Track)");
		mBrachialSongs.push_back((char *)"Alter Mann (Special Version)");
		mBrachialSongs.push_back((char *)"Wollt Ihr das Bett in Flammen sehen (Bedtime Mix)");
		mBrachialSongs.push_back((char *)"Hallo Hallo (Demo Version von ''Altes Leid'')");
		mBrachialSongs.push_back((char *)"Du riechst so gut (Scall Remix)");
		mBrachialSongs.push_back((char *)"Bck Dich (Massive Hardcore Terror Mix)");
		mBrachialSongs.push_back((char *)"Feuerr„der (Demo ï94)");
		mBrachialSongs.push_back((char *)"Wilder Wein (Demo ï94)");
		mBrachialSongs.push_back((char *)"Rammstein (Kompletter ''Eskimo & Egyp''-Mix)");
		mBrachialSongs.push_back((char *)"Engel (Alien-Space-Informer-Mix)");
		mBrachialSongs.push_back((char *)"Du hast (Brachial-Mix)");
	};

	void GetDBRecords(int &fakeIPODCount, tIPODName &fakeIPODName, tIPODID &fakeIPODID, tIPODURL fakeIPODURL, tUUID fakeUUID, int &fakeIPODActive,
			tMountPoint IPODMountpoint, tListType listType, tFilterTag1 tag1, tFilterTag2 tag2, tFilterTag3 tag3, tFilterTag4 tag4, int rowID, int limit, int offset)
	{

		/* check the limit */
		if (rowID >= limit && limit != -1) {
			fakeIPODID = 0; // end of this list
			strcpy(fakeIPODName, "");
			return;
		}

		// check the given mountpoint
		if (strcmp(IPODMountpoint, "/dev/usb/hiddev0") != 0) {
			fakeIPODID = 0; // end of this list
			strcpy(fakeIPODName, "");
			return;
		}

		/* set correct rowID for query */
		rowID += offset;

		// CID 10038 (#1 of 1): Incorrect sizeof expression (BAD_SIZEOF)
		// CID 17219 (#1 of 1): Wrong sizeof argument (SIZEOF_MISMATCH)
		snprintf(fakeUUID, sizeof(tUUID), "fake-uuid-%x-", rowID);

		// for test: take the row id as active flag
		fakeIPODActive = rowID;

		switch(listType)
		{
		case LTY_GENRE:
			fakeIPODCount = mGenres.size();
			if ((unsigned int)rowID >= mGenres.size()) {
				fakeIPODID = 0; // end of this list
				strcpy(fakeIPODName, "");
				return;
			}
			fakeIPODID = rowID + 1; // the ipod id is non zero
			strcpy(fakeIPODName, mGenres[rowID]);
			strcpy(fakeIPODURL, "/");
			strcat(fakeIPODURL, fakeIPODName);
			return;
			break;
		case LTY_GENRE_ARTIST:
			switch(tag1.genre)
			{
			case 4: // Neue Deutsche Härte
				fakeIPODCount = mNDHArtists.size();
				if ((unsigned int)rowID >= mNDHArtists.size()) {
					fakeIPODID = 0; // end of this list
					strcpy(fakeIPODName, "");
					return;
				}
				fakeIPODID = rowID + 1; // the ipod id is non zero
				strcpy(fakeIPODName, mNDHArtists[rowID]);
				strcpy(fakeIPODURL, "/GENRE/");
				strcat(fakeIPODURL, fakeIPODName);
				return;
				break;
			default:
				fakeIPODID = 0; // end of this list
				strcpy(fakeIPODName, "");
				break;
			}
			break;
        case LTY_CURRENT_SELECTION:
        case LTY_ARTIST_SONG:
        case LTY_SONG:
        case LTY_SONG_COUNT:
            fakeIPODCount = mBrachialSongs.size();
            if ((unsigned int)rowID >= mBrachialSongs.size()) {
                fakeIPODID = 0; // end of this list
                strcpy(fakeIPODName, "");
                return;
            }
            fakeIPODID = rowID + 1; // the ipod id is non zero
            strcpy(fakeIPODName, mBrachialSongs[rowID]);
			strcpy(fakeIPODURL, "/GENRE/ARTIST/");
			strcat(fakeIPODURL, fakeIPODName);
            return;
            break;
        case LTY_ARTIST:
        case LTY_ARTIST_COUNT:
            fakeIPODCount = mNDHArtists.size();
            if ((unsigned int) rowID >= mNDHArtists.size()) {
                fakeIPODID = 0; // end of this list
                strcpy(fakeIPODName, "");
                return;
            }
            fakeIPODID = rowID + 1; // the ipod id is non zero
            strcpy(fakeIPODName, mNDHArtists[rowID]);
			strcpy(fakeIPODURL, "/UNKNOWN/ARTIST/");
			strcat(fakeIPODURL, fakeIPODName);
            return;
            break;
        case LTY_ARTIST_SONG_COUNT:
            fakeIPODCount = mNDHArtists.size();
            break;
		case LTY_GENRE_ARTIST_ALBUM:
			switch(tag1.genre) {
			case 4: // Neue Deutsche Härte
				switch(tag2.artist) {
				case 2: // Rammstein
					fakeIPODCount = mRammsteinAlbums.size();
					if ((unsigned int)rowID >= mRammsteinAlbums.size()) {
						fakeIPODID = 0; // end of this list
						strcpy(fakeIPODName, "");
						return;
					}
					fakeIPODID = rowID + 1; // the ipod id is non zero
					strcpy(fakeIPODName, mRammsteinAlbums[rowID]);
					strcpy(fakeIPODURL, "/GENRE/ARTIST/");
					strcat(fakeIPODURL, fakeIPODName);
					return;
					break;
				default:
					fakeIPODID = 0; // end of this list
					strcpy(fakeIPODName, "");
					break;
				}
				break;
			default:
				fakeIPODID = 0; // end of this list
				strcpy(fakeIPODName, "");
				break;
			}
			break;
		case LTY_GENRE_ARTIST_ALBUM_SONG:
			switch(tag1.genre) {
			case 4: // Neue Deutsche Härte
				switch(tag2.artist) {
				case 2: // Rammstein
					switch(tag4.album) {
					case 3: // Brachiale Gewalt
						fakeIPODCount = mBrachialSongs.size();
						if ((unsigned int)rowID >= mBrachialSongs.size()) {
							fakeIPODID = 0; // end of this list
							strcpy(fakeIPODName, "");
							return;
						}
						fakeIPODID = rowID + 1; // the ipod id is non zero
						strcpy(fakeIPODName, mBrachialSongs[rowID]);
						strcpy(fakeIPODURL, "/GENRE/ARTIST/ALBUM/");
						strcat(fakeIPODURL, fakeIPODName);
						return;
						break;
					default:
						fakeIPODID = 0; // end of this list
						strcpy(fakeIPODName, "");
						break;
					}
					break;
				default:
					fakeIPODID = 0; // end of this list
					strcpy(fakeIPODName, "");
					break;
				}
			}
			break;
		default:
			fakeIPODID = 0; // end of this list
			strcpy(fakeIPODName, "");
			break;
		}

		return;
	};

private:
	vector<char *> mGenres;
	vector<char *> mNDHArtists;
	vector<char *> mRammsteinAlbums;
	vector<char *> mBrachialSongs;
};


#endif /* FAKETHEIPOD_H_ */
