#ifndef _FileSystemVTTest_H_
#define _FileSystemVTTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include <sqlite3.h>
#include <vector>

class FileSystemVTTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( FileSystemVTTest );
    //CPPUNIT_TEST( OpenDir_ReadDir_Performance );
    CPPUNIT_TEST( CreateVT );
    CPPUNIT_TEST( OpenWrongDir );
	CPPUNIT_TEST( QueryFirstLevel );
	CPPUNIT_TEST( QuerySecondLevel );
	CPPUNIT_TEST( QuerySecondLevelVideo );
	CPPUNIT_TEST( QueryThirdLevel );
	CPPUNIT_TEST( QueryThirdLevel2 );
	CPPUNIT_TEST( QueryThirdLevel2WOUnknown );
	CPPUNIT_TEST( QueryPlaylistM3U );
	CPPUNIT_TEST( QueryIncludeSubFolder );

    CPPUNIT_TEST( QueryPlaylistConcatenated );
    CPPUNIT_TEST( QueryPlaylistM3UExt );
    CPPUNIT_TEST( QueryPlaylistASX );
    CPPUNIT_TEST( QueryPlaylistPLS );
    CPPUNIT_TEST( QueryPlaylistWPL );
    CPPUNIT_TEST( QueryPlaylistXSPF );
    CPPUNIT_TEST( QueryPlaylistB4S );

    //CPPUNIT_TEST( VTCacheTest ); // development test to analyse cache usage within VTFile
    CPPUNIT_TEST( DeleteVT );
    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    int Query(char *deviceMountPoint, char *path, char *comparePath, int flags, vector<char *> expectedNames, vector<int> expectedTypes, int doAssert = 1 , int includeSubFolder=0);
    void QueryCount(char *deviceMountPoint, char *path, int countDirectories, int countMediaObjects, int countPlaylists,int includeSubFolder=0);

    /*test cases*/	
	void CreateVT();
	void QueryFirstLevel();
	void QuerySecondLevel();
	void QuerySecondLevelVideo();
	void QueryThirdLevel();
	void QueryThirdLevel2();
	void QueryThirdLevel2WOUnknown();
	void QueryPlaylistM3U();
	void QueryPlaylistM3UExt();
	void QueryPlaylistASX();
	void QueryPlaylistPLS();
	void QueryPlaylistWPL();
	void QueryPlaylistXSPF();
	void QueryPlaylistB4S();
	void QueryIncludeSubFolder();

	void QueryPlaylistConcatenated();
	void OpenDir_ReadDir_Performance();
	void OpenWrongDir();
	void VTCacheTest();
	void DeleteVT();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};

#endif  // _FileSystemVTTest_H_
