/*lint -save -e1773 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CDDAVTTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <stdlib.h>
#include <errno.h>
#include <memory.h>
#include <sqlite3.h>
#include <fcntl.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include <vector>

using namespace std;

#include "CDDAVTTest.h"
#include "TypeDefinitions.h"
#include <FunctionTracer.h>

static sqlite3 *mDBHandle;					// data base handle for all tests
static char mountPoint[1024];				// common mountpoint for all tests

void CDDAVTTest::setUp()
{
	pthread_mutex_init(&mutex,NULL);
	pthread_cond_init(&condition,NULL);
	ticks.begin();

	//todo: only for ubuntu tests with real Audion CD

	// intern cd rom drive connected to ubuntu
	//strncpy_r(mountPoint, "/dev/sr0", sizeof(mountPoint));

	// extern usb drive connected to ubuntu virtual box:
	strncpy_r(mountPoint, "/dev/sr2", sizeof(mountPoint));
}

void CDDAVTTest::tearDown()
{
	ticks.elapsed();
	pthread_mutex_destroy(&mutex);
	pthread_cond_destroy(&condition);
}

enum {
	SORT = 0,
	DONT_SORT = 1,
	ALL = 2,
	WO_UNKNOWN = 4
};

#define TEST_PRINT 0

/**********************************************************************
 * Test cases
 *********************************************************************/

int CDDAVTTest::Query(char *deviceMountPoint, char *path, int flags, vector<char *> expectedFileNames, vector<char *> expectedTitles, int doAssert)
{
    ENTRY_INTERNAL

    char query[1024];
	int res;
	int ncols;
	unsigned int rowCounter;
    sqlite3_stmt *stmt;	
	const char *tail;

	/* setup the first query */
	sprintf(query, "select mountpoint,path,filename,itemid,type,format,metadata1,metadata2,metadata3,metadata4,playtime from f where mountpoint match '%s' and path match '%s';",
	        deviceMountPoint, path);
#if 0
	printf("Query='%s'\n", query);
#else
    ETG_TRACE_USR2(("Query='%s'", query));
#endif
	
	/* search for files in mount point */
    res = sqlite3_prepare(mDBHandle, query, (int)strlen_r(query), &stmt, &tail);
    if (doAssert) CPPUNIT_ASSERT(res == SQLITE_OK);
    else if (res) return res;

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt); 
    if (doAssert) CPPUNIT_ASSERT(ncols == 11);

    /* do the first step */
    res = sqlite3_step(stmt);
    if (doAssert) CPPUNIT_ASSERT(res == SQLITE_ROW);
    else if (res != SQLITE_ROW) return res;

    rowCounter = 0;

	/* loop over all results */
    while(res == SQLITE_ROW)
    {
#if 1 // test print
        ETG_TRACE_USR2(("(char *)sqlite3_column_text(stmt, 0)=%s", (char *)sqlite3_column_text(stmt, 0)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_text(stmt, 1)=%s", (char *)sqlite3_column_text(stmt, 1)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_text(stmt, 2)=%s", (char *)sqlite3_column_text(stmt, 2)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_text(stmt, 8)=%s", (char *)sqlite3_column_text(stmt, 8)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_int(stmt, 3)=%d", (int)sqlite3_column_int(stmt, 3)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_int(stmt, 4)=%d", (int)sqlite3_column_int(stmt, 4)));
        ETG_TRACE_USR2(("(char *)sqlite3_column_int(stmt, 5)=%d", (int)sqlite3_column_int(stmt, 5)));
#endif
#if 1
		/* compare result with expectations */
		if (rowCounter < expectedFileNames.size()) {


		    if (doAssert) CPPUNIT_ASSERT(strcmp((char *)sqlite3_column_text(stmt,  0), deviceMountPoint) == 0); // check the mountpoint
		    if (doAssert) CPPUNIT_ASSERT(strcmp((char *)sqlite3_column_text(stmt,  2), expectedFileNames[rowCounter]) == 0); // check the name
		    if (doAssert) CPPUNIT_ASSERT(sqlite3_column_int(stmt, 3) == (int)rowCounter+1); // check the item id
		    if (doAssert) CPPUNIT_ASSERT(strcmp((char *)sqlite3_column_text(stmt,  8), expectedTitles[rowCounter]) == 0); // check the title
		} else {
		    if (doAssert) CPPUNIT_ASSERT(rowCounter < expectedFileNames.size()); // check number of expected items against number of read ones
		}
#endif
		/* next row */
        res = sqlite3_step(stmt);
        rowCounter++;
    }
    if (doAssert) CPPUNIT_ASSERT(rowCounter == expectedFileNames.size()); // check number of expected items against number of read ones

	/* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    if (doAssert) CPPUNIT_ASSERT(res == SQLITE_OK);
    else if (res) return res;

    return 0;
}

void CDDAVTTest::QueryCount(char *deviceMountPoint, char *path, int countMediaObjects)
{
    ENTRY_INTERNAL

    char query[1024];
	int res;
	int ncols;
    sqlite3_stmt *stmt;
	const char *tail;
	int mediaObjectCount = 0;
	int testedMediaObjects = 0;

	sprintf(query, "select type,COUNT(rowid) from f where mountpoint match '%s' AND path match '%s' ;", deviceMountPoint, path);

#if 0
    printf("query: '%s'\n", query);
#else
    ETG_TRACE_USR2(("query: '%s'", query));
#endif

	/* search for files in mount point */
    res = sqlite3_prepare(mDBHandle, query, (int)strlen_r(query), &stmt, &tail);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Iterate over results */
    ncols = sqlite3_column_count(stmt);
    CPPUNIT_ASSERT(ncols == 2);

    /* do the first step */
    res = sqlite3_step(stmt);
    CPPUNIT_ASSERT(res == SQLITE_ROW);

	/* loop over all results */
    while(res == SQLITE_ROW)
    {

#if 0
        printf("type=%d, count=%d\n", sqlite3_column_int(stmt, 0), sqlite3_column_int(stmt, 1));
#else
        ETG_TRACE_USR2(("type=%d, count=%d", sqlite3_column_int(stmt, 0), sqlite3_column_int(stmt, 1)));
#endif
#if 1
		/* compare after type id */
        mediaObjectCount += sqlite3_column_int (stmt, 1);
#endif
		/* next row */
		res = sqlite3_step(stmt);
	}

    // if media object count, check it
    if (mediaObjectCount) {
		CPPUNIT_ASSERT(mediaObjectCount == countMediaObjects); // check the count
		testedMediaObjects = 1;
    }

    /* check all non tested */
    if (!testedMediaObjects) CPPUNIT_ASSERT(countMediaObjects == 0);

	/* finalize the sql statement */
    res = sqlite3_finalize(stmt);
    CPPUNIT_ASSERT(res == SQLITE_OK);
}

void CDDAVTTest::QueryFirstLevel()
{
    ENTRY_TEST
 
    char path[1024];
	vector<char *> expectedNames;
	vector<char *> expectedTitles;

	/* set the path name */
	strcpy(path, "");

    /* set the expected file names */
    expectedNames.push_back((char *)"file1.cda");
    expectedNames.push_back((char *)"file2.cda");
    expectedNames.push_back((char *)"file3.cda");
    expectedNames.push_back((char *)"file4.cda");
    expectedNames.push_back((char *)"file5.cda");
    expectedNames.push_back((char *)"file6.cda");
    expectedNames.push_back((char *)"file7.cda");
    expectedNames.push_back((char *)"file8.cda");
    expectedNames.push_back((char *)"file9.cda");

    expectedTitles.push_back((char *)   "Frontera / Trigger"    );
    expectedTitles.push_back((char *)   "Epic"  );
    expectedTitles.push_back((char *)   "The News About William"    );
    expectedTitles.push_back((char *)   "Black Heart"   );
    expectedTitles.push_back((char *)   "Minas De Cobre"    );
    expectedTitles.push_back((char *)   "Inspiration"   );
    expectedTitles.push_back((char *)   "Two Silver Trees"  );
    expectedTitles.push_back((char *)   "Para"  );
    expectedTitles.push_back((char *)   "Quattro"   );

    /* do a count query */
    QueryCount(mountPoint, path, 9);

    /* do the query */
    Query(mountPoint, path, SORT, expectedNames, expectedTitles, 1);
}

void CDDAVTTest::CreateVT()
{
    ENTRY_TEST
 
    int res;
    char *msg = NULL;

    /* Open an in-memory database */
    res = sqlite3_open(":memory:", &mDBHandle);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Enable loadable modules (DSOs) */
    res = sqlite3_enable_load_extension(mDBHandle, 1);
    CPPUNIT_ASSERT(res == SQLITE_OK);

    /* Load the fs virtual table. */
    res = sqlite3_load_extension(mDBHandle, "libVTCDDA.so", "sqlite3_extension_init", &msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);
    if (msg) CPPUNIT_FAIL(msg);

    res = sqlite3_exec(mDBHandle, "create virtual table f using CDDAVT", NULL, NULL, &msg);
    CPPUNIT_ASSERT(res == SQLITE_OK);
    if (msg) CPPUNIT_FAIL(msg);

    /* create the mount point name */
#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strcpy(mountPoint, pwd);
    strcat(mountPoint, "/Customer/Simulation/CustomControl/test");
    free(pwd);
#else
    strcpy(mountPoint, "/opt/bosch/test/data/GMP/test");
#endif
}

void CDDAVTTest::DeleteVT()
{
    ENTRY_TEST
 
    sqlite3_close(mDBHandle);
}
