/*******************************************************************************
*
* FILE:          sortlib_table.c
*
* SW-COMPONENT:  Sorting Lib
*
* PROJECT:       Bosch-GM-NextGen
*
* DESCRIPTION:   Sorting Lib for Sqlite
*
* AUTHOR:        Nishant Parashar
*
* COPYRIGHT:     (c) 2011 MontaVista Software LLC
*
*******************************************************************************/

/*******************************************************************************
* 		        INCLUDES
*******************************************************************************/

/*******************************************************************************
* 		        DEFINES
*******************************************************************************/

#include "sortlib_helper.h"


#pragma GCC push_options
#pragma GCC optimize ("O0")

//This function would be updated as new data is made available
void sortlib_initialize_sort_table( unsigned sortTable[] )
{
  unsigned i = 0;

  for ( i = 0; i < SORTLIB_ARRAY_SIZE; ++i )
  {
    sortTable[i] = SORTLIB_DEFAULT_TABLE_VALUE;
  }

   //Bosch Golden Sorting Table
   sortTable[0x0020]=0;   // SPACE
   sortTable[0x00A0]=0;   // NO-BREAK SPACE
   sortTable[0x0021]=2;   // EXCLAMATION MARK
   sortTable[0x0022]=3;   // QUOTATION MARK
   sortTable[0x0023]=4;   // NUMBER SIGN
   sortTable[0x0025]=5;   // PERCENT SIGN
   sortTable[0x0026]=6;   // AMPERSAND
   sortTable[0x0027]=7;   // APOSTROPHE
   sortTable[0x0028]=8;   // LEFT PARENTHESIS
   sortTable[0x0029]=9;   // RIGHT PARENTHESIS
   sortTable[0x002A]=10;   // ASTERISK
   sortTable[0x002B]=11;   // PLUS SIGN
   sortTable[0x002C]=12;   // COMMA
   sortTable[0x002D]=13;   // HYPHEN-MINUS
   sortTable[0x002E]=14;   // FULL STOP
   sortTable[0x002F]=15;   // SOLIDUS
   sortTable[0x003A]=16;   // COLON
   sortTable[0x003B]=17;   // SEMICOLON
   sortTable[0x003C]=18;   // LESS-THAN SIGN
   sortTable[0x003D]=19;   // EQUALS SIGN
   sortTable[0x003E]=20;   // GREATER-THAN SIGN
   sortTable[0x003F]=21;   // QUESTION MARK
   sortTable[0x0040]=22;   // COMMERCIAL AT
   sortTable[0x005B]=23;   // LEFT SQUARE BRACKET
   sortTable[0x005C]=24;   // REVERSE SOLIDUS
   sortTable[0x005D]=25;   // RIGHT SQUARE BRACKET
   sortTable[0x005E]=26;   // CIRCUMFLEX ACCENT
   sortTable[0x005F]=27;   // LOW LINE
   sortTable[0x007B]=28;   // LEFT CURLY BRACKET
   sortTable[0x007C]=29;   // VERTICAL LINE
   sortTable[0x007D]=30;   // RIGHT CURLY BRACKET
   sortTable[0x007E]=31;   // TILDE
   sortTable[0x00A1]=32;   // INVERTED EXCLAMATION MARK
   sortTable[0x00A7]=33;   // SECTION SIGN
   sortTable[0x00BF]=34;   // INVERTED QUESTION MARK
   sortTable[0x0024]=35;   // DOLLAR SIGN
   sortTable[0x00A2]=36;   // CENT SIGN
   sortTable[0x00A3]=37;   // POUND SIGN
   sortTable[0x00A4]=38;   // CURRENCY SIGN
   sortTable[0x00A5]=39;   // YEN SIGN
   sortTable[0x20AC]=40;   // EURO SIGN
   sortTable[0x00A6]=41;   // BROKEN BAR
   sortTable[0x00A8]=42;   // DIAERESIS
   sortTable[0x00A9]=43;   // COPYRIGHT SIGN
   sortTable[0x00AA]=44;   // FEMININE ORDINAL INDICATOR
   sortTable[0x00AB]=45;   // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
   sortTable[0x00AC]=46;   // NOT SIGN
   sortTable[0x00AD]=47;   // SOFT HYPHEN
   sortTable[0x00AE]=48;   // REGISTERED SIGN
   sortTable[0x00AF]=49;   // MACRON
   sortTable[0x00B0]=50;   // DEGREE SIGN
   sortTable[0x00B1]=51;   // PLUS-MINUS SIGN
   sortTable[0x00B2]=52;   // SUPERSCRIPT TWO
   sortTable[0x00B3]=53;   // SUPERSCRIPT THREE
   sortTable[0x00B4]=54;   // ACUTE ACCENT
   sortTable[0x00B5]=55;   // MICRO SIGN
   sortTable[0x00B6]=56;   // PILCROW SIGN
   sortTable[0x00B7]=57;   // MIDDLE DOT
   sortTable[0x00B8]=58;   // CEDILLA
   sortTable[0x00B9]=59;   // SUPERSCRIPT ONE
   sortTable[0x00BA]=60;   // MASCULINE ORDINAL INDICATOR
   sortTable[0x00BB]=61;   // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
   sortTable[0x00BC]=62;   // VULGAR FRACTION ONE QUARTER
   sortTable[0x00BD]=63;   // VULGAR FRACTION ONE HALF
   sortTable[0x00BE]=64;   // VULGAR FRACTION THREE QUARTERS
   sortTable[0x00D7]=65;   // MULTIPLICATION SIGN
   sortTable[0x00F7]=66;   // DIVISION SIGN
   sortTable[0x0030]=67;   // DIGIT ZERO
   sortTable[0x0031]=68;   // DIGIT ONE
   sortTable[0x0032]=69;   // DIGIT TWO
   sortTable[0x0033]=70;   // DIGIT THREE
   sortTable[0x0034]=71;   // DIGIT FOUR
   sortTable[0x0035]=72;   // DIGIT FIVE
   sortTable[0x0036]=73;   // DIGIT SIX
   sortTable[0x0037]=74;   // DIGIT SEVEN
   sortTable[0x0038]=75;   // DIGIT EIGHT
   sortTable[0x0039]=76;   // DIGIT NINE
   sortTable[0x0061]=256;   // LATIN SMALL LETTER A
   sortTable[0x0041]=257;   // LATIN CAPITAL LETTER A
   sortTable[0x00E1]=258;   // LATIN SMALL LETTER A WITH ACUTE
   sortTable[0x00C1]=259;   // LATIN CAPITAL LETTER A WITH ACUTE
   sortTable[0x00E0]=260;   // LATIN SMALL LETTER A WITH GRAVE
   sortTable[0x00C0]=261;   // LATIN CAPITAL LETTER A WITH GRAVE
   sortTable[0x0103]=262;   // LATIN SMALL LETTER A WITH BREVE
   sortTable[0x0102]=263;   // LATIN CAPITAL LETTER A WITH BREVE
   sortTable[0x00E2]=264;   // LATIN SMALL LETTER A WITH CIRCUMFLEX
   sortTable[0x00C2]=265;   // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
   sortTable[0x01CE]=266;   // LATIN SMALL LETTER A WITH CARON
   sortTable[0x01CD]=267;   // LATIN CAPITAL LETTER A WITH CARON
   sortTable[0x00E5]=268;   // LATIN SMALL LETTER A WITH RING ABOVE
   sortTable[0x00C5]=269;   // LATIN CAPITAL LETTER A WITH RING ABOVE
   sortTable[0x00E4]=270;   // LATIN SMALL LETTER A WITH DIAERESIS
   sortTable[0x00C4]=271;   // LATIN CAPITAL LETTER A WITH DIAERESIS
   sortTable[0x00E3]=272;   // LATIN SMALL LETTER A WITH TILDE
   sortTable[0x00C3]=273;   // LATIN CAPITAL LETTER A WITH TILDE
   sortTable[0x0105]=274;   // LATIN SMALL LETTER A WITH OGONEK
   sortTable[0x0104]=275;   // LATIN CAPITAL LETTER A WITH OGONEK
   sortTable[0x0101]=276;   // LATIN SMALL LETTER A WITH MACRON
   sortTable[0x0100]=277;   // LATIN CAPITAL LETTER A WITH MACRON
   sortTable[0x00E6]=278;   // LATIN SMALL LETTER AE
   sortTable[0x00C6]=279;   // LATIN CAPITAL LETTER AE
   sortTable[0x0062]=768;   // LATIN SMALL LETTER B
   sortTable[0x0042]=769;   // LATIN CAPITAL LETTER B
   sortTable[0x0063]=2048;   // LATIN SMALL LETTER C
   sortTable[0x0043]=2049;   // LATIN CAPITAL LETTER C
   sortTable[0x0107]=2050;   // LATIN SMALL LETTER C WITH ACUTE
   sortTable[0x0106]=2051;   // LATIN CAPITAL LETTER C WITH ACUTE
   sortTable[0x0109]=2052;   // LATIN SMALL LETTER C WITH CIRCUMFLEX
   sortTable[0x0108]=2053;   // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
   sortTable[0x010D]=2054;   // LATIN SMALL LETTER C WITH CARON
   sortTable[0x010C]=2055;   // LATIN CAPITAL LETTER C WITH CARON
   sortTable[0x010B]=2056;   // LATIN SMALL LETTER C WITH DOT ABOVE
   sortTable[0x010A]=2057;   // LATIN CAPITAL LETTER C WITH DOT ABOVE
   sortTable[0x00E7]=2058;   // LATIN SMALL LETTER C WITH CEDILLA
   sortTable[0x00C7]=2059;   // LATIN CAPITAL LETTER C WITH CEDILLA
   sortTable[0x0064]=3840;   // LATIN SMALL LETTER D
   sortTable[0x0044]=3841;   // LATIN CAPITAL LETTER D
   sortTable[0x010F]=3842;   // LATIN SMALL LETTER D WITH CARON
   sortTable[0x010E]=3843;   // LATIN CAPITAL LETTER D WITH CARON
   sortTable[0x0111]=3844;   // LATIN SMALL LETTER D WITH STROKE
   sortTable[0x0110]=3845;   // LATIN CAPITAL LETTER D WITH STROKE
   sortTable[0x00F0]=3846;   // LATIN SMALL LETTER ETH
   sortTable[0x00D0]=3847;   // LATIN CAPITAL LETTER ETH
   sortTable[0x0065]=5120;   // LATIN SMALL LETTER E
   sortTable[0x0045]=5121;   // LATIN CAPITAL LETTER E
   sortTable[0x00E9]=5122;   // LATIN SMALL LETTER E WITH ACUTE
   sortTable[0x00C9]=5123;   // LATIN CAPITAL LETTER E WITH ACUTE
   sortTable[0x00E8]=5124;   // LATIN SMALL LETTER E WITH GRAVE
   sortTable[0x00C8]=5125;   // LATIN CAPITAL LETTER E WITH GRAVE
   sortTable[0x00EA]=5126;   // LATIN SMALL LETTER E WITH CIRCUMFLEX
   sortTable[0x00CA]=5127;   // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
   sortTable[0x011B]=5128;   // LATIN SMALL LETTER E WITH CARON
   sortTable[0x011A]=5129;   // LATIN CAPITAL LETTER E WITH CARON
   sortTable[0x00EB]=5130;   // LATIN SMALL LETTER E WITH DIAERESIS
   sortTable[0x00CB]=5131;   // LATIN CAPITAL LETTER E WITH DIAERESIS
   sortTable[0x0117]=5132;   // LATIN SMALL LETTER E WITH DOT ABOVE
   sortTable[0x0116]=5133;   // LATIN CAPITAL LETTER E WITH DOT ABOVE
   sortTable[0x0119]=5134;   // LATIN SMALL LETTER E WITH OGONEK
   sortTable[0x0118]=5135;   // LATIN CAPITAL LETTER E WITH OGONEK
   sortTable[0x0113]=5136;   // LATIN SMALL LETTER E WITH MACRON
   sortTable[0x0112]=5137;   // LATIN CAPITAL LETTER E WITH MACRON
   sortTable[0x0259]=5138;   // LATIN SMALL LETTER SCHWA
   sortTable[0x018F]=5139;   // LATIN CAPITAL LETTER SCHWA
   sortTable[0x0066]=5632;   // LATIN SMALL LETTER F
   sortTable[0x0046]=5633;   // LATIN CAPITAL LETTER F
   sortTable[0x0192]=5634;   // LATIN SMALL LETTER F WITH HOOK
   sortTable[0x0191]=5635;   // LATIN CAPITAL LETTER F WITH HOOK
   sortTable[0x0067]=6656;   // LATIN SMALL LETTER G
   sortTable[0x0047]=6657;   // LATIN CAPITAL LETTER G
   sortTable[0x011F]=6658;   // LATIN SMALL LETTER G WITH BREVE
   sortTable[0x011E]=6659;   // LATIN CAPITAL LETTER G WITH BREVE
   sortTable[0x011D]=6660;   // LATIN SMALL LETTER G WITH CIRCUMFLEX
   sortTable[0x011C]=6661;   // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
   sortTable[0x01E7]=6662;   // LATIN SMALL LETTER G WITH CARON
   sortTable[0x01E6]=6663;   // LATIN CAPITAL LETTER G WITH CARON
   sortTable[0x0121]=6664;   // LATIN SMALL LETTER G WITH DOT ABOVE
   sortTable[0x0120]=6665;   // LATIN CAPITAL LETTER G WITH DOT ABOVE
   sortTable[0x0123]=6666;   // LATIN SMALL LETTER G WITH CEDILLA
   sortTable[0x0122]=6667;   // LATIN CAPITAL LETTER G WITH CEDILLA
   sortTable[0x01E5]=6668;   // LATIN SMALL LETTER G WITH STROKE
   sortTable[0x01E4]=6669;   // LATIN CAPITAL LETTER G WITH STROKE
   sortTable[0x0068]=7936;   // LATIN SMALL LETTER H
   sortTable[0x0048]=7937;   // LATIN CAPITAL LETTER H
   sortTable[0x0125]=7938;   // LATIN SMALL LETTER H WITH CIRCUMFLEX
   sortTable[0x0124]=7939;   // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
   sortTable[0x0127]=7940;   // LATIN SMALL LETTER H WITH STROKE
   sortTable[0x0126]=7941;   // LATIN CAPITAL LETTER H WITH STROKE
   sortTable[0x0069]=9472;   // LATIN SMALL LETTER I
   sortTable[0x0049]=9473;   // LATIN CAPITAL LETTER I
   sortTable[0x00ED]=9474;   // LATIN SMALL LETTER I WITH ACUTE
   sortTable[0x00CD]=9475;   // LATIN CAPITAL LETTER I WITH ACUTE
   sortTable[0x00EC]=9476;   // LATIN SMALL LETTER I WITH GRAVE
   sortTable[0x00CC]=9477;   // LATIN CAPITAL LETTER I WITH GRAVE
   sortTable[0x00EE]=9478;   // LATIN SMALL LETTER I WITH CIRCUMFLEX
   sortTable[0x00CE]=9479;   // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
   sortTable[0x01D0]=9480;   // LATIN SMALL LETTER I WITH CARON
   sortTable[0x01CF]=9481;   // LATIN CAPITAL LETTER I WITH CARON
   sortTable[0x00EF]=9482;   // LATIN SMALL LETTER I WITH DIAERESIS
   sortTable[0x00CF]=9483;   // LATIN CAPITAL LETTER I WITH DIAERESIS
   sortTable[0x0130]=9484;   // LATIN CAPITAL LETTER I WITH DOT ABOVE
   sortTable[0x012F]=9485;   // LATIN SMALL LETTER I WITH OGONEK
   sortTable[0x012E]=9486;   // LATIN CAPITAL LETTER I WITH OGONEK
   sortTable[0x012B]=9487;   // LATIN SMALL LETTER I WITH MACRON
   sortTable[0x012A]=9488;   // LATIN CAPITAL LETTER I WITH MACRON
   sortTable[0x0131]=9489;   // LATIN SMALL LETTER DOTLESS I
   sortTable[0x0133]=9490;   // LATIN SMALL LIGATURE IJ
   sortTable[0x0132]=9491;   // LATIN CAPITAL LIGATURE IJ
   sortTable[0x006A]=9728;   // LATIN SMALL LETTER J
   sortTable[0x004A]=9729;   // LATIN CAPITAL LETTER J
   sortTable[0x0135]=9730;   // LATIN SMALL LETTER J WITH CIRCUMFLEX
   sortTable[0x0134]=9731;   // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
   sortTable[0x006B]=11776;   // LATIN SMALL LETTER K
   sortTable[0x004B]=11777;   // LATIN CAPITAL LETTER K
   sortTable[0x01E9]=11778;   // LATIN SMALL LETTER K WITH CARON
   sortTable[0x01E8]=11779;   // LATIN CAPITAL LETTER K WITH CARON
   sortTable[0x0137]=11780;   // LATIN SMALL LETTER K WITH CEDILLA
   sortTable[0x0136]=11781;   // LATIN CAPITAL LETTER K WITH CEDILLA
   sortTable[0x0138]=11782;   // LATIN SMALL LETTER KRA
   sortTable[0x006C]=12800;   // LATIN SMALL LETTER L
   sortTable[0x004C]=12801;   // LATIN CAPITAL LETTER L
   sortTable[0x013A]=12802;   // LATIN SMALL LETTER L WITH ACUTE
   sortTable[0x0139]=12803;   // LATIN CAPITAL LETTER L WITH ACUTE
   sortTable[0x013E]=12804;   // LATIN SMALL LETTER L WITH CARON
   sortTable[0x013D]=12805;   // LATIN CAPITAL LETTER L WITH CARON
   sortTable[0x013C]=12806;   // LATIN SMALL LETTER L WITH CEDILLA
   sortTable[0x013B]=12807;   // LATIN CAPITAL LETTER L WITH CEDILLA
   sortTable[0x0140]=12808;   // LATIN SMALL LETTER L WITH MIDDLE DOT
   sortTable[0x013F]=12809;   // LATIN CAPITAL LETTER L WITH MIDDLE DOT
   sortTable[0x0142]=12810;   // LATIN SMALL LETTER L WITH STROKE
   sortTable[0x0141]=12811;   // LATIN CAPITAL LETTER L WITH STROKE
   sortTable[0x006D]=14848;   // LATIN SMALL LETTER M
   sortTable[0x004D]=14849;   // LATIN CAPITAL LETTER M
   sortTable[0x006E]=16128;   // LATIN SMALL LETTER N
   sortTable[0x004E]=16129;   // LATIN CAPITAL LETTER N
   sortTable[0x0144]=16130;   // LATIN SMALL LETTER N WITH ACUTE
   sortTable[0x0143]=16131;   // LATIN CAPITAL LETTER N WITH ACUTE
   sortTable[0x0148]=16132;   // LATIN SMALL LETTER N WITH CARON
   sortTable[0x0147]=16133;   // LATIN CAPITAL LETTER N WITH CARON
   sortTable[0x00F1]=16134;   // LATIN SMALL LETTER N WITH TILDE
   sortTable[0x00D1]=16135;   // LATIN CAPITAL LETTER N WITH TILDE
   sortTable[0x0146]=16136;   // LATIN SMALL LETTER N WITH CEDILLA
   sortTable[0x0145]=16137;   // LATIN CAPITAL LETTER N WITH CEDILLA
   sortTable[0x0149]=16138;   // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
   sortTable[0x014B]=16139;   // LATIN SMALL LETTER ENG
   sortTable[0x014A]=16140;   // LATIN CAPITAL LETTER ENG
   sortTable[0x006F]=16896;   // LATIN SMALL LETTER O
   sortTable[0x004F]=16897;   // LATIN CAPITAL LETTER O
   sortTable[0x00F3]=16898;   // LATIN SMALL LETTER O WITH ACUTE
   sortTable[0x00D3]=16899;   // LATIN CAPITAL LETTER O WITH ACUTE
   sortTable[0x00F2]=16900;   // LATIN SMALL LETTER O WITH GRAVE
   sortTable[0x00D2]=16901;   // LATIN CAPITAL LETTER O WITH GRAVE
   sortTable[0x00F4]=16902;   // LATIN SMALL LETTER O WITH CIRCUMFLEX
   sortTable[0x00D4]=16903;   // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
   sortTable[0x01D2]=16904;   // LATIN SMALL LETTER O WITH CARON
   sortTable[0x01D1]=16905;   // LATIN CAPITAL LETTER O WITH CARON
   sortTable[0x00F6]=16906;   // LATIN SMALL LETTER O WITH DIAERESIS
   sortTable[0x00D6]=16907;   // LATIN CAPITAL LETTER O WITH DIAERESIS
   sortTable[0x0151]=16908;   // LATIN SMALL LETTER O WITH DOUBLE ACUTE
   sortTable[0x0150]=16909;   // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
   sortTable[0x00F5]=16910;   // LATIN SMALL LETTER O WITH TILDE
   sortTable[0x00D5]=16911;   // LATIN CAPITAL LETTER O WITH TILDE
   sortTable[0x014D]=16912;   // LATIN SMALL LETTER O WITH MACRON
   sortTable[0x014C]=16913;   // LATIN CAPITAL LETTER O WITH MACRON
   sortTable[0x01A1]=16914;   // LATIN SMALL LETTER O WITH HORN
   sortTable[0x01A0]=16915;   // LATIN CAPITAL LETTER O WITH HORN
   sortTable[0x00F8]=16916;   // LATIN SMALL LETTER O WITH STROKE
   sortTable[0x00D8]=16917;   // LATIN CAPITAL LETTER O WITH STROKE
   sortTable[0x0153]=16918;   // LATIN SMALL LIGATURE OE
   sortTable[0x0152]=16919;   // LATIN CAPITAL LIGATURE OE
   sortTable[0x0070]=17408;   // LATIN SMALL LETTER P
   sortTable[0x0050]=17409;   // LATIN CAPITAL LETTER P
   sortTable[0x0071]=18432;   // LATIN SMALL LETTER Q
   sortTable[0x0051]=18433;   // LATIN CAPITAL LETTER Q
   sortTable[0x0072]=19712;   // LATIN SMALL LETTER R
   sortTable[0x0052]=19713;   // LATIN CAPITAL LETTER R
   sortTable[0x0155]=19714;   // LATIN SMALL LETTER R WITH ACUTE
   sortTable[0x0154]=19715;   // LATIN CAPITAL LETTER R WITH ACUTE
   sortTable[0x0159]=19716;   // LATIN SMALL LETTER R WITH CARON
   sortTable[0x0158]=19717;   // LATIN CAPITAL LETTER R WITH CARON
   sortTable[0x0157]=19718;   // LATIN SMALL LETTER R WITH CEDILLA
   sortTable[0x0156]=19719;   // LATIN CAPITAL LETTER R WITH CEDILLA
   sortTable[0x0073]=20480;   // LATIN SMALL LETTER S
   sortTable[0x0053]=20481;   // LATIN CAPITAL LETTER S
   sortTable[0x015B]=20482;   // LATIN SMALL LETTER S WITH ACUTE
   sortTable[0x015A]=20483;   // LATIN CAPITAL LETTER S WITH ACUTE
   sortTable[0x015D]=20484;   // LATIN SMALL LETTER S WITH CIRCUMFLEX
   sortTable[0x015C]=20485;   // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
   sortTable[0x0161]=20486;   // LATIN SMALL LETTER S WITH CARON
   sortTable[0x0160]=20487;   // LATIN CAPITAL LETTER S WITH CARON
   sortTable[0x015F]=20488;   // LATIN SMALL LETTER S WITH CEDILLA
   sortTable[0x015E]=20489;   // LATIN CAPITAL LETTER S WITH CEDILLA
   sortTable[0x0219]=20490;   // LATIN SMALL LETTER S WITH COMMA BELOW
   sortTable[0x0218]=20491;   // LATIN CAPITAL LETTER S WITH COMMA BELOW
   sortTable[0x00DF]=20492;   // LATIN SMALL LETTER SHARP S
   sortTable[0x0074]=22272;   // LATIN SMALL LETTER T
   sortTable[0x0054]=22273;   // LATIN CAPITAL LETTER T
   sortTable[0x0165]=22274;   // LATIN SMALL LETTER T WITH CARON
   sortTable[0x0164]=22275;   // LATIN CAPITAL LETTER T WITH CARON
   sortTable[0x0162]=22276;   // LATIN CAPITAL LETTER T WITH CEDILLA
   sortTable[0x0163]=22277;   // LATIN SMALL LETTER T WITH CEDILLA
   sortTable[0x021B]=22278;   // LATIN SMALL LETTER T WITH COMMA BELOW
   sortTable[0x021A]=22279;   // LATIN CAPITAL LETTER T WITH COMMA BELOW
   sortTable[0x0167]=22280;   // LATIN SMALL LETTER T WITH STROKE
   sortTable[0x0166]=22281;   // LATIN CAPITAL LETTER T WITH STROKE
   sortTable[0x0075]=23552;   // LATIN SMALL LETTER U
   sortTable[0x0055]=23553;   // LATIN CAPITAL LETTER U
   sortTable[0x00FA]=23554;   // LATIN SMALL LETTER U WITH ACUTE
   sortTable[0x00DA]=23555;   // LATIN CAPITAL LETTER U WITH ACUTE
   sortTable[0x00F9]=23556;   // LATIN SMALL LETTER U WITH GRAVE
   sortTable[0x00D9]=23557;   // LATIN CAPITAL LETTER U WITH GRAVE
   sortTable[0x016D]=23558;   // LATIN SMALL LETTER U WITH BREVE
   sortTable[0x016C]=23559;   // LATIN CAPITAL LETTER U WITH BREVE
   sortTable[0x00FB]=23560;   // LATIN SMALL LETTER U WITH CIRCUMFLEX
   sortTable[0x00DB]=23561;   // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
   sortTable[0x01D4]=23562;   // LATIN SMALL LETTER U WITH CARON
   sortTable[0x01D3]=23563;   // LATIN CAPITAL LETTER U WITH CARON
   sortTable[0x016F]=23564;   // LATIN SMALL LETTER U WITH RING ABOVE
   sortTable[0x016E]=23565;   // LATIN CAPITAL LETTER U WITH RING ABOVE
   sortTable[0x00FC]=23566;   // LATIN SMALL LETTER U WITH DIAERESIS
   sortTable[0x00DC]=23567;   // LATIN CAPITAL LETTER U WITH DIAERESIS
   sortTable[0x0171]=23568;   // LATIN SMALL LETTER U WITH DOUBLE ACUTE
   sortTable[0x0170]=23569;   // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
   sortTable[0x0173]=23570;   // LATIN SMALL LETTER U WITH OGONEK
   sortTable[0x0172]=23571;   // LATIN CAPITAL LETTER U WITH OGONEK
   sortTable[0x016B]=23572;   // LATIN SMALL LETTER U WITH MACRON
   sortTable[0x016A]=23573;   // LATIN CAPITAL LETTER U WITH MACRON
   sortTable[0x01B0]=23574;   // LATIN SMALL LETTER U WITH HORN
   sortTable[0x01AF]=23575;   // LATIN CAPITAL LETTER U WITH HORN
   sortTable[0x01D8]=23576;   // LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
   sortTable[0x01D7]=23577;   // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
   sortTable[0x01DC]=23578;   // LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
   sortTable[0x01DB]=23579;   // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
   sortTable[0x01DA]=23580;   // LATIN SMALL LETTER U WITH DIAERESIS AND CARON
   sortTable[0x01D9]=23581;   // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
   sortTable[0x01D6]=23582;   // LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
   sortTable[0x01D5]=23583;   // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
   sortTable[0x0076]=23808;   // LATIN SMALL LETTER V
   sortTable[0x0056]=23809;   // LATIN CAPITAL LETTER V
   sortTable[0x0077]=24064;   // LATIN SMALL LETTER W
   sortTable[0x0057]=24065;   // LATIN CAPITAL LETTER W
   sortTable[0x1E83]=24066;   // LATIN SMALL LETTER W WITH ACUTE
   sortTable[0x1E82]=24067;   // LATIN CAPITAL LETTER W WITH ACUTE
   sortTable[0x1E81]=24068;   // LATIN SMALL LETTER W WITH GRAVE
   sortTable[0x1E80]=24069;   // LATIN CAPITAL LETTER W WITH GRAVE
   sortTable[0x0175]=24070;   // LATIN SMALL LETTER W WITH CIRCUMFLEX
   sortTable[0x0174]=24071;   // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
   sortTable[0x1E85]=24072;   // LATIN SMALL LETTER W WITH DIAERESIS
   sortTable[0x1E84]=24073;   // LATIN CAPITAL LETTER W WITH DIAERESIS
   sortTable[0x0078]=25088;   // LATIN SMALL LETTER X
   sortTable[0x0058]=25089;   // LATIN CAPITAL LETTER X
   sortTable[0x0079]=26880;   // LATIN SMALL LETTER Y
   sortTable[0x0059]=26881;   // LATIN CAPITAL LETTER Y
   sortTable[0x00FD]=26882;   // LATIN SMALL LETTER Y WITH ACUTE
   sortTable[0x00DD]=26883;   // LATIN CAPITAL LETTER Y WITH ACUTE
   sortTable[0x1EF3]=26884;   // LATIN SMALL LETTER Y WITH GRAVE
   sortTable[0x1EF2]=26885;   // LATIN CAPITAL LETTER Y WITH GRAVE
   sortTable[0x0177]=26886;   // LATIN SMALL LETTER Y WITH CIRCUMFLEX
   sortTable[0x0176]=26887;   // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
   sortTable[0x00FF]=26888;   // LATIN SMALL LETTER Y WITH DIAERESIS
   sortTable[0x0178]=26889;   // LATIN CAPITAL LETTER Y WITH DIAERESIS
   sortTable[0x007A]=29184;   // LATIN SMALL LETTER Z
   sortTable[0x005A]=29185;   // LATIN CAPITAL LETTER Z
   sortTable[0x017A]=29186;   // LATIN SMALL LETTER Z WITH ACUTE
   sortTable[0x0179]=29187;   // LATIN CAPITAL LETTER Z WITH ACUTE
   sortTable[0x017E]=29188;   // LATIN SMALL LETTER Z WITH CARON
   sortTable[0x017D]=29189;   // LATIN CAPITAL LETTER Z WITH CARON
   sortTable[0x017C]=29190;   // LATIN SMALL LETTER Z WITH DOT ABOVE
   sortTable[0x017B]=29191;   // LATIN CAPITAL LETTER Z WITH DOT ABOVE
   sortTable[0x0292]=29192;   // LATIN SMALL LETTER EZH
   sortTable[0x01B7]=29193;   // LATIN CAPITAL LETTER EZH
   sortTable[0x01EF]=29194;   // LATIN SMALL LETTER EZH WITH CARON
   sortTable[0x01EE]=29195;   // LATIN CAPITAL LETTER EZH WITH CARON
   sortTable[0x00FE]=29196;   // LATIN SMALL LETTER THORN
   sortTable[0x00DE]=29197;   // LATIN CAPITAL LETTER THORN
   sortTable[0x03B1]=31744;   // GREEK SMALL LETTER ALPHA
   sortTable[0x0391]=31745;   // GREEK CAPITAL LETTER ALPHA
   sortTable[0x03AC]=31746;   // GREEK SMALL LETTER ALPHA WITH TONOS
   sortTable[0x0386]=31747;   // GREEK CAPITAL LETTER ALPHA WITH TONOS
   sortTable[0x03B2]=31748;   // GREEK SMALL LETTER BETA
   sortTable[0x0392]=31749;   // GREEK CAPITAL LETTER BETA
   sortTable[0x03B3]=31750;   // GREEK SMALL LETTER GAMMA
   sortTable[0x0393]=31751;   // GREEK CAPITAL LETTER GAMMA
   sortTable[0x03B4]=31752;   // GREEK SMALL LETTER DELTA
   sortTable[0x0394]=31753;   // GREEK CAPITAL LETTER DELTA
   sortTable[0x03B5]=31754;   // GREEK SMALL LETTER EPSILON
   sortTable[0x0395]=31755;   // GREEK CAPITAL LETTER EPSILON
   sortTable[0x03AD]=31756;   // GREEK SMALL LETTER EPSILON WITH TONOS
   sortTable[0x0388]=31757;   // GREEK CAPITAL LETTER EPSILON WITH TONOS
   sortTable[0x03B6]=31758;   // GREEK SMALL LETTER ZETA
   sortTable[0x0396]=31759;   // GREEK CAPITAL LETTER ZETA
   sortTable[0x03B7]=31760;   // GREEK SMALL LETTER ETA
   sortTable[0x0397]=31761;   // GREEK CAPITAL LETTER ETA
   sortTable[0x03AE]=31762;   // GREEK SMALL LETTER ETA WITH TONOS
   sortTable[0x0389]=31763;   // GREEK CAPITAL LETTER ETA WITH TONOS
   sortTable[0x03B8]=31764;   // GREEK SMALL LETTER THETA
   sortTable[0x0398]=31765;   // GREEK CAPITAL LETTER THETA
   sortTable[0x03B9]=31766;   // GREEK SMALL LETTER IOTA
   sortTable[0x0399]=31767;   // GREEK CAPITAL LETTER IOTA
   sortTable[0x03AF]=31768;   // GREEK SMALL LETTER IOTA WITH TONOS
   sortTable[0x038A]=31769;   // GREEK CAPITAL LETTER IOTA WITH TONOS
   sortTable[0x03CA]=31770;   // GREEK SMALL LETTER IOTA WITH DIALYTICA
   sortTable[0x03AA]=31771;   // GREEK CAPITAL LETTER IOTA WITH DIALYTICA
   sortTable[0x0390]=31772;   // GREEK SMALL LETTER IOTA WITH DIALYTICA AND TONOS
   sortTable[0x03BA]=31773;   // GREEK SMALL LETTER KAPPA
   sortTable[0x039A]=31774;   // GREEK CAPITAL LETTER KAPPA
   sortTable[0x03BB]=31775;   // GREEK SMALL LETTER LAMDA
   sortTable[0x039B]=31776;   // GREEK CAPITAL LETTER LAMDA
   sortTable[0x03BC]=31777;   // GREEK SMALL LETTER MU
   sortTable[0x039C]=31778;   // GREEK CAPITAL LETTER MU
   sortTable[0x03BD]=31779;   // GREEK SMALL LETTER NU
   sortTable[0x039D]=31780;   // GREEK CAPITAL LETTER NU
   sortTable[0x03BE]=31781;   // GREEK SMALL LETTER XI
   sortTable[0x039E]=31782;   // GREEK CAPITAL LETTER XI
   sortTable[0x03BF]=31783;   // GREEK SMALL LETTER OMICRON
   sortTable[0x039F]=31784;   // GREEK CAPITAL LETTER OMICRON
   sortTable[0x03CC]=31785;   // GREEK SMALL LETTER OMICRON WITH TONOS
   sortTable[0x038C]=31786;   // GREEK CAPITAL LETTER OMICRON WITH TONOS
   sortTable[0x03C0]=31787;   // GREEK SMALL LETTER PI
   sortTable[0x03A0]=31788;   // GREEK CAPITAL LETTER PI
   sortTable[0x03C1]=31789;   // GREEK SMALL LETTER RHO
   sortTable[0x03A1]=31790;   // GREEK CAPITAL LETTER RHO
   sortTable[0x03C3]=31791;   // GREEK SMALL LETTER SIGMA
   sortTable[0x03C2]=31792;   // GREEK SMALL LETTER FINAL SIGMA
   sortTable[0x03A3]=31793;   // GREEK CAPITAL LETTER SIGMA
   sortTable[0x03C4]=31794;   // GREEK SMALL LETTER TAU
   sortTable[0x03A4]=31795;   // GREEK CAPITAL LETTER TAU
   sortTable[0x03C5]=31796;   // GREEK SMALL LETTER UPSILON
   sortTable[0x03A5]=31797;   // GREEK CAPITAL LETTER UPSILON
   sortTable[0x03CD]=31798;   // GREEK SMALL LETTER UPSILON WITH TONOS
   sortTable[0x038E]=31799;   // GREEK CAPITAL LETTER UPSILON WITH TONOS
   sortTable[0x03CB]=31800;   // GREEK SMALL LETTER UPSILON WITH DIALYTICA
   sortTable[0x03AB]=31801;   // GREEK CAPITAL LETTER UPSILON WITH DIALYTICA
   sortTable[0x03B0]=31802;   // GREEK SMALL LETTER UPSILON WITH DIALYTICA AND TONOS
   sortTable[0x03C6]=31803;   // GREEK SMALL LETTER PHI
   sortTable[0x03A6]=31804;   // GREEK CAPITAL LETTER PHI
   sortTable[0x03C7]=31805;   // GREEK SMALL LETTER CHI
   sortTable[0x03A7]=31806;   // GREEK CAPITAL LETTER CHI
   sortTable[0x03C8]=31807;   // GREEK SMALL LETTER PSI
   sortTable[0x03A8]=31808;   // GREEK CAPITAL LETTER PSI
   sortTable[0x03C9]=31809;   // GREEK SMALL LETTER OMEGA
   sortTable[0x03A9]=31810;   // GREEK CAPITAL LETTER OMEGA
   sortTable[0x03CE]=31811;   // GREEK SMALL LETTER OMEGA WITH TONOS
   sortTable[0x038F]=31812;   // GREEK CAPITAL LETTER OMEGA WITH TONOS
   sortTable[0x0430]=32000;   // CYRILLIC SMALL LETTER A
   sortTable[0x0410]=32001;   // CYRILLIC CAPITAL LETTER A
   sortTable[0x0431]=32002;   // CYRILLIC SMALL LETTER BE
   sortTable[0x0411]=32003;   // CYRILLIC CAPITAL LETTER BE
   sortTable[0x0432]=32004;   // CYRILLIC SMALL LETTER VE
   sortTable[0x0412]=32005;   // CYRILLIC CAPITAL LETTER VE
   sortTable[0x0433]=32006;   // CYRILLIC SMALL LETTER GHE
   sortTable[0x0413]=32007;   // CYRILLIC CAPITAL LETTER GHE
   sortTable[0x0491]=32008;   // CYRILLIC SMALL LETTER GHE WITH UPTURN
   sortTable[0x0490]=32009;   // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
   sortTable[0x0434]=32010;   // CYRILLIC SMALL LETTER DE
   sortTable[0x0414]=32011;   // CYRILLIC CAPITAL LETTER DE
   sortTable[0x0452]=32012;   // CYRILLIC SMALL LETTER DJE
   sortTable[0x0402]=32013;   // CYRILLIC CAPITAL LETTER DJE
   sortTable[0x0453]=32014;   // CYRILLIC SMALL LETTER GJE
   sortTable[0x0403]=32015;   // CYRILLIC CAPITAL LETTER GJE
   sortTable[0x0435]=32016;   // CYRILLIC SMALL LETTER IE
   sortTable[0x0415]=32017;   // CYRILLIC CAPITAL LETTER IE
   sortTable[0x0451]=32018;   // CYRILLIC SMALL LETTER IO
   sortTable[0x0401]=32019;   // CYRILLIC CAPITAL LETTER IO
   sortTable[0x0454]=32020;   // CYRILLIC SMALL LETTER UKRAINIAN IE
   sortTable[0x0404]=32021;   // CYRILLIC CAPITAL LETTER UKRAINIAN IE
   sortTable[0x0436]=32022;   // CYRILLIC SMALL LETTER ZHE
   sortTable[0x0416]=32023;   // CYRILLIC CAPITAL LETTER ZHE
   sortTable[0x0437]=32024;   // CYRILLIC SMALL LETTER ZE
   sortTable[0x0417]=32025;   // CYRILLIC CAPITAL LETTER ZE
   sortTable[0x0455]=32026;   // CYRILLIC SMALL LETTER DZE
   sortTable[0x0405]=32027;   // CYRILLIC CAPITAL LETTER DZE
   sortTable[0x0438]=32028;   // CYRILLIC SMALL LETTER I
   sortTable[0x0418]=32029;   // CYRILLIC CAPITAL LETTER I
   sortTable[0x0456]=32030;   // CYRILLIC SMALL LETTER BELORUSIAN-UKRAINIAN I
   sortTable[0x0406]=32031;   // CYRILLIC CAPITAL LETTER BELORUSIAN-UKRAINIAN I
   sortTable[0x0457]=32032;   // CYRILLIC SMALL LETTER YI
   sortTable[0x0407]=32033;   // CYRILLIC CAPITAL LETTER YI
   sortTable[0x0439]=32034;   // CYRILLIC SMALL LETTER SHORT I
   sortTable[0x0419]=32035;   // CYRILLIC CAPITAL LETTER SHORT I
   sortTable[0x0458]=32036;   // CYRILLIC SMALL LETTER JE
   sortTable[0x0408]=32037;   // CYRILLIC CAPITAL LETTER JE
   sortTable[0x043A]=32038;   // CYRILLIC SMALL LETTER KA
   sortTable[0x041A]=32039;   // CYRILLIC CAPITAL LETTER KA
   sortTable[0x043B]=32040;   // CYRILLIC SMALL LETTER EL
   sortTable[0x041B]=32041;   // CYRILLIC CAPITAL LETTER EL
   sortTable[0x0459]=32042;   // CYRILLIC SMALL LETTER LJE
   sortTable[0x0409]=32043;   // CYRILLIC CAPITAL LETTER LJE
   sortTable[0x043C]=32044;   // CYRILLIC SMALL LETTER EM
   sortTable[0x041C]=32045;   // CYRILLIC CAPITAL LETTER EM
   sortTable[0x043D]=32046;   // CYRILLIC SMALL LETTER EN
   sortTable[0x041D]=32047;   // CYRILLIC CAPITAL LETTER EN
   sortTable[0x045A]=32048;   // CYRILLIC SMALL LETTER NJE
   sortTable[0x040A]=32049;   // CYRILLIC CAPITAL LETTER NJE
   sortTable[0x043E]=32050;   // CYRILLIC SMALL LETTER O
   sortTable[0x041E]=32051;   // CYRILLIC CAPITAL LETTER O
   sortTable[0x043F]=32052;   // CYRILLIC SMALL LETTER PE
   sortTable[0x041F]=32053;   // CYRILLIC CAPITAL LETTER PE
   sortTable[0x0440]=32054;   // CYRILLIC SMALL LETTER ER
   sortTable[0x0420]=32055;   // CYRILLIC CAPITAL LETTER ER
   sortTable[0x0441]=32056;   // CYRILLIC SMALL LETTER ES
   sortTable[0x0421]=32057;   // CYRILLIC CAPITAL LETTER ES
   sortTable[0x0442]=32058;   // CYRILLIC SMALL LETTER TE
   sortTable[0x0422]=32059;   // CYRILLIC CAPITAL LETTER TE
   sortTable[0x045B]=32060;   // CYRILLIC SMALL LETTER TSHE
   sortTable[0x040B]=32061;   // CYRILLIC CAPITAL LETTER TSHE
   sortTable[0x045C]=32062;   // CYRILLIC SMALL LETTER KJE
   sortTable[0x040C]=32063;   // CYRILLIC CAPITAL LETTER KJE
   sortTable[0x0443]=32064;   // CYRILLIC SMALL LETTER U
   sortTable[0x0423]=32065;   // CYRILLIC CAPITAL LETTER U
   sortTable[0x045E]=32066;   // CYRILLIC SMALL LETTER SHORT U
   sortTable[0x040E]=32067;   // CYRILLIC CAPITAL LETTER SHORT U
   sortTable[0x0444]=32068;   // CYRILLIC SMALL LETTER EF
   sortTable[0x0424]=32069;   // CYRILLIC CAPITAL LETTER EF
   sortTable[0x0445]=32070;   // CYRILLIC SMALL LETTER HA
   sortTable[0x0425]=32071;   // CYRILLIC CAPITAL LETTER HA
   sortTable[0x0446]=32072;   // CYRILLIC SMALL LETTER TSE
   sortTable[0x0426]=32073;   // CYRILLIC CAPITAL LETTER TSE
   sortTable[0x0447]=32074;   // CYRILLIC SMALL LETTER CHE
   sortTable[0x0427]=32075;   // CYRILLIC CAPITAL LETTER CHE
   sortTable[0x045F]=32076;   // CYRILLIC SMALL LETTER DZHE
   sortTable[0x040F]=32077;   // CYRILLIC CAPITAL LETTER DZHE
   sortTable[0x0448]=32078;   // CYRILLIC SMALL LETTER SHA
   sortTable[0x0428]=32079;   // CYRILLIC CAPITAL LETTER SHA
   sortTable[0x0449]=32080;   // CYRILLIC SMALL LETTER SHCHA
   sortTable[0x0429]=32081;   // CYRILLIC CAPITAL LETTER SHCHA
   sortTable[0x044A]=32082;   // CYRILLIC SMALL LETTER HARD SIGN
   sortTable[0x042A]=32083;   // CYRILLIC CAPITAL LETTER HARD SIGN
   sortTable[0x044B]=32084;   // CYRILLIC SMALL LETTER YERU
   sortTable[0x042B]=32085;   // CYRILLIC CAPITAL LETTER YERU
   sortTable[0x044C]=32086;   // CYRILLIC SMALL LETTER SOFT SIGN
   sortTable[0x042C]=32087;   // CYRILLIC CAPITAL LETTER SOFT SIGN
   sortTable[0x044D]=32088;   // CYRILLIC SMALL LETTER E
   sortTable[0x042D]=32089;   // CYRILLIC CAPITAL LETTER E
   sortTable[0x044E]=32090;   // CYRILLIC SMALL LETTER YU
   sortTable[0x042E]=32091;   // CYRILLIC CAPITAL LETTER YU
   sortTable[0x044F]=32092;   // CYRILLIC SMALL LETTER YA
   sortTable[0x042F]=32093;   // CYRILLIC CAPITAL LETTER YA
   sortTable[0x05D0]=32256;   // HEBREW LETTER ALEF
   sortTable[0x05D1]=32257;   // HEBREW LETTER BET
   sortTable[0x05D2]=32258;   // HEBREW LETTER GIMEL
   sortTable[0x05D3]=32259;   // HEBREW LETTER DALET
   sortTable[0x05D4]=32260;   // HEBREW LETTER HE
   sortTable[0x05D5]=32261;   // HEBREW LETTER VAV
   sortTable[0x05D6]=32262;   // HEBREW LETTER ZAYIN
   sortTable[0x05D7]=32263;   // HEBREW LETTER HET
   sortTable[0x05D8]=32264;   // HEBREW LETTER TET
   sortTable[0x05D9]=32265;   // HEBREW LETTER YOD
   sortTable[0x05DA]=32266;   // HEBREW LETTER FINAL KAF
   sortTable[0x05DB]=32267;   // HEBREW LETTER KAF
   sortTable[0x05DC]=32268;   // HEBREW LETTER LAMED
   sortTable[0x05DD]=32269;   // HEBREW LETTER FINAL MEM
   sortTable[0x05DE]=32270;   // HEBREW LETTER MEM
   sortTable[0x05DF]=32271;   // HEBREW LETTER FINAL NUN
   sortTable[0x05E0]=32272;   // HEBREW LETTER NUN
   sortTable[0x05E1]=32273;   // HEBREW LETTER SAMEKH
   sortTable[0x05E2]=32274;   // HEBREW LETTER AYIN
   sortTable[0x05E3]=32275;   // HEBREW LETTER FINAL PE
   sortTable[0x05E4]=32276;   // HEBREW LETTER PE
   sortTable[0x05E5]=32277;   // HEBREW LETTER FINAL TSADI
   sortTable[0x05E6]=32278;   // HEBREW LETTER TSADI
   sortTable[0x05E7]=32279;   // HEBREW LETTER QOF
   sortTable[0x05E8]=32280;   // HEBREW LETTER RESH
   sortTable[0x05E9]=32281;   // HEBREW LETTER SHIN
   sortTable[0x05EA]=32282;   // HEBREW LETTER TAV
   sortTable[0x0660]=32512;   // ARABIC-INDIC DIGIT ZERO
   sortTable[0x0661]=32513;   // ARABIC-INDIC DIGIT ONE
   sortTable[0x0662]=32514;   // ARABIC-INDIC DIGIT TWO
   sortTable[0x0663]=32515;   // ARABIC-INDIC DIGIT THREE
   sortTable[0x0664]=32516;   // ARABIC-INDIC DIGIT FOUR
   sortTable[0x0665]=32517;   // ARABIC-INDIC DIGIT FIVE
   sortTable[0x0666]=32518;   // ARABIC-INDIC DIGIT SIX
   sortTable[0x0667]=32519;   // ARABIC-INDIC DIGIT SEVEN
   sortTable[0x0668]=32520;   // ARABIC-INDIC DIGIT EIGHT
   sortTable[0x0669]=32521;   // ARABIC-INDIC DIGIT NINE
   sortTable[0x0621]=32522;   // ARABIC LETTER HAMZA
   sortTable[0x0623]=32523;   // ARABIC LETTER ALEF WITH HAMZA ABOVE
   sortTable[0x0624]=32524;   // ARABIC LETTER WAW WITH HAMZA ABOVE
   sortTable[0x0625]=32525;   // ARABIC LETTER ALEF WITH HAMZA BELOW
   sortTable[0x0626]=32526;   // ARABIC LETTER YEH WITH HAMZA ABOVE
   sortTable[0x0622]=32527;   // ARABIC LETTER ALEF WITH MADDA ABOVE
   sortTable[0x0627]=32528;   // ARABIC LETTER ALEF
   sortTable[0x0628]=32529;   // ARABIC LETTER BEH
   sortTable[0x062A]=32530;   // ARABIC LETTER TEH
   sortTable[0x0629]=32531;   // ARABIC LETTER TEH MARBUTA
   sortTable[0x062B]=32532;   // ARABIC LETTER THEH
   sortTable[0x062C]=32533;   // ARABIC LETTER JEEM
   sortTable[0x062D]=32534;   // ARABIC LETTER HAH
   sortTable[0x062E]=32535;   // ARABIC LETTER KHAH
   sortTable[0x062F]=32536;   // ARABIC LETTER DAL
   sortTable[0x0630]=32537;   // ARABIC LETTER THAL
   sortTable[0x0631]=32538;   // ARABIC LETTER REH
   sortTable[0x0632]=32539;   // ARABIC LETTER ZAIN
   sortTable[0x0633]=32540;   // ARABIC LETTER SEEN
   sortTable[0x0634]=32541;   // ARABIC LETTER SHEEN
   sortTable[0x0635]=32542;   // ARABIC LETTER SAD
   sortTable[0x0636]=32543;   // ARABIC LETTER DAD
   sortTable[0x0637]=32544;   // ARABIC LETTER TAH
   sortTable[0x0638]=32545;   // ARABIC LETTER ZAH
   sortTable[0x0639]=32546;   // ARABIC LETTER AIN
   sortTable[0x063A]=32547;   // ARABIC LETTER GHAIN
   sortTable[0x0641]=32548;   // ARABIC LETTER FEH
   sortTable[0x0642]=32549;   // ARABIC LETTER QAF
   sortTable[0x0643]=32550;   // ARABIC LETTER KAF
   sortTable[0x0644]=32551;   // ARABIC LETTER LAM
   sortTable[0x0645]=32552;   // ARABIC LETTER MEEM
   sortTable[0x0646]=32553;   // ARABIC LETTER NOON
   sortTable[0x0647]=32554;   // ARABIC LETTER HEH
   sortTable[0x0648]=32555;   // ARABIC LETTER WAW
   sortTable[0x0649]=32556;   // ARABIC LETTER ALEF MAKSURA
   sortTable[0x064A]=32557;   // ARABIC LETTER YEH
   sortTable[0x30A0]=31232;   // KATAKANA-HIRAGANA DOUBLE HYPHEN
   sortTable[0x3041]=31233;   // HIRAGANA LETTER SMALL A
   sortTable[0x30A1]=31234;   // KATAKANA LETTER SMALL A
   sortTable[0x3042]=31235;   // HIRAGANA LETTER A
   sortTable[0x30A2]=31236;   // KATAKANA LETTER A
   sortTable[0x3043]=31237;   // HIRAGANA LETTER SMALL I
   sortTable[0x30A3]=31238;   // KATAKANA LETTER SMALL I
   sortTable[0x3044]=31239;   // HIRAGANA LETTER I
   sortTable[0x30A4]=31240;   // KATAKANA LETTER I
   sortTable[0x3045]=31241;   // HIRAGANA LETTER SMALL U
   sortTable[0x30A5]=31242;   // KATAKANA LETTER SMALL U
   sortTable[0x3046]=31243;   // HIRAGANA LETTER U
   sortTable[0x30A6]=31244;   // KATAKANA LETTER U
   sortTable[0x3047]=31245;   // HIRAGANA LETTER SMALL E
   sortTable[0x30A7]=31246;   // KATAKANA LETTER SMALL E
   sortTable[0x3048]=31247;   // HIRAGANA LETTER E
   sortTable[0x30A8]=31248;   // KATAKANA LETTER E
   sortTable[0x3049]=31249;   // HIRAGANA LETTER SMALL O
   sortTable[0x30A9]=31250;   // KATAKANA LETTER SMALL O
   sortTable[0x304A]=31251;   // HIRAGANA LETTER O
   sortTable[0x30AA]=31252;   // KATAKANA LETTER O
   sortTable[0x3095]=31253;   // HIRAGANA LETTER SMALL KA
   sortTable[0x30F5]=31254;   // KATAKANA LETTER SMALL KA
   sortTable[0x304B]=31255;   // HIRAGANA LETTER KA
   sortTable[0x30AB]=31256;   // KATAKANA LETTER KA
   sortTable[0x304C]=31257;   // HIRAGANA LETTER GA
   sortTable[0x30AC]=31258;   // KATAKANA LETTER GA
   sortTable[0x304D]=31259;   // HIRAGANA LETTER KI
   sortTable[0x30AD]=31260;   // KATAKANA LETTER KI
   sortTable[0x304E]=31261;   // HIRAGANA LETTER GI
   sortTable[0x30AE]=31262;   // KATAKANA LETTER GI
   sortTable[0x304F]=31263;   // HIRAGANA LETTER KU
   sortTable[0x30AF]=31264;   // KATAKANA LETTER KU
   sortTable[0x3050]=31265;   // HIRAGANA LETTER GU
   sortTable[0x30B0]=31266;   // KATAKANA LETTER GU
   sortTable[0x3096]=31267;   // HIRAGANA LETTER SMALL KE
   sortTable[0x30F6]=31268;   // KATAKANA LETTER SMALL KE
   sortTable[0x3051]=31269;   // HIRAGANA LETTER KE
   sortTable[0x30B1]=31270;   // KATAKANA LETTER KE
   sortTable[0x3052]=31271;   // HIRAGANA LETTER GE
   sortTable[0x30B2]=31272;   // KATAKANA LETTER GE
   sortTable[0x3053]=31273;   // HIRAGANA LETTER KO
   sortTable[0x30B3]=31274;   // KATAKANA LETTER KO
   sortTable[0x3054]=31275;   // HIRAGANA LETTER GO
   sortTable[0x30B4]=31276;   // KATAKANA LETTER GO
   sortTable[0x3055]=31277;   // HIRAGANA LETTER SA
   sortTable[0x30B5]=31278;   // KATAKANA LETTER SA
   sortTable[0x3056]=31279;   // HIRAGANA LETTER ZA
   sortTable[0x30B6]=31280;   // KATAKANA LETTER ZA
   sortTable[0x3057]=31281;   // HIRAGANA LETTER SI
   sortTable[0x30B7]=31282;   // KATAKANA LETTER SI
   sortTable[0x3058]=31283;   // HIRAGANA LETTER ZI
   sortTable[0x30B8]=31284;   // KATAKANA LETTER ZI
   sortTable[0x3059]=31285;   // HIRAGANA LETTER SU
   sortTable[0x30B9]=31286;   // KATAKANA LETTER SU
   sortTable[0x305A]=31287;   // HIRAGANA LETTER ZU
   sortTable[0x30BA]=31288;   // KATAKANA LETTER ZU
   sortTable[0x305B]=31289;   // HIRAGANA LETTER SE
   sortTable[0x30BB]=31290;   // KATAKANA LETTER SE
   sortTable[0x305C]=31291;   // HIRAGANA LETTER ZE
   sortTable[0x30BC]=31292;   // KATAKANA LETTER ZE
   sortTable[0x305D]=31293;   // HIRAGANA LETTER SO
   sortTable[0x30BD]=31294;   // KATAKANA LETTER SO
   sortTable[0x305E]=31295;   // HIRAGANA LETTER ZO
   sortTable[0x30BE]=31296;   // KATAKANA LETTER ZO
   sortTable[0x305F]=31297;   // HIRAGANA LETTER TA
   sortTable[0x30BF]=31298;   // KATAKANA LETTER TA
   sortTable[0x3060]=31299;   // HIRAGANA LETTER DA
   sortTable[0x30C0]=31300;   // KATAKANA LETTER DA
   sortTable[0x3061]=31301;   // HIRAGANA LETTER TI
   sortTable[0x30C1]=31302;   // KATAKANA LETTER TI
   sortTable[0x3062]=31303;   // HIRAGANA LETTER DI
   sortTable[0x30C2]=31304;   // KATAKANA LETTER DI
   sortTable[0x3063]=31305;   // HIRAGANA LETTER SMALL TU
   sortTable[0x30C3]=31306;   // KATAKANA LETTER SMALL TU
   sortTable[0x3064]=31307;   // HIRAGANA LETTER TU
   sortTable[0x30C4]=31308;   // KATAKANA LETTER TU
   sortTable[0x3065]=31309;   // HIRAGANA LETTER DU
   sortTable[0x30C5]=31310;   // KATAKANA LETTER DU
   sortTable[0x3066]=31311;   // HIRAGANA LETTER TE
   sortTable[0x30C6]=31312;   // KATAKANA LETTER TE
   sortTable[0x3067]=31313;   // HIRAGANA LETTER DE
   sortTable[0x30C7]=31314;   // KATAKANA LETTER DE
   sortTable[0x3068]=31315;   // HIRAGANA LETTER TO
   sortTable[0x30C8]=31316;   // KATAKANA LETTER TO
   sortTable[0x3069]=31317;   // HIRAGANA LETTER DO
   sortTable[0x30C9]=31318;   // KATAKANA LETTER DO
   sortTable[0x306A]=31319;   // HIRAGANA LETTER NA
   sortTable[0x30CA]=31320;   // KATAKANA LETTER NA
   sortTable[0x306B]=31321;   // HIRAGANA LETTER NI
   sortTable[0x30CB]=31322;   // KATAKANA LETTER NI
   sortTable[0x306C]=31323;   // HIRAGANA LETTER NU
   sortTable[0x30CC]=31324;   // KATAKANA LETTER NU
   sortTable[0x306D]=31325;   // HIRAGANA LETTER NE
   sortTable[0x30CD]=31326;   // KATAKANA LETTER NE
   sortTable[0x306E]=31327;   // HIRAGANA LETTER NO
   sortTable[0x30CE]=31328;   // KATAKANA LETTER NO
   sortTable[0x306F]=31329;   // HIRAGANA LETTER HA
   sortTable[0x30CF]=31330;   // KATAKANA LETTER HA
   sortTable[0x3070]=31331;   // HIRAGANA LETTER BA
   sortTable[0x30D0]=31332;   // KATAKANA LETTER BA
   sortTable[0x3071]=31333;   // HIRAGANA LETTER PA
   sortTable[0x30D1]=31334;   // KATAKANA LETTER PA
   sortTable[0x3072]=31335;   // HIRAGANA LETTER HI
   sortTable[0x30D2]=31336;   // KATAKANA LETTER HI
   sortTable[0x3073]=31337;   // HIRAGANA LETTER BI
   sortTable[0x30D3]=31338;   // KATAKANA LETTER BI
   sortTable[0x3074]=31339;   // HIRAGANA LETTER PI
   sortTable[0x30D4]=31340;   // KATAKANA LETTER PI
   sortTable[0x3075]=31341;   // HIRAGANA LETTER HU
   sortTable[0x30D5]=31342;   // KATAKANA LETTER HU
   sortTable[0x3076]=31343;   // HIRAGANA LETTER BU
   sortTable[0x30D6]=31344;   // KATAKANA LETTER BU
   sortTable[0x3077]=31345;   // HIRAGANA LETTER PU
   sortTable[0x30D7]=31346;   // KATAKANA LETTER PU
   sortTable[0x3078]=31347;   // HIRAGANA LETTER HE
   sortTable[0x30D8]=31348;   // KATAKANA LETTER HE
   sortTable[0x3079]=31349;   // HIRAGANA LETTER BE
   sortTable[0x30D9]=31350;   // KATAKANA LETTER BE
   sortTable[0x307A]=31351;   // HIRAGANA LETTER PE
   sortTable[0x30DA]=31352;   // KATAKANA LETTER PE
   sortTable[0x307B]=31353;   // HIRAGANA LETTER HO
   sortTable[0x30DB]=31354;   // KATAKANA LETTER HO
   sortTable[0x307C]=31355;   // HIRAGANA LETTER BO
   sortTable[0x30DC]=31356;   // KATAKANA LETTER BO
   sortTable[0x307D]=31357;   // HIRAGANA LETTER PO
   sortTable[0x30DD]=31358;   // KATAKANA LETTER PO
   sortTable[0x307E]=31359;   // HIRAGANA LETTER MA
   sortTable[0x30DE]=31360;   // KATAKANA LETTER MA
   sortTable[0x307F]=31361;   // HIRAGANA LETTER MI
   sortTable[0x30DF]=31362;   // KATAKANA LETTER MI
   sortTable[0x3080]=31363;   // HIRAGANA LETTER MU
   sortTable[0x30E0]=31364;   // KATAKANA LETTER MU
   sortTable[0x3081]=31365;   // HIRAGANA LETTER ME
   sortTable[0x30E1]=31366;   // KATAKANA LETTER ME
   sortTable[0x3082]=31367;   // HIRAGANA LETTER MO
   sortTable[0x30E2]=31368;   // KATAKANA LETTER MO
   sortTable[0x3083]=31369;   // HIRAGANA LETTER SMALL YA
   sortTable[0x30E3]=31370;   // KATAKANA LETTER SMALL YA
   sortTable[0x3084]=31371;   // HIRAGANA LETTER YA
   sortTable[0x30E4]=31372;   // KATAKANA LETTER YA
   sortTable[0x3085]=31373;   // HIRAGANA LETTER SMALL YU
   sortTable[0x30E5]=31374;   // KATAKANA LETTER SMALL YU
   sortTable[0x3086]=31375;   // HIRAGANA LETTER YU
   sortTable[0x30E6]=31376;   // KATAKANA LETTER YU
   sortTable[0x3087]=31377;   // HIRAGANA LETTER SMALL YO
   sortTable[0x30E7]=31378;   // KATAKANA LETTER SMALL YO
   sortTable[0x3088]=31379;   // HIRAGANA LETTER YO
   sortTable[0x30E8]=31380;   // KATAKANA LETTER YO
   sortTable[0x3089]=31381;   // HIRAGANA LETTER RA
   sortTable[0x30E9]=31382;   // KATAKANA LETTER RA
   sortTable[0x308A]=31383;   // HIRAGANA LETTER RI
   sortTable[0x30EA]=31384;   // KATAKANA LETTER RI
   sortTable[0x308B]=31385;   // HIRAGANA LETTER RU
   sortTable[0x30EB]=31386;   // KATAKANA LETTER RU
   sortTable[0x308C]=31387;   // HIRAGANA LETTER RE
   sortTable[0x30EC]=31388;   // KATAKANA LETTER RE
   sortTable[0x308D]=31389;   // HIRAGANA LETTER RO
   sortTable[0x30ED]=31390;   // KATAKANA LETTER RO
   sortTable[0x308E]=31391;   // HIRAGANA LETTER SMALL WA
   sortTable[0x30EE]=31392;   // KATAKANA LETTER SMALL WA
   sortTable[0x308F]=31393;   // HIRAGANA LETTER WA
   sortTable[0x30EF]=31394;   // KATAKANA LETTER WA
   sortTable[0x3090]=31395;   // HIRAGANA LETTER WI
   sortTable[0x30F0]=31396;   // KATAKANA LETTER WI
   sortTable[0x3091]=31397;   // HIRAGANA LETTER WE
   sortTable[0x30F1]=31398;   // KATAKANA LETTER WE
   sortTable[0x3092]=31399;   // HIRAGANA LETTER WO
   sortTable[0x30F2]=31400;   // KATAKANA LETTER WO
   sortTable[0x3093]=31401;   // HIRAGANA LETTER N
   sortTable[0x30F3]=31402;   // KATAKANA LETTER N
   sortTable[0x3094]=31403;   // HIRAGANA LETTER VU
   sortTable[0x30F4]=31404;   // KATAKANA LETTER VU
   sortTable[0x0E00]=31488;
   sortTable[0x0E01]=31489;   // THAI CHARACTER KO KAI
   sortTable[0x0E02]=31490;   // THAI CHARACTER KHO KHAI
   sortTable[0x0E03]=31491;   // THAI CHARACTER KHO KHUAT
   sortTable[0x0E04]=31492;   // THAI CHARACTER KHO KHWAI
   sortTable[0x0E05]=31493;   // THAI CHARACTER KHO KHON
   sortTable[0x0E06]=31494;   // THAI CHARACTER KHO RAKHANG
   sortTable[0x0E07]=31495;   // THAI CHARACTER NGO NGU
   sortTable[0x0E08]=31496;   // THAI CHARACTER CHO CHAN
   sortTable[0x0E09]=31497;   // THAI CHARACTER CHO CHING
   sortTable[0x0E0A]=31498;   // THAI CHARACTER CHO CHANG
   sortTable[0x0E0B]=31499;   // THAI CHARACTER SO SO
   sortTable[0x0E0C]=31500;   // THAI CHARACTER CHO CHOE
   sortTable[0x0E0D]=31501;   // THAI CHARACTER YO YING
   sortTable[0x0E0E]=31502;   // THAI CHARACTER DO CHADA
   sortTable[0x0E0F]=31503;   // THAI CHARACTER TO PATAK
   sortTable[0x0E10]=31504;   // THAI CHARACTER THO THAN
   sortTable[0x0E11]=31505;   // THAI CHARACTER THO NANGMONTHO
   sortTable[0x0E12]=31506;   // THAI CHARACTER THO PHUTHAO
   sortTable[0x0E13]=31507;   // THAI CHARACTER NO NEN
   sortTable[0x0E14]=31508;   // THAI CHARACTER DO DEK
   sortTable[0x0E15]=31509;   // THAI CHARACTER TO TAO
   sortTable[0x0E16]=31510;   // THAI CHARACTER THO THUNG
   sortTable[0x0E17]=31511;   // THAI CHARACTER THO THAHAN
   sortTable[0x0E18]=31512;   // THAI CHARACTER THO THONG
   sortTable[0x0E19]=31513;   // THAI CHARACTER NO NU
   sortTable[0x0E1A]=31514;   // THAI CHARACTER BO BAIMAI
   sortTable[0x0E1B]=31515;   // THAI CHARACTER PO PLA
   sortTable[0x0E1C]=31516;   // THAI CHARACTER PHO PHUNG
   sortTable[0x0E1D]=31517;   // THAI CHARACTER FO FA
   sortTable[0x0E1E]=31518;   // THAI CHARACTER PHO PHAN
   sortTable[0x0E1F]=31519;   // THAI CHARACTER FO FAN
   sortTable[0x0E20]=31520;   // THAI CHARACTER PHO SAMPHAO
   sortTable[0x0E21]=31521;   // THAI CHARACTER MO MA
   sortTable[0x0E22]=31522;   // THAI CHARACTER YO YAK
   sortTable[0x0E23]=31523;   // THAI CHARACTER RO RUA
   sortTable[0x0E24]=31524;   // THAI CHARACTER RU
   sortTable[0x0E25]=31525;   // THAI CHARACTER LO LING
   sortTable[0x0E26]=31526;   // THAI CHARACTER LU
   sortTable[0x0E27]=31527;   // THAI CHARACTER WO WAEN
   sortTable[0x0E28]=31528;   // THAI CHARACTER SO SALA
   sortTable[0x0E29]=31529;   // THAI CHARACTER SO RUSI
   sortTable[0x0E2A]=31530;   // THAI CHARACTER SO SUA
   sortTable[0x0E2B]=31531;   // THAI CHARACTER HO HIP
   sortTable[0x0E2C]=31532;   // THAI CHARACTER LO CHULA
   sortTable[0x0E2D]=31533;   // THAI CHARACTER O ANG
   sortTable[0x0E2E]=31534;   // THAI CHARACTER HO NOKHUK
   sortTable[0x0E2F]=31535;   // THAI CHARACTER PAIYANNOI
   sortTable[0x0E30]=31536;   // THAI CHARACTER SARA A
   sortTable[0x0E31]=31537;   // THAI CHARACTER MAI HAN-AKAT
   sortTable[0x0E32]=31538;   // THAI CHARACTER SARA AA
   sortTable[0x0E33]=31539;   // THAI CHARACTER SARA AM
   sortTable[0x0E34]=31540;   // THAI CHARACTER SARA I
   sortTable[0x0E35]=31541;   // THAI CHARACTER SARA II
   sortTable[0x0E36]=31542;   // THAI CHARACTER SARA UE
   sortTable[0x0E37]=31543;   // THAI CHARACTER SARA UEE
   sortTable[0x0E38]=31544;   // THAI CHARACTER SARA U
   sortTable[0x0E39]=31545;   // THAI CHARACTER SARA UU
   sortTable[0x0E3A]=31546;   // THAI CHARACTER PHINTHU
   sortTable[0x0E3F]=31547;   // THAI CURRENCY SYMBOL BAHT
   sortTable[0x0E40]=31548;   // THAI CHARACTER SARA E
   sortTable[0x0E41]=31549;   // THAI CHARACTER SARA AE
   sortTable[0x0E42]=31550;   // THAI CHARACTER SARA O
   sortTable[0x0E43]=31551;   // THAI CHARACTER SARA AI MAIMUAN
   sortTable[0x0E44]=31552;   // THAI CHARACTER SARA AI MAIMALAI
   sortTable[0x0E45]=31553;   // THAI CHARACTER LAKKHANGYAO
   sortTable[0x0E46]=31554;   // THAI CHARACTER MAIYAMOK
   sortTable[0x0E47]=31555;   // THAI CHARACTER MAITAIKHU
   sortTable[0x0E48]=31556;   // THAI CHARACTER MAI EK
   sortTable[0x0E49]=31557;   // THAI CHARACTER MAI THO
   sortTable[0x0E4A]=31558;   // THAI CHARACTER MAI TRI
   sortTable[0x0E4B]=31559;   // THAI CHARACTER MAI CHATTAWA
   sortTable[0x0E4C]=31560;   // THAI CHARACTER THANTHAKHAT
   sortTable[0x0E4D]=31561;   // THAI CHARACTER NIKHAHIT
   sortTable[0x0E4E]=31562;   // THAI CHARACTER YAMAKKAN
   sortTable[0x0E4F]=31563;   // THAI CHARACTER FONGMAN
   sortTable[0x0E50]=31564;   // THAI DIGIT ZERO
   sortTable[0x0E51]=31565;   // THAI DIGIT ONE
   sortTable[0x0E52]=31566;   // THAI DIGIT TWO
   sortTable[0x0E53]=31567;   // THAI DIGIT THREE
   sortTable[0x0E54]=31568;   // THAI DIGIT FOUR
   sortTable[0x0E55]=31569;   // THAI DIGIT FIVE
   sortTable[0x0E56]=31570;   // THAI DIGIT SIX
   sortTable[0x0E57]=31571;   // THAI DIGIT SEVEN
   sortTable[0x0E58]=31572;   // THAI DIGIT EIGHT
   sortTable[0x0E59]=31573;   // THAI DIGIT NINE
   sortTable[0x0E5A]=31574;   // THAI CHARACTER ANGKHANKHU
   sortTable[0x0E5B]=31575;   // THAI CHARACTER KHOMUT
   sortTable[0x554A]=512;   // a
   sortTable[0x5475]=513;   // a
   sortTable[0x963F]=514;   // a
   sortTable[0x55C4]=515;   // a
   sortTable[0x9515]=516;   // a
   sortTable[0x7231]=517;   // ai
   sortTable[0x611B]=518;   // ai
   sortTable[0x54CE]=519;   // ai
   sortTable[0x6328]=520;   // ai
   sortTable[0x788D]=521;   // ai
   sortTable[0x7919]=522;   // ai
   sortTable[0x54C0]=523;   // ai
   sortTable[0x77EE]=524;   // ai
   sortTable[0x764C]=525;   // ai
   sortTable[0x57C3]=526;   // ai
   sortTable[0x853C]=527;   // ai
   sortTable[0x85F9]=528;   // ai
   sortTable[0x9698]=529;   // ai
   sortTable[0x827E]=530;   // ai
   sortTable[0x5509]=531;   // ai
   sortTable[0x55F3]=532;   // ai
   sortTable[0x66A7]=533;   // ai
   sortTable[0x6371]=534;   // ai
   sortTable[0x972D]=535;   // ai
   sortTable[0x55CC]=536;   // ai
   sortTable[0x7691]=537;   // ai
   sortTable[0x953F]=538;   // ai
   sortTable[0x5AD2]=539;   // ai
   sortTable[0x7839]=540;   // ai
   sortTable[0x7477]=541;   // ai
   sortTable[0x9A03]=542;   // ai
   sortTable[0x8586]=543;   // ai
   sortTable[0x9D31]=544;   // ai
   sortTable[0x8B7A]=545;   // ai
   sortTable[0x9749]=546;   // ai
   sortTable[0x784B]=547;   // ai
   sortTable[0x9932]=548;   // ai
   sortTable[0x9440]=549;   // ai
   sortTable[0x9744]=550;   // ai
   sortTable[0x4F0C]=551;   // ai
   sortTable[0x50FE]=552;   // ai
   sortTable[0x53C6]=553;   // ai
   sortTable[0x5540]=554;   // ai
   sortTable[0x560A]=555;   // ai
   sortTable[0x566F]=556;   // ai
   sortTable[0x5867]=557;   // ai
   sortTable[0x58D2]=558;   // ai
   sortTable[0x5A2D]=559;   // ai
   sortTable[0x5A3E]=560;   // ai
   sortTable[0x5B21]=561;   // ai
   sortTable[0x61D3]=562;   // ai
   sortTable[0x61DD]=563;   // ai
   sortTable[0x6571]=564;   // ai
   sortTable[0x6573]=565;   // ai
   sortTable[0x6639]=566;   // ai
   sortTable[0x66D6]=567;   // ai
   sortTable[0x6B38]=568;   // ai
   sortTable[0x6BD0]=569;   // ai
   sortTable[0x6EB0]=570;   // ai
   sortTable[0x6EBE]=571;   // ai
   sortTable[0x6FED]=572;   // ai
   sortTable[0x74A6]=573;   // ai
   sortTable[0x769A]=574;   // ai
   sortTable[0x76A7]=575;   // ai
   sortTable[0x77B9]=576;   // ai
   sortTable[0x8B6A]=577;   // ai
   sortTable[0x8EB7]=578;   // ai
   sortTable[0x92B0]=579;   // ai
   sortTable[0x9384]=580;   // ai
   sortTable[0x95A1]=581;   // ai
   sortTable[0x99A4]=582;   // ai
   sortTable[0x9C6B]=583;   // ai
   sortTable[0x5B89]=584;   // an
   sortTable[0x6309]=585;   // an
   sortTable[0x5CB8]=586;   // an
   sortTable[0x6697]=587;   // an
   sortTable[0x6848]=588;   // an
   sortTable[0x4FFA]=589;   // an
   sortTable[0x6C28]=590;   // an
   sortTable[0x9E4C]=591;   // an
   sortTable[0x9D6A]=592;   // an
   sortTable[0x9EEF]=593;   // an
   sortTable[0x5EB5]=594;   // an
   sortTable[0x978D]=595;   // an
   sortTable[0x8C19]=596;   // an
   sortTable[0x80FA]=597;   // an
   sortTable[0x95C7]=598;   // an
   sortTable[0x72B4]=599;   // an
   sortTable[0x6849]=600;   // an
   sortTable[0x83F4]=601;   // an
   sortTable[0x94F5]=602;   // an
   sortTable[0x57EF]=603;   // an
   sortTable[0x9B9F]=604;   // an
   sortTable[0x76E6]=605;   // an
   sortTable[0x844A]=606;   // an
   sortTable[0x97FD]=607;   // an
   sortTable[0x63DE]=608;   // an
   sortTable[0x8C7B]=609;   // an
   sortTable[0x9D95]=610;   // an
   sortTable[0x76EB]=611;   // an
   sortTable[0x978C]=612;   // an
   sortTable[0x7F6F]=613;   // an
   sortTable[0x84ED]=614;   // an
   sortTable[0x96F8]=615;   // an
   sortTable[0x4F92]=616;   // an
   sortTable[0x5111]=617;   // an
   sortTable[0x5535]=618;   // an
   sortTable[0x557D]=619;   // an
   sortTable[0x57B5]=620;   // an
   sortTable[0x5813]=621;   // an
   sortTable[0x5A69]=622;   // an
   sortTable[0x5A95]=623;   // an
   sortTable[0x5CD6]=624;   // an
   sortTable[0x667B]=625;   // an
   sortTable[0x6D1D]=626;   // an
   sortTable[0x73B5]=627;   // an
   sortTable[0x75F7]=628;   // an
   sortTable[0x8164]=629;   // an
   sortTable[0x834C]=630;   // an
   sortTable[0x843B]=631;   // an
   sortTable[0x8A9D]=632;   // an
   sortTable[0x8AF3]=633;   // an
   sortTable[0x92A8]=634;   // an
   sortTable[0x930C]=635;   // an
   sortTable[0x968C]=636;   // an
   sortTable[0x99A3]=637;   // an
   sortTable[0x6602]=638;   // ang
   sortTable[0x80AE]=639;   // ang
   sortTable[0x76CE]=640;   // ang
   sortTable[0x9AAF]=641;   // ang
   sortTable[0x536C]=642;   // ang
   sortTable[0x5C87]=643;   // ang
   sortTable[0x663B]=644;   // ang
   sortTable[0x678A]=645;   // ang
   sortTable[0x91A0]=646;   // ang
   sortTable[0x50B2]=647;   // ao
   sortTable[0x8884]=648;   // ao
   sortTable[0x8956]=649;   // ao
   sortTable[0x51F9]=650;   // ao
   sortTable[0x71AC]=651;   // ao
   sortTable[0x5965]=652;   // ao
   sortTable[0x6FB3]=653;   // ao
   sortTable[0x6556]=654;   // ao
   sortTable[0x9CCC]=655;   // ao
   sortTable[0x61CA]=656;   // ao
   sortTable[0x62D7]=657;   // ao
   sortTable[0x5AAA]=658;   // ao
   sortTable[0x7FF1]=659;   // ao
   sortTable[0x55F7]=660;   // ao
   sortTable[0x93CA]=661;   // ao
   sortTable[0x93D6]=662;   // ao
   sortTable[0x9068]=663;   // ao
   sortTable[0x5773]=664;   // ao
   sortTable[0x9A9C]=665;   // ao
   sortTable[0x9C32]=666;   // ao
   sortTable[0x87AF]=667;   // ao
   sortTable[0x5ED2]=668;   // ao
   sortTable[0x7352]=669;   // ao
   sortTable[0x78DD]=670;   // ao
   sortTable[0x8071]=671;   // ao
   sortTable[0x5C99]=672;   // ao
   sortTable[0x96A9]=673;   // ao
   sortTable[0x9F07]=674;   // ao
   sortTable[0x8B37]=675;   // ao
   sortTable[0x8B38]=676;   // ao
   sortTable[0x969E]=677;   // ao
   sortTable[0x9A41]=678;   // ao
   sortTable[0x82BA]=679;   // ao
   sortTable[0x851C]=680;   // ao
   sortTable[0x53AB]=681;   // ao
   sortTable[0x55F8]=682;   // ao
   sortTable[0x5787]=683;   // ao
   sortTable[0x58BA]=684;   // ao
   sortTable[0x5961]=685;   // ao
   sortTable[0x5967]=686;   // ao
   sortTable[0x5ABC]=687;   // ao
   sortTable[0x5AEF]=688;   // ao
   sortTable[0x5CB0]=689;   // ao
   sortTable[0x5D85]=690;   // ao
   sortTable[0x5DB4]=691;   // ao
   sortTable[0x6160]=692;   // ao
   sortTable[0x6277]=693;   // ao
   sortTable[0x629D]=694;   // ao
   sortTable[0x646E]=695;   // ao
   sortTable[0x64D9]=696;   // ao
   sortTable[0x67EA]=697;   // ao
   sortTable[0x688E]=698;   // ao
   sortTable[0x6EF6]=699;   // ao
   sortTable[0x720A]=700;   // ao
   sortTable[0x7353]=701;   // ao
   sortTable[0x7488]=702;   // ao
   sortTable[0x7FF6]=703;   // ao
   sortTable[0x7FFA]=704;   // ao
   sortTable[0x8EEA]=705;   // ao
   sortTable[0x957A]=706;   // ao
   sortTable[0x9DD4]=707;   // ao
   sortTable[0x628A]=1024;   // ba
   sortTable[0x5427]=1025;   // ba
   sortTable[0x7F62]=1026;   // ba
   sortTable[0x7F77]=1027;   // ba
   sortTable[0x516B]=1028;   // ba
   sortTable[0x7238]=1029;   // ba
   sortTable[0x5DF4]=1030;   // ba
   sortTable[0x62D4]=1031;   // ba
   sortTable[0x6252]=1032;   // ba
   sortTable[0x9738]=1033;   // ba
   sortTable[0x53ED]=1034;   // ba
   sortTable[0x575D]=1035;   // ba
   sortTable[0x58E9]=1036;   // ba
   sortTable[0x7B06]=1037;   // ba
   sortTable[0x8DCB]=1038;   // ba
   sortTable[0x75A4]=1039;   // ba
   sortTable[0x9776]=1040;   // ba
   sortTable[0x82AD]=1041;   // ba
   sortTable[0x8019]=1042;   // ba
   sortTable[0x7C91]=1043;   // ba
   sortTable[0x9B43]=1044;   // ba
   sortTable[0x634C]=1045;   // ba
   sortTable[0x705E]=1046;   // ba
   sortTable[0x94AF]=1047;   // ba
   sortTable[0x5C9C]=1048;   // ba
   sortTable[0x9C85]=1049;   // ba
   sortTable[0x83DD]=1050;   // ba
   sortTable[0x8307]=1051;   // ba
   sortTable[0x9C83]=1052;   // ba
   sortTable[0x9C8C]=1053;   // ba
   sortTable[0x9B8A]=1054;   // ba
   sortTable[0x8DC1]=1055;   // ba
   sortTable[0x9B5E]=1056;   // ba
   sortTable[0x8EF7]=1057;   // ba
   sortTable[0x8C5D]=1058;   // ba
   sortTable[0x7F93]=1059;   // ba
   sortTable[0x80C8]=1060;   // ba
   sortTable[0x91DB]=1061;   // ba
   sortTable[0x8686]=1062;   // ba
   sortTable[0x91DF]=1063;   // ba
   sortTable[0x9F25]=1064;   // ba
   sortTable[0x7D26]=1065;   // ba
   sortTable[0x8987]=1066;   // ba
   sortTable[0x4EC8]=1067;   // ba
   sortTable[0x53D0]=1068;   // ba
   sortTable[0x54F5]=1069;   // ba
   sortTable[0x577A]=1070;   // ba
   sortTable[0x57BB]=1071;   // ba
   sortTable[0x58A2]=1072;   // ba
   sortTable[0x593F]=1073;   // ba
   sortTable[0x59AD]=1074;   // ba
   sortTable[0x5CC7]=1075;   // ba
   sortTable[0x5DFC]=1076;   // ba
   sortTable[0x5F1D]=1077;   // ba
   sortTable[0x629C]=1078;   // ba
   sortTable[0x6733]=1079;   // ba
   sortTable[0x67ED]=1080;   // ba
   sortTable[0x6B1B]=1081;   // ba
   sortTable[0x70A6]=1082;   // ba
   sortTable[0x72AE]=1083;   // ba
   sortTable[0x7390]=1084;   // ba
   sortTable[0x7679]=1085;   // ba
   sortTable[0x77F2]=1086;   // ba
   sortTable[0x8A59]=1087;   // ba
   sortTable[0x9200]=1088;   // ba
   sortTable[0x98B0]=1089;   // ba
   sortTable[0x767E]=1090;   // bai
   sortTable[0x767D]=1091;   // bai
   sortTable[0x6446]=1092;   // bai
   sortTable[0x64FA]=1093;   // bai
   sortTable[0x8D25]=1094;   // bai
   sortTable[0x6557]=1095;   // bai
   sortTable[0x62DC]=1096;   // bai
   sortTable[0x67CF]=1097;   // bai
   sortTable[0x63B0]=1098;   // bai
   sortTable[0x7A17]=1099;   // bai
   sortTable[0x64D8]=1100;   // bai
   sortTable[0x4F70]=1101;   // bai
   sortTable[0x636D]=1102;   // bai
   sortTable[0x7CBA]=1103;   // bai
   sortTable[0x8D01]=1104;   // bai
   sortTable[0x7CA8]=1105;   // bai
   sortTable[0x7D54]=1106;   // bai
   sortTable[0x896C]=1107;   // bai
   sortTable[0x85AD]=1108;   // bai
   sortTable[0x86FD]=1109;   // bai
   sortTable[0x5161]=1110;   // bai
   sortTable[0x5E8D]=1111;   // bai
   sortTable[0x62DD]=1112;   // bai
   sortTable[0x6300]=1113;   // bai
   sortTable[0x6822]=1114;   // bai
   sortTable[0x7308]=1115;   // bai
   sortTable[0x74F8]=1116;   // bai
   sortTable[0x7AE1]=1117;   // bai
   sortTable[0x97DB]=1118;   // bai
   sortTable[0x529E]=1119;   // ban
   sortTable[0x8FA6]=1120;   // ban
   sortTable[0x534A]=1121;   // ban
   sortTable[0x822C]=1122;   // ban
   sortTable[0x677F]=1123;   // ban
   sortTable[0x73ED]=1124;   // ban
   sortTable[0x642C]=1125;   // ban
   sortTable[0x4F34]=1126;   // ban
   sortTable[0x7248]=1127;   // ban
   sortTable[0x74E3]=1128;   // ban
   sortTable[0x62CC]=1129;   // ban
   sortTable[0x626E]=1130;   // ban
   sortTable[0x9881]=1131;   // ban
   sortTable[0x6273]=1132;   // ban
   sortTable[0x9812]=1133;   // ban
   sortTable[0x6591]=1134;   // ban
   sortTable[0x7622]=1135;   // ban
   sortTable[0x7ECA]=1136;   // ban
   sortTable[0x962A]=1137;   // ban
   sortTable[0x5742]=1138;   // ban
   sortTable[0x8228]=1139;   // ban
   sortTable[0x94A3]=1140;   // ban
   sortTable[0x764D]=1141;   // ban
   sortTable[0x977D]=1142;   // ban
   sortTable[0x95C6]=1143;   // ban
   sortTable[0x8781]=1144;   // ban
   sortTable[0x9261]=1145;   // ban
   sortTable[0x9B6C]=1146;   // ban
   sortTable[0x7C84]=1147;   // ban
   sortTable[0x7D46]=1148;   // ban
   sortTable[0x9CFB]=1149;   // ban
   sortTable[0x5762]=1150;   // ban
   sortTable[0x59C5]=1151;   // ban
   sortTable[0x5C85]=1152;   // ban
   sortTable[0x6011]=1153;   // ban
   sortTable[0x653D]=1154;   // ban
   sortTable[0x6592]=1155;   // ban
   sortTable[0x6604]=1156;   // ban
   sortTable[0x67C8]=1157;   // ban
   sortTable[0x6E74]=1158;   // ban
   sortTable[0x74EA]=1159;   // ban
   sortTable[0x79DA]=1160;   // ban
   sortTable[0x8742]=1161;   // ban
   sortTable[0x878C]=1162;   // ban
   sortTable[0x8929]=1163;   // ban
   sortTable[0x8FAC]=1164;   // ban
   sortTable[0x9211]=1165;   // ban
   sortTable[0x5E2E]=1166;   // bang
   sortTable[0x5E6B]=1167;   // bang
   sortTable[0x8180]=1168;   // bang
   sortTable[0x68D2]=1169;   // bang
   sortTable[0x7ED1]=1170;   // bang
   sortTable[0x7D81]=1171;   // bang
   sortTable[0x508D]=1172;   // bang
   sortTable[0x699C]=1173;   // bang
   sortTable[0x78C5]=1174;   // bang
   sortTable[0x90A6]=1175;   // bang
   sortTable[0x6886]=1176;   // bang
   sortTable[0x9551]=1177;   // bang
   sortTable[0x8C24]=1178;   // bang
   sortTable[0x6D5C]=1179;   // bang
   sortTable[0x868C]=1180;   // bang
   sortTable[0x84A1]=1181;   // bang
   sortTable[0x8255]=1182;   // bang
   sortTable[0x872F]=1183;   // bang
   sortTable[0x7A16]=1184;   // bang
   sortTable[0x90AB]=1185;   // bang
   sortTable[0x57B9]=1186;   // bang
   sortTable[0x585D]=1187;   // bang
   sortTable[0x5E47]=1188;   // bang
   sortTable[0x5E5A]=1189;   // bang
   sortTable[0x6360]=1190;   // bang
   sortTable[0x6412]=1191;   // bang
   sortTable[0x68D3]=1192;   // bang
   sortTable[0x7253]=1193;   // bang
   sortTable[0x73A4]=1194;   // bang
   sortTable[0x7E0D]=1195;   // bang
   sortTable[0x8B17]=1196;   // bang
   sortTable[0x938A]=1197;   // bang
   sortTable[0x97A4]=1198;   // bang
   sortTable[0x9AC8]=1199;   // bang
   sortTable[0x62A5]=1200;   // bao
   sortTable[0x5831]=1201;   // bao
   sortTable[0x4FDD]=1202;   // bao
   sortTable[0x5305]=1203;   // bao
   sortTable[0x62B1]=1204;   // bao
   sortTable[0x5B9D]=1205;   // bao
   sortTable[0x5BF6]=1206;   // bao
   sortTable[0x7206]=1207;   // bao
   sortTable[0x66B4]=1208;   // bao
   sortTable[0x80DE]=1209;   // bao
   sortTable[0x9971]=1210;   // bao
   sortTable[0x98FD]=1211;   // bao
   sortTable[0x8584]=1212;   // bao
   sortTable[0x5821]=1213;   // bao
   sortTable[0x8C79]=1214;   // bao
   sortTable[0x96F9]=1215;   // bao
   sortTable[0x9C8D]=1216;   // bao
   sortTable[0x8912]=1217;   // bao
   sortTable[0x82DE]=1218;   // bao
   sortTable[0x9E28]=1219;   // bao
   sortTable[0x8446]=1220;   // bao
   sortTable[0x7172]=1221;   // bao
   sortTable[0x9F85]=1222;   // bao
   sortTable[0x5B62]=1223;   // bao
   sortTable[0x8913]=1224;   // bao
   sortTable[0x8DB5]=1225;   // bao
   sortTable[0x8663]=1226;   // bao
   sortTable[0x94C7]=1227;   // bao
   sortTable[0x888C]=1228;   // bao
   sortTable[0x83E2]=1229;   // bao
   sortTable[0x8CF2]=1230;   // bao
   sortTable[0x7A87]=1231;   // bao
   sortTable[0x7B23]=1232;   // bao
   sortTable[0x9AB2]=1233;   // bao
   sortTable[0x9AF1]=1234;   // bao
   sortTable[0x7DE5]=1235;   // bao
   sortTable[0x85F5]=1236;   // bao
   sortTable[0x9464]=1237;   // bao
   sortTable[0x9764]=1238;   // bao
   sortTable[0x9B91]=1239;   // bao
   sortTable[0x9CF5]=1240;   // bao
   sortTable[0x4F68]=1241;   // bao
   sortTable[0x5124]=1242;   // bao
   sortTable[0x52F9]=1243;   // bao
   sortTable[0x52FD]=1244;   // bao
   sortTable[0x5822]=1245;   // bao
   sortTable[0x5AAC]=1246;   // bao
   sortTable[0x5AD1]=1247;   // bao
   sortTable[0x5BB2]=1248;   // bao
   sortTable[0x5BDA]=1249;   // bao
   sortTable[0x5BF3]=1250;   // bao
   sortTable[0x5FC1]=1251;   // bao
   sortTable[0x6009]=1252;   // bao
   sortTable[0x66D3]=1253;   // bao
   sortTable[0x67B9]=1254;   // bao
   sortTable[0x73E4]=1255;   // bao
   sortTable[0x8554]=1256;   // bao
   sortTable[0x86AB]=1257;   // bao
   sortTable[0x8943]=1258;   // bao
   sortTable[0x924B]=1259;   // bao
   sortTable[0x95C1]=1260;   // bao
   sortTable[0x974C]=1261;   // bao
   sortTable[0x99C2]=1262;   // bao
   sortTable[0x9D07]=1263;   // bao
   sortTable[0x9E14]=1264;   // bao
   sortTable[0x9F59]=1265;   // bao
   sortTable[0x88AB]=1266;   // bei
   sortTable[0x5907]=1267;   // bei
   sortTable[0x5099]=1268;   // bei
   sortTable[0x5317]=1269;   // bei
   sortTable[0x80CC]=1270;   // bei
   sortTable[0x500D]=1271;   // bei
   sortTable[0x60B2]=1272;   // bei
   sortTable[0x676F]=1273;   // bei
   sortTable[0x8F88]=1274;   // bei
   sortTable[0x8F29]=1275;   // bei
   sortTable[0x7891]=1276;   // bei
   sortTable[0x8D1D]=1277;   // bei
   sortTable[0x8C9D]=1278;   // bei
   sortTable[0x5457]=1279;   // bei
   sortTable[0x5504]=1280;   // bei
   sortTable[0x5351]=1281;   // bei
   sortTable[0x72C8]=1282;   // bei
   sortTable[0x72FD]=1283;   // bei
   sortTable[0x6096]=1284;   // bei
   sortTable[0x60EB]=1285;   // bei
   sortTable[0x94A1]=1286;   // bei
   sortTable[0x5B5B]=1287;   // bei
   sortTable[0x7119]=1288;   // bei
   sortTable[0x9642]=1289;   // bei
   sortTable[0x97B4]=1290;   // bei
   sortTable[0x84D3]=1291;   // bei
   sortTable[0x943E]=1292;   // bei
   sortTable[0x789A]=1293;   // bei
   sortTable[0x9E4E]=1294;   // bei
   sortTable[0x8919]=1295;   // bei
   sortTable[0x90B6]=1296;   // bei
   sortTable[0x8A96]=1297;   // bei
   sortTable[0x7986]=1298;   // bei
   sortTable[0x7CD2]=1299;   // bei
   sortTable[0x90E5]=1300;   // bei
   sortTable[0x9AB3]=1301;   // bei
   sortTable[0x9101]=1302;   // bei
   sortTable[0x9303]=1303;   // bei
   sortTable[0x9781]=1304;   // bei
   sortTable[0x85E3]=1305;   // bei
   sortTable[0x92C7]=1306;   // bei
   sortTable[0x4FFB]=1307;   // bei
   sortTable[0x505D]=1308;   // bei
   sortTable[0x5079]=1309;   // bei
   sortTable[0x50C3]=1310;   // bei
   sortTable[0x6102]=1311;   // bei
   sortTable[0x618A]=1312;   // bei
   sortTable[0x63F9]=1313;   // bei
   sortTable[0x6601]=1314;   // bei
   sortTable[0x686E]=1315;   // bei
   sortTable[0x6896]=1316;   // bei
   sortTable[0x6911]=1317;   // bei
   sortTable[0x726C]=1318;   // bei
   sortTable[0x7295]=1319;   // bei
   sortTable[0x73FC]=1320;   // bei
   sortTable[0x7432]=1321;   // bei
   sortTable[0x76C3]=1322;   // bei
   sortTable[0x7999]=1323;   // bei
   sortTable[0x82DD]=1324;   // bei
   sortTable[0x8EF0]=1325;   // bei
   sortTable[0x9273]=1326;   // bei
   sortTable[0x9D6F]=1327;   // bei
   sortTable[0x672C]=1328;   // ben
   sortTable[0x5954]=1329;   // ben
   sortTable[0x7B28]=1330;   // ben
   sortTable[0x8D32]=1331;   // ben
   sortTable[0x82EF]=1332;   // ben
   sortTable[0x755A]=1333;   // ben
   sortTable[0x951B]=1334;   // ben
   sortTable[0x574C]=1335;   // ben
   sortTable[0x7FC9]=1336;   // ben
   sortTable[0x8F3D]=1337;   // ben
   sortTable[0x5034]=1338;   // ben
   sortTable[0x574B]=1339;   // ben
   sortTable[0x5959]=1340;   // ben
   sortTable[0x6379]=1341;   // ben
   sortTable[0x64AA]=1342;   // ben
   sortTable[0x681F]=1343;   // ben
   sortTable[0x6873]=1344;   // ben
   sortTable[0x694D]=1345;   // ben
   sortTable[0x6CCD]=1346;   // ben
   sortTable[0x6E00]=1347;   // ben
   sortTable[0x7287]=1348;   // ben
   sortTable[0x7356]=1349;   // ben
   sortTable[0x9029]=1350;   // ben
   sortTable[0x931B]=1351;   // ben
   sortTable[0x752D]=1352;   // beng
   sortTable[0x8E66]=1353;   // beng
   sortTable[0x5D29]=1354;   // beng
   sortTable[0x7EF7]=1355;   // beng
   sortTable[0x7E43]=1356;   // beng
   sortTable[0x6CF5]=1357;   // beng
   sortTable[0x8FF8]=1358;   // beng
   sortTable[0x5623]=1359;   // beng
   sortTable[0x750F]=1360;   // beng
   sortTable[0x83F6]=1361;   // beng
   sortTable[0x794A]=1362;   // beng
   sortTable[0x7D63]=1363;   // beng
   sortTable[0x93F0]=1364;   // beng
   sortTable[0x979B]=1365;   // beng
   sortTable[0x955A]=1366;   // beng
   sortTable[0x882F]=1367;   // beng
   sortTable[0x958D]=1368;   // beng
   sortTable[0x4F3B]=1369;   // beng
   sortTable[0x50B0]=1370;   // beng
   sortTable[0x57C4]=1371;   // beng
   sortTable[0x57F2]=1372;   // beng
   sortTable[0x5874]=1373;   // beng
   sortTable[0x595F]=1374;   // beng
   sortTable[0x5D6D]=1375;   // beng
   sortTable[0x63FC]=1376;   // beng
   sortTable[0x7423]=1377;   // beng
   sortTable[0x742B]=1378;   // beng
   sortTable[0x75ED]=1379;   // beng
   sortTable[0x7DB3]=1380;   // beng
   sortTable[0x902C]=1381;   // beng
   sortTable[0x6BD4]=1382;   // bi
   sortTable[0x5FC5]=1383;   // bi
   sortTable[0x7B14]=1384;   // bi
   sortTable[0x7B46]=1385;   // bi
   sortTable[0x9F3B]=1386;   // bi
   sortTable[0x907F]=1387;   // bi
   sortTable[0x6BD5]=1388;   // bi
   sortTable[0x58C1]=1389;   // bi
   sortTable[0x7562]=1390;   // bi
   sortTable[0x95ED]=1391;   // bi
   sortTable[0x9589]=1392;   // bi
   sortTable[0x903C]=1393;   // bi
   sortTable[0x81C2]=1394;   // bi
   sortTable[0x5F7C]=1395;   // bi
   sortTable[0x853D]=1396;   // bi
   sortTable[0x5E01]=1397;   // bi
   sortTable[0x5E63]=1398;   // bi
   sortTable[0x78A7]=1399;   // bi
   sortTable[0x6BD9]=1400;   // bi
   sortTable[0x6583]=1401;   // bi
   sortTable[0x9119]=1402;   // bi
   sortTable[0x75F9]=1403;   // bi
   sortTable[0x75FA]=1404;   // bi
   sortTable[0x965B]=1405;   // bi
   sortTable[0x5F0A]=1406;   // bi
   sortTable[0x5A62]=1407;   // bi
   sortTable[0x5F3C]=1408;   // bi
   sortTable[0x655D]=1409;   // bi
   sortTable[0x5E87]=1410;   // bi
   sortTable[0x74A7]=1411;   // bi
   sortTable[0x4FFE]=1412;   // bi
   sortTable[0x88E8]=1413;   // bi
   sortTable[0x5315]=1414;   // bi
   sortTable[0x8DF8]=1415;   // bi
   sortTable[0x5B16]=1416;   // bi
   sortTable[0x84D6]=1417;   // bi
   sortTable[0x6BD6]=1418;   // bi
   sortTable[0x9AC0]=1419;   // bi
   sortTable[0x859C]=1420;   // bi
   sortTable[0x610E]=1421;   // bi
   sortTable[0x5421]=1422;   // bi
   sortTable[0x7540]=1423;   // bi
   sortTable[0x59A3]=1424;   // bi
   sortTable[0x8406]=1425;   // bi
   sortTable[0x82FE]=1426;   // bi
   sortTable[0x7BE6]=1427;   // bi
   sortTable[0x822D]=1428;   // bi
   sortTable[0x835C]=1429;   // bi
   sortTable[0x895E]=1430;   // bi
   sortTable[0x6FDE]=1431;   // bi
   sortTable[0x54D4]=1432;   // bi
   sortTable[0x959F]=1433;   // bi
   sortTable[0x8BD0]=1434;   // bi
   sortTable[0x5EB3]=1435;   // bi
   sortTable[0x7B5A]=1436;   // bi
   sortTable[0x79D5]=1437;   // bi
   sortTable[0x89F1]=1438;   // bi
   sortTable[0x90B2]=1439;   // bi
   sortTable[0x72F4]=1440;   // bi
   sortTable[0x94CB]=1441;   // bi
   sortTable[0x8378]=1442;   // bi
   sortTable[0x8E84]=1443;   // bi
   sortTable[0x99DC]=1444;   // bi
   sortTable[0x7C83]=1445;   // bi
   sortTable[0x98F6]=1446;   // bi
   sortTable[0x7C8A]=1447;   // bi
   sortTable[0x805B]=1448;   // bi
   sortTable[0x7F7C]=1449;   // bi
   sortTable[0x97E0]=1450;   // bi
   sortTable[0x7B84]=1451;   // bi
   sortTable[0x7B85]=1452;   // bi
   sortTable[0x8795]=1453;   // bi
   sortTable[0x6ED7]=1454;   // bi
   sortTable[0x7DBC]=1455;   // bi
   sortTable[0x8C8F]=1456;   // bi
   sortTable[0x912A]=1457;   // bi
   sortTable[0x7E2A]=1458;   // bi
   sortTable[0x9DE9]=1459;   // bi
   sortTable[0x8D51]=1460;   // bi
   sortTable[0x97B8]=1461;   // bi
   sortTable[0x9AF2]=1462;   // bi
   sortTable[0x84FD]=1463;   // bi
   sortTable[0x9A46]=1464;   // bi
   sortTable[0x9F0A]=1465;   // bi
   sortTable[0x870C]=1466;   // bi
   sortTable[0x8890]=1467;   // bi
   sortTable[0x8A56]=1468;   // bi
   sortTable[0x9128]=1469;   // bi
   sortTable[0x7B13]=1470;   // bi
   sortTable[0x8177]=1471;   // bi
   sortTable[0x7E74]=1472;   // bi
   sortTable[0x8E83]=1473;   // bi
   sortTable[0x9946]=1474;   // bi
   sortTable[0x9CBE]=1475;   // bi
   sortTable[0x939E]=1476;   // bi
   sortTable[0x9B85]=1477;   // bi
   sortTable[0x7BF3]=1478;   // bi
   sortTable[0x8CC1]=1479;   // bi
   sortTable[0x8D14]=1480;   // bi
   sortTable[0x8E55]=1481;   // bi
   sortTable[0x924D]=1482;   // bi
   sortTable[0x9434]=1483;   // bi
   sortTable[0x999D]=1484;   // bi
   sortTable[0x4F4A]=1485;   // bi
   sortTable[0x4F56]=1486;   // bi
   sortTable[0x506A]=1487;   // bi
   sortTable[0x5302]=1488;   // bi
   sortTable[0x555A]=1489;   // bi
   sortTable[0x55F6]=1490;   // bi
   sortTable[0x5752]=1491;   // bi
   sortTable[0x581B]=1492;   // bi
   sortTable[0x5936]=1493;   // bi
   sortTable[0x5970]=1494;   // bi
   sortTable[0x59BC]=1495;   // bi
   sortTable[0x5B36]=1496;   // bi
   sortTable[0x5C44]=1497;   // bi
   sortTable[0x5E64]=1498;   // bi
   sortTable[0x5EE6]=1499;   // bi
   sortTable[0x5F3B]=1500;   // bi
   sortTable[0x5F43]=1501;   // bi
   sortTable[0x602D]=1502;   // bi
   sortTable[0x6036]=1503;   // bi
   sortTable[0x610A]=1504;   // bi
   sortTable[0x673C]=1505;   // bi
   sortTable[0x6788]=1506;   // bi
   sortTable[0x67C0]=1507;   // bi
   sortTable[0x67F2]=1508;   // bi
   sortTable[0x6890]=1509;   // bi
   sortTable[0x6945]=1510;   // bi
   sortTable[0x6BF4]=1511;   // bi
   sortTable[0x6C98]=1512;   // bi
   sortTable[0x6E62]=1513;   // bi
   sortTable[0x6EED]=1514;   // bi
   sortTable[0x6F77]=1515;   // bi
   sortTable[0x714F]=1516;   // bi
   sortTable[0x719A]=1517;   // bi
   sortTable[0x7358]=1518;   // bi
   sortTable[0x7359]=1519;   // bi
   sortTable[0x73CC]=1520;   // bi
   sortTable[0x7595]=1521;   // bi
   sortTable[0x75AA]=1522;   // bi
   sortTable[0x7695]=1523;   // bi
   sortTable[0x7764]=1524;   // bi
   sortTable[0x7B86]=1525;   // bi
   sortTable[0x841E]=1526;   // bi
   sortTable[0x8945]=1527;   // bi
   sortTable[0x8963]=1528;   // bi
   sortTable[0x8C4D]=1529;   // bi
   sortTable[0x8CB1]=1530;   // bi
   sortTable[0x93CE]=1531;   // bi
   sortTable[0x9587]=1532;   // bi
   sortTable[0x9B53]=1533;   // bi
   sortTable[0x9C0F]=1534;   // bi
   sortTable[0x9D56]=1535;   // bi
   sortTable[0x9DDD]=1536;   // bi
   sortTable[0x8FB9]=1537;   // bian
   sortTable[0x908A]=1538;   // bian
   sortTable[0x53D8]=1539;   // bian
   sortTable[0x8B8A]=1540;   // bian
   sortTable[0x4FBF]=1541;   // bian
   sortTable[0x904D]=1542;   // bian
   sortTable[0x7F16]=1543;   // bian
   sortTable[0x7DE8]=1544;   // bian
   sortTable[0x8FA9]=1545;   // bian
   sortTable[0x8FAF]=1546;   // bian
   sortTable[0x6241]=1547;   // bian
   sortTable[0x8FAB]=1548;   // bian
   sortTable[0x8FAE]=1549;   // bian
   sortTable[0x8FA8]=1550;   // bian
   sortTable[0x97AD]=1551;   // bian
   sortTable[0x533E]=1552;   // bian
   sortTable[0x8759]=1553;   // bian
   sortTable[0x8D2C]=1554;   // bian
   sortTable[0x6C74]=1555;   // bian
   sortTable[0x5F01]=1556;   // bian
   sortTable[0x7B3E]=1557;   // bian
   sortTable[0x535E]=1558;   // bian
   sortTable[0x82C4]=1559;   // bian
   sortTable[0x782D]=1560;   // bian
   sortTable[0x7178]=1561;   // bian
   sortTable[0x7A86]=1562;   // bian
   sortTable[0x890A]=1563;   // bian
   sortTable[0x5FED]=1564;   // bian
   sortTable[0x7F0F]=1565;   // bian
   sortTable[0x9CCA]=1566;   // bian
   sortTable[0x78A5]=1567;   // bian
   sortTable[0x91C6]=1568;   // bian
   sortTable[0x85CA]=1569;   // bian
   sortTable[0x8251]=1570;   // bian
   sortTable[0x7BAF]=1571;   // bian
   sortTable[0x9089]=1572;   // bian
   sortTable[0x898D]=1573;   // bian
   sortTable[0x9BFE]=1574;   // bian
   sortTable[0x9D18]=1575;   // bian
   sortTable[0x7DF6]=1576;   // bian
   sortTable[0x959E]=1577;   // bian
   sortTable[0x8439]=1578;   // bian
   sortTable[0x5325]=1579;   // bian
   sortTable[0x5909]=1580;   // bian
   sortTable[0x5CC5]=1581;   // bian
   sortTable[0x5FA7]=1582;   // bian
   sortTable[0x60FC]=1583;   // bian
   sortTable[0x6283]=1584;   // bian
   sortTable[0x63D9]=1585;   // bian
   sortTable[0x662A]=1586;   // bian
   sortTable[0x6C73]=1587;   // bian
   sortTable[0x709E]=1588;   // bian
   sortTable[0x7251]=1589;   // bian
   sortTable[0x7335]=1590;   // bian
   sortTable[0x73A3]=1591;   // bian
   sortTable[0x7502]=1592;   // bian
   sortTable[0x7A28]=1593;   // bian
   sortTable[0x7C69]=1594;   // bian
   sortTable[0x7CC4]=1595;   // bian
   sortTable[0x8CB6]=1596;   // bian
   sortTable[0x8FA1]=1597;   // bian
   sortTable[0x8FA7]=1598;   // bian
   sortTable[0x8FBA]=1599;   // bian
   sortTable[0x937D]=1600;   // bian
   sortTable[0x9BFF]=1601;   // bian
   sortTable[0x8868]=1602;   // biao
   sortTable[0x6807]=1603;   // biao
   sortTable[0x6A19]=1604;   // biao
   sortTable[0x5F6A]=1605;   // biao
   sortTable[0x9556]=1606;   // biao
   sortTable[0x9AA0]=1607;   // biao
   sortTable[0x9ADF]=1608;   // biao
   sortTable[0x5A4A]=1609;   // biao
   sortTable[0x98D9]=1610;   // biao
   sortTable[0x88F1]=1611;   // biao
   sortTable[0x6753]=1612;   // biao
   sortTable[0x9573]=1613;   // biao
   sortTable[0x98DA]=1614;   // biao
   sortTable[0x8198]=1615;   // biao
   sortTable[0x893E]=1616;   // biao
   sortTable[0x9CD4]=1617;   // biao
   sortTable[0x8D06]=1618;   // biao
   sortTable[0x98D1]=1619;   // biao
   sortTable[0x85E8]=1620;   // biao
   sortTable[0x813F]=1621;   // biao
   sortTable[0x81D5]=1622;   // biao
   sortTable[0x78E6]=1623;   // biao
   sortTable[0x762D]=1624;   // biao
   sortTable[0x8508]=1625;   // biao
   sortTable[0x8AD8]=1626;   // biao
   sortTable[0x98C6]=1627;   // biao
   sortTable[0x93E2]=1628;   // biao
   sortTable[0x9463]=1629;   // biao
   sortTable[0x98A9]=1630;   // biao
   sortTable[0x9A43]=1631;   // biao
   sortTable[0x9C3E]=1632;   // biao
   sortTable[0x4FF5]=1633;   // biao
   sortTable[0x5126]=1634;   // biao
   sortTable[0x5882]=1635;   // biao
   sortTable[0x5E56]=1636;   // biao
   sortTable[0x647D]=1637;   // biao
   sortTable[0x6AA6]=1638;   // biao
   sortTable[0x6DF2]=1639;   // biao
   sortTable[0x6EEE]=1640;   // biao
   sortTable[0x700C]=1641;   // biao
   sortTable[0x706C]=1642;   // biao
   sortTable[0x719B]=1643;   // biao
   sortTable[0x7202]=1644;   // biao
   sortTable[0x730B]=1645;   // biao
   sortTable[0x7A6E]=1646;   // biao
   sortTable[0x8B24]=1647;   // biao
   sortTable[0x9336]=1648;   // biao
   sortTable[0x98AE]=1649;   // biao
   sortTable[0x98B7]=1650;   // biao
   sortTable[0x98C7]=1651;   // biao
   sortTable[0x98C8]=1652;   // biao
   sortTable[0x98CA]=1653;   // biao
   sortTable[0x9A6B]=1654;   // biao
   sortTable[0x9A89]=1655;   // biao
   sortTable[0x522B]=1656;   // bie
   sortTable[0x5225]=1657;   // bie
   sortTable[0x618B]=1658;   // bie
   sortTable[0x762A]=1659;   // bie
   sortTable[0x765F]=1660;   // bie
   sortTable[0x9CD6]=1661;   // bie
   sortTable[0x8E69]=1662;   // bie
   sortTable[0x9F08]=1663;   // bie
   sortTable[0x8952]=1664;   // bie
   sortTable[0x9C49]=1665;   // bie
   sortTable[0x87DE]=1666;   // bie
   sortTable[0x8382]=1667;   // bie
   sortTable[0x86C2]=1668;   // bie
   sortTable[0x5487]=1669;   // bie
   sortTable[0x5F46]=1670;   // bie
   sortTable[0x5FB6]=1671;   // bie
   sortTable[0x864C]=1672;   // bie
   sortTable[0x9F9E]=1673;   // bie
   sortTable[0x6EE8]=1674;   // bin
   sortTable[0x6FF1]=1675;   // bin
   sortTable[0x5BBE]=1676;   // bin
   sortTable[0x8CD3]=1677;   // bin
   sortTable[0x658C]=1678;   // bin
   sortTable[0x5F6C]=1679;   // bin
   sortTable[0x9B13]=1680;   // bin
   sortTable[0x6BA1]=1681;   // bin
   sortTable[0x6FD2]=1682;   // bin
   sortTable[0x90A0]=1683;   // bin
   sortTable[0x7F24]=1684;   // bin
   sortTable[0x6448]=1685;   // bin
   sortTable[0x69DF]=1686;   // bin
   sortTable[0x50A7]=1687;   // bin
   sortTable[0x8191]=1688;   // bin
   sortTable[0x9ACC]=1689;   // bin
   sortTable[0x8C73]=1690;   // bin
   sortTable[0x73A2]=1691;   // bin
   sortTable[0x9554]=1692;   // bin
   sortTable[0x9AE9]=1693;   // bin
   sortTable[0x9B02]=1694;   // bin
   sortTable[0x9726]=1695;   // bin
   sortTable[0x81CF]=1696;   // bin
   sortTable[0x780F]=1697;   // bin
   sortTable[0x9AD5]=1698;   // bin
   sortTable[0x8CD4]=1699;   // bin
   sortTable[0x986E]=1700;   // bin
   sortTable[0x9B22]=1701;   // bin
   sortTable[0x5110]=1702;   // bin
   sortTable[0x64EF]=1703;   // bin
   sortTable[0x68B9]=1704;   // bin
   sortTable[0x6915]=1705;   // bin
   sortTable[0x6AB3]=1706;   // bin
   sortTable[0x6BAF]=1707;   // bin
   sortTable[0x6C1E]=1708;   // bin
   sortTable[0x6C43]=1709;   // bin
   sortTable[0x6FF5]=1710;   // bin
   sortTable[0x7015]=1711;   // bin
   sortTable[0x7478]=1712;   // bin
   sortTable[0x74B8]=1713;   // bin
   sortTable[0x7E7D]=1714;   // bin
   sortTable[0x8668]=1715;   // bin
   sortTable[0x8C69]=1716;   // bin
   sortTable[0x944C]=1717;   // bin
   sortTable[0x5E76]=1718;   // bing
   sortTable[0x75C5]=1719;   // bing
   sortTable[0x5175]=1720;   // bing
   sortTable[0x51B0]=1721;   // bing
   sortTable[0x997C]=1722;   // bing
   sortTable[0x9905]=1723;   // bing
   sortTable[0x4E19]=1724;   // bing
   sortTable[0x67C4]=1725;   // bing
   sortTable[0x7980]=1726;   // bing
   sortTable[0x79C9]=1727;   // bing
   sortTable[0x70B3]=1728;   // bing
   sortTable[0x6452]=1729;   // bing
   sortTable[0x90B4]=1730;   // bing
   sortTable[0x979E]=1731;   // bing
   sortTable[0x9235]=1732;   // bing
   sortTable[0x7A1F]=1733;   // bing
   sortTable[0x7ADD]=1734;   // bing
   sortTable[0x927C]=1735;   // bing
   sortTable[0x9786]=1736;   // bing
   sortTable[0x92F2]=1737;   // bing
   sortTable[0x7A89]=1738;   // bing
   sortTable[0x82EA]=1739;   // bing
   sortTable[0x772A]=1740;   // bing
   sortTable[0x4E26]=1741;   // bing
   sortTable[0x4ECC]=1742;   // bing
   sortTable[0x4ED2]=1743;   // bing
   sortTable[0x4F75]=1744;   // bing
   sortTable[0x5002]=1745;   // bing
   sortTable[0x504B]=1746;   // bing
   sortTable[0x50A1]=1747;   // bing
   sortTable[0x51AB]=1748;   // bing
   sortTable[0x57AA]=1749;   // bing
   sortTable[0x5BCE]=1750;   // bing
   sortTable[0x5E77]=1751;   // bing
   sortTable[0x5EB0]=1752;   // bing
   sortTable[0x6032]=1753;   // bing
   sortTable[0x62A6]=1754;   // bing
   sortTable[0x63A4]=1755;   // bing
   sortTable[0x661E]=1756;   // bing
   sortTable[0x663A]=1757;   // bing
   sortTable[0x6824]=1758;   // bing
   sortTable[0x68C5]=1759;   // bing
   sortTable[0x6C37]=1760;   // bing
   sortTable[0x86C3]=1761;   // bing
   sortTable[0x8A81]=1762;   // bing
   sortTable[0x9643]=1763;   // bing
   sortTable[0x9750]=1764;   // bing
   sortTable[0x9920]=1765;   // bing
   sortTable[0x9BA9]=1766;   // bing
   sortTable[0x73BB]=1767;   // bo
   sortTable[0x5265]=1768;   // bo
   sortTable[0x525D]=1769;   // bo
   sortTable[0x64AD]=1770;   // bo
   sortTable[0x4F2F]=1771;   // bo
   sortTable[0x535A]=1772;   // bo
   sortTable[0x6CE2]=1773;   // bo
   sortTable[0x8116]=1774;   // bo
   sortTable[0x62E8]=1775;   // bo
   sortTable[0x64A5]=1776;   // bo
   sortTable[0x52C3]=1777;   // bo
   sortTable[0x818A]=1778;   // bo
   sortTable[0x9A73]=1779;   // bo
   sortTable[0x640F]=1780;   // bo
   sortTable[0x99C1]=1781;   // bo
   sortTable[0x535C]=1782;   // bo
   sortTable[0x7C38]=1783;   // bo
   sortTable[0x8236]=1784;   // bo
   sortTable[0x8DDB]=1785;   // bo
   sortTable[0x5E1B]=1786;   // bo
   sortTable[0x5575]=1787;   // bo
   sortTable[0x6E24]=1788;   // bo
   sortTable[0x94B5]=1789;   // bo
   sortTable[0x4EB3]=1790;   // bo
   sortTable[0x997D]=1791;   // bo
   sortTable[0x7B94]=1792;   // bo
   sortTable[0x9E41]=1793;   // bo
   sortTable[0x83E0]=1794;   // bo
   sortTable[0x9548]=1795;   // bo
   sortTable[0x94B9]=1796;   // bo
   sortTable[0x8E23]=1797;   // bo
   sortTable[0x7934]=1798;   // bo
   sortTable[0x94C2]=1799;   // bo
   sortTable[0x6A97]=1800;   // bo
   sortTable[0x99EE]=1801;   // bo
   sortTable[0x999B]=1802;   // bo
   sortTable[0x9AC6]=1803;   // bo
   sortTable[0x896E]=1804;   // bo
   sortTable[0x939B]=1805;   // bo
   sortTable[0x7F3D]=1806;   // bo
   sortTable[0x889A]=1807;   // bo
   sortTable[0x8B52]=1808;   // bo
   sortTable[0x8467]=1809;   // bo
   sortTable[0x7921]=1810;   // bo
   sortTable[0x998E]=1811;   // bo
   sortTable[0x7886]=1812;   // bo
   sortTable[0x7C19]=1813;   // bo
   sortTable[0x7D34]=1814;   // bo
   sortTable[0x80C9]=1815;   // bo
   sortTable[0x946E]=1816;   // bo
   sortTable[0x8514]=1817;   // bo
   sortTable[0x88AF]=1818;   // bo
   sortTable[0x7BA5]=1819;   // bo
   sortTable[0x88B9]=1820;   // bo
   sortTable[0x9A4B]=1821;   // bo
   sortTable[0x9B81]=1822;   // bo
   sortTable[0x8E73]=1823;   // bo
   sortTable[0x9238]=1824;   // bo
   sortTable[0x92CD]=1825;   // bo
   sortTable[0x7CEA]=1826;   // bo
   sortTable[0x824A]=1827;   // bo
   sortTable[0x8421]=1828;   // bo
   sortTable[0x8617]=1829;   // bo
   sortTable[0x8C70]=1830;   // bo
   sortTable[0x9AC9]=1831;   // bo
   sortTable[0x4EE2]=1832;   // bo
   sortTable[0x4FBC]=1833;   // bo
   sortTable[0x50E0]=1834;   // bo
   sortTable[0x50F0]=1835;   // bo
   sortTable[0x54F1]=1836;   // bo
   sortTable[0x5697]=1837;   // bo
   sortTable[0x5B79]=1838;   // bo
   sortTable[0x5D93]=1839;   // bo
   sortTable[0x5E17]=1840;   // bo
   sortTable[0x613D]=1841;   // bo
   sortTable[0x61EA]=1842;   // bo
   sortTable[0x632C]=1843;   // bo
   sortTable[0x6B02]=1844;   // bo
   sortTable[0x6D61]=1845;   // bo
   sortTable[0x717F]=1846;   // bo
   sortTable[0x7254]=1847;   // bo
   sortTable[0x72A6]=1848;   // bo
   sortTable[0x72BB]=1849;   // bo
   sortTable[0x72DB]=1850;   // bo
   sortTable[0x733C]=1851;   // bo
   sortTable[0x74DD]=1852;   // bo
   sortTable[0x74DF]=1853;   // bo
   sortTable[0x7676]=1854;   // bo
   sortTable[0x7677]=1855;   // bo
   sortTable[0x76CB]=1856;   // bo
   sortTable[0x7835]=1857;   // bo
   sortTable[0x79E1]=1858;   // bo
   sortTable[0x8091]=1859;   // bo
   sortTable[0x82E9]=1860;   // bo
   sortTable[0x88B0]=1861;   // bo
   sortTable[0x894F]=1862;   // bo
   sortTable[0x90E3]=1863;   // bo
   sortTable[0x9251]=1864;   // bo
   sortTable[0x9262]=1865;   // bo
   sortTable[0x9911]=1866;   // bo
   sortTable[0x993A]=1867;   // bo
   sortTable[0x999E]=1868;   // bo
   sortTable[0x9C4D]=1869;   // bo
   sortTable[0x9D53]=1870;   // bo
   sortTable[0x4E0D]=1871;   // bu
   sortTable[0x90E8]=1872;   // bu
   sortTable[0x6B65]=1873;   // bu
   sortTable[0x5E03]=1874;   // bu
   sortTable[0x8865]=1875;   // bu
   sortTable[0x88DC]=1876;   // bu
   sortTable[0x6355]=1877;   // bu
   sortTable[0x6016]=1878;   // bu
   sortTable[0x54FA]=1879;   // bu
   sortTable[0x57E0]=1880;   // bu
   sortTable[0x7C3F]=1881;   // bu
   sortTable[0x57D4]=1882;   // bu
   sortTable[0x900B]=1883;   // bu
   sortTable[0x6661]=1884;   // bu
   sortTable[0x949A]=1885;   // bu
   sortTable[0x535F]=1886;   // bu
   sortTable[0x91AD]=1887;   // bu
   sortTable[0x74FF]=1888;   // bu
   sortTable[0x8500]=1889;   // bu
   sortTable[0x9914]=1890;   // bu
   sortTable[0x94B8]=1891;   // bu
   sortTable[0x7BF0]=1892;   // bu
   sortTable[0x9CEA]=1893;   // bu
   sortTable[0x8AA7]=1894;   // bu
   sortTable[0x8E04]=1895;   // bu
   sortTable[0x923D]=1896;   // bu
   sortTable[0x8379]=1897;   // bu
   sortTable[0x8F50]=1898;   // bu
   sortTable[0x9D4F]=1899;   // bu
   sortTable[0x4F48]=1900;   // bu
   sortTable[0x52CF]=1901;   // bu
   sortTable[0x5425]=1902;   // bu
   sortTable[0x5498]=1903;   // bu
   sortTable[0x55B8]=1904;   // bu
   sortTable[0x57D7]=1905;   // bu
   sortTable[0x5CEC]=1906;   // bu
   sortTable[0x5EAF]=1907;   // bu
   sortTable[0x6091]=1908;   // bu
   sortTable[0x62AA]=1909;   // bu
   sortTable[0x6357]=1910;   // bu
   sortTable[0x67E8]=1911;   // bu
   sortTable[0x6B68]=1912;   // bu
   sortTable[0x6B69]=1913;   // bu
   sortTable[0x90F6]=1914;   // bu
   sortTable[0x9922]=1915;   // bu
   sortTable[0x64E6]=2304;   // ca
   sortTable[0x5693]=2305;   // ca
   sortTable[0x7924]=2306;   // ca
   sortTable[0x56C3]=2307;   // ca
   sortTable[0x6503]=2308;   // ca
   sortTable[0x906A]=2309;   // ca
   sortTable[0x624D]=2310;   // cai
   sortTable[0x6750]=2311;   // cai
   sortTable[0x91C7]=2312;   // cai
   sortTable[0x83DC]=2313;   // cai
   sortTable[0x8D22]=2314;   // cai
   sortTable[0x8CA1]=2315;   // cai
   sortTable[0x5F69]=2316;   // cai
   sortTable[0x731C]=2317;   // cai
   sortTable[0x8E29]=2318;   // cai
   sortTable[0x88C1]=2319;   // cai
   sortTable[0x8521]=2320;   // cai
   sortTable[0x776C]=2321;   // cai
   sortTable[0x7E94]=2322;   // cai
   sortTable[0x7DB5]=2323;   // cai
   sortTable[0x8DF4]=2324;   // cai
   sortTable[0x7E29]=2325;   // cai
   sortTable[0x5038]=2326;   // cai
   sortTable[0x5072]=2327;   // cai
   sortTable[0x554B]=2328;   // cai
   sortTable[0x57F0]=2329;   // cai
   sortTable[0x5A47]=2330;   // cai
   sortTable[0x5BC0]=2331;   // cai
   sortTable[0x63A1]=2332;   // cai
   sortTable[0x68CC]=2333;   // cai
   sortTable[0x6BDD]=2334;   // cai
   sortTable[0x6EA8]=2335;   // cai
   sortTable[0x72B2]=2336;   // cai
   sortTable[0x53C2]=2337;   // can
   sortTable[0x53C3]=2338;   // can
   sortTable[0x6B8B]=2339;   // can
   sortTable[0x6B98]=2340;   // can
   sortTable[0x8695]=2341;   // can
   sortTable[0x8836]=2342;   // can
   sortTable[0x60E8]=2343;   // can
   sortTable[0x6158]=2344;   // can
   sortTable[0x9910]=2345;   // can
   sortTable[0x707F]=2346;   // can
   sortTable[0x71E6]=2347;   // can
   sortTable[0x60ED]=2348;   // can
   sortTable[0x615A]=2349;   // can
   sortTable[0x7CB2]=2350;   // can
   sortTable[0x63BA]=2351;   // can
   sortTable[0x74A8]=2352;   // can
   sortTable[0x9A96]=2353;   // can
   sortTable[0x5B71]=2354;   // can
   sortTable[0x9EEA]=2355;   // can
   sortTable[0x7BF8]=2356;   // can
   sortTable[0x98E1]=2357;   // can
   sortTable[0x7A47]=2358;   // can
   sortTable[0x9A42]=2359;   // can
   sortTable[0x50AA]=2360;   // can
   sortTable[0x510F]=2361;   // can
   sortTable[0x53C4]=2362;   // can
   sortTable[0x53C5]=2363;   // can
   sortTable[0x55B0]=2364;   // can
   sortTable[0x5B20]=2365;   // can
   sortTable[0x5B31]=2366;   // can
   sortTable[0x6159]=2367;   // can
   sortTable[0x61AF]=2368;   // can
   sortTable[0x647B]=2369;   // can
   sortTable[0x6701]=2370;   // can
   sortTable[0x6E4C]=2371;   // can
   sortTable[0x6FAF]=2372;   // can
   sortTable[0x7218]=2373;   // can
   sortTable[0x8592]=2374;   // can
   sortTable[0x8745]=2375;   // can
   sortTable[0x883A]=2376;   // can
   sortTable[0x8B32]=2377;   // can
   sortTable[0x9EF2]=2378;   // can
   sortTable[0x85CF]=2379;   // cang
   sortTable[0x8231]=2380;   // cang
   sortTable[0x8259]=2381;   // cang
   sortTable[0x82CD]=2382;   // cang
   sortTable[0x84BC]=2383;   // cang
   sortTable[0x4ED3]=2384;   // cang
   sortTable[0x5009]=2385;   // cang
   sortTable[0x6CA7]=2386;   // cang
   sortTable[0x4F27]=2387;   // cang
   sortTable[0x9E27]=2388;   // cang
   sortTable[0x9DAC]=2389;   // cang
   sortTable[0x7F49]=2390;   // cang
   sortTable[0x8CF6]=2391;   // cang
   sortTable[0x87A5]=2392;   // cang
   sortTable[0x4EFA]=2393;   // cang
   sortTable[0x5096]=2394;   // cang
   sortTable[0x5D62]=2395;   // cang
   sortTable[0x6B0C]=2396;   // cang
   sortTable[0x6EC4]=2397;   // cang
   sortTable[0x6FF8]=2398;   // cang
   sortTable[0x734A]=2399;   // cang
   sortTable[0x9476]=2400;   // cang
   sortTable[0x8349]=2401;   // cao
   sortTable[0x64CD]=2402;   // cao
   sortTable[0x69FD]=2403;   // cao
   sortTable[0x7CD9]=2404;   // cao
   sortTable[0x5608]=2405;   // cao
   sortTable[0x66F9]=2406;   // cao
   sortTable[0x6F15]=2407;   // cao
   sortTable[0x825A]=2408;   // cao
   sortTable[0x87AC]=2409;   // cao
   sortTable[0x8278]=2410;   // cao
   sortTable[0x808F]=2411;   // cao
   sortTable[0x84F8]=2412;   // cao
   sortTable[0x9135]=2413;   // cao
   sortTable[0x9A32]=2414;   // cao
   sortTable[0x5D86]=2415;   // cao
   sortTable[0x613A]=2416;   // cao
   sortTable[0x61C6]=2417;   // cao
   sortTable[0x64A1]=2418;   // cao
   sortTable[0x66FA]=2419;   // cao
   sortTable[0x8279]=2420;   // cao
   sortTable[0x893F]=2421;   // cao
   sortTable[0x8959]=2422;   // cao
   sortTable[0x93EA]=2423;   // cao
   sortTable[0x7B56]=2424;   // ce
   sortTable[0x6D4B]=2425;   // ce
   sortTable[0x6E2C]=2426;   // ce
   sortTable[0x4FA7]=2427;   // ce
   sortTable[0x5074]=2428;   // ce
   sortTable[0x518C]=2429;   // ce
   sortTable[0x518A]=2430;   // ce
   sortTable[0x5395]=2431;   // ce
   sortTable[0x5EC1]=2432;   // ce
   sortTable[0x607B]=2433;   // ce
   sortTable[0x7B74]=2434;   // ce
   sortTable[0x7CA3]=2435;   // ce
   sortTable[0x84DB]=2436;   // ce
   sortTable[0x7BA3]=2437;   // ce
   sortTable[0x7C0E]=2438;   // ce
   sortTable[0x8417]=2439;   // ce
   sortTable[0x7B27]=2440;   // ce
   sortTable[0x8434]=2441;   // ce
   sortTable[0x53A0]=2442;   // ce
   sortTable[0x5884]=2443;   // ce
   sortTable[0x60FB]=2444;   // ce
   sortTable[0x61A1]=2445;   // ce
   sortTable[0x62FA]=2446;   // ce
   sortTable[0x6547]=2447;   // ce
   sortTable[0x755F]=2448;   // ce
   sortTable[0x7B5E]=2449;   // ce
   sortTable[0x5C91]=2450;   // cen
   sortTable[0x6D94]=2451;   // cen
   sortTable[0x7B12]=2452;   // cen
   sortTable[0x5D7E]=2453;   // cen
   sortTable[0x68A3]=2454;   // cen
   sortTable[0x5C42]=2455;   // ceng
   sortTable[0x5C64]=2456;   // ceng
   sortTable[0x66FE]=2457;   // ceng
   sortTable[0x8E6D]=2458;   // ceng
   sortTable[0x564C]=2459;   // ceng
   sortTable[0x9A53]=2460;   // ceng
   sortTable[0x5D92]=2461;   // ceng
   sortTable[0x66FD]=2462;   // ceng
   sortTable[0x7AF2]=2463;   // ceng
   sortTable[0x67E5]=2464;   // cha
   sortTable[0x5BDF]=2465;   // cha
   sortTable[0x5DEE]=2466;   // cha
   sortTable[0x8336]=2467;   // cha
   sortTable[0x63D2]=2468;   // cha
   sortTable[0x8BE7]=2469;   // cha
   sortTable[0x8A6B]=2470;   // cha
   sortTable[0x53C9]=2471;   // cha
   sortTable[0x5C94]=2472;   // cha
   sortTable[0x9538]=2473;   // cha
   sortTable[0x69CE]=2474;   // cha
   sortTable[0x832C]=2475;   // cha
   sortTable[0x8869]=2476;   // cha
   sortTable[0x59F9]=2477;   // cha
   sortTable[0x643D]=2478;   // cha
   sortTable[0x6748]=2479;   // cha
   sortTable[0x78B4]=2480;   // cha
   sortTable[0x9987]=2481;   // cha
   sortTable[0x6C4A]=2482;   // cha
   sortTable[0x8A67]=2483;   // cha
   sortTable[0x6AAB]=2484;   // cha
   sortTable[0x929F]=2485;   // cha
   sortTable[0x8256]=2486;   // cha
   sortTable[0x79C5]=2487;   // cha
   sortTable[0x81FF]=2488;   // cha
   sortTable[0x8E45]=2489;   // cha
   sortTable[0x7339]=2490;   // cha
   sortTable[0x9572]=2491;   // cha
   sortTable[0x976B]=2492;   // cha
   sortTable[0x809E]=2493;   // cha
   sortTable[0x9364]=2494;   // cha
   sortTable[0x4F98]=2495;   // cha
   sortTable[0x505B]=2496;   // cha
   sortTable[0x55CF]=2497;   // cha
   sortTable[0x579E]=2498;   // cha
   sortTable[0x597C]=2499;   // cha
   sortTable[0x5D56]=2500;   // cha
   sortTable[0x6260]=2501;   // cha
   sortTable[0x633F]=2502;   // cha
   sortTable[0x63F7]=2503;   // cha
   sortTable[0x7580]=2504;   // cha
   sortTable[0x7D01]=2505;   // cha
   sortTable[0x9454]=2506;   // cha
   sortTable[0x9937]=2507;   // cha
   sortTable[0x67F4]=2508;   // chai
   sortTable[0x62C6]=2509;   // chai
   sortTable[0x8C7A]=2510;   // chai
   sortTable[0x9497]=2511;   // chai
   sortTable[0x867F]=2512;   // chai
   sortTable[0x4FAA]=2513;   // chai
   sortTable[0x7625]=2514;   // chai
   sortTable[0x831D]=2515;   // chai
   sortTable[0x8883]=2516;   // chai
   sortTable[0x8A0D]=2517;   // chai
   sortTable[0x7961]=2518;   // chai
   sortTable[0x8806]=2519;   // chai
   sortTable[0x9F5C]=2520;   // chai
   sortTable[0x5115]=2521;   // chai
   sortTable[0x558D]=2522;   // chai
   sortTable[0x56C6]=2523;   // chai
   sortTable[0x8286]=2524;   // chai
   sortTable[0x91F5]=2525;   // chai
   sortTable[0x4EA7]=2526;   // chan
   sortTable[0x7522]=2527;   // chan
   sortTable[0x98A4]=2528;   // chan
   sortTable[0x986B]=2529;   // chan
   sortTable[0x8749]=2530;   // chan
   sortTable[0x87EC]=2531;   // chan
   sortTable[0x7F20]=2532;   // chan
   sortTable[0x7E8F]=2533;   // chan
   sortTable[0x94F2]=2534;   // chan
   sortTable[0x93DF]=2535;   // chan
   sortTable[0x6400]=2536;   // chan
   sortTable[0x6519]=2537;   // chan
   sortTable[0x9610]=2538;   // chan
   sortTable[0x95E1]=2539;   // chan
   sortTable[0x998B]=2540;   // chan
   sortTable[0x995E]=2541;   // chan
   sortTable[0x7985]=2542;   // chan
   sortTable[0x8C17]=2543;   // chan
   sortTable[0x8C04]=2544;   // chan
   sortTable[0x87FE]=2545;   // chan
   sortTable[0x5FCF]=2546;   // chan
   sortTable[0x97C2]=2547;   // chan
   sortTable[0x5A75]=2548;   // chan
   sortTable[0x8E94]=2549;   // chan
   sortTable[0x6FB6]=2550;   // chan
   sortTable[0x6F7A]=2551;   // chan
   sortTable[0x89C7]=2552;   // chan
   sortTable[0x5EDB]=2553;   // chan
   sortTable[0x92CB]=2554;   // chan
   sortTable[0x9561]=2555;   // chan
   sortTable[0x895C]=2556;   // chan
   sortTable[0x7FBC]=2557;   // chan
   sortTable[0x8487]=2558;   // chan
   sortTable[0x5181]=2559;   // chan
   sortTable[0x9575]=2560;   // chan
   sortTable[0x913D]=2561;   // chan
   sortTable[0x8546]=2562;   // chan
   sortTable[0x8FBF]=2563;   // chan
   sortTable[0x8A97]=2564;   // chan
   sortTable[0x7E5F]=2565;   // chan
   sortTable[0x785F]=2566;   // chan
   sortTable[0x9471]=2567;   // chan
   sortTable[0x9141]=2568;   // chan
   sortTable[0x8B42]=2569;   // chan
   sortTable[0x9AA3]=2570;   // chan
   sortTable[0x7DFE]=2571;   // chan
   sortTable[0x88E7]=2572;   // chan
   sortTable[0x8B87]=2573;   // chan
   sortTable[0x95B3]=2574;   // chan
   sortTable[0x79AA]=2575;   // chan
   sortTable[0x7C05]=2576;   // chan
   sortTable[0x7E92]=2577;   // chan
   sortTable[0x8998]=2578;   // chan
   sortTable[0x8AC2]=2579;   // chan
   sortTable[0x4E33]=2580;   // chan
   sortTable[0x50DD]=2581;   // chan
   sortTable[0x5103]=2582;   // chan
   sortTable[0x5133]=2583;   // chan
   sortTable[0x522C]=2584;   // chan
   sortTable[0x5257]=2585;   // chan
   sortTable[0x5277]=2586;   // chan
   sortTable[0x5296]=2587;   // chan
   sortTable[0x5574]=2588;   // chan
   sortTable[0x563D]=2589;   // chan
   sortTable[0x56B5]=2590;   // chan
   sortTable[0x56C5]=2591;   // chan
   sortTable[0x58E5]=2592;   // chan
   sortTable[0x5B0B]=2593;   // chan
   sortTable[0x5D7C]=2594;   // chan
   sortTable[0x5DC9]=2595;   // chan
   sortTable[0x5E5D]=2596;   // chan
   sortTable[0x5E68]=2597;   // chan
   sortTable[0x61F4]=2598;   // chan
   sortTable[0x61FA]=2599;   // chan
   sortTable[0x644C]=2600;   // chan
   sortTable[0x6472]=2601;   // chan
   sortTable[0x65BA]=2602;   // chan
   sortTable[0x65F5]=2603;   // chan
   sortTable[0x68B4]=2604;   // chan
   sortTable[0x68CE]=2605;   // chan
   sortTable[0x6B03]=2606;   // chan
   sortTable[0x6BDA]=2607;   // chan
   sortTable[0x6D50]=2608;   // chan
   sortTable[0x6E79]=2609;   // chan
   sortTable[0x6EFB]=2610;   // chan
   sortTable[0x6F79]=2611;   // chan
   sortTable[0x700D]=2612;   // chan
   sortTable[0x703A]=2613;   // chan
   sortTable[0x705B]=2614;   // chan
   sortTable[0x7158]=2615;   // chan
   sortTable[0x71C0]=2616;   // chan
   sortTable[0x7351]=2617;   // chan
   sortTable[0x7523]=2618;   // chan
   sortTable[0x78DB]=2619;   // chan
   sortTable[0x826C]=2620;   // chan
   sortTable[0x8B92]=2621;   // chan
   sortTable[0x8FB4]=2622;   // chan
   sortTable[0x9246]=2623;   // chan
   sortTable[0x92D3]=2624;   // chan
   sortTable[0x5E38]=2625;   // chang
   sortTable[0x573A]=2626;   // chang
   sortTable[0x5834]=2627;   // chang
   sortTable[0x5382]=2628;   // chang
   sortTable[0x5EE0]=2629;   // chang
   sortTable[0x5531]=2630;   // chang
   sortTable[0x80A0]=2631;   // chang
   sortTable[0x8178]=2632;   // chang
   sortTable[0x5021]=2633;   // chang
   sortTable[0x5C1D]=2634;   // chang
   sortTable[0x5617]=2635;   // chang
   sortTable[0x655E]=2636;   // chang
   sortTable[0x7545]=2637;   // chang
   sortTable[0x66A2]=2638;   // chang
   sortTable[0x507F]=2639;   // chang
   sortTable[0x511F]=2640;   // chang
   sortTable[0x660C]=2641;   // chang
   sortTable[0x6005]=2642;   // chang
   sortTable[0x5AE6]=2643;   // chang
   sortTable[0x5A3C]=2644;   // chang
   sortTable[0x6636]=2645;   // chang
   sortTable[0x7316]=2646;   // chang
   sortTable[0x82CC]=2647;   // chang
   sortTable[0x9B2F]=2648;   // chang
   sortTable[0x960A]=2649;   // chang
   sortTable[0x6C05]=2650;   // chang
   sortTable[0x83D6]=2651;   // chang
   sortTable[0x4F25]=2652;   // chang
   sortTable[0x5F9C]=2653;   // chang
   sortTable[0x92F9]=2654;   // chang
   sortTable[0x60DD]=2655;   // chang
   sortTable[0x9CB3]=2656;   // chang
   sortTable[0x9CBF]=2657;   // chang
   sortTable[0x97D4]=2658;   // chang
   sortTable[0x95B6]=2659;   // chang
   sortTable[0x9520]=2660;   // chang
   sortTable[0x92FF]=2661;   // chang
   sortTable[0x9C68]=2662;   // chang
   sortTable[0x9F1A]=2663;   // chang
   sortTable[0x4EE7]=2664;   // chang
   sortTable[0x5000]=2665;   // chang
   sortTable[0x50D8]=2666;   // chang
   sortTable[0x514F]=2667;   // chang
   sortTable[0x53B0]=2668;   // chang
   sortTable[0x5690]=2669;   // chang
   sortTable[0x5872]=2670;   // chang
   sortTable[0x60B5]=2671;   // chang
   sortTable[0x667F]=2672;   // chang
   sortTable[0x6919]=2673;   // chang
   sortTable[0x6DD0]=2674;   // chang
   sortTable[0x713B]=2675;   // chang
   sortTable[0x739A]=2676;   // chang
   sortTable[0x7429]=2677;   // chang
   sortTable[0x7452]=2678;   // chang
   sortTable[0x747A]=2679;   // chang
   sortTable[0x74FA]=2680;   // chang
   sortTable[0x751E]=2681;   // chang
   sortTable[0x757C]=2682;   // chang
   sortTable[0x8193]=2683;   // chang
   sortTable[0x8407]=2684;   // chang
   sortTable[0x87D0]=2685;   // chang
   sortTable[0x88EE]=2686;   // chang
   sortTable[0x8AAF]=2687;   // chang
   sortTable[0x9329]=2688;   // chang
   sortTable[0x93DB]=2689;   // chang
   sortTable[0x9578]=2690;   // chang
   sortTable[0x9BE7]=2691;   // chang
   sortTable[0x671D]=2692;   // chao
   sortTable[0x8D85]=2693;   // chao
   sortTable[0x6F6E]=2694;   // chao
   sortTable[0x5435]=2695;   // chao
   sortTable[0x6284]=2696;   // chao
   sortTable[0x5DE2]=2697;   // chao
   sortTable[0x5632]=2698;   // chao
   sortTable[0x949E]=2699;   // chao
   sortTable[0x9214]=2700;   // chao
   sortTable[0x7092]=2701;   // chao
   sortTable[0x6641]=2702;   // chao
   sortTable[0x712F]=2703;   // chao
   sortTable[0x8016]=2704;   // chao
   sortTable[0x9F02]=2705;   // chao
   sortTable[0x600A]=2706;   // chao
   sortTable[0x8B3F]=2707;   // chao
   sortTable[0x911B]=2708;   // chao
   sortTable[0x9EA8]=2709;   // chao
   sortTable[0x8A2C]=2710;   // chao
   sortTable[0x7727]=2711;   // chao
   sortTable[0x7F7A]=2712;   // chao
   sortTable[0x4EE6]=2713;   // chao
   sortTable[0x4EEF]=2714;   // chao
   sortTable[0x52E6]=2715;   // chao
   sortTable[0x5DD0]=2716;   // chao
   sortTable[0x5DE3]=2717;   // chao
   sortTable[0x5F28]=2718;   // chao
   sortTable[0x6A14]=2719;   // chao
   sortTable[0x6B29]=2720;   // chao
   sortTable[0x6F05]=2721;   // chao
   sortTable[0x7123]=2722;   // chao
   sortTable[0x717C]=2723;   // chao
   sortTable[0x724A]=2724;   // chao
   sortTable[0x7AB2]=2725;   // chao
   sortTable[0x89D8]=2726;   // chao
   sortTable[0x8F48]=2727;   // chao
   sortTable[0x9F0C]=2728;   // chao
   sortTable[0x8F66]=2729;   // che
   sortTable[0x8ECA]=2730;   // che
   sortTable[0x5F7B]=2731;   // che
   sortTable[0x5FB9]=2732;   // che
   sortTable[0x64A4]=2733;   // che
   sortTable[0x626F]=2734;   // che
   sortTable[0x63A3]=2735;   // che
   sortTable[0x6F88]=2736;   // che
   sortTable[0x7817]=2737;   // che
   sortTable[0x577C]=2738;   // che
   sortTable[0x77AE]=2739;   // che
   sortTable[0x7869]=2740;   // che
   sortTable[0x86FC]=2741;   // che
   sortTable[0x8045]=2742;   // che
   sortTable[0x4F21]=2743;   // che
   sortTable[0x4FE5]=2744;   // che
   sortTable[0x5056]=2745;   // che
   sortTable[0x52F6]=2746;   // che
   sortTable[0x5513]=2747;   // che
   sortTable[0x5C6E]=2748;   // che
   sortTable[0x64A6]=2749;   // che
   sortTable[0x70E2]=2750;   // che
   sortTable[0x7221]=2751;   // che
   sortTable[0x7868]=2752;   // che
   sortTable[0x8397]=2753;   // che
   sortTable[0x8FE0]=2754;   // che
   sortTable[0x9819]=2755;   // che
   sortTable[0x6C89]=2756;   // chen
   sortTable[0x6668]=2757;   // chen
   sortTable[0x8D81]=2758;   // chen
   sortTable[0x5C18]=2759;   // chen
   sortTable[0x5875]=2760;   // chen
   sortTable[0x886C]=2761;   // chen
   sortTable[0x896F]=2762;   // chen
   sortTable[0x9648]=2763;   // chen
   sortTable[0x9673]=2764;   // chen
   sortTable[0x81E3]=2765;   // chen
   sortTable[0x5FF1]=2766;   // chen
   sortTable[0x8FB0]=2767;   // chen
   sortTable[0x741B]=2768;   // chen
   sortTable[0x5BB8]=2769;   // chen
   sortTable[0x8C0C]=2770;   // chen
   sortTable[0x55D4]=2771;   // chen
   sortTable[0x8C36]=2772;   // chen
   sortTable[0x90F4]=2773;   // chen
   sortTable[0x62BB]=2774;   // chen
   sortTable[0x6987]=2775;   // chen
   sortTable[0x789C]=2776;   // chen
   sortTable[0x9F80]=2777;   // chen
   sortTable[0x7D9D]=2778;   // chen
   sortTable[0x778B]=2779;   // chen
   sortTable[0x91A6]=2780;   // chen
   sortTable[0x9703]=2781;   // chen
   sortTable[0x831E]=2782;   // chen
   sortTable[0x852F]=2783;   // chen
   sortTable[0x8CDD]=2784;   // chen
   sortTable[0x9E8E]=2785;   // chen
   sortTable[0x8D02]=2786;   // chen
   sortTable[0x8D82]=2787;   // chen
   sortTable[0x8ED9]=2788;   // chen
   sortTable[0x8DBB]=2789;   // chen
   sortTable[0x8FE7]=2790;   // chen
   sortTable[0x9356]=2791;   // chen
   sortTable[0x8B96]=2792;   // chen
   sortTable[0x7876]=2793;   // chen
   sortTable[0x78E3]=2794;   // chen
   sortTable[0x8390]=2795;   // chen
   sortTable[0x8E38]=2796;   // chen
   sortTable[0x9202]=2797;   // chen
   sortTable[0x9F53]=2798;   // chen
   sortTable[0x512C]=2799;   // chen
   sortTable[0x512D]=2800;   // chen
   sortTable[0x56AB]=2801;   // chen
   sortTable[0x588B]=2802;   // chen
   sortTable[0x5926]=2803;   // chen
   sortTable[0x6116]=2804;   // chen
   sortTable[0x6375]=2805;   // chen
   sortTable[0x63E8]=2806;   // chen
   sortTable[0x6550]=2807;   // chen
   sortTable[0x66DF]=2808;   // chen
   sortTable[0x6A04]=2809;   // chen
   sortTable[0x6AEC]=2810;   // chen
   sortTable[0x70E5]=2811;   // chen
   sortTable[0x7141]=2812;   // chen
   sortTable[0x75A2]=2813;   // chen
   sortTable[0x760E]=2814;   // chen
   sortTable[0x7E1D]=2815;   // chen
   sortTable[0x8380]=2816;   // chen
   sortTable[0x85BC]=2817;   // chen
   sortTable[0x87B4]=2818;   // chen
   sortTable[0x8A26]=2819;   // chen
   sortTable[0x8AC3]=2820;   // chen
   sortTable[0x8AF6]=2821;   // chen
   sortTable[0x8B13]=2822;   // chen
   sortTable[0x9DD0]=2823;   // chen
   sortTable[0x9F54]=2824;   // chen
   sortTable[0x6210]=2825;   // cheng
   sortTable[0x7A0B]=2826;   // cheng
   sortTable[0x57CE]=2827;   // cheng
   sortTable[0x79F0]=2828;   // cheng
   sortTable[0x7A31]=2829;   // cheng
   sortTable[0x627F]=2830;   // cheng
   sortTable[0x4E58]=2831;   // cheng
   sortTable[0x8BDA]=2832;   // cheng
   sortTable[0x8AA0]=2833;   // cheng
   sortTable[0x5448]=2834;   // cheng
   sortTable[0x6491]=2835;   // cheng
   sortTable[0x6490]=2836;   // cheng
   sortTable[0x60E9]=2837;   // cheng
   sortTable[0x79E4]=2838;   // cheng
   sortTable[0x61F2]=2839;   // cheng
   sortTable[0x4E1E]=2840;   // cheng
   sortTable[0x6F84]=2841;   // cheng
   sortTable[0x901E]=2842;   // cheng
   sortTable[0x665F]=2843;   // cheng
   sortTable[0x9A8B]=2844;   // cheng
   sortTable[0x6A59]=2845;   // cheng
   sortTable[0x88CE]=2846;   // cheng
   sortTable[0x77A0]=2847;   // cheng
   sortTable[0x86CF]=2848;   // cheng
   sortTable[0x94D6]=2849;   // cheng
   sortTable[0x67A8]=2850;   // cheng
   sortTable[0x90D5]=2851;   // cheng
   sortTable[0x9172]=2852;   // cheng
   sortTable[0x584D]=2853;   // cheng
   sortTable[0x67FD]=2854;   // cheng
   sortTable[0x7748]=2855;   // cheng
   sortTable[0x8D6A]=2856;   // cheng
   sortTable[0x57D5]=2857;   // cheng
   sortTable[0x8100]=2858;   // cheng
   sortTable[0x7A6A]=2859;   // cheng
   sortTable[0x812D]=2860;   // cheng
   sortTable[0x9833]=2861;   // cheng
   sortTable[0x9A2C]=2862;   // cheng
   sortTable[0x8D6C]=2863;   // cheng
   sortTable[0x7AC0]=2864;   // cheng
   sortTable[0x7D7E]=2865;   // cheng
   sortTable[0x7880]=2866;   // cheng
   sortTable[0x7DFD]=2867;   // cheng
   sortTable[0x93F3]=2868;   // cheng
   sortTable[0x9953]=2869;   // cheng
   sortTable[0x9A01]=2870;   // cheng
   sortTable[0x7A9A]=2871;   // cheng
   sortTable[0x93FF]=2872;   // cheng
   sortTable[0x4E57]=2873;   // cheng
   sortTable[0x4FB1]=2874;   // cheng
   sortTable[0x5041]=2875;   // cheng
   sortTable[0x50DC]=2876;   // cheng
   sortTable[0x5818]=2877;   // cheng
   sortTable[0x5856]=2878;   // cheng
   sortTable[0x5A0D]=2879;   // cheng
   sortTable[0x5BAC]=2880;   // cheng
   sortTable[0x5CF8]=2881;   // cheng
   sortTable[0x5EB1]=2882;   // cheng
   sortTable[0x5F8E]=2883;   // cheng
   sortTable[0x609C]=2884;   // cheng
   sortTable[0x6186]=2885;   // cheng
   sortTable[0x6195]=2886;   // cheng
   sortTable[0x6330]=2887;   // cheng
   sortTable[0x6381]=2888;   // cheng
   sortTable[0x645A]=2889;   // cheng
   sortTable[0x673E]=2890;   // cheng
   sortTable[0x68D6]=2891;   // cheng
   sortTable[0x68E6]=2892;   // cheng
   sortTable[0x6909]=2893;   // cheng
   sortTable[0x6A55]=2894;   // cheng
   sortTable[0x6A89]=2895;   // cheng
   sortTable[0x6A99]=2896;   // cheng
   sortTable[0x6CDF]=2897;   // cheng
   sortTable[0x6D06]=2898;   // cheng
   sortTable[0x6D7E]=2899;   // cheng
   sortTable[0x6E5E]=2900;   // cheng
   sortTable[0x6E97]=2901;   // cheng
   sortTable[0x6F82]=2902;   // cheng
   sortTable[0x7013]=2903;   // cheng
   sortTable[0x722F]=2904;   // cheng
   sortTable[0x725A]=2905;   // cheng
   sortTable[0x73F5]=2906;   // cheng
   sortTable[0x73F9]=2907;   // cheng
   sortTable[0x7424]=2908;   // cheng
   sortTable[0x757B]=2909;   // cheng
   sortTable[0x7B6C]=2910;   // cheng
   sortTable[0x837F]=2911;   // cheng
   sortTable[0x87F6]=2912;   // cheng
   sortTable[0x92EE]=2913;   // cheng
   sortTable[0x9637]=2914;   // cheng
   sortTable[0x9757]=2915;   // cheng
   sortTable[0x9BCE]=2916;   // cheng
   sortTable[0x5403]=2917;   // chi
   sortTable[0x6301]=2918;   // chi
   sortTable[0x5C3A]=2919;   // chi
   sortTable[0x8FDF]=2920;   // chi
   sortTable[0x9072]=2921;   // chi
   sortTable[0x7FC5]=2922;   // chi
   sortTable[0x9F7F]=2923;   // chi
   sortTable[0x9F52]=2924;   // chi
   sortTable[0x6C60]=2925;   // chi
   sortTable[0x803B]=2926;   // chi
   sortTable[0x6065]=2927;   // chi
   sortTable[0x9A70]=2928;   // chi
   sortTable[0x65A5]=2929;   // chi
   sortTable[0x54E7]=2930;   // chi
   sortTable[0x99B3]=2931;   // chi
   sortTable[0x8D64]=2932;   // chi
   sortTable[0x86A9]=2933;   // chi
   sortTable[0x6555]=2934;   // chi
   sortTable[0x75F4]=2935;   // chi
   sortTable[0x53F1]=2936;   // chi
   sortTable[0x4F88]=2937;   // chi
   sortTable[0x996C]=2938;   // chi
   sortTable[0x70BD]=2939;   // chi
   sortTable[0x55E4]=2940;   // chi
   sortTable[0x5F1B]=2941;   // chi
   sortTable[0x7B1E]=2942;   // chi
   sortTable[0x761B]=2943;   // chi
   sortTable[0x557B]=2944;   // chi
   sortTable[0x9B51]=2945;   // chi
   sortTable[0x5880]=2946;   // chi
   sortTable[0x9E31]=2947;   // chi
   sortTable[0x5AB8]=2948;   // chi
   sortTable[0x892B]=2949;   // chi
   sortTable[0x87AD]=2950;   // chi
   sortTable[0x50BA]=2951;   // chi
   sortTable[0x577B]=2952;   // chi
   sortTable[0x8E1F]=2953;   // chi
   sortTable[0x7BEA]=2954;   // chi
   sortTable[0x7D7A]=2955;   // chi
   sortTable[0x830C]=2956;   // chi
   sortTable[0x9D92]=2957;   // chi
   sortTable[0x994E]=2958;   // chi
   sortTable[0x7735]=2959;   // chi
   sortTable[0x7AFE]=2960;   // chi
   sortTable[0x7C8E]=2961;   // chi
   sortTable[0x86B3]=2962;   // chi
   sortTable[0x906B]=2963;   // chi
   sortTable[0x7B8E]=2964;   // chi
   sortTable[0x8D8D]=2965;   // chi
   sortTable[0x8DA9]=2966;   // chi
   sortTable[0x98ED]=2967;   // chi
   sortTable[0x80F5]=2968;   // chi
   sortTable[0x9D1F]=2969;   // chi
   sortTable[0x7FE8]=2970;   // chi
   sortTable[0x834E]=2971;   // chi
   sortTable[0x96F4]=2972;   // chi
   sortTable[0x779D]=2973;   // chi
   sortTable[0x80E3]=2974;   // chi
   sortTable[0x88B2]=2975;   // chi
   sortTable[0x8B18]=2976;   // chi
   sortTable[0x7B42]=2977;   // chi
   sortTable[0x8687]=2978;   // chi
   sortTable[0x88ED]=2979;   // chi
   sortTable[0x8CBE]=2980;   // chi
   sortTable[0x8DEE]=2981;   // chi
   sortTable[0x9279]=2982;   // chi
   sortTable[0x9DD8]=2983;   // chi
   sortTable[0x9ED0]=2984;   // chi
   sortTable[0x9F5D]=2985;   // chi
   sortTable[0x4F99]=2986;   // chi
   sortTable[0x52C5]=2987;   // chi
   sortTable[0x52D1]=2988;   // chi
   sortTable[0x5376]=2989;   // chi
   sortTable[0x53FA]=2990;   // chi
   sortTable[0x544E]=2991;   // chi
   sortTable[0x55AB]=2992;   // chi
   sortTable[0x5644]=2993;   // chi
   sortTable[0x5791]=2994;   // chi
   sortTable[0x599B]=2995;   // chi
   sortTable[0x5CBB]=2996;   // chi
   sortTable[0x5F68]=2997;   // chi
   sortTable[0x5F72]=2998;   // chi
   sortTable[0x5F73]=2999;   // chi
   sortTable[0x605C]=3000;   // chi
   sortTable[0x6157]=3001;   // chi
   sortTable[0x618F]=3002;   // chi
   sortTable[0x61D8]=3003;   // chi
   sortTable[0x62B6]=3004;   // chi
   sortTable[0x645B]=3005;   // chi
   sortTable[0x6758]=3006;   // chi
   sortTable[0x6B3C]=3007;   // chi
   sortTable[0x6B6D]=3008;   // chi
   sortTable[0x6B6F]=3009;   // chi
   sortTable[0x6E41]=3010;   // chi
   sortTable[0x6F26]=3011;   // chi
   sortTable[0x707B]=3012;   // chi
   sortTable[0x70FE]=3013;   // chi
   sortTable[0x71BE]=3014;   // chi
   sortTable[0x74FB]=3015;   // chi
   sortTable[0x75D3]=3016;   // chi
   sortTable[0x75F8]=3017;   // chi
   sortTable[0x7608]=3018;   // chi
   sortTable[0x7661]=3019;   // chi
   sortTable[0x7873]=3020;   // chi
   sortTable[0x7FC4]=3021;   // chi
   sortTable[0x7FE4]=3022;   // chi
   sortTable[0x815F]=3023;   // chi
   sortTable[0x88B3]=3024;   // chi
   sortTable[0x8A35]=3025;   // chi
   sortTable[0x8ABA]=3026;   // chi
   sortTable[0x8D7F]=3027;   // chi
   sortTable[0x9045]=3028;   // chi
   sortTable[0x905F]=3029;   // chi
   sortTable[0x9253]=3030;   // chi
   sortTable[0x9290]=3031;   // chi
   sortTable[0x9EB6]=3032;   // chi
   sortTable[0x866B]=3033;   // chong
   sortTable[0x51B2]=3034;   // chong
   sortTable[0x6C96]=3035;   // chong
   sortTable[0x5145]=3036;   // chong
   sortTable[0x5D07]=3037;   // chong
   sortTable[0x61A7]=3038;   // chong
   sortTable[0x5BA0]=3039;   // chong
   sortTable[0x5FE1]=3040;   // chong
   sortTable[0x8202]=3041;   // chong
   sortTable[0x825F]=3042;   // chong
   sortTable[0x94F3]=3043;   // chong
   sortTable[0x7FC0]=3044;   // chong
   sortTable[0x87F2]=3045;   // chong
   sortTable[0x833A]=3046;   // chong
   sortTable[0x7F7F]=3047;   // chong
   sortTable[0x885D]=3048;   // chong
   sortTable[0x7DDF]=3049;   // chong
   sortTable[0x8E56]=3050;   // chong
   sortTable[0x9680]=3051;   // chong
   sortTable[0x5603]=3052;   // chong
   sortTable[0x57EB]=3053;   // chong
   sortTable[0x5BF5]=3054;   // chong
   sortTable[0x5D08]=3055;   // chong
   sortTable[0x5FB8]=3056;   // chong
   sortTable[0x6183]=3057;   // chong
   sortTable[0x63F0]=3058;   // chong
   sortTable[0x644F]=3059;   // chong
   sortTable[0x6D7A]=3060;   // chong
   sortTable[0x721E]=3061;   // chong
   sortTable[0x73EB]=3062;   // chong
   sortTable[0x8769]=3063;   // chong
   sortTable[0x8908]=3064;   // chong
   sortTable[0x9283]=3065;   // chong
   sortTable[0x62BD]=3066;   // chou
   sortTable[0x81ED]=3067;   // chou
   sortTable[0x4EC7]=3068;   // chou
   sortTable[0x6101]=3069;   // chou
   sortTable[0x7785]=3070;   // chou
   sortTable[0x4E11]=3071;   // chou
   sortTable[0x7EF8]=3072;   // chou
   sortTable[0x8E0C]=3073;   // chou
   sortTable[0x8E8A]=3074;   // chou
   sortTable[0x7DA2]=3075;   // chou
   sortTable[0x916C]=3076;   // chou
   sortTable[0x7A20]=3077;   // chou
   sortTable[0x7B79]=3078;   // chou
   sortTable[0x7574]=3079;   // chou
   sortTable[0x4FE6]=3080;   // chou
   sortTable[0x96E0]=3081;   // chou
   sortTable[0x60C6]=3082;   // chou
   sortTable[0x7633]=3083;   // chou
   sortTable[0x5E31]=3084;   // chou
   sortTable[0x77C1]=3085;   // chou
   sortTable[0x88EF]=3086;   // chou
   sortTable[0x7D2C]=3087;   // chou
   sortTable[0x7BD8]=3088;   // chou
   sortTable[0x8B8E]=3089;   // chou
   sortTable[0x9167]=3090;   // chou
   sortTable[0x91BB]=3091;   // chou
   sortTable[0x96D4]=3092;   // chou
   sortTable[0x919C]=3093;   // chou
   sortTable[0x7C4C]=3094;   // chou
   sortTable[0x83D7]=3095;   // chou
   sortTable[0x7D52]=3096;   // chou
   sortTable[0x8B90]=3097;   // chou
   sortTable[0x4E12]=3098;   // chou
   sortTable[0x4FB4]=3099;   // chou
   sortTable[0x5062]=3100;   // chou
   sortTable[0x5114]=3101;   // chou
   sortTable[0x541C]=3102;   // chou
   sortTable[0x568B]=3103;   // chou
   sortTable[0x5A64]=3104;   // chou
   sortTable[0x5B26]=3105;   // chou
   sortTable[0x5E6C]=3106;   // chou
   sortTable[0x601E]=3107;   // chou
   sortTable[0x61E4]=3108;   // chou
   sortTable[0x640A]=3109;   // chou
   sortTable[0x677B]=3110;   // chou
   sortTable[0x677D]=3111;   // chou
   sortTable[0x6826]=3112;   // chou
   sortTable[0x6906]=3113;   // chou
   sortTable[0x6BA0]=3114;   // chou
   sortTable[0x71FD]=3115;   // chou
   sortTable[0x72A8]=3116;   // chou
   sortTable[0x72AB]=3117;   // chou
   sortTable[0x7587]=3118;   // chou
   sortTable[0x7697]=3119;   // chou
   sortTable[0x81F0]=3120;   // chou
   sortTable[0x85B5]=3121;   // chou
   sortTable[0x905A]=3122;   // chou
   sortTable[0x9B57]=3123;   // chou
   sortTable[0x51FA]=3124;   // chu
   sortTable[0x5904]=3125;   // chu
   sortTable[0x8655]=3126;   // chu
   sortTable[0x9664]=3127;   // chu
   sortTable[0x521D]=3128;   // chu
   sortTable[0x7840]=3129;   // chu
   sortTable[0x790E]=3130;   // chu
   sortTable[0x695A]=3131;   // chu
   sortTable[0x89E6]=3132;   // chu
   sortTable[0x89F8]=3133;   // chu
   sortTable[0x53A8]=3134;   // chu
   sortTable[0x5EDA]=3135;   // chu
   sortTable[0x50A8]=3136;   // chu
   sortTable[0x5132]=3137;   // chu
   sortTable[0x8E87]=3138;   // chu
   sortTable[0x9504]=3139;   // chu
   sortTable[0x92E4]=3140;   // chu
   sortTable[0x755C]=3141;   // chu
   sortTable[0x77D7]=3142;   // chu
   sortTable[0x891A]=3143;   // chu
   sortTable[0x9EDC]=3144;   // chu
   sortTable[0x6A71]=3145;   // chu
   sortTable[0x520D]=3146;   // chu
   sortTable[0x96CF]=3147;   // chu
   sortTable[0x6775]=3148;   // chu
   sortTable[0x6410]=3149;   // chu
   sortTable[0x6EC1]=3150;   // chu
   sortTable[0x6A17]=3151;   // chu
   sortTable[0x7ECC]=3152;   // chu
   sortTable[0x696E]=3153;   // chu
   sortTable[0x6035]=3154;   // chu
   sortTable[0x8E70]=3155;   // chu
   sortTable[0x61B7]=3156;   // chu
   sortTable[0x870D]=3157;   // chu
   sortTable[0x924F]=3158;   // chu
   sortTable[0x8C99]=3159;   // chu
   sortTable[0x84A2]=3160;   // chu
   sortTable[0x81C5]=3161;   // chu
   sortTable[0x7BE8]=3162;   // chu
   sortTable[0x9F7C]=3163;   // chu
   sortTable[0x84AD]=3164;   // chu
   sortTable[0x9E00]=3165;   // chu
   sortTable[0x95A6]=3166;   // chu
   sortTable[0x9DB5]=3167;   // chu
   sortTable[0x84EB]=3168;   // chu
   sortTable[0x85F8]=3169;   // chu
   sortTable[0x9F63]=3170;   // chu
   sortTable[0x7ACC]=3171;   // chu
   sortTable[0x8021]=3172;   // chu
   sortTable[0x854F]=3173;   // chu
   sortTable[0x8C56]=3174;   // chu
   sortTable[0x82BB]=3175;   // chu
   sortTable[0x87F5]=3176;   // chu
   sortTable[0x8AD4]=3177;   // chu
   sortTable[0x8C60]=3178;   // chu
   sortTable[0x8E00]=3179;   // chu
   sortTable[0x9110]=3180;   // chu
   sortTable[0x4E8D]=3181;   // chu
   sortTable[0x4FF6]=3182;   // chu
   sortTable[0x5097]=3183;   // chu
   sortTable[0x510A]=3184;   // chu
   sortTable[0x51E6]=3185;   // chu
   sortTable[0x563C]=3186;   // chu
   sortTable[0x57F1]=3187;   // chu
   sortTable[0x5AB0]=3188;   // chu
   sortTable[0x5C80]=3189;   // chu
   sortTable[0x5E6E]=3190;   // chu
   sortTable[0x62C0]=3191;   // chu
   sortTable[0x6474]=3192;   // chu
   sortTable[0x654A]=3193;   // chu
   sortTable[0x65B6]=3194;   // chu
   sortTable[0x67F7]=3195;   // chu
   sortTable[0x6918]=3196;   // chu
   sortTable[0x698B]=3197;   // chu
   sortTable[0x6A7B]=3198;   // chu
   sortTable[0x6A9A]=3199;   // chu
   sortTable[0x6AC9]=3200;   // chu
   sortTable[0x6AE5]=3201;   // chu
   sortTable[0x6B2A]=3202;   // chu
   sortTable[0x6B5C]=3203;   // chu
   sortTable[0x6EC0]=3204;   // chu
   sortTable[0x6FCB]=3205;   // chu
   sortTable[0x7293]=3206;   // chu
   sortTable[0x73FF]=3207;   // chu
   sortTable[0x7421]=3208;   // chu
   sortTable[0x74B4]=3209;   // chu
   sortTable[0x7AD0]=3210;   // chu
   sortTable[0x7D40]=3211;   // chu
   sortTable[0x8D8E]=3212;   // chu
   sortTable[0x8E95]=3213;   // chu
   sortTable[0x96DB]=3214;   // chu
   sortTable[0x9F6D]=3215;   // chu
   sortTable[0x6B3B]=3216;   // chua
   sortTable[0x6B58]=3217;   // chua
   sortTable[0x63E3]=3218;   // chuai
   sortTable[0x555C]=3219;   // chuai
   sortTable[0x8E39]=3220;   // chuai
   sortTable[0x562C]=3221;   // chuai
   sortTable[0x640B]=3222;   // chuai
   sortTable[0x8197]=3223;   // chuai
   sortTable[0x81AA]=3224;   // chuai
   sortTable[0x8239]=3225;   // chuan
   sortTable[0x4F20]=3226;   // chuan
   sortTable[0x50B3]=3227;   // chuan
   sortTable[0x7A7F]=3228;   // chuan
   sortTable[0x4E32]=3229;   // chuan
   sortTable[0x5598]=3230;   // chuan
   sortTable[0x5DDD]=3231;   // chuan
   sortTable[0x948F]=3232;   // chuan
   sortTable[0x821B]=3233;   // chuan
   sortTable[0x693D]=3234;   // chuan
   sortTable[0x9044]=3235;   // chuan
   sortTable[0x6C1A]=3236;   // chuan
   sortTable[0x8221]=3237;   // chuan
   sortTable[0x8348]=3238;   // chuan
   sortTable[0x8E33]=3239;   // chuan
   sortTable[0x5DDB]=3240;   // chuan
   sortTable[0x8F32]=3241;   // chuan
   sortTable[0x7BC5]=3242;   // chuan
   sortTable[0x9DA8]=3243;   // chuan
   sortTable[0x4F1D]=3244;   // chuan
   sortTable[0x50E2]=3245;   // chuan
   sortTable[0x5276]=3246;   // chuan
   sortTable[0x570C]=3247;   // chuan
   sortTable[0x66B7]=3248;   // chuan
   sortTable[0x6B42]=3249;   // chuan
   sortTable[0x6C4C]=3250;   // chuan
   sortTable[0x732D]=3251;   // chuan
   sortTable[0x7394]=3252;   // chuan
   sortTable[0x744F]=3253;   // chuan
   sortTable[0x8229]=3254;   // chuan
   sortTable[0x8CD7]=3255;   // chuan
   sortTable[0x91E7]=3256;   // chuan
   sortTable[0x521B]=3257;   // chuang
   sortTable[0x5275]=3258;   // chuang
   sortTable[0x5E8A]=3259;   // chuang
   sortTable[0x7A97]=3260;   // chuang
   sortTable[0x95EF]=3261;   // chuang
   sortTable[0x95D6]=3262;   // chuang
   sortTable[0x5E62]=3263;   // chuang
   sortTable[0x75AE]=3264;   // chuang
   sortTable[0x6006]=3265;   // chuang
   sortTable[0x78E2]=3266;   // chuang
   sortTable[0x50B8]=3267;   // chuang
   sortTable[0x51D4]=3268;   // chuang
   sortTable[0x5205]=3269;   // chuang
   sortTable[0x5231]=3270;   // chuang
   sortTable[0x524F]=3271;   // chuang
   sortTable[0x5259]=3272;   // chuang
   sortTable[0x5647]=3273;   // chuang
   sortTable[0x6134]=3274;   // chuang
   sortTable[0x6450]=3275;   // chuang
   sortTable[0x6464]=3276;   // chuang
   sortTable[0x7240]=3277;   // chuang
   sortTable[0x724E]=3278;   // chuang
   sortTable[0x7255]=3279;   // chuang
   sortTable[0x7621]=3280;   // chuang
   sortTable[0x7A93]=3281;   // chuang
   sortTable[0x7ABB]=3282;   // chuang
   sortTable[0x5439]=3283;   // chui
   sortTable[0x5782]=3284;   // chui
   sortTable[0x9524]=3285;   // chui
   sortTable[0x6376]=3286;   // chui
   sortTable[0x9318]=3287;   // chui
   sortTable[0x708A]=3288;   // chui
   sortTable[0x690E]=3289;   // chui
   sortTable[0x69CC]=3290;   // chui
   sortTable[0x9672]=3291;   // chui
   sortTable[0x68F0]=3292;   // chui
   sortTable[0x7BA0]=3293;   // chui
   sortTable[0x939A]=3294;   // chui
   sortTable[0x83D9]=3295;   // chui
   sortTable[0x8144]=3296;   // chui
   sortTable[0x9840]=3297;   // chui
   sortTable[0x5015]=3298;   // chui
   sortTable[0x57C0]=3299;   // chui
   sortTable[0x6425]=3300;   // chui
   sortTable[0x9FA1]=3301;   // chui
   sortTable[0x6625]=3302;   // chun
   sortTable[0x7EAF]=3303;   // chun
   sortTable[0x7D14]=3304;   // chun
   sortTable[0x5507]=3305;   // chun
   sortTable[0x9E51]=3306;   // chun
   sortTable[0x9D89]=3307;   // chun
   sortTable[0x6DF3]=3308;   // chun
   sortTable[0x8822]=3309;   // chun
   sortTable[0x9187]=3310;   // chun
   sortTable[0x693F]=3311;   // chun
   sortTable[0x83BC]=3312;   // chun
   sortTable[0x8123]=3313;   // chun
   sortTable[0x877D]=3314;   // chun
   sortTable[0x931E]=3315;   // chun
   sortTable[0x8F34]=3316;   // chun
   sortTable[0x84F4]=3317;   // chun
   sortTable[0x7776]=3318;   // chun
   sortTable[0x8CF0]=3319;   // chun
   sortTable[0x9BD9]=3320;   // chun
   sortTable[0x9659]=3321;   // chun
   sortTable[0x7BBA]=3322;   // chun
   sortTable[0x81A5]=3323;   // chun
   sortTable[0x8436]=3324;   // chun
   sortTable[0x9D9E]=3325;   // chun
   sortTable[0x9195]=3326;   // chun
   sortTable[0x5046]=3327;   // chun
   sortTable[0x583E]=3328;   // chun
   sortTable[0x5A8B]=3329;   // chun
   sortTable[0x60F7]=3330;   // chun
   sortTable[0x65FE]=3331;   // chun
   sortTable[0x6699]=3332;   // chun
   sortTable[0x6776]=3333;   // chun
   sortTable[0x6A41]=3334;   // chun
   sortTable[0x6AC4]=3335;   // chun
   sortTable[0x6D71]=3336;   // chun
   sortTable[0x6E7B]=3337;   // chun
   sortTable[0x6EE3]=3338;   // chun
   sortTable[0x6F18]=3339;   // chun
   sortTable[0x7289]=3340;   // chun
   sortTable[0x7443]=3341;   // chun
   sortTable[0x8405]=3342;   // chun
   sortTable[0x8493]=3343;   // chun
   sortTable[0x9C06]=3344;   // chun
   sortTable[0x7EF0]=3345;   // chuo
   sortTable[0x8F8D]=3346;   // chuo
   sortTable[0x6233]=3347;   // chuo
   sortTable[0x8E14]=3348;   // chuo
   sortTable[0x9F8A]=3349;   // chuo
   sortTable[0x9034]=3350;   // chuo
   sortTable[0x8DA0]=3351;   // chuo
   sortTable[0x8FB5]=3352;   // chuo
   sortTable[0x9461]=3353;   // chuo
   sortTable[0x78ED]=3354;   // chuo
   sortTable[0x7E5B]=3355;   // chuo
   sortTable[0x814F]=3356;   // chuo
   sortTable[0x56BD]=3357;   // chuo
   sortTable[0x5A15]=3358;   // chuo
   sortTable[0x5A16]=3359;   // chuo
   sortTable[0x5A7C]=3360;   // chuo
   sortTable[0x60D9]=3361;   // chuo
   sortTable[0x64C9]=3362;   // chuo
   sortTable[0x6B60]=3363;   // chuo
   sortTable[0x6DB0]=3364;   // chuo
   sortTable[0x7DBD]=3365;   // chuo
   sortTable[0x8F1F]=3366;   // chuo
   sortTable[0x8FB6]=3367;   // chuo
   sortTable[0x916B]=3368;   // chuo
   sortTable[0x9F6A]=3369;   // chuo
   sortTable[0x6B21]=3370;   // ci
   sortTable[0x6B64]=3371;   // ci
   sortTable[0x523A]=3372;   // ci
   sortTable[0x78C1]=3373;   // ci
   sortTable[0x8BCD]=3374;   // ci
   sortTable[0x8A5E]=3375;   // ci
   sortTable[0x74F7]=3376;   // ci
   sortTable[0x4F3A]=3377;   // ci
   sortTable[0x8F9E]=3378;   // ci
   sortTable[0x8FAD]=3379;   // ci
   sortTable[0x96CC]=3380;   // ci
   sortTable[0x6148]=3381;   // ci
   sortTable[0x8D50]=3382;   // ci
   sortTable[0x7960]=3383;   // ci
   sortTable[0x8328]=3384;   // ci
   sortTable[0x75B5]=3385;   // ci
   sortTable[0x9E5A]=3386;   // ci
   sortTable[0x5472]=3387;   // ci
   sortTable[0x7CCD]=3388;   // ci
   sortTable[0x8308]=3389;   // ci
   sortTable[0x8DD0]=3390;   // ci
   sortTable[0x9908]=3391;   // ci
   sortTable[0x7920]=3392;   // ci
   sortTable[0x9B86]=3393;   // ci
   sortTable[0x9AB4]=3394;   // ci
   sortTable[0x98FA]=3395;   // ci
   sortTable[0x83BF]=3396;   // ci
   sortTable[0x8786]=3397;   // ci
   sortTable[0x7E12]=3398;   // ci
   sortTable[0x858B]=3399;   // ci
   sortTable[0x8CDC]=3400;   // ci
   sortTable[0x7D2A]=3401;   // ci
   sortTable[0x8326]=3402;   // ci
   sortTable[0x8800]=3403;   // ci
   sortTable[0x9D1C]=3404;   // ci
   sortTable[0x7D58]=3405;   // ci
   sortTable[0x4F4C]=3406;   // ci
   sortTable[0x4F7D]=3407;   // ci
   sortTable[0x5068]=3408;   // ci
   sortTable[0x523E]=3409;   // ci
   sortTable[0x5790]=3410;   // ci
   sortTable[0x5832]=3411;   // ci
   sortTable[0x5B28]=3412;   // ci
   sortTable[0x5E9B]=3413;   // ci
   sortTable[0x673F]=3414;   // ci
   sortTable[0x67CC]=3415;   // ci
   sortTable[0x6828]=3416;   // ci
   sortTable[0x6CDA]=3417;   // ci
   sortTable[0x6FE8]=3418;   // ci
   sortTable[0x73BC]=3419;   // ci
   sortTable[0x73C1]=3420;   // ci
   sortTable[0x7506]=3421;   // ci
   sortTable[0x7689]=3422;   // ci
   sortTable[0x86D3]=3423;   // ci
   sortTable[0x8D7C]=3424;   // ci
   sortTable[0x8D80]=3425;   // ci
   sortTable[0x8F9D]=3426;   // ci
   sortTable[0x8FA4]=3427;   // ci
   sortTable[0x9ACA]=3428;   // ci
   sortTable[0x9DBF]=3429;   // ci
   sortTable[0x9DC0]=3430;   // ci
   sortTable[0x9F79]=3431;   // ci
   sortTable[0x4ECE]=3432;   // cong
   sortTable[0x5F9E]=3433;   // cong
   sortTable[0x5306]=3434;   // cong
   sortTable[0x806A]=3435;   // cong
   sortTable[0x8070]=3436;   // cong
   sortTable[0x4E1B]=3437;   // cong
   sortTable[0x53E2]=3438;   // cong
   sortTable[0x56F1]=3439;   // cong
   sortTable[0x56EA]=3440;   // cong
   sortTable[0x8471]=3441;   // cong
   sortTable[0x8525]=3442;   // cong
   sortTable[0x6DD9]=3443;   // cong
   sortTable[0x742E]=3444;   // cong
   sortTable[0x82C1]=3445;   // cong
   sortTable[0x679E]=3446;   // cong
   sortTable[0x7481]=3447;   // cong
   sortTable[0x9AA2]=3448;   // cong
   sortTable[0x8CE8]=3449;   // cong
   sortTable[0x93E6]=3450;   // cong
   sortTable[0x85C2]=3451;   // cong
   sortTable[0x84EF]=3452;   // cong
   sortTable[0x8310]=3453;   // cong
   sortTable[0x8B25]=3454;   // cong
   sortTable[0x8066]=3455;   // cong
   sortTable[0x9A44]=3456;   // cong
   sortTable[0x8AB4]=3457;   // cong
   sortTable[0x779B]=3458;   // cong
   sortTable[0x8061]=3459;   // cong
   sortTable[0x9A18]=3460;   // cong
   sortTable[0x5A43]=3461;   // cong
   sortTable[0x5B6E]=3462;   // cong
   sortTable[0x5F93]=3463;   // cong
   sortTable[0x5F96]=3464;   // cong
   sortTable[0x5FE9]=3465;   // cong
   sortTable[0x6031]=3466;   // cong
   sortTable[0x60A4]=3467;   // cong
   sortTable[0x60B0]=3468;   // cong
   sortTable[0x6152]=3469;   // cong
   sortTable[0x6181]=3470;   // cong
   sortTable[0x66B0]=3471;   // cong
   sortTable[0x68C7]=3472;   // cong
   sortTable[0x6A05]=3473;   // cong
   sortTable[0x6A2C]=3474;   // cong
   sortTable[0x6A37]=3475;   // cong
   sortTable[0x6B09]=3476;   // cong
   sortTable[0x6F0E]=3477;   // cong
   sortTable[0x6F17]=3478;   // cong
   sortTable[0x6F40]=3479;   // cong
   sortTable[0x6F68]=3480;   // cong
   sortTable[0x7047]=3481;   // cong
   sortTable[0x7127]=3482;   // cong
   sortTable[0x719C]=3483;   // cong
   sortTable[0x71EA]=3484;   // cong
   sortTable[0x721C]=3485;   // cong
   sortTable[0x747D]=3486;   // cong
   sortTable[0x7BF5]=3487;   // cong
   sortTable[0x7DEB]=3488;   // cong
   sortTable[0x7E71]=3489;   // cong
   sortTable[0x87CC]=3490;   // cong
   sortTable[0x8CE9]=3491;   // cong
   sortTable[0x936F]=3492;   // cong
   sortTable[0x51D1]=3493;   // cou
   sortTable[0x6E4A]=3494;   // cou
   sortTable[0x8F8F]=3495;   // cou
   sortTable[0x8160]=3496;   // cou
   sortTable[0x8F33]=3497;   // cou
   sortTable[0x7C97]=3498;   // cu
   sortTable[0x4FC3]=3499;   // cu
   sortTable[0x918B]=3500;   // cu
   sortTable[0x7C07]=3501;   // cu
   sortTable[0x9162]=3502;   // cu
   sortTable[0x8E59]=3503;   // cu
   sortTable[0x731D]=3504;   // cu
   sortTable[0x6B82]=3505;   // cu
   sortTable[0x8E74]=3506;   // cu
   sortTable[0x5F82]=3507;   // cu
   sortTable[0x851F]=3508;   // cu
   sortTable[0x8E27]=3509;   // cu
   sortTable[0x9EA4]=3510;   // cu
   sortTable[0x9863]=3511;   // cu
   sortTable[0x9E84]=3512;   // cu
   sortTable[0x89D5]=3513;   // cu
   sortTable[0x8128]=3514;   // cu
   sortTable[0x8A8E]=3515;   // cu
   sortTable[0x8E75]=3516;   // cu
   sortTable[0x5648]=3517;   // cu
   sortTable[0x61B1]=3518;   // cu
   sortTable[0x7604]=3519;   // cu
   sortTable[0x762F]=3520;   // cu
   sortTable[0x7E2C]=3521;   // cu
   sortTable[0x8D97]=3522;   // cu
   sortTable[0x9E81]=3523;   // cu
   sortTable[0x9F00]=3524;   // cu
   sortTable[0x7A9C]=3525;   // cuan
   sortTable[0x7AC4]=3526;   // cuan
   sortTable[0x7BE1]=3527;   // cuan
   sortTable[0x8E7F]=3528;   // cuan
   sortTable[0x64BA]=3529;   // cuan
   sortTable[0x7228]=3530;   // cuan
   sortTable[0x6C46]=3531;   // cuan
   sortTable[0x9569]=3532;   // cuan
   sortTable[0x7A73]=3533;   // cuan
   sortTable[0x5DD1]=3534;   // cuan
   sortTable[0x651B]=3535;   // cuan
   sortTable[0x6AD5]=3536;   // cuan
   sortTable[0x6B11]=3537;   // cuan
   sortTable[0x6BA9]=3538;   // cuan
   sortTable[0x71B6]=3539;   // cuan
   sortTable[0x7C12]=3540;   // cuan
   sortTable[0x8EA5]=3541;   // cuan
   sortTable[0x92D1]=3542;   // cuan
   sortTable[0x9479]=3543;   // cuan
   sortTable[0x8106]=3544;   // cui
   sortTable[0x6467]=3545;   // cui
   sortTable[0x50AC]=3546;   // cui
   sortTable[0x7CB9]=3547;   // cui
   sortTable[0x7FE0]=3548;   // cui
   sortTable[0x5D14]=3549;   // cui
   sortTable[0x60B4]=3550;   // cui
   sortTable[0x8403]=3551;   // cui
   sortTable[0x7601]=3552;   // cui
   sortTable[0x5550]=3553;   // cui
   sortTable[0x69B1]=3554;   // cui
   sortTable[0x7480]=3555;   // cui
   sortTable[0x6DEC]=3556;   // cui
   sortTable[0x6BF3]=3557;   // cui
   sortTable[0x7F1E]=3558;   // cui
   sortTable[0x7C8B]=3559;   // cui
   sortTable[0x7E17]=3560;   // cui
   sortTable[0x81AC]=3561;   // cui
   sortTable[0x81CE]=3562;   // cui
   sortTable[0x813A]=3563;   // cui
   sortTable[0x7DB7]=3564;   // cui
   sortTable[0x7AC1]=3565;   // cui
   sortTable[0x81B5]=3566;   // cui
   sortTable[0x78EA]=3567;   // cui
   sortTable[0x8DA1]=3568;   // cui
   sortTable[0x9847]=3569;   // cui
   sortTable[0x7D23]=3570;   // cui
   sortTable[0x7FC6]=3571;   // cui
   sortTable[0x8103]=3572;   // cui
   sortTable[0x4E7C]=3573;   // cui
   sortTable[0x4F1C]=3574;   // cui
   sortTable[0x5005]=3575;   // cui
   sortTable[0x51D7]=3576;   // cui
   sortTable[0x555B]=3577;   // cui
   sortTable[0x5894]=3578;   // cui
   sortTable[0x5D89]=3579;   // cui
   sortTable[0x5FF0]=3580;   // cui
   sortTable[0x615B]=3581;   // cui
   sortTable[0x69EF]=3582;   // cui
   sortTable[0x6F3C]=3583;   // cui
   sortTable[0x6FE2]=3584;   // cui
   sortTable[0x7120]=3585;   // cui
   sortTable[0x7355]=3586;   // cui
   sortTable[0x75A9]=3587;   // cui
   sortTable[0x76A0]=3588;   // cui
   sortTable[0x894A]=3589;   // cui
   sortTable[0x93D9]=3590;   // cui
   sortTable[0x6751]=3591;   // cun
   sortTable[0x5B58]=3592;   // cun
   sortTable[0x5BF8]=3593;   // cun
   sortTable[0x5FD6]=3594;   // cun
   sortTable[0x90A8]=3595;   // cun
   sortTable[0x76B4]=3596;   // cun
   sortTable[0x8E06]=3597;   // cun
   sortTable[0x7C7F]=3598;   // cun
   sortTable[0x4F9F]=3599;   // cun
   sortTable[0x520C]=3600;   // cun
   sortTable[0x540B]=3601;   // cun
   sortTable[0x62F5]=3602;   // cun
   sortTable[0x6F8A]=3603;   // cun
   sortTable[0x7AF4]=3604;   // cun
   sortTable[0x9519]=3605;   // cuo
   sortTable[0x932F]=3606;   // cuo
   sortTable[0x63AA]=3607;   // cuo
   sortTable[0x632B]=3608;   // cuo
   sortTable[0x6413]=3609;   // cuo
   sortTable[0x64AE]=3610;   // cuo
   sortTable[0x78CB]=3611;   // cuo
   sortTable[0x539D]=3612;   // cuo
   sortTable[0x9E7E]=3613;   // cuo
   sortTable[0x9509]=3614;   // cuo
   sortTable[0x5D6F]=3615;   // cuo
   sortTable[0x8E49]=3616;   // cuo
   sortTable[0x75E4]=3617;   // cuo
   sortTable[0x77EC]=3618;   // cuo
   sortTable[0x9142]=3619;   // cuo
   sortTable[0x811E]=3620;   // cuo
   sortTable[0x839D]=3621;   // cuo
   sortTable[0x9E7A]=3622;   // cuo
   sortTable[0x7749]=3623;   // cuo
   sortTable[0x8658]=3624;   // cuo
   sortTable[0x919D]=3625;   // cuo
   sortTable[0x84AB]=3626;   // cuo
   sortTable[0x84CC]=3627;   // cuo
   sortTable[0x8516]=3628;   // cuo
   sortTable[0x8EA6]=3629;   // cuo
   sortTable[0x5249]=3630;   // cuo
   sortTable[0x5252]=3631;   // cuo
   sortTable[0x590E]=3632;   // cuo
   sortTable[0x5D73]=3633;   // cuo
   sortTable[0x65AE]=3634;   // cuo
   sortTable[0x68E4]=3635;   // cuo
   sortTable[0x6B75]=3636;   // cuo
   sortTable[0x7473]=3637;   // cuo
   sortTable[0x83A1]=3638;   // cuo
   sortTable[0x902A]=3639;   // cuo
   sortTable[0x9073]=3640;   // cuo
   sortTable[0x92BC]=3641;   // cuo
   sortTable[0x5927]=4096;   // da
   sortTable[0x6253]=4097;   // da
   sortTable[0x8FBE]=4098;   // da
   sortTable[0x9054]=4099;   // da
   sortTable[0x7B54]=4100;   // da
   sortTable[0x642D]=4101;   // da
   sortTable[0x7629]=4102;   // da
   sortTable[0x8037]=4103;   // da
   sortTable[0x6C93]=4104;   // da
   sortTable[0x9791]=4105;   // da
   sortTable[0x54D2]=4106;   // da
   sortTable[0x977C]=4107;   // da
   sortTable[0x7B2A]=4108;   // da
   sortTable[0x55D2]=4109;   // da
   sortTable[0x59B2]=4110;   // da
   sortTable[0x8921]=4111;   // da
   sortTable[0x8345]=4112;   // da
   sortTable[0x601B]=4113;   // da
   sortTable[0x87FD]=4114;   // da
   sortTable[0x9618]=4115;   // da
   sortTable[0x7E68]=4116;   // da
   sortTable[0x7F8D]=4117;   // da
   sortTable[0x939D]=4118;   // da
   sortTable[0x8359]=4119;   // da
   sortTable[0x7B1A]=4120;   // da
   sortTable[0x5273]=4121;   // da
   sortTable[0x5312]=4122;   // da
   sortTable[0x547E]=4123;   // da
   sortTable[0x5491]=4124;   // da
   sortTable[0x5660]=4125;   // da
   sortTable[0x57AF]=4126;   // da
   sortTable[0x58B6]=4127;   // da
   sortTable[0x6498]=4128;   // da
   sortTable[0x6C4F]=4129;   // da
   sortTable[0x709F]=4130;   // da
   sortTable[0x71F5]=4131;   // da
   sortTable[0x7557]=4132;   // da
   sortTable[0x7563]=4133;   // da
   sortTable[0x7714]=4134;   // da
   sortTable[0x8598]=4135;   // da
   sortTable[0x8A5A]=4136;   // da
   sortTable[0x8E82]=4137;   // da
   sortTable[0x8FD6]=4138;   // da
   sortTable[0x9039]=4139;   // da
   sortTable[0x9389]=4140;   // da
   sortTable[0x943D]=4141;   // da
   sortTable[0x97C3]=4142;   // da
   sortTable[0x9F96]=4143;   // da
   sortTable[0x9F98]=4144;   // da
   sortTable[0x4EE3]=4145;   // dai
   sortTable[0x5E26]=4146;   // dai
   sortTable[0x5E36]=4147;   // dai
   sortTable[0x5F85]=4148;   // dai
   sortTable[0x888B]=4149;   // dai
   sortTable[0x6234]=4150;   // dai
   sortTable[0x5446]=4151;   // dai
   sortTable[0x902E]=4152;   // dai
   sortTable[0x8D37]=4153;   // dai
   sortTable[0x9EDB]=4154;   // dai
   sortTable[0x6020]=4155;   // dai
   sortTable[0x6B86]=4156;   // dai
   sortTable[0x6B79]=4157;   // dai
   sortTable[0x5CB1]=4158;   // dai
   sortTable[0x8FE8]=4159;   // dai
   sortTable[0x73B3]=4160;   // dai
   sortTable[0x50A3]=4161;   // dai
   sortTable[0x7ED0]=4162;   // dai
   sortTable[0x5454]=4163;   // dai
   sortTable[0x7519]=4164;   // dai
   sortTable[0x57ED]=4165;   // dai
   sortTable[0x9A80]=4166;   // dai
   sortTable[0x8F6A]=4167;   // dai
   sortTable[0x8E5B]=4168;   // dai
   sortTable[0x7D3F]=4169;   // dai
   sortTable[0x825C]=4170;   // dai
   sortTable[0x7C24]=4171;   // dai
   sortTable[0x8976]=4172;   // dai
   sortTable[0x9D0F]=4173;   // dai
   sortTable[0x8EDA]=4174;   // dai
   sortTable[0x9746]=4175;   // dai
   sortTable[0x8CB8]=4176;   // dai
   sortTable[0x9B98]=4177;   // dai
   sortTable[0x53C7]=4178;   // dai
   sortTable[0x5788]=4179;   // dai
   sortTable[0x5E12]=4180;   // dai
   sortTable[0x5E2F]=4181;   // dai
   sortTable[0x5ED7]=4182;   // dai
   sortTable[0x61DB]=4183;   // dai
   sortTable[0x66C3]=4184;   // dai
   sortTable[0x67CB]=4185;   // dai
   sortTable[0x703B]=4186;   // dai
   sortTable[0x7343]=4187;   // dai
   sortTable[0x7447]=4188;   // dai
   sortTable[0x7DFF]=4189;   // dai
   sortTable[0x8ED1]=4190;   // dai
   sortTable[0x8EE9]=4191;   // dai
   sortTable[0x9734]=4192;   // dai
   sortTable[0x9EF1]=4193;   // dai
   sortTable[0x4F46]=4194;   // dan
   sortTable[0x5355]=4195;   // dan
   sortTable[0x55AE]=4196;   // dan
   sortTable[0x5F39]=4197;   // dan
   sortTable[0x5F48]=4198;   // dan
   sortTable[0x62C5]=4199;   // dan
   sortTable[0x64D4]=4200;   // dan
   sortTable[0x86CB]=4201;   // dan
   sortTable[0x6DE1]=4202;   // dan
   sortTable[0x80C6]=4203;   // dan
   sortTable[0x81BD]=4204;   // dan
   sortTable[0x8BDE]=4205;   // dan
   sortTable[0x8A95]=4206;   // dan
   sortTable[0x65E6]=4207;   // dan
   sortTable[0x803D]=4208;   // dan
   sortTable[0x4E39]=4209;   // dan
   sortTable[0x6C2E]=4210;   // dan
   sortTable[0x6FB9]=4211;   // dan
   sortTable[0x60EE]=4212;   // dan
   sortTable[0x90F8]=4213;   // dan
   sortTable[0x5556]=4214;   // dan
   sortTable[0x7708]=4215;   // dan
   sortTable[0x6B9A]=4216;   // dan
   sortTable[0x510B]=4217;   // dan
   sortTable[0x63B8]=4218;   // dan
   sortTable[0x840F]=4219;   // dan
   sortTable[0x8043]=4220;   // dan
   sortTable[0x75B8]=4221;   // dan
   sortTable[0x7BAA]=4222;   // dan
   sortTable[0x79AB]=4223;   // dan
   sortTable[0x7D1E]=4224;   // dan
   sortTable[0x7605]=4225;   // dan
   sortTable[0x8711]=4226;   // dan
   sortTable[0x8D55]=4227;   // dan
   sortTable[0x8EAD]=4228;   // dan
   sortTable[0x894C]=4229;   // dan
   sortTable[0x9EEE]=4230;   // dan
   sortTable[0x8078]=4231;   // dan
   sortTable[0x972E]=4232;   // dan
   sortTable[0x7A9E]=4233;   // dan
   sortTable[0x9AE7]=4234;   // dan
   sortTable[0x994F]=4235;   // dan
   sortTable[0x7C1E]=4236;   // dan
   sortTable[0x84DE]=4237;   // dan
   sortTable[0x9D20]=4238;   // dan
   sortTable[0x8D09]=4239;   // dan
   sortTable[0x9132]=4240;   // dan
   sortTable[0x99F3]=4241;   // dan
   sortTable[0x9ED5]=4242;   // dan
   sortTable[0x7E75]=4243;   // dan
   sortTable[0x891D]=4244;   // dan
   sortTable[0x89DB]=4245;   // dan
   sortTable[0x4EB6]=4246;   // dan
   sortTable[0x4F14]=4247;   // dan
   sortTable[0x50E4]=4248;   // dan
   sortTable[0x5210]=4249;   // dan
   sortTable[0x52EF]=4250;   // dan
   sortTable[0x5330]=4251;   // dan
   sortTable[0x5358]=4252;   // dan
   sortTable[0x5557]=4253;   // dan
   sortTable[0x557F]=4254;   // dan
   sortTable[0x563E]=4255;   // dan
   sortTable[0x5649]=4256;   // dan
   sortTable[0x56AA]=4257;   // dan
   sortTable[0x5989]=4258;   // dan
   sortTable[0x5A85]=4259;   // dan
   sortTable[0x5E0E]=4260;   // dan
   sortTable[0x5F3E]=4261;   // dan
   sortTable[0x619A]=4262;   // dan
   sortTable[0x61BA]=4263;   // dan
   sortTable[0x628C]=4264;   // dan
   sortTable[0x64A2]=4265;   // dan
   sortTable[0x64A3]=4266;   // dan
   sortTable[0x66BA]=4267;   // dan
   sortTable[0x67E6]=4268;   // dan
   sortTable[0x6BAB]=4269;   // dan
   sortTable[0x6C8A]=4270;   // dan
   sortTable[0x6CF9]=4271;   // dan
   sortTable[0x6FB8]=4272;   // dan
   sortTable[0x72DA]=4273;   // dan
   sortTable[0x73AC]=4274;   // dan
   sortTable[0x74ED]=4275;   // dan
   sortTable[0x7514]=4276;   // dan
   sortTable[0x758D]=4277;   // dan
   sortTable[0x7649]=4278;   // dan
   sortTable[0x765A]=4279;   // dan
   sortTable[0x7803]=4280;   // dan
   sortTable[0x803C]=4281;   // dan
   sortTable[0x8145]=4282;   // dan
   sortTable[0x8874]=4283;   // dan
   sortTable[0x9815]=4284;   // dan
   sortTable[0x99BE]=4285;   // dan
   sortTable[0x515A]=4286;   // dang
   sortTable[0x9EE8]=4287;   // dang
   sortTable[0x5F53]=4288;   // dang
   sortTable[0x7576]=4289;   // dang
   sortTable[0x6321]=4290;   // dang
   sortTable[0x64CB]=4291;   // dang
   sortTable[0x8361]=4292;   // dang
   sortTable[0x8569]=4293;   // dang
   sortTable[0x6863]=4294;   // dang
   sortTable[0x6A94]=4295;   // dang
   sortTable[0x94DB]=4296;   // dang
   sortTable[0x943A]=4297;   // dang
   sortTable[0x8C20]=4298;   // dang
   sortTable[0x5B95]=4299;   // dang
   sortTable[0x88C6]=4300;   // dang
   sortTable[0x51FC]=4301;   // dang
   sortTable[0x7800]=4302;   // dang
   sortTable[0x83EA]=4303;   // dang
   sortTable[0x7B5C]=4304;   // dang
   sortTable[0x7C1C]=4305;   // dang
   sortTable[0x903F]=4306;   // dang
   sortTable[0x8DA4]=4307;   // dang
   sortTable[0x8B61]=4308;   // dang
   sortTable[0x7C39]=4309;   // dang
   sortTable[0x76EA]=4310;   // dang
   sortTable[0x78AD]=4311;   // dang
   sortTable[0x7911]=4312;   // dang
   sortTable[0x8261]=4313;   // dang
   sortTable[0x87F7]=4314;   // dang
   sortTable[0x8B9C]=4315;   // dang
   sortTable[0x5105]=4316;   // dang
   sortTable[0x5679]=4317;   // dang
   sortTable[0x5735]=4318;   // dang
   sortTable[0x57B1]=4319;   // dang
   sortTable[0x58CB]=4320;   // dang
   sortTable[0x5A78]=4321;   // dang
   sortTable[0x5D63]=4322;   // dang
   sortTable[0x6113]=4323;   // dang
   sortTable[0x6529]=4324;   // dang
   sortTable[0x6B13]=4325;   // dang
   sortTable[0x6C39]=4326;   // dang
   sortTable[0x6F52]=4327;   // dang
   sortTable[0x6FA2]=4328;   // dang
   sortTable[0x7059]=4329;   // dang
   sortTable[0x73F0]=4330;   // dang
   sortTable[0x7497]=4331;   // dang
   sortTable[0x74AB]=4332;   // dang
   sortTable[0x74FD]=4333;   // dang
   sortTable[0x778A]=4334;   // dang
   sortTable[0x862F]=4335;   // dang
   sortTable[0x8960]=4336;   // dang
   sortTable[0x95E3]=4337;   // dang
   sortTable[0x96FC]=4338;   // dang
   sortTable[0x5230]=4339;   // dao
   sortTable[0x9053]=4340;   // dao
   sortTable[0x5BFC]=4341;   // dao
   sortTable[0x5C0E]=4342;   // dao
   sortTable[0x5012]=4343;   // dao
   sortTable[0x5200]=4344;   // dao
   sortTable[0x5C9B]=4345;   // dao
   sortTable[0x5CF6]=4346;   // dao
   sortTable[0x7A3B]=4347;   // dao
   sortTable[0x76D7]=4348;   // dao
   sortTable[0x76DC]=4349;   // dao
   sortTable[0x6363]=4350;   // dao
   sortTable[0x6417]=4351;   // dao
   sortTable[0x60BC]=4352;   // dao
   sortTable[0x8E48]=4353;   // dao
   sortTable[0x7977]=4354;   // dao
   sortTable[0x53E8]=4355;   // dao
   sortTable[0x7118]=4356;   // dao
   sortTable[0x7E9B]=4357;   // dao
   sortTable[0x6C18]=4358;   // dao
   sortTable[0x5FC9]=4359;   // dao
   sortTable[0x7FFF]=4360;   // dao
   sortTable[0x8220]=4361;   // dao
   sortTable[0x7982]=4362;   // dao
   sortTable[0x9C7D]=4363;   // dao
   sortTable[0x79B1]=4364;   // dao
   sortTable[0x969D]=4365;   // dao
   sortTable[0x885C]=4366;   // dao
   sortTable[0x7FE2]=4367;   // dao
   sortTable[0x8EC7]=4368;   // dao
   sortTable[0x7A32]=4369;   // dao
   sortTable[0x885F]=4370;   // dao
   sortTable[0x9B5B]=4371;   // dao
   sortTable[0x5202]=4372;   // dao
   sortTable[0x5675]=4373;   // dao
   sortTable[0x58D4]=4374;   // dao
   sortTable[0x5C76]=4375;   // dao
   sortTable[0x5D8B]=4376;   // dao
   sortTable[0x5D8C]=4377;   // dao
   sortTable[0x5DB9]=4378;   // dao
   sortTable[0x636F]=4379;   // dao
   sortTable[0x64E3]=4380;   // dao
   sortTable[0x6737]=4381;   // dao
   sortTable[0x6921]=4382;   // dao
   sortTable[0x69DD]=4383;   // dao
   sortTable[0x6AA4]=4384;   // dao
   sortTable[0x71FE]=4385;   // dao
   sortTable[0x74D9]=4386;   // dao
   sortTable[0x7B8C]=4387;   // dao
   sortTable[0x83FF]=4388;   // dao
   sortTable[0x91D6]=4389;   // dao
   sortTable[0x9666]=4390;   // dao
   sortTable[0x96AF]=4391;   // dao
   sortTable[0x7684]=4392;   // de
   sortTable[0x5730]=4393;   // de
   sortTable[0x5F97]=4394;   // de
   sortTable[0x5FB7]=4395;   // de
   sortTable[0x951D]=4396;   // de
   sortTable[0x8126]=4397;   // de
   sortTable[0x561A]=4398;   // de
   sortTable[0x5FB3]=4399;   // de
   sortTable[0x6074]=4400;   // de
   sortTable[0x60EA]=4401;   // de
   sortTable[0x68CF]=4402;   // de
   sortTable[0x6DC2]=4403;   // de
   sortTable[0x9340]=4404;   // de
   sortTable[0x6265]=4405;   // den
   sortTable[0x627D]=4406;   // den
   sortTable[0x7B49]=4407;   // deng
   sortTable[0x706F]=4408;   // deng
   sortTable[0x71C8]=4409;   // deng
   sortTable[0x767B]=4410;   // deng
   sortTable[0x51F3]=4411;   // deng
   sortTable[0x77AA]=4412;   // deng
   sortTable[0x8E6C]=4413;   // deng
   sortTable[0x9093]=4414;   // deng
   sortTable[0x7C26]=4415;   // deng
   sortTable[0x956B]=4416;   // deng
   sortTable[0x5654]=4417;   // deng
   sortTable[0x78F4]=4418;   // deng
   sortTable[0x5D9D]=4419;   // deng
   sortTable[0x6225]=4420;   // deng
   sortTable[0x96A5]=4421;   // deng
   sortTable[0x9127]=4422;   // deng
   sortTable[0x7AF3]=4423;   // deng
   sortTable[0x89B4]=4424;   // deng
   sortTable[0x8C4B]=4425;   // deng
   sortTable[0x58B1]=4426;   // deng
   sortTable[0x5B01]=4427;   // deng
   sortTable[0x6729]=4428;   // deng
   sortTable[0x6AC8]=4429;   // deng
   sortTable[0x7492]=4430;   // deng
   sortTable[0x8260]=4431;   // deng
   sortTable[0x9419]=4432;   // deng
   sortTable[0x7B2C]=4433;   // di
   sortTable[0x654C]=4434;   // di
   sortTable[0x6575]=4435;   // di
   sortTable[0x5E95]=4436;   // di
   sortTable[0x4F4E]=4437;   // di
   sortTable[0x5E1D]=4438;   // di
   sortTable[0x5F1F]=4439;   // di
   sortTable[0x62B5]=4440;   // di
   sortTable[0x6EF4]=4441;   // di
   sortTable[0x9012]=4442;   // di
   sortTable[0x905E]=4443;   // di
   sortTable[0x5824]=4444;   // di
   sortTable[0x6DA4]=4445;   // di
   sortTable[0x6ECC]=4446;   // di
   sortTable[0x5600]=4447;   // di
   sortTable[0x7F14]=4448;   // di
   sortTable[0x7DE0]=4449;   // di
   sortTable[0x7B1B]=4450;   // di
   sortTable[0x8FEA]=4451;   // di
   sortTable[0x72C4]=4452;   // di
   sortTable[0x8482]=4453;   // di
   sortTable[0x90B8]=4454;   // di
   sortTable[0x6C10]=4455;   // di
   sortTable[0x5AE1]=4456;   // di
   sortTable[0x8C1B]=4457;   // di
   sortTable[0x7C74]=4458;   // di
   sortTable[0x68E3]=4459;   // di
   sortTable[0x8BCB]=4460;   // di
   sortTable[0x837B]=4461;   // di
   sortTable[0x7825]=4462;   // di
   sortTable[0x7998]=4463;   // di
   sortTable[0x9AB6]=4464;   // di
   sortTable[0x5A23]=4465;   // di
   sortTable[0x7F9D]=4466;   // di
   sortTable[0x89CC]=4467;   // di
   sortTable[0x78FE]=4468;   // di
   sortTable[0x97AE]=4469;   // di
   sortTable[0x955D]=4470;   // di
   sortTable[0x7747]=4471;   // di
   sortTable[0x67E2]=4472;   // di
   sortTable[0x9814]=4473;   // di
   sortTable[0x78B2]=4474;   // di
   sortTable[0x7731]=4475;   // di
   sortTable[0x9684]=4476;   // di
   sortTable[0x91F1]=4477;   // di
   sortTable[0x889B]=4478;   // di
   sortTable[0x83E7]=4479;   // di
   sortTable[0x8E36]=4480;   // di
   sortTable[0x7BF4]=4481;   // di
   sortTable[0x9AE2]=4482;   // di
   sortTable[0x976E]=4483;   // di
   sortTable[0x9070]=4484;   // di
   sortTable[0x9349]=4485;   // di
   sortTable[0x89DD]=4486;   // di
   sortTable[0x83C2]=4487;   // di
   sortTable[0x8515]=4488;   // di
   sortTable[0x8743]=4489;   // di
   sortTable[0x8E62]=4490;   // di
   sortTable[0x9E10]=4491;   // di
   sortTable[0x9B04]=4492;   // di
   sortTable[0x87AE]=4493;   // di
   sortTable[0x8EE7]=4494;   // di
   sortTable[0x963A]=4495;   // di
   sortTable[0x9013]=4496;   // di
   sortTable[0x7976]=4497;   // di
   sortTable[0x7CF4]=4498;   // di
   sortTable[0x805C]=4499;   // di
   sortTable[0x85E1]=4500;   // di
   sortTable[0x8163]=4501;   // di
   sortTable[0x82D6]=4502;   // di
   sortTable[0x8AE6]=4503;   // di
   sortTable[0x99B0]=4504;   // di
   sortTable[0x9BF3]=4505;   // di
   sortTable[0x4EFE]=4506;   // di
   sortTable[0x4FE4]=4507;   // di
   sortTable[0x5059]=4508;   // di
   sortTable[0x50C0]=4509;   // di
   sortTable[0x538E]=4510;   // di
   sortTable[0x5467]=4511;   // di
   sortTable[0x5519]=4512;   // di
   sortTable[0x5547]=4513;   // di
   sortTable[0x5572]=4514;   // di
   sortTable[0x5681]=4515;   // di
   sortTable[0x5754]=4516;   // di
   sortTable[0x5758]=4517;   // di
   sortTable[0x57CA]=4518;   // di
   sortTable[0x57DE]=4519;   // di
   sortTable[0x5891]=4520;   // di
   sortTable[0x58AC]=4521;   // di
   sortTable[0x5943]=4522;   // di
   sortTable[0x5A82]=4523;   // di
   sortTable[0x5DB3]=4524;   // di
   sortTable[0x5EF8]=4525;   // di
   sortTable[0x5F24]=4526;   // di
   sortTable[0x5F7D]=4527;   // di
   sortTable[0x601F]=4528;   // di
   sortTable[0x6178]=4529;   // di
   sortTable[0x62DE]=4530;   // di
   sortTable[0x638B]=4531;   // di
   sortTable[0x6455]=4532;   // di
   sortTable[0x65F3]=4533;   // di
   sortTable[0x6755]=4534;   // di
   sortTable[0x688A]=4535;   // di
   sortTable[0x6891]=4536;   // di
   sortTable[0x6A00]=4537;   // di
   sortTable[0x6E27]=4538;   // di
   sortTable[0x710D]=4539;   // di
   sortTable[0x7274]=4540;   // di
   sortTable[0x7393]=4541;   // di
   sortTable[0x73F6]=4542;   // di
   sortTable[0x750B]=4543;   // di
   sortTable[0x830B]=4544;   // di
   sortTable[0x850B]=4545;   // di
   sortTable[0x8510]=4546;   // di
   sortTable[0x89BF]=4547;   // di
   sortTable[0x8A46]=4548;   // di
   sortTable[0x8C74]=4549;   // di
   sortTable[0x8D86]=4550;   // di
   sortTable[0x926A]=4551;   // di
   sortTable[0x93D1]=4552;   // di
   sortTable[0x55F2]=4553;   // dia
   sortTable[0x70B9]=4554;   // dian
   sortTable[0x9EDE]=4555;   // dian
   sortTable[0x7535]=4556;   // dian
   sortTable[0x96FB]=4557;   // dian
   sortTable[0x5E97]=4558;   // dian
   sortTable[0x5178]=4559;   // dian
   sortTable[0x98A0]=4560;   // dian
   sortTable[0x985B]=4561;   // dian
   sortTable[0x6BBF]=4562;   // dian
   sortTable[0x6DC0]=4563;   // dian
   sortTable[0x6FB1]=4564;   // dian
   sortTable[0x7538]=4565;   // dian
   sortTable[0x5960]=4566;   // dian
   sortTable[0x57AB]=4567;   // dian
   sortTable[0x588A]=4568;   // dian
   sortTable[0x4F43]=4569;   // dian
   sortTable[0x60E6]=4570;   // dian
   sortTable[0x8E2E]=4571;   // dian
   sortTable[0x766B]=4572;   // dian
   sortTable[0x7C1F]=4573;   // dian
   sortTable[0x6EC7]=4574;   // dian
   sortTable[0x73B7]=4575;   // dian
   sortTable[0x94BF]=4576;   // dian
   sortTable[0x5DC5]=4577;   // dian
   sortTable[0x7898]=4578;   // dian
   sortTable[0x6382]=4579;   // dian
   sortTable[0x765C]=4580;   // dian
   sortTable[0x975B]=4581;   // dian
   sortTable[0x576B]=4582;   // dian
   sortTable[0x963D]=4583;   // dian
   sortTable[0x8714]=4584;   // dian
   sortTable[0x84A7]=4585;   // dian
   sortTable[0x9A54]=4586;   // dian
   sortTable[0x8DD5]=4587;   // dian
   sortTable[0x9F7B]=4588;   // dian
   sortTable[0x8E4E]=4589;   // dian
   sortTable[0x8547]=4590;   // dian
   sortTable[0x985A]=4591;   // dian
   sortTable[0x508E]=4592;   // dian
   sortTable[0x53A7]=4593;   // dian
   sortTable[0x56B8]=4594;   // dian
   sortTable[0x58C2]=4595;   // dian
   sortTable[0x594C]=4596;   // dian
   sortTable[0x5A5D]=4597;   // dian
   sortTable[0x5A70]=4598;   // dian
   sortTable[0x5D6E]=4599;   // dian
   sortTable[0x5DD3]=4600;   // dian
   sortTable[0x5DD4]=4601;   // dian
   sortTable[0x6242]=4602;   // dian
   sortTable[0x6527]=4603;   // dian
   sortTable[0x6541]=4604;   // dian
   sortTable[0x655F]=4605;   // dian
   sortTable[0x6923]=4606;   // dian
   sortTable[0x69C7]=4607;   // dian
   sortTable[0x69D9]=4608;   // dian
   sortTable[0x6A42]=4609;   // dian
   sortTable[0x6A5D]=4610;   // dian
   sortTable[0x7320]=4611;   // dian
   sortTable[0x7414]=4612;   // dian
   sortTable[0x7628]=4613;   // dian
   sortTable[0x7672]=4614;   // dian
   sortTable[0x6389]=4615;   // diao
   sortTable[0x8C03]=4616;   // diao
   sortTable[0x8ABF]=4617;   // diao
   sortTable[0x9493]=4618;   // diao
   sortTable[0x91E3]=4619;   // diao
   sortTable[0x540A]=4620;   // diao
   sortTable[0x96D5]=4621;   // diao
   sortTable[0x53FC]=4622;   // diao
   sortTable[0x5201]=4623;   // diao
   sortTable[0x51CB]=4624;   // diao
   sortTable[0x8C82]=4625;   // diao
   sortTable[0x7889]=4626;   // diao
   sortTable[0x94EB]=4627;   // diao
   sortTable[0x9CB7]=4628;   // diao
   sortTable[0x9D70]=4629;   // diao
   sortTable[0x7A8E]=4630;   // diao
   sortTable[0x94DE]=4631;   // diao
   sortTable[0x85CB]=4632;   // diao
   sortTable[0x8A0B]=4633;   // diao
   sortTable[0x9BDB]=4634;   // diao
   sortTable[0x92FD]=4635;   // diao
   sortTable[0x84E7]=4636;   // diao
   sortTable[0x86C1]=4637;   // diao
   sortTable[0x7AB5]=4638;   // diao
   sortTable[0x9B61]=4639;   // diao
   sortTable[0x866D]=4640;   // diao
   sortTable[0x96FF]=4641;   // diao
   sortTable[0x9CED]=4642;   // diao
   sortTable[0x4F04]=4643;   // diao
   sortTable[0x595D]=4644;   // diao
   sortTable[0x5C4C]=4645;   // diao
   sortTable[0x5F14]=4646;   // diao
   sortTable[0x5F34]=4647;   // diao
   sortTable[0x5F6B]=4648;   // diao
   sortTable[0x625A]=4649;   // diao
   sortTable[0x6BA6]=4650;   // diao
   sortTable[0x6C48]=4651;   // diao
   sortTable[0x7431]=4652;   // diao
   sortTable[0x7639]=4653;   // diao
   sortTable[0x7797]=4654;   // diao
   sortTable[0x7AE8]=4655;   // diao
   sortTable[0x7C13]=4656;   // diao
   sortTable[0x92B1]=4657;   // diao
   sortTable[0x9443]=4658;   // diao
   sortTable[0x9B89]=4659;   // diao
   sortTable[0x9F26]=4660;   // diao
   sortTable[0x7239]=4661;   // die
   sortTable[0x8DCC]=4662;   // die
   sortTable[0x53E0]=4663;   // die
   sortTable[0x758A]=4664;   // die
   sortTable[0x8776]=4665;   // die
   sortTable[0x789F]=4666;   // die
   sortTable[0x8C0D]=4667;   // die
   sortTable[0x8FED]=4668;   // die
   sortTable[0x7252]=4669;   // die
   sortTable[0x558B]=4670;   // die
   sortTable[0x7ED6]=4671;   // die
   sortTable[0x581E]=4672;   // die
   sortTable[0x8E40]=4673;   // die
   sortTable[0x800B]=4674;   // die
   sortTable[0x63F2]=4675;   // die
   sortTable[0x7730]=4676;   // die
   sortTable[0x57A4]=4677;   // die
   sortTable[0x74DE]=4678;   // die
   sortTable[0x9CBD]=4679;   // die
   sortTable[0x7D70]=4680;   // die
   sortTable[0x890B]=4681;   // die
   sortTable[0x8253]=4682;   // die
   sortTable[0x8A44]=4683;   // die
   sortTable[0x8728]=4684;   // die
   sortTable[0x7723]=4685;   // die
   sortTable[0x800A]=4686;   // die
   sortTable[0x957B]=4687;   // die
   sortTable[0x9C08]=4688;   // die
   sortTable[0x82F5]=4689;   // die
   sortTable[0x54CB]=4690;   // die
   sortTable[0x5CCC]=4691;   // die
   sortTable[0x5D7D]=4692;   // die
   sortTable[0x5E49]=4693;   // die
   sortTable[0x604E]=4694;   // die
   sortTable[0x60F5]=4695;   // die
   sortTable[0x621C]=4696;   // die
   sortTable[0x6315]=4697;   // die
   sortTable[0x6633]=4698;   // die
   sortTable[0x66E1]=4699;   // die
   sortTable[0x6B9C]=4700;   // die
   sortTable[0x6C0E]=4701;   // die
   sortTable[0x7243]=4702;   // die
   sortTable[0x7573]=4703;   // die
   sortTable[0x7582]=4704;   // die
   sortTable[0x7589]=4705;   // die
   sortTable[0x80C5]=4706;   // die
   sortTable[0x81F7]=4707;   // die
   sortTable[0x893A]=4708;   // die
   sortTable[0x8ADC]=4709;   // die
   sortTable[0x8D83]=4710;   // die
   sortTable[0x5B9A]=4711;   // ding
   sortTable[0x9876]=4712;   // ding
   sortTable[0x9802]=4713;   // ding
   sortTable[0x8BA2]=4714;   // ding
   sortTable[0x8A02]=4715;   // ding
   sortTable[0x76EF]=4716;   // ding
   sortTable[0x9489]=4717;   // ding
   sortTable[0x91D8]=4718;   // ding
   sortTable[0x53EE]=4719;   // ding
   sortTable[0x4E01]=4720;   // ding
   sortTable[0x952D]=4721;   // ding
   sortTable[0x9320]=4722;   // ding
   sortTable[0x9F0E]=4723;   // ding
   sortTable[0x7887]=4724;   // ding
   sortTable[0x815A]=4725;   // ding
   sortTable[0x914A]=4726;   // ding
   sortTable[0x94E4]=4727;   // ding
   sortTable[0x4EC3]=4728;   // ding
   sortTable[0x5576]=4729;   // ding
   sortTable[0x738E]=4730;   // ding
   sortTable[0x7594]=4731;   // ding
   sortTable[0x8035]=4732;   // ding
   sortTable[0x9964]=4733;   // ding
   sortTable[0x77F4]=4734;   // ding
   sortTable[0x78F8]=4735;   // ding
   sortTable[0x8670]=4736;   // ding
   sortTable[0x9F11]=4737;   // ding
   sortTable[0x9424]=4738;   // ding
   sortTable[0x98E3]=4739;   // ding
   sortTable[0x78A0]=4740;   // ding
   sortTable[0x85A1]=4741;   // ding
   sortTable[0x9841]=4742;   // ding
   sortTable[0x5975]=4743;   // ding
   sortTable[0x5D7F]=4744;   // ding
   sortTable[0x5E04]=4745;   // ding
   sortTable[0x5FCA]=4746;   // ding
   sortTable[0x6917]=4747;   // ding
   sortTable[0x6FCE]=4748;   // ding
   sortTable[0x8062]=4749;   // ding
   sortTable[0x8423]=4750;   // ding
   sortTable[0x874A]=4751;   // ding
   sortTable[0x92CC]=4752;   // ding
   sortTable[0x976A]=4753;   // ding
   sortTable[0x4E22]=4754;   // diu
   sortTable[0x4E1F]=4755;   // diu
   sortTable[0x94E5]=4756;   // diu
   sortTable[0x92A9]=4757;   // diu
   sortTable[0x52A8]=4758;   // dong
   sortTable[0x52D5]=4759;   // dong
   sortTable[0x4E1C]=4760;   // dong
   sortTable[0x6771]=4761;   // dong
   sortTable[0x61C2]=4762;   // dong
   sortTable[0x51AC]=4763;   // dong
   sortTable[0x6D1E]=4764;   // dong
   sortTable[0x51BB]=4765;   // dong
   sortTable[0x51CD]=4766;   // dong
   sortTable[0x8463]=4767;   // dong
   sortTable[0x680B]=4768;   // dong
   sortTable[0x549A]=4769;   // dong
   sortTable[0x5CD2]=4770;   // dong
   sortTable[0x4F97]=4771;   // dong
   sortTable[0x606B]=4772;   // dong
   sortTable[0x80E8]=4773;   // dong
   sortTable[0x6C21]=4774;   // dong
   sortTable[0x9E2B]=4775;   // dong
   sortTable[0x7850]=4776;   // dong
   sortTable[0x5CBD]=4777;   // dong
   sortTable[0x80F4]=4778;   // dong
   sortTable[0x9D87]=4779;   // dong
   sortTable[0x8740]=4780;   // dong
   sortTable[0x578C]=4781;   // dong
   sortTable[0x9F15]=4782;   // dong
   sortTable[0x7BBD]=4783;   // dong
   sortTable[0x9718]=4784;   // dong
   sortTable[0x856B]=4785;   // dong
   sortTable[0x7B17]=4786;   // dong
   sortTable[0x99E7]=4787;   // dong
   sortTable[0x83C4]=4788;   // dong
   sortTable[0x9DAB]=4789;   // dong
   sortTable[0x8FF5]=4790;   // dong
   sortTable[0x9D24]=4791;   // dong
   sortTable[0x5032]=4792;   // dong
   sortTable[0x50CD]=4793;   // dong
   sortTable[0x57EC]=4794;   // dong
   sortTable[0x58A5]=4795;   // dong
   sortTable[0x59DB]=4796;   // dong
   sortTable[0x5A3B]=4797;   // dong
   sortTable[0x5B1E]=4798;   // dong
   sortTable[0x5D20]=4799;   // dong
   sortTable[0x5D2C]=4800;   // dong
   sortTable[0x5F9A]=4801;   // dong
   sortTable[0x6219]=4802;   // dong
   sortTable[0x630F]=4803;   // dong
   sortTable[0x6638]=4804;   // dong
   sortTable[0x68DF]=4805;   // dong
   sortTable[0x6C2D]=4806;   // dong
   sortTable[0x6DB7]=4807;   // dong
   sortTable[0x6E69]=4808;   // dong
   sortTable[0x7D67]=4809;   // dong
   sortTable[0x8156]=4810;   // dong
   sortTable[0x82F3]=4811;   // dong
   sortTable[0x8ACC]=4812;   // dong
   sortTable[0x9B97]=4813;   // dong
   sortTable[0x9BDF]=4814;   // dong
   sortTable[0x90FD]=4815;   // dou
   sortTable[0x6597]=4816;   // dou
   sortTable[0x8C46]=4817;   // dou
   sortTable[0x6296]=4818;   // dou
   sortTable[0x9017]=4819;   // dou
   sortTable[0x515C]=4820;   // dou
   sortTable[0x9661]=4821;   // dou
   sortTable[0x86AA]=4822;   // dou
   sortTable[0x7AA6]=4823;   // dou
   sortTable[0x75D8]=4824;   // dou
   sortTable[0x8130]=4825;   // dou
   sortTable[0x997E]=4826;   // dou
   sortTable[0x8254]=4827;   // dou
   sortTable[0x8538]=4828;   // dou
   sortTable[0x8373]=4829;   // dou
   sortTable[0x9916]=4830;   // dou
   sortTable[0x7AC7]=4831;   // dou
   sortTable[0x7BFC]=4832;   // dou
   sortTable[0x9597]=4833;   // dou
   sortTable[0x9158]=4834;   // dou
   sortTable[0x90D6]=4835;   // dou
   sortTable[0x95D8]=4836;   // dou
   sortTable[0x4E67]=4837;   // dou
   sortTable[0x5160]=4838;   // dou
   sortTable[0x543A]=4839;   // dou
   sortTable[0x5517]=4840;   // dou
   sortTable[0x551E]=4841;   // dou
   sortTable[0x65A3]=4842;   // dou
   sortTable[0x6793]=4843;   // dou
   sortTable[0x67A1]=4844;   // dou
   sortTable[0x68AA]=4845;   // dou
   sortTable[0x6A77]=4846;   // dou
   sortTable[0x6BED]=4847;   // dou
   sortTable[0x6D62]=4848;   // dou
   sortTable[0x9204]=4849;   // dou
   sortTable[0x9627]=4850;   // dou
   sortTable[0x9B25]=4851;   // dou
   sortTable[0x9B26]=4852;   // dou
   sortTable[0x9B2A]=4853;   // dou
   sortTable[0x9B2C]=4854;   // dou
   sortTable[0x9B2D]=4855;   // dou
   sortTable[0x5EA6]=4856;   // du
   sortTable[0x8BFB]=4857;   // du
   sortTable[0x8B80]=4858;   // du
   sortTable[0x72EC]=4859;   // du
   sortTable[0x7368]=4860;   // du
   sortTable[0x6BD2]=4861;   // du
   sortTable[0x6E21]=4862;   // du
   sortTable[0x809A]=4863;   // du
   sortTable[0x5835]=4864;   // du
   sortTable[0x7763]=4865;   // du
   sortTable[0x9540]=4866;   // du
   sortTable[0x934D]=4867;   // du
   sortTable[0x675C]=4868;   // du
   sortTable[0x8D4C]=4869;   // du
   sortTable[0x8CED]=4870;   // du
   sortTable[0x7B03]=4871;   // du
   sortTable[0x7779]=4872;   // du
   sortTable[0x5992]=4873;   // du
   sortTable[0x6E0E]=4874;   // du
   sortTable[0x561F]=4875;   // du
   sortTable[0x724D]=4876;   // du
   sortTable[0x8839]=4877;   // du
   sortTable[0x728A]=4878;   // du
   sortTable[0x828F]=4879;   // du
   sortTable[0x9EE9]=4880;   // du
   sortTable[0x9AD1]=4881;   // du
   sortTable[0x9607]=4882;   // du
   sortTable[0x691F]=4883;   // du
   sortTable[0x78A1]=4884;   // du
   sortTable[0x8B9F]=4885;   // du
   sortTable[0x89A9]=4886;   // du
   sortTable[0x97E3]=4887;   // du
   sortTable[0x95CD]=4888;   // du
   sortTable[0x79FA]=4889;   // du
   sortTable[0x97E5]=4890;   // du
   sortTable[0x97C7]=4891;   // du
   sortTable[0x9A33]=4892;   // du
   sortTable[0x88FB]=4893;   // du
   sortTable[0x945F]=4894;   // du
   sortTable[0x7BE4]=4895;   // du
   sortTable[0x8827]=4896;   // du
   sortTable[0x8773]=4897;   // du
   sortTable[0x8799]=4898;   // du
   sortTable[0x7C35]=4899;   // du
   sortTable[0x9316]=4900;   // du
   sortTable[0x51DF]=4901;   // du
   sortTable[0x5262]=4902;   // du
   sortTable[0x5335]=4903;   // du
   sortTable[0x53BE]=4904;   // du
   sortTable[0x59AC]=4905;   // du
   sortTable[0x5B3B]=4906;   // du
   sortTable[0x5E3E]=4907;   // du
   sortTable[0x6ADD]=4908;   // du
   sortTable[0x6BAC]=4909;   // du
   sortTable[0x6BB0]=4910;   // du
   sortTable[0x6D9C]=4911;   // du
   sortTable[0x7006]=4912;   // du
   sortTable[0x7258]=4913;   // du
   sortTable[0x72A2]=4914;   // du
   sortTable[0x743D]=4915;   // du
   sortTable[0x74C4]=4916;   // du
   sortTable[0x76BE]=4917;   // du
   sortTable[0x8370]=4918;   // du
   sortTable[0x8AAD]=4919;   // du
   sortTable[0x8C44]=4920;   // du
   sortTable[0x8D15]=4921;   // du
   sortTable[0x918F]=4922;   // du
   sortTable[0x976F]=4923;   // du
   sortTable[0x9EF7]=4924;   // du
   sortTable[0x65AD]=4925;   // duan
   sortTable[0x65B7]=4926;   // duan
   sortTable[0x6BB5]=4927;   // duan
   sortTable[0x77ED]=4928;   // duan
   sortTable[0x7AEF]=4929;   // duan
   sortTable[0x953B]=4930;   // duan
   sortTable[0x935B]=4931;   // duan
   sortTable[0x7F0E]=4932;   // duan
   sortTable[0x7DDE]=4933;   // duan
   sortTable[0x6934]=4934;   // duan
   sortTable[0x7145]=4935;   // duan
   sortTable[0x8011]=4936;   // duan
   sortTable[0x8176]=4937;   // duan
   sortTable[0x890D]=4938;   // duan
   sortTable[0x7C16]=4939;   // duan
   sortTable[0x846E]=4940;   // duan
   sortTable[0x5073]=4941;   // duan
   sortTable[0x526C]=4942;   // duan
   sortTable[0x5845]=4943;   // duan
   sortTable[0x5A8F]=4944;   // duan
   sortTable[0x6BC8]=4945;   // duan
   sortTable[0x7456]=4946;   // duan
   sortTable[0x78AB]=4947;   // duan
   sortTable[0x7C6A]=4948;   // duan
   sortTable[0x8E96]=4949;   // duan
   sortTable[0x9374]=4950;   // duan
   sortTable[0x5BF9]=4951;   // dui
   sortTable[0x5C0D]=4952;   // dui
   sortTable[0x961F]=4953;   // dui
   sortTable[0x968A]=4954;   // dui
   sortTable[0x5806]=4955;   // dui
   sortTable[0x5151]=4956;   // dui
   sortTable[0x603C]=4957;   // dui
   sortTable[0x7893]=4958;   // dui
   sortTable[0x619D]=4959;   // dui
   sortTable[0x9566]=4960;   // dui
   sortTable[0x794B]=4961;   // dui
   sortTable[0x9827]=4962;   // dui
   sortTable[0x9413]=4963;   // dui
   sortTable[0x8B48]=4964;   // dui
   sortTable[0x9D2D]=4965;   // dui
   sortTable[0x78D3]=4966;   // dui
   sortTable[0x941C]=4967;   // dui
   sortTable[0x966E]=4968;   // dui
   sortTable[0x514A]=4969;   // dui
   sortTable[0x514C]=4970;   // dui
   sortTable[0x5796]=4971;   // dui
   sortTable[0x5860]=4972;   // dui
   sortTable[0x5BFE]=4973;   // dui
   sortTable[0x5D5F]=4974;   // dui
   sortTable[0x619E]=4975;   // dui
   sortTable[0x61DF]=4976;   // dui
   sortTable[0x6FE7]=4977;   // dui
   sortTable[0x7029]=4978;   // dui
   sortTable[0x75FD]=4979;   // dui
   sortTable[0x7D90]=4980;   // dui
   sortTable[0x85B1]=4981;   // dui
   sortTable[0x8968]=4982;   // dui
   sortTable[0x76FE]=4983;   // dun
   sortTable[0x987F]=4984;   // dun
   sortTable[0x9813]=4985;   // dun
   sortTable[0x5428]=4986;   // dun
   sortTable[0x5678]=4987;   // dun
   sortTable[0x8E72]=4988;   // dun
   sortTable[0x58A9]=4989;   // dun
   sortTable[0x6566]=4990;   // dun
   sortTable[0x9041]=4991;   // dun
   sortTable[0x949D]=4992;   // dun
   sortTable[0x6C8C]=4993;   // dun
   sortTable[0x7096]=4994;   // dun
   sortTable[0x76F9]=4995;   // dun
   sortTable[0x8DB8]=4996;   // dun
   sortTable[0x56E4]=4997;   // dun
   sortTable[0x7818]=4998;   // dun
   sortTable[0x906F]=4999;   // dun
   sortTable[0x7905]=5000;   // dun
   sortTable[0x9A50]=5001;   // dun
   sortTable[0x8E7E]=5002;   // dun
   sortTable[0x920D]=5003;   // dun
   sortTable[0x8733]=5004;   // dun
   sortTable[0x9007]=5005;   // dun
   sortTable[0x8E89]=5006;   // dun
   sortTable[0x4F05]=5007;   // dun
   sortTable[0x58AA]=5008;   // dun
   sortTable[0x5E89]=5009;   // dun
   sortTable[0x60C7]=5010;   // dun
   sortTable[0x6489]=5011;   // dun
   sortTable[0x64B4]=5012;   // dun
   sortTable[0x696F]=5013;   // dun
   sortTable[0x6A54]=5014;   // dun
   sortTable[0x6F61]=5015;   // dun
   sortTable[0x71C9]=5016;   // dun
   sortTable[0x729C]=5017;   // dun
   sortTable[0x7364]=5018;   // dun
   sortTable[0x78B7]=5019;   // dun
   sortTable[0x8E32]=5020;   // dun
   sortTable[0x591A]=5021;   // duo
   sortTable[0x593A]=5022;   // duo
   sortTable[0x596A]=5023;   // duo
   sortTable[0x8EB2]=5024;   // duo
   sortTable[0x6735]=5025;   // duo
   sortTable[0x8E31]=5026;   // duo
   sortTable[0x54C6]=5027;   // duo
   sortTable[0x8DFA]=5028;   // duo
   sortTable[0x5815]=5029;   // duo
   sortTable[0x94CE]=5030;   // duo
   sortTable[0x5484]=5031;   // duo
   sortTable[0x60F0]=5032;   // duo
   sortTable[0x8235]=5033;   // duo
   sortTable[0x88F0]=5034;   // duo
   sortTable[0x6387]=5035;   // duo
   sortTable[0x579B]=5036;   // duo
   sortTable[0x54DA]=5037;   // duo
   sortTable[0x9438]=5038;   // duo
   sortTable[0x5241]=5039;   // duo
   sortTable[0x7F0D]=5040;   // duo
   sortTable[0x67C1]=5041;   // duo
   sortTable[0x9973]=5042;   // duo
   sortTable[0x964A]=5043;   // duo
   sortTable[0x8EC3]=5044;   // duo
   sortTable[0x9D7D]=5045;   // duo
   sortTable[0x8D93]=5046;   // duo
   sortTable[0x8EB1]=5047;   // duo
   sortTable[0x964F]=5048;   // duo
   sortTable[0x98FF]=5049;   // duo
   sortTable[0x9BB5]=5050;   // duo
   sortTable[0x4EB8]=5051;   // duo
   sortTable[0x51D9]=5052;   // duo
   sortTable[0x5234]=5053;   // duo
   sortTable[0x525F]=5054;   // duo
   sortTable[0x526B]=5055;   // duo
   sortTable[0x55A5]=5056;   // duo
   sortTable[0x5689]=5057;   // duo
   sortTable[0x56B2]=5058;   // duo
   sortTable[0x579C]=5059;   // duo
   sortTable[0x57F5]=5060;   // duo
   sortTable[0x58AE]=5061;   // duo
   sortTable[0x58AF]=5062;   // duo
   sortTable[0x591B]=5063;   // duo
   sortTable[0x5972]=5064;   // duo
   sortTable[0x5C2E]=5065;   // duo
   sortTable[0x5D1C]=5066;   // duo
   sortTable[0x5D9E]=5067;   // duo
   sortTable[0x60B3]=5068;   // duo
   sortTable[0x619C]=5069;   // duo
   sortTable[0x6305]=5070;   // duo
   sortTable[0x6306]=5071;   // duo
   sortTable[0x6553]=5072;   // duo
   sortTable[0x655A]=5073;   // duo
   sortTable[0x6560]=5074;   // duo
   sortTable[0x656A]=5075;   // duo
   sortTable[0x6736]=5076;   // duo
   sortTable[0x67A4]=5077;   // duo
   sortTable[0x67EE]=5078;   // duo
   sortTable[0x6857]=5079;   // duo
   sortTable[0x692F]=5080;   // duo
   sortTable[0x6BF2]=5081;   // duo
   sortTable[0x70A8]=5082;   // duo
   sortTable[0x7553]=5083;   // duo
   sortTable[0x75E5]=5084;   // duo
   sortTable[0x7D9E]=5085;   // duo
   sortTable[0x8DE2]=5086;   // duo
   sortTable[0x8DE5]=5087;   // duo
   sortTable[0x922C]=5088;   // duo
   sortTable[0x937A]=5089;   // duo
   sortTable[0x7565]=5376;   // e
   sortTable[0x997F]=5377;   // e
   sortTable[0x9913]=5378;   // e
   sortTable[0x6076]=5379;   // e
   sortTable[0x60E1]=5380;   // e
   sortTable[0x989D]=5381;   // e
   sortTable[0x984D]=5382;   // e
   sortTable[0x63A0]=5383;   // e
   sortTable[0x9E45]=5384;   // e
   sortTable[0x9D5D]=5385;   // e
   sortTable[0x6115]=5386;   // e
   sortTable[0x5443]=5387;   // e
   sortTable[0x9CC4]=5388;   // e
   sortTable[0x9C77]=5389;   // e
   sortTable[0x4FC4]=5390;   // e
   sortTable[0x5CE8]=5391;   // e
   sortTable[0x86FE]=5392;   // e
   sortTable[0x5A25]=5393;   // e
   sortTable[0x5384]=5394;   // e
   sortTable[0x9102]=5395;   // e
   sortTable[0x904F]=5396;   // e
   sortTable[0x627C]=5397;   // e
   sortTable[0x8BB9]=5398;   // e
   sortTable[0x8C14]=5399;   // e
   sortTable[0x843C]=5400;   // e
   sortTable[0x5669]=5401;   // e
   sortTable[0x9E57]=5402;   // e
   sortTable[0x960F]=5403;   // e
   sortTable[0x9537]=5404;   // e
   sortTable[0x5A40]=5405;   // e
   sortTable[0x989A]=5406;   // e
   sortTable[0x57A9]=5407;   // e
   sortTable[0x82CA]=5408;   // e
   sortTable[0x9507]=5409;   // e
   sortTable[0x8F6D]=5410;   // e
   sortTable[0x816D]=5411;   // e
   sortTable[0x5C59]=5412;   // e
   sortTable[0x83AA]=5413;   // e
   sortTable[0x9628]=5414;   // e
   sortTable[0x981E]=5415;   // e
   sortTable[0x94B6]=5416;   // e
   sortTable[0x8A7B]=5417;   // e
   sortTable[0x8B4C]=5418;   // e
   sortTable[0x8A1B]=5419;   // e
   sortTable[0x774B]=5420;   // e
   sortTable[0x9C2A]=5421;   // e
   sortTable[0x855A]=5422;   // e
   sortTable[0x8EF6]=5423;   // e
   sortTable[0x9D9A]=5424;   // e
   sortTable[0x922A]=5425;   // e
   sortTable[0x981F]=5426;   // e
   sortTable[0x8FD7]=5427;   // e
   sortTable[0x96B2]=5428;   // e
   sortTable[0x8EDB]=5429;   // e
   sortTable[0x9638]=5430;   // e
   sortTable[0x980B]=5431;   // e
   sortTable[0x984E]=5432;   // e
   sortTable[0x9F43]=5433;   // e
   sortTable[0x8685]=5434;   // e
   sortTable[0x8A90]=5435;   // e
   sortTable[0x9354]=5436;   // e
   sortTable[0x7828]=5437;   // e
   sortTable[0x7918]=5438;   // e
   sortTable[0x8741]=5439;   // e
   sortTable[0x8B8D]=5440;   // e
   sortTable[0x920B]=5441;   // e
   sortTable[0x9A00]=5442;   // e
   sortTable[0x9B65]=5443;   // e
   sortTable[0x9F76]=5444;   // e
   sortTable[0x5054]=5445;   // e
   sortTable[0x50EB]=5446;   // e
   sortTable[0x530E]=5447;   // e
   sortTable[0x537E]=5448;   // e
   sortTable[0x542A]=5449;   // e
   sortTable[0x545D]=5450;   // e
   sortTable[0x54A2]=5451;   // e
   sortTable[0x54B9]=5452;   // e
   sortTable[0x5641]=5453;   // e
   sortTable[0x56EE]=5454;   // e
   sortTable[0x580A]=5455;   // e
   sortTable[0x582E]=5456;   // e
   sortTable[0x59B8]=5457;   // e
   sortTable[0x59BF]=5458;   // e
   sortTable[0x59F6]=5459;   // e
   sortTable[0x5A3F]=5460;   // e
   sortTable[0x5C75]=5461;   // e
   sortTable[0x5C8B]=5462;   // e
   sortTable[0x5CC9]=5463;   // e
   sortTable[0x5CE9]=5464;   // e
   sortTable[0x5D3F]=5465;   // e
   sortTable[0x5EC5]=5466;   // e
   sortTable[0x60AA]=5467;   // e
   sortTable[0x6239]=5468;   // e
   sortTable[0x6424]=5469;   // e
   sortTable[0x6439]=5470;   // e
   sortTable[0x64DC]=5471;   // e
   sortTable[0x6799]=5472;   // e
   sortTable[0x6AEE]=5473;   // e
   sortTable[0x6B5E]=5474;   // e
   sortTable[0x6B7A]=5475;   // e
   sortTable[0x6D90]=5476;   // e
   sortTable[0x6E42]=5477;   // e
   sortTable[0x73F4]=5478;   // e
   sortTable[0x7427]=5479;   // e
   sortTable[0x75FE]=5480;   // e
   sortTable[0x7692]=5481;   // e
   sortTable[0x7808]=5482;   // e
   sortTable[0x7810]=5483;   // e
   sortTable[0x7846]=5484;   // e
   sortTable[0x78C0]=5485;   // e
   sortTable[0x89A8]=5486;   // e
   sortTable[0x8AE4]=5487;   // e
   sortTable[0x8C5F]=5488;   // e
   sortTable[0x8C96]=5489;   // e
   sortTable[0x904C]=5490;   // e
   sortTable[0x9469]=5491;   // e
   sortTable[0x95BC]=5492;   // e
   sortTable[0x9929]=5493;   // e
   sortTable[0x9B64]=5494;   // e
   sortTable[0x9C10]=5495;   // e
   sortTable[0x9D48]=5496;   // e
   sortTable[0x9D5E]=5497;   // e
   sortTable[0x8BF6]=5498;   // ei
   sortTable[0x8A92]=5499;   // ei
   sortTable[0x55EF]=5500;   // en
   sortTable[0x6069]=5501;   // en
   sortTable[0x6441]=5502;   // en
   sortTable[0x84BD]=5503;   // en
   sortTable[0x5940]=5504;   // en
   sortTable[0x5CCE]=5505;   // en
   sortTable[0x717E]=5506;   // en
   sortTable[0x97A5]=5507;   // eng
   sortTable[0x800C]=5508;   // er
   sortTable[0x513F]=5509;   // er
   sortTable[0x5152]=5510;   // er
   sortTable[0x4E8C]=5511;   // er
   sortTable[0x8033]=5512;   // er
   sortTable[0x5C14]=5513;   // er
   sortTable[0x723E]=5514;   // er
   sortTable[0x8D30]=5515;   // er
   sortTable[0x8FE9]=5516;   // er
   sortTable[0x9975]=5517;   // er
   sortTable[0x73E5]=5518;   // er
   sortTable[0x9E38]=5519;   // er
   sortTable[0x6D31]=5520;   // er
   sortTable[0x94D2]=5521;   // er
   sortTable[0x4F74]=5522;   // er
   sortTable[0x7CAB]=5523;   // er
   sortTable[0x8F5C]=5524;   // er
   sortTable[0x9C95]=5525;   // er
   sortTable[0x8F00]=5526;   // er
   sortTable[0x8A80]=5527;   // er
   sortTable[0x9087]=5528;   // er
   sortTable[0x9D2F]=5529;   // er
   sortTable[0x8DB0]=5530;   // er
   sortTable[0x99EC]=5531;   // er
   sortTable[0x80F9]=5532;   // er
   sortTable[0x85BE]=5533;   // er
   sortTable[0x9651]=5534;   // er
   sortTable[0x834B]=5535;   // er
   sortTable[0x8848]=5536;   // er
   sortTable[0x8CAE]=5537;   // er
   sortTable[0x990C]=5538;   // er
   sortTable[0x9AF5]=5539;   // er
   sortTable[0x4F95]=5540;   // er
   sortTable[0x5150]=5541;   // er
   sortTable[0x5235]=5542;   // er
   sortTable[0x53BC]=5543;   // er
   sortTable[0x54A1]=5544;   // er
   sortTable[0x5532]=5545;   // er
   sortTable[0x5C12]=5546;   // er
   sortTable[0x5C13]=5547;   // er
   sortTable[0x5CCF]=5548;   // er
   sortTable[0x5F0D]=5549;   // er
   sortTable[0x5F10]=5550;   // er
   sortTable[0x682D]=5551;   // er
   sortTable[0x682E]=5552;   // er
   sortTable[0x6A32]=5553;   // er
   sortTable[0x6BE6]=5554;   // er
   sortTable[0x6D0F]=5555;   // er
   sortTable[0x804F]=5556;   // er
   sortTable[0x88BB]=5557;   // er
   sortTable[0x8CB3]=5558;   // er
   sortTable[0x927A]=5559;   // er
   sortTable[0x96AD]=5560;   // er
   sortTable[0x9B9E]=5561;   // er
   sortTable[0x53D1]=5888;   // fa
   sortTable[0x767C]=5889;   // fa
   sortTable[0x6CD5]=5890;   // fa
   sortTable[0x4E4F]=5891;   // fa
   sortTable[0x4F10]=5892;   // fa
   sortTable[0x9600]=5893;   // fa
   sortTable[0x95A5]=5894;   // fa
   sortTable[0x7F5A]=5895;   // fa
   sortTable[0x7F70]=5896;   // fa
   sortTable[0x7B4F]=5897;   // fa
   sortTable[0x57A1]=5898;   // fa
   sortTable[0x781D]=5899;   // fa
   sortTable[0x73D0]=5900;   // fa
   sortTable[0x9AEE]=5901;   // fa
   sortTable[0x8337]=5902;   // fa
   sortTable[0x9AEA]=5903;   // fa
   sortTable[0x7782]=5904;   // fa
   sortTable[0x9166]=5905;   // fa
   sortTable[0x855F]=5906;   // fa
   sortTable[0x85C5]=5907;   // fa
   sortTable[0x91B1]=5908;   // fa
   sortTable[0x4F71]=5909;   // fa
   sortTable[0x50A0]=5910;   // fa
   sortTable[0x59C2]=5911;   // fa
   sortTable[0x5F42]=5912;   // fa
   sortTable[0x6830]=5913;   // fa
   sortTable[0x6A43]=5914;   // fa
   sortTable[0x6CB7]=5915;   // fa
   sortTable[0x6D4C]=5916;   // fa
   sortTable[0x704B]=5917;   // fa
   sortTable[0x743A]=5918;   // fa
   sortTable[0x75BA]=5919;   // fa
   sortTable[0x767A]=5920;   // fa
   sortTable[0x7F78]=5921;   // fa
   sortTable[0x9345]=5922;   // fa
   sortTable[0x53CD]=5923;   // fan
   sortTable[0x996D]=5924;   // fan
   sortTable[0x98EF]=5925;   // fan
   sortTable[0x7FFB]=5926;   // fan
   sortTable[0x72AF]=5927;   // fan
   sortTable[0x8303]=5928;   // fan
   sortTable[0x6CDB]=5929;   // fan
   sortTable[0x51E1]=5930;   // fan
   sortTable[0x7E41]=5931;   // fan
   sortTable[0x756A]=5932;   // fan
   sortTable[0x70E6]=5933;   // fan
   sortTable[0x7169]=5934;   // fan
   sortTable[0x8FD4]=5935;   // fan
   sortTable[0x5E06]=5936;   // fan
   sortTable[0x8D29]=5937;   // fan
   sortTable[0x8CA9]=5938;   // fan
   sortTable[0x8543]=5939;   // fan
   sortTable[0x85E9]=5940;   // fan
   sortTable[0x6A0A]=5941;   // fan
   sortTable[0x7C53]=5942;   // fan
   sortTable[0x5E61]=5943;   // fan
   sortTable[0x68B5]=5944;   // fan
   sortTable[0x71D4]=5945;   // fan
   sortTable[0x7548]=5946;   // fan
   sortTable[0x77FE]=5947;   // fan
   sortTable[0x8629]=5948;   // fan
   sortTable[0x9492]=5949;   // fan
   sortTable[0x9407]=5950;   // fan
   sortTable[0x8E6F]=5951;   // fan
   sortTable[0x7E59]=5952;   // fan
   sortTable[0x8F53]=5953;   // fan
   sortTable[0x7BC4]=5954;   // fan
   sortTable[0x81B0]=5955;   // fan
   sortTable[0x8A09]=5956;   // fan
   sortTable[0x881C]=5957;   // fan
   sortTable[0x8ED3]=5958;   // fan
   sortTable[0x7B32]=5959;   // fan
   sortTable[0x7B35]=5960;   // fan
   sortTable[0x9422]=5961;   // fan
   sortTable[0x98BF]=5962;   // fan
   sortTable[0x98F0]=5963;   // fan
   sortTable[0x85A0]=5964;   // fan
   sortTable[0x98DC]=5965;   // fan
   sortTable[0x76D5]=5966;   // fan
   sortTable[0x7DD0]=5967;   // fan
   sortTable[0x9C55]=5968;   // fan
   sortTable[0x9DED]=5969;   // fan
   sortTable[0x7C75]=5970;   // fan
   sortTable[0x7FB3]=5971;   // fan
   sortTable[0x8EEC]=5972;   // fan
   sortTable[0x91E9]=5973;   // fan
   sortTable[0x51E2]=5974;   // fan
   sortTable[0x51E3]=5975;   // fan
   sortTable[0x52EB]=5976;   // fan
   sortTable[0x5643]=5977;   // fan
   sortTable[0x58A6]=5978;   // fan
   sortTable[0x597F]=5979;   // fan
   sortTable[0x5A4F]=5980;   // fan
   sortTable[0x5B0E]=5981;   // fan
   sortTable[0x5B0F]=5982;   // fan
   sortTable[0x5FDB]=5983;   // fan
   sortTable[0x61A3]=5984;   // fan
   sortTable[0x6255]=5985;   // fan
   sortTable[0x65D9]=5986;   // fan
   sortTable[0x65DB]=5987;   // fan
   sortTable[0x674B]=5988;   // fan
   sortTable[0x67C9]=5989;   // fan
   sortTable[0x68E5]=5990;   // fan
   sortTable[0x6A4E]=5991;   // fan
   sortTable[0x6C3E]=5992;   // fan
   sortTable[0x6C4E]=5993;   // fan
   sortTable[0x6E22]=5994;   // fan
   sortTable[0x6EFC]=5995;   // fan
   sortTable[0x702A]=5996;   // fan
   sortTable[0x703F]=5997;   // fan
   sortTable[0x74A0]=5998;   // fan
   sortTable[0x792C]=5999;   // fan
   sortTable[0x8224]=6000;   // fan
   sortTable[0x8227]=6001;   // fan
   sortTable[0x894E]=6002;   // fan
   sortTable[0x65B9]=6003;   // fang
   sortTable[0x653E]=6004;   // fang
   sortTable[0x623F]=6005;   // fang
   sortTable[0x9632]=6006;   // fang
   sortTable[0x4EFF]=6007;   // fang
   sortTable[0x7EBA]=6008;   // fang
   sortTable[0x7D21]=6009;   // fang
   sortTable[0x8BBF]=6010;   // fang
   sortTable[0x8A2A]=6011;   // fang
   sortTable[0x59A8]=6012;   // fang
   sortTable[0x574A]=6013;   // fang
   sortTable[0x80AA]=6014;   // fang
   sortTable[0x82B3]=6015;   // fang
   sortTable[0x822B]=6016;   // fang
   sortTable[0x5F77]=6017;   // fang
   sortTable[0x531A]=6018;   // fang
   sortTable[0x9C82]=6019;   // fang
   sortTable[0x678B]=6020;   // fang
   sortTable[0x94AB]=6021;   // fang
   sortTable[0x90A1]=6022;   // fang
   sortTable[0x8684]=6023;   // fang
   sortTable[0x9AE3]=6024;   // fang
   sortTable[0x9D0B]=6025;   // fang
   sortTable[0x8DBD]=6026;   // fang
   sortTable[0x9C1F]=6027;   // fang
   sortTable[0x7706]=6028;   // fang
   sortTable[0x9B74]=6029;   // fang
   sortTable[0x9DAD]=6030;   // fang
   sortTable[0x5023]=6031;   // fang
   sortTable[0x57C5]=6032;   // fang
   sortTable[0x580F]=6033;   // fang
   sortTable[0x65CA]=6034;   // fang
   sortTable[0x6609]=6035;   // fang
   sortTable[0x6618]=6036;   // fang
   sortTable[0x6C78]=6037;   // fang
   sortTable[0x6DD3]=6038;   // fang
   sortTable[0x7265]=6039;   // fang
   sortTable[0x74EC]=6040;   // fang
   sortTable[0x9201]=6041;   // fang
   sortTable[0x933A]=6042;   // fang
   sortTable[0x98DE]=6043;   // fei
   sortTable[0x98DB]=6044;   // fei
   sortTable[0x975E]=6045;   // fei
   sortTable[0x8D39]=6046;   // fei
   sortTable[0x8CBB]=6047;   // fei
   sortTable[0x80A5]=6048;   // fei
   sortTable[0x532A]=6049;   // fei
   sortTable[0x5E9F]=6050;   // fei
   sortTable[0x5EE2]=6051;   // fei
   sortTable[0x80BA]=6052;   // fei
   sortTable[0x6CB8]=6053;   // fei
   sortTable[0x5561]=6054;   // fei
   sortTable[0x83F2]=6055;   // fei
   sortTable[0x5983]=6056;   // fei
   sortTable[0x6590]=6057;   // fei
   sortTable[0x7EEF]=6058;   // fei
   sortTable[0x5420]=6059;   // fei
   sortTable[0x8BFD]=6060;   // fei
   sortTable[0x72D2]=6061;   // fei
   sortTable[0x6249]=6062;   // fei
   sortTable[0x8153]=6063;   // fei
   sortTable[0x7FE1]=6064;   // fei
   sortTable[0x6DDD]=6065;   // fei
   sortTable[0x82BE]=6066;   // fei
   sortTable[0x871A]=6067;   // fei
   sortTable[0x970F]=6068;   // fei
   sortTable[0x69A7]=6069;   // fei
   sortTable[0x7BDA]=6070;   // fei
   sortTable[0x9544]=6071;   // fei
   sortTable[0x60B1]=6072;   // fei
   sortTable[0x9CB1]=6073;   // fei
   sortTable[0x75F1]=6074;   // fei
   sortTable[0x9A11]=6075;   // fei
   sortTable[0x99A1]=6076;   // fei
   sortTable[0x9BE1]=6077;   // fei
   sortTable[0x855C]=6078;   // fei
   sortTable[0x9428]=6079;   // fei
   sortTable[0x9F23]=6080;   // fei
   sortTable[0x80C7]=6081;   // fei
   sortTable[0x8730]=6082;   // fei
   sortTable[0x88F6]=6083;   // fei
   sortTable[0x9A1B]=6084;   // fei
   sortTable[0x7DCB]=6085;   // fei
   sortTable[0x8409]=6086;   // fei
   sortTable[0x87E6]=6087;   // fei
   sortTable[0x9925]=6088;   // fei
   sortTable[0x4FF7]=6089;   // fei
   sortTable[0x5255]=6090;   // fei
   sortTable[0x539E]=6091;   // fei
   sortTable[0x595C]=6092;   // fei
   sortTable[0x5A53]=6093;   // fei
   sortTable[0x5A54]=6094;   // fei
   sortTable[0x5C5D]=6095;   // fei
   sortTable[0x5EC3]=6096;   // fei
   sortTable[0x6632]=6097;   // fei
   sortTable[0x6683]=6098;   // fei
   sortTable[0x66CA]=6099;   // fei
   sortTable[0x670F]=6100;   // fei
   sortTable[0x676E]=6101;   // fei
   sortTable[0x68D0]=6102;   // fei
   sortTable[0x6AE0]=6103;   // fei
   sortTable[0x6E04]=6104;   // fei
   sortTable[0x6FF7]=6105;   // fei
   sortTable[0x7306]=6106;   // fei
   sortTable[0x75BF]=6107;   // fei
   sortTable[0x7648]=6108;   // fei
   sortTable[0x8AB9]=6109;   // fei
   sortTable[0x966B]=6110;   // fei
   sortTable[0x9745]=6111;   // fei
   sortTable[0x975F]=6112;   // fei
   sortTable[0x98DD]=6113;   // fei
   sortTable[0x5206]=6114;   // fen
   sortTable[0x594B]=6115;   // fen
   sortTable[0x596E]=6116;   // fen
   sortTable[0x7C89]=6117;   // fen
   sortTable[0x6124]=6118;   // fen
   sortTable[0x61A4]=6119;   // fen
   sortTable[0x7EB7]=6120;   // fen
   sortTable[0x7D1B]=6121;   // fen
   sortTable[0x4EFD]=6122;   // fen
   sortTable[0x5FFF]=6123;   // fen
   sortTable[0x5429]=6124;   // fen
   sortTable[0x575F]=6125;   // fen
   sortTable[0x58B3]=6126;   // fen
   sortTable[0x7CAA]=6127;   // fen
   sortTable[0x7CDE]=6128;   // fen
   sortTable[0x6C1B]=6129;   // fen
   sortTable[0x82AC]=6130;   // fen
   sortTable[0x711A]=6131;   // fen
   sortTable[0x6C7E]=6132;   // fen
   sortTable[0x507E]=6133;   // fen
   sortTable[0x915A]=6134;   // fen
   sortTable[0x68FC]=6135;   // fen
   sortTable[0x8561]=6136;   // fen
   sortTable[0x86A1]=6137;   // fen
   sortTable[0x96F0]=6138;   // fen
   sortTable[0x7FC2]=6139;   // fen
   sortTable[0x7035]=6140;   // fen
   sortTable[0x9F22]=6141;   // fen
   sortTable[0x81B9]=6142;   // fen
   sortTable[0x9CBC]=6143;   // fen
   sortTable[0x9959]=6144;   // fen
   sortTable[0x7F92]=6145;   // fen
   sortTable[0x7FB5]=6146;   // fen
   sortTable[0x9F16]=6147;   // fen
   sortTable[0x8A1C]=6148;   // fen
   sortTable[0x9216]=6149;   // fen
   sortTable[0x9B75]=6150;   // fen
   sortTable[0x8C6E]=6151;   // fen
   sortTable[0x8F52]=6152;   // fen
   sortTable[0x9934]=6153;   // fen
   sortTable[0x9EFA]=6154;   // fen
   sortTable[0x50E8]=6155;   // fen
   sortTable[0x515D]=6156;   // fen
   sortTable[0x517A]=6157;   // fen
   sortTable[0x54DB]=6158;   // fen
   sortTable[0x59A2]=6159;   // fen
   sortTable[0x5C8E]=6160;   // fen
   sortTable[0x5E09]=6161;   // fen
   sortTable[0x5E69]=6162;   // fen
   sortTable[0x5F05]=6163;   // fen
   sortTable[0x6610]=6164;   // fen
   sortTable[0x6706]=6165;   // fen
   sortTable[0x670C]=6166;   // fen
   sortTable[0x678C]=6167;   // fen
   sortTable[0x68A4]=6168;   // fen
   sortTable[0x68FB]=6169;   // fen
   sortTable[0x6A68]=6170;   // fen
   sortTable[0x6FC6]=6171;   // fen
   sortTable[0x7083]=6172;   // fen
   sortTable[0x71CC]=6173;   // fen
   sortTable[0x71D3]=6174;   // fen
   sortTable[0x79CE]=6175;   // fen
   sortTable[0x7AD5]=6176;   // fen
   sortTable[0x80A6]=6177;   // fen
   sortTable[0x84B6]=6178;   // fen
   sortTable[0x86A0]=6179;   // fen
   sortTable[0x886F]=6180;   // fen
   sortTable[0x8C76]=6181;   // fen
   sortTable[0x8EAE]=6182;   // fen
   sortTable[0x943C]=6183;   // fen
   sortTable[0x96AB]=6184;   // fen
   sortTable[0x999A]=6185;   // fen
   sortTable[0x99A9]=6186;   // fen
   sortTable[0x9C5D]=6187;   // fen
   sortTable[0x9EC2]=6188;   // fen
   sortTable[0x98CE]=6189;   // feng
   sortTable[0x98A8]=6190;   // feng
   sortTable[0x5C01]=6191;   // feng
   sortTable[0x4E30]=6192;   // feng
   sortTable[0x75AF]=6193;   // feng
   sortTable[0x760B]=6194;   // feng
   sortTable[0x8702]=6195;   // feng
   sortTable[0x5CF0]=6196;   // feng
   sortTable[0x7F1D]=6197;   // feng
   sortTable[0x7E2B]=6198;   // feng
   sortTable[0x950B]=6199;   // feng
   sortTable[0x92D2]=6200;   // feng
   sortTable[0x9022]=6201;   // feng
   sortTable[0x5949]=6202;   // feng
   sortTable[0x51E4]=6203;   // feng
   sortTable[0x9CF3]=6204;   // feng
   sortTable[0x8BBD]=6205;   // feng
   sortTable[0x8AF7]=6206;   // feng
   sortTable[0x51AF]=6207;   // feng
   sortTable[0x4FF8]=6208;   // feng
   sortTable[0x67AB]=6209;   // feng
   sortTable[0x70FD]=6210;   // feng
   sortTable[0x8451]=6211;   // feng
   sortTable[0x9146]=6212;   // feng
   sortTable[0x6CA3]=6213;   // feng
   sortTable[0x781C]=6214;   // feng
   sortTable[0x8D57]=6215;   // feng
   sortTable[0x552A]=6216;   // feng
   sortTable[0x8982]=6217;   // feng
   sortTable[0x8CF5]=6218;   // feng
   sortTable[0x9137]=6219;   // feng
   sortTable[0x9EB7]=6220;   // feng
   sortTable[0x8C50]=6221;   // feng
   sortTable[0x8634]=6222;   // feng
   sortTable[0x7D98]=6223;   // feng
   sortTable[0x8242]=6224;   // feng
   sortTable[0x99AE]=6225;   // feng
   sortTable[0x882D]=6226;   // feng
   sortTable[0x93E0]=6227;   // feng
   sortTable[0x76FD]=6228;   // feng
   sortTable[0x78B8]=6229;   // feng
   sortTable[0x7BC8]=6230;   // feng
   sortTable[0x974A]=6231;   // feng
   sortTable[0x98CC]=6232;   // feng
   sortTable[0x4EF9]=6233;   // feng
   sortTable[0x5051]=6234;   // feng
   sortTable[0x50FC]=6235;   // feng
   sortTable[0x51E8]=6236;   // feng
   sortTable[0x51EC]=6237;   // feng
   sortTable[0x51EE]=6238;   // feng
   sortTable[0x5838]=6239;   // feng
   sortTable[0x5906]=6240;   // feng
   sortTable[0x59A6]=6241;   // feng
   sortTable[0x5BF7]=6242;   // feng
   sortTable[0x5CEF]=6243;   // feng
   sortTable[0x5D36]=6244;   // feng
   sortTable[0x6340]=6245;   // feng
   sortTable[0x6453]=6246;   // feng
   sortTable[0x687B]=6247;   // feng
   sortTable[0x6953]=6248;   // feng
   sortTable[0x6A92]=6249;   // feng
   sortTable[0x6CA8]=6250;   // feng
   sortTable[0x6D72]=6251;   // feng
   sortTable[0x6E57]=6252;   // feng
   sortTable[0x6E84]=6253;   // feng
   sortTable[0x6F28]=6254;   // feng
   sortTable[0x7043]=6255;   // feng
   sortTable[0x7128]=6256;   // feng
   sortTable[0x7148]=6257;   // feng
   sortTable[0x728E]=6258;   // feng
   sortTable[0x7326]=6259;   // feng
   sortTable[0x7412]=6260;   // feng
   sortTable[0x752E]=6261;   // feng
   sortTable[0x8615]=6262;   // feng
   sortTable[0x93BD]=6263;   // feng
   sortTable[0x95CF]=6264;   // feng
   sortTable[0x973B]=6265;   // feng
   sortTable[0x9CEF]=6266;   // feng
   sortTable[0x9D0C]=6267;   // feng
   sortTable[0x8985]=6268;   // fiao
   sortTable[0x4ECF]=6269;   // fo
   sortTable[0x5772]=6270;   // fo
   sortTable[0x68BB]=6271;   // fo
   sortTable[0x5426]=6272;   // fou
   sortTable[0x7F36]=6273;   // fou
   sortTable[0x7D11]=6274;   // fou
   sortTable[0x7F3B]=6275;   // fou
   sortTable[0x7F39]=6276;   // fou
   sortTable[0x88E6]=6277;   // fou
   sortTable[0x9D00]=6278;   // fou
   sortTable[0x599A]=6279;   // fou
   sortTable[0x6B95]=6280;   // fou
   sortTable[0x96EC]=6281;   // fou
   sortTable[0x590D]=6282;   // fu
   sortTable[0x8907]=6283;   // fu
   sortTable[0x670D]=6284;   // fu
   sortTable[0x7236]=6285;   // fu
   sortTable[0x5E9C]=6286;   // fu
   sortTable[0x592B]=6287;   // fu
   sortTable[0x8D1F]=6288;   // fu
   sortTable[0x8CA0]=6289;   // fu
   sortTable[0x5987]=6290;   // fu
   sortTable[0x5A66]=6291;   // fu
   sortTable[0x5BCC]=6292;   // fu
   sortTable[0x526F]=6293;   // fu
   sortTable[0x4F5B]=6294;   // fu
   sortTable[0x5085]=6295;   // fu
   sortTable[0x798F]=6296;   // fu
   sortTable[0x9644]=6297;   // fu
   sortTable[0x6D6E]=6298;   // fu
   sortTable[0x5E45]=6299;   // fu
   sortTable[0x4F0F]=6300;   // fu
   sortTable[0x8150]=6301;   // fu
   sortTable[0x80A4]=6302;   // fu
   sortTable[0x819A]=6303;   // fu
   sortTable[0x7B26]=6304;   // fu
   sortTable[0x4ED8]=6305;   // fu
   sortTable[0x5490]=6306;   // fu
   sortTable[0x6276]=6307;   // fu
   sortTable[0x65A7]=6308;   // fu
   sortTable[0x88B1]=6309;   // fu
   sortTable[0x7F1A]=6310;   // fu
   sortTable[0x7E1B]=6311;   // fu
   sortTable[0x8F85]=6312;   // fu
   sortTable[0x4FD8]=6313;   // fu
   sortTable[0x8F90]=6314;   // fu
   sortTable[0x8F14]=6315;   // fu
   sortTable[0x8F3B]=6316;   // fu
   sortTable[0x8986]=6317;   // fu
   sortTable[0x8179]=6318;   // fu
   sortTable[0x4FEF]=6319;   // fu
   sortTable[0x6577]=6320;   // fu
   sortTable[0x5B75]=6321;   // fu
   sortTable[0x8760]=6322;   // fu
   sortTable[0x629A]=6323;   // fu
   sortTable[0x64AB]=6324;   // fu
   sortTable[0x8D74]=6325;   // fu
   sortTable[0x752B]=6326;   // fu
   sortTable[0x51EB]=6327;   // fu
   sortTable[0x9CE7]=6328;   // fu
   sortTable[0x5F17]=6329;   // fu
   sortTable[0x8D4B]=6330;   // fu
   sortTable[0x62C2]=6331;   // fu
   sortTable[0x8299]=6332;   // fu
   sortTable[0x961C]=6333;   // fu
   sortTable[0x5B5A]=6334;   // fu
   sortTable[0x9A78]=6335;   // fu
   sortTable[0x7954]=6336;   // fu
   sortTable[0x8151]=6337;   // fu
   sortTable[0x82FB]=6338;   // fu
   sortTable[0x91DC]=6339;   // fu
   sortTable[0x911C]=6340;   // fu
   sortTable[0x99A5]=6341;   // fu
   sortTable[0x62CA]=6342;   // fu
   sortTable[0x9C8B]=6343;   // fu
   sortTable[0x86A8]=6344;   // fu
   sortTable[0x8DBA]=6345;   // fu
   sortTable[0x83D4]=6346;   // fu
   sortTable[0x6DAA]=6347;   // fu
   sortTable[0x9EFC]=6348;   // fu
   sortTable[0x6C1F]=6349;   // fu
   sortTable[0x8BA3]=6350;   // fu
   sortTable[0x5310]=6351;   // fu
   sortTable[0x83A9]=6352;   // fu
   sortTable[0x8D59]=6353;   // fu
   sortTable[0x7829]=6354;   // fu
   sortTable[0x5452]=6355;   // fu
   sortTable[0x7F58]=6356;   // fu
   sortTable[0x8DD7]=6357;   // fu
   sortTable[0x876E]=6358;   // fu
   sortTable[0x9EFB]=6359;   // fu
   sortTable[0x544B]=6360;   // fu
   sortTable[0x7EC2]=6361;   // fu
   sortTable[0x90DB]=6362;   // fu
   sortTable[0x7C20]=6363;   // fu
   sortTable[0x832F]=6364;   // fu
   sortTable[0x5E5E]=6365;   // fu
   sortTable[0x6ECF]=6366;   // fu
   sortTable[0x6874]=6367;   // fu
   sortTable[0x602B]=6368;   // fu
   sortTable[0x8709]=6369;   // fu
   sortTable[0x7953]=6370;   // fu
   sortTable[0x9207]=6371;   // fu
   sortTable[0x9EB8]=6372;   // fu
   sortTable[0x7ECB]=6373;   // fu
   sortTable[0x982B]=6374;   // fu
   sortTable[0x8300]=6375;   // fu
   sortTable[0x97E8]=6376;   // fu
   sortTable[0x7D8D]=6377;   // fu
   sortTable[0x8274]=6378;   // fu
   sortTable[0x8659]=6379;   // fu
   sortTable[0x8946]=6380;   // fu
   sortTable[0x889D]=6381;   // fu
   sortTable[0x842F]=6382;   // fu
   sortTable[0x9B34]=6383;   // fu
   sortTable[0x8914]=6384;   // fu
   sortTable[0x7B99]=6385;   // fu
   sortTable[0x8342]=6386;   // fu
   sortTable[0x7A03]=6387;   // fu
   sortTable[0x82A3]=6388;   // fu
   sortTable[0x9CC6]=6389;   // fu
   sortTable[0x90D9]=6390;   // fu
   sortTable[0x8F39]=6391;   // fu
   sortTable[0x9D69]=6392;   // fu
   sortTable[0x7B30]=6393;   // fu
   sortTable[0x844D]=6394;   // fu
   sortTable[0x9D9D]=6395;   // fu
   sortTable[0x7D92]=6396;   // fu
   sortTable[0x8CE6]=6397;   // fu
   sortTable[0x91E1]=6398;   // fu
   sortTable[0x7F66]=6399;   // fu
   sortTable[0x9B84]=6400;   // fu
   sortTable[0x9351]=6401;   // fu
   sortTable[0x9CFA]=6402;   // fu
   sortTable[0x909E]=6403;   // fu
   sortTable[0x7806]=6404;   // fu
   sortTable[0x79A3]=6405;   // fu
   sortTable[0x7CB0]=6406;   // fu
   sortTable[0x7D28]=6407;   // fu
   sortTable[0x7B5F]=6408;   // fu
   sortTable[0x8A03]=6409;   // fu
   sortTable[0x97CD]=6410;   // fu
   sortTable[0x7D3C]=6411;   // fu
   sortTable[0x8567]=6412;   // fu
   sortTable[0x8705]=6413;   // fu
   sortTable[0x8984]=6414;   // fu
   sortTable[0x9362]=6415;   // fu
   sortTable[0x9AF4]=6416;   // fu
   sortTable[0x9EA9]=6417;   // fu
   sortTable[0x7D31]=6418;   // fu
   sortTable[0x7DEE]=6419;   // fu
   sortTable[0x8374]=6420;   // fu
   sortTable[0x86A5]=6421;   // fu
   sortTable[0x86B9]=6422;   // fu
   sortTable[0x886D]=6423;   // fu
   sortTable[0x8C67]=6424;   // fu
   sortTable[0x8CFB]=6425;   // fu
   sortTable[0x9D14]=6426;   // fu
   sortTable[0x4E40]=6427;   // fu
   sortTable[0x4E76]=6428;   // fu
   sortTable[0x4F15]=6429;   // fu
   sortTable[0x4FCC]=6430;   // fu
   sortTable[0x4FDB]=6431;   // fu
   sortTable[0x5069]=6432;   // fu
   sortTable[0x51A8]=6433;   // fu
   sortTable[0x51B9]=6434;   // fu
   sortTable[0x521C]=6435;   // fu
   sortTable[0x5488]=6436;   // fu
   sortTable[0x54F9]=6437;   // fu
   sortTable[0x5638]=6438;   // fu
   sortTable[0x5711]=6439;   // fu
   sortTable[0x577F]=6440;   // fu
   sortTable[0x5798]=6441;   // fu
   sortTable[0x57BA]=6442;   // fu
   sortTable[0x598B]=6443;   // fu
   sortTable[0x59C7]=6444;   // fu
   sortTable[0x5A10]=6445;   // fu
   sortTable[0x5A8D]=6446;   // fu
   sortTable[0x5B14]=6447;   // fu
   sortTable[0x5C03]=6448;   // fu
   sortTable[0x5CAA]=6449;   // fu
   sortTable[0x5CCA]=6450;   // fu
   sortTable[0x5DFF]=6451;   // fu
   sortTable[0x5F23]=6452;   // fu
   sortTable[0x5F7F]=6453;   // fu
   sortTable[0x5FA9]=6454;   // fu
   sortTable[0x6024]=6455;   // fu
   sortTable[0x61EF]=6456;   // fu
   sortTable[0x636C]=6457;   // fu
   sortTable[0x64A8]=6458;   // fu
   sortTable[0x65C9]=6459;   // fu
   sortTable[0x678E]=6460;   // fu
   sortTable[0x67CE]=6461;   // fu
   sortTable[0x67EB]=6462;   // fu
   sortTable[0x683F]=6463;   // fu
   sortTable[0x68F4]=6464;   // fu
   sortTable[0x6928]=6465;   // fu
   sortTable[0x6931]=6466;   // fu
   sortTable[0x6991]=6467;   // fu
   sortTable[0x6CED]=6468;   // fu
   sortTable[0x6D11]=6469;   // fu
   sortTable[0x6F93]=6470;   // fu
   sortTable[0x70A5]=6471;   // fu
   sortTable[0x70F0]=6472;   // fu
   sortTable[0x7124]=6473;   // fu
   sortTable[0x739E]=6474;   // fu
   sortTable[0x73B8]=6475;   // fu
   sortTable[0x7408]=6476;   // fu
   sortTable[0x7536]=6477;   // fu
   sortTable[0x7549]=6478;   // fu
   sortTable[0x7550]=6479;   // fu
   sortTable[0x75E1]=6480;   // fu
   sortTable[0x7641]=6481;   // fu
   sortTable[0x76D9]=6482;   // fu
   sortTable[0x79FF]=6483;   // fu
   sortTable[0x7A2A]=6484;   // fu
   sortTable[0x7ACE]=6485;   // fu
   sortTable[0x7CD0]=6486;   // fu
   sortTable[0x7D65]=6487;   // fu
   sortTable[0x7FC7]=6488;   // fu
   sortTable[0x80D5]=6489;   // fu
   sortTable[0x8240]=6490;   // fu
   sortTable[0x86D7]=6491;   // fu
   sortTable[0x875C]=6492;   // fu
   sortTable[0x8A42]=6493;   // fu
   sortTable[0x8AE8]=6494;   // fu
   sortTable[0x8E3E]=6495;   // fu
   sortTable[0x915C]=6496;   // fu
   sortTable[0x9258]=6497;   // fu
   sortTable[0x925C]=6498;   // fu
   sortTable[0x961D]=6499;   // fu
   sortTable[0x965A]=6500;   // fu
   sortTable[0x98AB]=6501;   // fu
   sortTable[0x99D9]=6502;   // fu
   sortTable[0x9B92]=6503;   // fu
   sortTable[0x9BB2]=6504;   // fu
   sortTable[0x9C12]=6505;   // fu
   sortTable[0x9CEC]=6506;   // fu
   sortTable[0x9EAC]=6507;   // fu
   sortTable[0x9EB1]=6508;   // fu
   sortTable[0x5C2C]=6912;   // ga
   sortTable[0x560E]=6913;   // ga
   sortTable[0x5676]=6914;   // ga
   sortTable[0x5477]=6915;   // ga
   sortTable[0x65EE]=6916;   // ga
   sortTable[0x9486]=6917;   // ga
   sortTable[0x5C15]=6918;   // ga
   sortTable[0x5C1C]=6919;   // ga
   sortTable[0x9B40]=6920;   // ga
   sortTable[0x5620]=6921;   // ga
   sortTable[0x738D]=6922;   // ga
   sortTable[0x9337]=6923;   // ga
   sortTable[0x6539]=6924;   // gai
   sortTable[0x8BE5]=6925;   // gai
   sortTable[0x8A72]=6926;   // gai
   sortTable[0x6982]=6927;   // gai
   sortTable[0x76D6]=6928;   // gai
   sortTable[0x84CB]=6929;   // gai
   sortTable[0x6E89]=6930;   // gai
   sortTable[0x9499]=6931;   // gai
   sortTable[0x9223]=6932;   // gai
   sortTable[0x4E10]=6933;   // gai
   sortTable[0x5793]=6934;   // gai
   sortTable[0x9654]=6935;   // gai
   sortTable[0x8D45]=6936;   // gai
   sortTable[0x8344]=6937;   // gai
   sortTable[0x8462]=6938;   // gai
   sortTable[0x7974]=6939;   // gai
   sortTable[0x6224]=6940;   // gai
   sortTable[0x9691]=6941;   // gai
   sortTable[0x7D6F]=6942;   // gai
   sortTable[0x8C65]=6943;   // gai
   sortTable[0x8CC5]=6944;   // gai
   sortTable[0x4E62]=6945;   // gai
   sortTable[0x4F85]=6946;   // gai
   sortTable[0x5303]=6947;   // gai
   sortTable[0x5304]=6948;   // gai
   sortTable[0x59DF]=6949;   // gai
   sortTable[0x5CD0]=6950;   // gai
   sortTable[0x5FCB]=6951;   // gai
   sortTable[0x6461]=6952;   // gai
   sortTable[0x6650]=6953;   // gai
   sortTable[0x675A]=6954;   // gai
   sortTable[0x69E9]=6955;   // gai
   sortTable[0x69EA]=6956;   // gai
   sortTable[0x6F11]=6957;   // gai
   sortTable[0x74C2]=6958;   // gai
   sortTable[0x7561]=6959;   // gai
   sortTable[0x7D60]=6960;   // gai
   sortTable[0x8CCC]=6961;   // gai
   sortTable[0x90C2]=6962;   // gai
   sortTable[0x9623]=6963;   // gai
   sortTable[0x5E72]=6964;   // gan
   sortTable[0x611F]=6965;   // gan
   sortTable[0x8D76]=6966;   // gan
   sortTable[0x8D95]=6967;   // gan
   sortTable[0x6562]=6968;   // gan
   sortTable[0x6746]=6969;   // gan
   sortTable[0x809D]=6970;   // gan
   sortTable[0x7518]=6971;   // gan
   sortTable[0x7AFF]=6972;   // gan
   sortTable[0x79C6]=6973;   // gan
   sortTable[0x7A08]=6974;   // gan
   sortTable[0x5C34]=6975;   // gan
   sortTable[0x8D63]=6976;   // gan
   sortTable[0x6A44]=6977;   // gan
   sortTable[0x6DE6]=6978;   // gan
   sortTable[0x67D1]=6979;   // gan
   sortTable[0x82F7]=6980;   // gan
   sortTable[0x65F0]=6981;   // gan
   sortTable[0x7EC0]=6982;   // gan
   sortTable[0x77F8]=6983;   // gan
   sortTable[0x64C0]=6984;   // gan
   sortTable[0x6CD4]=6985;   // gan
   sortTable[0x75B3]=6986;   // gan
   sortTable[0x6F89]=6987;   // gan
   sortTable[0x9150]=6988;   // gan
   sortTable[0x7B78]=6989;   // gan
   sortTable[0x5769]=6990;   // gan
   sortTable[0x9CE1]=6991;   // gan
   sortTable[0x7B34]=6992;   // gan
   sortTable[0x7C33]=6993;   // gan
   sortTable[0x9AAD]=6994;   // gan
   sortTable[0x9C64]=6995;   // gan
   sortTable[0x7C93]=6996;   // gan
   sortTable[0x8A4C]=6997;   // gan
   sortTable[0x7D3A]=6998;   // gan
   sortTable[0x9CF1]=6999;   // gan
   sortTable[0x4E79]=7000;   // gan
   sortTable[0x4E81]=7001;   // gan
   sortTable[0x4EE0]=7002;   // gan
   sortTable[0x501D]=7003;   // gan
   sortTable[0x51CE]=7004;   // gan
   sortTable[0x51F2]=7005;   // gan
   sortTable[0x5C32]=7006;   // gan
   sortTable[0x5C36]=7007;   // gan
   sortTable[0x5C37]=7008;   // gan
   sortTable[0x5E79]=7009;   // gan
   sortTable[0x5FD3]=7010;   // gan
   sortTable[0x625E]=7011;   // gan
   sortTable[0x653C]=7012;   // gan
   sortTable[0x687F]=7013;   // gan
   sortTable[0x69A6]=7014;   // gan
   sortTable[0x6A8A]=7015;   // gan
   sortTable[0x6C75]=7016;   // gan
   sortTable[0x6F27]=7017;   // gan
   sortTable[0x7068]=7018;   // gan
   sortTable[0x7395]=7019;   // gan
   sortTable[0x76AF]=7020;   // gan
   sortTable[0x76F0]=7021;   // gan
   sortTable[0x8289]=7022;   // gan
   sortTable[0x8866]=7023;   // gan
   sortTable[0x8D11]=7024;   // gan
   sortTable[0x8D1B]=7025;   // gan
   sortTable[0x8FC0]=7026;   // gan
   sortTable[0x9B50]=7027;   // gan
   sortTable[0x9C14]=7028;   // gan
   sortTable[0x521A]=7029;   // gang
   sortTable[0x525B]=7030;   // gang
   sortTable[0x94A2]=7031;   // gang
   sortTable[0x92FC]=7032;   // gang
   sortTable[0x7EB2]=7033;   // gang
   sortTable[0x7DB1]=7034;   // gang
   sortTable[0x5C97]=7035;   // gang
   sortTable[0x5D17]=7036;   // gang
   sortTable[0x6E2F]=7037;   // gang
   sortTable[0x7F38]=7038;   // gang
   sortTable[0x5188]=7039;   // gang
   sortTable[0x5CA1]=7040;   // gang
   sortTable[0x6760]=7041;   // gang
   sortTable[0x7F61]=7042;   // gang
   sortTable[0x809B]=7043;   // gang
   sortTable[0x6206]=7044;   // gang
   sortTable[0x91ED]=7045;   // gang
   sortTable[0x77FC]=7046;   // gang
   sortTable[0x7B7B]=7047;   // gang
   sortTable[0x7F41]=7048;   // gang
   sortTable[0x51AE]=7049;   // gang
   sortTable[0x5808]=7050;   // gang
   sortTable[0x583D]=7051;   // gang
   sortTable[0x6205]=7052;   // gang
   sortTable[0x6386]=7053;   // gang
   sortTable[0x68E1]=7054;   // gang
   sortTable[0x69D3]=7055;   // gang
   sortTable[0x7135]=7056;   // gang
   sortTable[0x7268]=7057;   // gang
   sortTable[0x7285]=7058;   // gang
   sortTable[0x7598]=7059;   // gang
   sortTable[0x7F53]=7060;   // gang
   sortTable[0x93A0]=7061;   // gang
   sortTable[0x9AD8]=7062;   // gao
   sortTable[0x544A]=7063;   // gao
   sortTable[0x641E]=7064;   // gao
   sortTable[0x7A3F]=7065;   // gao
   sortTable[0x818F]=7066;   // gao
   sortTable[0x7CD5]=7067;   // gao
   sortTable[0x7F94]=7068;   // gao
   sortTable[0x768B]=7069;   // gao
   sortTable[0x8BF0]=7070;   // gao
   sortTable[0x6772]=7071;   // gao
   sortTable[0x777E]=7072;   // gao
   sortTable[0x9550]=7073;   // gao
   sortTable[0x69C1]=7074;   // gao
   sortTable[0x7F1F]=7075;   // gao
   sortTable[0x7BD9]=7076;   // gao
   sortTable[0x85C1]=7077;   // gao
   sortTable[0x69D4]=7078;   // gao
   sortTable[0x90DC]=7079;   // gao
   sortTable[0x9506]=7080;   // gao
   sortTable[0x9F1B]=7081;   // gao
   sortTable[0x7A3E]=7082;   // gao
   sortTable[0x85F3]=7083;   // gao
   sortTable[0x9DF1]=7084;   // gao
   sortTable[0x83D2]=7085;   // gao
   sortTable[0x796E]=7086;   // gao
   sortTable[0x7B76]=7087;   // gao
   sortTable[0x8AA5]=7088;   // gao
   sortTable[0x7970]=7089;   // gao
   sortTable[0x81EF]=7090;   // gao
   sortTable[0x92EF]=7091;   // gao
   sortTable[0x993B]=7092;   // gao
   sortTable[0x799E]=7093;   // gao
   sortTable[0x7E1E]=7094;   // gao
   sortTable[0x7F99]=7095;   // gao
   sortTable[0x97DF]=7096;   // gao
   sortTable[0x52C2]=7097;   // gao
   sortTable[0x53DD]=7098;   // gao
   sortTable[0x543F]=7099;   // gao
   sortTable[0x5930]=7100;   // gao
   sortTable[0x66A0]=7101;   // gao
   sortTable[0x69C0]=7102;   // gao
   sortTable[0x69F9]=7103;   // gao
   sortTable[0x6A70]=7104;   // gao
   sortTable[0x6ABA]=7105;   // gao
   sortTable[0x6ADC]=7106;   // gao
   sortTable[0x6EDC]=7107;   // gao
   sortTable[0x7170]=7108;   // gao
   sortTable[0x7690]=7109;   // gao
   sortTable[0x9AD9]=7110;   // gao
   sortTable[0x9DCE]=7111;   // gao
   sortTable[0x4E2A]=7112;   // ge
   sortTable[0x500B]=7113;   // ge
   sortTable[0x9769]=7114;   // ge
   sortTable[0x5404]=7115;   // ge
   sortTable[0x54E5]=7116;   // ge
   sortTable[0x6B4C]=7117;   // ge
   sortTable[0x683C]=7118;   // ge
   sortTable[0x9694]=7119;   // ge
   sortTable[0x5272]=7120;   // ge
   sortTable[0x80F3]=7121;   // ge
   sortTable[0x6401]=7122;   // ge
   sortTable[0x64F1]=7123;   // ge
   sortTable[0x9ABC]=7124;   // ge
   sortTable[0x7599]=7125;   // ge
   sortTable[0x9E3D]=7126;   // ge
   sortTable[0x9D3F]=7127;   // ge
   sortTable[0x9601]=7128;   // ge
   sortTable[0x845B]=7129;   // ge
   sortTable[0x6208]=7130;   // ge
   sortTable[0x54AF]=7131;   // ge
   sortTable[0x7EA5]=7132;   // ge
   sortTable[0x643F]=7133;   // ge
   sortTable[0x55DD]=7134;   // ge
   sortTable[0x8238]=7135;   // ge
   sortTable[0x9549]=7136;   // ge
   sortTable[0x95A4]=7137;   // ge
   sortTable[0x867C]=7138;   // ge
   sortTable[0x88BC]=7139;   // ge
   sortTable[0x572A]=7140;   // ge
   sortTable[0x94EC]=7141;   // ge
   sortTable[0x54FF]=7142;   // ge
   sortTable[0x784C]=7143;   // ge
   sortTable[0x9B32]=7144;   // ge
   sortTable[0x8188]=7145;   // ge
   sortTable[0x9A14]=7146;   // ge
   sortTable[0x4EE1]=7147;   // ge
   sortTable[0x97D0]=7148;   // ge
   sortTable[0x8316]=7149;   // ge
   sortTable[0x8090]=7150;   // ge
   sortTable[0x8F35]=7151;   // ge
   sortTable[0x8F55]=7152;   // ge
   sortTable[0x89E1]=7153;   // ge
   sortTable[0x86D2]=7154;   // ge
   sortTable[0x95A3]=7155;   // ge
   sortTable[0x9D10]=7156;   // ge
   sortTable[0x8B0C]=7157;   // ge
   sortTable[0x5865]=7158;   // ge
   sortTable[0x93B6]=7159;   // ge
   sortTable[0x7B87]=7160;   // ge
   sortTable[0x88D3]=7161;   // ge
   sortTable[0x9788]=7162;   // ge
   sortTable[0x4F6E]=7163;   // ge
   sortTable[0x530C]=7164;   // ge
   sortTable[0x5444]=7165;   // ge
   sortTable[0x55F0]=7166;   // ge
   sortTable[0x5F41]=7167;   // ge
   sortTable[0x6105]=7168;   // ge
   sortTable[0x6213]=7169;   // ge
   sortTable[0x6228]=7170;   // ge
   sortTable[0x630C]=7171;   // ge
   sortTable[0x654B]=7172;   // ge
   sortTable[0x69C5]=7173;   // ge
   sortTable[0x6ACA]=7174;   // ge
   sortTable[0x6EC6]=7175;   // ge
   sortTable[0x6ED2]=7176;   // ge
   sortTable[0x726B]=7177;   // ge
   sortTable[0x7271]=7178;   // ge
   sortTable[0x72B5]=7179;   // ge
   sortTable[0x7366]=7180;   // ge
   sortTable[0x81F5]=7181;   // ge
   sortTable[0x8AFD]=7182;   // ge
   sortTable[0x97B7]=7183;   // ge
   sortTable[0x97DA]=7184;   // ge
   sortTable[0x9BAF]=7185;   // ge
   sortTable[0x9D1A]=7186;   // ge
   sortTable[0x7ED9]=7187;   // gei
   sortTable[0x7D66]=7188;   // gei
   sortTable[0x8DDF]=7189;   // gen
   sortTable[0x6839]=7190;   // gen
   sortTable[0x54CF]=7191;   // gen
   sortTable[0x4E98]=7192;   // gen
   sortTable[0x826E]=7193;   // gen
   sortTable[0x831B]=7194;   // gen
   sortTable[0x4E99]=7195;   // gen
   sortTable[0x63EF]=7196;   // gen
   sortTable[0x66F4]=7197;   // geng
   sortTable[0x8015]=7198;   // geng
   sortTable[0x6897]=7199;   // geng
   sortTable[0x54FD]=7200;   // geng
   sortTable[0x5E9A]=7201;   // geng
   sortTable[0x803F]=7202;   // geng
   sortTable[0x57C2]=7203;   // geng
   sortTable[0x7FB9]=7204;   // geng
   sortTable[0x8D53]=7205;   // geng
   sortTable[0x9CA0]=7206;   // geng
   sortTable[0x7EE0]=7207;   // geng
   sortTable[0x9BC1]=7208;   // geng
   sortTable[0x7D86]=7209;   // geng
   sortTable[0x7DEA]=7210;   // geng
   sortTable[0x7FAE]=7211;   // geng
   sortTable[0x7E06]=7212;   // geng
   sortTable[0x9D8A]=7213;   // geng
   sortTable[0x90E0]=7214;   // geng
   sortTable[0x9E52]=7215;   // geng
   sortTable[0x9ABE]=7216;   // geng
   sortTable[0x7D5A]=7217;   // geng
   sortTable[0x8CE1]=7218;   // geng
   sortTable[0x522F]=7219;   // geng
   sortTable[0x5829]=7220;   // geng
   sortTable[0x5CFA]=7221;   // geng
   sortTable[0x632D]=7222;   // geng
   sortTable[0x63B6]=7223;   // geng
   sortTable[0x6404]=7224;   // geng
   sortTable[0x6685]=7225;   // geng
   sortTable[0x6929]=7226;   // geng
   sortTable[0x6D6D]=7227;   // geng
   sortTable[0x713F]=7228;   // geng
   sortTable[0x754A]=7229;   // geng
   sortTable[0x8384]=7230;   // geng
   sortTable[0x83EE]=7231;   // geng
   sortTable[0x5DE5]=7232;   // gong
   sortTable[0x5171]=7233;   // gong
   sortTable[0x516C]=7234;   // gong
   sortTable[0x529F]=7235;   // gong
   sortTable[0x653B]=7236;   // gong
   sortTable[0x4F9B]=7237;   // gong
   sortTable[0x5DE9]=7238;   // gong
   sortTable[0x978F]=7239;   // gong
   sortTable[0x8D21]=7240;   // gong
   sortTable[0x8CA2]=7241;   // gong
   sortTable[0x62F1]=7242;   // gong
   sortTable[0x5BAB]=7243;   // gong
   sortTable[0x5BAE]=7244;   // gong
   sortTable[0x5F13]=7245;   // gong
   sortTable[0x8EAC]=7246;   // gong
   sortTable[0x6C5E]=7247;   // gong
   sortTable[0x86A3]=7248;   // gong
   sortTable[0x606D]=7249;   // gong
   sortTable[0x9F9A]=7250;   // gong
   sortTable[0x89E5]=7251;   // gong
   sortTable[0x80B1]=7252;   // gong
   sortTable[0x73D9]=7253;   // gong
   sortTable[0x9F8F]=7254;   // gong
   sortTable[0x7FBE]=7255;   // gong
   sortTable[0x83BB]=7256;   // gong
   sortTable[0x9AF8]=7257;   // gong
   sortTable[0x9F94]=7258;   // gong
   sortTable[0x8F01]=7259;   // gong
   sortTable[0x78BD]=7260;   // gong
   sortTable[0x5311]=7261;   // gong
   sortTable[0x53B7]=7262;   // gong
   sortTable[0x551D]=7263;   // gong
   sortTable[0x5868]=7264;   // gong
   sortTable[0x5E4A]=7265;   // gong
   sortTable[0x5EFE]=7266;   // gong
   sortTable[0x6129]=7267;   // gong
   sortTable[0x6150]=7268;   // gong
   sortTable[0x62F2]=7269;   // gong
   sortTable[0x675B]=7270;   // gong
   sortTable[0x6831]=7271;   // gong
   sortTable[0x7195]=7272;   // gong
   sortTable[0x739C]=7273;   // gong
   sortTable[0x7CFC]=7274;   // gong
   sortTable[0x89F5]=7275;   // gong
   sortTable[0x8EB3]=7276;   // gong
   sortTable[0x92DB]=7277;   // gong
   sortTable[0x591F]=7278;   // gou
   sortTable[0x5920]=7279;   // gou
   sortTable[0x6784]=7280;   // gou
   sortTable[0x69CB]=7281;   // gou
   sortTable[0x72D7]=7282;   // gou
   sortTable[0x6C9F]=7283;   // gou
   sortTable[0x6E9D]=7284;   // gou
   sortTable[0x52FE]=7285;   // gou
   sortTable[0x94A9]=7286;   // gou
   sortTable[0x9264]=7287;   // gou
   sortTable[0x8D2D]=7288;   // gou
   sortTable[0x8CFC]=7289;   // gou
   sortTable[0x82DF]=7290;   // gou
   sortTable[0x57A2]=7291;   // gou
   sortTable[0x8BDF]=7292;   // gou
   sortTable[0x5F40]=7293;   // gou
   sortTable[0x7B31]=7294;   // gou
   sortTable[0x5ABE]=7295;   // gou
   sortTable[0x9058]=7296;   // gou
   sortTable[0x97B2]=7297;   // gou
   sortTable[0x7F11]=7298;   // gou
   sortTable[0x7BDD]=7299;   // gou
   sortTable[0x67B8]=7300;   // gou
   sortTable[0x5CA3]=7301;   // gou
   sortTable[0x4F5D]=7302;   // gou
   sortTable[0x89CF]=7303;   // gou
   sortTable[0x96CA]=7304;   // gou
   sortTable[0x8007]=7305;   // gou
   sortTable[0x8920]=7306;   // gou
   sortTable[0x97DD]=7307;   // gou
   sortTable[0x88A7]=7308;   // gou
   sortTable[0x86BC]=7309;   // gou
   sortTable[0x8A3D]=7310;   // gou
   sortTable[0x8A6C]=7311;   // gou
   sortTable[0x8008]=7312;   // gou
   sortTable[0x7DF1]=7313;   // gou
   sortTable[0x8329]=7314;   // gou
   sortTable[0x89AF]=7315;   // gou
   sortTable[0x920E]=7316;   // gou
   sortTable[0x5193]=7317;   // gou
   sortTable[0x5778]=7318;   // gou
   sortTable[0x59E4]=7319;   // gou
   sortTable[0x6406]=7320;   // gou
   sortTable[0x6480]=7321;   // gou
   sortTable[0x7179]=7322;   // gou
   sortTable[0x73BD]=7323;   // gou
   sortTable[0x8009]=7324;   // gou
   sortTable[0x82B6]=7325;   // gou
   sortTable[0x8C7F]=7326;   // gou
   sortTable[0x53E4]=7327;   // gu
   sortTable[0x59D1]=7328;   // gu
   sortTable[0x6545]=7329;   // gu
   sortTable[0x56FA]=7330;   // gu
   sortTable[0x987E]=7331;   // gu
   sortTable[0x9867]=7332;   // gu
   sortTable[0x9F13]=7333;   // gu
   sortTable[0x80A1]=7334;   // gu
   sortTable[0x9AA8]=7335;   // gu
   sortTable[0x8C37]=7336;   // gu
   sortTable[0x4F30]=7337;   // gu
   sortTable[0x5B64]=7338;   // gu
   sortTable[0x96C7]=7339;   // gu
   sortTable[0x50F1]=7340;   // gu
   sortTable[0x5495]=7341;   // gu
   sortTable[0x94B4]=7342;   // gu
   sortTable[0x9237]=7343;   // gu
   sortTable[0x83C7]=7344;   // gu
   sortTable[0x8F9C]=7345;   // gu
   sortTable[0x6CBD]=7346;   // gu
   sortTable[0x9E58]=7347;   // gu
   sortTable[0x9E44]=7348;   // gu
   sortTable[0x86CA]=7349;   // gu
   sortTable[0x5471]=7350;   // gu
   sortTable[0x9522]=7351;   // gu
   sortTable[0x7B8D]=7352;   // gu
   sortTable[0x6BC2]=7353;   // gu
   sortTable[0x9E2A]=7354;   // gu
   sortTable[0x7F5F]=7355;   // gu
   sortTable[0x86C4]=7356;   // gu
   sortTable[0x7A40]=7357;   // gu
   sortTable[0x77BD]=7358;   // gu
   sortTable[0x8BC2]=7359;   // gu
   sortTable[0x560F]=7360;   // gu
   sortTable[0x6C69]=7361;   // gu
   sortTable[0x83F0]=7362;   // gu
   sortTable[0x688F]=7363;   // gu
   sortTable[0x5D2E]=7364;   // gu
   sortTable[0x9164]=7365;   // gu
   sortTable[0x89DA]=7366;   // gu
   sortTable[0x75FC]=7367;   // gu
   sortTable[0x8F71]=7368;   // gu
   sortTable[0x726F]=7369;   // gu
   sortTable[0x76EC]=7370;   // gu
   sortTable[0x7F96]=7371;   // gu
   sortTable[0x9989]=7372;   // gu
   sortTable[0x9CB4]=7373;   // gu
   sortTable[0x81CC]=7374;   // gu
   sortTable[0x7F5B]=7375;   // gu
   sortTable[0x9D23]=7376;   // gu
   sortTable[0x727F]=7377;   // gu
   sortTable[0x7A12]=7378;   // gu
   sortTable[0x82FD]=7379;   // gu
   sortTable[0x8F42]=7380;   // gu
   sortTable[0x9BDD]=7381;   // gu
   sortTable[0x7B1F]=7382;   // gu
   sortTable[0x797B]=7383;   // gu
   sortTable[0x7B9B]=7384;   // gu
   sortTable[0x84C7]=7385;   // gu
   sortTable[0x8135]=7386;   // gu
   sortTable[0x9232]=7387;   // gu
   sortTable[0x7CD3]=7388;   // gu
   sortTable[0x50A6]=7389;   // gu
   sortTable[0x51C5]=7390;   // gu
   sortTable[0x5502]=7391;   // gu
   sortTable[0x5503]=7392;   // gu
   sortTable[0x5552]=7393;   // gu
   sortTable[0x580C]=7394;   // gu
   sortTable[0x5903]=7395;   // gu
   sortTable[0x5AF4]=7396;   // gu
   sortTable[0x5C33]=7397;   // gu
   sortTable[0x5CE0]=7398;   // gu
   sortTable[0x5D13]=7399;   // gu
   sortTable[0x6132]=7400;   // gu
   sortTable[0x6262]=7401;   // gu
   sortTable[0x67E7]=7402;   // gu
   sortTable[0x68DD]=7403;   // gu
   sortTable[0x6996]=7404;   // gu
   sortTable[0x69BE]=7405;   // gu
   sortTable[0x6A6D]=7406;   // gu
   sortTable[0x6CD2]=7407;   // gu
   sortTable[0x6DC8]=7408;   // gu
   sortTable[0x6FF2]=7409;   // gu
   sortTable[0x7014]=7410;   // gu
   sortTable[0x76B7]=7411;   // gu
   sortTable[0x76BC]=7412;   // gu
   sortTable[0x7BD0]=7413;   // gu
   sortTable[0x7E0E]=7414;   // gu
   sortTable[0x85A3]=7415;   // gu
   sortTable[0x86CC]=7416;   // gu
   sortTable[0x8831]=7417;   // gu
   sortTable[0x8A41]=7418;   // gu
   sortTable[0x8EF1]=7419;   // gu
   sortTable[0x8EF2]=7420;   // gu
   sortTable[0x9027]=7421;   // gu
   sortTable[0x932E]=7422;   // gu
   sortTable[0x9936]=7423;   // gu
   sortTable[0x9B95]=7424;   // gu
   sortTable[0x9DBB]=7425;   // gu
   sortTable[0x9F14]=7426;   // gu
   sortTable[0x6302]=7427;   // gua
   sortTable[0x639B]=7428;   // gua
   sortTable[0x74DC]=7429;   // gua
   sortTable[0x522E]=7430;   // gua
   sortTable[0x5BE1]=7431;   // gua
   sortTable[0x8902]=7432;   // gua
   sortTable[0x5366]=7433;   // gua
   sortTable[0x8BD6]=7434;   // gua
   sortTable[0x80CD]=7435;   // gua
   sortTable[0x5250]=7436;   // gua
   sortTable[0x8052]=7437;   // gua
   sortTable[0x9E39]=7438;   // gua
   sortTable[0x681D]=7439;   // gua
   sortTable[0x7D53]=7440;   // gua
   sortTable[0x9A27]=7441;   // gua
   sortTable[0x7F63]=7442;   // gua
   sortTable[0x7DFA]=7443;   // gua
   sortTable[0x8A7F]=7444;   // gua
   sortTable[0x7F6B]=7445;   // gua
   sortTable[0x9D30]=7446;   // gua
   sortTable[0x92BD]=7447;   // gua
   sortTable[0x518E]=7448;   // gua
   sortTable[0x526E]=7449;   // gua
   sortTable[0x5280]=7450;   // gua
   sortTable[0x53E7]=7451;   // gua
   sortTable[0x5569]=7452;   // gua
   sortTable[0x576C]=7453;   // gua
   sortTable[0x6B44]=7454;   // gua
   sortTable[0x7171]=7455;   // gua
   sortTable[0x8D8F]=7456;   // gua
   sortTable[0x8E3B]=7457;   // gua
   sortTable[0x98AA]=7458;   // gua
   sortTable[0x98B3]=7459;   // gua
   sortTable[0x602A]=7460;   // guai
   sortTable[0x62D0]=7461;   // guai
   sortTable[0x4E56]=7462;   // guai
   sortTable[0x63B4]=7463;   // guai
   sortTable[0x7B89]=7464;   // guai
   sortTable[0x53CF]=7465;   // guai
   sortTable[0x592C]=7466;   // guai
   sortTable[0x6060]=7467;   // guai
   sortTable[0x6451]=7468;   // guai
   sortTable[0x67B4]=7469;   // guai
   sortTable[0x67FA]=7470;   // guai
   sortTable[0x5173]=7471;   // guan
   sortTable[0x95DC]=7472;   // guan
   sortTable[0x89C2]=7473;   // guan
   sortTable[0x89C0]=7474;   // guan
   sortTable[0x7BA1]=7475;   // guan
   sortTable[0x5B98]=7476;   // guan
   sortTable[0x9986]=7477;   // guan
   sortTable[0x9928]=7478;   // guan
   sortTable[0x60EF]=7479;   // guan
   sortTable[0x6163]=7480;   // guan
   sortTable[0x704C]=7481;   // guan
   sortTable[0x8D2F]=7482;   // guan
   sortTable[0x8CAB]=7483;   // guan
   sortTable[0x7F50]=7484;   // guan
   sortTable[0x68FA]=7485;   // guan
   sortTable[0x51A0]=7486;   // guan
   sortTable[0x6DAB]=7487;   // guan
   sortTable[0x500C]=7488;   // guan
   sortTable[0x76E5]=7489;   // guan
   sortTable[0x839E]=7490;   // guan
   sortTable[0x9E73]=7491;   // guan
   sortTable[0x9CCF]=7492;   // guan
   sortTable[0x63BC]=7493;   // guan
   sortTable[0x7B66]=7494;   // guan
   sortTable[0x797C]=7495;   // guan
   sortTable[0x96DA]=7496;   // guan
   sortTable[0x7936]=7497;   // guan
   sortTable[0x9327]=7498;   // guan
   sortTable[0x77D4]=7499;   // guan
   sortTable[0x9CE4]=7500;   // guan
   sortTable[0x93C6]=7501;   // guan
   sortTable[0x7F46]=7502;   // guan
   sortTable[0x8F28]=7503;   // guan
   sortTable[0x9475]=7504;   // guan
   sortTable[0x7AA4]=7505;   // guan
   sortTable[0x8484]=7506;   // guan
   sortTable[0x95A2]=7507;   // guan
   sortTable[0x9C25]=7508;   // guan
   sortTable[0x4E31]=7509;   // guan
   sortTable[0x60B9]=7510;   // guan
   sortTable[0x60BA]=7511;   // guan
   sortTable[0x645C]=7512;   // guan
   sortTable[0x6A0C]=7513;   // guan
   sortTable[0x6BCC]=7514;   // guan
   sortTable[0x6CF4]=7515;   // guan
   sortTable[0x6F45]=7516;   // guan
   sortTable[0x721F]=7517;   // guan
   sortTable[0x742F]=7518;   // guan
   sortTable[0x74D8]=7519;   // guan
   sortTable[0x75EF]=7520;   // guan
   sortTable[0x761D]=7521;   // guan
   sortTable[0x764F]=7522;   // guan
   sortTable[0x8218]=7523;   // guan
   sortTable[0x898C]=7524;   // guan
   sortTable[0x89B3]=7525;   // guan
   sortTable[0x9066]=7526;   // guan
   sortTable[0x95D7]=7527;   // guan
   sortTable[0x9C5E]=7528;   // guan
   sortTable[0x9C79]=7529;   // guan
   sortTable[0x9E1B]=7530;   // guan
   sortTable[0x5149]=7531;   // guang
   sortTable[0x5E7F]=7532;   // guang
   sortTable[0x5EE3]=7533;   // guang
   sortTable[0x901B]=7534;   // guang
   sortTable[0x80F1]=7535;   // guang
   sortTable[0x72B7]=7536;   // guang
   sortTable[0x54A3]=7537;   // guang
   sortTable[0x6844]=7538;   // guang
   sortTable[0x832A]=7539;   // guang
   sortTable[0x92A7]=7540;   // guang
   sortTable[0x8F04]=7541;   // guang
   sortTable[0x81E9]=7542;   // guang
   sortTable[0x4F8A]=7543;   // guang
   sortTable[0x4FC7]=7544;   // guang
   sortTable[0x50D9]=7545;   // guang
   sortTable[0x5799]=7546;   // guang
   sortTable[0x59EF]=7547;   // guang
   sortTable[0x5E83]=7548;   // guang
   sortTable[0x6497]=7549;   // guang
   sortTable[0x6B1F]=7550;   // guang
   sortTable[0x6D38]=7551;   // guang
   sortTable[0x706E]=7552;   // guang
   sortTable[0x7097]=7553;   // guang
   sortTable[0x709A]=7554;   // guang
   sortTable[0x709B]=7555;   // guang
   sortTable[0x70E1]=7556;   // guang
   sortTable[0x7377]=7557;   // guang
   sortTable[0x73D6]=7558;   // guang
   sortTable[0x81E6]=7559;   // guang
   sortTable[0x9EC6]=7560;   // guang
   sortTable[0x89C4]=7561;   // gui
   sortTable[0x898F]=7562;   // gui
   sortTable[0x9B3C]=7563;   // gui
   sortTable[0x8D35]=7564;   // gui
   sortTable[0x8CB4]=7565;   // gui
   sortTable[0x67DC]=7566;   // gui
   sortTable[0x5F52]=7567;   // gui
   sortTable[0x6B78]=7568;   // gui
   sortTable[0x8F68]=7569;   // gui
   sortTable[0x8ECC]=7570;   // gui
   sortTable[0x8DEA]=7571;   // gui
   sortTable[0x95FA]=7572;   // gui
   sortTable[0x95A8]=7573;   // gui
   sortTable[0x8BE1]=7574;   // gui
   sortTable[0x8A6D]=7575;   // gui
   sortTable[0x7845]=7576;   // gui
   sortTable[0x9F9F]=7577;   // gui
   sortTable[0x9F9C]=7578;   // gui
   sortTable[0x7678]=7579;   // gui
   sortTable[0x6842]=7580;   // gui
   sortTable[0x7470]=7581;   // gui
   sortTable[0x572D]=7582;   // gui
   sortTable[0x6867]=7583;   // gui
   sortTable[0x59AB]=7584;   // gui
   sortTable[0x6677]=7585;   // gui
   sortTable[0x7688]=7586;   // gui
   sortTable[0x5080]=7587;   // gui
   sortTable[0x5B84]=7588;   // gui
   sortTable[0x523D]=7589;   // gui
   sortTable[0x5326]=7590;   // gui
   sortTable[0x5E8B]=7591;   // gui
   sortTable[0x7094]=7592;   // gui
   sortTable[0x7C0B]=7593;   // gui
   sortTable[0x9C91]=7594;   // gui
   sortTable[0x90BD]=7595;   // gui
   sortTable[0x523F]=7596;   // gui
   sortTable[0x9CDC]=7597;   // gui
   sortTable[0x9C56]=7598;   // gui
   sortTable[0x79AC]=7599;   // gui
   sortTable[0x88BF]=7600;   // gui
   sortTable[0x9A29]=7601;   // gui
   sortTable[0x879D]=7602;   // gui
   sortTable[0x77B6]=7603;   // gui
   sortTable[0x796A]=7604;   // gui
   sortTable[0x81AD]=7605;   // gui
   sortTable[0x8958]=7606;   // gui
   sortTable[0x77A1]=7607;   // gui
   sortTable[0x7A90]=7608;   // gui
   sortTable[0x9C65]=7609;   // gui
   sortTable[0x7C02]=7610;   // gui
   sortTable[0x7B40]=7611;   // gui
   sortTable[0x86EB]=7612;   // gui
   sortTable[0x9652]=7613;   // gui
   sortTable[0x8325]=7614;   // gui
   sortTable[0x9B36]=7615;   // gui
   sortTable[0x9BAD]=7616;   // gui
   sortTable[0x84D5]=7617;   // gui
   sortTable[0x89E4]=7618;   // gui
   sortTable[0x4E80]=7619;   // gui
   sortTable[0x4F79]=7620;   // gui
   sortTable[0x528A]=7621;   // gui
   sortTable[0x528C]=7622;   // gui
   sortTable[0x532D]=7623;   // gui
   sortTable[0x5331]=7624;   // gui
   sortTable[0x53AC]=7625;   // gui
   sortTable[0x579D]=7626;   // gui
   sortTable[0x59FD]=7627;   // gui
   sortTable[0x5AAF]=7628;   // gui
   sortTable[0x5AE2]=7629;   // gui
   sortTable[0x5B00]=7630;   // gui
   sortTable[0x5DA1]=7631;   // gui
   sortTable[0x5DC2]=7632;   // gui
   sortTable[0x5E30]=7633;   // gui
   sortTable[0x5EAA]=7634;   // gui
   sortTable[0x5EC6]=7635;   // gui
   sortTable[0x6051]=7636;   // gui
   sortTable[0x646B]=7637;   // gui
   sortTable[0x648C]=7638;   // gui
   sortTable[0x6530]=7639;   // gui
   sortTable[0x6531]=7640;   // gui
   sortTable[0x660B]=7641;   // gui
   sortTable[0x6739]=7642;   // gui
   sortTable[0x691D]=7643;   // gui
   sortTable[0x6922]=7644;   // gui
   sortTable[0x69F6]=7645;   // gui
   sortTable[0x69FB]=7646;   // gui
   sortTable[0x69FC]=7647;   // gui
   sortTable[0x6A9C]=7648;   // gui
   sortTable[0x6AC3]=7649;   // gui
   sortTable[0x6AF7]=7650;   // gui
   sortTable[0x6C3F]=7651;   // gui
   sortTable[0x6E40]=7652;   // gui
   sortTable[0x7324]=7653;   // gui
   sortTable[0x73EA]=7654;   // gui
   sortTable[0x749D]=7655;   // gui
   sortTable[0x74CC]=7656;   // gui
   sortTable[0x7650]=7657;   // gui
   sortTable[0x80FF]=7658;   // gui
   sortTable[0x87E1]=7659;   // gui
   sortTable[0x90CC]=7660;   // gui
   sortTable[0x97BC]=7661;   // gui
   sortTable[0x9B39]=7662;   // gui
   sortTable[0x6EDA]=7663;   // gun
   sortTable[0x6EFE]=7664;   // gun
   sortTable[0x68CD]=7665;   // gun
   sortTable[0x886E]=7666;   // gun
   sortTable[0x7EF2]=7667;   // gun
   sortTable[0x9CA7]=7668;   // gun
   sortTable[0x8F8A]=7669;   // gun
   sortTable[0x78D9]=7670;   // gun
   sortTable[0x889E]=7671;   // gun
   sortTable[0x7754]=7672;   // gun
   sortTable[0x8B34]=7673;   // gun
   sortTable[0x9B8C]=7674;   // gun
   sortTable[0x84D8]=7675;   // gun
   sortTable[0x9BC0]=7676;   // gun
   sortTable[0x8F25]=7677;   // gun
   sortTable[0x7DC4]=7678;   // gun
   sortTable[0x7774]=7679;   // gun
   sortTable[0x88AC]=7680;   // gun
   sortTable[0x4E28]=7681;   // gun
   sortTable[0x60C3]=7682;   // gun
   sortTable[0x74AD]=7683;   // gun
   sortTable[0x8509]=7684;   // gun
   sortTable[0x56FD]=7685;   // guo
   sortTable[0x570B]=7686;   // guo
   sortTable[0x8FC7]=7687;   // guo
   sortTable[0x904E]=7688;   // guo
   sortTable[0x679C]=7689;   // guo
   sortTable[0x9505]=7690;   // guo
   sortTable[0x934B]=7691;   // guo
   sortTable[0x88F9]=7692;   // guo
   sortTable[0x90ED]=7693;   // guo
   sortTable[0x7313]=7694;   // guo
   sortTable[0x8662]=7695;   // guo
   sortTable[0x5D1E]=7696;   // guo
   sortTable[0x6901]=7697;   // guo
   sortTable[0x9998]=7698;   // guo
   sortTable[0x5E3C]=7699;   // guo
   sortTable[0x5459]=7700;   // guo
   sortTable[0x8748]=7701;   // guo
   sortTable[0x57DA]=7702;   // guo
   sortTable[0x9983]=7703;   // guo
   sortTable[0x873E]=7704;   // guo
   sortTable[0x805D]=7705;   // guo
   sortTable[0x8158]=7706;   // guo
   sortTable[0x8F20]=7707;   // guo
   sortTable[0x7DB6]=7708;   // guo
   sortTable[0x8195]=7709;   // guo
   sortTable[0x852E]=7710;   // guo
   sortTable[0x7CBF]=7711;   // guo
   sortTable[0x83D3]=7712;   // guo
   sortTable[0x54BC]=7713;   // guo
   sortTable[0x556F]=7714;   // guo
   sortTable[0x5613]=7715;   // guo
   sortTable[0x56EF]=7716;   // guo
   sortTable[0x56F6]=7717;   // guo
   sortTable[0x56FB]=7718;   // guo
   sortTable[0x5700]=7719;   // guo
   sortTable[0x581D]=7720;   // guo
   sortTable[0x588E]=7721;   // guo
   sortTable[0x5E57]=7722;   // guo
   sortTable[0x5F49]=7723;   // guo
   sortTable[0x5F4D]=7724;   // guo
   sortTable[0x60C8]=7725;   // guo
   sortTable[0x6156]=7726;   // guo
   sortTable[0x69E8]=7727;   // guo
   sortTable[0x6DC9]=7728;   // guo
   sortTable[0x6F0D]=7729;   // guo
   sortTable[0x6FC4]=7730;   // guo
   sortTable[0x7611]=7731;   // guo
   sortTable[0x87C8]=7732;   // guo
   sortTable[0x921B]=7733;   // guo
   sortTable[0x9301]=7734;   // guo
   sortTable[0x9439]=7735;   // guo
   sortTable[0x991C]=7736;   // guo
   sortTable[0x54C8]=8192;   // ha
   sortTable[0x86E4]=8193;   // ha
   sortTable[0x94EA]=8194;   // ha
   sortTable[0x4E37]=8195;   // ha
   sortTable[0x5964]=8196;   // ha
   sortTable[0x8FD8]=8197;   // hai
   sortTable[0x9084]=8198;   // hai
   sortTable[0x5B69]=8199;   // hai
   sortTable[0x6D77]=8200;   // hai
   sortTable[0x5BB3]=8201;   // hai
   sortTable[0x54B3]=8202;   // hai
   sortTable[0x55E8]=8203;   // hai
   sortTable[0x55D0]=8204;   // hai
   sortTable[0x9AB8]=8205;   // hai
   sortTable[0x4EA5]=8206;   // hai
   sortTable[0x9A87]=8207;   // hai
   sortTable[0x91A2]=8208;   // hai
   sortTable[0x6C26]=8209;   // hai
   sortTable[0x80F2]=8210;   // hai
   sortTable[0x99ED]=8211;   // hai
   sortTable[0x9900]=8212;   // hai
   sortTable[0x917C]=8213;   // hai
   sortTable[0x9826]=8214;   // hai
   sortTable[0x548D]=8215;   // hai
   sortTable[0x56A1]=8216;   // hai
   sortTable[0x5870]=8217;   // hai
   sortTable[0x598E]=8218;   // hai
   sortTable[0x70F8]=8219;   // hai
   sortTable[0x995A]=8220;   // hai
   sortTable[0x558A]=8221;   // han
   sortTable[0x542B]=8222;   // han
   sortTable[0x6C49]=8223;   // han
   sortTable[0x6F22]=8224;   // han
   sortTable[0x5BD2]=8225;   // han
   sortTable[0x710A]=8226;   // han
   sortTable[0x65F1]=8227;   // han
   sortTable[0x6C57]=8228;   // han
   sortTable[0x61BE]=8229;   // han
   sortTable[0x64BC]=8230;   // han
   sortTable[0x634D]=8231;   // han
   sortTable[0x97E9]=8232;   // han
   sortTable[0x7FF0]=8233;   // han
   sortTable[0x7F55]=8234;   // han
   sortTable[0x51FD]=8235;   // han
   sortTable[0x6DB5]=8236;   // han
   sortTable[0x608D]=8237;   // han
   sortTable[0x9163]=8238;   // han
   sortTable[0x90AF]=8239;   // han
   sortTable[0x701A]=8240;   // han
   sortTable[0x9894]=8241;   // han
   sortTable[0x61A8]=8242;   // han
   sortTable[0x7113]=8243;   // han
   sortTable[0x9F3E]=8244;   // han
   sortTable[0x83E1]=8245;   // han
   sortTable[0x6657]=8246;   // han
   sortTable[0x86B6]=8247;   // han
   sortTable[0x961A]=8248;   // han
   sortTable[0x9097]=8249;   // han
   sortTable[0x9878]=8250;   // han
   sortTable[0x95EC]=8251;   // han
   sortTable[0x8C8B]=8252;   // han
   sortTable[0x92B2]=8253;   // han
   sortTable[0x7745]=8254;   // han
   sortTable[0x8B40]=8255;   // han
   sortTable[0x8C3D]=8256;   // han
   sortTable[0x99AF]=8257;   // han
   sortTable[0x9588]=8258;   // han
   sortTable[0x97D3]=8259;   // han
   sortTable[0x99FB]=8260;   // han
   sortTable[0x6496]=8261;   // han
   sortTable[0x80A3]=8262;   // han
   sortTable[0x850A]=8263;   // han
   sortTable[0x8677]=8264;   // han
   sortTable[0x872C]=8265;   // han
   sortTable[0x9837]=8266;   // han
   sortTable[0x9B7D]=8267;   // han
   sortTable[0x8C43]=8268;   // han
   sortTable[0x91EC]=8269;   // han
   sortTable[0x92CE]=8270;   // han
   sortTable[0x92E1]=8271;   // han
   sortTable[0x9844]=8272;   // han
   sortTable[0x4E06]=8273;   // han
   sortTable[0x4F44]=8274;   // han
   sortTable[0x50BC]=8275;   // han
   sortTable[0x516F]=8276;   // han
   sortTable[0x51FE]=8277;   // han
   sortTable[0x5388]=8278;   // han
   sortTable[0x5481]=8279;   // han
   sortTable[0x54FB]=8280;   // han
   sortTable[0x5505]=8281;   // han
   sortTable[0x5705]=8282;   // han
   sortTable[0x57BE]=8283;   // han
   sortTable[0x5A22]=8284;   // han
   sortTable[0x5AE8]=8285;   // han
   sortTable[0x5C7D]=8286;   // han
   sortTable[0x5CBE]=8287;   // han
   sortTable[0x5D21]=8288;   // han
   sortTable[0x5D45]=8289;   // han
   sortTable[0x6658]=8290;   // han
   sortTable[0x6665]=8291;   // han
   sortTable[0x66B5]=8292;   // han
   sortTable[0x6892]=8293;   // han
   sortTable[0x6B5B]=8294;   // han
   sortTable[0x6D5B]=8295;   // han
   sortTable[0x6D6B]=8296;   // han
   sortTable[0x6D86]=8297;   // han
   sortTable[0x6F8F]=8298;   // han
   sortTable[0x70B6]=8299;   // han
   sortTable[0x71AF]=8300;   // han
   sortTable[0x7233]=8301;   // han
   sortTable[0x7302]=8302;   // han
   sortTable[0x7400]=8303;   // han
   sortTable[0x751D]=8304;   // han
   sortTable[0x7694]=8305;   // han
   sortTable[0x7B68]=8306;   // han
   sortTable[0x839F]=8307;   // han
   sortTable[0x862B]=8308;   // han
   sortTable[0x86FF]=8309;   // han
   sortTable[0x872D]=8310;   // han
   sortTable[0x8792]=8311;   // han
   sortTable[0x96D7]=8312;   // han
   sortTable[0x9807]=8313;   // han
   sortTable[0x99A0]=8314;   // han
   sortTable[0x9B2B]=8315;   // han
   sortTable[0x9DBE]=8316;   // han
   sortTable[0x822A]=8317;   // hang
   sortTable[0x676D]=8318;   // hang
   sortTable[0x592F]=8319;   // hang
   sortTable[0x6C86]=8320;   // hang
   sortTable[0x73E9]=8321;   // hang
   sortTable[0x9883]=8322;   // hang
   sortTable[0x8FD2]=8323;   // hang
   sortTable[0x86A2]=8324;   // hang
   sortTable[0x7B10]=8325;   // hang
   sortTable[0x7ED7]=8326;   // hang
   sortTable[0x9B67]=8327;   // hang
   sortTable[0x8CA5]=8328;   // hang
   sortTable[0x82C0]=8329;   // hang
   sortTable[0x57B3]=8330;   // hang
   sortTable[0x65BB]=8331;   // hang
   sortTable[0x7B55]=8332;   // hang
   sortTable[0x7D4E]=8333;   // hang
   sortTable[0x980F]=8334;   // hang
   sortTable[0x597D]=8335;   // hao
   sortTable[0x53F7]=8336;   // hao
   sortTable[0x865F]=8337;   // hao
   sortTable[0x6BEB]=8338;   // hao
   sortTable[0x8017]=8339;   // hao
   sortTable[0x8C6A]=8340;   // hao
   sortTable[0x58D5]=8341;   // hao
   sortTable[0x6D69]=8342;   // hao
   sortTable[0x7693]=8343;   // hao
   sortTable[0x90DD]=8344;   // hao
   sortTable[0x660A]=8345;   // hao
   sortTable[0x6FE0]=8346;   // hao
   sortTable[0x568E]=8347;   // hao
   sortTable[0x98A2]=8348;   // hao
   sortTable[0x704F]=8349;   // hao
   sortTable[0x55E5]=8350;   // hao
   sortTable[0x84BF]=8351;   // hao
   sortTable[0x869D]=8352;   // hao
   sortTable[0x8C89]=8353;   // hao
   sortTable[0x8585]=8354;   // hao
   sortTable[0x9117]=8355;   // hao
   sortTable[0x5686]=8356;   // hao
   sortTable[0x79CF]=8357;   // hao
   sortTable[0x9865]=8358;   // hao
   sortTable[0x8814]=8359;   // hao
   sortTable[0x8AD5]=8360;   // hao
   sortTable[0x8320]=8361;   // hao
   sortTable[0x85A7]=8362;   // hao
   sortTable[0x7C47]=8363;   // hao
   sortTable[0x9C1D]=8364;   // hao
   sortTable[0x8583]=8365;   // hao
   sortTable[0x5090]=8366;   // hao
   sortTable[0x512B]=8367;   // hao
   sortTable[0x54E0]=8368;   // hao
   sortTable[0x5637]=8369;   // hao
   sortTable[0x5651]=8370;   // hao
   sortTable[0x5CFC]=8371;   // hao
   sortTable[0x604F]=8372;   // hao
   sortTable[0x608E]=8373;   // hao
   sortTable[0x6626]=8374;   // hao
   sortTable[0x6667]=8375;   // hao
   sortTable[0x66A4]=8376;   // hao
   sortTable[0x66AD]=8377;   // hao
   sortTable[0x66CD]=8378;   // hao
   sortTable[0x6903]=8379;   // hao
   sortTable[0x6BDC]=8380;   // hao
   sortTable[0x6DCF]=8381;   // hao
   sortTable[0x6EC8]=8382;   // hao
   sortTable[0x6F94]=8383;   // hao
   sortTable[0x705D]=8384;   // hao
   sortTable[0x7346]=8385;   // hao
   sortTable[0x734B]=8386;   // hao
   sortTable[0x7354]=8387;   // hao
   sortTable[0x769C]=8388;   // hao
   sortTable[0x769E]=8389;   // hao
   sortTable[0x76A1]=8390;   // hao
   sortTable[0x76A5]=8391;   // hao
   sortTable[0x7AD3]=8392;   // hao
   sortTable[0x8055]=8393;   // hao
   sortTable[0x8B79]=8394;   // hao
   sortTable[0x93AC]=8395;   // hao
   sortTable[0x548C]=8396;   // he
   sortTable[0x5408]=8397;   // he
   sortTable[0x6CB3]=8398;   // he
   sortTable[0x4F55]=8399;   // he
   sortTable[0x559D]=8400;   // he
   sortTable[0x76D2]=8401;   // he
   sortTable[0x8377]=8402;   // he
   sortTable[0x6838]=8403;   // he
   sortTable[0x8D3A]=8404;   // he
   sortTable[0x8CC0]=8405;   // he
   sortTable[0x55EC]=8406;   // he
   sortTable[0x8910]=8407;   // he
   sortTable[0x8D6B]=8408;   // he
   sortTable[0x9E64]=8409;   // he
   sortTable[0x52BE]=8410;   // he
   sortTable[0x79BE]=8411;   // he
   sortTable[0x58D1]=8412;   // he
   sortTable[0x9616]=8413;   // he
   sortTable[0x66F7]=8414;   // he
   sortTable[0x6DB8]=8415;   // he
   sortTable[0x8BC3]=8416;   // he
   sortTable[0x83CF]=8417;   // he
   sortTable[0x9602]=8418;   // he
   sortTable[0x988C]=8419;   // he
   sortTable[0x76CD]=8420;   // he
   sortTable[0x90C3]=8421;   // he
   sortTable[0x9FA2]=8422;   // he
   sortTable[0x86B5]=8423;   // he
   sortTable[0x7FEE]=8424;   // he
   sortTable[0x97A8]=8425;   // he
   sortTable[0x8988]=8426;   // he
   sortTable[0x9F81]=8427;   // he
   sortTable[0x9E56]=8428;   // he
   sortTable[0x9978]=8429;   // he
   sortTable[0x7909]=8430;   // he
   sortTable[0x9EA7]=8431;   // he
   sortTable[0x7C7A]=8432;   // he
   sortTable[0x9C84]=8433;   // he
   sortTable[0x8A65]=8434;   // he
   sortTable[0x881A]=8435;   // he
   sortTable[0x76C7]=8436;   // he
   sortTable[0x7FEF]=8437;   // he
   sortTable[0x8B1E]=8438;   // he
   sortTable[0x7CAD]=8439;   // he
   sortTable[0x8894]=8440;   // he
   sortTable[0x924C]=8441;   // he
   sortTable[0x9DA1]=8442;   // he
   sortTable[0x76C9]=8443;   // he
   sortTable[0x79F4]=8444;   // he
   sortTable[0x7D07]=8445;   // he
   sortTable[0x879B]=8446;   // he
   sortTable[0x9449]=8447;   // he
   sortTable[0x974E]=8448;   // he
   sortTable[0x981C]=8449;   // he
   sortTable[0x9B7A]=8450;   // he
   sortTable[0x9DB4]=8451;   // he
   sortTable[0x9E16]=8452;   // he
   sortTable[0x9F55]=8453;   // he
   sortTable[0x4F6B]=8454;   // he
   sortTable[0x5392]=8455;   // he
   sortTable[0x548A]=8456;   // he
   sortTable[0x54EC]=8457;   // he
   sortTable[0x555D]=8458;   // he
   sortTable[0x55C3]=8459;   // he
   sortTable[0x578E]=8460;   // he
   sortTable[0x59C0]=8461;   // he
   sortTable[0x5CC6]=8462;   // he
   sortTable[0x60D2]=8463;   // he
   sortTable[0x62B2]=8464;   // he
   sortTable[0x6546]=8465;   // he
   sortTable[0x67C7]=8466;   // he
   sortTable[0x6941]=8467;   // he
   sortTable[0x6B31]=8468;   // he
   sortTable[0x6BFC]=8469;   // he
   sortTable[0x6E2E]=8470;   // he
   sortTable[0x6F95]=8471;   // he
   sortTable[0x7103]=8472;   // he
   sortTable[0x7142]=8473;   // he
   sortTable[0x7186]=8474;   // he
   sortTable[0x7187]=8475;   // he
   sortTable[0x7200]=8476;   // he
   sortTable[0x72E2]=8477;   // he
   sortTable[0x764B]=8478;   // he
   sortTable[0x76AC]=8479;   // he
   sortTable[0x788B]=8480;   // he
   sortTable[0x7A52]=8481;   // he
   sortTable[0x7BD5]=8482;   // he
   sortTable[0x8402]=8483;   // he
   sortTable[0x8A36]=8484;   // he
   sortTable[0x8A38]=8485;   // he
   sortTable[0x8C88]=8486;   // he
   sortTable[0x8F05]=8487;   // he
   sortTable[0x95D4]=8488;   // he
   sortTable[0x974D]=8489;   // he
   sortTable[0x974F]=8490;   // he
   sortTable[0x9DAE]=8491;   // he
   sortTable[0x9ED1]=8492;   // hei
   sortTable[0x563F]=8493;   // hei
   sortTable[0x9ED2]=8494;   // hei
   sortTable[0x6F76]=8495;   // hei
   sortTable[0x5F88]=8496;   // hen
   sortTable[0x6068]=8497;   // hen
   sortTable[0x72E0]=8498;   // hen
   sortTable[0x75D5]=8499;   // hen
   sortTable[0x8A6A]=8500;   // hen
   sortTable[0x978E]=8501;   // hen
   sortTable[0x4F77]=8502;   // hen
   sortTable[0x62EB]=8503;   // hen
   sortTable[0x54FC]=8504;   // heng
   sortTable[0x6A2A]=8505;   // heng
   sortTable[0x6A6B]=8506;   // heng
   sortTable[0x8861]=8507;   // heng
   sortTable[0x6052]=8508;   // heng
   sortTable[0x6046]=8509;   // heng
   sortTable[0x4EA8]=8510;   // heng
   sortTable[0x8605]=8511;   // heng
   sortTable[0x6841]=8512;   // heng
   sortTable[0x9E3B]=8513;   // heng
   sortTable[0x811D]=8514;   // heng
   sortTable[0x9445]=8515;   // heng
   sortTable[0x9D34]=8516;   // heng
   sortTable[0x80FB]=8517;   // heng
   sortTable[0x5548]=8518;   // heng
   sortTable[0x583C]=8519;   // heng
   sortTable[0x59EE]=8520;   // heng
   sortTable[0x6099]=8521;   // heng
   sortTable[0x6DA5]=8522;   // heng
   sortTable[0x70C6]=8523;   // heng
   sortTable[0x9D46]=8524;   // heng
   sortTable[0x5677]=8525;   // hm
   sortTable[0x7EA2]=8526;   // hong
   sortTable[0x7D05]=8527;   // hong
   sortTable[0x8F70]=8528;   // hong
   sortTable[0x8F5F]=8529;   // hong
   sortTable[0x6D2A]=8530;   // hong
   sortTable[0x5B8F]=8531;   // hong
   sortTable[0x54C4]=8532;   // hong
   sortTable[0x70D8]=8533;   // hong
   sortTable[0x9E3F]=8534;   // hong
   sortTable[0x5F18]=8535;   // hong
   sortTable[0x85A8]=8536;   // hong
   sortTable[0x8679]=8537;   // hong
   sortTable[0x95F3]=8538;   // hong
   sortTable[0x6CD3]=8539;   // hong
   sortTable[0x7EAE]=8540;   // hong
   sortTable[0x7AD1]=8541;   // hong
   sortTable[0x836D]=8542;   // hong
   sortTable[0x9277]=8543;   // hong
   sortTable[0x8A07]=8544;   // hong
   sortTable[0x8BA7]=8545;   // hong
   sortTable[0x9EC9]=8546;   // hong
   sortTable[0x7FC3]=8547;   // hong
   sortTable[0x92D0]=8548;   // hong
   sortTable[0x857B]=8549;   // hong
   sortTable[0x9B5F]=8550;   // hong
   sortTable[0x8C3C]=8551;   // hong
   sortTable[0x9367]=8552;   // hong
   sortTable[0x8A0C]=8553;   // hong
   sortTable[0x95A7]=8554;   // hong
   sortTable[0x7D18]=8555;   // hong
   sortTable[0x803E]=8556;   // hong
   sortTable[0x8F37]=8557;   // hong
   sortTable[0x8C39]=8558;   // hong
   sortTable[0x7CA0]=8559;   // hong
   sortTable[0x7D8B]=8560;   // hong
   sortTable[0x8453]=8561;   // hong
   sortTable[0x9D3B]=8562;   // hong
   sortTable[0x7AE4]=8563;   // hong
   sortTable[0x82F0]=8564;   // hong
   sortTable[0x9710]=8565;   // hong
   sortTable[0x7FDD]=8566;   // hong
   sortTable[0x7D2D]=8567;   // hong
   sortTable[0x8452]=8568;   // hong
   sortTable[0x8EE3]=8569;   // hong
   sortTable[0x9ECC]=8570;   // hong
   sortTable[0x7861]=8571;   // hong
   sortTable[0x8C3E]=8572;   // hong
   sortTable[0x95C2]=8573;   // hong
   sortTable[0x9783]=8574;   // hong
   sortTable[0x4EDC]=8575;   // hong
   sortTable[0x53FF]=8576;   // hong
   sortTable[0x5430]=8577;   // hong
   sortTable[0x543D]=8578;   // hong
   sortTable[0x544D]=8579;   // hong
   sortTable[0x55CA]=8580;   // hong
   sortTable[0x569D]=8581;   // hong
   sortTable[0x57AC]=8582;   // hong
   sortTable[0x5985]=8583;   // hong
   sortTable[0x5A02]=8584;   // hong
   sortTable[0x5B96]=8585;   // hong
   sortTable[0x5CF5]=8586;   // hong
   sortTable[0x5F4B]=8587;   // hong
   sortTable[0x63C8]=8588;   // hong
   sortTable[0x6494]=8589;   // hong
   sortTable[0x664E]=8590;   // hong
   sortTable[0x6C6F]=8591;   // hong
   sortTable[0x6D64]=8592;   // hong
   sortTable[0x6E31]=8593;   // hong
   sortTable[0x6E39]=8594;   // hong
   sortTable[0x6F42]=8595;   // hong
   sortTable[0x6F8B]=8596;   // hong
   sortTable[0x6F92]=8597;   // hong
   sortTable[0x7074]=8598;   // hong
   sortTable[0x7122]=8599;   // hong
   sortTable[0x7392]=8600;   // hong
   sortTable[0x7854]=8601;   // hong
   sortTable[0x921C]=8602;   // hong
   sortTable[0x92BE]=8603;   // hong
   sortTable[0x958E]=8604;   // hong
   sortTable[0x971F]=8605;   // hong
   sortTable[0x9B28]=8606;   // hong
   sortTable[0x540E]=8607;   // hou
   sortTable[0x5019]=8608;   // hou
   sortTable[0x539A]=8609;   // hou
   sortTable[0x7334]=8610;   // hou
   sortTable[0x543C]=8611;   // hou
   sortTable[0x5589]=8612;   // hou
   sortTable[0x4FAF]=8613;   // hou
   sortTable[0x5F8C]=8614;   // hou
   sortTable[0x9005]=8615;   // hou
   sortTable[0x9C8E]=8616;   // hou
   sortTable[0x7CC7]=8617;   // hou
   sortTable[0x7BCC]=8618;   // hou
   sortTable[0x9ABA]=8619;   // hou
   sortTable[0x5820]=8620;   // hou
   sortTable[0x90C8]=8621;   // hou
   sortTable[0x9F41]=8622;   // hou
   sortTable[0x777A]=8623;   // hou
   sortTable[0x9931]=8624;   // hou
   sortTable[0x936D]=8625;   // hou
   sortTable[0x760A]=8626;   // hou
   sortTable[0x7FED]=8627;   // hou
   sortTable[0x9107]=8628;   // hou
   sortTable[0x8454]=8629;   // hou
   sortTable[0x5795]=8630;   // hou
   sortTable[0x5E3F]=8631;   // hou
   sortTable[0x6D09]=8632;   // hou
   sortTable[0x72BC]=8633;   // hou
   sortTable[0x77E6]=8634;   // hou
   sortTable[0x7FF5]=8635;   // hou
   sortTable[0x8C5E]=8636;   // hou
   sortTable[0x9B9C]=8637;   // hou
   sortTable[0x9BF8]=8638;   // hou
   sortTable[0x9C5F]=8639;   // hou
   sortTable[0x9C98]=8640;   // hou
   sortTable[0x5FFD]=8641;   // hu
   sortTable[0x62A4]=8642;   // hu
   sortTable[0x8B77]=8643;   // hu
   sortTable[0x547C]=8644;   // hu
   sortTable[0x4E4E]=8645;   // hu
   sortTable[0x4E92]=8646;   // hu
   sortTable[0x6E56]=8647;   // hu
   sortTable[0x80E1]=8648;   // hu
   sortTable[0x864E]=8649;   // hu
   sortTable[0x6237]=8650;   // hu
   sortTable[0x6236]=8651;   // hu
   sortTable[0x7CCA]=8652;   // hu
   sortTable[0x58F6]=8653;   // hu
   sortTable[0x58FA]=8654;   // hu
   sortTable[0x8774]=8655;   // hu
   sortTable[0x846B]=8656;   // hu
   sortTable[0x72D0]=8657;   // hu
   sortTable[0x745A]=8658;   // hu
   sortTable[0x552C]=8659;   // hu
   sortTable[0x60DA]=8660;   // hu
   sortTable[0x5F27]=8661;   // hu
   sortTable[0x659B]=8662;   // hu
   sortTable[0x6CAA]=8663;   // hu
   sortTable[0x6248]=8664;   // hu
   sortTable[0x7B0F]=8665;   // hu
   sortTable[0x6D52]=8666;   // hu
   sortTable[0x795C]=8667;   // hu
   sortTable[0x7173]=8668;   // hu
   sortTable[0x7425]=8669;   // hu
   sortTable[0x74E0]=8670;   // hu
   sortTable[0x9E55]=8671;   // hu
   sortTable[0x69F2]=8672;   // hu
   sortTable[0x6019]=8673;   // hu
   sortTable[0x89F3]=8674;   // hu
   sortTable[0x70C0]=8675;   // hu
   sortTable[0x5CB5]=8676;   // hu
   sortTable[0x9E71]=8677;   // hu
   sortTable[0x6EF9]=8678;   // hu
   sortTable[0x7E20]=8679;   // hu
   sortTable[0x7322]=8680;   // hu
   sortTable[0x9120]=8681;   // hu
   sortTable[0x56EB]=8682;   // hu
   sortTable[0x553F]=8683;   // hu
   sortTable[0x9190]=8684;   // hu
   sortTable[0x623D]=8685;   // hu
   sortTable[0x8656]=8686;   // hu
   sortTable[0x7C04]=8687;   // hu
   sortTable[0x992C]=8688;   // hu
   sortTable[0x51B1]=8689;   // hu
   sortTable[0x81B4]=8690;   // hu
   sortTable[0x96BA]=8691;   // hu
   sortTable[0x7C90]=8692;   // hu
   sortTable[0x9C6F]=8693;   // hu
   sortTable[0x7BB6]=8694;   // hu
   sortTable[0x9800]=8695;   // hu
   sortTable[0x865D]=8696;   // hu
   sortTable[0x7D94]=8697;   // hu
   sortTable[0x8290]=8698;   // hu
   sortTable[0x9359]=8699;   // hu
   sortTable[0x9B71]=8700;   // hu
   sortTable[0x8F77]=8701;   // hu
   sortTable[0x9CF8]=8702;   // hu
   sortTable[0x9BF1]=8703;   // hu
   sortTable[0x9CE0]=8704;   // hu
   sortTable[0x8B3C]=8705;   // hu
   sortTable[0x9378]=8706;   // hu
   sortTable[0x96FD]=8707;   // hu
   sortTable[0x879C]=8708;   // hu
   sortTable[0x8EE4]=8709;   // hu
   sortTable[0x4E55]=8710;   // hu
   sortTable[0x4E65]=8711;   // hu
   sortTable[0x4E6F]=8712;   // hu
   sortTable[0x4FFF]=8713;   // hu
   sortTable[0x51B4]=8714;   // hu
   sortTable[0x5322]=8715;   // hu
   sortTable[0x532B]=8716;   // hu
   sortTable[0x5596]=8717;   // hu
   sortTable[0x55C0]=8718;   // hu
   sortTable[0x5611]=8719;   // hu
   sortTable[0x561D]=8720;   // hu
   sortTable[0x569B]=8721;   // hu
   sortTable[0x5780]=8722;   // hu
   sortTable[0x58F7]=8723;   // hu
   sortTable[0x5A5F]=8724;   // hu
   sortTable[0x5AA9]=8725;   // hu
   sortTable[0x5AED]=8726;   // hu
   sortTable[0x5AEE]=8727;   // hu
   sortTable[0x5BE3]=8728;   // hu
   sortTable[0x5E0D]=8729;   // hu
   sortTable[0x5E60]=8730;   // hu
   sortTable[0x5F16]=8731;   // hu
   sortTable[0x6018]=8732;   // hu
   sortTable[0x6057]=8733;   // hu
   sortTable[0x622F]=8734;   // hu
   sortTable[0x6238]=8735;   // hu
   sortTable[0x6287]=8736;   // hu
   sortTable[0x6430]=8737;   // hu
   sortTable[0x6462]=8738;   // hu
   sortTable[0x6608]=8739;   // hu
   sortTable[0x6612]=8740;   // hu
   sortTable[0x66F6]=8741;   // hu
   sortTable[0x6791]=8742;   // hu
   sortTable[0x695B]=8743;   // hu
   sortTable[0x695C]=8744;   // hu
   sortTable[0x69F4]=8745;   // hu
   sortTable[0x6B51]=8746;   // hu
   sortTable[0x6C7B]=8747;   // hu
   sortTable[0x6C8D]=8748;   // hu
   sortTable[0x6CD8]=8749;   // hu
   sortTable[0x6DF4]=8750;   // hu
   sortTable[0x6EEC]=8751;   // hu
   sortTable[0x6EF8]=8752;   // hu
   sortTable[0x702B]=8753;   // hu
   sortTable[0x7100]=8754;   // hu
   sortTable[0x71A9]=8755;   // hu
   sortTable[0x74F3]=8756;   // hu
   sortTable[0x7D57]=8757;   // hu
   sortTable[0x82F8]=8758;   // hu
   sortTable[0x8400]=8759;   // hu
   sortTable[0x851B]=8760;   // hu
   sortTable[0x8530]=8761;   // hu
   sortTable[0x864D]=8762;   // hu
   sortTable[0x885A]=8763;   // hu
   sortTable[0x933F]=8764;   // hu
   sortTable[0x96D0]=8765;   // hu
   sortTable[0x97C4]=8766;   // hu
   sortTable[0x9836]=8767;   // hu
   sortTable[0x9B0D]=8768;   // hu
   sortTable[0x9C17]=8769;   // hu
   sortTable[0x9D60]=8770;   // hu
   sortTable[0x9D98]=8771;   // hu
   sortTable[0x9DA6]=8772;   // hu
   sortTable[0x9E0C]=8773;   // hu
   sortTable[0x8BDD]=8774;   // hua
   sortTable[0x8A71]=8775;   // hua
   sortTable[0x5316]=8776;   // hua
   sortTable[0x82B1]=8777;   // hua
   sortTable[0x753B]=8778;   // hua
   sortTable[0x756B]=8779;   // hua
   sortTable[0x5212]=8780;   // hua
   sortTable[0x6ED1]=8781;   // hua
   sortTable[0x54D7]=8782;   // hua
   sortTable[0x5629]=8783;   // hua
   sortTable[0x534E]=8784;   // hua
   sortTable[0x83EF]=8785;   // hua
   sortTable[0x733E]=8786;   // hua
   sortTable[0x6866]=8787;   // hua
   sortTable[0x6A3A]=8788;   // hua
   sortTable[0x9A85]=8789;   // hua
   sortTable[0x94E7]=8790;   // hua
   sortTable[0x8B41]=8791;   // hua
   sortTable[0x92D8]=8792;   // hua
   sortTable[0x7CC0]=8793;   // hua
   sortTable[0x7E63]=8794;   // hua
   sortTable[0x89DF]=8795;   // hua
   sortTable[0x91EA]=8796;   // hua
   sortTable[0x8B6E]=8797;   // hua
   sortTable[0x9A4A]=8798;   // hua
   sortTable[0x8796]=8799;   // hua
   sortTable[0x9DE8]=8800;   // hua
   sortTable[0x82B2]=8801;   // hua
   sortTable[0x8AE3]=8802;   // hua
   sortTable[0x5283]=8803;   // hua
   sortTable[0x57D6]=8804;   // hua
   sortTable[0x593B]=8805;   // hua
   sortTable[0x59E1]=8806;   // hua
   sortTable[0x5A72]=8807;   // hua
   sortTable[0x5A73]=8808;   // hua
   sortTable[0x5AFF]=8809;   // hua
   sortTable[0x5B05]=8810;   // hua
   sortTable[0x5D0B]=8811;   // hua
   sortTable[0x6433]=8812;   // hua
   sortTable[0x6466]=8813;   // hua
   sortTable[0x64B6]=8814;   // hua
   sortTable[0x6779]=8815;   // hua
   sortTable[0x691B]=8816;   // hua
   sortTable[0x69EC]=8817;   // hua
   sortTable[0x6F85]=8818;   // hua
   sortTable[0x748D]=8819;   // hua
   sortTable[0x7575]=8820;   // hua
   sortTable[0x7874]=8821;   // hua
   sortTable[0x78C6]=8822;   // hua
   sortTable[0x8219]=8823;   // hua
   sortTable[0x848A]=8824;   // hua
   sortTable[0x8550]=8825;   // hua
   sortTable[0x8AAE]=8826;   // hua
   sortTable[0x91EB]=8827;   // hua
   sortTable[0x9335]=8828;   // hua
   sortTable[0x93F5]=8829;   // hua
   sortTable[0x9ECA]=8830;   // hua
   sortTable[0x574F]=8831;   // huai
   sortTable[0x58DE]=8832;   // huai
   sortTable[0x6000]=8833;   // huai
   sortTable[0x61F7]=8834;   // huai
   sortTable[0x5F8A]=8835;   // huai
   sortTable[0x69D0]=8836;   // huai
   sortTable[0x6DEE]=8837;   // huai
   sortTable[0x8E1D]=8838;   // huai
   sortTable[0x8931]=8839;   // huai
   sortTable[0x8922]=8840;   // huai
   sortTable[0x8AD9]=8841;   // huai
   sortTable[0x863E]=8842;   // huai
   sortTable[0x54B6]=8843;   // huai
   sortTable[0x58CA]=8844;   // huai
   sortTable[0x61D0]=8845;   // huai
   sortTable[0x6AF0]=8846;   // huai
   sortTable[0x7024]=8847;   // huai
   sortTable[0x8032]=8848;   // huai
   sortTable[0x8639]=8849;   // huai
   sortTable[0x6362]=8850;   // huan
   sortTable[0x63DB]=8851;   // huan
   sortTable[0x73AF]=8852;   // huan
   sortTable[0x74B0]=8853;   // huan
   sortTable[0x6B22]=8854;   // huan
   sortTable[0x6B61]=8855;   // huan
   sortTable[0x7F13]=8856;   // huan
   sortTable[0x7DE9]=8857;   // huan
   sortTable[0x5E7B]=8858;   // huan
   sortTable[0x5524]=8859;   // huan
   sortTable[0x559A]=8860;   // huan
   sortTable[0x60A3]=8861;   // huan
   sortTable[0x6853]=8862;   // huan
   sortTable[0x5BA6]=8863;   // huan
   sortTable[0x7115]=8864;   // huan
   sortTable[0x8C62]=8865;   // huan
   sortTable[0x75EA]=8866;   // huan
   sortTable[0x6D63]=8867;   // huan
   sortTable[0x6D39]=8868;   // huan
   sortTable[0x9B1F]=8869;   // huan
   sortTable[0x6DA3]=8870;   // huan
   sortTable[0x5942]=8871;   // huan
   sortTable[0x5BF0]=8872;   // huan
   sortTable[0x571C]=8873;   // huan
   sortTable[0x8411]=8874;   // huan
   sortTable[0x737E]=8875;   // huan
   sortTable[0x902D]=8876;   // huan
   sortTable[0x953E]=8877;   // huan
   sortTable[0x64D0]=8878;   // huan
   sortTable[0x9A69]=8879;   // huan
   sortTable[0x90C7]=8880;   // huan
   sortTable[0x7F33]=8881;   // huan
   sortTable[0x8F58]=8882;   // huan
   sortTable[0x8B99]=8883;   // huan
   sortTable[0x956E]=8884;   // huan
   sortTable[0x7746]=8885;   // huan
   sortTable[0x9E6E]=8886;   // huan
   sortTable[0x6F36]=8887;   // huan
   sortTable[0x7D59]=8888;   // huan
   sortTable[0x961B]=8889;   // huan
   sortTable[0x9CA9]=8890;   // huan
   sortTable[0x9370]=8891;   // huan
   sortTable[0x85E7]=8892;   // huan
   sortTable[0x8C86]=8893;   // huan
   sortTable[0x8C9B]=8894;   // huan
   sortTable[0x8341]=8895;   // huan
   sortTable[0x95E4]=8896;   // huan
   sortTable[0x9BC7]=8897;   // huan
   sortTable[0x7CEB]=8898;   // huan
   sortTable[0x7D84]=8899;   // huan
   sortTable[0x8C72]=8900;   // huan
   sortTable[0x9436]=8901;   // huan
   sortTable[0x96C8]=8902;   // huan
   sortTable[0x77A3]=8903;   // huan
   sortTable[0x7E6F]=8904;   // huan
   sortTable[0x7FA6]=8905;   // huan
   sortTable[0x8408]=8906;   // huan
   sortTable[0x9144]=8907;   // huan
   sortTable[0x559B]=8908;   // huan
   sortTable[0x56BE]=8909;   // huan
   sortTable[0x5950]=8910;   // huan
   sortTable[0x5B1B]=8911;   // huan
   sortTable[0x5BCF]=8912;   // huan
   sortTable[0x5CD8]=8913;   // huan
   sortTable[0x5D48]=8914;   // huan
   sortTable[0x610C]=8915;   // huan
   sortTable[0x61FD]=8916;   // huan
   sortTable[0x650C]=8917;   // huan
   sortTable[0x6899]=8918;   // huan
   sortTable[0x69F5]=8919;   // huan
   sortTable[0x6B53]=8920;   // huan
   sortTable[0x6E19]=8921;   // huan
   sortTable[0x6FA3]=8922;   // huan
   sortTable[0x6FB4]=8923;   // huan
   sortTable[0x70C9]=8924;   // huan
   sortTable[0x7165]=8925;   // huan
   sortTable[0x72BF]=8926;   // huan
   sortTable[0x72DF]=8927;   // huan
   sortTable[0x744D]=8928;   // huan
   sortTable[0x74DB]=8929;   // huan
   sortTable[0x7613]=8930;   // huan
   sortTable[0x8092]=8931;   // huan
   sortTable[0x926E]=8932;   // huan
   sortTable[0x9C00]=8933;   // huan
   sortTable[0x9D05]=8934;   // huan
   sortTable[0x9D4D]=8935;   // huan
   sortTable[0x9EC4]=8936;   // huang
   sortTable[0x9EC3]=8937;   // huang
   sortTable[0x614C]=8938;   // huang
   sortTable[0x7687]=8939;   // huang
   sortTable[0x8757]=8940;   // huang
   sortTable[0x8352]=8941;   // huang
   sortTable[0x6643]=8942;   // huang
   sortTable[0x714C]=8943;   // huang
   sortTable[0x78FA]=8944;   // huang
   sortTable[0x604D]=8945;   // huang
   sortTable[0x8C0E]=8946;   // huang
   sortTable[0x8B0A]=8947;   // huang
   sortTable[0x51F0]=8948;   // huang
   sortTable[0x60F6]=8949;   // huang
   sortTable[0x5E4C]=8950;   // huang
   sortTable[0x7C27]=8951;   // huang
   sortTable[0x6E5F]=8952;   // huang
   sortTable[0x968D]=8953;   // huang
   sortTable[0x749C]=8954;   // huang
   sortTable[0x6F62]=8955;   // huang
   sortTable[0x9051]=8956;   // huang
   sortTable[0x8093]=8957;   // huang
   sortTable[0x5FA8]=8958;   // huang
   sortTable[0x7BC1]=8959;   // huang
   sortTable[0x953D]=8960;   // huang
   sortTable[0x9CC7]=8961;   // huang
   sortTable[0x87E5]=8962;   // huang
   sortTable[0x7640]=8963;   // huang
   sortTable[0x824E]=8964;   // huang
   sortTable[0x9404]=8965;   // huang
   sortTable[0x9C09]=8966;   // huang
   sortTable[0x8A64]=8967;   // huang
   sortTable[0x9C51]=8968;   // huang
   sortTable[0x992D]=8969;   // huang
   sortTable[0x845F]=8970;   // huang
   sortTable[0x8DAA]=8971;   // huang
   sortTable[0x9360]=8972;   // huang
   sortTable[0x9DEC]=8973;   // huang
   sortTable[0x97F9]=8974;   // huang
   sortTable[0x9A1C]=8975;   // huang
   sortTable[0x505F]=8976;   // huang
   sortTable[0x5164]=8977;   // huang
   sortTable[0x55A4]=8978;   // huang
   sortTable[0x582D]=8979;   // huang
   sortTable[0x5843]=8980;   // huang
   sortTable[0x58B4]=8981;   // huang
   sortTable[0x595B]=8982;   // huang
   sortTable[0x5A93]=8983;   // huang
   sortTable[0x5BBA]=8984;   // huang
   sortTable[0x5D32]=8985;   // huang
   sortTable[0x5DDF]=8986;   // huang
   sortTable[0x6033]=8987;   // huang
   sortTable[0x6130]=8988;   // huang
   sortTable[0x6644]=8989;   // huang
   sortTable[0x66C2]=8990;   // huang
   sortTable[0x671A]=8991;   // huang
   sortTable[0x697B]=8992;   // huang
   sortTable[0x69A5]=8993;   // huang
   sortTable[0x6ACE]=8994;   // huang
   sortTable[0x6EC9]=8995;   // huang
   sortTable[0x70BE]=8996;   // huang
   sortTable[0x7180]=8997;   // huang
   sortTable[0x71BF]=8998;   // huang
   sortTable[0x735A]=8999;   // huang
   sortTable[0x745D]=9000;   // huang
   sortTable[0x769D]=9001;   // huang
   sortTable[0x76A9]=9002;   // huang
   sortTable[0x7A54]=9003;   // huang
   sortTable[0x7BCA]=9004;   // huang
   sortTable[0x7E28]=9005;   // huang
   sortTable[0x8841]=9006;   // huang
   sortTable[0x8AFB]=9007;   // huang
   sortTable[0x93A4]=9008;   // huang
   sortTable[0x4F1A]=9009;   // hui
   sortTable[0x6703]=9010;   // hui
   sortTable[0x56DE]=9011;   // hui
   sortTable[0x6325]=9012;   // hui
   sortTable[0x63EE]=9013;   // hui
   sortTable[0x7070]=9014;   // hui
   sortTable[0x6062]=9015;   // hui
   sortTable[0x8F89]=9016;   // hui
   sortTable[0x8F1D]=9017;   // hui
   sortTable[0x6BC1]=9018;   // hui
   sortTable[0x6BC0]=9019;   // hui
   sortTable[0x6C47]=9020;   // hui
   sortTable[0x532F]=9021;   // hui
   sortTable[0x6167]=9022;   // hui
   sortTable[0x6094]=9023;   // hui
   sortTable[0x7ED8]=9024;   // hui
   sortTable[0x7E6A]=9025;   // hui
   sortTable[0x60E0]=9026;   // hui
   sortTable[0x5FBD]=9027;   // hui
   sortTable[0x8BB3]=9028;   // hui
   sortTable[0x8D3F]=9029;   // hui
   sortTable[0x6666]=9030;   // hui
   sortTable[0x605A]=9031;   // hui
   sortTable[0x6656]=9032;   // hui
   sortTable[0x79FD]=9033;   // hui
   sortTable[0x9EBE]=9034;   // hui
   sortTable[0x8BF2]=9035;   // hui
   sortTable[0x8BD9]=9036;   // hui
   sortTable[0x8559]=9037;   // hui
   sortTable[0x5F57]=9038;   // hui
   sortTable[0x86D4]=9039;   // hui
   sortTable[0x5349]=9040;   // hui
   sortTable[0x5599]=9041;   // hui
   sortTable[0x87EA]=9042;   // hui
   sortTable[0x54B4]=9043;   // hui
   sortTable[0x867A]=9044;   // hui
   sortTable[0x835F]=9045;   // hui
   sortTable[0x96B3]=9046;   // hui
   sortTable[0x6D04]=9047;   // hui
   sortTable[0x7F0B]=9048;   // hui
   sortTable[0x70E9]=9049;   // hui
   sortTable[0x73F2]=9050;   // hui
   sortTable[0x7FDA]=9051;   // hui
   sortTable[0x7FD9]=9052;   // hui
   sortTable[0x6D4D]=9053;   // hui
   sortTable[0x8334]=9054;   // hui
   sortTable[0x54D5]=9055;   // hui
   sortTable[0x8886]=9056;   // hui
   sortTable[0x8B53]=9057;   // hui
   sortTable[0x9613]=9058;   // hui
   sortTable[0x8FF4]=9059;   // hui
   sortTable[0x8A6F]=9060;   // hui
   sortTable[0x7FEC]=9061;   // hui
   sortTable[0x7BF2]=9062;   // hui
   sortTable[0x8918]=9063;   // hui
   sortTable[0x8A7C]=9064;   // hui
   sortTable[0x7FFD]=9065;   // hui
   sortTable[0x8C57]=9066;   // hui
   sortTable[0x8698]=9067;   // hui
   sortTable[0x8589]=9068;   // hui
   sortTable[0x9892]=9069;   // hui
   sortTable[0x8633]=9070;   // hui
   sortTable[0x93F8]=9071;   // hui
   sortTable[0x9767]=9072;   // hui
   sortTable[0x986A]=9073;   // hui
   sortTable[0x942C]=9074;   // hui
   sortTable[0x95E0]=9075;   // hui
   sortTable[0x7773]=9076;   // hui
   sortTable[0x8588]=9077;   // hui
   sortTable[0x9BB0]=9078;   // hui
   sortTable[0x8AF1]=9079;   // hui
   sortTable[0x8CC4]=9080;   // hui
   sortTable[0x7988]=9081;   // hui
   sortTable[0x7A62]=9082;   // hui
   sortTable[0x8294]=9083;   // hui
   sortTable[0x8527]=9084;   // hui
   sortTable[0x8B7F]=9085;   // hui
   sortTable[0x4F6A]=9086;   // hui
   sortTable[0x50E1]=9087;   // hui
   sortTable[0x5136]=9088;   // hui
   sortTable[0x5612]=9089;   // hui
   sortTable[0x5645]=9090;   // hui
   sortTable[0x5655]=9091;   // hui
   sortTable[0x5666]=9092;   // hui
   sortTable[0x5696]=9093;   // hui
   sortTable[0x56D8]=9094;   // hui
   sortTable[0x56EC]=9095;   // hui
   sortTable[0x571A]=9096;   // hui
   sortTable[0x5A4E]=9097;   // hui
   sortTable[0x5A88]=9098;   // hui
   sortTable[0x5B12]=9099;   // hui
   sortTable[0x5B48]=9100;   // hui
   sortTable[0x5BED]=9101;   // hui
   sortTable[0x5C77]=9102;   // hui
   sortTable[0x5E51]=9103;   // hui
   sortTable[0x5EFB]=9104;   // hui
   sortTable[0x5EFD]=9105;   // hui
   sortTable[0x5F59]=9106;   // hui
   sortTable[0x5F5A]=9107;   // hui
   sortTable[0x5FBB]=9108;   // hui
   sortTable[0x605B]=9109;   // hui
   sortTable[0x6075]=9110;   // hui
   sortTable[0x6193]=9111;   // hui
   sortTable[0x61F3]=9112;   // hui
   sortTable[0x62FB]=9113;   // hui
   sortTable[0x649D]=9114;   // hui
   sortTable[0x6689]=9115;   // hui
   sortTable[0x66B3]=9116;   // hui
   sortTable[0x694E]=9117;   // hui
   sortTable[0x69E5]=9118;   // hui
   sortTable[0x6A5E]=9119;   // hui
   sortTable[0x6A93]=9120;   // hui
   sortTable[0x6AD8]=9121;   // hui
   sortTable[0x6BA8]=9122;   // hui
   sortTable[0x6BC7]=9123;   // hui
   sortTable[0x6CCB]=9124;   // hui
   sortTable[0x6D03]=9125;   // hui
   sortTable[0x6E4F]=9126;   // hui
   sortTable[0x6ED9]=9127;   // hui
   sortTable[0x6F53]=9128;   // hui
   sortTable[0x6FAE]=9129;   // hui
   sortTable[0x6FCA]=9130;   // hui
   sortTable[0x7008]=9131;   // hui
   sortTable[0x7073]=9132;   // hui
   sortTable[0x70E0]=9133;   // hui
   sortTable[0x70E3]=9134;   // hui
   sortTable[0x7147]=9135;   // hui
   sortTable[0x71EC]=9136;   // hui
   sortTable[0x71F4]=9137;   // hui
   sortTable[0x7369]=9138;   // hui
   sortTable[0x74A4]=9139;   // hui
   sortTable[0x74AF]=9140;   // hui
   sortTable[0x75D0]=9141;   // hui
   sortTable[0x7623]=9142;   // hui
   sortTable[0x77BA]=9143;   // hui
   sortTable[0x7D75]=9144;   // hui
   sortTable[0x7E62]=9145;   // hui
   sortTable[0x85F1]=9146;   // hui
   sortTable[0x86D5]=9147;   // hui
   sortTable[0x8716]=9148;   // hui
   sortTable[0x8AA8]=9149;   // hui
   sortTable[0x8B6D]=9150;   // hui
   sortTable[0x9025]=9151;   // hui
   sortTable[0x9693]=9152;   // hui
   sortTable[0x982E]=9153;   // hui
   sortTable[0x992F]=9154;   // hui
   sortTable[0x9C34]=9155;   // hui
   sortTable[0x6DF7]=9156;   // hun
   sortTable[0x660F]=9157;   // hun
   sortTable[0x6D51]=9158;   // hun
   sortTable[0x6E3E]=9159;   // hun
   sortTable[0x5A5A]=9160;   // hun
   sortTable[0x9B42]=9161;   // hun
   sortTable[0x8BE8]=9162;   // hun
   sortTable[0x8364]=9163;   // hun
   sortTable[0x960D]=9164;   // hun
   sortTable[0x9984]=9165;   // hun
   sortTable[0x6EB7]=9166;   // hun
   sortTable[0x8AE2]=9167;   // hun
   sortTable[0x8477]=9168;   // hun
   sortTable[0x9F32]=9169;   // hun
   sortTable[0x9BF6]=9170;   // hun
   sortTable[0x7E49]=9171;   // hun
   sortTable[0x8F4B]=9172;   // hun
   sortTable[0x7767]=9173;   // hun
   sortTable[0x95BD]=9174;   // hun
   sortTable[0x4FD2]=9175;   // hun
   sortTable[0x5031]=9176;   // hun
   sortTable[0x5702]=9177;   // hun
   sortTable[0x581A]=9178;   // hun
   sortTable[0x5FF6]=9179;   // hun
   sortTable[0x60DB]=9180;   // hun
   sortTable[0x6141]=9181;   // hun
   sortTable[0x638D]=9182;   // hun
   sortTable[0x662C]=9183;   // hun
   sortTable[0x68A1]=9184;   // hun
   sortTable[0x68D4]=9185;   // hun
   sortTable[0x6B99]=9186;   // hun
   sortTable[0x6DBD]=9187;   // hun
   sortTable[0x711D]=9188;   // hun
   sortTable[0x743F]=9189;   // hun
   sortTable[0x776F]=9190;   // hun
   sortTable[0x89E8]=9191;   // hun
   sortTable[0x991B]=9192;   // hun
   sortTable[0x6D3B]=9193;   // huo
   sortTable[0x6216]=9194;   // huo
   sortTable[0x706B]=9195;   // huo
   sortTable[0x4F19]=9196;   // huo
   sortTable[0x8D27]=9197;   // huo
   sortTable[0x8CA8]=9198;   // huo
   sortTable[0x83B7]=9199;   // huo
   sortTable[0x7372]=9200;   // huo
   sortTable[0x8C41]=9201;   // huo
   sortTable[0x7978]=9202;   // huo
   sortTable[0x798D]=9203;   // huo
   sortTable[0x60D1]=9204;   // huo
   sortTable[0x970D]=9205;   // huo
   sortTable[0x8816]=9206;   // huo
   sortTable[0x5925]=9207;   // huo
   sortTable[0x85FF]=9208;   // huo
   sortTable[0x7809]=9209;   // huo
   sortTable[0x956C]=9210;   // huo
   sortTable[0x952A]=9211;   // huo
   sortTable[0x56AF]=9212;   // huo
   sortTable[0x94AC]=9213;   // huo
   sortTable[0x5290]=9214;   // huo
   sortTable[0x8020]=9215;   // huo
   sortTable[0x6509]=9216;   // huo
   sortTable[0x81DB]=9217;   // huo
   sortTable[0x7A6B]=9218;   // huo
   sortTable[0x84A6]=9219;   // huo
   sortTable[0x9743]=9220;   // huo
   sortTable[0x9A1E]=9221;   // huo
   sortTable[0x77D0]=9222;   // huo
   sortTable[0x79F3]=9223;   // huo
   sortTable[0x77C6]=9224;   // huo
   sortTable[0x8267]=9225;   // huo
   sortTable[0x79EE]=9226;   // huo
   sortTable[0x944A]=9227;   // huo
   sortTable[0x4F78]=9228;   // huo
   sortTable[0x4FF0]=9229;   // huo
   sortTable[0x5268]=9230;   // huo
   sortTable[0x5419]=9231;   // huo
   sortTable[0x549F]=9232;   // huo
   sortTable[0x5684]=9233;   // huo
   sortTable[0x56BF]=9234;   // huo
   sortTable[0x596F]=9235;   // huo
   sortTable[0x6347]=9236;   // huo
   sortTable[0x639D]=9237;   // huo
   sortTable[0x65E4]=9238;   // huo
   sortTable[0x66E4]=9239;   // huo
   sortTable[0x6947]=9240;   // huo
   sortTable[0x6AB4]=9241;   // huo
   sortTable[0x6C8E]=9242;   // huo
   sortTable[0x6E71]=9243;   // huo
   sortTable[0x6F37]=9244;   // huo
   sortTable[0x6FE9]=9245;   // huo
   sortTable[0x7016]=9246;   // huo
   sortTable[0x7668]=9247;   // huo
   sortTable[0x7713]=9248;   // huo
   sortTable[0x802F]=9249;   // huo
   sortTable[0x8B0B]=9250;   // huo
   sortTable[0x90A9]=9251;   // huo
   sortTable[0x9225]=9252;   // huo
   sortTable[0x9343]=9253;   // huo
   sortTable[0x9584]=9254;   // huo
   sortTable[0x5DF1]=9984;   // ji
   sortTable[0x673A]=9985;   // ji
   sortTable[0x6A5F]=9986;   // ji
   sortTable[0x51E0]=9987;   // ji
   sortTable[0x5E7E]=9988;   // ji
   sortTable[0x7EA7]=9989;   // ji
   sortTable[0x7D1A]=9990;   // ji
   sortTable[0x8BA1]=9991;   // ji
   sortTable[0x8A08]=9992;   // ji
   sortTable[0x6D4E]=9993;   // ji
   sortTable[0x6FDF]=9994;   // ji
   sortTable[0x6781]=9995;   // ji
   sortTable[0x6975]=9996;   // ji
   sortTable[0x57FA]=9997;   // ji
   sortTable[0x8BB0]=9998;   // ji
   sortTable[0x8A18]=9999;   // ji
   sortTable[0x96C6]=10000;   // ji
   sortTable[0x53CA]=10001;   // ji
   sortTable[0x6280]=10002;   // ji
   sortTable[0x9645]=10003;   // ji
   sortTable[0x969B]=10004;   // ji
   sortTable[0x51FB]=10005;   // ji
   sortTable[0x64CA]=10006;   // ji
   sortTable[0x6025]=10007;   // ji
   sortTable[0x79EF]=10008;   // ji
   sortTable[0x7A4D]=10009;   // ji
   sortTable[0x5373]=10010;   // ji
   sortTable[0x7EAA]=10011;   // ji
   sortTable[0x7D00]=10012;   // ji
   sortTable[0x6FC0]=10013;   // ji
   sortTable[0x7EE7]=10014;   // ji
   sortTable[0x7E7C]=10015;   // ji
   sortTable[0x65E2]=10016;   // ji
   sortTable[0x9E21]=10017;   // ji
   sortTable[0x96DE]=10018;   // ji
   sortTable[0x5B63]=10019;   // ji
   sortTable[0x6324]=10020;   // ji
   sortTable[0x64E0]=10021;   // ji
   sortTable[0x7EE9]=10022;   // ji
   sortTable[0x7E3E]=10023;   // ji
   sortTable[0x5BC4]=10024;   // ji
   sortTable[0x8FF9]=10025;   // ji
   sortTable[0x8DE1]=10026;   // ji
   sortTable[0x5242]=10027;   // ji
   sortTable[0x5291]=10028;   // ji
   sortTable[0x5BC2]=10029;   // ji
   sortTable[0x75BE]=10030;   // ji
   sortTable[0x808C]=10031;   // ji
   sortTable[0x8F91]=10032;   // ji
   sortTable[0x8F2F]=10033;   // ji
   sortTable[0x810A]=10034;   // ji
   sortTable[0x573E]=10035;   // ji
   sortTable[0x9965]=10036;   // ji
   sortTable[0x98E2]=10037;   // ji
   sortTable[0x7C4D]=10038;   // ji
   sortTable[0x8BA5]=10039;   // ji
   sortTable[0x8B4F]=10040;   // ji
   sortTable[0x5409]=10041;   // ji
   sortTable[0x796D]=10042;   // ji
   sortTable[0x5FCC]=10043;   // ji
   sortTable[0x7A3D]=10044;   // ji
   sortTable[0x5180]=10045;   // ji
   sortTable[0x59EC]=10046;   // ji
   sortTable[0x7391]=10047;   // ji
   sortTable[0x7A37]=10048;   // ji
   sortTable[0x85C9]=10049;   // ji
   sortTable[0x5993]=10050;   // ji
   sortTable[0x8BD8]=10051;   // ji
   sortTable[0x6C72]=10052;   // ji
   sortTable[0x5AC9]=10053;   // ji
   sortTable[0x4E9F]=10054;   // ji
   sortTable[0x68D8]=10055;   // ji
   sortTable[0x757F]=10056;   // ji
   sortTable[0x7F81]=10057;   // ji
   sortTable[0x7F09]=10058;   // ji
   sortTable[0x621F]=10059;   // ji
   sortTable[0x8D4D]=10060;   // ji
   sortTable[0x4F0E]=10061;   // ji
   sortTable[0x84DF]=10062;   // ji
   sortTable[0x77F6]=10063;   // ji
   sortTable[0x5048]=10064;   // ji
   sortTable[0x66A8]=10065;   // ji
   sortTable[0x7B95]=10066;   // ji
   sortTable[0x8DFB]=10067;   // ji
   sortTable[0x53FD]=10068;   // ji
   sortTable[0x9AFB]=10069;   // ji
   sortTable[0x9AA5]=10070;   // ji
   sortTable[0x60B8]=10071;   // ji
   sortTable[0x7578]=10072;   // ji
   sortTable[0x54AD]=10073;   // ji
   sortTable[0x5527]=10074;   // ji
   sortTable[0x7B08]=10075;   // ji
   sortTable[0x7DDD]=10076;   // ji
   sortTable[0x7620]=10077;   // ji
   sortTable[0x9701]=10078;   // ji
   sortTable[0x696B]=10079;   // ji
   sortTable[0x4E69]=10080;   // ji
   sortTable[0x7B04]=10081;   // ji
   sortTable[0x89CA]=10082;   // ji
   sortTable[0x5D47]=10083;   // ji
   sortTable[0x5C8C]=10084;   // ji
   sortTable[0x6D0E]=10085;   // ji
   sortTable[0x58BC]=10086;   // ji
   sortTable[0x82A8]=10087;   // ji
   sortTable[0x82B0]=10088;   // ji
   sortTable[0x6222]=10089;   // ji
   sortTable[0x9F51]=10090;   // ji
   sortTable[0x866E]=10091;   // ji
   sortTable[0x8DFD]=10092;   // ji
   sortTable[0x9CAB]=10093;   // ji
   sortTable[0x5C50]=10094;   // ji
   sortTable[0x4F76]=10095;   // ji
   sortTable[0x638E]=10096;   // ji
   sortTable[0x7284]=10097;   // ji
   sortTable[0x6B9B]=10098;   // ji
   sortTable[0x9E82]=10099;   // ji
   sortTable[0x5D74]=10100;   // ji
   sortTable[0x84BA]=10101;   // ji
   sortTable[0x7F7D]=10102;   // ji
   sortTable[0x8360]=10103;   // ji
   sortTable[0x8024]=10104;   // ji
   sortTable[0x54DC]=10105;   // ji
   sortTable[0x8E50]=10106;   // ji
   sortTable[0x9C9A]=10107;   // ji
   sortTable[0x79A8]=10108;   // ji
   sortTable[0x525E]=10109;   // ji
   sortTable[0x9F4E]=10110;   // ji
   sortTable[0x8E16]=10111;   // ji
   sortTable[0x7D12]=10112;   // ji
   sortTable[0x7A44]=10113;   // ji
   sortTable[0x96AE]=10114;   // ji
   sortTable[0x857A]=10115;   // ji
   sortTable[0x9E61]=10116;   // ji
   sortTable[0x7F87]=10117;   // ji
   sortTable[0x9491]=10118;   // ji
   sortTable[0x7A4A]=10119;   // ji
   sortTable[0x830D]=10120;   // ji
   sortTable[0x8E5F]=10121;   // ji
   sortTable[0x8265]=10122;   // ji
   sortTable[0x8324]=10123;   // ji
   sortTable[0x9C7E]=10124;   // ji
   sortTable[0x7A18]=10125;   // ji
   sortTable[0x9951]=10126;   // ji
   sortTable[0x81EE]=10127;   // ji
   sortTable[0x8507]=10128;   // ji
   sortTable[0x8640]=10129;   // ji
   sortTable[0x89ED]=10130;   // ji
   sortTable[0x913F]=10131;   // ji
   sortTable[0x97BF]=10132;   // ji
   sortTable[0x97F2]=10133;   // ji
   sortTable[0x802D]=10134;   // ji
   sortTable[0x9BDA]=10135;   // ji
   sortTable[0x9DBA]=10136;   // ji
   sortTable[0x9353]=10137;   // ji
   sortTable[0x9C36]=10138;   // ji
   sortTable[0x9C40]=10139;   // ji
   sortTable[0x799D]=10140;   // ji
   sortTable[0x7A67]=10141;   // ji
   sortTable[0x7E4B]=10142;   // ji
   sortTable[0x860E]=10143;   // ji
   sortTable[0x8AC5]=10144;   // ji
   sortTable[0x8D8C]=10145;   // ji
   sortTable[0x9F4F]=10146;   // ji
   sortTable[0x7B53]=10147;   // ji
   sortTable[0x78EF]=10148;   // ji
   sortTable[0x7F88]=10149;   // ji
   sortTable[0x846A]=10150;   // ji
   sortTable[0x8540]=10151;   // ji
   sortTable[0x894B]=10152;   // ji
   sortTable[0x9288]=10153;   // ji
   sortTable[0x92A1]=10154;   // ji
   sortTable[0x9416]=10155;   // ji
   sortTable[0x9735]=10156;   // ji
   sortTable[0x9B62]=10157;   // ji
   sortTable[0x9C3F]=10158;   // ji
   sortTable[0x9D4B]=10159;   // ji
   sortTable[0x7A56]=10160;   // ji
   sortTable[0x7BBF]=10161;   // ji
   sortTable[0x862E]=10162;   // ji
   sortTable[0x878F]=10163;   // ji
   sortTable[0x8989]=10164;   // ji
   sortTable[0x898A]=10165;   // ji
   sortTable[0x89D9]=10166;   // ji
   sortTable[0x8C3B]=10167;   // ji
   sortTable[0x8CF7]=10168;   // ji
   sortTable[0x8F5A]=10169;   // ji
   sortTable[0x9218]=10170;   // ji
   sortTable[0x96E6]=10171;   // ji
   sortTable[0x9A65]=10172;   // ji
   sortTable[0x9D8F]=10173;   // ji
   sortTable[0x9DC4]=10174;   // ji
   sortTable[0x9DD1]=10175;   // ji
   sortTable[0x4E0C]=10176;   // ji
   sortTable[0x4E2E]=10177;   // ji
   sortTable[0x4EBC]=10178;   // ji
   sortTable[0x4EBD]=10179;   // ji
   sortTable[0x4F0B]=10180;   // ji
   sortTable[0x506E]=10181;   // ji
   sortTable[0x50DF]=10182;   // ji
   sortTable[0x517E]=10183;   // ji
   sortTable[0x5209]=10184;   // ji
   sortTable[0x520F]=10185;   // ji
   sortTable[0x5264]=10186;   // ji
   sortTable[0x52E3]=10187;   // ji
   sortTable[0x5359]=10188;   // ji
   sortTable[0x537D]=10189;   // ji
   sortTable[0x559E]=10190;   // ji
   sortTable[0x55D8]=10191;   // ji
   sortTable[0x5630]=10192;   // ji
   sortTable[0x568C]=10193;   // ji
   sortTable[0x5756]=10194;   // ji
   sortTable[0x578D]=10195;   // ji
   sortTable[0x5848]=10196;   // ji
   sortTable[0x5849]=10197;   // ji
   sortTable[0x5980]=10198;   // ji
   sortTable[0x59DE]=10199;   // ji
   sortTable[0x59EB]=10200;   // ji
   sortTable[0x5CDC]=10201;   // ji
   sortTable[0x5D46]=10202;   // ji
   sortTable[0x5DAF]=10203;   // ji
   sortTable[0x5EB4]=10204;   // ji
   sortTable[0x5EED]=10205;   // ji
   sortTable[0x5F50]=10206;   // ji
   sortTable[0x5F51]=10207;   // ji
   sortTable[0x5F76]=10208;   // ji
   sortTable[0x5F9B]=10209;   // ji
   sortTable[0x5FE3]=10210;   // ji
   sortTable[0x60CE]=10211;   // ji
   sortTable[0x6131]=10212;   // ji
   sortTable[0x61FB]=10213;   // ji
   sortTable[0x63E4]=10214;   // ji
   sortTable[0x6483]=10215;   // ji
   sortTable[0x64A0]=10216;   // ji
   sortTable[0x64EE]=10217;   // ji
   sortTable[0x6567]=10218;   // ji
   sortTable[0x65E1]=10219;   // ji
   sortTable[0x65E3]=10220;   // ji
   sortTable[0x66A9]=10221;   // ji
   sortTable[0x66C1]=10222;   // ji
   sortTable[0x671E]=10223;   // ji
   sortTable[0x6785]=10224;   // ji
   sortTable[0x689E]=10225;   // ji
   sortTable[0x69C9]=10226;   // ji
   sortTable[0x69E3]=10227;   // ji
   sortTable[0x6A2D]=10228;   // ji
   sortTable[0x6A76]=10229;   // ji
   sortTable[0x6A95]=10230;   // ji
   sortTable[0x6A9D]=10231;   // ji
   sortTable[0x6AB5]=10232;   // ji
   sortTable[0x6AC5]=10233;   // ji
   sortTable[0x6BC4]=10234;   // ji
   sortTable[0x6CF2]=10235;   // ji
   sortTable[0x6E08]=10236;   // ji
   sortTable[0x6E52]=10237;   // ji
   sortTable[0x6F03]=10238;   // ji
   sortTable[0x6F08]=10239;   // ji
   sortTable[0x6F57]=10240;   // ji
   sortTable[0x6FC8]=10241;   // ji
   sortTable[0x7031]=10242;   // ji
   sortTable[0x710F]=10243;   // ji
   sortTable[0x72B1]=10244;   // ji
   sortTable[0x72E4]=10245;   // ji
   sortTable[0x74A3]=10246;   // ji
   sortTable[0x75F5]=10247;   // ji
   sortTable[0x7660]=10248;   // ji
   sortTable[0x766A]=10249;   // ji
   sortTable[0x7680]=10250;   // ji
   sortTable[0x768D]=10251;   // ji
   sortTable[0x7A29]=10252;   // ji
   sortTable[0x7C0A]=10253;   // ji
   sortTable[0x7D99]=10254;   // ji
   sortTable[0x818C]=10255;   // ji
   sortTable[0x858A]=10256;   // ji
   sortTable[0x85BA]=10257;   // ji
   sortTable[0x863B]=10258;   // ji
   sortTable[0x87E3]=10259;   // ji
   sortTable[0x88DA]=10260;   // ji
   sortTable[0x8900]=10261;   // ji
   sortTable[0x8940]=10262;   // ji
   sortTable[0x89AC]=10263;   // ji
   sortTable[0x8A8B]=10264;   // ji
   sortTable[0x8B64]=10265;   // ji
   sortTable[0x8CEB]=10266;   // ji
   sortTable[0x8E8B]=10267;   // ji
   sortTable[0x8EB8]=10268;   // ji
   sortTable[0x90C6]=10269;   // ji
   sortTable[0x9324]=10270;   // ji
   sortTable[0x93F6]=10271;   // ji
   sortTable[0x9447]=10272;   // ji
   sortTable[0x9459]=10273;   // ji
   sortTable[0x96E7]=10274;   // ji
   sortTable[0x973D]=10275;   // ji
   sortTable[0x9B3E]=10276;   // ji
   sortTable[0x9B55]=10277;   // ji
   sortTable[0x9C6D]=10278;   // ji
   sortTable[0x9CEE]=10279;   // ji
   sortTable[0x9E04]=10280;   // ji
   sortTable[0x9F4C]=10281;   // ji
   sortTable[0x5BB6]=10282;   // jia
   sortTable[0x52A0]=10283;   // jia
   sortTable[0x4EF7]=10284;   // jia
   sortTable[0x50F9]=10285;   // jia
   sortTable[0x67B6]=10286;   // jia
   sortTable[0x5047]=10287;   // jia
   sortTable[0x7A3C]=10288;   // jia
   sortTable[0x5939]=10289;   // jia
   sortTable[0x593E]=10290;   // jia
   sortTable[0x7532]=10291;   // jia
   sortTable[0x9A7E]=10292;   // jia
   sortTable[0x99D5]=10293;   // jia
   sortTable[0x5AC1]=10294;   // jia
   sortTable[0x4F73]=10295;   // jia
   sortTable[0x988A]=10296;   // jia
   sortTable[0x8304]=10297;   // jia
   sortTable[0x9830]=10298;   // jia
   sortTable[0x8D3E]=10299;   // jia
   sortTable[0x5609]=10300;   // jia
   sortTable[0x8FE6]=10301;   // jia
   sortTable[0x4F3D]=10302;   // jia
   sortTable[0x67B7]=10303;   // jia
   sortTable[0x90CF]=10304;   // jia
   sortTable[0x835A]=10305;   // jia
   sortTable[0x8DCF]=10306;   // jia
   sortTable[0x80DB]=10307;   // jia
   sortTable[0x7B33]=10308;   // jia
   sortTable[0x5CAC]=10309;   // jia
   sortTable[0x88B7]=10310;   // jia
   sortTable[0x8888]=10311;   // jia
   sortTable[0x94BE]=10312;   // jia
   sortTable[0x846D]=10313;   // jia
   sortTable[0x6D43]=10314;   // jia
   sortTable[0x86F1]=10315;   // jia
   sortTable[0x621B]=10316;   // jia
   sortTable[0x75C2]=10317;   // jia
   sortTable[0x73C8]=10318;   // jia
   sortTable[0x605D]=10319;   // jia
   sortTable[0x9553]=10320;   // jia
   sortTable[0x94D7]=10321;   // jia
   sortTable[0x8C6D]=10322;   // jia
   sortTable[0x7615]=10323;   // jia
   sortTable[0x9240]=10324;   // jia
   sortTable[0x88CC]=10325;   // jia
   sortTable[0x9782]=10326;   // jia
   sortTable[0x9E9A]=10327;   // jia
   sortTable[0x8CC8]=10328;   // jia
   sortTable[0x86FA]=10329;   // jia
   sortTable[0x8DF2]=10330;   // jia
   sortTable[0x9D36]=10331;   // jia
   sortTable[0x9D4A]=10332;   // jia
   sortTable[0x8C91]=10333;   // jia
   sortTable[0x83A2]=10334;   // jia
   sortTable[0x90DF]=10335;   // jia
   sortTable[0x801E]=10336;   // jia
   sortTable[0x8175]=10337;   // jia
   sortTable[0x9904]=10338;   // jia
   sortTable[0x4E6B]=10339;   // jia
   sortTable[0x4EEE]=10340;   // jia
   sortTable[0x50A2]=10341;   // jia
   sortTable[0x53DA]=10342;   // jia
   sortTable[0x550A]=10343;   // jia
   sortTable[0x55E7]=10344;   // jia
   sortTable[0x573F]=10345;   // jia
   sortTable[0x57C9]=10346;   // jia
   sortTable[0x5A7D]=10347;   // jia
   sortTable[0x5E4F]=10348;   // jia
   sortTable[0x5FA6]=10349;   // jia
   sortTable[0x5FE6]=10350;   // jia
   sortTable[0x621E]=10351;   // jia
   sortTable[0x6274]=10352;   // jia
   sortTable[0x62B8]=10353;   // jia
   sortTable[0x62C1]=10354;   // jia
   sortTable[0x659A]=10355;   // jia
   sortTable[0x659D]=10356;   // jia
   sortTable[0x689C]=10357;   // jia
   sortTable[0x6935]=10358;   // jia
   sortTable[0x698E]=10359;   // jia
   sortTable[0x69A2]=10360;   // jia
   sortTable[0x69DA]=10361;   // jia
   sortTable[0x6A9F]=10362;   // jia
   sortTable[0x6BE0]=10363;   // jia
   sortTable[0x6CC7]=10364;   // jia
   sortTable[0x6D79]=10365;   // jia
   sortTable[0x728C]=10366;   // jia
   sortTable[0x7333]=10367;   // jia
   sortTable[0x73BE]=10368;   // jia
   sortTable[0x7CD8]=10369;   // jia
   sortTable[0x926B]=10370;   // jia
   sortTable[0x927F]=10371;   // jia
   sortTable[0x92CF]=10372;   // jia
   sortTable[0x93B5]=10373;   // jia
   sortTable[0x982C]=10374;   // jia
   sortTable[0x89C1]=10375;   // jian
   sortTable[0x898B]=10376;   // jian
   sortTable[0x95F4]=10377;   // jian
   sortTable[0x9593]=10378;   // jian
   sortTable[0x5EFA]=10379;   // jian
   sortTable[0x4EF6]=10380;   // jian
   sortTable[0x575A]=10381;   // jian
   sortTable[0x5805]=10382;   // jian
   sortTable[0x6E10]=10383;   // jian
   sortTable[0x6F38]=10384;   // jian
   sortTable[0x7B80]=10385;   // jian
   sortTable[0x7C21]=10386;   // jian
   sortTable[0x68C0]=10387;   // jian
   sortTable[0x6AA2]=10388;   // jian
   sortTable[0x8DF5]=10389;   // jian
   sortTable[0x8E10]=10390;   // jian
   sortTable[0x51CF]=10391;   // jian
   sortTable[0x6E1B]=10392;   // jian
   sortTable[0x8270]=10393;   // jian
   sortTable[0x8271]=10394;   // jian
   sortTable[0x80A9]=10395;   // jian
   sortTable[0x5C16]=10396;   // jian
   sortTable[0x5065]=10397;   // jian
   sortTable[0x76D1]=10398;   // jian
   sortTable[0x76E3]=10399;   // jian
   sortTable[0x6B7C]=10400;   // jian
   sortTable[0x6BB2]=10401;   // jian
   sortTable[0x7BAD]=10402;   // jian
   sortTable[0x62E3]=10403;   // jian
   sortTable[0x63C0]=10404;   // jian
   sortTable[0x5251]=10405;   // jian
   sortTable[0x528D]=10406;   // jian
   sortTable[0x952E]=10407;   // jian
   sortTable[0x9375]=10408;   // jian
   sortTable[0x517C]=10409;   // jian
   sortTable[0x526A]=10410;   // jian
   sortTable[0x9274]=10411;   // jian
   sortTable[0x9452]=10412;   // jian
   sortTable[0x78B1]=10413;   // jian
   sortTable[0x9E7C]=10414;   // jian
   sortTable[0x8D31]=10415;   // jian
   sortTable[0x8CE4]=10416;   // jian
   sortTable[0x6361]=10417;   // jian
   sortTable[0x64BF]=10418;   // jian
   sortTable[0x6E85]=10419;   // jian
   sortTable[0x6FFA]=10420;   // jian
   sortTable[0x714E]=10421;   // jian
   sortTable[0x8230]=10422;   // jian
   sortTable[0x8266]=10423;   // jian
   sortTable[0x5978]=10424;   // jian
   sortTable[0x8350]=10425;   // jian
   sortTable[0x8327]=10426;   // jian
   sortTable[0x7E6D]=10427;   // jian
   sortTable[0x4FED]=10428;   // jian
   sortTable[0x5109]=10429;   // jian
   sortTable[0x8C0F]=10430;   // jian
   sortTable[0x7F04]=10431;   // jian
   sortTable[0x50ED]=10432;   // jian
   sortTable[0x7B3A]=10433;   // jian
   sortTable[0x67EC]=10434;   // jian
   sortTable[0x6DA7]=10435;   // jian
   sortTable[0x996F]=10436;   // jian
   sortTable[0x8E47]=10437;   // jian
   sortTable[0x7FE6]=10438;   // jian
   sortTable[0x622C]=10439;   // jian
   sortTable[0x950F]=10440;   // jian
   sortTable[0x97AF]=10441;   // jian
   sortTable[0x7B15]=10442;   // jian
   sortTable[0x7F23]=10443;   // jian
   sortTable[0x8B07]=10444;   // jian
   sortTable[0x7751]=10445;   // jian
   sortTable[0x728D]=10446;   // jian
   sortTable[0x6E54]=10447;   // jian
   sortTable[0x83C5]=10448;   // jian
   sortTable[0x88E5]=10449;   // jian
   sortTable[0x9E63]=10450;   // jian
   sortTable[0x8DBC]=10451;   // jian
   sortTable[0x97AC]=10452;   // jian
   sortTable[0x8171]=10453;   // jian
   sortTable[0x7877]=10454;   // jian
   sortTable[0x84B9]=10455;   // jian
   sortTable[0x7BEF]=10456;   // jian
   sortTable[0x8C2B]=10457;   // jian
   sortTable[0x620B]=10458;   // jian
   sortTable[0x6957]=10459;   // jian
   sortTable[0x67A7]=10460;   // jian
   sortTable[0x56DD]=10461;   // jian
   sortTable[0x6BFD]=10462;   // jian
   sortTable[0x8AD3]=10463;   // jian
   sortTable[0x9451]=10464;   // jian
   sortTable[0x77B7]=10465;   // jian
   sortTable[0x9CA3]=10466;   // jian
   sortTable[0x641B]=10467;   // jian
   sortTable[0x81F6]=10468;   // jian
   sortTable[0x89B8]=10469;   // jian
   sortTable[0x78F5]=10470;   // jian
   sortTable[0x7C5B]=10471;   // jian
   sortTable[0x844C]=10472;   // jian
   sortTable[0x9D73]=10473;   // jian
   sortTable[0x8573]=10474;   // jian
   sortTable[0x8F5E]=10475;   // jian
   sortTable[0x8E3A]=10476;   // jian
   sortTable[0x77BC]=10477;   // jian
   sortTable[0x7E5D]=10478;   // jian
   sortTable[0x9473]=10479;   // jian
   sortTable[0x9B0B]=10480;   // jian
   sortTable[0x9CD2]=10481;   // jian
   sortTable[0x791B]=10482;   // jian
   sortTable[0x852A]=10483;   // jian
   sortTable[0x8A43]=10484;   // jian
   sortTable[0x9C39]=10485;   // jian
   sortTable[0x9E89]=10486;   // jian
   sortTable[0x7906]=10487;   // jian
   sortTable[0x92FB]=10488;   // jian
   sortTable[0x9417]=10489;   // jian
   sortTable[0x9E7B]=10490;   // jian
   sortTable[0x726E]=10491;   // jian
   sortTable[0x7900]=10492;   // jian
   sortTable[0x7DD8]=10493;   // jian
   sortTable[0x85A6]=10494;   // jian
   sortTable[0x8643]=10495;   // jian
   sortTable[0x8B2D]=10496;   // jian
   sortTable[0x9427]=10497;   // jian
   sortTable[0x946C]=10498;   // jian
   sortTable[0x7B8B]=10499;   // jian
   sortTable[0x83FA]=10500;   // jian
   sortTable[0x8465]=10501;   // jian
   sortTable[0x85C6]=10502;   // jian
   sortTable[0x8812]=10503;   // jian
   sortTable[0x88B8]=10504;   // jian
   sortTable[0x8C5C]=10505;   // jian
   sortTable[0x9930]=10506;   // jian
   sortTable[0x7B67]=10507;   // jian
   sortTable[0x8947]=10508;   // jian
   sortTable[0x897A]=10509;   // jian
   sortTable[0x89B5]=10510;   // jian
   sortTable[0x8D9D]=10511;   // jian
   sortTable[0x9373]=10512;   // jian
   sortTable[0x9CFD]=10513;   // jian
   sortTable[0x4FF4]=10514;   // jian
   sortTable[0x5039]=10515;   // jian
   sortTable[0x5042]=10516;   // jian
   sortTable[0x51BF]=10517;   // jian
   sortTable[0x5263]=10518;   // jian
   sortTable[0x5271]=10519;   // jian
   sortTable[0x528E]=10520;   // jian
   sortTable[0x5292]=10521;   // jian
   sortTable[0x5294]=10522;   // jian
   sortTable[0x5297]=10523;   // jian
   sortTable[0x56CF]=10524;   // jian
   sortTable[0x583F]=10525;   // jian
   sortTable[0x58B9]=10526;   // jian
   sortTable[0x59E6]=10527;   // jian
   sortTable[0x59E7]=10528;   // jian
   sortTable[0x5BCB]=10529;   // jian
   sortTable[0x5E75]=10530;   // jian
   sortTable[0x5F3F]=10531;   // jian
   sortTable[0x5F45]=10532;   // jian
   sortTable[0x5FA4]=10533;   // jian
   sortTable[0x60E4]=10534;   // jian
   sortTable[0x6214]=10535;   // jian
   sortTable[0x6229]=10536;   // jian
   sortTable[0x6338]=10537;   // jian
   sortTable[0x63C3]=10538;   // jian
   sortTable[0x64F6]=10539;   // jian
   sortTable[0x65D4]=10540;   // jian
   sortTable[0x6695]=10541;   // jian
   sortTable[0x682B]=10542;   // jian
   sortTable[0x6898]=10543;   // jian
   sortTable[0x691C]=10544;   // jian
   sortTable[0x6937]=10545;   // jian
   sortTable[0x693E]=10546;   // jian
   sortTable[0x6997]=10547;   // jian
   sortTable[0x6A2B]=10548;   // jian
   sortTable[0x6A7A]=10549;   // jian
   sortTable[0x6AFC]=10550;   // jian
   sortTable[0x6BB1]=10551;   // jian
   sortTable[0x6D0A]=10552;   // jian
   sortTable[0x6E55]=10553;   // jian
   sortTable[0x6F97]=10554;   // jian
   sortTable[0x7010]=10555;   // jian
   sortTable[0x7033]=10556;   // jian
   sortTable[0x7038]=10557;   // jian
   sortTable[0x703D]=10558;   // jian
   sortTable[0x719E]=10559;   // jian
   sortTable[0x71B8]=10560;   // jian
   sortTable[0x724B]=10561;   // jian
   sortTable[0x730F]=10562;   // jian
   sortTable[0x73AA]=10563;   // jian
   sortTable[0x73D4]=10564;   // jian
   sortTable[0x744A]=10565;   // jian
   sortTable[0x7450]=10566;   // jian
   sortTable[0x7777]=10567;   // jian
   sortTable[0x788A]=10568;   // jian
   sortTable[0x7CCB]=10569;   // jian
   sortTable[0x7D78]=10570;   // jian
   sortTable[0x7E11]=10571;   // jian
   sortTable[0x8551]=10572;   // jian
   sortTable[0x87B9]=10573;   // jian
   sortTable[0x8949]=10574;   // jian
   sortTable[0x8AEB]=10575;   // jian
   sortTable[0x8B7C]=10576;   // jian
   sortTable[0x8B7E]=10577;   // jian
   sortTable[0x8C63]=10578;   // jian
   sortTable[0x8CCE]=10579;   // jian
   sortTable[0x91FC]=10580;   // jian
   sortTable[0x93E9]=10581;   // jian
   sortTable[0x9431]=10582;   // jian
   sortTable[0x946F]=10583;   // jian
   sortTable[0x97C0]=10584;   // jian
   sortTable[0x97C9]=10585;   // jian
   sortTable[0x991E]=10586;   // jian
   sortTable[0x99A2]=10587;   // jian
   sortTable[0x9C0E]=10588;   // jian
   sortTable[0x9DBC]=10589;   // jian
   sortTable[0x9E78]=10590;   // jian
   sortTable[0x5C06]=10591;   // jiang
   sortTable[0x5C07]=10592;   // jiang
   sortTable[0x8BB2]=10593;   // jiang
   sortTable[0x8B1B]=10594;   // jiang
   sortTable[0x6C5F]=10595;   // jiang
   sortTable[0x964D]=10596;   // jiang
   sortTable[0x5320]=10597;   // jiang
   sortTable[0x5956]=10598;   // jiang
   sortTable[0x734E]=10599;   // jiang
   sortTable[0x9171]=10600;   // jiang
   sortTable[0x91AC]=10601;   // jiang
   sortTable[0x50F5]=10602;   // jiang
   sortTable[0x6D46]=10603;   // jiang
   sortTable[0x7F30]=10604;   // jiang
   sortTable[0x97C1]=10605;   // jiang
   sortTable[0x6F3F]=10606;   // jiang
   sortTable[0x6868]=10607;   // jiang
   sortTable[0x69F3]=10608;   // jiang
   sortTable[0x7586]=10609;   // jiang
   sortTable[0x59DC]=10610;   // jiang
   sortTable[0x848B]=10611;   // jiang
   sortTable[0x7EDB]=10612;   // jiang
   sortTable[0x729F]=10613;   // jiang
   sortTable[0x8C47]=10614;   // jiang
   sortTable[0x7CE8]=10615;   // jiang
   sortTable[0x6D1A]=10616;   // jiang
   sortTable[0x7913]=10617;   // jiang
   sortTable[0x8591]=10618;   // jiang
   sortTable[0x8029]=10619;   // jiang
   sortTable[0x9CC9]=10620;   // jiang
   sortTable[0x8780]=10621;   // jiang
   sortTable[0x8523]=10622;   // jiang
   sortTable[0x8333]=10623;   // jiang
   sortTable[0x8B3D]=10624;   // jiang
   sortTable[0x985C]=10625;   // jiang
   sortTable[0x9C42]=10626;   // jiang
   sortTable[0x7D73]=10627;   // jiang
   sortTable[0x7FDE]=10628;   // jiang
   sortTable[0x508B]=10629;   // jiang
   sortTable[0x52E5]=10630;   // jiang
   sortTable[0x531E]=10631;   // jiang
   sortTable[0x58C3]=10632;   // jiang
   sortTable[0x5905]=10633;   // jiang
   sortTable[0x5968]=10634;   // jiang
   sortTable[0x596C]=10635;   // jiang
   sortTable[0x5D79]=10636;   // jiang
   sortTable[0x5F1C]=10637;   // jiang
   sortTable[0x5F36]=10638;   // jiang
   sortTable[0x5F4A]=10639;   // jiang
   sortTable[0x646A]=10640;   // jiang
   sortTable[0x647E]=10641;   // jiang
   sortTable[0x6762]=10642;   // jiang
   sortTable[0x6A7F]=10643;   // jiang
   sortTable[0x6AE4]=10644;   // jiang
   sortTable[0x6BAD]=10645;   // jiang
   sortTable[0x6EF0]=10646;   // jiang
   sortTable[0x7555]=10647;   // jiang
   sortTable[0x757A]=10648;   // jiang
   sortTable[0x7585]=10649;   // jiang
   sortTable[0x7CE1]=10650;   // jiang
   sortTable[0x7E6E]=10651;   // jiang
   sortTable[0x8199]=10652;   // jiang
   sortTable[0x8441]=10653;   // jiang
   sortTable[0x87BF]=10654;   // jiang
   sortTable[0x88B6]=10655;   // jiang
   sortTable[0x91A4]=10656;   // jiang
   sortTable[0x53EB]=10657;   // jiao
   sortTable[0x6559]=10658;   // jiao
   sortTable[0x8F83]=10659;   // jiao
   sortTable[0x8F03]=10660;   // jiao
   sortTable[0x4EA4]=10661;   // jiao
   sortTable[0x811A]=10662;   // jiao
   sortTable[0x8173]=10663;   // jiao
   sortTable[0x89D2]=10664;   // jiao
   sortTable[0x7126]=10665;   // jiao
   sortTable[0x9A84]=10666;   // jiao
   sortTable[0x9A55]=10667;   // jiao
   sortTable[0x6D47]=10668;   // jiao
   sortTable[0x6F86]=10669;   // jiao
   sortTable[0x6405]=10670;   // jiao
   sortTable[0x652A]=10671;   // jiao
   sortTable[0x80F6]=10672;   // jiao
   sortTable[0x81A0]=10673;   // jiao
   sortTable[0x8F7F]=10674;   // jiao
   sortTable[0x8F4E]=10675;   // jiao
   sortTable[0x90CA]=10676;   // jiao
   sortTable[0x527F]=10677;   // jiao
   sortTable[0x72E1]=10678;   // jiao
   sortTable[0x7F34]=10679;   // jiao
   sortTable[0x7E73]=10680;   // jiao
   sortTable[0x8549]=10681;   // jiao
   sortTable[0x5A07]=10682;   // jiao
   sortTable[0x6912]=10683;   // jiao
   sortTable[0x7A96]=10684;   // jiao
   sortTable[0x5B0C]=10685;   // jiao
   sortTable[0x997A]=10686;   // jiao
   sortTable[0x9903]=10687;   // jiao
   sortTable[0x9175]=10688;   // jiao
   sortTable[0x77EB]=10689;   // jiao
   sortTable[0x7EDE]=10690;   // jiao
   sortTable[0x86DF]=10691;   // jiao
   sortTable[0x7901]=10692;   // jiao
   sortTable[0x4FA5]=10693;   // jiao
   sortTable[0x91AE]=10694;   // jiao
   sortTable[0x768E]=10695;   // jiao
   sortTable[0x5CE4]=10696;   // jiao
   sortTable[0x8DE4]=10697;   // jiao
   sortTable[0x6E6B]=10698;   // jiao
   sortTable[0x5FBC]=10699;   // jiao
   sortTable[0x94F0]=10700;   // jiao
   sortTable[0x4F7C]=10701;   // jiao
   sortTable[0x9E6A]=10702;   // jiao
   sortTable[0x50EC]=10703;   // jiao
   sortTable[0x656B]=10704;   // jiao
   sortTable[0x59E3]=10705;   // jiao
   sortTable[0x827D]=10706;   // jiao
   sortTable[0x9C9B]=10707;   // jiao
   sortTable[0x832D]=10708;   // jiao
   sortTable[0x564D]=10709;   // jiao
   sortTable[0x6322]=10710;   // jiao
   sortTable[0x87DC]=10711;   // jiao
   sortTable[0x91C2]=10712;   // jiao
   sortTable[0x77EF]=10713;   // jiao
   sortTable[0x87ED]=10714;   // jiao
   sortTable[0x7A8C]=10715;   // jiao
   sortTable[0x9DEE]=10716;   // jiao
   sortTable[0x96A6]=10717;   // jiao
   sortTable[0x9D41]=10718;   // jiao
   sortTable[0x8F47]=10719;   // jiao
   sortTable[0x81B2]=10720;   // jiao
   sortTable[0x7C25]=10721;   // jiao
   sortTable[0x85E0]=10722;   // jiao
   sortTable[0x8DAD]=10723;   // jiao
   sortTable[0x8A06]=10724;   // jiao
   sortTable[0x940E]=10725;   // jiao
   sortTable[0x9DE6]=10726;   // jiao
   sortTable[0x7A5A]=10727;   // jiao
   sortTable[0x7D5E]=10728;   // jiao
   sortTable[0x8B65]=10729;   // jiao
   sortTable[0x9D64]=10730;   // jiao
   sortTable[0x8B51]=10731;   // jiao
   sortTable[0x50E5]=10732;   // jiao
   sortTable[0x510C]=10733;   // jiao
   sortTable[0x528B]=10734;   // jiao
   sortTable[0x544C]=10735;   // jiao
   sortTable[0x5602]=10736;   // jiao
   sortTable[0x5604]=10737;   // jiao
   sortTable[0x5626]=10738;   // jiao
   sortTable[0x566D]=10739;   // jiao
   sortTable[0x5B13]=10740;   // jiao
   sortTable[0x5B42]=10741;   // jiao
   sortTable[0x5CE7]=10742;   // jiao
   sortTable[0x5D95]=10743;   // jiao
   sortTable[0x5DA0]=10744;   // jiao
   sortTable[0x5DA3]=10745;   // jiao
   sortTable[0x5FBA]=10746;   // jiao
   sortTable[0x6054]=10747;   // jiao
   sortTable[0x618D]=10748;   // jiao
   sortTable[0x61BF]=10749;   // jiao
   sortTable[0x630D]=10750;   // jiao
   sortTable[0x6341]=10751;   // jiao
   sortTable[0x6477]=10752;   // jiao
   sortTable[0x649F]=10753;   // jiao
   sortTable[0x64B9]=10754;   // jiao
   sortTable[0x654E]=10755;   // jiao
   sortTable[0x657D]=10756;   // jiao
   sortTable[0x657F]=10757;   // jiao
   sortTable[0x65A0]=10758;   // jiao
   sortTable[0x6648]=10759;   // jiao
   sortTable[0x669E]=10760;   // jiao
   sortTable[0x66D2]=10761;   // jiao
   sortTable[0x6AF5]=10762;   // jiao
   sortTable[0x6E6C]=10763;   // jiao
   sortTable[0x6ED8]=10764;   // jiao
   sortTable[0x6F16]=10765;   // jiao
   sortTable[0x6F50]=10766;   // jiao
   sortTable[0x705A]=10767;   // jiao
   sortTable[0x70C4]=10768;   // jiao
   sortTable[0x714D]=10769;   // jiao
   sortTable[0x71CB]=10770;   // jiao
   sortTable[0x71DE]=10771;   // jiao
   sortTable[0x7365]=10772;   // jiao
   sortTable[0x73D3]=10773;   // jiao
   sortTable[0x74AC]=10774;   // jiao
   sortTable[0x76A6]=10775;   // jiao
   sortTable[0x76AD]=10776;   // jiao
   sortTable[0x7E90]=10777;   // jiao
   sortTable[0x81EB]=10778;   // jiao
   sortTable[0x8281]=10779;   // jiao
   sortTable[0x832E]=10780;   // jiao
   sortTable[0x8660]=10781;   // jiao
   sortTable[0x8CCB]=10782;   // jiao
   sortTable[0x8E0B]=10783;   // jiao
   sortTable[0x9278]=10784;   // jiao
   sortTable[0x9BAB]=10785;   // jiao
   sortTable[0x9C4E]=10786;   // jiao
   sortTable[0x9DCD]=10787;   // jiao
   sortTable[0x9636]=10788;   // jie
   sortTable[0x968E]=10789;   // jie
   sortTable[0x89E3]=10790;   // jie
   sortTable[0x7ED3]=10791;   // jie
   sortTable[0x7D50]=10792;   // jie
   sortTable[0x754C]=10793;   // jie
   sortTable[0x63A5]=10794;   // jie
   sortTable[0x8282]=10795;   // jie
   sortTable[0x7BC0]=10796;   // jie
   sortTable[0x8857]=10797;   // jie
   sortTable[0x59D0]=10798;   // jie
   sortTable[0x501F]=10799;   // jie
   sortTable[0x4ECB]=10800;   // jie
   sortTable[0x63ED]=10801;   // jie
   sortTable[0x6D01]=10802;   // jie
   sortTable[0x6F54]=10803;   // jie
   sortTable[0x5C4A]=10804;   // jie
   sortTable[0x5C46]=10805;   // jie
   sortTable[0x622A]=10806;   // jie
   sortTable[0x6212]=10807;   // jie
   sortTable[0x7AED]=10808;   // jie
   sortTable[0x6770]=10809;   // jie
   sortTable[0x6377]=10810;   // jie
   sortTable[0x776B]=10811;   // jie
   sortTable[0x7686]=10812;   // jie
   sortTable[0x8BEB]=10813;   // jie
   sortTable[0x8AA1]=10814;   // jie
   sortTable[0x52AB]=10815;   // jie
   sortTable[0x55DF]=10816;   // jie
   sortTable[0x9889]=10817;   // jie
   sortTable[0x79F8]=10818;   // jie
   sortTable[0x6840]=10819;   // jie
   sortTable[0x62EE]=10820;   // jie
   sortTable[0x5A55]=10821;   // jie
   sortTable[0x7FAF]=10822;   // jie
   sortTable[0x82A5]=10823;   // jie
   sortTable[0x86A7]=10824;   // jie
   sortTable[0x8BA6]=10825;   // jie
   sortTable[0x78A3]=10826;   // jie
   sortTable[0x5B51]=10827;   // jie
   sortTable[0x9AB1]=10828;   // jie
   sortTable[0x7D5C]=10829;   // jie
   sortTable[0x75A5]=10830;   // jie
   sortTable[0x5588]=10831;   // jie
   sortTable[0x7596]=10832;   // jie
   sortTable[0x9C92]=10833;   // jie
   sortTable[0x813B]=10834;   // jie
   sortTable[0x7A2D]=10835;   // jie
   sortTable[0x8A70]=10836;   // jie
   sortTable[0x84F5]=10837;   // jie
   sortTable[0x892F]=10838;   // jie
   sortTable[0x874D]=10839;   // jie
   sortTable[0x98F7]=10840;   // jie
   sortTable[0x86F6]=10841;   // jie
   sortTable[0x8710]=10842;   // jie
   sortTable[0x881E]=10843;   // jie
   sortTable[0x8871]=10844;   // jie
   sortTable[0x978A]=10845;   // jie
   sortTable[0x9B6A]=10846;   // jie
   sortTable[0x780E]=10847;   // jie
   sortTable[0x83E8]=10848;   // jie
   sortTable[0x9B9A]=10849;   // jie
   sortTable[0x9D9B]=10850;   // jie
   sortTable[0x88BA]=10851;   // jie
   sortTable[0x8A10]=10852;   // jie
   sortTable[0x8B2F]=10853;   // jie
   sortTable[0x8E15]=10854;   // jie
   sortTable[0x8FFC]=10855;   // jie
   sortTable[0x9B5D]=10856;   // jie
   sortTable[0x8878]=10857;   // jie
   sortTable[0x4E2F]=10858;   // jie
   sortTable[0x5022]=10859;   // jie
   sortTable[0x507C]=10860;   // jie
   sortTable[0x5091]=10861;   // jie
   sortTable[0x5226]=10862;   // jie
   sortTable[0x5227]=10863;   // jie
   sortTable[0x523C]=10864;   // jie
   sortTable[0x52BC]=10865;   // jie
   sortTable[0x5369]=10866;   // jie
   sortTable[0x536A]=10867;   // jie
   sortTable[0x5424]=10868;   // jie
   sortTable[0x55BC]=10869;   // jie
   sortTable[0x5826]=10870;   // jie
   sortTable[0x583A]=10871;   // jie
   sortTable[0x5A8E]=10872;   // jie
   sortTable[0x5A98]=10873;   // jie
   sortTable[0x5AC5]=10874;   // jie
   sortTable[0x5C10]=10875;   // jie
   sortTable[0x5C8A]=10876;   // jie
   sortTable[0x5C95]=10877;   // jie
   sortTable[0x5D28]=10878;   // jie
   sortTable[0x5D65]=10879;   // jie
   sortTable[0x5DC0]=10880;   // jie
   sortTable[0x5E6F]=10881;   // jie
   sortTable[0x5E8E]=10882;   // jie
   sortTable[0x5FA3]=10883;   // jie
   sortTable[0x6088]=10884;   // jie
   sortTable[0x63B2]=10885;   // jie
   sortTable[0x64D1]=10886;   // jie
   sortTable[0x6605]=10887;   // jie
   sortTable[0x685D]=10888;   // jie
   sortTable[0x6904]=10889;   // jie
   sortTable[0x6950]=10890;   // jie
   sortTable[0x696C]=10891;   // jie
   sortTable[0x6976]=10892;   // jie
   sortTable[0x69A4]=10893;   // jie
   sortTable[0x6A9E]=10894;   // jie
   sortTable[0x6AED]=10895;   // jie
   sortTable[0x6BD1]=10896;   // jie
   sortTable[0x6E5D]=10897;   // jie
   sortTable[0x6ED0]=10898;   // jie
   sortTable[0x716F]=10899;   // jie
   sortTable[0x7297]=10900;   // jie
   sortTable[0x73A0]=10901;   // jie
   sortTable[0x743E]=10902;   // jie
   sortTable[0x754D]=10903;   // jie
   sortTable[0x758C]=10904;   // jie
   sortTable[0x75CE]=10905;   // jie
   sortTable[0x7664]=10906;   // jie
   sortTable[0x83AD]=10907;   // jie
   sortTable[0x8754]=10908;   // jie
   sortTable[0x8818]=10909;   // jie
   sortTable[0x883D]=10910;   // jie
   sortTable[0x89E7]=10911;   // jie
   sortTable[0x8AB1]=10912;   // jie
   sortTable[0x8EA4]=10913;   // jie
   sortTable[0x9263]=10914;   // jie
   sortTable[0x937B]=10915;   // jie
   sortTable[0x9385]=10916;   // jie
   sortTable[0x8FDB]=10917;   // jin
   sortTable[0x9032]=10918;   // jin
   sortTable[0x4ECA]=10919;   // jin
   sortTable[0x7D27]=10920;   // jin
   sortTable[0x7DCA]=10921;   // jin
   sortTable[0x8FD1]=10922;   // jin
   sortTable[0x91D1]=10923;   // jin
   sortTable[0x4EC5]=10924;   // jin
   sortTable[0x50C5]=10925;   // jin
   sortTable[0x65A4]=10926;   // jin
   sortTable[0x52B2]=10927;   // jin
   sortTable[0x52C1]=10928;   // jin
   sortTable[0x5C3D]=10929;   // jin
   sortTable[0x76E1]=10930;   // jin
   sortTable[0x5DFE]=10931;   // jin
   sortTable[0x7981]=10932;   // jin
   sortTable[0x7B4B]=10933;   // jin
   sortTable[0x6D78]=10934;   // jin
   sortTable[0x9526]=10935;   // jin
   sortTable[0x9326]=10936;   // jin
   sortTable[0x6D25]=10937;   // jin
   sortTable[0x8C28]=10938;   // jin
   sortTable[0x8B39]=10939;   // jin
   sortTable[0x895F]=10940;   // jin
   sortTable[0x664B]=10941;   // jin
   sortTable[0x8369]=10942;   // jin
   sortTable[0x77DC]=10943;   // jin
   sortTable[0x747E]=10944;   // jin
   sortTable[0x89D0]=10945;   // jin
   sortTable[0x7F19]=10946;   // jin
   sortTable[0x5997]=10947;   // jin
   sortTable[0x70EC]=10948;   // jin
   sortTable[0x9991]=10949;   // jin
   sortTable[0x9773]=10950;   // jin
   sortTable[0x887F]=10951;   // jin
   sortTable[0x9485]=10952;   // jin
   sortTable[0x5664]=10953;   // jin
   sortTable[0x5807]=10954;   // jin
   sortTable[0x69FF]=10955;   // jin
   sortTable[0x537A]=10956;   // jin
   sortTable[0x8D46]=10957;   // jin
   sortTable[0x7972]=10958;   // jin
   sortTable[0x5ED1]=10959;   // jin
   sortTable[0x89D4]=10960;   // jin
   sortTable[0x7D1F]=10961;   // jin
   sortTable[0x83EB]=10962;   // jin
   sortTable[0x9EC5]=10963;   // jin
   sortTable[0x9F7D]=10964;   // jin
   sortTable[0x8CEE]=10965;   // jin
   sortTable[0x84F3]=10966;   // jin
   sortTable[0x91FF]=10967;   // jin
   sortTable[0x781B]=10968;   // jin
   sortTable[0x4F12]=10969;   // jin
   sortTable[0x4FAD]=10970;   // jin
   sortTable[0x50F8]=10971;   // jin
   sortTable[0x5118]=10972;   // jin
   sortTable[0x5153]=10973;   // jin
   sortTable[0x51DA]=10974;   // jin
   sortTable[0x52A4]=10975;   // jin
   sortTable[0x53AA]=10976;   // jin
   sortTable[0x552B]=10977;   // jin
   sortTable[0x568D]=10978;   // jin
   sortTable[0x57D0]=10979;   // jin
   sortTable[0x583B]=10980;   // jin
   sortTable[0x5890]=10981;   // jin
   sortTable[0x58D7]=10982;   // jin
   sortTable[0x5AE4]=10983;   // jin
   sortTable[0x5B27]=10984;   // jin
   sortTable[0x5BD6]=10985;   // jin
   sortTable[0x5D9C]=10986;   // jin
   sortTable[0x5DF9]=10987;   // jin
   sortTable[0x60CD]=10988;   // jin
   sortTable[0x6422]=10989;   // jin
   sortTable[0x6649]=10990;   // jin
   sortTable[0x669C]=10991;   // jin
   sortTable[0x6783]=10992;   // jin
   sortTable[0x6B4F]=10993;   // jin
   sortTable[0x6BA3]=10994;   // jin
   sortTable[0x6D55]=10995;   // jin
   sortTable[0x6E8D]=10996;   // jin
   sortTable[0x6F0C]=10997;   // jin
   sortTable[0x6FC5]=10998;   // jin
   sortTable[0x6FDC]=10999;   // jin
   sortTable[0x71FC]=11000;   // jin
   sortTable[0x73D2]=11001;   // jin
   sortTable[0x740E]=11002;   // jin
   sortTable[0x743B]=11003;   // jin
   sortTable[0x7468]=11004;   // jin
   sortTable[0x74A1]=11005;   // jin
   sortTable[0x74B6]=11006;   // jin
   sortTable[0x7E09]=11007;   // jin
   sortTable[0x8355]=11008;   // jin
   sortTable[0x85CE]=11009;   // jin
   sortTable[0x89B2]=11010;   // jin
   sortTable[0x8D10]=11011;   // jin
   sortTable[0x91D2]=11012;   // jin
   sortTable[0x9949]=11013;   // jin
   sortTable[0x9E76]=11014;   // jin
   sortTable[0x7ECF]=11015;   // jing
   sortTable[0x7D93]=11016;   // jing
   sortTable[0x775B]=11017;   // jing
   sortTable[0x7CBE]=11018;   // jing
   sortTable[0x9759]=11019;   // jing
   sortTable[0x975C]=11020;   // jing
   sortTable[0x60CA]=11021;   // jing
   sortTable[0x9A5A]=11022;   // jing
   sortTable[0x7ADF]=11023;   // jing
   sortTable[0x666F]=11024;   // jing
   sortTable[0x955C]=11025;   // jing
   sortTable[0x93E1]=11026;   // jing
   sortTable[0x5883]=11027;   // jing
   sortTable[0x8B66]=11028;   // jing
   sortTable[0x51C0]=11029;   // jing
   sortTable[0x6DE8]=11030;   // jing
   sortTable[0x4E95]=11031;   // jing
   sortTable[0x656C]=11032;   // jing
   sortTable[0x7ADE]=11033;   // jing
   sortTable[0x7AF6]=11034;   // jing
   sortTable[0x5F84]=11035;   // jing
   sortTable[0x5F91]=11036;   // jing
   sortTable[0x9CB8]=11037;   // jing
   sortTable[0x9BE8]=11038;   // jing
   sortTable[0x6676]=11039;   // jing
   sortTable[0x8148]=11040;   // jing
   sortTable[0x830E]=11041;   // jing
   sortTable[0x8396]=11042;   // jing
   sortTable[0x9888]=11043;   // jing
   sortTable[0x9838]=11044;   // jing
   sortTable[0x61AC]=11045;   // jing
   sortTable[0x4EAC]=11046;   // jing
   sortTable[0x8346]=11047;   // jing
   sortTable[0x9756]=11048;   // jing
   sortTable[0x65CC]=11049;   // jing
   sortTable[0x6CFE]=11050;   // jing
   sortTable[0x5162]=11051;   // jing
   sortTable[0x8FF3]=11052;   // jing
   sortTable[0x80EB]=11053;   // jing
   sortTable[0x83C1]=11054;   // jing
   sortTable[0x9631]=11055;   // jing
   sortTable[0x5106]=11056;   // jing
   sortTable[0x75C9]=11057;   // jing
   sortTable[0x9753]=11058;   // jing
   sortTable[0x80BC]=11059;   // jing
   sortTable[0x734D]=11060;   // jing
   sortTable[0x5A67]=11061;   // jing
   sortTable[0x7CB3]=11062;   // jing
   sortTable[0x522D]=11063;   // jing
   sortTable[0x9E96]=11064;   // jing
   sortTable[0x79D4]=11065;   // jing
   sortTable[0x9D84]=11066;   // jing
   sortTable[0x9F31]=11067;   // jing
   sortTable[0x7A7D]=11068;   // jing
   sortTable[0x7AEB]=11069;   // jing
   sortTable[0x811B]=11070;   // jing
   sortTable[0x5F2A]=11071;   // jing
   sortTable[0x7A09]=11072;   // jing
   sortTable[0x9015]=11073;   // jing
   sortTable[0x7AF8]=11074;   // jing
   sortTable[0x834A]=11075;   // jing
   sortTable[0x87FC]=11076;   // jing
   sortTable[0x844F]=11077;   // jing
   sortTable[0x981A]=11078;   // jing
   sortTable[0x9D5B]=11079;   // jing
   sortTable[0x7AE7]=11080;   // jing
   sortTable[0x4E3C]=11081;   // jing
   sortTable[0x4EB0]=11082;   // jing
   sortTable[0x4FD3]=11083;   // jing
   sortTable[0x501E]=11084;   // jing
   sortTable[0x50B9]=11085;   // jing
   sortTable[0x51C8]=11086;   // jing
   sortTable[0x5244]=11087;   // jing
   sortTable[0x5753]=11088;   // jing
   sortTable[0x5755]=11089;   // jing
   sortTable[0x5759]=11090;   // jing
   sortTable[0x598C]=11091;   // jing
   sortTable[0x5A59]=11092;   // jing
   sortTable[0x5A5B]=11093;   // jing
   sortTable[0x5B91]=11094;   // jing
   sortTable[0x5DE0]=11095;   // jing
   sortTable[0x5E5C]=11096;   // jing
   sortTable[0x5F33]=11097;   // jing
   sortTable[0x61BC]=11098;   // jing
   sortTable[0x65CD]=11099;   // jing
   sortTable[0x66BB]=11100;   // jing
   sortTable[0x66D4]=11101;   // jing
   sortTable[0x6871]=11102;   // jing
   sortTable[0x68B7]=11103;   // jing
   sortTable[0x6A78]=11104;   // jing
   sortTable[0x6C6B]=11105;   // jing
   sortTable[0x6C6C]=11106;   // jing
   sortTable[0x6D44]=11107;   // jing
   sortTable[0x6D87]=11108;   // jing
   sortTable[0x6FEA]=11109;   // jing
   sortTable[0x701E]=11110;   // jing
   sortTable[0x71DB]=11111;   // jing
   sortTable[0x71DD]=11112;   // jing
   sortTable[0x7304]=11113;   // jing
   sortTable[0x749F]=11114;   // jing
   sortTable[0x74A5]=11115;   // jing
   sortTable[0x75D9]=11116;   // jing
   sortTable[0x7D4C]=11117;   // jing
   sortTable[0x8059]=11118;   // jing
   sortTable[0x8AA9]=11119;   // jing
   sortTable[0x8E01]=11120;   // jing
   sortTable[0x975A]=11121;   // jing
   sortTable[0x9D81]=11122;   // jing
   sortTable[0x9EA0]=11123;   // jing
   sortTable[0x70AF]=11124;   // jiong
   sortTable[0x8FE5]=11125;   // jiong
   sortTable[0x7A98]=11126;   // jiong
   sortTable[0x7085]=11127;   // jiong
   sortTable[0x988E]=11128;   // jiong
   sortTable[0x6243]=11129;   // jiong
   sortTable[0x8927]=11130;   // jiong
   sortTable[0x99C9]=11131;   // jiong
   sortTable[0x7D45]=11132;   // jiong
   sortTable[0x9008]=11133;   // jiong
   sortTable[0x99EB]=11134;   // jiong
   sortTable[0x7D97]=11135;   // jiong
   sortTable[0x8614]=11136;   // jiong
   sortTable[0x4FB0]=11137;   // jiong
   sortTable[0x50D2]=11138;   // jiong
   sortTable[0x5182]=11139;   // jiong
   sortTable[0x518B]=11140;   // jiong
   sortTable[0x518F]=11141;   // jiong
   sortTable[0x56E7]=11142;   // jiong
   sortTable[0x5770]=11143;   // jiong
   sortTable[0x57DB]=11144;   // jiong
   sortTable[0x6CC2]=11145;   // jiong
   sortTable[0x6D7B]=11146;   // jiong
   sortTable[0x6F83]=11147;   // jiong
   sortTable[0x70F1]=11148;   // jiong
   sortTable[0x715A]=11149;   // jiong
   sortTable[0x715B]=11150;   // jiong
   sortTable[0x71B2]=11151;   // jiong
   sortTable[0x860F]=11152;   // jiong
   sortTable[0x5C31]=11153;   // jiu
   sortTable[0x4E5D]=11154;   // jiu
   sortTable[0x7A76]=11155;   // jiu
   sortTable[0x65E7]=11156;   // jiu
   sortTable[0x820A]=11157;   // jiu
   sortTable[0x4E45]=11158;   // jiu
   sortTable[0x9152]=11159;   // jiu
   sortTable[0x6551]=11160;   // jiu
   sortTable[0x7EA0]=11161;   // jiu
   sortTable[0x7CFE]=11162;   // jiu
   sortTable[0x8205]=11163;   // jiu
   sortTable[0x63EA]=11164;   // jiu
   sortTable[0x557E]=11165;   // jiu
   sortTable[0x548E]=11166;   // jiu
   sortTable[0x759A]=11167;   // jiu
   sortTable[0x9E20]=11168;   // jiu
   sortTable[0x67E9]=11169;   // jiu
   sortTable[0x97ED]=11170;   // jiu
   sortTable[0x81FC]=11171;   // jiu
   sortTable[0x53A9]=11172;   // jiu
   sortTable[0x50E6]=11173;   // jiu
   sortTable[0x9604]=11174;   // jiu
   sortTable[0x7078]=11175;   // jiu
   sortTable[0x9E6B]=11176;   // jiu
   sortTable[0x7396]=11177;   // jiu
   sortTable[0x8D73]=11178;   // jiu
   sortTable[0x6855]=11179;   // jiu
   sortTable[0x7CFA]=11180;   // jiu
   sortTable[0x97EE]=11181;   // jiu
   sortTable[0x9B0F]=11182;   // jiu
   sortTable[0x7D24]=11183;   // jiu
   sortTable[0x9DF2]=11184;   // jiu
   sortTable[0x9BE6]=11185;   // jiu
   sortTable[0x9F68]=11186;   // jiu
   sortTable[0x9CE9]=11187;   // jiu
   sortTable[0x9E94]=11188;   // jiu
   sortTable[0x4E29]=11189;   // jiu
   sortTable[0x4E46]=11190;   // jiu
   sortTable[0x4E63]=11191;   // jiu
   sortTable[0x5003]=11192;   // jiu
   sortTable[0x52FC]=11193;   // jiu
   sortTable[0x5313]=11194;   // jiu
   sortTable[0x531B]=11195;   // jiu
   sortTable[0x5336]=11196;   // jiu
   sortTable[0x597A]=11197;   // jiu
   sortTable[0x5AA8]=11198;   // jiu
   sortTable[0x5EC4]=11199;   // jiu
   sortTable[0x5ECF]=11200;   // jiu
   sortTable[0x5ED0]=11201;   // jiu
   sortTable[0x6166]=11202;   // jiu
   sortTable[0x6344]=11203;   // jiu
   sortTable[0x63C2]=11204;   // jiu
   sortTable[0x63EB]=11205;   // jiu
   sortTable[0x644E]=11206;   // jiu
   sortTable[0x673B]=11207;   // jiu
   sortTable[0x6766]=11208;   // jiu
   sortTable[0x67FE]=11209;   // jiu
   sortTable[0x6A1B]=11210;   // jiu
   sortTable[0x6B0D]=11211;   // jiu
   sortTable[0x6BA7]=11212;   // jiu
   sortTable[0x6C63]=11213;   // jiu
   sortTable[0x725E]=11214;   // jiu
   sortTable[0x820F]=11215;   // jiu
   sortTable[0x841B]=11216;   // jiu
   sortTable[0x9579]=11217;   // jiu
   sortTable[0x9B2E]=11218;   // jiu
   sortTable[0x636E]=11219;   // ju
   sortTable[0x64DA]=11220;   // ju
   sortTable[0x5177]=11221;   // ju
   sortTable[0x53E5]=11222;   // ju
   sortTable[0x4E3E]=11223;   // ju
   sortTable[0x8209]=11224;   // ju
   sortTable[0x5C40]=11225;   // ju
   sortTable[0x5DE8]=11226;   // ju
   sortTable[0x5C45]=11227;   // ju
   sortTable[0x8DDD]=11228;   // ju
   sortTable[0x5267]=11229;   // ju
   sortTable[0x5287]=11230;   // ju
   sortTable[0x805A]=11231;   // ju
   sortTable[0x62D2]=11232;   // ju
   sortTable[0x6A58]=11233;   // ju
   sortTable[0x77E9]=11234;   // ju
   sortTable[0x97A0]=11235;   // ju
   sortTable[0x4FF1]=11236;   // ju
   sortTable[0x62D8]=11237;   // ju
   sortTable[0x60E7]=11238;   // ju
   sortTable[0x61FC]=11239;   // ju
   sortTable[0x5480]=11240;   // ju
   sortTable[0x952F]=11241;   // ju
   sortTable[0x92F8]=11242;   // ju
   sortTable[0x83CA]=11243;   // ju
   sortTable[0x6854]=11244;   // ju
   sortTable[0x9A79]=11245;   // ju
   sortTable[0x99D2]=11246;   // ju
   sortTable[0x6CAE]=11247;   // ju
   sortTable[0x907D]=11248;   // ju
   sortTable[0x97AB]=11249;   // ju
   sortTable[0x949C]=11250;   // ju
   sortTable[0x83F9]=11251;   // ju
   sortTable[0x70AC]=11252;   // ju
   sortTable[0x8E1E]=11253;   // ju
   sortTable[0x75BD]=11254;   // ju
   sortTable[0x8392]=11255;   // ju
   sortTable[0x72D9]=11256;   // ju
   sortTable[0x5028]=11257;   // ju
   sortTable[0x88FE]=11258;   // ju
   sortTable[0x63AC]=11259;   // ju
   sortTable[0x98D3]=11260;   // ju
   sortTable[0x82F4]=11261;   // ju
   sortTable[0x8BB5]=11262;   // ju
   sortTable[0x91B5]=11263;   // ju
   sortTable[0x9F83]=11264;   // ju
   sortTable[0x96CE]=11265;   // ju
   sortTable[0x7AAD]=11266;   // ju
   sortTable[0x82E3]=11267;   // ju
   sortTable[0x6998]=11268;   // ju
   sortTable[0x741A]=11269;   // ju
   sortTable[0x6989]=11270;   // ju
   sortTable[0x5C66]=11271;   // ju
   sortTable[0x9514]=11272;   // ju
   sortTable[0x8D84]=11273;   // ju
   sortTable[0x8661]=11274;   // ju
   sortTable[0x8E3D]=11275;   // ju
   sortTable[0x79EC]=11276;   // ju
   sortTable[0x9B88]=11277;   // ju
   sortTable[0x7F5D]=11278;   // ju
   sortTable[0x8DFC]=11279;   // ju
   sortTable[0x7B65]=11280;   // ju
   sortTable[0x824D]=11281;   // ju
   sortTable[0x8E18]=11282;   // ju
   sortTable[0x9B94]=11283;   // ju
   sortTable[0x943B]=11284;   // ju
   sortTable[0x8893]=11285;   // ju
   sortTable[0x6910]=11286;   // ju
   sortTable[0x8152]=11287;   // ju
   sortTable[0x849F]=11288;   // ju
   sortTable[0x8C97]=11289;   // ju
   sortTable[0x7C34]=11290;   // ju
   sortTable[0x9245]=11291;   // ju
   sortTable[0x7CB7]=11292;   // ju
   sortTable[0x7C94]=11293;   // ju
   sortTable[0x95B0]=11294;   // ju
   sortTable[0x9D59]=11295;   // ju
   sortTable[0x728B]=11296;   // ju
   sortTable[0x8F02]=11297;   // ju
   sortTable[0x9D8B]=11298;   // ju
   sortTable[0x8DD4]=11299;   // ju
   sortTable[0x8C66]=11300;   // ju
   sortTable[0x99F6]=11301;   // ju
   sortTable[0x7820]=11302;   // ju
   sortTable[0x9D74]=11303;   // ju
   sortTable[0x8065]=11304;   // ju
   sortTable[0x861C]=11305;   // ju
   sortTable[0x8E86]=11306;   // ju
   sortTable[0x99CF]=11307;   // ju
   sortTable[0x9D21]=11308;   // ju
   sortTable[0x801F]=11309;   // ju
   sortTable[0x8ACA]=11310;   // ju
   sortTable[0x8DD9]=11311;   // ju
   sortTable[0x8E6B]=11312;   // ju
   sortTable[0x9671]=11313;   // ju
   sortTable[0x9F33]=11314;   // ju
   sortTable[0x4E6C]=11315;   // ju
   sortTable[0x4FB7]=11316;   // ju
   sortTable[0x5036]=11317;   // ju
   sortTable[0x50EA]=11318;   // ju
   sortTable[0x51A3]=11319;   // ju
   sortTable[0x51E5]=11320;   // ju
   sortTable[0x521F]=11321;   // ju
   sortTable[0x52EE]=11322;   // ju
   sortTable[0x530A]=11323;   // ju
   sortTable[0x5579]=11324;   // ju
   sortTable[0x57E7]=11325;   // ju
   sortTable[0x57FE]=11326;   // ju
   sortTable[0x58C9]=11327;   // ju
   sortTable[0x59D6]=11328;   // ju
   sortTable[0x5A35]=11329;   // ju
   sortTable[0x5A45]=11330;   // ju
   sortTable[0x5A6E]=11331;   // ju
   sortTable[0x5BE0]=11332;   // ju
   sortTable[0x5C68]=11333;   // ju
   sortTable[0x5CA0]=11334;   // ju
   sortTable[0x5D0C]=11335;   // ju
   sortTable[0x5DC8]=11336;   // ju
   sortTable[0x5DEA]=11337;   // ju
   sortTable[0x5F06]=11338;   // ju
   sortTable[0x6007]=11339;   // ju
   sortTable[0x6010]=11340;   // ju
   sortTable[0x601A]=11341;   // ju
   sortTable[0x6133]=11342;   // ju
   sortTable[0x61C5]=11343;   // ju
   sortTable[0x6285]=11344;   // ju
   sortTable[0x62E0]=11345;   // ju
   sortTable[0x6319]=11346;   // ju
   sortTable[0x6336]=11347;   // ju
   sortTable[0x64E7]=11348;   // ju
   sortTable[0x661B]=11349;   // ju
   sortTable[0x68AE]=11350;   // ju
   sortTable[0x6907]=11351;   // ju
   sortTable[0x6908]=11352;   // ju
   sortTable[0x6A8B]=11353;   // ju
   sortTable[0x6AF8]=11354;   // ju
   sortTable[0x6B05]=11355;   // ju
   sortTable[0x6B6B]=11356;   // ju
   sortTable[0x6BE9]=11357;   // ju
   sortTable[0x6BF1]=11358;   // ju
   sortTable[0x6CC3]=11359;   // ju
   sortTable[0x6CE6]=11360;   // ju
   sortTable[0x6D30]=11361;   // ju
   sortTable[0x6DBA]=11362;   // ju
   sortTable[0x6DD7]=11363;   // ju
   sortTable[0x6E68]=11364;   // ju
   sortTable[0x6FBD]=11365;   // ju
   sortTable[0x7117]=11366;   // ju
   sortTable[0x7220]=11367;   // ju
   sortTable[0x7291]=11368;   // ju
   sortTable[0x72CA]=11369;   // ju
   sortTable[0x75C0]=11370;   // ju
   sortTable[0x7717]=11371;   // ju
   sortTable[0x7AB6]=11372;   // ju
   sortTable[0x86B7]=11373;   // ju
   sortTable[0x871B]=11374;   // ju
   sortTable[0x8977]=11375;   // ju
   sortTable[0x8A4E]=11376;   // ju
   sortTable[0x8D9C]=11377;   // ju
   sortTable[0x8E19]=11378;   // ju
   sortTable[0x8EB9]=11379;   // ju
   sortTable[0x90AD]=11380;   // ju
   sortTable[0x90F9]=11381;   // ju
   sortTable[0x92E6]=11382;   // ju
   sortTable[0x98B6]=11383;   // ju
   sortTable[0x9A67]=11384;   // ju
   sortTable[0x9DAA]=11385;   // ju
   sortTable[0x9F5F]=11386;   // ju
   sortTable[0x5377]=11387;   // juan
   sortTable[0x5026]=11388;   // juan
   sortTable[0x7EE2]=11389;   // juan
   sortTable[0x7D79]=11390;   // juan
   sortTable[0x9E43]=11391;   // juan
   sortTable[0x9D51]=11392;   // juan
   sortTable[0x6350]=11393;   // juan
   sortTable[0x7737]=11394;   // juan
   sortTable[0x5A1F]=11395;   // juan
   sortTable[0x8832]=11396;   // juan
   sortTable[0x6D93]=11397;   // juan
   sortTable[0x954C]=11398;   // juan
   sortTable[0x96BD]=11399;   // juan
   sortTable[0x9104]=11400;   // juan
   sortTable[0x9529]=11401;   // juan
   sortTable[0x72F7]=11402;   // juan
   sortTable[0x7760]=11403;   // juan
   sortTable[0x7F65]=11404;   // juan
   sortTable[0x774A]=11405;   // juan
   sortTable[0x684A]=11406;   // juan
   sortTable[0x81C7]=11407;   // juan
   sortTable[0x8127]=11408;   // juan
   sortTable[0x7E33]=11409;   // juan
   sortTable[0x83E4]=11410;   // juan
   sortTable[0x9308]=11411;   // juan
   sortTable[0x7F82]=11412;   // juan
   sortTable[0x942B]=11413;   // juan
   sortTable[0x96CB]=11414;   // juan
   sortTable[0x7D6D]=11415;   // juan
   sortTable[0x8528]=11416;   // juan
   sortTable[0x93B8]=11417;   // juan
   sortTable[0x52B5]=11418;   // juan
   sortTable[0x52CC]=11419;   // juan
   sortTable[0x52EC]=11420;   // juan
   sortTable[0x545F]=11421;   // juan
   sortTable[0x57CD]=11422;   // juan
   sortTable[0x5946]=11423;   // juan
   sortTable[0x59E2]=11424;   // juan
   sortTable[0x5DFB]=11425;   // juan
   sortTable[0x5E23]=11426;   // juan
   sortTable[0x617B]=11427;   // juan
   sortTable[0x6372]=11428;   // juan
   sortTable[0x6DC3]=11429;   // juan
   sortTable[0x7106]=11430;   // juan
   sortTable[0x7367]=11431;   // juan
   sortTable[0x74F9]=11432;   // juan
   sortTable[0x88D0]=11433;   // juan
   sortTable[0x98EC]=11434;   // juan
   sortTable[0x990B]=11435;   // juan
   sortTable[0x51B3]=11436;   // jue
   sortTable[0x6C7A]=11437;   // jue
   sortTable[0x89C9]=11438;   // jue
   sortTable[0x89BA]=11439;   // jue
   sortTable[0x7EDD]=11440;   // jue
   sortTable[0x7D55]=11441;   // jue
   sortTable[0x6485]=11442;   // jue
   sortTable[0x56BC]=11443;   // jue
   sortTable[0x6398]=11444;   // jue
   sortTable[0x7235]=11445;   // jue
   sortTable[0x53A5]=11446;   // jue
   sortTable[0x8BC0]=11447;   // jue
   sortTable[0x5D1B]=11448;   // jue
   sortTable[0x7357]=11449;   // jue
   sortTable[0x5014]=11450;   // jue
   sortTable[0x6A5B]=11451;   // jue
   sortTable[0x6289]=11452;   // jue
   sortTable[0x652B]=11453;   // jue
   sortTable[0x8E76]=11454;   // jue
   sortTable[0x73CF]=11455;   // jue
   sortTable[0x77CD]=11456;   // jue
   sortTable[0x8C32]=11457;   // jue
   sortTable[0x8568]=11458;   // jue
   sortTable[0x5658]=11459;   // jue
   sortTable[0x5671]=11460;   // jue
   sortTable[0x9562]=11461;   // jue
   sortTable[0x6877]=11462;   // jue
   sortTable[0x89D6]=11463;   // jue
   sortTable[0x8E7B]=11464;   // jue
   sortTable[0x5282]=11465;   // jue
   sortTable[0x721D]=11466;   // jue
   sortTable[0x940D]=11467;   // jue
   sortTable[0x5B53]=11468;   // jue
   sortTable[0x99C3]=11469;   // jue
   sortTable[0x855D]=11470;   // jue
   sortTable[0x9D02]=11471;   // jue
   sortTable[0x9481]=11472;   // jue
   sortTable[0x89FC]=11473;   // jue
   sortTable[0x8DB9]=11474;   // jue
   sortTable[0x81C4]=11475;   // jue
   sortTable[0x9D03]=11476;   // jue
   sortTable[0x8C9C]=11477;   // jue
   sortTable[0x8E77]=11478;   // jue
   sortTable[0x8B4E]=11479;   // jue
   sortTable[0x8EA9]=11480;   // jue
   sortTable[0x87E8]=11481;   // jue
   sortTable[0x77E1]=11482;   // jue
   sortTable[0x82B5]=11483;   // jue
   sortTable[0x941D]=11484;   // jue
   sortTable[0x9D8C]=11485;   // jue
   sortTable[0x9FA3]=11486;   // jue
   sortTable[0x87E9]=11487;   // jue
   sortTable[0x8990]=11488;   // jue
   sortTable[0x899A]=11489;   // jue
   sortTable[0x8A23]=11490;   // jue
   sortTable[0x8D89]=11491;   // jue
   sortTable[0x920C]=11492;   // jue
   sortTable[0x7D76]=11493;   // jue
   sortTable[0x8D7D]=11494;   // jue
   sortTable[0x9DE2]=11495;   // jue
   sortTable[0x4E85]=11496;   // jue
   sortTable[0x5095]=11497;   // jue
   sortTable[0x5214]=11498;   // jue
   sortTable[0x52EA]=11499;   // jue
   sortTable[0x5337]=11500;   // jue
   sortTable[0x5B52]=11501;   // jue
   sortTable[0x5C69]=11502;   // jue
   sortTable[0x5C6B]=11503;   // jue
   sortTable[0x5DA5]=11504;   // jue
   sortTable[0x5F21]=11505;   // jue
   sortTable[0x5F4F]=11506;   // jue
   sortTable[0x61A0]=11507;   // jue
   sortTable[0x61B0]=11508;   // jue
   sortTable[0x6204]=11509;   // jue
   sortTable[0x6317]=11510;   // jue
   sortTable[0x6354]=11511;   // jue
   sortTable[0x64A7]=11512;   // jue
   sortTable[0x658D]=11513;   // jue
   sortTable[0x6A5C]=11514;   // jue
   sortTable[0x6B14]=11515;   // jue
   sortTable[0x6B2E]=11516;   // jue
   sortTable[0x6B8C]=11517;   // jue
   sortTable[0x6C12]=11518;   // jue
   sortTable[0x6CEC]=11519;   // jue
   sortTable[0x7133]=11520;   // jue
   sortTable[0x71A6]=11521;   // jue
   sortTable[0x7211]=11522;   // jue
   sortTable[0x7234]=11523;   // jue
   sortTable[0x7383]=11524;   // jue
   sortTable[0x73A6]=11525;   // jue
   sortTable[0x73A8]=11526;   // jue
   sortTable[0x7474]=11527;   // jue
   sortTable[0x75A6]=11528;   // jue
   sortTable[0x761A]=11529;   // jue
   sortTable[0x7804]=11530;   // jue
   sortTable[0x8673]=11531;   // jue
   sortTable[0x8697]=11532;   // jue
   sortTable[0x902B]=11533;   // jue
   sortTable[0x519B]=11534;   // jun
   sortTable[0x8ECD]=11535;   // jun
   sortTable[0x5747]=11536;   // jun
   sortTable[0x83CC]=11537;   // jun
   sortTable[0x541B]=11538;   // jun
   sortTable[0x5CFB]=11539;   // jun
   sortTable[0x90E1]=11540;   // jun
   sortTable[0x4FCA]=11541;   // jun
   sortTable[0x6D5A]=11542;   // jun
   sortTable[0x94A7]=11543;   // jun
   sortTable[0x9A8F]=11544;   // jun
   sortTable[0x7AE3]=11545;   // jun
   sortTable[0x9E87]=11546;   // jun
   sortTable[0x6343]=11547;   // jun
   sortTable[0x76B2]=11548;   // jun
   sortTable[0x9982]=11549;   // jun
   sortTable[0x9E95]=11550;   // jun
   sortTable[0x8880]=11551;   // jun
   sortTable[0x7B98]=11552;   // jun
   sortTable[0x9CAA]=11553;   // jun
   sortTable[0x89A0]=11554;   // jun
   sortTable[0x9E8F]=11555;   // jun
   sortTable[0x8399]=11556;   // jun
   sortTable[0x929E]=11557;   // jun
   sortTable[0x9D54]=11558;   // jun
   sortTable[0x7885]=11559;   // jun
   sortTable[0x9915]=11560;   // jun
   sortTable[0x8720]=11561;   // jun
   sortTable[0x9656]=11562;   // jun
   sortTable[0x5101]=11563;   // jun
   sortTable[0x5441]=11564;   // jun
   sortTable[0x57C8]=11565;   // jun
   sortTable[0x59F0]=11566;   // jun
   sortTable[0x5BEF]=11567;   // jun
   sortTable[0x61CF]=11568;   // jun
   sortTable[0x6508]=11569;   // jun
   sortTable[0x651F]=11570;   // jun
   sortTable[0x6659]=11571;   // jun
   sortTable[0x687E]=11572;   // jun
   sortTable[0x68DE]=11573;   // jun
   sortTable[0x6C6E]=11574;   // jun
   sortTable[0x6FEC]=11575;   // jun
   sortTable[0x710C]=11576;   // jun
   sortTable[0x71C7]=11577;   // jun
   sortTable[0x73FA]=11578;   // jun
   sortTable[0x756F]=11579;   // jun
   sortTable[0x76B8]=11580;   // jun
   sortTable[0x76B9]=11581;   // jun
   sortTable[0x7B9F]=11582;   // jun
   sortTable[0x8690]=11583;   // jun
   sortTable[0x921E]=11584;   // jun
   sortTable[0x9281]=11585;   // jun
   sortTable[0x9355]=11586;   // jun
   sortTable[0x99FF]=11587;   // jun
   sortTable[0x9BB6]=11588;   // jun
   sortTable[0x9D58]=11589;   // jun
   sortTable[0x5361]=12032;   // ka
   sortTable[0x5496]=12033;   // ka
   sortTable[0x5580]=12034;   // ka
   sortTable[0x5494]=12035;   // ka
   sortTable[0x80E9]=12036;   // ka
   sortTable[0x4F67]=12037;   // ka
   sortTable[0x8849]=12038;   // ka
   sortTable[0x57B0]=12039;   // ka
   sortTable[0x64D6]=12040;   // ka
   sortTable[0x88C3]=12041;   // ka
   sortTable[0x9272]=12042;   // ka
   sortTable[0x5F00]=12043;   // kai
   sortTable[0x958B]=12044;   // kai
   sortTable[0x6168]=12045;   // kai
   sortTable[0x63E9]=12046;   // kai
   sortTable[0x51EF]=12047;   // kai
   sortTable[0x6977]=12048;   // kai
   sortTable[0x607A]=12049;   // kai
   sortTable[0x94E0]=12050;   // kai
   sortTable[0x9534]=12051;   // kai
   sortTable[0x950E]=12052;   // kai
   sortTable[0x95FF]=12053;   // kai
   sortTable[0x5FFE]=12054;   // kai
   sortTable[0x5240]=12055;   // kai
   sortTable[0x57B2]=12056;   // kai
   sortTable[0x8488]=12057;   // kai
   sortTable[0x8F06]=12058;   // kai
   sortTable[0x98BD]=12059;   // kai
   sortTable[0x95D3]=12060;   // kai
   sortTable[0x9426]=12061;   // kai
   sortTable[0x51F1]=12062;   // kai
   sortTable[0x5274]=12063;   // kai
   sortTable[0x52D3]=12064;   // kai
   sortTable[0x5605]=12065;   // kai
   sortTable[0x584F]=12066;   // kai
   sortTable[0x5952]=12067;   // kai
   sortTable[0x5D66]=12068;   // kai
   sortTable[0x6112]=12069;   // kai
   sortTable[0x6137]=12070;   // kai
   sortTable[0x613E]=12071;   // kai
   sortTable[0x669F]=12072;   // kai
   sortTable[0x6B2C]=12073;   // kai
   sortTable[0x708C]=12074;   // kai
   sortTable[0x708F]=12075;   // kai
   sortTable[0x70D7]=12076;   // kai
   sortTable[0x9347]=12077;   // kai
   sortTable[0x938E]=12078;   // kai
   sortTable[0x93A7]=12079;   // kai
   sortTable[0x770B]=12080;   // kan
   sortTable[0x780D]=12081;   // kan
   sortTable[0x520A]=12082;   // kan
   sortTable[0x582A]=12083;   // kan
   sortTable[0x69DB]=12084;   // kan
   sortTable[0x6ABB]=12085;   // kan
   sortTable[0x52D8]=12086;   // kan
   sortTable[0x574E]=12087;   // kan
   sortTable[0x4F83]=12088;   // kan
   sortTable[0x9F9B]=12089;   // kan
   sortTable[0x77B0]=12090;   // kan
   sortTable[0x6221]=12091;   // kan
   sortTable[0x884E]=12092;   // kan
   sortTable[0x9851]=12093;   // kan
   sortTable[0x7AF7]=12094;   // kan
   sortTable[0x8F57]=12095;   // kan
   sortTable[0x78E1]=12096;   // kan
   sortTable[0x77D9]=12097;   // kan
   sortTable[0x9F95]=12098;   // kan
   sortTable[0x8F21]=12099;   // kan
   sortTable[0x5058]=12100;   // kan
   sortTable[0x519A]=12101;   // kan
   sortTable[0x57F3]=12102;   // kan
   sortTable[0x586A]=12103;   // kan
   sortTable[0x5888]=12104;   // kan
   sortTable[0x5D01]=12105;   // kan
   sortTable[0x5D41]=12106;   // kan
   sortTable[0x60C2]=12107;   // kan
   sortTable[0x681E]=12108;   // kan
   sortTable[0x6B3F]=12109;   // kan
   sortTable[0x6B41]=12110;   // kan
   sortTable[0x83B0]=12111;   // kan
   sortTable[0x95DE]=12112;   // kan
   sortTable[0x6297]=12113;   // kang
   sortTable[0x7095]=12114;   // kang
   sortTable[0x5EB7]=12115;   // kang
   sortTable[0x625B]=12116;   // kang
   sortTable[0x6177]=12117;   // kang
   sortTable[0x4EA2]=12118;   // kang
   sortTable[0x94AA]=12119;   // kang
   sortTable[0x7CE0]=12120;   // kang
   sortTable[0x95F6]=12121;   // kang
   sortTable[0x4F09]=12122;   // kang
   sortTable[0x9C47]=12123;   // kang
   sortTable[0x9227]=12124;   // kang
   sortTable[0x909F]=12125;   // kang
   sortTable[0x7A45]=12126;   // kang
   sortTable[0x7C87]=12127;   // kang
   sortTable[0x8EBF]=12128;   // kang
   sortTable[0x958C]=12129;   // kang
   sortTable[0x531F]=12130;   // kang
   sortTable[0x56E5]=12131;   // kang
   sortTable[0x5ADD]=12132;   // kang
   sortTable[0x5D7B]=12133;   // kang
   sortTable[0x5FFC]=12134;   // kang
   sortTable[0x6443]=12135;   // kang
   sortTable[0x69FA]=12136;   // kang
   sortTable[0x6F2E]=12137;   // kang
   sortTable[0x72BA]=12138;   // kang
   sortTable[0x780A]=12139;   // kang
   sortTable[0x93EE]=12140;   // kang
   sortTable[0x9760]=12141;   // kao
   sortTable[0x8003]=12142;   // kao
   sortTable[0x70E4]=12143;   // kao
   sortTable[0x62F7]=12144;   // kao
   sortTable[0x7292]=12145;   // kao
   sortTable[0x94D0]=12146;   // kao
   sortTable[0x5C3B]=12147;   // kao
   sortTable[0x6832]=12148;   // kao
   sortTable[0x9BCC]=12149;   // kao
   sortTable[0x9ADB]=12150;   // kao
   sortTable[0x7A01]=12151;   // kao
   sortTable[0x9C93]=12152;   // kao
   sortTable[0x4E02]=12153;   // kao
   sortTable[0x6537]=12154;   // kao
   sortTable[0x6D18]=12155;   // kao
   sortTable[0x71FA]=12156;   // kao
   sortTable[0x92AC]=12157;   // kao
   sortTable[0x9BB3]=12158;   // kao
   sortTable[0x53EF]=12159;   // ke
   sortTable[0x79D1]=12160;   // ke
   sortTable[0x523B]=12161;   // ke
   sortTable[0x5BA2]=12162;   // ke
   sortTable[0x8BFE]=12163;   // ke
   sortTable[0x8AB2]=12164;   // ke
   sortTable[0x9897]=12165;   // ke
   sortTable[0x9846]=12166;   // ke
   sortTable[0x514B]=12167;   // ke
   sortTable[0x68F5]=12168;   // ke
   sortTable[0x58F3]=12169;   // ke
   sortTable[0x6BBC]=12170;   // ke
   sortTable[0x6E34]=12171;   // ke
   sortTable[0x78D5]=12172;   // ke
   sortTable[0x778C]=12173;   // ke
   sortTable[0x874C]=12174;   // ke
   sortTable[0x67EF]=12175;   // ke
   sortTable[0x606A]=12176;   // ke
   sortTable[0x82DB]=12177;   // ke
   sortTable[0x73C2]=12178;   // ke
   sortTable[0x8F72]=12179;   // ke
   sortTable[0x7AA0]=12180;   // ke
   sortTable[0x5777]=12181;   // ke
   sortTable[0x55D1]=12182;   // ke
   sortTable[0x9AC1]=12183;   // ke
   sortTable[0x6C2A]=12184;   // ke
   sortTable[0x5CA2]=12185;   // ke
   sortTable[0x7F02]=12186;   // ke
   sortTable[0x951E]=12187;   // ke
   sortTable[0x988F]=12188;   // ke
   sortTable[0x75B4]=12189;   // ke
   sortTable[0x7A1E]=12190;   // ke
   sortTable[0x6E98]=12191;   // ke
   sortTable[0x9A92]=12192;   // ke
   sortTable[0x8DB7]=12193;   // ke
   sortTable[0x7822]=12194;   // ke
   sortTable[0x8250]=12195;   // ke
   sortTable[0x8596]=12196;   // ke
   sortTable[0x9A0D]=12197;   // ke
   sortTable[0x790A]=12198;   // ke
   sortTable[0x9233]=12199;   // ke
   sortTable[0x78A6]=12200;   // ke
   sortTable[0x7FD7]=12201;   // ke
   sortTable[0x8EFB]=12202;   // ke
   sortTable[0x524B]=12203;   // ke
   sortTable[0x52C0]=12204;   // ke
   sortTable[0x52CA]=12205;   // ke
   sortTable[0x533C]=12206;   // ke
   sortTable[0x5801]=12207;   // ke
   sortTable[0x5A14]=12208;   // ke
   sortTable[0x5C05]=12209;   // ke
   sortTable[0x5D51]=12210;   // ke
   sortTable[0x5D59]=12211;   // ke
   sortTable[0x5DB1]=12212;   // ke
   sortTable[0x6119]=12213;   // ke
   sortTable[0x63E2]=12214;   // ke
   sortTable[0x6415]=12215;   // ke
   sortTable[0x6564]=12216;   // ke
   sortTable[0x69BC]=12217;   // ke
   sortTable[0x6A16]=12218;   // ke
   sortTable[0x6E07]=12219;   // ke
   sortTable[0x70A3]=12220;   // ke
   sortTable[0x7241]=12221;   // ke
   sortTable[0x7290]=12222;   // ke
   sortTable[0x790D]=12223;   // ke
   sortTable[0x791A]=12224;   // ke
   sortTable[0x7DD9]=12225;   // ke
   sortTable[0x80E2]=12226;   // ke
   sortTable[0x842A]=12227;   // ke
   sortTable[0x9198]=12228;   // ke
   sortTable[0x9312]=12229;   // ke
   sortTable[0x80AF]=12230;   // ken
   sortTable[0x6073]=12231;   // ken
   sortTable[0x61C7]=12232;   // ken
   sortTable[0x5543]=12233;   // ken
   sortTable[0x57A6]=12234;   // ken
   sortTable[0x58BE]=12235;   // ken
   sortTable[0x9F88]=12236;   // ken
   sortTable[0x88C9]=12237;   // ken
   sortTable[0x80BB]=12238;   // ken
   sortTable[0x8C64]=12239;   // ken
   sortTable[0x9F66]=12240;   // ken
   sortTable[0x63AF]=12241;   // ken
   sortTable[0x808E]=12242;   // ken
   sortTable[0x8903]=12243;   // ken
   sortTable[0x9339]=12244;   // ken
   sortTable[0x5751]=12245;   // keng
   sortTable[0x542D]=12246;   // keng
   sortTable[0x94FF]=12247;   // keng
   sortTable[0x7841]=12248;   // keng
   sortTable[0x962C]=12249;   // keng
   sortTable[0x785C]=12250;   // keng
   sortTable[0x935E]=12251;   // keng
   sortTable[0x787B]=12252;   // keng
   sortTable[0x52A5]=12253;   // keng
   sortTable[0x5994]=12254;   // keng
   sortTable[0x6333]=12255;   // keng
   sortTable[0x647C]=12256;   // keng
   sortTable[0x727C]=12257;   // keng
   sortTable[0x8A99]=12258;   // keng
   sortTable[0x92B5]=12259;   // keng
   sortTable[0x93D7]=12260;   // keng
   sortTable[0x7A7A]=12261;   // kong
   sortTable[0x63A7]=12262;   // kong
   sortTable[0x5B54]=12263;   // kong
   sortTable[0x6050]=12264;   // kong
   sortTable[0x5D06]=12265;   // kong
   sortTable[0x5025]=12266;   // kong
   sortTable[0x7B9C]=12267;   // kong
   sortTable[0x979A]=12268;   // kong
   sortTable[0x787F]=12269;   // kong
   sortTable[0x8EBB]=12270;   // kong
   sortTable[0x9D7C]=12271;   // kong
   sortTable[0x57EA]=12272;   // kong
   sortTable[0x60BE]=12273;   // kong
   sortTable[0x6DB3]=12274;   // kong
   sortTable[0x9313]=12275;   // kong
   sortTable[0x53E3]=12276;   // kou
   sortTable[0x6263]=12277;   // kou
   sortTable[0x5BC7]=12278;   // kou
   sortTable[0x53E9]=12279;   // kou
   sortTable[0x82A4]=12280;   // kou
   sortTable[0x62A0]=12281;   // kou
   sortTable[0x7B58]=12282;   // kou
   sortTable[0x853B]=12283;   // kou
   sortTable[0x9DC7]=12284;   // kou
   sortTable[0x770D]=12285;   // kou
   sortTable[0x91E6]=12286;   // kou
   sortTable[0x7789]=12287;   // kou
   sortTable[0x7A9B]=12288;   // kou
   sortTable[0x8532]=12289;   // kou
   sortTable[0x7C06]=12290;   // kou
   sortTable[0x51A6]=12291;   // kou
   sortTable[0x527E]=12292;   // kou
   sortTable[0x52B6]=12293;   // kou
   sortTable[0x5BBC]=12294;   // kou
   sortTable[0x5F44]=12295;   // kou
   sortTable[0x6473]=12296;   // kou
   sortTable[0x6542]=12297;   // kou
   sortTable[0x6EF1]=12298;   // kou
   sortTable[0x7798]=12299;   // kou
   sortTable[0x82E6]=12300;   // ku
   sortTable[0x54ED]=12301;   // ku
   sortTable[0x5E93]=12302;   // ku
   sortTable[0x5EAB]=12303;   // ku
   sortTable[0x88E4]=12304;   // ku
   sortTable[0x8932]=12305;   // ku
   sortTable[0x9177]=12306;   // ku
   sortTable[0x67AF]=12307;   // ku
   sortTable[0x7A9F]=12308;   // ku
   sortTable[0x9AB7]=12309;   // ku
   sortTable[0x55BE]=12310;   // ku
   sortTable[0x88B4]=12311;   // ku
   sortTable[0x5233]=12312;   // ku
   sortTable[0x7ED4]=12313;   // ku
   sortTable[0x5800]=12314;   // ku
   sortTable[0x77FB]=12315;   // ku
   sortTable[0x8DCD]=12316;   // ku
   sortTable[0x8DB6]=12317;   // ku
   sortTable[0x9BAC]=12318;   // ku
   sortTable[0x90C0]=12319;   // ku
   sortTable[0x79D9]=12320;   // ku
   sortTable[0x4FC8]=12321;   // ku
   sortTable[0x56B3]=12322;   // ku
   sortTable[0x5710]=12323;   // ku
   sortTable[0x5D2B]=12324;   // ku
   sortTable[0x5EE4]=12325;   // ku
   sortTable[0x625D]=12326;   // ku
   sortTable[0x684D]=12327;   // ku
   sortTable[0x7105]=12328;   // ku
   sortTable[0x72DC]=12329;   // ku
   sortTable[0x7614]=12330;   // ku
   sortTable[0x7D5D]=12331;   // ku
   sortTable[0x80D0]=12332;   // ku
   sortTable[0x8DE8]=12333;   // kua
   sortTable[0x5938]=12334;   // kua
   sortTable[0x57AE]=12335;   // kua
   sortTable[0x630E]=12336;   // kua
   sortTable[0x80EF]=12337;   // kua
   sortTable[0x4F89]=12338;   // kua
   sortTable[0x9299]=12339;   // kua
   sortTable[0x8A87]=12340;   // kua
   sortTable[0x9ABB]=12341;   // kua
   sortTable[0x54B5]=12342;   // kua
   sortTable[0x59F1]=12343;   // kua
   sortTable[0x823F]=12344;   // kua
   sortTable[0x5FEB]=12345;   // kuai
   sortTable[0x5757]=12346;   // kuai
   sortTable[0x584A]=12347;   // kuai
   sortTable[0x7B77]=12348;   // kuai
   sortTable[0x84AF]=12349;   // kuai
   sortTable[0x54D9]=12350;   // kuai
   sortTable[0x810D]=12351;   // kuai
   sortTable[0x4FA9]=12352;   // kuai
   sortTable[0x72EF]=12353;   // kuai
   sortTable[0x9C99]=12354;   // kuai
   sortTable[0x90D0]=12355;   // kuai
   sortTable[0x9136]=12356;   // kuai
   sortTable[0x9C60]=12357;   // kuai
   sortTable[0x81BE]=12358;   // kuai
   sortTable[0x5108]=12359;   // kuai
   sortTable[0x51F7]=12360;   // kuai
   sortTable[0x5672]=12361;   // kuai
   sortTable[0x5726]=12362;   // kuai
   sortTable[0x58A4]=12363;   // kuai
   sortTable[0x5DDC]=12364;   // kuai
   sortTable[0x5EE5]=12365;   // kuai
   sortTable[0x64D3]=12366;   // kuai
   sortTable[0x65DD]=12367;   // kuai
   sortTable[0x736A]=12368;   // kuai
   sortTable[0x7CE9]=12369;   // kuai
   sortTable[0x5BBD]=12370;   // kuan
   sortTable[0x5BEC]=12371;   // kuan
   sortTable[0x6B3E]=12372;   // kuan
   sortTable[0x9ACB]=12373;   // kuan
   sortTable[0x7ABE]=12374;   // kuan
   sortTable[0x81D7]=12375;   // kuan
   sortTable[0x5BDB]=12376;   // kuan
   sortTable[0x6B35]=12377;   // kuan
   sortTable[0x6B40]=12378;   // kuan
   sortTable[0x7ABD]=12379;   // kuan
   sortTable[0x9467]=12380;   // kuan
   sortTable[0x9AD6]=12381;   // kuan
   sortTable[0x51B5]=12382;   // kuang
   sortTable[0x6CC1]=12383;   // kuang
   sortTable[0x77FF]=12384;   // kuang
   sortTable[0x7926]=12385;   // kuang
   sortTable[0x72C2]=12386;   // kuang
   sortTable[0x7B50]=12387;   // kuang
   sortTable[0x6846]=12388;   // kuang
   sortTable[0x7736]=12389;   // kuang
   sortTable[0x65F7]=12390;   // kuang
   sortTable[0x66E0]=12391;   // kuang
   sortTable[0x5321]=12392;   // kuang
   sortTable[0x8BF3]=12393;   // kuang
   sortTable[0x8BD3]=12394;   // kuang
   sortTable[0x54D0]=12395;   // kuang
   sortTable[0x8D36]=12396;   // kuang
   sortTable[0x909D]=12397;   // kuang
   sortTable[0x5739]=12398;   // kuang
   sortTable[0x7EA9]=12399;   // kuang
   sortTable[0x593C]=12400;   // kuang
   sortTable[0x7716]=12401;   // kuang
   sortTable[0x7A6C]=12402;   // kuang
   sortTable[0x945B]=12403;   // kuang
   sortTable[0x7E8A]=12404;   // kuang
   sortTable[0x8EED]=12405;   // kuang
   sortTable[0x8E80]=12406;   // kuang
   sortTable[0x8ED6]=12407;   // kuang
   sortTable[0x90BC]=12408;   // kuang
   sortTable[0x913A]=12409;   // kuang
   sortTable[0x9ECB]=12410;   // kuang
   sortTable[0x7844]=12411;   // kuang
   sortTable[0x7D56]=12412;   // kuang
   sortTable[0x9D5F]=12413;   // kuang
   sortTable[0x77CC]=12414;   // kuang
   sortTable[0x8A91]=12415;   // kuang
   sortTable[0x5123]=12416;   // kuang
   sortTable[0x52BB]=12417;   // kuang
   sortTable[0x5329]=12418;   // kuang
   sortTable[0x535D]=12419;   // kuang
   sortTable[0x58D9]=12420;   // kuang
   sortTable[0x5CB2]=12421;   // kuang
   sortTable[0x5FF9]=12422;   // kuang
   sortTable[0x6047]=12423;   // kuang
   sortTable[0x61EC]=12424;   // kuang
   sortTable[0x61ED]=12425;   // kuang
   sortTable[0x6282]=12426;   // kuang
   sortTable[0x663F]=12427;   // kuang
   sortTable[0x6D2D]=12428;   // kuang
   sortTable[0x720C]=12429;   // kuang
   sortTable[0x783F]=12430;   // kuang
   sortTable[0x7B7A]=12431;   // kuang
   sortTable[0x7D4B]=12432;   // kuang
   sortTable[0x8A86]=12433;   // kuang
   sortTable[0x8CBA]=12434;   // kuang
   sortTable[0x8EE6]=12435;   // kuang
   sortTable[0x9271]=12436;   // kuang
   sortTable[0x4E8F]=12437;   // kui
   sortTable[0x8667]=12438;   // kui
   sortTable[0x6127]=12439;   // kui
   sortTable[0x76D4]=12440;   // kui
   sortTable[0x8475]=12441;   // kui
   sortTable[0x6E83]=12442;   // kui
   sortTable[0x6F70]=12443;   // kui
   sortTable[0x9B41]=12444;   // kui
   sortTable[0x9988]=12445;   // kui
   sortTable[0x7AA5]=12446;   // kui
   sortTable[0x594E]=12447;   // kui
   sortTable[0x9035]=12448;   // kui
   sortTable[0x5914]=12449;   // kui
   sortTable[0x532E]=12450;   // kui
   sortTable[0x63C6]=12451;   // kui
   sortTable[0x9697]=12452;   // kui
   sortTable[0x559F]=12453;   // kui
   sortTable[0x9997]=12454;   // kui
   sortTable[0x668C]=12455;   // kui
   sortTable[0x777D]=12456;   // kui
   sortTable[0x6126]=12457;   // kui
   sortTable[0x8DEC]=12458;   // kui
   sortTable[0x8069]=12459;   // kui
   sortTable[0x5CBF]=12460;   // kui
   sortTable[0x609D]=12461;   // kui
   sortTable[0x7BD1]=12462;   // kui
   sortTable[0x8489]=12463;   // kui
   sortTable[0x9A99]=12464;   // kui
   sortTable[0x55B9]=12465;   // kui
   sortTable[0x980D]=12466;   // kui
   sortTable[0x8770]=12467;   // kui
   sortTable[0x993D]=12468;   // kui
   sortTable[0x985D]=12469;   // kui
   sortTable[0x806D]=12470;   // kui
   sortTable[0x7786]=12471;   // kui
   sortTable[0x95DA]=12472;   // kui
   sortTable[0x994B]=12473;   // kui
   sortTable[0x8E5E]=12474;   // kui
   sortTable[0x7C44]=12475;   // kui
   sortTable[0x8067]=12476;   // kui
   sortTable[0x9400]=12477;   // kui
   sortTable[0x9804]=12478;   // kui
   sortTable[0x9A24]=12479;   // kui
   sortTable[0x8143]=12480;   // kui
   sortTable[0x8075]=12481;   // kui
   sortTable[0x8562]=12482;   // kui
   sortTable[0x9108]=12483;   // kui
   sortTable[0x85C8]=12484;   // kui
   sortTable[0x862C]=12485;   // kui
   sortTable[0x8641]=12486;   // kui
   sortTable[0x8EA8]=12487;   // kui
   sortTable[0x9368]=12488;   // kui
   sortTable[0x5232]=12489;   // kui
   sortTable[0x5633]=12490;   // kui
   sortTable[0x5ABF]=12491;   // kui
   sortTable[0x5B07]=12492;   // kui
   sortTable[0x5C2F]=12493;   // kui
   sortTable[0x5DCB]=12494;   // kui
   sortTable[0x5DD9]=12495;   // kui
   sortTable[0x6192]=12496;   // kui
   sortTable[0x6223]=12497;   // kui
   sortTable[0x6646]=12498;   // kui
   sortTable[0x694F]=12499;   // kui
   sortTable[0x6951]=12500;   // kui
   sortTable[0x6A3B]=12501;   // kui
   sortTable[0x6AC6]=12502;   // kui
   sortTable[0x6B33]=12503;   // kui
   sortTable[0x7143]=12504;   // kui
   sortTable[0x72AA]=12505;   // kui
   sortTable[0x7ABA]=12506;   // kui
   sortTable[0x7C23]=12507;   // kui
   sortTable[0x8637]=12508;   // kui
   sortTable[0x8B09]=12509;   // kui
   sortTable[0x9377]=12510;   // kui
   sortTable[0x944E]=12511;   // kui
   sortTable[0x982F]=12512;   // kui
   sortTable[0x56F0]=12513;   // kun
   sortTable[0x6606]=12514;   // kun
   sortTable[0x6346]=12515;   // kun
   sortTable[0x5764]=12516;   // kun
   sortTable[0x7428]=12517;   // kun
   sortTable[0x9AE1]=12518;   // kun
   sortTable[0x9603]=12519;   // kun
   sortTable[0x951F]=12520;   // kun
   sortTable[0x9CB2]=12521;   // kun
   sortTable[0x6083]=12522;   // kun
   sortTable[0x9E4D]=12523;   // kun
   sortTable[0x918C]=12524;   // kun
   sortTable[0x7871]=12525;   // kun
   sortTable[0x88C8]=12526;   // kun
   sortTable[0x890C]=12527;   // kun
   sortTable[0x774F]=12528;   // kun
   sortTable[0x88E9]=12529;   // kun
   sortTable[0x9AE0]=12530;   // kun
   sortTable[0x7A1B]=12531;   // kun
   sortTable[0x7D91]=12532;   // kun
   sortTable[0x9A09]=12533;   // kun
   sortTable[0x9AE8]=12534;   // kun
   sortTable[0x7A07]=12535;   // kun
   sortTable[0x83CE]=12536;   // kun
   sortTable[0x872B]=12537;   // kun
   sortTable[0x9BE4]=12538;   // kun
   sortTable[0x9DA4]=12539;   // kun
   sortTable[0x95B8]=12540;   // kun
   sortTable[0x5803]=12541;   // kun
   sortTable[0x5812]=12542;   // kun
   sortTable[0x58F8]=12543;   // kun
   sortTable[0x58FC]=12544;   // kun
   sortTable[0x5A6B]=12545;   // kun
   sortTable[0x5C21]=12546;   // kun
   sortTable[0x5D10]=12547;   // kun
   sortTable[0x5D11]=12548;   // kun
   sortTable[0x665C]=12549;   // kun
   sortTable[0x68B1]=12550;   // kun
   sortTable[0x6D83]=12551;   // kun
   sortTable[0x6F49]=12552;   // kun
   sortTable[0x711C]=12553;   // kun
   sortTable[0x71B4]=12554;   // kun
   sortTable[0x7311]=12555;   // kun
   sortTable[0x747B]=12556;   // kun
   sortTable[0x7975]=12557;   // kun
   sortTable[0x88CD]=12558;   // kun
   sortTable[0x8C87]=12559;   // kun
   sortTable[0x9315]=12560;   // kun
   sortTable[0x95AB]=12561;   // kun
   sortTable[0x9D7E]=12562;   // kun
   sortTable[0x9F6B]=12563;   // kun
   sortTable[0x62EC]=12564;   // kuo
   sortTable[0x6269]=12565;   // kuo
   sortTable[0x64F4]=12566;   // kuo
   sortTable[0x9614]=12567;   // kuo
   sortTable[0x95CA]=12568;   // kuo
   sortTable[0x5ED3]=12569;   // kuo
   sortTable[0x86DE]=12570;   // kuo
   sortTable[0x7B48]=12571;   // kuo
   sortTable[0x97B9]=12572;   // kuo
   sortTable[0x979F]=12573;   // kuo
   sortTable[0x9729]=12574;   // kuo
   sortTable[0x9B20]=12575;   // kuo
   sortTable[0x843F]=12576;   // kuo
   sortTable[0x9AFA]=12577;   // kuo
   sortTable[0x61D6]=12578;   // kuo
   sortTable[0x62E1]=12579;   // kuo
   sortTable[0x6304]=12580;   // kuo
   sortTable[0x6870]=12581;   // kuo
   sortTable[0x6FF6]=12582;   // kuo
   sortTable[0x8440]=12583;   // kuo
   sortTable[0x97D5]=12584;   // kuo
   sortTable[0x9822]=12585;   // kuo
   sortTable[0x5566]=13056;   // la
   sortTable[0x62C9]=13057;   // la
   sortTable[0x8721]=13058;   // la
   sortTable[0x881F]=13059;   // la
   sortTable[0x5783]=13060;   // la
   sortTable[0x5587]=13061;   // la
   sortTable[0x8FA3]=13062;   // la
   sortTable[0x814A]=13063;   // la
   sortTable[0x524C]=13064;   // la
   sortTable[0x65EF]=13065;   // la
   sortTable[0x782C]=13066;   // la
   sortTable[0x908B]=13067;   // la
   sortTable[0x760C]=13068;   // la
   sortTable[0x9574]=13069;   // la
   sortTable[0x97A1]=13070;   // la
   sortTable[0x81C8]=13071;   // la
   sortTable[0x85DE]=13072;   // la
   sortTable[0x78D6]=13073;   // la
   sortTable[0x7FCB]=13074;   // la
   sortTable[0x81D8]=13075;   // la
   sortTable[0x83C8]=13076;   // la
   sortTable[0x8772]=13077;   // la
   sortTable[0x8FA2]=13078;   // la
   sortTable[0x9B0E]=13079;   // la
   sortTable[0x56B9]=13080;   // la
   sortTable[0x63E6]=13081;   // la
   sortTable[0x63E7]=13082;   // la
   sortTable[0x641A]=13083;   // la
   sortTable[0x650B]=13084;   // la
   sortTable[0x67C6]=13085;   // la
   sortTable[0x694B]=13086;   // la
   sortTable[0x6E82]=13087;   // la
   sortTable[0x7209]=13088;   // la
   sortTable[0x74CE]=13089;   // la
   sortTable[0x874B]=13090;   // la
   sortTable[0x945E]=13091;   // la
   sortTable[0x9BFB]=13092;   // la
   sortTable[0x6765]=13093;   // lai
   sortTable[0x4F86]=13094;   // lai
   sortTable[0x8D56]=13095;   // lai
   sortTable[0x8CF4]=13096;   // lai
   sortTable[0x83B1]=13097;   // lai
   sortTable[0x6D9E]=13098;   // lai
   sortTable[0x8D49]=13099;   // lai
   sortTable[0x765E]=13100;   // lai
   sortTable[0x7C41]=13101;   // lai
   sortTable[0x7750]=13102;   // lai
   sortTable[0x6FD1]=13103;   // lai
   sortTable[0x5D03]=13104;   // lai
   sortTable[0x5F95]=13105;   // lai
   sortTable[0x7C5F]=13106;   // lai
   sortTable[0x94FC]=13107;   // lai
   sortTable[0x90F2]=13108;   // lai
   sortTable[0x9A0B]=13109;   // lai
   sortTable[0x85FE]=13110;   // lai
   sortTable[0x775E]=13111;   // lai
   sortTable[0x9BE0]=13112;   // lai
   sortTable[0x9D63]=13113;   // lai
   sortTable[0x9D86]=13114;   // lai
   sortTable[0x840A]=13115;   // lai
   sortTable[0x9028]=13116;   // lai
   sortTable[0x983C]=13117;   // lai
   sortTable[0x8CDA]=13118;   // lai
   sortTable[0x4FEB]=13119;   // lai
   sortTable[0x5008]=13120;   // lai
   sortTable[0x553B]=13121;   // lai
   sortTable[0x5A61]=13122;   // lai
   sortTable[0x5D0D]=13123;   // lai
   sortTable[0x5EB2]=13124;   // lai
   sortTable[0x5FA0]=13125;   // lai
   sortTable[0x68BE]=13126;   // lai
   sortTable[0x68F6]=13127;   // lai
   sortTable[0x6AF4]=13128;   // lai
   sortTable[0x6DF6]=13129;   // lai
   sortTable[0x7028]=13130;   // lai
   sortTable[0x702C]=13131;   // lai
   sortTable[0x730D]=13132;   // lai
   sortTable[0x741C]=13133;   // lai
   sortTable[0x7669]=13134;   // lai
   sortTable[0x7B59]=13135;   // lai
   sortTable[0x7B82]=13136;   // lai
   sortTable[0x8970]=13137;   // lai
   sortTable[0x9338]=13138;   // lai
   sortTable[0x9842]=13139;   // lai
   sortTable[0x9EB3]=13140;   // lai
   sortTable[0x84DD]=13141;   // lan
   sortTable[0x70C2]=13142;   // lan
   sortTable[0x85CD]=13143;   // lan
   sortTable[0x721B]=13144;   // lan
   sortTable[0x7BEE]=13145;   // lan
   sortTable[0x7C43]=13146;   // lan
   sortTable[0x62E6]=13147;   // lan
   sortTable[0x6514]=13148;   // lan
   sortTable[0x89C8]=13149;   // lan
   sortTable[0x89BD]=13150;   // lan
   sortTable[0x680F]=13151;   // lan
   sortTable[0x6B04]=13152;   // lan
   sortTable[0x61D2]=13153;   // lan
   sortTable[0x61F6]=13154;   // lan
   sortTable[0x6EE5]=13155;   // lan
   sortTable[0x6FEB]=13156;   // lan
   sortTable[0x5170]=13157;   // lan
   sortTable[0x5C9A]=13158;   // lan
   sortTable[0x6F9C]=13159;   // lan
   sortTable[0x63FD]=13160;   // lan
   sortTable[0x7F06]=13161;   // lan
   sortTable[0x9611]=13162;   // lan
   sortTable[0x5A6A]=13163;   // lan
   sortTable[0x6593]=13164;   // lan
   sortTable[0x6984]=13165;   // lan
   sortTable[0x7F71]=13166;   // lan
   sortTable[0x8C30]=13167;   // lan
   sortTable[0x8934]=13168;   // lan
   sortTable[0x8955]=13169;   // lan
   sortTable[0x9567]=13170;   // lan
   sortTable[0x6F24]=13171;   // lan
   sortTable[0x862D]=13172;   // lan
   sortTable[0x8B95]=13173;   // lan
   sortTable[0x847B]=13174;   // lan
   sortTable[0x8974]=13175;   // lan
   sortTable[0x7CF7]=13176;   // lan
   sortTable[0x7E7F]=13177;   // lan
   sortTable[0x7C63]=13178;   // lan
   sortTable[0x897D]=13179;   // lan
   sortTable[0x8B4B]=13180;   // lan
   sortTable[0x8E9D]=13181;   // lan
   sortTable[0x9484]=13182;   // lan
   sortTable[0x95CC]=13183;   // lan
   sortTable[0x9872]=13184;   // lan
   sortTable[0x5116]=13185;   // lan
   sortTable[0x53B1]=13186;   // lan
   sortTable[0x5682]=13187;   // lan
   sortTable[0x56D2]=13188;   // lan
   sortTable[0x56D5]=13189;   // lan
   sortTable[0x58C8]=13190;   // lan
   sortTable[0x5B3E]=13191;   // lan
   sortTable[0x5B44]=13192;   // lan
   sortTable[0x5B4F]=13193;   // lan
   sortTable[0x5D50]=13194;   // lan
   sortTable[0x5E71]=13195;   // lan
   sortTable[0x60CF]=13196;   // lan
   sortTable[0x61E2]=13197;   // lan
   sortTable[0x64E5]=13198;   // lan
   sortTable[0x652C]=13199;   // lan
   sortTable[0x6595]=13200;   // lan
   sortTable[0x6B16]=13201;   // lan
   sortTable[0x6B17]=13202;   // lan
   sortTable[0x6D68]=13203;   // lan
   sortTable[0x703E]=13204;   // lan
   sortTable[0x7046]=13205;   // lan
   sortTable[0x7060]=13206;   // lan
   sortTable[0x7061]=13207;   // lan
   sortTable[0x71D7]=13208;   // lan
   sortTable[0x71E3]=13209;   // lan
   sortTable[0x71F7]=13210;   // lan
   sortTable[0x7201]=13211;   // lan
   sortTable[0x7224]=13212;   // lan
   sortTable[0x7226]=13213;   // lan
   sortTable[0x74BC]=13214;   // lan
   sortTable[0x74D3]=13215;   // lan
   sortTable[0x7937]=13216;   // lan
   sortTable[0x7E9C]=13217;   // lan
   sortTable[0x8964]=13218;   // lan
   sortTable[0x89A7]=13219;   // lan
   sortTable[0x9182]=13220;   // lan
   sortTable[0x946D]=13221;   // lan
   sortTable[0x97CA]=13222;   // lan
   sortTable[0x6D6A]=13223;   // lang
   sortTable[0x72FC]=13224;   // lang
   sortTable[0x6717]=13225;   // lang
   sortTable[0x90CE]=13226;   // lang
   sortTable[0x5ECA]=13227;   // lang
   sortTable[0x7405]=13228;   // lang
   sortTable[0x9606]=13229;   // lang
   sortTable[0x8782]=13230;   // lang
   sortTable[0x6994]=13231;   // lang
   sortTable[0x9512]=13232;   // lang
   sortTable[0x83A8]=13233;   // lang
   sortTable[0x5577]=13234;   // lang
   sortTable[0x93AF]=13235;   // lang
   sortTable[0x8497]=13236;   // lang
   sortTable[0x7A02]=13237;   // lang
   sortTable[0x7B64]=13238;   // lang
   sortTable[0x870B]=13239;   // lang
   sortTable[0x7860]=13240;   // lang
   sortTable[0x8246]=13241;   // lang
   sortTable[0x90DE]=13242;   // lang
   sortTable[0x95AC]=13243;   // lang
   sortTable[0x84E2]=13244;   // lang
   sortTable[0x99FA]=13245;   // lang
   sortTable[0x52C6]=13246;   // lang
   sortTable[0x5525]=13247;   // lang
   sortTable[0x57CC]=13248;   // lang
   sortTable[0x5871]=13249;   // lang
   sortTable[0x5ACF]=13250;   // lang
   sortTable[0x5D00]=13251;   // lang
   sortTable[0x658F]=13252;   // lang
   sortTable[0x6716]=13253;   // lang
   sortTable[0x6724]=13254;   // lang
   sortTable[0x6879]=13255;   // lang
   sortTable[0x6A03]=13256;   // lang
   sortTable[0x6B34]=13257;   // lang
   sortTable[0x70FA]=13258;   // lang
   sortTable[0x746F]=13259;   // lang
   sortTable[0x84C8]=13260;   // lang
   sortTable[0x8A8F]=13261;   // lang
   sortTable[0x8EB4]=13262;   // lang
   sortTable[0x90D2]=13263;   // lang
   sortTable[0x92C3]=13264;   // lang
   sortTable[0x8001]=13265;   // lao
   sortTable[0x52B3]=13266;   // lao
   sortTable[0x52DE]=13267;   // lao
   sortTable[0x635E]=13268;   // lao
   sortTable[0x6488]=13269;   // lao
   sortTable[0x7262]=13270;   // lao
   sortTable[0x59E5]=13271;   // lao
   sortTable[0x6F66]=13272;   // lao
   sortTable[0x70D9]=13273;   // lao
   sortTable[0x916A]=13274;   // lao
   sortTable[0x4F6C]=13275;   // lao
   sortTable[0x5520]=13276;   // lao
   sortTable[0x6D9D]=13277;   // lao
   sortTable[0x91AA]=13278;   // lao
   sortTable[0x5D02]=13279;   // lao
   sortTable[0x75E8]=13280;   // lao
   sortTable[0x6833]=13281;   // lao
   sortTable[0x94D1]=13282;   // lao
   sortTable[0x8022]=13283;   // lao
   sortTable[0x985F]=13284;   // lao
   sortTable[0x7CA9]=13285;   // lao
   sortTable[0x8EBC]=13286;   // lao
   sortTable[0x86EF]=13287;   // lao
   sortTable[0x8F51]=13288;   // lao
   sortTable[0x94F9]=13289;   // lao
   sortTable[0x8356]=13290;   // lao
   sortTable[0x87E7]=13291;   // lao
   sortTable[0x78F1]=13292;   // lao
   sortTable[0x7C29]=13293;   // lao
   sortTable[0x802E]=13294;   // lao
   sortTable[0x9BB1]=13295;   // lao
   sortTable[0x50D7]=13296;   // lao
   sortTable[0x52B4]=13297;   // lao
   sortTable[0x54BE]=13298;   // lao
   sortTable[0x54F0]=13299;   // lao
   sortTable[0x562E]=13300;   // lao
   sortTable[0x5AEA]=13301;   // lao
   sortTable[0x5D97]=13302;   // lao
   sortTable[0x6045]=13303;   // lao
   sortTable[0x61A5]=13304;   // lao
   sortTable[0x61A6]=13305;   // lao
   sortTable[0x6725]=13306;   // lao
   sortTable[0x6A51]=13307;   // lao
   sortTable[0x6A6F]=13308;   // lao
   sortTable[0x6D76]=13309;   // lao
   sortTable[0x6F87]=13310;   // lao
   sortTable[0x72EB]=13311;   // lao
   sortTable[0x73EF]=13312;   // lao
   sortTable[0x7646]=13313;   // lao
   sortTable[0x7853]=13314;   // lao
   sortTable[0x7A82]=13315;   // lao
   sortTable[0x8002]=13316;   // lao
   sortTable[0x8EC2]=13317;   // lao
   sortTable[0x92A0]=13318;   // lao
   sortTable[0x9412]=13319;   // lao
   sortTable[0x9ADD]=13320;   // lao
   sortTable[0x4E86]=13321;   // le
   sortTable[0x4E50]=13322;   // le
   sortTable[0x6A02]=13323;   // le
   sortTable[0x808B]=13324;   // le
   sortTable[0x53FB]=13325;   // le
   sortTable[0x6CD0]=13326;   // le
   sortTable[0x4EC2]=13327;   // le
   sortTable[0x9979]=13328;   // le
   sortTable[0x9CD3]=13329;   // le
   sortTable[0x7C15]=13330;   // le
   sortTable[0x97F7]=13331;   // le
   sortTable[0x961E]=13332;   // le
   sortTable[0x7AFB]=13333;   // le
   sortTable[0x9C33]=13334;   // le
   sortTable[0x5FC7]=13335;   // le
   sortTable[0x6250]=13336;   // le
   sortTable[0x697D]=13337;   // le
   sortTable[0x6C3B]=13338;   // le
   sortTable[0x738F]=13339;   // le
   sortTable[0x7833]=13340;   // le
   sortTable[0x827B]=13341;   // le
   sortTable[0x990E]=13342;   // le
   sortTable[0x7C7B]=13343;   // lei
   sortTable[0x985E]=13344;   // lei
   sortTable[0x6CEA]=13345;   // lei
   sortTable[0x6DDA]=13346;   // lei
   sortTable[0x7D2F]=13347;   // lei
   sortTable[0x96F7]=13348;   // lei
   sortTable[0x5792]=13349;   // lei
   sortTable[0x58D8]=13350;   // lei
   sortTable[0x52D2]=13351;   // lei
   sortTable[0x78CA]=13352;   // lei
   sortTable[0x64C2]=13353;   // lei
   sortTable[0x8BD4]=13354;   // lei
   sortTable[0x857E]=13355;   // lei
   sortTable[0x5121]=13356;   // lei
   sortTable[0x7FB8]=13357;   // lei
   sortTable[0x8012]=13358;   // lei
   sortTable[0x956D]=13359;   // lei
   sortTable[0x5AD8]=13360;   // lei
   sortTable[0x561E]=13361;   // lei
   sortTable[0x7F4D]=13362;   // lei
   sortTable[0x7F27]=13363;   // lei
   sortTable[0x9179]=13364;   // lei
   sortTable[0x790C]=13365;   // lei
   sortTable[0x7D6B]=13366;   // lei
   sortTable[0x85DF]=13367;   // lei
   sortTable[0x98A3]=13368;   // lei
   sortTable[0x7927]=13369;   // lei
   sortTable[0x9287]=13370;   // lei
   sortTable[0x6A91]=13371;   // lei
   sortTable[0x78E5]=13372;   // lei
   sortTable[0x8502]=13373;   // lei
   sortTable[0x8646]=13374;   // lei
   sortTable[0x881D]=13375;   // lei
   sortTable[0x7E8D]=13376;   // lei
   sortTable[0x7928]=13377;   // lei
   sortTable[0x8142]=13378;   // lei
   sortTable[0x7E32]=13379;   // lei
   sortTable[0x854C]=13380;   // lei
   sortTable[0x8631]=13381;   // lei
   sortTable[0x9433]=13382;   // lei
   sortTable[0x9458]=13383;   // lei
   sortTable[0x9478]=13384;   // lei
   sortTable[0x9E13]=13385;   // lei
   sortTable[0x50AB]=13386;   // lei
   sortTable[0x513D]=13387;   // lei
   sortTable[0x53BD]=13388;   // lei
   sortTable[0x5841]=13389;   // lei
   sortTable[0x58E8]=13390;   // lei
   sortTable[0x6502]=13391;   // lei
   sortTable[0x6A0F]=13392;   // lei
   sortTable[0x6AD0]=13393;   // lei
   sortTable[0x6AD1]=13394;   // lei
   sortTable[0x6B19]=13395;   // lei
   sortTable[0x6D21]=13396;   // lei
   sortTable[0x6D99]=13397;   // lei
   sortTable[0x7045]=13398;   // lei
   sortTable[0x74C3]=13399;   // lei
   sortTable[0x757E]=13400;   // lei
   sortTable[0x7657]=13401;   // lei
   sortTable[0x79B7]=13402;   // lei
   sortTable[0x7E87]=13403;   // lei
   sortTable[0x7E9D]=13404;   // lei
   sortTable[0x8632]=13405;   // lei
   sortTable[0x863D]=13406;   // lei
   sortTable[0x8A84]=13407;   // lei
   sortTable[0x8B84]=13408;   // lei
   sortTable[0x8F60]=13409;   // lei
   sortTable[0x9311]=13410;   // lei
   sortTable[0x9741]=13411;   // lei
   sortTable[0x981B]=13412;   // lei
   sortTable[0x982A]=13413;   // lei
   sortTable[0x9C69]=13414;   // lei
   sortTable[0x9F3A]=13415;   // lei
   sortTable[0x51B7]=13416;   // leng
   sortTable[0x6123]=13417;   // leng
   sortTable[0x68F1]=13418;   // leng
   sortTable[0x695E]=13419;   // leng
   sortTable[0x7A1C]=13420;   // leng
   sortTable[0x5844]=13421;   // leng
   sortTable[0x7756]=13422;   // leng
   sortTable[0x8590]=13423;   // leng
   sortTable[0x8F18]=13424;   // leng
   sortTable[0x8E1C]=13425;   // leng
   sortTable[0x5030]=13426;   // leng
   sortTable[0x580E]=13427;   // leng
   sortTable[0x5D1A]=13428;   // leng
   sortTable[0x7890]=13429;   // leng
   sortTable[0x91CC]=13430;   // li
   sortTable[0x529B]=13431;   // li
   sortTable[0x7406]=13432;   // li
   sortTable[0x5229]=13433;   // li
   sortTable[0x7ACB]=13434;   // li
   sortTable[0x5386]=13435;   // li
   sortTable[0x6B77]=13436;   // li
   sortTable[0x79BB]=13437;   // li
   sortTable[0x96E2]=13438;   // li
   sortTable[0x88E1]=13439;   // li
   sortTable[0x4F8B]=13440;   // li
   sortTable[0x54E9]=13441;   // li
   sortTable[0x4E3D]=13442;   // li
   sortTable[0x9E97]=13443;   // li
   sortTable[0x7483]=13444;   // li
   sortTable[0x5389]=13445;   // li
   sortTable[0x53B2]=13446;   // li
   sortTable[0x793C]=13447;   // li
   sortTable[0x79AE]=13448;   // li
   sortTable[0x7C92]=13449;   // li
   sortTable[0x52B1]=13450;   // li
   sortTable[0x52F5]=13451;   // li
   sortTable[0x96B6]=13452;   // li
   sortTable[0x96B8]=13453;   // li
   sortTable[0x5398]=13454;   // li
   sortTable[0x674E]=13455;   // li
   sortTable[0x9ECE]=13456;   // li
   sortTable[0x8354]=13457;   // li
   sortTable[0x6CA5]=13458;   // li
   sortTable[0x701D]=13459;   // li
   sortTable[0x72F8]=13460;   // li
   sortTable[0x7BF1]=13461;   // li
   sortTable[0x7C6C]=13462;   // li
   sortTable[0x68A8]=13463;   // li
   sortTable[0x9E42]=13464;   // li
   sortTable[0x9E1D]=13465;   // li
   sortTable[0x9CA4]=13466;   // li
   sortTable[0x9BC9]=13467;   // li
   sortTable[0x7281]=13468;   // li
   sortTable[0x783E]=13469;   // li
   sortTable[0x792B]=13470;   // li
   sortTable[0x540F]=13471;   // li
   sortTable[0x8389]=13472;   // li
   sortTable[0x6817]=13473;   // li
   sortTable[0x4FDA]=13474;   // li
   sortTable[0x7B20]=13475;   // li
   sortTable[0x7F79]=13476;   // li
   sortTable[0x91B4]=13477;   // li
   sortTable[0x623E]=13478;   // li
   sortTable[0x8821]=13479;   // li
   sortTable[0x6F13]=13480;   // li
   sortTable[0x4FD0]=13481;   // li
   sortTable[0x8A48]=13482;   // li
   sortTable[0x96F3]=13483;   // li
   sortTable[0x75E2]=13484;   // li
   sortTable[0x8385]=13485;   // li
   sortTable[0x85DC]=13486;   // li
   sortTable[0x4FEA]=13487;   // li
   sortTable[0x9A8A]=13488;   // li
   sortTable[0x783A]=13489;   // li
   sortTable[0x9026]=13490;   // li
   sortTable[0x6FA7]=13491;   // li
   sortTable[0x91D0]=13492;   // li
   sortTable[0x90E6]=13493;   // li
   sortTable[0x7C9D]=13494;   // li
   sortTable[0x86CE]=13495;   // li
   sortTable[0x5AE0]=13496;   // li
   sortTable[0x680E]=13497;   // li
   sortTable[0x8DDE]=13498;   // li
   sortTable[0x7F21]=13499;   // li
   sortTable[0x5A0C]=13500;   // li
   sortTable[0x75A0]=13501;   // li
   sortTable[0x6EA7]=13502;   // li
   sortTable[0x67A5]=13503;   // li
   sortTable[0x5456]=13504;   // li
   sortTable[0x5533]=13505;   // li
   sortTable[0x870A]=13506;   // li
   sortTable[0x82C8]=13507;   // li
   sortTable[0x9502]=13508;   // li
   sortTable[0x8F79]=13509;   // li
   sortTable[0x7BE5]=13510;   // li
   sortTable[0x5088]=13511;   // li
   sortTable[0x9CA1]=13512;   // li
   sortTable[0x9EE7]=13513;   // li
   sortTable[0x9CE2]=13514;   // li
   sortTable[0x8C4A]=13515;   // li
   sortTable[0x55B1]=13516;   // li
   sortTable[0x7E9A]=13517;   // li
   sortTable[0x7301]=13518;   // li
   sortTable[0x7D9F]=13519;   // li
   sortTable[0x84E0]=13520;   // li
   sortTable[0x8935]=13521;   // li
   sortTable[0x75AC]=13522;   // li
   sortTable[0x76ED]=13523;   // li
   sortTable[0x9C67]=13524;   // li
   sortTable[0x8C8D]=13525;   // li
   sortTable[0x8243]=13526;   // li
   sortTable[0x91A8]=13527;   // li
   sortTable[0x78FF]=13528;   // li
   sortTable[0x7CB4]=13529;   // li
   sortTable[0x9E9C]=13530;   // li
   sortTable[0x575C]=13531;   // li
   sortTable[0x82D9]=13532;   // li
   sortTable[0x7C9A]=13533;   // li
   sortTable[0x9BCF]=13534;   // li
   sortTable[0x7805]=13535;   // li
   sortTable[0x8B88]=13536;   // li
   sortTable[0x88CF]=13537;   // li
   sortTable[0x86E0]=13538;   // li
   sortTable[0x908C]=13539;   // li
   sortTable[0x8137]=13540;   // li
   sortTable[0x83DE]=13541;   // li
   sortTable[0x8B27]=13542;   // li
   sortTable[0x92EB]=13543;   // li
   sortTable[0x849E]=13544;   // li
   sortTable[0x85F6]=13545;   // li
   sortTable[0x9B01]=13546;   // li
   sortTable[0x8823]=13547;   // li
   sortTable[0x7CF2]=13548;   // li
   sortTable[0x8318]=13549;   // li
   sortTable[0x849A]=13550;   // li
   sortTable[0x8727]=13551;   // li
   sortTable[0x89FB]=13552;   // li
   sortTable[0x8F63]=13553;   // li
   sortTable[0x9305]=13554;   // li
   sortTable[0x76E0]=13555;   // li
   sortTable[0x7A72]=13556;   // li
   sortTable[0x7B63]=13557;   // li
   sortTable[0x86B8]=13558;   // li
   sortTable[0x8D72]=13559;   // li
   sortTable[0x8E92]=13560;   // li
   sortTable[0x925D]=13561;   // li
   sortTable[0x92F0]=13562;   // li
   sortTable[0x9398]=13563;   // li
   sortTable[0x9BEC]=13564;   // li
   sortTable[0x9C73]=13565;   // li
   sortTable[0x9C7A]=13566;   // li
   sortTable[0x9D17]=13567;   // li
   sortTable[0x512E]=13568;   // li
   sortTable[0x5137]=13569;   // li
   sortTable[0x5163]=13570;   // li
   sortTable[0x51D3]=13571;   // li
   sortTable[0x5215]=13572;   // li
   sortTable[0x5253]=13573;   // li
   sortTable[0x527A]=13574;   // li
   sortTable[0x5299]=13575;   // li
   sortTable[0x53A4]=13576;   // li
   sortTable[0x53AF]=13577;   // li
   sortTable[0x550E]=13578;   // li
   sortTable[0x569F]=13579;   // li
   sortTable[0x56A6]=13580;   // li
   sortTable[0x56C4]=13581;   // li
   sortTable[0x56C7]=13582;   // li
   sortTable[0x585B]=13583;   // li
   sortTable[0x58E2]=13584;   // li
   sortTable[0x5A33]=13585;   // li
   sortTable[0x5A6F]=13586;   // li
   sortTable[0x5B4B]=13587;   // li
   sortTable[0x5B77]=13588;   // li
   sortTable[0x5C74]=13589;   // li
   sortTable[0x5CA6]=13590;   // li
   sortTable[0x5CDB]=13591;   // li
   sortTable[0x5CE2]=13592;   // li
   sortTable[0x5CF2]=13593;   // li
   sortTable[0x5DC1]=13594;   // li
   sortTable[0x5EF2]=13595;   // li
   sortTable[0x60A1]=13596;   // li
   sortTable[0x60A7]=13597;   // li
   sortTable[0x6144]=13598;   // li
   sortTable[0x642E]=13599;   // li
   sortTable[0x650A]=13600;   // li
   sortTable[0x6521]=13601;   // li
   sortTable[0x6526]=13602;   // li
   sortTable[0x652D]=13603;   // li
   sortTable[0x6584]=13604;   // li
   sortTable[0x66A6]=13605;   // li
   sortTable[0x66C6]=13606;   // li
   sortTable[0x66DE]=13607;   // li
   sortTable[0x6738]=13608;   // li
   sortTable[0x675D]=13609;   // li
   sortTable[0x6803]=13610;   // li
   sortTable[0x681B]=13611;   // li
   sortTable[0x68A9]=13612;   // li
   sortTable[0x68B8]=13613;   // li
   sortTable[0x68C3]=13614;   // li
   sortTable[0x68D9]=13615;   // li
   sortTable[0x6A06]=13616;   // li
   sortTable[0x6AAA]=13617;   // li
   sortTable[0x6AD4]=13618;   // li
   sortTable[0x6ADF]=13619;   // li
   sortTable[0x6AEA]=13620;   // li
   sortTable[0x6B10]=13621;   // li
   sortTable[0x6B1A]=13622;   // li
   sortTable[0x6B74]=13623;   // li
   sortTable[0x6CB4]=13624;   // li
   sortTable[0x6D6C]=13625;   // li
   sortTable[0x6D96]=13626;   // li
   sortTable[0x6FFF]=13627;   // li
   sortTable[0x7055]=13628;   // li
   sortTable[0x7204]=13629;   // li
   sortTable[0x720F]=13630;   // li
   sortTable[0x7282]=13631;   // li
   sortTable[0x72A1]=13632;   // li
   sortTable[0x73D5]=13633;   // li
   sortTable[0x740D]=13634;   // li
   sortTable[0x746E]=13635;   // li
   sortTable[0x74C5]=13636;   // li
   sortTable[0x74C8]=13637;   // li
   sortTable[0x74D1]=13638;   // li
   sortTable[0x74E5]=13639;   // li
   sortTable[0x7658]=13640;   // li
   sortTable[0x7667]=13641;   // li
   sortTable[0x76AA]=13642;   // li
   sortTable[0x775D]=13643;   // li
   sortTable[0x77CB]=13644;   // li
   sortTable[0x792A]=13645;   // li
   sortTable[0x7930]=13646;   // li
   sortTable[0x79B2]=13647;   // li
   sortTable[0x79DD]=13648;   // li
   sortTable[0x7CCE]=13649;   // li
   sortTable[0x7E2D]=13650;   // li
   sortTable[0x8372]=13651;   // li
   sortTable[0x853E]=13652;   // li
   sortTable[0x863A]=13653;   // li
   sortTable[0x8777]=13654;   // li
   sortTable[0x87CD]=13655;   // li
   sortTable[0x87F8]=13656;   // li
   sortTable[0x8807]=13657;   // li
   sortTable[0x882B]=13658;   // li
   sortTable[0x8F62]=13659;   // li
   sortTable[0x9090]=13660;   // li
   sortTable[0x9148]=13661;   // li
   sortTable[0x93EB]=13662;   // li
   sortTable[0x9457]=13663;   // li
   sortTable[0x96B7]=13664;   // li
   sortTable[0x9742]=13665;   // li
   sortTable[0x974B]=13666;   // li
   sortTable[0x9A39]=13667;   // li
   sortTable[0x9A6A]=13668;   // li
   sortTable[0x9C71]=13669;   // li
   sortTable[0x9CE8]=13670;   // li
   sortTable[0x9D79]=13671;   // li
   sortTable[0x9DC5]=13672;   // li
   sortTable[0x4FE9]=13673;   // lia
   sortTable[0x5006]=13674;   // lia
   sortTable[0x8FDE]=13675;   // lian
   sortTable[0x9023]=13676;   // lian
   sortTable[0x8138]=13677;   // lian
   sortTable[0x81C9]=13678;   // lian
   sortTable[0x8054]=13679;   // lian
   sortTable[0x806F]=13680;   // lian
   sortTable[0x70BC]=13681;   // lian
   sortTable[0x7149]=13682;   // lian
   sortTable[0x7EC3]=13683;   // lian
   sortTable[0x7DF4]=13684;   // lian
   sortTable[0x601C]=13685;   // lian
   sortTable[0x6190]=13686;   // lian
   sortTable[0x5E18]=13687;   // lian
   sortTable[0x9570]=13688;   // lian
   sortTable[0x942E]=13689;   // lian
   sortTable[0x5EC9]=13690;   // lian
   sortTable[0x604B]=13691;   // lian
   sortTable[0x6200]=13692;   // lian
   sortTable[0x94FE]=13693;   // lian
   sortTable[0x93C8]=13694;   // lian
   sortTable[0x83B2]=13695;   // lian
   sortTable[0x655B]=13696;   // lian
   sortTable[0x740F]=13697;   // lian
   sortTable[0x6D9F]=13698;   // lian
   sortTable[0x6B93]=13699;   // lian
   sortTable[0x81C1]=13700;   // lian
   sortTable[0x5941]=13701;   // lian
   sortTable[0x6FC2]=13702;   // lian
   sortTable[0x880A]=13703;   // lian
   sortTable[0x88E2]=13704;   // lian
   sortTable[0x88E3]=13705;   // lian
   sortTable[0x9CA2]=13706;   // lian
   sortTable[0x6F4B]=13707;   // lian
   sortTable[0x695D]=13708;   // lian
   sortTable[0x934A]=13709;   // lian
   sortTable[0x84EE]=13710;   // lian
   sortTable[0x938C]=13711;   // lian
   sortTable[0x8539]=13712;   // lian
   sortTable[0x7C3E]=13713;   // lian
   sortTable[0x9B11]=13714;   // lian
   sortTable[0x78CF]=13715;   // lian
   sortTable[0x8B30]=13716;   // lian
   sortTable[0x9C31]=13717;   // lian
   sortTable[0x8068]=13718;   // lian
   sortTable[0x7FB7]=13719;   // lian
   sortTable[0x806B]=13720;   // lian
   sortTable[0x7E3A]=13721;   // lian
   sortTable[0x8595]=13722;   // lian
   sortTable[0x878A]=13723;   // lian
   sortTable[0x913B]=13724;   // lian
   sortTable[0x932C]=13725;   // lian
   sortTable[0x806E]=13726;   // lian
   sortTable[0x8430]=13727;   // lian
   sortTable[0x895D]=13728;   // lian
   sortTable[0x4EB7]=13729;   // lian
   sortTable[0x50C6]=13730;   // lian
   sortTable[0x5286]=13731;   // lian
   sortTable[0x5332]=13732;   // lian
   sortTable[0x5333]=13733;   // lian
   sortTable[0x55F9]=13734;   // lian
   sortTable[0x5652]=13735;   // lian
   sortTable[0x581C]=13736;   // lian
   sortTable[0x5969]=13737;   // lian
   sortTable[0x5AA1]=13738;   // lian
   sortTable[0x5AFE]=13739;   // lian
   sortTable[0x5B1A]=13740;   // lian
   sortTable[0x6169]=13741;   // lian
   sortTable[0x6459]=13742;   // lian
   sortTable[0x6582]=13743;   // lian
   sortTable[0x68BF]=13744;   // lian
   sortTable[0x69E4]=13745;   // lian
   sortTable[0x6AE3]=13746;   // lian
   sortTable[0x6BAE]=13747;   // lian
   sortTable[0x6D70]=13748;   // lian
   sortTable[0x6E45]=13749;   // lian
   sortTable[0x6E93]=13750;   // lian
   sortTable[0x6F23]=13751;   // lian
   sortTable[0x6FB0]=13752;   // lian
   sortTable[0x6FD3]=13753;   // lian
   sortTable[0x7032]=13754;   // lian
   sortTable[0x7191]=13755;   // lian
   sortTable[0x71EB]=13756;   // lian
   sortTable[0x7453]=13757;   // lian
   sortTable[0x7489]=13758;   // lian
   sortTable[0x7C62]=13759;   // lian
   sortTable[0x7C68]=13760;   // lian
   sortTable[0x7E9E]=13761;   // lian
   sortTable[0x7FF4]=13762;   // lian
   sortTable[0x861D]=13763;   // lian
   sortTable[0x861E]=13764;   // lian
   sortTable[0x8933]=13765;   // lian
   sortTable[0x899D]=13766;   // lian
   sortTable[0x8E65]=13767;   // lian
   sortTable[0x9C0A]=13768;   // lian
   sortTable[0x4E24]=13769;   // liang
   sortTable[0x5169]=13770;   // liang
   sortTable[0x91CF]=13771;   // liang
   sortTable[0x4EAE]=13772;   // liang
   sortTable[0x7CAE]=13773;   // liang
   sortTable[0x7CE7]=13774;   // liang
   sortTable[0x826F]=13775;   // liang
   sortTable[0x8F86]=13776;   // liang
   sortTable[0x8F1B]=13777;   // liang
   sortTable[0x51C9]=13778;   // liang
   sortTable[0x6DBC]=13779;   // liang
   sortTable[0x6881]=13780;   // liang
   sortTable[0x8C05]=13781;   // liang
   sortTable[0x8AD2]=13782;   // liang
   sortTable[0x667E]=13783;   // liang
   sortTable[0x690B]=13784;   // liang
   sortTable[0x8E09]=13785;   // liang
   sortTable[0x7CB1]=13786;   // liang
   sortTable[0x9B49]=13787;   // liang
   sortTable[0x8F8C]=13788;   // liang
   sortTable[0x88F2]=13789;   // liang
   sortTable[0x8F2C]=13790;   // liang
   sortTable[0x7DC9]=13791;   // liang
   sortTable[0x589A]=13792;   // liang
   sortTable[0x813C]=13793;   // liang
   sortTable[0x873D]=13794;   // liang
   sortTable[0x7DA1]=13795;   // liang
   sortTable[0x4E21]=13796;   // liang
   sortTable[0x4FCD]=13797;   // liang
   sortTable[0x54F4]=13798;   // liang
   sortTable[0x5521]=13799;   // liang
   sortTable[0x5562]=13800;   // liang
   sortTable[0x55A8]=13801;   // liang
   sortTable[0x60A2]=13802;   // liang
   sortTable[0x639A]=13803;   // liang
   sortTable[0x6A11]=13804;   // liang
   sortTable[0x6E78]=13805;   // liang
   sortTable[0x7177]=13806;   // liang
   sortTable[0x7C17]=13807;   // liang
   sortTable[0x8F0C]=13808;   // liang
   sortTable[0x9344]=13809;   // liang
   sortTable[0x9B4E]=13810;   // liang
   sortTable[0x6599]=13811;   // liao
   sortTable[0x77AD]=13812;   // liao
   sortTable[0x7597]=13813;   // liao
   sortTable[0x7642]=13814;   // liao
   sortTable[0x50DA]=13815;   // liao
   sortTable[0x8FBD]=13816;   // liao
   sortTable[0x907C]=13817;   // liao
   sortTable[0x804A]=13818;   // liao
   sortTable[0x64A9]=13819;   // liao
   sortTable[0x6482]=13820;   // liao
   sortTable[0x5ED6]=13821;   // liao
   sortTable[0x5BE5]=13822;   // liao
   sortTable[0x7F2D]=13823;   // liao
   sortTable[0x71CE]=13824;   // liao
   sortTable[0x7360]=13825;   // liao
   sortTable[0x5BEE]=13826;   // liao
   sortTable[0x948C]=13827;   // liao
   sortTable[0x9563]=13828;   // liao
   sortTable[0x9E69]=13829;   // liao
   sortTable[0x84FC]=13830;   // liao
   sortTable[0x5639]=13831;   // liao
   sortTable[0x5C25]=13832;   // liao
   sortTable[0x7C1D]=13833;   // liao
   sortTable[0x818B]=13834;   // liao
   sortTable[0x8C42]=13835;   // liao
   sortTable[0x87DF]=13836;   // liao
   sortTable[0x81AB]=13837;   // liao
   sortTable[0x9410]=13838;   // liao
   sortTable[0x8CFF]=13839;   // liao
   sortTable[0x7E5A]=13840;   // liao
   sortTable[0x85D4]=13841;   // liao
   sortTable[0x9DEF]=13842;   // liao
   sortTable[0x8E7D]=13843;   // liao
   sortTable[0x8E58]=13844;   // liao
   sortTable[0x911D]=13845;   // liao
   sortTable[0x91D5]=13846;   // liao
   sortTable[0x53FE]=13847;   // liao
   sortTable[0x5AFD]=13848;   // liao
   sortTable[0x5C1E]=13849;   // liao
   sortTable[0x5C26]=13850;   // liao
   sortTable[0x5C6A]=13851;   // liao
   sortTable[0x5D7A]=13852;   // liao
   sortTable[0x5D9A]=13853;   // liao
   sortTable[0x5D9B]=13854;   // liao
   sortTable[0x5EEB]=13855;   // liao
   sortTable[0x6180]=13856;   // liao
   sortTable[0x61AD]=13857;   // liao
   sortTable[0x6579]=13858;   // liao
   sortTable[0x66B8]=13859;   // liao
   sortTable[0x66E2]=13860;   // liao
   sortTable[0x6F3B]=13861;   // liao
   sortTable[0x7093]=13862;   // liao
   sortTable[0x720E]=13863;   // liao
   sortTable[0x7212]=13864;   // liao
   sortTable[0x7499]=13865;   // liao
   sortTable[0x7AB7]=13866;   // liao
   sortTable[0x957D]=13867;   // liao
   sortTable[0x98C9]=13868;   // liao
   sortTable[0x9ACE]=13869;   // liao
   sortTable[0x70C8]=13870;   // lie
   sortTable[0x5217]=13871;   // lie
   sortTable[0x730E]=13872;   // lie
   sortTable[0x7375]=13873;   // lie
   sortTable[0x88C2]=13874;   // lie
   sortTable[0x54A7]=13875;   // lie
   sortTable[0x52A3]=13876;   // lie
   sortTable[0x6D0C]=13877;   // lie
   sortTable[0x51BD]=13878;   // lie
   sortTable[0x9B23]=13879;   // lie
   sortTable[0x57D2]=13880;   // lie
   sortTable[0x8D94]=13881;   // lie
   sortTable[0x6369]=13882;   // lie
   sortTable[0x8E90]=13883;   // lie
   sortTable[0x9C72]=13884;   // lie
   sortTable[0x8322]=13885;   // lie
   sortTable[0x9D37]=13886;   // lie
   sortTable[0x86DA]=13887;   // lie
   sortTable[0x9B1B]=13888;   // lie
   sortTable[0x8FFE]=13889;   // lie
   sortTable[0x7759]=13890;   // lie
   sortTable[0x811F]=13891;   // lie
   sortTable[0x5120]=13892;   // lie
   sortTable[0x52BD]=13893;   // lie
   sortTable[0x54F7]=13894;   // lie
   sortTable[0x57D3]=13895;   // lie
   sortTable[0x59F4]=13896;   // lie
   sortTable[0x5DE4]=13897;   // lie
   sortTable[0x6312]=13898;   // lie
   sortTable[0x6318]=13899;   // lie
   sortTable[0x64F8]=13900;   // lie
   sortTable[0x6835]=13901;   // lie
   sortTable[0x6BDF]=13902;   // lie
   sortTable[0x6D56]=13903;   // lie
   sortTable[0x70EE]=13904;   // lie
   sortTable[0x716D]=13905;   // lie
   sortTable[0x72A3]=13906;   // lie
   sortTable[0x731F]=13907;   // lie
   sortTable[0x8057]=13908;   // lie
   sortTable[0x98B2]=13909;   // lie
   sortTable[0x9BA4]=13910;   // lie
   sortTable[0x6797]=13911;   // lin
   sortTable[0x4E34]=13912;   // lin
   sortTable[0x81E8]=13913;   // lin
   sortTable[0x6DCB]=13914;   // lin
   sortTable[0x90BB]=13915;   // lin
   sortTable[0x9130]=13916;   // lin
   sortTable[0x78F7]=13917;   // lin
   sortTable[0x9E9F]=13918;   // lin
   sortTable[0x7433]=13919;   // lin
   sortTable[0x9CDE]=13920;   // lin
   sortTable[0x9716]=13921;   // lin
   sortTable[0x51DB]=13922;   // lin
   sortTable[0x8D41]=13923;   // lin
   sortTable[0x5EEA]=13924;   // lin
   sortTable[0x541D]=13925;   // lin
   sortTable[0x62CE]=13926;   // lin
   sortTable[0x7CBC]=13927;   // lin
   sortTable[0x8E8F]=13928;   // lin
   sortTable[0x61D4]=13929;   // lin
   sortTable[0x5D99]=13930;   // lin
   sortTable[0x9074]=13931;   // lin
   sortTable[0x853A]=13932;   // lin
   sortTable[0x9A4E]=13933;   // lin
   sortTable[0x8F9A]=13934;   // lin
   sortTable[0x6AA9]=13935;   // lin
   sortTable[0x5549]=13936;   // lin
   sortTable[0x93FB]=13937;   // lin
   sortTable[0x83FB]=13938;   // lin
   sortTable[0x7B96]=13939;   // lin
   sortTable[0x77DD]=13940;   // lin
   sortTable[0x77B5]=13941;   // lin
   sortTable[0x7CA6]=13942;   // lin
   sortTable[0x8F65]=13943;   // lin
   sortTable[0x81A6]=13944;   // lin
   sortTable[0x9C57]=13945;   // lin
   sortTable[0x9E90]=13946;   // lin
   sortTable[0x95B5]=13947;   // lin
   sortTable[0x7884]=13948;   // lin
   sortTable[0x7E57]=13949;   // lin
   sortTable[0x96A3]=13950;   // lin
   sortTable[0x7FF7]=13951;   // lin
   sortTable[0x85FA]=13952;   // lin
   sortTable[0x8E78]=13953;   // lin
   sortTable[0x4E83]=13954;   // lin
   sortTable[0x50EF]=13955;   // lin
   sortTable[0x51A7]=13956;   // lin
   sortTable[0x51DC]=13957;   // lin
   sortTable[0x53B8]=13958;   // lin
   sortTable[0x58E3]=13959;   // lin
   sortTable[0x5D0A]=13960;   // lin
   sortTable[0x5EE9]=13961;   // lin
   sortTable[0x6061]=13962;   // lin
   sortTable[0x608B]=13963;   // lin
   sortTable[0x61CD]=13964;   // lin
   sortTable[0x649B]=13965;   // lin
   sortTable[0x65B4]=13966;   // lin
   sortTable[0x667D]=13967;   // lin
   sortTable[0x66BD]=13968;   // lin
   sortTable[0x6A49]=13969;   // lin
   sortTable[0x6A81]=13970;   // lin
   sortTable[0x6F7E]=13971;   // lin
   sortTable[0x6F9F]=13972;   // lin
   sortTable[0x7036]=13973;   // lin
   sortTable[0x711B]=13974;   // lin
   sortTable[0x71D0]=13975;   // lin
   sortTable[0x735C]=13976;   // lin
   sortTable[0x7498]=13977;   // lin
   sortTable[0x7510]=13978;   // lin
   sortTable[0x7584]=13979;   // lin
   sortTable[0x75F3]=13980;   // lin
   sortTable[0x765B]=13981;   // lin
   sortTable[0x765D]=13982;   // lin
   sortTable[0x8CC3]=13983;   // lin
   sortTable[0x8E99]=13984;   // lin
   sortTable[0x8EAA]=13985;   // lin
   sortTable[0x8F54]=13986;   // lin
   sortTable[0x9886]=13987;   // ling
   sortTable[0x9818]=13988;   // ling
   sortTable[0x53E6]=13989;   // ling
   sortTable[0x4EE4]=13990;   // ling
   sortTable[0x96F6]=13991;   // ling
   sortTable[0x7075]=13992;   // ling
   sortTable[0x9748]=13993;   // ling
   sortTable[0x94C3]=13994;   // ling
   sortTable[0x9234]=13995;   // ling
   sortTable[0x5CAD]=13996;   // ling
   sortTable[0x5DBA]=13997;   // ling
   sortTable[0x9F84]=13998;   // ling
   sortTable[0x9F61]=13999;   // ling
   sortTable[0x9675]=14000;   // ling
   sortTable[0x4F36]=14001;   // ling
   sortTable[0x73B2]=14002;   // ling
   sortTable[0x51CC]=14003;   // ling
   sortTable[0x83F1]=14004;   // ling
   sortTable[0x7EEB]=14005;   // ling
   sortTable[0x86C9]=14006;   // ling
   sortTable[0x7FCE]=14007;   // ling
   sortTable[0x5464]=14008;   // ling
   sortTable[0x8046]=14009;   // ling
   sortTable[0x82D3]=14010;   // ling
   sortTable[0x7F9A]=14011;   // ling
   sortTable[0x6CE0]=14012;   // ling
   sortTable[0x74F4]=14013;   // ling
   sortTable[0x68C2]=14014;   // ling
   sortTable[0x9143]=14015;   // ling
   sortTable[0x56F9]=14016;   // ling
   sortTable[0x9CAE]=14017;   // ling
   sortTable[0x8EE8]=14018;   // ling
   sortTable[0x67C3]=14019;   // ling
   sortTable[0x9E30]=14020;   // ling
   sortTable[0x7B2D]=14021;   // ling
   sortTable[0x91BD]=14022;   // ling
   sortTable[0x8232]=14023;   // ling
   sortTable[0x971D]=14024;   // ling
   sortTable[0x888A]=14025;   // ling
   sortTable[0x971B]=14026;   // ling
   sortTable[0x8DC9]=14027;   // ling
   sortTable[0x797E]=14028;   // ling
   sortTable[0x84E4]=14029;   // ling
   sortTable[0x970A]=14030;   // ling
   sortTable[0x9EA2]=14031;   // ling
   sortTable[0x9F97]=14032;   // ling
   sortTable[0x8626]=14033;   // ling
   sortTable[0x99D6]=14034;   // ling
   sortTable[0x9D12]=14035;   // ling
   sortTable[0x8506]=14036;   // ling
   sortTable[0x8A45]=14037;   // ling
   sortTable[0x9F62]=14038;   // ling
   sortTable[0x79E2]=14039;   // ling
   sortTable[0x7ADB]=14040;   // ling
   sortTable[0x9302]=14041;   // ling
   sortTable[0x963E]=14042;   // ling
   sortTable[0x9B7F]=14043;   // ling
   sortTable[0x5222]=14044;   // ling
   sortTable[0x577D]=14045;   // ling
   sortTable[0x590C]=14046;   // ling
   sortTable[0x59C8]=14047;   // ling
   sortTable[0x5A48]=14048;   // ling
   sortTable[0x5B41]=14049;   // ling
   sortTable[0x5CBA]=14050;   // ling
   sortTable[0x5F7E]=14051;   // ling
   sortTable[0x6395]=14052;   // ling
   sortTable[0x6624]=14053;   // ling
   sortTable[0x670E]=14054;   // ling
   sortTable[0x6AFA]=14055;   // ling
   sortTable[0x6B1E]=14056;   // ling
   sortTable[0x6DE9]=14057;   // ling
   sortTable[0x6FAA]=14058;   // ling
   sortTable[0x702E]=14059;   // ling
   sortTable[0x70A9]=14060;   // ling
   sortTable[0x71EF]=14061;   // ling
   sortTable[0x7227]=14062;   // ling
   sortTable[0x72D1]=14063;   // ling
   sortTable[0x740C]=14064;   // ling
   sortTable[0x768A]=14065;   // ling
   sortTable[0x7831]=14066;   // ling
   sortTable[0x7D37]=14067;   // ling
   sortTable[0x7DBE]=14068;   // ling
   sortTable[0x8576]=14069;   // ling
   sortTable[0x8851]=14070;   // ling
   sortTable[0x88EC]=14071;   // ling
   sortTable[0x959D]=14072;   // ling
   sortTable[0x9717]=14073;   // ling
   sortTable[0x9BEA]=14074;   // ling
   sortTable[0x9E77]=14075;   // ling
   sortTable[0x6D41]=14076;   // liu
   sortTable[0x516D]=14077;   // liu
   sortTable[0x7559]=14078;   // liu
   sortTable[0x69B4]=14079;   // liu
   sortTable[0x67F3]=14080;   // liu
   sortTable[0x6E9C]=14081;   // liu
   sortTable[0x786B]=14082;   // liu
   sortTable[0x5218]=14083;   // liu
   sortTable[0x7624]=14084;   // liu
   sortTable[0x7409]=14085;   // liu
   sortTable[0x6D4F]=14086;   // liu
   sortTable[0x7198]=14087;   // liu
   sortTable[0x954F]=14088;   // liu
   sortTable[0x65D2]=14089;   // liu
   sortTable[0x950D]=14090;   // liu
   sortTable[0x9E68]=14091;   // liu
   sortTable[0x7EFA]=14092;   // liu
   sortTable[0x9560]=14093;   // liu
   sortTable[0x905B]=14094;   // liu
   sortTable[0x938F]=14095;   // liu
   sortTable[0x9A9D]=14096;   // liu
   sortTable[0x998F]=14097;   // liu
   sortTable[0x8E53]=14098;   // liu
   sortTable[0x9724]=14099;   // liu
   sortTable[0x98D7]=14100;   // liu
   sortTable[0x9E60]=14101;   // liu
   sortTable[0x7F76]=14102;   // liu
   sortTable[0x7F80]=14103;   // liu
   sortTable[0x98C2]=14104;   // liu
   sortTable[0x9C21]=14105;   // liu
   sortTable[0x7FCF]=14106;   // liu
   sortTable[0x93D0]=14107;   // liu
   sortTable[0x99F5]=14108;   // liu
   sortTable[0x9DB9]=14109;   // liu
   sortTable[0x87C9]=14110;   // liu
   sortTable[0x99E0]=14111;   // liu
   sortTable[0x98F9]=14112;   // liu
   sortTable[0x85F0]=14113;   // liu
   sortTable[0x9A51]=14114;   // liu
   sortTable[0x9E8D]=14115;   // liu
   sortTable[0x7DB9]=14116;   // liu
   sortTable[0x98C0]=14117;   // liu
   sortTable[0x9B38]=14118;   // liu
   sortTable[0x5289]=14119;   // liu
   sortTable[0x56A0]=14120;   // liu
   sortTable[0x586F]=14121;   // liu
   sortTable[0x5AB9]=14122;   // liu
   sortTable[0x5B3C]=14123;   // liu
   sortTable[0x5D67]=14124;   // liu
   sortTable[0x5EC7]=14125;   // liu
   sortTable[0x61F0]=14126;   // liu
   sortTable[0x65C8]=14127;   // liu
   sortTable[0x6801]=14128;   // liu
   sortTable[0x685E]=14129;   // liu
   sortTable[0x687A]=14130;   // liu
   sortTable[0x6A4A]=14131;   // liu
   sortTable[0x6A6E]=14132;   // liu
   sortTable[0x6CA0]=14133;   // liu
   sortTable[0x6F91]=14134;   // liu
   sortTable[0x700F]=14135;   // liu
   sortTable[0x71AE]=14136;   // liu
   sortTable[0x73CB]=14137;   // liu
   sortTable[0x7460]=14138;   // liu
   sortTable[0x746C]=14139;   // liu
   sortTable[0x74A2]=14140;   // liu
   sortTable[0x7542]=14141;   // liu
   sortTable[0x7544]=14142;   // liu
   sortTable[0x7571]=14143;   // liu
   sortTable[0x7581]=14144;   // liu
   sortTable[0x7645]=14145;   // liu
   sortTable[0x78C2]=14146;   // liu
   sortTable[0x78DF]=14147;   // liu
   sortTable[0x84A5]=14148;   // liu
   sortTable[0x84C5]=14149;   // liu
   sortTable[0x88D7]=14150;   // liu
   sortTable[0x925A]=14151;   // liu
   sortTable[0x92F6]=14152;   // liu
   sortTable[0x93A6]=14153;   // liu
   sortTable[0x9402]=14154;   // liu
   sortTable[0x96E1]=14155;   // liu
   sortTable[0x98C5]=14156;   // liu
   sortTable[0x993E]=14157;   // liu
   sortTable[0x9A2E]=14158;   // liu
   sortTable[0x9DDA]=14159;   // liu
   sortTable[0x56D6]=14160;   // lo
   sortTable[0x9F99]=14161;   // long
   sortTable[0x9F8D]=14162;   // long
   sortTable[0x62E2]=14163;   // long
   sortTable[0x650F]=14164;   // long
   sortTable[0x9686]=14165;   // long
   sortTable[0x7B3C]=14166;   // long
   sortTable[0x7C60]=14167;   // long
   sortTable[0x80E7]=14168;   // long
   sortTable[0x6727]=14169;   // long
   sortTable[0x5784]=14170;   // long
   sortTable[0x58DF]=14171;   // long
   sortTable[0x5499]=14172;   // long
   sortTable[0x7ABF]=14173;   // long
   sortTable[0x56A8]=14174;   // long
   sortTable[0x73D1]=14175;   // long
   sortTable[0x74CF]=14176;   // long
   sortTable[0x9647]=14177;   // long
   sortTable[0x804B]=14178;   // long
   sortTable[0x830F]=14179;   // long
   sortTable[0x680A]=14180;   // long
   sortTable[0x783B]=14181;   // long
   sortTable[0x6CF7]=14182;   // long
   sortTable[0x5785]=14183;   // long
   sortTable[0x772C]=14184;   // long
   sortTable[0x7643]=14185;   // long
   sortTable[0x9468]=14186;   // long
   sortTable[0x9F92]=14187;   // long
   sortTable[0x8E98]=14188;   // long
   sortTable[0x9E17]=14189;   // long
   sortTable[0x7932]=14190;   // long
   sortTable[0x9F93]=14191;   // long
   sortTable[0x9733]=14192;   // long
   sortTable[0x7C3C]=14193;   // long
   sortTable[0x856F]=14194;   // long
   sortTable[0x8971]=14195;   // long
   sortTable[0x77D3]=14196;   // long
   sortTable[0x9A61]=14197;   // long
   sortTable[0x7931]=14198;   // long
   sortTable[0x882A]=14199;   // long
   sortTable[0x7BE2]=14200;   // long
   sortTable[0x7BED]=14201;   // long
   sortTable[0x807E]=14202;   // long
   sortTable[0x882C]=14203;   // long
   sortTable[0x5131]=14204;   // long
   sortTable[0x54E2]=14205;   // long
   sortTable[0x58E0]=14206;   // long
   sortTable[0x5C78]=14207;   // long
   sortTable[0x5D90]=14208;   // long
   sortTable[0x5DC3]=14209;   // long
   sortTable[0x5DC4]=14210;   // long
   sortTable[0x5FBF]=14211;   // long
   sortTable[0x6335]=14212;   // long
   sortTable[0x663D]=14213;   // long
   sortTable[0x66E8]=14214;   // long
   sortTable[0x6887]=14215;   // long
   sortTable[0x69DE]=14216;   // long
   sortTable[0x6AF3]=14217;   // long
   sortTable[0x6E70]=14218;   // long
   sortTable[0x6EDD]=14219;   // long
   sortTable[0x6F0B]=14220;   // long
   sortTable[0x7027]=14221;   // long
   sortTable[0x7216]=14222;   // long
   sortTable[0x7AC9]=14223;   // long
   sortTable[0x7ADC]=14224;   // long
   sortTable[0x8622]=14225;   // long
   sortTable[0x8C45]=14226;   // long
   sortTable[0x8D1A]=14227;   // long
   sortTable[0x93E7]=14228;   // long
   sortTable[0x96B4]=14229;   // long
   sortTable[0x9747]=14230;   // long
   sortTable[0x697C]=14231;   // lou
   sortTable[0x6A13]=14232;   // lou
   sortTable[0x6F0F]=14233;   // lou
   sortTable[0x55BD]=14234;   // lou
   sortTable[0x560D]=14235;   // lou
   sortTable[0x6402]=14236;   // lou
   sortTable[0x645F]=14237;   // lou
   sortTable[0x964B]=14238;   // lou
   sortTable[0x5A04]=14239;   // lou
   sortTable[0x9542]=14240;   // lou
   sortTable[0x9AC5]=14241;   // lou
   sortTable[0x507B]=14242;   // lou
   sortTable[0x7BD3]=14243;   // lou
   sortTable[0x5D5D]=14244;   // lou
   sortTable[0x877C]=14245;   // lou
   sortTable[0x7618]=14246;   // lou
   sortTable[0x848C]=14247;   // lou
   sortTable[0x8027]=14248;   // lou
   sortTable[0x825B]=14249;   // lou
   sortTable[0x97BB]=14250;   // lou
   sortTable[0x8B31]=14251;   // lou
   sortTable[0x7C0D]=14252;   // lou
   sortTable[0x851E]=14253;   // lou
   sortTable[0x9071]=14254;   // lou
   sortTable[0x93E4]=14255;   // lou
   sortTable[0x779C]=14256;   // lou
   sortTable[0x9ACF]=14257;   // lou
   sortTable[0x50C2]=14258;   // lou
   sortTable[0x5245]=14259;   // lou
   sortTable[0x587F]=14260;   // lou
   sortTable[0x5A41]=14261;   // lou
   sortTable[0x5C5A]=14262;   // lou
   sortTable[0x5D81]=14263;   // lou
   sortTable[0x5ED4]=14264;   // lou
   sortTable[0x617A]=14265;   // lou
   sortTable[0x6E87]=14266;   // lou
   sortTable[0x6F0A]=14267;   // lou
   sortTable[0x71A1]=14268;   // lou
   sortTable[0x750A]=14269;   // lou
   sortTable[0x763A]=14270;   // lou
   sortTable[0x763B]=14271;   // lou
   sortTable[0x802C]=14272;   // lou
   sortTable[0x87BB]=14273;   // lou
   sortTable[0x8EC1]=14274;   // lou
   sortTable[0x8DEF]=14275;   // lu
   sortTable[0x9732]=14276;   // lu
   sortTable[0x9646]=14277;   // lu
   sortTable[0x9678]=14278;   // lu
   sortTable[0x7089]=14279;   // lu
   sortTable[0x7210]=14280;   // lu
   sortTable[0x5F55]=14281;   // lu
   sortTable[0x9304]=14282;   // lu
   sortTable[0x82A6]=14283;   // lu
   sortTable[0x8606]=14284;   // lu
   sortTable[0x864F]=14285;   // lu
   sortTable[0x865C]=14286;   // lu
   sortTable[0x788C]=14287;   // lu
   sortTable[0x9E7F]=14288;   // lu
   sortTable[0x9C81]=14289;   // lu
   sortTable[0x5362]=14290;   // lu
   sortTable[0x7984]=14291;   // lu
   sortTable[0x5E90]=14292;   // lu
   sortTable[0x64B8]=14293;   // lu
   sortTable[0x622E]=14294;   // lu
   sortTable[0x8D42]=14295;   // lu
   sortTable[0x6F5E]=14296;   // lu
   sortTable[0x5364]=14297;   // lu
   sortTable[0x80EA]=14298;   // lu
   sortTable[0x565C]=14299;   // lu
   sortTable[0x9885]=14300;   // lu
   sortTable[0x9E93]=14301;   // lu
   sortTable[0x63B3]=14302;   // lu
   sortTable[0x8F82]=14303;   // lu
   sortTable[0x6A79]=14304;   // lu
   sortTable[0x6E0C]=14305;   // lu
   sortTable[0x9E6D]=14306;   // lu
   sortTable[0x7B93]=14307;   // lu
   sortTable[0x902F]=14308;   // lu
   sortTable[0x7490]=14309;   // lu
   sortTable[0x6F09]=14310;   // lu
   sortTable[0x8F98]=14311;   // lu
   sortTable[0x9C88]=14312;   // lu
   sortTable[0x6CF8]=14313;   // lu
   sortTable[0x823B]=14314;   // lu
   sortTable[0x9E2C]=14315;   // lu
   sortTable[0x680C]=14316;   // lu
   sortTable[0x8F73]=14317;   // lu
   sortTable[0x5786]=14318;   // lu
   sortTable[0x7C0F]=14319;   // lu
   sortTable[0x76DD]=14320;   // lu
   sortTable[0x6C07]=14321;   // lu
   sortTable[0x9A04]=14322;   // lu
   sortTable[0x9181]=14323;   // lu
   sortTable[0x9A3C]=14324;   // lu
   sortTable[0x9871]=14325;   // lu
   sortTable[0x83C9]=14326;   // lu
   sortTable[0x7A11]=14327;   // lu
   sortTable[0x9565]=14328;   // lu
   sortTable[0x7C2C]=14329;   // lu
   sortTable[0x7E91]=14330;   // lu
   sortTable[0x9229]=14331;   // lu
   sortTable[0x7CB6]=14332;   // lu
   sortTable[0x8263]=14333;   // lu
   sortTable[0x84FE]=14334;   // lu
   sortTable[0x8557]=14335;   // lu
   sortTable[0x7849]=14336;   // lu
   sortTable[0x7A4B]=14337;   // lu
   sortTable[0x7C59]=14338;   // lu
   sortTable[0x9332]=14339;   // lu
   sortTable[0x9DFA]=14340;   // lu
   sortTable[0x9B6F]=14341;   // lu
   sortTable[0x9E15]=14342;   // lu
   sortTable[0x9EF8]=14343;   // lu
   sortTable[0x7769]=14344;   // lu
   sortTable[0x93D5]=14345;   // lu
   sortTable[0x946A]=14346;   // lu
   sortTable[0x797F]=14347;   // lu
   sortTable[0x7F4F]=14348;   // lu
   sortTable[0x8826]=14349;   // lu
   sortTable[0x9E75]=14350;   // lu
   sortTable[0x76E7]=14351;   // lu
   sortTable[0x77D1]=14352;   // lu
   sortTable[0x7875]=14353;   // lu
   sortTable[0x78E0]=14354;   // lu
   sortTable[0x81DA]=14355;   // lu
   sortTable[0x826B]=14356;   // lu
   sortTable[0x8642]=14357;   // lu
   sortTable[0x87B0]=14358;   // lu
   sortTable[0x8CC2]=14359;   // lu
   sortTable[0x8E57]=14360;   // lu
   sortTable[0x93F4]=14361;   // lu
   sortTable[0x4F93]=14362;   // lu
   sortTable[0x50C7]=14363;   // lu
   sortTable[0x5279]=14364;   // lu
   sortTable[0x52CE]=14365;   // lu
   sortTable[0x52E0]=14366;   // lu
   sortTable[0x5695]=14367;   // lu
   sortTable[0x56A7]=14368;   // lu
   sortTable[0x5725]=14369;   // lu
   sortTable[0x5774]=14370;   // lu
   sortTable[0x5876]=14371;   // lu
   sortTable[0x5877]=14372;   // lu
   sortTable[0x58DA]=14373;   // lu
   sortTable[0x5A3D]=14374;   // lu
   sortTable[0x5CCD]=14375;   // lu
   sortTable[0x5ED8]=14376;   // lu
   sortTable[0x5EEC]=14377;   // lu
   sortTable[0x5F54]=14378;   // lu
   sortTable[0x645D]=14379;   // lu
   sortTable[0x64C4]=14380;   // lu
   sortTable[0x64FC]=14381;   // lu
   sortTable[0x650E]=14382;   // lu
   sortTable[0x66E5]=14383;   // lu
   sortTable[0x67A6]=14384;   // lu
   sortTable[0x6902]=14385;   // lu
   sortTable[0x6A10]=14386;   // lu
   sortTable[0x6A1A]=14387;   // lu
   sortTable[0x6AD3]=14388;   // lu
   sortTable[0x6ADA]=14389;   // lu
   sortTable[0x6AE8]=14390;   // lu
   sortTable[0x6C0C]=14391;   // lu
   sortTable[0x6DD5]=14392;   // lu
   sortTable[0x6DE5]=14393;   // lu
   sortTable[0x6EF7]=14394;   // lu
   sortTable[0x6F9B]=14395;   // lu
   sortTable[0x7002]=14396;   // lu
   sortTable[0x7018]=14397;   // lu
   sortTable[0x719D]=14398;   // lu
   sortTable[0x7379]=14399;   // lu
   sortTable[0x7388]=14400;   // lu
   sortTable[0x742D]=14401;   // lu
   sortTable[0x74B7]=14402;   // lu
   sortTable[0x74D0]=14403;   // lu
   sortTable[0x752A]=14404;   // lu
   sortTable[0x7C36]=14405;   // lu
   sortTable[0x7C5A]=14406;   // lu
   sortTable[0x8194]=14407;   // lu
   sortTable[0x822E]=14408;   // lu
   sortTable[0x826A]=14409;   // lu
   sortTable[0x850D]=14410;   // lu
   sortTable[0x89EE]=14411;   // lu
   sortTable[0x8DA2]=14412;   // lu
   sortTable[0x8E1B]=14413;   // lu
   sortTable[0x8F46]=14414;   // lu
   sortTable[0x8F64]=14415;   // lu
   sortTable[0x9334]=14416;   // lu
   sortTable[0x93C0]=14417;   // lu
   sortTable[0x942A]=14418;   // lu
   sortTable[0x9465]=14419;   // lu
   sortTable[0x9AD7]=14420;   // lu
   sortTable[0x9B72]=14421;   // lu
   sortTable[0x9BE5]=14422;   // lu
   sortTable[0x9C78]=14423;   // lu
   sortTable[0x9D66]=14424;   // lu
   sortTable[0x9D71]=14425;   // lu
   sortTable[0x4E71]=14426;   // luan
   sortTable[0x4E82]=14427;   // luan
   sortTable[0x5375]=14428;   // luan
   sortTable[0x5CE6]=14429;   // luan
   sortTable[0x5DD2]=14430;   // luan
   sortTable[0x9E3E]=14431;   // luan
   sortTable[0x631B]=14432;   // luan
   sortTable[0x92AE]=14433;   // luan
   sortTable[0x683E]=14434;   // luan
   sortTable[0x6EE6]=14435;   // luan
   sortTable[0x5B6A]=14436;   // luan
   sortTable[0x8114]=14437;   // luan
   sortTable[0x5A08]=14438;   // luan
   sortTable[0x91E0]=14439;   // luan
   sortTable[0x947E]=14440;   // luan
   sortTable[0x7F89]=14441;   // luan
   sortTable[0x81E0]=14442;   // luan
   sortTable[0x864A]=14443;   // luan
   sortTable[0x571D]=14444;   // luan
   sortTable[0x571E]=14445;   // luan
   sortTable[0x5971]=14446;   // luan
   sortTable[0x5B4C]=14447;   // luan
   sortTable[0x5B7F]=14448;   // luan
   sortTable[0x6523]=14449;   // luan
   sortTable[0x66EB]=14450;   // luan
   sortTable[0x6B12]=14451;   // luan
   sortTable[0x7053]=14452;   // luan
   sortTable[0x7064]=14453;   // luan
   sortTable[0x7674]=14454;   // luan
   sortTable[0x7675]=14455;   // luan
   sortTable[0x9D49]=14456;   // luan
   sortTable[0x9E1E]=14457;   // luan
   sortTable[0x950A]=14458;   // lüe
   sortTable[0x5719]=14459;   // lüe
   sortTable[0x64FD]=14460;   // lüe
   sortTable[0x7567]=14461;   // lüe
   sortTable[0x7A24]=14462;   // lüe
   sortTable[0x92DD]=14463;   // lüe
   sortTable[0x92E2]=14464;   // lüe
   sortTable[0x8BBA]=14465;   // lun
   sortTable[0x8AD6]=14466;   // lun
   sortTable[0x8F6E]=14467;   // lun
   sortTable[0x8F2A]=14468;   // lun
   sortTable[0x7EB6]=14469;   // lun
   sortTable[0x7DB8]=14470;   // lun
   sortTable[0x62A1]=14471;   // lun
   sortTable[0x6384]=14472;   // lun
   sortTable[0x4F26]=14473;   // lun
   sortTable[0x4ED1]=14474;   // lun
   sortTable[0x6CA6]=14475;   // lun
   sortTable[0x56F5]=14476;   // lun
   sortTable[0x7A10]=14477;   // lun
   sortTable[0x83D5]=14478;   // lun
   sortTable[0x9300]=14479;   // lun
   sortTable[0x78EE]=14480;   // lun
   sortTable[0x8140]=14481;   // lun
   sortTable[0x9BE9]=14482;   // lun
   sortTable[0x4F96]=14483;   // lun
   sortTable[0x502B]=14484;   // lun
   sortTable[0x5707]=14485;   // lun
   sortTable[0x57E8]=14486;   // lun
   sortTable[0x5A68]=14487;   // lun
   sortTable[0x5D18]=14488;   // lun
   sortTable[0x5D19]=14489;   // lun
   sortTable[0x60C0]=14490;   // lun
   sortTable[0x68C6]=14491;   // lun
   sortTable[0x6DEA]=14492;   // lun
   sortTable[0x6EA3]=14493;   // lun
   sortTable[0x7896]=14494;   // lun
   sortTable[0x8023]=14495;   // lun
   sortTable[0x8726]=14496;   // lun
   sortTable[0x8E1A]=14497;   // lun
   sortTable[0x966F]=14498;   // lun
   sortTable[0x843D]=14499;   // luo
   sortTable[0x9A86]=14500;   // luo
   sortTable[0x99F1]=14501;   // luo
   sortTable[0x9523]=14502;   // luo
   sortTable[0x947C]=14503;   // luo
   sortTable[0x7EDC]=14504;   // luo
   sortTable[0x7D61]=14505;   // luo
   sortTable[0x841D]=14506;   // luo
   sortTable[0x863F]=14507;   // luo
   sortTable[0x903B]=14508;   // luo
   sortTable[0x908F]=14509;   // luo
   sortTable[0x9AA1]=14510;   // luo
   sortTable[0x9A3E]=14511;   // luo
   sortTable[0x7BA9]=14512;   // luo
   sortTable[0x7C6E]=14513;   // luo
   sortTable[0x7F57]=14514;   // luo
   sortTable[0x6D1B]=14515;   // luo
   sortTable[0x88F8]=14516;   // luo
   sortTable[0x87BA]=14517;   // luo
   sortTable[0x6924]=14518;   // luo
   sortTable[0x96D2]=14519;   // luo
   sortTable[0x502E]=14520;   // luo
   sortTable[0x6CFA]=14521;   // luo
   sortTable[0x645E]=14522;   // luo
   sortTable[0x73DE]=14523;   // luo
   sortTable[0x8366]=14524;   // luo
   sortTable[0x6F2F]=14525;   // luo
   sortTable[0x8803]=14526;   // luo
   sortTable[0x8136]=14527;   // luo
   sortTable[0x7321]=14528;   // luo
   sortTable[0x7630]=14529;   // luo
   sortTable[0x81DD]=14530;   // luo
   sortTable[0x84CF]=14531;   // luo
   sortTable[0x8999]=14532;   // luo
   sortTable[0x9559]=14533;   // luo
   sortTable[0x9960]=14534;   // luo
   sortTable[0x9D3C]=14535;   // luo
   sortTable[0x9A58]=14536;   // luo
   sortTable[0x7F85]=14537;   // luo
   sortTable[0x93CD]=14538;   // luo
   sortTable[0x9E01]=14539;   // luo
   sortTable[0x8EB6]=14540;   // luo
   sortTable[0x9D45]=14541;   // luo
   sortTable[0x7B3F]=14542;   // luo
   sortTable[0x89BC]=14543;   // luo
   sortTable[0x9BA5]=14544;   // luo
   sortTable[0x5138]=14545;   // luo
   sortTable[0x5246]=14546;   // luo
   sortTable[0x5570]=14547;   // luo
   sortTable[0x55E0]=14548;   // luo
   sortTable[0x56C9]=14549;   // luo
   sortTable[0x5CC8]=14550;   // luo
   sortTable[0x651E]=14551;   // luo
   sortTable[0x66EA]=14552;   // luo
   sortTable[0x6B0F]=14553;   // luo
   sortTable[0x6D1C]=14554;   // luo
   sortTable[0x6FFC]=14555;   // luo
   sortTable[0x7296]=14556;   // luo
   sortTable[0x7380]=14557;   // luo
   sortTable[0x7673]=14558;   // luo
   sortTable[0x7866]=14559;   // luo
   sortTable[0x7E99]=14560;   // luo
   sortTable[0x7F56]=14561;   // luo
   sortTable[0x8161]=14562;   // luo
   sortTable[0x89B6]=14563;   // luo
   sortTable[0x927B]=14564;   // luo
   sortTable[0x9831]=14565;   // luo
   sortTable[0x5F8B]=14566;   // lv
   sortTable[0x7EFF]=14567;   // lv
   sortTable[0x7DA0]=14568;   // lv
   sortTable[0x7387]=14569;   // lv
   sortTable[0x65C5]=14570;   // lv
   sortTable[0x8651]=14571;   // lv
   sortTable[0x616E]=14572;   // lv
   sortTable[0x9A74]=14573;   // lv
   sortTable[0x9A62]=14574;   // lv
   sortTable[0x94DD]=14575;   // lv
   sortTable[0x92C1]=14576;   // lv
   sortTable[0x7F15]=14577;   // lv
   sortTable[0x7E37]=14578;   // lv
   sortTable[0x5415]=14579;   // lv
   sortTable[0x5C65]=14580;   // lv
   sortTable[0x5C61]=14581;   // lv
   sortTable[0x4FA3]=14582;   // lv
   sortTable[0x95FE]=14583;   // lv
   sortTable[0x6C2F]=14584;   // lv
   sortTable[0x6EE4]=14585;   // lv
   sortTable[0x6988]=14586;   // lv
   sortTable[0x634B]=14587;   // lv
   sortTable[0x8182]=14588;   // lv
   sortTable[0x891B]=14589;   // lv
   sortTable[0x844E]=14590;   // lv
   sortTable[0x85D8]=14591;   // lv
   sortTable[0x81A2]=14592;   // lv
   sortTable[0x7A06]=14593;   // lv
   sortTable[0x7BBB]=14594;   // lv
   sortTable[0x9462]=14595;   // lv
   sortTable[0x7D7D]=14596;   // lv
   sortTable[0x95AD]=14597;   // lv
   sortTable[0x7E42]=14598;   // lv
   sortTable[0x819F]=14599;   // lv
   sortTable[0x7A6D]=14600;   // lv
   sortTable[0x7A5E]=14601;   // lv
   sortTable[0x90D8]=14602;   // lv
   sortTable[0x8190]=14603;   // lv
   sortTable[0x8938]=14604;   // lv
   sortTable[0x99BF]=14605;   // lv
   sortTable[0x9DDC]=14606;   // lv
   sortTable[0x4FB6]=14607;   // lv
   sortTable[0x5122]=14608;   // lv
   sortTable[0x52F4]=14609;   // lv
   sortTable[0x5442]=14610;   // lv
   sortTable[0x578F]=14611;   // lv
   sortTable[0x5BFD]=14612;   // lv
   sortTable[0x5C62]=14613;   // lv
   sortTable[0x5D42]=14614;   // lv
   sortTable[0x6314]=14615;   // lv
   sortTable[0x635B]=14616;   // lv
   sortTable[0x68A0]=14617;   // lv
   sortTable[0x6AD6]=14618;   // lv
   sortTable[0x6C00]=14619;   // lv
   sortTable[0x6FFE]=14620;   // lv
   sortTable[0x7112]=14621;   // lv
   sortTable[0x7208]=14622;   // lv
   sortTable[0x7963]=14623;   // lv
   sortTable[0x7DD1]=14624;   // lv
   sortTable[0x5463]=15104;   // ḿ
   sortTable[0x5417]=15105;   // ma
   sortTable[0x55CE]=15106;   // ma
   sortTable[0x5988]=15107;   // ma
   sortTable[0x5ABD]=15108;   // ma
   sortTable[0x9A6C]=15109;   // ma
   sortTable[0x99AC]=15110;   // ma
   sortTable[0x561B]=15111;   // ma
   sortTable[0x9A82]=15112;   // ma
   sortTable[0x7F75]=15113;   // ma
   sortTable[0x9EBB]=15114;   // ma
   sortTable[0x7801]=15115;   // ma
   sortTable[0x78BC]=15116;   // ma
   sortTable[0x8682]=15117;   // ma
   sortTable[0x879E]=15118;   // ma
   sortTable[0x87C6]=15119;   // ma
   sortTable[0x739B]=15120;   // ma
   sortTable[0x5B37]=15121;   // ma
   sortTable[0x6769]=15122;   // ma
   sortTable[0x72B8]=15123;   // ma
   sortTable[0x551B]=15124;   // ma
   sortTable[0x7943]=15125;   // ma
   sortTable[0x7770]=15126;   // ma
   sortTable[0x79A1]=15127;   // ma
   sortTable[0x8534]=15128;   // ma
   sortTable[0x87C7]=15129;   // ma
   sortTable[0x9C22]=15130;   // ma
   sortTable[0x93B7]=15131;   // ma
   sortTable[0x99E1]=15132;   // ma
   sortTable[0x4E87]=15133;   // ma
   sortTable[0x508C]=15134;   // ma
   sortTable[0x561C]=15135;   // ma
   sortTable[0x5AF2]=15136;   // ma
   sortTable[0x5B24]=15137;   // ma
   sortTable[0x5B56]=15138;   // ma
   sortTable[0x69AA]=15139;   // ma
   sortTable[0x6EA4]=15140;   // ma
   sortTable[0x7298]=15141;   // ma
   sortTable[0x7341]=15142;   // ma
   sortTable[0x746A]=15143;   // ma
   sortTable[0x75F2]=15144;   // ma
   sortTable[0x7923]=15145;   // ma
   sortTable[0x9064]=15146;   // ma
   sortTable[0x9581]=15147;   // ma
   sortTable[0x9B15]=15148;   // ma
   sortTable[0x9DCC]=15149;   // ma
   sortTable[0x4E70]=15150;   // mai
   sortTable[0x8CB7]=15151;   // mai
   sortTable[0x5356]=15152;   // mai
   sortTable[0x8CE3]=15153;   // mai
   sortTable[0x9EA6]=15154;   // mai
   sortTable[0x9EA5]=15155;   // mai
   sortTable[0x8109]=15156;   // mai
   sortTable[0x8108]=15157;   // mai
   sortTable[0x57CB]=15158;   // mai
   sortTable[0x8FC8]=15159;   // mai
   sortTable[0x9081]=15160;   // mai
   sortTable[0x973E]=15161;   // mai
   sortTable[0x52A2]=15162;   // mai
   sortTable[0x9721]=15163;   // mai
   sortTable[0x836C]=15164;   // mai
   sortTable[0x85B6]=15165;   // mai
   sortTable[0x9DF6]=15166;   // mai
   sortTable[0x8552]=15167;   // mai
   sortTable[0x4F45]=15168;   // mai
   sortTable[0x52F1]=15169;   // mai
   sortTable[0x562A]=15170;   // mai
   sortTable[0x58F2]=15171;   // mai
   sortTable[0x8847]=15172;   // mai
   sortTable[0x9722]=15173;   // mai
   sortTable[0x6EE1]=15174;   // man
   sortTable[0x6EFF]=15175;   // man
   sortTable[0x6162]=15176;   // man
   sortTable[0x6F2B]=15177;   // man
   sortTable[0x9992]=15178;   // man
   sortTable[0x9945]=15179;   // man
   sortTable[0x7792]=15180;   // man
   sortTable[0x779E]=15181;   // man
   sortTable[0x66FC]=15182;   // man
   sortTable[0x86EE]=15183;   // man
   sortTable[0x8513]=15184;   // man
   sortTable[0x8C29]=15185;   // man
   sortTable[0x5E54]=15186;   // man
   sortTable[0x71B3]=15187;   // man
   sortTable[0x9794]=15188;   // man
   sortTable[0x7F26]=15189;   // man
   sortTable[0x9CD7]=15190;   // man
   sortTable[0x87A8]=15191;   // man
   sortTable[0x989F]=15192;   // man
   sortTable[0x5881]=15193;   // man
   sortTable[0x9B18]=15194;   // man
   sortTable[0x9124]=15195;   // man
   sortTable[0x9558]=15196;   // man
   sortTable[0x774C]=15197;   // man
   sortTable[0x883B]=15198;   // man
   sortTable[0x93CB]=15199;   // man
   sortTable[0x77D5]=15200;   // man
   sortTable[0x8954]=15201;   // man
   sortTable[0x8504]=15202;   // man
   sortTable[0x8B3E]=15203;   // man
   sortTable[0x9B17]=15204;   // man
   sortTable[0x9C3B]=15205;   // man
   sortTable[0x50C8]=15206;   // man
   sortTable[0x59CF]=15207;   // man
   sortTable[0x5ADA]=15208;   // man
   sortTable[0x5C58]=15209;   // man
   sortTable[0x6097]=15210;   // man
   sortTable[0x6172]=15211;   // man
   sortTable[0x6471]=15212;   // man
   sortTable[0x69FE]=15213;   // man
   sortTable[0x6A20]=15214;   // man
   sortTable[0x6E80]=15215;   // man
   sortTable[0x6FB7]=15216;   // man
   sortTable[0x734C]=15217;   // man
   sortTable[0x7E35]=15218;   // man
   sortTable[0x8630]=15219;   // man
   sortTable[0x87CE]=15220;   // man
   sortTable[0x93DD]=15221;   // man
   sortTable[0x9862]=15222;   // man
   sortTable[0x5FD9]=15223;   // mang
   sortTable[0x832B]=15224;   // mang
   sortTable[0x76F2]=15225;   // mang
   sortTable[0x8292]=15226;   // mang
   sortTable[0x6C13]=15227;   // mang
   sortTable[0x83BD]=15228;   // mang
   sortTable[0x87D2]=15229;   // mang
   sortTable[0x9099]=15230;   // mang
   sortTable[0x786D]=15231;   // mang
   sortTable[0x99F9]=15232;   // mang
   sortTable[0x94D3]=15233;   // mang
   sortTable[0x6F2D]=15234;   // mang
   sortTable[0x83BE]=15235;   // mang
   sortTable[0x7865]=15236;   // mang
   sortTable[0x86D6]=15237;   // mang
   sortTable[0x833B]=15238;   // mang
   sortTable[0x7B00]=15239;   // mang
   sortTable[0x880E]=15240;   // mang
   sortTable[0x91EF]=15241;   // mang
   sortTable[0x5402]=15242;   // mang
   sortTable[0x54E4]=15243;   // mang
   sortTable[0x58FE]=15244;   // mang
   sortTable[0x5A0F]=15245;   // mang
   sortTable[0x5C28]=15246;   // mang
   sortTable[0x5EAC]=15247;   // mang
   sortTable[0x607E]=15248;   // mang
   sortTable[0x6757]=15249;   // mang
   sortTable[0x6767]=15250;   // mang
   sortTable[0x6C52]=15251;   // mang
   sortTable[0x6D5D]=15252;   // mang
   sortTable[0x7264]=15253;   // mang
   sortTable[0x727B]=15254;   // mang
   sortTable[0x72F5]=15255;   // mang
   sortTable[0x75DD]=15256;   // mang
   sortTable[0x92E9]=15257;   // mang
   sortTable[0x6BDB]=15258;   // mao
   sortTable[0x77DB]=15259;   // mao
   sortTable[0x5E3D]=15260;   // mao
   sortTable[0x5192]=15261;   // mao
   sortTable[0x8C8C]=15262;   // mao
   sortTable[0x732B]=15263;   // mao
   sortTable[0x8C93]=15264;   // mao
   sortTable[0x8D38]=15265;   // mao
   sortTable[0x8CBF]=15266;   // mao
   sortTable[0x8302]=15267;   // mao
   sortTable[0x8305]=15268;   // mao
   sortTable[0x9AE6]=15269;   // mao
   sortTable[0x7266]=15270;   // mao
   sortTable[0x729B]=15271;   // mao
   sortTable[0x536F]=15272;   // mao
   sortTable[0x8004]=15273;   // mao
   sortTable[0x61CB]=15274;   // mao
   sortTable[0x7441]=15275;   // mao
   sortTable[0x6634]=15276;   // mao
   sortTable[0x88A4]=15277;   // mao
   sortTable[0x65C4]=15278;   // mao
   sortTable[0x951A]=15279;   // mao
   sortTable[0x87CA]=15280;   // mao
   sortTable[0x5CC1]=15281;   // mao
   sortTable[0x7780]=15282;   // mao
   sortTable[0x8306]=15283;   // mao
   sortTable[0x94C6]=15284;   // mao
   sortTable[0x770A]=15285;   // mao
   sortTable[0x911A]=15286;   // mao
   sortTable[0x6CD6]=15287;   // mao
   sortTable[0x8765]=15288;   // mao
   sortTable[0x912E]=15289;   // mao
   sortTable[0x9AF3]=15290;   // mao
   sortTable[0x82BC]=15291;   // mao
   sortTable[0x84E9]=15292;   // mao
   sortTable[0x9D9C]=15293;   // mao
   sortTable[0x9155]=15294;   // mao
   sortTable[0x8750]=15295;   // mao
   sortTable[0x8EDE]=15296;   // mao
   sortTable[0x9328]=15297;   // mao
   sortTable[0x7F5E]=15298;   // mao
   sortTable[0x4E6E]=15299;   // mao
   sortTable[0x515E]=15300;   // mao
   sortTable[0x5183]=15301;   // mao
   sortTable[0x5187]=15302;   // mao
   sortTable[0x5190]=15303;   // mao
   sortTable[0x5825]=15304;   // mao
   sortTable[0x5918]=15305;   // mao
   sortTable[0x5AA2]=15306;   // mao
   sortTable[0x5AF9]=15307;   // mao
   sortTable[0x6117]=15308;   // mao
   sortTable[0x623C]=15309;   // mao
   sortTable[0x6693]=15310;   // mao
   sortTable[0x6786]=15311;   // mao
   sortTable[0x67D5]=15312;   // mao
   sortTable[0x6959]=15313;   // mao
   sortTable[0x6BF7]=15314;   // mao
   sortTable[0x6C02]=15315;   // mao
   sortTable[0x6E35]=15316;   // mao
   sortTable[0x7683]=15317;   // mao
   sortTable[0x7B37]=15318;   // mao
   sortTable[0x843A]=15319;   // mao
   sortTable[0x8992]=15320;   // mao
   sortTable[0x4E48]=15321;   // me
   sortTable[0x9EBC]=15322;   // me
   sortTable[0x5692]=15323;   // me
   sortTable[0x569C]=15324;   // me
   sortTable[0x6FF9]=15325;   // me
   sortTable[0x7666]=15326;   // me
   sortTable[0x6CA1]=15327;   // mei
   sortTable[0x6C92]=15328;   // mei
   sortTable[0x6BCF]=15329;   // mei
   sortTable[0x7F8E]=15330;   // mei
   sortTable[0x7164]=15331;   // mei
   sortTable[0x59B9]=15332;   // mei
   sortTable[0x7709]=15333;   // mei
   sortTable[0x6885]=15334;   // mei
   sortTable[0x9709]=15335;   // mei
   sortTable[0x6627]=15336;   // mei
   sortTable[0x679A]=15337;   // mei
   sortTable[0x9541]=15338;   // mei
   sortTable[0x9382]=15339;   // mei
   sortTable[0x9176]=15340;   // mei
   sortTable[0x9EF4]=15341;   // mei
   sortTable[0x5A92]=15342;   // mei
   sortTable[0x5A9A]=15343;   // mei
   sortTable[0x73AB]=15344;   // mei
   sortTable[0x9B45]=15345;   // mei
   sortTable[0x5BD0]=15346;   // mei
   sortTable[0x8882]=15347;   // mei
   sortTable[0x5D4B]=15348;   // mei
   sortTable[0x6D7C]=15349;   // mei
   sortTable[0x6963]=15350;   // mei
   sortTable[0x6E44]=15351;   // mei
   sortTable[0x8393]=15352;   // mei
   sortTable[0x9545]=15353;   // mei
   sortTable[0x9E5B]=15354;   // mei
   sortTable[0x90FF]=15355;   // mei
   sortTable[0x7996]=15356;   // mei
   sortTable[0x7BC3]=15357;   // mei
   sortTable[0x771B]=15358;   // mei
   sortTable[0x97CE]=15359;   // mei
   sortTable[0x7A48]=15360;   // mei
   sortTable[0x8DCA]=15361;   // mei
   sortTable[0x7338]=15362;   // mei
   sortTable[0x862A]=15363;   // mei
   sortTable[0x92C2]=15364;   // mei
   sortTable[0x77C0]=15365;   // mei
   sortTable[0x8122]=15366;   // mei
   sortTable[0x8104]=15367;   // mei
   sortTable[0x9B3D]=15368;   // mei
   sortTable[0x7959]=15369;   // mei
   sortTable[0x9387]=15370;   // mei
   sortTable[0x51C2]=15371;   // mei
   sortTable[0x5445]=15372;   // mei
   sortTable[0x5746]=15373;   // mei
   sortTable[0x5833]=15374;   // mei
   sortTable[0x587A]=15375;   // mei
   sortTable[0x5A12]=15376;   // mei
   sortTable[0x5A84]=15377;   // mei
   sortTable[0x5ABA]=15378;   // mei
   sortTable[0x5B0D]=15379;   // mei
   sortTable[0x5D44]=15380;   // mei
   sortTable[0x5FBE]=15381;   // mei
   sortTable[0x62BA]=15382;   // mei
   sortTable[0x6334]=15383;   // mei
   sortTable[0x6517]=15384;   // mei
   sortTable[0x65C0]=15385;   // mei
   sortTable[0x6802]=15386;   // mei
   sortTable[0x6973]=15387;   // mei
   sortTable[0x69D1]=15388;   // mei
   sortTable[0x6BCE]=15389;   // mei
   sortTable[0x6CAC]=15390;   // mei
   sortTable[0x6E3C]=15391;   // mei
   sortTable[0x6E48]=15392;   // mei
   sortTable[0x715D]=15393;   // mei
   sortTable[0x71D8]=15394;   // mei
   sortTable[0x73FB]=15395;   // mei
   sortTable[0x7442]=15396;   // mei
   sortTable[0x75D7]=15397;   // mei
   sortTable[0x7742]=15398;   // mei
   sortTable[0x7778]=15399;   // mei
   sortTable[0x815C]=15400;   // mei
   sortTable[0x82FA]=15401;   // mei
   sortTable[0x847F]=15402;   // mei
   sortTable[0x875E]=15403;   // mei
   sortTable[0x8EBE]=15404;   // mei
   sortTable[0x9DA5]=15405;   // mei
   sortTable[0x9EE3]=15406;   // mei
   sortTable[0x4EEC]=15407;   // men
   sortTable[0x5011]=15408;   // men
   sortTable[0x95E8]=15409;   // men
   sortTable[0x9580]=15410;   // men
   sortTable[0x95F7]=15411;   // men
   sortTable[0x60B6]=15412;   // men
   sortTable[0x9494]=15413;   // men
   sortTable[0x626A]=15414;   // men
   sortTable[0x7116]=15415;   // men
   sortTable[0x61D1]=15416;   // men
   sortTable[0x83DB]=15417;   // men
   sortTable[0x864B]=15418;   // men
   sortTable[0x4EB9]=15419;   // men
   sortTable[0x61E3]=15420;   // men
   sortTable[0x636B]=15421;   // men
   sortTable[0x66AA]=15422;   // men
   sortTable[0x691A]=15423;   // men
   sortTable[0x71DC]=15424;   // men
   sortTable[0x73A7]=15425;   // men
   sortTable[0x748A]=15426;   // men
   sortTable[0x9346]=15427;   // men
   sortTable[0x9585]=15428;   // men
   sortTable[0x731B]=15429;   // meng
   sortTable[0x68A6]=15430;   // meng
   sortTable[0x5922]=15431;   // meng
   sortTable[0x76DF]=15432;   // meng
   sortTable[0x8499]=15433;   // meng
   sortTable[0x6726]=15434;   // meng
   sortTable[0x5B5F]=15435;   // meng
   sortTable[0x840C]=15436;   // meng
   sortTable[0x8813]=15437;   // meng
   sortTable[0x6AAC]=15438;   // meng
   sortTable[0x61F5]=15439;   // meng
   sortTable[0x867B]=15440;   // meng
   sortTable[0x9530]=15441;   // meng
   sortTable[0x8268]=15442;   // meng
   sortTable[0x824B]=15443;   // meng
   sortTable[0x52D0]=15444;   // meng
   sortTable[0x8722]=15445;   // meng
   sortTable[0x77C7]=15446;   // meng
   sortTable[0x750D]=15447;   // meng
   sortTable[0x77A2]=15448;   // meng
   sortTable[0x9133]=15449;   // meng
   sortTable[0x791E]=15450;   // meng
   sortTable[0x973F]=15451;   // meng
   sortTable[0x77D2]=15452;   // meng
   sortTable[0x9138]=15453;   // meng
   sortTable[0x995B]=15454;   // meng
   sortTable[0x986D]=15455;   // meng
   sortTable[0x8420]=15456;   // meng
   sortTable[0x9BCD]=15457;   // meng
   sortTable[0x9F06]=15458;   // meng
   sortTable[0x511A]=15459;   // meng
   sortTable[0x51A1]=15460;   // meng
   sortTable[0x5923]=15461;   // meng
   sortTable[0x5E6A]=15462;   // meng
   sortTable[0x61DC]=15463;   // meng
   sortTable[0x61DE]=15464;   // meng
   sortTable[0x63B9]=15465;   // meng
   sortTable[0x64DD]=15466;   // meng
   sortTable[0x66DA]=15467;   // meng
   sortTable[0x6A57]=15468;   // meng
   sortTable[0x6C0B]=15469;   // meng
   sortTable[0x6E95]=15470;   // meng
   sortTable[0x6FDB]=15471;   // meng
   sortTable[0x7374]=15472;   // meng
   sortTable[0x74FE]=15473;   // meng
   sortTable[0x753F]=15474;   // meng
   sortTable[0x8394]=15475;   // meng
   sortTable[0x8544]=15476;   // meng
   sortTable[0x8609]=15477;   // meng
   sortTable[0x8771]=15478;   // meng
   sortTable[0x9333]=15479;   // meng
   sortTable[0x9725]=15480;   // meng
   sortTable[0x9740]=15481;   // meng
   sortTable[0x9BED]=15482;   // meng
   sortTable[0x9E0F]=15483;   // meng
   sortTable[0x9E72]=15484;   // meng
   sortTable[0x7C73]=15485;   // mi
   sortTable[0x5BC6]=15486;   // mi
   sortTable[0x79D8]=15487;   // mi
   sortTable[0x8FF7]=15488;   // mi
   sortTable[0x871C]=15489;   // mi
   sortTable[0x772F]=15490;   // mi
   sortTable[0x7787]=15491;   // mi
   sortTable[0x5F25]=15492;   // mi
   sortTable[0x5F4C]=15493;   // mi
   sortTable[0x6CCC]=15494;   // mi
   sortTable[0x9761]=15495;   // mi
   sortTable[0x89C5]=15496;   // mi
   sortTable[0x8C1C]=15497;   // mi
   sortTable[0x7CDC]=15498;   // mi
   sortTable[0x8C27]=15499;   // mi
   sortTable[0x54AA]=15500;   // mi
   sortTable[0x5B93]=15501;   // mi
   sortTable[0x5F2D]=15502;   // mi
   sortTable[0x6549]=15503;   // mi
   sortTable[0x7E3B]=15504;   // mi
   sortTable[0x9E8B]=15505;   // mi
   sortTable[0x5627]=15506;   // mi
   sortTable[0x919A]=15507;   // mi
   sortTable[0x7962]=15508;   // mi
   sortTable[0x863C]=15509;   // mi
   sortTable[0x6C68]=15510;   // mi
   sortTable[0x8288]=15511;   // mi
   sortTable[0x7315]=15512;   // mi
   sortTable[0x5E42]=15513;   // mi
   sortTable[0x7955]=15514;   // mi
   sortTable[0x91BF]=15515;   // mi
   sortTable[0x899B]=15516;   // mi
   sortTable[0x9E9B]=15517;   // mi
   sortTable[0x8112]=15518;   // mi
   sortTable[0x9F0F]=15519;   // mi
   sortTable[0x9E8A]=15520;   // mi
   sortTable[0x91BE]=15521;   // mi
   sortTable[0x7F8B]=15522;   // mi
   sortTable[0x845E]=15523;   // mi
   sortTable[0x772B]=15524;   // mi
   sortTable[0x79B0]=15525;   // mi
   sortTable[0x7F83]=15526;   // mi
   sortTable[0x84BE]=15527;   // mi
   sortTable[0x8993]=15528;   // mi
   sortTable[0x8994]=15529;   // mi
   sortTable[0x8A78]=15530;   // mi
   sortTable[0x91C4]=15531;   // mi
   sortTable[0x9E0D]=15532;   // mi
   sortTable[0x7F59]=15533;   // mi
   sortTable[0x8524]=15534;   // mi
   sortTable[0x92A4]=15535;   // mi
   sortTable[0x4F8E]=15536;   // mi
   sortTable[0x5196]=15537;   // mi
   sortTable[0x519E]=15538;   // mi
   sortTable[0x51AA]=15539;   // mi
   sortTable[0x5853]=15540;   // mi
   sortTable[0x5B4A]=15541;   // mi
   sortTable[0x5BBB]=15542;   // mi
   sortTable[0x5CDA]=15543;   // mi
   sortTable[0x5E4E]=15544;   // mi
   sortTable[0x5E66]=15545;   // mi
   sortTable[0x6202]=15546;   // mi
   sortTable[0x64DF]=15547;   // mi
   sortTable[0x6520]=15548;   // mi
   sortTable[0x6993]=15549;   // mi
   sortTable[0x6A12]=15550;   // mi
   sortTable[0x6AC1]=15551;   // mi
   sortTable[0x6C95]=15552;   // mi
   sortTable[0x6CB5]=15553;   // mi
   sortTable[0x6D23]=15554;   // mi
   sortTable[0x6DE7]=15555;   // mi
   sortTable[0x6DFF]=15556;   // mi
   sortTable[0x6E33]=15557;   // mi
   sortTable[0x6EF5]=15558;   // mi
   sortTable[0x6F1E]=15559;   // mi
   sortTable[0x6FD4]=15560;   // mi
   sortTable[0x6FD7]=15561;   // mi
   sortTable[0x7030]=15562;   // mi
   sortTable[0x7056]=15563;   // mi
   sortTable[0x7190]=15564;   // mi
   sortTable[0x7222]=15565;   // mi
   sortTable[0x737C]=15566;   // mi
   sortTable[0x74D5]=15567;   // mi
   sortTable[0x7C1A]=15568;   // mi
   sortTable[0x7CF8]=15569;   // mi
   sortTable[0x851D]=15570;   // mi
   sortTable[0x85CC]=15571;   // mi
   sortTable[0x8B0E]=15572;   // mi
   sortTable[0x8B10]=15573;   // mi
   sortTable[0x957E]=15574;   // mi
   sortTable[0x9762]=15575;   // mian
   sortTable[0x68C9]=15576;   // mian
   sortTable[0x514D]=15577;   // mian
   sortTable[0x7720]=15578;   // mian
   sortTable[0x52C9]=15579;   // mian
   sortTable[0x7EF5]=15580;   // mian
   sortTable[0x7DBF]=15581;   // mian
   sortTable[0x7F05]=15582;   // mian
   sortTable[0x5195]=15583;   // mian
   sortTable[0x6C94]=15584;   // mian
   sortTable[0x6E4E]=15585;   // mian
   sortTable[0x5A29]=15586;   // mian
   sortTable[0x9EFE]=15587;   // mian
   sortTable[0x6E11]=15588;   // mian
   sortTable[0x817C]=15589;   // mian
   sortTable[0x7704]=15590;   // mian
   sortTable[0x81F1]=15591;   // mian
   sortTable[0x7D7B]=15592;   // mian
   sortTable[0x9BB8]=15593;   // mian
   sortTable[0x77CF]=15594;   // mian
   sortTable[0x9763]=15595;   // mian
   sortTable[0x77CA]=15596;   // mian
   sortTable[0x7DDC]=15597;   // mian
   sortTable[0x8752]=15598;   // mian
   sortTable[0x9EAA]=15599;   // mian
   sortTable[0x9EB5]=15600;   // mian
   sortTable[0x4E0F]=15601;   // mian
   sortTable[0x506D]=15602;   // mian
   sortTable[0x52D4]=15603;   // mian
   sortTable[0x5595]=15604;   // mian
   sortTable[0x5A42]=15605;   // mian
   sortTable[0x5A94]=15606;   // mian
   sortTable[0x5B35]=15607;   // mian
   sortTable[0x5B80]=15608;   // mian
   sortTable[0x6110]=15609;   // mian
   sortTable[0x6AB0]=15610;   // mian
   sortTable[0x6ACB]=15611;   // mian
   sortTable[0x6C45]=15612;   // mian
   sortTable[0x6FA0]=15613;   // mian
   sortTable[0x77C8]=15614;   // mian
   sortTable[0x7CC6]=15615;   // mian
   sortTable[0x7DEC]=15616;   // mian
   sortTable[0x8287]=15617;   // mian
   sortTable[0x8442]=15618;   // mian
   sortTable[0x9EAB]=15619;   // mian
   sortTable[0x9EBA]=15620;   // mian
   sortTable[0x9EFD]=15621;   // mian
   sortTable[0x79D2]=15622;   // miao
   sortTable[0x5999]=15623;   // miao
   sortTable[0x82D7]=15624;   // miao
   sortTable[0x63CF]=15625;   // miao
   sortTable[0x5E99]=15626;   // miao
   sortTable[0x5EDF]=15627;   // miao
   sortTable[0x6E3A]=15628;   // miao
   sortTable[0x7784]=15629;   // miao
   sortTable[0x7F2A]=15630;   // miao
   sortTable[0x9088]=15631;   // miao
   sortTable[0x85D0]=15632;   // miao
   sortTable[0x7F08]=15633;   // miao
   sortTable[0x7707]=15634;   // miao
   sortTable[0x6DFC]=15635;   // miao
   sortTable[0x676A]=15636;   // miao
   sortTable[0x55B5]=15637;   // miao
   sortTable[0x9E4B]=15638;   // miao
   sortTable[0x7DF2]=15639;   // miao
   sortTable[0x7BCE]=15640;   // miao
   sortTable[0x7DE2]=15641;   // miao
   sortTable[0x9D93]=15642;   // miao
   sortTable[0x5A8C]=15643;   // miao
   sortTable[0x5EBF]=15644;   // miao
   sortTable[0x7385]=15645;   // miao
   sortTable[0x7AD7]=15646;   // miao
   sortTable[0x9C59]=15647;   // miao
   sortTable[0x706D]=15648;   // mie
   sortTable[0x6EC5]=15649;   // mie
   sortTable[0x8511]=15650;   // mie
   sortTable[0x881B]=15651;   // mie
   sortTable[0x4E5C]=15652;   // mie
   sortTable[0x7BFE]=15653;   // mie
   sortTable[0x54A9]=15654;   // mie
   sortTable[0x884A]=15655;   // mie
   sortTable[0x8995]=15656;   // mie
   sortTable[0x9456]=15657;   // mie
   sortTable[0x9D13]=15658;   // mie
   sortTable[0x9C74]=15659;   // mie
   sortTable[0x5400]=15660;   // mie
   sortTable[0x54F6]=15661;   // mie
   sortTable[0x5B6D]=15662;   // mie
   sortTable[0x5E6D]=15663;   // mie
   sortTable[0x61F1]=15664;   // mie
   sortTable[0x6423]=15665;   // mie
   sortTable[0x6AD7]=15666;   // mie
   sortTable[0x70D5]=15667;   // mie
   sortTable[0x858E]=15668;   // mie
   sortTable[0x6C11]=15669;   // min
   sortTable[0x654F]=15670;   // min
   sortTable[0x62BF]=15671;   // min
   sortTable[0x95F5]=15672;   // min
   sortTable[0x95FD]=15673;   // min
   sortTable[0x60AF]=15674;   // min
   sortTable[0x7F17]=15675;   // min
   sortTable[0x610D]=15676;   // min
   sortTable[0x76BF]=15677;   // min
   sortTable[0x5CB7]=15678;   // min
   sortTable[0x6CEF]=15679;   // min
   sortTable[0x73C9]=15680;   // min
   sortTable[0x82E0]=15681;   // min
   sortTable[0x7DE1]=15682;   // min
   sortTable[0x7DCD]=15683;   // min
   sortTable[0x9CD8]=15684;   // min
   sortTable[0x7C22]=15685;   // min
   sortTable[0x9309]=15686;   // min
   sortTable[0x9231]=15687;   // min
   sortTable[0x76FF]=15688;   // min
   sortTable[0x7888]=15689;   // min
   sortTable[0x9C35]=15690;   // min
   sortTable[0x7B22]=15691;   // min
   sortTable[0x7F60]=15692;   // min
   sortTable[0x9594]=15693;   // min
   sortTable[0x50F6]=15694;   // min
   sortTable[0x51BA]=15695;   // min
   sortTable[0x5221]=15696;   // min
   sortTable[0x52C4]=15697;   // min
   sortTable[0x578A]=15698;   // min
   sortTable[0x59C4]=15699;   // min
   sortTable[0x5D0F]=15700;   // min
   sortTable[0x5FDE]=15701;   // min
   sortTable[0x600B]=15702;   // min
   sortTable[0x60FD]=15703;   // min
   sortTable[0x615C]=15704;   // min
   sortTable[0x61AB]=15705;   // min
   sortTable[0x636A]=15706;   // min
   sortTable[0x6543]=15707;   // min
   sortTable[0x656F]=15708;   // min
   sortTable[0x65FB]=15709;   // min
   sortTable[0x65FC]=15710;   // min
   sortTable[0x668B]=15711;   // min
   sortTable[0x6E63]=15712;   // min
   sortTable[0x6F63]=15713;   // min
   sortTable[0x7418]=15714;   // min
   sortTable[0x7449]=15715;   // min
   sortTable[0x75FB]=15716;   // min
   sortTable[0x7807]=15717;   // min
   sortTable[0x7B3D]=15718;   // min
   sortTable[0x8820]=15719;   // min
   sortTable[0x9372]=15720;   // min
   sortTable[0x95A9]=15721;   // min
   sortTable[0x9D16]=15722;   // min
   sortTable[0x547D]=15723;   // ming
   sortTable[0x660E]=15724;   // ming
   sortTable[0x540D]=15725;   // ming
   sortTable[0x9E23]=15726;   // ming
   sortTable[0x9CF4]=15727;   // ming
   sortTable[0x94ED]=15728;   // ming
   sortTable[0x51A5]=15729;   // ming
   sortTable[0x8317]=15730;   // ming
   sortTable[0x7791]=15731;   // ming
   sortTable[0x669D]=15732;   // ming
   sortTable[0x6E9F]=15733;   // ming
   sortTable[0x879F]=15734;   // ming
   sortTable[0x9169]=15735;   // ming
   sortTable[0x84C2]=15736;   // ming
   sortTable[0x7733]=15737;   // ming
   sortTable[0x8A7A]=15738;   // ming
   sortTable[0x910D]=15739;   // ming
   sortTable[0x9298]=15740;   // ming
   sortTable[0x7700]=15741;   // ming
   sortTable[0x89AD]=15742;   // ming
   sortTable[0x4F72]=15743;   // ming
   sortTable[0x51D5]=15744;   // ming
   sortTable[0x59F3]=15745;   // ming
   sortTable[0x5AC7]=15746;   // ming
   sortTable[0x614F]=15747;   // ming
   sortTable[0x63B5]=15748;   // ming
   sortTable[0x6719]=15749;   // ming
   sortTable[0x6927]=15750;   // ming
   sortTable[0x69A0]=15751;   // ming
   sortTable[0x6D3A]=15752;   // ming
   sortTable[0x733D]=15753;   // ming
   sortTable[0x8C2C]=15754;   // miu
   sortTable[0x8B2C]=15755;   // miu
   sortTable[0x6A21]=15756;   // mo
   sortTable[0x6478]=15757;   // mo
   sortTable[0x9ED8]=15758;   // mo
   sortTable[0x6F20]=15759;   // mo
   sortTable[0x78E8]=15760;   // mo
   sortTable[0x819C]=15761;   // mo
   sortTable[0x9B54]=15762;   // mo
   sortTable[0x672B]=15763;   // mo
   sortTable[0x58A8]=15764;   // mo
   sortTable[0x62B9]=15765;   // mo
   sortTable[0x83AB]=15766;   // mo
   sortTable[0x5BDE]=15767;   // mo
   sortTable[0x964C]=15768;   // mo
   sortTable[0x6CAB]=15769;   // mo
   sortTable[0x6469]=15770;   // mo
   sortTable[0x8611]=15771;   // mo
   sortTable[0x8C1F]=15772;   // mo
   sortTable[0x6479]=15773;   // mo
   sortTable[0x9EBD]=15774;   // mo
   sortTable[0x84E6]=15775;   // mo
   sortTable[0x6B81]=15776;   // mo
   sortTable[0x8309]=15777;   // mo
   sortTable[0x998D]=15778;   // mo
   sortTable[0x9546]=15779;   // mo
   sortTable[0x79E3]=15780;   // mo
   sortTable[0x5AEB]=15781;   // mo
   sortTable[0x977A]=15782;   // mo
   sortTable[0x8C8A]=15783;   // mo
   sortTable[0x763C]=15784;   // mo
   sortTable[0x9ED9]=15785;   // mo
   sortTable[0x8B29]=15786;   // mo
   sortTable[0x8C98]=15787;   // mo
   sortTable[0x7E86]=15788;   // mo
   sortTable[0x9EBF]=15789;   // mo
   sortTable[0x8031]=15790;   // mo
   sortTable[0x773D]=15791;   // mo
   sortTable[0x85E6]=15792;   // mo
   sortTable[0x8B28]=15793;   // mo
   sortTable[0x9B79]=15794;   // mo
   sortTable[0x9A40]=15795;   // mo
   sortTable[0x7790]=15796;   // mo
   sortTable[0x7CE2]=15797;   // mo
   sortTable[0x995D]=15798;   // mo
   sortTable[0x8C83]=15799;   // mo
   sortTable[0x771C]=15800;   // mo
   sortTable[0x781E]=15801;   // mo
   sortTable[0x9B69]=15802;   // mo
   sortTable[0x773F]=15803;   // mo
   sortTable[0x86E8]=15804;   // mo
   sortTable[0x9286]=15805;   // mo
   sortTable[0x93CC]=15806;   // mo
   sortTable[0x7C96]=15807;   // mo
   sortTable[0x87D4]=15808;   // mo
   sortTable[0x5298]=15809;   // mo
   sortTable[0x52B0]=15810;   // mo
   sortTable[0x551C]=15811;   // mo
   sortTable[0x55FC]=15812;   // mo
   sortTable[0x56A4]=15813;   // mo
   sortTable[0x56A9]=15814;   // mo
   sortTable[0x56B0]=15815;   // mo
   sortTable[0x573D]=15816;   // mo
   sortTable[0x587B]=15817;   // mo
   sortTable[0x59BA]=15818;   // mo
   sortTable[0x5AFC]=15819;   // mo
   sortTable[0x5C1B]=15820;   // mo
   sortTable[0x5E13]=15821;   // mo
   sortTable[0x5E1E]=15822;   // mo
   sortTable[0x5E85]=15823;   // mo
   sortTable[0x603D]=15824;   // mo
   sortTable[0x61E1]=15825;   // mo
   sortTable[0x64F5]=15826;   // mo
   sortTable[0x6629]=15827;   // mo
   sortTable[0x66AF]=15828;   // mo
   sortTable[0x67BA]=15829;   // mo
   sortTable[0x6A45]=15830;   // mo
   sortTable[0x6B7E]=15831;   // mo
   sortTable[0x6B7F]=15832;   // mo
   sortTable[0x6E50]=15833;   // mo
   sortTable[0x700E]=15834;   // mo
   sortTable[0x7205]=15835;   // mo
   sortTable[0x734F]=15836;   // mo
   sortTable[0x768C]=15837;   // mo
   sortTable[0x7799]=15838;   // mo
   sortTable[0x7933]=15839;   // mo
   sortTable[0x7D48]=15840;   // mo
   sortTable[0x8388]=15841;   // mo
   sortTable[0x9943]=15842;   // mo
   sortTable[0x9ACD]=15843;   // mo
   sortTable[0x67D0]=15844;   // mou
   sortTable[0x8C0B]=15845;   // mou
   sortTable[0x8B00]=15846;   // mou
   sortTable[0x725F]=15847;   // mou
   sortTable[0x7738]=15848;   // mou
   sortTable[0x4F94]=15849;   // mou
   sortTable[0x86D1]=15850;   // mou
   sortTable[0x936A]=15851;   // mou
   sortTable[0x54DE]=15852;   // mou
   sortTable[0x9EB0]=15853;   // mou
   sortTable[0x927E]=15854;   // mou
   sortTable[0x9D3E]=15855;   // mou
   sortTable[0x7E46]=15856;   // mou
   sortTable[0x52BA]=15857;   // mou
   sortTable[0x6048]=15858;   // mou
   sortTable[0x6D20]=15859;   // mou
   sortTable[0x77B4]=15860;   // mou
   sortTable[0x8E0E]=15861;   // mou
   sortTable[0x76EE]=15862;   // mu
   sortTable[0x6BCD]=15863;   // mu
   sortTable[0x6728]=15864;   // mu
   sortTable[0x5E55]=15865;   // mu
   sortTable[0x4EA9]=15866;   // mu
   sortTable[0x755D]=15867;   // mu
   sortTable[0x7267]=15868;   // mu
   sortTable[0x6155]=15869;   // mu
   sortTable[0x5893]=15870;   // mu
   sortTable[0x59C6]=15871;   // mu
   sortTable[0x7261]=15872;   // mu
   sortTable[0x62C7]=15873;   // mu
   sortTable[0x7A46]=15874;   // mu
   sortTable[0x66AE]=15875;   // mu
   sortTable[0x52DF]=15876;   // mu
   sortTable[0x7766]=15877;   // mu
   sortTable[0x6C90]=15878;   // mu
   sortTable[0x82DC]=15879;   // mu
   sortTable[0x94BC]=15880;   // mu
   sortTable[0x4EEB]=15881;   // mu
   sortTable[0x5776]=15882;   // mu
   sortTable[0x96EE]=15883;   // mu
   sortTable[0x9702]=15884;   // mu
   sortTable[0x8252]=15885;   // mu
   sortTable[0x7E38]=15886;   // mu
   sortTable[0x9267]=15887;   // mu
   sortTable[0x782A]=15888;   // mu
   sortTable[0x869E]=15889;   // mu
   sortTable[0x97AA]=15890;   // mu
   sortTable[0x51E9]=15891;   // mu
   sortTable[0x58B2]=15892;   // mu
   sortTable[0x5CD4]=15893;   // mu
   sortTable[0x5E59]=15894;   // mu
   sortTable[0x6154]=15895;   // mu
   sortTable[0x6730]=15896;   // mu
   sortTable[0x6958]=15897;   // mu
   sortTable[0x6BE3]=15898;   // mu
   sortTable[0x6BEA]=15899;   // mu
   sortTable[0x6C01]=15900;   // mu
   sortTable[0x7091]=15901;   // mu
   sortTable[0x7273]=15902;   // mu
   sortTable[0x72C7]=15903;   // mu
   sortTable[0x7546]=15904;   // mu
   sortTable[0x7552]=15905;   // mu
   sortTable[0x755E]=15906;   // mu
   sortTable[0x756E]=15907;   // mu
   sortTable[0x80DF]=15908;   // mu
   sortTable[0x83AF]=15909;   // mu
   sortTable[0x8E07]=15910;   // mu
   sortTable[0x926C]=15911;   // mu
   sortTable[0x90A3]=16384;   // na
   sortTable[0x54EA]=16385;   // na
   sortTable[0x62FF]=16386;   // na
   sortTable[0x7EB3]=16387;   // na
   sortTable[0x7D0D]=16388;   // na
   sortTable[0x5A1C]=16389;   // na
   sortTable[0x94A0]=16390;   // na
   sortTable[0x637A]=16391;   // na
   sortTable[0x8872]=16392;   // na
   sortTable[0x80AD]=16393;   // na
   sortTable[0x954E]=16394;   // na
   sortTable[0x8C7D]=16395;   // na
   sortTable[0x9779]=16396;   // na
   sortTable[0x9B76]=16397;   // na
   sortTable[0x88A6]=16398;   // na
   sortTable[0x93BF]=16399;   // na
   sortTable[0x8C80]=16400;   // na
   sortTable[0x8EDC]=16401;   // na
   sortTable[0x9209]=16402;   // na
   sortTable[0x84B3]=16403;   // na
   sortTable[0x4E78]=16404;   // na
   sortTable[0x55F1]=16405;   // na
   sortTable[0x59A0]=16406;   // na
   sortTable[0x62CF]=16407;   // na
   sortTable[0x6310]=16408;   // na
   sortTable[0x7B1D]=16409;   // na
   sortTable[0x96EB]=16410;   // na
   sortTable[0x5976]=16411;   // nai
   sortTable[0x8010]=16412;   // nai
   sortTable[0x4E43]=16413;   // nai
   sortTable[0x5948]=16414;   // nai
   sortTable[0x6C16]=16415;   // nai
   sortTable[0x9F10]=16416;   // nai
   sortTable[0x827F]=16417;   // nai
   sortTable[0x8418]=16418;   // nai
   sortTable[0x67F0]=16419;   // nai
   sortTable[0x800F]=16420;   // nai
   sortTable[0x91E2]=16421;   // nai
   sortTable[0x8FFA]=16422;   // nai
   sortTable[0x879A]=16423;   // nai
   sortTable[0x8926]=16424;   // nai
   sortTable[0x5037]=16425;   // nai
   sortTable[0x59B3]=16426;   // nai
   sortTable[0x5B2D]=16427;   // nai
   sortTable[0x5B7B]=16428;   // nai
   sortTable[0x5EFC]=16429;   // nai
   sortTable[0x6468]=16430;   // nai
   sortTable[0x6E3F]=16431;   // nai
   sortTable[0x718B]=16432;   // nai
   sortTable[0x7593]=16433;   // nai
   sortTable[0x8149]=16434;   // nai
   sortTable[0x933C]=16435;   // nai
   sortTable[0x96BE]=16436;   // nan
   sortTable[0x96E3]=16437;   // nan
   sortTable[0x5357]=16438;   // nan
   sortTable[0x7537]=16439;   // nan
   sortTable[0x5583]=16440;   // nan
   sortTable[0x6960]=16441;   // nan
   sortTable[0x8D67]=16442;   // nan
   sortTable[0x56E1]=16443;   // nan
   sortTable[0x877B]=16444;   // nan
   sortTable[0x8169]=16445;   // nan
   sortTable[0x8AF5]=16446;   // nan
   sortTable[0x4FBD]=16447;   // nan
   sortTable[0x5A1A]=16448;   // nan
   sortTable[0x5A7B]=16449;   // nan
   sortTable[0x6201]=16450;   // nan
   sortTable[0x63C7]=16451;   // nan
   sortTable[0x6694]=16452;   // nan
   sortTable[0x678F]=16453;   // nan
   sortTable[0x67AC]=16454;   // nan
   sortTable[0x67DF]=16455;   // nan
   sortTable[0x6E73]=16456;   // nan
   sortTable[0x7558]=16457;   // nan
   sortTable[0x83AE]=16458;   // nan
   sortTable[0x8433]=16459;   // nan
   sortTable[0x9056]=16460;   // nan
   sortTable[0x56CA]=16461;   // nang
   sortTable[0x9995]=16462;   // nang
   sortTable[0x66E9]=16463;   // nang
   sortTable[0x56D4]=16464;   // nang
   sortTable[0x652E]=16465;   // nang
   sortTable[0x9962]=16466;   // nang
   sortTable[0x8830]=16467;   // nang
   sortTable[0x4E6A]=16468;   // nang
   sortTable[0x513E]=16469;   // nang
   sortTable[0x56A2]=16470;   // nang
   sortTable[0x64C3]=16471;   // nang
   sortTable[0x6B1C]=16472;   // nang
   sortTable[0x7062]=16473;   // nang
   sortTable[0x8B68]=16474;   // nang
   sortTable[0x9B1E]=16475;   // nang
   sortTable[0x9F49]=16476;   // nang
   sortTable[0x8111]=16477;   // nao
   sortTable[0x8166]=16478;   // nao
   sortTable[0x95F9]=16479;   // nao
   sortTable[0x9B27]=16480;   // nao
   sortTable[0x607C]=16481;   // nao
   sortTable[0x60F1]=16482;   // nao
   sortTable[0x6320]=16483;   // nao
   sortTable[0x6DD6]=16484;   // nao
   sortTable[0x7459]=16485;   // nao
   sortTable[0x5476]=16486;   // nao
   sortTable[0x86F2]=16487;   // nao
   sortTable[0x94D9]=16488;   // nao
   sortTable[0x7847]=16489;   // nao
   sortTable[0x7331]=16490;   // nao
   sortTable[0x5B6C]=16491;   // nao
   sortTable[0x57B4]=16492;   // nao
   sortTable[0x81D1]=16493;   // nao
   sortTable[0x8B4A]=16494;   // nao
   sortTable[0x8133]=16495;   // nao
   sortTable[0x87EF]=16496;   // nao
   sortTable[0x8A49]=16497;   // nao
   sortTable[0x78AF]=16498;   // nao
   sortTable[0x5318]=16499;   // nao
   sortTable[0x5816]=16500;   // nao
   sortTable[0x5912]=16501;   // nao
   sortTable[0x5A65]=16502;   // nao
   sortTable[0x5AD0]=16503;   // nao
   sortTable[0x5CF1]=16504;   // nao
   sortTable[0x5DA9]=16505;   // nao
   sortTable[0x5DCE]=16506;   // nao
   sortTable[0x6013]=16507;   // nao
   sortTable[0x60A9]=16508;   // nao
   sortTable[0x61B9]=16509;   // nao
   sortTable[0x6493]=16510;   // nao
   sortTable[0x7376]=16511;   // nao
   sortTable[0x737F]=16512;   // nao
   sortTable[0x7899]=16513;   // nao
   sortTable[0x9403]=16514;   // nao
   sortTable[0x9599]=16515;   // nao
   sortTable[0x5462]=16516;   // ne
   sortTable[0x5450]=16517;   // ne
   sortTable[0x5436]=16518;   // ne
   sortTable[0x8BB7]=16519;   // ne
   sortTable[0x7732]=16520;   // ne
   sortTable[0x6290]=16521;   // ne
   sortTable[0x7592]=16522;   // ne
   sortTable[0x8A25]=16523;   // ne
   sortTable[0x5185]=16524;   // nei
   sortTable[0x5167]=16525;   // nei
   sortTable[0x9981]=16526;   // nei
   sortTable[0x9BBE]=16527;   // nei
   sortTable[0x9BD8]=16528;   // nei
   sortTable[0x812E]=16529;   // nei
   sortTable[0x8147]=16530;   // nei
   sortTable[0x9317]=16531;   // nei
   sortTable[0x9912]=16532;   // nei
   sortTable[0x5A1E]=16533;   // nei
   sortTable[0x6C1D]=16534;   // nei
   sortTable[0x5AE9]=16535;   // nen
   sortTable[0x6041]=16536;   // nen
   sortTable[0x5AF0]=16537;   // nen
   sortTable[0x80FD]=16538;   // neng
   sortTable[0x4F60]=16539;   // ni
   sortTable[0x6CE5]=16540;   // ni
   sortTable[0x62DF]=16541;   // ni
   sortTable[0x64EC]=16542;   // ni
   sortTable[0x5C3C]=16543;   // ni
   sortTable[0x9006]=16544;   // ni
   sortTable[0x59AE]=16545;   // ni
   sortTable[0x502A]=16546;   // ni
   sortTable[0x533F]=16547;   // ni
   sortTable[0x6EBA]=16548;   // ni
   sortTable[0x817B]=16549;   // ni
   sortTable[0x4F32]=16550;   // ni
   sortTable[0x9713]=16551;   // ni
   sortTable[0x6635]=16552;   // ni
   sortTable[0x7768]=16553;   // ni
   sortTable[0x65CE]=16554;   // ni
   sortTable[0x730A]=16555;   // ni
   sortTable[0x6029]=16556;   // ni
   sortTable[0x9CB5]=16557;   // ni
   sortTable[0x873A]=16558;   // ni
   sortTable[0x94CC]=16559;   // ni
   sortTable[0x9E91]=16560;   // ni
   sortTable[0x85BF]=16561;   // ni
   sortTable[0x8F17]=16562;   // ni
   sortTable[0x922E]=16563;   // ni
   sortTable[0x576D]=16564;   // ni
   sortTable[0x81A9]=16565;   // ni
   sortTable[0x81E1]=16566;   // ni
   sortTable[0x90F3]=16567;   // ni
   sortTable[0x8C8E]=16568;   // ni
   sortTable[0x82E8]=16569;   // ni
   sortTable[0x7E0C]=16570;   // ni
   sortTable[0x9BD3]=16571;   // ni
   sortTable[0x807B]=16572;   // ni
   sortTable[0x7724]=16573;   // ni
   sortTable[0x8063]=16574;   // ni
   sortTable[0x8FE1]=16575;   // ni
   sortTable[0x9F6F]=16576;   // ni
   sortTable[0x80D2]=16577;   // ni
   sortTable[0x815D]=16578;   // ni
   sortTable[0x8ABD]=16579;   // ni
   sortTable[0x8DDC]=16580;   // ni
   sortTable[0x9BE2]=16581;   // ni
   sortTable[0x4F31]=16582;   // ni
   sortTable[0x5117]=16583;   // ni
   sortTable[0x511E]=16584;   // ni
   sortTable[0x57FF]=16585;   // ni
   sortTable[0x5804]=16586;   // ni
   sortTable[0x5A57]=16587;   // ni
   sortTable[0x5ADF]=16588;   // ni
   sortTable[0x5B3A]=16589;   // ni
   sortTable[0x5B74]=16590;   // ni
   sortTable[0x5C54]=16591;   // ni
   sortTable[0x5C70]=16592;   // ni
   sortTable[0x60C4]=16593;   // ni
   sortTable[0x6135]=16594;   // ni
   sortTable[0x62B3]=16595;   // ni
   sortTable[0x6672]=16596;   // ni
   sortTable[0x66B1]=16597;   // ni
   sortTable[0x67C5]=16598;   // ni
   sortTable[0x68FF]=16599;   // ni
   sortTable[0x6AB7]=16600;   // ni
   sortTable[0x6C3C]=16601;   // ni
   sortTable[0x6DE3]=16602;   // ni
   sortTable[0x72D4]=16603;   // ni
   sortTable[0x79DC]=16604;   // ni
   sortTable[0x7C7E]=16605;   // ni
   sortTable[0x86AD]=16606;   // ni
   sortTable[0x88AE]=16607;   // ni
   sortTable[0x89EC]=16608;   // ni
   sortTable[0x96AC]=16609;   // ni
   sortTable[0x999C]=16610;   // ni
   sortTable[0x5E74]=16611;   // nian
   sortTable[0x5FF5]=16612;   // nian
   sortTable[0x9ECF]=16613;   // nian
   sortTable[0x637B]=16614;   // nian
   sortTable[0x78BE]=16615;   // nian
   sortTable[0x5EFF]=16616;   // nian
   sortTable[0x64B5]=16617;   // nian
   sortTable[0x6506]=16618;   // nian
   sortTable[0x8F87]=16619;   // nian
   sortTable[0x62C8]=16620;   // nian
   sortTable[0x8F97]=16621;   // nian
   sortTable[0x9C87]=16622;   // nian
   sortTable[0x852B]=16623;   // nian
   sortTable[0x9CB6]=16624;   // nian
   sortTable[0x57DD]=16625;   // nian
   sortTable[0x8E68]=16626;   // nian
   sortTable[0x9F30]=16627;   // nian
   sortTable[0x824C]=16628;   // nian
   sortTable[0x8E4D]=16629;   // nian
   sortTable[0x8DC8]=16630;   // nian
   sortTable[0x8F26]=16631;   // nian
   sortTable[0x9B8E]=16632;   // nian
   sortTable[0x5344]=16633;   // nian
   sortTable[0x54D6]=16634;   // nian
   sortTable[0x5538]=16635;   // nian
   sortTable[0x59E9]=16636;   // nian
   sortTable[0x649A]=16637;   // nian
   sortTable[0x6D8A]=16638;   // nian
   sortTable[0x6DF0]=16639;   // nian
   sortTable[0x713E]=16640;   // nian
   sortTable[0x79CA]=16641;   // nian
   sortTable[0x79E5]=16642;   // nian
   sortTable[0x7C10]=16643;   // nian
   sortTable[0x8E8E]=16644;   // nian
   sortTable[0x9BF0]=16645;   // nian
   sortTable[0x9D47]=16646;   // nian
   sortTable[0x5A18]=16647;   // niang
   sortTable[0x917F]=16648;   // niang
   sortTable[0x91C0]=16649;   // niang
   sortTable[0x5B22]=16650;   // niang
   sortTable[0x5B43]=16651;   // niang
   sortTable[0x91B8]=16652;   // niang
   sortTable[0x9E1F]=16653;   // niao
   sortTable[0x9CE5]=16654;   // niao
   sortTable[0x5C3F]=16655;   // niao
   sortTable[0x8885]=16656;   // niao
   sortTable[0x5B32]=16657;   // niao
   sortTable[0x8311]=16658;   // niao
   sortTable[0x8132]=16659;   // niao
   sortTable[0x892D]=16660;   // niao
   sortTable[0x8526]=16661;   // niao
   sortTable[0x5ACB]=16662;   // niao
   sortTable[0x5B1D]=16663;   // niao
   sortTable[0x6A22]=16664;   // niao
   sortTable[0x88CA]=16665;   // niao
   sortTable[0x634F]=16666;   // nie
   sortTable[0x6D85]=16667;   // nie
   sortTable[0x5B7D]=16668;   // nie
   sortTable[0x8042]=16669;   // nie
   sortTable[0x8E51]=16670;   // nie
   sortTable[0x55EB]=16671;   // nie
   sortTable[0x556E]=16672;   // nie
   sortTable[0x81EC]=16673;   // nie
   sortTable[0x8616]=16674;   // nie
   sortTable[0x954D]=16675;   // nie
   sortTable[0x954A]=16676;   // nie
   sortTable[0x989E]=16677;   // nie
   sortTable[0x9667]=16678;   // nie
   sortTable[0x9F67]=16679;   // nie
   sortTable[0x7CF5]=16680;   // nie
   sortTable[0x95D1]=16681;   // nie
   sortTable[0x7CF1]=16682;   // nie
   sortTable[0x81F2]=16683;   // nie
   sortTable[0x82F6]=16684;   // nie
   sortTable[0x83CD]=16685;   // nie
   sortTable[0x8B98]=16686;   // nie
   sortTable[0x8825]=16687;   // nie
   sortTable[0x7C4B]=16688;   // nie
   sortTable[0x9480]=16689;   // nie
   sortTable[0x9873]=16690;   // nie
   sortTable[0x7BDE]=16691;   // nie
   sortTable[0x9477]=16692;   // nie
   sortTable[0x8076]=16693;   // nie
   sortTable[0x93B3]=16694;   // nie
   sortTable[0x9689]=16695;   // nie
   sortTable[0x55A6]=16696;   // nie
   sortTable[0x565B]=16697;   // nie
   sortTable[0x5699]=16698;   // nie
   sortTable[0x56C1]=16699;   // nie
   sortTable[0x56D3]=16700;   // nie
   sortTable[0x573C]=16701;   // nie
   sortTable[0x5B7C]=16702;   // nie
   sortTable[0x5D72]=16703;   // nie
   sortTable[0x5DAD]=16704;   // nie
   sortTable[0x5DD5]=16705;   // nie
   sortTable[0x5E07]=16706;   // nie
   sortTable[0x60D7]=16707;   // nie
   sortTable[0x63D1]=16708;   // nie
   sortTable[0x6470]=16709;   // nie
   sortTable[0x655C]=16710;   // nie
   sortTable[0x67BF]=16711;   // nie
   sortTable[0x69F7]=16712;   // nie
   sortTable[0x6AF1]=16713;   // nie
   sortTable[0x6E7C]=16714;   // nie
   sortTable[0x75C6]=16715;   // nie
   sortTable[0x8E02]=16716;   // nie
   sortTable[0x8E17]=16717;   // nie
   sortTable[0x8EA1]=16718;   // nie
   sortTable[0x931C]=16719;   // nie
   sortTable[0x9448]=16720;   // nie
   sortTable[0x60A8]=16721;   // nin
   sortTable[0x56DC]=16722;   // nin
   sortTable[0x62F0]=16723;   // nin
   sortTable[0x810C]=16724;   // nin
   sortTable[0x51DD]=16725;   // ning
   sortTable[0x62E7]=16726;   // ning
   sortTable[0x64F0]=16727;   // ning
   sortTable[0x5B81]=16728;   // ning
   sortTable[0x5BE7]=16729;   // ning
   sortTable[0x549B]=16730;   // ning
   sortTable[0x5680]=16731;   // ning
   sortTable[0x4F5E]=16732;   // ning
   sortTable[0x72DE]=16733;   // ning
   sortTable[0x752F]=16734;   // ning
   sortTable[0x6CDE]=16735;   // ning
   sortTable[0x67E0]=16736;   // ning
   sortTable[0x804D]=16737;   // ning
   sortTable[0x82E7]=16738;   // ning
   sortTable[0x9E0B]=16739;   // ning
   sortTable[0x8079]=16740;   // ning
   sortTable[0x77C3]=16741;   // ning
   sortTable[0x9B21]=16742;   // ning
   sortTable[0x4FAB]=16743;   // ning
   sortTable[0x511C]=16744;   // ning
   sortTable[0x5B23]=16745;   // ning
   sortTable[0x5BCD]=16746;   // ning
   sortTable[0x5BD5]=16747;   // ning
   sortTable[0x5BD7]=16748;   // ning
   sortTable[0x5BDC]=16749;   // ning
   sortTable[0x6A63]=16750;   // ning
   sortTable[0x6AB8]=16751;   // ning
   sortTable[0x6F9D]=16752;   // ning
   sortTable[0x6FD8]=16753;   // ning
   sortTable[0x7370]=16754;   // ning
   sortTable[0x85B4]=16755;   // ning
   sortTable[0x944F]=16756;   // ning
   sortTable[0x725B]=16757;   // niu
   sortTable[0x626D]=16758;   // niu
   sortTable[0x7EBD]=16759;   // niu
   sortTable[0x7D10]=16760;   // niu
   sortTable[0x94AE]=16761;   // niu
   sortTable[0x599E]=16762;   // niu
   sortTable[0x5FF8]=16763;   // niu
   sortTable[0x72C3]=16764;   // niu
   sortTable[0x8842]=16765;   // niu
   sortTable[0x9775]=16766;   // niu
   sortTable[0x83A5]=16767;   // niu
   sortTable[0x9215]=16768;   // niu
   sortTable[0x6C7C]=16769;   // niu
   sortTable[0x7084]=16770;   // niu
   sortTable[0x725C]=16771;   // niu
   sortTable[0x519C]=16772;   // nong
   sortTable[0x8FB2]=16773;   // nong
   sortTable[0x5F04]=16774;   // nong
   sortTable[0x6D53]=16775;   // nong
   sortTable[0x6FC3]=16776;   // nong
   sortTable[0x4FAC]=16777;   // nong
   sortTable[0x54DD]=16778;   // nong
   sortTable[0x8113]=16779;   // nong
   sortTable[0x79FE]=16780;   // nong
   sortTable[0x91B2]=16781;   // nong
   sortTable[0x81BF]=16782;   // nong
   sortTable[0x7A60]=16783;   // nong
   sortTable[0x857D]=16784;   // nong
   sortTable[0x895B]=16785;   // nong
   sortTable[0x7E77]=16786;   // nong
   sortTable[0x5102]=16787;   // nong
   sortTable[0x5665]=16788;   // nong
   sortTable[0x630A]=16789;   // nong
   sortTable[0x6A82]=16790;   // nong
   sortTable[0x6B01]=16791;   // nong
   sortTable[0x71F6]=16792;   // nong
   sortTable[0x7651]=16793;   // nong
   sortTable[0x79AF]=16794;   // nong
   sortTable[0x8FB3]=16795;   // nong
   sortTable[0x9F48]=16796;   // nong
   sortTable[0x8028]=16797;   // nou
   sortTable[0x7FBA]=16798;   // nou
   sortTable[0x941E]=16799;   // nou
   sortTable[0x5542]=16800;   // nou
   sortTable[0x69C8]=16801;   // nou
   sortTable[0x6ABD]=16802;   // nou
   sortTable[0x7373]=16803;   // nou
   sortTable[0x8B73]=16804;   // nou
   sortTable[0x9392]=16805;   // nou
   sortTable[0x52AA]=16806;   // nu
   sortTable[0x6012]=16807;   // nu
   sortTable[0x5974]=16808;   // nu
   sortTable[0x5F29]=16809;   // nu
   sortTable[0x5B65]=16810;   // nu
   sortTable[0x9A7D]=16811;   // nu
   sortTable[0x80EC]=16812;   // nu
   sortTable[0x782E]=16813;   // nu
   sortTable[0x7B2F]=16814;   // nu
   sortTable[0x4F2E]=16815;   // nu
   sortTable[0x5089]=16816;   // nu
   sortTable[0x6419]=16817;   // nu
   sortTable[0x99D1]=16818;   // nu
   sortTable[0x6696]=16819;   // nuan
   sortTable[0x992A]=16820;   // nuan
   sortTable[0x597B]=16821;   // nuan
   sortTable[0x6E1C]=16822;   // nuan
   sortTable[0x7156]=16823;   // nuan
   sortTable[0x7157]=16824;   // nuan
   sortTable[0x8650]=16825;   // nüe
   sortTable[0x759F]=16826;   // nüe
   sortTable[0x7878]=16827;   // nüe
   sortTable[0x7627]=16828;   // nüe
   sortTable[0x9EC1]=16829;   // nun
   sortTable[0x8BFA]=16830;   // nuo
   sortTable[0x632A]=16831;   // nuo
   sortTable[0x61E6]=16832;   // nuo
   sortTable[0x50A9]=16833;   // nuo
   sortTable[0x558F]=16834;   // nuo
   sortTable[0x7CEF]=16835;   // nuo
   sortTable[0x6426]=16836;   // nuo
   sortTable[0x9518]=16837;   // nuo
   sortTable[0x8E43]=16838;   // nuo
   sortTable[0x90CD]=16839;   // nuo
   sortTable[0x7A2C]=16840;   // nuo
   sortTable[0x513A]=16841;   // nuo
   sortTable[0x611E]=16842;   // nuo
   sortTable[0x61E7]=16843;   // nuo
   sortTable[0x63BF]=16844;   // nuo
   sortTable[0x643B]=16845;   // nuo
   sortTable[0x689B]=16846;   // nuo
   sortTable[0x6992]=16847;   // nuo
   sortTable[0x6A60]=16848;   // nuo
   sortTable[0x7A64]=16849;   // nuo
   sortTable[0x7CD1]=16850;   // nuo
   sortTable[0x7CE5]=16851;   // nuo
   sortTable[0x8AFE]=16852;   // nuo
   sortTable[0x903D]=16853;   // nuo
   sortTable[0x5973]=16854;   // nv
   sortTable[0x9495]=16855;   // nv
   sortTable[0x8844]=16856;   // nv
   sortTable[0x6067]=16857;   // nv
   sortTable[0x7C79]=16858;   // nv
   sortTable[0x6712]=16859;   // nv
   sortTable[0x6C91]=16860;   // nv
   sortTable[0x91F9]=16861;   // nv
   sortTable[0x5662]=17152;   // o
   sortTable[0x5594]=17153;   // o
   sortTable[0x54E6]=17154;   // o
   sortTable[0x7B7D]=17155;   // o
   sortTable[0x5076]=17156;   // ou
   sortTable[0x6B27]=17157;   // ou
   sortTable[0x6B50]=17158;   // ou
   sortTable[0x9E25]=17159;   // ou
   sortTable[0x9DD7]=17160;   // ou
   sortTable[0x5455]=17161;   // ou
   sortTable[0x6BB4]=17162;   // ou
   sortTable[0x85D5]=17163;   // ou
   sortTable[0x74EF]=17164;   // ou
   sortTable[0x6CA4]=17165;   // ou
   sortTable[0x8BB4]=17166;   // ou
   sortTable[0x8026]=17167;   // ou
   sortTable[0x6004]=17168;   // ou
   sortTable[0x8B33]=17169;   // ou
   sortTable[0x8545]=17170;   // ou
   sortTable[0x8162]=17171;   // ou
   sortTable[0x93C2]=17172;   // ou
   sortTable[0x9F75]=17173;   // ou
   sortTable[0x85F2]=17174;   // ou
   sortTable[0x5418]=17175;   // ou
   sortTable[0x5614]=17176;   // ou
   sortTable[0x5878]=17177;   // ou
   sortTable[0x616A]=17178;   // ou
   sortTable[0x6AD9]=17179;   // ou
   sortTable[0x6BC6]=17180;   // ou
   sortTable[0x6F1A]=17181;   // ou
   sortTable[0x71B0]=17182;   // ou
   sortTable[0x750C]=17183;   // ou
   sortTable[0x8192]=17184;   // ou
   sortTable[0x9D0E]=17185;   // ou
   sortTable[0x6015]=17664;   // pa
   sortTable[0x722C]=17665;   // pa
   sortTable[0x556A]=17666;   // pa
   sortTable[0x8DB4]=17667;   // pa
   sortTable[0x5E15]=17668;   // pa
   sortTable[0x7436]=17669;   // pa
   sortTable[0x8469]=17670;   // pa
   sortTable[0x6777]=17671;   // pa
   sortTable[0x7B62]=17672;   // pa
   sortTable[0x8899]=17673;   // pa
   sortTable[0x8225]=17674;   // pa
   sortTable[0x5991]=17675;   // pa
   sortTable[0x5E0A]=17676;   // pa
   sortTable[0x63B1]=17677;   // pa
   sortTable[0x6F56]=17678;   // pa
   sortTable[0x7685]=17679;   // pa
   sortTable[0x6D3E]=17680;   // pai
   sortTable[0x6392]=17681;   // pai
   sortTable[0x62CD]=17682;   // pai
   sortTable[0x724C]=17683;   // pai
   sortTable[0x5F98]=17684;   // pai
   sortTable[0x6E43]=17685;   // pai
   sortTable[0x4FF3]=17686;   // pai
   sortTable[0x54CC]=17687;   // pai
   sortTable[0x848E]=17688;   // pai
   sortTable[0x7C30]=17689;   // pai
   sortTable[0x7C32]=17690;   // pai
   sortTable[0x8F2B]=17691;   // pai
   sortTable[0x5EF9]=17692;   // pai
   sortTable[0x68D1]=17693;   // pai
   sortTable[0x72A4]=17694;   // pai
   sortTable[0x7305]=17695;   // pai
   sortTable[0x9383]=17696;   // pai
   sortTable[0x5224]=17697;   // pan
   sortTable[0x76D8]=17698;   // pan
   sortTable[0x76E4]=17699;   // pan
   sortTable[0x76FC]=17700;   // pan
   sortTable[0x53DB]=17701;   // pan
   sortTable[0x6500]=17702;   // pan
   sortTable[0x7554]=17703;   // pan
   sortTable[0x6F58]=17704;   // pan
   sortTable[0x62DA]=17705;   // pan
   sortTable[0x78D0]=17706;   // pan
   sortTable[0x87E0]=17707;   // pan
   sortTable[0x88A2]=17708;   // pan
   sortTable[0x8E52]=17709;   // pan
   sortTable[0x6CEE]=17710;   // pan
   sortTable[0x97B6]=17711;   // pan
   sortTable[0x78FB]=17712;   // pan
   sortTable[0x92EC]=17713;   // pan
   sortTable[0x897B]=17714;   // pan
   sortTable[0x7705]=17715;   // pan
   sortTable[0x9816]=17716;   // pan
   sortTable[0x7E0F]=17717;   // pan
   sortTable[0x8DD8]=17718;   // pan
   sortTable[0x8E63]=17719;   // pan
   sortTable[0x7819]=17720;   // pan
   sortTable[0x947B]=17721;   // pan
   sortTable[0x84B0]=17722;   // pan
   sortTable[0x51B8]=17723;   // pan
   sortTable[0x5ABB]=17724;   // pan
   sortTable[0x5E4B]=17725;   // pan
   sortTable[0x642B]=17726;   // pan
   sortTable[0x69C3]=17727;   // pan
   sortTable[0x6C9C]=17728;   // pan
   sortTable[0x6D00]=17729;   // pan
   sortTable[0x6EBF]=17730;   // pan
   sortTable[0x700A]=17731;   // pan
   sortTable[0x708D]=17732;   // pan
   sortTable[0x723F]=17733;   // pan
   sortTable[0x7249]=17734;   // pan
   sortTable[0x7568]=17735;   // pan
   sortTable[0x8041]=17736;   // pan
   sortTable[0x8A4A]=17737;   // pan
   sortTable[0x939C]=17738;   // pan
   sortTable[0x9D65]=17739;   // pan
   sortTable[0x65C1]=17740;   // pang
   sortTable[0x80D6]=17741;   // pang
   sortTable[0x4E53]=17742;   // pang
   sortTable[0x5E9E]=17743;   // pang
   sortTable[0x9F90]=17744;   // pang
   sortTable[0x6EC2]=17745;   // pang
   sortTable[0x8783]=17746;   // pang
   sortTable[0x802A]=17747;   // pang
   sortTable[0x9004]=17748;   // pang
   sortTable[0x96F1]=17749;   // pang
   sortTable[0x9CD1]=17750;   // pang
   sortTable[0x9F8E]=17751;   // pang
   sortTable[0x5390]=17752;   // pang
   sortTable[0x5396]=17753;   // pang
   sortTable[0x55D9]=17754;   // pang
   sortTable[0x5ACE]=17755;   // pang
   sortTable[0x5FAC]=17756;   // pang
   sortTable[0x6C97]=17757;   // pang
   sortTable[0x7090]=17758;   // pang
   sortTable[0x80A8]=17759;   // pang
   sortTable[0x80EE]=17760;   // pang
   sortTable[0x8196]=17761;   // pang
   sortTable[0x823D]=17762;   // pang
   sortTable[0x89AB]=17763;   // pang
   sortTable[0x9736]=17764;   // pang
   sortTable[0x8DD1]=17765;   // pao
   sortTable[0x70AE]=17766;   // pao
   sortTable[0x6CE1]=17767;   // pao
   sortTable[0x629B]=17768;   // pao
   sortTable[0x62CB]=17769;   // pao
   sortTable[0x888D]=17770;   // pao
   sortTable[0x5486]=17771;   // pao
   sortTable[0x5228]=17772;   // pao
   sortTable[0x5E96]=17773;   // pao
   sortTable[0x7832]=17774;   // pao
   sortTable[0x530F]=17775;   // pao
   sortTable[0x75B1]=17776;   // pao
   sortTable[0x812C]=17777;   // pao
   sortTable[0x72CD]=17778;   // pao
   sortTable[0x9E83]=17779;   // pao
   sortTable[0x792E]=17780;   // pao
   sortTable[0x9784]=17781;   // pao
   sortTable[0x9E85]=17782;   // pao
   sortTable[0x791F]=17783;   // pao
   sortTable[0x8422]=17784;   // pao
   sortTable[0x891C]=17785;   // pao
   sortTable[0x5789]=17786;   // pao
   sortTable[0x5945]=17787;   // pao
   sortTable[0x70B0]=17788;   // pao
   sortTable[0x722E]=17789;   // pao
   sortTable[0x76B0]=17790;   // pao
   sortTable[0x8EF3]=17791;   // pao
   sortTable[0x9EAD]=17792;   // pao
   sortTable[0x914D]=17793;   // pei
   sortTable[0x57F9]=17794;   // pei
   sortTable[0x966A]=17795;   // pei
   sortTable[0x5478]=17796;   // pei
   sortTable[0x4F69]=17797;   // pei
   sortTable[0x8D54]=17798;   // pei
   sortTable[0x8CE0]=17799;   // pei
   sortTable[0x6C9B]=17800;   // pei
   sortTable[0x88F4]=17801;   // pei
   sortTable[0x8F94]=17802;   // pei
   sortTable[0x80DA]=17803;   // pei
   sortTable[0x65C6]=17804;   // pei
   sortTable[0x952B]=17805;   // pei
   sortTable[0x5E14]=17806;   // pei
   sortTable[0x9708]=17807;   // pei
   sortTable[0x9185]=17808;   // pei
   sortTable[0x8843]=17809;   // pei
   sortTable[0x84DC]=17810;   // pei
   sortTable[0x80A7]=17811;   // pei
   sortTable[0x99CD]=17812;   // pei
   sortTable[0x4F02]=17813;   // pei
   sortTable[0x4FD6]=17814;   // pei
   sortTable[0x59F5]=17815;   // pei
   sortTable[0x5D8F]=17816;   // pei
   sortTable[0x600C]=17817;   // pei
   sortTable[0x65BE]=17818;   // pei
   sortTable[0x67F8]=17819;   // pei
   sortTable[0x6BF0]=17820;   // pei
   sortTable[0x6D7F]=17821;   // pei
   sortTable[0x73EE]=17822;   // pei
   sortTable[0x7B29]=17823;   // pei
   sortTable[0x88F5]=17824;   // pei
   sortTable[0x8F61]=17825;   // pei
   sortTable[0x962B]=17826;   // pei
   sortTable[0x99B7]=17827;   // pei
   sortTable[0x76C6]=17828;   // pen
   sortTable[0x55B7]=17829;   // pen
   sortTable[0x5674]=17830;   // pen
   sortTable[0x6E53]=17831;   // pen
   sortTable[0x8450]=17832;   // pen
   sortTable[0x7FF8]=17833;   // pen
   sortTable[0x5460]=17834;   // pen
   sortTable[0x55AF]=17835;   // pen
   sortTable[0x6B55]=17836;   // pen
   sortTable[0x74EB]=17837;   // pen
   sortTable[0x670B]=17838;   // peng
   sortTable[0x78B0]=17839;   // peng
   sortTable[0x6367]=17840;   // peng
   sortTable[0x68DA]=17841;   // peng
   sortTable[0x81A8]=17842;   // peng
   sortTable[0x84EC]=17843;   // peng
   sortTable[0x6026]=17844;   // peng
   sortTable[0x7BF7]=17845;   // peng
   sortTable[0x7830]=17846;   // peng
   sortTable[0x6F8E]=17847;   // peng
   sortTable[0x5F6D]=17848;   // peng
   sortTable[0x9E4F]=17849;   // peng
   sortTable[0x70F9]=17850;   // peng
   sortTable[0x580B]=17851;   // peng
   sortTable[0x62A8]=17852;   // peng
   sortTable[0x87DB]=17853;   // peng
   sortTable[0x562D]=17854;   // peng
   sortTable[0x787C]=17855;   // peng
   sortTable[0x8283]=17856;   // peng
   sortTable[0x959B]=17857;   // peng
   sortTable[0x8F23]=17858;   // peng
   sortTable[0x7BE3]=17859;   // peng
   sortTable[0x9B05]=17860;   // peng
   sortTable[0x97FC]=17861;   // peng
   sortTable[0x78DE]=17862;   // peng
   sortTable[0x7E84]=17863;   // peng
   sortTable[0x8EEF]=17864;   // peng
   sortTable[0x9AFC]=17865;   // peng
   sortTable[0x7AFC]=17866;   // peng
   sortTable[0x8E2B]=17867;   // peng
   sortTable[0x930B]=17868;   // peng
   sortTable[0x97F8]=17869;   // peng
   sortTable[0x9D6C]=17870;   // peng
   sortTable[0x5017]=17871;   // peng
   sortTable[0x527B]=17872;   // peng
   sortTable[0x5309]=17873;   // peng
   sortTable[0x5873]=17874;   // peng
   sortTable[0x5F38]=17875;   // peng
   sortTable[0x6072]=17876;   // peng
   sortTable[0x6189]=17877;   // peng
   sortTable[0x6337]=17878;   // peng
   sortTable[0x63BD]=17879;   // peng
   sortTable[0x6888]=17880;   // peng
   sortTable[0x6916]=17881;   // peng
   sortTable[0x692A]=17882;   // peng
   sortTable[0x69F0]=17883;   // peng
   sortTable[0x6A25]=17884;   // peng
   sortTable[0x6DCE]=17885;   // peng
   sortTable[0x6F30]=17886;   // peng
   sortTable[0x71A2]=17887;   // peng
   sortTable[0x768F]=17888;   // peng
   sortTable[0x7851]=17889;   // peng
   sortTable[0x7A1D]=17890;   // peng
   sortTable[0x8391]=17891;   // peng
   sortTable[0x87DA]=17892;   // peng
   sortTable[0x945D]=17893;   // peng
   sortTable[0x9A2F]=17894;   // peng
   sortTable[0x9B14]=17895;   // peng
   sortTable[0x6279]=17896;   // pi
   sortTable[0x76AE]=17897;   // pi
   sortTable[0x62AB]=17898;   // pi
   sortTable[0x813E]=17899;   // pi
   sortTable[0x5339]=17900;   // pi
   sortTable[0x75B2]=17901;   // pi
   sortTable[0x8F9F]=17902;   // pi
   sortTable[0x5C41]=17903;   // pi
   sortTable[0x8B6C]=17904;   // pi
   sortTable[0x576F]=17905;   // pi
   sortTable[0x5288]=17906;   // pi
   sortTable[0x5564]=17907;   // pi
   sortTable[0x50FB]=17908;   // pi
   sortTable[0x4E15]=17909;   // pi
   sortTable[0x6BD7]=17910;   // pi
   sortTable[0x7435]=17911;   // pi
   sortTable[0x9739]=17912;   // pi
   sortTable[0x7656]=17913;   // pi
   sortTable[0x90B3]=17914;   // pi
   sortTable[0x7F74]=17915;   // pi
   sortTable[0x5AB2]=17916;   // pi
   sortTable[0x9F19]=17917;   // pi
   sortTable[0x6DE0]=17918;   // pi
   sortTable[0x7513]=17919;   // pi
   sortTable[0x75DE]=17920;   // pi
   sortTable[0x868D]=17921;   // pi
   sortTable[0x572E]=17922;   // pi
   sortTable[0x5E80]=17923;   // pi
   sortTable[0x567C]=17924;   // pi
   sortTable[0x6787]=17925;   // pi
   sortTable[0x7812]=17926;   // pi
   sortTable[0x9674]=17927;   // pi
   sortTable[0x8C94]=17928;   // pi
   sortTable[0x7EB0]=17929;   // pi
   sortTable[0x7765]=17930;   // pi
   sortTable[0x90EB]=17931;   // pi
   sortTable[0x94CD]=17932;   // pi
   sortTable[0x8298]=17933;   // pi
   sortTable[0x57E4]=17934;   // pi
   sortTable[0x8731]=17935;   // pi
   sortTable[0x64D7]=17936;   // pi
   sortTable[0x4EF3]=17937;   // pi
   sortTable[0x9C8F]=17938;   // pi
   sortTable[0x9E0A]=17939;   // pi
   sortTable[0x79E0]=17940;   // pi
   sortTable[0x925F]=17941;   // pi
   sortTable[0x9DFF]=17942;   // pi
   sortTable[0x818D]=17943;   // pi
   sortTable[0x99D3]=17944;   // pi
   sortTable[0x9B7E]=17945;   // pi
   sortTable[0x921A]=17946;   // pi
   sortTable[0x9B8D]=17947;   // pi
   sortTable[0x7914]=17948;   // pi
   sortTable[0x7BFA]=17949;   // pi
   sortTable[0x9294]=17950;   // pi
   sortTable[0x92A2]=17951;   // pi
   sortTable[0x95E2]=17952;   // pi
   sortTable[0x8157]=17953;   // pi
   sortTable[0x7FCD]=17954;   // pi
   sortTable[0x91FD]=17955;   // pi
   sortTable[0x930D]=17956;   // pi
   sortTable[0x9630]=17957;   // pi
   sortTable[0x9B6E]=17958;   // pi
   sortTable[0x7D15]=17959;   // pi
   sortTable[0x7F86]=17960;   // pi
   sortTable[0x8134]=17961;   // pi
   sortTable[0x86BE]=17962;   // pi
   sortTable[0x87B7]=17963;   // pi
   sortTable[0x9AEC]=17964;   // pi
   sortTable[0x9D04]=17965;   // pi
   sortTable[0x9D67]=17966;   // pi
   sortTable[0x4F13]=17967;   // pi
   sortTable[0x4F3E]=17968;   // pi
   sortTable[0x567D]=17969;   // pi
   sortTable[0x568A]=17970;   // pi
   sortTable[0x56AD]=17971;   // pi
   sortTable[0x58C0]=17972;   // pi
   sortTable[0x5AD3]=17973;   // pi
   sortTable[0x5CAF]=17974;   // pi
   sortTable[0x5D25]=17975;   // pi
   sortTable[0x6082]=17976;   // pi
   sortTable[0x61B5]=17977;   // pi
   sortTable[0x62B7]=17978;   // pi
   sortTable[0x63CA]=17979;   // pi
   sortTable[0x65C7]=17980;   // pi
   sortTable[0x6707]=17981;   // pi
   sortTable[0x698C]=17982;   // pi
   sortTable[0x6BD8]=17983;   // pi
   sortTable[0x6BDE]=17984;   // pi
   sortTable[0x6E12]=17985;   // pi
   sortTable[0x6F4E]=17986;   // pi
   sortTable[0x6FBC]=17987;   // pi
   sortTable[0x708B]=17988;   // pi
   sortTable[0x7137]=17989;   // pi
   sortTable[0x72C9]=17990;   // pi
   sortTable[0x72D3]=17991;   // pi
   sortTable[0x7588]=17992;   // pi
   sortTable[0x758B]=17993;   // pi
   sortTable[0x78C7]=17994;   // pi
   sortTable[0x7915]=17995;   // pi
   sortTable[0x79DB]=17996;   // pi
   sortTable[0x7A2B]=17997;   // pi
   sortTable[0x801A]=17998;   // pi
   sortTable[0x80B6]=17999;   // pi
   sortTable[0x82C9]=18000;   // pi
   sortTable[0x86BD]=18001;   // pi
   sortTable[0x8AC0]=18002;   // pi
   sortTable[0x8C7C]=18003;   // pi
   sortTable[0x8C7E]=18004;   // pi
   sortTable[0x9208]=18005;   // pi
   sortTable[0x9239]=18006;   // pi
   sortTable[0x7247]=18007;   // pian
   sortTable[0x7BC7]=18008;   // pian
   sortTable[0x504F]=18009;   // pian
   sortTable[0x9A97]=18010;   // pian
   sortTable[0x9A19]=18011;   // pian
   sortTable[0x7FE9]=18012;   // pian
   sortTable[0x8C1D]=18013;   // pian
   sortTable[0x9A88]=18014;   // pian
   sortTable[0x80FC]=18015;   // pian
   sortTable[0x8E41]=18016;   // pian
   sortTable[0x728F]=18017;   // pian
   sortTable[0x8DF0]=18018;   // pian
   sortTable[0x9B78]=18019;   // pian
   sortTable[0x8991]=18020;   // pian
   sortTable[0x8ADE]=18021;   // pian
   sortTable[0x8ADA]=18022;   // pian
   sortTable[0x9342]=18023;   // pian
   sortTable[0x99E2]=18024;   // pian
   sortTable[0x9ABF]=18025;   // pian
   sortTable[0x56E8]=18026;   // pian
   sortTable[0x5AA5]=18027;   // pian
   sortTable[0x6944]=18028;   // pian
   sortTable[0x6969]=18029;   // pian
   sortTable[0x8141]=18030;   // pian
   sortTable[0x8CB5]=18031;   // pian
   sortTable[0x8CC6]=18032;   // pian
   sortTable[0x9A08]=18033;   // pian
   sortTable[0x9A17]=18034;   // pian
   sortTable[0x9DA3]=18035;   // pian
   sortTable[0x7968]=18036;   // piao
   sortTable[0x98D8]=18037;   // piao
   sortTable[0x98C4]=18038;   // piao
   sortTable[0x6F02]=18039;   // piao
   sortTable[0x74E2]=18040;   // piao
   sortTable[0x5AD6]=18041;   // piao
   sortTable[0x527D]=18042;   // piao
   sortTable[0x7F25]=18043;   // piao
   sortTable[0x779F]=18044;   // piao
   sortTable[0x560C]=18045;   // piao
   sortTable[0x6B8D]=18046;   // piao
   sortTable[0x87B5]=18047;   // piao
   sortTable[0x9860]=18048;   // piao
   sortTable[0x7FF2]=18049;   // piao
   sortTable[0x7AC2]=18050;   // piao
   sortTable[0x7E39]=18051;   // piao
   sortTable[0x91A5]=18052;   // piao
   sortTable[0x9B52]=18053;   // piao
   sortTable[0x50C4]=18054;   // piao
   sortTable[0x52E1]=18055;   // piao
   sortTable[0x5F6F]=18056;   // piao
   sortTable[0x5FB1]=18057;   // piao
   sortTable[0x6153]=18058;   // piao
   sortTable[0x65DA]=18059;   // piao
   sortTable[0x72A5]=18060;   // piao
   sortTable[0x76AB]=18061;   // piao
   sortTable[0x7BFB]=18062;   // piao
   sortTable[0x85B8]=18063;   // piao
   sortTable[0x95DD]=18064;   // piao
   sortTable[0x98C3]=18065;   // piao
   sortTable[0x77A5]=18066;   // pie
   sortTable[0x6487]=18067;   // pie
   sortTable[0x82E4]=18068;   // pie
   sortTable[0x6C15]=18069;   // pie
   sortTable[0x4E3F]=18070;   // pie
   sortTable[0x5AF3]=18071;   // pie
   sortTable[0x6486]=18072;   // pie
   sortTable[0x66BC]=18073;   // pie
   sortTable[0x9405]=18074;   // pie
   sortTable[0x54C1]=18075;   // pin
   sortTable[0x62FC]=18076;   // pin
   sortTable[0x8D2B]=18077;   // pin
   sortTable[0x8CA7]=18078;   // pin
   sortTable[0x9891]=18079;   // pin
   sortTable[0x983B]=18080;   // pin
   sortTable[0x8058]=18081;   // pin
   sortTable[0x5AD4]=18082;   // pin
   sortTable[0x725D]=18083;   // pin
   sortTable[0x98A6]=18084;   // pin
   sortTable[0x59D8]=18085;   // pin
   sortTable[0x8819]=18086;   // pin
   sortTable[0x6980]=18087;   // pin
   sortTable[0x99AA]=18088;   // pin
   sortTable[0x77C9]=18089;   // pin
   sortTable[0x9870]=18090;   // pin
   sortTable[0x9A5E]=18091;   // pin
   sortTable[0x56AC]=18092;   // pin
   sortTable[0x5A26]=18093;   // pin
   sortTable[0x5B2A]=18094;   // pin
   sortTable[0x6C56]=18095;   // pin
   sortTable[0x7371]=18096;   // pin
   sortTable[0x73AD]=18097;   // pin
   sortTable[0x7415]=18098;   // pin
   sortTable[0x7917]=18099;   // pin
   sortTable[0x7A66]=18100;   // pin
   sortTable[0x85B2]=18101;   // pin
   sortTable[0x5E73]=18102;   // ping
   sortTable[0x8BC4]=18103;   // ping
   sortTable[0x8A55]=18104;   // ping
   sortTable[0x51ED]=18105;   // ping
   sortTable[0x6191]=18106;   // ping
   sortTable[0x74F6]=18107;   // ping
   sortTable[0x82F9]=18108;   // ping
   sortTable[0x860B]=18109;   // ping
   sortTable[0x4E52]=18110;   // ping
   sortTable[0x5C4F]=18111;   // ping
   sortTable[0x840D]=18112;   // ping
   sortTable[0x576A]=18113;   // ping
   sortTable[0x5A09]=18114;   // ping
   sortTable[0x9C86]=18115;   // ping
   sortTable[0x67B0]=18116;   // ping
   sortTable[0x4FDC]=18117;   // ping
   sortTable[0x8EFF]=18118;   // ping
   sortTable[0x8F27]=18119;   // ping
   sortTable[0x7F3E]=18120;   // ping
   sortTable[0x8353]=18121;   // ping
   sortTable[0x86E2]=18122;   // ping
   sortTable[0x90F1]=18123;   // ping
   sortTable[0x8060]=18124;   // ping
   sortTable[0x84F1]=18125;   // ping
   sortTable[0x7BB3]=18126;   // ping
   sortTable[0x782F]=18127;   // ping
   sortTable[0x80D3]=18128;   // ping
   sortTable[0x51F4]=18129;   // ping
   sortTable[0x546F]=18130;   // ping
   sortTable[0x5840]=18131;   // ping
   sortTable[0x5C5B]=18132;   // ping
   sortTable[0x5CBC]=18133;   // ping
   sortTable[0x5E21]=18134;   // ping
   sortTable[0x5E32]=18135;   // ping
   sortTable[0x5E48]=18136;   // ping
   sortTable[0x617F]=18137;   // ping
   sortTable[0x6A98]=18138;   // ping
   sortTable[0x6CD9]=18139;   // ping
   sortTable[0x6D34]=18140;   // ping
   sortTable[0x6D84]=18141;   // ping
   sortTable[0x6DDC]=18142;   // ping
   sortTable[0x7129]=18143;   // ping
   sortTable[0x73B6]=18144;   // ping
   sortTable[0x7501]=18145;   // ping
   sortTable[0x7539]=18146;   // ping
   sortTable[0x7AEE]=18147;   // ping
   sortTable[0x7C08]=18148;   // ping
   sortTable[0x8275]=18149;   // ping
   sortTable[0x86B2]=18150;   // ping
   sortTable[0x9829]=18151;   // ping
   sortTable[0x9B83]=18152;   // ping
   sortTable[0x7834]=18153;   // po
   sortTable[0x8FEB]=18154;   // po
   sortTable[0x5761]=18155;   // po
   sortTable[0x5A46]=18156;   // po
   sortTable[0x9887]=18157;   // po
   sortTable[0x9817]=18158;   // po
   sortTable[0x6CFC]=18159;   // po
   sortTable[0x6F51]=18160;   // po
   sortTable[0x6CCA]=18161;   // po
   sortTable[0x9B44]=18162;   // po
   sortTable[0x73C0]=18163;   // po
   sortTable[0x9131]=18164;   // po
   sortTable[0x53F5]=18165;   // po
   sortTable[0x7B38]=18166;   // po
   sortTable[0x7C95]=18167;   // po
   sortTable[0x948B]=18168;   // po
   sortTable[0x76A4]=18169;   // po
   sortTable[0x94B7]=18170;   // po
   sortTable[0x91D9]=18171;   // po
   sortTable[0x8B08]=18172;   // po
   sortTable[0x84AA]=18173;   // po
   sortTable[0x99CA]=18174;   // po
   sortTable[0x5619]=18175;   // po
   sortTable[0x5C00]=18176;   // po
   sortTable[0x5CA5]=18177;   // po
   sortTable[0x5CB6]=18178;   // po
   sortTable[0x6540]=18179;   // po
   sortTable[0x6622]=18180;   // po
   sortTable[0x6872]=18181;   // po
   sortTable[0x6AC7]=18182;   // po
   sortTable[0x6D26]=18183;   // po
   sortTable[0x6E8C]=18184;   // po
   sortTable[0x7087]=18185;   // po
   sortTable[0x70DE]=18186;   // po
   sortTable[0x7836]=18187;   // po
   sortTable[0x8522]=18188;   // po
   sortTable[0x9197]=18189;   // po
   sortTable[0x9255]=18190;   // po
   sortTable[0x93FA]=18191;   // po
   sortTable[0x5256]=18192;   // pou
   sortTable[0x88D2]=18193;   // pou
   sortTable[0x638A]=18194;   // pou
   sortTable[0x9307]=18195;   // pou
   sortTable[0x5485]=18196;   // pou
   sortTable[0x54E3]=18197;   // pou
   sortTable[0x5A1D]=18198;   // pou
   sortTable[0x5A44]=18199;   // pou
   sortTable[0x5ECD]=18200;   // pou
   sortTable[0x6294]=18201;   // pou
   sortTable[0x6299]=18202;   // pou
   sortTable[0x634A]=18203;   // pou
   sortTable[0x7283]=18204;   // pou
   sortTable[0x7B81]=18205;   // pou
   sortTable[0x666E]=18206;   // pu
   sortTable[0x6251]=18207;   // pu
   sortTable[0x64B2]=18208;   // pu
   sortTable[0x94FA]=18209;   // pu
   sortTable[0x92EA]=18210;   // pu
   sortTable[0x6734]=18211;   // pu
   sortTable[0x8461]=18212;   // pu
   sortTable[0x812F]=18213;   // pu
   sortTable[0x7011]=18214;   // pu
   sortTable[0x83E9]=18215;   // pu
   sortTable[0x4EC6]=18216;   // pu
   sortTable[0x6D66]=18217;   // pu
   sortTable[0x84B2]=18218;   // pu
   sortTable[0x8C31]=18219;   // pu
   sortTable[0x6FEE]=18220;   // pu
   sortTable[0x5703]=18221;   // pu
   sortTable[0x6EA5]=18222;   // pu
   sortTable[0x749E]=18223;   // pu
   sortTable[0x66DD]=18224;   // pu
   sortTable[0x5657]=18225;   // pu
   sortTable[0x8386]=18226;   // pu
   sortTable[0x530D]=18227;   // pu
   sortTable[0x917A]=18228;   // pu
   sortTable[0x6534]=18229;   // pu
   sortTable[0x8E7C]=18230;   // pu
   sortTable[0x84B1]=18231;   // pu
   sortTable[0x9568]=18232;   // pu
   sortTable[0x6C06]=18233;   // pu
   sortTable[0x9660]=18234;   // pu
   sortTable[0x9564]=18235;   // pu
   sortTable[0x9BC6]=18236;   // pu
   sortTable[0x8216]=18237;   // pu
   sortTable[0x7A59]=18238;   // pu
   sortTable[0x8D0C]=18239;   // pu
   sortTable[0x8B5C]=18240;   // pu
   sortTable[0x83D0]=18241;   // pu
   sortTable[0x7E80]=18242;   // pu
   sortTable[0x9420]=18243;   // pu
   sortTable[0x50D5]=18244;   // pu
   sortTable[0x5724]=18245;   // pu
   sortTable[0x58A3]=18246;   // pu
   sortTable[0x5DEC]=18247;   // pu
   sortTable[0x5DED]=18248;   // pu
   sortTable[0x64C8]=18249;   // pu
   sortTable[0x6A38]=18250;   // pu
   sortTable[0x6A8F]=18251;   // pu
   sortTable[0x6F7D]=18252;   // pu
   sortTable[0x70F3]=18253;   // pu
   sortTable[0x735B]=18254;   // pu
   sortTable[0x77A8]=18255;   // pu
   sortTable[0x8217]=18256;   // pu
   sortTable[0x8965]=18257;   // pu
   sortTable[0x8AE9]=18258;   // pu
   sortTable[0x93F7]=18259;   // pu
   sortTable[0x99C7]=18260;   // pu
   sortTable[0x8D77]=18688;   // qi
   sortTable[0x6C23]=18689;   // qi
   sortTable[0x6C14]=18690;   // qi
   sortTable[0x5176]=18691;   // qi
   sortTable[0x671F]=18692;   // qi
   sortTable[0x4E03]=18693;   // qi
   sortTable[0x5668]=18694;   // qi
   sortTable[0x6C7D]=18695;   // qi
   sortTable[0x5947]=18696;   // qi
   sortTable[0x4F01]=18697;   // qi
   sortTable[0x65D7]=18698;   // qi
   sortTable[0x9F50]=18699;   // qi
   sortTable[0x9F4A]=18700;   // qi
   sortTable[0x9A91]=18701;   // qi
   sortTable[0x9A0E]=18702;   // qi
   sortTable[0x6F06]=18703;   // qi
   sortTable[0x59BB]=18704;   // qi
   sortTable[0x542F]=18705;   // qi
   sortTable[0x555F]=18706;   // qi
   sortTable[0x6B3A]=18707;   // qi
   sortTable[0x621A]=18708;   // qi
   sortTable[0x5C82]=18709;   // qi
   sortTable[0x5F03]=18710;   // qi
   sortTable[0x8C48]=18711;   // qi
   sortTable[0x68C4]=18712;   // qi
   sortTable[0x780C]=18713;   // qi
   sortTable[0x68CB]=18714;   // qi
   sortTable[0x51C4]=18715;   // qi
   sortTable[0x6DD2]=18716;   // qi
   sortTable[0x6CE3]=18717;   // qi
   sortTable[0x5D0E]=18718;   // qi
   sortTable[0x6C8F]=18719;   // qi
   sortTable[0x4E5E]=18720;   // qi
   sortTable[0x5951]=18721;   // qi
   sortTable[0x7948]=18722;   // qi
   sortTable[0x4FDF]=18723;   // qi
   sortTable[0x6B67]=18724;   // qi
   sortTable[0x6816]=18725;   // qi
   sortTable[0x8BAB]=18726;   // qi
   sortTable[0x8FC4]=18727;   // qi
   sortTable[0x5C90]=18728;   // qi
   sortTable[0x7EEE]=18729;   // qi
   sortTable[0x7941]=18730;   // qi
   sortTable[0x7426]=18731;   // qi
   sortTable[0x8006]=18732;   // qi
   sortTable[0x742A]=18733;   // qi
   sortTable[0x9CCD]=18734;   // qi
   sortTable[0x675E]=18735;   // qi
   sortTable[0x69ED]=18736;   // qi
   sortTable[0x797A]=18737;   // qi
   sortTable[0x5601]=18738;   // qi
   sortTable[0x8E4A]=18739;   // qi
   sortTable[0x9E92]=18740;   // qi
   sortTable[0x6DC7]=18741;   // qi
   sortTable[0x8572]=18742;   // qi
   sortTable[0x789B]=18743;   // qi
   sortTable[0x86F4]=18744;   // qi
   sortTable[0x82AA]=18745;   // qi
   sortTable[0x7947]=18746;   // qi
   sortTable[0x8110]=18747;   // qi
   sortTable[0x951C]=18748;   // qi
   sortTable[0x847A]=18749;   // qi
   sortTable[0x61A9]=18750;   // qi
   sortTable[0x8401]=18751;   // qi
   sortTable[0x840B]=18752;   // qi
   sortTable[0x4E93]=18753;   // qi
   sortTable[0x7DA6]=18754;   // qi
   sortTable[0x8291]=18755;   // qi
   sortTable[0x573B]=18756;   // qi
   sortTable[0x7566]=18757;   // qi
   sortTable[0x9A90]=18758;   // qi
   sortTable[0x9880]=18759;   // qi
   sortTable[0x8DC2]=18760;   // qi
   sortTable[0x7DAE]=18761;   // qi
   sortTable[0x90EA]=18762;   // qi
   sortTable[0x6864]=18763;   // qi
   sortTable[0x6C54]=18764;   // qi
   sortTable[0x67D2]=18765;   // qi
   sortTable[0x78B6]=18766;   // qi
   sortTable[0x871E]=18767;   // qi
   sortTable[0x7881]=18768;   // qi
   sortTable[0x5C7A]=18769;   // qi
   sortTable[0x9B10]=18770;   // qi
   sortTable[0x8AC6]=18771;   // qi
   sortTable[0x80B5]=18772;   // qi
   sortTable[0x76F5]=18773;   // qi
   sortTable[0x81CD]=18774;   // qi
   sortTable[0x9321]=18775;   // qi
   sortTable[0x7895]=18776;   // qi
   sortTable[0x78E7]=18777;   // qi
   sortTable[0x79A5]=18778;   // qi
   sortTable[0x7F3C]=18779;   // qi
   sortTable[0x93DA]=18780;   // qi
   sortTable[0x9094]=18781;   // qi
   sortTable[0x86E3]=18782;   // qi
   sortTable[0x9CAF]=18783;   // qi
   sortTable[0x9F1C]=18784;   // qi
   sortTable[0x78DC]=18785;   // qi
   sortTable[0x8691]=18786;   // qi
   sortTable[0x8694]=18787;   // qi
   sortTable[0x78E9]=18788;   // qi
   sortTable[0x9BD5]=18789;   // qi
   sortTable[0x9EA1]=18790;   // qi
   sortTable[0x7C2F]=18791;   // qi
   sortTable[0x980E]=18792;   // qi
   sortTable[0x7CB8]=18793;   // qi
   sortTable[0x9B4C]=18794;   // qi
   sortTable[0x85C4]=18795;   // qi
   sortTable[0x8E11]=18796;   // qi
   sortTable[0x9D80]=18797;   // qi
   sortTable[0x9D88]=18798;   // qi
   sortTable[0x7C31]=18799;   // qi
   sortTable[0x7DA5]=18800;   // qi
   sortTable[0x7F4A]=18801;   // qi
   sortTable[0x8269]=18802;   // qi
   sortTable[0x87A7]=18803;   // qi
   sortTable[0x87FF]=18804;   // qi
   sortTable[0x970B]=18805;   // qi
   sortTable[0x9B3F]=18806;   // qi
   sortTable[0x9C2D]=18807;   // qi
   sortTable[0x77F5]=18808;   // qi
   sortTable[0x7AD2]=18809;   // qi
   sortTable[0x7C4F]=18810;   // qi
   sortTable[0x7DC0]=18811;   // qi
   sortTable[0x7E83]=18812;   // qi
   sortTable[0x8415]=18813;   // qi
   sortTable[0x869A]=18814;   // qi
   sortTable[0x8A16]=18815;   // qi
   sortTable[0x8EDD]=18816;   // qi
   sortTable[0x95D9]=18817;   // qi
   sortTable[0x4E9D]=18818;   // qi
   sortTable[0x501B]=18819;   // qi
   sortTable[0x50DB]=18820;   // qi
   sortTable[0x5258]=18821;   // qi
   sortTable[0x5447]=18822;   // qi
   sortTable[0x546E]=18823;   // qi
   sortTable[0x54A0]=18824;   // qi
   sortTable[0x5518]=18825;   // qi
   sortTable[0x552D]=18826;   // qi
   sortTable[0x5553]=18827;   // qi
   sortTable[0x5554]=18828;   // qi
   sortTable[0x5650]=18829;   // qi
   sortTable[0x57FC]=18830;   // qi
   sortTable[0x5921]=18831;   // qi
   sortTable[0x5A38]=18832;   // qi
   sortTable[0x5A4D]=18833;   // qi
   sortTable[0x5C93]=18834;   // qi
   sortTable[0x5E3A]=18835;   // qi
   sortTable[0x5FD4]=18836;   // qi
   sortTable[0x5FEF]=18837;   // qi
   sortTable[0x60BD]=18838;   // qi
   sortTable[0x612D]=18839;   // qi
   sortTable[0x617C]=18840;   // qi
   sortTable[0x617D]=18841;   // qi
   sortTable[0x6187]=18842;   // qi
   sortTable[0x61E0]=18843;   // qi
   sortTable[0x6391]=18844;   // qi
   sortTable[0x6456]=18845;   // qi
   sortTable[0x6532]=18846;   // qi
   sortTable[0x6589]=18847;   // qi
   sortTable[0x658A]=18848;   // qi
   sortTable[0x65C2]=18849;   // qi
   sortTable[0x6675]=18850;   // qi
   sortTable[0x66A3]=18851;   // qi
   sortTable[0x6814]=18852;   // qi
   sortTable[0x687C]=18853;   // qi
   sortTable[0x68CA]=18854;   // qi
   sortTable[0x68E8]=18855;   // qi
   sortTable[0x68F2]=18856;   // qi
   sortTable[0x69BF]=18857;   // qi
   sortTable[0x6AB1]=18858;   // qi
   sortTable[0x6AC0]=18859;   // qi
   sortTable[0x6B2B]=18860;   // qi
   sortTable[0x6C17]=18861;   // qi
   sortTable[0x6E0F]=18862;   // qi
   sortTable[0x6E46]=18863;   // qi
   sortTable[0x6E47]=18864;   // qi
   sortTable[0x6FDD]=18865;   // qi
   sortTable[0x7081]=18866;   // qi
   sortTable[0x7309]=18867;   // qi
   sortTable[0x7382]=18868;   // qi
   sortTable[0x7398]=18869;   // qi
   sortTable[0x7482]=18870;   // qi
   sortTable[0x7508]=18871;   // qi
   sortTable[0x7541]=18872;   // qi
   sortTable[0x75A7]=18873;   // qi
   sortTable[0x76C0]=18874;   // qi
   sortTable[0x7DA8]=18875;   // qi
   sortTable[0x7DBA]=18876;   // qi
   sortTable[0x7DD5]=18877;   // qi
   sortTable[0x829E]=18878;   // qi
   sortTable[0x8604]=18879;   // qi
   sortTable[0x871D]=18880;   // qi
   sortTable[0x8810]=18881;   // qi
   sortTable[0x8904]=18882;   // qi
   sortTable[0x8AEC]=18883;   // qi
   sortTable[0x8AFF]=18884;   // qi
   sortTable[0x8FC9]=18885;   // qi
   sortTable[0x91EE]=18886;   // qi
   sortTable[0x9A0F]=18887;   // qi
   sortTable[0x9D78]=18888;   // qi
   sortTable[0x6070]=18889;   // qia
   sortTable[0x6390]=18890;   // qia
   sortTable[0x6D3D]=18891;   // qia
   sortTable[0x845C]=18892;   // qia
   sortTable[0x9AC2]=18893;   // qia
   sortTable[0x8DD2]=18894;   // qia
   sortTable[0x9790]=18895;   // qia
   sortTable[0x7848]=18896;   // qia
   sortTable[0x51BE]=18897;   // qia
   sortTable[0x5736]=18898;   // qia
   sortTable[0x5E22]=18899;   // qia
   sortTable[0x6118]=18900;   // qia
   sortTable[0x62E4]=18901;   // qia
   sortTable[0x6B8E]=18902;   // qia
   sortTable[0x9160]=18903;   // qia
   sortTable[0x524D]=18904;   // qian
   sortTable[0x5343]=18905;   // qian
   sortTable[0x94B1]=18906;   // qian
   sortTable[0x9322]=18907;   // qian
   sortTable[0x7275]=18908;   // qian
   sortTable[0x727D]=18909;   // qian
   sortTable[0x6D45]=18910;   // qian
   sortTable[0x6DFA]=18911;   // qian
   sortTable[0x7B7E]=18912;   // qian
   sortTable[0x7C3D]=18913;   // qian
   sortTable[0x94C5]=18914;   // qian
   sortTable[0x925B]=18915;   // qian
   sortTable[0x6B20]=18916;   // qian
   sortTable[0x6F5C]=18917;   // qian
   sortTable[0x6F5B]=18918;   // qian
   sortTable[0x8FC1]=18919;   // qian
   sortTable[0x9077]=18920;   // qian
   sortTable[0x9063]=18921;   // qian
   sortTable[0x8C26]=18922;   // qian
   sortTable[0x8B19]=18923;   // qian
   sortTable[0x6B49]=18924;   // qian
   sortTable[0x5D4C]=18925;   // qian
   sortTable[0x94B3]=18926;   // qian
   sortTable[0x9257]=18927;   // qian
   sortTable[0x8C34]=18928;   // qian
   sortTable[0x8B74]=18929;   // qian
   sortTable[0x4E7E]=18930;   // qian
   sortTable[0x8654]=18931;   // qian
   sortTable[0x5029]=18932;   // qian
   sortTable[0x4F65]=18933;   // qian
   sortTable[0x5811]=18934;   // qian
   sortTable[0x94A4]=18935;   // qian
   sortTable[0x831C]=18936;   // qian
   sortTable[0x9ED4]=18937;   // qian
   sortTable[0x6106]=18938;   // qian
   sortTable[0x9A9E]=18939;   // qian
   sortTable[0x80B7]=18940;   // qian
   sortTable[0x6434]=18941;   // qian
   sortTable[0x82A1]=18942;   // qian
   sortTable[0x8930]=18943;   // qian
   sortTable[0x9621]=18944;   // qian
   sortTable[0x7F31]=18945;   // qian
   sortTable[0x828A]=18946;   // qian
   sortTable[0x614A]=18947;   // qian
   sortTable[0x60AD]=18948;   // qian
   sortTable[0x7B9D]=18949;   // qian
   sortTable[0x63AE]=18950;   // qian
   sortTable[0x84A8]=18951;   // qian
   sortTable[0x4EDF]=18952;   // qian
   sortTable[0x6266]=18953;   // qian
   sortTable[0x948E]=18954;   // qian
   sortTable[0x6920]=18955;   // qian
   sortTable[0x7C64]=18956;   // qian
   sortTable[0x9206]=18957;   // qian
   sortTable[0x8C38]=18958;   // qian
   sortTable[0x5C8D]=18959;   // qian
   sortTable[0x7DAA]=18960;   // qian
   sortTable[0x9C1C]=18961;   // qian
   sortTable[0x976C]=18962;   // qian
   sortTable[0x8AD0]=18963;   // qian
   sortTable[0x8F24]=18964;   // qian
   sortTable[0x8EE1]=18965;   // qian
   sortTable[0x8541]=18966;   // qian
   sortTable[0x9A1D]=18967;   // qian
   sortTable[0x9C2C]=18968;   // qian
   sortTable[0x7C56]=18969;   // qian
   sortTable[0x7E34]=18970;   // qian
   sortTable[0x8181]=18971;   // qian
   sortTable[0x9B1C]=18972;   // qian
   sortTable[0x9E50]=18973;   // qian
   sortTable[0x9EDA]=18974;   // qian
   sortTable[0x7ACF]=18975;   // qian
   sortTable[0x7BDF]=18976;   // qian
   sortTable[0x8688]=18977;   // qian
   sortTable[0x9A2B]=18978;   // qian
   sortTable[0x9B1D]=18979;   // qian
   sortTable[0x7B9E]=18980;   // qian
   sortTable[0x7BCF]=18981;   // qian
   sortTable[0x7FAC]=18982;   // qian
   sortTable[0x8125]=18983;   // qian
   sortTable[0x8738]=18984;   // qian
   sortTable[0x97C6]=18985;   // qian
   sortTable[0x9845]=18986;   // qian
   sortTable[0x4EF1]=18987;   // qian
   sortTable[0x4FD4]=18988;   // qian
   sortTable[0x5094]=18989;   // qian
   sortTable[0x50C9]=18990;   // qian
   sortTable[0x5119]=18991;   // qian
   sortTable[0x515B]=18992;   // qian
   sortTable[0x51F5]=18993;   // qian
   sortTable[0x520B]=18994;   // qian
   sortTable[0x55DB]=18995;   // qian
   sortTable[0x5731]=18996;   // qian
   sortTable[0x5732]=18997;   // qian
   sortTable[0x5879]=18998;   // qian
   sortTable[0x5898]=18999;   // qian
   sortTable[0x58CD]=19000;   // qian
   sortTable[0x5977]=19001;   // qian
   sortTable[0x5A5C]=19002;   // qian
   sortTable[0x5A8A]=19003;   // qian
   sortTable[0x5B45]=19004;   // qian
   sortTable[0x5B6F]=19005;   // qian
   sortTable[0x5C92]=19006;   // qian
   sortTable[0x5D70]=19007;   // qian
   sortTable[0x5FF4]=19008;   // qian
   sortTable[0x6093]=19009;   // qian
   sortTable[0x6173]=19010;   // qian
   sortTable[0x6272]=19011;   // qian
   sortTable[0x62D1]=19012;   // qian
   sortTable[0x62EA]=19013;   // qian
   sortTable[0x6394]=19014;   // qian
   sortTable[0x63F5]=19015;   // qian
   sortTable[0x6481]=19016;   // qian
   sortTable[0x6510]=19017;   // qian
   sortTable[0x6511]=19018;   // qian
   sortTable[0x6513]=19019;   // qian
   sortTable[0x6744]=19020;   // qian
   sortTable[0x68C8]=19021;   // qian
   sortTable[0x69A9]=19022;   // qian
   sortTable[0x69CF]=19023;   // qian
   sortTable[0x69E7]=19024;   // qian
   sortTable[0x6A6C]=19025;   // qian
   sortTable[0x6AB6]=19026;   // qian
   sortTable[0x6ACF]=19027;   // qian
   sortTable[0x6B26]=19028;   // qian
   sortTable[0x6B6C]=19029;   // qian
   sortTable[0x6C58]=19030;   // qian
   sortTable[0x6C67]=19031;   // qian
   sortTable[0x6FF3]=19032;   // qian
   sortTable[0x704A]=19033;   // qian
   sortTable[0x74E9]=19034;   // qian
   sortTable[0x7698]=19035;   // qian
   sortTable[0x7C81]=19036;   // qian
   sortTable[0x7E7E]=19037;   // qian
   sortTable[0x81E4]=19038;   // qian
   sortTable[0x833E]=19039;   // qian
   sortTable[0x8533]=19040;   // qian
   sortTable[0x91FA]=19041;   // qian
   sortTable[0x9210]=19042;   // qian
   sortTable[0x92AD]=19043;   // qian
   sortTable[0x9386]=19044;   // qian
   sortTable[0x93F2]=19045;   // qian
   sortTable[0x9453]=19046;   // qian
   sortTable[0x96C3]=19047;   // qian
   sortTable[0x9A1A]=19048;   // qian
   sortTable[0x9D6E]=19049;   // qian
   sortTable[0x5F3A]=19050;   // qiang
   sortTable[0x5F37]=19051;   // qiang
   sortTable[0x67AA]=19052;   // qiang
   sortTable[0x69CD]=19053;   // qiang
   sortTable[0x5899]=19054;   // qiang
   sortTable[0x7246]=19055;   // qiang
   sortTable[0x62A2]=19056;   // qiang
   sortTable[0x6436]=19057;   // qiang
   sortTable[0x8154]=19058;   // qiang
   sortTable[0x7F8C]=19059;   // qiang
   sortTable[0x8DC4]=19060;   // qiang
   sortTable[0x545B]=19061;   // qiang
   sortTable[0x9535]=19062;   // qiang
   sortTable[0x8537]=19063;   // qiang
   sortTable[0x6A2F]=19064;   // qiang
   sortTable[0x6215]=19065;   // qiang
   sortTable[0x5AF1]=19066;   // qiang
   sortTable[0x9516]=19067;   // qiang
   sortTable[0x8941]=19068;   // qiang
   sortTable[0x709D]=19069;   // qiang
   sortTable[0x7F9F]=19070;   // qiang
   sortTable[0x9397]=19071;   // qiang
   sortTable[0x956A]=19072;   // qiang
   sortTable[0x8723]=19073;   // qiang
   sortTable[0x6217]=19074;   // qiang
   sortTable[0x7E66]=19075;   // qiang
   sortTable[0x7F97]=19076;   // qiang
   sortTable[0x8E61]=19077;   // qiang
   sortTable[0x8262]=19078;   // qiang
   sortTable[0x9306]=19079;   // qiang
   sortTable[0x7BEC]=19080;   // qiang
   sortTable[0x7E48]=19081;   // qiang
   sortTable[0x7FAB]=19082;   // qiang
   sortTable[0x7FBB]=19083;   // qiang
   sortTable[0x93D8]=19084;   // qiang
   sortTable[0x8594]=19085;   // qiang
   sortTable[0x8E4C]=19086;   // qiang
   sortTable[0x93F9]=19087;   // qiang
   sortTable[0x4E2C]=19088;   // qiang
   sortTable[0x5534]=19089;   // qiang
   sortTable[0x55C6]=19090;   // qiang
   sortTable[0x55F4]=19091;   // qiang
   sortTable[0x588F]=19092;   // qiang
   sortTable[0x58BB]=19093;   // qiang
   sortTable[0x5B19]=19094;   // qiang
   sortTable[0x5D88]=19095;   // qiang
   sortTable[0x5EE7]=19096;   // qiang
   sortTable[0x6227]=19097;   // qiang
   sortTable[0x65A8]=19098;   // qiang
   sortTable[0x690C]=19099;   // qiang
   sortTable[0x6AA3]=19100;   // qiang
   sortTable[0x6EAC]=19101;   // qiang
   sortTable[0x6F12]=19102;   // qiang
   sortTable[0x7197]=19103;   // qiang
   sortTable[0x7244]=19104;   // qiang
   sortTable[0x7310]=19105;   // qiang
   sortTable[0x7347]=19106;   // qiang
   sortTable[0x73B1]=19107;   // qiang
   sortTable[0x7472]=19108;   // qiang
   sortTable[0x7FA5]=19109;   // qiang
   sortTable[0x8503]=19110;   // qiang
   sortTable[0x8620]=19111;   // qiang
   sortTable[0x8B12]=19112;   // qiang
   sortTable[0x6865]=19113;   // qiao
   sortTable[0x6A4B]=19114;   // qiao
   sortTable[0x77A7]=19115;   // qiao
   sortTable[0x6084]=19116;   // qiao
   sortTable[0x5DE7]=19117;   // qiao
   sortTable[0x6572]=19118;   // qiao
   sortTable[0x7FD8]=19119;   // qiao
   sortTable[0x7FF9]=19120;   // qiao
   sortTable[0x9539]=19121;   // qiao
   sortTable[0x936C]=19122;   // qiao
   sortTable[0x5CED]=19123;   // qiao
   sortTable[0x4E54]=19124;   // qiao
   sortTable[0x4FA8]=19125;   // qiao
   sortTable[0x7A8D]=19126;   // qiao
   sortTable[0x4FCF]=19127;   // qiao
   sortTable[0x6A35]=19128;   // qiao
   sortTable[0x9798]=19129;   // qiao
   sortTable[0x8DF7]=19130;   // qiao
   sortTable[0x8BEE]=19131;   // qiao
   sortTable[0x64AC]=19132;   // qiao
   sortTable[0x6194]=19133;   // qiao
   sortTable[0x8C2F]=19134;   // qiao
   sortTable[0x6A47]=19135;   // qiao
   sortTable[0x9792]=19136;   // qiao
   sortTable[0x6100]=19137;   // qiao
   sortTable[0x7857]=19138;   // qiao
   sortTable[0x835E]=19139;   // qiao
   sortTable[0x83EC]=19140;   // qiao
   sortTable[0x8DAB]=19141;   // qiao
   sortTable[0x5281]=19142;   // qiao
   sortTable[0x8DAC]=19143;   // qiao
   sortTable[0x7F32]=19144;   // qiao
   sortTable[0x9121]=19145;   // qiao
   sortTable[0x7AC5]=19146;   // qiao
   sortTable[0x9AB9]=19147;   // qiao
   sortTable[0x785A]=19148;   // qiao
   sortTable[0x7E51]=19149;   // qiao
   sortTable[0x78FD]=19150;   // qiao
   sortTable[0x85EE]=19151;   // qiao
   sortTable[0x834D]=19152;   // qiao
   sortTable[0x91E5]=19153;   // qiao
   sortTable[0x7904]=19154;   // qiao
   sortTable[0x9408]=19155;   // qiao
   sortTable[0x9430]=19156;   // qiao
   sortTable[0x9657]=19157;   // qiao
   sortTable[0x8E88]=19158;   // qiao
   sortTable[0x9125]=19159;   // qiao
   sortTable[0x936B]=19160;   // qiao
   sortTable[0x97BD]=19161;   // qiao
   sortTable[0x97D2]=19162;   // qiao
   sortTable[0x981D]=19163;   // qiao
   sortTable[0x50D1]=19164;   // qiao
   sortTable[0x50FA]=19165;   // qiao
   sortTable[0x55AC]=19166;   // qiao
   sortTable[0x563A]=19167;   // qiao
   sortTable[0x589D]=19168;   // qiao
   sortTable[0x58BD]=19169;   // qiao
   sortTable[0x5AF6]=19170;   // qiao
   sortTable[0x5D6A]=19171;   // qiao
   sortTable[0x5E29]=19172;   // qiao
   sortTable[0x5E67]=19173;   // qiao
   sortTable[0x64BD]=19174;   // qiao
   sortTable[0x69D7]=19175;   // qiao
   sortTable[0x6BBB]=19176;   // qiao
   sortTable[0x6BC3]=19177;   // qiao
   sortTable[0x71C6]=19178;   // qiao
   sortTable[0x729E]=19179;   // qiao
   sortTable[0x7644]=19180;   // qiao
   sortTable[0x854E]=19181;   // qiao
   sortTable[0x8A9A]=19182;   // qiao
   sortTable[0x8B59]=19183;   // qiao
   sortTable[0x8E0D]=19184;   // qiao
   sortTable[0x8E7A]=19185;   // qiao
   sortTable[0x90FB]=19186;   // qiao
   sortTable[0x9866]=19187;   // qiao
   sortTable[0x9ADA]=19188;   // qiao
   sortTable[0x9ADC]=19189;   // qiao
   sortTable[0x4E14]=19190;   // qie
   sortTable[0x5207]=19191;   // qie
   sortTable[0x7A83]=19192;   // qie
   sortTable[0x7ACA]=19193;   // qie
   sortTable[0x602F]=19194;   // qie
   sortTable[0x59BE]=19195;   // qie
   sortTable[0x6308]=19196;   // qie
   sortTable[0x60EC]=19197;   // qie
   sortTable[0x7BA7]=19198;   // qie
   sortTable[0x9532]=19199;   // qie
   sortTable[0x90C4]=19200;   // qie
   sortTable[0x9411]=19201;   // qie
   sortTable[0x807A]=19202;   // qie
   sortTable[0x8E25]=19203;   // qie
   sortTable[0x9365]=19204;   // qie
   sortTable[0x7B21]=19205;   // qie
   sortTable[0x7C61]=19206;   // qie
   sortTable[0x7BCB]=19207;   // qie
   sortTable[0x7DC1]=19208;   // qie
   sortTable[0x86EA]=19209;   // qie
   sortTable[0x503F]=19210;   // qie
   sortTable[0x5327]=19211;   // qie
   sortTable[0x5AAB]=19212;   // qie
   sortTable[0x608F]=19213;   // qie
   sortTable[0x611C]=19214;   // qie
   sortTable[0x6705]=19215;   // qie
   sortTable[0x6D2F]=19216;   // qie
   sortTable[0x6DC1]=19217;   // qie
   sortTable[0x767F]=19218;   // qie
   sortTable[0x7A55]=19219;   // qie
   sortTable[0x82C6]=19220;   // qie
   sortTable[0x85D2]=19221;   // qie
   sortTable[0x9BDC]=19222;   // qie
   sortTable[0x4EB2]=19223;   // qin
   sortTable[0x89AA]=19224;   // qin
   sortTable[0x4FB5]=19225;   // qin
   sortTable[0x52E4]=19226;   // qin
   sortTable[0x7434]=19227;   // qin
   sortTable[0x94A6]=19228;   // qin
   sortTable[0x6B3D]=19229;   // qin
   sortTable[0x79E6]=19230;   // qin
   sortTable[0x64D2]=19231;   // qin
   sortTable[0x5BDD]=19232;   // qin
   sortTable[0x79BD]=19233;   // qin
   sortTable[0x6C81]=19234;   // qin
   sortTable[0x887E]=19235;   // qin
   sortTable[0x82B9]=19236;   // qin
   sortTable[0x82A9]=19237;   // qin
   sortTable[0x5423]=19238;   // qin
   sortTable[0x55EA]=19239;   // qin
   sortTable[0x6A8E]=19240;   // qin
   sortTable[0x5659]=19241;   // qin
   sortTable[0x9513]=19242;   // qin
   sortTable[0x63FF]=19243;   // qin
   sortTable[0x6EB1]=19244;   // qin
   sortTable[0x9A8E]=19245;   // qin
   sortTable[0x8793]=19246;   // qin
   sortTable[0x9BBC]=19247;   // qin
   sortTable[0x99F8]=19248;   // qin
   sortTable[0x8804]=19249;   // qin
   sortTable[0x83E6]=19250;   // qin
   sortTable[0x9219]=19251;   // qin
   sortTable[0x9B35]=19252;   // qin
   sortTable[0x7D85]=19253;   // qin
   sortTable[0x9772]=19254;   // qin
   sortTable[0x7B09]=19255;   // qin
   sortTable[0x83E3]=19256;   // qin
   sortTable[0x83F3]=19257;   // qin
   sortTable[0x85FD]=19258;   // qin
   sortTable[0x92DF]=19259;   // qin
   sortTable[0x96C2]=19260;   // qin
   sortTable[0x9849]=19261;   // qin
   sortTable[0x5422]=19262;   // qin
   sortTable[0x551A]=19263;   // qin
   sortTable[0x5745]=19264;   // qin
   sortTable[0x57C1]=19265;   // qin
   sortTable[0x5A87]=19266;   // qin
   sortTable[0x5AC0]=19267;   // qin
   sortTable[0x5BD1]=19268;   // qin
   sortTable[0x5BE2]=19269;   // qin
   sortTable[0x5BF4]=19270;   // qin
   sortTable[0x5D5A]=19271;   // qin
   sortTable[0x5D94]=19272;   // qin
   sortTable[0x5E88]=19273;   // qin
   sortTable[0x616C]=19274;   // qin
   sortTable[0x61C3]=19275;   // qin
   sortTable[0x61C4]=19276;   // qin
   sortTable[0x628B]=19277;   // qin
   sortTable[0x6366]=19278;   // qin
   sortTable[0x6407]=19279;   // qin
   sortTable[0x64B3]=19280;   // qin
   sortTable[0x65B3]=19281;   // qin
   sortTable[0x6611]=19282;   // qin
   sortTable[0x68AB]=19283;   // qin
   sortTable[0x6FBF]=19284;   // qin
   sortTable[0x7019]=19285;   // qin
   sortTable[0x73E1]=19286;   // qin
   sortTable[0x7439]=19287;   // qin
   sortTable[0x763D]=19288;   // qin
   sortTable[0x8039]=19289;   // qin
   sortTable[0x8699]=19290;   // qin
   sortTable[0x87BC]=19291;   // qin
   sortTable[0x8A9B]=19292;   // qin
   sortTable[0x8D7E]=19293;   // qin
   sortTable[0x9CF9]=19294;   // qin
   sortTable[0x9D6D]=19295;   // qin
   sortTable[0x60C5]=19296;   // qing
   sortTable[0x8F7B]=19297;   // qing
   sortTable[0x8F15]=19298;   // qing
   sortTable[0x9752]=19299;   // qing
   sortTable[0x6E05]=19300;   // qing
   sortTable[0x8BF7]=19301;   // qing
   sortTable[0x8ACB]=19302;   // qing
   sortTable[0x503E]=19303;   // qing
   sortTable[0x50BE]=19304;   // qing
   sortTable[0x6674]=19305;   // qing
   sortTable[0x5E86]=19306;   // qing
   sortTable[0x6176]=19307;   // qing
   sortTable[0x9877]=19308;   // qing
   sortTable[0x9803]=19309;   // qing
   sortTable[0x873B]=19310;   // qing
   sortTable[0x6C22]=19311;   // qing
   sortTable[0x6C2B]=19312;   // qing
   sortTable[0x537F]=19313;   // qing
   sortTable[0x64CE]=19314;   // qing
   sortTable[0x7F44]=19315;   // qing
   sortTable[0x78EC]=19316;   // qing
   sortTable[0x9EE5]=19317;   // qing
   sortTable[0x6C30]=19318;   // qing
   sortTable[0x6AA0]=19319;   // qing
   sortTable[0x7B90]=19320;   // qing
   sortTable[0x9CAD]=19321;   // qing
   sortTable[0x570A]=19322;   // qing
   sortTable[0x82D8]=19323;   // qing
   sortTable[0x8B26]=19324;   // qing
   sortTable[0x7883]=19325;   // qing
   sortTable[0x845D]=19326;   // qing
   sortTable[0x78D8]=19327;   // qing
   sortTable[0x9758]=19328;   // qing
   sortTable[0x51CA]=19329;   // qing
   sortTable[0x5260]=19330;   // qing
   sortTable[0x52CD]=19331;   // qing
   sortTable[0x57E5]=19332;   // qing
   sortTable[0x591D]=19333;   // qing
   sortTable[0x5BC8]=19334;   // qing
   sortTable[0x5EBC]=19335;   // qing
   sortTable[0x5ECE]=19336;   // qing
   sortTable[0x6385]=19337;   // qing
   sortTable[0x64CF]=19338;   // qing
   sortTable[0x6692]=19339;   // qing
   sortTable[0x68FE]=19340;   // qing
   sortTable[0x6A08]=19341;   // qing
   sortTable[0x6ABE]=19342;   // qing
   sortTable[0x6AE6]=19343;   // qing
   sortTable[0x6B91]=19344;   // qing
   sortTable[0x6BB8]=19345;   // qing
   sortTable[0x6DF8]=19346;   // qing
   sortTable[0x6F00]=19347;   // qing
   sortTable[0x72C5]=19348;   // qing
   sortTable[0x7520]=19349;   // qing
   sortTable[0x7858]=19350;   // qing
   sortTable[0x90EC]=19351;   // qing
   sortTable[0x944B]=19352;   // qing
   sortTable[0x9751]=19353;   // qing
   sortTable[0x7A77]=19354;   // qiong
   sortTable[0x7AAE]=19355;   // qiong
   sortTable[0x743C]=19356;   // qiong
   sortTable[0x7A79]=19357;   // qiong
   sortTable[0x86E9]=19358;   // qiong
   sortTable[0x909B]=19359;   // qiong
   sortTable[0x8DEB]=19360;   // qiong
   sortTable[0x828E]=19361;   // qiong
   sortTable[0x928E]=19362;   // qiong
   sortTable[0x7B47]=19363;   // qiong
   sortTable[0x8315]=19364;   // qiong
   sortTable[0x85ED]=19365;   // qiong
   sortTable[0x85D1]=19366;   // qiong
   sortTable[0x7758]=19367;   // qiong
   sortTable[0x86EC]=19368;   // qiong
   sortTable[0x823C]=19369;   // qiong
   sortTable[0x778F]=19370;   // qiong
   sortTable[0x8D79]=19371;   // qiong
   sortTable[0x511D]=19372;   // qiong
   sortTable[0x5314]=19373;   // qiong
   sortTable[0x536D]=19374;   // qiong
   sortTable[0x5B86]=19375;   // qiong
   sortTable[0x60F8]=19376;   // qiong
   sortTable[0x618C]=19377;   // qiong
   sortTable[0x684F]=19378;   // qiong
   sortTable[0x6A69]=19379;   // qiong
   sortTable[0x712A]=19380;   // qiong
   sortTable[0x712D]=19381;   // qiong
   sortTable[0x7162]=19382;   // qiong
   sortTable[0x718D]=19383;   // qiong
   sortTable[0x749A]=19384;   // qiong
   sortTable[0x74CA]=19385;   // qiong
   sortTable[0x74D7]=19386;   // qiong
   sortTable[0x7AC6]=19387;   // qiong
   sortTable[0x7B3B]=19388;   // qiong
   sortTable[0x6C42]=19389;   // qiu
   sortTable[0x7403]=19390;   // qiu
   sortTable[0x79CB]=19391;   // qiu
   sortTable[0x4E18]=19392;   // qiu
   sortTable[0x86AF]=19393;   // qiu
   sortTable[0x56DA]=19394;   // qiu
   sortTable[0x90B1]=19395;   // qiu
   sortTable[0x88D8]=19396;   // qiu
   sortTable[0x914B]=19397;   // qiu
   sortTable[0x866C]=19398;   // qiu
   sortTable[0x4FC5]=19399;   // qiu
   sortTable[0x9CC5]=19400;   // qiu
   sortTable[0x9011]=19401;   // qiu
   sortTable[0x6978]=19402;   // qiu
   sortTable[0x6CC5]=19403;   // qiu
   sortTable[0x9052]=19404;   // qiu
   sortTable[0x8D47]=19405;   // qiu
   sortTable[0x7CD7]=19406;   // qiu
   sortTable[0x5DEF]=19407;   // qiu
   sortTable[0x9194]=19408;   // qiu
   sortTable[0x92B6]=19409;   // qiu
   sortTable[0x9C3D]=19410;   // qiu
   sortTable[0x9E59]=19411;   // qiu
   sortTable[0x72B0]=19412;   // qiu
   sortTable[0x8764]=19413;   // qiu
   sortTable[0x97A6]=19414;   // qiu
   sortTable[0x8A04]=19415;   // qiu
   sortTable[0x7D7F]=19416;   // qiu
   sortTable[0x8DA5]=19417;   // qiu
   sortTable[0x8429]=19418;   // qiu
   sortTable[0x97A7]=19419;   // qiu
   sortTable[0x866F]=19420;   // qiu
   sortTable[0x91DA]=19421;   // qiu
   sortTable[0x79CC]=19422;   // qiu
   sortTable[0x89E9]=19423;   // qiu
   sortTable[0x86F7]=19424;   // qiu
   sortTable[0x9D96]=19425;   // qiu
   sortTable[0x7DE7]=19426;   // qiu
   sortTable[0x8A05]=19427;   // qiu
   sortTable[0x9BC4]=19428;   // qiu
   sortTable[0x9F3D]=19429;   // qiu
   sortTable[0x84F2]=19430;   // qiu
   sortTable[0x9F9D]=19431;   // qiu
   sortTable[0x7A50]=19432;   // qiu
   sortTable[0x808D]=19433;   // qiu
   sortTable[0x89D3]=19434;   // qiu
   sortTable[0x900E]=19435;   // qiu
   sortTable[0x91D3]=19436;   // qiu
   sortTable[0x9B82]=19437;   // qiu
   sortTable[0x9C0C]=19438;   // qiu
   sortTable[0x4E20]=19439;   // qiu
   sortTable[0x53F4]=19440;   // qiu
   sortTable[0x5512]=19441;   // qiu
   sortTable[0x5775]=19442;   // qiu
   sortTable[0x5A9D]=19443;   // qiu
   sortTable[0x5D37]=19444;   // qiu
   sortTable[0x5DF0]=19445;   // qiu
   sortTable[0x6058]=19446;   // qiu
   sortTable[0x624F]=19447;   // qiu
   sortTable[0x641D]=19448;   // qiu
   sortTable[0x6882]=19449;   // qiu
   sortTable[0x6B8F]=19450;   // qiu
   sortTable[0x6BEC]=19451;   // qiu
   sortTable[0x6C53]=19452;   // qiu
   sortTable[0x6D57]=19453;   // qiu
   sortTable[0x6E1E]=19454;   // qiu
   sortTable[0x6E6D]=19455;   // qiu
   sortTable[0x716A]=19456;   // qiu
   sortTable[0x738C]=19457;   // qiu
   sortTable[0x7486]=19458;   // qiu
   sortTable[0x76B3]=19459;   // qiu
   sortTable[0x76DA]=19460;   // qiu
   sortTable[0x7BCD]=19461;   // qiu
   sortTable[0x7D0C]=19462;   // qiu
   sortTable[0x838D]=19463;   // qiu
   sortTable[0x8612]=19464;   // qiu
   sortTable[0x8775]=19465;   // qiu
   sortTable[0x87D7]=19466;   // qiu
   sortTable[0x8824]=19467;   // qiu
   sortTable[0x8CD5]=19468;   // qiu
   sortTable[0x91FB]=19469;   // qiu
   sortTable[0x9C0D]=19470;   // qiu
   sortTable[0x53BB]=19471;   // qu
   sortTable[0x533A]=19472;   // qu
   sortTable[0x5340]=19473;   // qu
   sortTable[0x53D6]=19474;   // qu
   sortTable[0x8DA3]=19475;   // qu
   sortTable[0x66F2]=19476;   // qu
   sortTable[0x6E20]=19477;   // qu
   sortTable[0x5A36]=19478;   // qu
   sortTable[0x5C48]=19479;   // qu
   sortTable[0x8D8B]=19480;   // qu
   sortTable[0x8DA8]=19481;   // qu
   sortTable[0x5C96]=19482;   // qu
   sortTable[0x5D87]=19483;   // qu
   sortTable[0x9A71]=19484;   // qu
   sortTable[0x9A45]=19485;   // qu
   sortTable[0x8EAF]=19486;   // qu
   sortTable[0x86C6]=19487;   // qu
   sortTable[0x8EC0]=19488;   // qu
   sortTable[0x9F8B]=19489;   // qu
   sortTable[0x77BF]=19490;   // qu
   sortTable[0x89D1]=19491;   // qu
   sortTable[0x8862]=19492;   // qu
   sortTable[0x883C]=19493;   // qu
   sortTable[0x8556]=19494;   // qu
   sortTable[0x6710]=19495;   // qu
   sortTable[0x9612]=19496;   // qu
   sortTable[0x8BCE]=19497;   // qu
   sortTable[0x86D0]=19498;   // qu
   sortTable[0x8627]=19499;   // qu
   sortTable[0x52AC]=19500;   // qu
   sortTable[0x795B]=19501;   // qu
   sortTable[0x766F]=19502;   // qu
   sortTable[0x74A9]=19503;   // qu
   sortTable[0x9E32]=19504;   // qu
   sortTable[0x9EB9]=19505;   // qu
   sortTable[0x9EE2]=19506;   // qu
   sortTable[0x9EB4]=19507;   // qu
   sortTable[0x88AA]=19508;   // qu
   sortTable[0x6C0D]=19509;   // qu
   sortTable[0x78F2]=19510;   // qu
   sortTable[0x80E0]=19511;   // qu
   sortTable[0x7D47]=19512;   // qu
   sortTable[0x99C6]=19513;   // qu
   sortTable[0x9F29]=19514;   // qu
   sortTable[0x81DE]=19515;   // qu
   sortTable[0x83C3]=19516;   // qu
   sortTable[0x7C67]=19517;   // qu
   sortTable[0x95B4]=19518;   // qu
   sortTable[0x9E1C]=19519;   // qu
   sortTable[0x877A]=19520;   // qu
   sortTable[0x7CAC]=19521;   // qu
   sortTable[0x8FF2]=19522;   // qu
   sortTable[0x80CA]=19523;   // qu
   sortTable[0x9639]=19524;   // qu
   sortTable[0x9EAF]=19525;   // qu
   sortTable[0x7D36]=19526;   // qu
   sortTable[0x8EE5]=19527;   // qu
   sortTable[0x7FD1]=19528;   // qu
   sortTable[0x844B]=19529;   // qu
   sortTable[0x8AB3]=19530;   // qu
   sortTable[0x9C38]=19531;   // qu
   sortTable[0x9F01]=19532;   // qu
   sortTable[0x957C]=19533;   // qu
   sortTable[0x95C3]=19534;   // qu
   sortTable[0x8837]=19535;   // qu
   sortTable[0x99C8]=19536;   // qu
   sortTable[0x9AF7]=19537;   // qu
   sortTable[0x9F72]=19538;   // qu
   sortTable[0x89BB]=19539;   // qu
   sortTable[0x947A]=19540;   // qu
   sortTable[0x9EAE]=19541;   // qu
   sortTable[0x4F39]=19542;   // qu
   sortTable[0x4F49]=19543;   // qu
   sortTable[0x4F62]=19544;   // qu
   sortTable[0x521E]=19545;   // qu
   sortTable[0x5324]=19546;   // qu
   sortTable[0x53BA]=19547;   // qu
   sortTable[0x547F]=19548;   // qu
   sortTable[0x551F]=19549;   // qu
   sortTable[0x5765]=19550;   // qu
   sortTable[0x5CA8]=19551;   // qu
   sortTable[0x5CB4]=19552;   // qu
   sortTable[0x5FC2]=19553;   // qu
   sortTable[0x6188]=19554;   // qu
   sortTable[0x6235]=19555;   // qu
   sortTable[0x62BE]=19556;   // qu
   sortTable[0x657A]=19557;   // qu
   sortTable[0x65AA]=19558;   // qu
   sortTable[0x6B0B]=19559;   // qu
   sortTable[0x6D40]=19560;   // qu
   sortTable[0x6DED]=19561;   // qu
   sortTable[0x7048]=19562;   // qu
   sortTable[0x7496]=19563;   // qu
   sortTable[0x7AD8]=19564;   // qu
   sortTable[0x7AEC]=19565;   // qu
   sortTable[0x7B41]=19566;   // qu
   sortTable[0x801D]=19567;   // qu
   sortTable[0x87B6]=19568;   // qu
   sortTable[0x87DD]=19569;   // qu
   sortTable[0x8850]=19570;   // qu
   sortTable[0x89B0]=19571;   // qu
   sortTable[0x89B7]=19572;   // qu
   sortTable[0x8A53]=19573;   // qu
   sortTable[0x8A58]=19574;   // qu
   sortTable[0x8EA3]=19575;   // qu
   sortTable[0x9B7C]=19576;   // qu
   sortTable[0x9C4B]=19577;   // qu
   sortTable[0x9D1D]=19578;   // qu
   sortTable[0x5168]=19579;   // quan
   sortTable[0x6743]=19580;   // quan
   sortTable[0x6B0A]=19581;   // quan
   sortTable[0x5708]=19582;   // quan
   sortTable[0x529D]=19583;   // quan
   sortTable[0x52F8]=19584;   // quan
   sortTable[0x62F3]=19585;   // quan
   sortTable[0x6CC9]=19586;   // quan
   sortTable[0x72AC]=19587;   // quan
   sortTable[0x5238]=19588;   // quan
   sortTable[0x8BE0]=19589;   // quan
   sortTable[0x94E8]=19590;   // quan
   sortTable[0x75CA]=19591;   // quan
   sortTable[0x7EFB]=19592;   // quan
   sortTable[0x8343]=19593;   // quan
   sortTable[0x8737]=19594;   // quan
   sortTable[0x609B]=19595;   // quan
   sortTable[0x754E]=19596;   // quan
   sortTable[0x98A7]=19597;   // quan
   sortTable[0x919B]=19598;   // quan
   sortTable[0x7B4C]=19599;   // quan
   sortTable[0x9B08]=19600;   // quan
   sortTable[0x9409]=19601;   // quan
   sortTable[0x8A6E]=19602;   // quan
   sortTable[0x9CC8]=19603;   // quan
   sortTable[0x7E13]=19604;   // quan
   sortTable[0x7D5F]=19605;   // quan
   sortTable[0x9C01]=19606;   // quan
   sortTable[0x8E21]=19607;   // quan
   sortTable[0x8DE7]=19608;   // quan
   sortTable[0x8472]=19609;   // quan
   sortTable[0x8F81]=19610;   // quan
   sortTable[0x8838]=19611;   // quan
   sortTable[0x9293]=19612;   // quan
   sortTable[0x99E9]=19613;   // quan
   sortTable[0x7842]=19614;   // quan
   sortTable[0x8647]=19615;   // quan
   sortTable[0x9874]=19616;   // quan
   sortTable[0x4F7A]=19617;   // quan
   sortTable[0x52E7]=19618;   // quan
   sortTable[0x5573]=19619;   // quan
   sortTable[0x570F]=19620;   // quan
   sortTable[0x57E2]=19621;   // quan
   sortTable[0x59FE]=19622;   // quan
   sortTable[0x5A58]=19623;   // quan
   sortTable[0x5B49]=19624;   // quan
   sortTable[0x5CD1]=19625;   // quan
   sortTable[0x5DCF]=19626;   // quan
   sortTable[0x5F2E]=19627;   // quan
   sortTable[0x606E]=19628;   // quan
   sortTable[0x60D3]=19629;   // quan
   sortTable[0x643C]=19630;   // quan
   sortTable[0x68EC]=19631;   // quan
   sortTable[0x6926]=19632;   // quan
   sortTable[0x697E]=19633;   // quan
   sortTable[0x6A29]=19634;   // quan
   sortTable[0x6C71]=19635;   // quan
   sortTable[0x6D24]=19636;   // quan
   sortTable[0x6E76]=19637;   // quan
   sortTable[0x70C7]=19638;   // quan
   sortTable[0x7276]=19639;   // quan
   sortTable[0x7277]=19640;   // quan
   sortTable[0x7288]=19641;   // quan
   sortTable[0x72AD]=19642;   // quan
   sortTable[0x7454]=19643;   // quan
   sortTable[0x7DA3]=19644;   // quan
   sortTable[0x89E0]=19645;   // quan
   sortTable[0x8F07]=19646;   // quan
   sortTable[0x95CE]=19647;   // quan
   sortTable[0x97CF]=19648;   // quan
   sortTable[0x9A21]=19649;   // quan
   sortTable[0x9F64]=19650;   // quan
   sortTable[0x5374]=19651;   // que
   sortTable[0x537B]=19652;   // que
   sortTable[0x786E]=19653;   // que
   sortTable[0x78BA]=19654;   // que
   sortTable[0x7F3A]=19655;   // que
   sortTable[0x96C0]=19656;   // que
   sortTable[0x9E4A]=19657;   // que
   sortTable[0x9D72]=19658;   // que
   sortTable[0x9619]=19659;   // que
   sortTable[0x69B7]=19660;   // que
   sortTable[0x9615]=19661;   // que
   sortTable[0x7638]=19662;   // que
   sortTable[0x60AB]=19663;   // que
   sortTable[0x78BB]=19664;   // que
   sortTable[0x788F]=19665;   // que
   sortTable[0x7910]=19666;   // que
   sortTable[0x95D5]=19667;   // que
   sortTable[0x785E]=19668;   // que
   sortTable[0x849B]=19669;   // que
   sortTable[0x57C6]=19670;   // que
   sortTable[0x5859]=19671;   // que
   sortTable[0x58A7]=19672;   // que
   sortTable[0x5BC9]=19673;   // que
   sortTable[0x5D05]=19674;   // que
   sortTable[0x6128]=19675;   // que
   sortTable[0x6164]=19676;   // que
   sortTable[0x6409]=19677;   // que
   sortTable[0x704D]=19678;   // que
   sortTable[0x71E9]=19679;   // que
   sortTable[0x7437]=19680;   // que
   sortTable[0x76B5]=19681;   // que
   sortTable[0x792D]=19682;   // que
   sortTable[0x8D9E]=19683;   // que
   sortTable[0x95CB]=19684;   // que
   sortTable[0x7FA4]=19685;   // qun
   sortTable[0x88D9]=19686;   // qun
   sortTable[0x9021]=19687;   // qun
   sortTable[0x56F7]=19688;   // qun
   sortTable[0x590B]=19689;   // qun
   sortTable[0x5BAD]=19690;   // qun
   sortTable[0x5CEE]=19691;   // qun
   sortTable[0x5E2C]=19692;   // qun
   sortTable[0x7FA3]=19693;   // qun
   sortTable[0x88E0]=19694;   // qun
   sortTable[0x7136]=19968;   // ran
   sortTable[0x71C3]=19969;   // ran
   sortTable[0x67D3]=19970;   // ran
   sortTable[0x5189]=19971;   // ran
   sortTable[0x9AEF]=19972;   // ran
   sortTable[0x82D2]=19973;   // ran
   sortTable[0x86BA]=19974;   // ran
   sortTable[0x8887]=19975;   // ran
   sortTable[0x88A1]=19976;   // ran
   sortTable[0x9AE5]=19977;   // ran
   sortTable[0x80B0]=19978;   // ran
   sortTable[0x5184]=19979;   // ran
   sortTable[0x5465]=19980;   // ran
   sortTable[0x562B]=19981;   // ran
   sortTable[0x59CC]=19982;   // ran
   sortTable[0x5AA3]=19983;   // ran
   sortTable[0x6A6A]=19984;   // ran
   sortTable[0x73C3]=19985;   // ran
   sortTable[0x7E4E]=19986;   // ran
   sortTable[0x8485]=19987;   // ran
   sortTable[0x86A6]=19988;   // ran
   sortTable[0x887B]=19989;   // ran
   sortTable[0x8BA9]=19990;   // rang
   sortTable[0x8B93]=19991;   // rang
   sortTable[0x56B7]=19992;   // rang
   sortTable[0x58E4]=19993;   // rang
   sortTable[0x6518]=19994;   // rang
   sortTable[0x7A70]=19995;   // rang
   sortTable[0x79B3]=19996;   // rang
   sortTable[0x74E4]=19997;   // rang
   sortTable[0x8618]=19998;   // rang
   sortTable[0x7E95]=19999;   // rang
   sortTable[0x5134]=20000;   // rang
   sortTable[0x52F7]=20001;   // rang
   sortTable[0x58CC]=20002;   // rang
   sortTable[0x61F9]=20003;   // rang
   sortTable[0x703C]=20004;   // rang
   sortTable[0x7219]=20005;   // rang
   sortTable[0x737D]=20006;   // rang
   sortTable[0x7A63]=20007;   // rang
   sortTable[0x8B72]=20008;   // rang
   sortTable[0x8E9F]=20009;   // rang
   sortTable[0x9B24]=20010;   // rang
   sortTable[0x7ED5]=20011;   // rao
   sortTable[0x7E5E]=20012;   // rao
   sortTable[0x6270]=20013;   // rao
   sortTable[0x64FE]=20014;   // rao
   sortTable[0x9976]=20015;   // rao
   sortTable[0x9952]=20016;   // rao
   sortTable[0x6861]=20017;   // rao
   sortTable[0x835B]=20018;   // rao
   sortTable[0x5A06]=20019;   // rao
   sortTable[0x9076]=20020;   // rao
   sortTable[0x8558]=20021;   // rao
   sortTable[0x8953]=20022;   // rao
   sortTable[0x5B08]=20023;   // rao
   sortTable[0x6A48]=20024;   // rao
   sortTable[0x96A2]=20025;   // rao
   sortTable[0x70ED]=20026;   // re
   sortTable[0x71B1]=20027;   // re
   sortTable[0x60F9]=20028;   // re
   sortTable[0x4EBA]=20029;   // ren
   sortTable[0x8BA4]=20030;   // ren
   sortTable[0x8A8D]=20031;   // ren
   sortTable[0x4EFB]=20032;   // ren
   sortTable[0x5FCD]=20033;   // ren
   sortTable[0x97E7]=20034;   // ren
   sortTable[0x97CC]=20035;   // ren
   sortTable[0x4EC1]=20036;   // ren
   sortTable[0x58EC]=20037;   // ren
   sortTable[0x5203]=20038;   // ren
   sortTable[0x7EAB]=20039;   // ren
   sortTable[0x598A]=20040;   // ren
   sortTable[0x7A14]=20041;   // ren
   sortTable[0x4EDE]=20042;   // ren
   sortTable[0x996A]=20043;   // ren
   sortTable[0x887D]=20044;   // ren
   sortTable[0x834F]=20045;   // ren
   sortTable[0x845A]=20046;   // ren
   sortTable[0x8F6B]=20047;   // ren
   sortTable[0x7EB4]=20048;   // ren
   sortTable[0x8A12]=20049;   // ren
   sortTable[0x8BB1]=20050;   // ren
   sortTable[0x98EA]=20051;   // ren
   sortTable[0x8ED4]=20052;   // ren
   sortTable[0x88B5]=20053;   // ren
   sortTable[0x9B5C]=20054;   // ren
   sortTable[0x928B]=20055;   // ren
   sortTable[0x79F9]=20056;   // ren
   sortTable[0x8EE0]=20057;   // ren
   sortTable[0x9901]=20058;   // ren
   sortTable[0x9D40]=20059;   // ren
   sortTable[0x7D1D]=20060;   // ren
   sortTable[0x9213]=20061;   // ren
   sortTable[0x976D]=20062;   // ren
   sortTable[0x8095]=20063;   // ren
   sortTable[0x82A2]=20064;   // ren
   sortTable[0x7D4D]=20065;   // ren
   sortTable[0x814D]=20066;   // ren
   sortTable[0x8375]=20067;   // ren
   sortTable[0x9771]=20068;   // ren
   sortTable[0x4EBB]=20069;   // ren
   sortTable[0x4EED]=20070;   // ren
   sortTable[0x5204]=20071;   // ren
   sortTable[0x59D9]=20072;   // ren
   sortTable[0x5C7B]=20073;   // ren
   sortTable[0x5C83]=20074;   // ren
   sortTable[0x5FC8]=20075;   // ren
   sortTable[0x5FCE]=20076;   // ren
   sortTable[0x6268]=20077;   // ren
   sortTable[0x6732]=20078;   // ren
   sortTable[0x6752]=20079;   // ren
   sortTable[0x6820]=20080;   // ren
   sortTable[0x6823]=20081;   // ren
   sortTable[0x6895]=20082;   // ren
   sortTable[0x68EF]=20083;   // ren
   sortTable[0x7263]=20084;   // ren
   sortTable[0x794D]=20085;   // ren
   sortTable[0x79C2]=20086;   // ren
   sortTable[0x7D09]=20087;   // ren
   sortTable[0x7D9B]=20088;   // ren
   sortTable[0x8EB5]=20089;   // ren
   sortTable[0x4ECD]=20090;   // reng
   sortTable[0x6254]=20091;   // reng
   sortTable[0x793D]=20092;   // reng
   sortTable[0x82BF]=20093;   // reng
   sortTable[0x8FB8]=20094;   // reng
   sortTable[0x967E]=20095;   // reng
   sortTable[0x65E5]=20096;   // ri
   sortTable[0x9224]=20097;   // ri
   sortTable[0x9A72]=20098;   // ri
   sortTable[0x99B9]=20099;   // ri
   sortTable[0x56F8]=20100;   // ri
   sortTable[0x91F0]=20101;   // ri
   sortTable[0x5BB9]=20102;   // rong
   sortTable[0x8363]=20103;   // rong
   sortTable[0x69AE]=20104;   // rong
   sortTable[0x6EB6]=20105;   // rong
   sortTable[0x7ED2]=20106;   // rong
   sortTable[0x7D68]=20107;   // rong
   sortTable[0x878D]=20108;   // rong
   sortTable[0x7194]=20109;   // rong
   sortTable[0x8338]=20110;   // rong
   sortTable[0x6995]=20111;   // rong
   sortTable[0x620E]=20112;   // rong
   sortTable[0x84C9]=20113;   // rong
   sortTable[0x5197]=20114;   // rong
   sortTable[0x9555]=20115;   // rong
   sortTable[0x5D58]=20116;   // rong
   sortTable[0x809C]=20117;   // rong
   sortTable[0x877E]=20118;   // rong
   sortTable[0x72E8]=20119;   // rong
   sortTable[0x9394]=20120;   // rong
   sortTable[0x8319]=20121;   // rong
   sortTable[0x8EF5]=20122;   // rong
   sortTable[0x9D27]=20123;   // rong
   sortTable[0x7A43]=20124;   // rong
   sortTable[0x7FA2]=20125;   // rong
   sortTable[0x8811]=20126;   // rong
   sortTable[0x7E19]=20127;   // rong
   sortTable[0x8923]=20128;   // rong
   sortTable[0x99E5]=20129;   // rong
   sortTable[0x5087]=20130;   // rong
   sortTable[0x5748]=20131;   // rong
   sortTable[0x5AB6]=20132;   // rong
   sortTable[0x5AC6]=20133;   // rong
   sortTable[0x5B2B]=20134;   // rong
   sortTable[0x5B82]=20135;   // rong
   sortTable[0x5D64]=20136;   // rong
   sortTable[0x5DB8]=20137;   // rong
   sortTable[0x5DC6]=20138;   // rong
   sortTable[0x6408]=20139;   // rong
   sortTable[0x6411]=20140;   // rong
   sortTable[0x66E7]=20141;   // rong
   sortTable[0x6804]=20142;   // rong
   sortTable[0x69B5]=20143;   // rong
   sortTable[0x6BE7]=20144;   // rong
   sortTable[0x6C04]=20145;   // rong
   sortTable[0x701C]=20146;   // rong
   sortTable[0x70FF]=20147;   // rong
   sortTable[0x7203]=20148;   // rong
   sortTable[0x7462]=20149;   // rong
   sortTable[0x7A41]=20150;   // rong
   sortTable[0x878E]=20151;   // rong
   sortTable[0x9AF6]=20152;   // rong
   sortTable[0x8089]=20153;   // rou
   sortTable[0x67D4]=20154;   // rou
   sortTable[0x63C9]=20155;   // rou
   sortTable[0x8E42]=20156;   // rou
   sortTable[0x97A3]=20157;   // rou
   sortTable[0x7CC5]=20158;   // rou
   sortTable[0x8F2E]=20159;   // rou
   sortTable[0x875A]=20160;   // rou
   sortTable[0x8447]=20161;   // rou
   sortTable[0x816C]=20162;   // rou
   sortTable[0x9D94]=20163;   // rou
   sortTable[0x7C88]=20164;   // rou
   sortTable[0x9A25]=20165;   // rou
   sortTable[0x53B9]=20166;   // rou
   sortTable[0x5A83]=20167;   // rou
   sortTable[0x5B8D]=20168;   // rou
   sortTable[0x697A]=20169;   // rou
   sortTable[0x6E18]=20170;   // rou
   sortTable[0x7163]=20171;   // rou
   sortTable[0x7448]=20172;   // rou
   sortTable[0x74C7]=20173;   // rou
   sortTable[0x79B8]=20174;   // rou
   sortTable[0x9352]=20175;   // rou
   sortTable[0x97D6]=20176;   // rou
   sortTable[0x9C07]=20177;   // rou
   sortTable[0x5982]=20178;   // ru
   sortTable[0x5165]=20179;   // ru
   sortTable[0x4E73]=20180;   // ru
   sortTable[0x8FB1]=20181;   // ru
   sortTable[0x8815]=20182;   // ru
   sortTable[0x6C5D]=20183;   // ru
   sortTable[0x5112]=20184;   // ru
   sortTable[0x5B7A]=20185;   // ru
   sortTable[0x8925]=20186;   // ru
   sortTable[0x8339]=20187;   // ru
   sortTable[0x6D33]=20188;   // ru
   sortTable[0x6FE1]=20189;   // ru
   sortTable[0x7F1B]=20190;   // ru
   sortTable[0x5685]=20191;   // ru
   sortTable[0x85B7]=20192;   // ru
   sortTable[0x8966]=20193;   // ru
   sortTable[0x84D0]=20194;   // ru
   sortTable[0x6EBD]=20195;   // ru
   sortTable[0x910F]=20196;   // ru
   sortTable[0x94F7]=20197;   // ru
   sortTable[0x9D3D]=20198;   // ru
   sortTable[0x88BD]=20199;   // ru
   sortTable[0x98A5]=20200;   // ru
   sortTable[0x9CF0]=20201;   // ru
   sortTable[0x986C]=20202;   // ru
   sortTable[0x8FBC]=20203;   // ru
   sortTable[0x8761]=20204;   // ru
   sortTable[0x909A]=20205;   // ru
   sortTable[0x8498]=20206;   // ru
   sortTable[0x91B9]=20207;   // ru
   sortTable[0x8097]=20208;   // ru
   sortTable[0x8560]=20209;   // ru
   sortTable[0x4F9E]=20210;   // ru
   sortTable[0x55D5]=20211;   // ru
   sortTable[0x5AB7]=20212;   // ru
   sortTable[0x5B2C]=20213;   // ru
   sortTable[0x5DBF]=20214;   // ru
   sortTable[0x5E24]=20215;   // ru
   sortTable[0x6256]=20216;   // ru
   sortTable[0x64E9]=20217;   // ru
   sortTable[0x66D8]=20218;   // ru
   sortTable[0x6741]=20219;   // ru
   sortTable[0x6847]=20220;   // ru
   sortTable[0x6E2A]=20221;   // ru
   sortTable[0x71F8]=20222;   // ru
   sortTable[0x7B4E]=20223;   // ru
   sortTable[0x7E1F]=20224;   // ru
   sortTable[0x92A3]=20225;   // ru
   sortTable[0x9C6C]=20226;   // ru
   sortTable[0x9D11]=20227;   // ru
   sortTable[0x633C]=20228;   // rua
   sortTable[0x8F6F]=20229;   // ruan
   sortTable[0x8EDF]=20230;   // ruan
   sortTable[0x962E]=20231;   // ruan
   sortTable[0x670A]=20232;   // ruan
   sortTable[0x800E]=20233;   // ruan
   sortTable[0x7DDB]=20234;   // ruan
   sortTable[0x8F2D]=20235;   // ruan
   sortTable[0x789D]=20236;   // ruan
   sortTable[0x5044]=20237;   // ruan
   sortTable[0x5827]=20238;   // ruan
   sortTable[0x58D6]=20239;   // ruan
   sortTable[0x5A86]=20240;   // ruan
   sortTable[0x648B]=20241;   // ruan
   sortTable[0x744C]=20242;   // ruan
   sortTable[0x74C0]=20243;   // ruan
   sortTable[0x791D]=20244;   // ruan
   sortTable[0x9510]=20245;   // rui
   sortTable[0x92B3]=20246;   // rui
   sortTable[0x745E]=20247;   // rui
   sortTable[0x777F]=20248;   // rui
   sortTable[0x854A]=20249;   // rui
   sortTable[0x82AE]=20250;   // rui
   sortTable[0x8564]=20251;   // rui
   sortTable[0x868B]=20252;   // rui
   sortTable[0x6798]=20253;   // rui
   sortTable[0x7DCC]=20254;   // rui
   sortTable[0x7E60]=20255;   // rui
   sortTable[0x92ED]=20256;   // rui
   sortTable[0x8602]=20257;   // rui
   sortTable[0x854B]=20258;   // rui
   sortTable[0x8739]=20259;   // rui
   sortTable[0x53E1]=20260;   // rui
   sortTable[0x58E1]=20261;   // rui
   sortTable[0x5A51]=20262;   // rui
   sortTable[0x6875]=20263;   // rui
   sortTable[0x6A64]=20264;   // rui
   sortTable[0x6C6D]=20265;   // rui
   sortTable[0x7524]=20266;   // rui
   sortTable[0x8603]=20267;   // rui
   sortTable[0x6DA6]=20268;   // run
   sortTable[0x6F64]=20269;   // run
   sortTable[0x95F0]=20270;   // run
   sortTable[0x81B6]=20271;   // run
   sortTable[0x77A4]=20272;   // run
   sortTable[0x958F]=20273;   // run
   sortTable[0x6A4D]=20274;   // run
   sortTable[0x95A0]=20275;   // run
   sortTable[0x5F31]=20276;   // ruo
   sortTable[0x82E5]=20277;   // ruo
   sortTable[0x504C]=20278;   // ruo
   sortTable[0x7BAC]=20279;   // ruo
   sortTable[0x9100]=20280;   // ruo
   sortTable[0x84BB]=20281;   // ruo
   sortTable[0x9DB8]=20282;   // ruo
   sortTable[0x7BDB]=20283;   // ruo
   sortTable[0x53D2]=20284;   // ruo
   sortTable[0x5D76]=20285;   // ruo
   sortTable[0x637C]=20286;   // ruo
   sortTable[0x6949]=20287;   // ruo
   sortTable[0x6E03]=20288;   // ruo
   sortTable[0x712B]=20289;   // ruo
   sortTable[0x7207]=20290;   // ruo
   sortTable[0x9C19]=20291;   // ruo
   sortTable[0x9C2F]=20292;   // ruo
   sortTable[0x6492]=20736;   // sa
   sortTable[0x6D12]=20737;   // sa
   sortTable[0x8428]=20738;   // sa
   sortTable[0x85A9]=20739;   // sa
   sortTable[0x98D2]=20740;   // sa
   sortTable[0x5345]=20741;   // sa
   sortTable[0x4EE8]=20742;   // sa
   sortTable[0x6332]=20743;   // sa
   sortTable[0x9778]=20744;   // sa
   sortTable[0x9212]=20745;   // sa
   sortTable[0x810E]=20746;   // sa
   sortTable[0x99BA]=20747;   // sa
   sortTable[0x8644]=20748;   // sa
   sortTable[0x8EA0]=20749;   // sa
   sortTable[0x6331]=20750;   // sa
   sortTable[0x644B]=20751;   // sa
   sortTable[0x6AD2]=20752;   // sa
   sortTable[0x6CE7]=20753;   // sa
   sortTable[0x6F75]=20754;   // sa
   sortTable[0x7051]=20755;   // sa
   sortTable[0x8A2F]=20756;   // sa
   sortTable[0x96A1]=20757;   // sa
   sortTable[0x98AF]=20758;   // sa
   sortTable[0x8D5B]=20759;   // sai
   sortTable[0x8CFD]=20760;   // sai
   sortTable[0x585E]=20761;   // sai
   sortTable[0x816E]=20762;   // sai
   sortTable[0x9CC3]=20763;   // sai
   sortTable[0x567B]=20764;   // sai
   sortTable[0x7C3A]=20765;   // sai
   sortTable[0x50FF]=20766;   // sai
   sortTable[0x55EE]=20767;   // sai
   sortTable[0x5625]=20768;   // sai
   sortTable[0x6122]=20769;   // sai
   sortTable[0x63CC]=20770;   // sai
   sortTable[0x6BE2]=20771;   // sai
   sortTable[0x6BF8]=20772;   // sai
   sortTable[0x984B]=20773;   // sai
   sortTable[0x9C13]=20774;   // sai
   sortTable[0x4E09]=20775;   // san
   sortTable[0x6563]=20776;   // san
   sortTable[0x4F1E]=20777;   // san
   sortTable[0x5098]=20778;   // san
   sortTable[0x53C1]=20779;   // san
   sortTable[0x7CC1]=20780;   // san
   sortTable[0x9730]=20781;   // san
   sortTable[0x9993]=20782;   // san
   sortTable[0x7E56]=20783;   // san
   sortTable[0x6BF5]=20784;   // san
   sortTable[0x93FE]=20785;   // san
   sortTable[0x7CE4]=20786;   // san
   sortTable[0x9B16]=20787;   // san
   sortTable[0x7CC2]=20788;   // san
   sortTable[0x4ED0]=20789;   // san
   sortTable[0x4FD5]=20790;   // san
   sortTable[0x5381]=20791;   // san
   sortTable[0x58ED]=20792;   // san
   sortTable[0x5E34]=20793;   // san
   sortTable[0x5F0E]=20794;   // san
   sortTable[0x60B7]=20795;   // san
   sortTable[0x6A75]=20796;   // san
   sortTable[0x6BF6]=20797;   // san
   sortTable[0x6BFF]=20798;   // san
   sortTable[0x7299]=20799;   // san
   sortTable[0x7CDD]=20800;   // san
   sortTable[0x7CE3]=20801;   // san
   sortTable[0x93D2]=20802;   // san
   sortTable[0x9590]=20803;   // san
   sortTable[0x994A]=20804;   // san
   sortTable[0x55D3]=20805;   // sang
   sortTable[0x4E27]=20806;   // sang
   sortTable[0x55AA]=20807;   // sang
   sortTable[0x6851]=20808;   // sang
   sortTable[0x98A1]=20809;   // sang
   sortTable[0x6421]=20810;   // sang
   sortTable[0x78C9]=20811;   // sang
   sortTable[0x9859]=20812;   // sang
   sortTable[0x6852]=20813;   // sang
   sortTable[0x69E1]=20814;   // sang
   sortTable[0x892C]=20815;   // sang
   sortTable[0x939F]=20816;   // sang
   sortTable[0x5AC2]=20817;   // sao
   sortTable[0x626B]=20818;   // sao
   sortTable[0x6383]=20819;   // sao
   sortTable[0x6414]=20820;   // sao
   sortTable[0x9A9A]=20821;   // sao
   sortTable[0x57FD]=20822;   // sao
   sortTable[0x7F2B]=20823;   // sao
   sortTable[0x81CA]=20824;   // sao
   sortTable[0x7619]=20825;   // sao
   sortTable[0x9ADE]=20826;   // sao
   sortTable[0x9CCB]=20827;   // sao
   sortTable[0x77C2]=20828;   // sao
   sortTable[0x9C20]=20829;   // sao
   sortTable[0x7E45]=20830;   // sao
   sortTable[0x87A6]=20831;   // sao
   sortTable[0x9A37]=20832;   // sao
   sortTable[0x6145]=20833;   // sao
   sortTable[0x63BB]=20834;   // sao
   sortTable[0x6C09]=20835;   // sao
   sortTable[0x6E9E]=20836;   // sao
   sortTable[0x9A12]=20837;   // sao
   sortTable[0x9C62]=20838;   // sao
   sortTable[0x8272]=20839;   // se
   sortTable[0x745F]=20840;   // se
   sortTable[0x7A51]=20841;   // se
   sortTable[0x6DA9]=20842;   // se
   sortTable[0x556C]=20843;   // se
   sortTable[0x94EF]=20844;   // se
   sortTable[0x96ED]=20845;   // se
   sortTable[0x8B45]=20846;   // se
   sortTable[0x7A6F]=20847;   // se
   sortTable[0x8F56]=20848;   // se
   sortTable[0x7E6C]=20849;   // se
   sortTable[0x92AB]=20850;   // se
   sortTable[0x98CB]=20851;   // se
   sortTable[0x55C7]=20852;   // se
   sortTable[0x61CE]=20853;   // se
   sortTable[0x64CC]=20854;   // se
   sortTable[0x681C]=20855;   // se
   sortTable[0x6B6E]=20856;   // se
   sortTable[0x6B70]=20857;   // se
   sortTable[0x6D13]=20858;   // se
   sortTable[0x6E0B]=20859;   // se
   sortTable[0x6F80]=20860;   // se
   sortTable[0x6F81]=20861;   // se
   sortTable[0x6FC7]=20862;   // se
   sortTable[0x6FCF]=20863;   // se
   sortTable[0x7012]=20864;   // se
   sortTable[0x7417]=20865;   // se
   sortTable[0x74B1]=20866;   // se
   sortTable[0x7637]=20867;   // se
   sortTable[0x7A61]=20868;   // se
   sortTable[0x93FC]=20869;   // se
   sortTable[0x95AA]=20870;   // se
   sortTable[0x68EE]=20871;   // sen
   sortTable[0x8942]=20872;   // sen
   sortTable[0x692E]=20873;   // sen
   sortTable[0x69EE]=20874;   // sen
   sortTable[0x50E7]=20875;   // seng
   sortTable[0x9B19]=20876;   // seng
   sortTable[0x6C99]=20877;   // sha
   sortTable[0x6740]=20878;   // sha
   sortTable[0x6BBA]=20879;   // sha
   sortTable[0x5565]=20880;   // sha
   sortTable[0x7EB1]=20881;   // sha
   sortTable[0x7D17]=20882;   // sha
   sortTable[0x50BB]=20883;   // sha
   sortTable[0x7802]=20884;   // sha
   sortTable[0x715E]=20885;   // sha
   sortTable[0x5239]=20886;   // sha
   sortTable[0x53A6]=20887;   // sha
   sortTable[0x524E]=20888;   // sha
   sortTable[0x5EC8]=20889;   // sha
   sortTable[0x970E]=20890;   // sha
   sortTable[0x838E]=20891;   // sha
   sortTable[0x94E9]=20892;   // sha
   sortTable[0x88DF]=20893;   // sha
   sortTable[0x9CA8]=20894;   // sha
   sortTable[0x6B43]=20895;   // sha
   sortTable[0x75E7]=20896;   // sha
   sortTable[0x7FE3]=20897;   // sha
   sortTable[0x553C]=20898;   // sha
   sortTable[0x9BCA]=20899;   // sha
   sortTable[0x7FDC]=20900;   // sha
   sortTable[0x9BCB]=20901;   // sha
   sortTable[0x7B91]=20902;   // sha
   sortTable[0x8410]=20903;   // sha
   sortTable[0x7E4C]=20904;   // sha
   sortTable[0x7870]=20905;   // sha
   sortTable[0x9B66]=20906;   // sha
   sortTable[0x7C86]=20907;   // sha
   sortTable[0x95AF]=20908;   // sha
   sortTable[0x8531]=20909;   // sha
   sortTable[0x4E77]=20910;   // sha
   sortTable[0x503D]=20911;   // sha
   sortTable[0x510D]=20912;   // sha
   sortTable[0x5526]=20913;   // sha
   sortTable[0x5551]=20914;   // sha
   sortTable[0x55A2]=20915;   // sha
   sortTable[0x5E39]=20916;   // sha
   sortTable[0x686C]=20917;   // sha
   sortTable[0x699D]=20918;   // sha
   sortTable[0x6A27]=20919;   // sha
   sortTable[0x6BEE]=20920;   // sha
   sortTable[0x7300]=20921;   // sha
   sortTable[0x93A9]=20922;   // sha
   sortTable[0x6652]=20923;   // shai
   sortTable[0x7B5B]=20924;   // shai
   sortTable[0x7BE9]=20925;   // shai
   sortTable[0x917E]=20926;   // shai
   sortTable[0x95B7]=20927;   // shai
   sortTable[0x7C01]=20928;   // shai
   sortTable[0x7C1B]=20929;   // shai
   sortTable[0x7E7A]=20930;   // shai
   sortTable[0x91C3]=20931;   // shai
   sortTable[0x66EC]=20932;   // shai
   sortTable[0x5C71]=20933;   // shan
   sortTable[0x95EA]=20934;   // shan
   sortTable[0x9583]=20935;   // shan
   sortTable[0x5584]=20936;   // shan
   sortTable[0x886B]=20937;   // shan
   sortTable[0x6247]=20938;   // shan
   sortTable[0x6749]=20939;   // shan
   sortTable[0x73CA]=20940;   // shan
   sortTable[0x9655]=20941;   // shan
   sortTable[0x64C5]=20942;   // shan
   sortTable[0x5220]=20943;   // shan
   sortTable[0x81B3]=20944;   // shan
   sortTable[0x8D61]=20945;   // shan
   sortTable[0x7F2E]=20946;   // shan
   sortTable[0x717D]=20947;   // shan
   sortTable[0x8BAA]=20948;   // shan
   sortTable[0x87EE]=20949;   // shan
   sortTable[0x6C55]=20950;   // shan
   sortTable[0x8DDA]=20951;   // shan
   sortTable[0x82EB]=20952;   // shan
   sortTable[0x912F]=20953;   // shan
   sortTable[0x5B17]=20954;   // shan
   sortTable[0x829F]=20955;   // shan
   sortTable[0x59D7]=20956;   // shan
   sortTable[0x5261]=20957;   // shan
   sortTable[0x9490]=20958;   // shan
   sortTable[0x6F78]=20959;   // shan
   sortTable[0x9CDD]=20960;   // shan
   sortTable[0x81BB]=20961;   // shan
   sortTable[0x8222]=20962;   // shan
   sortTable[0x759D]=20963;   // shan
   sortTable[0x994D]=20964;   // shan
   sortTable[0x57CF]=20965;   // shan
   sortTable[0x5F61]=20966;   // shan
   sortTable[0x7752]=20967;   // shan
   sortTable[0x9A9F]=20968;   // shan
   sortTable[0x7E3F]=20969;   // shan
   sortTable[0x7FB6]=20970;   // shan
   sortTable[0x91E4]=20971;   // shan
   sortTable[0x9C53]=20972;   // shan
   sortTable[0x87FA]=20973;   // shan
   sortTable[0x8120]=20974;   // shan
   sortTable[0x8A15]=20975;   // shan
   sortTable[0x7FB4]=20976;   // shan
   sortTable[0x8D78]=20977;   // shan
   sortTable[0x965D]=20978;   // shan
   sortTable[0x9BC5]=20979;   // shan
   sortTable[0x7E55]=20980;   // shan
   sortTable[0x8ED5]=20981;   // shan
   sortTable[0x9425]=20982;   // shan
   sortTable[0x78F0]=20983;   // shan
   sortTable[0x8D0D]=20984;   // shan
   sortTable[0x928F]=20985;   // shan
   sortTable[0x5093]=20986;   // shan
   sortTable[0x50D0]=20987;   // shan
   sortTable[0x522A]=20988;   // shan
   sortTable[0x527C]=20989;   // shan
   sortTable[0x5607]=20990;   // shan
   sortTable[0x5738]=20991;   // shan
   sortTable[0x58A0]=20992;   // shan
   sortTable[0x58A1]=20993;   // shan
   sortTable[0x59CD]=20994;   // shan
   sortTable[0x5E53]=20995;   // shan
   sortTable[0x633B]=20996;   // shan
   sortTable[0x639E]=20997;   // shan
   sortTable[0x6427]=20998;   // shan
   sortTable[0x657E]=20999;   // shan
   sortTable[0x6671]=21000;   // shan
   sortTable[0x6763]=21001;   // shan
   sortTable[0x67F5]=21002;   // shan
   sortTable[0x6A3F]=21003;   // shan
   sortTable[0x6A86]=21004;   // shan
   sortTable[0x6B5A]=21005;   // shan
   sortTable[0x6F6C]=21006;   // shan
   sortTable[0x6F98]=21007;   // shan
   sortTable[0x7057]=21008;   // shan
   sortTable[0x7154]=21009;   // shan
   sortTable[0x718C]=21010;   // shan
   sortTable[0x72E6]=21011;   // shan
   sortTable[0x75C1]=21012;   // shan
   sortTable[0x7B18]=21013;   // shan
   sortTable[0x89A2]=21014;   // shan
   sortTable[0x8B06]=21015;   // shan
   sortTable[0x8B71]=21016;   // shan
   sortTable[0x9096]=21017;   // shan
   sortTable[0x958A]=21018;   // shan
   sortTable[0x9A38]=21019;   // shan
   sortTable[0x9C54]=21020;   // shan
   sortTable[0x9FC3]=21021;   // shan
   sortTable[0x4E0A]=21022;   // shang
   sortTable[0x5546]=21023;   // shang
   sortTable[0x4F24]=21024;   // shang
   sortTable[0x50B7]=21025;   // shang
   sortTable[0x5C1A]=21026;   // shang
   sortTable[0x8D4F]=21027;   // shang
   sortTable[0x8CDE]=21028;   // shang
   sortTable[0x88F3]=21029;   // shang
   sortTable[0x664C]=21030;   // shang
   sortTable[0x89DE]=21031;   // shang
   sortTable[0x5892]=21032;   // shang
   sortTable[0x7EF1]=21033;   // shang
   sortTable[0x6B87]=21034;   // shang
   sortTable[0x71B5]=21035;   // shang
   sortTable[0x57A7]=21036;   // shang
   sortTable[0x9B3A]=21037;   // shang
   sortTable[0x8B2A]=21038;   // shang
   sortTable[0x850F]=21039;   // shang
   sortTable[0x979D]=21040;   // shang
   sortTable[0x87AA]=21041;   // shang
   sortTable[0x4E04]=21042;   // shang
   sortTable[0x4EE9]=21043;   // shang
   sortTable[0x5C19]=21044;   // shang
   sortTable[0x6066]=21045;   // shang
   sortTable[0x616F]=21046;   // shang
   sortTable[0x6244]=21047;   // shang
   sortTable[0x6BA4]=21048;   // shang
   sortTable[0x6EF3]=21049;   // shang
   sortTable[0x6F21]=21050;   // shang
   sortTable[0x7DD4]=21051;   // shang
   sortTable[0x89F4]=21052;   // shang
   sortTable[0x8D18]=21053;   // shang
   sortTable[0x945C]=21054;   // shang
   sortTable[0x5C11]=21055;   // shao
   sortTable[0x70E7]=21056;   // shao
   sortTable[0x71D2]=21057;   // shao
   sortTable[0x7ECD]=21058;   // shao
   sortTable[0x7D39]=21059;   // shao
   sortTable[0x7A0D]=21060;   // shao
   sortTable[0x54E8]=21061;   // shao
   sortTable[0x68A2]=21062;   // shao
   sortTable[0x634E]=21063;   // shao
   sortTable[0x90B5]=21064;   // shao
   sortTable[0x97F6]=21065;   // shao
   sortTable[0x828D]=21066;   // shao
   sortTable[0x52FA]=21067;   // shao
   sortTable[0x52AD]=21068;   // shao
   sortTable[0x8244]=21069;   // shao
   sortTable[0x82D5]=21070;   // shao
   sortTable[0x7B72]=21071;   // shao
   sortTable[0x86F8]=21072;   // shao
   sortTable[0x8891]=21073;   // shao
   sortTable[0x6F72]=21074;   // shao
   sortTable[0x7744]=21075;   // shao
   sortTable[0x83A6]=21076;   // shao
   sortTable[0x9AFE]=21077;   // shao
   sortTable[0x9BB9]=21078;   // shao
   sortTable[0x98B5]=21079;   // shao
   sortTable[0x5372]=21080;   // shao
   sortTable[0x5A0B]=21081;   // shao
   sortTable[0x5F30]=21082;   // shao
   sortTable[0x65D3]=21083;   // shao
   sortTable[0x67D6]=21084;   // shao
   sortTable[0x713C]=21085;   // shao
   sortTable[0x73BF]=21086;   // shao
   sortTable[0x7AF0]=21087;   // shao
   sortTable[0x7DA4]=21088;   // shao
   sortTable[0x8571]=21089;   // shao
   sortTable[0x8F0E]=21090;   // shao
   sortTable[0x793E]=21091;   // she
   sortTable[0x8BBE]=21092;   // she
   sortTable[0x8A2D]=21093;   // she
   sortTable[0x5C04]=21094;   // she
   sortTable[0x6444]=21095;   // she
   sortTable[0x651D]=21096;   // she
   sortTable[0x86C7]=21097;   // she
   sortTable[0x820D]=21098;   // she
   sortTable[0x820C]=21099;   // she
   sortTable[0x6D89]=21100;   // she
   sortTable[0x8D66]=21101;   // she
   sortTable[0x5962]=21102;   // she
   sortTable[0x6151]=21103;   // she
   sortTable[0x9E9D]=21104;   // she
   sortTable[0x6B59]=21105;   // she
   sortTable[0x8D4A]=21106;   // she
   sortTable[0x7572]=21107;   // she
   sortTable[0x538D]=21108;   // she
   sortTable[0x4F58]=21109;   // she
   sortTable[0x6EE0]=21110;   // she
   sortTable[0x731E]=21111;   // she
   sortTable[0x8675]=21112;   // she
   sortTable[0x850E]=21113;   // she
   sortTable[0x97D8]=21114;   // she
   sortTable[0x8F0B]=21115;   // she
   sortTable[0x86E5]=21116;   // she
   sortTable[0x8802]=21117;   // she
   sortTable[0x9A07]=21118;   // she
   sortTable[0x820E]=21119;   // she
   sortTable[0x5399]=21120;   // she
   sortTable[0x5F3D]=21121;   // she
   sortTable[0x6174]=21122;   // she
   sortTable[0x61FE]=21123;   // she
   sortTable[0x6368]=21124;   // she
   sortTable[0x6442]=21125;   // she
   sortTable[0x6475]=21126;   // she
   sortTable[0x6AA8]=21127;   // she
   sortTable[0x6B07]=21128;   // she
   sortTable[0x6DBB]=21129;   // she
   sortTable[0x6E09]=21130;   // she
   sortTable[0x7044]=21131;   // she
   sortTable[0x756C]=21132;   // she
   sortTable[0x8CD2]=21133;   // she
   sortTable[0x8CD6]=21134;   // she
   sortTable[0x4EC0]=21135;   // shen
   sortTable[0x751A]=21136;   // shen
   sortTable[0x8EAB]=21137;   // shen
   sortTable[0x795E]=21138;   // shen
   sortTable[0x6DF1]=21139;   // shen
   sortTable[0x4F38]=21140;   // shen
   sortTable[0x5A76]=21141;   // shen
   sortTable[0x5B38]=21142;   // shen
   sortTable[0x5BA1]=21143;   // shen
   sortTable[0x5BE9]=21144;   // shen
   sortTable[0x614E]=21145;   // shen
   sortTable[0x6E17]=21146;   // shen
   sortTable[0x6EF2]=21147;   // shen
   sortTable[0x7533]=21148;   // shen
   sortTable[0x7EC5]=21149;   // shen
   sortTable[0x7D33]=21150;   // shen
   sortTable[0x547B]=21151;   // shen
   sortTable[0x6C88]=21152;   // shen
   sortTable[0x80BE]=21153;   // shen
   sortTable[0x8BDC]=21154;   // shen
   sortTable[0x8398]=21155;   // shen
   sortTable[0x8703]=21156;   // shen
   sortTable[0x5A20]=21157;   // shen
   sortTable[0x54C2]=21158;   // shen
   sortTable[0x6E16]=21159;   // shen
   sortTable[0x80C2]=21160;   // shen
   sortTable[0x7837]=21161;   // shen
   sortTable[0x8C02]=21162;   // shen
   sortTable[0x77E7]=21163;   // shen
   sortTable[0x814E]=21164;   // shen
   sortTable[0x6939]=21165;   // shen
   sortTable[0x8124]=21166;   // shen
   sortTable[0x8460]=21167;   // shen
   sortTable[0x77AB]=21168;   // shen
   sortTable[0x8A75]=21169;   // shen
   sortTable[0x9B6B]=21170;   // shen
   sortTable[0x8C09]=21171;   // shen
   sortTable[0x90A5]=21172;   // shen
   sortTable[0x99EA]=21173;   // shen
   sortTable[0x8704]=21174;   // shen
   sortTable[0x9CB9]=21175;   // shen
   sortTable[0x9C30]=21176;   // shen
   sortTable[0x84E1]=21177;   // shen
   sortTable[0x8518]=21178;   // shen
   sortTable[0x8AD7]=21179;   // shen
   sortTable[0x92E0]=21180;   // shen
   sortTable[0x77E4]=21181;   // shen
   sortTable[0x7973]=21182;   // shen
   sortTable[0x7A7C]=21183;   // shen
   sortTable[0x9BF5]=21184;   // shen
   sortTable[0x7712]=21185;   // shen
   sortTable[0x7718]=21186;   // shen
   sortTable[0x7C76]=21187;   // shen
   sortTable[0x88D1]=21188;   // shen
   sortTable[0x9823]=21189;   // shen
   sortTable[0x9C3A]=21190;   // shen
   sortTable[0x4F81]=21191;   // shen
   sortTable[0x4FBA]=21192;   // shen
   sortTable[0x515F]=21193;   // shen
   sortTable[0x5814]=21194;   // shen
   sortTable[0x59BD]=21195;   // shen
   sortTable[0x59FA]=21196;   // shen
   sortTable[0x5BB7]=21197;   // shen
   sortTable[0x5C7E]=21198;   // shen
   sortTable[0x5CF7]=21199;   // shen
   sortTable[0x5F1E]=21200;   // shen
   sortTable[0x613C]=21201;   // shen
   sortTable[0x625F]=21202;   // shen
   sortTable[0x6552]=21203;   // shen
   sortTable[0x661A]=21204;   // shen
   sortTable[0x66CB]=21205;   // shen
   sortTable[0x66D1]=21206;   // shen
   sortTable[0x67DB]=21207;   // shen
   sortTable[0x68FD]=21208;   // shen
   sortTable[0x698A]=21209;   // shen
   sortTable[0x6C20]=21210;   // shen
   sortTable[0x6D81]=21211;   // shen
   sortTable[0x700B]=21212;   // shen
   sortTable[0x71CA]=21213;   // shen
   sortTable[0x73C5]=21214;   // shen
   sortTable[0x7521]=21215;   // shen
   sortTable[0x7527]=21216;   // shen
   sortTable[0x7606]=21217;   // shen
   sortTable[0x762E]=21218;   // shen
   sortTable[0x7C78]=21219;   // shen
   sortTable[0x7F67]=21220;   // shen
   sortTable[0x8593]=21221;   // shen
   sortTable[0x89BE]=21222;   // shen
   sortTable[0x8A20]=21223;   // shen
   sortTable[0x8A37]=21224;   // shen
   sortTable[0x8B85]=21225;   // shen
   sortTable[0x9825]=21226;   // shen
   sortTable[0x9D62]=21227;   // shen
   sortTable[0x751F]=21228;   // sheng
   sortTable[0x58F0]=21229;   // sheng
   sortTable[0x8072]=21230;   // sheng
   sortTable[0x80DC]=21231;   // sheng
   sortTable[0x52DD]=21232;   // sheng
   sortTable[0x7701]=21233;   // sheng
   sortTable[0x5269]=21234;   // sheng
   sortTable[0x5347]=21235;   // sheng
   sortTable[0x7272]=21236;   // sheng
   sortTable[0x7EF3]=21237;   // sheng
   sortTable[0x7E69]=21238;   // sheng
   sortTable[0x76DB]=21239;   // sheng
   sortTable[0x5723]=21240;   // sheng
   sortTable[0x8056]=21241;   // sheng
   sortTable[0x7525]=21242;   // sheng
   sortTable[0x7B19]=21243;   // sheng
   sortTable[0x5D4A]=21244;   // sheng
   sortTable[0x771A]=21245;   // sheng
   sortTable[0x8CF8]=21246;   // sheng
   sortTable[0x82FC]=21247;   // sheng
   sortTable[0x965E]=21248;   // sheng
   sortTable[0x9F2A]=21249;   // sheng
   sortTable[0x8542]=21250;   // sheng
   sortTable[0x8B5D]=21251;   // sheng
   sortTable[0x8CB9]=21252;   // sheng
   sortTable[0x5057]=21253;   // sheng
   sortTable[0x5270]=21254;   // sheng
   sortTable[0x544F]=21255;   // sheng
   sortTable[0x58AD]=21256;   // sheng
   sortTable[0x61B4]=21257;   // sheng
   sortTable[0x6598]=21258;   // sheng
   sortTable[0x6607]=21259;   // sheng
   sortTable[0x6660]=21260;   // sheng
   sortTable[0x66FB]=21261;   // sheng
   sortTable[0x680D]=21262;   // sheng
   sortTable[0x69BA]=21263;   // sheng
   sortTable[0x6A73]=21264;   // sheng
   sortTable[0x6B85]=21265;   // sheng
   sortTable[0x6CE9]=21266;   // sheng
   sortTable[0x6E3B]=21267;   // sheng
   sortTable[0x6E66]=21268;   // sheng
   sortTable[0x713A]=21269;   // sheng
   sortTable[0x72CC]=21270;   // sheng
   sortTable[0x73C4]=21271;   // sheng
   sortTable[0x741E]=21272;   // sheng
   sortTable[0x7AD4]=21273;   // sheng
   sortTable[0x924E]=21274;   // sheng
   sortTable[0x9629]=21275;   // sheng
   sortTable[0x9679]=21276;   // sheng
   sortTable[0x9D7F]=21277;   // sheng
   sortTable[0x662F]=21278;   // shi
   sortTable[0x65F6]=21279;   // shi
   sortTable[0x6642]=21280;   // shi
   sortTable[0x5341]=21281;   // shi
   sortTable[0x4E8B]=21282;   // shi
   sortTable[0x5B9E]=21283;   // shi
   sortTable[0x5BE6]=21284;   // shi
   sortTable[0x4F7F]=21285;   // shi
   sortTable[0x4E16]=21286;   // shi
   sortTable[0x5E08]=21287;   // shi
   sortTable[0x5E2B]=21288;   // shi
   sortTable[0x77F3]=21289;   // shi
   sortTable[0x8BC6]=21290;   // shi
   sortTable[0x8B58]=21291;   // shi
   sortTable[0x53F2]=21292;   // shi
   sortTable[0x5E02]=21293;   // shi
   sortTable[0x59CB]=21294;   // shi
   sortTable[0x4F3C]=21295;   // shi
   sortTable[0x5F0F]=21296;   // shi
   sortTable[0x5931]=21297;   // shi
   sortTable[0x58EB]=21298;   // shi
   sortTable[0x793A]=21299;   // shi
   sortTable[0x52BF]=21300;   // shi
   sortTable[0x52E2]=21301;   // shi
   sortTable[0x5BA4]=21302;   // shi
   sortTable[0x89C6]=21303;   // shi
   sortTable[0x8996]=21304;   // shi
   sortTable[0x8BD5]=21305;   // shi
   sortTable[0x8A66]=21306;   // shi
   sortTable[0x9002]=21307;   // shi
   sortTable[0x9069]=21308;   // shi
   sortTable[0x98DF]=21309;   // shi
   sortTable[0x65BD]=21310;   // shi
   sortTable[0x6E7F]=21311;   // shi
   sortTable[0x6FD5]=21312;   // shi
   sortTable[0x8BD7]=21313;   // shi
   sortTable[0x8A69]=21314;   // shi
   sortTable[0x91CA]=21315;   // shi
   sortTable[0x9A76]=21316;   // shi
   sortTable[0x91CB]=21317;   // shi
   sortTable[0x99DB]=21318;   // shi
   sortTable[0x8680]=21319;   // shi
   sortTable[0x8755]=21320;   // shi
   sortTable[0x62FE]=21321;   // shi
   sortTable[0x6C0F]=21322;   // shi
   sortTable[0x9970]=21323;   // shi
   sortTable[0x98FE]=21324;   // shi
   sortTable[0x901D]=21325;   // shi
   sortTable[0x8A93]=21326;   // shi
   sortTable[0x72EE]=21327;   // shi
   sortTable[0x7345]=21328;   // shi
   sortTable[0x4F8D]=21329;   // shi
   sortTable[0x5C38]=21330;   // shi
   sortTable[0x5C4E]=21331;   // shi
   sortTable[0x5319]=21332;   // shi
   sortTable[0x62ED]=21333;   // shi
   sortTable[0x8C25]=21334;   // shi
   sortTable[0x4ED5]=21335;   // shi
   sortTable[0x77E2]=21336;   // shi
   sortTable[0x6043]=21337;   // shi
   sortTable[0x55DC]=21338;   // shi
   sortTable[0x8F7C]=21339;   // shi
   sortTable[0x566C]=21340;   // shi
   sortTable[0x5F11]=21341;   // shi
   sortTable[0x8C55]=21342;   // shi
   sortTable[0x67FF]=21343;   // shi
   sortTable[0x7B6E]=21344;   // shi
   sortTable[0x8210]=21345;   // shi
   sortTable[0x8671]=21346;   // shi
   sortTable[0x794F]=21347;   // shi
   sortTable[0x8AE1]=21348;   // shi
   sortTable[0x87AB]=21349;   // shi
   sortTable[0x84CD]=21350;   // shi
   sortTable[0x70BB]=21351;   // shi
   sortTable[0x8D33]=21352;   // shi
   sortTable[0x7D41]=21353;   // shi
   sortTable[0x83B3]=21354;   // shi
   sortTable[0x8C49]=21355;   // shi
   sortTable[0x9CA5]=21356;   // shi
   sortTable[0x94C8]=21357;   // shi
   sortTable[0x8937]=21358;   // shi
   sortTable[0x57D8]=21359;   // shi
   sortTable[0x7757]=21360;   // shi
   sortTable[0x8492]=21361;   // shi
   sortTable[0x8ADF]=21362;   // shi
   sortTable[0x9E24]=21363;   // shi
   sortTable[0x90BF]=21364;   // shi
   sortTable[0x9F2B]=21365;   // shi
   sortTable[0x770E]=21366;   // shi
   sortTable[0x7721]=21367;   // shi
   sortTable[0x7C2D]=21368;   // shi
   sortTable[0x8FBB]=21369;   // shi
   sortTable[0x8479]=21370;   // shi
   sortTable[0x9048]=21371;   // shi
   sortTable[0x9CF2]=21372;   // shi
   sortTable[0x7702]=21373;   // shi
   sortTable[0x7C42]=21374;   // shi
   sortTable[0x9CBA]=21375;   // shi
   sortTable[0x9243]=21376;   // shi
   sortTable[0x9C24]=21377;   // shi
   sortTable[0x9366]=21378;   // shi
   sortTable[0x896B]=21379;   // shi
   sortTable[0x9242]=21380;   // shi
   sortTable[0x9250]=21381;   // shi
   sortTable[0x927D]=21382;   // shi
   sortTable[0x9C23]=21383;   // shi
   sortTable[0x9CFE]=21384;   // shi
   sortTable[0x9230]=21385;   // shi
   sortTable[0x9DB3]=21386;   // shi
   sortTable[0x8213]=21387;   // shi
   sortTable[0x8768]=21388;   // shi
   sortTable[0x8B1A]=21389;   // shi
   sortTable[0x8CB0]=21390;   // shi
   sortTable[0x907E]=21391;   // shi
   sortTable[0x921F]=21392;   // shi
   sortTable[0x991D]=21393;   // shi
   sortTable[0x9F2D]=21394;   // shi
   sortTable[0x4E17]=21395;   // shi
   sortTable[0x4E68]=21396;   // shi
   sortTable[0x4E6D]=21397;   // shi
   sortTable[0x4E8A]=21398;   // shi
   sortTable[0x4F66]=21399;   // shi
   sortTable[0x5158]=21400;   // shi
   sortTable[0x519F]=21401;   // shi
   sortTable[0x534B]=21402;   // shi
   sortTable[0x53D3]=21403;   // shi
   sortTable[0x545E]=21404;   // shi
   sortTable[0x5469]=21405;   // shi
   sortTable[0x5852]=21406;   // shi
   sortTable[0x596D]=21407;   // shi
   sortTable[0x59FC]=21408;   // shi
   sortTable[0x5A9E]=21409;   // shi
   sortTable[0x5B15]=21410;   // shi
   sortTable[0x5B9F]=21411;   // shi
   sortTable[0x5BA9]=21412;   // shi
   sortTable[0x5BD4]=21413;   // shi
   sortTable[0x5C4D]=21414;   // shi
   sortTable[0x5CD5]=21415;   // shi
   sortTable[0x5D3C]=21416;   // shi
   sortTable[0x5D75]=21417;   // shi
   sortTable[0x5F12]=21418;   // shi
   sortTable[0x5FA5]=21419;   // shi
   sortTable[0x5FD5]=21420;   // shi
   sortTable[0x6040]=21421;   // shi
   sortTable[0x623A]=21422;   // shi
   sortTable[0x63D3]=21423;   // shi
   sortTable[0x65F9]=21424;   // shi
   sortTable[0x6630]=21425;   // shi
   sortTable[0x67BE]=21426;   // shi
   sortTable[0x67F9]=21427;   // shi
   sortTable[0x683B]=21428;   // shi
   sortTable[0x6981]=21429;   // shi
   sortTable[0x69AF]=21430;   // shi
   sortTable[0x6D49]=21431;   // shi
   sortTable[0x6E5C]=21432;   // shi
   sortTable[0x6E64]=21433;   // shi
   sortTable[0x6EA1]=21434;   // shi
   sortTable[0x6EAE]=21435;   // shi
   sortTable[0x6EBC]=21436;   // shi
   sortTable[0x6FA8]=21437;   // shi
   sortTable[0x70D2]=21438;   // shi
   sortTable[0x7176]=21439;   // shi
   sortTable[0x7461]=21440;   // shi
   sortTable[0x793B]=21441;   // shi
   sortTable[0x7ACD]=21442;   // shi
   sortTable[0x7B36]=21443;   // shi
   sortTable[0x7BD2]=21444;   // shi
   sortTable[0x8494]=21445;   // shi
   sortTable[0x8979]=21446;   // shi
   sortTable[0x89E2]=21447;   // shi
   sortTable[0x8EFE]=21448;   // shi
   sortTable[0x91C8]=21449;   // shi
   sortTable[0x91F6]=21450;   // shi
   sortTable[0x9247]=21451;   // shi
   sortTable[0x9248]=21452;   // shi
   sortTable[0x92B4]=21453;   // shi
   sortTable[0x98E0]=21454;   // shi
   sortTable[0x9919]=21455;   // shi
   sortTable[0x9963]=21456;   // shi
   sortTable[0x9B96]=21457;   // shi
   sortTable[0x9BF4]=21458;   // shi
   sortTable[0x9C18]=21459;   // shi
   sortTable[0x5159]=21460;   // shig
   sortTable[0x624B]=21461;   // shou
   sortTable[0x53D7]=21462;   // shou
   sortTable[0x6536]=21463;   // shou
   sortTable[0x9996]=21464;   // shou
   sortTable[0x5B88]=21465;   // shou
   sortTable[0x6388]=21466;   // shou
   sortTable[0x7626]=21467;   // shou
   sortTable[0x552E]=21468;   // shou
   sortTable[0x517D]=21469;   // shou
   sortTable[0x7378]=21470;   // shou
   sortTable[0x5BFF]=21471;   // shou
   sortTable[0x58FD]=21472;   // shou
   sortTable[0x7EF6]=21473;   // shou
   sortTable[0x72E9]=21474;   // shou
   sortTable[0x824F]=21475;   // shou
   sortTable[0x93C9]=21476;   // shou
   sortTable[0x53CE]=21477;   // shou
   sortTable[0x57A8]=21478;   // shou
   sortTable[0x5900]=21479;   // shou
   sortTable[0x624C]=21480;   // shou
   sortTable[0x6DAD]=21481;   // shou
   sortTable[0x7363]=21482;   // shou
   sortTable[0x75E9]=21483;   // shou
   sortTable[0x7DAC]=21484;   // shou
   sortTable[0x4E66]=21485;   // shu
   sortTable[0x66F8]=21486;   // shu
   sortTable[0x6570]=21487;   // shu
   sortTable[0x6578]=21488;   // shu
   sortTable[0x672F]=21489;   // shu
   sortTable[0x672E]=21490;   // shu
   sortTable[0x6811]=21491;   // shu
   sortTable[0x6A39]=21492;   // shu
   sortTable[0x719F]=21493;   // shu
   sortTable[0x5C5E]=21494;   // shu
   sortTable[0x5C6C]=21495;   // shu
   sortTable[0x8F93]=21496;   // shu
   sortTable[0x675F]=21497;   // shu
   sortTable[0x8F38]=21498;   // shu
   sortTable[0x53D4]=21499;   // shu
   sortTable[0x8212]=21500;   // shu
   sortTable[0x8FF0]=21501;   // shu
   sortTable[0x6B8A]=21502;   // shu
   sortTable[0x9F20]=21503;   // shu
   sortTable[0x852C]=21504;   // shu
   sortTable[0x7AD6]=21505;   // shu
   sortTable[0x68B3]=21506;   // shu
   sortTable[0x8C4E]=21507;   // shu
   sortTable[0x7F72]=21508;   // shu
   sortTable[0x758F]=21509;   // shu
   sortTable[0x67A2]=21510;   // shu
   sortTable[0x6A1E]=21511;   // shu
   sortTable[0x6691]=21512;   // shu
   sortTable[0x85AF]=21513;   // shu
   sortTable[0x5EB6]=21514;   // shu
   sortTable[0x8700]=21515;   // shu
   sortTable[0x6055]=21516;   // shu
   sortTable[0x620D]=21517;   // shu
   sortTable[0x6DD1]=21518;   // shu
   sortTable[0x8D4E]=21519;   // shu
   sortTable[0x5B70]=21520;   // shu
   sortTable[0x7EBE]=21521;   // shu
   sortTable[0x500F]=21522;   // shu
   sortTable[0x5885]=21523;   // shu
   sortTable[0x6292]=21524;   // shu
   sortTable[0x6F31]=21525;   // shu
   sortTable[0x66D9]=21526;   // shu
   sortTable[0x587E]=21527;   // shu
   sortTable[0x9ECD]=21528;   // shu
   sortTable[0x83FD]=21529;   // shu
   sortTable[0x6F8D]=21530;   // shu
   sortTable[0x59DD]=21531;   // shu
   sortTable[0x6BB3]=21532;   // shu
   sortTable[0x6445]=21533;   // shu
   sortTable[0x79EB]=21534;   // shu
   sortTable[0x6CAD]=21535;   // shu
   sortTable[0x8853]=21536;   // shu
   sortTable[0x8167]=21537;   // shu
   sortTable[0x9103]=21538;   // shu
   sortTable[0x9683]=21539;   // shu
   sortTable[0x6BF9]=21540;   // shu
   sortTable[0x7D80]=21541;   // shu
   sortTable[0x88CB]=21542;   // shu
   sortTable[0x8481]=21543;   // shu
   sortTable[0x9265]=21544;   // shu
   sortTable[0x85F7]=21545;   // shu
   sortTable[0x9D90]=21546;   // shu
   sortTable[0x9483]=21547;   // shu
   sortTable[0x8961]=21548;   // shu
   sortTable[0x7D13]=21549;   // shu
   sortTable[0x93E3]=21550;   // shu
   sortTable[0x85A5]=21551;   // shu
   sortTable[0x8DFE]=21552;   // shu
   sortTable[0x9D68]=21553;   // shu
   sortTable[0x9F21]=21554;   // shu
   sortTable[0x4FB8]=21555;   // shu
   sortTable[0x5010]=21556;   // shu
   sortTable[0x5135]=21557;   // shu
   sortTable[0x51C1]=21558;   // shu
   sortTable[0x54B0]=21559;   // shu
   sortTable[0x5A4C]=21560;   // shu
   sortTable[0x5C0C]=21561;   // shu
   sortTable[0x5C17]=21562;   // shu
   sortTable[0x5EBB]=21563;   // shu
   sortTable[0x6037]=21564;   // shu
   sortTable[0x6352]=21565;   // shu
   sortTable[0x6393]=21566;   // shu
   sortTable[0x6504]=21567;   // shu
   sortTable[0x668F]=21568;   // shu
   sortTable[0x6778]=21569;   // shu
   sortTable[0x6A7E]=21570;   // shu
   sortTable[0x6F44]=21571;   // shu
   sortTable[0x6F7B]=21572;   // shu
   sortTable[0x6FD6]=21573;   // shu
   sortTable[0x702D]=21574;   // shu
   sortTable[0x7102]=21575;   // shu
   sortTable[0x7479]=21576;   // shu
   sortTable[0x74B9]=21577;   // shu
   sortTable[0x758E]=21578;   // shu
   sortTable[0x7659]=21579;   // shu
   sortTable[0x7AEA]=21580;   // shu
   sortTable[0x7CEC]=21581;   // shu
   sortTable[0x7D49]=21582;   // shu
   sortTable[0x8357]=21583;   // shu
   sortTable[0x866A]=21584;   // shu
   sortTable[0x8834]=21585;   // shu
   sortTable[0x8969]=21586;   // shu
   sortTable[0x8D16]=21587;   // shu
   sortTable[0x8E08]=21588;   // shu
   sortTable[0x8ED7]=21589;   // shu
   sortTable[0x9330]=21590;   // shu
   sortTable[0x964E]=21591;   // shu
   sortTable[0x9B9B]=21592;   // shu
   sortTable[0x9C6A]=21593;   // shu
   sortTable[0x9C70]=21594;   // shu
   sortTable[0x5237]=21595;   // shua
   sortTable[0x5530]=21596;   // shua
   sortTable[0x800D]=21597;   // shua
   sortTable[0x8A9C]=21598;   // shua
   sortTable[0x6454]=21599;   // shuai
   sortTable[0x7529]=21600;   // shuai
   sortTable[0x87C0]=21601;   // shuai
   sortTable[0x8870]=21602;   // shuai
   sortTable[0x5E05]=21603;   // shuai
   sortTable[0x5E25]=21604;   // shuai
   sortTable[0x535B]=21605;   // shuai
   sortTable[0x62F4]=21606;   // shuan
   sortTable[0x6813]=21607;   // shuan
   sortTable[0x95E9]=21608;   // shuan
   sortTable[0x6DAE]=21609;   // shuan
   sortTable[0x8168]=21610;   // shuan
   sortTable[0x9582]=21611;   // shuan
   sortTable[0x53CC]=21612;   // shuang
   sortTable[0x96D9]=21613;   // shuang
   sortTable[0x971C]=21614;   // shuang
   sortTable[0x723D]=21615;   // shuang
   sortTable[0x5B40]=21616;   // shuang
   sortTable[0x9E74]=21617;   // shuang
   sortTable[0x9A3B]=21618;   // shuang
   sortTable[0x9AA6]=21619;   // shuang
   sortTable[0x9DDE]=21620;   // shuang
   sortTable[0x7935]=21621;   // shuang
   sortTable[0x826D]=21622;   // shuang
   sortTable[0x9A66]=21623;   // shuang
   sortTable[0x9E18]=21624;   // shuang
   sortTable[0x587D]=21625;   // shuang
   sortTable[0x5B47]=21626;   // shuang
   sortTable[0x6161]=21627;   // shuang
   sortTable[0x6A09]=21628;   // shuang
   sortTable[0x6B06]=21629;   // shuang
   sortTable[0x6F3A]=21630;   // shuang
   sortTable[0x7040]=21631;   // shuang
   sortTable[0x7E14]=21632;   // shuang
   sortTable[0x93EF]=21633;   // shuang
   sortTable[0x6C34]=21634;   // shui
   sortTable[0x8C01]=21635;   // shui
   sortTable[0x8AB0]=21636;   // shui
   sortTable[0x7761]=21637;   // shui
   sortTable[0x7A0E]=21638;   // shui
   sortTable[0x7A05]=21639;   // shui
   sortTable[0x813D]=21640;   // shui
   sortTable[0x7793]=21641;   // shui
   sortTable[0x88DE]=21642;   // shui
   sortTable[0x7971]=21643;   // shui
   sortTable[0x9596]=21644;   // shui
   sortTable[0x5E28]=21645;   // shui
   sortTable[0x6C35]=21646;   // shui
   sortTable[0x6C3A]=21647;   // shui
   sortTable[0x6D97]=21648;   // shui
   sortTable[0x6D9A]=21649;   // shui
   sortTable[0x987A]=21650;   // shun
   sortTable[0x9806]=21651;   // shun
   sortTable[0x821C]=21652;   // shun
   sortTable[0x77AC]=21653;   // shun
   sortTable[0x542E]=21654;   // shun
   sortTable[0x8563]=21655;   // shun
   sortTable[0x779A]=21656;   // shun
   sortTable[0x9B0A]=21657;   // shun
   sortTable[0x6A53]=21658;   // shun
   sortTable[0x8BF4]=21659;   // shuo
   sortTable[0x8AAA]=21660;   // shuo
   sortTable[0x70C1]=21661;   // shuo
   sortTable[0x720D]=21662;   // shuo
   sortTable[0x6714]=21663;   // shuo
   sortTable[0x7855]=21664;   // shuo
   sortTable[0x69CA]=21665;   // shuo
   sortTable[0x94C4]=21666;   // shuo
   sortTable[0x6420]=21667;   // shuo
   sortTable[0x5981]=21668;   // shuo
   sortTable[0x84B4]=21669;   // shuo
   sortTable[0x7BBE]=21670;   // shuo
   sortTable[0x77DF]=21671;   // shuo
   sortTable[0x78A9]=21672;   // shuo
   sortTable[0x8AAC]=21673;   // shuo
   sortTable[0x54FE]=21674;   // shuo
   sortTable[0x6B36]=21675;   // shuo
   sortTable[0x7361]=21676;   // shuo
   sortTable[0x9399]=21677;   // shuo
   sortTable[0x9460]=21678;   // shuo
   sortTable[0x56DB]=21679;   // si
   sortTable[0x601D]=21680;   // si
   sortTable[0x6B7B]=21681;   // si
   sortTable[0x53F8]=21682;   // si
   sortTable[0x4E1D]=21683;   // si
   sortTable[0x7D72]=21684;   // si
   sortTable[0x79C1]=21685;   // si
   sortTable[0x65AF]=21686;   // si
   sortTable[0x6495]=21687;   // si
   sortTable[0x9972]=21688;   // si
   sortTable[0x98FC]=21689;   // si
   sortTable[0x5636]=21690;   // si
   sortTable[0x5BFA]=21691;   // si
   sortTable[0x55E3]=21692;   // si
   sortTable[0x5DF3]=21693;   // si
   sortTable[0x7940]=21694;   // si
   sortTable[0x8086]=21695;   // si
   sortTable[0x53AE]=21696;   // si
   sortTable[0x6CD7]=21697;   // si
   sortTable[0x7B25]=21698;   // si
   sortTable[0x9A77]=21699;   // si
   sortTable[0x86F3]=21700;   // si
   sortTable[0x7F0C]=21701;   // si
   sortTable[0x9536]=21702;   // si
   sortTable[0x6C5C]=21703;   // si
   sortTable[0x549D]=21704;   // si
   sortTable[0x59D2]=21705;   // si
   sortTable[0x9E36]=21706;   // si
   sortTable[0x801C]=21707;   // si
   sortTable[0x5155]=21708;   // si
   sortTable[0x79A9]=21709;   // si
   sortTable[0x6F8C]=21710;   // si
   sortTable[0x9DE5]=21711;   // si
   sortTable[0x8652]=21712;   // si
   sortTable[0x98D4]=21713;   // si
   sortTable[0x7F73]=21714;   // si
   sortTable[0x7997]=21715;   // si
   sortTable[0x79A0]=21716;   // si
   sortTable[0x9236]=21717;   // si
   sortTable[0x9F36]=21718;   // si
   sortTable[0x8997]=21719;   // si
   sortTable[0x7AE2]=21720;   // si
   sortTable[0x857C]=21721;   // si
   sortTable[0x8082]=21722;   // si
   sortTable[0x8784]=21723;   // si
   sortTable[0x78C3]=21724;   // si
   sortTable[0x7DE6]=21725;   // si
   sortTable[0x8724]=21726;   // si
   sortTable[0x92AF]=21727;   // si
   sortTable[0x856C]=21728;   // si
   sortTable[0x87F4]=21729;   // si
   sortTable[0x8C84]=21730;   // si
   sortTable[0x923B]=21731;   // si
   sortTable[0x9401]=21732;   // si
   sortTable[0x98E4]=21733;   // si
   sortTable[0x99DF]=21734;   // si
   sortTable[0x4E96]=21735;   // si
   sortTable[0x4F40]=21736;   // si
   sortTable[0x4FA1]=21737;   // si
   sortTable[0x4FEC]=21738;   // si
   sortTable[0x5129]=21739;   // si
   sortTable[0x51D8]=21740;   // si
   sortTable[0x53B6]=21741;   // si
   sortTable[0x565D]=21742;   // si
   sortTable[0x5A30]=21743;   // si
   sortTable[0x5AA4]=21744;   // si
   sortTable[0x5B60]=21745;   // si
   sortTable[0x5EDD]=21746;   // si
   sortTable[0x6056]=21747;   // si
   sortTable[0x676B]=21748;   // si
   sortTable[0x67F6]=21749;   // si
   sortTable[0x6952]=21750;   // si
   sortTable[0x69B9]=21751;   // si
   sortTable[0x6CC0]=21752;   // si
   sortTable[0x6CE4]=21753;   // si
   sortTable[0x6D0D]=21754;   // si
   sortTable[0x6D98]=21755;   // si
   sortTable[0x7003]=21756;   // si
   sortTable[0x71CD]=21757;   // si
   sortTable[0x726D]=21758;   // si
   sortTable[0x7C6D]=21759;   // si
   sortTable[0x7CF9]=21760;   // si
   sortTable[0x7E9F]=21761;   // si
   sortTable[0x87D6]=21762;   // si
   sortTable[0x91F2]=21763;   // si
   sortTable[0x9270]=21764;   // si
   sortTable[0x92D6]=21765;   // si
   sortTable[0x98B8]=21766;   // si
   sortTable[0x9A26]=21767;   // si
   sortTable[0x9001]=21768;   // song
   sortTable[0x677E]=21769;   // song
   sortTable[0x8038]=21770;   // song
   sortTable[0x8073]=21771;   // song
   sortTable[0x9882]=21772;   // song
   sortTable[0x980C]=21773;   // song
   sortTable[0x8BBC]=21774;   // song
   sortTable[0x8A1F]=21775;   // song
   sortTable[0x8BF5]=21776;   // song
   sortTable[0x8AA6]=21777;   // song
   sortTable[0x5B8B]=21778;   // song
   sortTable[0x5D69]=21779;   // song
   sortTable[0x51C7]=21780;   // song
   sortTable[0x6002]=21781;   // song
   sortTable[0x609A]=21782;   // song
   sortTable[0x7AE6]=21783;   // song
   sortTable[0x6DDE]=21784;   // song
   sortTable[0x5D27]=21785;   // song
   sortTable[0x83D8]=21786;   // song
   sortTable[0x5FEA]=21787;   // song
   sortTable[0x9B06]=21788;   // song
   sortTable[0x99F7]=21789;   // song
   sortTable[0x8719]=21790;   // song
   sortTable[0x502F]=21791;   // song
   sortTable[0x50B1]=21792;   // song
   sortTable[0x5A00]=21793;   // song
   sortTable[0x5D77]=21794;   // song
   sortTable[0x5EBA]=21795;   // song
   sortTable[0x612F]=21796;   // song
   sortTable[0x616B]=21797;   // song
   sortTable[0x61BD]=21798;   // song
   sortTable[0x6780]=21799;   // song
   sortTable[0x67A9]=21800;   // song
   sortTable[0x67D7]=21801;   // song
   sortTable[0x68A5]=21802;   // song
   sortTable[0x6964]=21803;   // song
   sortTable[0x6AA7]=21804;   // song
   sortTable[0x6FCD]=21805;   // song
   sortTable[0x7879]=21806;   // song
   sortTable[0x9376]=21807;   // song
   sortTable[0x93B9]=21808;   // song
   sortTable[0x9938]=21809;   // song
   sortTable[0x641C]=21810;   // sou
   sortTable[0x55FD]=21811;   // sou
   sortTable[0x8258]=21812;   // sou
   sortTable[0x53DF]=21813;   // sou
   sortTable[0x64DE]=21814;   // sou
   sortTable[0x55D6]=21815;   // sou
   sortTable[0x85AE]=21816;   // sou
   sortTable[0x98D5]=21817;   // sou
   sortTable[0x998A]=21818;   // sou
   sortTable[0x6EB2]=21819;   // sou
   sortTable[0x55FE]=21820;   // sou
   sortTable[0x953C]=21821;   // sou
   sortTable[0x8490]=21822;   // sou
   sortTable[0x778D]=21823;   // sou
   sortTable[0x878B]=21824;   // sou
   sortTable[0x910B]=21825;   // sou
   sortTable[0x7C54]=21826;   // sou
   sortTable[0x93AA]=21827;   // sou
   sortTable[0x98BC]=21828;   // sou
   sortTable[0x8184]=21829;   // sou
   sortTable[0x84C3]=21830;   // sou
   sortTable[0x85EA]=21831;   // sou
   sortTable[0x9199]=21832;   // sou
   sortTable[0x9A2A]=21833;   // sou
   sortTable[0x5081]=21834;   // sou
   sortTable[0x53DC]=21835;   // sou
   sortTable[0x5EC0]=21836;   // sou
   sortTable[0x5ECB]=21837;   // sou
   sortTable[0x635C]=21838;   // sou
   sortTable[0x6449]=21839;   // sou
   sortTable[0x6457]=21840;   // sou
   sortTable[0x64FB]=21841;   // sou
   sortTable[0x6AE2]=21842;   // sou
   sortTable[0x7340]=21843;   // sou
   sortTable[0x7636]=21844;   // sou
   sortTable[0x98BE]=21845;   // sou
   sortTable[0x993F]=21846;   // sou
   sortTable[0x901F]=21847;   // su
   sortTable[0x8BC9]=21848;   // su
   sortTable[0x8A34]=21849;   // su
   sortTable[0x7D20]=21850;   // su
   sortTable[0x8083]=21851;   // su
   sortTable[0x8085]=21852;   // su
   sortTable[0x5851]=21853;   // su
   sortTable[0x5BBF]=21854;   // su
   sortTable[0x4FD7]=21855;   // su
   sortTable[0x82CF]=21856;   // su
   sortTable[0x8607]=21857;   // su
   sortTable[0x7C9F]=21858;   // su
   sortTable[0x7A23]=21859;   // su
   sortTable[0x9165]=21860;   // su
   sortTable[0x6EAF]=21861;   // su
   sortTable[0x5919]=21862;   // su
   sortTable[0x8C21]=21863;   // su
   sortTable[0x612B]=21864;   // su
   sortTable[0x7C0C]=21865;   // su
   sortTable[0x55C9]=21866;   // su
   sortTable[0x6D91]=21867;   // su
   sortTable[0x7AA3]=21868;   // su
   sortTable[0x9917]=21869;   // su
   sortTable[0x50F3]=21870;   // su
   sortTable[0x850C]=21871;   // su
   sortTable[0x89EB]=21872;   // su
   sortTable[0x9A95]=21873;   // su
   sortTable[0x9DEB]=21874;   // su
   sortTable[0x9E54]=21875;   // su
   sortTable[0x9C50]=21876;   // su
   sortTable[0x83A4]=21877;   // su
   sortTable[0x8E5C]=21878;   // su
   sortTable[0x9061]=21879;   // su
   sortTable[0x9A4C]=21880;   // su
   sortTable[0x7C9B]=21881;   // su
   sortTable[0x8186]=21882;   // su
   sortTable[0x85D7]=21883;   // su
   sortTable[0x8D9A]=21884;   // su
   sortTable[0x9BC2]=21885;   // su
   sortTable[0x7E24]=21886;   // su
   sortTable[0x8613]=21887;   // su
   sortTable[0x906C]=21888;   // su
   sortTable[0x5083]=21889;   // su
   sortTable[0x56CC]=21890;   // su
   sortTable[0x5850]=21891;   // su
   sortTable[0x5ACA]=21892;   // su
   sortTable[0x612C]=21893;   // su
   sortTable[0x619F]=21894;   // su
   sortTable[0x6880]=21895;   // su
   sortTable[0x69A1]=21896;   // su
   sortTable[0x6A0E]=21897;   // su
   sortTable[0x6A15]=21898;   // su
   sortTable[0x6A5A]=21899;   // su
   sortTable[0x6AEF]=21900;   // su
   sortTable[0x6B90]=21901;   // su
   sortTable[0x6CDD]=21902;   // su
   sortTable[0x6D2C]=21903;   // su
   sortTable[0x6EB8]=21904;   // su
   sortTable[0x6F5A]=21905;   // su
   sortTable[0x6F65]=21906;   // su
   sortTable[0x738A]=21907;   // su
   sortTable[0x73DF]=21908;   // su
   sortTable[0x749B]=21909;   // su
   sortTable[0x7526]=21910;   // su
   sortTable[0x78BF]=21911;   // su
   sortTable[0x7A4C]=21912;   // su
   sortTable[0x8B16]=21913;   // su
   sortTable[0x92C9]=21914;   // su
   sortTable[0x7B97]=21915;   // suan
   sortTable[0x9178]=21916;   // suan
   sortTable[0x849C]=21917;   // suan
   sortTable[0x72FB]=21918;   // suan
   sortTable[0x7B6D]=21919;   // suan
   sortTable[0x7B07]=21920;   // suan
   sortTable[0x7958]=21921;   // suan
   sortTable[0x5334]=21922;   // suan
   sortTable[0x75E0]=21923;   // suan
   sortTable[0x968F]=21924;   // sui
   sortTable[0x96A8]=21925;   // sui
   sortTable[0x867D]=21926;   // sui
   sortTable[0x96D6]=21927;   // sui
   sortTable[0x5C81]=21928;   // sui
   sortTable[0x6B72]=21929;   // sui
   sortTable[0x788E]=21930;   // sui
   sortTable[0x96A7]=21931;   // sui
   sortTable[0x7A57]=21932;   // sui
   sortTable[0x9042]=21933;   // sui
   sortTable[0x968B]=21934;   // sui
   sortTable[0x7EE5]=21935;   // sui
   sortTable[0x837D]=21936;   // sui
   sortTable[0x7762]=21937;   // sui
   sortTable[0x9AD3]=21938;   // sui
   sortTable[0x795F]=21939;   // sui
   sortTable[0x6FC9]=21940;   // sui
   sortTable[0x9083]=21941;   // sui
   sortTable[0x71E7]=21942;   // sui
   sortTable[0x8C07]=21943;   // sui
   sortTable[0x6535]=21944;   // sui
   sortTable[0x772D]=21945;   // sui
   sortTable[0x895A]=21946;   // sui
   sortTable[0x775F]=21947;   // sui
   sortTable[0x9429]=21948;   // sui
   sortTable[0x7E50]=21949;   // sui
   sortTable[0x8470]=21950;   // sui
   sortTable[0x7A5F]=21951;   // sui
   sortTable[0x79AD]=21952;   // sui
   sortTable[0x7E78]=21953;   // sui
   sortTable[0x8B62]=21954;   // sui
   sortTable[0x81B8]=21955;   // sui
   sortTable[0x9796]=21956;   // sui
   sortTable[0x7D8F]=21957;   // sui
   sortTable[0x7E40]=21958;   // sui
   sortTable[0x837E]=21959;   // sui
   sortTable[0x4E97]=21960;   // sui
   sortTable[0x5020]=21961;   // sui
   sortTable[0x54F8]=21962;   // sui
   sortTable[0x57E3]=21963;   // sui
   sortTable[0x590A]=21964;   // sui
   sortTable[0x5B18]=21965;   // sui
   sortTable[0x5D57]=21966;   // sui
   sortTable[0x65DE]=21967;   // sui
   sortTable[0x6A85]=21968;   // sui
   sortTable[0x6A96]=21969;   // sui
   sortTable[0x6B73]=21970;   // sui
   sortTable[0x6D7D]=21971;   // sui
   sortTable[0x6ED6]=21972;   // sui
   sortTable[0x6FBB]=21973;   // sui
   sortTable[0x7021]=21974;   // sui
   sortTable[0x716B]=21975;   // sui
   sortTable[0x71A3]=21976;   // sui
   sortTable[0x74B2]=21977;   // sui
   sortTable[0x74CD]=21978;   // sui
   sortTable[0x7815]=21979;   // sui
   sortTable[0x7A42]=21980;   // sui
   sortTable[0x8295]=21981;   // sui
   sortTable[0x8AB6]=21982;   // sui
   sortTable[0x8CE5]=21983;   // sui
   sortTable[0x9040]=21984;   // sui
   sortTable[0x9406]=21985;   // sui
   sortTable[0x97E2]=21986;   // sui
   sortTable[0x9AC4]=21987;   // sui
   sortTable[0x635F]=21988;   // sun
   sortTable[0x640D]=21989;   // sun
   sortTable[0x5B59]=21990;   // sun
   sortTable[0x5B6B]=21991;   // sun
   sortTable[0x7B0B]=21992;   // sun
   sortTable[0x96BC]=21993;   // sun
   sortTable[0x98E7]=21994;   // sun
   sortTable[0x836A]=21995;   // sun
   sortTable[0x69AB]=21996;   // sun
   sortTable[0x72F2]=21997;   // sun
   sortTable[0x7C28]=21998;   // sun
   sortTable[0x7BB0]=21999;   // sun
   sortTable[0x7B4D]=22000;   // sun
   sortTable[0x98F1]=22001;   // sun
   sortTable[0x8575]=22002;   // sun
   sortTable[0x9DBD]=22003;   // sun
   sortTable[0x640E]=22004;   // sun
   sortTable[0x69C2]=22005;   // sun
   sortTable[0x733B]=22006;   // sun
   sortTable[0x84C0]=22007;   // sun
   sortTable[0x859E]=22008;   // sun
   sortTable[0x93A8]=22009;   // sun
   sortTable[0x6240]=22010;   // suo
   sortTable[0x7F29]=22011;   // suo
   sortTable[0x7E2E]=22012;   // suo
   sortTable[0x7D22]=22013;   // suo
   sortTable[0x9501]=22014;   // suo
   sortTable[0x9396]=22015;   // suo
   sortTable[0x55E6]=22016;   // suo
   sortTable[0x7410]=22017;   // suo
   sortTable[0x7463]=22018;   // suo
   sortTable[0x68AD]=22019;   // suo
   sortTable[0x5A11]=22020;   // suo
   sortTable[0x5506]=22021;   // suo
   sortTable[0x55CD]=22022;   // suo
   sortTable[0x84D1]=22023;   // suo
   sortTable[0x7FA7]=22024;   // suo
   sortTable[0x7743]=22025;   // suo
   sortTable[0x5522]=22026;   // suo
   sortTable[0x686B]=22027;   // suo
   sortTable[0x93C1]=22028;   // suo
   sortTable[0x9024]=22029;   // suo
   sortTable[0x9AFF]=22030;   // suo
   sortTable[0x9BBB]=22031;   // suo
   sortTable[0x8928]=22032;   // suo
   sortTable[0x93BB]=22033;   // suo
   sortTable[0x7C11]=22034;   // suo
   sortTable[0x8736]=22035;   // suo
   sortTable[0x938D]=22036;   // suo
   sortTable[0x4E7A]=22037;   // suo
   sortTable[0x509E]=22038;   // suo
   sortTable[0x55E9]=22039;   // suo
   sortTable[0x60E2]=22040;   // suo
   sortTable[0x644D]=22041;   // suo
   sortTable[0x669B]=22042;   // suo
   sortTable[0x6E91]=22043;   // suo
   sortTable[0x6EB9]=22044;   // suo
   sortTable[0x7411]=22045;   // suo
   sortTable[0x7485]=22046;   // suo
   sortTable[0x7C14]=22047;   // suo
   sortTable[0x838F]=22048;   // suo
   sortTable[0x8D96]=22049;   // suo
   sortTable[0x9388]=22050;   // suo
   sortTable[0x4ED6]=22528;   // ta
   sortTable[0x5979]=22529;   // ta
   sortTable[0x5B83]=22530;   // ta
   sortTable[0x8E0F]=22531;   // ta
   sortTable[0x5854]=22532;   // ta
   sortTable[0x584C]=22533;   // ta
   sortTable[0x8E4B]=22534;   // ta
   sortTable[0x62D3]=22535;   // ta
   sortTable[0x69BB]=22536;   // ta
   sortTable[0x9CCE]=22537;   // ta
   sortTable[0x736D]=22538;   // ta
   sortTable[0x631E]=22539;   // ta
   sortTable[0x95FC]=22540;   // ta
   sortTable[0x8DBF]=22541;   // ta
   sortTable[0x9062]=22542;   // ta
   sortTable[0x6EBB]=22543;   // ta
   sortTable[0x94CA]=22544;   // ta
   sortTable[0x8DF6]=22545;   // ta
   sortTable[0x905D]=22546;   // ta
   sortTable[0x9314]=22547;   // ta
   sortTable[0x7942]=22548;   // ta
   sortTable[0x9C28]=22549;   // ta
   sortTable[0x8ABB]=22550;   // ta
   sortTable[0x8E79]=22551;   // ta
   sortTable[0x95D2]=22552;   // ta
   sortTable[0x891F]=22553;   // ta
   sortTable[0x979C]=22554;   // ta
   sortTable[0x79A2]=22555;   // ta
   sortTable[0x97B3]=22556;   // ta
   sortTable[0x8EA2]=22557;   // ta
   sortTable[0x4EA3]=22558;   // ta
   sortTable[0x4FA4]=22559;   // ta
   sortTable[0x549C]=22560;   // ta
   sortTable[0x5683]=22561;   // ta
   sortTable[0x56BA]=22562;   // ta
   sortTable[0x5896]=22563;   // ta
   sortTable[0x5D09]=22564;   // ta
   sortTable[0x6428]=22565;   // ta
   sortTable[0x64BB]=22566;   // ta
   sortTable[0x6999]=22567;   // ta
   sortTable[0x6A7D]=22568;   // ta
   sortTable[0x6BFE]=22569;   // ta
   sortTable[0x6DBE]=22570;   // ta
   sortTable[0x6E9A]=22571;   // ta
   sortTable[0x6FBE]=22572;   // ta
   sortTable[0x6FCC]=22573;   // ta
   sortTable[0x7260]=22574;   // ta
   sortTable[0x72E7]=22575;   // ta
   sortTable[0x737A]=22576;   // ta
   sortTable[0x8B76]=22577;   // ta
   sortTable[0x95E5]=22578;   // ta
   sortTable[0x95E7]=22579;   // ta
   sortTable[0x9B99]=22580;   // ta
   sortTable[0x592A]=22581;   // tai
   sortTable[0x53F0]=22582;   // tai
   sortTable[0x6001]=22583;   // tai
   sortTable[0x614B]=22584;   // tai
   sortTable[0x62AC]=22585;   // tai
   sortTable[0x80CE]=22586;   // tai
   sortTable[0x6C70]=22587;   // tai
   sortTable[0x6CF0]=22588;   // tai
   sortTable[0x82D4]=22589;   // tai
   sortTable[0x80BD]=22590;   // tai
   sortTable[0x949B]=22591;   // tai
   sortTable[0x70B1]=22592;   // tai
   sortTable[0x85B9]=22593;   // tai
   sortTable[0x8DC6]=22594;   // tai
   sortTable[0x90B0]=22595;   // tai
   sortTable[0x9C90]=22596;   // tai
   sortTable[0x915E]=22597;   // tai
   sortTable[0x9226]=22598;   // tai
   sortTable[0x7C8F]=22599;   // tai
   sortTable[0x81FA]=22600;   // tai
   sortTable[0x83ED]=22601;   // tai
   sortTable[0x9B90]=22602;   // tai
   sortTable[0x7B88]=22603;   // tai
   sortTable[0x8226]=22604;   // tai
   sortTable[0x98B1]=22605;   // tai
   sortTable[0x5113]=22606;   // tai
   sortTable[0x51AD]=22607;   // tai
   sortTable[0x56FC]=22608;   // tai
   sortTable[0x576E]=22609;   // tai
   sortTable[0x5933]=22610;   // tai
   sortTable[0x5B2F]=22611;   // tai
   sortTable[0x5B61]=22612;   // tai
   sortTable[0x5FF2]=22613;   // tai
   sortTable[0x64E1]=22614;   // tai
   sortTable[0x65F2]=22615;   // tai
   sortTable[0x67B1]=22616;   // tai
   sortTable[0x6AAF]=22617;   // tai
   sortTable[0x6E99]=22618;   // tai
   sortTable[0x70B2]=22619;   // tai
   sortTable[0x71E4]=22620;   // tai
   sortTable[0x7C49]=22621;   // tai
   sortTable[0x99D8]=22622;   // tai
   sortTable[0x8C08]=22623;   // tan
   sortTable[0x8AC7]=22624;   // tan
   sortTable[0x53F9]=22625;   // tan
   sortTable[0x5606]=22626;   // tan
   sortTable[0x63A2]=22627;   // tan
   sortTable[0x5766]=22628;   // tan
   sortTable[0x70AD]=22629;   // tan
   sortTable[0x644A]=22630;   // tan
   sortTable[0x6524]=22631;   // tan
   sortTable[0x6EE9]=22632;   // tan
   sortTable[0x7058]=22633;   // tan
   sortTable[0x78B3]=22634;   // tan
   sortTable[0x8D2A]=22635;   // tan
   sortTable[0x8CAA]=22636;   // tan
   sortTable[0x6F6D]=22637;   // tan
   sortTable[0x6BEF]=22638;   // tan
   sortTable[0x75F0]=22639;   // tan
   sortTable[0x575B]=22640;   // tan
   sortTable[0x8C2D]=22641;   // tan
   sortTable[0x6A80]=22642;   // tan
   sortTable[0x762B]=22643;   // tan
   sortTable[0x6619]=22644;   // tan
   sortTable[0x8892]=22645;   // tan
   sortTable[0x574D]=22646;   // tan
   sortTable[0x8983]=22647;   // tan
   sortTable[0x90EF]=22648;   // tan
   sortTable[0x5FD0]=22649;   // tan
   sortTable[0x952C]=22650;   // tan
   sortTable[0x94BD]=22651;   // tan
   sortTable[0x83FC]=22652;   // tan
   sortTable[0x8962]=22653;   // tan
   sortTable[0x9193]=22654;   // tan
   sortTable[0x9924]=22655;   // tan
   sortTable[0x78F9]=22656;   // tan
   sortTable[0x7F48]=22657;   // tan
   sortTable[0x91B0]=22658;   // tan
   sortTable[0x7F4E]=22659;   // tan
   sortTable[0x85EB]=22660;   // tan
   sortTable[0x9188]=22661;   // tan
   sortTable[0x8C9A]=22662;   // tan
   sortTable[0x931F]=22663;   // tan
   sortTable[0x5013]=22664;   // tan
   sortTable[0x509D]=22665;   // tan
   sortTable[0x50CB]=22666;   // tan
   sortTable[0x55FF]=22667;   // tan
   sortTable[0x57EE]=22668;   // tan
   sortTable[0x58B0]=22669;   // tan
   sortTable[0x58B5]=22670;   // tan
   sortTable[0x58C7]=22671;   // tan
   sortTable[0x58DC]=22672;   // tan
   sortTable[0x5A52]=22673;   // tan
   sortTable[0x6039]=22674;   // tan
   sortTable[0x60D4]=22675;   // tan
   sortTable[0x619B]=22676;   // tan
   sortTable[0x61B3]=22677;   // tan
   sortTable[0x61BB]=22678;   // tan
   sortTable[0x62A9]=22679;   // tan
   sortTable[0x64F9]=22680;   // tan
   sortTable[0x66C7]=22681;   // tan
   sortTable[0x6983]=22682;   // tan
   sortTable[0x6B4E]=22683;   // tan
   sortTable[0x6E60]=22684;   // tan
   sortTable[0x71C2]=22685;   // tan
   sortTable[0x74AE]=22686;   // tan
   sortTable[0x75D1]=22687;   // tan
   sortTable[0x7671]=22688;   // tan
   sortTable[0x8211]=22689;   // tan
   sortTable[0x8215]=22690;   // tan
   sortTable[0x8B5A]=22691;   // tan
   sortTable[0x8B60]=22692;   // tan
   sortTable[0x8CE7]=22693;   // tan
   sortTable[0x926D]=22694;   // tan
   sortTable[0x9843]=22695;   // tan
   sortTable[0x8EBA]=22696;   // tang
   sortTable[0x5802]=22697;   // tang
   sortTable[0x7CD6]=22698;   // tang
   sortTable[0x8D9F]=22699;   // tang
   sortTable[0x5858]=22700;   // tang
   sortTable[0x5018]=22701;   // tang
   sortTable[0x6C64]=22702;   // tang
   sortTable[0x6E6F]=22703;   // tang
   sortTable[0x70EB]=22704;   // tang
   sortTable[0x71D9]=22705;   // tang
   sortTable[0x819B]=22706;   // tang
   sortTable[0x6DCC]=22707;   // tang
   sortTable[0x642A]=22708;   // tang
   sortTable[0x5510]=22709;   // tang
   sortTable[0x68E0]=22710;   // tang
   sortTable[0x50A5]=22711;   // tang
   sortTable[0x5E11]=22712;   // tang
   sortTable[0x7FB0]=22713;   // tang
   sortTable[0x9967]=22714;   // tang
   sortTable[0x746D]=22715;   // tang
   sortTable[0x87B3]=22716;   // tang
   sortTable[0x91A3]=22717;   // tang
   sortTable[0x9557]=22718;   // tang
   sortTable[0x6A18]=22719;   // tang
   sortTable[0x8E5A]=22720;   // tang
   sortTable[0x6E8F]=22721;   // tang
   sortTable[0x799F]=22722;   // tang
   sortTable[0x8797]=22723;   // tang
   sortTable[0x954B]=22724;   // tang
   sortTable[0x8025]=22725;   // tang
   sortTable[0x77D8]=22726;   // tang
   sortTable[0x910C]=22727;   // tang
   sortTable[0x93DC]=22728;   // tang
   sortTable[0x9F1E]=22729;   // tang
   sortTable[0x93B2]=22730;   // tang
   sortTable[0x97BA]=22731;   // tang
   sortTable[0x8E3C]=22732;   // tang
   sortTable[0x940B]=22733;   // tang
   sortTable[0x9482]=22734;   // tang
   sortTable[0x95DB]=22735;   // tang
   sortTable[0x969A]=22736;   // tang
   sortTable[0x78C4]=22737;   // tang
   sortTable[0x7BD6]=22738;   // tang
   sortTable[0x876A]=22739;   // tang
   sortTable[0x94F4]=22740;   // tang
   sortTable[0x9944]=22741;   // tang
   sortTable[0x9DB6]=22742;   // tang
   sortTable[0x4F16]=22743;   // tang
   sortTable[0x5052]=22744;   // tang
   sortTable[0x508F]=22745;   // tang
   sortTable[0x513B]=22746;   // tang
   sortTable[0x528F]=22747;   // tang
   sortTable[0x557A]=22748;   // tang
   sortTable[0x5621]=22749;   // tang
   sortTable[0x5763]=22750;   // tang
   sortTable[0x6203]=22751;   // tang
   sortTable[0x6465]=22752;   // tang
   sortTable[0x66ED]=22753;   // tang
   sortTable[0x69B6]=22754;   // tang
   sortTable[0x6A56]=22755;   // tang
   sortTable[0x6F1F]=22756;   // tang
   sortTable[0x717B]=22757;   // tang
   sortTable[0x7223]=22758;   // tang
   sortTable[0x7CC3]=22759;   // tang
   sortTable[0x7CDB]=22760;   // tang
   sortTable[0x8185]=22761;   // tang
   sortTable[0x84CE]=22762;   // tang
   sortTable[0x859A]=22763;   // tang
   sortTable[0x8D6F]=22764;   // tang
   sortTable[0x9395]=22765;   // tang
   sortTable[0x9933]=22766;   // tang
   sortTable[0x9939]=22767;   // tang
   sortTable[0x8BA8]=22768;   // tao
   sortTable[0x8A0E]=22769;   // tao
   sortTable[0x5957]=22770;   // tao
   sortTable[0x9003]=22771;   // tao
   sortTable[0x638F]=22772;   // tao
   sortTable[0x6843]=22773;   // tao
   sortTable[0x8404]=22774;   // tao
   sortTable[0x6DD8]=22775;   // tao
   sortTable[0x9676]=22776;   // tao
   sortTable[0x6D9B]=22777;   // tao
   sortTable[0x6FE4]=22778;   // tao
   sortTable[0x6ED4]=22779;   // tao
   sortTable[0x97EC]=22780;   // tao
   sortTable[0x9955]=22781;   // tao
   sortTable[0x6D2E]=22782;   // tao
   sortTable[0x7EE6]=22783;   // tao
   sortTable[0x9F17]=22784;   // tao
   sortTable[0x5555]=22785;   // tao
   sortTable[0x7DAF]=22786;   // tao
   sortTable[0x7EF9]=22787;   // tao
   sortTable[0x7E1A]=22788;   // tao
   sortTable[0x7979]=22789;   // tao
   sortTable[0x9A0A]=22790;   // tao
   sortTable[0x8FEF]=22791;   // tao
   sortTable[0x9789]=22792;   // tao
   sortTable[0x9780]=22793;   // tao
   sortTable[0x92FE]=22794;   // tao
   sortTable[0x7D5B]=22795;   // tao
   sortTable[0x8B1F]=22796;   // tao
   sortTable[0x9184]=22797;   // tao
   sortTable[0x98F8]=22798;   // tao
   sortTable[0x99E3]=22799;   // tao
   sortTable[0x872A]=22800;   // tao
   sortTable[0x7E27]=22801;   // tao
   sortTable[0x8F41]=22802;   // tao
   sortTable[0x932D]=22803;   // tao
   sortTable[0x530B]=22804;   // tao
   sortTable[0x54B7]=22805;   // tao
   sortTable[0x5932]=22806;   // tao
   sortTable[0x5ACD]=22807;   // tao
   sortTable[0x5E4D]=22808;   // tao
   sortTable[0x5F22]=22809;   // tao
   sortTable[0x6146]=22810;   // tao
   sortTable[0x642F]=22811;   // tao
   sortTable[0x68BC]=22812;   // tao
   sortTable[0x69C4]=22813;   // tao
   sortTable[0x6AAE]=22814;   // tao
   sortTable[0x746B]=22815;   // tao
   sortTable[0x88EA]=22816;   // tao
   sortTable[0x8A5C]=22817;   // tao
   sortTable[0x97B1]=22818;   // tao
   sortTable[0x97DC]=22819;   // tao
   sortTable[0x9940]=22820;   // tao
   sortTable[0x7279]=22821;   // te
   sortTable[0x5FD2]=22822;   // te
   sortTable[0x615D]=22823;   // te
   sortTable[0x5FD1]=22824;   // te
   sortTable[0x87A3]=22825;   // te
   sortTable[0x8CA3]=22826;   // te
   sortTable[0x94FD]=22827;   // te
   sortTable[0x87D8]=22828;   // te
   sortTable[0x92F1]=22829;   // te
   sortTable[0x86AE]=22830;   // te
   sortTable[0x75BC]=22831;   // teng
   sortTable[0x817E]=22832;   // teng
   sortTable[0x9A30]=22833;   // teng
   sortTable[0x85E4]=22834;   // teng
   sortTable[0x6ED5]=22835;   // teng
   sortTable[0x8A8A]=22836;   // teng
   sortTable[0x7E22]=22837;   // teng
   sortTable[0x9F1F]=22838;   // teng
   sortTable[0x8B04]=22839;   // teng
   sortTable[0x81AF]=22840;   // teng
   sortTable[0x9086]=22841;   // teng
   sortTable[0x7C50]=22842;   // teng
   sortTable[0x99E6]=22843;   // teng
   sortTable[0x9C27]=22844;   // teng
   sortTable[0x512F]=22845;   // teng
   sortTable[0x5E50]=22846;   // teng
   sortTable[0x6F1B]=22847;   // teng
   sortTable[0x71A5]=22848;   // teng
   sortTable[0x75CB]=22849;   // teng
   sortTable[0x7C58]=22850;   // teng
   sortTable[0x8645]=22851;   // teng
   sortTable[0x972F]=22852;   // teng
   sortTable[0x9A63]=22853;   // teng
   sortTable[0x4F53]=22854;   // ti
   sortTable[0x9AD4]=22855;   // ti
   sortTable[0x9898]=22856;   // ti
   sortTable[0x984C]=22857;   // ti
   sortTable[0x63D0]=22858;   // ti
   sortTable[0x66FF]=22859;   // ti
   sortTable[0x8E22]=22860;   // ti
   sortTable[0x68AF]=22861;   // ti
   sortTable[0x5C49]=22862;   // ti
   sortTable[0x5C5C]=22863;   // ti
   sortTable[0x60D5]=22864;   // ti
   sortTable[0x8E44]=22865;   // ti
   sortTable[0x6D95]=22866;   // ti
   sortTable[0x557C]=22867;   // ti
   sortTable[0x5254]=22868;   // ti
   sortTable[0x5243]=22869;   // ti
   sortTable[0x9016]=22870;   // ti
   sortTable[0x608C]=22871;   // ti
   sortTable[0x88FC]=22872;   // ti
   sortTable[0x501C]=22873;   // ti
   sortTable[0x568F]=22874;   // ti
   sortTable[0x7F07]=22875;   // ti
   sortTable[0x7EE8]=22876;   // ti
   sortTable[0x9E48]=22877;   // ti
   sortTable[0x918D]=22878;   // ti
   sortTable[0x8351]=22879;   // ti
   sortTable[0x9511]=22880;   // ti
   sortTable[0x8599]=22881;   // ti
   sortTable[0x8DAF]=22882;   // ti
   sortTable[0x9BA7]=22883;   // ti
   sortTable[0x9A20]=22884;   // ti
   sortTable[0x9D97]=22885;   // ti
   sortTable[0x9CC0]=22886;   // ti
   sortTable[0x9D3A]=22887;   // ti
   sortTable[0x7D88]=22888;   // ti
   sortTable[0x8EC6]=22889;   // ti
   sortTable[0x7A0A]=22890;   // ti
   sortTable[0x9037]=22891;   // ti
   sortTable[0x9DC9]=22892;   // ti
   sortTable[0x79B5]=22893;   // ti
   sortTable[0x8DA7]=22894;   // ti
   sortTable[0x7B39]=22895;   // ti
   sortTable[0x9046]=22896;   // ti
   sortTable[0x9DE4]=22897;   // ti
   sortTable[0x855B]=22898;   // ti
   sortTable[0x7DF9]=22899;   // ti
   sortTable[0x8E4F]=22900;   // ti
   sortTable[0x8FCF]=22901;   // ti
   sortTable[0x9357]=22902;   // ti
   sortTable[0x7C4A]=22903;   // ti
   sortTable[0x9B00]=22904;   // ti
   sortTable[0x9BF7]=22905;   // ti
   sortTable[0x9D99]=22906;   // ti
   sortTable[0x78AE]=22907;   // ti
   sortTable[0x876D]=22908;   // ti
   sortTable[0x8905]=22909;   // ti
   sortTable[0x8906]=22910;   // ti
   sortTable[0x9BB7]=22911;   // ti
   sortTable[0x504D]=22912;   // ti
   sortTable[0x5397]=22913;   // ti
   sortTable[0x55C1]=22914;   // ti
   sortTable[0x5694]=22915;   // ti
   sortTable[0x5D39]=22916;   // ti
   sortTable[0x5D5C]=22917;   // ti
   sortTable[0x5FB2]=22918;   // ti
   sortTable[0x6090]=22919;   // ti
   sortTable[0x60D6]=22920;   // ti
   sortTable[0x60FF]=22921;   // ti
   sortTable[0x623B]=22922;   // ti
   sortTable[0x632E]=22923;   // ti
   sortTable[0x63A6]=22924;   // ti
   sortTable[0x63E5]=22925;   // ti
   sortTable[0x64FF]=22926;   // ti
   sortTable[0x6711]=22927;   // ti
   sortTable[0x6974]=22928;   // ti
   sortTable[0x6B52]=22929;   // ti
   sortTable[0x6BA2]=22930;   // ti
   sortTable[0x6D1F]=22931;   // ti
   sortTable[0x6F3D]=22932;   // ti
   sortTable[0x7445]=22933;   // ti
   sortTable[0x74CB]=22934;   // ti
   sortTable[0x7F64]=22935;   // ti
   sortTable[0x82D0]=22936;   // ti
   sortTable[0x8B15]=22937;   // ti
   sortTable[0x8EB0]=22938;   // ti
   sortTable[0x92BB]=22939;   // ti
   sortTable[0x9AB5]=22940;   // ti
   sortTable[0x9AF0]=22941;   // ti
   sortTable[0x9D5C]=22942;   // ti
   sortTable[0x9DC8]=22943;   // ti
   sortTable[0x5929]=22944;   // tian
   sortTable[0x7530]=22945;   // tian
   sortTable[0x6DFB]=22946;   // tian
   sortTable[0x751C]=22947;   // tian
   sortTable[0x586B]=22948;   // tian
   sortTable[0x8214]=22949;   // tian
   sortTable[0x606C]=22950;   // tian
   sortTable[0x5FDD]=22951;   // tian
   sortTable[0x754B]=22952;   // tian
   sortTable[0x6B84]=22953;   // tian
   sortTable[0x9617]=22954;   // tian
   sortTable[0x8146]=22955;   // tian
   sortTable[0x7AB4]=22956;   // tian
   sortTable[0x9766]=22957;   // tian
   sortTable[0x9902]=22958;   // tian
   sortTable[0x63AD]=22959;   // tian
   sortTable[0x89CD]=22960;   // tian
   sortTable[0x9D2B]=22961;   // tian
   sortTable[0x9369]=22962;   // tian
   sortTable[0x923F]=22963;   // tian
   sortTable[0x78CC]=22964;   // tian
   sortTable[0x83FE]=22965;   // tian
   sortTable[0x89A5]=22966;   // tian
   sortTable[0x76F7]=22967;   // tian
   sortTable[0x9EC7]=22968;   // tian
   sortTable[0x7753]=22969;   // tian
   sortTable[0x777C]=22970;   // tian
   sortTable[0x78B5]=22971;   // tian
   sortTable[0x8CDF]=22972;   // tian
   sortTable[0x9754]=22973;   // tian
   sortTable[0x9DCF]=22974;   // tian
   sortTable[0x500E]=22975;   // tian
   sortTable[0x5172]=22976;   // tian
   sortTable[0x553A]=22977;   // tian
   sortTable[0x5861]=22978;   // tian
   sortTable[0x5A56]=22979;   // tian
   sortTable[0x5C47]=22980;   // tian
   sortTable[0x60BF]=22981;   // tian
   sortTable[0x6437]=22982;   // tian
   sortTable[0x666A]=22983;   // tian
   sortTable[0x6CBA]=22984;   // tian
   sortTable[0x6DDF]=22985;   // tian
   sortTable[0x6E49]=22986;   // tian
   sortTable[0x7420]=22987;   // tian
   sortTable[0x74B3]=22988;   // tian
   sortTable[0x751B]=22989;   // tian
   sortTable[0x7551]=22990;   // tian
   sortTable[0x7560]=22991;   // tian
   sortTable[0x75F6]=22992;   // tian
   sortTable[0x7DC2]=22993;   // tian
   sortTable[0x80CB]=22994;   // tian
   sortTable[0x821A]=22995;   // tian
   sortTable[0x915F]=22996;   // tian
   sortTable[0x932A]=22997;   // tian
   sortTable[0x95D0]=22998;   // tian
   sortTable[0x975D]=22999;   // tian
   sortTable[0x9DC6]=23000;   // tian
   sortTable[0x6761]=23001;   // tiao
   sortTable[0x689D]=23002;   // tiao
   sortTable[0x8DF3]=23003;   // tiao
   sortTable[0x6311]=23004;   // tiao
   sortTable[0x7C9C]=23005;   // tiao
   sortTable[0x7CF6]=23006;   // tiao
   sortTable[0x773A]=23007;   // tiao
   sortTable[0x8FE2]=23008;   // tiao
   sortTable[0x7A95]=23009;   // tiao
   sortTable[0x7B24]=23010;   // tiao
   sortTable[0x7967]=23011;   // tiao
   sortTable[0x9F86]=23012;   // tiao
   sortTable[0x4F7B]=23013;   // tiao
   sortTable[0x9AEB]=23014;   // tiao
   sortTable[0x84DA]=23015;   // tiao
   sortTable[0x8729]=23016;   // tiao
   sortTable[0x9BC8]=23017;   // tiao
   sortTable[0x9CA6]=23018;   // tiao
   sortTable[0x9797]=23019;   // tiao
   sortTable[0x84E8]=23020;   // tiao
   sortTable[0x8280]=23021;   // tiao
   sortTable[0x899C]=23022;   // tiao
   sortTable[0x7AB1]=23023;   // tiao
   sortTable[0x9C37]=23024;   // tiao
   sortTable[0x7D69]=23025;   // tiao
   sortTable[0x8A82]=23026;   // tiao
   sortTable[0x8101]=23027;   // tiao
   sortTable[0x5B25]=23028;   // tiao
   sortTable[0x5BA8]=23029;   // tiao
   sortTable[0x5CA7]=23030;   // tiao
   sortTable[0x5CB9]=23031;   // tiao
   sortTable[0x5EA3]=23032;   // tiao
   sortTable[0x604C]=23033;   // tiao
   sortTable[0x65A2]=23034;   // tiao
   sortTable[0x65EB]=23035;   // tiao
   sortTable[0x6640]=23036;   // tiao
   sortTable[0x6713]=23037;   // tiao
   sortTable[0x6A24]=23038;   // tiao
   sortTable[0x7952]=23039;   // tiao
   sortTable[0x804E]=23040;   // tiao
   sortTable[0x8414]=23041;   // tiao
   sortTable[0x87A9]=23042;   // tiao
   sortTable[0x8D92]=23043;   // tiao
   sortTable[0x92DA]=23044;   // tiao
   sortTable[0x93A5]=23045;   // tiao
   sortTable[0x9F60]=23046;   // tiao
   sortTable[0x94C1]=23047;   // tie
   sortTable[0x9435]=23048;   // tie
   sortTable[0x8D34]=23049;   // tie
   sortTable[0x8CBC]=23050;   // tie
   sortTable[0x5E16]=23051;   // tie
   sortTable[0x992E]=23052;   // tie
   sortTable[0x841C]=23053;   // tie
   sortTable[0x98FB]=23054;   // tie
   sortTable[0x9A56]=23055;   // tie
   sortTable[0x9295]=23056;   // tie
   sortTable[0x9D29]=23057;   // tie
   sortTable[0x86C8]=23058;   // tie
   sortTable[0x50E3]=23059;   // tie
   sortTable[0x546B]=23060;   // tie
   sortTable[0x6017]=23061;   // tie
   sortTable[0x8051]=23062;   // tie
   sortTable[0x92E8]=23063;   // tie
   sortTable[0x9421]=23064;   // tie
   sortTable[0x542C]=23065;   // ting
   sortTable[0x807D]=23066;   // ting
   sortTable[0x505C]=23067;   // ting
   sortTable[0x633A]=23068;   // ting
   sortTable[0x5EAD]=23069;   // ting
   sortTable[0x5385]=23070;   // ting
   sortTable[0x5EF3]=23071;   // ting
   sortTable[0x4EAD]=23072;   // ting
   sortTable[0x8247]=23073;   // ting
   sortTable[0x8713]=23074;   // ting
   sortTable[0x5EF7]=23075;   // ting
   sortTable[0x9706]=23076;   // ting
   sortTable[0x6C40]=23077;   // ting
   sortTable[0x5A77]=23078;   // ting
   sortTable[0x753A]=23079;   // ting
   sortTable[0x988B]=23080;   // ting
   sortTable[0x6883]=23081;   // ting
   sortTable[0x7D8E]=23082;   // ting
   sortTable[0x70C3]=23083;   // ting
   sortTable[0x8476]=23084;   // ting
   sortTable[0x9793]=23085;   // ting
   sortTable[0x8074]=23086;   // ting
   sortTable[0x839B]=23087;   // ting
   sortTable[0x8121]=23088;   // ting
   sortTable[0x95AE]=23089;   // ting
   sortTable[0x9F2E]=23090;   // ting
   sortTable[0x7B73]=23091;   // ting
   sortTable[0x827C]=23092;   // ting
   sortTable[0x9832]=23093;   // ting
   sortTable[0x4FB9]=23094;   // ting
   sortTable[0x539B]=23095;   // ting
   sortTable[0x5722]=23096;   // ting
   sortTable[0x5A17]=23097;   // ting
   sortTable[0x5D49]=23098;   // ting
   sortTable[0x5E81]=23099;   // ting
   sortTable[0x5EF0]=23100;   // ting
   sortTable[0x686F]=23101;   // ting
   sortTable[0x695F]=23102;   // ting
   sortTable[0x69B3]=23103;   // ting
   sortTable[0x6D8F]=23104;   // ting
   sortTable[0x6E1F]=23105;   // ting
   sortTable[0x70F4]=23106;   // ting
   sortTable[0x70F6]=23107;   // ting
   sortTable[0x73FD]=23108;   // ting
   sortTable[0x753C]=23109;   // ting
   sortTable[0x8013]=23110;   // ting
   sortTable[0x8064]=23111;   // ting
   sortTable[0x807C]=23112;   // ting
   sortTable[0x874F]=23113;   // ting
   sortTable[0x8A94]=23114;   // ting
   sortTable[0x8AEA]=23115;   // ting
   sortTable[0x9092]=23116;   // ting
   sortTable[0x540C]=23117;   // tong
   sortTable[0x901A]=23118;   // tong
   sortTable[0x7EDF]=23119;   // tong
   sortTable[0x7D71]=23120;   // tong
   sortTable[0x75DB]=23121;   // tong
   sortTable[0x94DC]=23122;   // tong
   sortTable[0x9285]=23123;   // tong
   sortTable[0x6876]=23124;   // tong
   sortTable[0x7AE5]=23125;   // tong
   sortTable[0x7B52]=23126;   // tong
   sortTable[0x6850]=23127;   // tong
   sortTable[0x4F5F]=23128;   // tong
   sortTable[0x6F7C]=23129;   // tong
   sortTable[0x50EE]=23130;   // tong
   sortTable[0x6078]=23131;   // tong
   sortTable[0x5F64]=23132;   // tong
   sortTable[0x6345]=23133;   // tong
   sortTable[0x77B3]=23134;   // tong
   sortTable[0x55F5]=23135;   // tong
   sortTable[0x916E]=23136;   // tong
   sortTable[0x4EDD]=23137;   // tong
   sortTable[0x783C]=23138;   // tong
   sortTable[0x7B69]=23139;   // tong
   sortTable[0x772E]=23140;   // tong
   sortTable[0x9C96]=23141;   // tong
   sortTable[0x7CA1]=23142;   // tong
   sortTable[0x833C]=23143;   // tong
   sortTable[0x8A77]=23144;   // tong
   sortTable[0x8855]=23145;   // tong
   sortTable[0x84EA]=23146;   // tong
   sortTable[0x79F1]=23147;   // tong
   sortTable[0x9BA6]=23148;   // tong
   sortTable[0x7D82]=23149;   // tong
   sortTable[0x8692]=23150;   // tong
   sortTable[0x9907]=23151;   // tong
   sortTable[0x52ED]=23152;   // tong
   sortTable[0x54C3]=23153;   // tong
   sortTable[0x56F2]=23154;   // tong
   sortTable[0x5CC2]=23155;   // tong
   sortTable[0x5CDD]=23156;   // tong
   sortTable[0x5E9D]=23157;   // tong
   sortTable[0x615F]=23158;   // tong
   sortTable[0x6185]=23159;   // tong
   sortTable[0x664D]=23160;   // tong
   sortTable[0x66C8]=23161;   // tong
   sortTable[0x6723]=23162;   // tong
   sortTable[0x6A0B]=23163;   // tong
   sortTable[0x6A66]=23164;   // tong
   sortTable[0x6C03]=23165;   // tong
   sortTable[0x6D75]=23166;   // tong
   sortTable[0x70B5]=23167;   // tong
   sortTable[0x70D4]=23168;   // tong
   sortTable[0x71D1]=23169;   // tong
   sortTable[0x729D]=23170;   // tong
   sortTable[0x72EA]=23171;   // tong
   sortTable[0x735E]=23172;   // tong
   sortTable[0x75CC]=23173;   // tong
   sortTable[0x81A7]=23174;   // tong
   sortTable[0x8D68]=23175;   // tong
   sortTable[0x9256]=23176;   // tong
   sortTable[0x9275]=23177;   // tong
   sortTable[0x5934]=23178;   // tou
   sortTable[0x982D]=23179;   // tou
   sortTable[0x900F]=23180;   // tou
   sortTable[0x6295]=23181;   // tou
   sortTable[0x5077]=23182;   // tou
   sortTable[0x9AB0]=23183;   // tou
   sortTable[0x94AD]=23184;   // tou
   sortTable[0x936E]=23185;   // tou
   sortTable[0x9EC8]=23186;   // tou
   sortTable[0x7DF0]=23187;   // tou
   sortTable[0x7D0F]=23188;   // tou
   sortTable[0x7D89]=23189;   // tou
   sortTable[0x98F3]=23190;   // tou
   sortTable[0x92C0]=23191;   // tou
   sortTable[0x4EA0]=23192;   // tou
   sortTable[0x5078]=23193;   // tou
   sortTable[0x59B5]=23194;   // tou
   sortTable[0x5A7E]=23195;   // tou
   sortTable[0x5AAE]=23196;   // tou
   sortTable[0x6568]=23197;   // tou
   sortTable[0x8623]=23198;   // tou
   sortTable[0x571F]=23199;   // tu
   sortTable[0x56FE]=23200;   // tu
   sortTable[0x5716]=23201;   // tu
   sortTable[0x7A81]=23202;   // tu
   sortTable[0x9014]=23203;   // tu
   sortTable[0x5F92]=23204;   // tu
   sortTable[0x6D82]=23205;   // tu
   sortTable[0x5154]=23206;   // tu
   sortTable[0x5410]=23207;   // tu
   sortTable[0x51F8]=23208;   // tu
   sortTable[0x5C60]=23209;   // tu
   sortTable[0x79C3]=23210;   // tu
   sortTable[0x79BF]=23211;   // tu
   sortTable[0x837C]=23212;   // tu
   sortTable[0x948D]=23213;   // tu
   sortTable[0x83DF]=23214;   // tu
   sortTable[0x9174]=23215;   // tu
   sortTable[0x99FC]=23216;   // tu
   sortTable[0x7A0C]=23217;   // tu
   sortTable[0x816F]=23218;   // tu
   sortTable[0x580D]=23219;   // tu
   sortTable[0x92F5]=23220;   // tu
   sortTable[0x9D9F]=23221;   // tu
   sortTable[0x83B5]=23222;   // tu
   sortTable[0x8FCC]=23223;   // tu
   sortTable[0x934E]=23224;   // tu
   sortTable[0x8456]=23225;   // tu
   sortTable[0x8DFF]=23226;   // tu
   sortTable[0x84A4]=23227;   // tu
   sortTable[0x9D4C]=23228;   // tu
   sortTable[0x9D75]=23229;   // tu
   sortTable[0x9F35]=23230;   // tu
   sortTable[0x7B61]=23231;   // tu
   sortTable[0x922F]=23232;   // tu
   sortTable[0x9DCB]=23233;   // tu
   sortTable[0x9DF5]=23234;   // tu
   sortTable[0x514E]=23235;   // tu
   sortTable[0x51C3]=23236;   // tu
   sortTable[0x550B]=23237;   // tu
   sortTable[0x56F3]=23238;   // tu
   sortTable[0x5715]=23239;   // tu
   sortTable[0x5717]=23240;   // tu
   sortTable[0x5721]=23241;   // tu
   sortTable[0x5817]=23242;   // tu
   sortTable[0x5857]=23243;   // tu
   sortTable[0x5B8A]=23244;   // tu
   sortTable[0x5CF9]=23245;   // tu
   sortTable[0x5D5E]=23246;   // tu
   sortTable[0x5D80]=23247;   // tu
   sortTable[0x5EA9]=23248;   // tu
   sortTable[0x5EDC]=23249;   // tu
   sortTable[0x6022]=23250;   // tu
   sortTable[0x6087]=23251;   // tu
   sortTable[0x6348]=23252;   // tu
   sortTable[0x6378]=23253;   // tu
   sortTable[0x63EC]=23254;   // tu
   sortTable[0x688C]=23255;   // tu
   sortTable[0x6C62]=23256;   // tu
   sortTable[0x6D8B]=23257;   // tu
   sortTable[0x6E65]=23258;   // tu
   sortTable[0x6F73]=23259;   // tu
   sortTable[0x75DC]=23260;   // tu
   sortTable[0x760F]=23261;   // tu
   sortTable[0x91F7]=23262;   // tu
   sortTable[0x999F]=23263;   // tu
   sortTable[0x9D5A]=23264;   // tu
   sortTable[0x56E2]=23265;   // tuan
   sortTable[0x5718]=23266;   // tuan
   sortTable[0x629F]=23267;   // tuan
   sortTable[0x6E4D]=23268;   // tuan
   sortTable[0x7583]=23269;   // tuan
   sortTable[0x5F56]=23270;   // tuan
   sortTable[0x8916]=23271;   // tuan
   sortTable[0x8C92]=23272;   // tuan
   sortTable[0x7CF0]=23273;   // tuan
   sortTable[0x93C4]=23274;   // tuan
   sortTable[0x9DFB]=23275;   // tuan
   sortTable[0x9DD2]=23276;   // tuan
   sortTable[0x5278]=23277;   // tuan
   sortTable[0x56E3]=23278;   // tuan
   sortTable[0x6171]=23279;   // tuan
   sortTable[0x6476]=23280;   // tuan
   sortTable[0x69EB]=23281;   // tuan
   sortTable[0x6AB2]=23282;   // tuan
   sortTable[0x6E6A]=23283;   // tuan
   sortTable[0x6F19]=23284;   // tuan
   sortTable[0x7153]=23285;   // tuan
   sortTable[0x732F]=23286;   // tuan
   sortTable[0x7BFF]=23287;   // tuan
   sortTable[0x63A8]=23288;   // tui
   sortTable[0x817F]=23289;   // tui
   sortTable[0x9000]=23290;   // tui
   sortTable[0x9893]=23291;   // tui
   sortTable[0x892A]=23292;   // tui
   sortTable[0x8715]=23293;   // tui
   sortTable[0x717A]=23294;   // tui
   sortTable[0x9B4B]=23295;   // tui
   sortTable[0x96A4]=23296;   // tui
   sortTable[0x7A68]=23297;   // tui
   sortTable[0x8E46]=23298;   // tui
   sortTable[0x84F7]=23299;   // tui
   sortTable[0x85EC]=23300;   // tui
   sortTable[0x8E6A]=23301;   // tui
   sortTable[0x983A]=23302;   // tui
   sortTable[0x86FB]=23303;   // tui
   sortTable[0x9839]=23304;   // tui
   sortTable[0x99FE]=23305;   // tui
   sortTable[0x4FBB]=23306;   // tui
   sortTable[0x4FC0]=23307;   // tui
   sortTable[0x50D3]=23308;   // tui
   sortTable[0x5A27]=23309;   // tui
   sortTable[0x5C35]=23310;   // tui
   sortTable[0x5F1A]=23311;   // tui
   sortTable[0x8608]=23312;   // tui
   sortTable[0x983D]=23313;   // tui
   sortTable[0x9ABD]=23314;   // tui
   sortTable[0x541E]=23315;   // tun
   sortTable[0x5C6F]=23316;   // tun
   sortTable[0x81C0]=23317;   // tun
   sortTable[0x8C5A]=23318;   // tun
   sortTable[0x9968]=23319;   // tun
   sortTable[0x66BE]=23320;   // tun
   sortTable[0x9C80]=23321;   // tun
   sortTable[0x9B68]=23322;   // tun
   sortTable[0x6C3D]=23323;   // tun
   sortTable[0x829A]=23324;   // tun
   sortTable[0x98E9]=23325;   // tun
   sortTable[0x81CB]=23326;   // tun
   sortTable[0x8ED8]=23327;   // tun
   sortTable[0x9715]=23328;   // tun
   sortTable[0x5451]=23329;   // tun
   sortTable[0x554D]=23330;   // tun
   sortTable[0x564B]=23331;   // tun
   sortTable[0x5749]=23332;   // tun
   sortTable[0x5FF3]=23333;   // tun
   sortTable[0x65FD]=23334;   // tun
   sortTable[0x671C]=23335;   // tun
   sortTable[0x6D92]=23336;   // tun
   sortTable[0x711E]=23337;   // tun
   sortTable[0x757D]=23338;   // tun
   sortTable[0x8C58]=23339;   // tun
   sortTable[0x9ED7]=23340;   // tun
   sortTable[0x8131]=23341;   // tuo
   sortTable[0x812B]=23342;   // tuo
   sortTable[0x62D6]=23343;   // tuo
   sortTable[0x9A7C]=23344;   // tuo
   sortTable[0x99DD]=23345;   // tuo
   sortTable[0x6258]=23346;   // tuo
   sortTable[0x59A5]=23347;   // tuo
   sortTable[0x9A6E]=23348;   // tuo
   sortTable[0x99B1]=23349;   // tuo
   sortTable[0x553E]=23350;   // tuo
   sortTable[0x692D]=23351;   // tuo
   sortTable[0x6A62]=23352;   // tuo
   sortTable[0x9640]=23353;   // tuo
   sortTable[0x6A50]=23354;   // tuo
   sortTable[0x9E35]=23355;   // tuo
   sortTable[0x4F57]=23356;   // tuo
   sortTable[0x6CB1]=23357;   // tuo
   sortTable[0x8DCE]=23358;   // tuo
   sortTable[0x4E47]=23359;   // tuo
   sortTable[0x9F0D]=23360;   // tuo
   sortTable[0x7823]=23361;   // tuo
   sortTable[0x8BAC]=23362;   // tuo
   sortTable[0x5EB9]=23363;   // tuo
   sortTable[0x67DD]=23364;   // tuo
   sortTable[0x7BA8]=23365;   // tuo
   sortTable[0x5768]=23366;   // tuo
   sortTable[0x9F09]=23367;   // tuo
   sortTable[0x9641]=23368;   // tuo
   sortTable[0x9161]=23369;   // tuo
   sortTable[0x6CB2]=23370;   // tuo
   sortTable[0x8DC5]=23371;   // tuo
   sortTable[0x88A5]=23372;   // tuo
   sortTable[0x9B80]=23373;   // tuo
   sortTable[0x8A17]=23374;   // tuo
   sortTable[0x9966]=23375;   // tuo
   sortTable[0x8FF1]=23376;   // tuo
   sortTable[0x841A]=23377;   // tuo
   sortTable[0x9A52]=23378;   // tuo
   sortTable[0x9B60]=23379;   // tuo
   sortTable[0x8600]=23380;   // tuo
   sortTable[0x8889]=23381;   // tuo
   sortTable[0x9B0C]=23382;   // tuo
   sortTable[0x7D3D]=23383;   // tuo
   sortTable[0x99DE]=23384;   // tuo
   sortTable[0x7824]=23385;   // tuo
   sortTable[0x7C5C]=23386;   // tuo
   sortTable[0x98E5]=23387;   // tuo
   sortTable[0x9A5D]=23388;   // tuo
   sortTable[0x9C16]=23389;   // tuo
   sortTable[0x9F27]=23390;   // tuo
   sortTable[0x4EDB]=23391;   // tuo
   sortTable[0x4F82]=23392;   // tuo
   sortTable[0x5483]=23393;   // tuo
   sortTable[0x5836]=23394;   // tuo
   sortTable[0x5AA0]=23395;   // tuo
   sortTable[0x5AF7]=23396;   // tuo
   sortTable[0x5CAE]=23397;   // tuo
   sortTable[0x5F75]=23398;   // tuo
   sortTable[0x6261]=23399;   // tuo
   sortTable[0x62D5]=23400;   // tuo
   sortTable[0x6329]=23401;   // tuo
   sortTable[0x635D]=23402;   // tuo
   sortTable[0x6754]=23403;   // tuo
   sortTable[0x6955]=23404;   // tuo
   sortTable[0x69D6]=23405;   // tuo
   sortTable[0x6BE4]=23406;   // tuo
   sortTable[0x6BFB]=23407;   // tuo
   sortTable[0x6C51]=23408;   // tuo
   sortTable[0x6CB0]=23409;   // tuo
   sortTable[0x6DB6]=23410;   // tuo
   sortTable[0x72CF]=23411;   // tuo
   sortTable[0x78A2]=23412;   // tuo
   sortTable[0x838C]=23413;   // tuo
   sortTable[0x99C4]=23414;   // tuo
   sortTable[0x9A28]=23415;   // tuo
   sortTable[0x9D15]=23416;   // tuo
   sortTable[0x9D4E]=23417;   // tuo
   sortTable[0x6316]=24320;   // wa
   sortTable[0x54C7]=24321;   // wa
   sortTable[0x86D9]=24322;   // wa
   sortTable[0x74E6]=24323;   // wa
   sortTable[0x5A03]=24324;   // wa
   sortTable[0x889C]=24325;   // wa
   sortTable[0x896A]=24326;   // wa
   sortTable[0x6D3C]=24327;   // wa
   sortTable[0x5A32]=24328;   // wa
   sortTable[0x4F64]=24329;   // wa
   sortTable[0x97C8]=24330;   // wa
   sortTable[0x7A8A]=24331;   // wa
   sortTable[0x817D]=24332;   // wa
   sortTable[0x7A75]=24333;   // wa
   sortTable[0x7AAA]=24334;   // wa
   sortTable[0x90B7]=24335;   // wa
   sortTable[0x52B8]=24336;   // wa
   sortTable[0x5493]=24337;   // wa
   sortTable[0x55D7]=24338;   // wa
   sortTable[0x55E2]=24339;   // wa
   sortTable[0x5AA7]=24340;   // wa
   sortTable[0x5C72]=24341;   // wa
   sortTable[0x6432]=24342;   // wa
   sortTable[0x6528]=24343;   // wa
   sortTable[0x6E9B]=24344;   // wa
   sortTable[0x6F25]=24345;   // wa
   sortTable[0x74F2]=24346;   // wa
   sortTable[0x7556]=24347;   // wa
   sortTable[0x8049]=24348;   // wa
   sortTable[0x8183]=24349;   // wa
   sortTable[0x97E4]=24350;   // wa
   sortTable[0x9F03]=24351;   // wa
   sortTable[0x5916]=24352;   // wai
   sortTable[0x6B6A]=24353;   // wai
   sortTable[0x5D34]=24354;   // wai
   sortTable[0x9861]=24355;   // wai
   sortTable[0x7AF5]=24356;   // wai
   sortTable[0x558E]=24357;   // wai
   sortTable[0x591E]=24358;   // wai
   sortTable[0x5B8C]=24359;   // wan
   sortTable[0x4E07]=24360;   // wan
   sortTable[0x842C]=24361;   // wan
   sortTable[0x665A]=24362;   // wan
   sortTable[0x7897]=24363;   // wan
   sortTable[0x73A9]=24364;   // wan
   sortTable[0x5F2F]=24365;   // wan
   sortTable[0x5F4E]=24366;   // wan
   sortTable[0x633D]=24367;   // wan
   sortTable[0x987D]=24368;   // wan
   sortTable[0x9811]=24369;   // wan
   sortTable[0x6E7E]=24370;   // wan
   sortTable[0x7063]=24371;   // wan
   sortTable[0x60CB]=24372;   // wan
   sortTable[0x4E38]=24373;   // wan
   sortTable[0x8C4C]=24374;   // wan
   sortTable[0x5B9B]=24375;   // wan
   sortTable[0x5A49]=24376;   // wan
   sortTable[0x8155]=24377;   // wan
   sortTable[0x7EA8]=24378;   // wan
   sortTable[0x7EFE]=24379;   // wan
   sortTable[0x7696]=24380;   // wan
   sortTable[0x7579]=24381;   // wan
   sortTable[0x8284]=24382;   // wan
   sortTable[0x742C]=24383;   // wan
   sortTable[0x83C0]=24384;   // wan
   sortTable[0x873F]=24385;   // wan
   sortTable[0x525C]=24386;   // wan
   sortTable[0x70F7]=24387;   // wan
   sortTable[0x8F13]=24388;   // wan
   sortTable[0x8118]=24389;   // wan
   sortTable[0x7FEB]=24390;   // wan
   sortTable[0x7755]=24391;   // wan
   sortTable[0x8E20]=24392;   // wan
   sortTable[0x92C4]=24393;   // wan
   sortTable[0x8115]=24394;   // wan
   sortTable[0x8CA6]=24395;   // wan
   sortTable[0x8F10]=24396;   // wan
   sortTable[0x909C]=24397;   // wan
   sortTable[0x93AB]=24398;   // wan
   sortTable[0x76CC]=24399;   // wan
   sortTable[0x5007]=24400;   // wan
   sortTable[0x5213]=24401;   // wan
   sortTable[0x534D]=24402;   // wan
   sortTable[0x5350]=24403;   // wan
   sortTable[0x550D]=24404;   // wan
   sortTable[0x57E6]=24405;   // wan
   sortTable[0x5846]=24406;   // wan
   sortTable[0x58EA]=24407;   // wan
   sortTable[0x59A7]=24408;   // wan
   sortTable[0x5A60]=24409;   // wan
   sortTable[0x5C8F]=24410;   // wan
   sortTable[0x5E35]=24411;   // wan
   sortTable[0x5FE8]=24412;   // wan
   sortTable[0x628F]=24413;   // wan
   sortTable[0x6356]=24414;   // wan
   sortTable[0x6365]=24415;   // wan
   sortTable[0x6669]=24416;   // wan
   sortTable[0x667C]=24417;   // wan
   sortTable[0x6764]=24418;   // wan
   sortTable[0x689A]=24419;   // wan
   sortTable[0x6900]=24420;   // wan
   sortTable[0x6C4D]=24421;   // wan
   sortTable[0x6F6B]=24422;   // wan
   sortTable[0x6FAB]=24423;   // wan
   sortTable[0x7413]=24424;   // wan
   sortTable[0x7B02]=24425;   // wan
   sortTable[0x7D08]=24426;   // wan
   sortTable[0x7DA9]=24427;   // wan
   sortTable[0x7DB0]=24428;   // wan
   sortTable[0x8416]=24429;   // wan
   sortTable[0x858D]=24430;   // wan
   sortTable[0x87C3]=24431;   // wan
   sortTable[0x8D03]=24432;   // wan
   sortTable[0x8D0E]=24433;   // wan
   sortTable[0x92D4]=24434;   // wan
   sortTable[0x933D]=24435;   // wan
   sortTable[0x671B]=24436;   // wang
   sortTable[0x5F80]=24437;   // wang
   sortTable[0x5FD8]=24438;   // wang
   sortTable[0x738B]=24439;   // wang
   sortTable[0x7F51]=24440;   // wang
   sortTable[0x7DB2]=24441;   // wang
   sortTable[0x4EA1]=24442;   // wang
   sortTable[0x5984]=24443;   // wang
   sortTable[0x65FA]=24444;   // wang
   sortTable[0x6789]=24445;   // wang
   sortTable[0x6C6A]=24446;   // wang
   sortTable[0x7F54]=24447;   // wang
   sortTable[0x60D8]=24448;   // wang
   sortTable[0x9B4D]=24449;   // wang
   sortTable[0x8F8B]=24450;   // wang
   sortTable[0x8744]=24451;   // wang
   sortTable[0x8FCB]=24452;   // wang
   sortTable[0x83F5]=24453;   // wang
   sortTable[0x8AB7]=24454;   // wang
   sortTable[0x8F1E]=24455;   // wang
   sortTable[0x76F3]=24456;   // wang
   sortTable[0x83A3]=24457;   // wang
   sortTable[0x86E7]=24458;   // wang
   sortTable[0x4EBE]=24459;   // wang
   sortTable[0x4EFC]=24460;   // wang
   sortTable[0x5166]=24461;   // wang
   sortTable[0x5C23]=24462;   // wang
   sortTable[0x5C29]=24463;   // wang
   sortTable[0x5C2A]=24464;   // wang
   sortTable[0x5C2B]=24465;   // wang
   sortTable[0x5F7A]=24466;   // wang
   sortTable[0x5F83]=24467;   // wang
   sortTable[0x5F8D]=24468;   // wang
   sortTable[0x6680]=24469;   // wang
   sortTable[0x6722]=24470;   // wang
   sortTable[0x68E2]=24471;   // wang
   sortTable[0x7007]=24472;   // wang
   sortTable[0x7139]=24473;   // wang
   sortTable[0x7F52]=24474;   // wang
   sortTable[0x869F]=24475;   // wang
   sortTable[0x4E3A]=24476;   // wei
   sortTable[0x70BA]=24477;   // wei
   sortTable[0x4F4D]=24478;   // wei
   sortTable[0x59D4]=24479;   // wei
   sortTable[0x56F4]=24480;   // wei
   sortTable[0x570D]=24481;   // wei
   sortTable[0x4F1F]=24482;   // wei
   sortTable[0x5049]=24483;   // wei
   sortTable[0x5FAE]=24484;   // wei
   sortTable[0x7EF4]=24485;   // wei
   sortTable[0x7DAD]=24486;   // wei
   sortTable[0x536B]=24487;   // wei
   sortTable[0x885B]=24488;   // wei
   sortTable[0x672A]=24489;   // wei
   sortTable[0x5371]=24490;   // wei
   sortTable[0x5473]=24491;   // wei
   sortTable[0x552F]=24492;   // wei
   sortTable[0x5A01]=24493;   // wei
   sortTable[0x8C13]=24494;   // wei
   sortTable[0x8B02]=24495;   // wei
   sortTable[0x5C3E]=24496;   // wei
   sortTable[0x5582]=24497;   // wei
   sortTable[0x60DF]=24498;   // wei
   sortTable[0x8FDD]=24499;   // wei
   sortTable[0x9055]=24500;   // wei
   sortTable[0x80C3]=24501;   // wei
   sortTable[0x6170]=24502;   // wei
   sortTable[0x4F2A]=24503;   // wei
   sortTable[0x507D]=24504;   // wei
   sortTable[0x7EAC]=24505;   // wei
   sortTable[0x7DEF]=24506;   // wei
   sortTable[0x82C7]=24507;   // wei
   sortTable[0x8466]=24508;   // wei
   sortTable[0x754F]=24509;   // wei
   sortTable[0x504E]=24510;   // wei
   sortTable[0x6845]=24511;   // wei
   sortTable[0x732C]=24512;   // wei
   sortTable[0x875F]=24513;   // wei
   sortTable[0x5DCD]=24514;   // wei
   sortTable[0x9B4F]=24515;   // wei
   sortTable[0x5C09]=24516;   // wei
   sortTable[0x97E6]=24517;   // wei
   sortTable[0x6E2D]=24518;   // wei
   sortTable[0x5E37]=24519;   // wei
   sortTable[0x851A]=24520;   // wei
   sortTable[0x840E]=24521;   // wei
   sortTable[0x8587]=24522;   // wei
   sortTable[0x95F1]=24523;   // wei
   sortTable[0x7168]=24524;   // wei
   sortTable[0x8BFF]=24525;   // wei
   sortTable[0x9036]=24526;   // wei
   sortTable[0x7325]=24527;   // wei
   sortTable[0x709C]=24528;   // wei
   sortTable[0x5A13]=24529;   // wei
   sortTable[0x5729]=24530;   // wei
   sortTable[0x73AE]=24531;   // wei
   sortTable[0x5E0F]=24532;   // wei
   sortTable[0x6DA0]=24533;   // wei
   sortTable[0x5D6C]=24534;   // wei
   sortTable[0x8249]=24535;   // wei
   sortTable[0x97EA]=24536;   // wei
   sortTable[0x6F4D]=24537;   // wei
   sortTable[0x75FF]=24538;   // wei
   sortTable[0x9820]=24539;   // wei
   sortTable[0x6D27]=24540;   // wei
   sortTable[0x9C94]=24541;   // wei
   sortTable[0x9688]=24542;   // wei
   sortTable[0x8473]=24543;   // wei
   sortTable[0x9CDA]=24544;   // wei
   sortTable[0x7859]=24545;   // wei
   sortTable[0x97E1]=24546;   // wei
   sortTable[0x848D]=24547;   // wei
   sortTable[0x85B3]=24548;   // wei
   sortTable[0x9927]=24549;   // wei
   sortTable[0x9728]=24550;   // wei
   sortTable[0x9CC2]=24551;   // wei
   sortTable[0x9AAB]=24552;   // wei
   sortTable[0x9BA0]=24553;   // wei
   sortTable[0x873C]=24554;   // wei
   sortTable[0x8A74]=24555;   // wei
   sortTable[0x6CA9]=24556;   // wei
   sortTable[0x7DED]=24557;   // wei
   sortTable[0x9687]=24558;   // wei
   sortTable[0x934F]=24559;   // wei
   sortTable[0x912C]=24560;   // wei
   sortTable[0x78D1]=24561;   // wei
   sortTable[0x853F]=24562;   // wei
   sortTable[0x7F7B]=24563;   // wei
   sortTable[0x82FF]=24564;   // wei
   sortTable[0x87B1]=24565;   // wei
   sortTable[0x8F4A]=24566;   // wei
   sortTable[0x78A8]=24567;   // wei
   sortTable[0x8468]=24568;   // wei
   sortTable[0x78C8]=24569;   // wei
   sortTable[0x84F6]=24570;   // wei
   sortTable[0x85EF]=24571;   // wei
   sortTable[0x8624]=24572;   // wei
   sortTable[0x8ECE]=24573;   // wei
   sortTable[0x8B8F]=24574;   // wei
   sortTable[0x784A]=24575;   // wei
   sortTable[0x83CB]=24576;   // wei
   sortTable[0x8AC9]=24577;   // wei
   sortTable[0x93CF]=24578;   // wei
   sortTable[0x9935]=24579;   // wei
   sortTable[0x829B]=24580;   // wei
   sortTable[0x8732]=24581;   // wei
   sortTable[0x95C8]=24582;   // wei
   sortTable[0x97D9]=24583;   // wei
   sortTable[0x9956]=24584;   // wei
   sortTable[0x9AA9]=24585;   // wei
   sortTable[0x9BAA]=24586;   // wei
   sortTable[0x893D]=24587;   // wei
   sortTable[0x8E97]=24588;   // wei
   sortTable[0x8E9B]=24589;   // wei
   sortTable[0x98B9]=24590;   // wei
   sortTable[0x9AAA]=24591;   // wei
   sortTable[0x9B87]=24592;   // wei
   sortTable[0x50DE]=24593;   // wei
   sortTable[0x5130]=24594;   // wei
   sortTable[0x5383]=24595;   // wei
   sortTable[0x53DE]=24596;   // wei
   sortTable[0x55A1]=24597;   // wei
   sortTable[0x55B4]=24598;   // wei
   sortTable[0x56D7]=24599;   // wei
   sortTable[0x589B]=24600;   // wei
   sortTable[0x58DD]=24601;   // wei
   sortTable[0x5A81]=24602;   // wei
   sortTable[0x5A99]=24603;   // wei
   sortTable[0x5AA6]=24604;   // wei
   sortTable[0x5BEA]=24605;   // wei
   sortTable[0x5C57]=24606;   // wei
   sortTable[0x5CD7]=24607;   // wei
   sortTable[0x5CDE]=24608;   // wei
   sortTable[0x5D23]=24609;   // wei
   sortTable[0x5D54]=24610;   // wei
   sortTable[0x5DB6]=24611;   // wei
   sortTable[0x5E43]=24612;   // wei
   sortTable[0x5FAB]=24613;   // wei
   sortTable[0x6104]=24614;   // wei
   sortTable[0x6107]=24615;   // wei
   sortTable[0x61C0]=24616;   // wei
   sortTable[0x6364]=24617;   // wei
   sortTable[0x63CB]=24618;   // wei
   sortTable[0x63FB]=24619;   // wei
   sortTable[0x64B1]=24620;   // wei
   sortTable[0x6596]=24621;   // wei
   sortTable[0x6690]=24622;   // wei
   sortTable[0x68B6]=24623;   // wei
   sortTable[0x6932]=24624;   // wei
   sortTable[0x6933]=24625;   // wei
   sortTable[0x6972]=24626;   // wei
   sortTable[0x6B08]=24627;   // wei
   sortTable[0x6D08]=24628;   // wei
   sortTable[0x6D58]=24629;   // wei
   sortTable[0x6E28]=24630;   // wei
   sortTable[0x6E4B]=24631;   // wei
   sortTable[0x6E88]=24632;   // wei
   sortTable[0x6EA6]=24633;   // wei
   sortTable[0x6F59]=24634;   // wei
   sortTable[0x6F7F]=24635;   // wei
   sortTable[0x6FF0]=24636;   // wei
   sortTable[0x6FFB]=24637;   // wei
   sortTable[0x7022]=24638;   // wei
   sortTable[0x70D3]=24639;   // wei
   sortTable[0x7140]=24640;   // wei
   sortTable[0x7152]=24641;   // wei
   sortTable[0x715F]=24642;   // wei
   sortTable[0x71AD]=24643;   // wei
   sortTable[0x71F0]=24644;   // wei
   sortTable[0x7232]=24645;   // wei
   sortTable[0x729A]=24646;   // wei
   sortTable[0x72A9]=24647;   // wei
   sortTable[0x741F]=24648;   // wei
   sortTable[0x744B]=24649;   // wei
   sortTable[0x748F]=24650;   // wei
   sortTable[0x75CF]=24651;   // wei
   sortTable[0x7653]=24652;   // wei
   sortTable[0x7E05]=24653;   // wei
   sortTable[0x8172]=24654;   // wei
   sortTable[0x8371]=24655;   // wei
   sortTable[0x8636]=24656;   // wei
   sortTable[0x875B]=24657;   // wei
   sortTable[0x885E]=24658;   // wei
   sortTable[0x89A3]=24659;   // wei
   sortTable[0x89B9]=24660;   // wei
   sortTable[0x8B86]=24661;   // wei
   sortTable[0x8E13]=24662;   // wei
   sortTable[0x9180]=24663;   // wei
   sortTable[0x9361]=24664;   // wei
   sortTable[0x973A]=24665;   // wei
   sortTable[0x97CB]=24666;   // wei
   sortTable[0x97D1]=24667;   // wei
   sortTable[0x9C03]=24668;   // wei
   sortTable[0x9C04]=24669;   // wei
   sortTable[0x95EE]=24670;   // wen
   sortTable[0x554F]=24671;   // wen
   sortTable[0x6587]=24672;   // wen
   sortTable[0x6E29]=24673;   // wen
   sortTable[0x6EAB]=24674;   // wen
   sortTable[0x7A33]=24675;   // wen
   sortTable[0x7A69]=24676;   // wen
   sortTable[0x95FB]=24677;   // wen
   sortTable[0x805E]=24678;   // wen
   sortTable[0x7EB9]=24679;   // wen
   sortTable[0x7D0B]=24680;   // wen
   sortTable[0x868A]=24681;   // wen
   sortTable[0x543B]=24682;   // wen
   sortTable[0x96EF]=24683;   // wen
   sortTable[0x7D0A]=24684;   // wen
   sortTable[0x761F]=24685;   // wen
   sortTable[0x6C76]=24686;   // wen
   sortTable[0x520E]=24687;   // wen
   sortTable[0x960C]=24688;   // wen
   sortTable[0x74BA]=24689;   // wen
   sortTable[0x9850]=24690;   // wen
   sortTable[0x8F92]=24691;   // wen
   sortTable[0x8570]=24692;   // wen
   sortTable[0x739F]=24693;   // wen
   sortTable[0x95BA]=24694;   // wen
   sortTable[0x95C5]=24695;   // wen
   sortTable[0x8F40]=24696;   // wen
   sortTable[0x9CC1]=24697;   // wen
   sortTable[0x8117]=24698;   // wen
   sortTable[0x9B70]=24699;   // wen
   sortTable[0x9F24]=24700;   // wen
   sortTable[0x97B0]=24701;   // wen
   sortTable[0x95BF]=24702;   // wen
   sortTable[0x82A0]=24703;   // wen
   sortTable[0x8689]=24704;   // wen
   sortTable[0x87A1]=24705;   // wen
   sortTable[0x87C1]=24706;   // wen
   sortTable[0x922B]=24707;   // wen
   sortTable[0x95E6]=24708;   // wen
   sortTable[0x9CFC]=24709;   // wen
   sortTable[0x5301]=24710;   // wen
   sortTable[0x545A]=24711;   // wen
   sortTable[0x5461]=24712;   // wen
   sortTable[0x586D]=24713;   // wen
   sortTable[0x598F]=24714;   // wen
   sortTable[0x5F63]=24715;   // wen
   sortTable[0x5FDF]=24716;   // wen
   sortTable[0x6286]=24717;   // wen
   sortTable[0x63FE]=24718;   // wen
   sortTable[0x6435]=24719;   // wen
   sortTable[0x6637]=24720;   // wen
   sortTable[0x687D]=24721;   // wen
   sortTable[0x6985]=24722;   // wen
   sortTable[0x6B9F]=24723;   // wen
   sortTable[0x6E02]=24724;   // wen
   sortTable[0x7086]=24725;   // wen
   sortTable[0x73F3]=24726;   // wen
   sortTable[0x741D]=24727;   // wen
   sortTable[0x7465]=24728;   // wen
   sortTable[0x7612]=24729;   // wen
   sortTable[0x7A4F]=24730;   // wen
   sortTable[0x80B3]=24731;   // wen
   sortTable[0x83AC]=24732;   // wen
   sortTable[0x8C71]=24733;   // wen
   sortTable[0x8F3C]=24734;   // wen
   sortTable[0x93BE]=24735;   // wen
   sortTable[0x99BC]=24736;   // wen
   sortTable[0x9C1B]=24737;   // wen
   sortTable[0x9C2E]=24738;   // wen
   sortTable[0x9D0D]=24739;   // wen
   sortTable[0x55E1]=24740;   // weng
   sortTable[0x7FC1]=24741;   // weng
   sortTable[0x74EE]=24742;   // weng
   sortTable[0x8579]=24743;   // weng
   sortTable[0x84CA]=24744;   // weng
   sortTable[0x806C]=24745;   // weng
   sortTable[0x8789]=24746;   // weng
   sortTable[0x9E5F]=24747;   // weng
   sortTable[0x9F46]=24748;   // weng
   sortTable[0x7F4B]=24749;   // weng
   sortTable[0x7788]=24750;   // weng
   sortTable[0x9DB2]=24751;   // weng
   sortTable[0x52DC]=24752;   // weng
   sortTable[0x5855]=24753;   // weng
   sortTable[0x5963]=24754;   // weng
   sortTable[0x5D61]=24755;   // weng
   sortTable[0x66A1]=24756;   // weng
   sortTable[0x6EC3]=24757;   // weng
   sortTable[0x7515]=24758;   // weng
   sortTable[0x9393]=24759;   // weng
   sortTable[0x6211]=24760;   // wo
   sortTable[0x63E1]=24761;   // wo
   sortTable[0x7A9D]=24762;   // wo
   sortTable[0x7AA9]=24763;   // wo
   sortTable[0x5367]=24764;   // wo
   sortTable[0x81E5]=24765;   // wo
   sortTable[0x6DA1]=24766;   // wo
   sortTable[0x6E26]=24767;   // wo
   sortTable[0x6C83]=24768;   // wo
   sortTable[0x8717]=24769;   // wo
   sortTable[0x8778]=24770;   // wo
   sortTable[0x502D]=24771;   // wo
   sortTable[0x6E25]=24772;   // wo
   sortTable[0x65A1]=24773;   // wo
   sortTable[0x631D]=24774;   // wo
   sortTable[0x5E44]=24775;   // wo
   sortTable[0x786A]=24776;   // wo
   sortTable[0x9F8C]=24777;   // wo
   sortTable[0x809F]=24778;   // wo
   sortTable[0x83B4]=24779;   // wo
   sortTable[0x96D8]=24780;   // wo
   sortTable[0x81D2]=24781;   // wo
   sortTable[0x8435]=24782;   // wo
   sortTable[0x8E12]=24783;   // wo
   sortTable[0x4EF4]=24784;   // wo
   sortTable[0x5053]=24785;   // wo
   sortTable[0x5529]=24786;   // wo
   sortTable[0x5A50]=24787;   // wo
   sortTable[0x5A89]=24788;   // wo
   sortTable[0x6370]=24789;   // wo
   sortTable[0x637E]=24790;   // wo
   sortTable[0x64BE]=24791;   // wo
   sortTable[0x64ED]=24792;   // wo
   sortTable[0x6782]=24793;   // wo
   sortTable[0x6943]=24794;   // wo
   sortTable[0x6DB4]=24795;   // wo
   sortTable[0x6DB9]=24796;   // wo
   sortTable[0x6FE3]=24797;   // wo
   sortTable[0x7125]=24798;   // wo
   sortTable[0x7327]=24799;   // wo
   sortTable[0x74C1]=24800;   // wo
   sortTable[0x7783]=24801;   // wo
   sortTable[0x815B]=24802;   // wo
   sortTable[0x9F77]=24803;   // wo
   sortTable[0x7269]=24804;   // wu
   sortTable[0x65E0]=24805;   // wu
   sortTable[0x7121]=24806;   // wu
   sortTable[0x4E94]=24807;   // wu
   sortTable[0x5C4B]=24808;   // wu
   sortTable[0x8BEF]=24809;   // wu
   sortTable[0x8AA4]=24810;   // wu
   sortTable[0x52A1]=24811;   // wu
   sortTable[0x52D9]=24812;   // wu
   sortTable[0x6B66]=24813;   // wu
   sortTable[0x5348]=24814;   // wu
   sortTable[0x4F0D]=24815;   // wu
   sortTable[0x821E]=24816;   // wu
   sortTable[0x6C61]=24817;   // wu
   sortTable[0x96FE]=24818;   // wu
   sortTable[0x9727]=24819;   // wu
   sortTable[0x4E4C]=24820;   // wu
   sortTable[0x609F]=24821;   // wu
   sortTable[0x70CF]=24822;   // wu
   sortTable[0x4FAE]=24823;   // wu
   sortTable[0x6342]=24824;   // wu
   sortTable[0x8BEC]=24825;   // wu
   sortTable[0x8AA3]=24826;   // wu
   sortTable[0x545C]=24827;   // wu
   sortTable[0x8708]=24828;   // wu
   sortTable[0x55DA]=24829;   // wu
   sortTable[0x543E]=24830;   // wu
   sortTable[0x5434]=24831;   // wu
   sortTable[0x620A]=24832;   // wu
   sortTable[0x52FF]=24833;   // wu
   sortTable[0x5DEB]=24834;   // wu
   sortTable[0x5140]=24835;   // wu
   sortTable[0x6BCB]=24836;   // wu
   sortTable[0x6664]=24837;   // wu
   sortTable[0x68A7]=24838;   // wu
   sortTable[0x829C]=24839;   // wu
   sortTable[0x575E]=24840;   // wu
   sortTable[0x5FE4]=24841;   // wu
   sortTable[0x9E49]=24842;   // wu
   sortTable[0x5514]=24843;   // wu
   sortTable[0x5E91]=24844;   // wu
   sortTable[0x5BE4]=24845;   // wu
   sortTable[0x5A7A]=24846;   // wu
   sortTable[0x92C8]=24847;   // wu
   sortTable[0x6D6F]=24848;   // wu
   sortTable[0x59A9]=24849;   // wu
   sortTable[0x7110]=24850;   // wu
   sortTable[0x9E5C]=24851;   // wu
   sortTable[0x90AC]=24852;   // wu
   sortTable[0x9A9B]=24853;   // wu
   sortTable[0x8FD5]=24854;   // wu
   sortTable[0x674C]=24855;   // wu
   sortTable[0x4EF5]=24856;   // wu
   sortTable[0x9622]=24857;   // wu
   sortTable[0x82B4]=24858;   // wu
   sortTable[0x94A8]=24859;   // wu
   sortTable[0x6003]=24860;   // wu
   sortTable[0x572C]=24861;   // wu
   sortTable[0x727E]=24862;   // wu
   sortTable[0x9C1E]=24863;   // wu
   sortTable[0x9F2F]=24864;   // wu
   sortTable[0x7991]=24865;   // wu
   sortTable[0x94FB]=24866;   // wu
   sortTable[0x90DA]=24867;   // wu
   sortTable[0x96FA]=24868;   // wu
   sortTable[0x75E6]=24869;   // wu
   sortTable[0x971A]=24870;   // wu
   sortTable[0x8323]=24871;   // wu
   sortTable[0x9770]=24872;   // wu
   sortTable[0x7894]=24873;   // wu
   sortTable[0x9E40]=24874;   // wu
   sortTable[0x7966]=24875;   // wu
   sortTable[0x907B]=24876;   // wu
   sortTable[0x856A]=24877;   // wu
   sortTable[0x9D2E]=24878;   // wu
   sortTable[0x8790]=24879;   // wu
   sortTable[0x7AB9]=24880;   // wu
   sortTable[0x9696]=24881;   // wu
   sortTable[0x8381]=24882;   // wu
   sortTable[0x8601]=24883;   // wu
   sortTable[0x87F1]=24884;   // wu
   sortTable[0x933B]=24885;   // wu
   sortTable[0x9F3F]=24886;   // wu
   sortTable[0x77F9]=24887;   // wu
   sortTable[0x7A8F]=24888;   // wu
   sortTable[0x901C]=24889;   // wu
   sortTable[0x9BC3]=24890;   // wu
   sortTable[0x9DA9]=24891;   // wu
   sortTable[0x9F40]=24892;   // wu
   sortTable[0x4E44]=24893;   // wu
   sortTable[0x4F06]=24894;   // wu
   sortTable[0x4FC9]=24895;   // wu
   sortTable[0x5035]=24896;   // wu
   sortTable[0x511B]=24897;   // wu
   sortTable[0x526D]=24898;   // wu
   sortTable[0x537C]=24899;   // wu
   sortTable[0x5433]=24900;   // wu
   sortTable[0x5449]=24901;   // wu
   sortTable[0x554E]=24902;   // wu
   sortTable[0x5862]=24903;   // wu
   sortTable[0x5966]=24904;   // wu
   sortTable[0x5A2A]=24905;   // wu
   sortTable[0x5A2C]=24906;   // wu
   sortTable[0x5AF5]=24907;   // wu
   sortTable[0x5C7C]=24908;   // wu
   sortTable[0x5C89]=24909;   // wu
   sortTable[0x5D4D]=24910;   // wu
   sortTable[0x5D68]=24911;   // wu
   sortTable[0x5EE1]=24912;   // wu
   sortTable[0x5F19]=24913;   // wu
   sortTable[0x5FE2]=24914;   // wu
   sortTable[0x609E]=24915;   // wu
   sortTable[0x60AE]=24916;   // wu
   sortTable[0x61AE]=24917;   // wu
   sortTable[0x6264]=24918;   // wu
   sortTable[0x6440]=24919;   // wu
   sortTable[0x6544]=24920;   // wu
   sortTable[0x65FF]=24921;   // wu
   sortTable[0x6747]=24922;   // wu
   sortTable[0x6A46]=24923;   // wu
   sortTable[0x6B4D]=24924;   // wu
   sortTable[0x6C59]=24925;   // wu
   sortTable[0x6C5A]=24926;   // wu
   sortTable[0x6D16]=24927;   // wu
   sortTable[0x6D3F]=24928;   // wu
   sortTable[0x6EA9]=24929;   // wu
   sortTable[0x6F55]=24930;   // wu
   sortTable[0x7183]=24931;   // wu
   sortTable[0x7193]=24932;   // wu
   sortTable[0x739D]=24933;   // wu
   sortTable[0x73F7]=24934;   // wu
   sortTable[0x73F8]=24935;   // wu
   sortTable[0x7466]=24936;   // wu
   sortTable[0x7491]=24937;   // wu
   sortTable[0x7512]=24938;   // wu
   sortTable[0x7BBC]=24939;   // wu
   sortTable[0x7C85]=24940;   // wu
   sortTable[0x8A88]=24941;   // wu
   sortTable[0x8B55]=24942;   // wu
   sortTable[0x8E8C]=24943;   // wu
   sortTable[0x9114]=24944;   // wu
   sortTable[0x93A2]=24945;   // wu
   sortTable[0x9A16]=24946;   // wu
   sortTable[0x9D50]=24947;   // wu
   sortTable[0x9D61]=24948;   // wu
   sortTable[0x9DE1]=24949;   // wu
   sortTable[0x897F]=25344;   // xi
   sortTable[0x7EC6]=25345;   // xi
   sortTable[0x7D30]=25346;   // xi
   sortTable[0x4E60]=25347;   // xi
   sortTable[0x7FD2]=25348;   // xi
   sortTable[0x5E2D]=25349;   // xi
   sortTable[0x7CFB]=25350;   // xi
   sortTable[0x559C]=25351;   // xi
   sortTable[0x606F]=25352;   // xi
   sortTable[0x5438]=25353;   // xi
   sortTable[0x5E0C]=25354;   // xi
   sortTable[0x6D17]=25355;   // xi
   sortTable[0x620F]=25356;   // xi
   sortTable[0x6232]=25357;   // xi
   sortTable[0x6790]=25358;   // xi
   sortTable[0x60DC]=25359;   // xi
   sortTable[0x6089]=25360;   // xi
   sortTable[0x727A]=25361;   // xi
   sortTable[0x72A7]=25362;   // xi
   sortTable[0x7A00]=25363;   // xi
   sortTable[0x5AB3]=25364;   // xi
   sortTable[0x88AD]=25365;   // xi
   sortTable[0x8972]=25366;   // xi
   sortTable[0x563B]=25367;   // xi
   sortTable[0x6EAA]=25368;   // xi
   sortTable[0x819D]=25369;   // xi
   sortTable[0x9699]=25370;   // xi
   sortTable[0x6670]=25371;   // xi
   sortTable[0x7184]=25372;   // xi
   sortTable[0x5915]=25373;   // xi
   sortTable[0x9521]=25374;   // xi
   sortTable[0x932B]=25375;   // xi
   sortTable[0x87CB]=25376;   // xi
   sortTable[0x7280]=25377;   // xi
   sortTable[0x6614]=25378;   // xi
   sortTable[0x7199]=25379;   // xi
   sortTable[0x5F99]=25380;   // xi
   sortTable[0x516E]=25381;   // xi
   sortTable[0x79A7]=25382;   // xi
   sortTable[0x595A]=25383;   // xi
   sortTable[0x8785]=25384;   // xi
   sortTable[0x73BA]=25385;   // xi
   sortTable[0x6A84]=25386;   // xi
   sortTable[0x50D6]=25387;   // xi
   sortTable[0x7FB2]=25388;   // xi
   sortTable[0x5B09]=25389;   // xi
   sortTable[0x71B9]=25390;   // xi
   sortTable[0x89FD]=25391;   // xi
   sortTable[0x66E6]=25392;   // xi
   sortTable[0x91AF]=25393;   // xi
   sortTable[0x94E3]=25394;   // xi
   sortTable[0x960B]=25395;   // xi
   sortTable[0x6DC5]=25396;   // xi
   sortTable[0x7FD5]=25397;   // xi
   sortTable[0x96B0]=25398;   // xi
   sortTable[0x9969]=25399;   // xi
   sortTable[0x6D60]=25400;   // xi
   sortTable[0x7699]=25401;   // xi
   sortTable[0x90D7]=25402;   // xi
   sortTable[0x7A78]=25403;   // xi
   sortTable[0x6C50]=25404;   // xi
   sortTable[0x8725]=25405;   // xi
   sortTable[0x550F]=25406;   // xi
   sortTable[0x8204]=25407;   // xi
   sortTable[0x6B37]=25408;   // xi
   sortTable[0x823E]=25409;   // xi
   sortTable[0x70EF]=25410;   // xi
   sortTable[0x83E5]=25411;   // xi
   sortTable[0x8C3F]=25412;   // xi
   sortTable[0x90E4]=25413;   // xi
   sortTable[0x7C9E]=25414;   // xi
   sortTable[0x8C68]=25415;   // xi
   sortTable[0x7AB8]=25416;   // xi
   sortTable[0x7852]=25417;   // xi
   sortTable[0x5C63]=25418;   // xi
   sortTable[0x89CB]=25419;   // xi
   sortTable[0x77FD]=25420;   // xi
   sortTable[0x6A28]=25421;   // xi
   sortTable[0x80B8]=25422;   // xi
   sortTable[0x798A]=25423;   // xi
   sortTable[0x9268]=25424;   // xi
   sortTable[0x89FF]=25425;   // xi
   sortTable[0x8478]=25426;   // xi
   sortTable[0x78CE]=25427;   // xi
   sortTable[0x9F37]=25428;   // xi
   sortTable[0x9145]=25429;   // xi
   sortTable[0x774E]=25430;   // xi
   sortTable[0x8B35]=25431;   // xi
   sortTable[0x84F0]=25432;   // xi
   sortTable[0x95DF]=25433;   // xi
   sortTable[0x76FB]=25434;   // xi
   sortTable[0x9E02]=25435;   // xi
   sortTable[0x8EA7]=25436;   // xi
   sortTable[0x7EE4]=25437;   // xi
   sortTable[0x8D69]=25438;   // xi
   sortTable[0x91F3]=25439;   // xi
   sortTable[0x8669]=25440;   // xi
   sortTable[0x96DF]=25441;   // xi
   sortTable[0x7E30]=25442;   // xi
   sortTable[0x8AF0]=25443;   // xi
   sortTable[0x8E5D]=25444;   // xi
   sortTable[0x7E6B]=25445;   // xi
   sortTable[0x910E]=25446;   // xi
   sortTable[0x9BD1]=25447;   // xi
   sortTable[0x78F6]=25448;   // xi
   sortTable[0x7CE6]=25449;   // xi
   sortTable[0x7D8C]=25450;   // xi
   sortTable[0x7DC6]=25451;   // xi
   sortTable[0x80B9]=25452;   // xi
   sortTable[0x9474]=25453;   // xi
   sortTable[0x972B]=25454;   // xi
   sortTable[0x87E2]=25455;   // xi
   sortTable[0x90CB]=25456;   // xi
   sortTable[0x8C95]=25457;   // xi
   sortTable[0x91F8]=25458;   // xi
   sortTable[0x9CDB]=25459;   // xi
   sortTable[0x84C6]=25460;   // xi
   sortTable[0x89F9]=25461;   // xi
   sortTable[0x8B46]=25462;   // xi
   sortTable[0x8C40]=25463;   // xi
   sortTable[0x77D6]=25464;   // xi
   sortTable[0x7E65]=25465;   // xi
   sortTable[0x8787]=25466;   // xi
   sortTable[0x884B]=25467;   // xi
   sortTable[0x8D65]=25468;   // xi
   sortTable[0x93B4]=25469;   // xi
   sortTable[0x9A31]=25470;   // xi
   sortTable[0x9A3D]=25471;   // xi
   sortTable[0x7902]=25472;   // xi
   sortTable[0x7FD6]=25473;   // xi
   sortTable[0x8582]=25474;   // xi
   sortTable[0x8835]=25475;   // xi
   sortTable[0x93ED]=25476;   // xi
   sortTable[0x7A27]=25477;   // xi
   sortTable[0x8203]=25478;   // xi
   sortTable[0x8383]=25479;   // xi
   sortTable[0x8448]=25480;   // xi
   sortTable[0x84A0]=25481;   // xi
   sortTable[0x856E]=25482;   // xi
   sortTable[0x89A1]=25483;   // xi
   sortTable[0x8B11]=25484;   // xi
   sortTable[0x8C6F]=25485;   // xi
   sortTable[0x969F]=25486;   // xi
   sortTable[0x993C]=25487;   // xi
   sortTable[0x997B]=25488;   // xi
   sortTable[0x9A68]=25489;   // xi
   sortTable[0x9B29]=25490;   // xi
   sortTable[0x9C3C]=25491;   // xi
   sortTable[0x9D57]=25492;   // xi
   sortTable[0x4FC2]=25493;   // xi
   sortTable[0x4FD9]=25494;   // xi
   sortTable[0x5092]=25495;   // xi
   sortTable[0x51DE]=25496;   // xi
   sortTable[0x5338]=25497;   // xi
   sortTable[0x534C]=25498;   // xi
   sortTable[0x5365]=25499;   // xi
   sortTable[0x5380]=25500;   // xi
   sortTable[0x546C]=25501;   // xi
   sortTable[0x54A5]=25502;   // xi
   sortTable[0x553D]=25503;   // xi
   sortTable[0x55BA]=25504;   // xi
   sortTable[0x564F]=25505;   // xi
   sortTable[0x56B1]=25506;   // xi
   sortTable[0x56CD]=25507;   // xi
   sortTable[0x588D]=25508;   // xi
   sortTable[0x58D0]=25509;   // xi
   sortTable[0x5B06]=25510;   // xi
   sortTable[0x5C43]=25511;   // xi
   sortTable[0x5C56]=25512;   // xi
   sortTable[0x5C6D]=25513;   // xi
   sortTable[0x5D60]=25514;   // xi
   sortTable[0x5D8D]=25515;   // xi
   sortTable[0x5DB2]=25516;   // xi
   sortTable[0x5DC7]=25517;   // xi
   sortTable[0x5F86]=25518;   // xi
   sortTable[0x5FAF]=25519;   // xi
   sortTable[0x5FDA]=25520;   // xi
   sortTable[0x5FE5]=25521;   // xi
   sortTable[0x602C]=25522;   // xi
   sortTable[0x6038]=25523;   // xi
   sortTable[0x6044]=25524;   // xi
   sortTable[0x6053]=25525;   // xi
   sortTable[0x6095]=25526;   // xi
   sortTable[0x60C1]=25527;   // xi
   sortTable[0x6140]=25528;   // xi
   sortTable[0x6198]=25529;   // xi
   sortTable[0x6199]=25530;   // xi
   sortTable[0x6231]=25531;   // xi
   sortTable[0x6271]=25532;   // xi
   sortTable[0x6278]=25533;   // xi
   sortTable[0x637F]=25534;   // xi
   sortTable[0x665E]=25535;   // xi
   sortTable[0x6673]=25536;   // xi
   sortTable[0x66BF]=25537;   // xi
   sortTable[0x67B2]=25538;   // xi
   sortTable[0x6878]=25539;   // xi
   sortTable[0x691E]=25540;   // xi
   sortTable[0x693A]=25541;   // xi
   sortTable[0x69BD]=25542;   // xi
   sortTable[0x69E2]=25543;   // xi
   sortTable[0x6A40]=25544;   // xi
   sortTable[0x6A72]=25545;   // xi
   sortTable[0x6B2F]=25546;   // xi
   sortTable[0x6B56]=25547;   // xi
   sortTable[0x6C25]=25548;   // xi
   sortTable[0x6E13]=25549;   // xi
   sortTable[0x6ECA]=25550;   // xi
   sortTable[0x6F07]=25551;   // xi
   sortTable[0x6F1D]=25552;   // xi
   sortTable[0x6F5D]=25553;   // xi
   sortTable[0x6F5F]=25554;   // xi
   sortTable[0x6F99]=25555;   // xi
   sortTable[0x7101]=25556;   // xi
   sortTable[0x7108]=25557;   // xi
   sortTable[0x711F]=25558;   // xi
   sortTable[0x712C]=25559;   // xi
   sortTable[0x7155]=25560;   // xi
   sortTable[0x7182]=25561;   // xi
   sortTable[0x7188]=25562;   // xi
   sortTable[0x71BA]=25563;   // xi
   sortTable[0x71BB]=25564;   // xi
   sortTable[0x71E8]=25565;   // xi
   sortTable[0x7214]=25566;   // xi
   sortTable[0x7294]=25567;   // xi
   sortTable[0x72A0]=25568;   // xi
   sortTable[0x72F6]=25569;   // xi
   sortTable[0x740B]=25570;   // xi
   sortTable[0x74BD]=25571;   // xi
   sortTable[0x761C]=25572;   // xi
   sortTable[0x77A6]=25573;   // xi
   sortTable[0x7E18]=25574;   // xi
   sortTable[0x84B5]=25575;   // xi
   sortTable[0x8980]=25576;   // xi
   sortTable[0x89A4]=25577;   // xi
   sortTable[0x8D87]=25578;   // xi
   sortTable[0x8D98]=25579;   // xi
   sortTable[0x9222]=25580;   // xi
   sortTable[0x9269]=25581;   // xi
   sortTable[0x96B5]=25582;   // xi
   sortTable[0x973C]=25583;   // xi
   sortTable[0x98C1]=25584;   // xi
   sortTable[0x990F]=25585;   // xi
   sortTable[0x9C5A]=25586;   // xi
   sortTable[0x9ED6]=25587;   // xi
   sortTable[0x4E0B]=25588;   // xia
   sortTable[0x590F]=25589;   // xia
   sortTable[0x5413]=25590;   // xia
   sortTable[0x5687]=25591;   // xia
   sortTable[0x5CE1]=25592;   // xia
   sortTable[0x5CFD]=25593;   // xia
   sortTable[0x778E]=25594;   // xia
   sortTable[0x867E]=25595;   // xia
   sortTable[0x8766]=25596;   // xia
   sortTable[0x72ED]=25597;   // xia
   sortTable[0x72F9]=25598;   // xia
   sortTable[0x971E]=25599;   // xia
   sortTable[0x4FA0]=25600;   // xia
   sortTable[0x8F96]=25601;   // xia
   sortTable[0x6687]=25602;   // xia
   sortTable[0x5323]=25603;   // xia
   sortTable[0x9050]=25604;   // xia
   sortTable[0x7455]=25605;   // xia
   sortTable[0x72CE]=25606;   // xia
   sortTable[0x9EE0]=25607;   // xia
   sortTable[0x796B]=25608;   // xia
   sortTable[0x7F45]=25609;   // xia
   sortTable[0x7856]=25610;   // xia
   sortTable[0x67D9]=25611;   // xia
   sortTable[0x9C15]=25612;   // xia
   sortTable[0x965C]=25613;   // xia
   sortTable[0x7E16]=25614;   // xia
   sortTable[0x821D]=25615;   // xia
   sortTable[0x93EC]=25616;   // xia
   sortTable[0x823A]=25617;   // xia
   sortTable[0x93BC]=25618;   // xia
   sortTable[0x938B]=25619;   // xia
   sortTable[0x9A22]=25620;   // xia
   sortTable[0x7FC8]=25621;   // xia
   sortTable[0x8578]=25622;   // xia
   sortTable[0x8C3A]=25623;   // xia
   sortTable[0x8D6E]=25624;   // xia
   sortTable[0x8F44]=25625;   // xia
   sortTable[0x935C]=25626;   // xia
   sortTable[0x967F]=25627;   // xia
   sortTable[0x9DB7]=25628;   // xia
   sortTable[0x7771]=25629;   // xia
   sortTable[0x7E00]=25630;   // xia
   sortTable[0x8672]=25631;   // xia
   sortTable[0x9B7B]=25632;   // xia
   sortTable[0x4E05]=25633;   // xia
   sortTable[0x4E64]=25634;   // xia
   sortTable[0x4FE0]=25635;   // xia
   sortTable[0x5084]=25636;   // xia
   sortTable[0x5737]=25637;   // xia
   sortTable[0x5913]=25638;   // xia
   sortTable[0x61D7]=25639;   // xia
   sortTable[0x656E]=25640;   // xia
   sortTable[0x68BA]=25641;   // xia
   sortTable[0x6E8A]=25642;   // xia
   sortTable[0x70A0]=25643;   // xia
   sortTable[0x70DA]=25644;   // xia
   sortTable[0x7146]=25645;   // xia
   sortTable[0x7175]=25646;   // xia
   sortTable[0x73E8]=25647;   // xia
   sortTable[0x759C]=25648;   // xia
   sortTable[0x75A8]=25649;   // xia
   sortTable[0x7864]=25650;   // xia
   sortTable[0x78AC]=25651;   // xia
   sortTable[0x78CD]=25652;   // xia
   sortTable[0x7B6A]=25653;   // xia
   sortTable[0x9595]=25654;   // xia
   sortTable[0x959C]=25655;   // xia
   sortTable[0x98AC]=25656;   // xia
   sortTable[0x73B0]=25657;   // xian
   sortTable[0x73FE]=25658;   // xian
   sortTable[0x5148]=25659;   // xian
   sortTable[0x7EBF]=25660;   // xian
   sortTable[0x7DDA]=25661;   // xian
   sortTable[0x663E]=25662;   // xian
   sortTable[0x986F]=25663;   // xian
   sortTable[0x53BF]=25664;   // xian
   sortTable[0x7E23]=25665;   // xian
   sortTable[0x9650]=25666;   // xian
   sortTable[0x9669]=25667;   // xian
   sortTable[0x96AA]=25668;   // xian
   sortTable[0x7EA4]=25669;   // xian
   sortTable[0x7E96]=25670;   // xian
   sortTable[0x9C9C]=25671;   // xian
   sortTable[0x9BAE]=25672;   // xian
   sortTable[0x732E]=25673;   // xian
   sortTable[0x737B]=25674;   // xian
   sortTable[0x95F2]=25675;   // xian
   sortTable[0x9591]=25676;   // xian
   sortTable[0x9677]=25677;   // xian
   sortTable[0x6380]=25678;   // xian
   sortTable[0x5BAA]=25679;   // xian
   sortTable[0x61B2]=25680;   // xian
   sortTable[0x5ACC]=25681;   // xian
   sortTable[0x7FA1]=25682;   // xian
   sortTable[0x7FA8]=25683;   // xian
   sortTable[0x4ED9]=25684;   // xian
   sortTable[0x5F26]=25685;   // xian
   sortTable[0x8854]=25686;   // xian
   sortTable[0x929C]=25687;   // xian
   sortTable[0x54B8]=25688;   // xian
   sortTable[0x9985]=25689;   // xian
   sortTable[0x9921]=25690;   // xian
   sortTable[0x8D24]=25691;   // xian
   sortTable[0x817A]=25692;   // xian
   sortTable[0x9170]=25693;   // xian
   sortTable[0x8237]=25694;   // xian
   sortTable[0x5A34]=25695;   // xian
   sortTable[0x6D8E]=25696;   // xian
   sortTable[0x66B9]=25697;   // xian
   sortTable[0x8DE3]=25698;   // xian
   sortTable[0x85D3]=25699;   // xian
   sortTable[0x82CB]=25700;   // xian
   sortTable[0x9528]=25701;   // xian
   sortTable[0x86AC]=25702;   // xian
   sortTable[0x5C98]=25703;   // xian
   sortTable[0x8DF9]=25704;   // xian
   sortTable[0x75EB]=25705;   // xian
   sortTable[0x7C7C]=25706;   // xian
   sortTable[0x83B6]=25707;   // xian
   sortTable[0x9E47]=25708;   // xian
   sortTable[0x7946]=25709;   // xian
   sortTable[0x8AF4]=25710;   // xian
   sortTable[0x71F9]=25711;   // xian
   sortTable[0x7B45]=25712;   // xian
   sortTable[0x774D]=25713;   // xian
   sortTable[0x9592]=25714;   // xian
   sortTable[0x7303]=25715;   // xian
   sortTable[0x51BC]=25716;   // xian
   sortTable[0x94E6]=25717;   // xian
   sortTable[0x6C19]=25718;   // xian
   sortTable[0x929B]=25719;   // xian
   sortTable[0x7CAF]=25720;   // xian
   sortTable[0x7D43]=25721;   // xian
   sortTable[0x9E79]=25722;   // xian
   sortTable[0x8B63]=25723;   // xian
   sortTable[0x81FD]=25724;   // xian
   sortTable[0x86BF]=25725;   // xian
   sortTable[0x934C]=25726;   // xian
   sortTable[0x8E6E]=25727;   // xian
   sortTable[0x8CE2]=25728;   // xian
   sortTable[0x97C5]=25729;   // xian
   sortTable[0x85D6]=25730;   // xian
   sortTable[0x9DF4]=25731;   // xian
   sortTable[0x784D]=25732;   // xian
   sortTable[0x918E]=25733;   // xian
   sortTable[0x92E7]=25734;   // xian
   sortTable[0x97F1]=25735;   // xian
   sortTable[0x79C8]=25736;   // xian
   sortTable[0x8706]=25737;   // xian
   sortTable[0x97EF]=25738;   // xian
   sortTable[0x9DF3]=25739;   // xian
   sortTable[0x770C]=25740;   // xian
   sortTable[0x7992]=25741;   // xian
   sortTable[0x7A34]=25742;   // xian
   sortTable[0x7E4A]=25743;   // xian
   sortTable[0x8C4F]=25744;   // xian
   sortTable[0x8F31]=25745;   // xian
   sortTable[0x9291]=25746;   // xian
   sortTable[0x9855]=25747;   // xian
   sortTable[0x9C7B]=25748;   // xian
   sortTable[0x9DFC]=25749;   // xian
   sortTable[0x9E99]=25750;   // xian
   sortTable[0x7925]=25751;   // xian
   sortTable[0x7CEE]=25752;   // xian
   sortTable[0x7D64]=25753;   // xian
   sortTable[0x7F10]=25754;   // xian
   sortTable[0x80D8]=25755;   // xian
   sortTable[0x8858]=25756;   // xian
   sortTable[0x8A2E]=25757;   // xian
   sortTable[0x8D12]=25758;   // xian
   sortTable[0x967A]=25759;   // xian
   sortTable[0x9F38]=25760;   // xian
   sortTable[0x4EDA]=25761;   // xian
   sortTable[0x4F23]=25762;   // xian
   sortTable[0x4F2D]=25763;   // xian
   sortTable[0x4F61]=25764;   // xian
   sortTable[0x50CA]=25765;   // xian
   sortTable[0x50E9]=25766;   // xian
   sortTable[0x50F2]=25767;   // xian
   sortTable[0x50F4]=25768;   // xian
   sortTable[0x549E]=25769;   // xian
   sortTable[0x54EF]=25770;   // xian
   sortTable[0x550C]=25771;   // xian
   sortTable[0x5563]=25772;   // xian
   sortTable[0x5615]=25773;   // xian
   sortTable[0x57B7]=25774;   // xian
   sortTable[0x58CF]=25775;   // xian
   sortTable[0x597E]=25776;   // xian
   sortTable[0x59B6]=25777;   // xian
   sortTable[0x59ED]=25778;   // xian
   sortTable[0x5A0A]=25779;   // xian
   sortTable[0x5A28]=25780;   // xian
   sortTable[0x5A39]=25781;   // xian
   sortTable[0x5A71]=25782;   // xian
   sortTable[0x5AFA]=25783;   // xian
   sortTable[0x5AFB]=25784;   // xian
   sortTable[0x5B10]=25785;   // xian
   sortTable[0x5C1F]=25786;   // xian
   sortTable[0x5C20]=25787;   // xian
   sortTable[0x5C73]=25788;   // xian
   sortTable[0x5CF4]=25789;   // xian
   sortTable[0x5D04]=25790;   // xian
   sortTable[0x5DAE]=25791;   // xian
   sortTable[0x5E70]=25792;   // xian
   sortTable[0x5EEF]=25793;   // xian
   sortTable[0x5FFA]=25794;   // xian
   sortTable[0x61AA]=25795;   // xian
   sortTable[0x61B8]=25796;   // xian
   sortTable[0x6326]=25797;   // xian
   sortTable[0x641F]=25798;   // xian
   sortTable[0x648A]=25799;   // xian
   sortTable[0x648F]=25800;   // xian
   sortTable[0x6507]=25801;   // xian
   sortTable[0x6515]=25802;   // xian
   sortTable[0x665B]=25803;   // xian
   sortTable[0x6774]=25804;   // xian
   sortTable[0x67AE]=25805;   // xian
   sortTable[0x6A4C]=25806;   // xian
   sortTable[0x6AF6]=25807;   // xian
   sortTable[0x6BE8]=25808;   // xian
   sortTable[0x6D80]=25809;   // xian
   sortTable[0x6F96]=25810;   // xian
   sortTable[0x7017]=25811;   // xian
   sortTable[0x7066]=25812;   // xian
   sortTable[0x70CD]=25813;   // xian
   sortTable[0x71C5]=25814;   // xian
   sortTable[0x72DD]=25815;   // xian
   sortTable[0x736B]=25816;   // xian
   sortTable[0x736E]=25817;   // xian
   sortTable[0x7381]=25818;   // xian
   sortTable[0x73D7]=25819;   // xian
   sortTable[0x7509]=25820;   // xian
   sortTable[0x7647]=25821;   // xian
   sortTable[0x764E]=25822;   // xian
   sortTable[0x77AF]=25823;   // xian
   sortTable[0x7BB2]=25824;   // xian
   sortTable[0x7DAB]=25825;   // xian
   sortTable[0x7E8E]=25826;   // xian
   sortTable[0x81D4]=25827;   // xian
   sortTable[0x82EE]=25828;   // xian
   sortTable[0x83A7]=25829;   // xian
   sortTable[0x859F]=25830;   // xian
   sortTable[0x861A]=25831;   // xian
   sortTable[0x86DD]=25832;   // xian
   sortTable[0x893C]=25833;   // xian
   sortTable[0x8973]=25834;   // xian
   sortTable[0x8AA2]=25835;   // xian
   sortTable[0x8AB8]=25836;   // xian
   sortTable[0x8D7B]=25837;   // xian
   sortTable[0x8E9A]=25838;   // xian
   sortTable[0x930E]=25839;   // xian
   sortTable[0x9341]=25840;   // xian
   sortTable[0x9466]=25841;   // xian
   sortTable[0x9665]=25842;   // xian
   sortTable[0x99A6]=25843;   // xian
   sortTable[0x9DB1]=25844;   // xian
   sortTable[0x9EB2]=25845;   // xian
   sortTable[0x60F3]=25846;   // xiang
   sortTable[0x8C61]=25847;   // xiang
   sortTable[0x5411]=25848;   // xiang
   sortTable[0x76F8]=25849;   // xiang
   sortTable[0x54CD]=25850;   // xiang
   sortTable[0x97FF]=25851;   // xiang
   sortTable[0x4E61]=25852;   // xiang
   sortTable[0x9109]=25853;   // xiang
   sortTable[0x9879]=25854;   // xiang
   sortTable[0x9805]=25855;   // xiang
   sortTable[0x50CF]=25856;   // xiang
   sortTable[0x9999]=25857;   // xiang
   sortTable[0x7BB1]=25858;   // xiang
   sortTable[0x8BE6]=25859;   // xiang
   sortTable[0x8A73]=25860;   // xiang
   sortTable[0x4EAB]=25861;   // xiang
   sortTable[0x5DF7]=25862;   // xiang
   sortTable[0x6A61]=25863;   // xiang
   sortTable[0x7965]=25864;   // xiang
   sortTable[0x53A2]=25865;   // xiang
   sortTable[0x5EC2]=25866;   // xiang
   sortTable[0x9576]=25867;   // xiang
   sortTable[0x9472]=25868;   // xiang
   sortTable[0x7FD4]=25869;   // xiang
   sortTable[0x8944]=25870;   // xiang
   sortTable[0x6E58]=25871;   // xiang
   sortTable[0x9977]=25872;   // xiang
   sortTable[0x98E8]=25873;   // xiang
   sortTable[0x9AA7]=25874;   // xiang
   sortTable[0x5EA0]=25875;   // xiang
   sortTable[0x8297]=25876;   // xiang
   sortTable[0x7F03]=25877;   // xiang
   sortTable[0x995F]=25878;   // xiang
   sortTable[0x8683]=25879;   // xiang
   sortTable[0x9C9E]=25880;   // xiang
   sortTable[0x8856]=25881;   // xiang
   sortTable[0x8459]=25882;   // xiang
   sortTable[0x9BD7]=25883;   // xiang
   sortTable[0x7A25]=25884;   // xiang
   sortTable[0x87D3]=25885;   // xiang
   sortTable[0x95C0]=25886;   // xiang
   sortTable[0x81B7]=25887;   // xiang
   sortTable[0x8801]=25888;   // xiang
   sortTable[0x7F3F]=25889;   // xiang
   sortTable[0x9297]=25890;   // xiang
   sortTable[0x9909]=25891;   // xiang
   sortTable[0x7DD7]=25892;   // xiang
   sortTable[0x8950]=25893;   // xiang
   sortTable[0x9284]=25894;   // xiang
   sortTable[0x9C4C]=25895;   // xiang
   sortTable[0x9E98]=25896;   // xiang
   sortTable[0x4EAF]=25897;   // xiang
   sortTable[0x4F6D]=25898;   // xiang
   sortTable[0x52E8]=25899;   // xiang
   sortTable[0x554C]=25900;   // xiang
   sortTable[0x56AE]=25901;   // xiang
   sortTable[0x5842]=25902;   // xiang
   sortTable[0x59E0]=25903;   // xiang
   sortTable[0x5D91]=25904;   // xiang
   sortTable[0x5FC0]=25905;   // xiang
   sortTable[0x6651]=25906;   // xiang
   sortTable[0x66CF]=25907;   // xiang
   sortTable[0x6819]=25908;   // xiang
   sortTable[0x697F]=25909;   // xiang
   sortTable[0x6B00]=25910;   // xiang
   sortTable[0x73E6]=25911;   // xiang
   sortTable[0x74D6]=25912;   // xiang
   sortTable[0x74E8]=25913;   // xiang
   sortTable[0x7D74]=25914;   // xiang
   sortTable[0x842B]=25915;   // xiang
   sortTable[0x858C]=25916;   // xiang
   sortTable[0x8DED]=25917;   // xiang
   sortTable[0x90F7]=25918;   // xiang
   sortTable[0x910A]=25919;   // xiang
   sortTable[0x9115]=25920;   // xiang
   sortTable[0x940C]=25921;   // xiang
   sortTable[0x9957]=25922;   // xiang
   sortTable[0x9A64]=25923;   // xiang
   sortTable[0x9B9D]=25924;   // xiang
   sortTable[0x9C5C]=25925;   // xiang
   sortTable[0x9C76]=25926;   // xiang
   sortTable[0x5C0F]=25927;   // xiao
   sortTable[0x7B11]=25928;   // xiao
   sortTable[0x6D88]=25929;   // xiao
   sortTable[0x6821]=25930;   // xiao
   sortTable[0x6548]=25931;   // xiao
   sortTable[0x9500]=25932;   // xiao
   sortTable[0x92B7]=25933;   // xiao
   sortTable[0x6653]=25934;   // xiao
   sortTable[0x66C9]=25935;   // xiao
   sortTable[0x8096]=25936;   // xiao
   sortTable[0x5BB5]=25937;   // xiao
   sortTable[0x5578]=25938;   // xiao
   sortTable[0x562F]=25939;   // xiao
   sortTable[0x54EE]=25940;   // xiao
   sortTable[0x785D]=25941;   // xiao
   sortTable[0x7BAB]=25942;   // xiao
   sortTable[0x7C2B]=25943;   // xiao
   sortTable[0x5B5D]=25944;   // xiao
   sortTable[0x8427]=25945;   // xiao
   sortTable[0x9704]=25946;   // xiao
   sortTable[0x9A81]=25947;   // xiao
   sortTable[0x56A3]=25948;   // xiao
   sortTable[0x6F47]=25949;   // xiao
   sortTable[0x67AD]=25950;   // xiao
   sortTable[0x900D]=25951;   // xiao
   sortTable[0x6DC6]=25952;   // xiao
   sortTable[0x7B71]=25953;   // xiao
   sortTable[0x9B48]=25954;   // xiao
   sortTable[0x7EE1]=25955;   // xiao
   sortTable[0x67B5]=25956;   // xiao
   sortTable[0x5D24]=25957;   // xiao
   sortTable[0x8653]=25958;   // xiao
   sortTable[0x54D3]=25959;   // xiao
   sortTable[0x7FDB]=25960;   // xiao
   sortTable[0x9E2E]=25961;   // xiao
   sortTable[0x8B0F]=25962;   // xiao
   sortTable[0x7BE0]=25963;   // xiao
   sortTable[0x81AE]=25964;   // xiao
   sortTable[0x9D1E]=25965;   // xiao
   sortTable[0x7B4A]=25966;   // xiao
   sortTable[0x87CF]=25967;   // xiao
   sortTable[0x9D35]=25968;   // xiao
   sortTable[0x7A99]=25969;   // xiao
   sortTable[0x8A68]=25970;   // xiao
   sortTable[0x7863]=25971;   // xiao
   sortTable[0x87C2]=25972;   // xiao
   sortTable[0x9AD0]=25973;   // xiao
   sortTable[0x7B7F]=25974;   // xiao
   sortTable[0x856D]=25975;   // xiao
   sortTable[0x8648]=25976;   // xiao
   sortTable[0x90E9]=25977;   // xiao
   sortTable[0x7C18]=25978;   // xiao
   sortTable[0x85C3]=25979;   // xiao
   sortTable[0x8828]=25980;   // xiao
   sortTable[0x8E03]=25981;   // xiao
   sortTable[0x9A4D]=25982;   // xiao
   sortTable[0x9AC7]=25983;   // xiao
   sortTable[0x4FBE]=25984;   // xiao
   sortTable[0x4FF2]=25985;   // xiao
   sortTable[0x509A]=25986;   // xiao
   sortTable[0x52B9]=25987;   // xiao
   sortTable[0x547A]=25988;   // xiao
   sortTable[0x54B2]=25989;   // xiao
   sortTable[0x560B]=25990;   // xiao
   sortTable[0x5610]=25991;   // xiao
   sortTable[0x5628]=25992;   // xiao
   sortTable[0x5635]=25993;   // xiao
   sortTable[0x56BB]=25994;   // xiao
   sortTable[0x56C2]=25995;   // xiao
   sortTable[0x5A4B]=25996;   // xiao
   sortTable[0x5BAF]=25997;   // xiao
   sortTable[0x5EA8]=25998;   // xiao
   sortTable[0x5F47]=25999;   // xiao
   sortTable[0x6077]=26000;   // xiao
   sortTable[0x61A2]=26001;   // xiao
   sortTable[0x63F1]=26002;   // xiao
   sortTable[0x6569]=26003;   // xiao
   sortTable[0x6585]=26004;   // xiao
   sortTable[0x6586]=26005;   // xiao
   sortTable[0x6681]=26006;   // xiao
   sortTable[0x689F]=26007;   // xiao
   sortTable[0x6AF9]=26008;   // xiao
   sortTable[0x6B4A]=26009;   // xiao
   sortTable[0x6B57]=26010;   // xiao
   sortTable[0x6BBD]=26011;   // xiao
   sortTable[0x6BCA]=26012;   // xiao
   sortTable[0x6D28]=26013;   // xiao
   sortTable[0x6D8D]=26014;   // xiao
   sortTable[0x6EE7]=26015;   // xiao
   sortTable[0x701F]=26016;   // xiao
   sortTable[0x7071]=26017;   // xiao
   sortTable[0x7072]=26018;   // xiao
   sortTable[0x7107]=26019;   // xiao
   sortTable[0x71BD]=26020;   // xiao
   sortTable[0x7307]=26021;   // xiao
   sortTable[0x7362]=26022;   // xiao
   sortTable[0x75DA]=26023;   // xiao
   sortTable[0x75DF]=26024;   // xiao
   sortTable[0x769B]=26025;   // xiao
   sortTable[0x76A2]=26026;   // xiao
   sortTable[0x7A58]=26027;   // xiao
   sortTable[0x7B05]=26028;   // xiao
   sortTable[0x7D83]=26029;   // xiao
   sortTable[0x8437]=26030;   // xiao
   sortTable[0x87F0]=26031;   // xiao
   sortTable[0x8A24]=26032;   // xiao
   sortTable[0x8A9F]=26033;   // xiao
   sortTable[0x8AB5]=26034;   // xiao
   sortTable[0x97A9]=26035;   // xiao
   sortTable[0x4E9B]=26036;   // xie
   sortTable[0x5199]=26037;   // xie
   sortTable[0x5BEB]=26038;   // xie
   sortTable[0x978B]=26039;   // xie
   sortTable[0x8C22]=26040;   // xie
   sortTable[0x8B1D]=26041;   // xie
   sortTable[0x68B0]=26042;   // xie
   sortTable[0x534F]=26043;   // xie
   sortTable[0x5354]=26044;   // xie
   sortTable[0x659C]=26045;   // xie
   sortTable[0x6B47]=26046;   // xie
   sortTable[0x80C1]=26047;   // xie
   sortTable[0x8105]=26048;   // xie
   sortTable[0x5378]=26049;   // xie
   sortTable[0x643A]=26050;   // xie
   sortTable[0x651C]=26051;   // xie
   sortTable[0x631F]=26052;   // xie
   sortTable[0x633E]=26053;   // xie
   sortTable[0x6CC4]=26054;   // xie
   sortTable[0x5C51]=26055;   // xie
   sortTable[0x90AA]=26056;   // xie
   sortTable[0x8C10]=26057;   // xie
   sortTable[0x61C8]=26058;   // xie
   sortTable[0x6CFB]=26059;   // xie
   sortTable[0x5055]=26060;   // xie
   sortTable[0x87F9]=26061;   // xie
   sortTable[0x4EB5]=26062;   // xie
   sortTable[0x71EE]=26063;   // xie
   sortTable[0x69AD]=26064;   // xie
   sortTable[0x52F0]=26065;   // xie
   sortTable[0x874E]=26066;   // xie
   sortTable[0x6E2B]=26067;   // xie
   sortTable[0x7F2C]=26068;   // xie
   sortTable[0x6954]=26069;   // xie
   sortTable[0x736C]=26070;   // xie
   sortTable[0x9082]=26071;   // xie
   sortTable[0x5EE8]=26072;   // xie
   sortTable[0x64B7]=26073;   // xie
   sortTable[0x698D]=26074;   // xie
   sortTable[0x7EC1]=26075;   // xie
   sortTable[0x79BC]=26076;   // xie
   sortTable[0x8E9E]=26077;   // xie
   sortTable[0x85A4]=26078;   // xie
   sortTable[0x7023]=26079;   // xie
   sortTable[0x818E]=26080;   // xie
   sortTable[0x8B97]=26081;   // xie
   sortTable[0x7DE4]=26082;   // xie
   sortTable[0x9FA4]=26083;   // xie
   sortTable[0x7D4F]=26084;   // xie
   sortTable[0x99F4]=26085;   // xie
   sortTable[0x887A]=26086;   // xie
   sortTable[0x97A2]=26087;   // xie
   sortTable[0x97F0]=26088;   // xie
   sortTable[0x7944]=26089;   // xie
   sortTable[0x85DB]=26090;   // xie
   sortTable[0x8909]=26091;   // xie
   sortTable[0x880F]=26092;   // xie
   sortTable[0x85A2]=26093;   // xie
   sortTable[0x880D]=26094;   // xie
   sortTable[0x7D8A]=26095;   // xie
   sortTable[0x7F37]=26096;   // xie
   sortTable[0x7FD3]=26097;   // xie
   sortTable[0x9F58]=26098;   // xie
   sortTable[0x7D32]=26099;   // xie
   sortTable[0x7E72]=26100;   // xie
   sortTable[0x9F5B]=26101;   // xie
   sortTable[0x8762]=26102;   // xie
   sortTable[0x893B]=26103;   // xie
   sortTable[0x896D]=26104;   // xie
   sortTable[0x8AE7]=26105;   // xie
   sortTable[0x97B5]=26106;   // xie
   sortTable[0x9F42]=26107;   // xie
   sortTable[0x4F33]=26108;   // xie
   sortTable[0x505E]=26109;   // xie
   sortTable[0x5070]=26110;   // xie
   sortTable[0x50C1]=26111;   // xie
   sortTable[0x51A9]=26112;   // xie
   sortTable[0x52A6]=26113;   // xie
   sortTable[0x5368]=26114;   // xie
   sortTable[0x55CB]=26115;   // xie
   sortTable[0x5667]=26116;   // xie
   sortTable[0x57A5]=26117;   // xie
   sortTable[0x586E]=26118;   // xie
   sortTable[0x5911]=26119;   // xie
   sortTable[0x594A]=26120;   // xie
   sortTable[0x5A0E]=26121;   // xie
   sortTable[0x5A9F]=26122;   // xie
   sortTable[0x5C53]=26123;   // xie
   sortTable[0x5C5F]=26124;   // xie
   sortTable[0x5C67]=26125;   // xie
   sortTable[0x5CEB]=26126;   // xie
   sortTable[0x5DB0]=26127;   // xie
   sortTable[0x5FA2]=26128;   // xie
   sortTable[0x604A]=26129;   // xie
   sortTable[0x6136]=26130;   // xie
   sortTable[0x62F9]=26131;   // xie
   sortTable[0x63F3]=26132;   // xie
   sortTable[0x64D5]=26133;   // xie
   sortTable[0x64F7]=26134;   // xie
   sortTable[0x65EA]=26135;   // xie
   sortTable[0x66AC]=26136;   // xie
   sortTable[0x6D29]=26137;   // xie
   sortTable[0x6FA5]=26138;   // xie
   sortTable[0x7009]=26139;   // xie
   sortTable[0x707A]=26140;   // xie
   sortTable[0x70A7]=26141;   // xie
   sortTable[0x70F2]=26142;   // xie
   sortTable[0x710E]=26143;   // xie
   sortTable[0x7181]=26144;   // xie
   sortTable[0x71F2]=26145;   // xie
   sortTable[0x7215]=26146;   // xie
   sortTable[0x7332]=26147;   // xie
   sortTable[0x744E]=26148;   // xie
   sortTable[0x7CCF]=26149;   // xie
   sortTable[0x7D6C]=26150;   // xie
   sortTable[0x7DF3]=26151;   // xie
   sortTable[0x7E88]=26152;   // xie
   sortTable[0x8107]=26153;   // xie
   sortTable[0x810B]=26154;   // xie
   sortTable[0x9821]=26155;   // xie
   sortTable[0x9F65]=26156;   // xie
   sortTable[0x5FC3]=26157;   // xin
   sortTable[0x65B0]=26158;   // xin
   sortTable[0x4FE1]=26159;   // xin
   sortTable[0x8F9B]=26160;   // xin
   sortTable[0x6B23]=26161;   // xin
   sortTable[0x85AA]=26162;   // xin
   sortTable[0x82AF]=26163;   // xin
   sortTable[0x950C]=26164;   // xin
   sortTable[0x92C5]=26165;   // xin
   sortTable[0x8845]=26166;   // xin
   sortTable[0x820B]=26167;   // xin
   sortTable[0x99A8]=26168;   // xin
   sortTable[0x5FFB]=26169;   // xin
   sortTable[0x6B46]=26170;   // xin
   sortTable[0x946B]=26171;   // xin
   sortTable[0x6615]=26172;   // xin
   sortTable[0x56DF]=26173;   // xin
   sortTable[0x8A22]=26174;   // xin
   sortTable[0x8ED0]=26175;   // xin
   sortTable[0x812A]=26176;   // xin
   sortTable[0x90A4]=26177;   // xin
   sortTable[0x91C1]=26178;   // xin
   sortTable[0x9856]=26179;   // xin
   sortTable[0x4F08]=26180;   // xin
   sortTable[0x4F29]=26181;   // xin
   sortTable[0x4FFD]=26182;   // xin
   sortTable[0x567A]=26183;   // xin
   sortTable[0x59A1]=26184;   // xin
   sortTable[0x5B1C]=26185;   // xin
   sortTable[0x5B5E]=26186;   // xin
   sortTable[0x5EDE]=26187;   // xin
   sortTable[0x5FC4]=26188;   // xin
   sortTable[0x60DE]=26189;   // xin
   sortTable[0x677A]=26190;   // xin
   sortTable[0x6794]=26191;   // xin
   sortTable[0x7098]=26192;   // xin
   sortTable[0x712E]=26193;   // xin
   sortTable[0x7161]=26194;   // xin
   sortTable[0x76FA]=26195;   // xin
   sortTable[0x8951]=26196;   // xin
   sortTable[0x8A2B]=26197;   // xin
   sortTable[0x920A]=26198;   // xin
   sortTable[0x9414]=26199;   // xin
   sortTable[0x9620]=26200;   // xin
   sortTable[0x99AB]=26201;   // xin
   sortTable[0x99B8]=26202;   // xin
   sortTable[0x884C]=26203;   // xing
   sortTable[0x6027]=26204;   // xing
   sortTable[0x5F62]=26205;   // xing
   sortTable[0x661F]=26206;   // xing
   sortTable[0x5174]=26207;   // xing
   sortTable[0x8208]=26208;   // xing
   sortTable[0x578B]=26209;   // xing
   sortTable[0x5E78]=26210;   // xing
   sortTable[0x59D3]=26211;   // xing
   sortTable[0x9192]=26212;   // xing
   sortTable[0x5211]=26213;   // xing
   sortTable[0x7329]=26214;   // xing
   sortTable[0x8165]=26215;   // xing
   sortTable[0x60FA]=26216;   // xing
   sortTable[0x674F]=26217;   // xing
   sortTable[0x90A2]=26218;   // xing
   sortTable[0x8365]=26219;   // xing
   sortTable[0x60BB]=26220;   // xing
   sortTable[0x784E]=26221;   // xing
   sortTable[0x9649]=26222;   // xing
   sortTable[0x8347]=26223;   // xing
   sortTable[0x94CF]=26224;   // xing
   sortTable[0x64E4]=26225;   // xing
   sortTable[0x9A8D]=26226;   // xing
   sortTable[0x9498]=26227;   // xing
   sortTable[0x9276]=26228;   // xing
   sortTable[0x9A02]=26229;   // xing
   sortTable[0x7BB5]=26230;   // xing
   sortTable[0x935F]=26231;   // xing
   sortTable[0x7BC2]=26232;   // xing
   sortTable[0x8395]=26233;   // xing
   sortTable[0x86F5]=26234;   // xing
   sortTable[0x81D6]=26235;   // xing
   sortTable[0x89F2]=26236;   // xing
   sortTable[0x9203]=26237;   // xing
   sortTable[0x9292]=26238;   // xing
   sortTable[0x4F80]=26239;   // xing
   sortTable[0x5016]=26240;   // xing
   sortTable[0x54D8]=26241;   // xing
   sortTable[0x57B6]=26242;   // xing
   sortTable[0x5A19]=26243;   // xing
   sortTable[0x5A5E]=26244;   // xing
   sortTable[0x5B39]=26245;   // xing
   sortTable[0x66D0]=26246;   // xing
   sortTable[0x6D10]=26247;   // xing
   sortTable[0x6DAC]=26248;   // xing
   sortTable[0x6ECE]=26249;   // xing
   sortTable[0x714B]=26250;   // xing
   sortTable[0x7446]=26251;   // xing
   sortTable[0x76A8]=26252;   // xing
   sortTable[0x7772]=26253;   // xing
   sortTable[0x7DC8]=26254;   // xing
   sortTable[0x88C4]=26255;   // xing
   sortTable[0x89EA]=26256;   // xing
   sortTable[0x8B03]=26257;   // xing
   sortTable[0x90C9]=26258;   // xing
   sortTable[0x92DE]=26259;   // xing
   sortTable[0x9658]=26260;   // xing
   sortTable[0x9B8F]=26261;   // xing
   sortTable[0x9BF9]=26262;   // xing
   sortTable[0x96C4]=26263;   // xiong
   sortTable[0x80F8]=26264;   // xiong
   sortTable[0x5144]=26265;   // xiong
   sortTable[0x51F6]=26266;   // xiong
   sortTable[0x718A]=26267;   // xiong
   sortTable[0x6C79]=26268;   // xiong
   sortTable[0x6D36]=26269;   // xiong
   sortTable[0x5308]=26270;   // xiong
   sortTable[0x8BC7]=26271;   // xiong
   sortTable[0x8A7E]=26272;   // xiong
   sortTable[0x8BBB]=26273;   // xiong
   sortTable[0x8CEF]=26274;   // xiong
   sortTable[0x8A57]=26275;   // xiong
   sortTable[0x5147]=26276;   // xiong
   sortTable[0x54C5]=26277;   // xiong
   sortTable[0x5910]=26278;   // xiong
   sortTable[0x5FF7]=26279;   // xiong
   sortTable[0x605F]=26280;   // xiong
   sortTable[0x657B]=26281;   // xiong
   sortTable[0x7138]=26282;   // xiong
   sortTable[0x713D]=26283;   // xiong
   sortTable[0x80F7]=26284;   // xiong
   sortTable[0x8A29]=26285;   // xiong
   sortTable[0x4FEE]=26286;   // xiu
   sortTable[0x4F11]=26287;   // xiu
   sortTable[0x8896]=26288;   // xiu
   sortTable[0x79C0]=26289;   // xiu
   sortTable[0x673D]=26290;   // xiu
   sortTable[0x7EE3]=26291;   // xiu
   sortTable[0x9508]=26292;   // xiu
   sortTable[0x93FD]=26293;   // xiu
   sortTable[0x7E61]=26294;   // xiu
   sortTable[0x55C5]=26295;   // xiu
   sortTable[0x7F9E]=26296;   // xiu
   sortTable[0x5CAB]=26297;   // xiu
   sortTable[0x9990]=26298;   // xiu
   sortTable[0x5EA5]=26299;   // xiu
   sortTable[0x8129]=26300;   // xiu
   sortTable[0x9E3A]=26301;   // xiu
   sortTable[0x54BB]=26302;   // xiu
   sortTable[0x6EB4]=26303;   // xiu
   sortTable[0x9AF9]=26304;   // xiu
   sortTable[0x8C85]=26305;   // xiu
   sortTable[0x890E]=26306;   // xiu
   sortTable[0x8119]=26307;   // xiu
   sortTable[0x9AE4]=26308;   // xiu
   sortTable[0x7E4D]=26309;   // xiu
   sortTable[0x8791]=26310;   // xiu
   sortTable[0x7D87]=26311;   // xiu
   sortTable[0x9948]=26312;   // xiu
   sortTable[0x9D42]=26313;   // xiu
   sortTable[0x7CD4]=26314;   // xiu
   sortTable[0x890F]=26315;   // xiu
   sortTable[0x9F45]=26316;   // xiu
   sortTable[0x82EC]=26317;   // xiu
   sortTable[0x929D]=26318;   // xiu
   sortTable[0x4FE2]=26319;   // xiu
   sortTable[0x5CC0]=26320;   // xiu
   sortTable[0x6A07]=26321;   // xiu
   sortTable[0x6EEB]=26322;   // xiu
   sortTable[0x70CB]=26323;   // xiu
   sortTable[0x70CC]=26324;   // xiu
   sortTable[0x73DB]=26325;   // xiu
   sortTable[0x7407]=26326;   // xiu
   sortTable[0x7493]=26327;   // xiu
   sortTable[0x81F9]=26328;   // xiu
   sortTable[0x92B9]=26329;   // xiu
   sortTable[0x9380]=26330;   // xiu
   sortTable[0x93C5]=26331;   // xiu
   sortTable[0x93E5]=26332;   // xiu
   sortTable[0x98CD]=26333;   // xiu
   sortTable[0x9BB4]=26334;   // xiu
   sortTable[0x9C43]=26335;   // xiu
   sortTable[0x8BB8]=26336;   // xu
   sortTable[0x8A31]=26337;   // xu
   sortTable[0x9700]=26338;   // xu
   sortTable[0x987B]=26339;   // xu
   sortTable[0x9808]=26340;   // xu
   sortTable[0x7EED]=26341;   // xu
   sortTable[0x7E8C]=26342;   // xu
   sortTable[0x5E8F]=26343;   // xu
   sortTable[0x7EEA]=26344;   // xu
   sortTable[0x7DD2]=26345;   // xu
   sortTable[0x865A]=26346;   // xu
   sortTable[0x865B]=26347;   // xu
   sortTable[0x5F90]=26348;   // xu
   sortTable[0x5401]=26349;   // xu
   sortTable[0x53D9]=26350;   // xu
   sortTable[0x6558]=26351;   // xu
   sortTable[0x84C4]=26352;   // xu
   sortTable[0x5618]=26353;   // xu
   sortTable[0x5653]=26354;   // xu
   sortTable[0x620C]=26355;   // xu
   sortTable[0x5A7F]=26356;   // xu
   sortTable[0x6064]=26357;   // xu
   sortTable[0x65ED]=26358;   // xu
   sortTable[0x7D6E]=26359;   // xu
   sortTable[0x80E5]=26360;   // xu
   sortTable[0x589F]=26361;   // xu
   sortTable[0x8BE9]=26362;   // xu
   sortTable[0x987C]=26363;   // xu
   sortTable[0x6E86]=26364;   // xu
   sortTable[0x84FF]=26365;   // xu
   sortTable[0x52D6]=26366;   // xu
   sortTable[0x7166]=26367;   // xu
   sortTable[0x6829]=26368;   // xu
   sortTable[0x76F1]=26369;   // xu
   sortTable[0x9157]=26370;   // xu
   sortTable[0x8C1E]=26371;   // xu
   sortTable[0x7E7B]=26372;   // xu
   sortTable[0x6D2B]=26373;   // xu
   sortTable[0x7CC8]=26374;   // xu
   sortTable[0x9B46]=26375;   // xu
   sortTable[0x9191]=26376;   // xu
   sortTable[0x8A0F]=26377;   // xu
   sortTable[0x8A39]=26378;   // xu
   sortTable[0x85DA]=26379;   // xu
   sortTable[0x8053]=26380;   // xu
   sortTable[0x980A]=26381;   // xu
   sortTable[0x8ADD]=26382;   // xu
   sortTable[0x9C6E]=26383;   // xu
   sortTable[0x9126]=26384;   // xu
   sortTable[0x85C7]=26385;   // xu
   sortTable[0x9B56]=26386;   // xu
   sortTable[0x8751]=26387;   // xu
   sortTable[0x8A61]=26388;   // xu
   sortTable[0x8657]=26389;   // xu
   sortTable[0x76E8]=26390;   // xu
   sortTable[0x82A7]=26391;   // xu
   sortTable[0x8B43]=26392;   // xu
   sortTable[0x928A]=26393;   // xu
   sortTable[0x9A49]=26394;   // xu
   sortTable[0x76E2]=26395;   // xu
   sortTable[0x7A30]=26396;   // xu
   sortTable[0x7A38]=26397;   // xu
   sortTable[0x7E03]=26398;   // xu
   sortTable[0x805F]=26399;   // xu
   sortTable[0x9450]=26400;   // xu
   sortTable[0x9B1A]=26401;   // xu
   sortTable[0x9B63]=26402;   // xu
   sortTable[0x7D9A]=26403;   // xu
   sortTable[0x84A3]=26404;   // xu
   sortTable[0x8566]=26405;   // xu
   sortTable[0x4F35]=26406;   // xu
   sortTable[0x4F90]=26407;   // xu
   sortTable[0x4FC6]=26408;   // xu
   sortTable[0x5066]=26409;   // xu
   sortTable[0x5194]=26410;   // xu
   sortTable[0x52D7]=26411;   // xu
   sortTable[0x5379]=26412;   // xu
   sortTable[0x5474]=26413;   // xu
   sortTable[0x55A3]=26414;   // xu
   sortTable[0x57BF]=26415;   // xu
   sortTable[0x58FB]=26416;   // xu
   sortTable[0x59C1]=26417;   // xu
   sortTable[0x5AAD]=26418;   // xu
   sortTable[0x5B03]=26419;   // xu
   sortTable[0x5E41]=26420;   // xu
   sortTable[0x6034]=26421;   // xu
   sortTable[0x6149]=26422;   // xu
   sortTable[0x63DF]=26423;   // xu
   sortTable[0x654D]=26424;   // xu
   sortTable[0x65F4]=26425;   // xu
   sortTable[0x662B]=26426;   // xu
   sortTable[0x6647]=26427;   // xu
   sortTable[0x668A]=26428;   // xu
   sortTable[0x6702]=26429;   // xu
   sortTable[0x6948]=26430;   // xu
   sortTable[0x69D2]=26431;   // xu
   sortTable[0x6B28]=26432;   // xu
   sortTable[0x6B30]=26433;   // xu
   sortTable[0x6B54]=26434;   // xu
   sortTable[0x6B88]=26435;   // xu
   sortTable[0x6C7F]=26436;   // xu
   sortTable[0x6C80]=26437;   // xu
   sortTable[0x6E51]=26438;   // xu
   sortTable[0x6F35]=26439;   // xu
   sortTable[0x6F4A]=26440;   // xu
   sortTable[0x70C5]=26441;   // xu
   sortTable[0x70FC]=26442;   // xu
   sortTable[0x735D]=26443;   // xu
   sortTable[0x73DD]=26444;   // xu
   sortTable[0x73EC]=26445;   // xu
   sortTable[0x759E]=26446;   // xu
   sortTable[0x7781]=26447;   // xu
   sortTable[0x77B2]=26448;   // xu
   sortTable[0x7AA2]=26449;   // xu
   sortTable[0x7DD6]=26450;   // xu
   sortTable[0x88C7]=26451;   // xu
   sortTable[0x8CC9]=26452;   // xu
   sortTable[0x9009]=26453;   // xuan
   sortTable[0x9078]=26454;   // xuan
   sortTable[0x5BA3]=26455;   // xuan
   sortTable[0x65CB]=26456;   // xuan
   sortTable[0x60AC]=26457;   // xuan
   sortTable[0x61F8]=26458;   // xuan
   sortTable[0x6F29]=26459;   // xuan
   sortTable[0x7EDA]=26460;   // xuan
   sortTable[0x7D62]=26461;   // xuan
   sortTable[0x6684]=26462;   // xuan
   sortTable[0x7384]=26463;   // xuan
   sortTable[0x8F69]=26464;   // xuan
   sortTable[0x7487]=26465;   // xuan
   sortTable[0x55A7]=26466;   // xuan
   sortTable[0x7729]=26467;   // xuan
   sortTable[0x6E32]=26468;   // xuan
   sortTable[0x8C16]=26469;   // xuan
   sortTable[0x70AB]=26470;   // xuan
   sortTable[0x714A]=26471;   // xuan
   sortTable[0x94C9]=26472;   // xuan
   sortTable[0x8431]=26473;   // xuan
   sortTable[0x7663]=26474;   // xuan
   sortTable[0x6966]=26475;   // xuan
   sortTable[0x6CEB]=26476;   // xuan
   sortTable[0x5107]=26477;   // xuan
   sortTable[0x63CE]=26478;   // xuan
   sortTable[0x7FFE]=26479;   // xuan
   sortTable[0x8852]=26480;   // xuan
   sortTable[0x955F]=26481;   // xuan
   sortTable[0x8AE0]=26482;   // xuan
   sortTable[0x88A8]=26483;   // xuan
   sortTable[0x92D7]=26484;   // xuan
   sortTable[0x7734]=26485;   // xuan
   sortTable[0x8701]=26486;   // xuan
   sortTable[0x857F]=26487;   // xuan
   sortTable[0x8B5E]=26488;   // xuan
   sortTable[0x78B9]=26489;   // xuan
   sortTable[0x75C3]=26490;   // xuan
   sortTable[0x8ED2]=26491;   // xuan
   sortTable[0x7FE7]=26492;   // xuan
   sortTable[0x9799]=26493;   // xuan
   sortTable[0x7BAE]=26494;   // xuan
   sortTable[0x77CE]=26495;   // xuan
   sortTable[0x7E3C]=26496;   // xuan
   sortTable[0x8610]=26497;   // xuan
   sortTable[0x8809]=26498;   // xuan
   sortTable[0x9848]=26499;   // xuan
   sortTable[0x99FD]=26500;   // xuan
   sortTable[0x84D2]=26501;   // xuan
   sortTable[0x8D19]=26502;   // xuan
   sortTable[0x93C7]=26503;   // xuan
   sortTable[0x777B]=26504;   // xuan
   sortTable[0x79A4]=26505;   // xuan
   sortTable[0x8519]=26506;   // xuan
   sortTable[0x8756]=26507;   // xuan
   sortTable[0x5405]=26508;   // xuan
   sortTable[0x54BA]=26509;   // xuan
   sortTable[0x5847]=26510;   // xuan
   sortTable[0x5A97]=26511;   // xuan
   sortTable[0x5AD9]=26512;   // xuan
   sortTable[0x5F32]=26513;   // xuan
   sortTable[0x6030]=26514;   // xuan
   sortTable[0x6103]=26515;   // xuan
   sortTable[0x610B]=26516;   // xuan
   sortTable[0x61C1]=26517;   // xuan
   sortTable[0x660D]=26518;   // xuan
   sortTable[0x6621]=26519;   // xuan
   sortTable[0x6645]=26520;   // xuan
   sortTable[0x66B6]=26521;   // xuan
   sortTable[0x688B]=26522;   // xuan
   sortTable[0x6965]=26523;   // xuan
   sortTable[0x6A88]=26524;   // xuan
   sortTable[0x70DC]=26525;   // xuan
   sortTable[0x73B9]=26526;   // xuan
   sortTable[0x7401]=26527;   // xuan
   sortTable[0x7404]=26528;   // xuan
   sortTable[0x7444]=26529;   // xuan
   sortTable[0x74BF]=26530;   // xuan
   sortTable[0x766C]=26531;   // xuan
   sortTable[0x7E07]=26532;   // xuan
   sortTable[0x7E4F]=26533;   // xuan
   sortTable[0x8432]=26534;   // xuan
   sortTable[0x85FC]=26535;   // xuan
   sortTable[0x8AFC]=26536;   // xuan
   sortTable[0x8B82]=26537;   // xuan
   sortTable[0x9249]=26538;   // xuan
   sortTable[0x9379]=26539;   // xuan
   sortTable[0x98B4]=26540;   // xuan
   sortTable[0x9C1A]=26541;   // xuan
   sortTable[0x5B66]=26542;   // xue
   sortTable[0x5B78]=26543;   // xue
   sortTable[0x96EA]=26544;   // xue
   sortTable[0x8840]=26545;   // xue
   sortTable[0x524A]=26546;   // xue
   sortTable[0x9774]=26547;   // xue
   sortTable[0x859B]=26548;   // xue
   sortTable[0x7A74]=26549;   // xue
   sortTable[0x8C11]=26550;   // xue
   sortTable[0x8E05]=26551;   // xue
   sortTable[0x6CF6]=26552;   // xue
   sortTable[0x9CD5]=26553;   // xue
   sortTable[0x89F7]=26554;   // xue
   sortTable[0x97BE]=26555;   // xue
   sortTable[0x9E34]=26556;   // xue
   sortTable[0x8895]=26557;   // xue
   sortTable[0x9DFD]=26558;   // xue
   sortTable[0x825D]=26559;   // xue
   sortTable[0x8313]=26560;   // xue
   sortTable[0x81A4]=26561;   // xue
   sortTable[0x8D90]=26562;   // xue
   sortTable[0x4E74]=26563;   // xue
   sortTable[0x5437]=26564;   // xue
   sortTable[0x5779]=26565;   // xue
   sortTable[0x58C6]=26566;   // xue
   sortTable[0x5CA4]=26567;   // xue
   sortTable[0x5CC3]=26568;   // xue
   sortTable[0x5DA8]=26569;   // xue
   sortTable[0x6588]=26570;   // xue
   sortTable[0x6856]=26571;   // xue
   sortTable[0x6A30]=26572;   // xue
   sortTable[0x6FA9]=26573;   // xue
   sortTable[0x7025]=26574;   // xue
   sortTable[0x71E2]=26575;   // xue
   sortTable[0x72D8]=26576;   // xue
   sortTable[0x75B6]=26577;   // xue
   sortTable[0x8486]=26578;   // xue
   sortTable[0x8B14]=26579;   // xue
   sortTable[0x8F4C]=26580;   // xue
   sortTable[0x8FA5]=26581;   // xue
   sortTable[0x8FAA]=26582;   // xue
   sortTable[0x96E4]=26583;   // xue
   sortTable[0x9C48]=26584;   // xue
   sortTable[0x8FC5]=26585;   // xun
   sortTable[0x8BAF]=26586;   // xun
   sortTable[0x8A0A]=26587;   // xun
   sortTable[0x5BFB]=26588;   // xun
   sortTable[0x5C0B]=26589;   // xun
   sortTable[0x8BAD]=26590;   // xun
   sortTable[0x8A13]=26591;   // xun
   sortTable[0x5FAA]=26592;   // xun
   sortTable[0x65EC]=26593;   // xun
   sortTable[0x8BE2]=26594;   // xun
   sortTable[0x8A62]=26595;   // xun
   sortTable[0x718F]=26596;   // xun
   sortTable[0x5DE1]=26597;   // xun
   sortTable[0x6C5B]=26598;   // xun
   sortTable[0x900A]=26599;   // xun
   sortTable[0x905C]=26600;   // xun
   sortTable[0x52CB]=26601;   // xun
   sortTable[0x8368]=26602;   // xun
   sortTable[0x9A6F]=26603;   // xun
   sortTable[0x8340]=26604;   // xun
   sortTable[0x5F87]=26605;   // xun
   sortTable[0x6B89]=26606;   // xun
   sortTable[0x85B0]=26607;   // xun
   sortTable[0x6D54]=26608;   // xun
   sortTable[0x6042]=26609;   // xun
   sortTable[0x91BA]=26610;   // xun
   sortTable[0x66DB]=26611;   // xun
   sortTable[0x6D35]=26612;   // xun
   sortTable[0x5DFD]=26613;   // xun
   sortTable[0x5CCB]=26614;   // xun
   sortTable[0x7AA8]=26615;   // xun
   sortTable[0x736F]=26616;   // xun
   sortTable[0x9129]=26617;   // xun
   sortTable[0x57D9]=26618;   // xun
   sortTable[0x7E81]=26619;   // xun
   sortTable[0x9C9F]=26620;   // xun
   sortTable[0x8548]=26621;   // xun
   sortTable[0x7D03]=26622;   // xun
   sortTable[0x8A19]=26623;   // xun
   sortTable[0x81D0]=26624;   // xun
   sortTable[0x9D55]=26625;   // xun
   sortTable[0x77C4]=26626;   // xun
   sortTable[0x9868]=26627;   // xun
   sortTable[0x99E8]=26628;   // xun
   sortTable[0x7A04]=26629;   // xun
   sortTable[0x87F3]=26630;   // xun
   sortTable[0x99B4]=26631;   // xun
   sortTable[0x9C4F]=26632;   // xun
   sortTable[0x4F28]=26633;   // xun
   sortTable[0x4F9A]=26634;   // xun
   sortTable[0x5071]=26635;   // xun
   sortTable[0x52DB]=26636;   // xun
   sortTable[0x52F2]=26637;   // xun
   sortTable[0x52F3]=26638;   // xun
   sortTable[0x5342]=26639;   // xun
   sortTable[0x5640]=26640;   // xun
   sortTable[0x565A]=26641;   // xun
   sortTable[0x5691]=26642;   // xun
   sortTable[0x5743]=26643;   // xun
   sortTable[0x5864]=26644;   // xun
   sortTable[0x58CE]=26645;   // xun
   sortTable[0x58E6]=26646;   // xun
   sortTable[0x595E]=26647;   // xun
   sortTable[0x5DFA]=26648;   // xun
   sortTable[0x5EF5]=26649;   // xun
   sortTable[0x613B]=26650;   // xun
   sortTable[0x63D7]=26651;   // xun
   sortTable[0x6533]=26652;   // xun
   sortTable[0x674A]=26653;   // xun
   sortTable[0x6812]=26654;   // xun
   sortTable[0x686A]=26655;   // xun
   sortTable[0x69C6]=26656;   // xun
   sortTable[0x6A33]=26657;   // xun
   sortTable[0x6BBE]=26658;   // xun
   sortTable[0x6BE5]=26659;   // xun
   sortTable[0x6F43]=26660;   // xun
   sortTable[0x6F60]=26661;   // xun
   sortTable[0x6F6F]=26662;   // xun
   sortTable[0x7065]=26663;   // xun
   sortTable[0x7104]=26664;   // xun
   sortTable[0x71D6]=26665;   // xun
   sortTable[0x71FB]=26666;   // xun
   sortTable[0x720B]=26667;   // xun
   sortTable[0x72E5]=26668;   // xun
   sortTable[0x73E3]=26669;   // xun
   sortTable[0x7495]=26670;   // xun
   sortTable[0x7543]=26671;   // xun
   sortTable[0x8512]=26672;   // xun
   sortTable[0x85AB]=26673;   // xun
   sortTable[0x860D]=26674;   // xun
   sortTable[0x8CD0]=26675;   // xun
   sortTable[0x8FFF]=26676;   // xun
   sortTable[0x9442]=26677;   // xun
   sortTable[0x9C58]=26678;   // xun
   sortTable[0x5440]=27136;   // ya
   sortTable[0x538B]=27137;   // ya
   sortTable[0x58D3]=27138;   // ya
   sortTable[0x7259]=27139;   // ya
   sortTable[0x9E26]=27140;   // ya
   sortTable[0x9D09]=27141;   // ya
   sortTable[0x4E2B]=27142;   // ya
   sortTable[0x5D16]=27143;   // ya
   sortTable[0x9E2D]=27144;   // ya
   sortTable[0x9D28]=27145;   // ya
   sortTable[0x62BC]=27146;   // ya
   sortTable[0x8BB6]=27147;   // ya
   sortTable[0x8A1D]=27148;   // ya
   sortTable[0x82BD]=27149;   // ya
   sortTable[0x4E9A]=27150;   // ya
   sortTable[0x4E9E]=27151;   // ya
   sortTable[0x8F67]=27152;   // ya
   sortTable[0x8ECB]=27153;   // ya
   sortTable[0x8859]=27154;   // ya
   sortTable[0x869C]=27155;   // ya
   sortTable[0x54D1]=27156;   // ya
   sortTable[0x555E]=27157;   // ya
   sortTable[0x96C5]=27158;   // ya
   sortTable[0x6DAF]=27159;   // ya
   sortTable[0x5A05]=27160;   // ya
   sortTable[0x4F22]=27161;   // ya
   sortTable[0x8FD3]=27162;   // ya
   sortTable[0x6C29]=27163;   // ya
   sortTable[0x740A]=27164;   // ya
   sortTable[0x7811]=27165;   // ya
   sortTable[0x5416]=27166;   // ya
   sortTable[0x6860]=27167;   // ya
   sortTable[0x775A]=27168;   // ya
   sortTable[0x57AD]=27169;   // ya
   sortTable[0x75D6]=27170;   // ya
   sortTable[0x63E0]=27171;   // ya
   sortTable[0x9D76]=27172;   // ya
   sortTable[0x5C88]=27173;   // ya
   sortTable[0x9F7E]=27174;   // ya
   sortTable[0x94D4]=27175;   // ya
   sortTable[0x7A0F]=27176;   // ya
   sortTable[0x930F]=27177;   // ya
   sortTable[0x7AAB]=27178;   // ya
   sortTable[0x9F56]=27179;   // ya
   sortTable[0x897E]=27180;   // ya
   sortTable[0x8050]=27181;   // ya
   sortTable[0x8565]=27182;   // ya
   sortTable[0x4E5B]=27183;   // ya
   sortTable[0x4E9C]=27184;   // ya
   sortTable[0x4FF9]=27185;   // ya
   sortTable[0x529C]=27186;   // ya
   sortTable[0x538A]=27187;   // ya
   sortTable[0x5391]=27188;   // ya
   sortTable[0x5393]=27189;   // ya
   sortTable[0x5516]=27190;   // ya
   sortTable[0x5714]=27191;   // ya
   sortTable[0x5720]=27192;   // ya
   sortTable[0x5727]=27193;   // ya
   sortTable[0x57E1]=27194;   // ya
   sortTable[0x5810]=27195;   // ya
   sortTable[0x5A6D]=27196;   // ya
   sortTable[0x5B72]=27197;   // ya
   sortTable[0x5D15]=27198;   // ya
   sortTable[0x5E8C]=27199;   // ya
   sortTable[0x5E98]=27200;   // ya
   sortTable[0x631C]=27201;   // ya
   sortTable[0x6397]=27202;   // ya
   sortTable[0x6792]=27203;   // ya
   sortTable[0x690F]=27204;   // ya
   sortTable[0x6C2C]=27205;   // ya
   sortTable[0x6F04]=27206;   // ya
   sortTable[0x72BD]=27207;   // ya
   sortTable[0x731A]=27208;   // ya
   sortTable[0x7330]=27209;   // ya
   sortTable[0x73A1]=27210;   // ya
   sortTable[0x7458]=27211;   // ya
   sortTable[0x7602]=27212;   // ya
   sortTable[0x7B0C]=27213;   // ya
   sortTable[0x941A]=27214;   // ya
   sortTable[0x773C]=27215;   // yan
   sortTable[0x7814]=27216;   // yan
   sortTable[0x9A8C]=27217;   // yan
   sortTable[0x9A57]=27218;   // yan
   sortTable[0x4E25]=27219;   // yan
   sortTable[0x56B4]=27220;   // yan
   sortTable[0x70DF]=27221;   // yan
   sortTable[0x7159]=27222;   // yan
   sortTable[0x6F14]=27223;   // yan
   sortTable[0x8A00]=27224;   // yan
   sortTable[0x6CBF]=27225;   // yan
   sortTable[0x989C]=27226;   // yan
   sortTable[0x984F]=27227;   // yan
   sortTable[0x63A9]=27228;   // yan
   sortTable[0x5CA9]=27229;   // yan
   sortTable[0x76D0]=27230;   // yan
   sortTable[0x9E7D]=27231;   // yan
   sortTable[0x538C]=27232;   // yan
   sortTable[0x53AD]=27233;   // yan
   sortTable[0x71D5]=27234;   // yan
   sortTable[0x5EF6]=27235;   // yan
   sortTable[0x708E]=27236;   // yan
   sortTable[0x6DF9]=27237;   // yan
   sortTable[0x8273]=27238;   // yan
   sortTable[0x8277]=27239;   // yan
   sortTable[0x5BB4]=27240;   // yan
   sortTable[0x7130]=27241;   // yan
   sortTable[0x54BD]=27242;   // yan
   sortTable[0x6A90]=27243;   // yan
   sortTable[0x5830]=27244;   // yan
   sortTable[0x884D]=27245;   // yan
   sortTable[0x7109]=27246;   // yan
   sortTable[0x5F66]=27247;   // yan
   sortTable[0x960E]=27248;   // yan
   sortTable[0x96C1]=27249;   // yan
   sortTable[0x664F]=27250;   // yan
   sortTable[0x7B75]=27251;   // yan
   sortTable[0x5043]=27252;   // yan
   sortTable[0x4FE8]=27253;   // yan
   sortTable[0x5944]=27254;   // yan
   sortTable[0x5AE3]=27255;   // yan
   sortTable[0x6E6E]=27256;   // yan
   sortTable[0x9609]=27257;   // yan
   sortTable[0x781A]=27258;   // yan
   sortTable[0x5156]=27259;   // yan
   sortTable[0x9B47]=27260;   // yan
   sortTable[0x8C1A]=27261;   // yan
   sortTable[0x7430]=27262;   // yan
   sortTable[0x8712]=27263;   // yan
   sortTable[0x598D]=27264;   // yan
   sortTable[0x990D]=27265;   // yan
   sortTable[0x9122]=27266;   // yan
   sortTable[0x80ED]=27267;   // yan
   sortTable[0x8D5D]=27268;   // yan
   sortTable[0x83F8]=27269;   // yan
   sortTable[0x814C]=27270;   // yan
   sortTable[0x53A3]=27271;   // yan
   sortTable[0x7131]=27272;   // yan
   sortTable[0x82AB]=27273;   // yan
   sortTable[0x90FE]=27274;   // yan
   sortTable[0x6079]=27275;   // yan
   sortTable[0x8C33]=27276;   // yan
   sortTable[0x95EB]=27277;   // yan
   sortTable[0x7F68]=27278;   // yan
   sortTable[0x5501]=27279;   // yan
   sortTable[0x6EDF]=27280;   // yan
   sortTable[0x5D26]=27281;   // yan
   sortTable[0x9D08]=27282;   // yan
   sortTable[0x7E2F]=27283;   // yan
   sortTable[0x9F39]=27284;   // yan
   sortTable[0x917D]=27285;   // yan
   sortTable[0x7D96]=27286;   // yan
   sortTable[0x9EE1]=27287;   // yan
   sortTable[0x9DC3]=27288;   // yan
   sortTable[0x89FE]=27289;   // yan
   sortTable[0x9854]=27290;   // yan
   sortTable[0x784F]=27291;   // yan
   sortTable[0x8A7D]=27292;   // yan
   sortTable[0x839A]=27293;   // yan
   sortTable[0x9D33]=27294;   // yan
   sortTable[0x9869]=27295;   // yan
   sortTable[0x8758]=27296;   // yan
   sortTable[0x8B9E]=27297;   // yan
   sortTable[0x95BB]=27298;   // yan
   sortTable[0x9DA0]=27299;   // yan
   sortTable[0x8EC5]=27300;   // yan
   sortTable[0x9C0B]=27301;   // yan
   sortTable[0x7C37]=27302;   // yan
   sortTable[0x787D]=27303;   // yan
   sortTable[0x91BC]=27304;   // yan
   sortTable[0x9681]=27305;   // yan
   sortTable[0x9EA3]=27306;   // yan
   sortTable[0x9F91]=27307;   // yan
   sortTable[0x90D4]=27308;   // yan
   sortTable[0x8664]=27309;   // yan
   sortTable[0x8D0B]=27310;   // yan
   sortTable[0x9140]=27311;   // yan
   sortTable[0x9183]=27312;   // yan
   sortTable[0x995C]=27313;   // yan
   sortTable[0x9F74]=27314;   // yan
   sortTable[0x786F]=27315;   // yan
   sortTable[0x7939]=27316;   // yan
   sortTable[0x9153]=27317;   // yan
   sortTable[0x9692]=27318;   // yan
   sortTable[0x9F34]=27319;   // yan
   sortTable[0x789E]=27320;   // yan
   sortTable[0x8276]=27321;   // yan
   sortTable[0x8412]=27322;   // yan
   sortTable[0x8505]=27323;   // yan
   sortTable[0x88FA]=27324;   // yan
   sortTable[0x8AFA]=27325;   // yan
   sortTable[0x8B8C]=27326;   // yan
   sortTable[0x91B6]=27327;   // yan
   sortTable[0x95B9]=27328;   // yan
   sortTable[0x9A34]=27329;   // yan
   sortTable[0x9A60]=27330;   // yan
   sortTable[0x9B33]=27331;   // yan
   sortTable[0x9EE4]=27332;   // yan
   sortTable[0x9EEB]=27333;   // yan
   sortTable[0x9EED]=27334;   // yan
   sortTable[0x9EF6]=27335;   // yan
   sortTable[0x4E75]=27336;   // yan
   sortTable[0x5050]=27337;   // yan
   sortTable[0x5063]=27338;   // yan
   sortTable[0x50BF]=27339;   // yan
   sortTable[0x513C]=27340;   // yan
   sortTable[0x5157]=27341;   // yan
   sortTable[0x5266]=27342;   // yan
   sortTable[0x533D]=27343;   // yan
   sortTable[0x53B3]=27344;   // yan
   sortTable[0x53B4]=27345;   // yan
   sortTable[0x5571]=27346;   // yan
   sortTable[0x55AD]=27347;   // yan
   sortTable[0x565E]=27348;   // yan
   sortTable[0x56A5]=27349;   // yan
   sortTable[0x5869]=27350;   // yan
   sortTable[0x5895]=27351;   // yan
   sortTable[0x58DB]=27352;   // yan
   sortTable[0x58E7]=27353;   // yan
   sortTable[0x5935]=27354;   // yan
   sortTable[0x599F]=27355;   // yan
   sortTable[0x59F2]=27356;   // yan
   sortTable[0x59F8]=27357;   // yan
   sortTable[0x5A2B]=27358;   // yan
   sortTable[0x5A2E]=27359;   // yan
   sortTable[0x5B0A]=27360;   // yan
   sortTable[0x5B2E]=27361;   // yan
   sortTable[0x5B3F]=27362;   // yan
   sortTable[0x5B4D]=27363;   // yan
   sortTable[0x5D43]=27364;   // yan
   sortTable[0x5D52]=27365;   // yan
   sortTable[0x5D53]=27366;   // yan
   sortTable[0x5D96]=27367;   // yan
   sortTable[0x5DCC]=27368;   // yan
   sortTable[0x5DD6]=27369;   // yan
   sortTable[0x5DD7]=27370;   // yan
   sortTable[0x5DD8]=27371;   // yan
   sortTable[0x5DDA]=27372;   // yan
   sortTable[0x5F07]=27373;   // yan
   sortTable[0x5F65]=27374;   // yan
   sortTable[0x611D]=27375;   // yan
   sortTable[0x61D5]=27376;   // yan
   sortTable[0x61E8]=27377;   // yan
   sortTable[0x622D]=27378;   // yan
   sortTable[0x624A]=27379;   // yan
   sortTable[0x6281]=27380;   // yan
   sortTable[0x63C5]=27381;   // yan
   sortTable[0x63DC]=27382;   // yan
   sortTable[0x6565]=27383;   // yan
   sortTable[0x6616]=27384;   // yan
   sortTable[0x66A5]=27385;   // yan
   sortTable[0x66D5]=27386;   // yan
   sortTable[0x66E3]=27387;   // yan
   sortTable[0x66EE]=27388;   // yan
   sortTable[0x68EA]=27389;   // yan
   sortTable[0x693B]=27390;   // yan
   sortTable[0x693C]=27391;   // yan
   sortTable[0x694C]=27392;   // yan
   sortTable[0x6A2E]=27393;   // yan
   sortTable[0x6ABF]=27394;   // yan
   sortTable[0x6AE9]=27395;   // yan
   sortTable[0x6B15]=27396;   // yan
   sortTable[0x6C87]=27397;   // yan
   sortTable[0x6DCA]=27398;   // yan
   sortTable[0x6E30]=27399;   // yan
   sortTable[0x6E37]=27400;   // yan
   sortTable[0x6E7A]=27401;   // yan
   sortTable[0x6E8E]=27402;   // yan
   sortTable[0x6F39]=27403;   // yan
   sortTable[0x704E]=27404;   // yan
   sortTable[0x7054]=27405;   // yan
   sortTable[0x7067]=27406;   // yan
   sortTable[0x7069]=27407;   // yan
   sortTable[0x70FB]=27408;   // yan
   sortTable[0x7111]=27409;   // yan
   sortTable[0x7114]=27410;   // yan
   sortTable[0x7196]=27411;   // yan
   sortTable[0x71C4]=27412;   // yan
   sortTable[0x7213]=27413;   // yan
   sortTable[0x726A]=27414;   // yan
   sortTable[0x72FF]=27415;   // yan
   sortTable[0x7312]=27416;   // yan
   sortTable[0x73DA]=27417;   // yan
   sortTable[0x7402]=27418;   // yan
   sortTable[0x7517]=27419;   // yan
   sortTable[0x7BF6]=27420;   // yan
   sortTable[0x81D9]=27421;   // yan
   sortTable[0x8455]=27422;   // yan
   sortTable[0x8917]=27423;   // yan
   sortTable[0x898E]=27424;   // yan
   sortTable[0x89C3]=27425;   // yan
   sortTable[0x8A01]=27426;   // yan
   sortTable[0x8BA0]=27427;   // yan
   sortTable[0x8C53]=27428;   // yan
   sortTable[0x8C54]=27429;   // yan
   sortTable[0x8D17]=27430;   // yan
   sortTable[0x8EBD]=27431;   // yan
   sortTable[0x9043]=27432;   // yan
   sortTable[0x91C5]=27433;   // yan
   sortTable[0x9586]=27434;   // yan
   sortTable[0x9A10]=27435;   // yan
   sortTable[0x9A13]=27436;   // yan
   sortTable[0x9B58]=27437;   // yan
   sortTable[0x9CEB]=27438;   // yan
   sortTable[0x9DF0]=27439;   // yan
   sortTable[0x9EEC]=27440;   // yan
   sortTable[0x9F5E]=27441;   // yan
   sortTable[0x6837]=27442;   // yang
   sortTable[0x6A23]=27443;   // yang
   sortTable[0x9633]=27444;   // yang
   sortTable[0x967D]=27445;   // yang
   sortTable[0x517B]=27446;   // yang
   sortTable[0x990A]=27447;   // yang
   sortTable[0x592E]=27448;   // yang
   sortTable[0x6D0B]=27449;   // yang
   sortTable[0x7F8A]=27450;   // yang
   sortTable[0x626C]=27451;   // yang
   sortTable[0x63DA]=27452;   // yang
   sortTable[0x6C27]=27453;   // yang
   sortTable[0x6768]=27454;   // yang
   sortTable[0x694A]=27455;   // yang
   sortTable[0x4EF0]=27456;   // yang
   sortTable[0x79E7]=27457;   // yang
   sortTable[0x6F3E]=27458;   // yang
   sortTable[0x75D2]=27459;   // yang
   sortTable[0x9E2F]=27460;   // yang
   sortTable[0x7080]=27461;   // yang
   sortTable[0x9785]=27462;   // yang
   sortTable[0x4F6F]=27463;   // yang
   sortTable[0x6B83]=27464;   // yang
   sortTable[0x6059]=27465;   // yang
   sortTable[0x600F]=27466;   // yang
   sortTable[0x75A1]=27467;   // yang
   sortTable[0x70CA]=27468;   // yang
   sortTable[0x86D8]=27469;   // yang
   sortTable[0x98CF]=27470;   // yang
   sortTable[0x6CF1]=27471;   // yang
   sortTable[0x5F89]=27472;   // yang
   sortTable[0x7F95]=27473;   // yang
   sortTable[0x9496]=27474;   // yang
   sortTable[0x99DA]=27475;   // yang
   sortTable[0x8AF9]=27476;   // yang
   sortTable[0x9D39]=27477;   // yang
   sortTable[0x773B]=27478;   // yang
   sortTable[0x98BA]=27479;   // yang
   sortTable[0x9D26]=27480;   // yang
   sortTable[0x935A]=27481;   // yang
   sortTable[0x8EEE]=27482;   // yang
   sortTable[0x8F30]=27483;   // yang
   sortTable[0x9C11]=27484;   // yang
   sortTable[0x770F]=27485;   // yang
   sortTable[0x7993]=27486;   // yang
   sortTable[0x7D3B]=27487;   // yang
   sortTable[0x7F8F]=27488;   // yang
   sortTable[0x8A47]=27489;   // yang
   sortTable[0x4F52]=27490;   // yang
   sortTable[0x509F]=27491;   // yang
   sortTable[0x52B7]=27492;   // yang
   sortTable[0x5489]=27493;   // yang
   sortTable[0x5771]=27494;   // yang
   sortTable[0x579F]=27495;   // yang
   sortTable[0x594D]=27496;   // yang
   sortTable[0x59CE]=27497;   // yang
   sortTable[0x5C9F]=27498;   // yang
   sortTable[0x5D35]=27499;   // yang
   sortTable[0x5D38]=27500;   // yang
   sortTable[0x6143]=27501;   // yang
   sortTable[0x61E9]=27502;   // yang
   sortTable[0x62B0]=27503;   // yang
   sortTable[0x6501]=27504;   // yang
   sortTable[0x656D]=27505;   // yang
   sortTable[0x65F8]=27506;   // yang
   sortTable[0x661C]=27507;   // yang
   sortTable[0x6698]=27508;   // yang
   sortTable[0x67CD]=27509;   // yang
   sortTable[0x6967]=27510;   // yang
   sortTable[0x69D8]=27511;   // yang
   sortTable[0x6C1C]=27512;   // yang
   sortTable[0x6C31]=27513;   // yang
   sortTable[0x7001]=27514;   // yang
   sortTable[0x70B4]=27515;   // yang
   sortTable[0x716C]=27516;   // yang
   sortTable[0x73DC]=27517;   // yang
   sortTable[0x760D]=27518;   // yang
   sortTable[0x7662]=27519;   // yang
   sortTable[0x7922]=27520;   // yang
   sortTable[0x7FAA]=27521;   // yang
   sortTable[0x80E6]=27522;   // yang
   sortTable[0x8746]=27523;   // yang
   sortTable[0x9260]=27524;   // yang
   sortTable[0x940A]=27525;   // yang
   sortTable[0x9626]=27526;   // yang
   sortTable[0x96F5]=27527;   // yang
   sortTable[0x9737]=27528;   // yang
   sortTable[0x9E09]=27529;   // yang
   sortTable[0x8981]=27530;   // yao
   sortTable[0x836F]=27531;   // yao
   sortTable[0x85E5]=27532;   // yao
   sortTable[0x6447]=27533;   // yao
   sortTable[0x6416]=27534;   // yao
   sortTable[0x54AC]=27535;   // yao
   sortTable[0x8170]=27536;   // yao
   sortTable[0x7A91]=27537;   // yao
   sortTable[0x7AAF]=27538;   // yao
   sortTable[0x8000]=27539;   // yao
   sortTable[0x5406]=27540;   // yao
   sortTable[0x9080]=27541;   // yao
   sortTable[0x9065]=27542;   // yao
   sortTable[0x9059]=27543;   // yao
   sortTable[0x8C23]=27544;   // yao
   sortTable[0x8200]=27545;   // yao
   sortTable[0x8B20]=27546;   // yao
   sortTable[0x94A5]=27547;   // yao
   sortTable[0x9470]=27548;   // yao
   sortTable[0x5996]=27549;   // yao
   sortTable[0x59DA]=27550;   // yao
   sortTable[0x5C27]=27551;   // yao
   sortTable[0x7476]=27552;   // yao
   sortTable[0x592D]=27553;   // yao
   sortTable[0x66DC]=27554;   // yao
   sortTable[0x80B4]=27555;   // yao
   sortTable[0x7E47]=27556;   // yao
   sortTable[0x6773]=27557;   // yao
   sortTable[0x9E5E]=27558;   // yao
   sortTable[0x723B]=27559;   // yao
   sortTable[0x7A88]=27560;   // yao
   sortTable[0x5FAD]=27561;   // yao
   sortTable[0x5E7A]=27562;   // yao
   sortTable[0x5D3E]=27563;   // yao
   sortTable[0x8F7A]=27564;   // yao
   sortTable[0x7945]=27565;   // yao
   sortTable[0x98D6]=27566;   // yao
   sortTable[0x7A85]=27567;   // yao
   sortTable[0x73E7]=27568;   // yao
   sortTable[0x9CD0]=27569;   // yao
   sortTable[0x9A15]=27570;   // yao
   sortTable[0x977F]=27571;   // yao
   sortTable[0x8A1E]=27572;   // yao
   sortTable[0x7A94]=27573;   // yao
   sortTable[0x888E]=27574;   // yao
   sortTable[0x9864]=27575;   // yao
   sortTable[0x7711]=27576;   // yao
   sortTable[0x825E]=27577;   // yao
   sortTable[0x991A]=27578;   // yao
   sortTable[0x77C5]=27579;   // yao
   sortTable[0x846F]=27580;   // yao
   sortTable[0x847D]=27581;   // yao
   sortTable[0x95C4]=27582;   // yao
   sortTable[0x9DD5]=27583;   // yao
   sortTable[0x7A7E]=27584;   // yao
   sortTable[0x929A]=27585;   // yao
   sortTable[0x9906]=27586;   // yao
   sortTable[0x9D22]=27587;   // yao
   sortTable[0x7B44]=27588;   // yao
   sortTable[0x84D4]=27589;   // yao
   sortTable[0x899E]=27590;   // yao
   sortTable[0x8B21]=27591;   // yao
   sortTable[0x8B91]=27592;   // yao
   sortTable[0x98BB]=27593;   // yao
   sortTable[0x9C29]=27594;   // yao
   sortTable[0x9F3C]=27595;   // yao
   sortTable[0x4EF8]=27596;   // yao
   sortTable[0x5004]=27597;   // yao
   sortTable[0x5060]=27598;   // yao
   sortTable[0x509C]=27599;   // yao
   sortTable[0x5593]=27600;   // yao
   sortTable[0x55C2]=27601;   // yao
   sortTable[0x579A]=27602;   // yao
   sortTable[0x582F]=27603;   // yao
   sortTable[0x5A79]=27604;   // yao
   sortTable[0x5AB1]=27605;   // yao
   sortTable[0x5B8E]=27606;   // yao
   sortTable[0x5C2D]=27607;   // yao
   sortTable[0x5C86]=27608;   // yao
   sortTable[0x5CE3]=27609;   // yao
   sortTable[0x5DA2]=27610;   // yao
   sortTable[0x5DA4]=27611;   // yao
   sortTable[0x612E]=27612;   // yao
   sortTable[0x62AD]=27613;   // yao
   sortTable[0x63FA]=27614;   // yao
   sortTable[0x669A]=27615;   // yao
   sortTable[0x6796]=27616;   // yao
   sortTable[0x67FC]=27617;   // yao
   sortTable[0x6946]=27618;   // yao
   sortTable[0x699A]=27619;   // yao
   sortTable[0x69A3]=27620;   // yao
   sortTable[0x6B80]=27621;   // yao
   sortTable[0x6E94]=27622;   // yao
   sortTable[0x70D1]=27623;   // yao
   sortTable[0x718E]=27624;   // yao
   sortTable[0x71FF]=27625;   // yao
   sortTable[0x72D5]=27626;   // yao
   sortTable[0x733A]=27627;   // yao
   sortTable[0x735F]=27628;   // yao
   sortTable[0x7464]=27629;   // yao
   sortTable[0x7AB0]=27630;   // yao
   sortTable[0x7E85]=27631;   // yao
   sortTable[0x82ED]=27632;   // yao
   sortTable[0x85AC]=27633;   // yao
   sortTable[0x8628]=27634;   // yao
   sortTable[0x8A4F]=27635;   // yao
   sortTable[0x8EFA]=27636;   // yao
   sortTable[0x908E]=27637;   // yao
   sortTable[0x9390]=27638;   // yao
   sortTable[0x9D01]=27639;   // yao
   sortTable[0x9DC2]=27640;   // yao
   sortTable[0x9F69]=27641;   // yao
   sortTable[0x4E5F]=27642;   // ye
   sortTable[0x4E1A]=27643;   // ye
   sortTable[0x696D]=27644;   // ye
   sortTable[0x591C]=27645;   // ye
   sortTable[0x7237]=27646;   // ye
   sortTable[0x723A]=27647;   // ye
   sortTable[0x91CE]=27648;   // ye
   sortTable[0x53F6]=27649;   // ye
   sortTable[0x8449]=27650;   // ye
   sortTable[0x6DB2]=27651;   // ye
   sortTable[0x51B6]=27652;   // ye
   sortTable[0x9875]=27653;   // ye
   sortTable[0x9801]=27654;   // ye
   sortTable[0x8036]=27655;   // ye
   sortTable[0x8C12]=27656;   // ye
   sortTable[0x6396]=27657;   // ye
   sortTable[0x66F3]=27658;   // ye
   sortTable[0x9134]=27659;   // ye
   sortTable[0x6654]=27660;   // ye
   sortTable[0x90BA]=27661;   // ye
   sortTable[0x814B]=27662;   // ye
   sortTable[0x564E]=27663;   // ye
   sortTable[0x70E8]=27664;   // ye
   sortTable[0x6930]=27665;   // ye
   sortTable[0x9765]=27666;   // ye
   sortTable[0x63F6]=27667;   // ye
   sortTable[0x94D8]=27668;   // ye
   sortTable[0x998C]=27669;   // ye
   sortTable[0x882E]=27670;   // ye
   sortTable[0x9371]=27671;   // ye
   sortTable[0x9941]=27672;   // ye
   sortTable[0x9381]=27673;   // ye
   sortTable[0x9437]=27674;   // ye
   sortTable[0x790F]=27675;   // ye
   sortTable[0x4EAA]=27676;   // ye
   sortTable[0x4EB1]=27677;   // ye
   sortTable[0x503B]=27678;   // ye
   sortTable[0x50F7]=27679;   // ye
   sortTable[0x5414]=27680;   // ye
   sortTable[0x5558]=27681;   // ye
   sortTable[0x5622]=27682;   // ye
   sortTable[0x5688]=27683;   // ye
   sortTable[0x57DC]=27684;   // ye
   sortTable[0x5828]=27685;   // ye
   sortTable[0x58B7]=27686;   // ye
   sortTable[0x58C4]=27687;   // ye
   sortTable[0x5DAA]=27688;   // ye
   sortTable[0x5DAB]=27689;   // ye
   sortTable[0x62B4]=27690;   // ye
   sortTable[0x6353]=27691;   // ye
   sortTable[0x64DB]=27692;   // ye
   sortTable[0x64E8]=27693;   // ye
   sortTable[0x64EA]=27694;   // ye
   sortTable[0x64EB]=27695;   // ye
   sortTable[0x668D]=27696;   // ye
   sortTable[0x66C4]=27697;   // ye
   sortTable[0x66C5]=27698;   // ye
   sortTable[0x66D7]=27699;   // ye
   sortTable[0x66F5]=27700;   // ye
   sortTable[0x67BC]=27701;   // ye
   sortTable[0x67BD]=27702;   // ye
   sortTable[0x696A]=27703;   // ye
   sortTable[0x6B4B]=27704;   // ye
   sortTable[0x6B97]=27705;   // ye
   sortTable[0x6F1C]=27706;   // ye
   sortTable[0x6F71]=27707;   // ye
   sortTable[0x6FB2]=27708;   // ye
   sortTable[0x71C1]=27709;   // ye
   sortTable[0x7217]=27710;   // ye
   sortTable[0x76A3]=27711;   // ye
   sortTable[0x77B1]=27712;   // ye
   sortTable[0x77B8]=27713;   // ye
   sortTable[0x8B01]=27714;   // ye
   sortTable[0x9113]=27715;   // ye
   sortTable[0x91FE]=27716;   // ye
   sortTable[0x92E3]=27717;   // ye
   sortTable[0x9391]=27718;   // ye
   sortTable[0x9768]=27719;   // ye
   sortTable[0x9923]=27720;   // ye
   sortTable[0x9A5C]=27721;   // ye
   sortTable[0x9D7A]=27722;   // ye
   sortTable[0x9E08]=27723;   // ye
   sortTable[0x4E00]=27724;   // yi
   sortTable[0x4EE5]=27725;   // yi
   sortTable[0x4E49]=27726;   // yi
   sortTable[0x7FA9]=27727;   // yi
   sortTable[0x5DF2]=27728;   // yi
   sortTable[0x610F]=27729;   // yi
   sortTable[0x8863]=27730;   // yi
   sortTable[0x827A]=27731;   // yi
   sortTable[0x85DD]=27732;   // yi
   sortTable[0x8BAE]=27733;   // yi
   sortTable[0x8B70]=27734;   // yi
   sortTable[0x6613]=27735;   // yi
   sortTable[0x533B]=27736;   // yi
   sortTable[0x91AB]=27737;   // yi
   sortTable[0x4F9D]=27738;   // yi
   sortTable[0x76CA]=27739;   // yi
   sortTable[0x79FB]=27740;   // yi
   sortTable[0x4EBF]=27741;   // yi
   sortTable[0x5104]=27742;   // yi
   sortTable[0x7591]=27743;   // yi
   sortTable[0x5F02]=27744;   // yi
   sortTable[0x7570]=27745;   // yi
   sortTable[0x5F79]=27746;   // yi
   sortTable[0x4EEA]=27747;   // yi
   sortTable[0x5100]=27748;   // yi
   sortTable[0x5FC6]=27749;   // yi
   sortTable[0x61B6]=27750;   // yi
   sortTable[0x6905]=27751;   // yi
   sortTable[0x9057]=27752;   // yi
   sortTable[0x907A]=27753;   // yi
   sortTable[0x8BD1]=27754;   // yi
   sortTable[0x8B6F]=27755;   // yi
   sortTable[0x5B9C]=27756;   // yi
   sortTable[0x59E8]=27757;   // yi
   sortTable[0x6291]=27758;   // yi
   sortTable[0x4E59]=27759;   // yi
   sortTable[0x54A6]=27760;   // yi
   sortTable[0x8681]=27761;   // yi
   sortTable[0x87FB]=27762;   // yi
   sortTable[0x4EA6]=27763;   // yi
   sortTable[0x501A]=27764;   // yi
   sortTable[0x8C0A]=27765;   // yi
   sortTable[0x8ABC]=27766;   // yi
   sortTable[0x6BC5]=27767;   // yi
   sortTable[0x7FFC]=27768;   // yi
   sortTable[0x5C79]=27769;   // yi
   sortTable[0x4F0A]=27770;   // yi
   sortTable[0x75AB]=27771;   // yi
   sortTable[0x77E3]=27772;   // yi
   sortTable[0x5937]=27773;   // yi
   sortTable[0x9091]=27774;   // yi
   sortTable[0x8BE3]=27775;   // yi
   sortTable[0x9038]=27776;   // yi
   sortTable[0x6EA2]=27777;   // yi
   sortTable[0x61FF]=27778;   // yi
   sortTable[0x9A7F]=27779;   // yi
   sortTable[0x63D6]=27780;   // yi
   sortTable[0x6021]=27781;   // yi
   sortTable[0x9890]=27782;   // yi
   sortTable[0x88D4]=27783;   // yi
   sortTable[0x5955]=27784;   // yi
   sortTable[0x6339]=27785;   // yi
   sortTable[0x6C82]=27786;   // yi
   sortTable[0x5F5D]=27787;   // yi
   sortTable[0x8D3B]=27788;   // yi
   sortTable[0x7ECE]=27789;   // yi
   sortTable[0x7FCA]=27790;   // yi
   sortTable[0x80F0]=27791;   // yi
   sortTable[0x7FCC]=27792;   // yi
   sortTable[0x7F22]=27793;   // yi
   sortTable[0x8FE4]=27794;   // yi
   sortTable[0x4F5A]=27795;   // yi
   sortTable[0x58F9]=27796;   // yi
   sortTable[0x7317]=27797;   // yi
   sortTable[0x8BD2]=27798;   // yi
   sortTable[0x5F08]=27799;   // yi
   sortTable[0x9552]=27800;   // yi
   sortTable[0x5F0B]=27801;   // yi
   sortTable[0x81C6]=27802;   // yi
   sortTable[0x9974]=27803;   // yi
   sortTable[0x6F2A]=27804;   // yi
   sortTable[0x8F76]=27805;   // yi
   sortTable[0x7617]=27806;   // yi
   sortTable[0x5208]=27807;   // yi
   sortTable[0x5DB7]=27808;   // yi
   sortTable[0x7FF3]=27809;   // yi
   sortTable[0x9857]=27810;   // yi
   sortTable[0x5453]=27811;   // yi
   sortTable[0x82E1]=27812;   // yi
   sortTable[0x858F]=27813;   // yi
   sortTable[0x603F]=27814;   // yi
   sortTable[0x794E]=27815;   // yi
   sortTable[0x65D6]=27816;   // yi
   sortTable[0x566B]=27817;   // yi
   sortTable[0x5CC4]=27818;   // yi
   sortTable[0x7719]=27819;   // yi
   sortTable[0x8084]=27820;   // yi
   sortTable[0x71A0]=27821;   // yi
   sortTable[0x94F1]=27822;   // yi
   sortTable[0x7FBF]=27823;   // yi
   sortTable[0x54BF]=27824;   // yi
   sortTable[0x6B39]=27825;   // yi
   sortTable[0x9809]=27826;   // yi
   sortTable[0x8734]=27827;   // yi
   sortTable[0x4F7E]=27828;   // yi
   sortTable[0x75CD]=27829;   // yi
   sortTable[0x9487]=27830;   // yi
   sortTable[0x6092]=27831;   // yi
   sortTable[0x6BAA]=27832;   // yi
   sortTable[0x5293]=27833;   // yi
   sortTable[0x57F8]=27834;   // yi
   sortTable[0x572F]=27835;   // yi
   sortTable[0x84FA]=27836;   // yi
   sortTable[0x8223]=27837;   // yi
   sortTable[0x9EDF]=27838;   // yi
   sortTable[0x9ED3]=27839;   // yi
   sortTable[0x9F6E]=27840;   // yi
   sortTable[0x88DB]=27841;   // yi
   sortTable[0x7654]=27842;   // yi
   sortTable[0x9E62]=27843;   // yi
   sortTable[0x7E44]=27844;   // yi
   sortTable[0x8E26]=27845;   // yi
   sortTable[0x91F4]=27846;   // yi
   sortTable[0x9E65]=27847;   // yi
   sortTable[0x8798]=27848;   // yi
   sortTable[0x8FFB]=27849;   // yi
   sortTable[0x91B3]=27850;   // yi
   sortTable[0x8A63]=27851;   // yi
   sortTable[0x8CA4]=27852;   // yi
   sortTable[0x9D82]=27853;   // yi
   sortTable[0x914F]=27854;   // yi
   sortTable[0x7E76]=27855;   // yi
   sortTable[0x776A]=27856;   // yi
   sortTable[0x8B89]=27857;   // yi
   sortTable[0x9571]=27858;   // yi
   sortTable[0x9DC1]=27859;   // yi
   sortTable[0x8A11]=27860;   // yi
   sortTable[0x8C77]=27861;   // yi
   sortTable[0x9E03]=27862;   // yi
   sortTable[0x93B0]=27863;   // yi
   sortTable[0x88A3]=27864;   // yi
   sortTable[0x8B3B]=27865;   // yi
   sortTable[0x8F59]=27866;   // yi
   sortTable[0x85D9]=27867;   // yi
   sortTable[0x8D00]=27868;   // yi
   sortTable[0x86E1]=27869;   // yi
   sortTable[0x91D4]=27870;   // yi
   sortTable[0x8875]=27871;   // yi
   sortTable[0x8DC7]=27872;   // yi
   sortTable[0x8FB7]=27873;   // yi
   sortTable[0x9950]=27874;   // yi
   sortTable[0x91B7]=27875;   // yi
   sortTable[0x7995]=27876;   // yi
   sortTable[0x808A]=27877;   // yi
   sortTable[0x8264]=27878;   // yi
   sortTable[0x9BA8]=27879;   // yi
   sortTable[0x9D83]=27880;   // yi
   sortTable[0x9DD6]=27881;   // yi
   sortTable[0x7C03]=27882;   // yi
   sortTable[0x9CE6]=27883;   // yi
   sortTable[0x9DE7]=27884;   // yi
   sortTable[0x9F78]=27885;   // yi
   sortTable[0x7BB7]=27886;   // yi
   sortTable[0x7F9B]=27887;   // yi
   sortTable[0x86E6]=27888;   // yi
   sortTable[0x8794]=27889;   // yi
   sortTable[0x8CF9]=27890;   // yi
   sortTable[0x9220]=27891;   // yi
   sortTable[0x7B16]=27892;   // yi
   sortTable[0x8B9B]=27893;   // yi
   sortTable[0x972C]=27894;   // yi
   sortTable[0x9EF3]=27895;   // yi
   sortTable[0x8257]=27896;   // yi
   sortTable[0x8649]=27897;   // yi
   sortTable[0x8898]=27898;   // yi
   sortTable[0x89FA]=27899;   // yi
   sortTable[0x8A52]=27900;   // yi
   sortTable[0x8DE0]=27901;   // yi
   sortTable[0x8F22]=27902;   // yi
   sortTable[0x8FC6]=27903;   // yi
   sortTable[0x9824]=27904;   // yi
   sortTable[0x9DFE]=27905;   // yi
   sortTable[0x7912]=27906;   // yi
   sortTable[0x8189]=27907;   // yi
   sortTable[0x86DC]=27908;   // yi
   sortTable[0x87A0]=27909;   // yi
   sortTable[0x8939]=27910;   // yi
   sortTable[0x9018]=27911;   // yi
   sortTable[0x92A5]=27912;   // yi
   sortTable[0x966D]=27913;   // yi
   sortTable[0x96BF]=27914;   // yi
   sortTable[0x977E]=27915;   // yi
   sortTable[0x9D8D]=27916;   // yi
   sortTable[0x9E5D]=27917;   // yi
   sortTable[0x79C7]=27918;   // yi
   sortTable[0x7FA0]=27919;   // yi
   sortTable[0x8034]=27920;   // yi
   sortTable[0x8094]=27921;   // yi
   sortTable[0x8285]=27922;   // yi
   sortTable[0x82C5]=27923;   // yi
   sortTable[0x8619]=27924;   // yi
   sortTable[0x88FF]=27925;   // yi
   sortTable[0x897C]=27926;   // yi
   sortTable[0x8A4D]=27927;   // yi
   sortTable[0x8A83]=27928;   // yi
   sortTable[0x8C59]=27929;   // yi
   sortTable[0x8CBD]=27930;   // yi
   sortTable[0x943F]=27931;   // yi
   sortTable[0x9A5B]=27932;   // yi
   sortTable[0x9AAE]=27933;   // yi
   sortTable[0x9DCA]=27934;   // yi
   sortTable[0x4E41]=27935;   // yi
   sortTable[0x4E42]=27936;   // yi
   sortTable[0x4E4A]=27937;   // yi
   sortTable[0x4E84]=27938;   // yi
   sortTable[0x4F07]=27939;   // yi
   sortTable[0x4F3F]=27940;   // yi
   sortTable[0x4F41]=27941;   // yi
   sortTable[0x4F87]=27942;   // yi
   sortTable[0x4FCB]=27943;   // yi
   sortTable[0x506F]=27944;   // yi
   sortTable[0x517F]=27945;   // yi
   sortTable[0x519D]=27946;   // yi
   sortTable[0x51D2]=27947;   // yi
   sortTable[0x52AE]=27948;   // yi
   sortTable[0x52DA]=27949;   // yi
   sortTable[0x52E9]=27950;   // yi
   sortTable[0x5307]=27951;   // yi
   sortTable[0x531C]=27952;   // yi
   sortTable[0x541A]=27953;   // yi
   sortTable[0x546D]=27954;   // yi
   sortTable[0x5479]=27955;   // yi
   sortTable[0x5508]=27956;   // yi
   sortTable[0x56C8]=27957;   // yi
   sortTable[0x571B]=27958;   // yi
   sortTable[0x5744]=27959;   // yi
   sortTable[0x57BC]=27960;   // yi
   sortTable[0x57F6]=27961;   // yi
   sortTable[0x58BF]=27962;   // yi
   sortTable[0x58F1]=27963;   // yi
   sortTable[0x5901]=27964;   // yi
   sortTable[0x5A90]=27965;   // yi
   sortTable[0x5AD5]=27966;   // yi
   sortTable[0x5ADB]=27967;   // yi
   sortTable[0x5B04]=27968;   // yi
   sortTable[0x5B11]=27969;   // yi
   sortTable[0x5B1F]=27970;   // yi
   sortTable[0x5B90]=27971;   // yi
   sortTable[0x5BA7]=27972;   // yi
   sortTable[0x5BF1]=27973;   // yi
   sortTable[0x5BF2]=27974;   // yi
   sortTable[0x5CD3]=27975;   // yi
   sortTable[0x5D3A]=27976;   // yi
   sortTable[0x5DA7]=27977;   // yi
   sortTable[0x5DAC]=27978;   // yi
   sortTable[0x5DF8]=27979;   // yi
   sortTable[0x5E1F]=27980;   // yi
   sortTable[0x5E20]=27981;   // yi
   sortTable[0x5E46]=27982;   // yi
   sortTable[0x5EA1]=27983;   // yi
   sortTable[0x5ED9]=27984;   // yi
   sortTable[0x5F0C]=27985;   // yi
   sortTable[0x5F2C]=27986;   // yi
   sortTable[0x5F5B]=27987;   // yi
   sortTable[0x5F5C]=27988;   // yi
   sortTable[0x5F5E]=27989;   // yi
   sortTable[0x6008]=27990;   // yi
   sortTable[0x605E]=27991;   // yi
   sortTable[0x6098]=27992;   // yi
   sortTable[0x60A5]=27993;   // yi
   sortTable[0x61CC]=27994;   // yi
   sortTable[0x6245]=27995;   // yi
   sortTable[0x6246]=27996;   // yi
   sortTable[0x62F8]=27997;   // yi
   sortTable[0x6359]=27998;   // yi
   sortTable[0x639C]=27999;   // yi
   sortTable[0x648E]=28000;   // yi
   sortTable[0x653A]=28001;   // yi
   sortTable[0x6561]=28002;   // yi
   sortTable[0x657C]=28003;   // yi
   sortTable[0x6581]=28004;   // yi
   sortTable[0x65D1]=28005;   // yi
   sortTable[0x6679]=28006;   // yi
   sortTable[0x6686]=28007;   // yi
   sortTable[0x66C0]=28008;   // yi
   sortTable[0x66CE]=28009;   // yi
   sortTable[0x6759]=28010;   // yi
   sortTable[0x678D]=28011;   // yi
   sortTable[0x67BB]=28012;   // yi
   sortTable[0x67C2]=28013;   // yi
   sortTable[0x6818]=28014;   // yi
   sortTable[0x6827]=28015;   // yi
   sortTable[0x683A]=28016;   // yi
   sortTable[0x684B]=28017;   // yi
   sortTable[0x68ED]=28018;   // yi
   sortTable[0x692C]=28019;   // yi
   sortTable[0x6938]=28020;   // yi
   sortTable[0x698F]=28021;   // yi
   sortTable[0x69F8]=28022;   // yi
   sortTable[0x6A8D]=28023;   // yi
   sortTable[0x6AA5]=28024;   // yi
   sortTable[0x6AB9]=28025;   // yi
   sortTable[0x6B25]=28026;   // yi
   sortTable[0x6B2D]=28027;   // yi
   sortTable[0x6B5D]=28028;   // yi
   sortTable[0x6B94]=28029;   // yi
   sortTable[0x6BB9]=28030;   // yi
   sortTable[0x6BC9]=28031;   // yi
   sortTable[0x6CB6]=28032;   // yi
   sortTable[0x6CC6]=28033;   // yi
   sortTable[0x6D02]=28034;   // yi
   sortTable[0x6D22]=28035;   // yi
   sortTable[0x6D42]=28036;   // yi
   sortTable[0x6D65]=28037;   // yi
   sortTable[0x6D73]=28038;   // yi
   sortTable[0x6E59]=28039;   // yi
   sortTable[0x6F69]=28040;   // yi
   sortTable[0x6FBA]=28041;   // yi
   sortTable[0x7037]=28042;   // yi
   sortTable[0x7088]=28043;   // yi
   sortTable[0x7132]=28044;   // yi
   sortTable[0x71A4]=28045;   // yi
   sortTable[0x71AA]=28046;   // yi
   sortTable[0x71BC]=28047;   // yi
   sortTable[0x71DA]=28048;   // yi
   sortTable[0x71E1]=28049;   // yi
   sortTable[0x71F1]=28050;   // yi
   sortTable[0x72CB]=28051;   // yi
   sortTable[0x7348]=28052;   // yi
   sortTable[0x73B4]=28053;   // yi
   sortTable[0x73C6]=28054;   // yi
   sortTable[0x747F]=28055;   // yi
   sortTable[0x74F5]=28056;   // yi
   sortTable[0x7569]=28057;   // yi
   sortTable[0x75EC]=28058;   // yi
   sortTable[0x761E]=28059;   // yi
   sortTable[0x7631]=28060;   // yi
   sortTable[0x7796]=28061;   // yi
   sortTable[0x785B]=28062;   // yi
   sortTable[0x7A26]=28063;   // yi
   sortTable[0x7A53]=28064;   // yi
   sortTable[0x7AE9]=28065;   // yi
   sortTable[0x7C4E]=28066;   // yi
   sortTable[0x7E0A]=28067;   // yi
   sortTable[0x7E79]=28068;   // yi
   sortTable[0x801B]=28069;   // yi
   sortTable[0x82E2]=28070;   // yi
   sortTable[0x8413]=28071;   // yi
   sortTable[0x841F]=28072;   // yi
   sortTable[0x8864]=28073;   // yi
   sortTable[0x886A]=28074;   // yi
   sortTable[0x8A32]=28075;   // yi
   sortTable[0x8A33]=28076;   // yi
   sortTable[0x8A51]=28077;   // yi
   sortTable[0x8B69]=28078;   // yi
   sortTable[0x8C5B]=28079;   // yi
   sortTable[0x8EFC]=28080;   // yi
   sortTable[0x90FC]=28081;   // yi
   sortTable[0x926F]=28082;   // yi
   sortTable[0x93D4]=28083;   // yi
   sortTable[0x984A]=28084;   // yi
   sortTable[0x98F4]=28085;   // yi
   sortTable[0x99C5]=28086;   // yi
   sortTable[0x9BE3]=28087;   // yi
   sortTable[0x56E0]=28088;   // yin
   sortTable[0x97F3]=28089;   // yin
   sortTable[0x5F15]=28090;   // yin
   sortTable[0x5370]=28091;   // yin
   sortTable[0x94F6]=28092;   // yin
   sortTable[0x9280]=28093;   // yin
   sortTable[0x9634]=28094;   // yin
   sortTable[0x9670]=28095;   // yin
   sortTable[0x9690]=28096;   // yin
   sortTable[0x96B1]=28097;   // yin
   sortTable[0x996E]=28098;   // yin
   sortTable[0x98F2]=28099;   // yin
   sortTable[0x541F]=28100;   // yin
   sortTable[0x59FB]=28101;   // yin
   sortTable[0x8693]=28102;   // yin
   sortTable[0x5BC5]=28103;   // yin
   sortTable[0x6BB7]=28104;   // yin
   sortTable[0x5C39]=28105;   // yin
   sortTable[0x6DEB]=28106;   // yin
   sortTable[0x80E4]=28107;   // yin
   sortTable[0x836B]=28108;   // yin
   sortTable[0x8335]=28109;   // yin
   sortTable[0x763E]=28110;   // yin
   sortTable[0x5924]=28111;   // yin
   sortTable[0x6C24]=28112;   // yin
   sortTable[0x5591]=28113;   // yin
   sortTable[0x798B]=28114;   // yin
   sortTable[0x911E]=28115;   // yin
   sortTable[0x57A0]=28116;   // yin
   sortTable[0x8AF2]=28117;   // yin
   sortTable[0x972A]=28118;   // yin
   sortTable[0x5819]=28119;   // yin
   sortTable[0x9A83]=28120;   // yin
   sortTable[0x79F5]=28121;   // yin
   sortTable[0x7D6A]=28122;   // yin
   sortTable[0x95C9]=28123;   // yin
   sortTable[0x5432]=28124;   // yin
   sortTable[0x88C0]=28125;   // yin
   sortTable[0x72FA]=28126;   // yin
   sortTable[0x8A1A]=28127;   // yin
   sortTable[0x8ABE]=28128;   // yin
   sortTable[0x7C8C]=28129;   // yin
   sortTable[0x9173]=28130;   // yin
   sortTable[0x9F82]=28131;   // yin
   sortTable[0x6D07]=28132;   // yin
   sortTable[0x87BE]=28133;   // yin
   sortTable[0x94DF]=28134;   // yin
   sortTable[0x8A14]=28135;   // yin
   sortTable[0x831A]=28136;   // yin
   sortTable[0x87EB]=28137;   // yin
   sortTable[0x9777]=28138;   // yin
   sortTable[0x99F0]=28139;   // yin
   sortTable[0x9BA3]=28140;   // yin
   sortTable[0x9DE3]=28141;   // yin
   sortTable[0x9712]=28142;   // yin
   sortTable[0x8B94]=28143;   // yin
   sortTable[0x967B]=28144;   // yin
   sortTable[0x9682]=28145;   // yin
   sortTable[0x9720]=28146;   // yin
   sortTable[0x98EE]=28147;   // yin
   sortTable[0x78E4]=28148;   // yin
   sortTable[0x8529]=28149;   // yin
   sortTable[0x920F]=28150;   // yin
   sortTable[0x92A6]=28151;   // yin
   sortTable[0x9625]=28152;   // yin
   sortTable[0x9787]=28153;   // yin
   sortTable[0x97FE]=28154;   // yin
   sortTable[0x9F57]=28155;   // yin
   sortTable[0x7892]=28156;   // yin
   sortTable[0x7DF8]=28157;   // yin
   sortTable[0x8491]=28158;   // yin
   sortTable[0x8A21]=28159;   // yin
   sortTable[0x96A0]=28160;   // yin
   sortTable[0x4E51]=28161;   // yin
   sortTable[0x4E5A]=28162;   // yin
   sortTable[0x4F8C]=28163;   // yin
   sortTable[0x5198]=28164;   // yin
   sortTable[0x51D0]=28165;   // yin
   sortTable[0x5656]=28166;   // yin
   sortTable[0x567E]=28167;   // yin
   sortTable[0x569A]=28168;   // yin
   sortTable[0x56D9]=28169;   // yin
   sortTable[0x5701]=28170;   // yin
   sortTable[0x5794]=28171;   // yin
   sortTable[0x57BD]=28172;   // yin
   sortTable[0x5837]=28173;   // yin
   sortTable[0x5A63]=28174;   // yin
   sortTable[0x5A6C]=28175;   // yin
   sortTable[0x5CFE]=28176;   // yin
   sortTable[0x5D1F]=28177;   // yin
   sortTable[0x5D2F]=28178;   // yin
   sortTable[0x5DBE]=28179;   // yin
   sortTable[0x5ED5]=28180;   // yin
   sortTable[0x5EF4]=28181;   // yin
   sortTable[0x6114]=28182;   // yin
   sortTable[0x6147]=28183;   // yin
   sortTable[0x616D]=28184;   // yin
   sortTable[0x6196]=28185;   // yin
   sortTable[0x6197]=28186;   // yin
   sortTable[0x61DA]=28187;   // yin
   sortTable[0x647F]=28188;   // yin
   sortTable[0x65A6]=28189;   // yin
   sortTable[0x6704]=28190;   // yin
   sortTable[0x6836]=28191;   // yin
   sortTable[0x6A83]=28192;   // yin
   sortTable[0x6AAD]=28193;   // yin
   sortTable[0x6ABC]=28194;   // yin
   sortTable[0x6AFD]=28195;   // yin
   sortTable[0x6B45]=28196;   // yin
   sortTable[0x6BA5]=28197;   // yin
   sortTable[0x6CFF]=28198;   // yin
   sortTable[0x6D15]=28199;   // yin
   sortTable[0x6DFE]=28200;   // yin
   sortTable[0x6E5A]=28201;   // yin
   sortTable[0x6EB5]=28202;   // yin
   sortTable[0x6EDB]=28203;   // yin
   sortTable[0x6FE5]=28204;   // yin
   sortTable[0x6FE6]=28205;   // yin
   sortTable[0x70CE]=28206;   // yin
   sortTable[0x72BE]=28207;   // yin
   sortTable[0x730C]=28208;   // yin
   sortTable[0x73E2]=28209;   // yin
   sortTable[0x748C]=28210;   // yin
   sortTable[0x7616]=28211;   // yin
   sortTable[0x764A]=28212;   // yin
   sortTable[0x766E]=28213;   // yin
   sortTable[0x7B43]=28214;   // yin
   sortTable[0x82C2]=28215;   // yin
   sortTable[0x8376]=28216;   // yin
   sortTable[0x852D]=28217;   // yin
   sortTable[0x861F]=28218;   // yin
   sortTable[0x8D7A]=28219;   // yin
   sortTable[0x8D9B]=28220;   // yin
   sortTable[0x8F11]=28221;   // yin
   sortTable[0x921D]=28222;   // yin
   sortTable[0x5E94]=28223;   // ying
   sortTable[0x61C9]=28224;   // ying
   sortTable[0x5F71]=28225;   // ying
   sortTable[0x8425]=28226;   // ying
   sortTable[0x71DF]=28227;   // ying
   sortTable[0x6620]=28228;   // ying
   sortTable[0x82F1]=28229;   // ying
   sortTable[0x786C]=28230;   // ying
   sortTable[0x8FCE]=28231;   // ying
   sortTable[0x8747]=28232;   // ying
   sortTable[0x8805]=28233;   // ying
   sortTable[0x5A74]=28234;   // ying
   sortTable[0x5B30]=28235;   // ying
   sortTable[0x9E70]=28236;   // ying
   sortTable[0x9DF9]=28237;   // ying
   sortTable[0x8424]=28238;   // ying
   sortTable[0x87A2]=28239;   // ying
   sortTable[0x83B9]=28240;   // ying
   sortTable[0x7469]=28241;   // ying
   sortTable[0x9896]=28242;   // ying
   sortTable[0x7A4E]=28243;   // ying
   sortTable[0x76C8]=28244;   // ying
   sortTable[0x8D62]=28245;   // ying
   sortTable[0x6A31]=28246;   // ying
   sortTable[0x988D]=28247;   // ying
   sortTable[0x83BA]=28248;   // ying
   sortTable[0x8367]=28249;   // ying
   sortTable[0x81BA]=28250;   // ying
   sortTable[0x90E2]=28251;   // ying
   sortTable[0x745B]=28252;   // ying
   sortTable[0x701B]=28253;   // ying
   sortTable[0x9E66]=28254;   // ying
   sortTable[0x8426]=28255;   // ying
   sortTable[0x7F28]=28256;   // ying
   sortTable[0x5624]=28257;   // ying
   sortTable[0x6979]=28258;   // ying
   sortTable[0x7F42]=28259;   // ying
   sortTable[0x5B34]=28260;   // ying
   sortTable[0x8314]=28261;   // ying
   sortTable[0x5AB5]=28262;   // ying
   sortTable[0x6EE2]=28263;   // ying
   sortTable[0x763F]=28264;   // ying
   sortTable[0x6F46]=28265;   // ying
   sortTable[0x748E]=28266;   // ying
   sortTable[0x6484]=28267;   // ying
   sortTable[0x9DEA]=28268;   // ying
   sortTable[0x7F43]=28269;   // ying
   sortTable[0x84E5]=28270;   // ying
   sortTable[0x7EEC]=28271;   // ying
   sortTable[0x97FA]=28272;   // ying
   sortTable[0x9719]=28273;   // ying
   sortTable[0x7C5D]=28274;   // ying
   sortTable[0x9795]=28275;   // ying
   sortTable[0x9533]=28276;   // ying
   sortTable[0x8B7B]=28277;   // ying
   sortTable[0x9D2C]=28278;   // ying
   sortTable[0x877F]=28279;   // ying
   sortTable[0x8D0F]=28280;   // ying
   sortTable[0x77E8]=28281;   // ying
   sortTable[0x892E]=28282;   // ying
   sortTable[0x8EC8]=28283;   // ying
   sortTable[0x7C6F]=28284;   // ying
   sortTable[0x8B0D]=28285;   // ying
   sortTable[0x944D]=28286;   // ying
   sortTable[0x9895]=28287;   // ying
   sortTable[0x9C66]=28288;   // ying
   sortTable[0x7E08]=28289;   // ying
   sortTable[0x85C0]=28290;   // ying
   sortTable[0x8621]=28291;   // ying
   sortTable[0x9D91]=28292;   // ying
   sortTable[0x9DAF]=28293;   // ying
   sortTable[0x5040]=28294;   // ying
   sortTable[0x50CC]=28295;   // ying
   sortTable[0x5568]=28296;   // ying
   sortTable[0x55B6]=28297;   // ying
   sortTable[0x565F]=28298;   // ying
   sortTable[0x56B6]=28299;   // ying
   sortTable[0x584B]=28300;   // ying
   sortTable[0x5A96]=28301;   // ying
   sortTable[0x5AC8]=28302;   // ying
   sortTable[0x5B46]=28303;   // ying
   sortTable[0x5B7E]=28304;   // ying
   sortTable[0x5DCA]=28305;   // ying
   sortTable[0x5EEE]=28306;   // ying
   sortTable[0x5FDC]=28307;   // ying
   sortTable[0x6125]=28308;   // ying
   sortTable[0x646C]=28309;   // ying
   sortTable[0x650D]=28310;   // ying
   sortTable[0x6516]=28311;   // ying
   sortTable[0x651A]=28312;   // ying
   sortTable[0x668E]=28313;   // ying
   sortTable[0x6720]=28314;   // ying
   sortTable[0x685C]=28315;   // ying
   sortTable[0x68AC]=28316;   // ying
   sortTable[0x6AFB]=28317;   // ying
   sortTable[0x6AFF]=28318;   // ying
   sortTable[0x6D67]=28319;   // ying
   sortTable[0x6E36]=28320;   // ying
   sortTable[0x6E81]=28321;   // ying
   sortTable[0x6E8B]=28322;   // ying
   sortTable[0x6F41]=28323;   // ying
   sortTable[0x6FD9]=28324;   // ying
   sortTable[0x6FDA]=28325;   // ying
   sortTable[0x6FF4]=28326;   // ying
   sortTable[0x7005]=28327;   // ying
   sortTable[0x7020]=28328;   // ying
   sortTable[0x702F]=28329;   // ying
   sortTable[0x7034]=28330;   // ying
   sortTable[0x7050]=28331;   // ying
   sortTable[0x705C]=28332;   // ying
   sortTable[0x7150]=28333;   // ying
   sortTable[0x7192]=28334;   // ying
   sortTable[0x73F1]=28335;   // ying
   sortTable[0x7484]=28336;   // ying
   sortTable[0x74D4]=28337;   // ying
   sortTable[0x7507]=28338;   // ying
   sortTable[0x7516]=28339;   // ying
   sortTable[0x766D]=28340;   // ying
   sortTable[0x76C1]=28341;   // ying
   sortTable[0x78A4]=28342;   // ying
   sortTable[0x792F]=28343;   // ying
   sortTable[0x7DD3]=28344;   // ying
   sortTable[0x7E04]=28345;   // ying
   sortTable[0x7E93]=28346;   // ying
   sortTable[0x7F4C]=28347;   // ying
   sortTable[0x81A1]=28348;   // ying
   sortTable[0x843E]=28349;   // ying
   sortTable[0x86CD]=28350;   // ying
   sortTable[0x8767]=28351;   // ying
   sortTable[0x8833]=28352;   // ying
   sortTable[0x89AE]=28353;   // ying
   sortTable[0x8B4D]=28354;   // ying
   sortTable[0x8CCF]=28355;   // ying
   sortTable[0x9348]=28356;   // ying
   sortTable[0x93A3]=28357;   // ying
   sortTable[0x941B]=28358;   // ying
   sortTable[0x9834]=28359;   // ying
   sortTable[0x9DA7]=28360;   // ying
   sortTable[0x9E0E]=28361;   // ying
   sortTable[0x9E1A]=28362;   // ying
   sortTable[0x54DF]=28363;   // yo
   sortTable[0x55B2]=28364;   // yo
   sortTable[0x5537]=28365;   // yo
   sortTable[0x7528]=28366;   // yong
   sortTable[0x6C38]=28367;   // yong
   sortTable[0x52C7]=28368;   // yong
   sortTable[0x6D8C]=28369;   // yong
   sortTable[0x62E5]=28370;   // yong
   sortTable[0x64C1]=28371;   // yong
   sortTable[0x6CF3]=28372;   // yong
   sortTable[0x5EB8]=28373;   // yong
   sortTable[0x96CD]=28374;   // yong
   sortTable[0x4F63]=28375;   // yong
   sortTable[0x548F]=28376;   // yong
   sortTable[0x9095]=28377;   // yong
   sortTable[0x8E0A]=28378;   // yong
   sortTable[0x86F9]=28379;   // yong
   sortTable[0x58C5]=28380;   // yong
   sortTable[0x9954]=28381;   // yong
   sortTable[0x607F]=28382;   // yong
   sortTable[0x9899]=28383;   // yong
   sortTable[0x6175]=28384;   // yong
   sortTable[0x4FD1]=28385;   // yong
   sortTable[0x752C]=28386;   // yong
   sortTable[0x75C8]=28387;   // yong
   sortTable[0x5889]=28388;   // yong
   sortTable[0x81C3]=28389;   // yong
   sortTable[0x955B]=28390;   // yong
   sortTable[0x5581]=28391;   // yong
   sortTable[0x9852]=28392;   // yong
   sortTable[0x9118]=28393;   // yong
   sortTable[0x799C]=28394;   // yong
   sortTable[0x9CD9]=28395;   // yong
   sortTable[0x96DD]=28396;   // yong
   sortTable[0x8A60]=28397;   // yong
   sortTable[0x9BD2]=28398;   // yong
   sortTable[0x9C2B]=28399;   // yong
   sortTable[0x9CAC]=28400;   // yong
   sortTable[0x8E34]=28401;   // yong
   sortTable[0x90FA]=28402;   // yong
   sortTable[0x509B]=28403;   // yong
   sortTable[0x50AD]=28404;   // yong
   sortTable[0x52C8]=28405;   // yong
   sortTable[0x55C8]=28406;   // yong
   sortTable[0x5670]=28407;   // yong
   sortTable[0x57C7]=28408;   // yong
   sortTable[0x584E]=28409;   // yong
   sortTable[0x5ADE]=28410;   // yong
   sortTable[0x5D71]=28411;   // yong
   sortTable[0x5EF1]=28412;   // yong
   sortTable[0x5F6E]=28413;   // yong
   sortTable[0x603A]=28414;   // yong
   sortTable[0x6080]=28415;   // yong
   sortTable[0x60E5]=28416;   // yong
   sortTable[0x6111]=28417;   // yong
   sortTable[0x6139]=28418;   // yong
   sortTable[0x6142]=28419;   // yong
   sortTable[0x63D8]=28420;   // yong
   sortTable[0x67E1]=28421;   // yong
   sortTable[0x6810]=28422;   // yong
   sortTable[0x69E6]=28423;   // yong
   sortTable[0x6E67]=28424;   // yong
   sortTable[0x6EFD]=28425;   // yong
   sortTable[0x6FAD]=28426;   // yong
   sortTable[0x7049]=28427;   // yong
   sortTable[0x7245]=28428;   // yong
   sortTable[0x7655]=28429;   // yong
   sortTable[0x7670]=28430;   // yong
   sortTable[0x783D]=28431;   // yong
   sortTable[0x7867]=28432;   // yong
   sortTable[0x82DA]=28433;   // yong
   sortTable[0x919F]=28434;   // yong
   sortTable[0x93DE]=28435;   // yong
   sortTable[0x9C45]=28436;   // yong
   sortTable[0x9DDB]=28437;   // yong
   sortTable[0x6709]=28438;   // you
   sortTable[0x53C8]=28439;   // you
   sortTable[0x7531]=28440;   // you
   sortTable[0x6CB9]=28441;   // you
   sortTable[0x53F3]=28442;   // you
   sortTable[0x53CB]=28443;   // you
   sortTable[0x6E38]=28444;   // you
   sortTable[0x4F18]=28445;   // you
   sortTable[0x512A]=28446;   // you
   sortTable[0x5C24]=28447;   // you
   sortTable[0x5E7C]=28448;   // you
   sortTable[0x72B9]=28449;   // you
   sortTable[0x7336]=28450;   // you
   sortTable[0x90AE]=28451;   // you
   sortTable[0x90F5]=28452;   // you
   sortTable[0x5FE7]=28453;   // you
   sortTable[0x6182]=28454;   // you
   sortTable[0x94C0]=28455;   // you
   sortTable[0x923E]=28456;   // you
   sortTable[0x60A0]=28457;   // you
   sortTable[0x8BF1]=28458;   // you
   sortTable[0x8A98]=28459;   // you
   sortTable[0x4F51]=28460;   // you
   sortTable[0x5E7D]=28461;   // you
   sortTable[0x9149]=28462;   // you
   sortTable[0x7950]=28463;   // you
   sortTable[0x6538]=28464;   // you
   sortTable[0x91C9]=28465;   // you
   sortTable[0x5BA5]=28466;   // you
   sortTable[0x7337]=28467;   // you
   sortTable[0x86B4]=28468;   // you
   sortTable[0x7256]=28469;   // you
   sortTable[0x9EDD]=28470;   // you
   sortTable[0x5363]=28471;   // you
   sortTable[0x75A3]=28472;   // you
   sortTable[0x67DA]=28473;   // you
   sortTable[0x56FF]=28474;   // you
   sortTable[0x83B8]=28475;   // you
   sortTable[0x86B0]=28476;   // you
   sortTable[0x4F91]=28477;   // you
   sortTable[0x5466]=28478;   // you
   sortTable[0x9C7F]=28479;   // you
   sortTable[0x5C22]=28480;   // you
   sortTable[0x83A0]=28481;   // you
   sortTable[0x839C]=28482;   // you
   sortTable[0x9F2C]=28483;   // you
   sortTable[0x8763]=28484;   // you
   sortTable[0x900C]=28485;   // you
   sortTable[0x8F36]=28486;   // you
   sortTable[0x7F91]=28487;   // you
   sortTable[0x9E80]=28488;   // you
   sortTable[0x94D5]=28489;   // you
   sortTable[0x8030]=28490;   // you
   sortTable[0x9C89]=28491;   // you
   sortTable[0x904A]=28492;   // you
   sortTable[0x870F]=28493;   // you
   sortTable[0x913E]=28494;   // you
   sortTable[0x8FF6]=28495;   // you
   sortTable[0x8A27]=28496;   // you
   sortTable[0x9B77]=28497;   // you
   sortTable[0x9B8B]=28498;   // you
   sortTable[0x80AC]=28499;   // you
   sortTable[0x811C]=28500;   // you
   sortTable[0x82C3]=28501;   // you
   sortTable[0x7989]=28502;   // you
   sortTable[0x79DE]=28503;   // you
   sortTable[0x7E8B]=28504;   // you
   sortTable[0x4E23]=28505;   // you
   sortTable[0x4EB4]=28506;   // you
   sortTable[0x5064]=28507;   // you
   sortTable[0x54CA]=28508;   // you
   sortTable[0x5500]=28509;   // you
   sortTable[0x5698]=28510;   // you
   sortTable[0x59F7]=28511;   // you
   sortTable[0x5B67]=28512;   // you
   sortTable[0x5CDF]=28513;   // you
   sortTable[0x5CF3]=28514;   // you
   sortTable[0x5EAE]=28515;   // you
   sortTable[0x6023]=28516;   // you
   sortTable[0x602E]=28517;   // you
   sortTable[0x61EE]=28518;   // you
   sortTable[0x65BF]=28519;   // you
   sortTable[0x682F]=28520;   // you
   sortTable[0x6884]=28521;   // you
   sortTable[0x6962]=28522;   // you
   sortTable[0x69F1]=28523;   // you
   sortTable[0x6ACC]=28524;   // you
   sortTable[0x6AFE]=28525;   // you
   sortTable[0x6C8B]=28526;   // you
   sortTable[0x6CD1]=28527;   // you
   sortTable[0x6D5F]=28528;   // you
   sortTable[0x6E75]=28529;   // you
   sortTable[0x6EFA]=28530;   // you
   sortTable[0x7000]=28531;   // you
   sortTable[0x7257]=28532;   // you
   sortTable[0x7270]=28533;   // you
   sortTable[0x72D6]=28534;   // you
   sortTable[0x7CFF]=28535;   // you
   sortTable[0x7F90]=28536;   // you
   sortTable[0x8048]=28537;   // you
   sortTable[0x848F]=28538;   // you
   sortTable[0x8555]=28539;   // you
   sortTable[0x8C81]=28540;   // you
   sortTable[0x8F0F]=28541;   // you
   sortTable[0x9030]=28542;   // you
   sortTable[0x916D]=28543;   // you
   sortTable[0x92AA]=28544;   // you
   sortTable[0x99C0]=28545;   // you
   sortTable[0x4E8E]=28546;   // yu
   sortTable[0x4E0E]=28547;   // yu
   sortTable[0x8207]=28548;   // yu
   sortTable[0x80B2]=28549;   // yu
   sortTable[0x96E8]=28550;   // yu
   sortTable[0x9C7C]=28551;   // yu
   sortTable[0x9B5A]=28552;   // yu
   sortTable[0x4F59]=28553;   // yu
   sortTable[0x8BED]=28554;   // yu
   sortTable[0x9047]=28555;   // yu
   sortTable[0x8A9E]=28556;   // yu
   sortTable[0x9884]=28557;   // yu
   sortTable[0x9810]=28558;   // yu
   sortTable[0x5B87]=28559;   // yu
   sortTable[0x6108]=28560;   // yu
   sortTable[0x57DF]=28561;   // yu
   sortTable[0x7389]=28562;   // yu
   sortTable[0x72F1]=28563;   // yu
   sortTable[0x7344]=28564;   // yu
   sortTable[0x6109]=28565;   // yu
   sortTable[0x6B32]=28566;   // yu
   sortTable[0x5FA1]=28567;   // yu
   sortTable[0x6E14]=28568;   // yu
   sortTable[0x6F01]=28569;   // yu
   sortTable[0x4E88]=28570;   // yu
   sortTable[0x8C6B]=28571;   // yu
   sortTable[0x8A89]=28572;   // yu
   sortTable[0x8B7D]=28573;   // yu
   sortTable[0x5C7F]=28574;   // yu
   sortTable[0x5DBC]=28575;   // yu
   sortTable[0x88D5]=28576;   // yu
   sortTable[0x7FBD]=28577;   // yu
   sortTable[0x5A31]=28578;   // yu
   sortTable[0x7AFD]=28579;   // yu
   sortTable[0x5A1B]=28580;   // yu
   sortTable[0x90C1]=28581;   // yu
   sortTable[0x5BD3]=28582;   // yu
   sortTable[0x8206]=28583;   // yu
   sortTable[0x8F3F]=28584;   // yu
   sortTable[0x611A]=28585;   // yu
   sortTable[0x8C15]=28586;   // yu
   sortTable[0x9980]=28587;   // yu
   sortTable[0x65BC]=28588;   // yu
   sortTable[0x865E]=28589;   // yu
   sortTable[0x903E]=28590;   // yu
   sortTable[0x6D74]=28591;   // yu
   sortTable[0x55BB]=28592;   // yu
   sortTable[0x79B9]=28593;   // yu
   sortTable[0x745C]=28594;   // yu
   sortTable[0x6BD3]=28595;   // yu
   sortTable[0x4FDE]=28596;   // yu
   sortTable[0x6B24]=28597;   // yu
   sortTable[0x715C]=28598;   // yu
   sortTable[0x9685]=28599;   // yu
   sortTable[0x6986]=28600;   // yu
   sortTable[0x8FC2]=28601;   // yu
   sortTable[0x81FE]=28602;   // yu
   sortTable[0x5EBE]=28603;   // yu
   sortTable[0x9A6D]=28604;   // yu
   sortTable[0x79BA]=28605;   // yu
   sortTable[0x8C00]=28606;   // yu
   sortTable[0x94B0]=28607;   // yu
   sortTable[0x807F]=28608;   // yu
   sortTable[0x6DE4]=28609;   // yu
   sortTable[0x59AA]=28610;   // yu
   sortTable[0x9B3B]=28611;   // yu
   sortTable[0x6E1D]=28612;   // yu
   sortTable[0x6631]=28613;   // yu
   sortTable[0x76C2]=28614;   // yu
   sortTable[0x4FE3]=28615;   // yu
   sortTable[0x9E6C]=28616;   // yu
   sortTable[0x9AC3]=28617;   // yu
   sortTable[0x5CEA]=28618;   // yu
   sortTable[0x9E46]=28619;   // yu
   sortTable[0x996B]=28620;   // yu
   sortTable[0x8174]=28621;   // yu
   sortTable[0x9608]=28622;   // yu
   sortTable[0x9F89]=28623;   // yu
   sortTable[0x96E9]=28624;   // yu
   sortTable[0x5709]=28625;   // yu
   sortTable[0x8438]=28626;   // yu
   sortTable[0x828B]=28627;   // yu
   sortTable[0x5D5B]=28628;   // yu
   sortTable[0x89CE]=28629;   // yu
   sortTable[0x7AB3]=28630;   // yu
   sortTable[0x8E30]=28631;   // yu
   sortTable[0x7AAC]=28632;   // yu
   sortTable[0x7600]=28633;   // yu
   sortTable[0x7EA1]=28634;   // yu
   sortTable[0x8201]=28635;   // yu
   sortTable[0x59A4]=28636;   // yu
   sortTable[0x5704]=28637;   // yu
   sortTable[0x63C4]=28638;   // yu
   sortTable[0x872E]=28639;   // yu
   sortTable[0x8080]=28640;   // yu
   sortTable[0x71E0]=28641;   // yu
   sortTable[0x9079]=28642;   // yu
   sortTable[0x4F1B]=28643;   // yu
   sortTable[0x7610]=28644;   // yu
   sortTable[0x8753]=28645;   // yu
   sortTable[0x8915]=28646;   // yu
   sortTable[0x8581]=28647;   // yu
   sortTable[0x77DE]=28648;   // yu
   sortTable[0x8F5D]=28649;   // yu
   sortTable[0x9D25]=28650;   // yu
   sortTable[0x8248]=28651;   // yu
   sortTable[0x84E3]=28652;   // yu
   sortTable[0x9098]=28653;   // yu
   sortTable[0x9918]=28654;   // yu
   sortTable[0x72F3]=28655;   // yu
   sortTable[0x923A]=28656;   // yu
   sortTable[0x7C5E]=28657;   // yu
   sortTable[0x9105]=28658;   // yu
   sortTable[0x776E]=28659;   // yu
   sortTable[0x9B31]=28660;   // yu
   sortTable[0x7964]=28661;   // yu
   sortTable[0x8C90]=28662;   // yu
   sortTable[0x7907]=28663;   // yu
   sortTable[0x7E58]=28664;   // yu
   sortTable[0x8B23]=28665;   // yu
   sortTable[0x92CA]=28666;   // yu
   sortTable[0x791C]=28667;   // yu
   sortTable[0x8245]=28668;   // yu
   sortTable[0x842D]=28669;   // yu
   sortTable[0x8577]=28670;   // yu
   sortTable[0x9828]=28671;   // yu
   sortTable[0x9BBD]=28672;   // yu
   sortTable[0x9E8C]=28673;   // yu
   sortTable[0x9FA5]=28674;   // yu
   sortTable[0x79A6]=28675;   // yu
   sortTable[0x9A48]=28676;   // yu
   sortTable[0x9E12]=28677;   // yu
   sortTable[0x7F6D]=28678;   // yu
   sortTable[0x7FAD]=28679;   // yu
   sortTable[0x9325]=28680;   // yu
   sortTable[0x9D2A]=28681;   // yu
   sortTable[0x7872]=28682;   // yu
   sortTable[0x7A7B]=28683;   // yu
   sortTable[0x8330]=28684;   // yu
   sortTable[0x9289]=28685;   // yu
   sortTable[0x7DCE]=28686;   // yu
   sortTable[0x8ADB]=28687;   // yu
   sortTable[0x7C72]=28688;   // yu
   sortTable[0x8EC9]=28689;   // yu
   sortTable[0x942D]=28690;   // yu
   sortTable[0x95BE]=28691;   // yu
   sortTable[0x98EB]=28692;   // yu
   sortTable[0x9A1F]=28693;   // yu
   sortTable[0x9C05]=28694;   // yu
   sortTable[0x9CFF]=28695;   // yu
   sortTable[0x76D3]=28696;   // yu
   sortTable[0x7A22]=28697;   // yu
   sortTable[0x7BFD]=28698;   // yu
   sortTable[0x7C45]=28699;   // yu
   sortTable[0x831F]=28700;   // yu
   sortTable[0x8362]=28701;   // yu
   sortTable[0x84AE]=28702;   // yu
   sortTable[0x854D]=28703;   // yu
   sortTable[0x860C]=28704;   // yu
   sortTable[0x861B]=28705;   // yu
   sortTable[0x87B8]=28706;   // yu
   sortTable[0x935D]=28707;   // yu
   sortTable[0x9653]=28708;   // yu
   sortTable[0x96D3]=28709;   // yu
   sortTable[0x9947]=28710;   // yu
   sortTable[0x9C4A]=28711;   // yu
   sortTable[0x9D52]=28712;   // yu
   sortTable[0x9DF8]=28713;   // yu
   sortTable[0x9E06]=28714;   // yu
   sortTable[0x4E7B]=28715;   // yu
   sortTable[0x4E90]=28716;   // yu
   sortTable[0x4F03]=28717;   // yu
   sortTable[0x4FC1]=28718;   // yu
   sortTable[0x4FFC]=28719;   // yu
   sortTable[0x504A]=28720;   // yu
   sortTable[0x50B4]=28721;   // yu
   sortTable[0x5125]=28722;   // yu
   sortTable[0x516A]=28723;   // yu
   sortTable[0x532C]=28724;   // yu
   sortTable[0x5539]=28725;   // yu
   sortTable[0x5585]=28726;   // yu
   sortTable[0x5590]=28727;   // yu
   sortTable[0x55A9]=28728;   // yu
   sortTable[0x564A]=28729;   // yu
   sortTable[0x5673]=28730;   // yu
   sortTable[0x572B]=28731;   // yu
   sortTable[0x5809]=28732;   // yu
   sortTable[0x5823]=28733;   // yu
   sortTable[0x582C]=28734;   // yu
   sortTable[0x5A2F]=28735;   // yu
   sortTable[0x5A80]=28736;   // yu
   sortTable[0x5AD7]=28737;   // yu
   sortTable[0x5B29]=28738;   // yu
   sortTable[0x5BD9]=28739;   // yu
   sortTable[0x5CFF]=28740;   // yu
   sortTable[0x5D33]=28741;   // yu
   sortTable[0x5D4E]=28742;   // yu
   sortTable[0x5D8E]=28743;   // yu
   sortTable[0x5EBD]=28744;   // yu
   sortTable[0x5F67]=28745;   // yu
   sortTable[0x5FEC]=28746;   // yu
   sortTable[0x6086]=28747;   // yu
   sortTable[0x60D0]=28748;   // yu
   sortTable[0x617E]=28749;   // yu
   sortTable[0x61D9]=28750;   // yu
   sortTable[0x622B]=28751;   // yu
   sortTable[0x625C]=28752;   // yu
   sortTable[0x6275]=28753;   // yu
   sortTable[0x6327]=28754;   // yu
   sortTable[0x6554]=28755;   // yu
   sortTable[0x6594]=28756;   // yu
   sortTable[0x659E]=28757;   // yu
   sortTable[0x65D5]=28758;   // yu
   sortTable[0x65DF]=28759;   // yu
   sortTable[0x6745]=28760;   // yu
   sortTable[0x6859]=28761;   // yu
   sortTable[0x68DB]=28762;   // yu
   sortTable[0x68DC]=28763;   // yu
   sortTable[0x68EB]=28764;   // yu
   sortTable[0x6940]=28765;   // yu
   sortTable[0x6961]=28766;   // yu
   sortTable[0x6970]=28767;   // yu
   sortTable[0x6AF2]=28768;   // yu
   sortTable[0x6B0E]=28769;   // yu
   sortTable[0x6B1D]=28770;   // yu
   sortTable[0x6B48]=28771;   // yu
   sortTable[0x6B5F]=28772;   // yu
   sortTable[0x6B76]=28773;   // yu
   sortTable[0x6BFA]=28774;   // yu
   sortTable[0x6DE2]=28775;   // yu
   sortTable[0x6DEF]=28776;   // yu
   sortTable[0x6E61]=28777;   // yu
   sortTable[0x6EEA]=28778;   // yu
   sortTable[0x6F4F]=28779;   // yu
   sortTable[0x6F9A]=28780;   // yu
   sortTable[0x6F9E]=28781;   // yu
   sortTable[0x6FA6]=28782;   // yu
   sortTable[0x706A]=28783;   // yu
   sortTable[0x7134]=28784;   // yu
   sortTable[0x71CF]=28785;   // yu
   sortTable[0x7229]=28786;   // yu
   sortTable[0x724F]=28787;   // yu
   sortTable[0x7397]=28788;   // yu
   sortTable[0x7399]=28789;   // yu
   sortTable[0x7419]=28790;   // yu
   sortTable[0x7440]=28791;   // yu
   sortTable[0x74B5]=28792;   // yu
   sortTable[0x756D]=28793;   // yu
   sortTable[0x7609]=28794;   // yu
   sortTable[0x7652]=28795;   // yu
   sortTable[0x7821]=28796;   // yu
   sortTable[0x7862]=28797;   // yu
   sortTable[0x7916]=28798;   // yu
   sortTable[0x79D7]=28799;   // yu
   sortTable[0x7A36]=28800;   // yu
   sortTable[0x7A65]=28801;   // yu
   sortTable[0x7B8A]=28802;   // yu
   sortTable[0x7D06]=28803;   // yu
   sortTable[0x828C]=28804;   // yu
   sortTable[0x842E]=28805;   // yu
   sortTable[0x84F9]=28806;   // yu
   sortTable[0x8676]=28807;   // yu
   sortTable[0x871F]=28808;   // yu
   sortTable[0x8867]=28809;   // yu
   sortTable[0x89A6]=28810;   // yu
   sortTable[0x8AED]=28811;   // yu
   sortTable[0x8F0D]=28812;   // yu
   sortTable[0x8FC3]=28813;   // yu
   sortTable[0x9033]=28814;   // yu
   sortTable[0x9151]=28815;   // yu
   sortTable[0x91A7]=28816;   // yu
   sortTable[0x92D9]=28817;   // yu
   sortTable[0x9731]=28818;   // yu
   sortTable[0x99AD]=28819;   // yu
   sortTable[0x9AAC]=28820;   // yu
   sortTable[0x9B30]=28821;   // yu
   sortTable[0x9B4A]=28822;   // yu
   sortTable[0x9BF2]=28823;   // yu
   sortTable[0x9DE0]=28824;   // yu
   sortTable[0x9F6C]=28825;   // yu
   sortTable[0x5458]=28826;   // yuan
   sortTable[0x54E1]=28827;   // yuan
   sortTable[0x539F]=28828;   // yuan
   sortTable[0x8FDC]=28829;   // yuan
   sortTable[0x9060]=28830;   // yuan
   sortTable[0x9662]=28831;   // yuan
   sortTable[0x613F]=28832;   // yuan
   sortTable[0x6E90]=28833;   // yuan
   sortTable[0x5143]=28834;   // yuan
   sortTable[0x56ED]=28835;   // yuan
   sortTable[0x5712]=28836;   // yuan
   sortTable[0x5706]=28837;   // yuan
   sortTable[0x5713]=28838;   // yuan
   sortTable[0x63F4]=28839;   // yuan
   sortTable[0x733F]=28840;   // yuan
   sortTable[0x7F18]=28841;   // yuan
   sortTable[0x7DE3]=28842;   // yuan
   sortTable[0x51A4]=28843;   // yuan
   sortTable[0x6028]=28844;   // yuan
   sortTable[0x8881]=28845;   // yuan
   sortTable[0x6E0A]=28846;   // yuan
   sortTable[0x82D1]=28847;   // yuan
   sortTable[0x57A3]=28848;   // yuan
   sortTable[0x9E33]=28849;   // yuan
   sortTable[0x8F95]=28850;   // yuan
   sortTable[0x7230]=28851;   // yuan
   sortTable[0x63BE]=28852;   // yuan
   sortTable[0x5A9B]=28853;   // yuan
   sortTable[0x6C85]=28854;   // yuan
   sortTable[0x9F0B]=28855;   // yuan
   sortTable[0x7457]=28856;   // yuan
   sortTable[0x9E22]=28857;   // yuan
   sortTable[0x8788]=28858;   // yuan
   sortTable[0x6A7C]=28859;   // yuan
   sortTable[0x7722]=28860;   // yuan
   sortTable[0x586C]=28861;   // yuan
   sortTable[0x9E53]=28862;   // yuan
   sortTable[0x875D]=28863;   // yuan
   sortTable[0x8B1C]=28864;   // yuan
   sortTable[0x57B8]=28865;   // yuan
   sortTable[0x8696]=28866;   // yuan
   sortTable[0x9B6D]=28867;   // yuan
   sortTable[0x7BA2]=28868;   // yuan
   sortTable[0x9228]=28869;   // yuan
   sortTable[0x8312]=28870;   // yuan
   sortTable[0x7B0E]=28871;   // yuan
   sortTable[0x8099]=28872;   // yuan
   sortTable[0x870E]=28873;   // yuan
   sortTable[0x9A35]=28874;   // yuan
   sortTable[0x92FA]=28875;   // yuan
   sortTable[0x90A7]=28876;   // yuan
   sortTable[0x7FB1]=28877;   // yuan
   sortTable[0x8D20]=28878;   // yuan
   sortTable[0x9858]=28879;   // yuan
   sortTable[0x876F]=28880;   // yuan
   sortTable[0x884F]=28881;   // yuan
   sortTable[0x9D77]=28882;   // yuan
   sortTable[0x847E]=28883;   // yuan
   sortTable[0x8911]=28884;   // yuan
   sortTable[0x908D]=28885;   // yuan
   sortTable[0x9EFF]=28886;   // yuan
   sortTable[0x9F18]=28887;   // yuan
   sortTable[0x9F1D]=28888;   // yuan
   sortTable[0x88F7]=28889;   // yuan
   sortTable[0x9DA2]=28890;   // yuan
   sortTable[0x7990]=28891;   // yuan
   sortTable[0x7E01]=28892;   // yuan
   sortTable[0x8597]=28893;   // yuan
   sortTable[0x8C9F]=28894;   // yuan
   sortTable[0x99CC]=28895;   // yuan
   sortTable[0x9CF6]=28896;   // yuan
   sortTable[0x5086]=28897;   // yuan
   sortTable[0x5186]=28898;   // yuan
   sortTable[0x5248]=28899;   // yuan
   sortTable[0x53A1]=28900;   // yuan
   sortTable[0x53B5]=28901;   // yuan
   sortTable[0x566E]=28902;   // yuan
   sortTable[0x56E6]=28903;   // yuan
   sortTable[0x570E]=28904;   // yuan
   sortTable[0x5917]=28905;   // yuan
   sortTable[0x59B4]=28906;   // yuan
   sortTable[0x5AB4]=28907;   // yuan
   sortTable[0x5AC4]=28908;   // yuan
   sortTable[0x5B3D]=28909;   // yuan
   sortTable[0x5BC3]=28910;   // yuan
   sortTable[0x6081]=28911;   // yuan
   sortTable[0x60CC]=28912;   // yuan
   sortTable[0x676C]=28913;   // yuan
   sortTable[0x68E9]=28914;   // yuan
   sortTable[0x699E]=28915;   // yuan
   sortTable[0x69AC]=28916;   // yuan
   sortTable[0x6ADE]=28917;   // yuan
   sortTable[0x6DF5]=28918;   // yuan
   sortTable[0x6E01]=28919;   // yuan
   sortTable[0x6E06]=28920;   // yuan
   sortTable[0x6E15]=28921;   // yuan
   sortTable[0x6E72]=28922;   // yuan
   sortTable[0x6E92]=28923;   // yuan
   sortTable[0x7041]=28924;   // yuan
   sortTable[0x7328]=28925;   // yuan
   sortTable[0x7342]=28926;   // yuan
   sortTable[0x76F6]=28927;   // yuan
   sortTable[0x849D]=28928;   // yuan
   sortTable[0x84AC]=28929;   // yuan
   sortTable[0x8735]=28930;   // yuan
   sortTable[0x88EB]=28931;   // yuan
   sortTable[0x8924]=28932;   // yuan
   sortTable[0x8F45]=28933;   // yuan
   sortTable[0x903A]=28934;   // yuan
   sortTable[0x915B]=28935;   // yuan
   sortTable[0x93B1]=28936;   // yuan
   sortTable[0x9D1B]=28937;   // yuan
   sortTable[0x9DB0]=28938;   // yuan
   sortTable[0x6708]=28939;   // yue
   sortTable[0x8D8A]=28940;   // yue
   sortTable[0x7EA6]=28941;   // yue
   sortTable[0x7D04]=28942;   // yue
   sortTable[0x8DC3]=28943;   // yue
   sortTable[0x8E8D]=28944;   // yue
   sortTable[0x60A6]=28945;   // yue
   sortTable[0x6085]=28946;   // yue
   sortTable[0x9605]=28947;   // yue
   sortTable[0x95B1]=28948;   // yue
   sortTable[0x66F0]=28949;   // yue
   sortTable[0x5CB3]=28950;   // yue
   sortTable[0x7CA4]=28951;   // yue
   sortTable[0x94BA]=28952;   // yue
   sortTable[0x5216]=28953;   // yue
   sortTable[0x6A3E]=28954;   // yue
   sortTable[0x9FA0]=28955;   // yue
   sortTable[0x7C65]=28956;   // yue
   sortTable[0x7039]=28957;   // yue
   sortTable[0x8ECF]=28958;   // yue
   sortTable[0x9E11]=28959;   // yue
   sortTable[0x793F]=28960;   // yue
   sortTable[0x79B4]=28961;   // yue
   sortTable[0x77F1]=28962;   // yue
   sortTable[0x7CB5]=28963;   // yue
   sortTable[0x8DC0]=28964;   // yue
   sortTable[0x7BB9]=28965;   // yue
   sortTable[0x868F]=28966;   // yue
   sortTable[0x7C46]=28967;   // yue
   sortTable[0x9EE6]=28968;   // yue
   sortTable[0x7C70]=28969;   // yue
   sortTable[0x8625]=28970;   // yue
   sortTable[0x599C]=28971;   // yue
   sortTable[0x5B33]=28972;   // yue
   sortTable[0x5C84]=28973;   // yue
   sortTable[0x5DBD]=28974;   // yue
   sortTable[0x5F5F]=28975;   // yue
   sortTable[0x5F60]=28976;   // yue
   sortTable[0x6071]=28977;   // yue
   sortTable[0x6209]=28978;   // yue
   sortTable[0x6288]=28979;   // yue
   sortTable[0x6373]=28980;   // yue
   sortTable[0x66F1]=28981;   // yue
   sortTable[0x721A]=28982;   // yue
   sortTable[0x73A5]=28983;   // yue
   sortTable[0x7BD7]=28984;   // yue
   sortTable[0x868E]=28985;   // yue
   sortTable[0x9205]=28986;   // yue
   sortTable[0x925E]=28987;   // yue
   sortTable[0x95B2]=28988;   // yue
   sortTable[0x9E19]=28989;   // yue
   sortTable[0x8FD0]=28990;   // yun
   sortTable[0x904B]=28991;   // yun
   sortTable[0x4E91]=28992;   // yun
   sortTable[0x5141]=28993;   // yun
   sortTable[0x5300]=28994;   // yun
   sortTable[0x52FB]=28995;   // yun
   sortTable[0x6655]=28996;   // yun
   sortTable[0x6688]=28997;   // yun
   sortTable[0x8574]=28998;   // yun
   sortTable[0x860A]=28999;   // yun
   sortTable[0x97F5]=29000;   // yun
   sortTable[0x5B55]=29001;   // yun
   sortTable[0x9668]=29002;   // yun
   sortTable[0x82B8]=29003;   // yun
   sortTable[0x915D]=29004;   // yun
   sortTable[0x7B60]=29005;   // yun
   sortTable[0x90E7]=29006;   // yun
   sortTable[0x90D3]=29007;   // yun
   sortTable[0x7EAD]=29008;   // yun
   sortTable[0x6C32]=29009;   // yun
   sortTable[0x8018]=29010;   // yun
   sortTable[0x6120]=29011;   // yun
   sortTable[0x607D]=29012;   // yun
   sortTable[0x6B92]=29013;   // yun
   sortTable[0x92C6]=29014;   // yun
   sortTable[0x97EB]=29015;   // yun
   sortTable[0x71A8]=29016;   // yun
   sortTable[0x8D5F]=29017;   // yun
   sortTable[0x6600]=29018;   // yun
   sortTable[0x9835]=29019;   // yun
   sortTable[0x9196]=29020;   // yun
   sortTable[0x72C1]=29021;   // yun
   sortTable[0x7F0A]=29022;   // yun
   sortTable[0x97FB]=29023;   // yun
   sortTable[0x9723]=29024;   // yun
   sortTable[0x992B]=29025;   // yun
   sortTable[0x85F4]=29026;   // yun
   sortTable[0x7B7C]=29027;   // yun
   sortTable[0x8D07]=29028;   // yun
   sortTable[0x96F2]=29029;   // yun
   sortTable[0x8580]=29030;   // yun
   sortTable[0x7E15]=29031;   // yun
   sortTable[0x84B7]=29032;   // yun
   sortTable[0x837A]=29033;   // yun
   sortTable[0x7DF7]=29034;   // yun
   sortTable[0x816A]=29035;   // yun
   sortTable[0x8779]=29036;   // yun
   sortTable[0x9217]=29037;   // yun
   sortTable[0x99A7]=29038;   // yun
   sortTable[0x7DFC]=29039;   // yun
   sortTable[0x97D7]=29040;   // yun
   sortTable[0x7703]=29041;   // yun
   sortTable[0x891E]=29042;   // yun
   sortTable[0x99BB]=29043;   // yun
   sortTable[0x7E1C]=29044;   // yun
   sortTable[0x8CF1]=29045;   // yun
   sortTable[0x9F73]=29046;   // yun
   sortTable[0x7BD4]=29047;   // yun
   sortTable[0x7E67]=29048;   // yun
   sortTable[0x8480]=29049;   // yun
   sortTable[0x8495]=29050;   // yun
   sortTable[0x919E]=29051;   // yun
   sortTable[0x962D]=29052;   // yun
   sortTable[0x508A]=29053;   // yun
   sortTable[0x5597]=29054;   // yun
   sortTable[0x56E9]=29055;   // yun
   sortTable[0x593D]=29056;   // yun
   sortTable[0x596B]=29057;   // yun
   sortTable[0x5998]=29058;   // yun
   sortTable[0x60F2]=29059;   // yun
   sortTable[0x612A]=29060;   // yun
   sortTable[0x614D]=29061;   // yun
   sortTable[0x628E]=29062;   // yun
   sortTable[0x62A3]=29063;   // yun
   sortTable[0x679F]=29064;   // yun
   sortTable[0x69B2]=29065;   // yun
   sortTable[0x6A52]=29066;   // yun
   sortTable[0x6B9E]=29067;   // yun
   sortTable[0x6C33]=29068;   // yun
   sortTable[0x6C84]=29069;   // yun
   sortTable[0x6DA2]=29070;   // yun
   sortTable[0x6EB3]=29071;   // yun
   sortTable[0x6F90]=29072;   // yun
   sortTable[0x7174]=29073;   // yun
   sortTable[0x7185]=29074;   // yun
   sortTable[0x7189]=29075;   // yun
   sortTable[0x7547]=29076;   // yun
   sortTable[0x78D2]=29077;   // yun
   sortTable[0x79D0]=29078;   // yun
   sortTable[0x7D1C]=29079;   // yun
   sortTable[0x803A]=29080;   // yun
   sortTable[0x8553]=29081;   // yun
   sortTable[0x9106]=29082;   // yun
   sortTable[0x9116]=29083;   // yun
   sortTable[0x9695]=29084;   // yun
   sortTable[0x97DE]=29085;   // yun
   sortTable[0x9942]=29086;   // yun
   sortTable[0x6742]=29440;   // za
   sortTable[0x96DC]=29441;   // za
   sortTable[0x7838]=29442;   // za
   sortTable[0x5482]=29443;   // za
   sortTable[0x548B]=29444;   // za
   sortTable[0x531D]=29445;   // za
   sortTable[0x62F6]=29446;   // za
   sortTable[0x81DC]=29447;   // za
   sortTable[0x7D25]=29448;   // za
   sortTable[0x81E2]=29449;   // za
   sortTable[0x7D2E]=29450;   // za
   sortTable[0x894D]=29451;   // za
   sortTable[0x9B73]=29452;   // za
   sortTable[0x97F4]=29453;   // za
   sortTable[0x78FC]=29454;   // za
   sortTable[0x8FCA]=29455;   // za
   sortTable[0x9254]=29456;   // za
   sortTable[0x96D1]=29457;   // za
   sortTable[0x96E5]=29458;   // za
   sortTable[0x507A]=29459;   // za
   sortTable[0x5592]=29460;   // za
   sortTable[0x56CB]=29461;   // za
   sortTable[0x56D0]=29462;   // za
   sortTable[0x5DBB]=29463;   // za
   sortTable[0x5E00]=29464;   // za
   sortTable[0x6C9E]=29465;   // za
   sortTable[0x5728]=29466;   // zai
   sortTable[0x518D]=29467;   // zai
   sortTable[0x707E]=29468;   // zai
   sortTable[0x707D]=29469;   // zai
   sortTable[0x8F7D]=29470;   // zai
   sortTable[0x8F09]=29471;   // zai
   sortTable[0x683D]=29472;   // zai
   sortTable[0x5BB0]=29473;   // zai
   sortTable[0x5D3D]=29474;   // zai
   sortTable[0x54C9]=29475;   // zai
   sortTable[0x83D1]=29476;   // zai
   sortTable[0x753E]=29477;   // zai
   sortTable[0x7E21]=29478;   // zai
   sortTable[0x8CF3]=29479;   // zai
   sortTable[0x9168]=29480;   // zai
   sortTable[0x4FA2]=29481;   // zai
   sortTable[0x50A4]=29482;   // zai
   sortTable[0x510E]=29483;   // zai
   sortTable[0x6257]=29484;   // zai
   sortTable[0x6D05]=29485;   // zai
   sortTable[0x6E3D]=29486;   // zai
   sortTable[0x70D6]=29487;   // zai
   sortTable[0x7775]=29488;   // zai
   sortTable[0x54B1]=29489;   // zan
   sortTable[0x8D5E]=29490;   // zan
   sortTable[0x8D0A]=29491;   // zan
   sortTable[0x6682]=29492;   // zan
   sortTable[0x66AB]=29493;   // zan
   sortTable[0x6512]=29494;   // zan
   sortTable[0x6522]=29495;   // zan
   sortTable[0x7C2A]=29496;   // zan
   sortTable[0x74D2]=29497;   // zan
   sortTable[0x933E]=29498;   // zan
   sortTable[0x661D]=29499;   // zan
   sortTable[0x8DB1]=29500;   // zan
   sortTable[0x7CCC]=29501;   // zan
   sortTable[0x9147]=29502;   // zan
   sortTable[0x8E54]=29503;   // zan
   sortTable[0x9415]=29504;   // zan
   sortTable[0x9961]=29505;   // zan
   sortTable[0x8B9A]=29506;   // zan
   sortTable[0x7C2E]=29507;   // zan
   sortTable[0x8DB2]=29508;   // zan
   sortTable[0x79B6]=29509;   // zan
   sortTable[0x8978]=29510;   // zan
   sortTable[0x941F]=29511;   // zan
   sortTable[0x5127]=29512;   // zan
   sortTable[0x5139]=29513;   // zan
   sortTable[0x5142]=29514;   // zan
   sortTable[0x5646]=29515;   // zan
   sortTable[0x5BC1]=29516;   // zan
   sortTable[0x63DD]=29517;   // zan
   sortTable[0x648D]=29518;   // zan
   sortTable[0x6505]=29519;   // zan
   sortTable[0x685A]=29520;   // zan
   sortTable[0x6CAF]=29521;   // zan
   sortTable[0x6FFD]=29522;   // zan
   sortTable[0x7052]=29523;   // zan
   sortTable[0x74C9]=29524;   // zan
   sortTable[0x74DA]=29525;   // zan
   sortTable[0x7938]=29526;   // zan
   sortTable[0x8B83]=29527;   // zan
   sortTable[0x8CDB]=29528;   // zan
   sortTable[0x913C]=29529;   // zan
   sortTable[0x93E8]=29530;   // zan
   sortTable[0x810F]=29531;   // zang
   sortTable[0x81DF]=29532;   // zang
   sortTable[0x846C]=29533;   // zang
   sortTable[0x8D43]=29534;   // zang
   sortTable[0x81E7]=29535;   // zang
   sortTable[0x5958]=29536;   // zang
   sortTable[0x9A75]=29537;   // zang
   sortTable[0x9AD2]=29538;   // zang
   sortTable[0x81D3]=29539;   // zang
   sortTable[0x8D13]=29540;   // zang
   sortTable[0x99D4]=29541;   // zang
   sortTable[0x8535]=29542;   // zang
   sortTable[0x8D1C]=29543;   // zang
   sortTable[0x5328]=29544;   // zang
   sortTable[0x585F]=29545;   // zang
   sortTable[0x5F09]=29546;   // zang
   sortTable[0x7242]=29547;   // zang
   sortTable[0x7F98]=29548;   // zang
   sortTable[0x8CCD]=29549;   // zang
   sortTable[0x8CD8]=29550;   // zang
   sortTable[0x92BA]=29551;   // zang
   sortTable[0x9020]=29552;   // zao
   sortTable[0x65E9]=29553;   // zao
   sortTable[0x906D]=29554;   // zao
   sortTable[0x7CDF]=29555;   // zao
   sortTable[0x7682]=29556;   // zao
   sortTable[0x51FF]=29557;   // zao
   sortTable[0x947F]=29558;   // zao
   sortTable[0x8E81]=29559;   // zao
   sortTable[0x71E5]=29560;   // zao
   sortTable[0x7076]=29561;   // zao
   sortTable[0x6FA1]=29562;   // zao
   sortTable[0x67A3]=29563;   // zao
   sortTable[0x68D7]=29564;   // zao
   sortTable[0x566A]=29565;   // zao
   sortTable[0x85FB]=29566;   // zao
   sortTable[0x86A4]=29567;   // zao
   sortTable[0x5523]=29568;   // zao
   sortTable[0x7C09]=29569;   // zao
   sortTable[0x8241]=29570;   // zao
   sortTable[0x8B5F]=29571;   // zao
   sortTable[0x8DAE]=29572;   // zao
   sortTable[0x8E67]=29573;   // zao
   sortTable[0x7E70]=29574;   // zao
   sortTable[0x7AC3]=29575;   // zao
   sortTable[0x7AC8]=29576;   // zao
   sortTable[0x50AE]=29577;   // zao
   sortTable[0x5515]=29578;   // zao
   sortTable[0x55BF]=29579;   // zao
   sortTable[0x6165]=29580;   // zao
   sortTable[0x6806]=29581;   // zao
   sortTable[0x688D]=29582;   // zao
   sortTable[0x74AA]=29583;   // zao
   sortTable[0x7681]=29584;   // zao
   sortTable[0x85BB]=29585;   // zao
   sortTable[0x91A9]=29586;   // zao
   sortTable[0x5219]=29587;   // ze
   sortTable[0x5247]=29588;   // ze
   sortTable[0x8D23]=29589;   // ze
   sortTable[0x8CAC]=29590;   // ze
   sortTable[0x62E9]=29591;   // ze
   sortTable[0x64C7]=29592;   // ze
   sortTable[0x6CFD]=29593;   // ze
   sortTable[0x8D5C]=29594;   // ze
   sortTable[0x4EC4]=29595;   // ze
   sortTable[0x5567]=29596;   // ze
   sortTable[0x7B2E]=29597;   // ze
   sortTable[0x5E3B]=29598;   // ze
   sortTable[0x6603]=29599;   // ze
   sortTable[0x8234]=29600;   // ze
   sortTable[0x7BA6]=29601;   // ze
   sortTable[0x8FEE]=29602;   // ze
   sortTable[0x835D]=29603;   // ze
   sortTable[0x9F70]=29604;   // ze
   sortTable[0x9F5A]=29605;   // ze
   sortTable[0x790B]=29606;   // ze
   sortTable[0x880C]=29607;   // ze
   sortTable[0x8957]=29608;   // ze
   sortTable[0x9E05]=29609;   // ze
   sortTable[0x77E0]=29610;   // ze
   sortTable[0x8B2E]=29611;   // ze
   sortTable[0x7794]=29612;   // ze
   sortTable[0x4F2C]=29613;   // ze
   sortTable[0x5536]=29614;   // ze
   sortTable[0x5616]=29615;   // ze
   sortTable[0x5928]=29616;   // ze
   sortTable[0x5AE7]=29617;   // ze
   sortTable[0x5D31]=29618;   // ze
   sortTable[0x5E58]=29619;   // ze
   sortTable[0x5E82]=29620;   // ze
   sortTable[0x629E]=29621;   // ze
   sortTable[0x6351]=29622;   // ze
   sortTable[0x6617]=29623;   // ze
   sortTable[0x6A0D]=29624;   // ze
   sortTable[0x6C44]=29625;   // ze
   sortTable[0x6CA2]=29626;   // ze
   sortTable[0x6CCE]=29627;   // ze
   sortTable[0x6EAD]=29628;   // ze
   sortTable[0x6FA4]=29629;   // ze
   sortTable[0x769F]=29630;   // ze
   sortTable[0x7C00]=29631;   // ze
   sortTable[0x8536]=29632;   // ze
   sortTable[0x8ACE]=29633;   // ze
   sortTable[0x8CFE]=29634;   // ze
   sortTable[0x8D3C]=29635;   // zei
   sortTable[0x8CCA]=29636;   // zei
   sortTable[0x8808]=29637;   // zei
   sortTable[0x9C97]=29638;   // zei
   sortTable[0x9BFD]=29639;   // zei
   sortTable[0x621D]=29640;   // zei
   sortTable[0x9C02]=29641;   // zei
   sortTable[0x9C61]=29642;   // zei
   sortTable[0x600E]=29643;   // zen
   sortTable[0x8C2E]=29644;   // zen
   sortTable[0x8B5B]=29645;   // zen
   sortTable[0x56CE]=29646;   // zen
   sortTable[0x8B56]=29647;   // zen
   sortTable[0x589E]=29648;   // zeng
   sortTable[0x8D60]=29649;   // zeng
   sortTable[0x618E]=29650;   // zeng
   sortTable[0x7F2F]=29651;   // zeng
   sortTable[0x7511]=29652;   // zeng
   sortTable[0x7F7E]=29653;   // zeng
   sortTable[0x9503]=29654;   // zeng
   sortTable[0x912B]=29655;   // zeng
   sortTable[0x77F0]=29656;   // zeng
   sortTable[0x8D08]=29657;   // zeng
   sortTable[0x8B44]=29658;   // zeng
   sortTable[0x7E52]=29659;   // zeng
   sortTable[0x78F3]=29660;   // zeng
   sortTable[0x5897]=29661;   // zeng
   sortTable[0x6A67]=29662;   // zeng
   sortTable[0x71B7]=29663;   // zeng
   sortTable[0x7494]=29664;   // zeng
   sortTable[0x92E5]=29665;   // zeng
   sortTable[0x9C5B]=29666;   // zeng
   sortTable[0x70B8]=29667;   // zha
   sortTable[0x624E]=29668;   // zha
   sortTable[0x7728]=29669;   // zha
   sortTable[0x6E23]=29670;   // zha
   sortTable[0x95F8]=29671;   // zha
   sortTable[0x9598]=29672;   // zha
   sortTable[0x8BC8]=29673;   // zha
   sortTable[0x672D]=29674;   // zha
   sortTable[0x6805]=29675;   // zha
   sortTable[0x4E4D]=29676;   // zha
   sortTable[0x5412]=29677;   // zha
   sortTable[0x94E1]=29678;   // zha
   sortTable[0x55B3]=29679;   // zha
   sortTable[0x86B1]=29680;   // zha
   sortTable[0x69A8]=29681;   // zha
   sortTable[0x54A4]=29682;   // zha
   sortTable[0x67DE]=29683;   // zha
   sortTable[0x6942]=29684;   // zha
   sortTable[0x781F]=29685;   // zha
   sortTable[0x9705]=29686;   // zha
   sortTable[0x9C8A]=29687;   // zha
   sortTable[0x63F8]=29688;   // zha
   sortTable[0x9C9D]=29689;   // zha
   sortTable[0x91A1]=29690;   // zha
   sortTable[0x54F3]=29691;   // zha
   sortTable[0x75C4]=29692;   // zha
   sortTable[0x9F44]=29693;   // zha
   sortTable[0x82F2]=29694;   // zha
   sortTable[0x9358]=29695;   // zha
   sortTable[0x7B9A]=29696;   // zha
   sortTable[0x8B57]=29697;   // zha
   sortTable[0x8E37]=29698;   // zha
   sortTable[0x9B93]=29699;   // zha
   sortTable[0x9F47]=29700;   // zha
   sortTable[0x86BB]=29701;   // zha
   sortTable[0x89F0]=29702;   // zha
   sortTable[0x8A50]=29703;   // zha
   sortTable[0x5067]=29704;   // zha
   sortTable[0x5284]=29705;   // zha
   sortTable[0x538F]=29706;   // zha
   sortTable[0x5953]=29707;   // zha
   sortTable[0x5BB1]=29708;   // zha
   sortTable[0x62AF]=29709;   // zha
   sortTable[0x62C3]=29710;   // zha
   sortTable[0x6313]=29711;   // zha
   sortTable[0x6429]=29712;   // zha
   sortTable[0x643E]=29713;   // zha
   sortTable[0x6463]=29714;   // zha
   sortTable[0x67E4]=29715;   // zha
   sortTable[0x67FB]=29716;   // zha
   sortTable[0x6A1D]=29717;   // zha
   sortTable[0x6EA0]=29718;   // zha
   sortTable[0x7079]=29719;   // zha
   sortTable[0x7160]=29720;   // zha
   sortTable[0x7250]=29721;   // zha
   sortTable[0x7534]=29722;   // zha
   sortTable[0x76B6]=29723;   // zha
   sortTable[0x76BB]=29724;   // zha
   sortTable[0x802B]=29725;   // zha
   sortTable[0x8B47]=29726;   // zha
   sortTable[0x9BBA]=29727;   // zha
   sortTable[0x6458]=29728;   // zhai
   sortTable[0x5B85]=29729;   // zhai
   sortTable[0x7A84]=29730;   // zhai
   sortTable[0x503A]=29731;   // zhai
   sortTable[0x50B5]=29732;   // zhai
   sortTable[0x5BE8]=29733;   // zhai
   sortTable[0x658B]=29734;   // zhai
   sortTable[0x7FDF]=29735;   // zhai
   sortTable[0x7826]=29736;   // zhai
   sortTable[0x7635]=29737;   // zhai
   sortTable[0x9F4B]=29738;   // zhai
   sortTable[0x5908]=29739;   // zhai
   sortTable[0x635A]=29740;   // zhai
   sortTable[0x658E]=29741;   // zhai
   sortTable[0x69B8]=29742;   // zhai
   sortTable[0x6AA1]=29743;   // zhai
   sortTable[0x7C82]=29744;   // zhai
   sortTable[0x9259]=29745;   // zhai
   sortTable[0x6218]=29746;   // zhan
   sortTable[0x6230]=29747;   // zhan
   sortTable[0x5C55]=29748;   // zhan
   sortTable[0x7AD9]=29749;   // zhan
   sortTable[0x5360]=29750;   // zhan
   sortTable[0x76CF]=29751;   // zhan
   sortTable[0x76DE]=29752;   // zhan
   sortTable[0x6CBE]=29753;   // zhan
   sortTable[0x5D2D]=29754;   // zhan
   sortTable[0x5D84]=29755;   // zhan
   sortTable[0x7C98]=29756;   // zhan
   sortTable[0x6BE1]=29757;   // zhan
   sortTable[0x6C08]=29758;   // zhan
   sortTable[0x77BB]=29759;   // zhan
   sortTable[0x8638]=29760;   // zhan
   sortTable[0x65A9]=29761;   // zhan
   sortTable[0x8A79]=29762;   // zhan
   sortTable[0x6E5B]=29763;   // zhan
   sortTable[0x6808]=29764;   // zhan
   sortTable[0x7EFD]=29765;   // zhan
   sortTable[0x65C3]=29766;   // zhan
   sortTable[0x98D0]=29767;   // zhan
   sortTable[0x9711]=29768;   // zhan
   sortTable[0x8C35]=29769;   // zhan
   sortTable[0x9E6F]=29770;   // zhan
   sortTable[0x9958]=29771;   // zhan
   sortTable[0x9085]=29772;   // zhan
   sortTable[0x9CE3]=29773;   // zhan
   sortTable[0x9C63]=29774;   // zhan
   sortTable[0x9186]=29775;   // zhan
   sortTable[0x640C]=29776;   // zhan
   sortTable[0x859D]=29777;   // zhan
   sortTable[0x8B9D]=29778;   // zhan
   sortTable[0x98E6]=29779;   // zhan
   sortTable[0x8F3E]=29780;   // zhan
   sortTable[0x9A4F]=29781;   // zhan
   sortTable[0x9E07]=29782;   // zhan
   sortTable[0x9EF5]=29783;   // zhan
   sortTable[0x83DA]=29784;   // zhan
   sortTable[0x8A40]=29785;   // zhan
   sortTable[0x98AD]=29786;   // zhan
   sortTable[0x8666]=29787;   // zhan
   sortTable[0x9A59]=29788;   // zhan
   sortTable[0x8665]=29789;   // zhan
   sortTable[0x8B6B]=29790;   // zhan
   sortTable[0x8F1A]=29791;   // zhan
   sortTable[0x86C5]=29792;   // zhan
   sortTable[0x8F4F]=29793;   // zhan
   sortTable[0x4F54]=29794;   // zhan
   sortTable[0x5061]=29795;   // zhan
   sortTable[0x5661]=29796;   // zhan
   sortTable[0x5AF8]=29797;   // zhan
   sortTable[0x5D83]=29798;   // zhan
   sortTable[0x5D98]=29799;   // zhan
   sortTable[0x5DA6]=29800;   // zhan
   sortTable[0x60C9]=29801;   // zhan
   sortTable[0x6226]=29802;   // zhan
   sortTable[0x65AC]=29803;   // zhan
   sortTable[0x65DC]=29804;   // zhan
   sortTable[0x6834]=29805;   // zhan
   sortTable[0x685F]=29806;   // zhan
   sortTable[0x68E7]=29807;   // zhan
   sortTable[0x692B]=29808;   // zhan
   sortTable[0x6990]=29809;   // zhan
   sortTable[0x6A4F]=29810;   // zhan
   sortTable[0x6C0A]=29811;   // zhan
   sortTable[0x7416]=29812;   // zhan
   sortTable[0x7DBB]=29813;   // zhan
   sortTable[0x89B1]=29814;   // zhan
   sortTable[0x8B67]=29815;   // zhan
   sortTable[0x8D88]=29816;   // zhan
   sortTable[0x959A]=29817;   // zhan
   sortTable[0x9B59]=29818;   // zhan
   sortTable[0x957F]=29819;   // zhang
   sortTable[0x9577]=29820;   // zhang
   sortTable[0x5F20]=29821;   // zhang
   sortTable[0x5F35]=29822;   // zhang
   sortTable[0x7AE0]=29823;   // zhang
   sortTable[0x638C]=29824;   // zhang
   sortTable[0x5E10]=29825;   // zhang
   sortTable[0x5E33]=29826;   // zhang
   sortTable[0x4ED7]=29827;   // zhang
   sortTable[0x4E08]=29828;   // zhang
   sortTable[0x969C]=29829;   // zhang
   sortTable[0x6DA8]=29830;   // zhang
   sortTable[0x6F32]=29831;   // zhang
   sortTable[0x80C0]=29832;   // zhang
   sortTable[0x8139]=29833;   // zhang
   sortTable[0x6A1F]=29834;   // zhang
   sortTable[0x6756]=29835;   // zhang
   sortTable[0x8D26]=29836;   // zhang
   sortTable[0x5F70]=29837;   // zhang
   sortTable[0x748B]=29838;   // zhang
   sortTable[0x6F33]=29839;   // zhang
   sortTable[0x7634]=29840;   // zhang
   sortTable[0x5D82]=29841;   // zhang
   sortTable[0x9123]=29842;   // zhang
   sortTable[0x7350]=29843;   // zhang
   sortTable[0x87D1]=29844;   // zhang
   sortTable[0x5ADC]=29845;   // zhang
   sortTable[0x9E9E]=29846;   // zhang
   sortTable[0x5E5B]=29847;   // zhang
   sortTable[0x4EC9]=29848;   // zhang
   sortTable[0x9926]=29849;   // zhang
   sortTable[0x7CBB]=29850;   // zhang
   sortTable[0x9423]=29851;   // zhang
   sortTable[0x7795]=29852;   // zhang
   sortTable[0x7903]=29853;   // zhang
   sortTable[0x9067]=29854;   // zhang
   sortTable[0x93F1]=29855;   // zhang
   sortTable[0x8501]=29856;   // zhang
   sortTable[0x9A3F]=29857;   // zhang
   sortTable[0x50BD]=29858;   // zhang
   sortTable[0x5887]=29859;   // zhang
   sortTable[0x5E65]=29860;   // zhang
   sortTable[0x615E]=29861;   // zhang
   sortTable[0x6259]=29862;   // zhang
   sortTable[0x66B2]=29863;   // zhang
   sortTable[0x6DB1]=29864;   // zhang
   sortTable[0x75EE]=29865;   // zhang
   sortTable[0x762C]=29866;   // zhang
   sortTable[0x7C80]=29867;   // zhang
   sortTable[0x8CEC]=29868;   // zhang
   sortTable[0x9C46]=29869;   // zhang
   sortTable[0x627E]=29870;   // zhao
   sortTable[0x7167]=29871;   // zhao
   sortTable[0x53EC]=29872;   // zhao
   sortTable[0x62DB]=29873;   // zhao
   sortTable[0x7F69]=29874;   // zhao
   sortTable[0x722A]=29875;   // zhao
   sortTable[0x8BCF]=29876;   // zhao
   sortTable[0x8D75]=29877;   // zhao
   sortTable[0x662D]=29878;   // zhao
   sortTable[0x5146]=29879;   // zhao
   sortTable[0x6CBC]=29880;   // zhao
   sortTable[0x8087]=29881;   // zhao
   sortTable[0x948A]=29882;   // zhao
   sortTable[0x68F9]=29883;   // zhao
   sortTable[0x7B0A]=29884;   // zhao
   sortTable[0x5541]=29885;   // zhao
   sortTable[0x9BA1]=29886;   // zhao
   sortTable[0x77BE]=29887;   // zhao
   sortTable[0x8D99]=29888;   // zhao
   sortTable[0x91D7]=29889;   // zhao
   sortTable[0x7ABC]=29890;   // zhao
   sortTable[0x9363]=29891;   // zhao
   sortTable[0x7F40]=29892;   // zhao
   sortTable[0x8081]=29893;   // zhao
   sortTable[0x8088]=29894;   // zhao
   sortTable[0x99CB]=29895;   // zhao
   sortTable[0x4F4B]=29896;   // zhao
   sortTable[0x5797]=29897;   // zhao
   sortTable[0x59B1]=29898;   // zhao
   sortTable[0x5DF6]=29899;   // zhao
   sortTable[0x65D0]=29900;   // zhao
   sortTable[0x66CC]=29901;   // zhao
   sortTable[0x679B]=29902;   // zhao
   sortTable[0x6AC2]=29903;   // zhao
   sortTable[0x70A4]=29904;   // zhao
   sortTable[0x71F3]=29905;   // zhao
   sortTable[0x722B]=29906;   // zhao
   sortTable[0x72E3]=29907;   // zhao
   sortTable[0x7475]=29908;   // zhao
   sortTable[0x76BD]=29909;   // zhao
   sortTable[0x76C4]=29910;   // zhao
   sortTable[0x7F84]=29911;   // zhao
   sortTable[0x8A54]=29912;   // zhao
   sortTable[0x924A]=29913;   // zhao
   sortTable[0x8FD9]=29914;   // zhe
   sortTable[0x9019]=29915;   // zhe
   sortTable[0x7740]=29916;   // zhe
   sortTable[0x8457]=29917;   // zhe
   sortTable[0x8005]=29918;   // zhe
   sortTable[0x54F2]=29919;   // zhe
   sortTable[0x6298]=29920;   // zhe
   sortTable[0x906E]=29921;   // zhe
   sortTable[0x8517]=29922;   // zhe
   sortTable[0x6D59]=29923;   // zhe
   sortTable[0x8F84]=29924;   // zhe
   sortTable[0x647A]=29925;   // zhe
   sortTable[0x8C2A]=29926;   // zhe
   sortTable[0x8F99]=29927;   // zhe
   sortTable[0x8936]=29928;   // zhe
   sortTable[0x9E67]=29929;   // zhe
   sortTable[0x86F0]=29930;   // zhe
   sortTable[0x8D6D]=29931;   // zhe
   sortTable[0x67D8]=29932;   // zhe
   sortTable[0x78D4]=29933;   // zhe
   sortTable[0x8707]=29934;   // zhe
   sortTable[0x9517]=29935;   // zhe
   sortTable[0x8A5F]=29936;   // zhe
   sortTable[0x7987]=29937;   // zhe
   sortTable[0x9BBF]=29938;   // zhe
   sortTable[0x8B3A]=29939;   // zhe
   sortTable[0x88A9]=29940;   // zhe
   sortTable[0x8F19]=29941;   // zhe
   sortTable[0x7C8D]=29942;   // zhe
   sortTable[0x77FA]=29943;   // zhe
   sortTable[0x99B2]=29944;   // zhe
   sortTable[0x8975]=29945;   // zhe
   sortTable[0x8B2B]=29946;   // zhe
   sortTable[0x87C5]=29947;   // zhe
   sortTable[0x8B81]=29948;   // zhe
   sortTable[0x8B8B]=29949;   // zhe
   sortTable[0x8F12]=29950;   // zhe
   sortTable[0x4E7D]=29951;   // zhe
   sortTable[0x5387]=29952;   // zhe
   sortTable[0x5560]=29953;   // zhe
   sortTable[0x556B]=29954;   // zhe
   sortTable[0x5586]=29955;   // zhe
   sortTable[0x55FB]=29956;   // zhe
   sortTable[0x569E]=29957;   // zhe
   sortTable[0x57D1]=29958;   // zhe
   sortTable[0x5AEC]=29959;   // zhe
   sortTable[0x608A]=29960;   // zhe
   sortTable[0x6662]=29961;   // zhe
   sortTable[0x6663]=29962;   // zhe
   sortTable[0x6A1C]=29963;   // zhe
   sortTable[0x6B7D]=29964;   // zhe
   sortTable[0x6DDB]=29965;   // zhe
   sortTable[0x6F6A]=29966;   // zhe
   sortTable[0x7813]=29967;   // zhe
   sortTable[0x7C77]=29968;   // zhe
   sortTable[0x8674]=29969;   // zhe
   sortTable[0x87C4]=29970;   // zhe
   sortTable[0x8F4D]=29971;   // zhe
   sortTable[0x92B8]=29972;   // zhe
   sortTable[0x9DD3]=29973;   // zhe
   sortTable[0x771F]=29974;   // zhen
   sortTable[0x9635]=29975;   // zhen
   sortTable[0x9663]=29976;   // zhen
   sortTable[0x9488]=29977;   // zhen
   sortTable[0x91DD]=29978;   // zhen
   sortTable[0x9707]=29979;   // zhen
   sortTable[0x9547]=29980;   // zhen
   sortTable[0x93AE]=29981;   // zhen
   sortTable[0x73CD]=29982;   // zhen
   sortTable[0x632F]=29983;   // zhen
   sortTable[0x4FA6]=29984;   // zhen
   sortTable[0x5075]=29985;   // zhen
   sortTable[0x6795]=29986;   // zhen
   sortTable[0x8BCA]=29987;   // zhen
   sortTable[0x8A3A]=29988;   // zhen
   sortTable[0x8D1E]=29989;   // zhen
   sortTable[0x6715]=29990;   // zhen
   sortTable[0x5733]=29991;   // zhen
   sortTable[0x8D48]=29992;   // zhen
   sortTable[0x659F]=29993;   // zhen
   sortTable[0x796F]=29994;   // zhen
   sortTable[0x7504]=29995;   // zhen
   sortTable[0x7A39]=29996;   // zhen
   sortTable[0x81FB]=29997;   // zhen
   sortTable[0x6862]=29998;   // zhen
   sortTable[0x75B9]=29999;   // zhen
   sortTable[0x8F78]=30000;   // zhen
   sortTable[0x7BB4]=30001;   // zhen
   sortTable[0x9E29]=30002;   // zhen
   sortTable[0x699B]=30003;   // zhen
   sortTable[0x7F1C]=30004;   // zhen
   sortTable[0x755B]=30005;   // zhen
   sortTable[0x80D7]=30006;   // zhen
   sortTable[0x7827]=30007;   // zhen
   sortTable[0x84C1]=30008;   // zhen
   sortTable[0x799B]=30009;   // zhen
   sortTable[0x9156]=30010;   // zhen
   sortTable[0x6D48]=30011;   // zhen
   sortTable[0x8897]=30012;   // zhen
   sortTable[0x7EBC]=30013;   // zhen
   sortTable[0x8474]=30014;   // zhen
   sortTable[0x9241]=30015;   // zhen
   sortTable[0x7D7C]=30016;   // zhen
   sortTable[0x7D3E]=30017;   // zhen
   sortTable[0x9B12]=30018;   // zhen
   sortTable[0x937C]=30019;   // zhen
   sortTable[0x93AD]=30020;   // zhen
   sortTable[0x798E]=30021;   // zhen
   sortTable[0x8C9E]=30022;   // zhen
   sortTable[0x9C75]=30023;   // zhen
   sortTable[0x7739]=30024;   // zhen
   sortTable[0x7715]=30025;   // zhen
   sortTable[0x78AA]=30026;   // zhen
   sortTable[0x7C48]=30027;   // zhen
   sortTable[0x9EF0]=30028;   // zhen
   sortTable[0x7D16]=30029;   // zhen
   sortTable[0x8F43]=30030;   // zhen
   sortTable[0x771E]=30031;   // zhen
   sortTable[0x85BD]=30032;   // zhen
   sortTable[0x92F4]=30033;   // zhen
   sortTable[0x4FB2]=30034;   // zhen
   sortTable[0x5866]=30035;   // zhen
   sortTable[0x5AC3]=30036;   // zhen
   sortTable[0x5BCA]=30037;   // zhen
   sortTable[0x5C52]=30038;   // zhen
   sortTable[0x5E2A]=30039;   // zhen
   sortTable[0x5F2B]=30040;   // zhen
   sortTable[0x62AE]=30041;   // zhen
   sortTable[0x630B]=30042;   // zhen
   sortTable[0x63D5]=30043;   // zhen
   sortTable[0x6438]=30044;   // zhen
   sortTable[0x6576]=30045;   // zhen
   sortTable[0x6623]=30046;   // zhen
   sortTable[0x6815]=30047;   // zhen
   sortTable[0x681A]=30048;   // zhen
   sortTable[0x686D]=30049;   // zhen
   sortTable[0x6968]=30050;   // zhen
   sortTable[0x6A3C]=30051;   // zhen
   sortTable[0x6B9D]=30052;   // zhen
   sortTable[0x6F67]=30053;   // zhen
   sortTable[0x6FB5]=30054;   // zhen
   sortTable[0x7349]=30055;   // zhen
   sortTable[0x73CE]=30056;   // zhen
   sortTable[0x7467]=30057;   // zhen
   sortTable[0x7471]=30058;   // zhen
   sortTable[0x753D]=30059;   // zhen
   sortTable[0x7E25]=30060;   // zhen
   sortTable[0x8044]=30061;   // zhen
   sortTable[0x8419]=30062;   // zhen
   sortTable[0x8496]=30063;   // zhen
   sortTable[0x88D6]=30064;   // zhen
   sortTable[0x8AAB]=30065;   // zhen
   sortTable[0x8CD1]=30066;   // zhen
   sortTable[0x8EEB]=30067;   // zhen
   sortTable[0x9049]=30068;   // zhen
   sortTable[0x9159]=30069;   // zhen
   sortTable[0x9331]=30070;   // zhen
   sortTable[0x9755]=30071;   // zhen
   sortTable[0x99D7]=30072;   // zhen
   sortTable[0x9D06]=30073;   // zhen
   sortTable[0x6B63]=30074;   // zheng
   sortTable[0x653F]=30075;   // zheng
   sortTable[0x4E89]=30076;   // zheng
   sortTable[0x722D]=30077;   // zheng
   sortTable[0x6574]=30078;   // zheng
   sortTable[0x8BC1]=30079;   // zheng
   sortTable[0x8A3C]=30080;   // zheng
   sortTable[0x5F81]=30081;   // zheng
   sortTable[0x7741]=30082;   // zheng
   sortTable[0x775C]=30083;   // zheng
   sortTable[0x84B8]=30084;   // zheng
   sortTable[0x6323]=30085;   // zheng
   sortTable[0x6399]=30086;   // zheng
   sortTable[0x75C7]=30087;   // zheng
   sortTable[0x90D1]=30088;   // zheng
   sortTable[0x912D]=30089;   // zheng
   sortTable[0x6014]=30090;   // zheng
   sortTable[0x94EE]=30091;   // zheng
   sortTable[0x5FB5]=30092;   // zheng
   sortTable[0x62EF]=30093;   // zheng
   sortTable[0x5E27]=30094;   // zheng
   sortTable[0x8BE4]=30095;   // zheng
   sortTable[0x7B5D]=30096;   // zheng
   sortTable[0x72F0]=30097;   // zheng
   sortTable[0x5CE5]=30098;   // zheng
   sortTable[0x94B2]=30099;   // zheng
   sortTable[0x8B49]=30100;   // zheng
   sortTable[0x9BD6]=30101;   // zheng
   sortTable[0x7B8F]=30102;   // zheng
   sortTable[0x7BDC]=30103;   // zheng
   sortTable[0x9266]=30104;   // zheng
   sortTable[0x931A]=30105;   // zheng
   sortTable[0x9D0A]=30106;   // zheng
   sortTable[0x4F42]=30107;   // zheng
   sortTable[0x51E7]=30108;   // zheng
   sortTable[0x57E9]=30109;   // zheng
   sortTable[0x5863]=30110;   // zheng
   sortTable[0x59C3]=30111;   // zheng
   sortTable[0x5A9C]=30112;   // zheng
   sortTable[0x5D1D]=30113;   // zheng
   sortTable[0x5D22]=30114;   // zheng
   sortTable[0x5E40]=30115;   // zheng
   sortTable[0x5FB0]=30116;   // zheng
   sortTable[0x5FB4]=30117;   // zheng
   sortTable[0x6138]=30118;   // zheng
   sortTable[0x628D]=30119;   // zheng
   sortTable[0x639F]=30120;   // zheng
   sortTable[0x63C1]=30121;   // zheng
   sortTable[0x649C]=30122;   // zheng
   sortTable[0x6678]=30123;   // zheng
   sortTable[0x6C36]=30124;   // zheng
   sortTable[0x70A1]=30125;   // zheng
   sortTable[0x70DD]=30126;   // zheng
   sortTable[0x7319]=30127;   // zheng
   sortTable[0x7665]=30128;   // zheng
   sortTable[0x7710]=30129;   // zheng
   sortTable[0x7CFD]=30130;   // zheng
   sortTable[0x8047]=30131;   // zheng
   sortTable[0x8ACD]=30132;   // zheng
   sortTable[0x8E2D]=30133;   // zheng
   sortTable[0x9B07]=30134;   // zheng
   sortTable[0x53EA]=30135;   // zhi
   sortTable[0x77E5]=30136;   // zhi
   sortTable[0x4E4B]=30137;   // zhi
   sortTable[0x5FD7]=30138;   // zhi
   sortTable[0x5236]=30139;   // zhi
   sortTable[0x76F4]=30140;   // zhi
   sortTable[0x6307]=30141;   // zhi
   sortTable[0x6CBB]=30142;   // zhi
   sortTable[0x8D28]=30143;   // zhi
   sortTable[0x8CEA]=30144;   // zhi
   sortTable[0x81F3]=30145;   // zhi
   sortTable[0x7EC7]=30146;   // zhi
   sortTable[0x7E54]=30147;   // zhi
   sortTable[0x652F]=30148;   // zhi
   sortTable[0x7EB8]=30149;   // zhi
   sortTable[0x7D19]=30150;   // zhi
   sortTable[0x6B62]=30151;   // zhi
   sortTable[0x503C]=30152;   // zhi
   sortTable[0x81F4]=30153;   // zhi
   sortTable[0x679D]=30154;   // zhi
   sortTable[0x6267]=30155;   // zhi
   sortTable[0x690D]=30156;   // zhi
   sortTable[0x57F7]=30157;   // zhi
   sortTable[0x804C]=30158;   // zhi
   sortTable[0x8077]=30159;   // zhi
   sortTable[0x7F6E]=30160;   // zhi
   sortTable[0x6B96]=30161;   // zhi
   sortTable[0x667A]=30162;   // zhi
   sortTable[0x5E1C]=30163;   // zhi
   sortTable[0x5E5F]=30164;   // zhi
   sortTable[0x79E9]=30165;   // zhi
   sortTable[0x8102]=30166;   // zhi
   sortTable[0x80A2]=30167;   // zhi
   sortTable[0x8718]=30168;   // zhi
   sortTable[0x5740]=30169;   // zhi
   sortTable[0x7A1A]=30170;   // zhi
   sortTable[0x63B7]=30171;   // zhi
   sortTable[0x64F2]=30172;   // zhi
   sortTable[0x829D]=30173;   // zhi
   sortTable[0x6C41]=30174;   // zhi
   sortTable[0x65E8]=30175;   // zhi
   sortTable[0x4F84]=30176;   // zhi
   sortTable[0x6EDE]=30177;   // zhi
   sortTable[0x7957]=30178;   // zhi
   sortTable[0x631A]=30179;   // zhi
   sortTable[0x89EF]=30180;   // zhi
   sortTable[0x8DBE]=30181;   // zhi
   sortTable[0x5431]=30182;   // zhi
   sortTable[0x5CD9]=30183;   // zhi
   sortTable[0x7A92]=30184;   // zhi
   sortTable[0x7099]=30185;   // zhi
   sortTable[0x965F]=30186;   // zhi
   sortTable[0x96C9]=30187;   // zhi
   sortTable[0x86ED]=30188;   // zhi
   sortTable[0x82B7]=30189;   // zhi
   sortTable[0x8D3D]=30190;   // zhi
   sortTable[0x7949]=30191;   // zhi
   sortTable[0x54AB]=30192;   // zhi
   sortTable[0x536E]=30193;   // zhi
   sortTable[0x75D4]=30194;   // zhi
   sortTable[0x6809]=30195;   // zhi
   sortTable[0x80DD]=30196;   // zhi
   sortTable[0x8879]=30197;   // zhi
   sortTable[0x90C5]=30198;   // zhi
   sortTable[0x9E37]=30199;   // zhi
   sortTable[0x646D]=30200;   // zhi
   sortTable[0x9A98]=30201;   // zhi
   sortTable[0x75E3]=30202;   // zhi
   sortTable[0x5F58]=30203;   // zhi
   sortTable[0x684E]=30204;   // zhi
   sortTable[0x67B3]=30205;   // zhi
   sortTable[0x7D77]=30206;   // zhi
   sortTable[0x8DD6]=30207;   // zhi
   sortTable[0x962F]=30208;   // zhi
   sortTable[0x916F]=30209;   // zhi
   sortTable[0x5E19]=30210;   // zhi
   sortTable[0x8E2F]=30211;   // zhi
   sortTable[0x8E2C]=30212;   // zhi
   sortTable[0x8F75]=30213;   // zhi
   sortTable[0x5FEE]=30214;   // zhi
   sortTable[0x6800]=30215;   // zhi
   sortTable[0x57F4]=30216;   // zhi
   sortTable[0x9EF9]=30217;   // zhi
   sortTable[0x7983]=30218;   // zhi
   sortTable[0x7994]=30219;   // zhi
   sortTable[0x9CF7]=30220;   // zhi
   sortTable[0x8F7E]=30221;   // zhi
   sortTable[0x7929]=30222;   // zhi
   sortTable[0x9527]=30223;   // zhi
   sortTable[0x94DA]=30224;   // zhi
   sortTable[0x8E60]=30225;   // zhi
   sortTable[0x8DF1]=30226;   // zhi
   sortTable[0x88FD]=30227;   // zhi
   sortTable[0x8A8C]=30228;   // zhi
   sortTable[0x79F2]=30229;   // zhi
   sortTable[0x88A0]=30230;   // zhi
   sortTable[0x9624]=30231;   // zhi
   sortTable[0x7A49]=30232;   // zhi
   sortTable[0x7A19]=30233;   // zhi
   sortTable[0x7D29]=30234;   // zhi
   sortTable[0x9D32]=30235;   // zhi
   sortTable[0x9A3A]=30236;   // zhi
   sortTable[0x9455]=30237;   // zhi
   sortTable[0x96BB]=30238;   // zhi
   sortTable[0x79EA]=30239;   // zhi
   sortTable[0x7DFB]=30240;   // zhi
   sortTable[0x9D44]=30241;   // zhi
   sortTable[0x889F]=30242;   // zhi
   sortTable[0x79D6]=30243;   // zhi
   sortTable[0x7FD0]=30244;   // zhi
   sortTable[0x80D1]=30245;   // zhi
   sortTable[0x81B1]=30246;   // zhi
   sortTable[0x9244]=30247;   // zhi
   sortTable[0x928D]=30248;   // zhi
   sortTable[0x7D95]=30249;   // zhi
   sortTable[0x8296]=30250;   // zhi
   sortTable[0x92D5]=30251;   // zhi
   sortTable[0x887C]=30252;   // zhi
   sortTable[0x85E2]=30253;   // zhi
   sortTable[0x9A47]=30254;   // zhi
   sortTable[0x7951]=30255;   // zhi
   sortTable[0x8635]=30256;   // zhi
   sortTable[0x899F]=30257;   // zhi
   sortTable[0x8D04]=30258;   // zhi
   sortTable[0x8FE3]=30259;   // zhi
   sortTable[0x99BD]=30260;   // zhi
   sortTable[0x9A2D]=30261;   // zhi
   sortTable[0x79F7]=30262;   // zhi
   sortTable[0x8B22]=30263;   // zhi
   sortTable[0x8CAD]=30264;   // zhi
   sortTable[0x8EC4]=30265;   // zhi
   sortTable[0x9D19]=30266;   // zhi
   sortTable[0x9F05]=30267;   // zhi
   sortTable[0x4E7F]=30268;   // zhi
   sortTable[0x4FE7]=30269;   // zhi
   sortTable[0x5001]=30270;   // zhi
   sortTable[0x5024]=30271;   // zhi
   sortTable[0x506B]=30272;   // zhi
   sortTable[0x5082]=30273;   // zhi
   sortTable[0x5128]=30274;   // zhi
   sortTable[0x51EA]=30275;   // zhi
   sortTable[0x5295]=30276;   // zhi
   sortTable[0x52A7]=30277;   // zhi
   sortTable[0x5394]=30278;   // zhi
   sortTable[0x55ED]=30279;   // zhi
   sortTable[0x5741]=30280;   // zhi
   sortTable[0x5767]=30281;   // zhi
   sortTable[0x5781]=30282;   // zhi
   sortTable[0x5886]=30283;   // zhi
   sortTable[0x588C]=30284;   // zhi
   sortTable[0x5902]=30285;   // zhi
   sortTable[0x59B7]=30286;   // zhi
   sortTable[0x59EA]=30287;   // zhi
   sortTable[0x5A21]=30288;   // zhi
   sortTable[0x5B02]=30289;   // zhi
   sortTable[0x5BD8]=30290;   // zhi
   sortTable[0x5D3B]=30291;   // zhi
   sortTable[0x5DF5]=30292;   // zhi
   sortTable[0x5E0B]=30293;   // zhi
   sortTable[0x5EA2]=30294;   // zhi
   sortTable[0x5EA4]=30295;   // zhi
   sortTable[0x5ECC]=30296;   // zhi
   sortTable[0x5F8F]=30297;   // zhi
   sortTable[0x5F94]=30298;   // zhi
   sortTable[0x5F9D]=30299;   // zhi
   sortTable[0x603E]=30300;   // zhi
   sortTable[0x6049]=30301;   // zhi
   sortTable[0x6179]=30302;   // zhi
   sortTable[0x6184]=30303;   // zhi
   sortTable[0x61E5]=30304;   // zhi
   sortTable[0x61EB]=30305;   // zhi
   sortTable[0x6220]=30306;   // zhi
   sortTable[0x627A]=30307;   // zhi
   sortTable[0x627B]=30308;   // zhi
   sortTable[0x62A7]=30309;   // zhi
   sortTable[0x6303]=30310;   // zhi
   sortTable[0x6418]=30311;   // zhi
   sortTable[0x6431]=30312;   // zhi
   sortTable[0x646F]=30313;   // zhi
   sortTable[0x64F3]=30314;   // zhi
   sortTable[0x65D8]=30315;   // zhi
   sortTable[0x664A]=30316;   // zhi
   sortTable[0x67E3]=30317;   // zhi
   sortTable[0x6894]=30318;   // zhi
   sortTable[0x68BD]=30319;   // zhi
   sortTable[0x6925]=30320;   // zhi
   sortTable[0x6956]=30321;   // zhi
   sortTable[0x69B0]=30322;   // zhi
   sortTable[0x6A34]=30323;   // zhi
   sortTable[0x6ACD]=30324;   // zhi
   sortTable[0x6ADB]=30325;   // zhi
   sortTable[0x6C65]=30326;   // zhi
   sortTable[0x6C66]=30327;   // zhi
   sortTable[0x6C9A]=30328;   // zhi
   sortTable[0x6CDC]=30329;   // zhi
   sortTable[0x6D14]=30330;   // zhi
   sortTable[0x6D37]=30331;   // zhi
   sortTable[0x6DD4]=30332;   // zhi
   sortTable[0x6DFD]=30333;   // zhi
   sortTable[0x6ECD]=30334;   // zhi
   sortTable[0x6EEF]=30335;   // zhi
   sortTable[0x6F10]=30336;   // zhi
   sortTable[0x6F4C]=30337;   // zhi
   sortTable[0x7004]=30338;   // zhi
   sortTable[0x71AB]=30339;   // zhi
   sortTable[0x7286]=30340;   // zhi
   sortTable[0x72FE]=30341;   // zhi
   sortTable[0x7318]=30342;   // zhi
   sortTable[0x74C6]=30343;   // zhi
   sortTable[0x74E1]=30344;   // zhi
   sortTable[0x7564]=30345;   // zhi
   sortTable[0x7590]=30346;   // zhi
   sortTable[0x75B7]=30347;   // zhi
   sortTable[0x75BB]=30348;   // zhi
   sortTable[0x780B]=30349;   // zhi
   sortTable[0x796C]=30350;   // zhi
   sortTable[0x79D3]=30351;   // zhi
   sortTable[0x7A3A]=30352;   // zhi
   sortTable[0x7B6B]=30353;   // zhi
   sortTable[0x7E36]=30354;   // zhi
   sortTable[0x8040]=30355;   // zhi
   sortTable[0x81A3]=30356;   // zhi
   sortTable[0x81F8]=30357;   // zhi
   sortTable[0x87B2]=30358;   // zhi
   sortTable[0x87D9]=30359;   // zhi
   sortTable[0x8901]=30360;   // zhi
   sortTable[0x8967]=30361;   // zhi
   sortTable[0x89D7]=30362;   // zhi
   sortTable[0x89F6]=30363;   // zhi
   sortTable[0x8A28]=30364;   // zhi
   sortTable[0x8C51]=30365;   // zhi
   sortTable[0x8C52]=30366;   // zhi
   sortTable[0x8C78]=30367;   // zhi
   sortTable[0x8E91]=30368;   // zhi
   sortTable[0x8E93]=30369;   // zhi
   sortTable[0x8EF9]=30370;   // zhi
   sortTable[0x8EFD]=30371;   // zhi
   sortTable[0x8F0A]=30372;   // zhi
   sortTable[0x91DE]=30373;   // zhi
   sortTable[0x99B6]=30374;   // zhi
   sortTable[0x99E4]=30375;   // zhi
   sortTable[0x9BEF]=30376;   // zhi
   sortTable[0x9DD9]=30377;   // zhi
   sortTable[0x4E2D]=30378;   // zhong
   sortTable[0x79CD]=30379;   // zhong
   sortTable[0x7A2E]=30380;   // zhong
   sortTable[0x91CD]=30381;   // zhong
   sortTable[0x4F17]=30382;   // zhong
   sortTable[0x773E]=30383;   // zhong
   sortTable[0x949F]=30384;   // zhong
   sortTable[0x9418]=30385;   // zhong
   sortTable[0x7EC8]=30386;   // zhong
   sortTable[0x7D42]=30387;   // zhong
   sortTable[0x5FE0]=30388;   // zhong
   sortTable[0x80BF]=30389;   // zhong
   sortTable[0x816B]=30390;   // zhong
   sortTable[0x4EF2]=30391;   // zhong
   sortTable[0x8877]=30392;   // zhong
   sortTable[0x51A2]=30393;   // zhong
   sortTable[0x8E35]=30394;   // zhong
   sortTable[0x953A]=30395;   // zhong
   sortTable[0x76C5]=30396;   // zhong
   sortTable[0x822F]=30397;   // zhong
   sortTable[0x87BD]=30398;   // zhong
   sortTable[0x8846]=30399;   // zhong
   sortTable[0x7A5C]=30400;   // zhong
   sortTable[0x8E71]=30401;   // zhong
   sortTable[0x8AE5]=30402;   // zhong
   sortTable[0x8876]=30403;   // zhong
   sortTable[0x92BF]=30404;   // zhong
   sortTable[0x9F28]=30405;   // zhong
   sortTable[0x833D]=30406;   // zhong
   sortTable[0x87A4]=30407;   // zhong
   sortTable[0x937E]=30408;   // zhong
   sortTable[0x8520]=30409;   // zhong
   sortTable[0x869B]=30410;   // zhong
   sortTable[0x8FDA]=30411;   // zhong
   sortTable[0x9221]=30412;   // zhong
   sortTable[0x4F00]=30413;   // zhong
   sortTable[0x5045]=30414;   // zhong
   sortTable[0x5223]=30415;   // zhong
   sortTable[0x55A0]=30416;   // zhong
   sortTable[0x5839]=30417;   // zhong
   sortTable[0x585A]=30418;   // zhong
   sortTable[0x585C]=30419;   // zhong
   sortTable[0x5990]=30420;   // zhong
   sortTable[0x5995]=30421;   // zhong
   sortTable[0x5A91]=30422;   // zhong
   sortTable[0x5C30]=30423;   // zhong
   sortTable[0x5E52]=30424;   // zhong
   sortTable[0x5F78]=30425;   // zhong
   sortTable[0x67CA]=30426;   // zhong
   sortTable[0x6B71]=30427;   // zhong
   sortTable[0x6C77]=30428;   // zhong
   sortTable[0x6CC8]=30429;   // zhong
   sortTable[0x7082]=30430;   // zhong
   sortTable[0x7144]=30431;   // zhong
   sortTable[0x72C6]=30432;   // zhong
   sortTable[0x7607]=30433;   // zhong
   sortTable[0x794C]=30434;   // zhong
   sortTable[0x7B57]=30435;   // zhong
   sortTable[0x7C66]=30436;   // zhong
   sortTable[0x8873]=30437;   // zhong
   sortTable[0x5468]=30438;   // zhou
   sortTable[0x6D32]=30439;   // zhou
   sortTable[0x5B99]=30440;   // zhou
   sortTable[0x76B1]=30441;   // zhou
   sortTable[0x76BA]=30442;   // zhou
   sortTable[0x7CA5]=30443;   // zhou
   sortTable[0x8F74]=30444;   // zhou
   sortTable[0x8EF8]=30445;   // zhou
   sortTable[0x5DDE]=30446;   // zhou
   sortTable[0x663C]=30447;   // zhou
   sortTable[0x665D]=30448;   // zhou
   sortTable[0x9AA4]=30449;   // zhou
   sortTable[0x9A5F]=30450;   // zhou
   sortTable[0x821F]=30451;   // zhou
   sortTable[0x5E1A]=30452;   // zhou
   sortTable[0x5492]=30453;   // zhou
   sortTable[0x80C4]=30454;   // zhou
   sortTable[0x7EA3]=30455;   // zhou
   sortTable[0x8098]=30456;   // zhou
   sortTable[0x7EC9]=30457;   // zhou
   sortTable[0x8BCC]=30458;   // zhou
   sortTable[0x59AF]=30459;   // zhou
   sortTable[0x76E9]=30460;   // zhou
   sortTable[0x7C40]=30461;   // zhou
   sortTable[0x914E]=30462;   // zhou
   sortTable[0x8F80]=30463;   // zhou
   sortTable[0x8D52]=30464;   // zhou
   sortTable[0x8BEA]=30465;   // zhou
   sortTable[0x9031]=30466;   // zhou
   sortTable[0x8A76]=30467;   // zhou
   sortTable[0x8F08]=30468;   // zhou
   sortTable[0x970C]=30469;   // zhou
   sortTable[0x9282]=30470;   // zhou
   sortTable[0x7B92]=30471;   // zhou
   sortTable[0x8F16]=30472;   // zhou
   sortTable[0x83F7]=30473;   // zhou
   sortTable[0x8B78]=30474;   // zhou
   sortTable[0x7C52]=30475;   // zhou
   sortTable[0x9D43]=30476;   // zhou
   sortTable[0x9E3C]=30477;   // zhou
   sortTable[0x7C99]=30478;   // zhou
   sortTable[0x7D02]=30479;   // zhou
   sortTable[0x836E]=30480;   // zhou
   sortTable[0x8464]=30481;   // zhou
   sortTable[0x8A4B]=30482;   // zhou
   sortTable[0x99CE]=30483;   // zhou
   sortTable[0x9A06]=30484;   // zhou
   sortTable[0x9BDE]=30485;   // zhou
   sortTable[0x4F37]=30486;   // zhou
   sortTable[0x4F9C]=30487;   // zhou
   sortTable[0x50FD]=30488;   // zhou
   sortTable[0x5191]=30489;   // zhou
   sortTable[0x546A]=30490;   // zhou
   sortTable[0x54AE]=30491;   // zhou
   sortTable[0x558C]=30492;   // zhou
   sortTable[0x5663]=30493;   // zhou
   sortTable[0x5F9F]=30494;   // zhou
   sortTable[0x63AB]=30495;   // zhou
   sortTable[0x666D]=30496;   // zhou
   sortTable[0x6DCD]=30497;   // zhou
   sortTable[0x70BF]=30498;   // zhou
   sortTable[0x70D0]=30499;   // zhou
   sortTable[0x73D8]=30500;   // zhou
   sortTable[0x7503]=30501;   // zhou
   sortTable[0x759B]=30502;   // zhou
   sortTable[0x776D]=30503;   // zhou
   sortTable[0x77EA]=30504;   // zhou
   sortTable[0x7C55]=30505;   // zhou
   sortTable[0x7E10]=30506;   // zhou
   sortTable[0x8B05]=30507;   // zhou
   sortTable[0x8CD9]=30508;   // zhou
   sortTable[0x90EE]=30509;   // zhou
   sortTable[0x99F2]=30510;   // zhou
   sortTable[0x4E3B]=30511;   // zhu
   sortTable[0x4F4F]=30512;   // zhu
   sortTable[0x52A9]=30513;   // zhu
   sortTable[0x6CE8]=30514;   // zhu
   sortTable[0x9010]=30515;   // zhu
   sortTable[0x7B51]=30516;   // zhu
   sortTable[0x73E0]=30517;   // zhu
   sortTable[0x7AF9]=30518;   // zhu
   sortTable[0x795D]=30519;   // zhu
   sortTable[0x732A]=30520;   // zhu
   sortTable[0x8C6C]=30521;   // zhu
   sortTable[0x67F1]=30522;   // zhu
   sortTable[0x682A]=30523;   // zhu
   sortTable[0x70DB]=30524;   // zhu
   sortTable[0x71ED]=30525;   // zhu
   sortTable[0x716E]=30526;   // zhu
   sortTable[0x94F8]=30527;   // zhu
   sortTable[0x9444]=30528;   // zhu
   sortTable[0x5631]=30529;   // zhu
   sortTable[0x56D1]=30530;   // zhu
   sortTable[0x86DB]=30531;   // zhu
   sortTable[0x9A7B]=30532;   // zhu
   sortTable[0x99D0]=30533;   // zhu
   sortTable[0x8BF8]=30534;   // zhu
   sortTable[0x8AF8]=30535;   // zhu
   sortTable[0x62C4]=30536;   // zhu
   sortTable[0x86C0]=30537;   // zhu
   sortTable[0x6731]=30538;   // zhu
   sortTable[0x8BDB]=30539;   // zhu
   sortTable[0x7843]=30540;   // zhu
   sortTable[0x8D2E]=30541;   // zhu
   sortTable[0x7AFA]=30542;   // zhu
   sortTable[0x6E1A]=30543;   // zhu
   sortTable[0x94E2]=30544;   // zhu
   sortTable[0x77A9]=30545;   // zhu
   sortTable[0x4F2B]=30546;   // zhu
   sortTable[0x7BB8]=30547;   // zhu
   sortTable[0x4F8F]=30548;   // zhu
   sortTable[0x90BE]=30549;   // zhu
   sortTable[0x677C]=30550;   // zhu
   sortTable[0x8233]=30551;   // zhu
   sortTable[0x70B7]=30552;   // zhu
   sortTable[0x6D19]=30553;   // zhu
   sortTable[0x9E88]=30554;   // zhu
   sortTable[0x69E0]=30555;   // zhu
   sortTable[0x82CE]=30556;   // zhu
   sortTable[0x7FE5]=30557;   // zhu
   sortTable[0x6F74]=30558;   // zhu
   sortTable[0x7EBB]=30559;   // zhu
   sortTable[0x6A65]=30560;   // zhu
   sortTable[0x8E85]=30561;   // zhu
   sortTable[0x8331]=30562;   // zhu
   sortTable[0x8A3B]=30563;   // zhu
   sortTable[0x7A8B]=30564;   // zhu
   sortTable[0x782B]=30565;   // zhu
   sortTable[0x880B]=30566;   // zhu
   sortTable[0x7603]=30567;   // zhu
   sortTable[0x7D35]=30568;   // zhu
   sortTable[0x75B0]=30569;   // zhu
   sortTable[0x967C]=30570;   // zhu
   sortTable[0x8A5D]=30571;   // zhu
   sortTable[0x9E86]=30572;   // zhu
   sortTable[0x7F9C]=30573;   // zhu
   sortTable[0x8DE6]=30574;   // zhu
   sortTable[0x8CAF]=30575;   // zhu
   sortTable[0x8DD3]=30576;   // zhu
   sortTable[0x9714]=30577;   // zhu
   sortTable[0x9D38]=30578;   // zhu
   sortTable[0x7969]=30579;   // zhu
   sortTable[0x88BE]=30580;   // zhu
   sortTable[0x7ADA]=30581;   // zhu
   sortTable[0x7BC9]=30582;   // zhu
   sortTable[0x7B6F]=30583;   // zhu
   sortTable[0x8829]=30584;   // zhu
   sortTable[0x9C41]=30585;   // zhu
   sortTable[0x77DA]=30586;   // zhu
   sortTable[0x883E]=30587;   // zhu
   sortTable[0x7B01]=30588;   // zhu
   sortTable[0x8FEC]=30589;   // zhu
   sortTable[0x9296]=30590;   // zhu
   sortTable[0x99EF]=30591;   // zhu
   sortTable[0x79FC]=30592;   // zhu
   sortTable[0x7B1C]=30593;   // zhu
   sortTable[0x7D38]=30594;   // zhu
   sortTable[0x833F]=30595;   // zhu
   sortTable[0x9F04]=30596;   // zhu
   sortTable[0x4E36]=30597;   // zhu
   sortTable[0x4F47]=30598;   // zhu
   sortTable[0x529A]=30599;   // zhu
   sortTable[0x52AF]=30600;   // zhu
   sortTable[0x577E]=30601;   // zhu
   sortTable[0x58B8]=30602;   // zhu
   sortTable[0x58F4]=30603;   // zhu
   sortTable[0x5B4E]=30604;   // zhu
   sortTable[0x5B94]=30605;   // zhu
   sortTable[0x5D40]=30606;   // zhu
   sortTable[0x65B8]=30607;   // zhu
   sortTable[0x66EF]=30608;   // zhu
   sortTable[0x6A26]=30609;   // zhu
   sortTable[0x6AE7]=30610;   // zhu
   sortTable[0x6AEB]=30611;   // zhu
   sortTable[0x6B18]=30612;   // zhu
   sortTable[0x6BB6]=30613;   // zhu
   sortTable[0x6CCF]=30614;   // zhu
   sortTable[0x6FD0]=30615;   // zhu
   sortTable[0x7026]=30616;   // zhu
   sortTable[0x705F]=30617;   // zhu
   sortTable[0x70A2]=30618;   // zhu
   sortTable[0x7151]=30619;   // zhu
   sortTable[0x7225]=30620;   // zhu
   sortTable[0x771D]=30621;   // zhu
   sortTable[0x7BEB]=30622;   // zhu
   sortTable[0x7D51]=30623;   // zhu
   sortTable[0x7F5C]=30624;   // zhu
   sortTable[0x8387]=30625;   // zhu
   sortTable[0x876B]=30626;   // zhu
   sortTable[0x8A85]=30627;   // zhu
   sortTable[0x8EF4]=30628;   // zhu
   sortTable[0x9252]=30629;   // zhu
   sortTable[0x92F3]=30630;   // zhu
   sortTable[0x99B5]=30631;   // zhu
   sortTable[0x9BA2]=30632;   // zhu
   sortTable[0x9BFA]=30633;   // zhu
   sortTable[0x6293]=30634;   // zhua
   sortTable[0x9AFD]=30635;   // zhua
   sortTable[0x7C3B]=30636;   // zhua
   sortTable[0x81BC]=30637;   // zhua
   sortTable[0x6A9B]=30638;   // zhua
   sortTable[0x62FD]=30639;   // zhuai
   sortTable[0x8DE9]=30640;   // zhuai
   sortTable[0x8F6C]=30641;   // zhuan
   sortTable[0x8F49]=30642;   // zhuan
   sortTable[0x4E13]=30643;   // zhuan
   sortTable[0x5C08]=30644;   // zhuan
   sortTable[0x7816]=30645;   // zhuan
   sortTable[0x78DA]=30646;   // zhuan
   sortTable[0x8D5A]=30647;   // zhuan
   sortTable[0x8CFA]=30648;   // zhuan
   sortTable[0x64B0]=30649;   // zhuan
   sortTable[0x9994]=30650;   // zhuan
   sortTable[0x7BC6]=30651;   // zhuan
   sortTable[0x989B]=30652;   // zhuan
   sortTable[0x556D]=30653;   // zhuan
   sortTable[0x8948]=30654;   // zhuan
   sortTable[0x8B54]=30655;   // zhuan
   sortTable[0x9C44]=30656;   // zhuan
   sortTable[0x911F]=30657;   // zhuan
   sortTable[0x7BF9]=30658;   // zhuan
   sortTable[0x994C]=30659;   // zhuan
   sortTable[0x819E]=30660;   // zhuan
   sortTable[0x9853]=30661;   // zhuan
   sortTable[0x8EE2]=30662;   // zhuan
   sortTable[0x8483]=30663;   // zhuan
   sortTable[0x815E]=30664;   // zhuan
   sortTable[0x50CE]=30665;   // zhuan
   sortTable[0x53C0]=30666;   // zhuan
   sortTable[0x56C0]=30667;   // zhuan
   sortTable[0x581F]=30668;   // zhuan
   sortTable[0x587C]=30669;   // zhuan
   sortTable[0x5AE5]=30670;   // zhuan
   sortTable[0x5B68]=30671;   // zhuan
   sortTable[0x5C02]=30672;   // zhuan
   sortTable[0x7077]=30673;   // zhuan
   sortTable[0x7451]=30674;   // zhuan
   sortTable[0x747C]=30675;   // zhuan
   sortTable[0x750E]=30676;   // zhuan
   sortTable[0x78D7]=30677;   // zhuan
   sortTable[0x7AF1]=30678;   // zhuan
   sortTable[0x7C51]=30679;   // zhuan
   sortTable[0x87E4]=30680;   // zhuan
   sortTable[0x8AEF]=30681;   // zhuan
   sortTable[0x88C5]=30682;   // zhuang
   sortTable[0x88DD]=30683;   // zhuang
   sortTable[0x5E84]=30684;   // zhuang
   sortTable[0x838A]=30685;   // zhuang
   sortTable[0x72B6]=30686;   // zhuang
   sortTable[0x72C0]=30687;   // zhuang
   sortTable[0x58EE]=30688;   // zhuang
   sortTable[0x58EF]=30689;   // zhuang
   sortTable[0x649E]=30690;   // zhuang
   sortTable[0x6869]=30691;   // zhuang
   sortTable[0x6A01]=30692;   // zhuang
   sortTable[0x5986]=30693;   // zhuang
   sortTable[0x7CA7]=30694;   // zhuang
   sortTable[0x8358]=30695;   // zhuang
   sortTable[0x58F5]=30696;   // zhuang
   sortTable[0x599D]=30697;   // zhuang
   sortTable[0x5A24]=30698;   // zhuang
   sortTable[0x5E92]=30699;   // zhuang
   sortTable[0x6207]=30700;   // zhuang
   sortTable[0x6889]=30701;   // zhuang
   sortTable[0x6E77]=30702;   // zhuang
   sortTable[0x6F34]=30703;   // zhuang
   sortTable[0x710B]=30704;   // zhuang
   sortTable[0x7CDA]=30705;   // zhuang
   sortTable[0x8FFD]=30706;   // zhui
   sortTable[0x7F00]=30707;   // zhui
   sortTable[0x7DB4]=30708;   // zhui
   sortTable[0x5760]=30709;   // zhui
   sortTable[0x589C]=30710;   // zhui
   sortTable[0x9525]=30711;   // zhui
   sortTable[0x8D58]=30712;   // zhui
   sortTable[0x60F4]=30713;   // zhui
   sortTable[0x7F12]=30714;   // zhui
   sortTable[0x96B9]=30715;   // zhui
   sortTable[0x9A93]=30716;   // zhui
   sortTable[0x918A]=30717;   // zhui
   sortTable[0x8D05]=30718;   // zhui
   sortTable[0x7B0D]=30719;   // zhui
   sortTable[0x8187]=30720;   // zhui
   sortTable[0x8F5B]=30721;   // zhui
   sortTable[0x7E0B]=30722;   // zhui
   sortTable[0x991F]=30723;   // zhui
   sortTable[0x787E]=30724;   // zhui
   sortTable[0x7908]=30725;   // zhui
   sortTable[0x8AC8]=30726;   // zhui
   sortTable[0x9310]=30727;   // zhui
   sortTable[0x9D7B]=30728;   // zhui
   sortTable[0x9323]=30729;   // zhui
   sortTable[0x9A05]=30730;   // zhui
   sortTable[0x5A37]=30731;   // zhui
   sortTable[0x6858]=30732;   // zhui
   sortTable[0x6C9D]=30733;   // zhui
   sortTable[0x7500]=30734;   // zhui
   sortTable[0x7577]=30735;   // zhui
   sortTable[0x8B75]=30736;   // zhui
   sortTable[0x9446]=30737;   // zhui
   sortTable[0x51C6]=30738;   // zhun
   sortTable[0x8C06]=30739;   // zhun
   sortTable[0x80AB]=30740;   // zhun
   sortTable[0x7A80]=30741;   // zhun
   sortTable[0x8FCD]=30742;   // zhun
   sortTable[0x8A30]=30743;   // zhun
   sortTable[0x7DA7]=30744;   // zhun
   sortTable[0x8AC4]=30745;   // zhun
   sortTable[0x7A15]=30746;   // zhun
   sortTable[0x8860]=30747;   // zhun
   sortTable[0x51D6]=30748;   // zhun
   sortTable[0x57FB]=30749;   // zhun
   sortTable[0x5B92]=30750;   // zhun
   sortTable[0x6E96]=30751;   // zhun
   sortTable[0x684C]=30752;   // zhuo
   sortTable[0x6349]=30753;   // zhuo
   sortTable[0x6D4A]=30754;   // zhuo
   sortTable[0x6FC1]=30755;   // zhuo
   sortTable[0x5544]=30756;   // zhuo
   sortTable[0x8301]=30757;   // zhuo
   sortTable[0x5353]=30758;   // zhuo
   sortTable[0x64E2]=30759;   // zhuo
   sortTable[0x914C]=30760;   // zhuo
   sortTable[0x62D9]=30761;   // zhuo
   sortTable[0x707C]=30762;   // zhuo
   sortTable[0x6DBF]=30763;   // zhuo
   sortTable[0x65AB]=30764;   // zhuo
   sortTable[0x956F]=30765;   // zhuo
   sortTable[0x502C]=30766;   // zhuo
   sortTable[0x6FEF]=30767;   // zhuo
   sortTable[0x6D5E]=30768;   // zhuo
   sortTable[0x8BFC]=30769;   // zhuo
   sortTable[0x9DDF]=30770;   // zhuo
   sortTable[0x9D6B]=30771;   // zhuo
   sortTable[0x799A]=30772;   // zhuo
   sortTable[0x7F6C]=30773;   // zhuo
   sortTable[0x8AD1]=30774;   // zhuo
   sortTable[0x7AA1]=30775;   // zhuo
   sortTable[0x8817]=30776;   // zhuo
   sortTable[0x7A5B]=30777;   // zhuo
   sortTable[0x7A71]=30778;   // zhuo
   sortTable[0x92DC]=30779;   // zhuo
   sortTable[0x7BE7]=30780;   // zhuo
   sortTable[0x8B36]=30781;   // zhuo
   sortTable[0x9432]=30782;   // zhuo
   sortTable[0x4E35]=30783;   // zhuo
   sortTable[0x5285]=30784;   // zhuo
   sortTable[0x53D5]=30785;   // zhuo
   sortTable[0x5545]=30786;   // zhuo
   sortTable[0x5734]=30787;   // zhuo
   sortTable[0x59B0]=30788;   // zhuo
   sortTable[0x5A3A]=30789;   // zhuo
   sortTable[0x5F74]=30790;   // zhuo
   sortTable[0x64AF]=30791;   // zhuo
   sortTable[0x64C6]=30792;   // zhuo
   sortTable[0x6580]=30793;   // zhuo
   sortTable[0x65B1]=30794;   // zhuo
   sortTable[0x65B2]=30795;   // zhuo
   sortTable[0x65B5]=30796;   // zhuo
   sortTable[0x666B]=30797;   // zhuo
   sortTable[0x68B2]=30798;   // zhuo
   sortTable[0x68C1]=30799;   // zhuo
   sortTable[0x68F3]=30800;   // zhuo
   sortTable[0x6913]=30801;   // zhuo
   sortTable[0x69D5]=30802;   // zhuo
   sortTable[0x6AE1]=30803;   // zhuo
   sortTable[0x6C4B]=30804;   // zhuo
   sortTable[0x7042]=30805;   // zhuo
   sortTable[0x70AA]=30806;   // zhuo
   sortTable[0x70F5]=30807;   // zhuo
   sortTable[0x72B3]=30808;   // zhuo
   sortTable[0x7438]=30809;   // zhuo
   sortTable[0x787A]=30810;   // zhuo
   sortTable[0x7AA7]=30811;   // zhuo
   sortTable[0x7C57]=30812;   // zhuo
   sortTable[0x7C71]=30813;   // zhuo
   sortTable[0x883F]=30814;   // zhuo
   sortTable[0x8AC1]=30815;   // zhuo
   sortTable[0x942F]=30816;   // zhuo
   sortTable[0x5B50]=30817;   // zi
   sortTable[0x81EA]=30818;   // zi
   sortTable[0x8D44]=30819;   // zi
   sortTable[0x8CC7]=30820;   // zi
   sortTable[0x5B57]=30821;   // zi
   sortTable[0x4ED4]=30822;   // zi
   sortTable[0x7D2B]=30823;   // zi
   sortTable[0x59FF]=30824;   // zi
   sortTable[0x6ECB]=30825;   // zi
   sortTable[0x59CA]=30826;   // zi
   sortTable[0x7C7D]=30827;   // zi
   sortTable[0x5179]=30828;   // zi
   sortTable[0x54A8]=30829;   // zi
   sortTable[0x5B5C]=30830;   // zi
   sortTable[0x6063]=30831;   // zi
   sortTable[0x6893]=30832;   // zi
   sortTable[0x6DC4]=30833;   // zi
   sortTable[0x8C18]=30834;   // zi
   sortTable[0x7B2B]=30835;   // zi
   sortTable[0x8F8E]=30836;   // zi
   sortTable[0x8D40]=30837;   // zi
   sortTable[0x6E0D]=30838;   // zi
   sortTable[0x6ED3]=30839;   // zi
   sortTable[0x7CA2]=30840;   // zi
   sortTable[0x7F01]=30841;   // zi
   sortTable[0x9F87]=30842;   // zi
   sortTable[0x9AED]=30843;   // zi
   sortTable[0x5B73]=30844;   // zi
   sortTable[0x8A3E]=30845;   // zi
   sortTable[0x89DC]=30846;   // zi
   sortTable[0x7726]=30847;   // zi
   sortTable[0x9531]=30848;   // zi
   sortTable[0x5D6B]=30849;   // zi
   sortTable[0x79ED]=30850;   // zi
   sortTable[0x8D91]=30851;   // zi
   sortTable[0x80D4]=30852;   // zi
   sortTable[0x9CBB]=30853;   // zi
   sortTable[0x8678]=30854;   // zi
   sortTable[0x80FE]=30855;   // zi
   sortTable[0x8DA6]=30856;   // zi
   sortTable[0x9111]=30857;   // zi
   sortTable[0x93A1]=30858;   // zi
   sortTable[0x8014]=30859;   // zi
   sortTable[0x9F12]=30860;   // zi
   sortTable[0x8332]=30861;   // zi
   sortTable[0x8A3F]=30862;   // zi
   sortTable[0x9BD4]=30863;   // zi
   sortTable[0x9543]=30864;   // zi
   sortTable[0x9D85]=30865;   // zi
   sortTable[0x9F4D]=30866;   // zi
   sortTable[0x80CF]=30867;   // zi
   sortTable[0x84FB]=30868;   // zi
   sortTable[0x7725]=30869;   // zi
   sortTable[0x79C4]=30870;   // zi
   sortTable[0x798C]=30871;   // zi
   sortTable[0x830A]=30872;   // zi
   sortTable[0x8F3A]=30873;   // zi
   sortTable[0x9C26]=30874;   // zi
   sortTable[0x79F6]=30875;   // zi
   sortTable[0x8458]=30876;   // zi
   sortTable[0x922D]=30877;   // zi
   sortTable[0x8AEE]=30878;   // zi
   sortTable[0x8321]=30879;   // zi
   sortTable[0x8CB2]=30880;   // zi
   sortTable[0x983E]=30881;   // zi
   sortTable[0x8293]=30882;   // zi
   sortTable[0x4E72]=30883;   // zi
   sortTable[0x5033]=30884;   // zi
   sortTable[0x525A]=30885;   // zi
   sortTable[0x5407]=30886;   // zi
   sortTable[0x5470]=30887;   // zi
   sortTable[0x5559]=30888;   // zi
   sortTable[0x55DE]=30889;   // zi
   sortTable[0x59C9]=30890;   // zi
   sortTable[0x59D5]=30891;   // zi
   sortTable[0x5B76]=30892;   // zi
   sortTable[0x5D30]=30893;   // zi
   sortTable[0x674D]=30894;   // zi
   sortTable[0x6825]=30895;   // zi
   sortTable[0x6914]=30896;   // zi
   sortTable[0x699F]=30897;   // zi
   sortTable[0x6A74]=30898;   // zi
   sortTable[0x6E7D]=30899;   // zi
   sortTable[0x6F2C]=30900;   // zi
   sortTable[0x6FAC]=30901;   // zi
   sortTable[0x7278]=30902;   // zi
   sortTable[0x7386]=30903;   // zi
   sortTable[0x74BE]=30904;   // zi
   sortTable[0x77F7]=30905;   // zi
   sortTable[0x7A35]=30906;   // zi
   sortTable[0x7D0E]=30907;   // zi
   sortTable[0x7DC7]=30908;   // zi
   sortTable[0x8F1C]=30909;   // zi
   sortTable[0x91E8]=30910;   // zi
   sortTable[0x9319]=30911;   // zi
   sortTable[0x937F]=30912;   // zi
   sortTable[0x983F]=30913;   // zi
   sortTable[0x603B]=30914;   // zong
   sortTable[0x7E3D]=30915;   // zong
   sortTable[0x7EFC]=30916;   // zong
   sortTable[0x7D9C]=30917;   // zong
   sortTable[0x5B97]=30918;   // zong
   sortTable[0x7EB5]=30919;   // zong
   sortTable[0x7E31]=30920;   // zong
   sortTable[0x8E2A]=30921;   // zong
   sortTable[0x8E64]=30922;   // zong
   sortTable[0x68D5]=30923;   // zong
   sortTable[0x9B03]=30924;   // zong
   sortTable[0x7CBD]=30925;   // zong
   sortTable[0x506C]=30926;   // zong
   sortTable[0x8159]=30927;   // zong
   sortTable[0x9B37]=30928;   // zong
   sortTable[0x9350]=30929;   // zong
   sortTable[0x9BEE]=30930;   // zong
   sortTable[0x7DC3]=30931;   // zong
   sortTable[0x78EB]=30932;   // zong
   sortTable[0x931D]=30933;   // zong
   sortTable[0x7DF5]=30934;   // zong
   sortTable[0x8C75]=30935;   // zong
   sortTable[0x9A23]=30936;   // zong
   sortTable[0x9A94]=30937;   // zong
   sortTable[0x7A2F]=30938;   // zong
   sortTable[0x7E02]=30939;   // zong
   sortTable[0x7FEA]=30940;   // zong
   sortTable[0x847C]=30941;   // zong
   sortTable[0x7CC9]=30942;   // zong
   sortTable[0x84D7]=30943;   // zong
   sortTable[0x8E28]=30944;   // zong
   sortTable[0x9B09]=30945;   // zong
   sortTable[0x500A]=30946;   // zong
   sortTable[0x5027]=30947;   // zong
   sortTable[0x50AF]=30948;   // zong
   sortTable[0x582B]=30949;   // zong
   sortTable[0x5D4F]=30950;   // zong
   sortTable[0x5D55]=30951;   // zong
   sortTable[0x5D78]=30952;   // zong
   sortTable[0x60E3]=30953;   // zong
   sortTable[0x60FE]=30954;   // zong
   sortTable[0x6121]=30955;   // zong
   sortTable[0x6374]=30956;   // zong
   sortTable[0x63D4]=30957;   // zong
   sortTable[0x6403]=30958;   // zong
   sortTable[0x6460]=30959;   // zong
   sortTable[0x662E]=30960;   // zong
   sortTable[0x6721]=30961;   // zong
   sortTable[0x6936]=30962;   // zong
   sortTable[0x6F48]=30963;   // zong
   sortTable[0x71A7]=30964;   // zong
   sortTable[0x7314]=30965;   // zong
   sortTable[0x7323]=30966;   // zong
   sortTable[0x75AD]=30967;   // zong
   sortTable[0x7632]=30968;   // zong
   sortTable[0x7882]=30969;   // zong
   sortTable[0x7CED]=30970;   // zong
   sortTable[0x7DCF]=30971;   // zong
   sortTable[0x7E26]=30972;   // zong
   sortTable[0x876C]=30973;   // zong
   sortTable[0x93D3]=30974;   // zong
   sortTable[0x9441]=30975;   // zong
   sortTable[0x9A0C]=30976;   // zong
   sortTable[0x9BFC]=30977;   // zong
   sortTable[0x8D70]=30978;   // zou
   sortTable[0x594F]=30979;   // zou
   sortTable[0x63CD]=30980;   // zou
   sortTable[0x90B9]=30981;   // zou
   sortTable[0x8BF9]=30982;   // zou
   sortTable[0x9A7A]=30983;   // zou
   sortTable[0x966C]=30984;   // zou
   sortTable[0x9139]=30985;   // zou
   sortTable[0x9CB0]=30986;   // zou
   sortTable[0x9BD0]=30987;   // zou
   sortTable[0x83C6]=30988;   // zou
   sortTable[0x7DC5]=30989;   // zou
   sortTable[0x9F7A]=30990;   // zou
   sortTable[0x6971]=30991;   // zou
   sortTable[0x90F0]=30992;   // zou
   sortTable[0x9F71]=30993;   // zou
   sortTable[0x8ACF]=30994;   // zou
   sortTable[0x68F7]=30995;   // zou
   sortTable[0x68F8]=30996;   // zou
   sortTable[0x7B83]=30997;   // zou
   sortTable[0x8D71]=30998;   // zou
   sortTable[0x9112]=30999;   // zou
   sortTable[0x9A36]=31000;   // zou
   sortTable[0x9BEB]=31001;   // zou
   sortTable[0x9EC0]=31002;   // zou
   sortTable[0x7EC4]=31003;   // zu
   sortTable[0x7D44]=31004;   // zu
   sortTable[0x65CF]=31005;   // zu
   sortTable[0x7956]=31006;   // zu
   sortTable[0x8DB3]=31007;   // zu
   sortTable[0x963B]=31008;   // zu
   sortTable[0x79DF]=31009;   // zu
   sortTable[0x5352]=31010;   // zu
   sortTable[0x4FCE]=31011;   // zu
   sortTable[0x8BC5]=31012;   // zu
   sortTable[0x955E]=31013;   // zu
   sortTable[0x8445]=31014;   // zu
   sortTable[0x84A9]=31015;   // zu
   sortTable[0x7BA4]=31016;   // zu
   sortTable[0x8A5B]=31017;   // zu
   sortTable[0x93BA]=31018;   // zu
   sortTable[0x93C3]=31019;   // zu
   sortTable[0x977B]=31020;   // zu
   sortTable[0x50B6]=31021;   // zu
   sortTable[0x5346]=31022;   // zu
   sortTable[0x54EB]=31023;   // zu
   sortTable[0x5D12]=31024;   // zu
   sortTable[0x5D2A]=31025;   // zu
   sortTable[0x723C]=31026;   // zu
   sortTable[0x73C7]=31027;   // zu
   sortTable[0x8E24]=31028;   // zu
   sortTable[0x8E3F]=31029;   // zu
   sortTable[0x94BB]=31030;   // zuan
   sortTable[0x947D]=31031;   // zuan
   sortTable[0x6525]=31032;   // zuan
   sortTable[0x7E82]=31033;   // zuan
   sortTable[0x7F35]=31034;   // zuan
   sortTable[0x8E9C]=31035;   // zuan
   sortTable[0x7E98]=31036;   // zuan
   sortTable[0x7C6B]=31037;   // zuan
   sortTable[0x7E64]=31038;   // zuan
   sortTable[0x7E89]=31039;   // zuan
   sortTable[0x945A]=31040;   // zuan
   sortTable[0x6700]=31041;   // zui
   sortTable[0x5634]=31042;   // zui
   sortTable[0x7F6A]=31043;   // zui
   sortTable[0x9189]=31044;   // zui
   sortTable[0x855E]=31045;   // zui
   sortTable[0x7A21]=31046;   // zui
   sortTable[0x92F7]=31047;   // zui
   sortTable[0x87D5]=31048;   // zui
   sortTable[0x797D]=31049;   // zui
   sortTable[0x7E97]=31050;   // zui
   sortTable[0x539C]=31051;   // zui
   sortTable[0x55FA]=31052;   // zui
   sortTable[0x567F]=31053;   // zui
   sortTable[0x5D8A]=31054;   // zui
   sortTable[0x5DB5]=31055;   // zui
   sortTable[0x666C]=31056;   // zui
   sortTable[0x6718]=31057;   // zui
   sortTable[0x67A0]=31058;   // zui
   sortTable[0x682C]=31059;   // zui
   sortTable[0x69DC]=31060;   // zui
   sortTable[0x6A36]=31061;   // zui
   sortTable[0x6A87]=31062;   // zui
   sortTable[0x6A8C]=31063;   // zui
   sortTable[0x74BB]=31064;   // zui
   sortTable[0x7A5D]=31065;   // zui
   sortTable[0x7D4A]=31066;   // zui
   sortTable[0x8FA0]=31067;   // zui
   sortTable[0x9154]=31068;   // zui
   sortTable[0x917B]=31069;   // zui
   sortTable[0x930A]=31070;   // zui
   sortTable[0x5C0A]=31071;   // zun
   sortTable[0x9075]=31072;   // zun
   sortTable[0x6A3D]=31073;   // zun
   sortTable[0x6499]=31074;   // zun
   sortTable[0x9CDF]=31075;   // zun
   sortTable[0x940F]=31076;   // zun
   sortTable[0x7F47]=31077;   // zun
   sortTable[0x9D8E]=31078;   // zun
   sortTable[0x9DF7]=31079;   // zun
   sortTable[0x7E5C]=31080;   // zun
   sortTable[0x8B50]=31081;   // zun
   sortTable[0x928C]=31082;   // zun
   sortTable[0x50D4]=31083;   // zun
   sortTable[0x5642]=31084;   // zun
   sortTable[0x58AB]=31085;   // zun
   sortTable[0x58FF]=31086;   // zun
   sortTable[0x5D9F]=31087;   // zun
   sortTable[0x6358]=31088;   // zun
   sortTable[0x9C52]=31089;   // zun
   sortTable[0x4F5C]=31090;   // zuo
   sortTable[0x505A]=31091;   // zuo
   sortTable[0x5750]=31092;   // zuo
   sortTable[0x5DE6]=31093;   // zuo
   sortTable[0x5EA7]=31094;   // zuo
   sortTable[0x6628]=31095;   // zuo
   sortTable[0x7422]=31096;   // zuo
   sortTable[0x4F50]=31097;   // zuo
   sortTable[0x795A]=31098;   // zuo
   sortTable[0x963C]=31099;   // zuo
   sortTable[0x80D9]=31100;   // zuo
   sortTable[0x5511]=31101;   // zuo
   sortTable[0x600D]=31102;   // zuo
   sortTable[0x838B]=31103;   // zuo
   sortTable[0x7B70]=31104;   // zuo
   sortTable[0x7A13]=31105;   // zuo
   sortTable[0x7E53]=31106;   // zuo
   sortTable[0x84D9]=31107;   // zuo
   sortTable[0x888F]=31108;   // zuo
   sortTable[0x8444]=31109;   // zuo
   sortTable[0x923C]=31110;   // zuo
   sortTable[0x98F5]=31111;   // zuo
   sortTable[0x4FB3]=31112;   // zuo
   sortTable[0x5497]=31113;   // zuo
   sortTable[0x5528]=31114;   // zuo
   sortTable[0x5C9D]=31115;   // zuo
   sortTable[0x5C9E]=31116;   // zuo
   sortTable[0x637D]=31117;   // zuo
   sortTable[0x690A]=31118;   // zuo
   sortTable[0x79E8]=31119;   // zuo
   sortTable[0x7CF3]=31120;   // zuo
   sortTable[0x8443]=31121;   // zuo
   sortTable[0x685B]=31122;   // zzz
   sortTable[0x70EA]=31123;   // zzz
   sortTable[0x74E7]=31124;   // zzz
   sortTable[0x74F0]=31125;   // zzz
   sortTable[0x74F1]=31126;   // zzz
   sortTable[0x74FC]=31127;   // zzz
   sortTable[0x7505]=31128;   // zzz
   sortTable[0x3131]=32768;   // HANGUL SYLLABLE
   sortTable[0x1100]=32769;   // HANGUL CHOSEONG KIYEOK
   sortTable[0x11A8]=32770;   // HANGUL JONGSEONG KIYEOK
   sortTable[0xAC00]=32771;   // HANGUL SYLLABLE
   sortTable[0xAC01]=32772;   // HANGUL SYLLABLE
   sortTable[0xAC02]=32773;   // HANGUL SYLLABLE
   sortTable[0xAC03]=32774;   // HANGUL SYLLABLE
   sortTable[0xAC04]=32775;   // HANGUL SYLLABLE
   sortTable[0xAC05]=32776;   // HANGUL SYLLABLE
   sortTable[0xAC06]=32777;   // HANGUL SYLLABLE
   sortTable[0xAC07]=32778;   // HANGUL SYLLABLE
   sortTable[0xAC08]=32779;   // HANGUL SYLLABLE
   sortTable[0xAC09]=32780;   // HANGUL SYLLABLE
   sortTable[0xAC0A]=32781;   // HANGUL SYLLABLE
   sortTable[0xAC0B]=32782;   // HANGUL SYLLABLE
   sortTable[0xAC0C]=32783;   // HANGUL SYLLABLE
   sortTable[0xAC0D]=32784;   // HANGUL SYLLABLE
   sortTable[0xAC0E]=32785;   // HANGUL SYLLABLE
   sortTable[0xAC0F]=32786;   // HANGUL SYLLABLE
   sortTable[0xAC10]=32787;   // HANGUL SYLLABLE
   sortTable[0xAC11]=32788;   // HANGUL SYLLABLE
   sortTable[0xAC12]=32789;   // HANGUL SYLLABLE
   sortTable[0xAC13]=32790;   // HANGUL SYLLABLE
   sortTable[0xAC14]=32791;   // HANGUL SYLLABLE
   sortTable[0xAC15]=32792;   // HANGUL SYLLABLE
   sortTable[0xAC16]=32793;   // HANGUL SYLLABLE
   sortTable[0xAC17]=32794;   // HANGUL SYLLABLE
   sortTable[0xAC18]=32795;   // HANGUL SYLLABLE
   sortTable[0xAC19]=32796;   // HANGUL SYLLABLE
   sortTable[0xAC1A]=32797;   // HANGUL SYLLABLE
   sortTable[0xAC1B]=32798;   // HANGUL SYLLABLE
   sortTable[0xAC1C]=32799;   // HANGUL SYLLABLE
   sortTable[0xAC1D]=32800;   // HANGUL SYLLABLE
   sortTable[0xAC1E]=32801;   // HANGUL SYLLABLE
   sortTable[0xAC1F]=32802;   // HANGUL SYLLABLE
   sortTable[0xAC20]=32803;   // HANGUL SYLLABLE
   sortTable[0xAC21]=32804;   // HANGUL SYLLABLE
   sortTable[0xAC22]=32805;   // HANGUL SYLLABLE
   sortTable[0xAC23]=32806;   // HANGUL SYLLABLE
   sortTable[0xAC24]=32807;   // HANGUL SYLLABLE
   sortTable[0xAC25]=32808;   // HANGUL SYLLABLE
   sortTable[0xAC26]=32809;   // HANGUL SYLLABLE
   sortTable[0xAC27]=32810;   // HANGUL SYLLABLE
   sortTable[0xAC28]=32811;   // HANGUL SYLLABLE
   sortTable[0xAC29]=32812;   // HANGUL SYLLABLE
   sortTable[0xAC2A]=32813;   // HANGUL SYLLABLE
   sortTable[0xAC2B]=32814;   // HANGUL SYLLABLE
   sortTable[0xAC2C]=32815;   // HANGUL SYLLABLE
   sortTable[0xAC2D]=32816;   // HANGUL SYLLABLE
   sortTable[0xAC2E]=32817;   // HANGUL SYLLABLE
   sortTable[0xAC2F]=32818;   // HANGUL SYLLABLE
   sortTable[0xAC30]=32819;   // HANGUL SYLLABLE
   sortTable[0xAC31]=32820;   // HANGUL SYLLABLE
   sortTable[0xAC32]=32821;   // HANGUL SYLLABLE
   sortTable[0xAC33]=32822;   // HANGUL SYLLABLE
   sortTable[0xAC34]=32823;   // HANGUL SYLLABLE
   sortTable[0xAC35]=32824;   // HANGUL SYLLABLE
   sortTable[0xAC36]=32825;   // HANGUL SYLLABLE
   sortTable[0xAC37]=32826;   // HANGUL SYLLABLE
   sortTable[0xAC38]=32827;   // HANGUL SYLLABLE
   sortTable[0xAC39]=32828;   // HANGUL SYLLABLE
   sortTable[0xAC3A]=32829;   // HANGUL SYLLABLE
   sortTable[0xAC3B]=32830;   // HANGUL SYLLABLE
   sortTable[0xAC3C]=32831;   // HANGUL SYLLABLE
   sortTable[0xAC3D]=32832;   // HANGUL SYLLABLE
   sortTable[0xAC3E]=32833;   // HANGUL SYLLABLE
   sortTable[0xAC3F]=32834;   // HANGUL SYLLABLE
   sortTable[0xAC40]=32835;   // HANGUL SYLLABLE
   sortTable[0xAC41]=32836;   // HANGUL SYLLABLE
   sortTable[0xAC42]=32837;   // HANGUL SYLLABLE
   sortTable[0xAC43]=32838;   // HANGUL SYLLABLE
   sortTable[0xAC44]=32839;   // HANGUL SYLLABLE
   sortTable[0xAC45]=32840;   // HANGUL SYLLABLE
   sortTable[0xAC46]=32841;   // HANGUL SYLLABLE
   sortTable[0xAC47]=32842;   // HANGUL SYLLABLE
   sortTable[0xAC48]=32843;   // HANGUL SYLLABLE
   sortTable[0xAC49]=32844;   // HANGUL SYLLABLE
   sortTable[0xAC4A]=32845;   // HANGUL SYLLABLE
   sortTable[0xAC4B]=32846;   // HANGUL SYLLABLE
   sortTable[0xAC4C]=32847;   // HANGUL SYLLABLE
   sortTable[0xAC4D]=32848;   // HANGUL SYLLABLE
   sortTable[0xAC4E]=32849;   // HANGUL SYLLABLE
   sortTable[0xAC4F]=32850;   // HANGUL SYLLABLE
   sortTable[0xAC50]=32851;   // HANGUL SYLLABLE
   sortTable[0xAC51]=32852;   // HANGUL SYLLABLE
   sortTable[0xAC52]=32853;   // HANGUL SYLLABLE
   sortTable[0xAC53]=32854;   // HANGUL SYLLABLE
   sortTable[0xAC54]=32855;   // HANGUL SYLLABLE
   sortTable[0xAC55]=32856;   // HANGUL SYLLABLE
   sortTable[0xAC56]=32857;   // HANGUL SYLLABLE
   sortTable[0xAC57]=32858;   // HANGUL SYLLABLE
   sortTable[0xAC58]=32859;   // HANGUL SYLLABLE
   sortTable[0xAC59]=32860;   // HANGUL SYLLABLE
   sortTable[0xAC5A]=32861;   // HANGUL SYLLABLE
   sortTable[0xAC5B]=32862;   // HANGUL SYLLABLE
   sortTable[0xAC5C]=32863;   // HANGUL SYLLABLE
   sortTable[0xAC5D]=32864;   // HANGUL SYLLABLE
   sortTable[0xAC5E]=32865;   // HANGUL SYLLABLE
   sortTable[0xAC5F]=32866;   // HANGUL SYLLABLE
   sortTable[0xAC60]=32867;   // HANGUL SYLLABLE
   sortTable[0xAC61]=32868;   // HANGUL SYLLABLE
   sortTable[0xAC62]=32869;   // HANGUL SYLLABLE
   sortTable[0xAC63]=32870;   // HANGUL SYLLABLE
   sortTable[0xAC64]=32871;   // HANGUL SYLLABLE
   sortTable[0xAC65]=32872;   // HANGUL SYLLABLE
   sortTable[0xAC66]=32873;   // HANGUL SYLLABLE
   sortTable[0xAC67]=32874;   // HANGUL SYLLABLE
   sortTable[0xAC68]=32875;   // HANGUL SYLLABLE
   sortTable[0xAC69]=32876;   // HANGUL SYLLABLE
   sortTable[0xAC6A]=32877;   // HANGUL SYLLABLE
   sortTable[0xAC6B]=32878;   // HANGUL SYLLABLE
   sortTable[0xAC6C]=32879;   // HANGUL SYLLABLE
   sortTable[0xAC6D]=32880;   // HANGUL SYLLABLE
   sortTable[0xAC6E]=32881;   // HANGUL SYLLABLE
   sortTable[0xAC6F]=32882;   // HANGUL SYLLABLE
   sortTable[0xAC70]=32883;   // HANGUL SYLLABLE
   sortTable[0xAC71]=32884;   // HANGUL SYLLABLE
   sortTable[0xAC72]=32885;   // HANGUL SYLLABLE
   sortTable[0xAC73]=32886;   // HANGUL SYLLABLE
   sortTable[0xAC74]=32887;   // HANGUL SYLLABLE
   sortTable[0xAC75]=32888;   // HANGUL SYLLABLE
   sortTable[0xAC76]=32889;   // HANGUL SYLLABLE
   sortTable[0xAC77]=32890;   // HANGUL SYLLABLE
   sortTable[0xAC78]=32891;   // HANGUL SYLLABLE
   sortTable[0xAC79]=32892;   // HANGUL SYLLABLE
   sortTable[0xAC7A]=32893;   // HANGUL SYLLABLE
   sortTable[0xAC7B]=32894;   // HANGUL SYLLABLE
   sortTable[0xAC7C]=32895;   // HANGUL SYLLABLE
   sortTable[0xAC7D]=32896;   // HANGUL SYLLABLE
   sortTable[0xAC7E]=32897;   // HANGUL SYLLABLE
   sortTable[0xAC7F]=32898;   // HANGUL SYLLABLE
   sortTable[0xAC80]=32899;   // HANGUL SYLLABLE
   sortTable[0xAC81]=32900;   // HANGUL SYLLABLE
   sortTable[0xAC82]=32901;   // HANGUL SYLLABLE
   sortTable[0xAC83]=32902;   // HANGUL SYLLABLE
   sortTable[0xAC84]=32903;   // HANGUL SYLLABLE
   sortTable[0xAC85]=32904;   // HANGUL SYLLABLE
   sortTable[0xAC86]=32905;   // HANGUL SYLLABLE
   sortTable[0xAC87]=32906;   // HANGUL SYLLABLE
   sortTable[0xAC88]=32907;   // HANGUL SYLLABLE
   sortTable[0xAC89]=32908;   // HANGUL SYLLABLE
   sortTable[0xAC8A]=32909;   // HANGUL SYLLABLE
   sortTable[0xAC8B]=32910;   // HANGUL SYLLABLE
   sortTable[0xAC8C]=32911;   // HANGUL SYLLABLE
   sortTable[0xAC8D]=32912;   // HANGUL SYLLABLE
   sortTable[0xAC8E]=32913;   // HANGUL SYLLABLE
   sortTable[0xAC8F]=32914;   // HANGUL SYLLABLE
   sortTable[0xAC90]=32915;   // HANGUL SYLLABLE
   sortTable[0xAC91]=32916;   // HANGUL SYLLABLE
   sortTable[0xAC92]=32917;   // HANGUL SYLLABLE
   sortTable[0xAC93]=32918;   // HANGUL SYLLABLE
   sortTable[0xAC94]=32919;   // HANGUL SYLLABLE
   sortTable[0xAC95]=32920;   // HANGUL SYLLABLE
   sortTable[0xAC96]=32921;   // HANGUL SYLLABLE
   sortTable[0xAC97]=32922;   // HANGUL SYLLABLE
   sortTable[0xAC98]=32923;   // HANGUL SYLLABLE
   sortTable[0xAC99]=32924;   // HANGUL SYLLABLE
   sortTable[0xAC9A]=32925;   // HANGUL SYLLABLE
   sortTable[0xAC9B]=32926;   // HANGUL SYLLABLE
   sortTable[0xAC9C]=32927;   // HANGUL SYLLABLE
   sortTable[0xAC9D]=32928;   // HANGUL SYLLABLE
   sortTable[0xAC9E]=32929;   // HANGUL SYLLABLE
   sortTable[0xAC9F]=32930;   // HANGUL SYLLABLE
   sortTable[0xACA0]=32931;   // HANGUL SYLLABLE
   sortTable[0xACA1]=32932;   // HANGUL SYLLABLE
   sortTable[0xACA2]=32933;   // HANGUL SYLLABLE
   sortTable[0xACA3]=32934;   // HANGUL SYLLABLE
   sortTable[0xACA4]=32935;   // HANGUL SYLLABLE
   sortTable[0xACA5]=32936;   // HANGUL SYLLABLE
   sortTable[0xACA6]=32937;   // HANGUL SYLLABLE
   sortTable[0xACA7]=32938;   // HANGUL SYLLABLE
   sortTable[0xACA8]=32939;   // HANGUL SYLLABLE
   sortTable[0xACA9]=32940;   // HANGUL SYLLABLE
   sortTable[0xACAA]=32941;   // HANGUL SYLLABLE
   sortTable[0xACAB]=32942;   // HANGUL SYLLABLE
   sortTable[0xACAC]=32943;   // HANGUL SYLLABLE
   sortTable[0xACAD]=32944;   // HANGUL SYLLABLE
   sortTable[0xACAE]=32945;   // HANGUL SYLLABLE
   sortTable[0xACAF]=32946;   // HANGUL SYLLABLE
   sortTable[0xACB0]=32947;   // HANGUL SYLLABLE
   sortTable[0xACB1]=32948;   // HANGUL SYLLABLE
   sortTable[0xACB2]=32949;   // HANGUL SYLLABLE
   sortTable[0xACB3]=32950;   // HANGUL SYLLABLE
   sortTable[0xACB4]=32951;   // HANGUL SYLLABLE
   sortTable[0xACB5]=32952;   // HANGUL SYLLABLE
   sortTable[0xACB6]=32953;   // HANGUL SYLLABLE
   sortTable[0xACB7]=32954;   // HANGUL SYLLABLE
   sortTable[0xACB8]=32955;   // HANGUL SYLLABLE
   sortTable[0xACB9]=32956;   // HANGUL SYLLABLE
   sortTable[0xACBA]=32957;   // HANGUL SYLLABLE
   sortTable[0xACBB]=32958;   // HANGUL SYLLABLE
   sortTable[0xACBC]=32959;   // HANGUL SYLLABLE
   sortTable[0xACBD]=32960;   // HANGUL SYLLABLE
   sortTable[0xACBE]=32961;   // HANGUL SYLLABLE
   sortTable[0xACBF]=32962;   // HANGUL SYLLABLE
   sortTable[0xACC0]=32963;   // HANGUL SYLLABLE
   sortTable[0xACC1]=32964;   // HANGUL SYLLABLE
   sortTable[0xACC2]=32965;   // HANGUL SYLLABLE
   sortTable[0xACC3]=32966;   // HANGUL SYLLABLE
   sortTable[0xACC4]=32967;   // HANGUL SYLLABLE
   sortTable[0xACC5]=32968;   // HANGUL SYLLABLE
   sortTable[0xACC6]=32969;   // HANGUL SYLLABLE
   sortTable[0xACC7]=32970;   // HANGUL SYLLABLE
   sortTable[0xACC8]=32971;   // HANGUL SYLLABLE
   sortTable[0xACC9]=32972;   // HANGUL SYLLABLE
   sortTable[0xACCA]=32973;   // HANGUL SYLLABLE
   sortTable[0xACCB]=32974;   // HANGUL SYLLABLE
   sortTable[0xACCC]=32975;   // HANGUL SYLLABLE
   sortTable[0xACCD]=32976;   // HANGUL SYLLABLE
   sortTable[0xACCE]=32977;   // HANGUL SYLLABLE
   sortTable[0xACCF]=32978;   // HANGUL SYLLABLE
   sortTable[0xACD0]=32979;   // HANGUL SYLLABLE
   sortTable[0xACD1]=32980;   // HANGUL SYLLABLE
   sortTable[0xACD2]=32981;   // HANGUL SYLLABLE
   sortTable[0xACD3]=32982;   // HANGUL SYLLABLE
   sortTable[0xACD4]=32983;   // HANGUL SYLLABLE
   sortTable[0xACD5]=32984;   // HANGUL SYLLABLE
   sortTable[0xACD6]=32985;   // HANGUL SYLLABLE
   sortTable[0xACD7]=32986;   // HANGUL SYLLABLE
   sortTable[0xACD8]=32987;   // HANGUL SYLLABLE
   sortTable[0xACD9]=32988;   // HANGUL SYLLABLE
   sortTable[0xACDA]=32989;   // HANGUL SYLLABLE
   sortTable[0xACDB]=32990;   // HANGUL SYLLABLE
   sortTable[0xACDC]=32991;   // HANGUL SYLLABLE
   sortTable[0xACDD]=32992;   // HANGUL SYLLABLE
   sortTable[0xACDE]=32993;   // HANGUL SYLLABLE
   sortTable[0xACDF]=32994;   // HANGUL SYLLABLE
   sortTable[0xACE0]=32995;   // HANGUL SYLLABLE
   sortTable[0xACE1]=32996;   // HANGUL SYLLABLE
   sortTable[0xACE2]=32997;   // HANGUL SYLLABLE
   sortTable[0xACE3]=32998;   // HANGUL SYLLABLE
   sortTable[0xACE4]=32999;   // HANGUL SYLLABLE
   sortTable[0xACE5]=33000;   // HANGUL SYLLABLE
   sortTable[0xACE6]=33001;   // HANGUL SYLLABLE
   sortTable[0xACE7]=33002;   // HANGUL SYLLABLE
   sortTable[0xACE8]=33003;   // HANGUL SYLLABLE
   sortTable[0xACE9]=33004;   // HANGUL SYLLABLE
   sortTable[0xACEA]=33005;   // HANGUL SYLLABLE
   sortTable[0xACEB]=33006;   // HANGUL SYLLABLE
   sortTable[0xACEC]=33007;   // HANGUL SYLLABLE
   sortTable[0xACED]=33008;   // HANGUL SYLLABLE
   sortTable[0xACEE]=33009;   // HANGUL SYLLABLE
   sortTable[0xACEF]=33010;   // HANGUL SYLLABLE
   sortTable[0xACF0]=33011;   // HANGUL SYLLABLE
   sortTable[0xACF1]=33012;   // HANGUL SYLLABLE
   sortTable[0xACF2]=33013;   // HANGUL SYLLABLE
   sortTable[0xACF3]=33014;   // HANGUL SYLLABLE
   sortTable[0xACF4]=33015;   // HANGUL SYLLABLE
   sortTable[0xACF5]=33016;   // HANGUL SYLLABLE
   sortTable[0xACF6]=33017;   // HANGUL SYLLABLE
   sortTable[0xACF7]=33018;   // HANGUL SYLLABLE
   sortTable[0xACF8]=33019;   // HANGUL SYLLABLE
   sortTable[0xACF9]=33020;   // HANGUL SYLLABLE
   sortTable[0xACFA]=33021;   // HANGUL SYLLABLE
   sortTable[0xACFB]=33022;   // HANGUL SYLLABLE
   sortTable[0xACFC]=33023;   // HANGUL SYLLABLE
   sortTable[0xACFD]=33024;   // HANGUL SYLLABLE
   sortTable[0xACFE]=33025;   // HANGUL SYLLABLE
   sortTable[0xACFF]=33026;   // HANGUL SYLLABLE
   sortTable[0xAD00]=33027;   // HANGUL SYLLABLE
   sortTable[0xAD01]=33028;   // HANGUL SYLLABLE
   sortTable[0xAD02]=33029;   // HANGUL SYLLABLE
   sortTable[0xAD03]=33030;   // HANGUL SYLLABLE
   sortTable[0xAD04]=33031;   // HANGUL SYLLABLE
   sortTable[0xAD05]=33032;   // HANGUL SYLLABLE
   sortTable[0xAD06]=33033;   // HANGUL SYLLABLE
   sortTable[0xAD07]=33034;   // HANGUL SYLLABLE
   sortTable[0xAD08]=33035;   // HANGUL SYLLABLE
   sortTable[0xAD09]=33036;   // HANGUL SYLLABLE
   sortTable[0xAD0A]=33037;   // HANGUL SYLLABLE
   sortTable[0xAD0B]=33038;   // HANGUL SYLLABLE
   sortTable[0xAD0C]=33039;   // HANGUL SYLLABLE
   sortTable[0xAD0D]=33040;   // HANGUL SYLLABLE
   sortTable[0xAD0E]=33041;   // HANGUL SYLLABLE
   sortTable[0xAD0F]=33042;   // HANGUL SYLLABLE
   sortTable[0xAD10]=33043;   // HANGUL SYLLABLE
   sortTable[0xAD11]=33044;   // HANGUL SYLLABLE
   sortTable[0xAD12]=33045;   // HANGUL SYLLABLE
   sortTable[0xAD13]=33046;   // HANGUL SYLLABLE
   sortTable[0xAD14]=33047;   // HANGUL SYLLABLE
   sortTable[0xAD15]=33048;   // HANGUL SYLLABLE
   sortTable[0xAD16]=33049;   // HANGUL SYLLABLE
   sortTable[0xAD17]=33050;   // HANGUL SYLLABLE
   sortTable[0xAD18]=33051;   // HANGUL SYLLABLE
   sortTable[0xAD19]=33052;   // HANGUL SYLLABLE
   sortTable[0xAD1A]=33053;   // HANGUL SYLLABLE
   sortTable[0xAD1B]=33054;   // HANGUL SYLLABLE
   sortTable[0xAD1C]=33055;   // HANGUL SYLLABLE
   sortTable[0xAD1D]=33056;   // HANGUL SYLLABLE
   sortTable[0xAD1E]=33057;   // HANGUL SYLLABLE
   sortTable[0xAD1F]=33058;   // HANGUL SYLLABLE
   sortTable[0xAD20]=33059;   // HANGUL SYLLABLE
   sortTable[0xAD21]=33060;   // HANGUL SYLLABLE
   sortTable[0xAD22]=33061;   // HANGUL SYLLABLE
   sortTable[0xAD23]=33062;   // HANGUL SYLLABLE
   sortTable[0xAD24]=33063;   // HANGUL SYLLABLE
   sortTable[0xAD25]=33064;   // HANGUL SYLLABLE
   sortTable[0xAD26]=33065;   // HANGUL SYLLABLE
   sortTable[0xAD27]=33066;   // HANGUL SYLLABLE
   sortTable[0xAD28]=33067;   // HANGUL SYLLABLE
   sortTable[0xAD29]=33068;   // HANGUL SYLLABLE
   sortTable[0xAD2A]=33069;   // HANGUL SYLLABLE
   sortTable[0xAD2B]=33070;   // HANGUL SYLLABLE
   sortTable[0xAD2C]=33071;   // HANGUL SYLLABLE
   sortTable[0xAD2D]=33072;   // HANGUL SYLLABLE
   sortTable[0xAD2E]=33073;   // HANGUL SYLLABLE
   sortTable[0xAD2F]=33074;   // HANGUL SYLLABLE
   sortTable[0xAD30]=33075;   // HANGUL SYLLABLE
   sortTable[0xAD31]=33076;   // HANGUL SYLLABLE
   sortTable[0xAD32]=33077;   // HANGUL SYLLABLE
   sortTable[0xAD33]=33078;   // HANGUL SYLLABLE
   sortTable[0xAD34]=33079;   // HANGUL SYLLABLE
   sortTable[0xAD35]=33080;   // HANGUL SYLLABLE
   sortTable[0xAD36]=33081;   // HANGUL SYLLABLE
   sortTable[0xAD37]=33082;   // HANGUL SYLLABLE
   sortTable[0xAD38]=33083;   // HANGUL SYLLABLE
   sortTable[0xAD39]=33084;   // HANGUL SYLLABLE
   sortTable[0xAD3A]=33085;   // HANGUL SYLLABLE
   sortTable[0xAD3B]=33086;   // HANGUL SYLLABLE
   sortTable[0xAD3C]=33087;   // HANGUL SYLLABLE
   sortTable[0xAD3D]=33088;   // HANGUL SYLLABLE
   sortTable[0xAD3E]=33089;   // HANGUL SYLLABLE
   sortTable[0xAD3F]=33090;   // HANGUL SYLLABLE
   sortTable[0xAD40]=33091;   // HANGUL SYLLABLE
   sortTable[0xAD41]=33092;   // HANGUL SYLLABLE
   sortTable[0xAD42]=33093;   // HANGUL SYLLABLE
   sortTable[0xAD43]=33094;   // HANGUL SYLLABLE
   sortTable[0xAD44]=33095;   // HANGUL SYLLABLE
   sortTable[0xAD45]=33096;   // HANGUL SYLLABLE
   sortTable[0xAD46]=33097;   // HANGUL SYLLABLE
   sortTable[0xAD47]=33098;   // HANGUL SYLLABLE
   sortTable[0xAD48]=33099;   // HANGUL SYLLABLE
   sortTable[0xAD49]=33100;   // HANGUL SYLLABLE
   sortTable[0xAD4A]=33101;   // HANGUL SYLLABLE
   sortTable[0xAD4B]=33102;   // HANGUL SYLLABLE
   sortTable[0xAD4C]=33103;   // HANGUL SYLLABLE
   sortTable[0xAD4D]=33104;   // HANGUL SYLLABLE
   sortTable[0xAD4E]=33105;   // HANGUL SYLLABLE
   sortTable[0xAD4F]=33106;   // HANGUL SYLLABLE
   sortTable[0xAD50]=33107;   // HANGUL SYLLABLE
   sortTable[0xAD51]=33108;   // HANGUL SYLLABLE
   sortTable[0xAD52]=33109;   // HANGUL SYLLABLE
   sortTable[0xAD53]=33110;   // HANGUL SYLLABLE
   sortTable[0xAD54]=33111;   // HANGUL SYLLABLE
   sortTable[0xAD55]=33112;   // HANGUL SYLLABLE
   sortTable[0xAD56]=33113;   // HANGUL SYLLABLE
   sortTable[0xAD57]=33114;   // HANGUL SYLLABLE
   sortTable[0xAD58]=33115;   // HANGUL SYLLABLE
   sortTable[0xAD59]=33116;   // HANGUL SYLLABLE
   sortTable[0xAD5A]=33117;   // HANGUL SYLLABLE
   sortTable[0xAD5B]=33118;   // HANGUL SYLLABLE
   sortTable[0xAD5C]=33119;   // HANGUL SYLLABLE
   sortTable[0xAD5D]=33120;   // HANGUL SYLLABLE
   sortTable[0xAD5E]=33121;   // HANGUL SYLLABLE
   sortTable[0xAD5F]=33122;   // HANGUL SYLLABLE
   sortTable[0xAD60]=33123;   // HANGUL SYLLABLE
   sortTable[0xAD61]=33124;   // HANGUL SYLLABLE
   sortTable[0xAD62]=33125;   // HANGUL SYLLABLE
   sortTable[0xAD63]=33126;   // HANGUL SYLLABLE
   sortTable[0xAD64]=33127;   // HANGUL SYLLABLE
   sortTable[0xAD65]=33128;   // HANGUL SYLLABLE
   sortTable[0xAD66]=33129;   // HANGUL SYLLABLE
   sortTable[0xAD67]=33130;   // HANGUL SYLLABLE
   sortTable[0xAD68]=33131;   // HANGUL SYLLABLE
   sortTable[0xAD69]=33132;   // HANGUL SYLLABLE
   sortTable[0xAD6A]=33133;   // HANGUL SYLLABLE
   sortTable[0xAD6B]=33134;   // HANGUL SYLLABLE
   sortTable[0xAD6C]=33135;   // HANGUL SYLLABLE
   sortTable[0xAD6D]=33136;   // HANGUL SYLLABLE
   sortTable[0xAD6E]=33137;   // HANGUL SYLLABLE
   sortTable[0xAD6F]=33138;   // HANGUL SYLLABLE
   sortTable[0xAD70]=33139;   // HANGUL SYLLABLE
   sortTable[0xAD71]=33140;   // HANGUL SYLLABLE
   sortTable[0xAD72]=33141;   // HANGUL SYLLABLE
   sortTable[0xAD73]=33142;   // HANGUL SYLLABLE
   sortTable[0xAD74]=33143;   // HANGUL SYLLABLE
   sortTable[0xAD75]=33144;   // HANGUL SYLLABLE
   sortTable[0xAD76]=33145;   // HANGUL SYLLABLE
   sortTable[0xAD77]=33146;   // HANGUL SYLLABLE
   sortTable[0xAD78]=33147;   // HANGUL SYLLABLE
   sortTable[0xAD79]=33148;   // HANGUL SYLLABLE
   sortTable[0xAD7A]=33149;   // HANGUL SYLLABLE
   sortTable[0xAD7B]=33150;   // HANGUL SYLLABLE
   sortTable[0xAD7C]=33151;   // HANGUL SYLLABLE
   sortTable[0xAD7D]=33152;   // HANGUL SYLLABLE
   sortTable[0xAD7E]=33153;   // HANGUL SYLLABLE
   sortTable[0xAD7F]=33154;   // HANGUL SYLLABLE
   sortTable[0xAD80]=33155;   // HANGUL SYLLABLE
   sortTable[0xAD81]=33156;   // HANGUL SYLLABLE
   sortTable[0xAD82]=33157;   // HANGUL SYLLABLE
   sortTable[0xAD83]=33158;   // HANGUL SYLLABLE
   sortTable[0xAD84]=33159;   // HANGUL SYLLABLE
   sortTable[0xAD85]=33160;   // HANGUL SYLLABLE
   sortTable[0xAD86]=33161;   // HANGUL SYLLABLE
   sortTable[0xAD87]=33162;   // HANGUL SYLLABLE
   sortTable[0xAD88]=33163;   // HANGUL SYLLABLE
   sortTable[0xAD89]=33164;   // HANGUL SYLLABLE
   sortTable[0xAD8A]=33165;   // HANGUL SYLLABLE
   sortTable[0xAD8B]=33166;   // HANGUL SYLLABLE
   sortTable[0xAD8C]=33167;   // HANGUL SYLLABLE
   sortTable[0xAD8D]=33168;   // HANGUL SYLLABLE
   sortTable[0xAD8E]=33169;   // HANGUL SYLLABLE
   sortTable[0xAD8F]=33170;   // HANGUL SYLLABLE
   sortTable[0xAD90]=33171;   // HANGUL SYLLABLE
   sortTable[0xAD91]=33172;   // HANGUL SYLLABLE
   sortTable[0xAD92]=33173;   // HANGUL SYLLABLE
   sortTable[0xAD93]=33174;   // HANGUL SYLLABLE
   sortTable[0xAD94]=33175;   // HANGUL SYLLABLE
   sortTable[0xAD95]=33176;   // HANGUL SYLLABLE
   sortTable[0xAD96]=33177;   // HANGUL SYLLABLE
   sortTable[0xAD97]=33178;   // HANGUL SYLLABLE
   sortTable[0xAD98]=33179;   // HANGUL SYLLABLE
   sortTable[0xAD99]=33180;   // HANGUL SYLLABLE
   sortTable[0xAD9A]=33181;   // HANGUL SYLLABLE
   sortTable[0xAD9B]=33182;   // HANGUL SYLLABLE
   sortTable[0xAD9C]=33183;   // HANGUL SYLLABLE
   sortTable[0xAD9D]=33184;   // HANGUL SYLLABLE
   sortTable[0xAD9E]=33185;   // HANGUL SYLLABLE
   sortTable[0xAD9F]=33186;   // HANGUL SYLLABLE
   sortTable[0xADA0]=33187;   // HANGUL SYLLABLE
   sortTable[0xADA1]=33188;   // HANGUL SYLLABLE
   sortTable[0xADA2]=33189;   // HANGUL SYLLABLE
   sortTable[0xADA3]=33190;   // HANGUL SYLLABLE
   sortTable[0xADA4]=33191;   // HANGUL SYLLABLE
   sortTable[0xADA5]=33192;   // HANGUL SYLLABLE
   sortTable[0xADA6]=33193;   // HANGUL SYLLABLE
   sortTable[0xADA7]=33194;   // HANGUL SYLLABLE
   sortTable[0xADA8]=33195;   // HANGUL SYLLABLE
   sortTable[0xADA9]=33196;   // HANGUL SYLLABLE
   sortTable[0xADAA]=33197;   // HANGUL SYLLABLE
   sortTable[0xADAB]=33198;   // HANGUL SYLLABLE
   sortTable[0xADAC]=33199;   // HANGUL SYLLABLE
   sortTable[0xADAD]=33200;   // HANGUL SYLLABLE
   sortTable[0xADAE]=33201;   // HANGUL SYLLABLE
   sortTable[0xADAF]=33202;   // HANGUL SYLLABLE
   sortTable[0xADB0]=33203;   // HANGUL SYLLABLE
   sortTable[0xADB1]=33204;   // HANGUL SYLLABLE
   sortTable[0xADB2]=33205;   // HANGUL SYLLABLE
   sortTable[0xADB3]=33206;   // HANGUL SYLLABLE
   sortTable[0xADB4]=33207;   // HANGUL SYLLABLE
   sortTable[0xADB5]=33208;   // HANGUL SYLLABLE
   sortTable[0xADB6]=33209;   // HANGUL SYLLABLE
   sortTable[0xADB7]=33210;   // HANGUL SYLLABLE
   sortTable[0xADB8]=33211;   // HANGUL SYLLABLE
   sortTable[0xADB9]=33212;   // HANGUL SYLLABLE
   sortTable[0xADBA]=33213;   // HANGUL SYLLABLE
   sortTable[0xADBB]=33214;   // HANGUL SYLLABLE
   sortTable[0xADBC]=33215;   // HANGUL SYLLABLE
   sortTable[0xADBD]=33216;   // HANGUL SYLLABLE
   sortTable[0xADBE]=33217;   // HANGUL SYLLABLE
   sortTable[0xADBF]=33218;   // HANGUL SYLLABLE
   sortTable[0xADC0]=33219;   // HANGUL SYLLABLE
   sortTable[0xADC1]=33220;   // HANGUL SYLLABLE
   sortTable[0xADC2]=33221;   // HANGUL SYLLABLE
   sortTable[0xADC3]=33222;   // HANGUL SYLLABLE
   sortTable[0xADC4]=33223;   // HANGUL SYLLABLE
   sortTable[0xADC5]=33224;   // HANGUL SYLLABLE
   sortTable[0xADC6]=33225;   // HANGUL SYLLABLE
   sortTable[0xADC7]=33226;   // HANGUL SYLLABLE
   sortTable[0xADC8]=33227;   // HANGUL SYLLABLE
   sortTable[0xADC9]=33228;   // HANGUL SYLLABLE
   sortTable[0xADCA]=33229;   // HANGUL SYLLABLE
   sortTable[0xADCB]=33230;   // HANGUL SYLLABLE
   sortTable[0xADCC]=33231;   // HANGUL SYLLABLE
   sortTable[0xADCD]=33232;   // HANGUL SYLLABLE
   sortTable[0xADCE]=33233;   // HANGUL SYLLABLE
   sortTable[0xADCF]=33234;   // HANGUL SYLLABLE
   sortTable[0xADD0]=33235;   // HANGUL SYLLABLE
   sortTable[0xADD1]=33236;   // HANGUL SYLLABLE
   sortTable[0xADD2]=33237;   // HANGUL SYLLABLE
   sortTable[0xADD3]=33238;   // HANGUL SYLLABLE
   sortTable[0xADD4]=33239;   // HANGUL SYLLABLE
   sortTable[0xADD5]=33240;   // HANGUL SYLLABLE
   sortTable[0xADD6]=33241;   // HANGUL SYLLABLE
   sortTable[0xADD7]=33242;   // HANGUL SYLLABLE
   sortTable[0xADD8]=33243;   // HANGUL SYLLABLE
   sortTable[0xADD9]=33244;   // HANGUL SYLLABLE
   sortTable[0xADDA]=33245;   // HANGUL SYLLABLE
   sortTable[0xADDB]=33246;   // HANGUL SYLLABLE
   sortTable[0xADDC]=33247;   // HANGUL SYLLABLE
   sortTable[0xADDD]=33248;   // HANGUL SYLLABLE
   sortTable[0xADDE]=33249;   // HANGUL SYLLABLE
   sortTable[0xADDF]=33250;   // HANGUL SYLLABLE
   sortTable[0xADE0]=33251;   // HANGUL SYLLABLE
   sortTable[0xADE1]=33252;   // HANGUL SYLLABLE
   sortTable[0xADE2]=33253;   // HANGUL SYLLABLE
   sortTable[0xADE3]=33254;   // HANGUL SYLLABLE
   sortTable[0xADE4]=33255;   // HANGUL SYLLABLE
   sortTable[0xADE5]=33256;   // HANGUL SYLLABLE
   sortTable[0xADE6]=33257;   // HANGUL SYLLABLE
   sortTable[0xADE7]=33258;   // HANGUL SYLLABLE
   sortTable[0xADE8]=33259;   // HANGUL SYLLABLE
   sortTable[0xADE9]=33260;   // HANGUL SYLLABLE
   sortTable[0xADEA]=33261;   // HANGUL SYLLABLE
   sortTable[0xADEB]=33262;   // HANGUL SYLLABLE
   sortTable[0xADEC]=33263;   // HANGUL SYLLABLE
   sortTable[0xADED]=33264;   // HANGUL SYLLABLE
   sortTable[0xADEE]=33265;   // HANGUL SYLLABLE
   sortTable[0xADEF]=33266;   // HANGUL SYLLABLE
   sortTable[0xADF0]=33267;   // HANGUL SYLLABLE
   sortTable[0xADF1]=33268;   // HANGUL SYLLABLE
   sortTable[0xADF2]=33269;   // HANGUL SYLLABLE
   sortTable[0xADF3]=33270;   // HANGUL SYLLABLE
   sortTable[0xADF4]=33271;   // HANGUL SYLLABLE
   sortTable[0xADF5]=33272;   // HANGUL SYLLABLE
   sortTable[0xADF6]=33273;   // HANGUL SYLLABLE
   sortTable[0xADF7]=33274;   // HANGUL SYLLABLE
   sortTable[0xADF8]=33275;   // HANGUL SYLLABLE
   sortTable[0xADF9]=33276;   // HANGUL SYLLABLE
   sortTable[0xADFA]=33277;   // HANGUL SYLLABLE
   sortTable[0xADFB]=33278;   // HANGUL SYLLABLE
   sortTable[0xADFC]=33279;   // HANGUL SYLLABLE
   sortTable[0xADFD]=33280;   // HANGUL SYLLABLE
   sortTable[0xADFE]=33281;   // HANGUL SYLLABLE
   sortTable[0xADFF]=33282;   // HANGUL SYLLABLE
   sortTable[0xAE00]=33283;   // HANGUL SYLLABLE
   sortTable[0xAE01]=33284;   // HANGUL SYLLABLE
   sortTable[0xAE02]=33285;   // HANGUL SYLLABLE
   sortTable[0xAE03]=33286;   // HANGUL SYLLABLE
   sortTable[0xAE04]=33287;   // HANGUL SYLLABLE
   sortTable[0xAE05]=33288;   // HANGUL SYLLABLE
   sortTable[0xAE06]=33289;   // HANGUL SYLLABLE
   sortTable[0xAE07]=33290;   // HANGUL SYLLABLE
   sortTable[0xAE08]=33291;   // HANGUL SYLLABLE
   sortTable[0xAE09]=33292;   // HANGUL SYLLABLE
   sortTable[0xAE0A]=33293;   // HANGUL SYLLABLE
   sortTable[0xAE0B]=33294;   // HANGUL SYLLABLE
   sortTable[0xAE0C]=33295;   // HANGUL SYLLABLE
   sortTable[0xAE0D]=33296;   // HANGUL SYLLABLE
   sortTable[0xAE0E]=33297;   // HANGUL SYLLABLE
   sortTable[0xAE0F]=33298;   // HANGUL SYLLABLE
   sortTable[0xAE10]=33299;   // HANGUL SYLLABLE
   sortTable[0xAE11]=33300;   // HANGUL SYLLABLE
   sortTable[0xAE12]=33301;   // HANGUL SYLLABLE
   sortTable[0xAE13]=33302;   // HANGUL SYLLABLE
   sortTable[0xAE14]=33303;   // HANGUL SYLLABLE
   sortTable[0xAE15]=33304;   // HANGUL SYLLABLE
   sortTable[0xAE16]=33305;   // HANGUL SYLLABLE
   sortTable[0xAE17]=33306;   // HANGUL SYLLABLE
   sortTable[0xAE18]=33307;   // HANGUL SYLLABLE
   sortTable[0xAE19]=33308;   // HANGUL SYLLABLE
   sortTable[0xAE1A]=33309;   // HANGUL SYLLABLE
   sortTable[0xAE1B]=33310;   // HANGUL SYLLABLE
   sortTable[0xAE1C]=33311;   // HANGUL SYLLABLE
   sortTable[0xAE1D]=33312;   // HANGUL SYLLABLE
   sortTable[0xAE1E]=33313;   // HANGUL SYLLABLE
   sortTable[0xAE1F]=33314;   // HANGUL SYLLABLE
   sortTable[0xAE20]=33315;   // HANGUL SYLLABLE
   sortTable[0xAE21]=33316;   // HANGUL SYLLABLE
   sortTable[0xAE22]=33317;   // HANGUL SYLLABLE
   sortTable[0xAE23]=33318;   // HANGUL SYLLABLE
   sortTable[0xAE24]=33319;   // HANGUL SYLLABLE
   sortTable[0xAE25]=33320;   // HANGUL SYLLABLE
   sortTable[0xAE26]=33321;   // HANGUL SYLLABLE
   sortTable[0xAE27]=33322;   // HANGUL SYLLABLE
   sortTable[0xAE28]=33323;   // HANGUL SYLLABLE
   sortTable[0xAE29]=33324;   // HANGUL SYLLABLE
   sortTable[0xAE2A]=33325;   // HANGUL SYLLABLE
   sortTable[0xAE2B]=33326;   // HANGUL SYLLABLE
   sortTable[0xAE2C]=33327;   // HANGUL SYLLABLE
   sortTable[0xAE2D]=33328;   // HANGUL SYLLABLE
   sortTable[0xAE2E]=33329;   // HANGUL SYLLABLE
   sortTable[0xAE2F]=33330;   // HANGUL SYLLABLE
   sortTable[0xAE30]=33331;   // HANGUL SYLLABLE
   sortTable[0xAE31]=33332;   // HANGUL SYLLABLE
   sortTable[0xAE32]=33333;   // HANGUL SYLLABLE
   sortTable[0xAE33]=33334;   // HANGUL SYLLABLE
   sortTable[0xAE34]=33335;   // HANGUL SYLLABLE
   sortTable[0xAE35]=33336;   // HANGUL SYLLABLE
   sortTable[0xAE36]=33337;   // HANGUL SYLLABLE
   sortTable[0xAE37]=33338;   // HANGUL SYLLABLE
   sortTable[0xAE38]=33339;   // HANGUL SYLLABLE
   sortTable[0xAE39]=33340;   // HANGUL SYLLABLE
   sortTable[0xAE3A]=33341;   // HANGUL SYLLABLE
   sortTable[0xAE3B]=33342;   // HANGUL SYLLABLE
   sortTable[0xAE3C]=33343;   // HANGUL SYLLABLE
   sortTable[0xAE3D]=33344;   // HANGUL SYLLABLE
   sortTable[0xAE3E]=33345;   // HANGUL SYLLABLE
   sortTable[0xAE3F]=33346;   // HANGUL SYLLABLE
   sortTable[0xAE40]=33347;   // HANGUL SYLLABLE
   sortTable[0xAE41]=33348;   // HANGUL SYLLABLE
   sortTable[0xAE42]=33349;   // HANGUL SYLLABLE
   sortTable[0xAE43]=33350;   // HANGUL SYLLABLE
   sortTable[0xAE44]=33351;   // HANGUL SYLLABLE
   sortTable[0xAE45]=33352;   // HANGUL SYLLABLE
   sortTable[0xAE46]=33353;   // HANGUL SYLLABLE
   sortTable[0xAE47]=33354;   // HANGUL SYLLABLE
   sortTable[0xAE48]=33355;   // HANGUL SYLLABLE
   sortTable[0xAE49]=33356;   // HANGUL SYLLABLE
   sortTable[0xAE4A]=33357;   // HANGUL SYLLABLE
   sortTable[0xAE4B]=33358;   // HANGUL SYLLABLE
   sortTable[0x3132]=33359;   // HANGUL SYLLABLE
   sortTable[0x1101]=33360;   // HANGUL CHOSEONG SSANGKIYEOK
   sortTable[0x11A9]=33361;   // HANGUL JONGSEONG SSANGKIYEOK
   sortTable[0xAE4C]=33362;   // HANGUL SYLLABLE
   sortTable[0xAE4D]=33363;   // HANGUL SYLLABLE
   sortTable[0xAE4E]=33364;   // HANGUL SYLLABLE
   sortTable[0xAE4F]=33365;   // HANGUL SYLLABLE
   sortTable[0xAE50]=33366;   // HANGUL SYLLABLE
   sortTable[0xAE51]=33367;   // HANGUL SYLLABLE
   sortTable[0xAE52]=33368;   // HANGUL SYLLABLE
   sortTable[0xAE53]=33369;   // HANGUL SYLLABLE
   sortTable[0xAE54]=33370;   // HANGUL SYLLABLE
   sortTable[0xAE55]=33371;   // HANGUL SYLLABLE
   sortTable[0xAE56]=33372;   // HANGUL SYLLABLE
   sortTable[0xAE57]=33373;   // HANGUL SYLLABLE
   sortTable[0xAE58]=33374;   // HANGUL SYLLABLE
   sortTable[0xAE59]=33375;   // HANGUL SYLLABLE
   sortTable[0xAE5A]=33376;   // HANGUL SYLLABLE
   sortTable[0xAE5B]=33377;   // HANGUL SYLLABLE
   sortTable[0xAE5C]=33378;   // HANGUL SYLLABLE
   sortTable[0xAE5D]=33379;   // HANGUL SYLLABLE
   sortTable[0xAE5E]=33380;   // HANGUL SYLLABLE
   sortTable[0xAE5F]=33381;   // HANGUL SYLLABLE
   sortTable[0xAE60]=33382;   // HANGUL SYLLABLE
   sortTable[0xAE61]=33383;   // HANGUL SYLLABLE
   sortTable[0xAE62]=33384;   // HANGUL SYLLABLE
   sortTable[0xAE63]=33385;   // HANGUL SYLLABLE
   sortTable[0xAE64]=33386;   // HANGUL SYLLABLE
   sortTable[0xAE65]=33387;   // HANGUL SYLLABLE
   sortTable[0xAE66]=33388;   // HANGUL SYLLABLE
   sortTable[0xAE67]=33389;   // HANGUL SYLLABLE
   sortTable[0xAE68]=33390;   // HANGUL SYLLABLE
   sortTable[0xAE69]=33391;   // HANGUL SYLLABLE
   sortTable[0xAE6A]=33392;   // HANGUL SYLLABLE
   sortTable[0xAE6B]=33393;   // HANGUL SYLLABLE
   sortTable[0xAE6C]=33394;   // HANGUL SYLLABLE
   sortTable[0xAE6D]=33395;   // HANGUL SYLLABLE
   sortTable[0xAE6E]=33396;   // HANGUL SYLLABLE
   sortTable[0xAE6F]=33397;   // HANGUL SYLLABLE
   sortTable[0xAE70]=33398;   // HANGUL SYLLABLE
   sortTable[0xAE71]=33399;   // HANGUL SYLLABLE
   sortTable[0xAE72]=33400;   // HANGUL SYLLABLE
   sortTable[0xAE73]=33401;   // HANGUL SYLLABLE
   sortTable[0xAE74]=33402;   // HANGUL SYLLABLE
   sortTable[0xAE75]=33403;   // HANGUL SYLLABLE
   sortTable[0xAE76]=33404;   // HANGUL SYLLABLE
   sortTable[0xAE77]=33405;   // HANGUL SYLLABLE
   sortTable[0xAE78]=33406;   // HANGUL SYLLABLE
   sortTable[0xAE79]=33407;   // HANGUL SYLLABLE
   sortTable[0xAE7A]=33408;   // HANGUL SYLLABLE
   sortTable[0xAE7B]=33409;   // HANGUL SYLLABLE
   sortTable[0xAE7C]=33410;   // HANGUL SYLLABLE
   sortTable[0xAE7D]=33411;   // HANGUL SYLLABLE
   sortTable[0xAE7E]=33412;   // HANGUL SYLLABLE
   sortTable[0xAE7F]=33413;   // HANGUL SYLLABLE
   sortTable[0xAE80]=33414;   // HANGUL SYLLABLE
   sortTable[0xAE81]=33415;   // HANGUL SYLLABLE
   sortTable[0xAE82]=33416;   // HANGUL SYLLABLE
   sortTable[0xAE83]=33417;   // HANGUL SYLLABLE
   sortTable[0xAE84]=33418;   // HANGUL SYLLABLE
   sortTable[0xAE85]=33419;   // HANGUL SYLLABLE
   sortTable[0xAE86]=33420;   // HANGUL SYLLABLE
   sortTable[0xAE87]=33421;   // HANGUL SYLLABLE
   sortTable[0xAE88]=33422;   // HANGUL SYLLABLE
   sortTable[0xAE89]=33423;   // HANGUL SYLLABLE
   sortTable[0xAE8A]=33424;   // HANGUL SYLLABLE
   sortTable[0xAE8B]=33425;   // HANGUL SYLLABLE
   sortTable[0xAE8C]=33426;   // HANGUL SYLLABLE
   sortTable[0xAE8D]=33427;   // HANGUL SYLLABLE
   sortTable[0xAE8E]=33428;   // HANGUL SYLLABLE
   sortTable[0xAE8F]=33429;   // HANGUL SYLLABLE
   sortTable[0xAE90]=33430;   // HANGUL SYLLABLE
   sortTable[0xAE91]=33431;   // HANGUL SYLLABLE
   sortTable[0xAE92]=33432;   // HANGUL SYLLABLE
   sortTable[0xAE93]=33433;   // HANGUL SYLLABLE
   sortTable[0xAE94]=33434;   // HANGUL SYLLABLE
   sortTable[0xAE95]=33435;   // HANGUL SYLLABLE
   sortTable[0xAE96]=33436;   // HANGUL SYLLABLE
   sortTable[0xAE97]=33437;   // HANGUL SYLLABLE
   sortTable[0xAE98]=33438;   // HANGUL SYLLABLE
   sortTable[0xAE99]=33439;   // HANGUL SYLLABLE
   sortTable[0xAE9A]=33440;   // HANGUL SYLLABLE
   sortTable[0xAE9B]=33441;   // HANGUL SYLLABLE
   sortTable[0xAE9C]=33442;   // HANGUL SYLLABLE
   sortTable[0xAE9D]=33443;   // HANGUL SYLLABLE
   sortTable[0xAE9E]=33444;   // HANGUL SYLLABLE
   sortTable[0xAE9F]=33445;   // HANGUL SYLLABLE
   sortTable[0xAEA0]=33446;   // HANGUL SYLLABLE
   sortTable[0xAEA1]=33447;   // HANGUL SYLLABLE
   sortTable[0xAEA2]=33448;   // HANGUL SYLLABLE
   sortTable[0xAEA3]=33449;   // HANGUL SYLLABLE
   sortTable[0xAEA4]=33450;   // HANGUL SYLLABLE
   sortTable[0xAEA5]=33451;   // HANGUL SYLLABLE
   sortTable[0xAEA6]=33452;   // HANGUL SYLLABLE
   sortTable[0xAEA7]=33453;   // HANGUL SYLLABLE
   sortTable[0xAEA8]=33454;   // HANGUL SYLLABLE
   sortTable[0xAEA9]=33455;   // HANGUL SYLLABLE
   sortTable[0xAEAA]=33456;   // HANGUL SYLLABLE
   sortTable[0xAEAB]=33457;   // HANGUL SYLLABLE
   sortTable[0xAEAC]=33458;   // HANGUL SYLLABLE
   sortTable[0xAEAD]=33459;   // HANGUL SYLLABLE
   sortTable[0xAEAE]=33460;   // HANGUL SYLLABLE
   sortTable[0xAEAF]=33461;   // HANGUL SYLLABLE
   sortTable[0xAEB0]=33462;   // HANGUL SYLLABLE
   sortTable[0xAEB1]=33463;   // HANGUL SYLLABLE
   sortTable[0xAEB2]=33464;   // HANGUL SYLLABLE
   sortTable[0xAEB3]=33465;   // HANGUL SYLLABLE
   sortTable[0xAEB4]=33466;   // HANGUL SYLLABLE
   sortTable[0xAEB5]=33467;   // HANGUL SYLLABLE
   sortTable[0xAEB6]=33468;   // HANGUL SYLLABLE
   sortTable[0xAEB7]=33469;   // HANGUL SYLLABLE
   sortTable[0xAEB8]=33470;   // HANGUL SYLLABLE
   sortTable[0xAEB9]=33471;   // HANGUL SYLLABLE
   sortTable[0xAEBA]=33472;   // HANGUL SYLLABLE
   sortTable[0xAEBB]=33473;   // HANGUL SYLLABLE
   sortTable[0xAEBC]=33474;   // HANGUL SYLLABLE
   sortTable[0xAEBD]=33475;   // HANGUL SYLLABLE
   sortTable[0xAEBE]=33476;   // HANGUL SYLLABLE
   sortTable[0xAEBF]=33477;   // HANGUL SYLLABLE
   sortTable[0xAEC0]=33478;   // HANGUL SYLLABLE
   sortTable[0xAEC1]=33479;   // HANGUL SYLLABLE
   sortTable[0xAEC2]=33480;   // HANGUL SYLLABLE
   sortTable[0xAEC3]=33481;   // HANGUL SYLLABLE
   sortTable[0xAEC4]=33482;   // HANGUL SYLLABLE
   sortTable[0xAEC5]=33483;   // HANGUL SYLLABLE
   sortTable[0xAEC6]=33484;   // HANGUL SYLLABLE
   sortTable[0xAEC7]=33485;   // HANGUL SYLLABLE
   sortTable[0xAEC8]=33486;   // HANGUL SYLLABLE
   sortTable[0xAEC9]=33487;   // HANGUL SYLLABLE
   sortTable[0xAECA]=33488;   // HANGUL SYLLABLE
   sortTable[0xAECB]=33489;   // HANGUL SYLLABLE
   sortTable[0xAECC]=33490;   // HANGUL SYLLABLE
   sortTable[0xAECD]=33491;   // HANGUL SYLLABLE
   sortTable[0xAECE]=33492;   // HANGUL SYLLABLE
   sortTable[0xAECF]=33493;   // HANGUL SYLLABLE
   sortTable[0xAED0]=33494;   // HANGUL SYLLABLE
   sortTable[0xAED1]=33495;   // HANGUL SYLLABLE
   sortTable[0xAED2]=33496;   // HANGUL SYLLABLE
   sortTable[0xAED3]=33497;   // HANGUL SYLLABLE
   sortTable[0xAED4]=33498;   // HANGUL SYLLABLE
   sortTable[0xAED5]=33499;   // HANGUL SYLLABLE
   sortTable[0xAED6]=33500;   // HANGUL SYLLABLE
   sortTable[0xAED7]=33501;   // HANGUL SYLLABLE
   sortTable[0xAED8]=33502;   // HANGUL SYLLABLE
   sortTable[0xAED9]=33503;   // HANGUL SYLLABLE
   sortTable[0xAEDA]=33504;   // HANGUL SYLLABLE
   sortTable[0xAEDB]=33505;   // HANGUL SYLLABLE
   sortTable[0xAEDC]=33506;   // HANGUL SYLLABLE
   sortTable[0xAEDD]=33507;   // HANGUL SYLLABLE
   sortTable[0xAEDE]=33508;   // HANGUL SYLLABLE
   sortTable[0xAEDF]=33509;   // HANGUL SYLLABLE
   sortTable[0xAEE0]=33510;   // HANGUL SYLLABLE
   sortTable[0xAEE1]=33511;   // HANGUL SYLLABLE
   sortTable[0xAEE2]=33512;   // HANGUL SYLLABLE
   sortTable[0xAEE3]=33513;   // HANGUL SYLLABLE
   sortTable[0xAEE4]=33514;   // HANGUL SYLLABLE
   sortTable[0xAEE5]=33515;   // HANGUL SYLLABLE
   sortTable[0xAEE6]=33516;   // HANGUL SYLLABLE
   sortTable[0xAEE7]=33517;   // HANGUL SYLLABLE
   sortTable[0xAEE8]=33518;   // HANGUL SYLLABLE
   sortTable[0xAEE9]=33519;   // HANGUL SYLLABLE
   sortTable[0xAEEA]=33520;   // HANGUL SYLLABLE
   sortTable[0xAEEB]=33521;   // HANGUL SYLLABLE
   sortTable[0xAEEC]=33522;   // HANGUL SYLLABLE
   sortTable[0xAEED]=33523;   // HANGUL SYLLABLE
   sortTable[0xAEEE]=33524;   // HANGUL SYLLABLE
   sortTable[0xAEEF]=33525;   // HANGUL SYLLABLE
   sortTable[0xAEF0]=33526;   // HANGUL SYLLABLE
   sortTable[0xAEF1]=33527;   // HANGUL SYLLABLE
   sortTable[0xAEF2]=33528;   // HANGUL SYLLABLE
   sortTable[0xAEF3]=33529;   // HANGUL SYLLABLE
   sortTable[0xAEF4]=33530;   // HANGUL SYLLABLE
   sortTable[0xAEF5]=33531;   // HANGUL SYLLABLE
   sortTable[0xAEF6]=33532;   // HANGUL SYLLABLE
   sortTable[0xAEF7]=33533;   // HANGUL SYLLABLE
   sortTable[0xAEF8]=33534;   // HANGUL SYLLABLE
   sortTable[0xAEF9]=33535;   // HANGUL SYLLABLE
   sortTable[0xAEFA]=33536;   // HANGUL SYLLABLE
   sortTable[0xAEFB]=33537;   // HANGUL SYLLABLE
   sortTable[0xAEFC]=33538;   // HANGUL SYLLABLE
   sortTable[0xAEFD]=33539;   // HANGUL SYLLABLE
   sortTable[0xAEFE]=33540;   // HANGUL SYLLABLE
   sortTable[0xAEFF]=33541;   // HANGUL SYLLABLE
   sortTable[0xAF00]=33542;   // HANGUL SYLLABLE
   sortTable[0xAF01]=33543;   // HANGUL SYLLABLE
   sortTable[0xAF02]=33544;   // HANGUL SYLLABLE
   sortTable[0xAF03]=33545;   // HANGUL SYLLABLE
   sortTable[0xAF04]=33546;   // HANGUL SYLLABLE
   sortTable[0xAF05]=33547;   // HANGUL SYLLABLE
   sortTable[0xAF06]=33548;   // HANGUL SYLLABLE
   sortTable[0xAF07]=33549;   // HANGUL SYLLABLE
   sortTable[0xAF08]=33550;   // HANGUL SYLLABLE
   sortTable[0xAF09]=33551;   // HANGUL SYLLABLE
   sortTable[0xAF0A]=33552;   // HANGUL SYLLABLE
   sortTable[0xAF0B]=33553;   // HANGUL SYLLABLE
   sortTable[0xAF0C]=33554;   // HANGUL SYLLABLE
   sortTable[0xAF0D]=33555;   // HANGUL SYLLABLE
   sortTable[0xAF0E]=33556;   // HANGUL SYLLABLE
   sortTable[0xAF0F]=33557;   // HANGUL SYLLABLE
   sortTable[0xAF10]=33558;   // HANGUL SYLLABLE
   sortTable[0xAF11]=33559;   // HANGUL SYLLABLE
   sortTable[0xAF12]=33560;   // HANGUL SYLLABLE
   sortTable[0xAF13]=33561;   // HANGUL SYLLABLE
   sortTable[0xAF14]=33562;   // HANGUL SYLLABLE
   sortTable[0xAF15]=33563;   // HANGUL SYLLABLE
   sortTable[0xAF16]=33564;   // HANGUL SYLLABLE
   sortTable[0xAF17]=33565;   // HANGUL SYLLABLE
   sortTable[0xAF18]=33566;   // HANGUL SYLLABLE
   sortTable[0xAF19]=33567;   // HANGUL SYLLABLE
   sortTable[0xAF1A]=33568;   // HANGUL SYLLABLE
   sortTable[0xAF1B]=33569;   // HANGUL SYLLABLE
   sortTable[0xAF1C]=33570;   // HANGUL SYLLABLE
   sortTable[0xAF1D]=33571;   // HANGUL SYLLABLE
   sortTable[0xAF1E]=33572;   // HANGUL SYLLABLE
   sortTable[0xAF1F]=33573;   // HANGUL SYLLABLE
   sortTable[0xAF20]=33574;   // HANGUL SYLLABLE
   sortTable[0xAF21]=33575;   // HANGUL SYLLABLE
   sortTable[0xAF22]=33576;   // HANGUL SYLLABLE
   sortTable[0xAF23]=33577;   // HANGUL SYLLABLE
   sortTable[0xAF24]=33578;   // HANGUL SYLLABLE
   sortTable[0xAF25]=33579;   // HANGUL SYLLABLE
   sortTable[0xAF26]=33580;   // HANGUL SYLLABLE
   sortTable[0xAF27]=33581;   // HANGUL SYLLABLE
   sortTable[0xAF28]=33582;   // HANGUL SYLLABLE
   sortTable[0xAF29]=33583;   // HANGUL SYLLABLE
   sortTable[0xAF2A]=33584;   // HANGUL SYLLABLE
   sortTable[0xAF2B]=33585;   // HANGUL SYLLABLE
   sortTable[0xAF2C]=33586;   // HANGUL SYLLABLE
   sortTable[0xAF2D]=33587;   // HANGUL SYLLABLE
   sortTable[0xAF2E]=33588;   // HANGUL SYLLABLE
   sortTable[0xAF2F]=33589;   // HANGUL SYLLABLE
   sortTable[0xAF30]=33590;   // HANGUL SYLLABLE
   sortTable[0xAF31]=33591;   // HANGUL SYLLABLE
   sortTable[0xAF32]=33592;   // HANGUL SYLLABLE
   sortTable[0xAF33]=33593;   // HANGUL SYLLABLE
   sortTable[0xAF34]=33594;   // HANGUL SYLLABLE
   sortTable[0xAF35]=33595;   // HANGUL SYLLABLE
   sortTable[0xAF36]=33596;   // HANGUL SYLLABLE
   sortTable[0xAF37]=33597;   // HANGUL SYLLABLE
   sortTable[0xAF38]=33598;   // HANGUL SYLLABLE
   sortTable[0xAF39]=33599;   // HANGUL SYLLABLE
   sortTable[0xAF3A]=33600;   // HANGUL SYLLABLE
   sortTable[0xAF3B]=33601;   // HANGUL SYLLABLE
   sortTable[0xAF3C]=33602;   // HANGUL SYLLABLE
   sortTable[0xAF3D]=33603;   // HANGUL SYLLABLE
   sortTable[0xAF3E]=33604;   // HANGUL SYLLABLE
   sortTable[0xAF3F]=33605;   // HANGUL SYLLABLE
   sortTable[0xAF40]=33606;   // HANGUL SYLLABLE
   sortTable[0xAF41]=33607;   // HANGUL SYLLABLE
   sortTable[0xAF42]=33608;   // HANGUL SYLLABLE
   sortTable[0xAF43]=33609;   // HANGUL SYLLABLE
   sortTable[0xAF44]=33610;   // HANGUL SYLLABLE
   sortTable[0xAF45]=33611;   // HANGUL SYLLABLE
   sortTable[0xAF46]=33612;   // HANGUL SYLLABLE
   sortTable[0xAF47]=33613;   // HANGUL SYLLABLE
   sortTable[0xAF48]=33614;   // HANGUL SYLLABLE
   sortTable[0xAF49]=33615;   // HANGUL SYLLABLE
   sortTable[0xAF4A]=33616;   // HANGUL SYLLABLE
   sortTable[0xAF4B]=33617;   // HANGUL SYLLABLE
   sortTable[0xAF4C]=33618;   // HANGUL SYLLABLE
   sortTable[0xAF4D]=33619;   // HANGUL SYLLABLE
   sortTable[0xAF4E]=33620;   // HANGUL SYLLABLE
   sortTable[0xAF4F]=33621;   // HANGUL SYLLABLE
   sortTable[0xAF50]=33622;   // HANGUL SYLLABLE
   sortTable[0xAF51]=33623;   // HANGUL SYLLABLE
   sortTable[0xAF52]=33624;   // HANGUL SYLLABLE
   sortTable[0xAF53]=33625;   // HANGUL SYLLABLE
   sortTable[0xAF54]=33626;   // HANGUL SYLLABLE
   sortTable[0xAF55]=33627;   // HANGUL SYLLABLE
   sortTable[0xAF56]=33628;   // HANGUL SYLLABLE
   sortTable[0xAF57]=33629;   // HANGUL SYLLABLE
   sortTable[0xAF58]=33630;   // HANGUL SYLLABLE
   sortTable[0xAF59]=33631;   // HANGUL SYLLABLE
   sortTable[0xAF5A]=33632;   // HANGUL SYLLABLE
   sortTable[0xAF5B]=33633;   // HANGUL SYLLABLE
   sortTable[0xAF5C]=33634;   // HANGUL SYLLABLE
   sortTable[0xAF5D]=33635;   // HANGUL SYLLABLE
   sortTable[0xAF5E]=33636;   // HANGUL SYLLABLE
   sortTable[0xAF5F]=33637;   // HANGUL SYLLABLE
   sortTable[0xAF60]=33638;   // HANGUL SYLLABLE
   sortTable[0xAF61]=33639;   // HANGUL SYLLABLE
   sortTable[0xAF62]=33640;   // HANGUL SYLLABLE
   sortTable[0xAF63]=33641;   // HANGUL SYLLABLE
   sortTable[0xAF64]=33642;   // HANGUL SYLLABLE
   sortTable[0xAF65]=33643;   // HANGUL SYLLABLE
   sortTable[0xAF66]=33644;   // HANGUL SYLLABLE
   sortTable[0xAF67]=33645;   // HANGUL SYLLABLE
   sortTable[0xAF68]=33646;   // HANGUL SYLLABLE
   sortTable[0xAF69]=33647;   // HANGUL SYLLABLE
   sortTable[0xAF6A]=33648;   // HANGUL SYLLABLE
   sortTable[0xAF6B]=33649;   // HANGUL SYLLABLE
   sortTable[0xAF6C]=33650;   // HANGUL SYLLABLE
   sortTable[0xAF6D]=33651;   // HANGUL SYLLABLE
   sortTable[0xAF6E]=33652;   // HANGUL SYLLABLE
   sortTable[0xAF6F]=33653;   // HANGUL SYLLABLE
   sortTable[0xAF70]=33654;   // HANGUL SYLLABLE
   sortTable[0xAF71]=33655;   // HANGUL SYLLABLE
   sortTable[0xAF72]=33656;   // HANGUL SYLLABLE
   sortTable[0xAF73]=33657;   // HANGUL SYLLABLE
   sortTable[0xAF74]=33658;   // HANGUL SYLLABLE
   sortTable[0xAF75]=33659;   // HANGUL SYLLABLE
   sortTable[0xAF76]=33660;   // HANGUL SYLLABLE
   sortTable[0xAF77]=33661;   // HANGUL SYLLABLE
   sortTable[0xAF78]=33662;   // HANGUL SYLLABLE
   sortTable[0xAF79]=33663;   // HANGUL SYLLABLE
   sortTable[0xAF7A]=33664;   // HANGUL SYLLABLE
   sortTable[0xAF7B]=33665;   // HANGUL SYLLABLE
   sortTable[0xAF7C]=33666;   // HANGUL SYLLABLE
   sortTable[0xAF7D]=33667;   // HANGUL SYLLABLE
   sortTable[0xAF7E]=33668;   // HANGUL SYLLABLE
   sortTable[0xAF7F]=33669;   // HANGUL SYLLABLE
   sortTable[0xAF80]=33670;   // HANGUL SYLLABLE
   sortTable[0xAF81]=33671;   // HANGUL SYLLABLE
   sortTable[0xAF82]=33672;   // HANGUL SYLLABLE
   sortTable[0xAF83]=33673;   // HANGUL SYLLABLE
   sortTable[0xAF84]=33674;   // HANGUL SYLLABLE
   sortTable[0xAF85]=33675;   // HANGUL SYLLABLE
   sortTable[0xAF86]=33676;   // HANGUL SYLLABLE
   sortTable[0xAF87]=33677;   // HANGUL SYLLABLE
   sortTable[0xAF88]=33678;   // HANGUL SYLLABLE
   sortTable[0xAF89]=33679;   // HANGUL SYLLABLE
   sortTable[0xAF8A]=33680;   // HANGUL SYLLABLE
   sortTable[0xAF8B]=33681;   // HANGUL SYLLABLE
   sortTable[0xAF8C]=33682;   // HANGUL SYLLABLE
   sortTable[0xAF8D]=33683;   // HANGUL SYLLABLE
   sortTable[0xAF8E]=33684;   // HANGUL SYLLABLE
   sortTable[0xAF8F]=33685;   // HANGUL SYLLABLE
   sortTable[0xAF90]=33686;   // HANGUL SYLLABLE
   sortTable[0xAF91]=33687;   // HANGUL SYLLABLE
   sortTable[0xAF92]=33688;   // HANGUL SYLLABLE
   sortTable[0xAF93]=33689;   // HANGUL SYLLABLE
   sortTable[0xAF94]=33690;   // HANGUL SYLLABLE
   sortTable[0xAF95]=33691;   // HANGUL SYLLABLE
   sortTable[0xAF96]=33692;   // HANGUL SYLLABLE
   sortTable[0xAF97]=33693;   // HANGUL SYLLABLE
   sortTable[0xAF98]=33694;   // HANGUL SYLLABLE
   sortTable[0xAF99]=33695;   // HANGUL SYLLABLE
   sortTable[0xAF9A]=33696;   // HANGUL SYLLABLE
   sortTable[0xAF9B]=33697;   // HANGUL SYLLABLE
   sortTable[0xAF9C]=33698;   // HANGUL SYLLABLE
   sortTable[0xAF9D]=33699;   // HANGUL SYLLABLE
   sortTable[0xAF9E]=33700;   // HANGUL SYLLABLE
   sortTable[0xAF9F]=33701;   // HANGUL SYLLABLE
   sortTable[0xAFA0]=33702;   // HANGUL SYLLABLE
   sortTable[0xAFA1]=33703;   // HANGUL SYLLABLE
   sortTable[0xAFA2]=33704;   // HANGUL SYLLABLE
   sortTable[0xAFA3]=33705;   // HANGUL SYLLABLE
   sortTable[0xAFA4]=33706;   // HANGUL SYLLABLE
   sortTable[0xAFA5]=33707;   // HANGUL SYLLABLE
   sortTable[0xAFA6]=33708;   // HANGUL SYLLABLE
   sortTable[0xAFA7]=33709;   // HANGUL SYLLABLE
   sortTable[0xAFA8]=33710;   // HANGUL SYLLABLE
   sortTable[0xAFA9]=33711;   // HANGUL SYLLABLE
   sortTable[0xAFAA]=33712;   // HANGUL SYLLABLE
   sortTable[0xAFAB]=33713;   // HANGUL SYLLABLE
   sortTable[0xAFAC]=33714;   // HANGUL SYLLABLE
   sortTable[0xAFAD]=33715;   // HANGUL SYLLABLE
   sortTable[0xAFAE]=33716;   // HANGUL SYLLABLE
   sortTable[0xAFAF]=33717;   // HANGUL SYLLABLE
   sortTable[0xAFB0]=33718;   // HANGUL SYLLABLE
   sortTable[0xAFB1]=33719;   // HANGUL SYLLABLE
   sortTable[0xAFB2]=33720;   // HANGUL SYLLABLE
   sortTable[0xAFB3]=33721;   // HANGUL SYLLABLE
   sortTable[0xAFB4]=33722;   // HANGUL SYLLABLE
   sortTable[0xAFB5]=33723;   // HANGUL SYLLABLE
   sortTable[0xAFB6]=33724;   // HANGUL SYLLABLE
   sortTable[0xAFB7]=33725;   // HANGUL SYLLABLE
   sortTable[0xAFB8]=33726;   // HANGUL SYLLABLE
   sortTable[0xAFB9]=33727;   // HANGUL SYLLABLE
   sortTable[0xAFBA]=33728;   // HANGUL SYLLABLE
   sortTable[0xAFBB]=33729;   // HANGUL SYLLABLE
   sortTable[0xAFBC]=33730;   // HANGUL SYLLABLE
   sortTable[0xAFBD]=33731;   // HANGUL SYLLABLE
   sortTable[0xAFBE]=33732;   // HANGUL SYLLABLE
   sortTable[0xAFBF]=33733;   // HANGUL SYLLABLE
   sortTable[0xAFC0]=33734;   // HANGUL SYLLABLE
   sortTable[0xAFC1]=33735;   // HANGUL SYLLABLE
   sortTable[0xAFC2]=33736;   // HANGUL SYLLABLE
   sortTable[0xAFC3]=33737;   // HANGUL SYLLABLE
   sortTable[0xAFC4]=33738;   // HANGUL SYLLABLE
   sortTable[0xAFC5]=33739;   // HANGUL SYLLABLE
   sortTable[0xAFC6]=33740;   // HANGUL SYLLABLE
   sortTable[0xAFC7]=33741;   // HANGUL SYLLABLE
   sortTable[0xAFC8]=33742;   // HANGUL SYLLABLE
   sortTable[0xAFC9]=33743;   // HANGUL SYLLABLE
   sortTable[0xAFCA]=33744;   // HANGUL SYLLABLE
   sortTable[0xAFCB]=33745;   // HANGUL SYLLABLE
   sortTable[0xAFCC]=33746;   // HANGUL SYLLABLE
   sortTable[0xAFCD]=33747;   // HANGUL SYLLABLE
   sortTable[0xAFCE]=33748;   // HANGUL SYLLABLE
   sortTable[0xAFCF]=33749;   // HANGUL SYLLABLE
   sortTable[0xAFD0]=33750;   // HANGUL SYLLABLE
   sortTable[0xAFD1]=33751;   // HANGUL SYLLABLE
   sortTable[0xAFD2]=33752;   // HANGUL SYLLABLE
   sortTable[0xAFD3]=33753;   // HANGUL SYLLABLE
   sortTable[0xAFD4]=33754;   // HANGUL SYLLABLE
   sortTable[0xAFD5]=33755;   // HANGUL SYLLABLE
   sortTable[0xAFD6]=33756;   // HANGUL SYLLABLE
   sortTable[0xAFD7]=33757;   // HANGUL SYLLABLE
   sortTable[0xAFD8]=33758;   // HANGUL SYLLABLE
   sortTable[0xAFD9]=33759;   // HANGUL SYLLABLE
   sortTable[0xAFDA]=33760;   // HANGUL SYLLABLE
   sortTable[0xAFDB]=33761;   // HANGUL SYLLABLE
   sortTable[0xAFDC]=33762;   // HANGUL SYLLABLE
   sortTable[0xAFDD]=33763;   // HANGUL SYLLABLE
   sortTable[0xAFDE]=33764;   // HANGUL SYLLABLE
   sortTable[0xAFDF]=33765;   // HANGUL SYLLABLE
   sortTable[0xAFE0]=33766;   // HANGUL SYLLABLE
   sortTable[0xAFE1]=33767;   // HANGUL SYLLABLE
   sortTable[0xAFE2]=33768;   // HANGUL SYLLABLE
   sortTable[0xAFE3]=33769;   // HANGUL SYLLABLE
   sortTable[0xAFE4]=33770;   // HANGUL SYLLABLE
   sortTable[0xAFE5]=33771;   // HANGUL SYLLABLE
   sortTable[0xAFE6]=33772;   // HANGUL SYLLABLE
   sortTable[0xAFE7]=33773;   // HANGUL SYLLABLE
   sortTable[0xAFE8]=33774;   // HANGUL SYLLABLE
   sortTable[0xAFE9]=33775;   // HANGUL SYLLABLE
   sortTable[0xAFEA]=33776;   // HANGUL SYLLABLE
   sortTable[0xAFEB]=33777;   // HANGUL SYLLABLE
   sortTable[0xAFEC]=33778;   // HANGUL SYLLABLE
   sortTable[0xAFED]=33779;   // HANGUL SYLLABLE
   sortTable[0xAFEE]=33780;   // HANGUL SYLLABLE
   sortTable[0xAFEF]=33781;   // HANGUL SYLLABLE
   sortTable[0xAFF0]=33782;   // HANGUL SYLLABLE
   sortTable[0xAFF1]=33783;   // HANGUL SYLLABLE
   sortTable[0xAFF2]=33784;   // HANGUL SYLLABLE
   sortTable[0xAFF3]=33785;   // HANGUL SYLLABLE
   sortTable[0xAFF4]=33786;   // HANGUL SYLLABLE
   sortTable[0xAFF5]=33787;   // HANGUL SYLLABLE
   sortTable[0xAFF6]=33788;   // HANGUL SYLLABLE
   sortTable[0xAFF7]=33789;   // HANGUL SYLLABLE
   sortTable[0xAFF8]=33790;   // HANGUL SYLLABLE
   sortTable[0xAFF9]=33791;   // HANGUL SYLLABLE
   sortTable[0xAFFA]=33792;   // HANGUL SYLLABLE
   sortTable[0xAFFB]=33793;   // HANGUL SYLLABLE
   sortTable[0xAFFC]=33794;   // HANGUL SYLLABLE
   sortTable[0xAFFD]=33795;   // HANGUL SYLLABLE
   sortTable[0xAFFE]=33796;   // HANGUL SYLLABLE
   sortTable[0xAFFF]=33797;   // HANGUL SYLLABLE
   sortTable[0xB000]=33798;   // HANGUL SYLLABLE
   sortTable[0xB001]=33799;   // HANGUL SYLLABLE
   sortTable[0xB002]=33800;   // HANGUL SYLLABLE
   sortTable[0xB003]=33801;   // HANGUL SYLLABLE
   sortTable[0xB004]=33802;   // HANGUL SYLLABLE
   sortTable[0xB005]=33803;   // HANGUL SYLLABLE
   sortTable[0xB006]=33804;   // HANGUL SYLLABLE
   sortTable[0xB007]=33805;   // HANGUL SYLLABLE
   sortTable[0xB008]=33806;   // HANGUL SYLLABLE
   sortTable[0xB009]=33807;   // HANGUL SYLLABLE
   sortTable[0xB00A]=33808;   // HANGUL SYLLABLE
   sortTable[0xB00B]=33809;   // HANGUL SYLLABLE
   sortTable[0xB00C]=33810;   // HANGUL SYLLABLE
   sortTable[0xB00D]=33811;   // HANGUL SYLLABLE
   sortTable[0xB00E]=33812;   // HANGUL SYLLABLE
   sortTable[0xB00F]=33813;   // HANGUL SYLLABLE
   sortTable[0xB010]=33814;   // HANGUL SYLLABLE
   sortTable[0xB011]=33815;   // HANGUL SYLLABLE
   sortTable[0xB012]=33816;   // HANGUL SYLLABLE
   sortTable[0xB013]=33817;   // HANGUL SYLLABLE
   sortTable[0xB014]=33818;   // HANGUL SYLLABLE
   sortTable[0xB015]=33819;   // HANGUL SYLLABLE
   sortTable[0xB016]=33820;   // HANGUL SYLLABLE
   sortTable[0xB017]=33821;   // HANGUL SYLLABLE
   sortTable[0xB018]=33822;   // HANGUL SYLLABLE
   sortTable[0xB019]=33823;   // HANGUL SYLLABLE
   sortTable[0xB01A]=33824;   // HANGUL SYLLABLE
   sortTable[0xB01B]=33825;   // HANGUL SYLLABLE
   sortTable[0xB01C]=33826;   // HANGUL SYLLABLE
   sortTable[0xB01D]=33827;   // HANGUL SYLLABLE
   sortTable[0xB01E]=33828;   // HANGUL SYLLABLE
   sortTable[0xB01F]=33829;   // HANGUL SYLLABLE
   sortTable[0xB020]=33830;   // HANGUL SYLLABLE
   sortTable[0xB021]=33831;   // HANGUL SYLLABLE
   sortTable[0xB022]=33832;   // HANGUL SYLLABLE
   sortTable[0xB023]=33833;   // HANGUL SYLLABLE
   sortTable[0xB024]=33834;   // HANGUL SYLLABLE
   sortTable[0xB025]=33835;   // HANGUL SYLLABLE
   sortTable[0xB026]=33836;   // HANGUL SYLLABLE
   sortTable[0xB027]=33837;   // HANGUL SYLLABLE
   sortTable[0xB028]=33838;   // HANGUL SYLLABLE
   sortTable[0xB029]=33839;   // HANGUL SYLLABLE
   sortTable[0xB02A]=33840;   // HANGUL SYLLABLE
   sortTable[0xB02B]=33841;   // HANGUL SYLLABLE
   sortTable[0xB02C]=33842;   // HANGUL SYLLABLE
   sortTable[0xB02D]=33843;   // HANGUL SYLLABLE
   sortTable[0xB02E]=33844;   // HANGUL SYLLABLE
   sortTable[0xB02F]=33845;   // HANGUL SYLLABLE
   sortTable[0xB030]=33846;   // HANGUL SYLLABLE
   sortTable[0xB031]=33847;   // HANGUL SYLLABLE
   sortTable[0xB032]=33848;   // HANGUL SYLLABLE
   sortTable[0xB033]=33849;   // HANGUL SYLLABLE
   sortTable[0xB034]=33850;   // HANGUL SYLLABLE
   sortTable[0xB035]=33851;   // HANGUL SYLLABLE
   sortTable[0xB036]=33852;   // HANGUL SYLLABLE
   sortTable[0xB037]=33853;   // HANGUL SYLLABLE
   sortTable[0xB038]=33854;   // HANGUL SYLLABLE
   sortTable[0xB039]=33855;   // HANGUL SYLLABLE
   sortTable[0xB03A]=33856;   // HANGUL SYLLABLE
   sortTable[0xB03B]=33857;   // HANGUL SYLLABLE
   sortTable[0xB03C]=33858;   // HANGUL SYLLABLE
   sortTable[0xB03D]=33859;   // HANGUL SYLLABLE
   sortTable[0xB03E]=33860;   // HANGUL SYLLABLE
   sortTable[0xB03F]=33861;   // HANGUL SYLLABLE
   sortTable[0xB040]=33862;   // HANGUL SYLLABLE
   sortTable[0xB041]=33863;   // HANGUL SYLLABLE
   sortTable[0xB042]=33864;   // HANGUL SYLLABLE
   sortTable[0xB043]=33865;   // HANGUL SYLLABLE
   sortTable[0xB044]=33866;   // HANGUL SYLLABLE
   sortTable[0xB045]=33867;   // HANGUL SYLLABLE
   sortTable[0xB046]=33868;   // HANGUL SYLLABLE
   sortTable[0xB047]=33869;   // HANGUL SYLLABLE
   sortTable[0xB048]=33870;   // HANGUL SYLLABLE
   sortTable[0xB049]=33871;   // HANGUL SYLLABLE
   sortTable[0xB04A]=33872;   // HANGUL SYLLABLE
   sortTable[0xB04B]=33873;   // HANGUL SYLLABLE
   sortTable[0xB04C]=33874;   // HANGUL SYLLABLE
   sortTable[0xB04D]=33875;   // HANGUL SYLLABLE
   sortTable[0xB04E]=33876;   // HANGUL SYLLABLE
   sortTable[0xB04F]=33877;   // HANGUL SYLLABLE
   sortTable[0xB050]=33878;   // HANGUL SYLLABLE
   sortTable[0xB051]=33879;   // HANGUL SYLLABLE
   sortTable[0xB052]=33880;   // HANGUL SYLLABLE
   sortTable[0xB053]=33881;   // HANGUL SYLLABLE
   sortTable[0xB054]=33882;   // HANGUL SYLLABLE
   sortTable[0xB055]=33883;   // HANGUL SYLLABLE
   sortTable[0xB056]=33884;   // HANGUL SYLLABLE
   sortTable[0xB057]=33885;   // HANGUL SYLLABLE
   sortTable[0xB058]=33886;   // HANGUL SYLLABLE
   sortTable[0xB059]=33887;   // HANGUL SYLLABLE
   sortTable[0xB05A]=33888;   // HANGUL SYLLABLE
   sortTable[0xB05B]=33889;   // HANGUL SYLLABLE
   sortTable[0xB05C]=33890;   // HANGUL SYLLABLE
   sortTable[0xB05D]=33891;   // HANGUL SYLLABLE
   sortTable[0xB05E]=33892;   // HANGUL SYLLABLE
   sortTable[0xB05F]=33893;   // HANGUL SYLLABLE
   sortTable[0xB060]=33894;   // HANGUL SYLLABLE
   sortTable[0xB061]=33895;   // HANGUL SYLLABLE
   sortTable[0xB062]=33896;   // HANGUL SYLLABLE
   sortTable[0xB063]=33897;   // HANGUL SYLLABLE
   sortTable[0xB064]=33898;   // HANGUL SYLLABLE
   sortTable[0xB065]=33899;   // HANGUL SYLLABLE
   sortTable[0xB066]=33900;   // HANGUL SYLLABLE
   sortTable[0xB067]=33901;   // HANGUL SYLLABLE
   sortTable[0xB068]=33902;   // HANGUL SYLLABLE
   sortTable[0xB069]=33903;   // HANGUL SYLLABLE
   sortTable[0xB06A]=33904;   // HANGUL SYLLABLE
   sortTable[0xB06B]=33905;   // HANGUL SYLLABLE
   sortTable[0xB06C]=33906;   // HANGUL SYLLABLE
   sortTable[0xB06D]=33907;   // HANGUL SYLLABLE
   sortTable[0xB06E]=33908;   // HANGUL SYLLABLE
   sortTable[0xB06F]=33909;   // HANGUL SYLLABLE
   sortTable[0xB070]=33910;   // HANGUL SYLLABLE
   sortTable[0xB071]=33911;   // HANGUL SYLLABLE
   sortTable[0xB072]=33912;   // HANGUL SYLLABLE
   sortTable[0xB073]=33913;   // HANGUL SYLLABLE
   sortTable[0xB074]=33914;   // HANGUL SYLLABLE
   sortTable[0xB075]=33915;   // HANGUL SYLLABLE
   sortTable[0xB076]=33916;   // HANGUL SYLLABLE
   sortTable[0xB077]=33917;   // HANGUL SYLLABLE
   sortTable[0xB078]=33918;   // HANGUL SYLLABLE
   sortTable[0xB079]=33919;   // HANGUL SYLLABLE
   sortTable[0xB07A]=33920;   // HANGUL SYLLABLE
   sortTable[0xB07B]=33921;   // HANGUL SYLLABLE
   sortTable[0xB07C]=33922;   // HANGUL SYLLABLE
   sortTable[0xB07D]=33923;   // HANGUL SYLLABLE
   sortTable[0xB07E]=33924;   // HANGUL SYLLABLE
   sortTable[0xB07F]=33925;   // HANGUL SYLLABLE
   sortTable[0xB080]=33926;   // HANGUL SYLLABLE
   sortTable[0xB081]=33927;   // HANGUL SYLLABLE
   sortTable[0xB082]=33928;   // HANGUL SYLLABLE
   sortTable[0xB083]=33929;   // HANGUL SYLLABLE
   sortTable[0xB084]=33930;   // HANGUL SYLLABLE
   sortTable[0xB085]=33931;   // HANGUL SYLLABLE
   sortTable[0xB086]=33932;   // HANGUL SYLLABLE
   sortTable[0xB087]=33933;   // HANGUL SYLLABLE
   sortTable[0xB088]=33934;   // HANGUL SYLLABLE
   sortTable[0xB089]=33935;   // HANGUL SYLLABLE
   sortTable[0xB08A]=33936;   // HANGUL SYLLABLE
   sortTable[0xB08B]=33937;   // HANGUL SYLLABLE
   sortTable[0xB08C]=33938;   // HANGUL SYLLABLE
   sortTable[0xB08D]=33939;   // HANGUL SYLLABLE
   sortTable[0xB08E]=33940;   // HANGUL SYLLABLE
   sortTable[0xB08F]=33941;   // HANGUL SYLLABLE
   sortTable[0xB090]=33942;   // HANGUL SYLLABLE
   sortTable[0xB091]=33943;   // HANGUL SYLLABLE
   sortTable[0xB092]=33944;   // HANGUL SYLLABLE
   sortTable[0xB093]=33945;   // HANGUL SYLLABLE
   sortTable[0xB094]=33946;   // HANGUL SYLLABLE
   sortTable[0xB095]=33947;   // HANGUL SYLLABLE
   sortTable[0xB096]=33948;   // HANGUL SYLLABLE
   sortTable[0xB097]=33949;   // HANGUL SYLLABLE
   sortTable[0x3134]=33950;   // HANGUL SYLLABLE
   sortTable[0x1102]=33951;   // HANGUL CHOSEONG NIEUN
   sortTable[0x11AB]=33952;   // HANGUL JONGSEONG NIEUN
   sortTable[0xB098]=33953;   // HANGUL SYLLABLE
   sortTable[0xB099]=33954;   // HANGUL SYLLABLE
   sortTable[0xB09A]=33955;   // HANGUL SYLLABLE
   sortTable[0xB09B]=33956;   // HANGUL SYLLABLE
   sortTable[0xB09C]=33957;   // HANGUL SYLLABLE
   sortTable[0xB09D]=33958;   // HANGUL SYLLABLE
   sortTable[0xB09E]=33959;   // HANGUL SYLLABLE
   sortTable[0xB09F]=33960;   // HANGUL SYLLABLE
   sortTable[0xB0A0]=33961;   // HANGUL SYLLABLE
   sortTable[0xB0A1]=33962;   // HANGUL SYLLABLE
   sortTable[0xB0A2]=33963;   // HANGUL SYLLABLE
   sortTable[0xB0A3]=33964;   // HANGUL SYLLABLE
   sortTable[0xB0A4]=33965;   // HANGUL SYLLABLE
   sortTable[0xB0A5]=33966;   // HANGUL SYLLABLE
   sortTable[0xB0A6]=33967;   // HANGUL SYLLABLE
   sortTable[0xB0A7]=33968;   // HANGUL SYLLABLE
   sortTable[0xB0A8]=33969;   // HANGUL SYLLABLE
   sortTable[0xB0A9]=33970;   // HANGUL SYLLABLE
   sortTable[0xB0AA]=33971;   // HANGUL SYLLABLE
   sortTable[0xB0AB]=33972;   // HANGUL SYLLABLE
   sortTable[0xB0AC]=33973;   // HANGUL SYLLABLE
   sortTable[0xB0AD]=33974;   // HANGUL SYLLABLE
   sortTable[0xB0AE]=33975;   // HANGUL SYLLABLE
   sortTable[0xB0AF]=33976;   // HANGUL SYLLABLE
   sortTable[0xB0B0]=33977;   // HANGUL SYLLABLE
   sortTable[0xB0B1]=33978;   // HANGUL SYLLABLE
   sortTable[0xB0B2]=33979;   // HANGUL SYLLABLE
   sortTable[0xB0B3]=33980;   // HANGUL SYLLABLE
   sortTable[0xB0B4]=33981;   // HANGUL SYLLABLE
   sortTable[0xB0B5]=33982;   // HANGUL SYLLABLE
   sortTable[0xB0B6]=33983;   // HANGUL SYLLABLE
   sortTable[0xB0B7]=33984;   // HANGUL SYLLABLE
   sortTable[0xB0B8]=33985;   // HANGUL SYLLABLE
   sortTable[0xB0B9]=33986;   // HANGUL SYLLABLE
   sortTable[0xB0BA]=33987;   // HANGUL SYLLABLE
   sortTable[0xB0BB]=33988;   // HANGUL SYLLABLE
   sortTable[0xB0BC]=33989;   // HANGUL SYLLABLE
   sortTable[0xB0BD]=33990;   // HANGUL SYLLABLE
   sortTable[0xB0BE]=33991;   // HANGUL SYLLABLE
   sortTable[0xB0BF]=33992;   // HANGUL SYLLABLE
   sortTable[0xB0C0]=33993;   // HANGUL SYLLABLE
   sortTable[0xB0C1]=33994;   // HANGUL SYLLABLE
   sortTable[0xB0C2]=33995;   // HANGUL SYLLABLE
   sortTable[0xB0C3]=33996;   // HANGUL SYLLABLE
   sortTable[0xB0C4]=33997;   // HANGUL SYLLABLE
   sortTable[0xB0C5]=33998;   // HANGUL SYLLABLE
   sortTable[0xB0C6]=33999;   // HANGUL SYLLABLE
   sortTable[0xB0C7]=34000;   // HANGUL SYLLABLE
   sortTable[0xB0C8]=34001;   // HANGUL SYLLABLE
   sortTable[0xB0C9]=34002;   // HANGUL SYLLABLE
   sortTable[0xB0CA]=34003;   // HANGUL SYLLABLE
   sortTable[0xB0CB]=34004;   // HANGUL SYLLABLE
   sortTable[0xB0CC]=34005;   // HANGUL SYLLABLE
   sortTable[0xB0CD]=34006;   // HANGUL SYLLABLE
   sortTable[0xB0CE]=34007;   // HANGUL SYLLABLE
   sortTable[0xB0CF]=34008;   // HANGUL SYLLABLE
   sortTable[0xB0D0]=34009;   // HANGUL SYLLABLE
   sortTable[0xB0D1]=34010;   // HANGUL SYLLABLE
   sortTable[0xB0D2]=34011;   // HANGUL SYLLABLE
   sortTable[0xB0D3]=34012;   // HANGUL SYLLABLE
   sortTable[0xB0D4]=34013;   // HANGUL SYLLABLE
   sortTable[0xB0D5]=34014;   // HANGUL SYLLABLE
   sortTable[0xB0D6]=34015;   // HANGUL SYLLABLE
   sortTable[0xB0D7]=34016;   // HANGUL SYLLABLE
   sortTable[0xB0D8]=34017;   // HANGUL SYLLABLE
   sortTable[0xB0D9]=34018;   // HANGUL SYLLABLE
   sortTable[0xB0DA]=34019;   // HANGUL SYLLABLE
   sortTable[0xB0DB]=34020;   // HANGUL SYLLABLE
   sortTable[0xB0DC]=34021;   // HANGUL SYLLABLE
   sortTable[0xB0DD]=34022;   // HANGUL SYLLABLE
   sortTable[0xB0DE]=34023;   // HANGUL SYLLABLE
   sortTable[0xB0DF]=34024;   // HANGUL SYLLABLE
   sortTable[0xB0E0]=34025;   // HANGUL SYLLABLE
   sortTable[0xB0E1]=34026;   // HANGUL SYLLABLE
   sortTable[0xB0E2]=34027;   // HANGUL SYLLABLE
   sortTable[0xB0E3]=34028;   // HANGUL SYLLABLE
   sortTable[0xB0E4]=34029;   // HANGUL SYLLABLE
   sortTable[0xB0E5]=34030;   // HANGUL SYLLABLE
   sortTable[0xB0E6]=34031;   // HANGUL SYLLABLE
   sortTable[0xB0E7]=34032;   // HANGUL SYLLABLE
   sortTable[0xB0E8]=34033;   // HANGUL SYLLABLE
   sortTable[0xB0E9]=34034;   // HANGUL SYLLABLE
   sortTable[0xB0EA]=34035;   // HANGUL SYLLABLE
   sortTable[0xB0EB]=34036;   // HANGUL SYLLABLE
   sortTable[0xB0EC]=34037;   // HANGUL SYLLABLE
   sortTable[0xB0ED]=34038;   // HANGUL SYLLABLE
   sortTable[0xB0EE]=34039;   // HANGUL SYLLABLE
   sortTable[0xB0EF]=34040;   // HANGUL SYLLABLE
   sortTable[0xB0F0]=34041;   // HANGUL SYLLABLE
   sortTable[0xB0F1]=34042;   // HANGUL SYLLABLE
   sortTable[0xB0F2]=34043;   // HANGUL SYLLABLE
   sortTable[0xB0F3]=34044;   // HANGUL SYLLABLE
   sortTable[0xB0F4]=34045;   // HANGUL SYLLABLE
   sortTable[0xB0F5]=34046;   // HANGUL SYLLABLE
   sortTable[0xB0F6]=34047;   // HANGUL SYLLABLE
   sortTable[0xB0F7]=34048;   // HANGUL SYLLABLE
   sortTable[0xB0F8]=34049;   // HANGUL SYLLABLE
   sortTable[0xB0F9]=34050;   // HANGUL SYLLABLE
   sortTable[0xB0FA]=34051;   // HANGUL SYLLABLE
   sortTable[0xB0FB]=34052;   // HANGUL SYLLABLE
   sortTable[0xB0FC]=34053;   // HANGUL SYLLABLE
   sortTable[0xB0FD]=34054;   // HANGUL SYLLABLE
   sortTable[0xB0FE]=34055;   // HANGUL SYLLABLE
   sortTable[0xB0FF]=34056;   // HANGUL SYLLABLE
   sortTable[0xB100]=34057;   // HANGUL SYLLABLE
   sortTable[0xB101]=34058;   // HANGUL SYLLABLE
   sortTable[0xB102]=34059;   // HANGUL SYLLABLE
   sortTable[0xB103]=34060;   // HANGUL SYLLABLE
   sortTable[0xB104]=34061;   // HANGUL SYLLABLE
   sortTable[0xB105]=34062;   // HANGUL SYLLABLE
   sortTable[0xB106]=34063;   // HANGUL SYLLABLE
   sortTable[0xB107]=34064;   // HANGUL SYLLABLE
   sortTable[0xB108]=34065;   // HANGUL SYLLABLE
   sortTable[0xB109]=34066;   // HANGUL SYLLABLE
   sortTable[0xB10A]=34067;   // HANGUL SYLLABLE
   sortTable[0xB10B]=34068;   // HANGUL SYLLABLE
   sortTable[0xB10C]=34069;   // HANGUL SYLLABLE
   sortTable[0xB10D]=34070;   // HANGUL SYLLABLE
   sortTable[0xB10E]=34071;   // HANGUL SYLLABLE
   sortTable[0xB10F]=34072;   // HANGUL SYLLABLE
   sortTable[0xB110]=34073;   // HANGUL SYLLABLE
   sortTable[0xB111]=34074;   // HANGUL SYLLABLE
   sortTable[0xB112]=34075;   // HANGUL SYLLABLE
   sortTable[0xB113]=34076;   // HANGUL SYLLABLE
   sortTable[0xB114]=34077;   // HANGUL SYLLABLE
   sortTable[0xB115]=34078;   // HANGUL SYLLABLE
   sortTable[0xB116]=34079;   // HANGUL SYLLABLE
   sortTable[0xB117]=34080;   // HANGUL SYLLABLE
   sortTable[0xB118]=34081;   // HANGUL SYLLABLE
   sortTable[0xB119]=34082;   // HANGUL SYLLABLE
   sortTable[0xB11A]=34083;   // HANGUL SYLLABLE
   sortTable[0xB11B]=34084;   // HANGUL SYLLABLE
   sortTable[0xB11C]=34085;   // HANGUL SYLLABLE
   sortTable[0xB11D]=34086;   // HANGUL SYLLABLE
   sortTable[0xB11E]=34087;   // HANGUL SYLLABLE
   sortTable[0xB11F]=34088;   // HANGUL SYLLABLE
   sortTable[0xB120]=34089;   // HANGUL SYLLABLE
   sortTable[0xB121]=34090;   // HANGUL SYLLABLE
   sortTable[0xB122]=34091;   // HANGUL SYLLABLE
   sortTable[0xB123]=34092;   // HANGUL SYLLABLE
   sortTable[0xB124]=34093;   // HANGUL SYLLABLE
   sortTable[0xB125]=34094;   // HANGUL SYLLABLE
   sortTable[0xB126]=34095;   // HANGUL SYLLABLE
   sortTable[0xB127]=34096;   // HANGUL SYLLABLE
   sortTable[0xB128]=34097;   // HANGUL SYLLABLE
   sortTable[0xB129]=34098;   // HANGUL SYLLABLE
   sortTable[0xB12A]=34099;   // HANGUL SYLLABLE
   sortTable[0xB12B]=34100;   // HANGUL SYLLABLE
   sortTable[0xB12C]=34101;   // HANGUL SYLLABLE
   sortTable[0xB12D]=34102;   // HANGUL SYLLABLE
   sortTable[0xB12E]=34103;   // HANGUL SYLLABLE
   sortTable[0xB12F]=34104;   // HANGUL SYLLABLE
   sortTable[0xB130]=34105;   // HANGUL SYLLABLE
   sortTable[0xB131]=34106;   // HANGUL SYLLABLE
   sortTable[0xB132]=34107;   // HANGUL SYLLABLE
   sortTable[0xB133]=34108;   // HANGUL SYLLABLE
   sortTable[0xB134]=34109;   // HANGUL SYLLABLE
   sortTable[0xB135]=34110;   // HANGUL SYLLABLE
   sortTable[0xB136]=34111;   // HANGUL SYLLABLE
   sortTable[0xB137]=34112;   // HANGUL SYLLABLE
   sortTable[0xB138]=34113;   // HANGUL SYLLABLE
   sortTable[0xB139]=34114;   // HANGUL SYLLABLE
   sortTable[0xB13A]=34115;   // HANGUL SYLLABLE
   sortTable[0xB13B]=34116;   // HANGUL SYLLABLE
   sortTable[0xB13C]=34117;   // HANGUL SYLLABLE
   sortTable[0xB13D]=34118;   // HANGUL SYLLABLE
   sortTable[0xB13E]=34119;   // HANGUL SYLLABLE
   sortTable[0xB13F]=34120;   // HANGUL SYLLABLE
   sortTable[0xB140]=34121;   // HANGUL SYLLABLE
   sortTable[0xB141]=34122;   // HANGUL SYLLABLE
   sortTable[0xB142]=34123;   // HANGUL SYLLABLE
   sortTable[0xB143]=34124;   // HANGUL SYLLABLE
   sortTable[0xB144]=34125;   // HANGUL SYLLABLE
   sortTable[0xB145]=34126;   // HANGUL SYLLABLE
   sortTable[0xB146]=34127;   // HANGUL SYLLABLE
   sortTable[0xB147]=34128;   // HANGUL SYLLABLE
   sortTable[0xB148]=34129;   // HANGUL SYLLABLE
   sortTable[0xB149]=34130;   // HANGUL SYLLABLE
   sortTable[0xB14A]=34131;   // HANGUL SYLLABLE
   sortTable[0xB14B]=34132;   // HANGUL SYLLABLE
   sortTable[0xB14C]=34133;   // HANGUL SYLLABLE
   sortTable[0xB14D]=34134;   // HANGUL SYLLABLE
   sortTable[0xB14E]=34135;   // HANGUL SYLLABLE
   sortTable[0xB14F]=34136;   // HANGUL SYLLABLE
   sortTable[0xB150]=34137;   // HANGUL SYLLABLE
   sortTable[0xB151]=34138;   // HANGUL SYLLABLE
   sortTable[0xB152]=34139;   // HANGUL SYLLABLE
   sortTable[0xB153]=34140;   // HANGUL SYLLABLE
   sortTable[0xB154]=34141;   // HANGUL SYLLABLE
   sortTable[0xB155]=34142;   // HANGUL SYLLABLE
   sortTable[0xB156]=34143;   // HANGUL SYLLABLE
   sortTable[0xB157]=34144;   // HANGUL SYLLABLE
   sortTable[0xB158]=34145;   // HANGUL SYLLABLE
   sortTable[0xB159]=34146;   // HANGUL SYLLABLE
   sortTable[0xB15A]=34147;   // HANGUL SYLLABLE
   sortTable[0xB15B]=34148;   // HANGUL SYLLABLE
   sortTable[0xB15C]=34149;   // HANGUL SYLLABLE
   sortTable[0xB15D]=34150;   // HANGUL SYLLABLE
   sortTable[0xB15E]=34151;   // HANGUL SYLLABLE
   sortTable[0xB15F]=34152;   // HANGUL SYLLABLE
   sortTable[0xB160]=34153;   // HANGUL SYLLABLE
   sortTable[0xB161]=34154;   // HANGUL SYLLABLE
   sortTable[0xB162]=34155;   // HANGUL SYLLABLE
   sortTable[0xB163]=34156;   // HANGUL SYLLABLE
   sortTable[0xB164]=34157;   // HANGUL SYLLABLE
   sortTable[0xB165]=34158;   // HANGUL SYLLABLE
   sortTable[0xB166]=34159;   // HANGUL SYLLABLE
   sortTable[0xB167]=34160;   // HANGUL SYLLABLE
   sortTable[0xB168]=34161;   // HANGUL SYLLABLE
   sortTable[0xB169]=34162;   // HANGUL SYLLABLE
   sortTable[0xB16A]=34163;   // HANGUL SYLLABLE
   sortTable[0xB16B]=34164;   // HANGUL SYLLABLE
   sortTable[0xB16C]=34165;   // HANGUL SYLLABLE
   sortTable[0xB16D]=34166;   // HANGUL SYLLABLE
   sortTable[0xB16E]=34167;   // HANGUL SYLLABLE
   sortTable[0xB16F]=34168;   // HANGUL SYLLABLE
   sortTable[0xB170]=34169;   // HANGUL SYLLABLE
   sortTable[0xB171]=34170;   // HANGUL SYLLABLE
   sortTable[0xB172]=34171;   // HANGUL SYLLABLE
   sortTable[0xB173]=34172;   // HANGUL SYLLABLE
   sortTable[0xB174]=34173;   // HANGUL SYLLABLE
   sortTable[0xB175]=34174;   // HANGUL SYLLABLE
   sortTable[0xB176]=34175;   // HANGUL SYLLABLE
   sortTable[0xB177]=34176;   // HANGUL SYLLABLE
   sortTable[0xB178]=34177;   // HANGUL SYLLABLE
   sortTable[0xB179]=34178;   // HANGUL SYLLABLE
   sortTable[0xB17A]=34179;   // HANGUL SYLLABLE
   sortTable[0xB17B]=34180;   // HANGUL SYLLABLE
   sortTable[0xB17C]=34181;   // HANGUL SYLLABLE
   sortTable[0xB17D]=34182;   // HANGUL SYLLABLE
   sortTable[0xB17E]=34183;   // HANGUL SYLLABLE
   sortTable[0xB17F]=34184;   // HANGUL SYLLABLE
   sortTable[0xB180]=34185;   // HANGUL SYLLABLE
   sortTable[0xB181]=34186;   // HANGUL SYLLABLE
   sortTable[0xB182]=34187;   // HANGUL SYLLABLE
   sortTable[0xB183]=34188;   // HANGUL SYLLABLE
   sortTable[0xB184]=34189;   // HANGUL SYLLABLE
   sortTable[0xB185]=34190;   // HANGUL SYLLABLE
   sortTable[0xB186]=34191;   // HANGUL SYLLABLE
   sortTable[0xB187]=34192;   // HANGUL SYLLABLE
   sortTable[0xB188]=34193;   // HANGUL SYLLABLE
   sortTable[0xB189]=34194;   // HANGUL SYLLABLE
   sortTable[0xB18A]=34195;   // HANGUL SYLLABLE
   sortTable[0xB18B]=34196;   // HANGUL SYLLABLE
   sortTable[0xB18C]=34197;   // HANGUL SYLLABLE
   sortTable[0xB18D]=34198;   // HANGUL SYLLABLE
   sortTable[0xB18E]=34199;   // HANGUL SYLLABLE
   sortTable[0xB18F]=34200;   // HANGUL SYLLABLE
   sortTable[0xB190]=34201;   // HANGUL SYLLABLE
   sortTable[0xB191]=34202;   // HANGUL SYLLABLE
   sortTable[0xB192]=34203;   // HANGUL SYLLABLE
   sortTable[0xB193]=34204;   // HANGUL SYLLABLE
   sortTable[0xB194]=34205;   // HANGUL SYLLABLE
   sortTable[0xB195]=34206;   // HANGUL SYLLABLE
   sortTable[0xB196]=34207;   // HANGUL SYLLABLE
   sortTable[0xB197]=34208;   // HANGUL SYLLABLE
   sortTable[0xB198]=34209;   // HANGUL SYLLABLE
   sortTable[0xB199]=34210;   // HANGUL SYLLABLE
   sortTable[0xB19A]=34211;   // HANGUL SYLLABLE
   sortTable[0xB19B]=34212;   // HANGUL SYLLABLE
   sortTable[0xB19C]=34213;   // HANGUL SYLLABLE
   sortTable[0xB19D]=34214;   // HANGUL SYLLABLE
   sortTable[0xB19E]=34215;   // HANGUL SYLLABLE
   sortTable[0xB19F]=34216;   // HANGUL SYLLABLE
   sortTable[0xB1A0]=34217;   // HANGUL SYLLABLE
   sortTable[0xB1A1]=34218;   // HANGUL SYLLABLE
   sortTable[0xB1A2]=34219;   // HANGUL SYLLABLE
   sortTable[0xB1A3]=34220;   // HANGUL SYLLABLE
   sortTable[0xB1A4]=34221;   // HANGUL SYLLABLE
   sortTable[0xB1A5]=34222;   // HANGUL SYLLABLE
   sortTable[0xB1A6]=34223;   // HANGUL SYLLABLE
   sortTable[0xB1A7]=34224;   // HANGUL SYLLABLE
   sortTable[0xB1A8]=34225;   // HANGUL SYLLABLE
   sortTable[0xB1A9]=34226;   // HANGUL SYLLABLE
   sortTable[0xB1AA]=34227;   // HANGUL SYLLABLE
   sortTable[0xB1AB]=34228;   // HANGUL SYLLABLE
   sortTable[0xB1AC]=34229;   // HANGUL SYLLABLE
   sortTable[0xB1AD]=34230;   // HANGUL SYLLABLE
   sortTable[0xB1AE]=34231;   // HANGUL SYLLABLE
   sortTable[0xB1AF]=34232;   // HANGUL SYLLABLE
   sortTable[0xB1B0]=34233;   // HANGUL SYLLABLE
   sortTable[0xB1B1]=34234;   // HANGUL SYLLABLE
   sortTable[0xB1B2]=34235;   // HANGUL SYLLABLE
   sortTable[0xB1B3]=34236;   // HANGUL SYLLABLE
   sortTable[0xB1B4]=34237;   // HANGUL SYLLABLE
   sortTable[0xB1B5]=34238;   // HANGUL SYLLABLE
   sortTable[0xB1B6]=34239;   // HANGUL SYLLABLE
   sortTable[0xB1B7]=34240;   // HANGUL SYLLABLE
   sortTable[0xB1B8]=34241;   // HANGUL SYLLABLE
   sortTable[0xB1B9]=34242;   // HANGUL SYLLABLE
   sortTable[0xB1BA]=34243;   // HANGUL SYLLABLE
   sortTable[0xB1BB]=34244;   // HANGUL SYLLABLE
   sortTable[0xB1BC]=34245;   // HANGUL SYLLABLE
   sortTable[0xB1BD]=34246;   // HANGUL SYLLABLE
   sortTable[0xB1BE]=34247;   // HANGUL SYLLABLE
   sortTable[0xB1BF]=34248;   // HANGUL SYLLABLE
   sortTable[0xB1C0]=34249;   // HANGUL SYLLABLE
   sortTable[0xB1C1]=34250;   // HANGUL SYLLABLE
   sortTable[0xB1C2]=34251;   // HANGUL SYLLABLE
   sortTable[0xB1C3]=34252;   // HANGUL SYLLABLE
   sortTable[0xB1C4]=34253;   // HANGUL SYLLABLE
   sortTable[0xB1C5]=34254;   // HANGUL SYLLABLE
   sortTable[0xB1C6]=34255;   // HANGUL SYLLABLE
   sortTable[0xB1C7]=34256;   // HANGUL SYLLABLE
   sortTable[0xB1C8]=34257;   // HANGUL SYLLABLE
   sortTable[0xB1C9]=34258;   // HANGUL SYLLABLE
   sortTable[0xB1CA]=34259;   // HANGUL SYLLABLE
   sortTable[0xB1CB]=34260;   // HANGUL SYLLABLE
   sortTable[0xB1CC]=34261;   // HANGUL SYLLABLE
   sortTable[0xB1CD]=34262;   // HANGUL SYLLABLE
   sortTable[0xB1CE]=34263;   // HANGUL SYLLABLE
   sortTable[0xB1CF]=34264;   // HANGUL SYLLABLE
   sortTable[0xB1D0]=34265;   // HANGUL SYLLABLE
   sortTable[0xB1D1]=34266;   // HANGUL SYLLABLE
   sortTable[0xB1D2]=34267;   // HANGUL SYLLABLE
   sortTable[0xB1D3]=34268;   // HANGUL SYLLABLE
   sortTable[0xB1D4]=34269;   // HANGUL SYLLABLE
   sortTable[0xB1D5]=34270;   // HANGUL SYLLABLE
   sortTable[0xB1D6]=34271;   // HANGUL SYLLABLE
   sortTable[0xB1D7]=34272;   // HANGUL SYLLABLE
   sortTable[0xB1D8]=34273;   // HANGUL SYLLABLE
   sortTable[0xB1D9]=34274;   // HANGUL SYLLABLE
   sortTable[0xB1DA]=34275;   // HANGUL SYLLABLE
   sortTable[0xB1DB]=34276;   // HANGUL SYLLABLE
   sortTable[0xB1DC]=34277;   // HANGUL SYLLABLE
   sortTable[0xB1DD]=34278;   // HANGUL SYLLABLE
   sortTable[0xB1DE]=34279;   // HANGUL SYLLABLE
   sortTable[0xB1DF]=34280;   // HANGUL SYLLABLE
   sortTable[0xB1E0]=34281;   // HANGUL SYLLABLE
   sortTable[0xB1E1]=34282;   // HANGUL SYLLABLE
   sortTable[0xB1E2]=34283;   // HANGUL SYLLABLE
   sortTable[0xB1E3]=34284;   // HANGUL SYLLABLE
   sortTable[0xB1E4]=34285;   // HANGUL SYLLABLE
   sortTable[0xB1E5]=34286;   // HANGUL SYLLABLE
   sortTable[0xB1E6]=34287;   // HANGUL SYLLABLE
   sortTable[0xB1E7]=34288;   // HANGUL SYLLABLE
   sortTable[0xB1E8]=34289;   // HANGUL SYLLABLE
   sortTable[0xB1E9]=34290;   // HANGUL SYLLABLE
   sortTable[0xB1EA]=34291;   // HANGUL SYLLABLE
   sortTable[0xB1EB]=34292;   // HANGUL SYLLABLE
   sortTable[0xB1EC]=34293;   // HANGUL SYLLABLE
   sortTable[0xB1ED]=34294;   // HANGUL SYLLABLE
   sortTable[0xB1EE]=34295;   // HANGUL SYLLABLE
   sortTable[0xB1EF]=34296;   // HANGUL SYLLABLE
   sortTable[0xB1F0]=34297;   // HANGUL SYLLABLE
   sortTable[0xB1F1]=34298;   // HANGUL SYLLABLE
   sortTable[0xB1F2]=34299;   // HANGUL SYLLABLE
   sortTable[0xB1F3]=34300;   // HANGUL SYLLABLE
   sortTable[0xB1F4]=34301;   // HANGUL SYLLABLE
   sortTable[0xB1F5]=34302;   // HANGUL SYLLABLE
   sortTable[0xB1F6]=34303;   // HANGUL SYLLABLE
   sortTable[0xB1F7]=34304;   // HANGUL SYLLABLE
   sortTable[0xB1F8]=34305;   // HANGUL SYLLABLE
   sortTable[0xB1F9]=34306;   // HANGUL SYLLABLE
   sortTable[0xB1FA]=34307;   // HANGUL SYLLABLE
   sortTable[0xB1FB]=34308;   // HANGUL SYLLABLE
   sortTable[0xB1FC]=34309;   // HANGUL SYLLABLE
   sortTable[0xB1FD]=34310;   // HANGUL SYLLABLE
   sortTable[0xB1FE]=34311;   // HANGUL SYLLABLE
   sortTable[0xB1FF]=34312;   // HANGUL SYLLABLE
   sortTable[0xB200]=34313;   // HANGUL SYLLABLE
   sortTable[0xB201]=34314;   // HANGUL SYLLABLE
   sortTable[0xB202]=34315;   // HANGUL SYLLABLE
   sortTable[0xB203]=34316;   // HANGUL SYLLABLE
   sortTable[0xB204]=34317;   // HANGUL SYLLABLE
   sortTable[0xB205]=34318;   // HANGUL SYLLABLE
   sortTable[0xB206]=34319;   // HANGUL SYLLABLE
   sortTable[0xB207]=34320;   // HANGUL SYLLABLE
   sortTable[0xB208]=34321;   // HANGUL SYLLABLE
   sortTable[0xB209]=34322;   // HANGUL SYLLABLE
   sortTable[0xB20A]=34323;   // HANGUL SYLLABLE
   sortTable[0xB20B]=34324;   // HANGUL SYLLABLE
   sortTable[0xB20C]=34325;   // HANGUL SYLLABLE
   sortTable[0xB20D]=34326;   // HANGUL SYLLABLE
   sortTable[0xB20E]=34327;   // HANGUL SYLLABLE
   sortTable[0xB20F]=34328;   // HANGUL SYLLABLE
   sortTable[0xB210]=34329;   // HANGUL SYLLABLE
   sortTable[0xB211]=34330;   // HANGUL SYLLABLE
   sortTable[0xB212]=34331;   // HANGUL SYLLABLE
   sortTable[0xB213]=34332;   // HANGUL SYLLABLE
   sortTable[0xB214]=34333;   // HANGUL SYLLABLE
   sortTable[0xB215]=34334;   // HANGUL SYLLABLE
   sortTable[0xB216]=34335;   // HANGUL SYLLABLE
   sortTable[0xB217]=34336;   // HANGUL SYLLABLE
   sortTable[0xB218]=34337;   // HANGUL SYLLABLE
   sortTable[0xB219]=34338;   // HANGUL SYLLABLE
   sortTable[0xB21A]=34339;   // HANGUL SYLLABLE
   sortTable[0xB21B]=34340;   // HANGUL SYLLABLE
   sortTable[0xB21C]=34341;   // HANGUL SYLLABLE
   sortTable[0xB21D]=34342;   // HANGUL SYLLABLE
   sortTable[0xB21E]=34343;   // HANGUL SYLLABLE
   sortTable[0xB21F]=34344;   // HANGUL SYLLABLE
   sortTable[0xB220]=34345;   // HANGUL SYLLABLE
   sortTable[0xB221]=34346;   // HANGUL SYLLABLE
   sortTable[0xB222]=34347;   // HANGUL SYLLABLE
   sortTable[0xB223]=34348;   // HANGUL SYLLABLE
   sortTable[0xB224]=34349;   // HANGUL SYLLABLE
   sortTable[0xB225]=34350;   // HANGUL SYLLABLE
   sortTable[0xB226]=34351;   // HANGUL SYLLABLE
   sortTable[0xB227]=34352;   // HANGUL SYLLABLE
   sortTable[0xB228]=34353;   // HANGUL SYLLABLE
   sortTable[0xB229]=34354;   // HANGUL SYLLABLE
   sortTable[0xB22A]=34355;   // HANGUL SYLLABLE
   sortTable[0xB22B]=34356;   // HANGUL SYLLABLE
   sortTable[0xB22C]=34357;   // HANGUL SYLLABLE
   sortTable[0xB22D]=34358;   // HANGUL SYLLABLE
   sortTable[0xB22E]=34359;   // HANGUL SYLLABLE
   sortTable[0xB22F]=34360;   // HANGUL SYLLABLE
   sortTable[0xB230]=34361;   // HANGUL SYLLABLE
   sortTable[0xB231]=34362;   // HANGUL SYLLABLE
   sortTable[0xB232]=34363;   // HANGUL SYLLABLE
   sortTable[0xB233]=34364;   // HANGUL SYLLABLE
   sortTable[0xB234]=34365;   // HANGUL SYLLABLE
   sortTable[0xB235]=34366;   // HANGUL SYLLABLE
   sortTable[0xB236]=34367;   // HANGUL SYLLABLE
   sortTable[0xB237]=34368;   // HANGUL SYLLABLE
   sortTable[0xB238]=34369;   // HANGUL SYLLABLE
   sortTable[0xB239]=34370;   // HANGUL SYLLABLE
   sortTable[0xB23A]=34371;   // HANGUL SYLLABLE
   sortTable[0xB23B]=34372;   // HANGUL SYLLABLE
   sortTable[0xB23C]=34373;   // HANGUL SYLLABLE
   sortTable[0xB23D]=34374;   // HANGUL SYLLABLE
   sortTable[0xB23E]=34375;   // HANGUL SYLLABLE
   sortTable[0xB23F]=34376;   // HANGUL SYLLABLE
   sortTable[0xB240]=34377;   // HANGUL SYLLABLE
   sortTable[0xB241]=34378;   // HANGUL SYLLABLE
   sortTable[0xB242]=34379;   // HANGUL SYLLABLE
   sortTable[0xB243]=34380;   // HANGUL SYLLABLE
   sortTable[0xB244]=34381;   // HANGUL SYLLABLE
   sortTable[0xB245]=34382;   // HANGUL SYLLABLE
   sortTable[0xB246]=34383;   // HANGUL SYLLABLE
   sortTable[0xB247]=34384;   // HANGUL SYLLABLE
   sortTable[0xB248]=34385;   // HANGUL SYLLABLE
   sortTable[0xB249]=34386;   // HANGUL SYLLABLE
   sortTable[0xB24A]=34387;   // HANGUL SYLLABLE
   sortTable[0xB24B]=34388;   // HANGUL SYLLABLE
   sortTable[0xB24C]=34389;   // HANGUL SYLLABLE
   sortTable[0xB24D]=34390;   // HANGUL SYLLABLE
   sortTable[0xB24E]=34391;   // HANGUL SYLLABLE
   sortTable[0xB24F]=34392;   // HANGUL SYLLABLE
   sortTable[0xB250]=34393;   // HANGUL SYLLABLE
   sortTable[0xB251]=34394;   // HANGUL SYLLABLE
   sortTable[0xB252]=34395;   // HANGUL SYLLABLE
   sortTable[0xB253]=34396;   // HANGUL SYLLABLE
   sortTable[0xB254]=34397;   // HANGUL SYLLABLE
   sortTable[0xB255]=34398;   // HANGUL SYLLABLE
   sortTable[0xB256]=34399;   // HANGUL SYLLABLE
   sortTable[0xB257]=34400;   // HANGUL SYLLABLE
   sortTable[0xB258]=34401;   // HANGUL SYLLABLE
   sortTable[0xB259]=34402;   // HANGUL SYLLABLE
   sortTable[0xB25A]=34403;   // HANGUL SYLLABLE
   sortTable[0xB25B]=34404;   // HANGUL SYLLABLE
   sortTable[0xB25C]=34405;   // HANGUL SYLLABLE
   sortTable[0xB25D]=34406;   // HANGUL SYLLABLE
   sortTable[0xB25E]=34407;   // HANGUL SYLLABLE
   sortTable[0xB25F]=34408;   // HANGUL SYLLABLE
   sortTable[0xB260]=34409;   // HANGUL SYLLABLE
   sortTable[0xB261]=34410;   // HANGUL SYLLABLE
   sortTable[0xB262]=34411;   // HANGUL SYLLABLE
   sortTable[0xB263]=34412;   // HANGUL SYLLABLE
   sortTable[0xB264]=34413;   // HANGUL SYLLABLE
   sortTable[0xB265]=34414;   // HANGUL SYLLABLE
   sortTable[0xB266]=34415;   // HANGUL SYLLABLE
   sortTable[0xB267]=34416;   // HANGUL SYLLABLE
   sortTable[0xB268]=34417;   // HANGUL SYLLABLE
   sortTable[0xB269]=34418;   // HANGUL SYLLABLE
   sortTable[0xB26A]=34419;   // HANGUL SYLLABLE
   sortTable[0xB26B]=34420;   // HANGUL SYLLABLE
   sortTable[0xB26C]=34421;   // HANGUL SYLLABLE
   sortTable[0xB26D]=34422;   // HANGUL SYLLABLE
   sortTable[0xB26E]=34423;   // HANGUL SYLLABLE
   sortTable[0xB26F]=34424;   // HANGUL SYLLABLE
   sortTable[0xB270]=34425;   // HANGUL SYLLABLE
   sortTable[0xB271]=34426;   // HANGUL SYLLABLE
   sortTable[0xB272]=34427;   // HANGUL SYLLABLE
   sortTable[0xB273]=34428;   // HANGUL SYLLABLE
   sortTable[0xB274]=34429;   // HANGUL SYLLABLE
   sortTable[0xB275]=34430;   // HANGUL SYLLABLE
   sortTable[0xB276]=34431;   // HANGUL SYLLABLE
   sortTable[0xB277]=34432;   // HANGUL SYLLABLE
   sortTable[0xB278]=34433;   // HANGUL SYLLABLE
   sortTable[0xB279]=34434;   // HANGUL SYLLABLE
   sortTable[0xB27A]=34435;   // HANGUL SYLLABLE
   sortTable[0xB27B]=34436;   // HANGUL SYLLABLE
   sortTable[0xB27C]=34437;   // HANGUL SYLLABLE
   sortTable[0xB27D]=34438;   // HANGUL SYLLABLE
   sortTable[0xB27E]=34439;   // HANGUL SYLLABLE
   sortTable[0xB27F]=34440;   // HANGUL SYLLABLE
   sortTable[0xB280]=34441;   // HANGUL SYLLABLE
   sortTable[0xB281]=34442;   // HANGUL SYLLABLE
   sortTable[0xB282]=34443;   // HANGUL SYLLABLE
   sortTable[0xB283]=34444;   // HANGUL SYLLABLE
   sortTable[0xB284]=34445;   // HANGUL SYLLABLE
   sortTable[0xB285]=34446;   // HANGUL SYLLABLE
   sortTable[0xB286]=34447;   // HANGUL SYLLABLE
   sortTable[0xB287]=34448;   // HANGUL SYLLABLE
   sortTable[0xB288]=34449;   // HANGUL SYLLABLE
   sortTable[0xB289]=34450;   // HANGUL SYLLABLE
   sortTable[0xB28A]=34451;   // HANGUL SYLLABLE
   sortTable[0xB28B]=34452;   // HANGUL SYLLABLE
   sortTable[0xB28C]=34453;   // HANGUL SYLLABLE
   sortTable[0xB28D]=34454;   // HANGUL SYLLABLE
   sortTable[0xB28E]=34455;   // HANGUL SYLLABLE
   sortTable[0xB28F]=34456;   // HANGUL SYLLABLE
   sortTable[0xB290]=34457;   // HANGUL SYLLABLE
   sortTable[0xB291]=34458;   // HANGUL SYLLABLE
   sortTable[0xB292]=34459;   // HANGUL SYLLABLE
   sortTable[0xB293]=34460;   // HANGUL SYLLABLE
   sortTable[0xB294]=34461;   // HANGUL SYLLABLE
   sortTable[0xB295]=34462;   // HANGUL SYLLABLE
   sortTable[0xB296]=34463;   // HANGUL SYLLABLE
   sortTable[0xB297]=34464;   // HANGUL SYLLABLE
   sortTable[0xB298]=34465;   // HANGUL SYLLABLE
   sortTable[0xB299]=34466;   // HANGUL SYLLABLE
   sortTable[0xB29A]=34467;   // HANGUL SYLLABLE
   sortTable[0xB29B]=34468;   // HANGUL SYLLABLE
   sortTable[0xB29C]=34469;   // HANGUL SYLLABLE
   sortTable[0xB29D]=34470;   // HANGUL SYLLABLE
   sortTable[0xB29E]=34471;   // HANGUL SYLLABLE
   sortTable[0xB29F]=34472;   // HANGUL SYLLABLE
   sortTable[0xB2A0]=34473;   // HANGUL SYLLABLE
   sortTable[0xB2A1]=34474;   // HANGUL SYLLABLE
   sortTable[0xB2A2]=34475;   // HANGUL SYLLABLE
   sortTable[0xB2A3]=34476;   // HANGUL SYLLABLE
   sortTable[0xB2A4]=34477;   // HANGUL SYLLABLE
   sortTable[0xB2A5]=34478;   // HANGUL SYLLABLE
   sortTable[0xB2A6]=34479;   // HANGUL SYLLABLE
   sortTable[0xB2A7]=34480;   // HANGUL SYLLABLE
   sortTable[0xB2A8]=34481;   // HANGUL SYLLABLE
   sortTable[0xB2A9]=34482;   // HANGUL SYLLABLE
   sortTable[0xB2AA]=34483;   // HANGUL SYLLABLE
   sortTable[0xB2AB]=34484;   // HANGUL SYLLABLE
   sortTable[0xB2AC]=34485;   // HANGUL SYLLABLE
   sortTable[0xB2AD]=34486;   // HANGUL SYLLABLE
   sortTable[0xB2AE]=34487;   // HANGUL SYLLABLE
   sortTable[0xB2AF]=34488;   // HANGUL SYLLABLE
   sortTable[0xB2B0]=34489;   // HANGUL SYLLABLE
   sortTable[0xB2B1]=34490;   // HANGUL SYLLABLE
   sortTable[0xB2B2]=34491;   // HANGUL SYLLABLE
   sortTable[0xB2B3]=34492;   // HANGUL SYLLABLE
   sortTable[0xB2B4]=34493;   // HANGUL SYLLABLE
   sortTable[0xB2B5]=34494;   // HANGUL SYLLABLE
   sortTable[0xB2B6]=34495;   // HANGUL SYLLABLE
   sortTable[0xB2B7]=34496;   // HANGUL SYLLABLE
   sortTable[0xB2B8]=34497;   // HANGUL SYLLABLE
   sortTable[0xB2B9]=34498;   // HANGUL SYLLABLE
   sortTable[0xB2BA]=34499;   // HANGUL SYLLABLE
   sortTable[0xB2BB]=34500;   // HANGUL SYLLABLE
   sortTable[0xB2BC]=34501;   // HANGUL SYLLABLE
   sortTable[0xB2BD]=34502;   // HANGUL SYLLABLE
   sortTable[0xB2BE]=34503;   // HANGUL SYLLABLE
   sortTable[0xB2BF]=34504;   // HANGUL SYLLABLE
   sortTable[0xB2C0]=34505;   // HANGUL SYLLABLE
   sortTable[0xB2C1]=34506;   // HANGUL SYLLABLE
   sortTable[0xB2C2]=34507;   // HANGUL SYLLABLE
   sortTable[0xB2C3]=34508;   // HANGUL SYLLABLE
   sortTable[0xB2C4]=34509;   // HANGUL SYLLABLE
   sortTable[0xB2C5]=34510;   // HANGUL SYLLABLE
   sortTable[0xB2C6]=34511;   // HANGUL SYLLABLE
   sortTable[0xB2C7]=34512;   // HANGUL SYLLABLE
   sortTable[0xB2C8]=34513;   // HANGUL SYLLABLE
   sortTable[0xB2C9]=34514;   // HANGUL SYLLABLE
   sortTable[0xB2CA]=34515;   // HANGUL SYLLABLE
   sortTable[0xB2CB]=34516;   // HANGUL SYLLABLE
   sortTable[0xB2CC]=34517;   // HANGUL SYLLABLE
   sortTable[0xB2CD]=34518;   // HANGUL SYLLABLE
   sortTable[0xB2CE]=34519;   // HANGUL SYLLABLE
   sortTable[0xB2CF]=34520;   // HANGUL SYLLABLE
   sortTable[0xB2D0]=34521;   // HANGUL SYLLABLE
   sortTable[0xB2D1]=34522;   // HANGUL SYLLABLE
   sortTable[0xB2D2]=34523;   // HANGUL SYLLABLE
   sortTable[0xB2D3]=34524;   // HANGUL SYLLABLE
   sortTable[0xB2D4]=34525;   // HANGUL SYLLABLE
   sortTable[0xB2D5]=34526;   // HANGUL SYLLABLE
   sortTable[0xB2D6]=34527;   // HANGUL SYLLABLE
   sortTable[0xB2D7]=34528;   // HANGUL SYLLABLE
   sortTable[0xB2D8]=34529;   // HANGUL SYLLABLE
   sortTable[0xB2D9]=34530;   // HANGUL SYLLABLE
   sortTable[0xB2DA]=34531;   // HANGUL SYLLABLE
   sortTable[0xB2DB]=34532;   // HANGUL SYLLABLE
   sortTable[0xB2DC]=34533;   // HANGUL SYLLABLE
   sortTable[0xB2DD]=34534;   // HANGUL SYLLABLE
   sortTable[0xB2DE]=34535;   // HANGUL SYLLABLE
   sortTable[0xB2DF]=34536;   // HANGUL SYLLABLE
   sortTable[0xB2E0]=34537;   // HANGUL SYLLABLE
   sortTable[0xB2E1]=34538;   // HANGUL SYLLABLE
   sortTable[0xB2E2]=34539;   // HANGUL SYLLABLE
   sortTable[0xB2E3]=34540;   // HANGUL SYLLABLE
   sortTable[0x3137]=34541;   // HANGUL LETTER TIKEUT
   sortTable[0x1103]=34542;   // HANGUL CHOSEONG TIKEUT
   sortTable[0x11AE]=34543;   // HANGUL JONGSEONG TIKEUT
   sortTable[0xB2E4]=34544;   // HANGUL SYLLABLE
   sortTable[0xB2E5]=34545;   // HANGUL SYLLABLE
   sortTable[0xB2E6]=34546;   // HANGUL SYLLABLE
   sortTable[0xB2E7]=34547;   // HANGUL SYLLABLE
   sortTable[0xB2E8]=34548;   // HANGUL SYLLABLE
   sortTable[0xB2E9]=34549;   // HANGUL SYLLABLE
   sortTable[0xB2EA]=34550;   // HANGUL SYLLABLE
   sortTable[0xB2EB]=34551;   // HANGUL SYLLABLE
   sortTable[0xB2EC]=34552;   // HANGUL SYLLABLE
   sortTable[0xB2ED]=34553;   // HANGUL SYLLABLE
   sortTable[0xB2EE]=34554;   // HANGUL SYLLABLE
   sortTable[0xB2EF]=34555;   // HANGUL SYLLABLE
   sortTable[0xB2F0]=34556;   // HANGUL SYLLABLE
   sortTable[0xB2F1]=34557;   // HANGUL SYLLABLE
   sortTable[0xB2F2]=34558;   // HANGUL SYLLABLE
   sortTable[0xB2F3]=34559;   // HANGUL SYLLABLE
   sortTable[0xB2F4]=34560;   // HANGUL SYLLABLE
   sortTable[0xB2F5]=34561;   // HANGUL SYLLABLE
   sortTable[0xB2F6]=34562;   // HANGUL SYLLABLE
   sortTable[0xB2F7]=34563;   // HANGUL SYLLABLE
   sortTable[0xB2F8]=34564;   // HANGUL SYLLABLE
   sortTable[0xB2F9]=34565;   // HANGUL SYLLABLE
   sortTable[0xB2FA]=34566;   // HANGUL SYLLABLE
   sortTable[0xB2FB]=34567;   // HANGUL SYLLABLE
   sortTable[0xB2FC]=34568;   // HANGUL SYLLABLE
   sortTable[0xB2FD]=34569;   // HANGUL SYLLABLE
   sortTable[0xB2FE]=34570;   // HANGUL SYLLABLE
   sortTable[0xB2FF]=34571;   // HANGUL SYLLABLE
   sortTable[0xB300]=34572;   // HANGUL SYLLABLE
   sortTable[0xB301]=34573;   // HANGUL SYLLABLE
   sortTable[0xB302]=34574;   // HANGUL SYLLABLE
   sortTable[0xB303]=34575;   // HANGUL SYLLABLE
   sortTable[0xB304]=34576;   // HANGUL SYLLABLE
   sortTable[0xB305]=34577;   // HANGUL SYLLABLE
   sortTable[0xB306]=34578;   // HANGUL SYLLABLE
   sortTable[0xB307]=34579;   // HANGUL SYLLABLE
   sortTable[0xB308]=34580;   // HANGUL SYLLABLE
   sortTable[0xB309]=34581;   // HANGUL SYLLABLE
   sortTable[0xB30A]=34582;   // HANGUL SYLLABLE
   sortTable[0xB30B]=34583;   // HANGUL SYLLABLE
   sortTable[0xB30C]=34584;   // HANGUL SYLLABLE
   sortTable[0xB30D]=34585;   // HANGUL SYLLABLE
   sortTable[0xB30E]=34586;   // HANGUL SYLLABLE
   sortTable[0xB30F]=34587;   // HANGUL SYLLABLE
   sortTable[0xB310]=34588;   // HANGUL SYLLABLE
   sortTable[0xB311]=34589;   // HANGUL SYLLABLE
   sortTable[0xB312]=34590;   // HANGUL SYLLABLE
   sortTable[0xB313]=34591;   // HANGUL SYLLABLE
   sortTable[0xB314]=34592;   // HANGUL SYLLABLE
   sortTable[0xB315]=34593;   // HANGUL SYLLABLE
   sortTable[0xB316]=34594;   // HANGUL SYLLABLE
   sortTable[0xB317]=34595;   // HANGUL SYLLABLE
   sortTable[0xB318]=34596;   // HANGUL SYLLABLE
   sortTable[0xB319]=34597;   // HANGUL SYLLABLE
   sortTable[0xB31A]=34598;   // HANGUL SYLLABLE
   sortTable[0xB31B]=34599;   // HANGUL SYLLABLE
   sortTable[0xB31C]=34600;   // HANGUL SYLLABLE
   sortTable[0xB31D]=34601;   // HANGUL SYLLABLE
   sortTable[0xB31E]=34602;   // HANGUL SYLLABLE
   sortTable[0xB31F]=34603;   // HANGUL SYLLABLE
   sortTable[0xB320]=34604;   // HANGUL SYLLABLE
   sortTable[0xB321]=34605;   // HANGUL SYLLABLE
   sortTable[0xB322]=34606;   // HANGUL SYLLABLE
   sortTable[0xB323]=34607;   // HANGUL SYLLABLE
   sortTable[0xB324]=34608;   // HANGUL SYLLABLE
   sortTable[0xB325]=34609;   // HANGUL SYLLABLE
   sortTable[0xB326]=34610;   // HANGUL SYLLABLE
   sortTable[0xB327]=34611;   // HANGUL SYLLABLE
   sortTable[0xB328]=34612;   // HANGUL SYLLABLE
   sortTable[0xB329]=34613;   // HANGUL SYLLABLE
   sortTable[0xB32A]=34614;   // HANGUL SYLLABLE
   sortTable[0xB32B]=34615;   // HANGUL SYLLABLE
   sortTable[0xB32C]=34616;   // HANGUL SYLLABLE
   sortTable[0xB32D]=34617;   // HANGUL SYLLABLE
   sortTable[0xB32E]=34618;   // HANGUL SYLLABLE
   sortTable[0xB32F]=34619;   // HANGUL SYLLABLE
   sortTable[0xB330]=34620;   // HANGUL SYLLABLE
   sortTable[0xB331]=34621;   // HANGUL SYLLABLE
   sortTable[0xB332]=34622;   // HANGUL SYLLABLE
   sortTable[0xB333]=34623;   // HANGUL SYLLABLE
   sortTable[0xB334]=34624;   // HANGUL SYLLABLE
   sortTable[0xB335]=34625;   // HANGUL SYLLABLE
   sortTable[0xB336]=34626;   // HANGUL SYLLABLE
   sortTable[0xB337]=34627;   // HANGUL SYLLABLE
   sortTable[0xB338]=34628;   // HANGUL SYLLABLE
   sortTable[0xB339]=34629;   // HANGUL SYLLABLE
   sortTable[0xB33A]=34630;   // HANGUL SYLLABLE
   sortTable[0xB33B]=34631;   // HANGUL SYLLABLE
   sortTable[0xB33C]=34632;   // HANGUL SYLLABLE
   sortTable[0xB33D]=34633;   // HANGUL SYLLABLE
   sortTable[0xB33E]=34634;   // HANGUL SYLLABLE
   sortTable[0xB33F]=34635;   // HANGUL SYLLABLE
   sortTable[0xB340]=34636;   // HANGUL SYLLABLE
   sortTable[0xB341]=34637;   // HANGUL SYLLABLE
   sortTable[0xB342]=34638;   // HANGUL SYLLABLE
   sortTable[0xB343]=34639;   // HANGUL SYLLABLE
   sortTable[0xB344]=34640;   // HANGUL SYLLABLE
   sortTable[0xB345]=34641;   // HANGUL SYLLABLE
   sortTable[0xB346]=34642;   // HANGUL SYLLABLE
   sortTable[0xB347]=34643;   // HANGUL SYLLABLE
   sortTable[0xB348]=34644;   // HANGUL SYLLABLE
   sortTable[0xB349]=34645;   // HANGUL SYLLABLE
   sortTable[0xB34A]=34646;   // HANGUL SYLLABLE
   sortTable[0xB34B]=34647;   // HANGUL SYLLABLE
   sortTable[0xB34C]=34648;   // HANGUL SYLLABLE
   sortTable[0xB34D]=34649;   // HANGUL SYLLABLE
   sortTable[0xB34E]=34650;   // HANGUL SYLLABLE
   sortTable[0xB34F]=34651;   // HANGUL SYLLABLE
   sortTable[0xB350]=34652;   // HANGUL SYLLABLE
   sortTable[0xB351]=34653;   // HANGUL SYLLABLE
   sortTable[0xB352]=34654;   // HANGUL SYLLABLE
   sortTable[0xB353]=34655;   // HANGUL SYLLABLE
   sortTable[0xB354]=34656;   // HANGUL SYLLABLE
   sortTable[0xB355]=34657;   // HANGUL SYLLABLE
   sortTable[0xB356]=34658;   // HANGUL SYLLABLE
   sortTable[0xB357]=34659;   // HANGUL SYLLABLE
   sortTable[0xB358]=34660;   // HANGUL SYLLABLE
   sortTable[0xB359]=34661;   // HANGUL SYLLABLE
   sortTable[0xB35A]=34662;   // HANGUL SYLLABLE
   sortTable[0xB35B]=34663;   // HANGUL SYLLABLE
   sortTable[0xB35C]=34664;   // HANGUL SYLLABLE
   sortTable[0xB35D]=34665;   // HANGUL SYLLABLE
   sortTable[0xB35E]=34666;   // HANGUL SYLLABLE
   sortTable[0xB35F]=34667;   // HANGUL SYLLABLE
   sortTable[0xB360]=34668;   // HANGUL SYLLABLE
   sortTable[0xB361]=34669;   // HANGUL SYLLABLE
   sortTable[0xB362]=34670;   // HANGUL SYLLABLE
   sortTable[0xB363]=34671;   // HANGUL SYLLABLE
   sortTable[0xB364]=34672;   // HANGUL SYLLABLE
   sortTable[0xB365]=34673;   // HANGUL SYLLABLE
   sortTable[0xB366]=34674;   // HANGUL SYLLABLE
   sortTable[0xB367]=34675;   // HANGUL SYLLABLE
   sortTable[0xB368]=34676;   // HANGUL SYLLABLE
   sortTable[0xB369]=34677;   // HANGUL SYLLABLE
   sortTable[0xB36A]=34678;   // HANGUL SYLLABLE
   sortTable[0xB36B]=34679;   // HANGUL SYLLABLE
   sortTable[0xB36C]=34680;   // HANGUL SYLLABLE
   sortTable[0xB36D]=34681;   // HANGUL SYLLABLE
   sortTable[0xB36E]=34682;   // HANGUL SYLLABLE
   sortTable[0xB36F]=34683;   // HANGUL SYLLABLE
   sortTable[0xB370]=34684;   // HANGUL SYLLABLE
   sortTable[0xB371]=34685;   // HANGUL SYLLABLE
   sortTable[0xB372]=34686;   // HANGUL SYLLABLE
   sortTable[0xB373]=34687;   // HANGUL SYLLABLE
   sortTable[0xB374]=34688;   // HANGUL SYLLABLE
   sortTable[0xB375]=34689;   // HANGUL SYLLABLE
   sortTable[0xB376]=34690;   // HANGUL SYLLABLE
   sortTable[0xB377]=34691;   // HANGUL SYLLABLE
   sortTable[0xB378]=34692;   // HANGUL SYLLABLE
   sortTable[0xB379]=34693;   // HANGUL SYLLABLE
   sortTable[0xB37A]=34694;   // HANGUL SYLLABLE
   sortTable[0xB37B]=34695;   // HANGUL SYLLABLE
   sortTable[0xB37C]=34696;   // HANGUL SYLLABLE
   sortTable[0xB37D]=34697;   // HANGUL SYLLABLE
   sortTable[0xB37E]=34698;   // HANGUL SYLLABLE
   sortTable[0xB37F]=34699;   // HANGUL SYLLABLE
   sortTable[0xB380]=34700;   // HANGUL SYLLABLE
   sortTable[0xB381]=34701;   // HANGUL SYLLABLE
   sortTable[0xB382]=34702;   // HANGUL SYLLABLE
   sortTable[0xB383]=34703;   // HANGUL SYLLABLE
   sortTable[0xB384]=34704;   // HANGUL SYLLABLE
   sortTable[0xB385]=34705;   // HANGUL SYLLABLE
   sortTable[0xB386]=34706;   // HANGUL SYLLABLE
   sortTable[0xB387]=34707;   // HANGUL SYLLABLE
   sortTable[0xB388]=34708;   // HANGUL SYLLABLE
   sortTable[0xB389]=34709;   // HANGUL SYLLABLE
   sortTable[0xB38A]=34710;   // HANGUL SYLLABLE
   sortTable[0xB38B]=34711;   // HANGUL SYLLABLE
   sortTable[0xB38C]=34712;   // HANGUL SYLLABLE
   sortTable[0xB38D]=34713;   // HANGUL SYLLABLE
   sortTable[0xB38E]=34714;   // HANGUL SYLLABLE
   sortTable[0xB38F]=34715;   // HANGUL SYLLABLE
   sortTable[0xB390]=34716;   // HANGUL SYLLABLE
   sortTable[0xB391]=34717;   // HANGUL SYLLABLE
   sortTable[0xB392]=34718;   // HANGUL SYLLABLE
   sortTable[0xB393]=34719;   // HANGUL SYLLABLE
   sortTable[0xB394]=34720;   // HANGUL SYLLABLE
   sortTable[0xB395]=34721;   // HANGUL SYLLABLE
   sortTable[0xB396]=34722;   // HANGUL SYLLABLE
   sortTable[0xB397]=34723;   // HANGUL SYLLABLE
   sortTable[0xB398]=34724;   // HANGUL SYLLABLE
   sortTable[0xB399]=34725;   // HANGUL SYLLABLE
   sortTable[0xB39A]=34726;   // HANGUL SYLLABLE
   sortTable[0xB39B]=34727;   // HANGUL SYLLABLE
   sortTable[0xB39C]=34728;   // HANGUL SYLLABLE
   sortTable[0xB39D]=34729;   // HANGUL SYLLABLE
   sortTable[0xB39E]=34730;   // HANGUL SYLLABLE
   sortTable[0xB39F]=34731;   // HANGUL SYLLABLE
   sortTable[0xB3A0]=34732;   // HANGUL SYLLABLE
   sortTable[0xB3A1]=34733;   // HANGUL SYLLABLE
   sortTable[0xB3A2]=34734;   // HANGUL SYLLABLE
   sortTable[0xB3A3]=34735;   // HANGUL SYLLABLE
   sortTable[0xB3A4]=34736;   // HANGUL SYLLABLE
   sortTable[0xB3A5]=34737;   // HANGUL SYLLABLE
   sortTable[0xB3A6]=34738;   // HANGUL SYLLABLE
   sortTable[0xB3A7]=34739;   // HANGUL SYLLABLE
   sortTable[0xB3A8]=34740;   // HANGUL SYLLABLE
   sortTable[0xB3A9]=34741;   // HANGUL SYLLABLE
   sortTable[0xB3AA]=34742;   // HANGUL SYLLABLE
   sortTable[0xB3AB]=34743;   // HANGUL SYLLABLE
   sortTable[0xB3AC]=34744;   // HANGUL SYLLABLE
   sortTable[0xB3AD]=34745;   // HANGUL SYLLABLE
   sortTable[0xB3AE]=34746;   // HANGUL SYLLABLE
   sortTable[0xB3AF]=34747;   // HANGUL SYLLABLE
   sortTable[0xB3B0]=34748;   // HANGUL SYLLABLE
   sortTable[0xB3B1]=34749;   // HANGUL SYLLABLE
   sortTable[0xB3B2]=34750;   // HANGUL SYLLABLE
   sortTable[0xB3B3]=34751;   // HANGUL SYLLABLE
   sortTable[0xB3B4]=34752;   // HANGUL SYLLABLE
   sortTable[0xB3B5]=34753;   // HANGUL SYLLABLE
   sortTable[0xB3B6]=34754;   // HANGUL SYLLABLE
   sortTable[0xB3B7]=34755;   // HANGUL SYLLABLE
   sortTable[0xB3B8]=34756;   // HANGUL SYLLABLE
   sortTable[0xB3B9]=34757;   // HANGUL SYLLABLE
   sortTable[0xB3BA]=34758;   // HANGUL SYLLABLE
   sortTable[0xB3BB]=34759;   // HANGUL SYLLABLE
   sortTable[0xB3BC]=34760;   // HANGUL SYLLABLE
   sortTable[0xB3BD]=34761;   // HANGUL SYLLABLE
   sortTable[0xB3BE]=34762;   // HANGUL SYLLABLE
   sortTable[0xB3BF]=34763;   // HANGUL SYLLABLE
   sortTable[0xB3C0]=34764;   // HANGUL SYLLABLE
   sortTable[0xB3C1]=34765;   // HANGUL SYLLABLE
   sortTable[0xB3C2]=34766;   // HANGUL SYLLABLE
   sortTable[0xB3C3]=34767;   // HANGUL SYLLABLE
   sortTable[0xB3C4]=34768;   // HANGUL SYLLABLE
   sortTable[0xB3C5]=34769;   // HANGUL SYLLABLE
   sortTable[0xB3C6]=34770;   // HANGUL SYLLABLE
   sortTable[0xB3C7]=34771;   // HANGUL SYLLABLE
   sortTable[0xB3C8]=34772;   // HANGUL SYLLABLE
   sortTable[0xB3C9]=34773;   // HANGUL SYLLABLE
   sortTable[0xB3CA]=34774;   // HANGUL SYLLABLE
   sortTable[0xB3CB]=34775;   // HANGUL SYLLABLE
   sortTable[0xB3CC]=34776;   // HANGUL SYLLABLE
   sortTable[0xB3CD]=34777;   // HANGUL SYLLABLE
   sortTable[0xB3CE]=34778;   // HANGUL SYLLABLE
   sortTable[0xB3CF]=34779;   // HANGUL SYLLABLE
   sortTable[0xB3D0]=34780;   // HANGUL SYLLABLE
   sortTable[0xB3D1]=34781;   // HANGUL SYLLABLE
   sortTable[0xB3D2]=34782;   // HANGUL SYLLABLE
   sortTable[0xB3D3]=34783;   // HANGUL SYLLABLE
   sortTable[0xB3D4]=34784;   // HANGUL SYLLABLE
   sortTable[0xB3D5]=34785;   // HANGUL SYLLABLE
   sortTable[0xB3D6]=34786;   // HANGUL SYLLABLE
   sortTable[0xB3D7]=34787;   // HANGUL SYLLABLE
   sortTable[0xB3D8]=34788;   // HANGUL SYLLABLE
   sortTable[0xB3D9]=34789;   // HANGUL SYLLABLE
   sortTable[0xB3DA]=34790;   // HANGUL SYLLABLE
   sortTable[0xB3DB]=34791;   // HANGUL SYLLABLE
   sortTable[0xB3DC]=34792;   // HANGUL SYLLABLE
   sortTable[0xB3DD]=34793;   // HANGUL SYLLABLE
   sortTable[0xB3DE]=34794;   // HANGUL SYLLABLE
   sortTable[0xB3DF]=34795;   // HANGUL SYLLABLE
   sortTable[0xB3E0]=34796;   // HANGUL SYLLABLE
   sortTable[0xB3E1]=34797;   // HANGUL SYLLABLE
   sortTable[0xB3E2]=34798;   // HANGUL SYLLABLE
   sortTable[0xB3E3]=34799;   // HANGUL SYLLABLE
   sortTable[0xB3E4]=34800;   // HANGUL SYLLABLE
   sortTable[0xB3E5]=34801;   // HANGUL SYLLABLE
   sortTable[0xB3E6]=34802;   // HANGUL SYLLABLE
   sortTable[0xB3E7]=34803;   // HANGUL SYLLABLE
   sortTable[0xB3E8]=34804;   // HANGUL SYLLABLE
   sortTable[0xB3E9]=34805;   // HANGUL SYLLABLE
   sortTable[0xB3EA]=34806;   // HANGUL SYLLABLE
   sortTable[0xB3EB]=34807;   // HANGUL SYLLABLE
   sortTable[0xB3EC]=34808;   // HANGUL SYLLABLE
   sortTable[0xB3ED]=34809;   // HANGUL SYLLABLE
   sortTable[0xB3EE]=34810;   // HANGUL SYLLABLE
   sortTable[0xB3EF]=34811;   // HANGUL SYLLABLE
   sortTable[0xB3F0]=34812;   // HANGUL SYLLABLE
   sortTable[0xB3F1]=34813;   // HANGUL SYLLABLE
   sortTable[0xB3F2]=34814;   // HANGUL SYLLABLE
   sortTable[0xB3F3]=34815;   // HANGUL SYLLABLE
   sortTable[0xB3F4]=34816;   // HANGUL SYLLABLE
   sortTable[0xB3F5]=34817;   // HANGUL SYLLABLE
   sortTable[0xB3F6]=34818;   // HANGUL SYLLABLE
   sortTable[0xB3F7]=34819;   // HANGUL SYLLABLE
   sortTable[0xB3F8]=34820;   // HANGUL SYLLABLE
   sortTable[0xB3F9]=34821;   // HANGUL SYLLABLE
   sortTable[0xB3FA]=34822;   // HANGUL SYLLABLE
   sortTable[0xB3FB]=34823;   // HANGUL SYLLABLE
   sortTable[0xB3FC]=34824;   // HANGUL SYLLABLE
   sortTable[0xB3FD]=34825;   // HANGUL SYLLABLE
   sortTable[0xB3FE]=34826;   // HANGUL SYLLABLE
   sortTable[0xB3FF]=34827;   // HANGUL SYLLABLE
   sortTable[0xB400]=34828;   // HANGUL SYLLABLE
   sortTable[0xB401]=34829;   // HANGUL SYLLABLE
   sortTable[0xB402]=34830;   // HANGUL SYLLABLE
   sortTable[0xB403]=34831;   // HANGUL SYLLABLE
   sortTable[0xB404]=34832;   // HANGUL SYLLABLE
   sortTable[0xB405]=34833;   // HANGUL SYLLABLE
   sortTable[0xB406]=34834;   // HANGUL SYLLABLE
   sortTable[0xB407]=34835;   // HANGUL SYLLABLE
   sortTable[0xB408]=34836;   // HANGUL SYLLABLE
   sortTable[0xB409]=34837;   // HANGUL SYLLABLE
   sortTable[0xB40A]=34838;   // HANGUL SYLLABLE
   sortTable[0xB40B]=34839;   // HANGUL SYLLABLE
   sortTable[0xB40C]=34840;   // HANGUL SYLLABLE
   sortTable[0xB40D]=34841;   // HANGUL SYLLABLE
   sortTable[0xB40E]=34842;   // HANGUL SYLLABLE
   sortTable[0xB40F]=34843;   // HANGUL SYLLABLE
   sortTable[0xB410]=34844;   // HANGUL SYLLABLE
   sortTable[0xB411]=34845;   // HANGUL SYLLABLE
   sortTable[0xB412]=34846;   // HANGUL SYLLABLE
   sortTable[0xB413]=34847;   // HANGUL SYLLABLE
   sortTable[0xB414]=34848;   // HANGUL SYLLABLE
   sortTable[0xB415]=34849;   // HANGUL SYLLABLE
   sortTable[0xB416]=34850;   // HANGUL SYLLABLE
   sortTable[0xB417]=34851;   // HANGUL SYLLABLE
   sortTable[0xB418]=34852;   // HANGUL SYLLABLE
   sortTable[0xB419]=34853;   // HANGUL SYLLABLE
   sortTable[0xB41A]=34854;   // HANGUL SYLLABLE
   sortTable[0xB41B]=34855;   // HANGUL SYLLABLE
   sortTable[0xB41C]=34856;   // HANGUL SYLLABLE
   sortTable[0xB41D]=34857;   // HANGUL SYLLABLE
   sortTable[0xB41E]=34858;   // HANGUL SYLLABLE
   sortTable[0xB41F]=34859;   // HANGUL SYLLABLE
   sortTable[0xB420]=34860;   // HANGUL SYLLABLE
   sortTable[0xB421]=34861;   // HANGUL SYLLABLE
   sortTable[0xB422]=34862;   // HANGUL SYLLABLE
   sortTable[0xB423]=34863;   // HANGUL SYLLABLE
   sortTable[0xB424]=34864;   // HANGUL SYLLABLE
   sortTable[0xB425]=34865;   // HANGUL SYLLABLE
   sortTable[0xB426]=34866;   // HANGUL SYLLABLE
   sortTable[0xB427]=34867;   // HANGUL SYLLABLE
   sortTable[0xB428]=34868;   // HANGUL SYLLABLE
   sortTable[0xB429]=34869;   // HANGUL SYLLABLE
   sortTable[0xB42A]=34870;   // HANGUL SYLLABLE
   sortTable[0xB42B]=34871;   // HANGUL SYLLABLE
   sortTable[0xB42C]=34872;   // HANGUL SYLLABLE
   sortTable[0xB42D]=34873;   // HANGUL SYLLABLE
   sortTable[0xB42E]=34874;   // HANGUL SYLLABLE
   sortTable[0xB42F]=34875;   // HANGUL SYLLABLE
   sortTable[0xB430]=34876;   // HANGUL SYLLABLE
   sortTable[0xB431]=34877;   // HANGUL SYLLABLE
   sortTable[0xB432]=34878;   // HANGUL SYLLABLE
   sortTable[0xB433]=34879;   // HANGUL SYLLABLE
   sortTable[0xB434]=34880;   // HANGUL SYLLABLE
   sortTable[0xB435]=34881;   // HANGUL SYLLABLE
   sortTable[0xB436]=34882;   // HANGUL SYLLABLE
   sortTable[0xB437]=34883;   // HANGUL SYLLABLE
   sortTable[0xB438]=34884;   // HANGUL SYLLABLE
   sortTable[0xB439]=34885;   // HANGUL SYLLABLE
   sortTable[0xB43A]=34886;   // HANGUL SYLLABLE
   sortTable[0xB43B]=34887;   // HANGUL SYLLABLE
   sortTable[0xB43C]=34888;   // HANGUL SYLLABLE
   sortTable[0xB43D]=34889;   // HANGUL SYLLABLE
   sortTable[0xB43E]=34890;   // HANGUL SYLLABLE
   sortTable[0xB43F]=34891;   // HANGUL SYLLABLE
   sortTable[0xB440]=34892;   // HANGUL SYLLABLE
   sortTable[0xB441]=34893;   // HANGUL SYLLABLE
   sortTable[0xB442]=34894;   // HANGUL SYLLABLE
   sortTable[0xB443]=34895;   // HANGUL SYLLABLE
   sortTable[0xB444]=34896;   // HANGUL SYLLABLE
   sortTable[0xB445]=34897;   // HANGUL SYLLABLE
   sortTable[0xB446]=34898;   // HANGUL SYLLABLE
   sortTable[0xB447]=34899;   // HANGUL SYLLABLE
   sortTable[0xB448]=34900;   // HANGUL SYLLABLE
   sortTable[0xB449]=34901;   // HANGUL SYLLABLE
   sortTable[0xB44A]=34902;   // HANGUL SYLLABLE
   sortTable[0xB44B]=34903;   // HANGUL SYLLABLE
   sortTable[0xB44C]=34904;   // HANGUL SYLLABLE
   sortTable[0xB44D]=34905;   // HANGUL SYLLABLE
   sortTable[0xB44E]=34906;   // HANGUL SYLLABLE
   sortTable[0xB44F]=34907;   // HANGUL SYLLABLE
   sortTable[0xB450]=34908;   // HANGUL SYLLABLE
   sortTable[0xB451]=34909;   // HANGUL SYLLABLE
   sortTable[0xB452]=34910;   // HANGUL SYLLABLE
   sortTable[0xB453]=34911;   // HANGUL SYLLABLE
   sortTable[0xB454]=34912;   // HANGUL SYLLABLE
   sortTable[0xB455]=34913;   // HANGUL SYLLABLE
   sortTable[0xB456]=34914;   // HANGUL SYLLABLE
   sortTable[0xB457]=34915;   // HANGUL SYLLABLE
   sortTable[0xB458]=34916;   // HANGUL SYLLABLE
   sortTable[0xB459]=34917;   // HANGUL SYLLABLE
   sortTable[0xB45A]=34918;   // HANGUL SYLLABLE
   sortTable[0xB45B]=34919;   // HANGUL SYLLABLE
   sortTable[0xB45C]=34920;   // HANGUL SYLLABLE
   sortTable[0xB45D]=34921;   // HANGUL SYLLABLE
   sortTable[0xB45E]=34922;   // HANGUL SYLLABLE
   sortTable[0xB45F]=34923;   // HANGUL SYLLABLE
   sortTable[0xB460]=34924;   // HANGUL SYLLABLE
   sortTable[0xB461]=34925;   // HANGUL SYLLABLE
   sortTable[0xB462]=34926;   // HANGUL SYLLABLE
   sortTable[0xB463]=34927;   // HANGUL SYLLABLE
   sortTable[0xB464]=34928;   // HANGUL SYLLABLE
   sortTable[0xB465]=34929;   // HANGUL SYLLABLE
   sortTable[0xB466]=34930;   // HANGUL SYLLABLE
   sortTable[0xB467]=34931;   // HANGUL SYLLABLE
   sortTable[0xB468]=34932;   // HANGUL SYLLABLE
   sortTable[0xB469]=34933;   // HANGUL SYLLABLE
   sortTable[0xB46A]=34934;   // HANGUL SYLLABLE
   sortTable[0xB46B]=34935;   // HANGUL SYLLABLE
   sortTable[0xB46C]=34936;   // HANGUL SYLLABLE
   sortTable[0xB46D]=34937;   // HANGUL SYLLABLE
   sortTable[0xB46E]=34938;   // HANGUL SYLLABLE
   sortTable[0xB46F]=34939;   // HANGUL SYLLABLE
   sortTable[0xB470]=34940;   // HANGUL SYLLABLE
   sortTable[0xB471]=34941;   // HANGUL SYLLABLE
   sortTable[0xB472]=34942;   // HANGUL SYLLABLE
   sortTable[0xB473]=34943;   // HANGUL SYLLABLE
   sortTable[0xB474]=34944;   // HANGUL SYLLABLE
   sortTable[0xB475]=34945;   // HANGUL SYLLABLE
   sortTable[0xB476]=34946;   // HANGUL SYLLABLE
   sortTable[0xB477]=34947;   // HANGUL SYLLABLE
   sortTable[0xB478]=34948;   // HANGUL SYLLABLE
   sortTable[0xB479]=34949;   // HANGUL SYLLABLE
   sortTable[0xB47A]=34950;   // HANGUL SYLLABLE
   sortTable[0xB47B]=34951;   // HANGUL SYLLABLE
   sortTable[0xB47C]=34952;   // HANGUL SYLLABLE
   sortTable[0xB47D]=34953;   // HANGUL SYLLABLE
   sortTable[0xB47E]=34954;   // HANGUL SYLLABLE
   sortTable[0xB47F]=34955;   // HANGUL SYLLABLE
   sortTable[0xB480]=34956;   // HANGUL SYLLABLE
   sortTable[0xB481]=34957;   // HANGUL SYLLABLE
   sortTable[0xB482]=34958;   // HANGUL SYLLABLE
   sortTable[0xB483]=34959;   // HANGUL SYLLABLE
   sortTable[0xB484]=34960;   // HANGUL SYLLABLE
   sortTable[0xB485]=34961;   // HANGUL SYLLABLE
   sortTable[0xB486]=34962;   // HANGUL SYLLABLE
   sortTable[0xB487]=34963;   // HANGUL SYLLABLE
   sortTable[0xB488]=34964;   // HANGUL SYLLABLE
   sortTable[0xB489]=34965;   // HANGUL SYLLABLE
   sortTable[0xB48A]=34966;   // HANGUL SYLLABLE
   sortTable[0xB48B]=34967;   // HANGUL SYLLABLE
   sortTable[0xB48C]=34968;   // HANGUL SYLLABLE
   sortTable[0xB48D]=34969;   // HANGUL SYLLABLE
   sortTable[0xB48E]=34970;   // HANGUL SYLLABLE
   sortTable[0xB48F]=34971;   // HANGUL SYLLABLE
   sortTable[0xB490]=34972;   // HANGUL SYLLABLE
   sortTable[0xB491]=34973;   // HANGUL SYLLABLE
   sortTable[0xB492]=34974;   // HANGUL SYLLABLE
   sortTable[0xB493]=34975;   // HANGUL SYLLABLE
   sortTable[0xB494]=34976;   // HANGUL SYLLABLE
   sortTable[0xB495]=34977;   // HANGUL SYLLABLE
   sortTable[0xB496]=34978;   // HANGUL SYLLABLE
   sortTable[0xB497]=34979;   // HANGUL SYLLABLE
   sortTable[0xB498]=34980;   // HANGUL SYLLABLE
   sortTable[0xB499]=34981;   // HANGUL SYLLABLE
   sortTable[0xB49A]=34982;   // HANGUL SYLLABLE
   sortTable[0xB49B]=34983;   // HANGUL SYLLABLE
   sortTable[0xB49C]=34984;   // HANGUL SYLLABLE
   sortTable[0xB49D]=34985;   // HANGUL SYLLABLE
   sortTable[0xB49E]=34986;   // HANGUL SYLLABLE
   sortTable[0xB49F]=34987;   // HANGUL SYLLABLE
   sortTable[0xB4A0]=34988;   // HANGUL SYLLABLE
   sortTable[0xB4A1]=34989;   // HANGUL SYLLABLE
   sortTable[0xB4A2]=34990;   // HANGUL SYLLABLE
   sortTable[0xB4A3]=34991;   // HANGUL SYLLABLE
   sortTable[0xB4A4]=34992;   // HANGUL SYLLABLE
   sortTable[0xB4A5]=34993;   // HANGUL SYLLABLE
   sortTable[0xB4A6]=34994;   // HANGUL SYLLABLE
   sortTable[0xB4A7]=34995;   // HANGUL SYLLABLE
   sortTable[0xB4A8]=34996;   // HANGUL SYLLABLE
   sortTable[0xB4A9]=34997;   // HANGUL SYLLABLE
   sortTable[0xB4AA]=34998;   // HANGUL SYLLABLE
   sortTable[0xB4AB]=34999;   // HANGUL SYLLABLE
   sortTable[0xB4AC]=35000;   // HANGUL SYLLABLE
   sortTable[0xB4AD]=35001;   // HANGUL SYLLABLE
   sortTable[0xB4AE]=35002;   // HANGUL SYLLABLE
   sortTable[0xB4AF]=35003;   // HANGUL SYLLABLE
   sortTable[0xB4B0]=35004;   // HANGUL SYLLABLE
   sortTable[0xB4B1]=35005;   // HANGUL SYLLABLE
   sortTable[0xB4B2]=35006;   // HANGUL SYLLABLE
   sortTable[0xB4B3]=35007;   // HANGUL SYLLABLE
   sortTable[0xB4B4]=35008;   // HANGUL SYLLABLE
   sortTable[0xB4B5]=35009;   // HANGUL SYLLABLE
   sortTable[0xB4B6]=35010;   // HANGUL SYLLABLE
   sortTable[0xB4B7]=35011;   // HANGUL SYLLABLE
   sortTable[0xB4B8]=35012;   // HANGUL SYLLABLE
   sortTable[0xB4B9]=35013;   // HANGUL SYLLABLE
   sortTable[0xB4BA]=35014;   // HANGUL SYLLABLE
   sortTable[0xB4BB]=35015;   // HANGUL SYLLABLE
   sortTable[0xB4BC]=35016;   // HANGUL SYLLABLE
   sortTable[0xB4BD]=35017;   // HANGUL SYLLABLE
   sortTable[0xB4BE]=35018;   // HANGUL SYLLABLE
   sortTable[0xB4BF]=35019;   // HANGUL SYLLABLE
   sortTable[0xB4C0]=35020;   // HANGUL SYLLABLE
   sortTable[0xB4C1]=35021;   // HANGUL SYLLABLE
   sortTable[0xB4C2]=35022;   // HANGUL SYLLABLE
   sortTable[0xB4C3]=35023;   // HANGUL SYLLABLE
   sortTable[0xB4C4]=35024;   // HANGUL SYLLABLE
   sortTable[0xB4C5]=35025;   // HANGUL SYLLABLE
   sortTable[0xB4C6]=35026;   // HANGUL SYLLABLE
   sortTable[0xB4C7]=35027;   // HANGUL SYLLABLE
   sortTable[0xB4C8]=35028;   // HANGUL SYLLABLE
   sortTable[0xB4C9]=35029;   // HANGUL SYLLABLE
   sortTable[0xB4CA]=35030;   // HANGUL SYLLABLE
   sortTable[0xB4CB]=35031;   // HANGUL SYLLABLE
   sortTable[0xB4CC]=35032;   // HANGUL SYLLABLE
   sortTable[0xB4CD]=35033;   // HANGUL SYLLABLE
   sortTable[0xB4CE]=35034;   // HANGUL SYLLABLE
   sortTable[0xB4CF]=35035;   // HANGUL SYLLABLE
   sortTable[0xB4D0]=35036;   // HANGUL SYLLABLE
   sortTable[0xB4D1]=35037;   // HANGUL SYLLABLE
   sortTable[0xB4D2]=35038;   // HANGUL SYLLABLE
   sortTable[0xB4D3]=35039;   // HANGUL SYLLABLE
   sortTable[0xB4D4]=35040;   // HANGUL SYLLABLE
   sortTable[0xB4D5]=35041;   // HANGUL SYLLABLE
   sortTable[0xB4D6]=35042;   // HANGUL SYLLABLE
   sortTable[0xB4D7]=35043;   // HANGUL SYLLABLE
   sortTable[0xB4D8]=35044;   // HANGUL SYLLABLE
   sortTable[0xB4D9]=35045;   // HANGUL SYLLABLE
   sortTable[0xB4DA]=35046;   // HANGUL SYLLABLE
   sortTable[0xB4DB]=35047;   // HANGUL SYLLABLE
   sortTable[0xB4DC]=35048;   // HANGUL SYLLABLE
   sortTable[0xB4DD]=35049;   // HANGUL SYLLABLE
   sortTable[0xB4DE]=35050;   // HANGUL SYLLABLE
   sortTable[0xB4DF]=35051;   // HANGUL SYLLABLE
   sortTable[0xB4E0]=35052;   // HANGUL SYLLABLE
   sortTable[0xB4E1]=35053;   // HANGUL SYLLABLE
   sortTable[0xB4E2]=35054;   // HANGUL SYLLABLE
   sortTable[0xB4E3]=35055;   // HANGUL SYLLABLE
   sortTable[0xB4E4]=35056;   // HANGUL SYLLABLE
   sortTable[0xB4E5]=35057;   // HANGUL SYLLABLE
   sortTable[0xB4E6]=35058;   // HANGUL SYLLABLE
   sortTable[0xB4E7]=35059;   // HANGUL SYLLABLE
   sortTable[0xB4E8]=35060;   // HANGUL SYLLABLE
   sortTable[0xB4E9]=35061;   // HANGUL SYLLABLE
   sortTable[0xB4EA]=35062;   // HANGUL SYLLABLE
   sortTable[0xB4EB]=35063;   // HANGUL SYLLABLE
   sortTable[0xB4EC]=35064;   // HANGUL SYLLABLE
   sortTable[0xB4ED]=35065;   // HANGUL SYLLABLE
   sortTable[0xB4EE]=35066;   // HANGUL SYLLABLE
   sortTable[0xB4EF]=35067;   // HANGUL SYLLABLE
   sortTable[0xB4F0]=35068;   // HANGUL SYLLABLE
   sortTable[0xB4F1]=35069;   // HANGUL SYLLABLE
   sortTable[0xB4F2]=35070;   // HANGUL SYLLABLE
   sortTable[0xB4F3]=35071;   // HANGUL SYLLABLE
   sortTable[0xB4F4]=35072;   // HANGUL SYLLABLE
   sortTable[0xB4F5]=35073;   // HANGUL SYLLABLE
   sortTable[0xB4F6]=35074;   // HANGUL SYLLABLE
   sortTable[0xB4F7]=35075;   // HANGUL SYLLABLE
   sortTable[0xB4F8]=35076;   // HANGUL SYLLABLE
   sortTable[0xB4F9]=35077;   // HANGUL SYLLABLE
   sortTable[0xB4FA]=35078;   // HANGUL SYLLABLE
   sortTable[0xB4FB]=35079;   // HANGUL SYLLABLE
   sortTable[0xB4FC]=35080;   // HANGUL SYLLABLE
   sortTable[0xB4FD]=35081;   // HANGUL SYLLABLE
   sortTable[0xB4FE]=35082;   // HANGUL SYLLABLE
   sortTable[0xB4FF]=35083;   // HANGUL SYLLABLE
   sortTable[0xB500]=35084;   // HANGUL SYLLABLE
   sortTable[0xB501]=35085;   // HANGUL SYLLABLE
   sortTable[0xB502]=35086;   // HANGUL SYLLABLE
   sortTable[0xB503]=35087;   // HANGUL SYLLABLE
   sortTable[0xB504]=35088;   // HANGUL SYLLABLE
   sortTable[0xB505]=35089;   // HANGUL SYLLABLE
   sortTable[0xB506]=35090;   // HANGUL SYLLABLE
   sortTable[0xB507]=35091;   // HANGUL SYLLABLE
   sortTable[0xB508]=35092;   // HANGUL SYLLABLE
   sortTable[0xB509]=35093;   // HANGUL SYLLABLE
   sortTable[0xB50A]=35094;   // HANGUL SYLLABLE
   sortTable[0xB50B]=35095;   // HANGUL SYLLABLE
   sortTable[0xB50C]=35096;   // HANGUL SYLLABLE
   sortTable[0xB50D]=35097;   // HANGUL SYLLABLE
   sortTable[0xB50E]=35098;   // HANGUL SYLLABLE
   sortTable[0xB50F]=35099;   // HANGUL SYLLABLE
   sortTable[0xB510]=35100;   // HANGUL SYLLABLE
   sortTable[0xB511]=35101;   // HANGUL SYLLABLE
   sortTable[0xB512]=35102;   // HANGUL SYLLABLE
   sortTable[0xB513]=35103;   // HANGUL SYLLABLE
   sortTable[0xB514]=35104;   // HANGUL SYLLABLE
   sortTable[0xB515]=35105;   // HANGUL SYLLABLE
   sortTable[0xB516]=35106;   // HANGUL SYLLABLE
   sortTable[0xB517]=35107;   // HANGUL SYLLABLE
   sortTable[0xB518]=35108;   // HANGUL SYLLABLE
   sortTable[0xB519]=35109;   // HANGUL SYLLABLE
   sortTable[0xB51A]=35110;   // HANGUL SYLLABLE
   sortTable[0xB51B]=35111;   // HANGUL SYLLABLE
   sortTable[0xB51C]=35112;   // HANGUL SYLLABLE
   sortTable[0xB51D]=35113;   // HANGUL SYLLABLE
   sortTable[0xB51E]=35114;   // HANGUL SYLLABLE
   sortTable[0xB51F]=35115;   // HANGUL SYLLABLE
   sortTable[0xB520]=35116;   // HANGUL SYLLABLE
   sortTable[0xB521]=35117;   // HANGUL SYLLABLE
   sortTable[0xB522]=35118;   // HANGUL SYLLABLE
   sortTable[0xB523]=35119;   // HANGUL SYLLABLE
   sortTable[0xB524]=35120;   // HANGUL SYLLABLE
   sortTable[0xB525]=35121;   // HANGUL SYLLABLE
   sortTable[0xB526]=35122;   // HANGUL SYLLABLE
   sortTable[0xB527]=35123;   // HANGUL SYLLABLE
   sortTable[0xB528]=35124;   // HANGUL SYLLABLE
   sortTable[0xB529]=35125;   // HANGUL SYLLABLE
   sortTable[0xB52A]=35126;   // HANGUL SYLLABLE
   sortTable[0xB52B]=35127;   // HANGUL SYLLABLE
   sortTable[0xB52C]=35128;   // HANGUL SYLLABLE
   sortTable[0xB52D]=35129;   // HANGUL SYLLABLE
   sortTable[0xB52E]=35130;   // HANGUL SYLLABLE
   sortTable[0xB52F]=35131;   // HANGUL SYLLABLE
   sortTable[0x3138]=35132;   // HANGUL LETTER SSANGTIKEUT
   sortTable[0x1104]=35133;   // HANGUL CHOSEONG SSANGTIKEUT
   sortTable[0xB530]=35134;   // HANGUL SYLLABLE
   sortTable[0xB531]=35135;   // HANGUL SYLLABLE
   sortTable[0xB532]=35136;   // HANGUL SYLLABLE
   sortTable[0xB533]=35137;   // HANGUL SYLLABLE
   sortTable[0xB534]=35138;   // HANGUL SYLLABLE
   sortTable[0xB535]=35139;   // HANGUL SYLLABLE
   sortTable[0xB536]=35140;   // HANGUL SYLLABLE
   sortTable[0xB537]=35141;   // HANGUL SYLLABLE
   sortTable[0xB538]=35142;   // HANGUL SYLLABLE
   sortTable[0xB539]=35143;   // HANGUL SYLLABLE
   sortTable[0xB53A]=35144;   // HANGUL SYLLABLE
   sortTable[0xB53B]=35145;   // HANGUL SYLLABLE
   sortTable[0xB53C]=35146;   // HANGUL SYLLABLE
   sortTable[0xB53D]=35147;   // HANGUL SYLLABLE
   sortTable[0xB53E]=35148;   // HANGUL SYLLABLE
   sortTable[0xB53F]=35149;   // HANGUL SYLLABLE
   sortTable[0xB540]=35150;   // HANGUL SYLLABLE
   sortTable[0xB541]=35151;   // HANGUL SYLLABLE
   sortTable[0xB542]=35152;   // HANGUL SYLLABLE
   sortTable[0xB543]=35153;   // HANGUL SYLLABLE
   sortTable[0xB544]=35154;   // HANGUL SYLLABLE
   sortTable[0xB545]=35155;   // HANGUL SYLLABLE
   sortTable[0xB546]=35156;   // HANGUL SYLLABLE
   sortTable[0xB547]=35157;   // HANGUL SYLLABLE
   sortTable[0xB548]=35158;   // HANGUL SYLLABLE
   sortTable[0xB549]=35159;   // HANGUL SYLLABLE
   sortTable[0xB54A]=35160;   // HANGUL SYLLABLE
   sortTable[0xB54B]=35161;   // HANGUL SYLLABLE
   sortTable[0xB54C]=35162;   // HANGUL SYLLABLE
   sortTable[0xB54D]=35163;   // HANGUL SYLLABLE
   sortTable[0xB54E]=35164;   // HANGUL SYLLABLE
   sortTable[0xB54F]=35165;   // HANGUL SYLLABLE
   sortTable[0xB550]=35166;   // HANGUL SYLLABLE
   sortTable[0xB551]=35167;   // HANGUL SYLLABLE
   sortTable[0xB552]=35168;   // HANGUL SYLLABLE
   sortTable[0xB553]=35169;   // HANGUL SYLLABLE
   sortTable[0xB554]=35170;   // HANGUL SYLLABLE
   sortTable[0xB555]=35171;   // HANGUL SYLLABLE
   sortTable[0xB556]=35172;   // HANGUL SYLLABLE
   sortTable[0xB557]=35173;   // HANGUL SYLLABLE
   sortTable[0xB558]=35174;   // HANGUL SYLLABLE
   sortTable[0xB559]=35175;   // HANGUL SYLLABLE
   sortTable[0xB55A]=35176;   // HANGUL SYLLABLE
   sortTable[0xB55B]=35177;   // HANGUL SYLLABLE
   sortTable[0xB55C]=35178;   // HANGUL SYLLABLE
   sortTable[0xB55D]=35179;   // HANGUL SYLLABLE
   sortTable[0xB55E]=35180;   // HANGUL SYLLABLE
   sortTable[0xB55F]=35181;   // HANGUL SYLLABLE
   sortTable[0xB560]=35182;   // HANGUL SYLLABLE
   sortTable[0xB561]=35183;   // HANGUL SYLLABLE
   sortTable[0xB562]=35184;   // HANGUL SYLLABLE
   sortTable[0xB563]=35185;   // HANGUL SYLLABLE
   sortTable[0xB564]=35186;   // HANGUL SYLLABLE
   sortTable[0xB565]=35187;   // HANGUL SYLLABLE
   sortTable[0xB566]=35188;   // HANGUL SYLLABLE
   sortTable[0xB567]=35189;   // HANGUL SYLLABLE
   sortTable[0xB568]=35190;   // HANGUL SYLLABLE
   sortTable[0xB569]=35191;   // HANGUL SYLLABLE
   sortTable[0xB56A]=35192;   // HANGUL SYLLABLE
   sortTable[0xB56B]=35193;   // HANGUL SYLLABLE
   sortTable[0xB56C]=35194;   // HANGUL SYLLABLE
   sortTable[0xB56D]=35195;   // HANGUL SYLLABLE
   sortTable[0xB56E]=35196;   // HANGUL SYLLABLE
   sortTable[0xB56F]=35197;   // HANGUL SYLLABLE
   sortTable[0xB570]=35198;   // HANGUL SYLLABLE
   sortTable[0xB571]=35199;   // HANGUL SYLLABLE
   sortTable[0xB572]=35200;   // HANGUL SYLLABLE
   sortTable[0xB573]=35201;   // HANGUL SYLLABLE
   sortTable[0xB574]=35202;   // HANGUL SYLLABLE
   sortTable[0xB575]=35203;   // HANGUL SYLLABLE
   sortTable[0xB576]=35204;   // HANGUL SYLLABLE
   sortTable[0xB577]=35205;   // HANGUL SYLLABLE
   sortTable[0xB578]=35206;   // HANGUL SYLLABLE
   sortTable[0xB579]=35207;   // HANGUL SYLLABLE
   sortTable[0xB57A]=35208;   // HANGUL SYLLABLE
   sortTable[0xB57B]=35209;   // HANGUL SYLLABLE
   sortTable[0xB57C]=35210;   // HANGUL SYLLABLE
   sortTable[0xB57D]=35211;   // HANGUL SYLLABLE
   sortTable[0xB57E]=35212;   // HANGUL SYLLABLE
   sortTable[0xB57F]=35213;   // HANGUL SYLLABLE
   sortTable[0xB580]=35214;   // HANGUL SYLLABLE
   sortTable[0xB581]=35215;   // HANGUL SYLLABLE
   sortTable[0xB582]=35216;   // HANGUL SYLLABLE
   sortTable[0xB583]=35217;   // HANGUL SYLLABLE
   sortTable[0xB584]=35218;   // HANGUL SYLLABLE
   sortTable[0xB585]=35219;   // HANGUL SYLLABLE
   sortTable[0xB586]=35220;   // HANGUL SYLLABLE
   sortTable[0xB587]=35221;   // HANGUL SYLLABLE
   sortTable[0xB588]=35222;   // HANGUL SYLLABLE
   sortTable[0xB589]=35223;   // HANGUL SYLLABLE
   sortTable[0xB58A]=35224;   // HANGUL SYLLABLE
   sortTable[0xB58B]=35225;   // HANGUL SYLLABLE
   sortTable[0xB58C]=35226;   // HANGUL SYLLABLE
   sortTable[0xB58D]=35227;   // HANGUL SYLLABLE
   sortTable[0xB58E]=35228;   // HANGUL SYLLABLE
   sortTable[0xB58F]=35229;   // HANGUL SYLLABLE
   sortTable[0xB590]=35230;   // HANGUL SYLLABLE
   sortTable[0xB591]=35231;   // HANGUL SYLLABLE
   sortTable[0xB592]=35232;   // HANGUL SYLLABLE
   sortTable[0xB593]=35233;   // HANGUL SYLLABLE
   sortTable[0xB594]=35234;   // HANGUL SYLLABLE
   sortTable[0xB595]=35235;   // HANGUL SYLLABLE
   sortTable[0xB596]=35236;   // HANGUL SYLLABLE
   sortTable[0xB597]=35237;   // HANGUL SYLLABLE
   sortTable[0xB598]=35238;   // HANGUL SYLLABLE
   sortTable[0xB599]=35239;   // HANGUL SYLLABLE
   sortTable[0xB59A]=35240;   // HANGUL SYLLABLE
   sortTable[0xB59B]=35241;   // HANGUL SYLLABLE
   sortTable[0xB59C]=35242;   // HANGUL SYLLABLE
   sortTable[0xB59D]=35243;   // HANGUL SYLLABLE
   sortTable[0xB59E]=35244;   // HANGUL SYLLABLE
   sortTable[0xB59F]=35245;   // HANGUL SYLLABLE
   sortTable[0xB5A0]=35246;   // HANGUL SYLLABLE
   sortTable[0xB5A1]=35247;   // HANGUL SYLLABLE
   sortTable[0xB5A2]=35248;   // HANGUL SYLLABLE
   sortTable[0xB5A3]=35249;   // HANGUL SYLLABLE
   sortTable[0xB5A4]=35250;   // HANGUL SYLLABLE
   sortTable[0xB5A5]=35251;   // HANGUL SYLLABLE
   sortTable[0xB5A6]=35252;   // HANGUL SYLLABLE
   sortTable[0xB5A7]=35253;   // HANGUL SYLLABLE
   sortTable[0xB5A8]=35254;   // HANGUL SYLLABLE
   sortTable[0xB5A9]=35255;   // HANGUL SYLLABLE
   sortTable[0xB5AA]=35256;   // HANGUL SYLLABLE
   sortTable[0xB5AB]=35257;   // HANGUL SYLLABLE
   sortTable[0xB5AC]=35258;   // HANGUL SYLLABLE
   sortTable[0xB5AD]=35259;   // HANGUL SYLLABLE
   sortTable[0xB5AE]=35260;   // HANGUL SYLLABLE
   sortTable[0xB5AF]=35261;   // HANGUL SYLLABLE
   sortTable[0xB5B0]=35262;   // HANGUL SYLLABLE
   sortTable[0xB5B1]=35263;   // HANGUL SYLLABLE
   sortTable[0xB5B2]=35264;   // HANGUL SYLLABLE
   sortTable[0xB5B3]=35265;   // HANGUL SYLLABLE
   sortTable[0xB5B4]=35266;   // HANGUL SYLLABLE
   sortTable[0xB5B5]=35267;   // HANGUL SYLLABLE
   sortTable[0xB5B6]=35268;   // HANGUL SYLLABLE
   sortTable[0xB5B7]=35269;   // HANGUL SYLLABLE
   sortTable[0xB5B8]=35270;   // HANGUL SYLLABLE
   sortTable[0xB5B9]=35271;   // HANGUL SYLLABLE
   sortTable[0xB5BA]=35272;   // HANGUL SYLLABLE
   sortTable[0xB5BB]=35273;   // HANGUL SYLLABLE
   sortTable[0xB5BC]=35274;   // HANGUL SYLLABLE
   sortTable[0xB5BD]=35275;   // HANGUL SYLLABLE
   sortTable[0xB5BE]=35276;   // HANGUL SYLLABLE
   sortTable[0xB5BF]=35277;   // HANGUL SYLLABLE
   sortTable[0xB5C0]=35278;   // HANGUL SYLLABLE
   sortTable[0xB5C1]=35279;   // HANGUL SYLLABLE
   sortTable[0xB5C2]=35280;   // HANGUL SYLLABLE
   sortTable[0xB5C3]=35281;   // HANGUL SYLLABLE
   sortTable[0xB5C4]=35282;   // HANGUL SYLLABLE
   sortTable[0xB5C5]=35283;   // HANGUL SYLLABLE
   sortTable[0xB5C6]=35284;   // HANGUL SYLLABLE
   sortTable[0xB5C7]=35285;   // HANGUL SYLLABLE
   sortTable[0xB5C8]=35286;   // HANGUL SYLLABLE
   sortTable[0xB5C9]=35287;   // HANGUL SYLLABLE
   sortTable[0xB5CA]=35288;   // HANGUL SYLLABLE
   sortTable[0xB5CB]=35289;   // HANGUL SYLLABLE
   sortTable[0xB5CC]=35290;   // HANGUL SYLLABLE
   sortTable[0xB5CD]=35291;   // HANGUL SYLLABLE
   sortTable[0xB5CE]=35292;   // HANGUL SYLLABLE
   sortTable[0xB5CF]=35293;   // HANGUL SYLLABLE
   sortTable[0xB5D0]=35294;   // HANGUL SYLLABLE
   sortTable[0xB5D1]=35295;   // HANGUL SYLLABLE
   sortTable[0xB5D2]=35296;   // HANGUL SYLLABLE
   sortTable[0xB5D3]=35297;   // HANGUL SYLLABLE
   sortTable[0xB5D4]=35298;   // HANGUL SYLLABLE
   sortTable[0xB5D5]=35299;   // HANGUL SYLLABLE
   sortTable[0xB5D6]=35300;   // HANGUL SYLLABLE
   sortTable[0xB5D7]=35301;   // HANGUL SYLLABLE
   sortTable[0xB5D8]=35302;   // HANGUL SYLLABLE
   sortTable[0xB5D9]=35303;   // HANGUL SYLLABLE
   sortTable[0xB5DA]=35304;   // HANGUL SYLLABLE
   sortTable[0xB5DB]=35305;   // HANGUL SYLLABLE
   sortTable[0xB5DC]=35306;   // HANGUL SYLLABLE
   sortTable[0xB5DD]=35307;   // HANGUL SYLLABLE
   sortTable[0xB5DE]=35308;   // HANGUL SYLLABLE
   sortTable[0xB5DF]=35309;   // HANGUL SYLLABLE
   sortTable[0xB5E0]=35310;   // HANGUL SYLLABLE
   sortTable[0xB5E1]=35311;   // HANGUL SYLLABLE
   sortTable[0xB5E2]=35312;   // HANGUL SYLLABLE
   sortTable[0xB5E3]=35313;   // HANGUL SYLLABLE
   sortTable[0xB5E4]=35314;   // HANGUL SYLLABLE
   sortTable[0xB5E5]=35315;   // HANGUL SYLLABLE
   sortTable[0xB5E6]=35316;   // HANGUL SYLLABLE
   sortTable[0xB5E7]=35317;   // HANGUL SYLLABLE
   sortTable[0xB5E8]=35318;   // HANGUL SYLLABLE
   sortTable[0xB5E9]=35319;   // HANGUL SYLLABLE
   sortTable[0xB5EA]=35320;   // HANGUL SYLLABLE
   sortTable[0xB5EB]=35321;   // HANGUL SYLLABLE
   sortTable[0xB5EC]=35322;   // HANGUL SYLLABLE
   sortTable[0xB5ED]=35323;   // HANGUL SYLLABLE
   sortTable[0xB5EE]=35324;   // HANGUL SYLLABLE
   sortTable[0xB5EF]=35325;   // HANGUL SYLLABLE
   sortTable[0xB5F0]=35326;   // HANGUL SYLLABLE
   sortTable[0xB5F1]=35327;   // HANGUL SYLLABLE
   sortTable[0xB5F2]=35328;   // HANGUL SYLLABLE
   sortTable[0xB5F3]=35329;   // HANGUL SYLLABLE
   sortTable[0xB5F4]=35330;   // HANGUL SYLLABLE
   sortTable[0xB5F5]=35331;   // HANGUL SYLLABLE
   sortTable[0xB5F6]=35332;   // HANGUL SYLLABLE
   sortTable[0xB5F7]=35333;   // HANGUL SYLLABLE
   sortTable[0xB5F8]=35334;   // HANGUL SYLLABLE
   sortTable[0xB5F9]=35335;   // HANGUL SYLLABLE
   sortTable[0xB5FA]=35336;   // HANGUL SYLLABLE
   sortTable[0xB5FB]=35337;   // HANGUL SYLLABLE
   sortTable[0xB5FC]=35338;   // HANGUL SYLLABLE
   sortTable[0xB5FD]=35339;   // HANGUL SYLLABLE
   sortTable[0xB5FE]=35340;   // HANGUL SYLLABLE
   sortTable[0xB5FF]=35341;   // HANGUL SYLLABLE
   sortTable[0xB600]=35342;   // HANGUL SYLLABLE
   sortTable[0xB601]=35343;   // HANGUL SYLLABLE
   sortTable[0xB602]=35344;   // HANGUL SYLLABLE
   sortTable[0xB603]=35345;   // HANGUL SYLLABLE
   sortTable[0xB604]=35346;   // HANGUL SYLLABLE
   sortTable[0xB605]=35347;   // HANGUL SYLLABLE
   sortTable[0xB606]=35348;   // HANGUL SYLLABLE
   sortTable[0xB607]=35349;   // HANGUL SYLLABLE
   sortTable[0xB608]=35350;   // HANGUL SYLLABLE
   sortTable[0xB609]=35351;   // HANGUL SYLLABLE
   sortTable[0xB60A]=35352;   // HANGUL SYLLABLE
   sortTable[0xB60B]=35353;   // HANGUL SYLLABLE
   sortTable[0xB60C]=35354;   // HANGUL SYLLABLE
   sortTable[0xB60D]=35355;   // HANGUL SYLLABLE
   sortTable[0xB60E]=35356;   // HANGUL SYLLABLE
   sortTable[0xB60F]=35357;   // HANGUL SYLLABLE
   sortTable[0xB610]=35358;   // HANGUL SYLLABLE
   sortTable[0xB611]=35359;   // HANGUL SYLLABLE
   sortTable[0xB612]=35360;   // HANGUL SYLLABLE
   sortTable[0xB613]=35361;   // HANGUL SYLLABLE
   sortTable[0xB614]=35362;   // HANGUL SYLLABLE
   sortTable[0xB615]=35363;   // HANGUL SYLLABLE
   sortTable[0xB616]=35364;   // HANGUL SYLLABLE
   sortTable[0xB617]=35365;   // HANGUL SYLLABLE
   sortTable[0xB618]=35366;   // HANGUL SYLLABLE
   sortTable[0xB619]=35367;   // HANGUL SYLLABLE
   sortTable[0xB61A]=35368;   // HANGUL SYLLABLE
   sortTable[0xB61B]=35369;   // HANGUL SYLLABLE
   sortTable[0xB61C]=35370;   // HANGUL SYLLABLE
   sortTable[0xB61D]=35371;   // HANGUL SYLLABLE
   sortTable[0xB61E]=35372;   // HANGUL SYLLABLE
   sortTable[0xB61F]=35373;   // HANGUL SYLLABLE
   sortTable[0xB620]=35374;   // HANGUL SYLLABLE
   sortTable[0xB621]=35375;   // HANGUL SYLLABLE
   sortTable[0xB622]=35376;   // HANGUL SYLLABLE
   sortTable[0xB623]=35377;   // HANGUL SYLLABLE
   sortTable[0xB624]=35378;   // HANGUL SYLLABLE
   sortTable[0xB625]=35379;   // HANGUL SYLLABLE
   sortTable[0xB626]=35380;   // HANGUL SYLLABLE
   sortTable[0xB627]=35381;   // HANGUL SYLLABLE
   sortTable[0xB628]=35382;   // HANGUL SYLLABLE
   sortTable[0xB629]=35383;   // HANGUL SYLLABLE
   sortTable[0xB62A]=35384;   // HANGUL SYLLABLE
   sortTable[0xB62B]=35385;   // HANGUL SYLLABLE
   sortTable[0xB62C]=35386;   // HANGUL SYLLABLE
   sortTable[0xB62D]=35387;   // HANGUL SYLLABLE
   sortTable[0xB62E]=35388;   // HANGUL SYLLABLE
   sortTable[0xB62F]=35389;   // HANGUL SYLLABLE
   sortTable[0xB630]=35390;   // HANGUL SYLLABLE
   sortTable[0xB631]=35391;   // HANGUL SYLLABLE
   sortTable[0xB632]=35392;   // HANGUL SYLLABLE
   sortTable[0xB633]=35393;   // HANGUL SYLLABLE
   sortTable[0xB634]=35394;   // HANGUL SYLLABLE
   sortTable[0xB635]=35395;   // HANGUL SYLLABLE
   sortTable[0xB636]=35396;   // HANGUL SYLLABLE
   sortTable[0xB637]=35397;   // HANGUL SYLLABLE
   sortTable[0xB638]=35398;   // HANGUL SYLLABLE
   sortTable[0xB639]=35399;   // HANGUL SYLLABLE
   sortTable[0xB63A]=35400;   // HANGUL SYLLABLE
   sortTable[0xB63B]=35401;   // HANGUL SYLLABLE
   sortTable[0xB63C]=35402;   // HANGUL SYLLABLE
   sortTable[0xB63D]=35403;   // HANGUL SYLLABLE
   sortTable[0xB63E]=35404;   // HANGUL SYLLABLE
   sortTable[0xB63F]=35405;   // HANGUL SYLLABLE
   sortTable[0xB640]=35406;   // HANGUL SYLLABLE
   sortTable[0xB641]=35407;   // HANGUL SYLLABLE
   sortTable[0xB642]=35408;   // HANGUL SYLLABLE
   sortTable[0xB643]=35409;   // HANGUL SYLLABLE
   sortTable[0xB644]=35410;   // HANGUL SYLLABLE
   sortTable[0xB645]=35411;   // HANGUL SYLLABLE
   sortTable[0xB646]=35412;   // HANGUL SYLLABLE
   sortTable[0xB647]=35413;   // HANGUL SYLLABLE
   sortTable[0xB648]=35414;   // HANGUL SYLLABLE
   sortTable[0xB649]=35415;   // HANGUL SYLLABLE
   sortTable[0xB64A]=35416;   // HANGUL SYLLABLE
   sortTable[0xB64B]=35417;   // HANGUL SYLLABLE
   sortTable[0xB64C]=35418;   // HANGUL SYLLABLE
   sortTable[0xB64D]=35419;   // HANGUL SYLLABLE
   sortTable[0xB64E]=35420;   // HANGUL SYLLABLE
   sortTable[0xB64F]=35421;   // HANGUL SYLLABLE
   sortTable[0xB650]=35422;   // HANGUL SYLLABLE
   sortTable[0xB651]=35423;   // HANGUL SYLLABLE
   sortTable[0xB652]=35424;   // HANGUL SYLLABLE
   sortTable[0xB653]=35425;   // HANGUL SYLLABLE
   sortTable[0xB654]=35426;   // HANGUL SYLLABLE
   sortTable[0xB655]=35427;   // HANGUL SYLLABLE
   sortTable[0xB656]=35428;   // HANGUL SYLLABLE
   sortTable[0xB657]=35429;   // HANGUL SYLLABLE
   sortTable[0xB658]=35430;   // HANGUL SYLLABLE
   sortTable[0xB659]=35431;   // HANGUL SYLLABLE
   sortTable[0xB65A]=35432;   // HANGUL SYLLABLE
   sortTable[0xB65B]=35433;   // HANGUL SYLLABLE
   sortTable[0xB65C]=35434;   // HANGUL SYLLABLE
   sortTable[0xB65D]=35435;   // HANGUL SYLLABLE
   sortTable[0xB65E]=35436;   // HANGUL SYLLABLE
   sortTable[0xB65F]=35437;   // HANGUL SYLLABLE
   sortTable[0xB660]=35438;   // HANGUL SYLLABLE
   sortTable[0xB661]=35439;   // HANGUL SYLLABLE
   sortTable[0xB662]=35440;   // HANGUL SYLLABLE
   sortTable[0xB663]=35441;   // HANGUL SYLLABLE
   sortTable[0xB664]=35442;   // HANGUL SYLLABLE
   sortTable[0xB665]=35443;   // HANGUL SYLLABLE
   sortTable[0xB666]=35444;   // HANGUL SYLLABLE
   sortTable[0xB667]=35445;   // HANGUL SYLLABLE
   sortTable[0xB668]=35446;   // HANGUL SYLLABLE
   sortTable[0xB669]=35447;   // HANGUL SYLLABLE
   sortTable[0xB66A]=35448;   // HANGUL SYLLABLE
   sortTable[0xB66B]=35449;   // HANGUL SYLLABLE
   sortTable[0xB66C]=35450;   // HANGUL SYLLABLE
   sortTable[0xB66D]=35451;   // HANGUL SYLLABLE
   sortTable[0xB66E]=35452;   // HANGUL SYLLABLE
   sortTable[0xB66F]=35453;   // HANGUL SYLLABLE
   sortTable[0xB670]=35454;   // HANGUL SYLLABLE
   sortTable[0xB671]=35455;   // HANGUL SYLLABLE
   sortTable[0xB672]=35456;   // HANGUL SYLLABLE
   sortTable[0xB673]=35457;   // HANGUL SYLLABLE
   sortTable[0xB674]=35458;   // HANGUL SYLLABLE
   sortTable[0xB675]=35459;   // HANGUL SYLLABLE
   sortTable[0xB676]=35460;   // HANGUL SYLLABLE
   sortTable[0xB677]=35461;   // HANGUL SYLLABLE
   sortTable[0xB678]=35462;   // HANGUL SYLLABLE
   sortTable[0xB679]=35463;   // HANGUL SYLLABLE
   sortTable[0xB67A]=35464;   // HANGUL SYLLABLE
   sortTable[0xB67B]=35465;   // HANGUL SYLLABLE
   sortTable[0xB67C]=35466;   // HANGUL SYLLABLE
   sortTable[0xB67D]=35467;   // HANGUL SYLLABLE
   sortTable[0xB67E]=35468;   // HANGUL SYLLABLE
   sortTable[0xB67F]=35469;   // HANGUL SYLLABLE
   sortTable[0xB680]=35470;   // HANGUL SYLLABLE
   sortTable[0xB681]=35471;   // HANGUL SYLLABLE
   sortTable[0xB682]=35472;   // HANGUL SYLLABLE
   sortTable[0xB683]=35473;   // HANGUL SYLLABLE
   sortTable[0xB684]=35474;   // HANGUL SYLLABLE
   sortTable[0xB685]=35475;   // HANGUL SYLLABLE
   sortTable[0xB686]=35476;   // HANGUL SYLLABLE
   sortTable[0xB687]=35477;   // HANGUL SYLLABLE
   sortTable[0xB688]=35478;   // HANGUL SYLLABLE
   sortTable[0xB689]=35479;   // HANGUL SYLLABLE
   sortTable[0xB68A]=35480;   // HANGUL SYLLABLE
   sortTable[0xB68B]=35481;   // HANGUL SYLLABLE
   sortTable[0xB68C]=35482;   // HANGUL SYLLABLE
   sortTable[0xB68D]=35483;   // HANGUL SYLLABLE
   sortTable[0xB68E]=35484;   // HANGUL SYLLABLE
   sortTable[0xB68F]=35485;   // HANGUL SYLLABLE
   sortTable[0xB690]=35486;   // HANGUL SYLLABLE
   sortTable[0xB691]=35487;   // HANGUL SYLLABLE
   sortTable[0xB692]=35488;   // HANGUL SYLLABLE
   sortTable[0xB693]=35489;   // HANGUL SYLLABLE
   sortTable[0xB694]=35490;   // HANGUL SYLLABLE
   sortTable[0xB695]=35491;   // HANGUL SYLLABLE
   sortTable[0xB696]=35492;   // HANGUL SYLLABLE
   sortTable[0xB697]=35493;   // HANGUL SYLLABLE
   sortTable[0xB698]=35494;   // HANGUL SYLLABLE
   sortTable[0xB699]=35495;   // HANGUL SYLLABLE
   sortTable[0xB69A]=35496;   // HANGUL SYLLABLE
   sortTable[0xB69B]=35497;   // HANGUL SYLLABLE
   sortTable[0xB69C]=35498;   // HANGUL SYLLABLE
   sortTable[0xB69D]=35499;   // HANGUL SYLLABLE
   sortTable[0xB69E]=35500;   // HANGUL SYLLABLE
   sortTable[0xB69F]=35501;   // HANGUL SYLLABLE
   sortTable[0xB6A0]=35502;   // HANGUL SYLLABLE
   sortTable[0xB6A1]=35503;   // HANGUL SYLLABLE
   sortTable[0xB6A2]=35504;   // HANGUL SYLLABLE
   sortTable[0xB6A3]=35505;   // HANGUL SYLLABLE
   sortTable[0xB6A4]=35506;   // HANGUL SYLLABLE
   sortTable[0xB6A5]=35507;   // HANGUL SYLLABLE
   sortTable[0xB6A6]=35508;   // HANGUL SYLLABLE
   sortTable[0xB6A7]=35509;   // HANGUL SYLLABLE
   sortTable[0xB6A8]=35510;   // HANGUL SYLLABLE
   sortTable[0xB6A9]=35511;   // HANGUL SYLLABLE
   sortTable[0xB6AA]=35512;   // HANGUL SYLLABLE
   sortTable[0xB6AB]=35513;   // HANGUL SYLLABLE
   sortTable[0xB6AC]=35514;   // HANGUL SYLLABLE
   sortTable[0xB6AD]=35515;   // HANGUL SYLLABLE
   sortTable[0xB6AE]=35516;   // HANGUL SYLLABLE
   sortTable[0xB6AF]=35517;   // HANGUL SYLLABLE
   sortTable[0xB6B0]=35518;   // HANGUL SYLLABLE
   sortTable[0xB6B1]=35519;   // HANGUL SYLLABLE
   sortTable[0xB6B2]=35520;   // HANGUL SYLLABLE
   sortTable[0xB6B3]=35521;   // HANGUL SYLLABLE
   sortTable[0xB6B4]=35522;   // HANGUL SYLLABLE
   sortTable[0xB6B5]=35523;   // HANGUL SYLLABLE
   sortTable[0xB6B6]=35524;   // HANGUL SYLLABLE
   sortTable[0xB6B7]=35525;   // HANGUL SYLLABLE
   sortTable[0xB6B8]=35526;   // HANGUL SYLLABLE
   sortTable[0xB6B9]=35527;   // HANGUL SYLLABLE
   sortTable[0xB6BA]=35528;   // HANGUL SYLLABLE
   sortTable[0xB6BB]=35529;   // HANGUL SYLLABLE
   sortTable[0xB6BC]=35530;   // HANGUL SYLLABLE
   sortTable[0xB6BD]=35531;   // HANGUL SYLLABLE
   sortTable[0xB6BE]=35532;   // HANGUL SYLLABLE
   sortTable[0xB6BF]=35533;   // HANGUL SYLLABLE
   sortTable[0xB6C0]=35534;   // HANGUL SYLLABLE
   sortTable[0xB6C1]=35535;   // HANGUL SYLLABLE
   sortTable[0xB6C2]=35536;   // HANGUL SYLLABLE
   sortTable[0xB6C3]=35537;   // HANGUL SYLLABLE
   sortTable[0xB6C4]=35538;   // HANGUL SYLLABLE
   sortTable[0xB6C5]=35539;   // HANGUL SYLLABLE
   sortTable[0xB6C6]=35540;   // HANGUL SYLLABLE
   sortTable[0xB6C7]=35541;   // HANGUL SYLLABLE
   sortTable[0xB6C8]=35542;   // HANGUL SYLLABLE
   sortTable[0xB6C9]=35543;   // HANGUL SYLLABLE
   sortTable[0xB6CA]=35544;   // HANGUL SYLLABLE
   sortTable[0xB6CB]=35545;   // HANGUL SYLLABLE
   sortTable[0xB6CC]=35546;   // HANGUL SYLLABLE
   sortTable[0xB6CD]=35547;   // HANGUL SYLLABLE
   sortTable[0xB6CE]=35548;   // HANGUL SYLLABLE
   sortTable[0xB6CF]=35549;   // HANGUL SYLLABLE
   sortTable[0xB6D0]=35550;   // HANGUL SYLLABLE
   sortTable[0xB6D1]=35551;   // HANGUL SYLLABLE
   sortTable[0xB6D2]=35552;   // HANGUL SYLLABLE
   sortTable[0xB6D3]=35553;   // HANGUL SYLLABLE
   sortTable[0xB6D4]=35554;   // HANGUL SYLLABLE
   sortTable[0xB6D5]=35555;   // HANGUL SYLLABLE
   sortTable[0xB6D6]=35556;   // HANGUL SYLLABLE
   sortTable[0xB6D7]=35557;   // HANGUL SYLLABLE
   sortTable[0xB6D8]=35558;   // HANGUL SYLLABLE
   sortTable[0xB6D9]=35559;   // HANGUL SYLLABLE
   sortTable[0xB6DA]=35560;   // HANGUL SYLLABLE
   sortTable[0xB6DB]=35561;   // HANGUL SYLLABLE
   sortTable[0xB6DC]=35562;   // HANGUL SYLLABLE
   sortTable[0xB6DD]=35563;   // HANGUL SYLLABLE
   sortTable[0xB6DE]=35564;   // HANGUL SYLLABLE
   sortTable[0xB6DF]=35565;   // HANGUL SYLLABLE
   sortTable[0xB6E0]=35566;   // HANGUL SYLLABLE
   sortTable[0xB6E1]=35567;   // HANGUL SYLLABLE
   sortTable[0xB6E2]=35568;   // HANGUL SYLLABLE
   sortTable[0xB6E3]=35569;   // HANGUL SYLLABLE
   sortTable[0xB6E4]=35570;   // HANGUL SYLLABLE
   sortTable[0xB6E5]=35571;   // HANGUL SYLLABLE
   sortTable[0xB6E6]=35572;   // HANGUL SYLLABLE
   sortTable[0xB6E7]=35573;   // HANGUL SYLLABLE
   sortTable[0xB6E8]=35574;   // HANGUL SYLLABLE
   sortTable[0xB6E9]=35575;   // HANGUL SYLLABLE
   sortTable[0xB6EA]=35576;   // HANGUL SYLLABLE
   sortTable[0xB6EB]=35577;   // HANGUL SYLLABLE
   sortTable[0xB6EC]=35578;   // HANGUL SYLLABLE
   sortTable[0xB6ED]=35579;   // HANGUL SYLLABLE
   sortTable[0xB6EE]=35580;   // HANGUL SYLLABLE
   sortTable[0xB6EF]=35581;   // HANGUL SYLLABLE
   sortTable[0xB6F0]=35582;   // HANGUL SYLLABLE
   sortTable[0xB6F1]=35583;   // HANGUL SYLLABLE
   sortTable[0xB6F2]=35584;   // HANGUL SYLLABLE
   sortTable[0xB6F3]=35585;   // HANGUL SYLLABLE
   sortTable[0xB6F4]=35586;   // HANGUL SYLLABLE
   sortTable[0xB6F5]=35587;   // HANGUL SYLLABLE
   sortTable[0xB6F6]=35588;   // HANGUL SYLLABLE
   sortTable[0xB6F7]=35589;   // HANGUL SYLLABLE
   sortTable[0xB6F8]=35590;   // HANGUL SYLLABLE
   sortTable[0xB6F9]=35591;   // HANGUL SYLLABLE
   sortTable[0xB6FA]=35592;   // HANGUL SYLLABLE
   sortTable[0xB6FB]=35593;   // HANGUL SYLLABLE
   sortTable[0xB6FC]=35594;   // HANGUL SYLLABLE
   sortTable[0xB6FD]=35595;   // HANGUL SYLLABLE
   sortTable[0xB6FE]=35596;   // HANGUL SYLLABLE
   sortTable[0xB6FF]=35597;   // HANGUL SYLLABLE
   sortTable[0xB700]=35598;   // HANGUL SYLLABLE
   sortTable[0xB701]=35599;   // HANGUL SYLLABLE
   sortTable[0xB702]=35600;   // HANGUL SYLLABLE
   sortTable[0xB703]=35601;   // HANGUL SYLLABLE
   sortTable[0xB704]=35602;   // HANGUL SYLLABLE
   sortTable[0xB705]=35603;   // HANGUL SYLLABLE
   sortTable[0xB706]=35604;   // HANGUL SYLLABLE
   sortTable[0xB707]=35605;   // HANGUL SYLLABLE
   sortTable[0xB708]=35606;   // HANGUL SYLLABLE
   sortTable[0xB709]=35607;   // HANGUL SYLLABLE
   sortTable[0xB70A]=35608;   // HANGUL SYLLABLE
   sortTable[0xB70B]=35609;   // HANGUL SYLLABLE
   sortTable[0xB70C]=35610;   // HANGUL SYLLABLE
   sortTable[0xB70D]=35611;   // HANGUL SYLLABLE
   sortTable[0xB70E]=35612;   // HANGUL SYLLABLE
   sortTable[0xB70F]=35613;   // HANGUL SYLLABLE
   sortTable[0xB710]=35614;   // HANGUL SYLLABLE
   sortTable[0xB711]=35615;   // HANGUL SYLLABLE
   sortTable[0xB712]=35616;   // HANGUL SYLLABLE
   sortTable[0xB713]=35617;   // HANGUL SYLLABLE
   sortTable[0xB714]=35618;   // HANGUL SYLLABLE
   sortTable[0xB715]=35619;   // HANGUL SYLLABLE
   sortTable[0xB716]=35620;   // HANGUL SYLLABLE
   sortTable[0xB717]=35621;   // HANGUL SYLLABLE
   sortTable[0xB718]=35622;   // HANGUL SYLLABLE
   sortTable[0xB719]=35623;   // HANGUL SYLLABLE
   sortTable[0xB71A]=35624;   // HANGUL SYLLABLE
   sortTable[0xB71B]=35625;   // HANGUL SYLLABLE
   sortTable[0xB71C]=35626;   // HANGUL SYLLABLE
   sortTable[0xB71D]=35627;   // HANGUL SYLLABLE
   sortTable[0xB71E]=35628;   // HANGUL SYLLABLE
   sortTable[0xB71F]=35629;   // HANGUL SYLLABLE
   sortTable[0xB720]=35630;   // HANGUL SYLLABLE
   sortTable[0xB721]=35631;   // HANGUL SYLLABLE
   sortTable[0xB722]=35632;   // HANGUL SYLLABLE
   sortTable[0xB723]=35633;   // HANGUL SYLLABLE
   sortTable[0xB724]=35634;   // HANGUL SYLLABLE
   sortTable[0xB725]=35635;   // HANGUL SYLLABLE
   sortTable[0xB726]=35636;   // HANGUL SYLLABLE
   sortTable[0xB727]=35637;   // HANGUL SYLLABLE
   sortTable[0xB728]=35638;   // HANGUL SYLLABLE
   sortTable[0xB729]=35639;   // HANGUL SYLLABLE
   sortTable[0xB72A]=35640;   // HANGUL SYLLABLE
   sortTable[0xB72B]=35641;   // HANGUL SYLLABLE
   sortTable[0xB72C]=35642;   // HANGUL SYLLABLE
   sortTable[0xB72D]=35643;   // HANGUL SYLLABLE
   sortTable[0xB72E]=35644;   // HANGUL SYLLABLE
   sortTable[0xB72F]=35645;   // HANGUL SYLLABLE
   sortTable[0xB730]=35646;   // HANGUL SYLLABLE
   sortTable[0xB731]=35647;   // HANGUL SYLLABLE
   sortTable[0xB732]=35648;   // HANGUL SYLLABLE
   sortTable[0xB733]=35649;   // HANGUL SYLLABLE
   sortTable[0xB734]=35650;   // HANGUL SYLLABLE
   sortTable[0xB735]=35651;   // HANGUL SYLLABLE
   sortTable[0xB736]=35652;   // HANGUL SYLLABLE
   sortTable[0xB737]=35653;   // HANGUL SYLLABLE
   sortTable[0xB738]=35654;   // HANGUL SYLLABLE
   sortTable[0xB739]=35655;   // HANGUL SYLLABLE
   sortTable[0xB73A]=35656;   // HANGUL SYLLABLE
   sortTable[0xB73B]=35657;   // HANGUL SYLLABLE
   sortTable[0xB73C]=35658;   // HANGUL SYLLABLE
   sortTable[0xB73D]=35659;   // HANGUL SYLLABLE
   sortTable[0xB73E]=35660;   // HANGUL SYLLABLE
   sortTable[0xB73F]=35661;   // HANGUL SYLLABLE
   sortTable[0xB740]=35662;   // HANGUL SYLLABLE
   sortTable[0xB741]=35663;   // HANGUL SYLLABLE
   sortTable[0xB742]=35664;   // HANGUL SYLLABLE
   sortTable[0xB743]=35665;   // HANGUL SYLLABLE
   sortTable[0xB744]=35666;   // HANGUL SYLLABLE
   sortTable[0xB745]=35667;   // HANGUL SYLLABLE
   sortTable[0xB746]=35668;   // HANGUL SYLLABLE
   sortTable[0xB747]=35669;   // HANGUL SYLLABLE
   sortTable[0xB748]=35670;   // HANGUL SYLLABLE
   sortTable[0xB749]=35671;   // HANGUL SYLLABLE
   sortTable[0xB74A]=35672;   // HANGUL SYLLABLE
   sortTable[0xB74B]=35673;   // HANGUL SYLLABLE
   sortTable[0xB74C]=35674;   // HANGUL SYLLABLE
   sortTable[0xB74D]=35675;   // HANGUL SYLLABLE
   sortTable[0xB74E]=35676;   // HANGUL SYLLABLE
   sortTable[0xB74F]=35677;   // HANGUL SYLLABLE
   sortTable[0xB750]=35678;   // HANGUL SYLLABLE
   sortTable[0xB751]=35679;   // HANGUL SYLLABLE
   sortTable[0xB752]=35680;   // HANGUL SYLLABLE
   sortTable[0xB753]=35681;   // HANGUL SYLLABLE
   sortTable[0xB754]=35682;   // HANGUL SYLLABLE
   sortTable[0xB755]=35683;   // HANGUL SYLLABLE
   sortTable[0xB756]=35684;   // HANGUL SYLLABLE
   sortTable[0xB757]=35685;   // HANGUL SYLLABLE
   sortTable[0xB758]=35686;   // HANGUL SYLLABLE
   sortTable[0xB759]=35687;   // HANGUL SYLLABLE
   sortTable[0xB75A]=35688;   // HANGUL SYLLABLE
   sortTable[0xB75B]=35689;   // HANGUL SYLLABLE
   sortTable[0xB75C]=35690;   // HANGUL SYLLABLE
   sortTable[0xB75D]=35691;   // HANGUL SYLLABLE
   sortTable[0xB75E]=35692;   // HANGUL SYLLABLE
   sortTable[0xB75F]=35693;   // HANGUL SYLLABLE
   sortTable[0xB760]=35694;   // HANGUL SYLLABLE
   sortTable[0xB761]=35695;   // HANGUL SYLLABLE
   sortTable[0xB762]=35696;   // HANGUL SYLLABLE
   sortTable[0xB763]=35697;   // HANGUL SYLLABLE
   sortTable[0xB764]=35698;   // HANGUL SYLLABLE
   sortTable[0xB765]=35699;   // HANGUL SYLLABLE
   sortTable[0xB766]=35700;   // HANGUL SYLLABLE
   sortTable[0xB767]=35701;   // HANGUL SYLLABLE
   sortTable[0xB768]=35702;   // HANGUL SYLLABLE
   sortTable[0xB769]=35703;   // HANGUL SYLLABLE
   sortTable[0xB76A]=35704;   // HANGUL SYLLABLE
   sortTable[0xB76B]=35705;   // HANGUL SYLLABLE
   sortTable[0xB76C]=35706;   // HANGUL SYLLABLE
   sortTable[0xB76D]=35707;   // HANGUL SYLLABLE
   sortTable[0xB76E]=35708;   // HANGUL SYLLABLE
   sortTable[0xB76F]=35709;   // HANGUL SYLLABLE
   sortTable[0xB770]=35710;   // HANGUL SYLLABLE
   sortTable[0xB771]=35711;   // HANGUL SYLLABLE
   sortTable[0xB772]=35712;   // HANGUL SYLLABLE
   sortTable[0xB773]=35713;   // HANGUL SYLLABLE
   sortTable[0xB774]=35714;   // HANGUL SYLLABLE
   sortTable[0xB775]=35715;   // HANGUL SYLLABLE
   sortTable[0xB776]=35716;   // HANGUL SYLLABLE
   sortTable[0xB777]=35717;   // HANGUL SYLLABLE
   sortTable[0xB778]=35718;   // HANGUL SYLLABLE
   sortTable[0xB779]=35719;   // HANGUL SYLLABLE
   sortTable[0xB77A]=35720;   // HANGUL SYLLABLE
   sortTable[0xB77B]=35721;   // HANGUL SYLLABLE
   sortTable[0x3139]=35722;   // HANGUL LETTER RIEUL
   sortTable[0x1105]=35723;   // HANGUL CHOSEONG RIEUL
   sortTable[0x11AF]=35724;   // HANGUL JONGSEONG RIEUL
   sortTable[0xB77C]=35725;   // HANGUL SYLLABLE
   sortTable[0xB77D]=35726;   // HANGUL SYLLABLE
   sortTable[0xB77E]=35727;   // HANGUL SYLLABLE
   sortTable[0xB77F]=35728;   // HANGUL SYLLABLE
   sortTable[0xB780]=35729;   // HANGUL SYLLABLE
   sortTable[0xB781]=35730;   // HANGUL SYLLABLE
   sortTable[0xB782]=35731;   // HANGUL SYLLABLE
   sortTable[0xB783]=35732;   // HANGUL SYLLABLE
   sortTable[0xB784]=35733;   // HANGUL SYLLABLE
   sortTable[0xB785]=35734;   // HANGUL SYLLABLE
   sortTable[0xB786]=35735;   // HANGUL SYLLABLE
   sortTable[0xB787]=35736;   // HANGUL SYLLABLE
   sortTable[0xB788]=35737;   // HANGUL SYLLABLE
   sortTable[0xB789]=35738;   // HANGUL SYLLABLE
   sortTable[0xB78A]=35739;   // HANGUL SYLLABLE
   sortTable[0xB78B]=35740;   // HANGUL SYLLABLE
   sortTable[0xB78C]=35741;   // HANGUL SYLLABLE
   sortTable[0xB78D]=35742;   // HANGUL SYLLABLE
   sortTable[0xB78E]=35743;   // HANGUL SYLLABLE
   sortTable[0xB78F]=35744;   // HANGUL SYLLABLE
   sortTable[0xB790]=35745;   // HANGUL SYLLABLE
   sortTable[0xB791]=35746;   // HANGUL SYLLABLE
   sortTable[0xB792]=35747;   // HANGUL SYLLABLE
   sortTable[0xB793]=35748;   // HANGUL SYLLABLE
   sortTable[0xB794]=35749;   // HANGUL SYLLABLE
   sortTable[0xB795]=35750;   // HANGUL SYLLABLE
   sortTable[0xB796]=35751;   // HANGUL SYLLABLE
   sortTable[0xB797]=35752;   // HANGUL SYLLABLE
   sortTable[0xB798]=35753;   // HANGUL SYLLABLE
   sortTable[0xB799]=35754;   // HANGUL SYLLABLE
   sortTable[0xB79A]=35755;   // HANGUL SYLLABLE
   sortTable[0xB79B]=35756;   // HANGUL SYLLABLE
   sortTable[0xB79C]=35757;   // HANGUL SYLLABLE
   sortTable[0xB79D]=35758;   // HANGUL SYLLABLE
   sortTable[0xB79E]=35759;   // HANGUL SYLLABLE
   sortTable[0xB79F]=35760;   // HANGUL SYLLABLE
   sortTable[0xB7A0]=35761;   // HANGUL SYLLABLE
   sortTable[0xB7A1]=35762;   // HANGUL SYLLABLE
   sortTable[0xB7A2]=35763;   // HANGUL SYLLABLE
   sortTable[0xB7A3]=35764;   // HANGUL SYLLABLE
   sortTable[0xB7A4]=35765;   // HANGUL SYLLABLE
   sortTable[0xB7A5]=35766;   // HANGUL SYLLABLE
   sortTable[0xB7A6]=35767;   // HANGUL SYLLABLE
   sortTable[0xB7A7]=35768;   // HANGUL SYLLABLE
   sortTable[0xB7A8]=35769;   // HANGUL SYLLABLE
   sortTable[0xB7A9]=35770;   // HANGUL SYLLABLE
   sortTable[0xB7AA]=35771;   // HANGUL SYLLABLE
   sortTable[0xB7AB]=35772;   // HANGUL SYLLABLE
   sortTable[0xB7AC]=35773;   // HANGUL SYLLABLE
   sortTable[0xB7AD]=35774;   // HANGUL SYLLABLE
   sortTable[0xB7AE]=35775;   // HANGUL SYLLABLE
   sortTable[0xB7AF]=35776;   // HANGUL SYLLABLE
   sortTable[0xB7B0]=35777;   // HANGUL SYLLABLE
   sortTable[0xB7B1]=35778;   // HANGUL SYLLABLE
   sortTable[0xB7B2]=35779;   // HANGUL SYLLABLE
   sortTable[0xB7B3]=35780;   // HANGUL SYLLABLE
   sortTable[0xB7B4]=35781;   // HANGUL SYLLABLE
   sortTable[0xB7B5]=35782;   // HANGUL SYLLABLE
   sortTable[0xB7B6]=35783;   // HANGUL SYLLABLE
   sortTable[0xB7B7]=35784;   // HANGUL SYLLABLE
   sortTable[0xB7B8]=35785;   // HANGUL SYLLABLE
   sortTable[0xB7B9]=35786;   // HANGUL SYLLABLE
   sortTable[0xB7BA]=35787;   // HANGUL SYLLABLE
   sortTable[0xB7BB]=35788;   // HANGUL SYLLABLE
   sortTable[0xB7BC]=35789;   // HANGUL SYLLABLE
   sortTable[0xB7BD]=35790;   // HANGUL SYLLABLE
   sortTable[0xB7BE]=35791;   // HANGUL SYLLABLE
   sortTable[0xB7BF]=35792;   // HANGUL SYLLABLE
   sortTable[0xB7C0]=35793;   // HANGUL SYLLABLE
   sortTable[0xB7C1]=35794;   // HANGUL SYLLABLE
   sortTable[0xB7C2]=35795;   // HANGUL SYLLABLE
   sortTable[0xB7C3]=35796;   // HANGUL SYLLABLE
   sortTable[0xB7C4]=35797;   // HANGUL SYLLABLE
   sortTable[0xB7C5]=35798;   // HANGUL SYLLABLE
   sortTable[0xB7C6]=35799;   // HANGUL SYLLABLE
   sortTable[0xB7C7]=35800;   // HANGUL SYLLABLE
   sortTable[0xB7C8]=35801;   // HANGUL SYLLABLE
   sortTable[0xB7C9]=35802;   // HANGUL SYLLABLE
   sortTable[0xB7CA]=35803;   // HANGUL SYLLABLE
   sortTable[0xB7CB]=35804;   // HANGUL SYLLABLE
   sortTable[0xB7CC]=35805;   // HANGUL SYLLABLE
   sortTable[0xB7CD]=35806;   // HANGUL SYLLABLE
   sortTable[0xB7CE]=35807;   // HANGUL SYLLABLE
   sortTable[0xB7CF]=35808;   // HANGUL SYLLABLE
   sortTable[0xB7D0]=35809;   // HANGUL SYLLABLE
   sortTable[0xB7D1]=35810;   // HANGUL SYLLABLE
   sortTable[0xB7D2]=35811;   // HANGUL SYLLABLE
   sortTable[0xB7D3]=35812;   // HANGUL SYLLABLE
   sortTable[0xB7D4]=35813;   // HANGUL SYLLABLE
   sortTable[0xB7D5]=35814;   // HANGUL SYLLABLE
   sortTable[0xB7D6]=35815;   // HANGUL SYLLABLE
   sortTable[0xB7D7]=35816;   // HANGUL SYLLABLE
   sortTable[0xB7D8]=35817;   // HANGUL SYLLABLE
   sortTable[0xB7D9]=35818;   // HANGUL SYLLABLE
   sortTable[0xB7DA]=35819;   // HANGUL SYLLABLE
   sortTable[0xB7DB]=35820;   // HANGUL SYLLABLE
   sortTable[0xB7DC]=35821;   // HANGUL SYLLABLE
   sortTable[0xB7DD]=35822;   // HANGUL SYLLABLE
   sortTable[0xB7DE]=35823;   // HANGUL SYLLABLE
   sortTable[0xB7DF]=35824;   // HANGUL SYLLABLE
   sortTable[0xB7E0]=35825;   // HANGUL SYLLABLE
   sortTable[0xB7E1]=35826;   // HANGUL SYLLABLE
   sortTable[0xB7E2]=35827;   // HANGUL SYLLABLE
   sortTable[0xB7E3]=35828;   // HANGUL SYLLABLE
   sortTable[0xB7E4]=35829;   // HANGUL SYLLABLE
   sortTable[0xB7E5]=35830;   // HANGUL SYLLABLE
   sortTable[0xB7E6]=35831;   // HANGUL SYLLABLE
   sortTable[0xB7E7]=35832;   // HANGUL SYLLABLE
   sortTable[0xB7E8]=35833;   // HANGUL SYLLABLE
   sortTable[0xB7E9]=35834;   // HANGUL SYLLABLE
   sortTable[0xB7EA]=35835;   // HANGUL SYLLABLE
   sortTable[0xB7EB]=35836;   // HANGUL SYLLABLE
   sortTable[0xB7EC]=35837;   // HANGUL SYLLABLE
   sortTable[0xB7ED]=35838;   // HANGUL SYLLABLE
   sortTable[0xB7EE]=35839;   // HANGUL SYLLABLE
   sortTable[0xB7EF]=35840;   // HANGUL SYLLABLE
   sortTable[0xB7F0]=35841;   // HANGUL SYLLABLE
   sortTable[0xB7F1]=35842;   // HANGUL SYLLABLE
   sortTable[0xB7F2]=35843;   // HANGUL SYLLABLE
   sortTable[0xB7F3]=35844;   // HANGUL SYLLABLE
   sortTable[0xB7F4]=35845;   // HANGUL SYLLABLE
   sortTable[0xB7F5]=35846;   // HANGUL SYLLABLE
   sortTable[0xB7F6]=35847;   // HANGUL SYLLABLE
   sortTable[0xB7F7]=35848;   // HANGUL SYLLABLE
   sortTable[0xB7F8]=35849;   // HANGUL SYLLABLE
   sortTable[0xB7F9]=35850;   // HANGUL SYLLABLE
   sortTable[0xB7FA]=35851;   // HANGUL SYLLABLE
   sortTable[0xB7FB]=35852;   // HANGUL SYLLABLE
   sortTable[0xB7FC]=35853;   // HANGUL SYLLABLE
   sortTable[0xB7FD]=35854;   // HANGUL SYLLABLE
   sortTable[0xB7FE]=35855;   // HANGUL SYLLABLE
   sortTable[0xB7FF]=35856;   // HANGUL SYLLABLE
   sortTable[0xB800]=35857;   // HANGUL SYLLABLE
   sortTable[0xB801]=35858;   // HANGUL SYLLABLE
   sortTable[0xB802]=35859;   // HANGUL SYLLABLE
   sortTable[0xB803]=35860;   // HANGUL SYLLABLE
   sortTable[0xB804]=35861;   // HANGUL SYLLABLE
   sortTable[0xB805]=35862;   // HANGUL SYLLABLE
   sortTable[0xB806]=35863;   // HANGUL SYLLABLE
   sortTable[0xB807]=35864;   // HANGUL SYLLABLE
   sortTable[0xB808]=35865;   // HANGUL SYLLABLE
   sortTable[0xB809]=35866;   // HANGUL SYLLABLE
   sortTable[0xB80A]=35867;   // HANGUL SYLLABLE
   sortTable[0xB80B]=35868;   // HANGUL SYLLABLE
   sortTable[0xB80C]=35869;   // HANGUL SYLLABLE
   sortTable[0xB80D]=35870;   // HANGUL SYLLABLE
   sortTable[0xB80E]=35871;   // HANGUL SYLLABLE
   sortTable[0xB80F]=35872;   // HANGUL SYLLABLE
   sortTable[0xB810]=35873;   // HANGUL SYLLABLE
   sortTable[0xB811]=35874;   // HANGUL SYLLABLE
   sortTable[0xB812]=35875;   // HANGUL SYLLABLE
   sortTable[0xB813]=35876;   // HANGUL SYLLABLE
   sortTable[0xB814]=35877;   // HANGUL SYLLABLE
   sortTable[0xB815]=35878;   // HANGUL SYLLABLE
   sortTable[0xB816]=35879;   // HANGUL SYLLABLE
   sortTable[0xB817]=35880;   // HANGUL SYLLABLE
   sortTable[0xB818]=35881;   // HANGUL SYLLABLE
   sortTable[0xB819]=35882;   // HANGUL SYLLABLE
   sortTable[0xB81A]=35883;   // HANGUL SYLLABLE
   sortTable[0xB81B]=35884;   // HANGUL SYLLABLE
   sortTable[0xB81C]=35885;   // HANGUL SYLLABLE
   sortTable[0xB81D]=35886;   // HANGUL SYLLABLE
   sortTable[0xB81E]=35887;   // HANGUL SYLLABLE
   sortTable[0xB81F]=35888;   // HANGUL SYLLABLE
   sortTable[0xB820]=35889;   // HANGUL SYLLABLE
   sortTable[0xB821]=35890;   // HANGUL SYLLABLE
   sortTable[0xB822]=35891;   // HANGUL SYLLABLE
   sortTable[0xB823]=35892;   // HANGUL SYLLABLE
   sortTable[0xB824]=35893;   // HANGUL SYLLABLE
   sortTable[0xB825]=35894;   // HANGUL SYLLABLE
   sortTable[0xB826]=35895;   // HANGUL SYLLABLE
   sortTable[0xB827]=35896;   // HANGUL SYLLABLE
   sortTable[0xB828]=35897;   // HANGUL SYLLABLE
   sortTable[0xB829]=35898;   // HANGUL SYLLABLE
   sortTable[0xB82A]=35899;   // HANGUL SYLLABLE
   sortTable[0xB82B]=35900;   // HANGUL SYLLABLE
   sortTable[0xB82C]=35901;   // HANGUL SYLLABLE
   sortTable[0xB82D]=35902;   // HANGUL SYLLABLE
   sortTable[0xB82E]=35903;   // HANGUL SYLLABLE
   sortTable[0xB82F]=35904;   // HANGUL SYLLABLE
   sortTable[0xB830]=35905;   // HANGUL SYLLABLE
   sortTable[0xB831]=35906;   // HANGUL SYLLABLE
   sortTable[0xB832]=35907;   // HANGUL SYLLABLE
   sortTable[0xB833]=35908;   // HANGUL SYLLABLE
   sortTable[0xB834]=35909;   // HANGUL SYLLABLE
   sortTable[0xB835]=35910;   // HANGUL SYLLABLE
   sortTable[0xB836]=35911;   // HANGUL SYLLABLE
   sortTable[0xB837]=35912;   // HANGUL SYLLABLE
   sortTable[0xB838]=35913;   // HANGUL SYLLABLE
   sortTable[0xB839]=35914;   // HANGUL SYLLABLE
   sortTable[0xB83A]=35915;   // HANGUL SYLLABLE
   sortTable[0xB83B]=35916;   // HANGUL SYLLABLE
   sortTable[0xB83C]=35917;   // HANGUL SYLLABLE
   sortTable[0xB83D]=35918;   // HANGUL SYLLABLE
   sortTable[0xB83E]=35919;   // HANGUL SYLLABLE
   sortTable[0xB83F]=35920;   // HANGUL SYLLABLE
   sortTable[0xB840]=35921;   // HANGUL SYLLABLE
   sortTable[0xB841]=35922;   // HANGUL SYLLABLE
   sortTable[0xB842]=35923;   // HANGUL SYLLABLE
   sortTable[0xB843]=35924;   // HANGUL SYLLABLE
   sortTable[0xB844]=35925;   // HANGUL SYLLABLE
   sortTable[0xB845]=35926;   // HANGUL SYLLABLE
   sortTable[0xB846]=35927;   // HANGUL SYLLABLE
   sortTable[0xB847]=35928;   // HANGUL SYLLABLE
   sortTable[0xB848]=35929;   // HANGUL SYLLABLE
   sortTable[0xB849]=35930;   // HANGUL SYLLABLE
   sortTable[0xB84A]=35931;   // HANGUL SYLLABLE
   sortTable[0xB84B]=35932;   // HANGUL SYLLABLE
   sortTable[0xB84C]=35933;   // HANGUL SYLLABLE
   sortTable[0xB84D]=35934;   // HANGUL SYLLABLE
   sortTable[0xB84E]=35935;   // HANGUL SYLLABLE
   sortTable[0xB84F]=35936;   // HANGUL SYLLABLE
   sortTable[0xB850]=35937;   // HANGUL SYLLABLE
   sortTable[0xB851]=35938;   // HANGUL SYLLABLE
   sortTable[0xB852]=35939;   // HANGUL SYLLABLE
   sortTable[0xB853]=35940;   // HANGUL SYLLABLE
   sortTable[0xB854]=35941;   // HANGUL SYLLABLE
   sortTable[0xB855]=35942;   // HANGUL SYLLABLE
   sortTable[0xB856]=35943;   // HANGUL SYLLABLE
   sortTable[0xB857]=35944;   // HANGUL SYLLABLE
   sortTable[0xB858]=35945;   // HANGUL SYLLABLE
   sortTable[0xB859]=35946;   // HANGUL SYLLABLE
   sortTable[0xB85A]=35947;   // HANGUL SYLLABLE
   sortTable[0xB85B]=35948;   // HANGUL SYLLABLE
   sortTable[0xB85C]=35949;   // HANGUL SYLLABLE
   sortTable[0xB85D]=35950;   // HANGUL SYLLABLE
   sortTable[0xB85E]=35951;   // HANGUL SYLLABLE
   sortTable[0xB85F]=35952;   // HANGUL SYLLABLE
   sortTable[0xB860]=35953;   // HANGUL SYLLABLE
   sortTable[0xB861]=35954;   // HANGUL SYLLABLE
   sortTable[0xB862]=35955;   // HANGUL SYLLABLE
   sortTable[0xB863]=35956;   // HANGUL SYLLABLE
   sortTable[0xB864]=35957;   // HANGUL SYLLABLE
   sortTable[0xB865]=35958;   // HANGUL SYLLABLE
   sortTable[0xB866]=35959;   // HANGUL SYLLABLE
   sortTable[0xB867]=35960;   // HANGUL SYLLABLE
   sortTable[0xB868]=35961;   // HANGUL SYLLABLE
   sortTable[0xB869]=35962;   // HANGUL SYLLABLE
   sortTable[0xB86A]=35963;   // HANGUL SYLLABLE
   sortTable[0xB86B]=35964;   // HANGUL SYLLABLE
   sortTable[0xB86C]=35965;   // HANGUL SYLLABLE
   sortTable[0xB86D]=35966;   // HANGUL SYLLABLE
   sortTable[0xB86E]=35967;   // HANGUL SYLLABLE
   sortTable[0xB86F]=35968;   // HANGUL SYLLABLE
   sortTable[0xB870]=35969;   // HANGUL SYLLABLE
   sortTable[0xB871]=35970;   // HANGUL SYLLABLE
   sortTable[0xB872]=35971;   // HANGUL SYLLABLE
   sortTable[0xB873]=35972;   // HANGUL SYLLABLE
   sortTable[0xB874]=35973;   // HANGUL SYLLABLE
   sortTable[0xB875]=35974;   // HANGUL SYLLABLE
   sortTable[0xB876]=35975;   // HANGUL SYLLABLE
   sortTable[0xB877]=35976;   // HANGUL SYLLABLE
   sortTable[0xB878]=35977;   // HANGUL SYLLABLE
   sortTable[0xB879]=35978;   // HANGUL SYLLABLE
   sortTable[0xB87A]=35979;   // HANGUL SYLLABLE
   sortTable[0xB87B]=35980;   // HANGUL SYLLABLE
   sortTable[0xB87C]=35981;   // HANGUL SYLLABLE
   sortTable[0xB87D]=35982;   // HANGUL SYLLABLE
   sortTable[0xB87E]=35983;   // HANGUL SYLLABLE
   sortTable[0xB87F]=35984;   // HANGUL SYLLABLE
   sortTable[0xB880]=35985;   // HANGUL SYLLABLE
   sortTable[0xB881]=35986;   // HANGUL SYLLABLE
   sortTable[0xB882]=35987;   // HANGUL SYLLABLE
   sortTable[0xB883]=35988;   // HANGUL SYLLABLE
   sortTable[0xB884]=35989;   // HANGUL SYLLABLE
   sortTable[0xB885]=35990;   // HANGUL SYLLABLE
   sortTable[0xB886]=35991;   // HANGUL SYLLABLE
   sortTable[0xB887]=35992;   // HANGUL SYLLABLE
   sortTable[0xB888]=35993;   // HANGUL SYLLABLE
   sortTable[0xB889]=35994;   // HANGUL SYLLABLE
   sortTable[0xB88A]=35995;   // HANGUL SYLLABLE
   sortTable[0xB88B]=35996;   // HANGUL SYLLABLE
   sortTable[0xB88C]=35997;   // HANGUL SYLLABLE
   sortTable[0xB88D]=35998;   // HANGUL SYLLABLE
   sortTable[0xB88E]=35999;   // HANGUL SYLLABLE
   sortTable[0xB88F]=36000;   // HANGUL SYLLABLE
   sortTable[0xB890]=36001;   // HANGUL SYLLABLE
   sortTable[0xB891]=36002;   // HANGUL SYLLABLE
   sortTable[0xB892]=36003;   // HANGUL SYLLABLE
   sortTable[0xB893]=36004;   // HANGUL SYLLABLE
   sortTable[0xB894]=36005;   // HANGUL SYLLABLE
   sortTable[0xB895]=36006;   // HANGUL SYLLABLE
   sortTable[0xB896]=36007;   // HANGUL SYLLABLE
   sortTable[0xB897]=36008;   // HANGUL SYLLABLE
   sortTable[0xB898]=36009;   // HANGUL SYLLABLE
   sortTable[0xB899]=36010;   // HANGUL SYLLABLE
   sortTable[0xB89A]=36011;   // HANGUL SYLLABLE
   sortTable[0xB89B]=36012;   // HANGUL SYLLABLE
   sortTable[0xB89C]=36013;   // HANGUL SYLLABLE
   sortTable[0xB89D]=36014;   // HANGUL SYLLABLE
   sortTable[0xB89E]=36015;   // HANGUL SYLLABLE
   sortTable[0xB89F]=36016;   // HANGUL SYLLABLE
   sortTable[0xB8A0]=36017;   // HANGUL SYLLABLE
   sortTable[0xB8A1]=36018;   // HANGUL SYLLABLE
   sortTable[0xB8A2]=36019;   // HANGUL SYLLABLE
   sortTable[0xB8A3]=36020;   // HANGUL SYLLABLE
   sortTable[0xB8A4]=36021;   // HANGUL SYLLABLE
   sortTable[0xB8A5]=36022;   // HANGUL SYLLABLE
   sortTable[0xB8A6]=36023;   // HANGUL SYLLABLE
   sortTable[0xB8A7]=36024;   // HANGUL SYLLABLE
   sortTable[0xB8A8]=36025;   // HANGUL SYLLABLE
   sortTable[0xB8A9]=36026;   // HANGUL SYLLABLE
   sortTable[0xB8AA]=36027;   // HANGUL SYLLABLE
   sortTable[0xB8AB]=36028;   // HANGUL SYLLABLE
   sortTable[0xB8AC]=36029;   // HANGUL SYLLABLE
   sortTable[0xB8AD]=36030;   // HANGUL SYLLABLE
   sortTable[0xB8AE]=36031;   // HANGUL SYLLABLE
   sortTable[0xB8AF]=36032;   // HANGUL SYLLABLE
   sortTable[0xB8B0]=36033;   // HANGUL SYLLABLE
   sortTable[0xB8B1]=36034;   // HANGUL SYLLABLE
   sortTable[0xB8B2]=36035;   // HANGUL SYLLABLE
   sortTable[0xB8B3]=36036;   // HANGUL SYLLABLE
   sortTable[0xB8B4]=36037;   // HANGUL SYLLABLE
   sortTable[0xB8B5]=36038;   // HANGUL SYLLABLE
   sortTable[0xB8B6]=36039;   // HANGUL SYLLABLE
   sortTable[0xB8B7]=36040;   // HANGUL SYLLABLE
   sortTable[0xB8B8]=36041;   // HANGUL SYLLABLE
   sortTable[0xB8B9]=36042;   // HANGUL SYLLABLE
   sortTable[0xB8BA]=36043;   // HANGUL SYLLABLE
   sortTable[0xB8BB]=36044;   // HANGUL SYLLABLE
   sortTable[0xB8BC]=36045;   // HANGUL SYLLABLE
   sortTable[0xB8BD]=36046;   // HANGUL SYLLABLE
   sortTable[0xB8BE]=36047;   // HANGUL SYLLABLE
   sortTable[0xB8BF]=36048;   // HANGUL SYLLABLE
   sortTable[0xB8C0]=36049;   // HANGUL SYLLABLE
   sortTable[0xB8C1]=36050;   // HANGUL SYLLABLE
   sortTable[0xB8C2]=36051;   // HANGUL SYLLABLE
   sortTable[0xB8C3]=36052;   // HANGUL SYLLABLE
   sortTable[0xB8C4]=36053;   // HANGUL SYLLABLE
   sortTable[0xB8C5]=36054;   // HANGUL SYLLABLE
   sortTable[0xB8C6]=36055;   // HANGUL SYLLABLE
   sortTable[0xB8C7]=36056;   // HANGUL SYLLABLE
   sortTable[0xB8C8]=36057;   // HANGUL SYLLABLE
   sortTable[0xB8C9]=36058;   // HANGUL SYLLABLE
   sortTable[0xB8CA]=36059;   // HANGUL SYLLABLE
   sortTable[0xB8CB]=36060;   // HANGUL SYLLABLE
   sortTable[0xB8CC]=36061;   // HANGUL SYLLABLE
   sortTable[0xB8CD]=36062;   // HANGUL SYLLABLE
   sortTable[0xB8CE]=36063;   // HANGUL SYLLABLE
   sortTable[0xB8CF]=36064;   // HANGUL SYLLABLE
   sortTable[0xB8D0]=36065;   // HANGUL SYLLABLE
   sortTable[0xB8D1]=36066;   // HANGUL SYLLABLE
   sortTable[0xB8D2]=36067;   // HANGUL SYLLABLE
   sortTable[0xB8D3]=36068;   // HANGUL SYLLABLE
   sortTable[0xB8D4]=36069;   // HANGUL SYLLABLE
   sortTable[0xB8D5]=36070;   // HANGUL SYLLABLE
   sortTable[0xB8D6]=36071;   // HANGUL SYLLABLE
   sortTable[0xB8D7]=36072;   // HANGUL SYLLABLE
   sortTable[0xB8D8]=36073;   // HANGUL SYLLABLE
   sortTable[0xB8D9]=36074;   // HANGUL SYLLABLE
   sortTable[0xB8DA]=36075;   // HANGUL SYLLABLE
   sortTable[0xB8DB]=36076;   // HANGUL SYLLABLE
   sortTable[0xB8DC]=36077;   // HANGUL SYLLABLE
   sortTable[0xB8DD]=36078;   // HANGUL SYLLABLE
   sortTable[0xB8DE]=36079;   // HANGUL SYLLABLE
   sortTable[0xB8DF]=36080;   // HANGUL SYLLABLE
   sortTable[0xB8E0]=36081;   // HANGUL SYLLABLE
   sortTable[0xB8E1]=36082;   // HANGUL SYLLABLE
   sortTable[0xB8E2]=36083;   // HANGUL SYLLABLE
   sortTable[0xB8E3]=36084;   // HANGUL SYLLABLE
   sortTable[0xB8E4]=36085;   // HANGUL SYLLABLE
   sortTable[0xB8E5]=36086;   // HANGUL SYLLABLE
   sortTable[0xB8E6]=36087;   // HANGUL SYLLABLE
   sortTable[0xB8E7]=36088;   // HANGUL SYLLABLE
   sortTable[0xB8E8]=36089;   // HANGUL SYLLABLE
   sortTable[0xB8E9]=36090;   // HANGUL SYLLABLE
   sortTable[0xB8EA]=36091;   // HANGUL SYLLABLE
   sortTable[0xB8EB]=36092;   // HANGUL SYLLABLE
   sortTable[0xB8EC]=36093;   // HANGUL SYLLABLE
   sortTable[0xB8ED]=36094;   // HANGUL SYLLABLE
   sortTable[0xB8EE]=36095;   // HANGUL SYLLABLE
   sortTable[0xB8EF]=36096;   // HANGUL SYLLABLE
   sortTable[0xB8F0]=36097;   // HANGUL SYLLABLE
   sortTable[0xB8F1]=36098;   // HANGUL SYLLABLE
   sortTable[0xB8F2]=36099;   // HANGUL SYLLABLE
   sortTable[0xB8F3]=36100;   // HANGUL SYLLABLE
   sortTable[0xB8F4]=36101;   // HANGUL SYLLABLE
   sortTable[0xB8F5]=36102;   // HANGUL SYLLABLE
   sortTable[0xB8F6]=36103;   // HANGUL SYLLABLE
   sortTable[0xB8F7]=36104;   // HANGUL SYLLABLE
   sortTable[0xB8F8]=36105;   // HANGUL SYLLABLE
   sortTable[0xB8F9]=36106;   // HANGUL SYLLABLE
   sortTable[0xB8FA]=36107;   // HANGUL SYLLABLE
   sortTable[0xB8FB]=36108;   // HANGUL SYLLABLE
   sortTable[0xB8FC]=36109;   // HANGUL SYLLABLE
   sortTable[0xB8FD]=36110;   // HANGUL SYLLABLE
   sortTable[0xB8FE]=36111;   // HANGUL SYLLABLE
   sortTable[0xB8FF]=36112;   // HANGUL SYLLABLE
   sortTable[0xB900]=36113;   // HANGUL SYLLABLE
   sortTable[0xB901]=36114;   // HANGUL SYLLABLE
   sortTable[0xB902]=36115;   // HANGUL SYLLABLE
   sortTable[0xB903]=36116;   // HANGUL SYLLABLE
   sortTable[0xB904]=36117;   // HANGUL SYLLABLE
   sortTable[0xB905]=36118;   // HANGUL SYLLABLE
   sortTable[0xB906]=36119;   // HANGUL SYLLABLE
   sortTable[0xB907]=36120;   // HANGUL SYLLABLE
   sortTable[0xB908]=36121;   // HANGUL SYLLABLE
   sortTable[0xB909]=36122;   // HANGUL SYLLABLE
   sortTable[0xB90A]=36123;   // HANGUL SYLLABLE
   sortTable[0xB90B]=36124;   // HANGUL SYLLABLE
   sortTable[0xB90C]=36125;   // HANGUL SYLLABLE
   sortTable[0xB90D]=36126;   // HANGUL SYLLABLE
   sortTable[0xB90E]=36127;   // HANGUL SYLLABLE
   sortTable[0xB90F]=36128;   // HANGUL SYLLABLE
   sortTable[0xB910]=36129;   // HANGUL SYLLABLE
   sortTable[0xB911]=36130;   // HANGUL SYLLABLE
   sortTable[0xB912]=36131;   // HANGUL SYLLABLE
   sortTable[0xB913]=36132;   // HANGUL SYLLABLE
   sortTable[0xB914]=36133;   // HANGUL SYLLABLE
   sortTable[0xB915]=36134;   // HANGUL SYLLABLE
   sortTable[0xB916]=36135;   // HANGUL SYLLABLE
   sortTable[0xB917]=36136;   // HANGUL SYLLABLE
   sortTable[0xB918]=36137;   // HANGUL SYLLABLE
   sortTable[0xB919]=36138;   // HANGUL SYLLABLE
   sortTable[0xB91A]=36139;   // HANGUL SYLLABLE
   sortTable[0xB91B]=36140;   // HANGUL SYLLABLE
   sortTable[0xB91C]=36141;   // HANGUL SYLLABLE
   sortTable[0xB91D]=36142;   // HANGUL SYLLABLE
   sortTable[0xB91E]=36143;   // HANGUL SYLLABLE
   sortTable[0xB91F]=36144;   // HANGUL SYLLABLE
   sortTable[0xB920]=36145;   // HANGUL SYLLABLE
   sortTable[0xB921]=36146;   // HANGUL SYLLABLE
   sortTable[0xB922]=36147;   // HANGUL SYLLABLE
   sortTable[0xB923]=36148;   // HANGUL SYLLABLE
   sortTable[0xB924]=36149;   // HANGUL SYLLABLE
   sortTable[0xB925]=36150;   // HANGUL SYLLABLE
   sortTable[0xB926]=36151;   // HANGUL SYLLABLE
   sortTable[0xB927]=36152;   // HANGUL SYLLABLE
   sortTable[0xB928]=36153;   // HANGUL SYLLABLE
   sortTable[0xB929]=36154;   // HANGUL SYLLABLE
   sortTable[0xB92A]=36155;   // HANGUL SYLLABLE
   sortTable[0xB92B]=36156;   // HANGUL SYLLABLE
   sortTable[0xB92C]=36157;   // HANGUL SYLLABLE
   sortTable[0xB92D]=36158;   // HANGUL SYLLABLE
   sortTable[0xB92E]=36159;   // HANGUL SYLLABLE
   sortTable[0xB92F]=36160;   // HANGUL SYLLABLE
   sortTable[0xB930]=36161;   // HANGUL SYLLABLE
   sortTable[0xB931]=36162;   // HANGUL SYLLABLE
   sortTable[0xB932]=36163;   // HANGUL SYLLABLE
   sortTable[0xB933]=36164;   // HANGUL SYLLABLE
   sortTable[0xB934]=36165;   // HANGUL SYLLABLE
   sortTable[0xB935]=36166;   // HANGUL SYLLABLE
   sortTable[0xB936]=36167;   // HANGUL SYLLABLE
   sortTable[0xB937]=36168;   // HANGUL SYLLABLE
   sortTable[0xB938]=36169;   // HANGUL SYLLABLE
   sortTable[0xB939]=36170;   // HANGUL SYLLABLE
   sortTable[0xB93A]=36171;   // HANGUL SYLLABLE
   sortTable[0xB93B]=36172;   // HANGUL SYLLABLE
   sortTable[0xB93C]=36173;   // HANGUL SYLLABLE
   sortTable[0xB93D]=36174;   // HANGUL SYLLABLE
   sortTable[0xB93E]=36175;   // HANGUL SYLLABLE
   sortTable[0xB93F]=36176;   // HANGUL SYLLABLE
   sortTable[0xB940]=36177;   // HANGUL SYLLABLE
   sortTable[0xB941]=36178;   // HANGUL SYLLABLE
   sortTable[0xB942]=36179;   // HANGUL SYLLABLE
   sortTable[0xB943]=36180;   // HANGUL SYLLABLE
   sortTable[0xB944]=36181;   // HANGUL SYLLABLE
   sortTable[0xB945]=36182;   // HANGUL SYLLABLE
   sortTable[0xB946]=36183;   // HANGUL SYLLABLE
   sortTable[0xB947]=36184;   // HANGUL SYLLABLE
   sortTable[0xB948]=36185;   // HANGUL SYLLABLE
   sortTable[0xB949]=36186;   // HANGUL SYLLABLE
   sortTable[0xB94A]=36187;   // HANGUL SYLLABLE
   sortTable[0xB94B]=36188;   // HANGUL SYLLABLE
   sortTable[0xB94C]=36189;   // HANGUL SYLLABLE
   sortTable[0xB94D]=36190;   // HANGUL SYLLABLE
   sortTable[0xB94E]=36191;   // HANGUL SYLLABLE
   sortTable[0xB94F]=36192;   // HANGUL SYLLABLE
   sortTable[0xB950]=36193;   // HANGUL SYLLABLE
   sortTable[0xB951]=36194;   // HANGUL SYLLABLE
   sortTable[0xB952]=36195;   // HANGUL SYLLABLE
   sortTable[0xB953]=36196;   // HANGUL SYLLABLE
   sortTable[0xB954]=36197;   // HANGUL SYLLABLE
   sortTable[0xB955]=36198;   // HANGUL SYLLABLE
   sortTable[0xB956]=36199;   // HANGUL SYLLABLE
   sortTable[0xB957]=36200;   // HANGUL SYLLABLE
   sortTable[0xB958]=36201;   // HANGUL SYLLABLE
   sortTable[0xB959]=36202;   // HANGUL SYLLABLE
   sortTable[0xB95A]=36203;   // HANGUL SYLLABLE
   sortTable[0xB95B]=36204;   // HANGUL SYLLABLE
   sortTable[0xB95C]=36205;   // HANGUL SYLLABLE
   sortTable[0xB95D]=36206;   // HANGUL SYLLABLE
   sortTable[0xB95E]=36207;   // HANGUL SYLLABLE
   sortTable[0xB95F]=36208;   // HANGUL SYLLABLE
   sortTable[0xB960]=36209;   // HANGUL SYLLABLE
   sortTable[0xB961]=36210;   // HANGUL SYLLABLE
   sortTable[0xB962]=36211;   // HANGUL SYLLABLE
   sortTable[0xB963]=36212;   // HANGUL SYLLABLE
   sortTable[0xB964]=36213;   // HANGUL SYLLABLE
   sortTable[0xB965]=36214;   // HANGUL SYLLABLE
   sortTable[0xB966]=36215;   // HANGUL SYLLABLE
   sortTable[0xB967]=36216;   // HANGUL SYLLABLE
   sortTable[0xB968]=36217;   // HANGUL SYLLABLE
   sortTable[0xB969]=36218;   // HANGUL SYLLABLE
   sortTable[0xB96A]=36219;   // HANGUL SYLLABLE
   sortTable[0xB96B]=36220;   // HANGUL SYLLABLE
   sortTable[0xB96C]=36221;   // HANGUL SYLLABLE
   sortTable[0xB96D]=36222;   // HANGUL SYLLABLE
   sortTable[0xB96E]=36223;   // HANGUL SYLLABLE
   sortTable[0xB96F]=36224;   // HANGUL SYLLABLE
   sortTable[0xB970]=36225;   // HANGUL SYLLABLE
   sortTable[0xB971]=36226;   // HANGUL SYLLABLE
   sortTable[0xB972]=36227;   // HANGUL SYLLABLE
   sortTable[0xB973]=36228;   // HANGUL SYLLABLE
   sortTable[0xB974]=36229;   // HANGUL SYLLABLE
   sortTable[0xB975]=36230;   // HANGUL SYLLABLE
   sortTable[0xB976]=36231;   // HANGUL SYLLABLE
   sortTable[0xB977]=36232;   // HANGUL SYLLABLE
   sortTable[0xB978]=36233;   // HANGUL SYLLABLE
   sortTable[0xB979]=36234;   // HANGUL SYLLABLE
   sortTable[0xB97A]=36235;   // HANGUL SYLLABLE
   sortTable[0xB97B]=36236;   // HANGUL SYLLABLE
   sortTable[0xB97C]=36237;   // HANGUL SYLLABLE
   sortTable[0xB97D]=36238;   // HANGUL SYLLABLE
   sortTable[0xB97E]=36239;   // HANGUL SYLLABLE
   sortTable[0xB97F]=36240;   // HANGUL SYLLABLE
   sortTable[0xB980]=36241;   // HANGUL SYLLABLE
   sortTable[0xB981]=36242;   // HANGUL SYLLABLE
   sortTable[0xB982]=36243;   // HANGUL SYLLABLE
   sortTable[0xB983]=36244;   // HANGUL SYLLABLE
   sortTable[0xB984]=36245;   // HANGUL SYLLABLE
   sortTable[0xB985]=36246;   // HANGUL SYLLABLE
   sortTable[0xB986]=36247;   // HANGUL SYLLABLE
   sortTable[0xB987]=36248;   // HANGUL SYLLABLE
   sortTable[0xB988]=36249;   // HANGUL SYLLABLE
   sortTable[0xB989]=36250;   // HANGUL SYLLABLE
   sortTable[0xB98A]=36251;   // HANGUL SYLLABLE
   sortTable[0xB98B]=36252;   // HANGUL SYLLABLE
   sortTable[0xB98C]=36253;   // HANGUL SYLLABLE
   sortTable[0xB98D]=36254;   // HANGUL SYLLABLE
   sortTable[0xB98E]=36255;   // HANGUL SYLLABLE
   sortTable[0xB98F]=36256;   // HANGUL SYLLABLE
   sortTable[0xB990]=36257;   // HANGUL SYLLABLE
   sortTable[0xB991]=36258;   // HANGUL SYLLABLE
   sortTable[0xB992]=36259;   // HANGUL SYLLABLE
   sortTable[0xB993]=36260;   // HANGUL SYLLABLE
   sortTable[0xB994]=36261;   // HANGUL SYLLABLE
   sortTable[0xB995]=36262;   // HANGUL SYLLABLE
   sortTable[0xB996]=36263;   // HANGUL SYLLABLE
   sortTable[0xB997]=36264;   // HANGUL SYLLABLE
   sortTable[0xB998]=36265;   // HANGUL SYLLABLE
   sortTable[0xB999]=36266;   // HANGUL SYLLABLE
   sortTable[0xB99A]=36267;   // HANGUL SYLLABLE
   sortTable[0xB99B]=36268;   // HANGUL SYLLABLE
   sortTable[0xB99C]=36269;   // HANGUL SYLLABLE
   sortTable[0xB99D]=36270;   // HANGUL SYLLABLE
   sortTable[0xB99E]=36271;   // HANGUL SYLLABLE
   sortTable[0xB99F]=36272;   // HANGUL SYLLABLE
   sortTable[0xB9A0]=36273;   // HANGUL SYLLABLE
   sortTable[0xB9A1]=36274;   // HANGUL SYLLABLE
   sortTable[0xB9A2]=36275;   // HANGUL SYLLABLE
   sortTable[0xB9A3]=36276;   // HANGUL SYLLABLE
   sortTable[0xB9A4]=36277;   // HANGUL SYLLABLE
   sortTable[0xB9A5]=36278;   // HANGUL SYLLABLE
   sortTable[0xB9A6]=36279;   // HANGUL SYLLABLE
   sortTable[0xB9A7]=36280;   // HANGUL SYLLABLE
   sortTable[0xB9A8]=36281;   // HANGUL SYLLABLE
   sortTable[0xB9A9]=36282;   // HANGUL SYLLABLE
   sortTable[0xB9AA]=36283;   // HANGUL SYLLABLE
   sortTable[0xB9AB]=36284;   // HANGUL SYLLABLE
   sortTable[0xB9AC]=36285;   // HANGUL SYLLABLE
   sortTable[0xB9AD]=36286;   // HANGUL SYLLABLE
   sortTable[0xB9AE]=36287;   // HANGUL SYLLABLE
   sortTable[0xB9AF]=36288;   // HANGUL SYLLABLE
   sortTable[0xB9B0]=36289;   // HANGUL SYLLABLE
   sortTable[0xB9B1]=36290;   // HANGUL SYLLABLE
   sortTable[0xB9B2]=36291;   // HANGUL SYLLABLE
   sortTable[0xB9B3]=36292;   // HANGUL SYLLABLE
   sortTable[0xB9B4]=36293;   // HANGUL SYLLABLE
   sortTable[0xB9B5]=36294;   // HANGUL SYLLABLE
   sortTable[0xB9B6]=36295;   // HANGUL SYLLABLE
   sortTable[0xB9B7]=36296;   // HANGUL SYLLABLE
   sortTable[0xB9B8]=36297;   // HANGUL SYLLABLE
   sortTable[0xB9B9]=36298;   // HANGUL SYLLABLE
   sortTable[0xB9BA]=36299;   // HANGUL SYLLABLE
   sortTable[0xB9BB]=36300;   // HANGUL SYLLABLE
   sortTable[0xB9BC]=36301;   // HANGUL SYLLABLE
   sortTable[0xB9BD]=36302;   // HANGUL SYLLABLE
   sortTable[0xB9BE]=36303;   // HANGUL SYLLABLE
   sortTable[0xB9BF]=36304;   // HANGUL SYLLABLE
   sortTable[0xB9C0]=36305;   // HANGUL SYLLABLE
   sortTable[0xB9C1]=36306;   // HANGUL SYLLABLE
   sortTable[0xB9C2]=36307;   // HANGUL SYLLABLE
   sortTable[0xB9C3]=36308;   // HANGUL SYLLABLE
   sortTable[0xB9C4]=36309;   // HANGUL SYLLABLE
   sortTable[0xB9C5]=36310;   // HANGUL SYLLABLE
   sortTable[0xB9C6]=36311;   // HANGUL SYLLABLE
   sortTable[0xB9C7]=36312;   // HANGUL SYLLABLE
   sortTable[0x3141]=36313;   // HANGUL LETTER MIEUM
   sortTable[0x1106]=36314;   // HANGUL CHOSEONG MIEUM
   sortTable[0x11B7]=36315;   // HANGUL JONGSEONG MIEUM
   sortTable[0xB9C8]=36316;   // HANGUL SYLLABLE
   sortTable[0xB9C9]=36317;   // HANGUL SYLLABLE
   sortTable[0xB9CA]=36318;   // HANGUL SYLLABLE
   sortTable[0xB9CB]=36319;   // HANGUL SYLLABLE
   sortTable[0xB9CC]=36320;   // HANGUL SYLLABLE
   sortTable[0xB9CD]=36321;   // HANGUL SYLLABLE
   sortTable[0xB9CE]=36322;   // HANGUL SYLLABLE
   sortTable[0xB9CF]=36323;   // HANGUL SYLLABLE
   sortTable[0xB9D0]=36324;   // HANGUL SYLLABLE
   sortTable[0xB9D1]=36325;   // HANGUL SYLLABLE
   sortTable[0xB9D2]=36326;   // HANGUL SYLLABLE
   sortTable[0xB9D3]=36327;   // HANGUL SYLLABLE
   sortTable[0xB9D4]=36328;   // HANGUL SYLLABLE
   sortTable[0xB9D5]=36329;   // HANGUL SYLLABLE
   sortTable[0xB9D6]=36330;   // HANGUL SYLLABLE
   sortTable[0xB9D7]=36331;   // HANGUL SYLLABLE
   sortTable[0xB9D8]=36332;   // HANGUL SYLLABLE
   sortTable[0xB9D9]=36333;   // HANGUL SYLLABLE
   sortTable[0xB9DA]=36334;   // HANGUL SYLLABLE
   sortTable[0xB9DB]=36335;   // HANGUL SYLLABLE
   sortTable[0xB9DC]=36336;   // HANGUL SYLLABLE
   sortTable[0xB9DD]=36337;   // HANGUL SYLLABLE
   sortTable[0xB9DE]=36338;   // HANGUL SYLLABLE
   sortTable[0xB9DF]=36339;   // HANGUL SYLLABLE
   sortTable[0xB9E0]=36340;   // HANGUL SYLLABLE
   sortTable[0xB9E1]=36341;   // HANGUL SYLLABLE
   sortTable[0xB9E2]=36342;   // HANGUL SYLLABLE
   sortTable[0xB9E3]=36343;   // HANGUL SYLLABLE
   sortTable[0xB9E4]=36344;   // HANGUL SYLLABLE
   sortTable[0xB9E5]=36345;   // HANGUL SYLLABLE
   sortTable[0xB9E6]=36346;   // HANGUL SYLLABLE
   sortTable[0xB9E7]=36347;   // HANGUL SYLLABLE
   sortTable[0xB9E8]=36348;   // HANGUL SYLLABLE
   sortTable[0xB9E9]=36349;   // HANGUL SYLLABLE
   sortTable[0xB9EA]=36350;   // HANGUL SYLLABLE
   sortTable[0xB9EB]=36351;   // HANGUL SYLLABLE
   sortTable[0xB9EC]=36352;   // HANGUL SYLLABLE
   sortTable[0xB9ED]=36353;   // HANGUL SYLLABLE
   sortTable[0xB9EE]=36354;   // HANGUL SYLLABLE
   sortTable[0xB9EF]=36355;   // HANGUL SYLLABLE
   sortTable[0xB9F0]=36356;   // HANGUL SYLLABLE
   sortTable[0xB9F1]=36357;   // HANGUL SYLLABLE
   sortTable[0xB9F2]=36358;   // HANGUL SYLLABLE
   sortTable[0xB9F3]=36359;   // HANGUL SYLLABLE
   sortTable[0xB9F4]=36360;   // HANGUL SYLLABLE
   sortTable[0xB9F5]=36361;   // HANGUL SYLLABLE
   sortTable[0xB9F6]=36362;   // HANGUL SYLLABLE
   sortTable[0xB9F7]=36363;   // HANGUL SYLLABLE
   sortTable[0xB9F8]=36364;   // HANGUL SYLLABLE
   sortTable[0xB9F9]=36365;   // HANGUL SYLLABLE
   sortTable[0xB9FA]=36366;   // HANGUL SYLLABLE
   sortTable[0xB9FB]=36367;   // HANGUL SYLLABLE
   sortTable[0xB9FC]=36368;   // HANGUL SYLLABLE
   sortTable[0xB9FD]=36369;   // HANGUL SYLLABLE
   sortTable[0xB9FE]=36370;   // HANGUL SYLLABLE
   sortTable[0xB9FF]=36371;   // HANGUL SYLLABLE
   sortTable[0xBA00]=36372;   // HANGUL SYLLABLE
   sortTable[0xBA01]=36373;   // HANGUL SYLLABLE
   sortTable[0xBA02]=36374;   // HANGUL SYLLABLE
   sortTable[0xBA03]=36375;   // HANGUL SYLLABLE
   sortTable[0xBA04]=36376;   // HANGUL SYLLABLE
   sortTable[0xBA05]=36377;   // HANGUL SYLLABLE
   sortTable[0xBA06]=36378;   // HANGUL SYLLABLE
   sortTable[0xBA07]=36379;   // HANGUL SYLLABLE
   sortTable[0xBA08]=36380;   // HANGUL SYLLABLE
   sortTable[0xBA09]=36381;   // HANGUL SYLLABLE
   sortTable[0xBA0A]=36382;   // HANGUL SYLLABLE
   sortTable[0xBA0B]=36383;   // HANGUL SYLLABLE
   sortTable[0xBA0C]=36384;   // HANGUL SYLLABLE
   sortTable[0xBA0D]=36385;   // HANGUL SYLLABLE
   sortTable[0xBA0E]=36386;   // HANGUL SYLLABLE
   sortTable[0xBA0F]=36387;   // HANGUL SYLLABLE
   sortTable[0xBA10]=36388;   // HANGUL SYLLABLE
   sortTable[0xBA11]=36389;   // HANGUL SYLLABLE
   sortTable[0xBA12]=36390;   // HANGUL SYLLABLE
   sortTable[0xBA13]=36391;   // HANGUL SYLLABLE
   sortTable[0xBA14]=36392;   // HANGUL SYLLABLE
   sortTable[0xBA15]=36393;   // HANGUL SYLLABLE
   sortTable[0xBA16]=36394;   // HANGUL SYLLABLE
   sortTable[0xBA17]=36395;   // HANGUL SYLLABLE
   sortTable[0xBA18]=36396;   // HANGUL SYLLABLE
   sortTable[0xBA19]=36397;   // HANGUL SYLLABLE
   sortTable[0xBA1A]=36398;   // HANGUL SYLLABLE
   sortTable[0xBA1B]=36399;   // HANGUL SYLLABLE
   sortTable[0xBA1C]=36400;   // HANGUL SYLLABLE
   sortTable[0xBA1D]=36401;   // HANGUL SYLLABLE
   sortTable[0xBA1E]=36402;   // HANGUL SYLLABLE
   sortTable[0xBA1F]=36403;   // HANGUL SYLLABLE
   sortTable[0xBA20]=36404;   // HANGUL SYLLABLE
   sortTable[0xBA21]=36405;   // HANGUL SYLLABLE
   sortTable[0xBA22]=36406;   // HANGUL SYLLABLE
   sortTable[0xBA23]=36407;   // HANGUL SYLLABLE
   sortTable[0xBA24]=36408;   // HANGUL SYLLABLE
   sortTable[0xBA25]=36409;   // HANGUL SYLLABLE
   sortTable[0xBA26]=36410;   // HANGUL SYLLABLE
   sortTable[0xBA27]=36411;   // HANGUL SYLLABLE
   sortTable[0xBA28]=36412;   // HANGUL SYLLABLE
   sortTable[0xBA29]=36413;   // HANGUL SYLLABLE
   sortTable[0xBA2A]=36414;   // HANGUL SYLLABLE
   sortTable[0xBA2B]=36415;   // HANGUL SYLLABLE
   sortTable[0xBA2C]=36416;   // HANGUL SYLLABLE
   sortTable[0xBA2D]=36417;   // HANGUL SYLLABLE
   sortTable[0xBA2E]=36418;   // HANGUL SYLLABLE
   sortTable[0xBA2F]=36419;   // HANGUL SYLLABLE
   sortTable[0xBA30]=36420;   // HANGUL SYLLABLE
   sortTable[0xBA31]=36421;   // HANGUL SYLLABLE
   sortTable[0xBA32]=36422;   // HANGUL SYLLABLE
   sortTable[0xBA33]=36423;   // HANGUL SYLLABLE
   sortTable[0xBA34]=36424;   // HANGUL SYLLABLE
   sortTable[0xBA35]=36425;   // HANGUL SYLLABLE
   sortTable[0xBA36]=36426;   // HANGUL SYLLABLE
   sortTable[0xBA37]=36427;   // HANGUL SYLLABLE
   sortTable[0xBA38]=36428;   // HANGUL SYLLABLE
   sortTable[0xBA39]=36429;   // HANGUL SYLLABLE
   sortTable[0xBA3A]=36430;   // HANGUL SYLLABLE
   sortTable[0xBA3B]=36431;   // HANGUL SYLLABLE
   sortTable[0xBA3C]=36432;   // HANGUL SYLLABLE
   sortTable[0xBA3D]=36433;   // HANGUL SYLLABLE
   sortTable[0xBA3E]=36434;   // HANGUL SYLLABLE
   sortTable[0xBA3F]=36435;   // HANGUL SYLLABLE
   sortTable[0xBA40]=36436;   // HANGUL SYLLABLE
   sortTable[0xBA41]=36437;   // HANGUL SYLLABLE
   sortTable[0xBA42]=36438;   // HANGUL SYLLABLE
   sortTable[0xBA43]=36439;   // HANGUL SYLLABLE
   sortTable[0xBA44]=36440;   // HANGUL SYLLABLE
   sortTable[0xBA45]=36441;   // HANGUL SYLLABLE
   sortTable[0xBA46]=36442;   // HANGUL SYLLABLE
   sortTable[0xBA47]=36443;   // HANGUL SYLLABLE
   sortTable[0xBA48]=36444;   // HANGUL SYLLABLE
   sortTable[0xBA49]=36445;   // HANGUL SYLLABLE
   sortTable[0xBA4A]=36446;   // HANGUL SYLLABLE
   sortTable[0xBA4B]=36447;   // HANGUL SYLLABLE
   sortTable[0xBA4C]=36448;   // HANGUL SYLLABLE
   sortTable[0xBA4D]=36449;   // HANGUL SYLLABLE
   sortTable[0xBA4E]=3