/*******************************************************************************
*
* FILE:          sortlib.h
*
* SW-COMPONENT:  Sorting Lib
*
* PROJECT:       Bosch-GM-NextGen
*
* DESCRIPTION:   Sorting Lib for Sqlite
*
* AUTHOR:        Nishant Parashar
*
* COPYRIGHT:     (c) 2011 MontaVista Software LLC
*
*******************************************************************************/

#ifndef SORTLIB_H
#define SORTLIB_H

#include <sqlite3.h>
#include "sortlib_helper.h"

/*
** After registering the new sort function using sortlib_register_sort_function
** Use this macro for getting the sorted data from the sqlite database.
** The sql query should contain the "COLLATE" clause, for e.g.:-
** "SELECT * FROM tableName ORDER BY columnName COLLATE "SORTLIB_COLLATE_NAME //Macro use
**                ---OR---
** "SELECT * FROM tableName ORDER BY columnName COLLATE SORT_LIB" //Direct use
*/

#ifdef __cplusplus
extern "C"
{
  int sortlib_register_sort_function( sqlite3* handle );
  int sortlib_compare(const void *string1, const void *string2);
  int sortlib_old_compare(const void *string1, const void *string2);
  int sortlib_string_compare(const char* string1, int len1, const char* string2, int len2);
  unsigned sortlib_get_char_sort_prio(unsigned u32Unicode32BitCodePoint);  // function added for vertical keyboard
}
#else

  int sortlib_register_sort_function( sqlite3* handle );
  int sortlib_compare(const void *string1, const void *string2);
  int sortlib_old_compare(const void *string1, const void *string2);
  int sortlib_string_compare(const char* string1, int len1, const char* string2, int len2);
  unsigned sortlib_get_char_sort_prio(unsigned u32Unicode32BitCodePoint);  // function added for vertical keyboard

#endif //__cplusplus

#endif  //SORTLIB_H
