/*
 * MTPCusror.h
 *
 *  Created on: Dec 26, 2013
 *      Author: Dinesh
 */

#ifndef MTPCURSOR_H_
#define MTPCURSOR_H_

#include <sqlite3.h>
#include "libmtp.h"   // use mediaplayer specific libmtp
#include "RequestResponseSM.h"


class RequestResponseMTPControl: public RequestResponseSM
{

    int HandleInitRequest()
    {
        tResult res = 0;
        return res;
    }

    int HandleEntryWaitingRequest()
    {
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {

        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        if(allParameters != NULL)
        {
            tFiles *fileInfoPtr;
            SMF::UnMarshal(allParameters, "p" ,&fileInfoPtr);
            if(NULL != (fileInfoPtr))
            {
                mFileInfo = *fileInfoPtr;
                delete fileInfoPtr;
                isEOF = false;
            }
        }
        return 0;
    }

public:

        tFiles  mFileInfo;
        bool    isEOF;
        RequestResponseMTPControl()
        {
           isEOF = false;
           memset(&mFileInfo, 0, sizeof(mFileInfo));
           mFileInfo.type = FT_UNKNOWN;
           mFileInfo.objectID = OBJECT_ID_NONE;
           mFileInfo.fileFormat = FFT_UNKNOWN;
           mFileInfo.notPlayable = FNP_PLAYABLE;
           mFileInfo.isPlaying = false;
           mFileInfo.trackNumber = 0;
        }
};


typedef struct
{
    sqlite3_vtab base;
    sqlite3 *db;
} tVTMTP;

typedef struct
{
    sqlite3_vtab_cursor          base;
    tIndex                       rowIndex;
    tMountPoint                  mountPoint;
    tPath                        path;
    RequestResponseMTPControl    *rrMTPControl;

} tVTMTPCursor;

/* Update cursor to point to next top-level directory to search, if any. */
int MTPCursorNext(tVTMTPCursor *p_cur);

#endif /* MTPCURSOR_H_ */
