/*
 * MTPCursor.cpp
 *
 *  Created on: Dec 26, 2013
 *      Author: Dinesh
 */


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_MTP
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPCursor.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_MTP
#endif
#endif

#include "MTPCursor.h"
#include "MTPCache.h"
#include "TypeDefinitions.h"
#include <string.h>
// thoemel: removed; is not needed #include <ptp.h>
#include "FastUTF8.h"
#include <stdlib.h>
#include "FunctionTracer.h"
//#include "VarTrace.h"

/*lint -save -e1773 */

#ifdef TARGET_BUILD
#include "LocalSPM.h"
#endif

/*disable debug printf for release*/
#define debug //

/*enable debug printf for PC development*/
//#define debug

int MTPCursorNext(tVTMTPCursor *p_cur)
{
    /*send read cache entry event to mtpcontrol sm */

    ENTRY_INTERNAL

    char msgToSendString[64];
    int res = SQLITE_OK;

    strncpy_r(OUT msgToSendString, IN "MTPControlSM::MTP_GET_FOLDER_ITEM", IN sizeof(msgToSendString));

    tAllParameters parameterString;

    if((NULL != p_cur) && (NULL != p_cur->rrMTPControl))
    {
        p_cur->rrMTPControl->isEOF = true;
        p_cur->rrMTPControl->Marshal(parameterString, sizeof(parameterString) - 1,
                tMountPoint_format tPath_format tIndex_format ,p_cur->mountPoint,p_cur->path,p_cur-> rowIndex);

        /* do the request and wait for the answer */
        res = p_cur->rrMTPControl->DoEventAnswer(msgToSendString, parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);

        if (res) { // request did not happen
            return SQLITE_ERROR ;
        }

        if(true == p_cur->rrMTPControl->isEOF)
        {
            ETG_TRACE_USR3(("End of the query reached"));
            return SQLITE_OK;
        }
       ETG_TRACE_USR3(("Filename received is %s",p_cur->rrMTPControl->mFileInfo.fileName));
       p_cur->rowIndex ++;
       return SQLITE_OK;
    }
    else
        return SQLITE_ERROR;
}
