/**************************************************************************//**
* \file      VTCursor.cpp
* \ingroup   MediaPlayer
*
*            Implementation of Filesystem virtual table.
*			 The functions implemented here implement cursor and relevant functions.
*            See .h file for description.
*
* \remark    Copyright: 2012, Robert Bosch Car Multimedia GmbH, Hildesheim
* \remark    Scope:     MediaPlayer
* \remark    Authors:
* 			 - Matthias Thömel
*            - CM-AI/PJ-CD6 Xu Benny
******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "IPODCursor.h"
#include "TypeDefinitions.h"
#ifdef TARGET_BUILD
# include "LocalSPM.h"
#endif

//global fake flag for VTIPOD tests
extern int globalFakeTheIpod;

int IPODCursorNext(tVTIPODCursor *cursor) // finished: 100%
{
	//tVTIPOD *p_vt = (tVTIPOD*)((sqlite3_vtab_cursor*)cursor)->pVtab;
	char sendMessage[1024];
	char parameter[1024];
	int res;

	//printf("IPODCursorNext: %d\n",cursor->objectCount_rowID);
	cursor->rrIPODControl->IPODID = 0; //reset to default: endOfDataset [GMMY16-25050]

#ifdef TARGET_BUILD
	string cacheValue;
	const bool cachedVTRecord = !globalFakeTheIpod && (MP_NO_ERROR
			== LocalSPM::GetIPODControl().GetVTRecordFromCache(cacheValue,
					cursor->IPODMountpoint, (tListType)cursor->listType, cursor->tag1.tag,
					cursor->tag2.tag, cursor->tag3.tag, cursor->tag4.tag,
					cursor->objectCount_rowID, cursor->limit, cursor->offset));
	if (cachedVTRecord) {
		//Raise performance: retrieve cached metadata directly from iPodControl, NOT using SMF
		cursor->rrIPODControl->HandleSuccessRequest(cacheValue.c_str());
	} else
#endif
	{
		/* ask the ipod control for one element */
		if (globalFakeTheIpod) {
			// this message goes to the request sm to simulate the ipod control
			snprintf(sendMessage, sizeof(sendMessage), "%s::%s",
					cursor->rrIPODControl->GetSMNameFull(), "LOOP_BACK_MESSAGE");
		} else {
			// this message goes to the ipod control:
			snprintf(sendMessage, sizeof(sendMessage), "%s::%s",
					"iPodControlSM", "GET_VIRTUAL_METADATA");
		}

		/* generate the parameters for the request */
		cursor->rrIPODControl->Marshal(parameter, sizeof(parameter) - 1,
				"tiiiiiiii", cursor->IPODMountpoint, cursor->listType,
				cursor->tag1.tag, cursor->tag2.tag, cursor->tag3.tag, cursor->tag4.tag,
				cursor->objectCount_rowID, cursor->limit, cursor->offset);

		/* do the request and wait for the answer */
		res = cursor->rrIPODControl->DoEventAnswer(sendMessage, parameter, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);
		if (res) { // request did not happen
			return SQLITE_ERROR;
		}
	}
	/* No more directories to search. End of result set. */
    if (cursor->rrIPODControl->IPODID == 0) {
        cursor->endOfDataset = 1;
        return SQLITE_OK;
    }

    /* set the return values */
    cursor->IPODCount = cursor->rrIPODControl->IPODCount;
    strncpy_r(cursor->IPODName, cursor->rrIPODControl->IPODName, sizeof(cursor->IPODName));
    strncpy_r(cursor->IPODURL, cursor->rrIPODControl->IPODURL, sizeof(cursor->IPODURL));
    cursor->IPODID = cursor->rrIPODControl->IPODID;
    strncpy_r(cursor->IPODUUID, cursor->rrIPODControl->IPODUUID, sizeof(cursor->IPODUUID));
    cursor->IPODActive = cursor->rrIPODControl->IPODActive;
    cursor->IPODTrackNumber = cursor->rrIPODControl->IPODTrackNumber;

    /* increase the row id */
    cursor->objectCount_rowID++;

    return SQLITE_OK;
}

