/*
 * VTFileTypes.h
 *
 *  Created on: Jun 27, 2013
 *      Author: matthias,dinesh
 */

#ifndef VTFILETYPES_H_
#define VTFILETYPES_H_

#include <unistd.h>
#include <string>
#include <totem-pl-parser.h>

#include "VTFileContext.h"

using namespace std;
/**
 * Type for the file type from the virtual table file system
 */
typedef enum
{
    FILE_TYPE_DIRECTORY = 0,
    FILE_TYPE_PLAYLIST,
    FILE_TYPE_AUDIOOBJECT,
    FILE_TYPE_VIDEOOBJECT,
    FILE_TYPE_IMAGE,
    FILE_TYPE_UNKNOWN,
    FILE_TYPE_FAILED
} tVTFileType;

typedef enum {
    FFT_MP3 = 0UL,      /**< MP3 audio file format */
    FFT_WMA = 1UL,      /**< Windows Media Audio (WMA) file format */
    FFT_AAC = 2UL,      /**< Advanced Audio Coding (AAC) audio file format */
    FFT_AAC_PLUS = 3UL, /**< High-Efficiency Advanced Audio Coding audio file format */
    FFT_M4A = 4UL,      /**< M4A container format for audio */
    FFT_MP4 = 5UL,      /**< MP4 Container format for audio and video */
    FFT_WAV = 6UL,      /**< Waveform (WAV) audio file format */
    FFT_OGG = 7UL,      /**< Ogg Vorbis audio file format */
    FFT_3GP = 8UL,      /**< 3GP and 3GPP container format for audio and video */
    FFT_3G2 = 9UL,      /**< 3G2 and 3GPP2 container format for audio and video */
    FFT_AIFF = 10UL,    /**< Audio Interchange File Format (AIFF) */
    FFT_AA = 11UL,      /**< Audible.com Audio Books */
    FFT_SBC = 12UL,     /**< Bluetooth Sub-Band Coding audio file format */
    FFT_MPEG = 13UL,    /**< MPEG video file format */
    FFT_AVI = 14UL,     /**< Audio Video Interleave (AVI) file format */
    FFT_MOV = 15UL,     /**< QuickTime multimedia format */
    FFT_DIVX = 16UL,    /**< DIVX file format */
    FFT_WMV = 17UL,     /**< Windows Media Video (WMV) file format */
    FFT_M4V = 18UL,     /**< iTunes Video file format */
    FFT_FLV = 19UL,     /**< Flash video format */
    FFT_M3U = 20UL,     /**< M3U playlist format */
    FFT_PLS = 21UL,     /**< PLS playlist format */
    FFT_XSPF = 22UL,    /**< XSPF playlist format */
    FFT_WPL = 23UL,     /**< WPL playlist format */
    FFT_B4S = 24UL,     /**< B4S playlist format */
    FFT_ASX = 25UL,     /**< ASX playlist format */
    FFT_JPEG = 26UL,	/**< JPEG image format */
	FFT_GIF = 27UL,	    /**< GIF image format */
    FFT_BMP = 28UL,	    /**< BMP image format */
    FFT_PNG = 29UL,	    /**< PNG image format */
    FFT_TIF = 30UL,     /**< TIF image format */
    FFT_FLAC = 31UL,    /**< Free Lossless Audio Codec (FLAC) audio file format */
    FFT_M4B = 32UL,     /**< iTunes Audiobook file format */
    FFT_M4P = 33UL,     /**< DRM protected iTunes file format */
    FFT_M4R = 34UL,     /**< iTunes Ringtone file format */
    FFT_MKV = 35UL,     /**< MKV Video file format */
    FFT_UNKNOWN = 999UL
} tVTFileFormat;

typedef struct tFileSystemNode_tag
{
    DIR *           directoryEntry;     // active opened directory stream
    struct dirent   *entry;             // file entry from the above directory stream pointed by the node
    char            *path;              // path of the file entry inside the mount point
    tVTFileType     fileType;           // type of the file entry like audio,video,directory,playlists, unknown etc
    vector<string>  *playListStrings;
    int openPlParserHandles;
    tFileSystemNode_tag     *parentNode;
    //weg bool isCacheValid;
} tFileSystemNode;

typedef struct
{
    sqlite3_vtab_cursor base;
    const char          *mountPoint;
    tFileSystemNode     *currentNode;
    int                 objectCount_rowID;
    int                 endOfDataset;
    tVTFileType         fileType;           // type of the file entry like audio,video,directory,playlists, unknown etc
    tVTFileFormat       fileFormat;
    const char          *playListEntryPath;
    const char          *playListEntryName;
    bool                recursive;
} tVTFileSystemCursor;


typedef struct
{
    sqlite3_vtab base;
    tVTFileContext *context;
} tVTFileSystem;

#endif /* VTFILETYPES_H_ */
