/*
 * VTBluetooth.cpp
 *
 *  Created on: Oct 21, 2013
 *      Author: pee1cob
 */
 
 
 
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#ifdef TARGET_BUILD
#include "trcGenProj/Header/VTBluetooth.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include "Utf8FileName.h"
#include "FastUTF8.h"
#include "BTCursor.h"
#include "VTBluetooth.h"
#include <glib.h>
#include <sqlite3ext.h>
#include<sstream>
#include "FunctionTracer.h"
//#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"
#include "TimeTrace.h"


SQLITE_EXTENSION_INIT1

typedef struct _VTBluetooth
{
    void *contextPointer ;
} VTBluetooth;
static VTBluetooth self ;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* DDL defining the structure of the vtable */
//static const char* ddl = "create table vtable (mountpoint text, path text,filename text,type integer, format integer,uid text) ";
static const char* ddl = "create table vtable (mountpoint text, path text,filename text,type integer, format integer,uid text,count integer,LTY integer,_limit integer,_offset integer) ";
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static int VTBluetoothCreate( sqlite3 *db, void *p_aux, int argc, const char * const* argv , sqlite3_vtab **pp_vt,   char **pzErr ) // finished: 100%
{
    ENTRY_INTERNAL

    (void)argc;
    (void)argv;
    (void)p_aux;
    (void)pzErr;
    tVTBluetooth *vTabObject;
    int rc;

    /* allocate the virtual table object */
    vTabObject = (tVTBluetooth *)sqlite3_malloc(sizeof(tVTBluetooth));
    if (!vTabObject) return SQLITE_NOMEM;
    memset(vTabObject, 0, sizeof(tVTBluetooth));

    /* declare the table to the sqlite */
    rc = sqlite3_declare_vtab(db, ddl);
    if(rc != SQLITE_OK)
    {
        sqlite3_free(vTabObject);
        return SQLITE_ERROR;
    }

     /* set the user context */
     vTabObject->context = (tVTBluetoothContext *)p_aux;

     /* set the resulting pointer to new vtab struct */
     *pp_vt = (sqlite3_vtab *)vTabObject;


     //Initialize the Path Variable
     //CurrentReqPath = NULL;
     //CurrentBrowsePath = NULL;

     return SQLITE_OK;
}

static int VTBluetoothConnect( sqlite3 *db, void *p_aux, int argc, const char * const *argv, sqlite3_vtab **pp_vt, char **pzErr ) // finished: 100%
{
    return VTBluetoothCreate(db, p_aux, argc, argv, pp_vt, pzErr);
}

static int VTBluetoothDestructor(sqlite3_vtab *pVtab) // finished: 100%
{
    ENTRY_INTERNAL

    tVTBluetooth *p = (tVTBluetooth*)pVtab; //lint !e826

    sqlite3_free(p);

    return 0;
}

static int VTBluetoothDisconnect(sqlite3_vtab *pVtab) // finished: 100%
{
    return VTBluetoothDestructor(pVtab);
}

static int VTBluetoothDestroy(sqlite3_vtab *pVtab) // finished: 100%
{
    return VTBluetoothDestructor(pVtab);
}

static int VTBluetoothOpen(sqlite3_vtab *pVTab, sqlite3_vtab_cursor **pp_cursor) // finished: 100%
{
    ENTRY_INTERNAL

    tVTBluetooth* p_vt         = (tVTBluetooth*)pVTab; //lint !e826
    p_vt->base.zErrMsg = NULL;

    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)sqlite3_malloc(sizeof(tVTBluetoothCursor));
    if (cursor == NULL) {
        return SQLITE_NOMEM;
	}
    /* reset memory */
    memset(cursor, 0, sizeof(tVTBluetoothCursor));

    /* create the request/response state machine */
    cursor->rrBTControl = new(RequestResponseBTControl);

    *pp_cursor = (sqlite3_vtab_cursor*)cursor;
    return SQLITE_OK;
}

static int VTBluetoothClose(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY_INTERNAL

    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)cur;  //lint !e826

    /* free the request/response stte machine */
    delete cursor->rrBTControl;

    //free the ItemName,mountPoint,Path,UID
    if(cursor->ItemName!=NULL)
    {
        free(cursor->ItemName);
    }
    
    if(cursor->mountPoint!=NULL)
    {
        free(cursor->mountPoint);
    }
 
    if(cursor->Path!=NULL)
    {
        free(cursor->Path);
    }
    if(cursor->ItemUID!=NULL)
    {
        delete[] cursor->ItemUID;
    }
    /* free cursor memory */
    sqlite3_free(cursor);

    return SQLITE_OK;
}

//doubt:For CreateMediaPlayerFileList Filter wont get called ?
static int VTBluetoothFilter( sqlite3_vtab_cursor *p_vtc, int idxNum, const char *idxStr, int argc, sqlite3_value **argv ) // finished: 80%
{
    ENTRY_INTERNAL
    (void)idxNum;
    (void)idxStr;

    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)p_vtc; //lint !e826

    /* set the mount point, it is the first where-clause-part */
    ETG_TRACE_USR4(("argc:%d",argc));
    /* set the search path, it could be the second where-clause-part */
    if(argc >= 2)
    {
        /* set the mount point, it is the first where-clause-part */
        cursor->mountPoint = strdup( (const char*) (sqlite3_value_text(argv[0])) );
        string pathName = string((const char*)sqlite3_value_text(argv[1]));
        size_t pathlength = strlen((const char*)sqlite3_value_text(argv[1]));

        if(0 == pathlength)
        {
            cursor->Path = strdup("/");
        }
        else if(pathlength >1 && pathName[pathlength-1] == '/')
        {
            pathName.erase(pathlength-1,1);
            cursor->Path = strdup(pathName.c_str());
        }
        else
        {
            cursor->Path = strdup( (const char*) (sqlite3_value_text(argv[1])));
        }

        if(argc == 3){ //LTY_BLUETOOTH_FILELIST_COUNT
            cursor->listType  = sqlite3_value_int(argv[2]);

            //Count request could be served in one cursor read.
            cursor->limit = 1;
            cursor->offset = 0;
            cursor->RequestedRowCount = 1;
        }
        else if(argc == 6){ //LTY_BLUETOOTH_FILELIST
            cursor->ItemType  = sqlite3_value_int(argv[2]); //TODO(Reenu):ItemType not coming properly .Why ???
            cursor->listType =sqlite3_value_int(argv[3]);
            cursor->limit  =sqlite3_value_int(argv[4]);
            cursor->offset =sqlite3_value_int(argv[5]);
            cursor->RequestedRowCount = cursor->offset+1;
			
			//TODO(Reenu):If argCount == 6;then it should be mountpoint,path,listType,(limit,offset,itemType) - print only those
        }
		
		//TODO(Reenu):Move tracing into above if-else based on argc
        ETG_TRACE_USR3(("cursor->mountPoint is %s",cursor->mountPoint));
        ETG_TRACE_USR3(("cursor->Path is %s",cursor->Path));
        ETG_TRACE_USR3(("cursor->listType is %d",cursor->listType));
        ETG_TRACE_USR3(("cursor->limit is %d",cursor->limit)); 
        ETG_TRACE_USR3(("cursor->offset is %d",cursor->offset));
        //ETG_TRACE_USR3(("cursor->ItemType is %d",cursor->ItemType)); --currently it is always FILE_TYPE_UNKNOWN
        ETG_TRACE_USR3(("cursor->RequestedRowCount is %d",cursor->RequestedRowCount));
    }
    else
    {
        return SQLITE_ERROR;
    }

	//Cursor Preparation.
	//If valid Path given,use VTBluetoothCursorNext to prepare cursor.
	//Else(ie dummy-now-playing path given),donot call VTBluetoothCursorNext.Instead, prepare locally
    if(!strcmp(cursor->Path,"dummy-now-playing"))
    {
		SetupDummyCursor(INOUT cursor);
	}
    else if(!strcmp(cursor->Path,"now-playing"))
    {
        strncpy(cursor->Path,"/NowPlaying",sizeof("/NowPlaying"));
        ETG_TRACE_USR3(("cursor-> path is %s",cursor->Path));
        tInteger SqliteResult = VTBluetoothCursorNext(cursor);
		
		//why this workaround.?Why ChangePath to Nowplaying failed.?If fails why not giving invalid row ?
		//In this workaround,the count is made 1.So reading next row will fail:LTY_BLUETOOTH_FILELIST_COUNT.
		//But with this workaround,reading next row with LTY_BLUETOOTH_FILELIST will not fail.Because:isEOF checks for other params!==> due to this GetPositionInList goes on endlessly
        if(SQLITE_ERROR == SqliteResult) 
        {
			SetupDummyCursor(INOUT cursor);
        }
    }
    else
    {
        tInteger SqliteResult = VTBluetoothCursorNext(cursor);
        if(SQLITE_ERROR == SqliteResult)
        {
            //return 1;
        }
    }
    return 0;
}

static int VTBluetoothNext(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY_INTERNAL
    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)cur; //lint !e826

    cursor->RequestedRowCount++;
	
	//For path:"dummy-now-playing" only 1 dummy cursor available.Hence,xNext(..) not possible
	//Hence,advance cursor to invalid row
	if(!strcmp(cursor->Path,"dummy-now-playing"))
	{
		SetupInvalidCursor(cursor);
	}
	else
	{	
		tInteger SqliteResult = VTBluetoothCursorNext(cursor);
	
		if(SQLITE_ERROR == SqliteResult)
		{
			//return 1;
		}
	}
    
	return SQLITE_OK;
}

static int VTBluetoothEof(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY_INTERNAL

    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)cur; //lint !e826
    bool result = false;
	
    if((LTY_BLUETOOTH_FILELIST_COUNT == cursor->listType) && (cursor->RequestedRowCount > 1))
    {
        result = true;
    }
    else if((LTY_BLUETOOTH_FILELIST == cursor->listType) && (cursor->ItemType == INVALID))
    {
        result = true;
    }

    return result;
}

static int VTBluetoothColumn(sqlite3_vtab_cursor *cur, sqlite3_context *ctx, int i) // finished: 80%
{
    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)cur; //lint !e826
    //tFileSystemNode* currentNode = cursor->currentNode;

    switch (i)
    {
        case 0: // mountpoint
            if(cursor->mountPoint != NULL)
            {
                sqlite3_result_text(ctx, cursor->mountPoint, strlen_r(cursor->mountPoint), SQLITE_STATIC);
            }
            //ETG_TRACE_USR3(("cursor->mountPoint is %s",cursor->mountPoint));
            break;

        case 1: // Cuurent Browsed path
            if(cursor->Path != NULL)
            {
                sqlite3_result_text(ctx,cursor->Path, strlen_r(cursor->Path), SQLITE_STATIC);
            }
            //ETG_TRACE_USR3(("cursor->Path is %s",cursor->Path));
            break;

        case 2: // name
            if(cursor->ItemName != NULL)
            {
                sqlite3_result_text(ctx,cursor->ItemName, strlen_r(cursor->ItemName), SQLITE_STATIC);
            }
            //ETG_TRACE_USR3(("cursor->ItemName is %s",cursor->ItemName));
            break;

        case 3: // type
            switch(cursor->ItemType)
            {
                case AUDIO_FILE:
                case MEDIA_ELEMENT:
                    sqlite3_result_int(ctx,FT_AUDIO);
                    //ETG_TRACE_USR3(("FT_AUDIO"));
                    break;

                case VIDEO_FILE:
                    sqlite3_result_int(ctx,FT_VIDEO);
                    //ETG_TRACE_USR3(("FT_VIDEO"));
                    break;

                case FOLDER:
                    sqlite3_result_int(ctx,FT_FOLDER);
                    //ETG_TRACE_USR3(("FT_FOLDER"));
                    break;

                default:
                    sqlite3_result_int(ctx,FT_UNKNOWN);
                    //ETG_TRACE_USR3(("FT_UNKNOWN"));
                    break;
            }
            break;

        case 4: // format
            sqlite3_result_int(ctx,cursor->FileFormat);
            break;

        case 5: // uid
            ETG_TRACE_USR3(("cursor->ItemUID is %s",cursor->ItemUID));
            if(cursor->ItemUID != NULL)
            {
                sqlite3_result_text(ctx,cursor->ItemUID, strlen_r(cursor->ItemUID), SQLITE_STATIC);
            }
            break;
        case 6:
            ETG_TRACE_USR3(("cursor->count is %d",cursor->count));
            sqlite3_result_int(ctx,  cursor->count);
            break;
        case 7:
            ETG_TRACE_USR3(("cursor->listType is %d",cursor->listType));
            sqlite3_result_int(ctx,  cursor->listType);
            break;

        case 8:
            ETG_TRACE_USR3(("cursor->limit is %d",cursor->limit));
            sqlite3_result_int(ctx,  cursor->limit);
            break;

        case 9:
            ETG_TRACE_USR3(("cursor->offset is %d",cursor->offset));
            sqlite3_result_int(ctx,  cursor->offset);
            break;

        default:
            sqlite3_result_int(ctx, 0);
            break;
    }

    return SQLITE_OK;
}

static int VTBluetoothRowid(sqlite3_vtab_cursor *cur, sqlite_int64 *p_rowid) // finished: 100%
{
    tVTBluetoothCursor *cursor = (tVTBluetoothCursor*)cur; //lint !e826

    /* Just use the current row count as the rowid. */
//    *p_rowid = cursor->objectCount_rowID;
	
	*p_rowid = cursor->RequestedRowCount;
	
	//TODO(Reenu):add print
    return SQLITE_OK;
}
static int VTBluetoothBestIndex(sqlite3_vtab *tab, sqlite3_index_info *pIdxInfo) // finished: 100%
{

    (void)tab;

    int ops = SQLITE_INDEX_CONSTRAINT_MATCH | SQLITE_INDEX_CONSTRAINT_EQ |SQLITE_INDEX_CONSTRAINT_LT;
    ETG_TRACE_USR4(("nConstraint:%d",pIdxInfo->nConstraint));
    for(int i =0;i<pIdxInfo->nConstraint;i++)
    {
        ETG_TRACE_USR3(("pIdxInfo->aConstraint[%d].iColumn:%d",i,pIdxInfo->aConstraint[i].iColumn));
        ETG_TRACE_USR3(("pIdxInfo->aConstraint[%d].op:%d",i,pIdxInfo->aConstraint[i].op));
        ETG_TRACE_USR3(("pIdxInfo->aConstraint[%d].usable:%d",i,pIdxInfo->aConstraint[i].usable));
        ETG_TRACE_USR3(("pIdxInfo->aConstraint[%d].iTermOffset:%d",i,pIdxInfo->aConstraint[i].iTermOffset));
    }
    vector<int> interestedColumnNo ={0,1,3,7,8,9};
    vector<int>::iterator it;
    for(int i =0;i<pIdxInfo->nConstraint;i++)
    {
        int x =pIdxInfo->aConstraint[i].iColumn;
        it =  find(interestedColumnNo.begin(),interestedColumnNo.end(),x);
        bool isInterestedCol = (it != interestedColumnNo.end());
        ETG_TRACE_USR4(("iColumn:%d isInterestedCol:%d",x,isInterestedCol));
        if(isInterestedCol &&(pIdxInfo->aConstraint[i].op & ops))
        {
            if((pIdxInfo->nConstraint == 6) || (pIdxInfo->nConstraint == 2))
            {
                switch(x)
                {
                    case 0:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 1;
                        break;
                    case 1:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 2;
                        break;
                    case 3:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 3;
                        break;
                    case 7:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 4;
                        break;
                    case 8:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 5;
                        break;
                    case 9:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 6;
                        break;
                    default:
                        break;

                }
            }
            else if(pIdxInfo->nConstraint == 3)
            {
                switch(x)
                // mountpoint in where
                {
                    case 0:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 1;
                        break;
                    case 1:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 2;
                        break;
                    case 7:
                        pIdxInfo->aConstraintUsage[i].argvIndex = 3;
                        break;
                    default:
                        break;
                }
            }
            // path in where
        }
        /* Then we want the value to be passed to xFilter() */
    }

    return SQLITE_OK;
}

static void VTBluetoothMatchFunction(sqlite3_context* ctx, int argc, sqlite3_value** argv) // finished: 100%
{
    (void)argc;
    (void)argv;
    sqlite3_result_int(ctx, 1);
}
static int VTBluetoothFindFunction( sqlite3_vtab *pVtab, int nArg,const char *zName,
                             void (**pxFunc)(sqlite3_context*,int,sqlite3_value**),
                             void **ppArg )
{
    (void)pVtab;
    (void)nArg;
    (void)ppArg;
    if(strcmp(zName, "match") == 0)
    {
        *pxFunc = VTBluetoothMatchFunction;

        return 1;
    }
    return SQLITE_OK;
}

static int VTBluetoothUpdate(sqlite3_vtab *pVTab,int argc,sqlite3_value **argv,sqlite_int64 *pRowid)
{
    (void)pVTab;
    (void)argc;
    (void)argv;
    (void)pRowid;
    // used to delete the cache matching with given mount point
    return SQLITE_OK;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
static sqlite3_module VTBluetoothModule =
{
    0, /* iVersion */
    VTBluetoothCreate, /* xCreate - create a vtable */
    VTBluetoothConnect, /* xConnect - associate a vtable with a connection */
    VTBluetoothBestIndex, /* xBestIndex - best index */
    VTBluetoothDisconnect, /* xDisconnect - disassociate a vtable with a connection */
    VTBluetoothDestroy, /* xDestroy - destroy a vtable */
    VTBluetoothOpen, /* xOpen - open a cursor */
    VTBluetoothClose, /* xClose - close a cursor */
    VTBluetoothFilter, /* xFilter - configure scan constraints */
    VTBluetoothNext, /* xNext - advance a cursor */
    VTBluetoothEof, /* xEof - inidicate end of result set*/
    VTBluetoothColumn, /* xColumn - read data */
    VTBluetoothRowid, /* xRowid - read data */
    VTBluetoothUpdate, /* xUpdate - write data */
    NULL, /* xBegin - begin transaction */
    NULL, /* xSync - sync transaction */
    NULL, /* xCommit - commit transaction */
    NULL, /* xRollback - rollback transaction */
    VTBluetoothFindFunction, /*  xFindFunction - function overloading */
    NULL, /* xRename - rename a vtable */
    NULL, /* xSavepoint */
    NULL, /* xRelease */
    NULL /* xRollbackTo */
};

void VTBluetoothEntrySetContext(void *context)
{
    self.contextPointer = context;

}
int VTBluetooth_register(sqlite3 *db, void *userContext) // finished: 100%
{
    int ret = sqlite3_create_module(db, "BluetoothVT", &VTBluetoothModule, userContext);

    return ret;
}

extern "C" int sqlite3_extension_init( sqlite3 *db, char **pzErrMsg, const sqlite3_api_routines *pApi ) // finished: 100%
{
    (void)pzErrMsg;
    SQLITE_EXTENSION_INIT2(pApi);

    if(VTBluetooth_register(db,self.contextPointer) != SQLITE_OK)
    {
        return SQLITE_ERROR;
    }
    return SQLITE_OK;
}
