/*
 * UCASort.c
 *
 *  Created on: Nov 29, 2013
 *      Author: din3kor
 */

#include "TraceDefinitions.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DB_MANAGER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/UCASort.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DB_MANAGER
#endif
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <glib.h>

#include "unicode/unistr.h"
#include "unicode/utypes.h"
#include "unicode/locid.h"
#include "unicode/coll.h"
#include "unicode/tblcoll.h"
#include "unicode/coleitr.h"
#include "unicode/sortkey.h"

#include "UCASort.h"

using namespace std;
#define SORTLIB_COLLATE_NAME "SORT_LIB"

/*member data*/
typedef struct _UCASort
{
    Collator *ucaCollator;
    Locale *locale;
    string language;
}UCASort;

/*singleton instance for UCA Sort implementation*/
static UCASort self;

static int UCASort_Compare(void* pCtx, int len1, const void* s1, int len2, const void* s2)
{
    (void)pCtx;

    /*take a copy of the strings which needs to be compared*/
    char* utf8String1 = new char[len1+1];;
    char* utf8String2 = new char[len2+1];

    memcpy(utf8String1,s1,len1);    utf8String1[len1] = 0;
    memcpy(utf8String2,s2,len2);    utf8String2[len2] = 0;

#if 0
    /*Convert the received UTF8 strings to pure Unicode Strings using icu UnicodeString utils*/
    UnicodeString unicodeString1 = UnicodeString::fromUTF8(utf8String1);
    UnicodeString unicodeString2 = UnicodeString::fromUTF8(utf8String2);
#else
    /*Convert the received UTF8 strings to pure Unicode Strings using glib utils*/
    long charactersWritten = 0;
    gunichar *ucsCharacters1 = g_utf8_to_ucs4_fast(utf8String1,len1,&charactersWritten);
    gunichar *ucsCharacters2 = g_utf8_to_ucs4_fast(utf8String2,len2,&charactersWritten);

    /*Transform to icu type UnicodeString*/
    UnicodeString unicodeString1((UChar32)*ucsCharacters1);
    UnicodeString unicodeString2((UChar32)*ucsCharacters2);

    if(ucsCharacters1) g_free(ucsCharacters1);
    if(ucsCharacters2) g_free(ucsCharacters2);
#endif

    delete[] utf8String1;
    delete[] utf8String2;

    /*perform the comparison of the pure unicode strings*/
    UErrorCode errorCode = U_ZERO_ERROR;
    UCollationResult compareResult = self.ucaCollator->compare(unicodeString1,unicodeString2,errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("UCA Collator comparison failed: %s",u_errorName (errorCode)));
        return -1; //@todo : decide on the unique error code
    }

    /*return the result*/
    return compareResult;

/* UCollationResult :
 * string a == string b
    UCOL_EQUAL    = 0,
    string a > string b
    UCOL_GREATER    = 1,
    string a < string b
    UCOL_LESS    = -1
*/
}

int UCASort_Setup()
{
    /*recreate locale for new langauge-country*/
    if(self.locale)
    {
        delete self.locale;
        self.locale = NULL;
    }
    self.locale = new Locale(self.language.c_str());

    /*recreate Collator instance for new locale*/
    if(self.ucaCollator )
    {
        delete self.ucaCollator;
        self.ucaCollator  = NULL;
    }

    UErrorCode errorCode = U_ZERO_ERROR;
    self.ucaCollator = Collator::createInstance(*self.locale, errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("Failed to create UCA collator instance: %s\n",u_errorName (errorCode)));
        return -1;
    }

    errorCode = U_ZERO_ERROR;
    self.ucaCollator->setAttribute(UCOL_CASE_FIRST,UCOL_UPPER_FIRST,errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("Failed to set UCOL_CASE_FIRST attribute: %s\n",u_errorName (errorCode)));
        return -1;
    }
#if 0
    errorCode = U_ZERO_ERROR;
    self.ucaCollator->setAttribute(UCOL_NUMERIC_COLLATION,UCOL_ON,errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("Failed to set UCOL_NUMERIC_COLLATION attribute: %s\n",u_errorName (errorCode)));
        return -1;
    }

    errorCode = U_ZERO_ERROR;
    self.ucaCollator->setAttribute(UCOL_CASE_LEVEL,UCOL_ON,errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("Failed to set UCOL_CASE_LEVEL attribute: %s\n",u_errorName (errorCode)));
        return -1;
    }
    errorCode = U_ZERO_ERROR;
    self.ucaCollator->setAttribute(UCOL_NORMALIZATION_MODE,UCOL_ON,errorCode);
    if (U_FAILURE(errorCode))
    {
        ETG_TRACE_ERR(("Failed to set UCOL_NORMALIZATION_MODE attribute: %s\n",u_errorName (errorCode)));
        return -1;
    }
#endif

    return 0; //setup is success
}

int UCASort_SetCollationRules( const char* language)
{
    /*save the new collation rules*/
    self.language.assign(language);

    /*Re run the setup to recreate UCA Collator and Locale based on the new collation rules*/
    UCASort_Setup();

    return 0;
}

int UCASort_RegisterSortFunction( sqlite3* handle ,const char* languageRule)
{
    /*default collation rules*/
    self.language.assign(languageRule);

    /*run the setup to create Collator instance ready for sort requests*/
    UCASort_Setup();

    /*Register new Collating Function with the sqlite3 */
    return sqlite3_create_collation_v2( handle,SORTLIB_COLLATE_NAME,SQLITE_UTF8,0,UCASort_Compare,0);
}


