/*
 * MyMediaUpdateManager.h
 *
 *  Created on: Jun 13, 2013
 *      Author: tritonsu
 */

#ifndef MYMEDIAUPDATEMANAGER_H_
#define MYMEDIAUPDATEMANAGER_H_
#include "ILocalSPM.h"
#include "TypeDefinitions.h"
#include "Lock.h"
#include "Database.h"
#include "ThreadFactory.h"

#include <vector>
using namespace std;

class MyMediaUpdateManager : public TFThread
{
public:

	void Init();
	void Stop();

	/* general tasks to order */
	tResult AddDevice(Database *db, const tDeviceID deviceID);
	tResult RemoveDevice(Database *db, const tDeviceID deviceID);
	tResult Speedup(Database *db);

	/* task modificators */
	tResult SlowDownCurrentTask(Database *db) const;
	tResult WaitForFinished(const tDeviceID deviceID);
	tResult WaitForFinished();
	tResult AbortCurrentTask(const tDeviceID deviceID);
	tResult AbortAllTasks();
	tResult GetLastResult(const tDeviceID deviceID);

private:

	typedef enum {
		TSK_SCHEDULE,
		TSK_ADD_DEVICE,
		TSK_REMOVE_DEVICE,
		TSK_SPEED_UP
	} tTaskCommand;

	/* struct for info for one task */
	typedef class {
	public:
		tTaskCommand task;
		Database *db;
		tDeviceID deviceID;
		int stopFlag;
	} tTask;

	vector<tTask *> tasks;
	class Lock tasksLock;
	class Lock newTask;
	vector<tDeviceID> startedDevices;
	typedef map<tDeviceID,tResult> tLastResults;
	typedef map<tDeviceID,tResult>::iterator tLastResultsIter;
	tLastResults lastResults;

	int taskID;
	int stop;
	int deactive;

    void Do(int functionID, void *ptr);
    tResult AddDeviceThread(void *ptr) const;
    tResult RemoveDeviceThread(void *ptr) const;
    tResult SpeedupThread(void *ptr) const;

    /* helper */
    tResult GetCurrentTask(tTask **task, const tDeviceID deviceID);
	tResult WaitForFinishedInternal(tTask *task);
};

#endif /* MYMEDIAUPDATEMANAGER_H_ */
