#ifndef DATABASE_H_
#define DATABASE_H_

#include <sqlite3.h>
#include "TypeDefinitions.h"

class Database
{
public:
    Database();
    virtual ~Database();
    sqlite3* Handle();
    tResult DeInit();
    tResult RecreateDatabase() const;
    //Roadmap 13005 (Read config values from DataProvider (GetInternalDevices) and add internal devices)
    tResult CreateInternalDevices() const; //Roadmap 13005: 100%
    tResult CreateTestDatabase(const tBoolean createDevices, const tBoolean createSongs);
    tResult ScanDirForTest(const tDeviceID deviceID);
    void Close();
    tResult Register(const void *ptr) const;
    tResult UnRegister(const void *ptr) const;
    tResult DeleteMyMediaDatabase(sqlite3 *dbHandle) const;
    tResult UpdateMain(sqlite3 *dbHandle, const tDeviceID deviceID) const;
    tResult DetermineFolderContent(sqlite3 *dbHandle, const tDeviceID deviceID) const;
    tResult CleanupLiveTags(sqlite3 *dbHandle) const;
    tResult CopyDeviceToFromVirtualTable(sqlite3 *dbHandle, const tBoolean fromVirtual, const tBoolean toVirtual,
            const tDeviceID deviceID, tDeviceID newDeviceID = DEVICE_ID_NOT_SET) const; //Roadmap 14004
    tResult SpeedupDatabase(sqlite3 *dbHandle, tDeviceID deviceID) const;
    tResult UpdateMyMediaDatabase(int *stopFlag, sqlite3 *dbHandle, tDeviceID deviceID) const;
    tResult RemoveDeviceFromMyMedia(int *stopFlag, sqlite3 *dbHandle, tDeviceID deviceID) const;
    tResult Refresh();
    tResult Sync(sqlite3 *dbHandle) const;
    tResult CheckDatabaseIntegrity(sqlite3 *dbHandle, const tBoolean withExplain = true) const;
    int Shutdown(const int waitForAllThreadsFinished = 1) const;
    tResult GetFileFormat(tFileFormat &fileFormat, tFileType &fileType, const char *path) const;
    void SlowDownUpdateMyMedia(void) const;
    int GetNumberOfVTCacheElements(int *cacheEntries, int *cacheHits, int *cacheMisses);
    tResult ReleaseDatabaseMemory(sqlite3 *dbHandle);
    tResult DatabaseStatus(sqlite3 *dbHandle, int op);
    tResult AllocatedMemory(void);
    tResult PrepareStatementCount(sqlite3 *dbHandle);


    /* this file name will be used by upper levels of DataBase to signal a needed data base file recreation on next startup */
    static const char* mDatabaseRecreateFile;

private:
    static const char* mDatabaseFile;
    static const char* mMyMediaDatabaseFile;
    /*If the schema version is changed here, make sure to update it in schema-2.0.h also*/
    static const tInteger mSchemaVersion = 24;//Fix for RTC-341485
    sqlite3 *mDatabase;

    tResult CheckSqlite3Version(sqlite3 *dbHandle) const;
    static int BusyCallback(void *userData, int times);
    static int ProgressCallbackCaller(void *userData);
    int ProgressCallback() const;
    sqlite3 *OpenDatabase();
    tResult AddModules(sqlite3 *dbHandle) const;
    tResult ConfigureConnection(sqlite3 *dbHandle) const;
    tResult CloseDatabase(sqlite3 *dbHandle) const;
    void CloseAllHandles() const;
    tResult ResetDatabaseIntegrity(sqlite3 *dbHandle) const;
    tResult CreateDatabase(sqlite3 *dbHandle) const;
    tResult ScanDirectory(const char *path, const tDeviceID deviceID);
    tResult CreateMyMediaDatabase(sqlite3 *dbHandle) const;
    tResult Refresh(sqlite3 *dbHandle);
    tResult ReadOneVideoMetaData(IN FILE *fpInput, IN char *tmpFileName, const char *format, ...);
};

#endif /*DATABASE_H_*/
