/*
 * FavoritesManagerTest.h
 *
 *  Created on: Jan 15, 2013
 *      Author: Dinesh
 */

#ifndef FAVORITESMANAGERTEST_H_
#define FAVORITESMANAGERTEST_H_


#include <cppunit/extensions/HelperMacros.h>

class FavoritesManagerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( FavoritesManagerTest );

    CPPUNIT_TEST( prepareTestIDs );

    //This is necessary because ActivateFavorite is returning before RequestAVActivation due to objectID problems
    //TODO: remove this after objectID problem is solved
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( SourceActivityOn );

    /* test cases */
    CPPUNIT_TEST( Triggers );
    CPPUNIT_TEST( StoreFavorites );
    CPPUNIT_TEST( GetFavorite );
    CPPUNIT_TEST( GetAllFavorites );
    CPPUNIT_TEST( ActivateFavorite );
    CPPUNIT_TEST( DeleteFavorite );
    CPPUNIT_TEST( ResetFavorites );
    CPPUNIT_TEST( ReStoreFavorites );
    CPPUNIT_TEST( UpdateFavoriteStatus );
    CPPUNIT_TEST( DeActivateAllFavorites );
    CPPUNIT_TEST( StoreArtist );
    CPPUNIT_TEST( ActivateArtist );
    CPPUNIT_TEST( StoreGenre );
    CPPUNIT_TEST( ActivateGenre );
    CPPUNIT_TEST( StoreAlbum );
    CPPUNIT_TEST( ActivateAlbum );
    CPPUNIT_TEST( DeviceRemoved );
    CPPUNIT_TEST( DeviceChanged );
    CPPUNIT_TEST( StoreDuplicateFavorite );
    CPPUNIT_TEST( UpdateAllFavoriteStatus );
    //CPPUNIT_TEST( StoreFavFromFileList );
    //CPPUNIT_TEST( StoreFavFromIndexedList );

    CPPUNIT_TEST( SourceActivityOff );
    CPPUNIT_TEST( DeAllocate );

    CPPUNIT_TEST_SUITE_END();

public:

    /*test case function*/
    void prepareTestIDs();
    void Allocate();
    void DeAllocate();
    void SourceActivityOn();
    void SourceActivityOff();
    void StoreFavorites(void);
    void GetFavorite(void);
    void GetAllFavorites(void);
    void ActivateFavorite(void);
    void DeleteFavorite(void);
    void ResetFavorites(void);
    void ReStoreFavorites(void);
    void UpdateFavoriteStatus(void);
    void DeActivateAllFavorites(void);
    void StoreArtist(void);
    void ActivateArtist(void);
    void StoreGenre(void);
    void ActivateGenre(void);
    void StoreAlbum(void);
    void ActivateAlbum(void);
    void Triggers(void);
    void DeviceRemoved(void);
    void DeviceChanged(void);
    void UpdateAllFavoriteStatus(void);
    void StoreDuplicateFavorite(void);
};

#endif /* FAVORITESMANAGERTEST_H_ */
