#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CustomControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <memory.h>
#include <CustomControl.h>

#include "CustomControlTest.h"
#include <FunctionTracer.h>
#include "VarTrace.h"
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "TypeDefinitions.h"
#include "CppUnitDefinitions.h"

#define WAIT_FOR_HMI_STATE(stateToReach, timeoutInSec) \
    if (CheckPlaybackState((stateToReach), (timeoutInSec)) != MP_NO_ERROR) {\
        tHMIPlaybackState playstatus = HMI_PBS_UNDEFINED;\
        CPPUNIT_ASSERT(stateToReach == playstatus);\
    }

void CustomControlTest::InitTestsuite()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true); //all the SM are Stopped and then made to Run.
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void CustomControlTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

tResult CustomControlTest::WaitForPlaytimeUpdate(int sec)
{
    tResult res = MP_NO_ERROR;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime elapsedPlaytimeCompare = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    int secMax = sec;

    for(; sec; sec--) {

        /* get the current playtime */
        res = LocalSPM::GetPlayerManager().GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime,OUT objectID);
        if (res != MP_NO_ERROR) break;

        if (secMax == sec) { // if first run, store only the current play time as compare value
            elapsedPlaytimeCompare = elapsedPlaytime;
        } else { // if additional run, check if playtime changes
            if ((elapsedPlaytimeCompare != elapsedPlaytime) && (elapsedPlaytime > 0)) {
                break;
            }
        }
        sleep(1);
    }

    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //playtime was not updated
    }
    return res;
}

tResult CustomControlTest::WaitForListID(const tListID listID, int sec)
{
    tResult res = MP_NO_ERROR;
    tNowPlaying nowPlaying;

    for(; sec; sec--) {
        res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        if (res != MP_NO_ERROR) break;

        if(listID == nowPlaying.listID) break;
        sleep(1);
    }

    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //requested list not found in time
    }
    return res;
}

tResult CustomControlTest::WaitForObjectID(const tObjectID objectID, int sec)
{
    tResult res = MP_NO_ERROR;
    tNowPlaying nowPlaying;

    for(; sec; sec--) {
        res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        if (res != MP_NO_ERROR) break;

        if(objectID == nowPlaying.objectID) break;
        sleep(1);
    }
    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //requested object not found in time
    }
    return res;
}

/**********************************************************************
 * Test cases
 *********************************************************************/
void CustomControlTest::Allocate()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Call SendAllocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    res = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(2); //Wait a little bit until IPC is initialized by first Allocate call

    // test result
    tAllocateState allocateState;
    res = LocalSPM::GetPlayerManager().GetAllocateState(OUT allocateState, OUT audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(ALS_ALLOCATED == allocateState);
    CPPUNIT_ASSERT(!strcmp(audioOutputDevice, USB_ALSA_DEVICENAME));
}

void CustomControlTest::DeAllocate()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Call SendDeAllocate */
    res = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    // test result
    tAllocateState allocateState;
    tAudioOutputDevice audioOutputDevice;
    res = LocalSPM::GetPlayerManager().GetAllocateState(OUT allocateState, OUT audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(ALS_DEALLOCATED == allocateState);
}

void CustomControlTest::SourceActivityOn()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_ON;
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    // test result
    tBoolean isActive = FALSE;
    res = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(FALSE != isActive);
}

void CustomControlTest::SourceActivityOff()
{
    ENTRY_TEST


    tResult res = MP_NO_ERROR;

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_OFF;
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    // test result
    tBoolean isActive = TRUE;
    res = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(FALSE == isActive);
}

void CustomControlTest::PlayMediaPlayerObject()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get deviceID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    CreateAndPlayListType(IN deviceID, IN LTY_SONG);
    CreateAndPlayListType(IN deviceID, IN LTY_GENRE);
    CreateAndPlayListType(IN deviceID, IN LTY_ARTIST);
    CreateAndPlayListType(IN deviceID, IN LTY_ALBUM);
    // thömel: this will never work: on USB there are no podcasts or audiobooks:
    //CreateAndPlayListType(IN deviceID, IN LTY_PODCAST); //TODO: activate it after feature is enabled
    //CreateAndPlayListType(IN deviceID, IN LTY_AUDIOBOOK); //TODO: activate it after feature is enabled
    CreateAndPlayListType(IN deviceID, IN LTY_COMPOSER);
#if defined(TARGET_BUILD)
    CreateAndPlayListType(IN deviceID, IN LTY_VIDEO);
#endif
    CreateAndPlayListType(IN deviceID, IN LTY_PLAYLIST);
}

void CustomControlTest::CreateAndPlayListType(const tDeviceID deviceID, const tListType listType)
{
    ENTRY_INTERNAL

    VARTRACE(listType);
    tGeneralString listTypeString;
    snprintf(listTypeString, sizeof(listTypeString), "listType=%d", listType);

	tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tPlayContinuation playContinuation = PC_NO_REPEAT;

    /* Set the filter tags */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* Create an list type specific list */
    tListID specificListID;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT specificListID,
            OUT listSize,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(specificListID != LIST_ID_NONE);
    CPPUNIT_ASSERT(listSize > 0);

    /* Request slice from list */
    vector<tMediaObject> mediaObjectVector;
    tIndex startIndex = 0;
    tUInt i = listSize-1;
    if(LTY_VIDEO == listType) i=2; //Use third video object of list because last one is not playable

    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN specificListID,
            IN startIndex,
            IN listSize);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(mediaObjectVector.size() == listSize);
    CPPUNIT_ASSERT(mediaObjectVector[i].objectID > 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(
            OUT listID,
            OUT listSize,
            IN mediaObjectVector[i].objectID,
            IN playContinuation);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listID != LIST_ID_NONE);
    //CPPUNIT_ASSERT(listSize > 0);

    // test result
    res = WaitForListID(IN listID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    enum {secMax = 30};
    int sec;
    tNowPlaying nowPlaying;
    static char nowPlayingUnknownText[64] = {0};
    strncpy_r(nowPlayingUnknownText, LocalSPM::GetDataProvider().NowPlayingUnknownText().c_str(), sizeof(nowPlayingUnknownText));

    switch(listType) {
    case LTY_SONG:
        VARTRACE(mediaObjectVector[i].title);
        for(sec=secMax; sec; sec--) {
            res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
            CPPUNIT_ASSERT(MP_NO_ERROR == res);

            if ((mediaObjectVector[i].objectID == nowPlaying.objectID)
                &&
                (0 == strcmp(mediaObjectVector[i].title, nowPlaying.object.title))) break;
            sleep(1);
        }
        CPPUNIT_ASSERT(sec);
        break;
    case LTY_GENRE:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField1)) {
            VARTRACE(mediaObjectVector[i].MetadataField1);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
                CPPUNIT_ASSERT(MP_NO_ERROR == res);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag1)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField1, nowPlaying.object.MetadataField1))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_ARTIST:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField2)) {
            VARTRACE(mediaObjectVector[i].MetadataField2);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
                CPPUNIT_ASSERT(MP_NO_ERROR == res);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag2)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField2, nowPlaying.object.MetadataField2))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_ALBUM:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField4)) {
            VARTRACE(mediaObjectVector[i].MetadataField4);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
                CPPUNIT_ASSERT(MP_NO_ERROR == res);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag4)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField4, nowPlaying.object.MetadataField4))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_PODCAST:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField1)) {
            VARTRACE(mediaObjectVector[i].MetadataField1);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
                CPPUNIT_ASSERT(MP_NO_ERROR == res);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag1)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField1, nowPlaying.object.MetadataField1))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_AUDIOBOOK:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField2)) {
            VARTRACE(mediaObjectVector[i].MetadataField2);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag2)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField2, nowPlaying.object.MetadataField2))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_COMPOSER:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField3)) {
            VARTRACE(mediaObjectVector[i].MetadataField3);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
                CPPUNIT_ASSERT(MP_NO_ERROR == res);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag3)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField3, nowPlaying.object.MetadataField3))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_VIDEO:
        if(strcmp(nowPlayingUnknownText, nowPlaying.object.MetadataField1)) {
            VARTRACE(mediaObjectVector[i].MetadataField1);
            for(sec=secMax; sec; sec--) {
                res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);

                if ((mediaObjectVector[i].objectID == nowPlaying.object.MetadataTag1)
                    &&
                    (0 == strcmp(mediaObjectVector[i].MetadataField1, nowPlaying.object.MetadataField1))) break;
                sleep(1);
            }
            CPPUNIT_ASSERT(sec);
        }
        break;
    case LTY_PLAYLIST:
        // Cannot be compared with nowPlaying
        break;
    default: //No additional check
        break;
    }
}

void CustomControlTest::CreateAndStoreLastModeList(tListID &createdListID, const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    VARTRACE(deviceID);

    tResult res = MP_NO_ERROR;

    /* Get a valid object ID for a song */
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    tListSize listSize;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT createdListID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listSize > 0);

    /* Get the  object */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN createdListID, IN 0 /*startIndex*/, IN 1 /*sliceSize*/);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 1);

    /* Inform ListControl about object currently played (for highlighting in the list) */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN createdListID, IN IN mediaObjectVector[0].objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Save current list as last played list */
    res = LocalSPM::GetListControl().StoreLastPlayedList(IN createdListID, IN 0 /*playtime*/);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::ActiveMediaDeviceGet()
{
    ENTRY_TEST

	tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Set the active device */
    res = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Read back which is active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);
    CPPUNIT_ASSERT(deviceInfo.connected == 1);
    CPPUNIT_ASSERT(deviceInfo.deviceType == DTY_USB);
    CPPUNIT_ASSERT(deviceInfo.indexedState == IDS_COMPLETE);
    CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, "987654321") == 0);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, "USB") == 0);
}

void CustomControlTest::ActiveMediaDeviceSet()
{
    ENTRY_TEST

	tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID;
    tDeviceID deviceID2;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);


    /* Try to set device 2 as active */
	res = LocalSPM::GetCustomControl().ActiveMediaDeviceSet(IN deviceID2, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1); // Sleep a little to get the player manager switching the list and set the new one as active

    /* Read back which is active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID2);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);
    CPPUNIT_ASSERT(deviceInfo.connected == 1);
    CPPUNIT_ASSERT(deviceInfo.deviceType == DTY_USB);
    CPPUNIT_ASSERT(deviceInfo.indexedState == IDS_NOT_STARTED);
    CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, "9874321") == 0);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, "USB-2") == 0);

    /* Set device 1 as active */
	res = LocalSPM::GetCustomControl().ActiveMediaDeviceSet(IN deviceID, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    /* Read back which is active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);
    CPPUNIT_ASSERT(deviceInfo.connected == 1);
    CPPUNIT_ASSERT(deviceInfo.deviceType == DTY_USB);
    CPPUNIT_ASSERT(deviceInfo.indexedState == IDS_COMPLETE);
    CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, "987654321") == 0);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, "USB") == 0);
}

void CustomControlTest::SetActiveStreamingDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID;
    tDeviceID deviceID2;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPOD, IN "IPOD");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Try to set iPod device as streaming device */
#if 0
    res = LocalSPM::GetCustomControl().SetActiveStreamingDevice(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
#else
    /* Send SET_ACTIVE_STREAMING_DEVICE message to CustomControlSM */
    char msgToSendString[64];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    strncpy_r(OUT msgToSendString, IN "CustomControlSM::SET_ACTIVE_STREAMING_DEVICE", IN sizeof(msgToSendString));

    res = LocalSPM::GetCustomControl().ParameterSET_ACTIVE_STREAMING_DEVICE(OUT parameterString, IN size, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
#endif

    sleep(1); // Sleep a little to get the player manager switching the list and set the new one as active

    /* Read back which is active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);

    /* Set device 2 as active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceSet(IN deviceID2, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    /* Read back which is active */
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID2);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);
}

void CustomControlTest::PlayObjectID()
{
    ENTRY_TEST

	tResult res = MP_NO_ERROR;
    tBoolean isActive;

    //create an all song list and find album "Garbage"
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
   	tFilterTag1 tag1 = { 0 };
   	tFilterTag2 tag2 = { 0 };
   	tFilterTag3 tag3 = { 0 };
   	tFilterTag4 tag4 = { 0 };
   	vector<tMediaObject> mediaObjectVector;
   	res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
               OUT listID,
               OUT listSize,
               LTY_SONG,
               IN streaming,
               IN tag1,
               IN tag2,
               IN tag3,
               IN tag4,
               MY_MEDIA);
   	CPPUNIT_ASSERT(MP_NO_ERROR == res);
   	CPPUNIT_ASSERT(listSize == 31);

   	/* get the first contents */
   	res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
   	CPPUNIT_ASSERT(MP_NO_ERROR == res);
   	CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
   	CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));

   	/* Play object ID */
    tObjectID objectID = mediaObjectVector[0].objectID; // must be a song tag
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().ReleaseList(IN listID);

    res = LocalSPM::GetCustomControl().PlayObjectID(OUT isActive, OUT listID, IN objectID, CTY_SONG, PC_NO_REPEAT);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(isActive);

    // test result
    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    res = WaitForObjectID(IN objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = WaitForPlaytimeUpdate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::PlayItemFromIndexedList()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Create playable list */
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(0 < listSize);

    /* Play item from created list */
    tIndex listIndex = 6;
    tPlaytime offset = 268000;
    res = LocalSPM::GetCustomControl().PlayItemFromList(OUT listSize, IN listID, IN listIndex, IN offset);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // test result
    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    res = WaitForListID(IN listID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listIndex == nowPlaying.position);

    res = WaitForPlaytimeUpdate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;
    res = LocalSPM::GetPlayerManager().GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    ETG_TRACE_USR2(("CustomControlTest::PlayItemFromList:offset:%d elapsedPlaytime:%d", offset, elapsedPlaytime));
    CPPUNIT_ASSERT(offset <= elapsedPlaytime);

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);

}

void CustomControlTest::EnableBrowseList()
{
    ENTRY

    /* Enable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    }

    /* recreate the test database */
    InitTestsuite();
}

void CustomControlTest::DisableBrowseList()
{
    ENTRY

    /* Disable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 0;
    }

    /* recreate the test database */
    InitTestsuite();
}

void CustomControlTest::EnableFileListsToContainOnlyMediaObjects()
{
    ENTRY

    /* Enable OnlyMediaObjectsInFileLists configuration */
    int onlyMediaObjects = LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists();
    if (0 == onlyMediaObjects)
    {
        LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists = 1;
    }
}

void CustomControlTest::DisableFileListsToContainOnlyMediaObjects()
{
    ENTRY

    /* Disable OnlyMediaObjectsInFileLists configuration */
    int onlyMediaObjects = LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists();
    if (onlyMediaObjects)
    {
        LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists = 0;
    }
}

void CustomControlTest::PlayItemFromFileList_RepeatModeList()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of first audio file in the created list */
    tIndex listIndex = 0;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_LIST.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType;

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        expectedListType = LTY_BROWSELIST_MEDIAOBJECTS;
    }
    else
    {
        expectedListType = LTY_FILELIST_MEDIAOBJECTS;
    }

    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::PlayItemFromFileList_RepeatModeListWithSubLists()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of second audio file in the created list */
    tIndex listIndex = 1;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_LIST_WITH_SUBLISTS.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST_WITH_SUBLISTS);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType;

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        expectedListType = LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    }
    else
    {
        expectedListType = LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;;
    }
    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::PlayItemFromFileList_RepeatModeAll()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of third audio file in the created list */
    tIndex listIndex = 2;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_ALL.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_ALL);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType;

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        expectedListType = LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    }
    else
    {
        expectedListType = LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    }

    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::PlayItemFromFileListLTY_FILELIST_RepeatModeList()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of fourth audio file in the created list */
    tIndex listIndex = 3;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_LIST.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType = LTY_FILELIST;

    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::PlayItemFromFileListLTY_FILELIST_UNSORTED_RepeatModeList()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST_UNSORTED,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of fifth audio file in the created list */
    tIndex listIndex = 4;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_LIST.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType = LTY_FILELIST_UNSORTED;

    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::PlayItemFromFileListLTY_BROWSELIST_RepeatModeList()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Create a file list from directory "/music/Garbage/" */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_BROWSELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Search index of sixth audio file in the created list */
    tIndex listIndex = 5;
    bool found = GetAudioFileIndex(INOUT listIndex, IN listID, IN listSize);
    CPPUNIT_ASSERT(true == found);

    /*Set the RepeatMode to RPT_LIST.Then,validate the Playback of Item Selected*/
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tListType expectedListType = LTY_BROWSELIST;

    ValidatePlaybackOfSelectedItem(IN expectedListType, IN listID, IN listIndex);
}

void CustomControlTest::ValidatePlaybackOfSelectedItem(const tListType expectedListType, const tListID listID, const tIndex listIndex)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR2(("expectedListType:%d, listID:%d, listIndex:%d", expectedListType, listID, listIndex));

    tResult res = MP_NO_ERROR;
    tListSize listSize = 0;
    tPlaytime offset = 1000;

    /*Get the MediaObject at the index found */
    tMediaObject mediaObject;
    res = LocalSPM::GetListControl().GetMediaObject(OUT mediaObject, IN listID, IN listIndex);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(OBJECT_ID_NONE != mediaObject.objectID);

    res = LocalSPM::GetCustomControl().PlayItemFromList(OUT listSize, IN listID, IN listIndex, IN offset);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* wait a little */
    res = WaitForObjectID(IN mediaObject.objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // test result
    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(LIST_ID_NONE != nowPlaying.listID);

    /* Get ListType via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN nowPlaying.listID, IN withListSize);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(expectedListType == listInfo.listType);

    tRepeatMode repeatMode = RPT_INVALID;
    res = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* If OnlyMediaObjectsInFileLists disabled and repeatMode being RPT_LIST,then the same given List is played instead of creating a NewList.
     * Hence the ListID and Position can be validated
     */
    if((RPT_LIST == repeatMode) && !(LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists()))
    {
        CPPUNIT_ASSERT(listID == nowPlaying.listID);
        if(LTY_FILELIST_UNSORTED != expectedListType)
        {
            CPPUNIT_ASSERT(listIndex == nowPlaying.position);
        }
    }

    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;
    res = LocalSPM::GetPlayerManager().GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(offset <= elapsedPlaytime);

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

bool CustomControlTest::GetAudioFileIndex(tIndex &index, const tListID listID, const tListSize listSize)
{
    ENTRY_INTERNAL
    bool found = false;
    tResult res = MP_NO_ERROR;

    /* Get the list slice to get an audio file in the "/" path*/
    vector<tFiles> mediaFileVector;
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tUInt audioFileCount = 0;
    for(tUInt i=0; i<mediaFileVector.size(); i++) {
        if (FT_AUDIO == mediaFileVector[i].type) {
            audioFileCount++;
            if (index == (audioFileCount-1)) {
                index = i;
                found = true;
                break;
            }
        }
    }

    return found;
}

void CustomControlTest::PlayItemFromListByTag()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Create playable list */
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(0 < listSize);

    tObjectID objectID = 0 ;
    res = LocalSPM::GetDBManager().GetObjectID(OUT objectID, IN deviceID, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/02-sweet_ride-evighet.mp3");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Play item from created list */
    res = LocalSPM::GetCustomControl().PlayItemFromListByTag(OUT listSize, IN listID, IN objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // test result
    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    res = WaitForObjectID(IN objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

     tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        CPPUNIT_ASSERT(MP_NO_ERROR == res);
        if (!strcmp(nowPlaying.object.fileName,"/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/02-sweet_ride-evighet.mp3")) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(!strcmp(nowPlaying.object.fileName,"/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/02-sweet_ride-evighet.mp3"));
    CPPUNIT_ASSERT(listID == nowPlaying.listID);
    CPPUNIT_ASSERT(objectID == nowPlaying.objectID);

    res = WaitForPlaytimeUpdate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::CreateQuickPlayListIterative()
{
   ENTRY_TEST

	tResult res = MP_NO_ERROR;

	/* Create a quick play list and ask for random peaces of this list */
    tListInfo listInfo;
    tListType listType = LTY_SONG;
    tObjectID filterTags[4];
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* set parameters */
    filterTags[0] = 0;
    filterTags[1] = 0;
    filterTags[2] = 0;
    filterTags[3] = 0;

    /* test */
    res = LocalSPM::GetCustomControl().CreateQuickPlayList(
    		OUT listInfo,
            IN listType,
            IN filterTags,
            IN playContinuation,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(listInfo.listType == LTY_SONG);
    CPPUNIT_ASSERT(listInfo.listSize == 31); // must be before the data provider test because it is deleting one song from list

#if 1 // test: on target if this is on this test does not fail - but why?
	vector<tMediaObject> mediaObjectDummyVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectDummyVector,
                IN listInfo.listID,
                0,
                100);
	CPPUNIT_ASSERT(MP_NO_ERROR == res);
#endif

    vector<tMediaObject> mediaObjectScliceVector;
    vector<tMediaObject> mediaObjectV1Vector;
    vector<tObjectID> objectSequence;
    tUInt i;

    /* setup the randomized object sequence for slice requests */
    tListSize listSize = listInfo.listSize;
    tMediaObject emptyMediaObject;
    InitMediaObject(OUT emptyMediaObject);
    for(i=0; i<listSize; i++) {
    	objectSequence.push_back(i);
    	mediaObjectV1Vector.push_back(emptyMediaObject);
    }
    srand(0);
    for(i=0; i<listSize; i++) {
    	tUInt idx1, idx2;
    	idx1 = (rand()*(listSize-1)) / RAND_MAX;
    	idx2 = (rand()*(listSize-1)) / RAND_MAX;
    	tObjectID objSwap;
    	objSwap = objectSequence[idx1];
    	objectSequence[idx1] = objectSequence[idx2];
    	objectSequence[idx2] = objSwap;
    }

    /* request the list slices in random order */
    for(i=0; i<listSize; i++) {
        res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                    OUT mediaObjectScliceVector,
                    IN listInfo.listID,
                    objectSequence[i],
                    1);
    	CPPUNIT_ASSERT(MP_NO_ERROR == res);
    	CPPUNIT_ASSERT(mediaObjectScliceVector.size() != 0);

    	/* put the object into the right position in V1 vector */
    	mediaObjectV1Vector[objectSequence[i]] = mediaObjectScliceVector[0];
    }

#if 1 // debug
	for(i=0; i<mediaObjectV1Vector.size(); i++) {
		ETG_TRACE_USR2(("V1: no=%d: id=%d, tag1=%32s, tag2=%32s, tag3=%32s, tag4=%32s",
				i,
				mediaObjectV1Vector[i].objectID,
				mediaObjectV1Vector[i].MetadataField1,
				mediaObjectV1Vector[i].MetadataField2,
				mediaObjectV1Vector[i].MetadataField3,
				mediaObjectV1Vector[i].MetadataField4
			));
	}
#endif

	/* Ask for the same entries but with one request in one slice */
	vector<tMediaObject> mediaObjectV2Vector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectV2Vector,
                IN listInfo.listID,
                0,
                100);
	CPPUNIT_ASSERT(MP_NO_ERROR == res);

#if 1 // debug
	for(i=0; i<mediaObjectV2Vector.size(); i++) {
		ETG_TRACE_USR2(("V2: no=%d: id=%d, tag1=%32s, tag2=%32s, tag3=%32s, tag4=%32s",
				i,
				mediaObjectV2Vector[i].objectID,
				mediaObjectV2Vector[i].MetadataField1,
				mediaObjectV2Vector[i].MetadataField2,
				mediaObjectV2Vector[i].MetadataField3,
				mediaObjectV2Vector[i].MetadataField4
			));
	}
#endif

	/* Compare the both vectors */
    for(i=0; i<listSize; i++) {
    	CPPUNIT_ASSERT(mediaObjectV1Vector[i].objectID == mediaObjectV2Vector[i].objectID);
    }

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::CreateQuickPlayList()
{
   ENTRY_TEST

	tResult res = MP_NO_ERROR;
    tListInfo listInfo;
    tListType listType = LTY_SONG;
    tObjectID filterTags[4];
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* set parameters */
    filterTags[0] = 0;
    filterTags[1] = 0;
    filterTags[2] = 0;
    filterTags[3] = 0;

    /* test */
    res = LocalSPM::GetCustomControl().CreateQuickPlayList(
    		OUT listInfo,
            IN listType,
            IN filterTags,
            IN playContinuation,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(listInfo.listType == LTY_SONG);
    CPPUNIT_ASSERT(listInfo.listSize == 31); // must be before the data provider test because it is deleting one song from list

    /* request a list slice from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN listInfo.listID,
                4,
                3);
	CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
	CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));
	CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::CreateFolderQuickPlayList()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    //tPlayContinuation playContinuation = PC_NO_REPEAT;
    tListSize listSize;
    tDeviceID deviceID;
    tPath path ;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* set the path and test for */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = LocalSPM::GetCustomControl().CreateFolderQuickPlayList(OUT listSize, IN path, IN PC_NO_REPEAT, IN deviceID);

    CPPUNIT_ASSERT_MESSAGE("Failed to create a list for Folder Playback", MP_NO_ERROR == res);
    CPPUNIT_ASSERT(listSize == 3);

    /* wait a little */
    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    res = WaitForPlaytimeUpdate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);
    CPPUNIT_ASSERT_MESSAGE("Now playing info not as expected after Folder quickplay",!strcmp(nowPlaying.object.fileName,"/Garbage-Garbage-01-Supervixen.MP3"));

    /* request a list slice from that list */
    vector<tFiles> mediaFileVector;
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN nowPlaying.listID, 0, 3);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    ETG_TRACE_USR2(("CreateFolderQuickPlayList slice content 1 -> %s", mediaFileVector[0].fileName));
    ETG_TRACE_USR2(("CreateFolderQuickPlayList slice content 2 -> %s", mediaFileVector[1].fileName));
    ETG_TRACE_USR2(("CreateFolderQuickPlayList slice content 3 -> %s", mediaFileVector[2].fileName));

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::CheckListSelection()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    /* Get device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Create and store a last mode list for given device ID */
    tListID listID;
    CreateAndStoreLastModeList(OUT listID, IN deviceID);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);

    /* Check precondition (criteria) */
    tInteger value = LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceID);
    CPPUNIT_ASSERT(0 == value);
    value = LocalSPM::GetDataProvider().IsLastModeListAvailable(deviceID);
    CPPUNIT_ASSERT(1 == value);
    value = LocalSPM::GetDataProvider().IsAnyDBContentAvailable(deviceID);
    CPPUNIT_ASSERT(1 == value);
    //value = LocalSPM::GetDataProvider().IsCurrentIPodSelectionChanged(deviceID);
    //CPPUNIT_ASSERT(0 == value);

    /* List selection for USB */
    res = LocalSPM::GetCustomControl().CheckListSelection(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* wait a little */
    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceID == nowPlaying.object.deviceID);

    res = WaitForPlaytimeUpdate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* stop playing */
    res = LocalSPM::GetPlayerManager().SendStop();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);
    // wait for PlayerManager is paused state
    WAIT_FOR_HMI_STATE(HMI_PBS_PAUSED, 5);
}

void CustomControlTest::CheckDeviceActivation()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tDeviceID deviceID2;
    tDeviceID checkDeviceID;

    /* Get device IDs */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Create and store a last mode list for given device ID */
    tListID listID;
    CreateAndStoreLastModeList(OUT listID, IN deviceID);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);

    /* Set all devices as deactive in DB */
    res = LocalSPM::GetDBManager().ActiveMediaDeviceSet(MY_MEDIA, IN true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    res = LocalSPM::GetDBManager().ActiveMediaDeviceSet(MY_MEDIA, IN false);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Check precondition (criteria) */
    tInteger value = LocalSPM::GetDataProvider().IsStartupPhase();
    CPPUNIT_ASSERT(0 == value);
    value = LocalSPM::GetDataProvider().IsLastPlayedDevice(IN deviceID);
    CPPUNIT_ASSERT(1 == value);
    value = LocalSPM::GetDataProvider().IsAnyDeviceActive();
    CPPUNIT_ASSERT(0 == value);
    value = LocalSPM::GetDataProvider().IsAnyDeviceConnected(IN deviceID);
    CPPUNIT_ASSERT(1 == value);
    value = LocalSPM::GetDataProvider().IsDeviceAutoplay(deviceID);
    CPPUNIT_ASSERT(0 == value);
    value = LocalSPM::GetDataProvider().IsSameDeviceTypeLikeBefore(IN deviceID);
    CPPUNIT_ASSERT(1 == value);


    /* Activate first available device (deviceID=1) by precondition timer expired */
    tConfigTablePrecondition precondition = CTP_TIMER_EXPIRED;
    res = LocalSPM::GetCustomControl().CheckDeviceActivation(INOUT deviceID, IN precondition);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Check result */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT checkDeviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceID == checkDeviceID); //Attention: Normally it is MyMedia, but in the simulation MyMedia is never connected


    /* Activate device by precondition add device */
    precondition = CTP_ADD_DEVICE;
    res = LocalSPM::GetCustomControl().CheckDeviceActivation(INOUT deviceID, IN precondition);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Check result */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT checkDeviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceID != checkDeviceID); //DeviceID=1 is already active (deviceID=DEVICE_ID_NOT_SET)


    /* Activate device by precondition activate device */
    precondition = CTP_ACTIVATE_DEVICE;
    res = LocalSPM::GetCustomControl().CheckDeviceActivation(INOUT deviceID2, IN precondition);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Check result */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT checkDeviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(deviceID2 == checkDeviceID);
}

void CustomControlTest::TimeoutOfStartupTimer()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetCustomControl().StartStartupTimer();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tBoolean startup = LocalSPM::GetCustomControl().IsStartupPhase();
    CPPUNIT_ASSERT(FALSE != startup);

    res = LocalSPM::GetCustomControl().SendMessageTimeout();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    startup = LocalSPM::GetCustomControl().IsStartupPhase();
    CPPUNIT_ASSERT(FALSE == startup);
}

void CustomControlTest::StartCheckListTimer()
{
   ENTRY_TEST

    tResult res;

    /* set indexing started flag */
    res = LocalSPM::GetCustomControl().StartCheckListTimer(MY_MEDIA); //just a deviceID dummy
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::StopCheckListTimer()
{
   ENTRY_TEST

    tResult res;

    /* set indexing stopped flag */
    res = LocalSPM::GetCustomControl().StopCheckListTimer();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::HandleDeviceUpdated()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_UPDATED(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_UPDATED", parameters);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::HandleDeviceConnected()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_CONNECTED(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_CONNECTED", parameters);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::HandleDeviceNewDevice()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_NEW_DEVICE(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_NEW_DEVICE", parameters);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::HandleDeviceSameDevice()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_SAME_DEVICE(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_SAME_DEVICE", parameters);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::HandleDeviceRemoved()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;
#if 0
    /* setup expect for the custom control sm */
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectReset();
    //((CustomControlSM &)LocalSPM::GetCustomControlRef()).ExpectSetString("on");
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectSetString("Trans: CUSTOMCONTROL2CUSTOMCONTROLINTERNALDEVICEREMOVED: Guard");
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectSetString("Trans: CUSTOMCONTROL2CUSTOMCONTROLINTERNALDEVICEREMOVED: Action");
#endif
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* simulate a data base update trigger */
    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_REMOVED(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_REMOVED", parameters); // deviceCount=2, deviceID=3
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

#if 0
    /* wait a little */
    sleep(1);

    /* check the state */
    CPPUNIT_ASSERT(((CustomControlSM &)LocalSPM::GetCustomControl()).GetExpectErrorCount() == 0);
#endif
}

void CustomControlTest::HandleDeviceActivated()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceCount deviceCount = 2;
    tDeviceID deviceID;
#if 0
    /* setup expect for the custom control sm */
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectReset();
    //((CustomControlSM &)LocalSPM::GetCustomControlRef()).ExpectSetString("on");
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectSetString("Trans: CUSTOMCONTROL2CUSTOMCONTROLINTERNALDEVICEACTIVATED: Guard");
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ExpectSetString("Trans: CUSTOMCONTROL2CUSTOMCONTROLINTERNALDEVICEACTIVATED: Action");
#endif
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tGeneralString parameters;
    ((CustomControlSM &)LocalSPM::GetCustomControl()).ParameterDB_DEVICE_ACTIVATED(OUT parameters, sizeof(parameters), IN deviceCount, IN deviceID);

    res = Dispatcher::GetInstance().SendMessage("CustomControlSM::DB_DEVICE_ACTIVATED", parameters);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

#if 0
    /* wait a little */
    sleep(1);

    /* check the state */
    CPPUNIT_ASSERT(((CustomControlSM &)LocalSPM::GetCustomControl()).GetExpectErrorCount() == 0);
#endif
}

void CustomControlTest::HandleDeviceRepeatMode()
{
   ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* Get deviceID */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Set repeat mode to RPT_LIST_WITH_SUBLISTS */
    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetPlayerManager().SendRepeatMode(RPT_LIST_WITH_SUBLISTS);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Create a file list from directory "/music/" */
    strncpy_r(path, "/music/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(numberOfMediaObjects > 0);

    /* Call SendNewList */
    tIndex listIndex = 0;
    tPlaytime offset = 0;
    res = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN listIndex, IN offset);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    //sleep(1);

    /* Send DB_DEVICE_REPEAT_MODE message to CustomControlSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;
    res = LocalSPM::GetCustomControl().ParameterDB_DEVICE_REPEAT_MODE(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetCustomControl().SendEventByName("DB_DEVICE_REPEAT_MODE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void CustomControlTest::DiagnosisPlaySong()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    // workaround in current version
    //res = LocalSPM::GetPlayerManager().SendRepeatMode(RPT_NONE);

    // Test play song in subdirectory
    res = LocalSPM::GetCustomControl().DiagnosisPlaySong(DTY_USB, (char*) "/music/Garbage/Garbage-Garbage-12-Milk.mp3");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // Test play song in root
    res = LocalSPM::GetCustomControl().DiagnosisPlaySong(DTY_USB, (char*) "/Garbage-Garbage-02-Queer.MP3");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // Test play song in root without "/"
    res = LocalSPM::GetCustomControl().DiagnosisPlaySong(DTY_USB, (char*) "Garbage-Garbage-02-Queer.MP3");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    // Test play not available song
    res = LocalSPM::GetCustomControl().DiagnosisPlaySong(DTY_USB, (char*) "Garbage-Garbage-02-Queer_.MP3");
    CPPUNIT_ASSERT(MP_NO_ERROR != res);

    // Test play song with incorrect device type
    res = LocalSPM::GetCustomControl().DiagnosisPlaySong(DTY_SD, (char*) "Garbage-Garbage-02-Queer.MP3");
    CPPUNIT_ASSERT(MP_NO_ERROR != res);
}

tResult CustomControlTest::CheckPlaybackState(const tHMIPlaybackState stateToReach, const int timeoutInSec)
{
    ENTRY_INTERNAL
    tResult ret;
    tHMIPlaybackState playstatus = HMI_PBS_UNDEFINED;

    /* check loop */
    for(int sec=timeoutInSec; sec; sec--)
    {
        ret = LocalSPM::GetPlayerManager().GetPlaybackState(OUT playstatus);
        if (MP_NO_ERROR != ret) return ret;

        if (playstatus == stateToReach)
        {
            ETG_TRACE_USR2(("state reached: playstatus=%d", playstatus));
            return MP_NO_ERROR;
        }
        sleep(1);
    }

    ETG_TRACE_USR2(("state not reached: stateToReach=%d, playstatus=%d", stateToReach, playstatus));

    return MP_ERR_SM_GENERAL_ERROR;
}
