/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CUSTOM_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CustomControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CUSTOM_CONTROL
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

/* others */
#include "CustomControl.h"
#include "LocalSPM.h"
#include "Dispatcher.h"
#include <TimeTrace.h>

/*lint -save -e1401 */

#define BT_SETTINGS_FBLOCKID 165
#define BT_AUDIO 15
enum FileOperationThreadIDs
{
    FUNCTION_ID_DELETEMEDIACONTENT_TAGS      = 1,
    FUNCTION_ID_DELETEMEDIACONTENT_OBJECTIDS,
    FUNCTION_ID_DELETEMEDIACONTENT_URLS,
    FUNCTION_ID_EDITMETADATA_OBJECTID,
    FUNCTION_ID_EDITMETADATA_URL,
    FUNCTION_ID_PLAYLIST_ADDENTRIES,
    FUNCTION_ID_PLAYLIST_DELETEENTRIES,
    FUNCTION_ID_SETFILEPERMISSION_TAG,
    FUNCTION_ID_PLAYLIST_ADDENTRIES_TAGS
};

CustomControl::CustomControl(const tComponentID componentID):ILocalSPM(componentID)
{
    ENTRY_INTERNAL

    /* Early initialization of variables */
    mAutoRegisterOnDBTrigger = TS_ON;
    mTimerID = 0;
    mDeviceFound = false;
    bPlayPendingInReindexing = false;
    setSystemCondition(true);
    /*Register DBUS Listener for Personalization Component */
    LocalSPM::GetInstance().GetIPCProvider().RegisterListener(&PersonalizationProxy::GetInstance());
    tResult ret = MP_NO_ERROR;
    ret = PersonalizationProxy::GetInstance().RegisterForPersonalizationSignals();
    if(!ret)
    {
        ETG_TRACE_USR3(("PersonalizationProxy RegisterForPersonalizationSignals Successful"));
    }
    else
    {
        ETG_TRACE_USR3(("PersonalizationProxy RegisterForPersonalizationSignals failed"));
    }
}

CustomControl::~CustomControl()
{
    ENTRY_INTERNAL

    /*UnRegister DBUS Listener for Personalization Component */
    tResult ret = MP_NO_ERROR;
    ret = PersonalizationProxy::GetInstance().UnRegisterForPersonalizationSignals();
    if(ret)
    {
        ETG_TRACE_USR3(("UnRegisterForBTSignals failed"));
    }
}

void CustomControl::Create()
{
    // create the state machine and other internal objects return state
    ENTRY

    CustomControlSM::Create();

    CreateDone(0);
}

// to init everything
tResult CustomControl::Init(tInitReason reason)
{
    // run the init of the state machine and return error if any
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    CustomControlSM::Init();

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN &LocalSPM::GetCustomControl());
    setSystemCondition(true);
    return InitDone(0);
}

tResult CustomControl::InitSM()
{
    ENTRY

    /* Initialize variables */
    mTriggerID_DB_DEVICE_CHANGED_CSTATE = 0;
    mTriggerID_DB_DEVICE_CHANGED_ISTATE = 0;
    mTriggerID_DB_DEVICE_CHANGED_ACTIVE = 0;
    mTriggerID_DB_DEVICE_CONNECTED = 0;
    mTriggerID_DB_DEVICE_REMOVED = 0;
    mTriggerID_DB_DEVICE_ACTIVATED = 0;
    mTriggerID_DB_DEVICE_REPEAT_MODE = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE = 0;
    mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE = 0;
    mTriggerID_DB_FAVORITE_UPDATED_ACTIVE = 0;
    mTriggerID_DB_FAVORITE_UPDATED_AVAIL = 0;
    mTriggerID_DB_FAVORITE_INSERTED = 0;
    mTriggerID_DB_FAVORITE_DELETED = 0;
    mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE = 0;
    mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE = 0;
    mTriggerID_DB_DEVICE_CHANGED_NAME = 0;
    mTriggerID_DB_DEVICE_SAME_DEVICE = 0;
    mTriggerID_DB_DEVICE_NEW_DEVICE = 0;
    mTriggerID_DB_DEVICE_ERROR_DEVICE = 0;
    mTriggerID_DB_DEVICE_ERROR_END_DEVICE = 0;
    mTriggerID_DB_DEVICE_INSERTED = 0;
    mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON = 0;
    mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION = 0;
    mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL  = 0;
    mTriggerID_DB_DEVICE_CHANGED_DSTATE = 0;
    mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT = 0;
    mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT = 0;
    mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE = 0;
    mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE = 0;
    mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE = 0;

    mCheckListTimerID = 0;

    return MP_NO_ERROR;
}

tResult CustomControl::Run()
{
    ENTRY

    LocalSPM::GetThreadFactory().Do(this, 0, NULL);

    if(TS_ON == mAutoRegisterOnDBTrigger)
    {
        /* Register on DB trigger */
        SwitchDBTrigger(TT_ALL, TS_ON);

        /* Start the startup timer */
        StartStartupTimer();
    }

    /* Start the Personalization timer */
    StartPersonalizationTimer();

    return RunDone(0);
}

void CustomControl::Do(int functionID, void *ptr)
{
    ENTRY
    switch(functionID)
    {
          case 0:
          {
              // set the threads name
              LocalSPM::GetThreadFactory().SetName(CustomControlSM::GetSMNameFull());

              while((CustomControlSM::STATE_MACHINE_FINISHED != CustomControlSM::StateMachine_Main())){}
              break;
          }
          case FUNCTION_ID_DELETEMEDIACONTENT_TAGS:
          case FUNCTION_ID_DELETEMEDIACONTENT_OBJECTIDS:
          case FUNCTION_ID_DELETEMEDIACONTENT_URLS:
          {
              /* Do delete media content  one at a time (not in parallel) */
              Locker l_DeleteMedaiaContentLocker(&m_DeletMediaContentLock);
              DoDeleteMediaContentThread(functionID, ptr);
              break;
          }
          case FUNCTION_ID_EDITMETADATA_OBJECTID:
          case FUNCTION_ID_EDITMETADATA_URL:
          {
              /* Do edit metadata  one at a time (not in parallel) */
              Locker l_EditMetadataLocker(&m_EditMetadataLock);
              DoEditMetaDataThread(functionID, ptr);
              break;
          }
          case FUNCTION_ID_PLAYLIST_ADDENTRIES:
          case FUNCTION_ID_PLAYLIST_DELETEENTRIES:
          case FUNCTION_ID_PLAYLIST_ADDENTRIES_TAGS:
          {
              /* Do playlist operation  one at a time (not in parallel) */
              Locker PlayListOperationLocker(&m_PlayListOperationLock);
              DoPlayListOperationThread(functionID, ptr);

            break;
        }
        case FUNCTION_ID_SETFILEPERMISSION_TAG:
        {
            /* Do file operation  one at a time (not in parallel) */
            Locker lFilePermissionLock(&m_FilePermissionLock);
            DoFilePermissionThread(ptr);
              break;
          }
          default:
          {
              ETG_TRACE_ERR(("CustomControl::Do: No thread defined for functionID: %d", functionID));
              break;
          }
    }




}

tResult CustomControl::Stop()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Stop the startup timer */
    StopStartupTimer();

    /* delete check list timer */
    if(mCheckListTimerID) {
        mCheckListTimer.CancelTimer(IN mCheckListTimerID);
        mCheckListTimerID = 0;
    }

    /* delete Personalization timer */
    if(mPersonalizationTimerID) {
        mPersonalizationTimer.CancelTimer(IN mPersonalizationTimerID);
        mPersonalizationTimerID = 0;
    }

    /* Deregister on DB trigger */
    SwitchDBTrigger(TT_ALL, TS_OFF);

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    setSystemCondition(false);
    return ret;
}

tResult CustomControl::StopEventProcessed()
{
    ENTRY

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult CustomControl::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CustomControl::DoneEventProcessed()
{
    ENTRY

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN &LocalSPM::GetCustomControl());

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *CustomControl::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

FavoritesManager &CustomControl::GetFavoritesManager(void)
{
    return mFavoriteManager;
}

tResult CustomControl::PlayMediaPlayerObject(tListID &listID, tListSize &listSize, const tObjectID _objectID, const tPlayContinuation playContinuation) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /*retrive the category type of the requested tag*/
    tCategoryType objectType;
    tObjectID objectID = _objectID;
    ret = LocalSPM::GetDBManager().GetObjectType(OUT objectType, INOUT objectID);
    if (ret) return ret;

    /*play the requested tag*/
    tBoolean isActive;
    ret = PlayObjectID(OUT isActive, OUT listID ,IN objectID, IN objectType, IN playContinuation);
    if (ret) return ret;

    /* Get list size from ListControl if wanted */
    if( LocalSPM::GetDataProvider().DeliverListSizeInPlayObjectToHMI() )
    {
        tListInfo listInfo;
        tBoolean withListSize = true;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
        if (ret) return ret;

        listSize = listInfo.listSize;
    }
    else
    {
        listSize = 0;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::PlayItemFromList(tListSize &listSize, const tListID listID, const tIndex listIndex, const tPlaytime offset) const
{
    ENTRY
    ETG_TRACE_USR3(("CustomControl::PlayItemFromList listID:%u index:%u offset:%u", listID, listIndex, offset));

    /* Parameter check */
    if(LIST_ID_NONE == listID)
    {
        ETG_TRACE_ERR(("Received listID is invalid"));
        return MP_ERR_CC_INVALID_PARAM;
    }

    tResult ret = MP_NO_ERROR;
    tListID localListID = listID;
    tIndex localIndex = listIndex;
    tBoolean playfromlastoffset = false;
    tPlaytime lastPlayedPlaytime = 0;

    /* Get the list info */
    tListInfo listInfo;
    tBoolean withListSize = false;
    ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN localListID, IN withListSize);
    if (ret) return ret;

    if(IsFileList(listInfo.listType))
    {
        /* If item is a folder or a playlist, then create a sublist and play this one*/

        /* Get the item's details to know whether item is simple audio/video or folder/playList */
        vector<tFiles> mediaFileVector;
        ret = LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN localListID, IN localIndex, 1);
        if( (ret) || (mediaFileVector.size() == 0) )
        {
            return ret;
        }

        /* Check if item to be played is a folder or playlist which is not playable directly */
        /*IMPORTANT NOTE(!!workaround - will be removed for feature branch by having clean soln!!):
         * AIVI,Renault 2.1 Media HMI currently to achieve "Play All" in a FolderList,it sends index = 0.
         * At index=0,
         * if found folder,then instead of playing the selected folder, its parentFolder played -to achieve "Play All:(NCG3D-131645)".
         * HMI also takes care to set repeatMode to RPT_LIST_WITH_SUBLIST & send playItem request.Thus Play All Achieved.
         *
         * PROPOSED CLEAN SOLN (for scope 3.0 or higher):
         * "Play All" be achieved by giving index = -1 + HMI Need not set the repeatMode to RPT_LIST_WITH_SUBLIST.
         */
        if(((mediaFileVector[0].type == FT_FOLDER) && (false == LocalSPM::GetDataProvider().PlayParentFolderInsteadOfGivenFolder())) ||(mediaFileVector[0].type == FT_PLAYLIST))
        {
            /* Construct the full path for the folder to be played */
            tPath newPath;
            ret = LocalSPM::GetListControl().GetPath(OUT newPath, IN localListID);
            if( MP_NO_ERROR == ret )
            {
                /* add "/" if missing */
                if(NULL == FastUTF8::EndsWithNC((const FastUTF8::tString)newPath, (const FastUTF8::tString)"/")) //lint !e1773
                {
                    strncat_r(newPath, "/", sizeof(newPath));
                }

                strncat_r(newPath, mediaFileVector[0].fileName, sizeof(newPath));

                ETG_TRACE_USR1(("PlayItemFromList Folder/PlayList name : %s", mediaFileVector[0].fileName));
                ETG_TRACE_USR1(("PlayItemFromList Folder/PlayList path : %s", newPath));

                /* Creates file list for the items under the folder and initiates the play back of the same */
                return CreateFolderQuickPlayList(OUT listSize, IN newPath, IN PC_REPEAT_CURRENT_LEVEL, IN listInfo.deviceID, IN listInfo.listType);
            }
        }

        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
        if (ret) return ret;

     //AutoPlay Roadmap Topic
     tMediaContext mediaContext;
     LocalSPM::GetDBManager().GetMediaContext( OUT mediaContext);

     if( MC_VIDEO == mediaContext )
    {
       tListID dblastPlayedListID; //TODO(pee1cob):release this List as it is unused.
       tObjectID lastPlayedObjectID;
       ret = LocalSPM::GetDBManager().GetLastPlayed(OUT dblastPlayedListID, OUT lastPlayedObjectID, OUT lastPlayedPlaytime, IN deviceInfo.deviceID);
       if( ret )
       {
        ETG_TRACE_USR3(("LastPlayed retrieval  for video source, returned value:(ErrorCode:%s)", errorString(ret)));
       }
       else if((mediaFileVector[0].objectID == lastPlayedObjectID))
       {
        playfromlastoffset = true;
        }
    }
        tListID nowPlayingListID;
        LocalSPM::GetPlayerManager().GetListID(OUT nowPlayingListID);/*NCG3D-102164 :  If play request comes for the nowplaying list id then dont create a new list.*/
        if((DTY_BLUETOOTH != deviceInfo.deviceType) && (DTY_CDDA != deviceInfo.deviceType) && (DTY_DVD_DRIVE != deviceInfo.deviceType) && (nowPlayingListID != localListID))
        {
            /* Get the repeat mode for that device */
            tRepeatMode repeatMode;
            ret = LocalSPM::GetDBManager().GetRepeatMode(OUT repeatMode, IN listInfo.deviceID);
            if (ret) return ret;

            /*When Item selected to play from FileBrowsing,Nowplayinglist is altered.
             * Deciding Nowplayinglist's content is done relavant to Repeat mode.It is described below:
             *
             * RepeatMode                                       NowplayingList
             * ==========                                       ==============
             * RPT_ALL                                          all tracks in device
             * All other repeat modes                           configuration PreferredNewListContent(..) be used to decide contents
             *
             * TODO(pee1cob):For now,only for Renault/Nissan PreferredNewListContent(..) made use.Extend for all other projects
             */

            if(RPT_ALL != repeatMode)
            {
                tRepeatMode newListContentPreference = (tRepeatMode)LocalSPM::GetDataProvider().PreferredNewListContent();
                if(newListContentPreference != RPT_INVALID)
                {
                    repeatMode = newListContentPreference;
                }
            }

            if((RPT_ONE == repeatMode)
                    &&
                    (LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext()))
            {
                //use default repeatMode in case of RPT_ONE (NCG3D-4642)
                if(MC_VIDEO == mediaContext)
                    repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode();
                else
                    repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode();
            }

            VARTRACE(repeatMode);

            if(RPT_ALL == repeatMode && LocalSPM::GetDataProvider().ChangeFromRepeatAllToDefaultRepeatMode())
            {
                /* CMG3G-8071:Being in RPT_ALL mode,any track selection to play from a Folder
                 * should switch repeatMode from RPT_ALL to DBDefaultRepeatMode.Hence avoid creating a list.
                 */
            }
            else if((LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists())
               ||
               (RPT_LIST_WITH_SUBLISTS == repeatMode)
               ||
               (RPT_ALL == repeatMode))
            {
                /* Position the media object in current list */
                tMediaObject mediaObject;
                ret = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN localListID, IN localIndex);
                if (ret) return ret;

                tListID newListID = LIST_ID_NONE;
                if(RPT_ALL == repeatMode)
                {
                    ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                            OUT newListID,
                            IN "/" /*path*/,
                            IN listInfo.deviceID,
                            IN true /*withSubFolders*/);
                }
                else if(RPT_LIST_WITH_SUBLISTS == repeatMode)
                {
                    ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                            OUT newListID,
                            IN mediaObject.path,
                            IN listInfo.deviceID,
                            IN true /*withSubFolders*/);
                }
                else
                {
                    ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                            OUT newListID,
                            IN mediaObject.path,
                            IN listInfo.deviceID,
                            IN false /*withSubFolders*/);
                }
                if (ret) return ret;

                /*If audio/video file,Get index (=position) of media object in list from ListControl.Else,play the list from beginning */
                tPosition newPosition = POSITION_NOT_SET;
                if((mediaFileVector[0].type == FT_AUDIO) || (mediaFileVector[0].type == FT_VIDEO))
                {
                    ret = LocalSPM::GetListControl().GetPositionInList(OUT newPosition, IN newListID, IN mediaObject.objectID);
                    if (ret) return ret;
                }
                else if(mediaFileVector[0].type == FT_FOLDER)
                {
                    ETG_TRACE_USR4(("folder Item selected to play.Play the list from beginning"));
                    newPosition = 0;
                }
                /* Map listID and position of new list to requested list */
                localListID = newListID;
                localIndex = (tIndex)newPosition;
            }
        }
    }

    /* Get list size from ListControl if wanted */
    if( LocalSPM::GetDataProvider().DeliverListSizeInPlayObjectToHMI() )
    {
        withListSize = true;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN localListID, IN withListSize);
        if (ret) return ret;

        listSize = listInfo.listSize;
    }
    else
    {
        listSize = 0;
    }

    /* Set device as active in DB */
    ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN listInfo.deviceID, IN true);
    if (ret) return ret;


    /* Send new list to the PlayerManager and start playback of item with index */
    if((true == playfromlastoffset))
    {
        VARTRACE(lastPlayedPlaytime);
        ret = LocalSPM::GetPlayerManager().SendNewList(IN localListID, IN localIndex, IN lastPlayedPlaytime);
        //reset playtime to zero
        lastPlayedPlaytime = 0;
        ret = LocalSPM::GetListControl().StoreLastPlayedList( IN localListID,  IN lastPlayedPlaytime);
    }
    else
    {
        ret = LocalSPM::GetPlayerManager().SendNewList(IN localListID, IN localIndex, IN offset);
    }
    if (ret) return ret;

    return ret;
}

tResult CustomControl::PlayItemFromListByTag(tListSize &listSize, const tListID listID, const tObjectID objectID) const
{
    ENTRY
    ETG_TRACE_USR3(("CustomControl::PlayItemFromListByTag listID:%u objectID:%u", listID, objectID));

    tResult ret = MP_NO_ERROR;

    /* Parameter check */
    if(LIST_ID_NONE == listID)
    {
        ETG_TRACE_ERR(("Received listID is invalid"));
        return MP_ERR_CC_INVALID_PARAM;
    }

    /* Get index (=position) of media object in list from ListControl */
    tPosition position = POSITION_NOT_SET;
    ret = LocalSPM::GetListControl().GetPositionInList(OUT position, IN listID, IN objectID);
    if (ret) return ret;

    if(position == POSITION_NOT_SET)
    {
        ETG_TRACE_ERR(("CustomControl::PlayItemFromListByTag failed as ObjectID:%d is not part of list:%d",objectID, listID));
        return MP_ERR_CC_INVALID_PARAM;
    }

    /* Call internal PlayItemFromList */
    ret = PlayItemFromList(OUT listSize, IN listID, IN (tIndex)position, 0);
    if (ret) return ret;

    return ret;
}

tResult CustomControl::ActiveMediaDeviceGet(tDeviceInfo &deviceInfo) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID;

    /* Get the current active device ID */
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (ret) return ret;

    /* Get the info to the device */
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::AutoRegisterOnDBTrigger(const tTriggerState autoRegister)
{
    ENTRY

    mAutoRegisterOnDBTrigger = autoRegister;

    return MP_NO_ERROR;
}

tResult CustomControl::SwitchDBTrigger(const tTriggerType trigger, const tTriggerState onOff)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_INSERTED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_INSERTED) {
                ret = LocalSPM::GetDBManager().OnInsertTrigger(OUT mTriggerID_DB_DEVICE_INSERTED,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "WHEN NEW.ID>0 AND NEW.ConnectionState=1",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=NEW.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_INSERTED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_INSERTED);
                mTriggerID_DB_DEVICE_INSERTED = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_CHANGED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_CHANGED_CSTATE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_CSTATE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN NEW.ID>0 AND OLD.ConnectionState != NEW.ConnectionState",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_ISTATE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_ISTATE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "IndexingState",
                    IN "WHEN NEW.ID>0 AND OLD.IndexingState != NEW.IndexingState",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_ACTIVE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_ACTIVE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "Active",
                    IN "WHEN OLD.Active != NEW.Active",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DiPOCapable",
                    IN "WHEN NEW.ID>0 AND OLD.DiPOCapable != NEW.DiPOCapable",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DiPOActive",
                    IN "WHEN NEW.ID>0 AND OLD.DiPOActive != NEW.DiPOActive",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_NAME) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_NAME,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "FriendlyName",
                    IN "WHEN NEW.ID>0 AND OLD.FriendlyName != NEW.FriendlyName",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DisconnectReason",
                    IN "WHEN NEW.ID>0 AND OLD.ConnectionState=NEW.ConnectionState AND OLD.DisconnectReason != NEW.DisconnectReason",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "FirmwareVersion",
                    IN "WHEN NEW.ID>0 AND OLD.FirmwareVersion != NEW.FirmwareVersion",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "IsShuffleSupported",
                    IN "WHEN NEW.ID>0 AND OLD.IsShuffleSupported != NEW.IsShuffleSupported",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "IsRepeatSupported",
                    IN "WHEN NEW.ID>0 AND OLD.IsRepeatSupported != NEW.IsRepeatSupported",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_NOWPLAYINGLIST_AVAILABLE){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NOWPLAYINGLIST_AVAILABLE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "IsNowPlayingListAvailable",
                    IN "WHEN OLD.IsNowPlayingListAvailable != NEW.IsNowPlayingListAvailable",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DeviceUUID",
                    IN "WHEN NEW.ID>0 AND OLD.DeviceUUID != NEW.DeviceUUID",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
                ETG_TRACE_USR4(("ret: %d, mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID: %d",ret, mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID));
            }
            /*if(!mTriggerID_DB_DEVICE_CHANGED_DISCTYPE){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DISCTYPE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DiscType",
                    IN "WHEN NEW.ID>0 AND OLD.DiscType != NEW.DiscType",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
                ETG_TRACE_USR4(("ret: %d, mTriggerID_DB_DEVICE_CHANGED_DISCTYPE: %d",ret, mTriggerID_DB_DEVICE_CHANGED_DISCTYPE));
            }*/
            if(!mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEMACADDRESS){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEMACADDRESS,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "AppleDeviceMACAddress",
                    IN "WHEN NEW.ID>0 AND OLD.AppleDeviceMACAddress != NEW.AppleDeviceMACAddress",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
                ETG_TRACE_USR4(("ret: %d, mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEMACADDRESS: %d",ret, mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEMACADDRESS));
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL){
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "AppleDeviceUSBSerial",
                    IN "WHEN NEW.ID>0 AND OLD.AppleDeviceUSBSerial != NEW.AppleDeviceUSBSerial",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
                ETG_TRACE_USR4(("ret: %d, mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL: %d",ret, mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL));
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_DSTATE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DSTATE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "DeviceState",
                    IN "WHEN NEW.ID>0 AND NEW.DeviceState != OLD.DeviceState AND (NEW.DeviceType=2 OR NEW.DeviceType=5)", /* DTY_IPOD = 2, DTY_IPHONE = 5 */
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_UPDATED",
                    IN "Devices",
                    IN "FreeSize",
                    IN "WHEN NEW.ID>0 AND (NEW.FreeSize != OLD.FreeSize OR NEW.TotalSize != OLD.TotalSize)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if(!mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT)
            {
                //Note:Trigger limited to MassStorageDevices.Reason:Currently ImageFiles supported ONLY in such devices.
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT,
                        IN GetSMNameFull(),
                        IN "DB_DEVICE_UPDATED",
                        IN "Devices",
                        IN "NumberOfImageFiles",
                        IN "WHEN NEW.ID>0 AND (NEW.NumberOfImageFiles != OLD.NumberOfImageFiles) AND (NEW.DeviceType=1 OR NEW.DeviceType=3 OR NEW.DeviceType=8 OR NEW.DeviceType=11)");
                if(ret != MP_NO_ERROR)
                {
                    ETG_TRACE_ERR(("UpdateTrigger Registration Failed for ImageFileCount with Error:%s",errorString(ret)));
                }
            }
        } else {
            if (mTriggerID_DB_DEVICE_CHANGED_CSTATE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_CSTATE);
                mTriggerID_DB_DEVICE_CHANGED_CSTATE = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_ISTATE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_ISTATE);
                mTriggerID_DB_DEVICE_CHANGED_ISTATE = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_ACTIVE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_ACTIVE);
                mTriggerID_DB_DEVICE_CHANGED_ACTIVE = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE);
                mTriggerID_DB_DEVICE_CHANGED_DIPOCAPABLE = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE);
                mTriggerID_DB_DEVICE_CHANGED_DIPOACTIVE = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_NAME) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_NAME);
                mTriggerID_DB_DEVICE_CHANGED_NAME = 0;
            }
            if (mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON);
                mTriggerID_DB_DEVICE_CHANGED_DISCONNECTIONREASON = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION);
                mTriggerID_DB_DEVICE_CHANGED_FIRMWARE_VERSION = 0;
            }
            if(mTriggerID_DB_DEVICE_NOWPLAYINGLIST_AVAILABLE){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NOWPLAYINGLIST_AVAILABLE);
                mTriggerID_DB_DEVICE_NOWPLAYINGLIST_AVAILABLE = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID);
                mTriggerID_DB_DEVICE_CHANGED_DEVICEUUID = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT);
                mTriggerID_DB_DEVICE_CHANGED_SHUFFLE_SUPPORT = 0;
            }

            if(mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT);
                mTriggerID_DB_DEVICE_CHANGED_REPEAT_SUPPORT = 0;
            }

            /*if(mTriggerID_DB_DEVICE_CHANGED_DISCTYPE){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DISCTYPE);
                mTriggerID_DB_DEVICE_CHANGED_DISCTYPE = 0;
            }*/
            if(mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL);
                mTriggerID_DB_DEVICE_CHANGED_APPLEDEVICEUSBSERIAL = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_DSTATE){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DSTATE);
                mTriggerID_DB_DEVICE_CHANGED_DSTATE = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE){
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE);
                mTriggerID_DB_DEVICE_CHANGED_DEVICESIZE = 0;
            }
            if(mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT)
            {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT);
                if(ret != MP_NO_ERROR)
                {
                    ETG_TRACE_ERR(("Unregister ImageFileCount Trigger Failed with Error:%s",errorString(ret)));
                }
                mTriggerID_DB_DEVICE_CHANGED_IMAGE_FILECOUNT = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_CONNECTED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_CONNECTED) {
                //Roadmap 13035 OverTemperature  (DB_DEVICE_UPDATED above already covered)
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_CONNECTED,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_CONNECTED",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN OLD.ConnectionState<>0 AND OLD.ConnectionState<>6 AND (NEW.ConnectionState=0 OR NEW.ConnectionState=6)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_CONNECTED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_CONNECTED);
                mTriggerID_DB_DEVICE_CONNECTED = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_SAME)
    {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_SAME_DEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_SAME_DEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN (OLD.ConnectionState=1 OR OLD.ConnectionState=2) AND NEW.ConnectionState=0 AND (OLD.FormerConnectionState=0 OR OLD.FormerConnectionState=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_ERROR_DEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_ERROR_DEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN (OLD.ConnectionState != NEW.ConnectionState) AND (NEW.ConnectionState=3 OR NEW.ConnectionState=4 OR NEW.ConnectionState=5 OR NEW.ConnectionState=6)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_DEVICE_ERROR_END_DEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_ERROR_END_DEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN (OLD.ConnectionState=3 OR OLD.ConnectionState=4 OR OLD.ConnectionState=5 OR OLD.ConnectionState=6) AND NEW.ConnectionState=0",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "NumberOfAudioFiles",
                    IN "WHEN ((OLD.NumberOfAudioFiles<1 AND NEW.NumberOfAudioFiles>0) OR (OLD.NumberOfAudioFiles>0 AND NEW.NumberOfAudioFiles<1) OR (OLD.NumberOfAudioFiles=-1 AND NEW.NumberOfAudioFiles=0)) AND (OLD.FormerConnectionState=0 OR OLD.FormerConnectionState=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "NumberOfVideoFiles",
                    IN "WHEN ((OLD.NumberOfVideoFiles<1 AND NEW.NumberOfVideoFiles>0) OR (OLD.NumberOfVideoFiles>0 AND NEW.NumberOfVideoFiles<1) OR (OLD.NumberOfVideoFiles=-1 AND NEW.NumberOfVideoFiles=0)) AND (OLD.FormerConnectionState=0 OR OLD.FormerConnectionState=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
             }
            if (!LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_SAME_DEVICE",
                    IN "Devices",
                    IN "NumberOfAudioFiles,NumberOfVideoFiles",
                    IN "WHEN (((OLD.NumberOfAudioFiles<1 AND OLD.NumberOfVideoFiles < 1)  AND (NEW.NumberOfAudioFiles>0 OR NEW.NumberOfVideoFiles>0)) OR ((OLD.NumberOfAudioFiles>0 OR OLD.NumberOfVideoFiles >0) AND (NEW.NumberOfAudioFiles<1 AND NEW.NumberOfVideoFiles<1)) OR (((OLD.NumberOfAudioFiles=-1 AND OLD.NumberOfVideoFiles=0) OR (OLD.NumberOfAudioFiles=0 AND OLD.NumberOfVideoFiles=-1) OR (OLD.NumberOfAudioFiles=-1 AND OLD.NumberOfVideoFiles=-1))  AND (NEW.NumberOfAudioFiles=0 AND NEW.NumberOfVideoFiles=0))) AND (OLD.FormerConnectionState=0 OR OLD.FormerConnectionState=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
             }
        }
        else
        {
            if (mTriggerID_DB_DEVICE_SAME_DEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_SAME_DEVICE);
                mTriggerID_DB_DEVICE_SAME_DEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_ERROR_DEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_ERROR_DEVICE);
                mTriggerID_DB_DEVICE_ERROR_DEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_ERROR_END_DEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_ERROR_END_DEVICE);
                mTriggerID_DB_DEVICE_ERROR_END_DEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE);
                mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_SAMEDEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE);
                mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_SAMEDEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE) {
                   ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE);
                   mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_SAMEDEVICE = 0;
            }
    }

    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_NEW)
    {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_NEW_DEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NEW_DEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_NEW_DEVICE",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN (OLD.ConnectionState=1 OR OLD.ConnectionState=2) AND NEW.ConnectionState=0 AND (OLD.FormerConnectionState!=0 AND OLD.FormerConnectionState!=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if (LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_NEW_DEVICE",
                    IN "Devices",
                    IN "NumberOfAudioFiles",
                    IN "WHEN ((OLD.NumberOfAudioFiles<1 AND NEW.NumberOfAudioFiles>0) OR (OLD.NumberOfAudioFiles>0 AND NEW.NumberOfAudioFiles<1) OR (OLD.NumberOfAudioFiles=-1 AND NEW.NumberOfAudioFiles=0)) AND (OLD.FormerConnectionState!=0 AND OLD.FormerConnectionState!=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            if ( LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE) {
                 ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE,
                     IN GetSMNameFull(),
                     IN "DB_DEVICE_NEW_DEVICE",
                     IN "Devices",
                     IN "NumberOfVideoFiles",
                     IN "WHEN ((OLD.NumberOfVideoFiles<1 AND NEW.NumberOfVideoFiles>0) OR (OLD.NumberOfVideoFiles>0 AND NEW.NumberOfVideoFiles<1) OR (OLD.NumberOfVideoFiles=-1 AND NEW.NumberOfVideoFiles=0)) AND (OLD.FormerConnectionState!=0 AND OLD.FormerConnectionState!=8)",
                     IN "COUNT()",
                     IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
            //RTC-341485
            if (!LocalSPM::GetDataProvider().SeparateMediaContent() && !mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_NEW_DEVICE",
                    IN "Devices",
                    IN "NumberOfAudioFiles,NumberOfVideoFiles",
                    IN "WHEN (((OLD.NumberOfAudioFiles<1 AND OLD.NumberOfVideoFiles < 1)  AND (NEW.NumberOfAudioFiles>0 OR NEW.NumberOfVideoFiles>0)) OR ((OLD.NumberOfAudioFiles>0 OR OLD.NumberOfVideoFiles >0) AND (NEW.NumberOfAudioFiles<1 AND NEW.NumberOfVideoFiles<1)) OR (((OLD.NumberOfAudioFiles=-1 AND OLD.NumberOfVideoFiles=0) OR (OLD.NumberOfAudioFiles=0 AND OLD.NumberOfVideoFiles=-1) OR (OLD.NumberOfAudioFiles=-1 AND OLD.NumberOfVideoFiles=-1))  AND (NEW.NumberOfAudioFiles=0 AND NEW.NumberOfVideoFiles=0))) AND (OLD.FormerConnectionState!=0 AND OLD.FormerConnectionState!=8)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
             }
        }
        else
        {
            if (mTriggerID_DB_DEVICE_NEW_DEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NEW_DEVICE);
                mTriggerID_DB_DEVICE_NEW_DEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE);
                mTriggerID_DB_DEVICE_NUMBER_OF_AUDIO_FILES_NEWDEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE) {
               ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE);
               mTriggerID_DB_DEVICE_NUMBER_OF_VIDEO_FILES_NEWDEVICE = 0;
            }
            if (mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE) {
               ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE);
               mTriggerID_DB_DEVICE_NUMBER_OF_PLAYABLE_FILES_NEWDEVICE = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_REMOVED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_REMOVED) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_REMOVED,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_REMOVED",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN OLD.ConnectionState<>2 AND OLD.ConnectionState<>7 AND (NEW.ConnectionState=2 OR NEW.ConnectionState=7 OR NEW.ConnectionState=6)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_REMOVED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_REMOVED);
                mTriggerID_DB_DEVICE_REMOVED = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_ACTIVATED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_ACTIVATED) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_ACTIVATED,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_ACTIVATED",
                    IN "Devices",
                    IN "Active",
                    IN "WHEN OLD.Active=0 AND NEW.Active=1",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_ACTIVATED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_ACTIVATED);
                mTriggerID_DB_DEVICE_ACTIVATED = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_REPEAT_MODE) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_REPEAT_MODE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_REPEAT_MODE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_REPEAT_MODE",
                    IN "Devices",
                    IN "RepeatMode",
                    //IN "WHEN (OLD.RepeatMode<=2 AND NEW.RepeatMode>2) OR (OLD.RepeatMode>2 AND NEW.RepeatMode<=2)",
                    IN "WHEN (OLD.RepeatMode>2 AND NEW.RepeatMode<=2) OR (OLD.RepeatMode<>0 AND NEW.RepeatMode=0) OR (OLD.RepeatMode<>3 AND NEW.RepeatMode=3) OR (OLD.RepeatMode<>4 AND NEW.RepeatMode=4) OR (OLD.RepeatMode <>5 AND NEW.RepeatMode=5)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_REPEAT_MODE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_REPEAT_MODE);
                mTriggerID_DB_DEVICE_REPEAT_MODE = 0;
            }
        }
    }
    //TODO(kmv5cob):check if we need to consider video files and act accordingly
    if (trigger == TT_ALL || trigger == TT_DB_DEVICE_NUMBER_OF_FILES) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE,
                    IN GetSMNameFull(),
                    IN "DB_DEVICE_FIRST_CONTENT_AVAILABLE",
                    IN "Devices",
                    IN "NumberOfAudioFiles",
                    IN "WHEN (OLD.NumberOfAudioFiles<1 AND NEW.NumberOfAudioFiles>0) OR (OLD.NumberOfAudioFiles>0 AND NEW.NumberOfAudioFiles = 1)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE);
                mTriggerID_DB_DEVICE_FIRST_CONTENT_AVAILABLE = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_FAVORITE_CHANGED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_FAVORITE_UPDATED_ACTIVE) {
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_FAVORITE_UPDATED_ACTIVE,
                    IN GetSMNameFull(),
                    IN "DB_FAVORITE_UPDATED",
                    IN "Favorites",
                    IN "Active",
                    IN "WHEN OLD.Active != NEW.Active",
                    IN "COUNT()",
                    IN "SELECT ID FROM Favorites WHERE ROWID=OLD.ROWID");
            }
            if (!mTriggerID_DB_FAVORITE_UPDATED_AVAIL) {
                ret =LocalSPM::GetDBManager().OnUpdateTrigger(OUT mTriggerID_DB_FAVORITE_UPDATED_AVAIL,
                    IN GetSMNameFull(),
                    IN "DB_FAVORITE_UPDATED",
                    IN "Favorites",
                    IN "Available",
                    IN "WHEN OLD.Available != NEW.Available",
                    IN "COUNT()",
                    IN "SELECT ID FROM Favorites WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_FAVORITE_UPDATED_ACTIVE) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_FAVORITE_UPDATED_ACTIVE);
                mTriggerID_DB_FAVORITE_UPDATED_ACTIVE = 0;
            }
            if (mTriggerID_DB_FAVORITE_UPDATED_AVAIL) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_FAVORITE_UPDATED_AVAIL);
                mTriggerID_DB_FAVORITE_UPDATED_AVAIL = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_FAVORITE_INSERTED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_FAVORITE_INSERTED) {
                ret = LocalSPM::GetDBManager().OnInsertTrigger(OUT mTriggerID_DB_FAVORITE_INSERTED,
                     IN GetSMNameFull(),
                     IN "DB_FAVORITE_INSERTED",
                     IN "Favorites",
                     IN NULL,
                     IN "COUNT()",
                     IN "SELECT ID FROM Favorites WHERE ROWID=NEW.ROWID");
            }
        } else {
            if (mTriggerID_DB_FAVORITE_INSERTED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_FAVORITE_INSERTED);
                mTriggerID_DB_FAVORITE_INSERTED = 0;
            }
        }
    }

    if (trigger == TT_ALL || trigger == TT_DB_FAVORITE_DELETED) {
        if (onOff == TS_ON) {
            if (!mTriggerID_DB_FAVORITE_DELETED) {
                ret = LocalSPM::GetDBManager().OnDeleteTrigger(OUT mTriggerID_DB_FAVORITE_DELETED,
                     IN GetSMNameFull(),
                     IN "DB_FAVORITE_DELETED",
                     IN "Favorites",
                     IN NULL,
                     IN "COUNT()",
                     IN "SELECT ID FROM Favorites WHERE ROWID=OLD.ROWID");
            }
        } else {
            if (mTriggerID_DB_FAVORITE_DELETED) {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN mTriggerID_DB_FAVORITE_DELETED);
                mTriggerID_DB_FAVORITE_DELETED = 0;
            }
        }
    }

    return ret;
}

tResult CustomControl::SetActiveStreamingDevice(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID);
    tResult ret = MP_NO_ERROR;

    /* Create play list for iPod */
    tListID listID = LIST_ID_NONE;
    tListSize listSize = 1;
    tIndex listIndex = INDEX_LAST_ACTIVE_OBJECT;
    tPlaytime offset = PLAYTIME_NONE; //In case of LTY_CURRENT_SELECTION this means play from last position and not from beginning
    tStreaming streaming = true;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    if(IsAppleDevice(deviceInfo.deviceType))
    {
        tag1.tag = IPOD_MARKER_BIT;
        tag2.tag = IPOD_MARKER_BIT;
        tag3.tag = IPOD_MARKER_BIT;
        tag4.tag = IPOD_MARKER_BIT;

        ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT listID,
                OUT listSize,
                LTY_CURRENT_SELECTION,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        //if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret; //Don't go on if the LTY_CURRENT_SELECTION list is empty
        if (ret) return ret;
    }
    else if(DTY_BLUETOOTH == deviceInfo.deviceType)
    {
        tBoolean isSourceAllocated = false;
        if(LocalSPM::GetDataProvider().UseArlSrcBtAudio()) //NCG3D-57249 - Try ListCreation for Playing ONLY if BTAudio is already Allocated.
        {
            tSource source = 0;
            ret = LocalSPM::GetOutputWrapper().GetCurrentSource(OUT source);
            if((MP_NO_ERROR == ret) && (BT_AUDIO == source))
            {
                isSourceAllocated = true;
            }
        }
        else
        {
            isSourceAllocated = true;
        }

        if(true == isSourceAllocated)
        {

            tNumberOfMediaObjects numberOfMediaObjects;
            tNumberOfPlayLists numberOfPlayLists;
            tNumberOfFolders numberOfFolders;

            /* create a normal file list for BT device*/
            if(LocalSPM::GetDataProvider().BtNowPlayingListSupport())
            {
                ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                    OUT listID,
                    OUT listSize,
                    OUT numberOfMediaObjects,
                    OUT numberOfPlayLists,
                    OUT numberOfFolders,
                    IN LTY_BLUETOOTH_FILELIST,
                    IN "now-playing",
                    IN deviceID,
                    IN streaming);
                if (ret) return ret;
            }
            else
            {
                ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                    OUT listID,
                    OUT listSize,
                    OUT numberOfMediaObjects,
                    OUT numberOfPlayLists,
                    OUT numberOfFolders,
                    IN LTY_BLUETOOTH_FILELIST,
                    IN "dummy-now-playing",
                    IN deviceID,
                    IN streaming);
                if (ret) return ret;
            }
        }
        else
        {
            ETG_TRACE_USR4(("SetActiveStreamingDevice:SOURCE NOT ALLOCATED.So Device will not be activated"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("SetActiveStreamingDevice: Device type not supported for streaming (deviceID: %u, type: %u) cannot be played", deviceID, deviceInfo.deviceType));
        return MP_ERR_CC_UNSUPPORTED_DEVICE_TYPE;
    }

#if 0 //Is done in PlayerManager::NewList
    /* Position the iPod current selection */
    tMediaObject mediaObject;
    ret = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN listID, IN INDEX_LAST_ACTIVE_OBJECT);
    //if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret; //Don't go on if the LTY_CURRENT_SELECTION list is empty
    if (ret) return ret;
#endif

#if 0 //Do nothing if list is empty
    if(ret == MP_ERR_DB_END_OF_LIST)
    {
        /* No iPod last mode list, create all songs list */
        tag1.tag = 0;
        tag2.tag = 0;
        tag3.tag = 0;
        tag4.tag = 0;

        ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT listID,
                OUT listSize,
                LTY_SONG,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
    }
#endif

    if((LIST_ID_NONE != listID))
       // && (0 < listSize)) //VTIPOD does not always supports a list size (see Pandora)
    {
        /* Set device as active in DB */
        ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
        if (ret) return ret;

        /* Play created list */
        ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN listIndex, IN offset);
        if (ret) return ret;
    }
    else
    {
        ETG_TRACE_ERR(("SetActiveStreamingDevice: Created list (listID: %u, size: %u) not playable", listID, listSize));
        return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
    }

    return MP_NO_ERROR;
}

bool CustomControl::TimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY_INTERNAL
    (void)timerID;
    CustomControl *self = (CustomControl*)instance;
    (void)userData;
    tResult ret = MP_NO_ERROR;

    /* Send the timeout message */
    ret = self->SendMessageTimeout();
    if (ret) {
        ETG_TRACE_ERR(("TimerCallBack: SendMessageTimeout returned %d", ret));
    }

    return MP_NO_ERROR;
}


tResult CustomControl::CreateQuickPlayList(tListInfo &listInfo, const tListType listType,
        const tObjectID filterTags[4], const tPlayContinuation playContinuation, const tDeviceID deviceID) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tListID listID; // this is a known memory leak
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    /* Set the filter tags */
    tag1.tag = filterTags[0];
    tag2.tag = filterTags[1];
    tag3.tag = filterTags[2];
    tag4.tag = filterTags[3];

    /* Create the play list */
    ret = LocalSPM::GetListControl().CreatePlayList(
            OUT listID,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    if (ret) return ret;
    VARTRACE(listID);

    /* Get the list info */
    tBoolean withListSize = true;
    ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    if (ret) return ret;

    /* Start the playback if at least one element is in the list */
    if(0 < listInfo.listSize)
    {
        /* Set device as active in DB */
        ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
        if (ret) return ret;


        /* Play the created list */
        ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN 0, IN 0);
        if (ret) return ret;
    }
    else
    {
        ETG_TRACE_ERR(("Created list (listID: %u, size: %u) cannot be played", listID, listInfo.listSize));
        return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::CreateFolderQuickPlayList(tListSize &listSize, const tPath path,
        const tPlayContinuation playContinuation, const tDeviceID deviceID,const tListType listType) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tListID listID;

    /* Create the play list */
    (void)playContinuation;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tFileTypeSelection fileTypeSelection = LocalSPM::GetDBManager().GetFTSByActiveMediaContext();

    ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN listType,
            IN path,
            IN deviceID,
            IN false, //streaming
            IN fileTypeSelection);
    if (ret) return ret;

    listSize = numberOfMediaObjects;

    /* Start the playback if at least one media object is in the list */
    if(0 < listSize)
    {
        /* Set device as active in DB */
        ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
        if (ret) return ret;


        /* Play the created list */
        ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN 0, IN 0);
        if (ret) return ret;
    }
    else
    {
        ETG_TRACE_ERR(("Created list (listID: %u, size: %u) cannot be played", listID, listSize));
        return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::PlayObjectID(tBoolean &isActive, tListID &listID , const tObjectID objectID,
        const tCategoryType objectType, const tPlayContinuation playContinuation) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tIndex playposition= INDEX_LAST_ACTIVE_OBJECT; //position of object in list for playing

    /* Retrieve the MY_MEDIA device info */
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN MY_MEDIA);
    if (ret) return ret;

    /* Check if object has to be played only from active device */
    if(LocalSPM::GetDataProvider().PlayObjectFromActiveDevice())
    {
        ret = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
        if (ret) return MP_ERR_CC_DEVICE_NOT_ACTIVE;
    }
    else if((LocalSPM::GetDataProvider().MyMediaVisible()) && (deviceInfo.connectionState == CS_CONNECTED))
    {
        /* Is MY_MEDIA configured and more than 1 device connected , then play the tag with MY_MEDIA as the active device */
        deviceID = MY_MEDIA;
    }
    else
    {
        /* Look for the device to which requested tag belongs */
        deviceID = DEVICE_ID_NOT_SET;

        /* Get physical device of the current media object */
        tMediaObject mediaObject;
        ret = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, IN objectType);
        if (ret) return ret;

        /* Check if device is currently connected */
        InitDeviceInfo(deviceInfo);
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
        if (ret) return ret;

        if(deviceInfo.connectionState == CS_CONNECTED)
        {
            deviceID = mediaObject.deviceID;
        }
    }

    if( DEVICE_ID_NOT_SET == deviceID )
    {
        return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
    }

    /* Create a playable list for that particular object ID */
    listID = LIST_ID_NONE;
    ret = LocalSPM::GetListControl().CreatePlayList(OUT listID, IN objectID, IN objectType, IN playContinuation, IN deviceID);
    if (ret) return ret;

    /* Only resume an audiobook */
    tPlaytime offset = 0;
    if(CTY_TITLE == objectType)
    {
        offset = PLAYTIME_NONE;
    }

    /* Get media object info to check if at least one object is available */
    tMediaObjectInfo mediaObjectInfo;
    ret = LocalSPM::GetListControl().CheckMediaObject(OUT mediaObjectInfo, IN listID, IN 0, IN 0);
    if (ret) return ret;

    /* Start the playback if first mediaobject is available*/
    if(1 > mediaObjectInfo.ObjectValid)
    {
        return MP_ERR_CC_NO_OBJECT_AVAILABLE;
    }

    /* Set device to active */
    ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
    if (ret) return ret;

    switch(objectType)
    {
        case CTY_GENRE:
        case CTY_ARTIST:
        case CTY_ALBUM:
        case CTY_COMPOSER:
        case CTY_AUTHOR:
        case CTY_TITLE:
        case CTY_PLAYLIST:
           playposition = 0;                          //Set first object as position
           break;
        case CTY_SONG:
        case CTY_PODCAST:
        case CTY_VIDEO:
        case CTY_AUDIOBOOK:
        case CTY_NAME:
        default:
           playposition = INDEX_LAST_ACTIVE_OBJECT;   //Set current playing object as position
           break;
    }


    /* Get active state from PlayerManager (do it before SendNewList to prevent a transition problem) */
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    if (ret) return ret;


    /* Play this list */
    ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN playposition, IN offset);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::SendActiveMediaDeviceSet(const tDeviceID deviceID, const tDeviceActiveSource activeSource, const tMediaContext mediaContext)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* use a request / response state machine to request ActiveMediaDeviceSet */
    class ActiveMediaDeviceSetRR: public RequestResponseSM {

        int HandleInitRequest() {
            SetAnswerTimeout(2000L); // Set special answer timeout for ActiveMediaDeviceSet request
            mResult = MP_NO_ERROR;
            return 0;
        }

        int HandleSuccessRequest(const char *allParameters) {
            if (!allParameters || strlen_r(allParameters) == 0) {
                /* set an error */
                mResult = MP_ERR_CC_INVALID_PAYLOAD;
            } else {
                /* read out the pointer to the umount result */
                UnMarshal(IN allParameters, "i", OUT &mResult);
            }
            return 0;
        }

        int HandleEntryWaitingRequest() {
            return 0;
        }

    public:
        tResult mResult;
    };

    /* Send ACTIVE_MEDIA_DEVICE_SET message to own SM */
    char messageString[64];
    strncpy_r(OUT messageString, IN "CustomControlSM::ACTIVE_MEDIA_DEVICE_SET", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterACTIVE_MEDIA_DEVICE_SET(OUT parameterString, IN size, IN deviceID, IN activeSource, IN mediaContext);
    if (ret) return ret;

    //ret = SendEvent(ACTIVE_MEDIA_DEVICE_SET, IN parameterString);
    ActiveMediaDeviceSetRR rrActiveMediaDeviceSet;
    ret = rrActiveMediaDeviceSet.DoEventAnswer(IN messageString, parameterString);
    if (ret) return ret;

    return rrActiveMediaDeviceSet.mResult;;
}

tResult CustomControl::HandleActiveMediaDeviceSet(const tDeviceID deviceID, const tDeviceActiveSource activeSource, const tMediaContext mediaContext)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = ActiveMediaDeviceSet(IN deviceID, IN activeSource, IN mediaContext);

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    SMF::Marshal(parameterString, size - 1, "i", ret);

    ret = SendAnswer(IN parameterString);

    return ret;
}

tResult CustomControl::ActiveMediaDeviceSet(const tDeviceID deviceID, const tDeviceActiveSource activeSource, const tMediaContext mediaContext)
{
    ENTRY
    VARTRACE(deviceID)
    VARTRACE(activeSource)
    VARTRACE(mediaContext)

    tResult ret = MP_NO_ERROR;

    if (activeSource) {

        /* Check if the requested device is connected */
        tDeviceInfo deviceInfo;
        tMediaContext currentmediaContext;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        if (ret) return ret;
        if (!deviceInfo.connected) return MP_ERR_CC_DEVICE_NOT_CONNECTED;

        /* Get the active device */
        tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
        ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
        if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
        /* Get the current active media context value */
        ret = LocalSPM::GetDBManager().GetMediaContext( OUT currentmediaContext);

        /* If current device is not the requested one */
        /* Note: Fast reconnection of USB devices can force a mount point change (NCG3D-164).
         * In this case it makes sense to call CheckListSelection for file lists even if the deviceID does not change.
         * But due to several side effects it is deactivated again because the first defect is very rare and heals itself after 2-3s */
        if ((deviceID != currentDeviceID) || ( mediaContext != currentmediaContext)) {
        if( deviceID !=currentDeviceID)
        {
          /* Set device as active in DB */
         ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
        if (ret) return ret;
        }
        if( mediaContext != currentmediaContext)
        {
         LocalSPM::GetDBManager().SetMediaContext( IN mediaContext);
        }

       /* Use ListSelectionTable to decide what kind of list has to be created and played */
        ret = CheckListSelection(IN deviceID);
        if (ret) return ret;
      }


    }
    else {

        /* Set device as deactive in DB */
        ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN false);
        if (ret) return ret;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::ListIsEmpty(const tListID listID, const tNoObjectReason noObjectReason)
{
    ENTRY
    // see ListIsEmpty.vsd in DocuShare

    tResult ret = MP_NO_ERROR;

    switch(noObjectReason)
    {
    case NOR_NEW_LIST:
        //Do nothing
        break;
    case NOR_VIDEO_SOURCE:
         //DO nothing
         break;
    case NOR_LIST_IS_NOT_PLAYABLE:
    case NOR_END_OF_LIST:
        ret = LocalSPM::GetPlayerManager().SetNowPlayingState(NP_LIST_COMPLETE);
        break;
    case NOR_START_OF_LIST:
        ret = LocalSPM::GetPlayerManager().SetNowPlayingState(NP_LIST_START);
        break;
    case NOR_NO_OBJECT:
    {
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
        if (ret) return ret;

        /* Check if the requested device is connected */
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
        if (ret) return ret;

        tMediaContext mediaContext;
        LocalSPM::GetDBManager().GetMediaContext(OUT mediaContext);

        if (!deviceInfo.connected || ((MC_VIDEO == mediaContext) && (FALSE == LocalSPM::GetDataProvider().CreateListForVideoSource())))
        {
            ret = LocalSPM::GetPlayerManager().SetNowPlayingState(NP_NO_DEVICE);
            if (ret) return ret;
        }
        else
        {
            ret = LocalSPM::GetPlayerManager().SetNowPlayingState(NP_LIST_COMPLETE);
            if (ret) return ret;

            /* Create AllSongsList only if current list has another type */
            if (LTY_SONG != listInfo.listType)
            {
                ETG_TRACE_USR3(("ListIsEmpty due to NoObject: Create and play DB all songs list"));

                tListID newListID; // this is a known memory leak
                tStreaming streaming = false;
                tFilterTag1 tag1;
                tFilterTag2 tag2;
                tFilterTag3 tag3;
                tFilterTag4 tag4;

                tag1.tag = 0;
                tag2.tag = 0;
                tag3.tag = 0;
                tag4.tag = 0;

                ret = LocalSPM::GetListControl().CreatePlayList(OUT newListID,
                        LTY_SONG,
                        IN streaming,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        PC_REPEAT_CURRENT_LEVEL,
                        IN listInfo.deviceID);
                if (ret) return ret;

                /* Get media object info to check if at least one object is available */
                tMediaObjectInfo mediaObjectInfo;
                ret = LocalSPM::GetListControl().CheckMediaObject(OUT mediaObjectInfo, IN newListID, IN 0, IN 0);
                if (ret) return ret;

                /* Start the playback if first mediaobject is available*/
                if(1 == mediaObjectInfo.ObjectValid)
                {
                    /* Set the device as active */
                    ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN listInfo.deviceID, IN true);
                    if (ret) return ret;

                    /* Play the created list */
                    ret = LocalSPM::GetPlayerManager().SendNewList(IN newListID, IN 0, IN 0);
                    if (ret) return ret;
                }
                else
                {
                    // Set a flag to remember that 1st playable file is not yet found during reindexing
                    bPlayPendingInReindexing = true;
                }
            }
        }
        break;
    }
    case NOR_DEVICE_REMOVED:
    {
        ETG_TRACE_USR1(("          ***Start CustomControl::ListIsEmpty NOR_DEVICE_REMOVED***"));
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
        if(MP_NO_ERROR == ret)
        {
            /* Check if the requested device is connected */
            tDeviceInfo deviceInfo;
            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
            if(MP_NO_ERROR == ret)
            {
                if(deviceInfo.connected)
                {
                    if(strlen(deviceInfo.mountPoint))
                    {
                        if(IsMassStorageDevice(IN deviceInfo.deviceType))
                        {
                            /*check if read request on device related to this mount point is possible*/
                            if(!LocalSPM::GetDataProvider().checkIfDeviceConnected(deviceInfo.mountPoint))
                            {
                                ETG_TRACE_ERR(("Couldnt play the url from Device which is connected in still CONNECTED to MP but NOT Accessible!!"));

                                /* Inform AudioManagement about Error in playing the device */
                                ret = LocalSPM::GetOutputWrapper().UpdateDeviceConnection(deviceInfo.deviceID, CR_ERROR);
                                if(ret != MP_NO_ERROR)
                                {
                                    ETG_TRACE_ERR(("Error in updating device NOT Playable as Device is not accessible"));
                                }
                            }
                            else
                            {
                                ETG_TRACE_USR4(("Device mountpoint is accessible.AVOID Announcing NOT Playable"));
                            }
                        }
                        else
                        {
                            ETG_TRACE_FATAL(("CustomControl::ListIsEmpty Missing Handling of CR_ERROR for NON-MassStorage Devices"));
                        }
                    }
                    else
                    {
                        ETG_TRACE_ERR(("CustomControl::ListIsEmpty Empty Mountpoint!.could not update device NOT Playable"));
                    }
                }
                else
                {
                    LocalSPM::GetPlayerManager().SetNowPlayingState(NP_NO_DEVICE);
                }
            }
        }
        break;
    }
    default:
        ret = MP_ERR_CC_INVALID_PARAM;
        break;
    }

    return ret;
}

tBoolean CustomControl::IsStartupPhase(void) const
{
    ENTRY
    tBoolean timerRunning = false;

    if ((mTimerID)
        &&
        (false == mDeviceFound))
    {
        timerRunning = true;
    }

    return timerRunning;
}

tResult CustomControl::HandleTimeout(void)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tBool bIgnore = false;
    /* Stop the startup timer */
    StopStartupTimer();

    /* Avoid calling CheckDeviceActivation and CheckListSelection if the active source is BT_AUDIO */
    /* This is for avoiding other than BT devices getting active in BT Audio screen */
    if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
    {
        tSource source;
        ret = LocalSPM::GetOutputWrapper().GetCurrentSource(OUT source);
        if(!ret && (BT_AUDIO == source))
        {
            bIgnore = true;
        }
    }

    if ((false == mDeviceFound) && !bIgnore)
    {
        /* Use DeviceActivationTable to decide if and which device has to be activated */
        tConfigTablePrecondition precondition = CTP_TIMER_EXPIRED;
        tDeviceID deviceID = MY_MEDIA;
        ret = CheckDeviceActivation(INOUT deviceID, IN precondition);
        if (ret) return ret;

        /* Use ListSelectionTable to decide what kind of list has to be created and played */
        ret = CheckListSelection(IN deviceID);
        if (ret) return ret;
    }

    /* Clear last mode for all devices which are not connected any longer */
    /* Get all last mode devices */
    tNumberOfDevices numberOfDevices;
    vector<tDeviceID> deviceIDs;
    ret = LocalSPM::GetDBManager().GetLastModeDevices(OUT numberOfDevices, OUT deviceIDs);
    if (ret) return ret;

    if (0 < numberOfDevices)
    {
        /* Get all connected devices */
        vector<tDeviceInfo> deviceInfos;
        ret = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
        if (ret) return ret;

        tUInt i,j;
        for(i=0; i<deviceIDs.size(); i++) //Loop over all last mode devices
        {
            for(j=0; j<deviceInfos.size(); j++) //Loop over all connected devices
            {
                if (deviceIDs[i] == deviceInfos[j].deviceID) break;
            }

            if (deviceInfos.size() == j) //Not found
            {
                /* Clear last mode for this device */
                ret = LocalSPM::GetDBManager().ClearLastMode(IN deviceIDs[i]);
                if (ret) return ret;
            }
        }
    }

    return MP_NO_ERROR;
}

tResult CustomControl::SendMessageTimeout(void)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send the TIMEOUT event */
    ret = SendEvent(TIMEOUT, NULL);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::SendResetFormerConnection(void)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send the RESET_FORMER_CONNECTION event */
    ret = SendEvent(RESET_FORMER_CONNECTION, NULL);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::ResetFormerConnection()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Reset former connection state in DB */
    ret = LocalSPM::GetDBManager().ResetFormerConnection();
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleFavoriteInserted(const tFavCount favCount, const tFavoriteID favID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    ETG_TRACE_USR3(("CustomControl::HandleFavoriteInserted -> favID:%d , favCount:%d",favID,favCount));

    /* Send the update via Output wrapper*/
    ret = LocalSPM::GetOutputWrapper().SendFavoritesChanged(LCH_ITEMS_ADDED,favCount,favID);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleFavoriteDeleted(const tFavCount favCount, tFavoriteID favID)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    favID = mFavoriteManager.GetCurrentFavID();
    ETG_TRACE_USR3(("CustomControl::HandleFavoriteDeleted -> favID:%d , favCount:%d",favID,favCount));

    /* Send the update via Output wrapper*/
    ret = LocalSPM::GetOutputWrapper().SendFavoritesChanged(LCH_ITEMS_REMOVED,favCount,favID);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleFavoriteUpdated(const tFavCount favCount, const tFavoriteID favID)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ETG_TRACE_USR3(("CustomControl::HandleFavoriteUpdated -> favID:%d , favCount:%d",favID,favCount));

    /* Send the update via Output wrapper*/
    ret = LocalSPM::GetOutputWrapper().SendFavoritesChanged(LCH_ITEMS_CHANGED,favCount,favID);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceUpdated(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount; // parameters are only there because of the generator, but not needed
    tResult ret = MP_NO_ERROR;

    /* Filter the MY_MEDIA device */
    //if (deviceID == MY_MEDIA) return MP_NO_ERROR;

    /* Update HMI of property MediaPlayerDeviceConnections */
    ret = LocalSPM::GetOutputWrapper().UpdateMediaPlayerDeviceConnections();
    if (ret) return ret;

    /* Check if device is also active */
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    /* Update HMI of property ActiveMediaDevice also in case of connection state change */
    if (FALSE != deviceInfo.activeSource)
    {
        ret = LocalSPM::GetOutputWrapper().UpdateActiveMediaDevice();
        if (ret) return ret;
    }

    /* Update Audio when disconnectreason in DR_HW_MALFUNC_PERMANENT . Fix done for NCG3D-14402 */
    if(DR_HW_MALFUNC_PERMANENT == deviceInfo.disconnectReason)
    {
        /* Inform AudioManagement about device removal due to malfunction permanent*/
        ret = LocalSPM::GetOutputWrapper().UpdateDeviceConnection(deviceID, CR_SAME_MEDIA);
        if (ret) return ret;
    }


    if(LocalSPM::GetDataProvider().FavoritesSupported())
    {
        //Send Deviceupdate to FavoriteManager
        //Comment out because it is already done in HandleDeviceRemoved/HandleDeviceConnected (GMMY17-13147)
        //ret = mFavoriteManager.OnDeviceUpdate(IN deviceID, IN deviceInfo.connected);
        //if(ret) return ret;
    }
    return MP_NO_ERROR;

}

tResult CustomControl::HandleDeviceFirstContentAvailable(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;

    tDeviceInfo newDeviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT newDeviceInfo, IN deviceID);
    if (ret) return ret;

    tMediaContext mediaContext = MC_ALL;
    LocalSPM::GetDBManager().GetMediaContext( OUT mediaContext);


    if((LocalSPM::GetDataProvider().DBFileListWhileIndexing())
       &&
       ((IsMassStorageDevice(IN newDeviceInfo.deviceType)) || (newDeviceInfo.deviceType == DTY_MTP)) //DTY_USB, DTY_SD, DTY_CDROM, DTY_FLASH
       &&
       (    ((LocalSPM::GetDataProvider().IsDeviceAutoplay(IN deviceID))) || \
            ((newDeviceInfo.activeSource == true) && (bPlayPendingInReindexing == true))    ))
    {
        if( MC_VIDEO == mediaContext)
        {
           if(!(LocalSPM::GetDataProvider().CreateListForVideoSource()))
           return MP_NO_ERROR;
        }
        bPlayPendingInReindexing = false;
        /* Create and play DB all songs list */
        tListSize listID;
        tListSize listSize;
        tStreaming streaming = false;
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;

        tag1.tag = 0;
        tag2.tag = 0;
        tag3.tag = 0;
        tag4.tag = 0;

        ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT listID,
                OUT listSize,
                LTY_SONG,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        if (ret) return ret;

        if((LIST_ID_NONE != listID)
           &&
           (0 < listSize))
        {
            /* Play created list */
            ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN 0 /*listIndex*/, IN 0 /*offset*/);
            if (ret) return ret;
        }
        else
        {
            ETG_TRACE_ERR(("Created list (listID: %u, size: %u) cannot be played", listID, listSize));
            return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
        }
    }

    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceNewDevice(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;

    /* Inform AudioManagement about new device */
    ret = LocalSPM::GetOutputWrapper().UpdateDeviceConnection(IN deviceID, IN CR_NEW_MEDIA);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceSameDevice(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;

    /* Inform AudioManagement about device */
    ret = LocalSPM::GetOutputWrapper().UpdateDeviceConnection(IN deviceID, IN CR_SAME_MEDIA);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceConnected(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;

    tBool bIgnore = false;

    if(LocalSPM::GetDataProvider().FavoritesSupported())
    {
    /* Inform FavoriteManager about the device update which can in turn care for updating the
        status of all the favorite which belong to this device */
        ret = mFavoriteManager.OnDeviceUpdate(IN deviceID, /*tDeviceConnected*/ true);
    if(ret) return ret;
    }

    tDeviceInfo newDeviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT newDeviceInfo, IN deviceID);
    if (ret) return ret;

    /* Avoid calling CheckDeviceActivation and CheckListSelection if the active source is BT_AUDIO */
    /* This is for avoiding other than BT devices getting active in BT Audio screen */
    if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
    {
        tSource source;
        ret = LocalSPM::GetOutputWrapper().GetCurrentSource(OUT source);
        if(!ret && (BT_AUDIO == source))
        {
            if((DTY_BLUETOOTH != newDeviceInfo.deviceType) )
            {
                bIgnore = true;
            }
        }
    }


    if(IsAppleDevice(IN newDeviceInfo.deviceType))
    {
        ret = CheckSourceSwitchFromBTStreaming(newDeviceInfo);
        if(ret == MP_NO_ERROR)
        {
            ETG_TRACE_USR4(("BT device is put on hold as the same device is connected over USB"));
            return MP_NO_ERROR;
        }
    }

    /* Deliver playable state as soon as possible */
    if((LocalSPM::GetDataProvider().SearchForFirstPlayableFile())
       &&
       (!LocalSPM::GetDataProvider().DBFileListWhileIndexing())
       &&
       ((IsMassStorageDevice(IN newDeviceInfo.deviceType)) || (newDeviceInfo.deviceType == DTY_MTP))) //DTY_USB, DTY_SD, DTY_CDROM, DTY_FLASH
    {
        tListID listID;
        tListSize listSize;
        tNumberOfMediaObjects numberOfMediaObjects;
        tPath path;
        TimeTrace ticks("SearchForFirstPlayableFile");

        /* Create a file list which has a playable object */
        strncpy_r(path, "/", sizeof(path));
        ret = LocalSPM::GetListControl().GetFilelistWithObject(OUT listID, OUT listSize, OUT numberOfMediaObjects, IN path, IN deviceID, IN false /*streaming*/);
        if (ret) numberOfMediaObjects = 0;
        ticks.elapsed();

        /* Release the created list because not needed */
        ret = LocalSPM::GetListControl().ReleaseList(IN listID);
        //if (ret) return ret;

        //TODO(kmv5cob):check if we need to consider video files and act accordingly
        /* Set NumberOfAudioFiles of first playable folder for device */
        ret = LocalSPM::GetDBManager().SetNumberOfAudioFiles(IN deviceID, IN numberOfMediaObjects);
        if (ret) return ret;
    }

    if(!bIgnore)
    {
        /* Use DeviceActivationTable to decide if and which device has to be activated */
        tConfigTablePrecondition precondition = CTP_ADD_DEVICE;
        tDeviceID localDeviceID = deviceID;
        ret = CheckDeviceActivation(INOUT localDeviceID, IN precondition);
        if (ret) return ret;

        /* Use ListSelectionTable to decide what kind of list has to be created and played */
        ret = CheckListSelection(IN localDeviceID);
        if (ret) return ret;
    }
    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceRemoved(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;
    tDeviceInfo removedDeviceInfo;

    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT removedDeviceInfo, IN deviceID);
    if (ret) return ret;

    if(removedDeviceInfo.deviceType == DTY_IPHONE || removedDeviceInfo.deviceType == DTY_IPOD)
    {
        ret = HandleAppleDeviceRemoved(removedDeviceInfo);
    }

    /* Use DeviceActivationTable to decide if and which device has to be activated */
    tConfigTablePrecondition precondition = CTP_REMOVE_DEVICE;
    tDeviceID localDeviceID = deviceID;
    ret = CheckDeviceActivation(INOUT localDeviceID, IN precondition);
    if (ret) return ret;

    /* Update HMI of property ActiveMediaDevice */
    ret = LocalSPM::GetOutputWrapper().UpdateActiveMediaDevice();
    if (ret) return ret;

    /* Inform AudioManagement about removed device */
    ret = LocalSPM::GetOutputWrapper().UpdateDeviceConnection(deviceID, CR_SAME_MEDIA);
    if (ret) return ret;

    /* Check all lists against changes */
    ret = LocalSPM::GetListControl().CheckLists(IN deviceID);
    if (ret) return ret;

    if(LocalSPM::GetDataProvider().FavoritesSupported())
    {
    /* Inform FavoriteManager about the device removal which can in turn
         * care for updating the status of all the favorite which belong to this device */
        ret = mFavoriteManager.OnDeviceUpdate(IN deviceID, /*tDeviceConnected*/ false);
    if (ret) return ret;
    }

    /* Clear last mode for this device */
    ret = LocalSPM::GetDBManager().ClearLastMode(IN deviceID);
    if (ret) return ret;

    /*For DVD drive, change the connection state from disconnected to attached as it is internal disconnection - Fix for NCG3D-100247*/
    if(removedDeviceInfo.deviceType == DTY_DVD_DRIVE && removedDeviceInfo.disconnectReason == DR_INTERNALDISCONNECT)
    {
        ret = LocalSPM::GetDBManager().SetConnectionState(removedDeviceInfo.deviceID, CS_ATTACHED);
        if (ret) return ret;
    }
    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceActivated(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount;
    (void)deviceID;
    tResult ret = MP_NO_ERROR;

    LocalSPM::GetPlayerManager().SetActiveDevice(deviceID);

    /* Update HMI of property ActiveMediaDevice */
    ret = LocalSPM::GetOutputWrapper().UpdateActiveMediaDevice();
    if (ret) return ret;

    /* Update HMI of property NowPlaying too because HMI clears this info after receiving ActiveMediaDevice with a new device (GMMY17-10230) */
    ret = LocalSPM::GetOutputWrapper().UpdateNowPlaying();
    if (ret) return ret;

    /* Update HMI of property PlaybackMode (shuffle mode) */
    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackMode();
    if (ret) return ret;

    /* Update HMI of property RepeatMode */
    ret = LocalSPM::GetOutputWrapper().UpdateRepeatMode();
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::HandleDeviceRepeatMode(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount;
    tResult ret = MP_NO_ERROR;

    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    /*NCG3D-11430 - For DTY_BLUETOOTH, the NowPlayingList is created and managed by Phone device itself
      Hence don't try creating list.
    */
    if ((LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceInfo.deviceType))
        ||
        (DTY_CDDA == deviceInfo.deviceType)) return ret;

    /* Get current played list from PlayerManager */
    tListID listID;
    ret = LocalSPM::GetPlayerManager().GetListID(OUT listID);
    if (ret) return ret;

    /* Get the list info */
    tListInfo listInfo;
    tBoolean withListSize = false;
    ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    if (ret) return ret;

    if(deviceID != listInfo.deviceID) return ret;

    /* Get the repeat mode for that device */
    tRepeatMode repeatMode;
    ret = LocalSPM::GetDBManager().GetRepeatMode(OUT repeatMode, IN listInfo.deviceID);
    if (ret) return ret;

    /* Get current played media object from PlayerManager */
    tMediaObject mediaObject;
    ret = LocalSPM::GetPlayerManager().GetMediaObject(OUT mediaObject);
    if (ret) {
    strncpy_r(mediaObject.path, "/", sizeof(mediaObject.path));
    mediaObject.objectID = OBJECT_ID_NONE;
    ret = MP_NO_ERROR;
    }

    tListID newListID = LIST_ID_NONE;
    if(IsFileList(listInfo.listType))
    {
        /*When RepeatMode setting changed,Nowplayinglist is altered.Deciding Nowplayinglist's content is done
         * relavant to Repeat mode.It is described below:
         *
         * NOTE:TODO(pee1cob):
         * 1.For now,only Renault/Nissan PreferredNewListContent(..) setup done.Extend for all other projects
         * 2.DB Trigger donot exist when changed from RPT_LIST to RPT_ONE  and vice versa.Check the necessity and clean up unwanted triggers
         *
         * Repeat Mode                                      NowplayingList
         * ===========                                      ==============
         * RPT_ALL                                          all tracks in device
         * All other repeat modes                           configuration PreferredNewListContent(..) used to decide contents
         * */
        if(RPT_ALL != repeatMode)
        {
            tRepeatMode newListContentPreference = (tRepeatMode)LocalSPM::GetDataProvider().PreferredNewListContent();
            if(newListContentPreference != RPT_INVALID)
            {
                repeatMode = newListContentPreference;
            }
        }

        if((RPT_ONE == repeatMode)
           &&
           (LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext()))
        {
            tMediaContext mediaContext;
            LocalSPM::GetDBManager().GetMediaContext( OUT mediaContext);
            if(MC_VIDEO == mediaContext)
                repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode();
            else
                repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode();
        }

        VARTRACE(repeatMode);

        if (RPT_ALL == repeatMode)
        {
            ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                OUT newListID,
                IN "/" /*path*/,
                IN listInfo.deviceID,
                IN true /*withSubFolders*/);
        }
        else if (RPT_LIST_WITH_SUBLISTS == repeatMode)
        {
            ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                    OUT newListID,
                    IN mediaObject.path,
                    IN listInfo.deviceID,
                    IN true /*withSubFolders*/);
        }
        else
        {
            ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                OUT newListID,
                IN mediaObject.path,
                IN listInfo.deviceID,
                IN false /*withSubFolders*/);
        }
        if (ret) return ret;
    }
    else
    {
        /*For Indexed Lists,If current List's category is CTY_SONG,Set All songs list as the Next List.*/
        if(RPT_ALL == repeatMode)
        {
            tListType listType = LTY_END_OF_EXTERNAL_LIST_TYPES;
            tCategoryType categoryType = LocalSPM::GetDBManager().GetCTYByLTY(listInfo.listType);

            if(CTY_SONG == categoryType) listType = LTY_SONG;
            if(CTY_VIDEO == categoryType) listType = LTY_EPISODE_OF_VIDEO;

            if(listType != LTY_END_OF_EXTERNAL_LIST_TYPES)
            {
                tListSize listSize;
                tFilterTag1 tag1;
                tFilterTag2 tag2;
                tFilterTag3 tag3;
                tFilterTag4 tag4;

                tag1.tag = 0;
                tag2.tag = 0;
                tag3.tag = 0;
                tag4.tag = 0;

                ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                        OUT newListID,
                        OUT listSize,
                        IN listType,
                        IN (tStreaming)false,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        IN listInfo.deviceID);
                if (ret) return ret;
            }
        }
        else {
            return ret;
        }
    }

    /* Set current media object in created list */
    if(OBJECT_ID_NONE != mediaObject.objectID)
    {
        ret = LocalSPM::GetListControl().SetCurrentMediaObject(IN newListID, IN mediaObject.objectID);
        //if (ret) return ret; Go on even setting of current media object fails
        VARTRACE(ret);
    }

    /* Set next list at PlayerManager (it will be used after end of current song) */
    ret = LocalSPM::GetPlayerManager().SendNextList(newListID);
    if (ret) return ret;

    return MP_NO_ERROR;
}

tResult CustomControl::CheckDeviceActivation(tDeviceID &deviceID, const tConfigTablePrecondition precondition)
{
    ENTRY
    VARTRACE(precondition)
    VARTRACE(deviceID)

    tResult ret = MP_NO_ERROR;
    tConfigTableAction action = CTA_NONE;
    tConfigTable usedConfigTable = CT_DEVICE_ACTIVATION;

    /* Calculate action from config table */
    ret = LocalSPM::GetDataProvider().ProcessConfigTable(OUT action, IN usedConfigTable, IN precondition, IN deviceID);
    if (ret) return ret;

    //Check if the allocated source is BTA and the connected device is DTY_BLUETOOTH, then Activate teh device.
    if(CTA_NONE == action)
    {
      tDeviceInfo deviceInfo;
      tSource source;

      ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
      if (!ret)
      {
        ret = LocalSPM::GetOutputWrapper().GetCurrentSource(OUT source);
        if(!ret && (BT_AUDIO == source) && (DCT_BLUETOOTH == deviceInfo.connectionType))
        {
          action = CTA_ACTIVATE_DEVICE;
        }
      }
    }

    switch(action)
    {
        case CTA_ACTIVATE_DEVICE_STOP_TIMER:
        {
            ETG_TRACE_USR3(("Action: Activate device and stop startup timer"));

            /* Stop the startup timer */
            //StopStartupTimer(); tph: Don't stop timer here because we need timeout for ClearLastMode
            mDeviceFound = true;

            /* Set device as active in DB */
            ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
            if (ret) return ret;
            break;
        }
        case CTA_ACTIVATE_DEVICE:
        {
            ETG_TRACE_USR3(("Action: Activate device"));

            /* Set device as active in DB */
            ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
            if (ret) return ret;
            break;
        }
        case CTA_DEACTIVATE_DEVICE:
        {
            ETG_TRACE_USR3(("Action: Deactivate device"));

            /* Set device as deactive in DB */
            ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN false);
            if (ret) return ret;
            break;
        }
        case CTA_ACTIVATE_FIRST_AVAILABLE_DEVICE:
        {
            ETG_TRACE_USR3(("Action: Activate first available device of DB"));

            /* Get a list of all connected devices and take the first one */
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInfos;
            ret = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
            if (ret) return ret;

            /* Loop over all connected devices */
            for(tUInt i=0; i<deviceInfos.size(); i++)
            {
                /* Make device activation for first connected device */
                if (deviceInfos[i].connected)
                {
                    deviceID = deviceInfos[i].deviceID;

                    /* Set device as active in DB */
                    ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, IN true);
                    if (ret) return ret;
                    break;
                }
            }

            break;
        }
        default: // Do nothing
            deviceID = DEVICE_ID_NOT_SET;
            break;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::CheckListSelection(const tDeviceID deviceID) const
{
    ENTRY
    VARTRACE(deviceID)

    tResult ret = MP_NO_ERROR;
    tConfigTablePrecondition precondition = CTP_NONE;
    tConfigTableAction action = CTA_NONE;
    tConfigTable usedConfigTable = CT_LIST_SELECTION;

    tMediaContext mediaContext = MC_ALL;
    LocalSPM::GetDBManager().GetMediaContext( OUT mediaContext);

    /* Nothing to do */
    if(( (MC_VIDEO == mediaContext) && (FALSE == LocalSPM::GetDataProvider().CreateListForVideoSource())) || (DEVICE_ID_NOT_SET == deviceID))
    {
        ETG_TRACE_USR3(("Action: Nothing to do"));
        return MP_NO_ERROR;
    }

    /* Map device type to precondition */
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    switch(deviceInfo.deviceType)
    {
    case DTY_USB:
    case DTY_SD:
    case DTY_CDROM:
    case DTY_FLASH:
    case DTY_MUSICBOX:
        precondition = CTP_USB;
        break;
    case DTY_IPOD:
    case DTY_IPHONE:
        precondition = CTP_IPOD;
        break;
    case DTY_MTP:
        precondition = CTP_MTP;
        break;
    case DTY_BLUETOOTH:
        precondition = CTP_BT;
        break;
    case DTY_MYMEDIA:
        precondition = CTP_MYMEDIA;
        break;
    case DTY_CDDA:
    case DTY_DVD_DRIVE:
        precondition = CTP_CDDA;
        break;
    case DTY_CS:
        precondition = CTP_CS;
        break;
    case DTY_UNKNOWN:
    case DTY_MSZUNE:
    case DTY_UNSUPPORTED:
    default:
        break;
    }

    /* Calculate action from config table */
    ret = LocalSPM::GetDataProvider().ProcessConfigTable(OUT action, IN usedConfigTable, IN precondition, IN deviceID);
    if (ret) return ret;

    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    tIndex listIndex = 0;
    tPlaytime offset = 0;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tUInt fallbackCount = 0;

    while((action != CTA_NONE)
          &&
          (3 > fallbackCount)) //At most 2 fallback solutions in error case
    {
        switch(action)
        {
            case CTA_PLAY_FOLDER_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play list of first folder with content"));

                if(CTP_CDDA == precondition)
                {
                    tNumberOfMediaObjects numberOfMediaObjects;
                    tNumberOfPlayLists numberOfPlayLists;
                    tNumberOfFolders numberOfFolders;

                    tPath path;
                    strncpy_r(OUT path, IN "/", IN sizeof(path)); //Set path to root

                    if( DTY_DVD_DRIVE == deviceInfo.deviceType)
                    {
                        streaming = true;
                    }


                    /* Create a CDDA list which looks like a flat file list */
                    ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                            OUT listID,
                            OUT listSize,
                            OUT numberOfMediaObjects,
                            OUT numberOfPlayLists,
                            OUT numberOfFolders,
                            IN LTY_CD,
                            IN path,
                            IN deviceID,
                            IN streaming);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                //for musicbox the folder view list is disabled
                else if(DTY_MUSICBOX == deviceInfo.deviceType)
                {
                    /* fix for NCG3D-119348*/
                    ETG_TRACE_USR3(("Action: Create and play DB all songs list for MB since folder view is not possible"));

                    /* Create all songs list */
                    tag1.tag = 0;
                    tag2.tag = 0;
                    tag3.tag = 0;
                    tag4.tag = 0;

                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_SONG,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                else // in case of CTP_USB or CTP_MTP
                {
                    /* Get the repeat mode for that device */
                    tRepeatMode repeatMode;
                    ret = LocalSPM::GetDBManager().GetRepeatMode(OUT repeatMode, IN deviceID);
                    if (ret) repeatMode = RPT_LIST;

                    if((RPT_LIST_WITH_SUBLISTS == repeatMode)
                       ||
                       (RPT_ALL == repeatMode))
                    {
                        ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                                OUT listID,
                                IN "/" /*path*/,
                                IN deviceID,
                                IN true /*withSubFolders*/);
                        if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;

                        /* Is at least one object in the list (faster than get list size) */
                        tMediaObject mediaObject;
                        ret = LocalSPM::GetListControl().GetMediaObject(OUT mediaObject, IN listID, IN listIndex);
                        if ((ret == MP_NO_ERROR)
                            &&
                            (OBJECT_ID_NONE != mediaObject.objectID))
                        {
                            listSize = 1;
                        }
                    }
                    else
                    {
                        /* Fix(din3kor) : performance issue during default playback of devices with huge number of songs
                         *       -Avoid complete file listing including subfolder
                         *       -@todo -> support limiting the file list results while including subfolder and check for performance*/

                        /* Reads folder recursively to find the first level which has media objects and creates list for the same*/
                        ret = LocalSPM::GetListControl().CreatePlayableFilelist(
                                OUT listID,
                                OUT listSize,
                                OUT listIndex,
                                IN deviceID,
                                IN streaming);
                        if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                    }
                }
                break;
            }
            case CTA_PLAY_FOLDER_STREAMING_LIST:
            {
                streaming = true;

                if(CTP_IPOD == precondition)
                {
                    ETG_TRACE_USR3(("Action: Create and play iPod all songs list in streaming mode"));

                    /* Create all songs list */
                    tag1.tag = 0;
                    tag2.tag = 0;
                    tag3.tag = 0;
                    tag4.tag = 0;

                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_SONG,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                else
                {
                    ETG_TRACE_USR3(("Action: Create and play list of first folder with content in streaming mode"));

                    /* Fix(din3kor) : performance issue during default playback of devices with huge number of songs
                     *       -Avoid complete file listing including subfolder
                     *       -@todo -> support limiting the file list results while including subfolder and check for performance*/

                    /* Reads folder recursively to find the first level which has media objects and creates list for the same*/
                    ret = LocalSPM::GetListControl().CreatePlayableFilelist(
                            OUT listID,
                            OUT listSize,
                            OUT listIndex,
                            IN deviceID,
                            IN streaming);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                break;
            }
            case CTA_PLAY_DB_LAST_MODE_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play DB last mode list"));

                /* Get last mode list */
                //listIndex = INDEX_LAST_ACTIVE_OBJECT;
                ret = LocalSPM::GetListControl().GetLastPlayedList(OUT listID, OUT listIndex, OUT offset, IN deviceID);
                if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;

                /* Is at least one object in the list (faster than get list size) */
                tMediaObject mediaObject;
                ret = LocalSPM::GetListControl().GetMediaObject(OUT mediaObject, IN listID, IN listIndex);
                if ((ret == MP_NO_ERROR)
                    &&
                    (OBJECT_ID_NONE != mediaObject.objectID))
                {
                    listSize = 1;
                }
                break;
            }
            case CTA_PLAY_DB_ALL_SONGS_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play DB all songs list"));

                /* Create all songs list */
                tag1.tag = 0;
                tag2.tag = 0;
                tag3.tag = 0;
                tag4.tag = 0;

                ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                        OUT listID,
                        OUT listSize,
                        LTY_SONG,
                        IN streaming,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        IN deviceID);
                if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                break;
            }
            case CTA_PLAY_DB_ALL_VIDEOS_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play DB all video files list"));

                /* Create all video episodes list */
                tag1.tag = 0;
                tag2.tag = 0;
                tag3.tag = 0;
                tag4.tag = 0;

                ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                        OUT listID,
                        OUT listSize,
                        LTY_EPISODE_OF_VIDEO,
                        IN streaming,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        IN deviceID);
                if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
#if 0
                if (ret == MP_ERR_DB_END_OF_LIST) break;

                /* Get first video object */
                vector<tMediaObject> mediaObjectVector;
                ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
                if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                if (ret == MP_ERR_DB_END_OF_LIST) break;

                if( 0 < mediaObjectVector.size() )
                {
                    tag1.video = mediaObjectVector[0].MetadataTag1;
                }

                /* Release video list: not needed anymore */
                ret = LocalSPM::GetListControl().ReleaseList(IN listID);
                //if (ret) return ret;

                /* Create video episode list of first video */
                if( 0 < tag1.video )
                {
                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_VIDEO_EPISODE,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
#endif
                break;
            }
            case CTA_PLAY_CURRENT_SELECTION_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play current selection list"));

                if(CTP_IPOD == precondition)
                {
                    /* Create play list for iPod */
                    tag1.tag = IPOD_MARKER_BIT;
                    tag2.tag = IPOD_MARKER_BIT;
                    tag3.tag = IPOD_MARKER_BIT;
                    tag4.tag = IPOD_MARKER_BIT;

                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_CURRENT_SELECTION,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;

                    /* Resume iPod current playing track */
                    listIndex = INDEX_LAST_ACTIVE_OBJECT;
                    offset = PLAYTIME_NONE; //This means play from last position and not from beginning

                    if((1 > listSize)
                       &&
                       (LocalSPM::GetIPODControl().IsIAP2(deviceInfo.mountPoint)))
                    {
                        listSize = 1; //iPod special: force 1 to pass check below (GMMY16-19553, GMMY16-22348)
                    }
                }
                else if(CTP_BT == precondition)
                {
                    tNumberOfMediaObjects numberOfMediaObjects;
                    tNumberOfPlayLists numberOfPlayLists;
                    tNumberOfFolders numberOfFolders;

                    /* create a normal file list for BT device*/
                    ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                            OUT listID,
                            OUT listSize,
                            OUT numberOfMediaObjects,
                            OUT numberOfPlayLists,
                            OUT numberOfFolders,
                            IN LTY_BLUETOOTH_FILELIST,
                            IN "dummy-now-playing",
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                else
                {
                    ETG_TRACE_ERR(("CheckListSelection: Wrong CTP device type: %u", precondition));
                }
                break;
            }
            case CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST:
            {
                ETG_TRACE_USR3(("Action: Create and play current selection list in streaming mode"));
                streaming = true;

                if(CTP_IPOD == precondition)
                {
                    /* Create play list for iPod */
                    tag1.tag = IPOD_MARKER_BIT;
                    tag2.tag = IPOD_MARKER_BIT;
                    tag3.tag = IPOD_MARKER_BIT;
                    tag4.tag = IPOD_MARKER_BIT;

                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_CURRENT_SELECTION,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;

                    /* Resume iPod current playing track */
                    listIndex = INDEX_LAST_ACTIVE_OBJECT;
                    offset = PLAYTIME_NONE; //This means play from last position and not from beginning
                    listSize = 1; //iPod special: force 1 to pass check below
                }
                else if(CTP_BT == precondition)
                {
                    tNumberOfMediaObjects numberOfMediaObjects;
                    tNumberOfPlayLists numberOfPlayLists;
                    tNumberOfFolders numberOfFolders;

                    /* create a normal file list for BT device*/
                    ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                            OUT listID,
                            OUT listSize,
                            OUT numberOfMediaObjects,
                            OUT numberOfPlayLists,
                            OUT numberOfFolders,
                            IN LTY_BLUETOOTH_FILELIST,
                            IN "dummy-now-playing",
                            IN deviceID,
                            IN streaming);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;
                }
                else if(CTP_CS == precondition)
                {
                    /* Create dummy list for Content Sharing including only the current object */
                    tag1.tag = 0;
                    tag2.tag = 0;
                    tag3.tag = 0;
                    tag4.tag = 0;

                    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                            OUT listID,
                            OUT listSize,
                            LTY_SONG,
                            IN streaming,
                            IN tag1,
                            IN tag2,
                            IN tag3,
                            IN tag4,
                            IN deviceID);
                    if (ret && ret != MP_ERR_DB_END_OF_LIST) return ret;

                    /* Resume CS current playing track */
                    //listIndex = INDEX_LAST_ACTIVE_OBJECT;
                    offset = PLAYTIME_NONE; //This means play from last position and not from beginning
                    listSize = 1; //CS special: force 1 to pass check below
                }
                else
                {
                    ETG_TRACE_ERR(("CheckListSelection: Wrong CTP device type: %u", precondition));
                }
                break;
            }
            default: // Do nothing
                break;
        }

        if((LIST_ID_NONE == listID )
           ||
           (1 > listSize))
        {
            /* Get fallback solution */
            tConfigTableAction fallbackAction = CTA_NONE;
            ret = LocalSPM::GetDataProvider().GetFallbackAction(OUT fallbackAction, IN action);
            if (ret) return ret;

            action = fallbackAction;
            fallbackCount++;
            listID = LIST_ID_NONE;
            listSize = 0;
            listIndex = 0;
            offset = 0;

            /* Last mode list not playable -> reset playmodes (NCG3D-5271) */
            if(CTA_PLAY_DB_LAST_MODE_LIST == action)
            {
                if(LocalSPM::GetDataProvider().SeparateMediaContent())
                {
                    ret = LocalSPM::GetDBManager().ResetAllPlaybackModes(IN deviceID);/*reset both video and audio repeat modes */
                    if (ret) return ret;
                    ret = LocalSPM::GetDBManager().ResetAllRepeatModes(IN deviceID);/* reset both audio and video shuffle modes */
                    if (ret) return ret;
                }
                else
                {
                    ret = LocalSPM::GetDBManager().SetPlaybackMode(IN deviceID, IN PBM_NORMAL);/*reset only audio shuffle mode*/
                    if (ret) return ret;
                    ret = LocalSPM::GetDBManager().SetRepeatMode(IN deviceID, IN (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode());/*reset only audio repeatmode*/
                    if (ret) return ret;
                }
            }
        }
        else
        {
            break; //Everything is ok
        }
    }

    if((LIST_ID_NONE != listID)
       &&
       (0 < listSize))
    {
        /* Play created list */
        ret = LocalSPM::GetPlayerManager().SendNewList(IN listID, IN listIndex, IN offset);
        if (ret) return ret;
    }
    else
    {
        ETG_TRACE_ERR(("CheckListSelection: Created list (listID: %u, size: %u) cannot be played", listID, listSize));

        /* Stop playback of old list and go to state noObject */
        ret = LocalSPM::GetPlayerManager().SendNoObject(NOR_LIST_IS_NOT_PLAYABLE);
        if (ret) return ret;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::StartStartupTimer(void)
{
    ENTRY_INTERNAL

    /* Set the timeout value */
    long timeoutValue = LocalSPM::GetDataProvider().StartupTimeMS();

    /* Start the timer */
    /*
     * since this method can be called by the init procedure the this pointer is not pointing to CustomControl. For that
     * reason here the LocalSPM::GetCustomControl() has to be used instead of this.
     */
    mTimer.StartTimer(OUT mTimerID, IN timeoutValue, 0L, &LocalSPM::GetCustomControl(), &TimerCallBack, (const char *)"CustomControlTimer");

    mDeviceFound = false;

    return MP_NO_ERROR;
}

tResult CustomControl::StopStartupTimer(void)
{
    ENTRY_INTERNAL

    /* Cancel the timer */
    if (mTimerID)
    {
        mTimer.CancelTimer(IN mTimerID);
        mTimerID = 0;
    }

    return MP_NO_ERROR;
}

tResult CustomControl::DiagnosisPlaySong(tDeviceType deviceType, tFilename filename)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Get all connected devices */
    tNumberOfDevices numberOfDevices;
    vector<tDeviceInfo> deviceInfos;
    ret = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    if (ret) return ret;

    /* Search for the device type */
    int i;
    for(i=0; i<(int)deviceInfos.size(); i++)
    {
        if (deviceType == deviceInfos[i].deviceType) break;
    }
    if (i == (int)deviceInfos.size()) return MP_ERR_CC_DEVICE_NOT_CONNECTED;

    // split full name into path and purefilename
    unsigned char *temp;
    tURL path;
    tURL purefilename;

    strncpy_r(OUT path, IN filename, IN sizeof(path));
    FastUTF8::Split(OUT temp, INOUT (unsigned char *)path);
    if (NULL == temp) // no path
    {
        strncpy_r(OUT purefilename, IN filename, IN sizeof(purefilename));
        path[0] = '\0';
    }
    else
    {
        strncpy_r(OUT purefilename, IN (char*)temp, IN sizeof(purefilename));
    }

    strncat_r(OUT path, "/", IN sizeof(path));

    VARTRACE(purefilename)
    VARTRACE(path)

    /* Create a file list of all files in the root from that device */
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            deviceInfos[i].deviceID);
    if (ret) return ret;
    if (listSize == 0) return MP_ERR_CC_UNABLE_TO_CREATE_LIST;
    if (numberOfMediaObjects == 0) return MP_ERR_CC_UNABLE_TO_CREATE_LIST;

    /* Search the given song */
    /* Get the list slice */
    vector<tFiles> mediaFileVector;
    ret = LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    if (ret) return ret;
    if (mediaFileVector.size() == 0) return MP_ERR_CC_UNABLE_TO_CREATE_LIST;

    int j;
    for(j=0; j<(int)mediaFileVector.size(); j++)
    {
        /* Check the file name */
        if (!strcmp((char*)purefilename, mediaFileVector[j].fileName)) break;
    }
    if (j == (int)mediaFileVector.size()) return MP_ERR_CC_UNABLE_TO_CREATE_LIST;

    /* Set active device */
    //ret = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceInfos[i].deviceID, IN true); Done in PLayItemFromList now
    //if (ret) return ret;

    /* File found, now try to play it */
    ret = PlayItemFromList(OUT listSize, IN listID, IN j, 0);
    if (ret) return ret;

    /* Set the repeat mode to song / one */
    ret = LocalSPM::GetListControl().SetRepeatMode(IN deviceInfos[i].deviceID, RPT_ONE);
    if (ret) return ret;

    //TODO: Call audio manager to set media player as source needed?

    return MP_NO_ERROR;
}

tResult CustomControl::RecreateDatabase(const tLanguageType language) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /*switch off all DB triggers before DB recreation*/
    LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    LocalSPM::GetAlbumArtIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    LocalSPM::GetPlayerManager().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    LocalSPM::GetCustomControl().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);

    /*Recreate the database which will be empty afresh without any device*/
    ret = LocalSPM::GetListControl().RecreateDatabase(IN language);
    if(ret) return ret;

    /*switch on all DB triggers after DB recreation*/
    LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    LocalSPM::GetAlbumArtIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    LocalSPM::GetPlayerManager().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    LocalSPM::GetCustomControl().SwitchDBTrigger(IN TT_ALL, IN TS_ON);

    return MP_NO_ERROR;

}

tResult CustomControl::SetLanguage(const tLanguageType language) const
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    tLanguageType activeLanguage;
    LocalSPM::GetDBManager().GetLanguage(OUT activeLanguage);
    if (language == activeLanguage)
    {
        return MP_NO_ERROR;
    }

    if(LocalSPM::GetDataProvider().DBSortUseUCAOn() == 0)
    {
        /*no dynamic change*/
        ret = LocalSPM::GetDataProvider().SetLanguage(IN language);
    }
    /*dynamic change to adapt new language for all list sorts*/
    else
    {
        tDeviceInfo deviceInfo;
        InitDeviceInfo(OUT deviceInfo);

        /*get the currently playing object*/
        tMediaObject mediaObject;
        ret = LocalSPM::GetPlayerManager().GetMediaObject(OUT mediaObject);

        /*save the active device which is playing */
        if(!ret)
        {
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo , IN mediaObject.deviceID);
        /*reset the deviceinfo as device will simulated as reconnected so that its is reindexed as per new lanagueg*/
        deviceInfo.connectionState = CS_ATTACHED;
        deviceInfo.indexedState = IDS_NOT_STARTED;
        }

        /*recreate the database*/
        ret = RecreateDatabase(language);
        if(ret) return ret;

        /*add previously active device to DB*/
        if(deviceInfo.deviceID != DEVICE_ID_NOT_SET)
        {
            ret = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        if(ret) return ret;

        /*create a playlist from last played device and iniate playback via Playermanager*/
        if((deviceInfo.deviceType == DTY_IPOD) || (deviceInfo.deviceType == DTY_IPHONE))
        {
            //tListID newListID;
            //ret = LocalSPM::GetListControl().CreatePlaylist(OUT newListID,LTY_STREAMING);
            //ret = LocalSPM::GetPlayerManager().SendNewList(IN newListID, 0 , 0);
        }
        else
        {
            tListID newListID;
            tListID listSize;
            tNumberOfMediaObjects numberOfMediaObjects;
            tNumberOfPlayLists numberOfPlayLists;
            tNumberOfFolders numberOfFolders;
            tPosition position;
            tFileTypeSelection fileTypeSelection = LocalSPM::GetDBManager().GetFTSByActiveMediaContext();

            /*create a filelist with previously playing track as the active folder*/
            ret = LocalSPM::GetListControl().CreateMediaPlayerFileList(
                    OUT newListID,
                    OUT listSize,
                    OUT numberOfMediaObjects,
                    OUT numberOfPlayLists,
                    OUT numberOfFolders,
                    OUT position,
                    IN mediaObject.fileName,
                    IN deviceInfo.deviceID,
                    IN false, //streaming
                    IN fileTypeSelection);
            if(ret) return ret;

            /*@todo : Remove this explicit once design is revisited to playback newlist
             * Currently sleep is required to avoid the default playback list overriding the required last playback */
            sleep(2);

            /*initiate the playlist of the newly created file list*/
            ret = LocalSPM::GetPlayerManager().SendNewList(IN newListID, position+1 , 0);
            if(ret) return ret;
        }

        ret = LocalSPM::GetOutputWrapper().RequestConnectedDevices();
        if(ret) return ret;
        }
    }
    return ret;
}

tResult CustomControl::CheckSourceSwitchFromBTStreaming(tDeviceInfo &appleDeviceInfo)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceID btDeviceID;

    //Get the device id of BT device, if it is same as the device connected over USB
    ret = LocalSPM::GetDBManager().GetDevice(OUT btDeviceID, IN DTY_BLUETOOTH, IN appleDeviceInfo.deviceName, IN false, IN CS_CONNECTED);
    if((MP_NO_ERROR == ret) && (DEVICE_ID_NOT_SET!= btDeviceID))
    {
        /*disable the same device connected over BT as ON_HOLD. Also update the disconnect reason as DR_CONNECTED_OVER_USB*/
        ret = LocalSPM::GetDBManager().SetConnectionState(IN btDeviceID, CS_ON_HOLD, DR_CONNECTED_OVER_USB);
    }

    return ret;

//Disabled auto source activation as it is not supported, this code will be removed after few releases
#if 0
    tDeviceInfo activeDeviceInfo;

    /*Check if same device is connected over bluetooth*/
    ret = ActiveMediaDeviceGet(OUT activeDeviceInfo);

    /*case 1:DTY_IPHONE/IPOD Connected is already active as DTY_BLUETOOTH in MediaPlayer*/
    if(activeDeviceInfo.deviceID != DEVICE_ID_NOT_SET &&
       DTY_BLUETOOTH == activeDeviceInfo.deviceType &&
       !strncmp(appleDeviceInfo.deviceName,activeDeviceInfo.deviceName,sizeof(appleDeviceInfo.deviceName)))
    {
        if(CS_DISCONNECTED != activeDeviceInfo.connectionState)
        {
            /*disable the same device connected over bt as ON_HOLD. Also update the disconnect reason as DR_CONNECTED_OVER_USB*/
            ret = LocalSPM::GetDBManager().SetConnectionState(IN activeDeviceInfo.deviceID, CS_ON_HOLD, DR_CONNECTED_OVER_USB);
        }

        /*Get status of player manager*/
        tBoolean isActive;
        ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
        if (ret)return ret;

        /*Case 1:MediaPlayer is the currently streaming the apple device via bluetooth.
        Hence source switch to its connection as DTY_IPHONE in streaming mode */
        if(isActive)
        {
            ret = SetActiveStreamingDevice(IN appleDeviceInfo.deviceID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while setting active streaming device at CustomControl (ErrorCode:%s)", errorString(ret)));
                return ret;
            }
        }
        else
        {
            /*Mediaplayer is not Active.Hence Returning without activating its connection as DTY_IPHONE */
            return MP_ERR_DP_NO_DEVICE_FOUND;
        }
    }
    else
    {
        /*case 2:DTY_IPHONE/IPOD Connected is connected as DTY_BLUETOOTH but Not Active in MediaPlayer or No Device is active in Mediaplayer */
        ret = LocalSPM::GetDBManager().GetDevice(OUT btDeviceID, IN DTY_BLUETOOTH, IN appleDeviceInfo.deviceName, IN false, IN CS_CONNECTED);
        if(DEVICE_ID_NOT_SET!= btDeviceID)
        {
            /*disable the same device connected over bt as ON_HOLD. Also update the disconnect reason as DR_CONNECTED_OVER_USB*/
            ret = LocalSPM::GetDBManager().SetConnectionState(IN btDeviceID, CS_ON_HOLD, DR_CONNECTED_OVER_USB);
            return MP_ERR_DP_NO_DEVICE_FOUND;
        }
        else
        {
            /*case 3 : same device is streamed via BT-Settings (e.g for AVRCP < 1.4)*/
            tSource source;
            ret = LocalSPM::GetOutputWrapper().GetCurrentSource(OUT source);
            if (ret)return ret;

            /*active streaming via bt-settings */
            if(BT_SETTINGS_FBLOCKID == source)
            {
                /*Get the same device connected over bluetooth which supports AVRCP < 1.4
                 *It will be in connected state = CS_ATTACHED*/
                ret = LocalSPM::GetDBManager().GetDevice(OUT btDeviceID, IN DTY_BLUETOOTH, IN appleDeviceInfo.deviceName, IN false, IN CS_ATTACHED);
                if (ret)return ret;

                /*activate the device in streaming mode to resume the playback over iap*/
                ret = SetActiveStreamingDevice(IN appleDeviceInfo.deviceID);
                if(MP_NO_ERROR != ret)
                {
                    /*Normal handling of  DTY_IPHONE/IPOD Connection must happen if SetActiveStreamingDevice fails*/
                    ETG_TRACE_ERR(("Error while setting active streaming device at CustomControl (ErrorCode:%s)", errorString(ret)));
                    return ret;
                }

                /*If AVActivation request fails,then Apple device connected as DTY_IPHONE/IPOD be set as Active device internally in MediaPlayer*/
                ret = LocalSPM::GetOutputWrapper().RequestAVActivation(1,LC_MAIN_AUDIO);
                if (ret)return ret;
            }
            else
            {
                /*No apple device actively streaming over bluetooth found*/
                return MP_ERR_DP_NO_DEVICE_FOUND;
            }
        }
    }
#endif
}

tResult CustomControl::HandleAppleDeviceRemoved(tDeviceInfo &appleDeviceInfo)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tConnectionState connectionState = CS_ATTACHED;
    VARTRACE(appleDeviceInfo.connectionState);
    VARTRACE(appleDeviceInfo.disconnectReason);
    if(DR_HW_MALFUNC == appleDeviceInfo.disconnectReason){
        ret = LocalSPM::GetDBManager().SetConnectionState(appleDeviceInfo.deviceID, appleDeviceInfo.connectionState, appleDeviceInfo.disconnectReason);
    }

    /*look for any DTY_BLUETOOTH device with the same name as removed apple device and is CS_ON_HOLD*/
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_BLUETOOTH, IN appleDeviceInfo.deviceName, IN false, IN CS_ON_HOLD);
    if (ret)
    {
        /*no BT connection in state CS_ON_HOLD*/
        tConnectionType connectionType = DCT_UNKNOWN;

        if(DCT_USB == appleDeviceInfo.connectionType)
        {
            connectionType = DCT_BLUETOOTH;
        }
        else if(DCT_BLUETOOTH == appleDeviceInfo.connectionType)
        {
            connectionType = DCT_USB;
        }

        /*look for any DTY_IPHONE device with the same name as removed apple device and is CS_ON_HOLD*/
        ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPHONE, IN appleDeviceInfo.deviceName, IN false, IN CS_ON_HOLD, IN connectionType);
        if (ret) {
            /*look for any DTY_IPOD device with the same name as removed apple device and is CS_ON_HOLD*/
            ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPOD, IN appleDeviceInfo.deviceName, IN false, IN CS_ON_HOLD, IN connectionType);
        }
    }

    if(!ret && deviceID != DEVICE_ID_NOT_SET) {
        /*make it as available again*/
        ret = LocalSPM::GetDBManager().SetConnectionState(IN deviceID, connectionState);
    }
    return MP_NO_ERROR;
}

tResult CustomControl::OnFocusAppChanged(const tDeviceID deviceID, const tAppName appName)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(appName);

    if (LocalSPM::GetOutputWrapper().OnFocusAppChanges(deviceID, appName) != MP_NO_ERROR) {
        ETG_TRACE_ERR(("OnFocusAppChanges failed"));
    }
    return MP_NO_ERROR;
}

tResult CustomControl::CheckLists(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);

    if(MP_NO_ERROR != LocalSPM::GetListControl().CheckLists(IN deviceID)) {
        ETG_TRACE_ERR(("Error while calling CheckLists at ListControl"));
    }

    return MP_NO_ERROR;
}

tResult CustomControl::StartCheckListTimer(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    long timerMS = LocalSPM::GetDataProvider().CheckListTimerMS();

    /* create check list timer */
    mCheckListTimer.StartTimer(OUT mCheckListTimerID, IN timerMS, IN timerMS, IN this, IN &CheckListTimerCallBack, IN (void *)(unsigned long)deviceID); // thoemel: the additional (unsigned long) cast is for the 64 bit compiler

    return MP_NO_ERROR;
}

tResult CustomControl::StopCheckListTimer(void)
{
    ENTRY;

    /* delete check list timer */
    if(mCheckListTimerID) {
        mCheckListTimer.CancelTimer(IN mCheckListTimerID);
        mCheckListTimerID = 0;
    }

    return MP_NO_ERROR;
}

bool CustomControl::CheckListTimerCallBack(timer_t timerID , void* instance, const void *userData)
{
    ENTRY;
    (void)timerID;
    CustomControl *self = (CustomControl *)instance;
    if(self) {
        const tDeviceID deviceID = (tDeviceID)(unsigned long)userData; // thoemel: additional cast for 64bit compiler
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        self->ParameterCHECK_LISTS(OUT parameterString, IN size, IN deviceID);
        self->SendEvent(self->CHECK_LISTS, IN parameterString);
    }
    return MP_NO_ERROR;
}
//>--Roadmap 16003 : 'CD Ripping With Gracenote'
tResult CustomControl::DeleteMediaContent(const tDeleteMediaByTagsParam& deleteMediaByTagsParam, const tU8 syncMode)
{

    ENTRY


    tDeleteMediaByTagsParam *pdeleteMediaByTagsParam = new tDeleteMediaByTagsParam[sizeof(tDeleteMediaByTagsParam)];      // will be deleted by the thread function
    if(pdeleteMediaByTagsParam)
    {
        pdeleteMediaByTagsParam->listType =  deleteMediaByTagsParam.listType;
        pdeleteMediaByTagsParam->tag1     =  deleteMediaByTagsParam.tag1;
        pdeleteMediaByTagsParam->tag2     =  deleteMediaByTagsParam.tag2;
        pdeleteMediaByTagsParam->tag3     =  deleteMediaByTagsParam.tag3;
        pdeleteMediaByTagsParam->tag4     =  deleteMediaByTagsParam.tag4;
        pdeleteMediaByTagsParam->deviceID =  deleteMediaByTagsParam.deviceID;
        /*Create a worker thread to delete media content */
        if(syncMode)
        {
            DoDeleteMediaContentThread(FUNCTION_ID_DELETEMEDIACONTENT_TAGS, (void*)pdeleteMediaByTagsParam);
        }
        else
        {
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_DELETEMEDIACONTENT_TAGS, (void*)pdeleteMediaByTagsParam, this); //lint -e429 freed by calling thread
        }

    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}



tResult CustomControl::DeleteMediaContent(IN const tDeleteMediaByObjectIDParam &deleteMediaByObjectIDParam)
{

    tDeleteMediaByObjectIDParam *pdeleteMediaByObjectIDParam = new  tDeleteMediaByObjectIDParam[sizeof(tDeleteMediaByObjectIDParam)];
    if(pdeleteMediaByObjectIDParam)
    {
        pdeleteMediaByObjectIDParam->objectIDs = deleteMediaByObjectIDParam.objectIDs;
        pdeleteMediaByObjectIDParam->deviceID  = deleteMediaByObjectIDParam.deviceID;
        /*Create a worker thread to deletemediacontent */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_DELETEMEDIACONTENT_OBJECTIDS, (void*)pdeleteMediaByObjectIDParam, this); //lint -e429 freed by calling thread
    }
    return MP_NO_ERROR;

}




tResult CustomControl::DeleteMediaContent(IN const tDeleteMediaByUrlParam &deleteMediaByUrlParam)
{
    tDeleteMediaByUrlParam *pdeleteMediaByUrlParam = new  tDeleteMediaByUrlParam[sizeof(tDeleteMediaByUrlParam)];
    if(pdeleteMediaByUrlParam)
    {
        pdeleteMediaByUrlParam->objectUrl = deleteMediaByUrlParam.objectUrl;
        pdeleteMediaByUrlParam->deviceID = deleteMediaByUrlParam.deviceID;
        /*Create a worker thread to deletemediacontent */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_DELETEMEDIACONTENT_URLS, (void*)pdeleteMediaByUrlParam, this); //lint -e429 freed by calling thread}
    }
    return MP_NO_ERROR;
}


tFileOperationErrorCodes CustomControl::deleteMediaContentByTags(tDeleteMediaByTagsParam &pdeleteMediaByTagsParam,tU16 &numberofFilesDeleted)
{
    ENTRY
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFileOperationErrorCodes fileOperationErrorCodes = FILE_OPERATION_OK;
    tIndex startIndex = 0;
    tDeviceID deviceID;
    tResult ret;
    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(OUT listID, OUT listSize, IN pdeleteMediaByTagsParam.listType, IN streaming, IN pdeleteMediaByTagsParam.tag1, IN pdeleteMediaByTagsParam.tag2, IN pdeleteMediaByTagsParam.tag3, IN pdeleteMediaByTagsParam.tag4, IN pdeleteMediaByTagsParam.deviceID);
    if(MP_NO_ERROR == ret)
    {
        vector<tMediaObject> mediaObjectVector;
        ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN startIndex, IN listSize);
        if(MP_NO_ERROR == ret )
        {
            vector<tMediaObject>::iterator objit;
            tDeviceInfo deviceInfo;
            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN pdeleteMediaByTagsParam.deviceID);
            if(!ret)
            {
                setSRMount(deviceInfo, false);
                for(objit = mediaObjectVector.begin();objit<mediaObjectVector.end();objit++)
                {
                    ETG_TRACE_USR3(("deleteMediaContentByTags filename : %s",objit->fileName));
                    ret = LocalSPM::GetListControl().DeleteMediaContent(deviceInfo,objit->fileName,getSystemCondition());
                    if(ret)
                        break;
                    numberofFilesDeleted++;
                }
                deviceID = pdeleteMediaByTagsParam.deviceID;
                setSRMount(deviceInfo, true);
            }
            else
            {
                ret = MP_ERR_DEVICE_NOT_EXIST;
            }

        }
        else
        {
            fileOperationErrorCodes = LISTTYPE_NOT_FOUND;
        }
        LocalSPM::GetListControl().ReleaseList(IN listID);
    }
    else
    {

        fileOperationErrorCodes = LISTTYPE_NOT_FOUND;
    }

    return fileOperationErrorCodes;

}
tResult CustomControl::DoDeleteMediaContentThread(const int functionID, const void *ptr)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeleteMediaByTagsParam *pdeleteMediaByTagsParam = NULL;
    tDeleteMediaByObjectIDParam *pdeleteMediaByObjectIDParam = NULL;
    tDeleteMediaByUrlParam *pdeleteMediaByUrlParam = NULL;
    tFileOperationErrorCodes fileOperationErrorCodes = FILE_OPERATION_OK;
    TimeTrace ticks(__PRETTY_FUNCTION__);
    tU16 numofFilesDeleted = 0;
    tDeleteMediaContentType deleteMediaContentType = DELETEMEDIACONTENTBYFILERTAGS;
    tDeviceID ldeviceID = MY_MEDIA;
    tDeviceInfo deviceInfo;
    tU16 numberofMediaObjects = 0;

    switch(functionID)
    {
        case FUNCTION_ID_DELETEMEDIACONTENT_TAGS:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_DeleteMediaContentByTags");
            pdeleteMediaByTagsParam = (tDeleteMediaByTagsParam*)ptr;
            break;
        }
        //can be used delete multiple media objects or albums
        //first check whether the requested mediaobject item is there in the database and delete them,
        //else user might tried to delete album object ids
        case FUNCTION_ID_DELETEMEDIACONTENT_OBJECTIDS:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_DeleteMediaContentByObjectIDs");
            pdeleteMediaByObjectIDParam = (tDeleteMediaByObjectIDParam*) ptr;
            deleteMediaContentType = DELETEMEDIACONTENTBYMEDIAOBJECTTAGS;
            break;
        }
        case FUNCTION_ID_DELETEMEDIACONTENT_URLS:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_DeleteMediaContentByURLs");
            pdeleteMediaByUrlParam = (tDeleteMediaByUrlParam*)ptr;
            deleteMediaContentType = DELETEMEDIACONTENTBYURLS;
            break;
        }
        default:
            ETG_TRACE_USR3(("DoDeleteMediaContentThread : Invalid function Id %d",functionID));
            break;

    }
    //can be use used to delete all albums, individual list types providing filter tags
    if(pdeleteMediaByTagsParam)
    {
        //Stop Playback incase the deletion is for All albums , All songs
        if((LTY_ALBUM == pdeleteMediaByTagsParam->listType)||(LTY_SONG == pdeleteMediaByTagsParam->listType))
        {
            ETG_TRACE_USR4(("DeleteMediaContent Stop Playback incase the deletion is for All albums / All songs Listtype : %d" , pdeleteMediaByTagsParam->listType));
            ret = LocalSPM::GetPlayerManager().SendPlaybackAction(PBA_STOP);
            int sleepCount = 25;/*Maximum waiting time = 2.5 seconds*/
            do
            {
                usleep(100000);//sleep 100ms
                tHMIPlaybackState hmiPlaybackState;
                ret = LocalSPM::GetPlayerManager().GetPlaybackState(hmiPlaybackState);
                VARTRACE(hmiPlaybackState);
                /*If the next track started playing or if end of the list is reached or if playback gets stopped/paused, then we are ready for deleting the current playing track*/
                if( HMI_PBS_PAUSED == hmiPlaybackState || HMI_PBS_STOPPED == hmiPlaybackState)
                {
                    break;
                }
            }while(--sleepCount);

        }
        tListID listID;
        tListSize listSize;
        tStreaming streaming = false;
        tIndex startIndex = 0;
        //Request to delete all the albums
        if(LTY_ALBUM == pdeleteMediaByTagsParam->listType)
        {
            ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(OUT listID, OUT listSize, IN pdeleteMediaByTagsParam->listType, IN streaming, IN pdeleteMediaByTagsParam->tag1, IN pdeleteMediaByTagsParam->tag2, IN pdeleteMediaByTagsParam->tag3, IN pdeleteMediaByTagsParam->tag4, IN pdeleteMediaByTagsParam->deviceID);
            if(MP_NO_ERROR == ret)
            {
                vector<tMediaObject> mediaObjectVector;
                ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN startIndex, IN listSize);
                if(MP_NO_ERROR == ret )
                {
                    vector<tMediaObject>::iterator objit;

                    for(objit = mediaObjectVector.begin();objit<mediaObjectVector.end();objit++)
                    {
                        ETG_TRACE_USR3(("deleteMediaContentByTags album tags : %d",objit->objectID));
                        tDeleteMediaByTagsParam  deleteMediaByTagsParam;
                        memset(&deleteMediaByTagsParam,0,sizeof(tDeleteMediaByTagsParam));
                        deleteMediaByTagsParam.deviceID = pdeleteMediaByTagsParam->deviceID;
                        deleteMediaByTagsParam.listType = LTY_ALBUM_SONG;
                        deleteMediaByTagsParam.tag4.tag = objit->objectID;//album tag is filled here
                        fileOperationErrorCodes = deleteMediaContentByTags(deleteMediaByTagsParam,numberofMediaObjects);
                        //CID 183931: Logically dead code
                        if(FILE_OPERATION_OK == fileOperationErrorCodes)
                        {
                            ETG_TRACE_USR3(("DoDeleteMediaContentThread  delete album tag %d Successful, deleted %d items",objit->objectID,numberofMediaObjects));
                            numofFilesDeleted +=numberofMediaObjects;
                        }
                        else
                        {
                            ETG_TRACE_USR3(("DoDeleteMediaContentThread error occurred while trying delete album tag %d",objit->objectID));
                            continue;
                        }

                    }

                }
                else
                {
                    fileOperationErrorCodes = LISTTYPE_NOT_FOUND;
                }
                LocalSPM::GetListControl().ReleaseList(IN listID);
            }
            else
            {

                fileOperationErrorCodes = LISTTYPE_NOT_FOUND;
            }
        }//if(LTY_ALBUM == pdeleteMediaByTagsParam->listType)
        else
        {
            fileOperationErrorCodes = deleteMediaContentByTags(*pdeleteMediaByTagsParam,numofFilesDeleted);
        }
        ticks.elapsed();
        delete[] pdeleteMediaByTagsParam;
    }
    //can be used to delete individual media objects/ albums by giving their object ids
    else if(pdeleteMediaByObjectIDParam)
    {

        vector<tObjectID>::iterator objit;
        vector<tObjectID> objectIDs = pdeleteMediaByObjectIDParam->objectIDs;

        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN pdeleteMediaByObjectIDParam->deviceID);
        if(!ret)    {
            setSRMount(deviceInfo, false);
        for(objit = objectIDs.begin();objit<objectIDs.end();objit++)
        {
            tURL url;

            ret = LocalSPM::GetDBManager().GetURLOfMediaObject(url,*objit,pdeleteMediaByObjectIDParam->deviceID);

            if(ret)
            {
                fileOperationErrorCodes = DATABASE_ERROR;

            }
            else
            {
                    numberofMediaObjects++;
                ETG_TRACE_USR3(("DoDeleteMediaContentThread filename : %s",url));
                ret = LocalSPM::GetListControl().DeleteMediaContent(deviceInfo,url,getSystemCondition());
                if(ret)
                    break;
                numofFilesDeleted++;
            }
        }
        ldeviceID = pdeleteMediaByObjectIDParam->deviceID;
            setSRMount(deviceInfo, true);
            //GetURLOfMediaObject returned nothing means, user is trying to delete multiple albums by providing the album object ids
            if(!numberofMediaObjects)
            {
                tFileOperationErrorCodes errorcodes;
                ETG_TRACE_USR3(("DoDeleteMediaContentThread trying to delete albums"));
                for(objit = objectIDs.begin();objit<objectIDs.end();objit++)
                {
                    ETG_TRACE_USR3(("DoDeleteMediaContentThread trying to delete albums tag %d",*objit));
                    //Filling the details of the album
                    tDeleteMediaByTagsParam  deleteMediaByTagsParam;
                    memset(&deleteMediaByTagsParam,0,sizeof(tDeleteMediaByTagsParam));
                    deleteMediaByTagsParam.deviceID = pdeleteMediaByObjectIDParam->deviceID;
                    deleteMediaByTagsParam.listType = LTY_ALBUM_SONG;
                    deleteMediaByTagsParam.tag4.tag = *objit;//album tag is filled here
                    errorcodes = deleteMediaContentByTags(deleteMediaByTagsParam,numberofMediaObjects);
                    if(FILE_OPERATION_OK != errorcodes || FILE_OPERATION_ERROR != errorcodes )
                    {
                        ETG_TRACE_USR3(("DoDeleteMediaContentThread error occurred while trying delete album tag %d",*objit));
                        continue;
                    }
                    else
                    {
                        ETG_TRACE_USR3(("DoDeleteMediaContentThread  delete album tag %d Successful, deleted %d items",*objit,numberofMediaObjects));
                        numofFilesDeleted +=numberofMediaObjects;
                    }
                }
            }
        }
        else {
            ret = MP_ERR_DEVICE_NOT_EXIST;
        }

        ticks.elapsed();
        delete [] pdeleteMediaByObjectIDParam;
    }
    else if(pdeleteMediaByUrlParam)
    {
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN pdeleteMediaByUrlParam->deviceID);
        if(!ret)    {
            setSRMount(deviceInfo, false);
        for(vector<std::string>::iterator it = pdeleteMediaByUrlParam->objectUrl.begin(); it!=pdeleteMediaByUrlParam->objectUrl.end();it++)
        {
            if(isDirectory(*it,deviceInfo))
            {
                ret = LocalSPM::GetListControl().DeleteMediaContent(deviceInfo,*it,getSystemCondition());
                if(ret)
                    break;
                numofFilesDeleted++;
            }
            else
            {
                tU16 count = 0;
                ret = DeleteMediaContentFromDirectory(pdeleteMediaByUrlParam->deviceID, *it, count);
                numofFilesDeleted = numofFilesDeleted + count;
            }
        }
        ldeviceID = pdeleteMediaByUrlParam->deviceID;
            setSRMount(deviceInfo, true);
        }
        else{
            ret = MP_ERR_DEVICE_NOT_EXIST;
        }

        ticks.elapsed();
        delete [] pdeleteMediaByUrlParam;
    }
    if(!ret)
    {
        ETG_TRACE_USR1(("DeleteMediaContent No of files deleted %d : ",numofFilesDeleted));
        /* Check all lists against changes */
        LocalSPM::GetListControl().CheckLists(IN ldeviceID);
        if(IsSRStorageDevice(IN deviceInfo.deviceType))
        {
            LocalSPM::GetListControl().CheckFileLists(IN ldeviceID);
        }
    }
    ETG_TRACE_USR4(("DeleteMediaContent deleteMediaContentType : %d fileOperationErrorCodes : %d  numofFilesDeleted : %d ",deleteMediaContentType,fileOperationErrorCodes,numofFilesDeleted));
    //send the result
    LocalSPM::GetOutputWrapper().Send_OnDeleteMediaContentMethodResult(deleteMediaContentType,fileOperationErrorCodes,numofFilesDeleted);

    return ret;

}



void ConvertErrorCodeFromReturnVal(tResult ret, tFileOperationErrorCodes& fileOperationErrorCodes)
 {
    fileOperationErrorCodes = FILE_OPERATION_OK;
     switch(ret)
     {
         case MP_NO_ERROR:
             fileOperationErrorCodes = FILE_OPERATION_OK;
             break;
         case MP_ERR_DB_UNEXPECTED:
             fileOperationErrorCodes = DATABASE_ERROR;
             break;
         case MP_ERR_RD_FILE_PERMISSION:
             fileOperationErrorCodes = FILEPERM_ISSUE;
             break;
         case MP_ERR_DEVICE_NOT_EXIST:
             fileOperationErrorCodes = DEVICE_NOT_EXISITS;
             break;
         case TAG_EDIT_ERROR:
             fileOperationErrorCodes = TAG_EDIT_ERROR;
             break;
         case DATABASE_ERROR:
         case OBJECT_NOT_FOUND:
             fileOperationErrorCodes = OBJECT_NOT_FOUND;
             break;
         case MP_ERR_LC_UNDEFINED_LIST_ID:
              fileOperationErrorCodes = LISTTYPE_NOT_FOUND;
             break;//CID 148275 : Missing break in switch
         default:
             fileOperationErrorCodes = DEVICE_ERROR;
             ETG_TRACE_USR1(("ConvertErrorCodeFromReturnVal unexpected return value %d", ret));
             break;
     }
 }


tResult CustomControl::EditMetaData(IN const tEditMetaDataByID &editMetaDataByID)
{
    tEditMetaDataByID *pEditMetaDataByID = new tEditMetaDataByID;
    if(pEditMetaDataByID)
    {
        pEditMetaDataByID->MediaObjectID = editMetaDataByID.MediaObjectID;
        strncpy_r(OUT pEditMetaDataByID->GenreField,IN editMetaDataByID.GenreField, IN sizeof(pEditMetaDataByID->GenreField));
        strncpy_r(OUT pEditMetaDataByID->AlbumField, IN editMetaDataByID.AlbumField, IN sizeof(pEditMetaDataByID->AlbumField));
        strncpy_r(OUT pEditMetaDataByID->ArtistField, IN editMetaDataByID.ArtistField, IN sizeof(pEditMetaDataByID->ArtistField)) ;
        strncpy_r(OUT pEditMetaDataByID->TitleField, IN editMetaDataByID.TitleField, IN sizeof(pEditMetaDataByID->TitleField));
        strncpy_r(OUT pEditMetaDataByID->ComposerField, IN editMetaDataByID.ComposerField, IN sizeof(pEditMetaDataByID->ComposerField));
        strncpy_r(OUT pEditMetaDataByID->yomiMetaData.YomiTitle, IN editMetaDataByID.yomiMetaData.YomiTitle, IN sizeof(pEditMetaDataByID->yomiMetaData.YomiTitle));
        strncpy_r(OUT pEditMetaDataByID->yomiMetaData.YomiArtist, IN editMetaDataByID.yomiMetaData.YomiArtist, IN sizeof(pEditMetaDataByID->yomiMetaData.YomiArtist));
        strncpy_r(OUT pEditMetaDataByID->yomiMetaData.YomiAlbum, IN editMetaDataByID.yomiMetaData.YomiAlbum, IN sizeof(pEditMetaDataByID->yomiMetaData.YomiAlbum));
        pEditMetaDataByID->YearField = editMetaDataByID.YearField;
        pEditMetaDataByID->deviceID      = editMetaDataByID.deviceID;
        /*Create a worker thread to EditMetadata */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_EDITMETADATA_OBJECTID, (void*)pEditMetaDataByID, this); //lint -e429 freed by calling thread}
    }
    return MP_NO_ERROR;

}

tResult CustomControl::EditMetaData(IN const tEditMetaDataByUrl &editMetaDataByUrl)
{
    tEditMetaDataByUrl *pEditMetaDataByUrl = new tEditMetaDataByUrl;
    ETG_TRACE_USR4(("EditMetaData pEditMetaDataByUrl"));
    if(pEditMetaDataByUrl)
    {
        strncpy_r(OUT pEditMetaDataByUrl->MediaObjectUrl, IN editMetaDataByUrl.MediaObjectUrl, IN sizeof(pEditMetaDataByUrl->MediaObjectUrl));
        strncpy_r(OUT pEditMetaDataByUrl->GenreField, IN editMetaDataByUrl.GenreField, IN sizeof(pEditMetaDataByUrl->GenreField));
        strncpy_r(OUT pEditMetaDataByUrl->AlbumField, IN editMetaDataByUrl.AlbumField, IN sizeof(pEditMetaDataByUrl->AlbumField));
        strncpy_r(OUT pEditMetaDataByUrl->ArtistField, IN editMetaDataByUrl.ArtistField, IN sizeof(pEditMetaDataByUrl->ArtistField));
        strncpy_r(OUT pEditMetaDataByUrl->TitleField, IN editMetaDataByUrl.TitleField, IN sizeof(pEditMetaDataByUrl->TitleField));
        strncpy_r(OUT pEditMetaDataByUrl->ComposerField, IN editMetaDataByUrl.ComposerField, IN sizeof(pEditMetaDataByUrl->ComposerField));
        strncpy_r(OUT pEditMetaDataByUrl->yomiMetaData.YomiTitle, IN editMetaDataByUrl.yomiMetaData.YomiTitle, IN sizeof(pEditMetaDataByUrl->yomiMetaData.YomiTitle));
        strncpy_r(OUT pEditMetaDataByUrl->yomiMetaData.YomiArtist, IN editMetaDataByUrl.yomiMetaData.YomiArtist, IN sizeof(pEditMetaDataByUrl->yomiMetaData.YomiArtist));
        strncpy_r(OUT pEditMetaDataByUrl->yomiMetaData.YomiAlbum, IN editMetaDataByUrl.yomiMetaData.YomiAlbum, IN sizeof(pEditMetaDataByUrl->yomiMetaData.YomiAlbum));
        pEditMetaDataByUrl->YearField = editMetaDataByUrl.YearField;
        pEditMetaDataByUrl->deviceID  = editMetaDataByUrl.deviceID;
        /*Create a worker thread to EditMetadata */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_EDITMETADATA_URL, (void*)pEditMetaDataByUrl, this); //lint -e429 freed by calling thread}
    }
    return MP_NO_ERROR;

}


tResult CustomControl::DoEditMetaDataThread(IN int functionID, IN const void *param)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tEditMetaDataByID *pEditMetaDataByID   = NULL;
    tEditMetaDataByUrl *pEditMetaDataByUrl = NULL;
    tDeviceID deviceID;
    tFileOperationErrorCodes fileOperationErrorCodes = FILE_OPERATION_OK;
    tEditMetadatatType editMetadatatType = EDITMETADATABYMEDIAOBJECTTAG;

    switch(functionID)
    {
       case FUNCTION_ID_EDITMETADATA_OBJECTID:
       {
           LocalSPM::GetThreadFactory().SetName("CustomControl_EditMetadataByTag");
           pEditMetaDataByID = (tEditMetaDataByID*)param;
           break;
       }
       case FUNCTION_ID_EDITMETADATA_URL:
       {
          LocalSPM::GetThreadFactory().SetName("CustomControl_EditMetadataByUrl");
          pEditMetaDataByUrl = (tEditMetaDataByUrl*)param;
          editMetadatatType  = EDITMETADATABYURL;
          break;
       }
       default:
           ETG_TRACE_USR3(("DoEditMetaDataThread : Invalid function Id %d",functionID));
           break;
    }
    if(pEditMetaDataByID)
    {

        tURL url;
        ret = LocalSPM::GetDBManager().GetURLOfMediaObject(url,pEditMetaDataByID->MediaObjectID,pEditMetaDataByID->deviceID);
        if(ret)
        {
            ret = DATABASE_ERROR;
        }
        else
        {
            tEditMetaDataByUrl editMetaDataByUrl;
            strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN url, IN sizeof(editMetaDataByUrl.MediaObjectUrl));
            strncpy_r(OUT editMetaDataByUrl.GenreField, IN pEditMetaDataByID->GenreField, IN sizeof(editMetaDataByUrl.GenreField));
            strncpy_r(OUT editMetaDataByUrl.AlbumField, IN pEditMetaDataByID->AlbumField, IN sizeof(editMetaDataByUrl.AlbumField));
            strncpy_r(OUT editMetaDataByUrl.ArtistField, IN pEditMetaDataByID->ArtistField, IN sizeof(editMetaDataByUrl.ArtistField));
            strncpy_r(OUT editMetaDataByUrl.TitleField, IN pEditMetaDataByID->TitleField, IN sizeof(editMetaDataByUrl.TitleField));
            strncpy_r(OUT editMetaDataByUrl.ComposerField, IN pEditMetaDataByID->ComposerField, IN sizeof(editMetaDataByUrl.ComposerField));
            strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiTitle, IN  pEditMetaDataByID->yomiMetaData.YomiTitle, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiTitle));
            strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiArtist, IN  pEditMetaDataByID->yomiMetaData.YomiArtist, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiArtist));
            strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiAlbum, IN  pEditMetaDataByID->yomiMetaData.YomiAlbum, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiArtist));
            editMetaDataByUrl.YearField = pEditMetaDataByID->YearField;
            editMetaDataByUrl.deviceID = pEditMetaDataByID->deviceID;
            deviceID = pEditMetaDataByID->deviceID;
            ret = LocalSPM::GetListControl().EditMetaData(editMetaDataByUrl);

            if(ret == MP_NO_ERROR)
            {
                ETG_TRACE_USR1(("DoEditMetaDataThread finished with return value %d", ret));
                //Metadata updated for nowplaying content if pEditMetaDataByID->MediaObjectID is same as nowPlaying objectID
                LocalSPM::GetPlayerManager().SetNowPlayingMetadataEditedByUser(pEditMetaDataByID->MediaObjectID);
            }
        }
        delete pEditMetaDataByID;
    }
    else if(pEditMetaDataByUrl)
    {
        tObjectID MediaObjectID;
        ret = LocalSPM::GetListControl().EditMetaData(*pEditMetaDataByUrl);
        deviceID = pEditMetaDataByUrl->deviceID;
        if(ret == MP_NO_ERROR)
        {
            ETG_TRACE_USR1(("DoEditMetaDataThread finished with return value %d", ret));
            //Metadata updated for nowplaying content if MediaObjectID is same as nowPlaying objectID
            if(MP_NO_ERROR == LocalSPM::GetDBManager().GetObjectID(MediaObjectID, pEditMetaDataByUrl->deviceID, pEditMetaDataByUrl->MediaObjectUrl))
            {
                LocalSPM::GetPlayerManager().SetNowPlayingMetadataEditedByUser(MediaObjectID);
            }
        }
        delete pEditMetaDataByUrl;
    }
    ConvertErrorCodeFromReturnVal(ret,fileOperationErrorCodes);
    if(MP_NO_ERROR == ret)
    {
      LocalSPM::GetListControl().CheckLists(IN deviceID);

    }
    //send the result
    LocalSPM::GetOutputWrapper().Send_OnEditMetadataMethodResult(editMetadatatType,fileOperationErrorCodes);
    return ret;
}

tResult CustomControl::DoPlayListOperationThread(IN int functionID, IN const void *param)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tPlayListAddOperation *p_PlayListAddOperation = NULL;
    tPlayListDeleteOperation *p_PlayListDeleteOperation = NULL;
    tPlayListAddOperationByTags *p_PlayListAddOperationByTags = NULL;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tFileOperationErrorCodes fileOperationErrorCodes = FILE_OPERATION_OK;

    switch(functionID)
    {
        case FUNCTION_ID_PLAYLIST_ADDENTRIES:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_Playlist_AddEntries");
            p_PlayListAddOperation = (tPlayListAddOperation*) param;
            break;
        }
        case FUNCTION_ID_PLAYLIST_DELETEENTRIES:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_Playlist_DeleteEntries");
            p_PlayListDeleteOperation = (tPlayListDeleteOperation *)param;
            break;
        }
        case FUNCTION_ID_PLAYLIST_ADDENTRIES_TAGS:
        {
            LocalSPM::GetThreadFactory().SetName("CustomControl_Playlist_AddEntriesByTag");
            p_PlayListAddOperationByTags = (tPlayListAddOperationByTags *)param;

        }
    }
    if(p_PlayListAddOperation)
    {
        vector<string>::iterator pathit;
        vector<string> filenamePaths = p_PlayListAddOperation->filenamePaths;
        vector<tPosition>::iterator positionit;
        vector<tPosition> positions = p_PlayListAddOperation->ListOfPositions;
        deviceID = p_PlayListAddOperation->deviceID;
        bool isPositionSupplied = false;
        tResult tempret = MP_NO_ERROR;
        //if HMI has supplied the entries for the positions then the both the vector will be having the same size
        if(filenamePaths.size() == positions.size())
        {
            isPositionSupplied = true;
        }
        tPosition position = POSITION_NOT_SET;
        int numberOfEntriesAdded = 0;
        positionit = positions.begin();
        for(pathit = filenamePaths.begin();pathit<filenamePaths.end();pathit++)
        {
            if(isPositionSupplied)
            {
                position = *positionit;
                positionit++;
            }
            tPath filenamePath = "";
            strncpy_r(OUT filenamePath,(*pathit).c_str(),sizeof(filenamePath));

            ret = LocalSPM::GetListControl().AddFileNameToPlaylist(p_PlayListAddOperation->PlayListPath,filenamePath,position);
            if(MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == ret )
            {
                tempret = ret;
            }
            if(ret && (MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND != ret))//continue adding next items in the list of entries
            {
                break;
            }
            else
            {
                numberOfEntriesAdded++;
            }
        }

        if(numberOfEntriesAdded)
        {
            //update the HMI if the list is changed
            LocalSPM::GetListControl().CheckFileLists(deviceID);
        }

        //if the user attempts to store the entry multiple times, then the user will get the response as "MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND"
        if(MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == tempret && ( MP_NO_ERROR == ret  || MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == ret ))
        {
            ETG_TRACE_USR4(("PlayListAddOperation playlist operation returning with error code MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND "));
            ret = tempret;
        }

        LocalSPM::GetOutputWrapper().Send_OnAddFileNamesToPlaylistMethodResult(ret);
        delete p_PlayListAddOperation;

    }
    else if(p_PlayListDeleteOperation)
    {
        vector<tPosition> positions = p_PlayListDeleteOperation->ListOfPositions;
        vector<tPosition>::iterator positionit;
        int numberOfEntriesDeleted = 0;
        if(0 == positions.size())
        {
            //It will delete all the entries in the playlist
            bool deleteallentries = true;
            ret = LocalSPM::GetListControl().DeleteEntryFromPlaylist(p_PlayListDeleteOperation->PlayListPath,DELETE_ALL,deleteallentries);
            if(!ret)
            {
                numberOfEntriesDeleted++;
            }
        }
        else
        {
            for(positionit = positions.begin();positionit<positions.end();positionit++)
            {
                ret = LocalSPM::GetListControl().DeleteEntryFromPlaylist(p_PlayListDeleteOperation->PlayListPath,*positionit);
                if(!ret)
                {
                    numberOfEntriesDeleted++;
                }
                else
                {
                    break;
                }
            }
        }
        if(numberOfEntriesDeleted)
        {
            //update the HMI if the list is changed
            LocalSPM::GetListControl().CheckFileLists(deviceID);
        }
        LocalSPM::GetOutputWrapper().Send_OnDeleteEntriesFromPlaylistMethodResult(ret);
        delete p_PlayListDeleteOperation;
    }
    else if(p_PlayListAddOperationByTags)
    {
        tListID listID;
        tListSize listSize;
        tStreaming streaming = false;
        tIndex startIndex = 0;
        tResult tempret = MP_NO_ERROR;
        int numberOfEntriesAdded = 0;


        ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(OUT listID, OUT listSize, IN p_PlayListAddOperationByTags->listType, IN streaming, IN p_PlayListAddOperationByTags->tag1, IN p_PlayListAddOperationByTags->tag2, IN p_PlayListAddOperationByTags->tag3, IN p_PlayListAddOperationByTags->tag4, IN p_PlayListAddOperationByTags->deviceID);
        if(MP_NO_ERROR == ret)
        {
          vector<tMediaObject> mediaObjectVector;
          ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN startIndex, IN listSize);
          if(MP_NO_ERROR == ret )
          {
              vector<tMediaObject>::iterator objit;


              for(objit = mediaObjectVector.begin();objit<mediaObjectVector.end();objit++)
              {

                  ETG_TRACE_USR3(("DoPlayListOperationThread playlist filename : %s",p_PlayListAddOperationByTags->playlistPath));
                  tDeviceInfo deviceInfo;
                  deviceID = p_PlayListAddOperationByTags->deviceID;
                  ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
                  string filename = deviceInfo.mountPoint;
                  filename += objit->fileName;
                  if(exists_file(filename.c_str()))
                  {
                      ETG_TRACE_USR3(("DoPlayListOperationThread filename : %s",objit->fileName));
                      ret = LocalSPM::GetListControl().AddFileNameToPlaylist(p_PlayListAddOperationByTags->playlistPath,objit->fileName,POSITION_NOT_SET);
                      if(MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == ret )
                      {
                          tempret = ret;
                      }
                      else if(ret && (MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND != ret))//continue adding next items in the list of entries
                      {
                          break;
                      }
                      else
                      {
                          numberOfEntriesAdded++;
                      }
                  }
                  else
                  {
                      ETG_TRACE_USR3(("DoPlayListOperationThread filename does not exists: %s",objit->fileName));
                      ret = MP_ERR_LC_PLAYLIST_NOT_FOUND;

                  }

              }
          }
          LocalSPM::GetListControl().ReleaseList(IN listID);
        }
        if(numberOfEntriesAdded)
        {
           //update the HMI if the list is changed
           LocalSPM::GetListControl().CheckFileLists(deviceID);
        }

        //if the user attempts to store the entry multiple times, then the user will get the response as "MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND"
        if(MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == tempret && ( MP_NO_ERROR == ret  || MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND == ret ))
        {
           ETG_TRACE_USR4(("PlayListAddOperation playlist operation returning with error code MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND "));
           ret = tempret;
        }
        LocalSPM::GetOutputWrapper().Send_OnAddFileNamesToPlaylistMethodResult(ret);
        delete p_PlayListAddOperationByTags;
    }//if(p_PlayListAddOperationByTags)
    ETG_TRACE_USR4(("DoPlayListOperationThread finished with return value %d", ret));
    return ret;
}

tResult CustomControl::AddFileNamesToPlayList(IN const  tPlayListAddOperation &PlayListAddOperation)
{
    tResult ret = MP_NO_ERROR;
    tPlayListAddOperation *pPlayListAddOperation = new tPlayListAddOperation;
    if(pPlayListAddOperation)
    {
        strncpy_r(pPlayListAddOperation->PlayListPath,PlayListAddOperation.PlayListPath,sizeof(pPlayListAddOperation->PlayListPath));
        pPlayListAddOperation->filenamePaths = PlayListAddOperation.filenamePaths;
        pPlayListAddOperation-> ListOfPositions = PlayListAddOperation.ListOfPositions ;
        pPlayListAddOperation->deviceID = PlayListAddOperation.deviceID;
        if(!m_PlayListOperationLock.locked())
        {
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_PLAYLIST_ADDENTRIES, (void*)pPlayListAddOperation, this); //lint -e429 freed by calling thread
        }
        else
        {
            ret = MP_ERR_FILE_OPERATION_INPROGESS;
        }
    }
    else
    {
        ret = MP_ERR_CC_MEMORY_ALLOC_FAILED;
    }
    return ret;
}
tResult CustomControl::DeleteEntriesFromPlaylist(IN const  tPlayListDeleteOperation &PlayListDeleteOperation)
{
    tResult ret = MP_NO_ERROR;
    tPlayListDeleteOperation *pPlayListDeleteOperation = new tPlayListDeleteOperation;
    if(pPlayListDeleteOperation)
    {
        strncpy(pPlayListDeleteOperation->PlayListPath,PlayListDeleteOperation.PlayListPath,sizeof(pPlayListDeleteOperation->PlayListPath));
        pPlayListDeleteOperation->ListOfPositions = PlayListDeleteOperation.ListOfPositions;
        pPlayListDeleteOperation->deviceID = PlayListDeleteOperation.deviceID;
        if(!m_PlayListOperationLock.locked())
        {
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_PLAYLIST_DELETEENTRIES, (void*)pPlayListDeleteOperation, this); //lint -e429 freed by calling thread
        }
        else
        {
            ret = MP_ERR_FILE_OPERATION_INPROGESS;
        }

    }
    else
    {
        ret = MP_ERR_CC_MEMORY_ALLOC_FAILED;
    }

    return ret;

}
tResult CustomControl::SetFilePermissions(tSetFilePermission pFilePermissions)
{
    ENTRY
    tSetFilePermission *oPermission = new  tSetFilePermission[sizeof(tSetFilePermission)];
    if(oPermission)
    {
        oPermission->objectIDs = pFilePermissions.objectIDs;
        oPermission->deviceID  = pFilePermissions.deviceID;
        /*Create a worker thread to set file permission */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_SETFILEPERMISSION_TAG, (void*)oPermission, this); //lint -e429 freed by calling thread
    }
    return MP_NO_ERROR;
}

//>--Roadmap CMG3G-10221 : 'Scene Recorder '
tResult CustomControl::DoFilePermissionThread(IN const void *param)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tSetFilePermission *oFilePermission = (tSetFilePermission*)param;
    vector<tFilePermission> lfilePermissions;
    vector<tFilePermission>::iterator objit;
    TimeTrace ticks(__PRETTY_FUNCTION__);
    tU16 numofFiles = 0;
    tDeviceInfo deviceInfo;

    if(oFilePermission)
    {
        tFilePermission l_file;
        for(objit = oFilePermission->objectIDs.begin();objit!=oFilePermission->objectIDs.end();objit++)
        {
            ret = LocalSPM::GetDBManager().GetURLOfMediaObject(objit->url,objit->objectID,oFilePermission->deviceID);
            l_file.objectID = objit->objectID;
            l_file.readOnly = objit->readOnly;
            strncpy(l_file.url , objit->url, sizeof(objit->url));
            lfilePermissions.push_back(l_file);
            if(ret)
            {
                ret = DATABASE_ERROR;
            }
            else
            {
                ETG_TRACE_USR3(("DoDeleteMediaContentThread filename : %s",objit->url));
            }
        }

        if(!ret)
        {
            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN oFilePermission->deviceID);
            if(!ret)
            {
                setSRMount(deviceInfo, false);
                ret = LocalSPM::GetListControl().SetFilePermissions(deviceInfo, lfilePermissions, numofFiles);
                setSRMount(deviceInfo, true);
            }
        }
        /* Check all lists against changes */
        if(!ret)
        {
            LocalSPM::GetListControl().CheckLists(IN oFilePermission->deviceID);
            if(IsSRStorageDevice(IN deviceInfo.deviceType))
            {
                LocalSPM::GetListControl().CheckFileLists(IN oFilePermission->deviceID);
            }
        }
    }
    ticks.elapsed();
    delete []oFilePermission;
    ETG_TRACE_USR4(("DoDeleteMediaContentThread method result  numofFiles = %d ret = %d",numofFiles,ret));
    LocalSPM::GetOutputWrapper().Send_SetfilePermissionByMediaobjectTagsMethodResult(ret,numofFiles);
    return ret;
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

//>--Roadmap 16003 : 'CD Ripping With Gracenote'
tResult CustomControl::AddFileNamesToPlayListByTag(IN tPlayListAddOperationByTags PlayListAddOperationByTags)
{
    VARTRACE(PlayListAddOperationByTags.deviceID);
    VARTRACE(PlayListAddOperationByTags.playlistPath);
    VARTRACE(PlayListAddOperationByTags.listType);
    VARTRACE(PlayListAddOperationByTags.tag1);
    VARTRACE(PlayListAddOperationByTags.tag2);
    VARTRACE(PlayListAddOperationByTags.tag3);
    tResult ret = MP_NO_ERROR;
    tPlayListAddOperationByTags *pPlayListAddOperationByTags = new tPlayListAddOperationByTags;
    if(pPlayListAddOperationByTags)
    {
        memset(pPlayListAddOperationByTags,0,sizeof(tPlayListAddOperationByTags));
        strncpy_r(pPlayListAddOperationByTags->playlistPath,PlayListAddOperationByTags.playlistPath,sizeof(pPlayListAddOperationByTags->playlistPath));
        pPlayListAddOperationByTags->listType = PlayListAddOperationByTags.listType;
        pPlayListAddOperationByTags-> tag1 = PlayListAddOperationByTags.tag1 ;
        pPlayListAddOperationByTags-> tag2 = PlayListAddOperationByTags.tag2 ;
        pPlayListAddOperationByTags-> tag3 = PlayListAddOperationByTags.tag3 ;
        pPlayListAddOperationByTags-> tag4 = PlayListAddOperationByTags.tag4 ;
        pPlayListAddOperationByTags->deviceID = PlayListAddOperationByTags.deviceID;
        if(!m_PlayListOperationLock.locked())
        {
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_PLAYLIST_ADDENTRIES_TAGS, (void*)pPlayListAddOperationByTags, this); //lint -e429 freed by calling thread
        }
        else
        {
            ret = MP_ERR_FILE_OPERATION_INPROGESS;
        }
    }
    else
    {
        ret = MP_ERR_CC_MEMORY_ALLOC_FAILED;
    }
    return ret;
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
tResult CustomControl::DeleteMediaContentFromDirectory(IN const tDeviceID deviceID,IN  std::string dirName,OUT tU16 &numofFilesDeleted)
{
    ENTRY
    VARTRACE(dirName.c_str());
    vector<tDirInfo> dirInfo;
    tResult ret = MP_NO_ERROR;
    vector<tDirInfo>::iterator it;
    tU16 count = 0;
    tDeviceInfo deviceInfo;

    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    string dirPath = LocalSPM::GetDataProvider().ConvertDbPath(dirName);
    dirPath = dirPath + "%";

    if(!ret)    {
        ret = LocalSPM::GetDBManager().GetDirInfoFromPath(IN deviceID, IN dirPath, OUT dirInfo);
        if(!ret)    {
            for(it = dirInfo.begin();it!=dirInfo.end();it++)    {
                if(CTY_DIR != it->Category) {
                    ret = LocalSPM::GetListControl().DeleteMediaContent(deviceInfo,it->URL,getSystemCondition());
                    if(MP_ERR_DEVICE_NOT_EXIST == ret)
                        break;
                    count++;
                }
            }
        }
        else  {
            ret = MP_ERR_DB_UNEXPECTED;
        }
    }
    else {
       ret = MP_ERR_DEVICE_NOT_EXIST;
   }
   numofFilesDeleted = count;
   return ret;
}
tBoolean CustomControl::isDirectory(IN std::string url, IN const tDeviceInfo &deviceInfo)
{
    tResult ret = MP_NO_ERROR;

    string filename = deviceInfo.mountPoint;
    filename += url;

    return  exists_directory(filename.c_str());
}

tBool CustomControl::getSystemCondition()
{
    ENTRY
    Locker locker(&m_SystemConditionLock);
    return bNormalCondition;
}
void CustomControl::setSystemCondition(tBool condition)
{
    ENTRY
    Locker locker(&m_SystemConditionLock);
    bNormalCondition = condition;
}
void CustomControl::setSRMount(IN const tDeviceInfo &deviceInfo, IN tBool condition)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    // for sr device mount
    if(LocalSPM::GetDataProvider().EnableSRdevice() && IsSRStorageDevice(IN deviceInfo.deviceType))
    {
        ret = LocalSPM::GetListControl().ReMountFolder(deviceInfo,condition);
        if(ret)
        {
            ETG_TRACE_USR1(("setSRMount failed  %d - err %d ",deviceInfo.deviceID,ret));
        }
    }
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

//<--Roadmap 17001 : 'Personalization'
tResult CustomControl::StorePersonalizedFavorite(OUT tFavoriteID &retFavID, IN const tObjectID _objectID,  IN const tUserID userID )
{
    ENTRY

    tResult res;
    VARTRACE(_objectID);
    VARTRACE(userID);

    tLabelText labelText;
    tDescriptorText descripterText;
    tTitle title;
    tMediaObject mediaObject;

    tCategoryType objectType;
    tObjectID objectID = _objectID;

    memset(labelText,0,sizeof(tLabelText));
    memset(descripterText,0,sizeof(tDescriptorText));

    if (objectID & IPOD_MARKER_BIT) {
        res = LocalSPM::GetDBManager().GetFavoriteNameIPOD(OUT title , INOUT objectID, OUT objectType);
        if (res) return res;

    } else {

        //// Get object Type for LabelText and DescriptorText  \\\\

        objectType = CTY_SONG;
        // For 17001_Personalization, Type is always song. If changed in future, use below call
        /*
        res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, INOUT objectID);
        if (res) return res;
        */

        //// Get object name for LabelText and DescriptorText  \\\\

        strncpy_r(title,"Default",sizeof(tTitle));
        // For 17001_Personalization, Title is not necessary. If changed in future, use below call
        /*
        res = GetObjectName(OUT title, IN objectID, IN objectType);
        if (res) return res;
        */
    }
    /* Create LabelText and DescripterText from title(stored above)*/
    strncpy_r(labelText,title,sizeof(tLabelText));
    strncpy_r(descripterText,title,sizeof(tDescriptorText));

    /* Check for objectid in db and set favid to zero */
    res = LocalSPM::GetDBManager().GetMediaObject( OUT mediaObject, IN objectID, IN objectType);
    if (res)
    {
        ETG_TRACE_ERR(("StorePersonalizedFavorite -> Unable to retrieve the media object for objectID:%d , type:%d",objectID,objectType));
        retFavID=0;
        return MP_NO_ERROR;
    }

    /*Store the User favorite in the Database*/
    res = LocalSPM::GetDBManager().StorePersonalizedFavorite(OUT retFavID, IN objectID, IN objectType, IN labelText, IN descripterText, IN userID);
    if (res)  return res;

    ETG_TRACE_USR3(("StorePersonalizedFavorite Updating Favorite Info to PlayerManager"));
    mediaObject.isFavorite = true;
    res = LocalSPM::GetPlayerManager().SetMediaObject(IN mediaObject);
    if (res)  return res;

    /*Update HMI of updated list*/
    tDeviceID deviceID;
    /* Get the current active device ID */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    /* Check all lists against changes */
    res = LocalSPM::GetListControl().CheckLists(IN deviceID);
    if (res) return res;

    return  MP_NO_ERROR;
}

tResult CustomControl::DeletePersonalizedFavorite(IN tObjectID objectID, IN const tUserID userID )
{
    ENTRY
    tResult res;
    VARTRACE(objectID);
    VARTRACE(userID);

    if (0 == userID) //For UserID = 0
    {
        /*Reset the user table and Favorites table*/
        res = LocalSPM::GetDBManager().ResetPersonalization();
    }
    else if ((0 == objectID) && (userID > 0)) //For objectID = 0 and Non Zero userID
    {
        /*Delete All users for that particular user*/
        res = LocalSPM::GetDBManager().DeleteAllUserFavorites(IN userID);
    }
    else
    {
        /*Delete the favorite in the Database*/
        res = LocalSPM::GetDBManager().DeletePersonalizedFavorite(IN objectID, IN userID);
        if (res)  return res;

        tMediaObject mediaObject;
        tCategoryType objectType = CTY_SONG;
        res = LocalSPM::GetDBManager().GetMediaObject( OUT mediaObject, IN objectID, IN objectType);
        if (res)

        ETG_TRACE_USR3(("DeletePersonalizedFavorite Updating Favorite Info to PlayerManager"));
        mediaObject.isFavorite = false;
        res = LocalSPM::GetPlayerManager().SetMediaObject(IN mediaObject);
        if (res)  return res;
    }

    /*Update HMI of updated list*/
    tDeviceID deviceID;
    /* Get the current active device ID */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    /* Check all lists against changes */
    res = LocalSPM::GetListControl().CheckLists(IN deviceID);
    if (res) return res;

    return  MP_NO_ERROR;
}

tResult CustomControl::SetCurrentUser(IN const tUserID userID )
{
    ENTRY
    tResult res;
    VARTRACE(userID);

    /*Set Current user in the Database*/
    res = LocalSPM::GetDBManager().SetCurrentUser(IN userID);
    if (res)  return res;

    return  MP_NO_ERROR;
}

tResult CustomControl::StartPersonalizationTimer()
{
    ENTRY;

    long timerMS = 5000;

    /* create Personalization timer */
    mPersonalizationTimer.StartTimer(OUT mPersonalizationTimerID, IN timerMS, IN 0L, IN this, IN &PersonalizationTimerCallback, IN NULL);

    return MP_NO_ERROR;
}

tResult CustomControl::StopPersonalizationTimer()
{
    ENTRY;

    /* delete Personalization timer */
    if(mPersonalizationTimerID) {
        mCheckListTimer.CancelTimer(IN mPersonalizationTimerID);
        mPersonalizationTimerID = 0;
    }

    return MP_NO_ERROR;
}

bool CustomControl::PersonalizationTimerCallback(timer_t timerID , void* instance, const void *userData)
{
    ENTRY;
    (void)timerID;
    tResult ret = MP_NO_ERROR;
    CustomControl *self = (CustomControl *)instance;
    if(LocalSPM::GetInstance().isAllRunExternal())
    {
        if(self)
        {
            ret = self->SendEvent(self->GET_PROFILEID, IN (char *)NULL);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }

    }
    else
    {
        ETG_TRACE_ERR(("All components not up yet. Restart timer"));
        self->StartPersonalizationTimer();
    }

    return MP_NO_ERROR;

}

tResult CustomControl::GetProfileID()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = PersonalizationProxy::GetInstance().ActiveProfileInformationGet();
    if (ret != MP_NO_ERROR) {
        ETG_TRACE_ERR(("Error while calling ActiveProfileInformationGet (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}
//<--Roadmap 17001 : 'Personalization'
tResult CustomControl::UpdateFolderBrowseStructureCleared(tDeviceID deviceID)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    SetDeviceIDForFolderStructureCleared(deviceID);
    LocalSPM::GetOutputWrapper().UpdateFolderBrowseStructureCleared();
    return ret;
}
tDeviceID CustomControl::GetDeviceIDForFolderStructureCleared()
{
    VARTRACE(mDeviceIDForFolderStructureCleared);
    return mDeviceIDForFolderStructureCleared;
}
void CustomControl::SetDeviceIDForFolderStructureCleared(tDeviceID deviceID)
{
    mDeviceIDForFolderStructureCleared = deviceID;
    VARTRACE(mDeviceIDForFolderStructureCleared);
}

tResult CustomControl::HandleFolderUpDown(tPlaybackAction playbackAction, tNextPrevSkipCount nextPrevSkipCount)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tBoolean bFolderFound = FALSE;

    VARTRACE(playbackAction);
    VARTRACE(nextPrevSkipCount);

    // If Repeat mode is RPT_ALL, set it to RPT_LIST_WITH_SUBLISTS.
    // Because user is already inside a folder and playback of songs in the root folder is not expected.
    tRepeatMode repeatMode = RPT_INVALID;
    ret = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);
    if( RPT_ALL == repeatMode )
    {
        ETG_TRACE_USR4((" Switching RepeatMode from RPT_ALL to RPT_LIST_WITH_SUBLISTS "));
        ret = LocalSPM::GetPlayerManager().SendRepeatMode(IN RPT_LIST_WITH_SUBLISTS);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR((" Error while updating repeatMode (ErrorCode:%s)", errorString(ret)));
        }
    }

    // Get the currently playing media item
    tNowPlaying nowPlaying;
    if( MP_NO_ERROR == LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying) )
    {
        if( OBJECT_ID_NONE != nowPlaying.objectID )
        {
            // Get the folder path of the nowplaying media item
            tPath folderPath;
            strncpy_r(OUT folderPath, IN nowPlaying.object.path, IN sizeof(folderPath));

            tListID fileListID = LIST_ID_NONE;
            tNumberOfMediaObjects numberOfMediaObjects = 0;
            tNextPrevSkipCount skipCount = nextPrevSkipCount;
            do
            {
                // Find the folder path to switch to
                ret = LocalSPM::GetListControl().GetFolderPathToSwitchTo(INOUT folderPath, IN nowPlaying.object.deviceID, IN playbackAction, IN skipCount);
                VARTRACE(folderPath);

                if( MP_NO_ERROR == ret)
                {
                    // Create a MediaPlayerFileList for the new folder path
                    ret = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
                            OUT fileListID,
                            IN folderPath,
                            IN nowPlaying.object.deviceID,
                            IN true /*withSubFolders*/);

                    if( MP_NO_ERROR == ret )
                    {
                        //Get the number of media objects in the current path
                        ret = LocalSPM::GetListControl().GetNumberOfMediaObjects(IN fileListID, OUT numberOfMediaObjects);
                        if( MP_NO_ERROR == ret )
                        {
                            if( 0 == numberOfMediaObjects )
                            {
                                // If there are no mediaobjects in this folder this do/while loop checks next/previous folder for mediaobjects.
                                // For that, for the next iteration use nextPrevSkipCount as 1.
                                // So that folder checked for mediaobjects is the very next/previous folder.
                                skipCount = 1;

                                // Also release the already created list as it is not required.
                                ret = LocalSPM::GetListControl().ReleaseList(IN fileListID);
                                if( MP_NO_ERROR != ret )
                                {
                                    ETG_TRACE_ERR((" Error while releasing list (ErrorCode:%s)", errorString(ret)));
                                }
                            }
                            else
                            {
                                bFolderFound = TRUE;
                            }
                        }
                        else
                        {
                            ETG_TRACE_ERR((" Error while getting NumberOfMediaObjects (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                    else
                    {
                        ETG_TRACE_ERR((" Error while Creating FileListOfMediaObjects (ErrorCode:%s)", errorString(ret)));
                    }
                }
                else
                {
                    ETG_TRACE_ERR((" Error while getting FolderPathToSwitchTo (ErrorCode:%s)", errorString(ret)));
                }
            } while ( 0 == numberOfMediaObjects && MP_NO_ERROR == ret );

            if( TRUE == bFolderFound )
            {
                // Send updated playlist for starting playback
                tIndex index = 0;
                tPlaytime offset = 0;
                ret = LocalSPM::GetPlayerManager().SendNewList(IN fileListID, IN index, IN offset);
                if( MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR((" Error while sending NewList (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
        else
        {
            ETG_TRACE_ERR((" Error: NowPlaying object ID is Invalid! "));
        }
    }
    else
    {
        ETG_TRACE_ERR((" Error while getting nowPlaying (ErrorCode:%s)", errorString(ret)));
    }

    return MP_NO_ERROR;
}

tResult CustomControl::GetVolumeFromAudio()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    LocalSPM::GetOutputWrapper().GetCurrentVolumeFromAudio();
    return ret;
}

tResult CustomControl::UpdateReadyToPlay(const tDeviceSerialNumber deviceAddress, const tPEPlaybackState playbackState)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    VARTRACE(deviceAddress);
    VARTRACE(playbackState);
    strncpy_r(mDeviceAddressForReadyToPlay,deviceAddress,sizeof(tDeviceSerialNumber));
    mPlaybackStateForReadyToPlay = playbackState;
    LocalSPM::GetOutputWrapper().UpdateReadyToPlay();
    return ret;
}

tPEPlaybackState CustomControl::GetPlaybackStateForReadyToPlay()
{
    ENTRY
    VARTRACE(mPlaybackStateForReadyToPlay);
    return mPlaybackStateForReadyToPlay;
}

tBool CustomControl::GetPlayingStatus()
{
    ENTRY
    /*Client needs to know only if the playbackstatus is Playing or not
    Hence we shall update TRUE if the Playbackstatus is playing and FALSE for anyother state*/
    tPEPlaybackState PlaybackStateForReadyToPlay;
    PlaybackStateForReadyToPlay = GetPlaybackStateForReadyToPlay();
    if(PE_PBS_PLAYINGSTATE == PlaybackStateForReadyToPlay)
    {
        return true;
    }
    return false;
}

tResult CustomControl::GetDeviceAddressForReadyToPlay(tDeviceSerialNumber &deviceAddress)
{
    ENTRY
    VARTRACE(mDeviceAddressForReadyToPlay);
    strncpy(deviceAddress,mDeviceAddressForReadyToPlay,sizeof(deviceAddress));
    return MP_NO_ERROR;
}
