/*
 * VideoTagInfo.h
 *
 *  Created on: Jun 2, 2015
 *      Author: thm3hi
 */

#ifndef VIDEOTAGINFO_H_
#define VIDEOTAGINFO_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "TypeDefinitions.h"
#include "LocalSPM.h"
#include "GMPCommands.h"

class VideoTagInfoString {
public:
    VideoTagInfoString() {
        mString_toCString_0[0] = 0;
        mString_toCString_1[0] = 0;
        mString_to8Bit_true[0] = 0;
        mString_to8Bit_false[0] = 0;
        mLatin1 = 0;
    };

    char *toCString(int param)
    {
        if (param == 0) {
            return mString_toCString_0;
        } else {
            return mString_toCString_1;
        }
    }

    class VideoTagInfo8Bit {
    public:
        void setPtr(char *cptr)
        {
            mCPtr = cptr;
        }

        char *c_str() {
            return mCPtr;
        }
    private:
        char *mCPtr;
    };

    VideoTagInfo8Bit to8Bit(int param)
    {
        if (param == 0) {
            mV8b.setPtr(mString_to8Bit_false);
            return mV8b;
        } else {
            mV8b.setPtr(mString_to8Bit_true);
            return mV8b;
        }
    }

    void setLatin1(int isLatin1)
    {
        mLatin1 = isLatin1;
    }

    typedef enum {
        TO_CSTRING_0,
        TO_CSTRING_1,
        TO_8BIT_FALSE,
        TO_8BIT_TRUE
    } tTypeOfString;

    char *getRef() {
        return mString_toCString_1;
    }

    char *getRef(tTypeOfString type) {

        switch(type)
        {
            default:
            case TO_CSTRING_0:
                return mString_toCString_0;
            case TO_CSTRING_1:
                return mString_toCString_1;
            case TO_8BIT_FALSE:
                return mString_to8Bit_false;
            case TO_8BIT_TRUE:
                return mString_to8Bit_true;
        }
    }

    int isLatin1()
    {
        return mLatin1;
    }

private:
    tGeneralString mString_toCString_0;
    tGeneralString mString_toCString_1;
    tGeneralString mString_to8Bit_true;
    tGeneralString mString_to8Bit_false;
    VideoTagInfo8Bit mV8b;
    int mLatin1;
};

class VideoTagInfo
{
public:
    VideoTagInfo(const char *videoFileName, const int timeoutMs = 0);
    virtual ~VideoTagInfo();
    tResult read();

    VideoTagInfoString get_title();
    VideoTagInfoString get_videocodec();
    VideoTagInfoString get_profile();
    unsigned long long int get_duration();
    tBitRate get_bitrate();
    int get_tracknumber();
    tSize get_width();
    tSize get_height();
    float get_level();
    tFrameRate get_framerate();
    int get_encrypted();
    int get_media_type();

private:
    tURL mReadVideoFileName;
    VideoTagInfoString mProfile;
    VideoTagInfoString mCodecString;
    float mLevel;
    tSize mWidth;
    tSize mHeight;
    tBitRate mBitRate;
    tFrameRate mFrameRate;
    int mIsLatin;
    VideoTagInfoString mTitle;
    unsigned long long int mDurationInNanoSec;
    int mTrackNumber;
    int mEncrypted;
    int mMediaType;
    long mTimeoutMs;

    tResult ReadOneVideoMetaData(IN FILE *fpInput, const char *format, ...);

};

#endif /* VIDEOTAGINFO_H_ */
