/*
 * VideoTagInfo.cpp
 *
 *  Created on: Jun 2, 2015
 *      Author: thm3hi
 */

#include "VideoTagInfo.h"

tResult VideoTagInfo::ReadOneVideoMetaData(IN FILE *fpInput, const char *format, ...)
{
    tGeneralString buffer;

    /* read one line */
    char *cerr;
    cerr = fgets(buffer, sizeof(tGeneralString), fpInput);
    if (cerr != buffer) {
        return -1;
    }

    /* look for the '=' and read the item */
    char *cEqualSign = strstr(buffer, "=");
    if (!cEqualSign) {
        return -1;
    }
    cEqualSign++; // now pointing to value

    va_list vl;
    va_start(vl, format);
#if 0
    vsscanf(cEqualSign, format, vl);
#else
    char *fmt = (char *)format;
    switch(*fmt) {
    case 'i':
    {
        int *pInteger;
        pInteger = va_arg(vl, int *);
        *pInteger = atoi(cEqualSign);
        break;
    }
    case 'l':
    {
        long long int *pLongLongInteger;
        pLongLongInteger = va_arg(vl, long long int *);
        *pLongLongInteger = atoll(cEqualSign);
        break;
    }
    case 'f':
    {
        float *pFloat;
        pFloat = va_arg(vl, float *);
        *pFloat = (float)atof(cEqualSign);
        break;
    }
    case 's':
    {
        char *pChar;
        int maxlen = 0;
        pChar = va_arg(vl, char *);
        maxlen = va_arg(vl, int);
        while((*cEqualSign != '\n') && (*cEqualSign != 0) && (maxlen > 0)) {
            *pChar++ = *cEqualSign++;
            maxlen--;
        }
        *pChar = 0;
        break;
    }
    default:
        break;
    }
#endif
    va_end(vl);

    return MP_NO_ERROR;
}

VideoTagInfo::VideoTagInfo(const char *videoFileName, const int timeoutMs)
{
    /* init members */
    strncpy_r(mReadVideoFileName, videoFileName, sizeof(mReadVideoFileName));
    mTimeoutMs = timeoutMs;
    mLevel=0.0;
    mWidth=0;
    mHeight=0;
    mBitRate=0;
    mFrameRate=0;
    mIsLatin = 0;
    mDurationInNanoSec = 0;
    mTrackNumber=0;
    mEncrypted=0;
}

tResult VideoTagInfo::read()
{
    tResult res = 0;

    /* create temp file and start video scanner */
    tFilename tmpFilename = { 0 };
    if (0 > GenerateTempFileName(tmpFilename, "VMD")) {
        return 0;
    } else {

        /* path to videometascan */
        char progName[1024];
        strncpy(progName,getMediaPlayerBinPath(),sizeof(progName)-1);
        strncat(progName,"/videometascan_out.out", sizeof(progName)-1);

        char *commandStr[4] = {progName,mReadVideoFileName,tmpFilename,NULL};
        int retStatus = executeCommand(commandStr);
        if (0 != retStatus) {
            // todo put error message here
            return 0;
        }
    }

    /* read out the meta data from temp file */
    int err = 0;
    FILE *fpTempfile = fopen(tmpFilename, "r");
    if (fpTempfile) {

        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mReadVideoFileName, sizeof(mReadVideoFileName)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mCodecString.getRef(mCodecString.TO_CSTRING_1), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mProfile.getRef(mProfile.TO_CSTRING_1), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%f"*/"f", &mLevel) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mWidth) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mHeight) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mBitRate) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mFrameRate) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mIsLatin) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mTitle.getRef(mTitle.TO_8BIT_FALSE), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mTitle.getRef(mTitle.TO_8BIT_TRUE), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mTitle.getRef(mTitle.TO_CSTRING_0), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%s"*/"s", mTitle.getRef(mTitle.TO_CSTRING_1), sizeof(tGeneralString)) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%lld"*/"l", &mDurationInNanoSec) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mTrackNumber) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mEncrypted) != MP_NO_ERROR) err++;
        if (!err && ReadOneVideoMetaData(fpTempfile, /*"%d"*/"i", &mMediaType) != MP_NO_ERROR) err++;

        mTitle.setLatin1(mIsLatin);

        fclose(fpTempfile);

        if(0 != remove(tmpFilename))
        {
            // todo put error message here
        }
    }

    if (err) {
        return 0;
    }
    return 1; // OK
}

VideoTagInfoString VideoTagInfo::get_title()
{
    return mTitle;
}

VideoTagInfoString VideoTagInfo::get_videocodec()
{
    return mCodecString;
}

VideoTagInfoString VideoTagInfo::get_profile()
{
    return mProfile;
}

unsigned long long int VideoTagInfo::get_duration()
{
    return mDurationInNanoSec;
}

tBitRate VideoTagInfo::get_bitrate()
{
    return mBitRate;
}

int VideoTagInfo::get_tracknumber()
{
    return mTrackNumber;
}

tSize VideoTagInfo::get_width()
{
    return mWidth;
}

tSize VideoTagInfo::get_height()
{
    return mHeight;
}

float VideoTagInfo::get_level()
{
    return mLevel;
}

tFrameRate VideoTagInfo::get_framerate()
{
    return mFrameRate;
}

int VideoTagInfo::get_encrypted()
{
    return mEncrypted;
}

int VideoTagInfo::get_media_type()
{
    return mMediaType;
}

VideoTagInfo::~VideoTagInfo()
{

}

