#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/UTF8FileNameTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "FunctionTracer.h"
#include "Utf8FileName.h"
#include "UTF8FileNameTest.h"
#include "FastUTF8.h"

/*lint -save -e1773 */

// Registers the fixture into the 'registry'

void UTF8FileNameTest::setUp()
{
	ticks.begin();
}

void UTF8FileNameTest::tearDown()
{
	ticks.elapsed();
}

void UTF8FileNameTest::testParentDir()
{
    ENTRY_TEST

    UTF8FileName subpath ("/mnt/ccstg ");
    UTF8FileName path = subpath.getParentDir();
	
    //printf ("Log:: %s  --> sub_path %s\n", subpath.getCString(), path.getCString());

    bool bret = subpath.isChildOf (path);

    CPPUNIT_ASSERT(bret == true);
}

void UTF8FileNameTest::testParentDir2()
{
    ENTRY_TEST

    UTF8FileName subpath ("./mnt ");
    UTF8FileName path = subpath.getParentDir();
	
    //printf ("Log:: %s  --> sub_path %s\n", subpath.getCString(), path.getCString());

    bool bret = subpath.isChildOf (path);

    CPPUNIT_ASSERT(bret == true);
}

void UTF8FileNameTest::testAppendPath()
{
    ENTRY_TEST

    string spath("./mnt");
    UTF8FileName subpath (" ccstg ");
    UTF8FileName path (spath);
    subpath.appendPath(spath);

    //printf ("Log:: sub_path %s  --> path %s\n\n", subpath.getCString(), path.getCString());

    bool bret = subpath.isChildOf (path);

    CPPUNIT_ASSERT(bret == true);
}


void UTF8FileNameTest::testPureName()
{
    ENTRY_TEST

    UTF8FileName subpath (" /mnt/ccstg");
    UTF8FileName purname = subpath.getPureName();
	
    //printf ("Log:: %s  --> Pure Name %s\n", subpath.getCString(), purname.getCString());
	
    bool bret = (purname == UTF8FileName("ccstg"));

    CPPUNIT_ASSERT(bret == true);
}

void UTF8FileNameTest::testGetCString()
{
    ENTRY_TEST

    UTF8FileName path ("/mnt/ccstg");

    const char* pPath = path.getCString();

    UTF8FileName sec_path (pPath);

    //printf ("Log:: %s  == %s\n", path.getCString(), sec_path.getCString());

    bool bret = (path == sec_path);

    CPPUNIT_ASSERT(bret == true);
}

void UTF8FileNameTest::FastEndsWith()
{
	ENTRY_TEST

	FastUTF8::tStringBuffer UTF8Path[512];
	FastUTF8::tString UTF8Extension = (FastUTF8::tString)".mp3";
	FastUTF8::tString UTF8ExtensionFalse = (FastUTF8::tString)".mp1";
	FastUTF8::tString position;

#ifndef TARGET_BUILD
    strncpy_r(OUT (char *)UTF8Path, IN get_current_dir_name(), IN sizeof(UTF8Path));
    strncat_r(OUT (char *)UTF8Path, IN "Customer/Simulation/CustomControl/test/music/Grönemeyer - Anders/Herbert Grönemeyer - Nach Mir.mp3", IN sizeof(UTF8Path));
#else
    strncpy_r(OUT (char *)UTF8Path, IN "/opt/bosch/test/data/GMP/test/music/Grönemeyer - Anders/Herbert Grönemeyer - Nach Mir.mp3", IN sizeof(UTF8Path));
#endif

	/* has the path the extension? */
	position = FastUTF8::EndsWith(IN UTF8Path, IN UTF8Extension);
    CPPUNIT_ASSERT(position != NULL);

	/* has the path NOT the extension? */
	position = FastUTF8::EndsWith(IN UTF8Path, IN UTF8ExtensionFalse);
    CPPUNIT_ASSERT(position == NULL);
}

void UTF8FileNameTest::FastSplit()
{
    ENTRY_TEST

	FastUTF8::tStringBuffer UTF8Path[512];
	FastUTF8::tString fileName;
	FastUTF8::tString filePath;

#ifndef TARGET_BUILD
	strncpy_r(OUT (char *)UTF8Path, IN get_current_dir_name(), IN sizeof(UTF8Path));
	strncat_r(OUT (char *)UTF8Path, IN "Customer/Simulation/CustomControl/test/music/Grönemeyer - Anders/Herbert Grönemeyer - Nach Mir.mp3", IN sizeof(UTF8Path));
#else
	strncpy_r(OUT (char *)UTF8Path, IN "/opt/bosch/test/data/GMP/test/music/Grönemeyer - Anders/Herbert Grönemeyer - Nach Mir.mp3", IN sizeof(UTF8Path));
#endif

	filePath = FastUTF8::Split(OUT fileName, INOUT UTF8Path);
    CPPUNIT_ASSERT(!strcmp((const char *)fileName, "Herbert Grönemeyer - Nach Mir.mp3"));
    CPPUNIT_ASSERT(!strcmp((const char *)filePath, (const char *)UTF8Path)); // UTF8Path was modified by Split()

    strncpy_r(OUT (char *)UTF8Path, IN "1001_YBR_highest_quality", IN sizeof(UTF8Path));
    filePath = FastUTF8::Split(OUT fileName, INOUT UTF8Path);
    CPPUNIT_ASSERT(NULL == fileName);
}
