/*
 * StructTrace.cpp
 *
 *  Created on: Sep 20, 2012
 *      Author: tritonsu
 */


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VARIABLE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/VarTrace.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VARIABLE
#endif
#endif

#define MAXNAME 100

#include "VarTrace.h"
#include <string.h>

const char* removePath(const char *path)
{
    // search last '/'. if found return string after last '/' else return complete path
    char *filename = strrchr(const_cast<char*>(path), '/');
    if (filename)
        return filename+1;
    else
        return path;
}


void VarTrace(tClassType cls, const tMountPoint varA, const char *nameA, tDeviceID varB, const char *nameB, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "%50s: %50s, %50s: %d", nameA, varA, nameB, varB));
}

void VarTrace(tClassType cls, tPlaytime varA, const char *nameA, tPlaytime varB, const char *nameB, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "%50s: %d, %50s: %d", nameA, varA, nameB, varB));
}

void VarTrace(tClassType cls, tListID varA, const char *nameA, tIndex varB, const char *nameB, tPlaytime varC, const char *nameC, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "%50s: %d, %50s: %d, %50s: %d", nameA, varA, nameB, varB, nameC, varC));
}

void VarTrace(  tClassType cls,
                tDeviceType varA, const char *nameA,
                tDeviceID varB, const char *nameB,
                const tURL varC, const char *nameC,
                const tMountPoint varD, const char *nameD,
                const char *file, const int line)
{
    (void)nameA;
    (void)nameB;
    (void)nameC;
    (void)nameD;
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "StartPlaybackAction: (deviceType: %d, deviceID: %d, URL: %50s, mountPoint: %50s)", ETG_CENUM(tDeviceType,varA), varB, varC, varD));
}

void VarTrace(  tClassType cls,
                tPEPlaybackState varA, const char *nameA,
                const tMetadata varB, const char *nameB,
                const tMetadata varC, const char *nameC,
                const tMetadata varD, const char *nameD,
                const tMetadata varE, const char *nameE,
                tMediaType varF, const char *nameF,
                const char *file, const int line)
{
    (void)nameA;
    (void)nameB;
    (void)nameC;
    (void)nameD;
    (void)nameE;
    (void)nameF;
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "PlaybackStatusResponse: (playbackState: %d, %50s, %50s, %50s, %50s)", ETG_CENUM(tPEPlaybackState,varA), varB, varC, varD, varE));
    ETG_TRACE_USR3_DCL((cls, "PlaybackStatusResponse: (mediaType: %d)", ETG_CENUM(tMediaType,varF)));
}

void VarTrace(  tClassType cls,
                const tMetadata varA, const char *nameA,
                const tMetadata varB, const char *nameB,
                const tMetadata varC, const char *nameC,
                const tMetadata varD, const char *nameD,
                const tMetadata varE, const char *nameE,
                const char *file, const int line)
{
    (void)nameA;
    (void)nameB;
    (void)nameC;
    (void)nameD;
    (void)nameE;
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "Metadata: (%40s, %40s, %40s, %40s)", varA, varB, varC, varD));
    ETG_TRACE_USR3_DCL((cls, "Metadata: (%40s)", varE));
}


void VarTrace(tClassType cls, tDiPOLocationInfoType var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tDiPOLocationInfoType(%50s): %d,%d,%d,%d,%d,%d,%d", name, var.GPGGA, var.GPRMC, var.GPGSV, var.GPHDT, var.PASCD, var.PAGCD, var.PAACD));
}

void VarTrace(tClassType cls, tDiPOInitiateCall var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tDiPOInitiateCall(%50s): %d,%40s,%d,%40s", name, ETG_CENUM(tDiPOInitiateCallType,var.type), var.destinationID, ETG_CENUM(tDiPOInitiateCallSevice,var.service), var.addressBookID));
}

void VarTrace(tClassType cls, tDiPOAcceptCall var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tDiPOAcceptCall(%50s): %d,%40s", name, ETG_CENUM(tDiPOAcceptAction,var.acceptAction), var.callUUID));
}

void VarTrace(tClassType cls, tDiPOEndCall var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tDiPOEndCall(%50s): %d,%40s", name, ETG_CENUM(tDiPOEndAction,var.endAction), var.callUUID));
}

void VarTrace(tClassType cls, tBTProfile var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tBTProfile(%50s): %d,%d,%d,%d,%d", name, var.HandsFree, var.PhoneBookAccess, var.AudioVideoRemoteControl, var.AdvancedAudioDistribution, var.HumanInterfaceDevice));
    ETG_TRACE_USR3_DCL((cls, "tBTProfile(%50s): %d,%d,%d,%d", name, var.iAP2Link, var.PersonalAreaNetworkAccessPoint, var.MessageAccess, var.PersonalAreaNetworkClient));
}

void VarTrace(tClassType cls, tPEPosition var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tPEPosition(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tPEPosition(%s):", name));
        }
        VarTrace(cls, var.bytes, "tPEPosition.bytes");
        VarTrace(cls, var.pct, "tPEPosition.pct");
        VarTrace(cls, var.ms, "tPEPosition.ms");
    }
}

void VarTrace(tClassType cls, tPEDuration var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tPEDuration(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tPEDuration(%s):", name));
        }
        VarTrace(cls, var.bytes, "tPEDuration.bytes");
        VarTrace(cls, var.ms, "tPEDuration.ms");

    }
}

void VarTrace(tClassType cls, tPETimeInfoStruct var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tPETimeInfoStruct(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tPETimeInfoStruct(%s):", name));
        }
        VarTrace(cls, var.position, "tPETimeInfoStruct.position");
        VarTrace(cls, var.duration, "tPETimeInfoStruct.duration");
    }
}

void VarTrace(tClassType cls, tPlaybackMode var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaybackMode(%50s): %d [(%d)%s]", name, ETG_CENUM(tPlaybackMode,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaybackMode(%50s): %d", name, ETG_CENUM(tPlaybackMode,var)));
    }
}

void VarTrace(tClassType cls, tConnectionType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tConnectionType(%50s): %d [(%d)%s]", name, ETG_CENUM(tConnectionType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tConnectionType(%50s): %d", name, ETG_CENUM(tConnectionType,var)));
    }
}

void VarTrace(tClassType cls, tRepeatMode var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tRepeatMode(%50s): %d [(%d)%s]", name, ETG_CENUM(tRepeatMode,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tRepeatMode(%50s): %d", name, ETG_CENUM(tRepeatMode,var)));
    }
}

void VarTrace(tClassType cls, tIndexingState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tIndexingState(%50s): %d [(%d)%s]", name, ETG_CENUM(tIndexingState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tIndexingState(%50s): %d", name, ETG_CENUM(tIndexingState,var)));
    }
}

void VarTrace(tClassType cls, tConnectionState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tConnectionState(%50s): %d [(%d)%s]", name, ETG_CENUM(tConnectionState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tConnectionState(%50s): %d", name, ETG_CENUM(tConnectionState,var)));
    }
}

void VarTrace(tClassType cls, tListType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tListType(%50s): %d [(%d)%s]", name, ETG_CENUM(tListType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tListType(%50s): %d", name, ETG_CENUM(tListType,var)));
    }
}

void VarTrace(tClassType cls, tFileType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFileType(%50s): %d [(%d)%s]", name, ETG_CENUM(tFileType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFileType(%50s): %d", name, ETG_CENUM(tFileType,var)));
    }
}

void VarTrace(tClassType cls, tFileFormat var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFileFormat(%50s): %d [(%d)%s]", name, ETG_CENUM(tFileFormat,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFileFormat(%50s): %d", name, ETG_CENUM(tFileFormat,var)));
    }
}

void VarTrace(tClassType cls, tCategoryType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tCategoryType(%50s): %d [(%d)%s]", name, ETG_CENUM(tCategoryType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tCategoryType(%50s): %d", name, ETG_CENUM(tCategoryType,var)));
    }
}

void VarTrace(tClassType cls, tPlaybackAction var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaybackAction(%50s): %d [(%d)%s]", name, ETG_CENUM(tPlaybackAction,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaybackAction(%50s): %d", name, ETG_CENUM(tPlaybackAction,var)));
    }
}

void VarTrace(tClassType cls, tHMIPlaybackState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tHMIPlaybackState(%50s): %d [(%d)%s]", name, ETG_CENUM(tHMIPlaybackState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tHMIPlaybackState(%50s): %d", name, ETG_CENUM(tHMIPlaybackState,var)));
    }
}

void VarTrace(tClassType cls, tNowPlayingState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tNowPlayingState(%50s): %d [(%d)%s]", name, ETG_CENUM(tNowPlayingState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tNowPlayingState(%50s): %d", name, ETG_CENUM(tNowPlayingState,var)));
    }
}

void VarTrace(tClassType cls, tPlaypointFormat var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaypointFormat(%50s): %d [(%d)%s]", name, ETG_CENUM(tPlaypointFormat,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPlaypointFormat(%50s): %d", name, ETG_CENUM(tPlaypointFormat,var)));
    }
}

void VarTrace(tClassType cls, tListChangeType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tListChangeType(%50s): %d [(%d)%s]", name, ETG_CENUM(tListChangeType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tListChangeType(%50s): %d", name, ETG_CENUM(tListChangeType,var)));
    }
}

void VarTrace(tClassType cls, tSourceActivity var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tSourceActivity(%50s): %d [(%d)%s]", name, ETG_CENUM(tSourceActivity,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tSourceActivity(%50s): %d", name, ETG_CENUM(tSourceActivity,var)));
    }
}

void VarTrace(tClassType cls, tMediaType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tMediaType(%50s): %d [(%d)%s]", name, ETG_CENUM(tMediaType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tMediaType(%50s): %d", name, ETG_CENUM(tMediaType,var)));
    }
}

void VarTrace(tClassType cls, tDeviceType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tDeviceType(%50s): %d [(%d)%s]", name, ETG_CENUM(tDeviceType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tDeviceType(%50s): %d", name, ETG_CENUM(tDeviceType,var)));
    }
}

void VarTrace(tClassType cls, tTagTransferStatus var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tTagTransferStatus(%50s): %d [(%d)%s]", name, ETG_CENUM(tTagTransferStatus,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tTagTransferStatus(%50s): %d", name, ETG_CENUM(tTagTransferStatus,var)));
    }
}

void VarTrace(tClassType cls, tLogicalAVChannel var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tLogicalAVChannel(%50s): %d [(%d)%s]", name, ETG_CENUM(tLogicalAVChannel,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tLogicalAVChannel(%50s): %d", name, ETG_CENUM(tLogicalAVChannel,var)));
    }
}

void VarTrace(tClassType cls, tLanguageType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tLanguageType(%50s): %d [(%d)%s]", name, ETG_CENUM(tLanguageType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tLanguageType(%50s): %d", name, ETG_CENUM(tLanguageType,var)));
    }
}

void VarTrace(tClassType cls, tDMConnectStatus var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tDMConnectStatus(%50s): %d [(%d)%s]", name, ETG_CENUM(tDMConnectStatus,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tDMConnectStatus(%50s): %d", name, ETG_CENUM(tDMConnectStatus,var)));
    }
}

void VarTrace(tClassType cls, tMimeType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tMimeType(%50s): %d [(%d)%s]", name, ETG_CENUM(tMimeType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tMimeType(%50s): %d", name, ETG_CENUM(tMimeType,var)));
    }
}

void VarTrace(tClassType cls, tViewStatus var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tViewStatus(%50s): %d [(%d)%s]", name, ETG_CENUM(tViewStatus,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tViewStatus(%50s): %d", name, ETG_CENUM(tViewStatus,var)));
    }
}

void VarTrace(tClassType cls, tPlayContinuation var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPlayContinuation(%50s): %d [(%d)%s]", name, ETG_CENUM(tPlayContinuation,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPlayContinuation(%50s): %d", name, ETG_CENUM(tPlayContinuation,var)));
    }
}

void VarTrace(tClassType cls, tComponentID var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tComponentID(%50s): %d [(%d)%s]", name, ETG_CENUM(tComponentID,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tComponentID(%50s): %d", name, ETG_CENUM(tComponentID,var)));
    }
}

void VarTrace(tClassType cls, tComponentState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tComponentState(%50s): %d [(%d)%s]", name, ETG_CENUM(tComponentState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tComponentState(%50s): %d", name, ETG_CENUM(tComponentState,var)));
    }
}

void VarTrace(tClassType cls, tPositionInList var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPositionInList(%50s): %d [(%d)%s]", name, ETG_CENUM(tPositionInList,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPositionInList(%50s): %d", name, ETG_CENUM(tPositionInList,var)));
    }
}

void VarTrace(tClassType cls, tPEPlaybackState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPEPlaybackState(%50s): %d [(%d)%s]", name, ETG_CENUM(tPEPlaybackState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPEPlaybackState(%50s): %d", name, ETG_CENUM(tPEPlaybackState,var)));
    }
}

void VarTrace(tClassType cls, tPEErrorCode var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tPEErrorCode(%50s): %d [(%d)%s]", name, ETG_CENUM(tPEErrorCode,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tPEErrorCode(%50s): %d", name, ETG_CENUM(tPEErrorCode,var)));
    }
}

void VarTrace(tClassType cls, tFingerprintStatus var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFingerprintStatus(%50s): %d [(%d)%s]", name, ETG_CENUM(tFingerprintStatus,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFingerprintStatus(%50s): %d", name, ETG_CENUM(tFingerprintStatus,var)));
    }
}

void VarTrace(tClassType cls, tMetadataStatus var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tMetadataStatus(%50s): %d [(%d)%s]", name, ETG_CENUM(tMetadataStatus,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tMetadataStatus(%50s): %d", name, ETG_CENUM(tMetadataStatus,var)));
    }
}

void VarTrace(tClassType cls, tNoObjectReason var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tNoObjectReason(%50s): %d [(%d)%s]", name, ETG_CENUM(tNoObjectReason,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tNoObjectReason(%50s): %d", name, ETG_CENUM(tNoObjectReason,var)));
    }
}

void VarTrace(tClassType cls, tIndexingMode var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tIndexingMode(%50s): %d [(%d)%s]", name, ETG_CENUM(tIndexingMode,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tIndexingMode(%50s): %d", name, ETG_CENUM(tIndexingMode,var)));
    }
}

void VarTrace(tClassType cls, tMuteState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tMuteState(%50s): %d [(%d)%s]", name, ETG_CENUM(tMuteState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tMuteState(%50s): %d", name, ETG_CENUM(tMuteState,var)));
    }
}

void VarTrace(tClassType cls, tDeviceState var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tDeviceState(%50s): %d [(%d)%s]", name, ETG_CENUM(tDeviceState,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tDeviceState(%50s): %d", name, ETG_CENUM(tDeviceState,var)));
    }
}

void VarTrace(tClassType cls, tFileSystemType var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFileSystemType(%50s): %d [(%d)%s]", name, ETG_CENUM(tFileSystemType,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFileSystemType(%50s): %d", name, ETG_CENUM(tFileSystemType,var)));
    }
}

void VarTrace(tClassType cls, tDiPOCaps var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tDiPOCaps(%50s): %d [(%d)%s]", name, ETG_CENUM(tDiPOCaps,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tDiPOCaps(%50s): %d", name, ETG_CENUM(tDiPOCaps,var)));
    }
}

void VarTrace(tClassType cls, tDisconnectReason var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tDisconnectReason(%50s): %d [(%d)%s]", name, ETG_CENUM(tDisconnectReason,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tDisconnectReason(%50s): %d", name, ETG_CENUM(tDisconnectReason,var)));
    }
}

void VarTrace(tClassType cls, tNotPlayable var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tNotPlayable(%50s): %d [(%d)%s]", name, ETG_CENUM(tNotPlayable,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tNotPlayable(%50s): %d", name, ETG_CENUM(tNotPlayable,var)));
    }
}

void VarTrace(tClassType cls, tError var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tError(%50s): %d [(%d)%s]", name, ETG_CENUM(tError,var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tError(%50s): %d", name, ETG_CENUM(tError,var)));
    }
}

void VarTrace(tClassType cls, tFilterTag1 var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag1(%50s): %d [(%d)%s]", name, var.tag,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag1(%50s): %d", name, var.tag));
    }
}

void VarTrace(tClassType cls, tFilterTag2 var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag2(%50s): %d [(%d)%s]", name, var.tag,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag2(%50s): %d", name, var.tag));
    }
}

void VarTrace(tClassType cls, tFilterTag3 var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag3(%50s): %d [(%d)%s]", name, var.tag,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag3(%50s): %d", name, var.tag));
    }
}

void VarTrace(tClassType cls, tFilterTag4 var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag4(%50s): %d [(%d)%s]", name, var.tag,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tFilterTag4(%50s): %d", name, var.tag));
    }
}

void VarTrace(tClassType cls, const char* var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "char*(%100s): %100s [(%d)%s]", name, CHECK_NULL(var),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "char*(%50s): %s", name, CHECK_NULL(var)));
    }
}

void VarTrace(tClassType cls, unsigned char* var, const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned char*(%50s): %50s [(%d)%s]", name, CHECK_NULL((char*) var), line, removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned char*(%50s): %s", name, CHECK_NULL((char*) var)));
    }
}


void VarTrace(tClassType cls, unsigned int var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %d [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %d", name, var));
    }
}

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT // todo: first attemp: must be changed for target linux 64 bit compiler
void VarTrace(tClassType cls, size_t var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %d [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %d", name, var));
    }
}
#endif

void VarTrace(tClassType cls, int var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "int(%50s): %d [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "int(%50s): %d", name, var));
    }
}

void VarTrace(tClassType cls, float var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %f [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned int(%50s): %f", name, var));
    }
}

void VarTrace(tClassType cls, char var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "char(%50s): %d [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "char(%50s): %d", name, var));
    }
}

void VarTrace(tClassType cls, unsigned char var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned char(%50s): %u [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned char(%50s): %u", name, var));
    }
}


void VarTrace(tClassType cls, short var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "short(%50s): %d [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "short(%50s): %d", name, var));
    }
}

void VarTrace(tClassType cls, unsigned short var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned short(%50s): %u [(%d)%s]", name, var,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned short(%50s): %u", name, var));
    }
}

void VarTrace(tClassType cls, long long var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "long long(%50s): 0x%08x%08x [(%d)%s]", name, (int)((unsigned long long)var>>32), (int)(var&0xffffffff),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "long long(%50s): 0x%08x%08x ", name, (int)((unsigned long long)var>>32), (int)(var&0xffffffff)));
    }
}

void VarTrace(tClassType cls, long int var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "long int(%50s): 0x%08x%08x [(%d)%s]", name, (int)((unsigned long long)var>>32), (int)(var&0xffffffff),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "long int(%50s): 0x%08x%08x ", name, (int)((unsigned long long)var>>32), (int)(var&0xffffffff)));
    }
}

void VarTrace(tClassType cls, unsigned long long var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned long long(%50s): 0x%08x%08x [(%d)%s]", name, (int)(var>>32), (int)(var&0xffffffff),line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "unsigned long long(%50s):  0x%08x%08x ", name, (int)(var>>32), (int)(var&0xffffffff)));
    }
}


#ifndef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT // todo: make the following only available in 32-bit builds to solve ambiguities
// Ch. Simon-Klar: the following line does not compile in 64 enviroments
void VarTrace(tClassType cls, unsigned long var,const char *name, const char *file, const int line)
{

    if (file != NULL && line != -1)
    {
        //typecasting  var to unsigned long long to avoid compiler warning.
        ETG_TRACE_USR3_DCL((cls, "unsigned long(%50s): 0x%08x%08x [(%d)%s]", name, (unsigned long long)(var)>>32, (int)(var&0xffffffff),line,removePath(file)));
    }
    else
    {
        //typecasting var to unsigned long long to avoid compiler warning.
        ETG_TRACE_USR3_DCL((cls, "unsigned long(%50s):  0x%08x%08x ", name, (unsigned long long)(var)>>32, (int)(var&0xffffffff)));
    }
}
#endif

void VarTrace(tClassType cls, tAlbumArtObject var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tAlbumArtObject(%50s): [(%d)%s]", name,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tAlbumArtObject(%s):", name));
    }
    VarTrace(cls, var.albumArtString, "tAlbumArtObject.albumArtString");
    VarTrace(cls, var.mimeType, "tAlbumArtObject.mimeType");
    VarTrace(cls, var.sizeX, "tAlbumArtObject.sizeX");
    VarTrace(cls, var.sizeY, "tAlbumArtObject.sizeY");
    VarTrace(cls, var.imageSize, "tAlbumArtObject.imageSize");
}

void VarTrace(tClassType cls, tDeviceInfo var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDeviceInfo(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDeviceInfo(%s):", name));
        }

        VarTrace(cls, var.deviceID, "tDeviceInfo.deviceID");
        //VarTrace(cls, var.UUID, "tDeviceInfo.UUID");
        VarTrace(cls, var.serialNumber, "tDeviceInfo.serialNumber");
        //VarTrace(cls, var.deviceVersion, "tDeviceInfo.deviceVersion");
        VarTrace(cls, var.deviceName, "tDeviceInfo.deviceName");
        VarTrace(cls, var.mountPoint, "tDeviceInfo.mountPoint");
        //VarTrace(cls, var.connectionCount, "tDeviceInfo.connectionCount");
        VarTrace(cls, var.activeSource, "tDeviceInfo.activeSource");
        VarTrace(cls, var.deviceType, "tDeviceInfo.deviceType");
        VarTrace(cls, var.connectionType, "tDeviceInfo.connectionType");
        VarTrace(cls, var.indexedState, "tDeviceInfo.indexedState");
        VarTrace(cls, var.connectionState, "tDeviceInfo.connectionState");
        VarTrace(cls, var.accessoryName, "tDeviceInfo.accessoryName");
        VarTrace(cls, var.deviceState, "tDeviceInfo.deviceState");
        VarTrace(cls, var.fileSystemType, "tDeviceInfo.fileSystemType");
        VarTrace(cls, var.partitionNumber, "tDeviceInfo.partitionNumber");
        VarTrace(cls, var.totalSize, "tDeviceInfo.totalSize");
        VarTrace(cls, var.freeSize, "tDeviceInfo.freeSize");
        VarTrace(cls, var.numberOfAudioFiles, "tDeviceInfo.numberOfAudioFiles");
        VarTrace(cls, var.numberOfVideoFiles, "tDeviceInfo.numberOfVideoFiles");
       VarTrace(cls, var.numberOfImageFiles, "tDeviceInfo.numberOfImageFiles");
        //VarTrace(cls, var.productID, "tDeviceInfo.productID");
        VarTrace(cls, var.diPOCaps, "tDeviceInfo.diPOCaps");
        VarTrace(cls, var.diPOActive, "tDeviceInfo.diPOActive");
        VarTrace(cls, var.diPOVersion, "tDeviceInfo.diPOVersion");
        VarTrace(cls, var.lastPlayedFile, "tDeviceInfo.lastPlayedFile");
        VarTrace(cls, var.connected, "tDeviceInfo.connected");
        VarTrace(cls, var.disconnectReason, "tDeviceInfo.disconnectReason");
        VarTrace(cls, var.isShuffleSupported, "tDeviceInfo.isShuffleSupported");
        VarTrace(cls, var.isRepeatSupported, "tDeviceInfo.isRepeatSupported");
        VarTrace(cls, var.isNowPlayingListAvailable, "tDeviceInfo.isNowPlayingListAvailable");
        VarTrace(cls, var.deviceUUID, "tDeviceInfo.deviceUUID");
        VarTrace(cls, var.appleDeviceMACAddress, "tDeviceInfo.appleDeviceMACAddress");
        VarTrace(cls, var.appleDeviceUSBSerialNumber, "tDeviceInfo.appleDeviceUSBSerialNumber");
        VarTrace(cls, var.discType, "tDeviceInfo.tDiscType");
    }
}

void VarTraceMin(tClassType cls, tDeviceInfo var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tDeviceInfo(%50s):(deviceID: %d, deviceName: %50s, mountPoint: %50s, activeSource: %d, deviceType: %d)",
        name,
        var.deviceID,
        var.deviceName,
        var.mountPoint,
        var.activeSource,
        ETG_CENUM(tDeviceType,var.deviceType)));
    ETG_TRACE_USR3_DCL((cls, "tDeviceInfo(%50s):connectionType: %d)",
        name,
        ETG_CENUM(tConnectionType,var.connectionType)));

}


void VarTrace(tClassType cls, vector<tDeviceInfo> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDeviceInfo>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDeviceInfo>(%s):", name));
        }
        vector<tDeviceInfo>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}


void VarTrace(tClassType cls, tDeviceProperty var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDeviceProperty(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDeviceProperty(%s):", name));
        }
        VarTrace(cls, var.serialNumber, "tDeviceProperty.serialNumber");
        VarTrace(cls, var.USBPortNumber, "tDeviceProperty.USBPortNumber");
        VarTrace(cls, var.deviceType, "tDeviceProperty.deviceType");
        VarTrace(cls, var.connectionType, "tDeviceProperty.connectionType");
        VarTrace(cls, var.deviceVersion, "tDeviceProperty.deviceVersion");
        VarTrace(cls, var.deviceName, "tDeviceProperty.deviceName");
        VarTrace(cls, var.accessoryName, "tDeviceProperty.accessoryName");
        VarTrace(cls, var.mountPoint, "tDeviceProperty.mountPoint");
        VarTrace(cls, var.connectStatus, "tDeviceProperty.connectStatus");
        VarTrace(cls, var.sizeInByte, "tDeviceProperty.sizeInByte");
        VarTrace(cls, var.vendorID, "tDeviceProperty.vendorID");
        VarTrace(cls, var.manufacturer, "tDeviceProperty.manufacturer");
        VarTrace(cls, var.productID, "tDeviceProperty.productID");
        VarTrace(cls, var.totalSizekB, "tDeviceProperty.totalSizekB");
        VarTrace(cls, var.usedSizekB, "tDeviceProperty.usedSizekB");
        VarTrace(cls, var.freeSizekB, "tDeviceProperty.freeSizekB");
        VarTrace(cls, var.partitionNumber, "tDeviceProperty.partitionNumber");
        VarTrace(cls, var.fileSystemType, "tDeviceProperty.fileSystemType");
        VarTrace(cls, var.deviceSpeed, "tDeviceProperty.deviceSpeed");
        VarTrace(cls, var.protocolUsb, "tDeviceProperty.protocolUsb");
        VarTrace(cls, var.baseClassCodeUsb, "tDeviceProperty.baseClassCodeUsb");
        VarTrace(cls, var.subBaseClassCodeUsb, "tDeviceProperty.subBaseClassCodeUsb");
    }
}


void VarTrace(tClassType cls, vector<tDeviceProperty> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDeviceProperty>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDeviceProperty>(%s):", name));
        }
        vector<tDeviceProperty>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tMediaObjectInfo var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tMediaObjectInfo(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tMediaObjectInfo(%s):", name));
        }
        VarTrace(cls, var.ObjectValid, "tMediaObjectInfo.ObjectValid");
        VarTrace(cls, var.ObjectInvalid, "tMediaObjectInfo.ObjectInvalid");
        VarTrace(cls, var.ListInvalid, "tMediaObjectInfo.ListInvalid");
        VarTrace(cls, var.PositionInvalid, "tMediaObjectInfo.PositionInvalid");
        VarTrace(cls, var.GeneralError, "tMediaObjectInfo.GeneralError");
    }
}

void VarTrace(tClassType cls, tFiles var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tFiles(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tFiles(%s):", name));
        }
        VarTrace(cls, var.type, "tFiles.type");
        VarTrace(cls, var.trackNumber, "tFiles.trackNumber");
        VarTrace(cls, var.objectID, "tFiles.objectID");
        VarTrace(cls, var.fileName, "tFiles.fileName");
        VarTrace(cls, var.fileFormat, "tFiles.fileFormat");
        VarTrace(cls, var.isPlaying, "tFiles.isPlaying");
        VarTrace(cls, var.notPlayable, "tFiles.notPlayable");
        VarTrace(cls, var.readOnlyFlag, "tFiles.readOnlyFlag");
        VarTrace(cls, var.playTime, "tFiles.playTime");
        VarTrace(cls, var.fileSize, "tFiles.fileSize");
        VarTrace(cls, var.dateTime, "tFiles.dateTime");
        VarTrace(cls, var.coverArtString, "tFiles.coverArtString");

    }
}

void VarTraceMin(tClassType cls, tFiles var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tFiles(%50s): (type: %d, fileName: %50s, fileFormat: %d)",
        name,
        ETG_CENUM(tFileType,var.type),
        var.fileName,
        ETG_CENUM(tFileFormat,var.fileFormat)));
}

void VarTrace(tClassType cls, vector<tFiles> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tFiles>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tFiles>(%s):", name));
        }
        vector<tFiles>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tSearchKeyboard var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tSearchKeyboard(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tSearchKeyboard(%s):", name));
        }
        VarTrace(cls, var.letter, "tSearchKeyboard.letter");
        VarTrace(cls, var.available, "tSearchKeyboard.available");
        VarTrace(cls, var.startIndex, "tSearchKeyboard.startIndex");
        VarTrace(cls, var.endIndex, "tSearchKeyboard.endIndex");
    }
}

void VarTrace(tClassType cls, vector<tSearchKeyboard> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tSearchKeyboard>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tSearchKeyboard>(%s):", name));
        }
        vector<tSearchKeyboard>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tListInfo var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tListInfo(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tListInfo(%s):", name));
        }
        VarTrace(cls, var.listID, "tListInfo.listID");
        VarTrace(cls, var.parent, "tListInfo.parent");
        VarTrace(cls, var.next, "tListInfo.next");
        VarTrace(cls, var.listType, "tListInfo.listType");
        VarTrace(cls, var.streaming, "tListInfo.streaming");
        VarTrace(cls, var.listSize, "tListInfo.listSize");
        VarTrace(cls, var.deviceID, "tListInfo.deviceID");
        VarTrace(cls, var.playContinuation, "tListInfo.playContinuation");
        VarTrace(cls, var.filterTag1, "tListInfo.filterTag1");
        VarTrace(cls, var.filterTag2, "tListInfo.filterTag2");
        VarTrace(cls, var.filterTag3, "tListInfo.filterTag3");
        VarTrace(cls, var.filterTag4, "tListInfo.filterTag4");
    }
}

void VarTraceMin(tClassType cls, tListInfo var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tListInfo(%50s):(listID: %d, type: %d, listSize: %d, deviceID: %d, streaming: %d)",
        name,
        var.listID,
        ETG_CENUM(tListType,var.listType),
        var.listSize,
        var.deviceID,
        var.streaming));
}

void VarTrace(tClassType cls, tMediaObject var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tMediaObject(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tMediaObject(%s):", name));
        }
        VarTrace(cls, var.albumArtString, "tMediaObject.albumArtString");
        VarTrace(cls, var.catType, "tMediaObject.catType");
        VarTrace(cls, var.deviceID, "tMediaObject.deviceID");
        VarTrace(cls, var.deviceType, "tMediaObject.deviceType");
        VarTrace(cls, var.deviceVersion, "tMediaObject.deviceVersion");
        VarTrace(cls, var.fileFormat, "tMediaObject.fileFormat");
        VarTrace(cls, var.fileName, "tMediaObject.fileName");
        VarTrace(cls, var.isPlaying, "tMediaObject.isPlaying");
        VarTrace(cls, var.mediaType, "tMediaObject.mediaType");
        VarTrace(cls, var.MetadataField1, "tMediaObject.MetadataField1");
        VarTrace(cls, var.MetadataField2, "tMediaObject.MetadataField2");
        VarTrace(cls, var.MetadataField3, "tMediaObject.MetadataField3");
        VarTrace(cls, var.MetadataField4, "tMediaObject.MetadataField4");
        VarTrace(cls, var.MetadataTag1, "tMediaObject.MetadataTag1");
        VarTrace(cls, var.MetadataTag2, "tMediaObject.MetadataTag2");
        VarTrace(cls, var.MetadataTag3, "tMediaObject.MetadataTag3");
        VarTrace(cls, var.MetadataTag4, "tMediaObject.MetadataTag4");
        VarTrace(cls, var.title, "tMediaObject.title");
        VarTrace(cls, var.objectID, "tMediaObject.objectID");
        VarTrace(cls, var.year, "tMediaObject.year");
        VarTrace(cls, var.yearID, "tMediaObject.yearID");
        VarTrace(cls, var.totalPlaytime, "tMediaObject.totalPlaytime");
        VarTrace(cls, var.trackNumber, "tMediaObject.trackNumber");
        VarTrace(cls, var.mountPoint, "tMediaObject.mountPoint");
        VarTrace(cls, var.fileType, "tMediaObject.fileType");
        VarTrace(cls, var.UUID, "tMediaObject.UUID");
        VarTrace(cls, var.active, "tMediaObject.active");
        VarTrace(cls, var.path, "tMediaObject.path");
        VarTrace(cls, var.notPlayable, "tMediaObject.notPlayable");
        VarTrace(cls, var.fileSize, "tMediaObject.fileSize");
        VarTrace(cls, var.dateTime, "tMediaObject.dateTime");
        VarTrace(cls, var.isFavorite, "tMediaObject.isFavorite");
        VarTrace(cls, var.coverArtString, "tMediaObject.coverArtString");
    }
}

void VarTraceMin(tClassType cls, tMediaObject var,const char *name, const char *file, const int line)
{
    (void)file;
    (void)line;
    ETG_TRACE_USR3_DCL((cls, "tMediaObject(%50s):(catType: %d, deviceID: %d, fileName: %50s, title: %50s, objectID: %d)",
        name,
        ETG_CENUM(tCategoryType,var.catType),
        var.deviceID,
        var.fileName,
        var.title,
        var.objectID));
}

void VarTrace(tClassType cls, vector<tMediaObject> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tMediaObject>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tMediaObject>(%s):", name));
        }
        vector<tMediaObject>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tNowPlaying var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tNowPlaying(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tNowPlaying(%s):", name));
        }
        VarTrace(cls, var.listID, "tNowPlaying.listID");
        VarTrace(cls, var.state, "tNowPlaying.state");
        VarTrace(cls, var.position, "tNowPlaying.position");
        VarTrace(cls, var.objectID, "tNowPlaying.objectID");
        VarTrace(cls, var.object, "tNowPlaying.object");
    }
}

void VarTrace(tClassType cls, tDiPONowPlaying var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPONowPlaying(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPONowPlaying(%s):", name));
        }
        VarTrace(cls, var.title, "tDiPONowPlaying.title");
        VarTrace(cls, var.artist, "tDiPONowPlaying.artist");
        VarTrace(cls, var.album, "tDiPONowPlaying.album");
        VarTrace(cls, var.genre, "tDiPONowPlaying.genre");
        VarTrace(cls, var.composer, "tDiPONowPlaying.composer");
        VarTrace(cls, var.albumArt, "tDiPONowPlaying.albumArt");
        VarTrace(cls, var.appName, "tDiPONowPlaying.appName");
        VarTrace(cls, var.albumTrackNumber, "tDiPONowPlaying.albumTrackNumber");
        VarTrace(cls, var.albumTrackCount, "tDiPONowPlaying.albumTrackCount");
        VarTrace(cls, var.albumDiscNumber, "tDiPONowPlaying.albumDiscNumber");
        VarTrace(cls, var.albumDiscCount, "tDiPONowPlaying.albumDiscCount");
        VarTrace(cls, var.chapterCount, "tDiPONowPlaying.chapterCount");
        VarTrace(cls, (int)var.queueIndex, "tDiPONowPlaying.queueIndex");
        VarTrace(cls, (int)var.queueCount, "tDiPONowPlaying.queueCount");
        VarTrace(cls, (int)var.queueChapterIndex, "tDiPONowPlaying.queueChapterIndex");
        VarTrace(cls, var.iTunesRadioAd, "tDiPONowPlaying.iTunesRadioAd");
        VarTrace(cls, var.iTunesRadioStationName, "tDiPONowPlaying.iTunesRadioStationName");
    }
}

void VarTrace(tClassType cls, tDiPOCallStateItem var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOCallStateItem(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOCallStateItem(%s):", name));
        }
        VarTrace(cls, var.remoteID, "tDiPOCallStateItem.remoteID");
        VarTrace(cls, var.displayName, "tDiPOCallStateItem.displayName");
        VarTrace(cls, (int)var.status, "tDiPOCallStateItem.status");
        VarTrace(cls, (int)var.direction, "tDiPOCallStateItem.direction");
        VarTrace(cls, var.callUUID, "tDiPOCallStateItem.callUUID");
        VarTrace(cls, var.addressBookID, "tDiPOCallStateItem.addressBookID");
        VarTrace(cls, var.label, "tDiPOCallStateItem.label");
        VarTrace(cls, (int)var.service, "tDiPOCallStateItem.service");
        VarTrace(cls, var.isConferenced, "tDiPOCallStateItem.isConferenced");
        VarTrace(cls, var.conferenceGroup, "tDiPOCallStateItem.conferenceGroup");
        VarTrace(cls, (int)var.disconnectReason, "tDiPOCallStateItem.disconnectReason");
    }
}

void VarTrace(tClassType cls, tDiPOCommunications var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOCommunications(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOCommunications(%s):", name));
        }
        VarTrace(cls, (int)var.signalStrength, "tDiPOCommunications.signalStrength");
        VarTrace(cls, (int)var.registrationStatus, "tDiPOCommunications.registrationStatus");
        VarTrace(cls, var.airplaneModeStatus, "tDiPOCommunications.airplaneModeStatus");
        VarTrace(cls, var.carrierName, "tDiPOCommunications.carrierName");
        VarTrace(cls, var.cellularSupported, "tDiPOCommunications.cellularSupported");
        VarTrace(cls, var.telephonyEnabled, "tDiPOCommunications.telephonyEnabled");
        VarTrace(cls, var.faceTimeAudioEnabled, "tDiPOCommunications.faceTimeAudioEnabled");
        VarTrace(cls, var.faceTimeVideoEnabled, "tDiPOCommunications.faceTimeVideoEnabled");
        VarTrace(cls, var.muteStatus, "tDiPOCommunications.muteStatus");
        VarTrace(cls, var.currentCallCount, "tDiPOCommunications.currentCallCount");
        VarTrace(cls, var.newVoicemailCount, "tDiPOCommunications.newVoicemailCount");
        VarTrace(cls, var.initiateCallAvalable, "tDiPOCommunications.initiateCallAvalable");
        VarTrace(cls, var.endAndAcceptAvailable, "tDiPOCommunications.endAndAcceptAvailable");
        VarTrace(cls, var.holdAndAcceptAvailable, "tDiPOCommunications.holdAndAcceptAvailable");
        VarTrace(cls, var.swapAvailable, "tDiPOCommunications.swapAvailable");
        VarTrace(cls, var.mergeAvailable, "tDiPOCommunications.mergeAvailable");
        VarTrace(cls, var.holdAvailable, "tDiPOCommunications.holdAvailable");
    }
}

void VarTrace(tClassType cls, tUserContext var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tUserContext(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tUserContext(%s):", name));
        }
        VarTrace(cls, var.sourceAppID, "tUserContext.sourceAppID");
        VarTrace(cls, var.registerID, "tUserContext.registerID");
        VarTrace(cls, var.cmdCounter, "tUserContext.cmdCounter");
        VarTrace(cls, var.functionID, "tUserContext.functionID");
        VarTrace(cls, var.serviceID, "tUserContext.serviceID");
    }
}


void VarTrace(tClassType cls, tIndexingStateResult var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tIndexingStateResult(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tIndexingStateResult(%s):", name));
        }
        VarTrace(cls, var.deviceID, "tIndexingStateResult.deviceID");
        VarTrace(cls, var.percent, "tIndexingStateResult.percent");
        VarTrace(cls, var.state, "tIndexingStateResult.state");
    }
}

void VarTrace(tClassType cls, vector <tIndexingStateResult> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tIndexingStateResult>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tIndexingStateResult>(%s):", name));
        }
        vector<tIndexingStateResult>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }

}

void VarTrace(tClassType cls, vector <tUInt> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tUInt>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tUInt>(%s):", name));
        }
        vector<tUInt>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }

}

void VarTrace(tClassType cls, tFavoriteInfo var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tFavoritesInfo(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tFavoritesInfo(%s):", name));
        }
        VarTrace(cls, var.active, "tFavoritesInfo.active");
        VarTrace(cls, var.available, "tFavoritesInfo.available");
        VarTrace(cls, var.descriptorText, "tFavoritesInfo.descriptorText");
        VarTrace(cls, var.favoriteId, "tFavoritesInfo.favoriteId");
        VarTrace(cls, var.labelText, "tFavoritesInfo.labelText");
        VarTrace(cls, var.objectID, "tFavoritesInfo.objectID");
        VarTrace(cls, var.objectType, "tFavoritesInfo.objectType");
    }
}

void VarTrace(tClassType cls, vector<tFavoriteInfo> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tFavoriteInfo>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tFavoriteInfo>(%s):", name));
        }
        vector<tFavoriteInfo>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tTagTransfer var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tTagTransfer(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tTagTransfer(%s):", name));
        }
        VarTrace(cls, var.ambiguousTag, "tTagTransfer.ambiguousTag");
        VarTrace(cls, var.buttonPressed, "tTagTransfer.buttonPressed");
        VarTrace(cls, var.tagTrackName, "tTagTransfer.tagTrackName");
        VarTrace(cls, var.tagArtistName, "tTagTransfer.tagArtistName");
        VarTrace(cls, var.tagAlbumName, "tTagTransfer.tagAlbumName");
        VarTrace(cls, var.tagGenreName, "tTagTransfer.tagGenreName");
        VarTrace(cls, var.tagSongID, "tTagTransfer.tagSongID");
        VarTrace(cls, var.tagStorefrontID, "tTagTransfer.tagStorefrontID");
        VarTrace(cls, var.tagChannelNumber, "tTagTransfer.tagChannelNumber");
        VarTrace(cls, var.tagChannelName, "tTagTransfer.tagChannelName");
        VarTrace(cls, var.tagTimeStamp, "tTagTransfer.tagTimeStamp");
        VarTrace(cls, var.podcastFeedURL, "tTagTransfer.podcastFeedURL");
        VarTrace(cls, var.stationURL, "tTagTransfer.stationURL");
        VarTrace(cls, var.tagProgramNumber, "tTagTransfer.tagProgramNumber");
        VarTrace(cls, var.tagAffiliateID, "tTagTransfer.tagAffiliateID");
        VarTrace(cls, var.unknownDataSize, "tTagTransfer.unknownDataSize");
        VarTrace(cls, var.stationURLFrequency, "tTagTransfer.stationURLFrequency");
    }
}

void VarTrace(tClassType cls, vector <tTagTransfer> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tTagTransfer>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tTagTransfer>(%s):", name));
        }
        vector<tTagTransfer>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tUntransferredTag var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tUntransferredTag(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tUntransferredTag(%s):", name));
        }
        VarTrace(cls, var.tagSongID, "tTagTransfer.tagSongID");
        VarTrace(cls, var.tagArtistName, "tTagTransfer.tagArtistName");
        VarTrace(cls, var.tagTrackName, "tTagTransfer.tagTrackName");
    }
}

void VarTrace(tClassType cls, vector <tUntransferredTag> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tUntransferredTag>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tUntransferredTag>(%s):]", name));
        }
        vector<tUntransferredTag>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls, tNowShowing var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tNowShowing(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tNowShowing(%s):", name));
        }
        VarTrace(cls, var.listID, "tNowShowing.listID");
        VarTrace(cls, var.state, "tNowShowing.state");
        VarTrace(cls, var.position, "tNowShowing.position");
        VarTrace(cls, var.object, "tNowPlaying.object");
        VarTrace(cls, var.nextFile, "tNowShowing.nextFile");
    }
}

void VarTrace(tClassType cls, me::vprops_t var,const char *name, const char *file, const int line)
{
    if (file != NULL && line != -1)
    {
        ETG_TRACE_USR3_DCL((cls, "tMEVideoProperties(%50s): [(%d)%s]", name,line,removePath(file)));
    }
    else
    {
        ETG_TRACE_USR3_DCL((cls, "tMEVideoProperties(%s):", name));
    }
    VarTrace(cls, var.brightness(), "tMEVideoProperties.brightness");
    VarTrace(cls, var.hue(), "tMEVideoProperties.hue");
    VarTrace(cls, var.saturation(), "tMEVideoProperties.saturation");
    VarTrace(cls, var.contrast(), "tMEVideoProperties.contrast");
    VarTrace(cls, var.brightnessoffset(), "tMEVideoProperties.brightnessoffset");
    VarTrace(cls, var.saturationoffset(), "tMEVideoProperties.saturationoffset");
    VarTrace(cls, var.hueoffset(), "tMEVideoProperties.hueoffset");
}

#if USE_IMAGE_OBJECT
void VarTrace(tClassType cls, tImageObject var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tImageObject(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tImageObject(%s):", name));
        }
        VarTrace(cls, var.type, "tImageObject.type");
        VarTrace(cls, var.folderTitle, "tImageObject.folderTitle");
        VarTrace(cls, var.numberofImages, "tImageObject.numberofImages");
#if IMAGE_ATTRIBUTES_IN_METADATA
        VarTrace(cls, var.imageSize, "tImageObject.imageSize");
#else
        VarTrace(cls, var.fileSize, "tImageObject.fileSize");
#endif
        VarTrace(cls, var.dateTime, "tImageObject.dateTime");
        VarTrace(cls, var.dimension, "tImageObject.dimension");
        VarTrace(cls, var.resolution, "tImageObject.resolution");
        VarTrace(cls, var.fileFormat, "tImageObject.fileFormat");
        VarTrace(cls, var.objectID, "tImageObject.objectID");
        VarTrace(cls, var.imageTitle, "tImageObject.imageTitle");
        VarTrace(cls, var.path, "tImageObject.path");
        VarTrace(cls, var.imageFile, "tImageObject.imageFile");
        VarTrace(cls, var.deviceID, "tImageObject.deviceID");
        VarTrace(cls, var.mountPoint, "tImageObject.mountPoint");
    }
}

void VarTrace(tClassType cls, vector <tImageObject> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tImageObject>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tImageObject>(%s):", name));
        }
        vector<tImageObject>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}
#endif

void VarTrace(tClassType cls, tDiPOPower var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOPower(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPOPower(%s):", name));
        }
        VarTrace(cls, (int)var.BatteryChargingState, "tDiPOPower.BatteryChargingState");
        VarTrace(cls, (int)var.AccessoryPowerMode, "tDiPOPower.AccessoryPowerMode");
        VarTrace(cls, var.BatteryChargeLevel, "tDiPOPower.BatteryChargeLevel");
        VarTrace(cls, var.MaximumCurrentDrawnFromAccessory, "tDiPOPower.MaximumCurrentDrawnFromAccessory");
        VarTrace(cls, var.DeviceBatteryWillChargeIfPowerIsPresent, "tDiPOPower.DeviceBatteryWillChargeIfPowerIsPresent");
        VarTrace(cls, var.IsExternalChargerConnected, "tDiPOPower.IsExternalChargerConnected");
    }
}

#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
void VarTrace(tClassType cls, tDiPORouteGuidanceManeuverUpdate var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
        {
            if (file != NULL && line != -1)
            {
                ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceManeuverUpdate(%50s): [(%d)%s]", name,line,removePath(file)));
            }
            else
            {
                ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceManeuverUpdate(%s):", name));
            }
            VarTrace(cls,var.RouteGuidanceDisplayComponentID,"tDiPORouteGuidanceManeuverUpdate.RouteGuidanceDisplayComponentID");
            VarTrace(cls,(int)var.ManeuverType,"tDiPORouteGuidanceManeuverUpdate.ManeuverType");
            VarTrace(cls,var.ManeuverDescription,"tDiPORouteGuidanceManeuverUpdate.ManeuverDescription");
            VarTrace(cls,(int)var.JunctionType,"tDiPORouteGuidanceManeuverUpdate.JunctionType");
            VarTrace(cls,var.JunctionElementExitAngle,"tDiPORouteGuidanceManeuverUpdate.JunctionElementExitAngle");
            VarTrace(cls,var.JunctionElementAngle,"tDiPORouteGuidanceManeuverUpdate.JunctionElementAngle");
            VarTrace(cls,var.Index,"tDiPORouteGuidanceManeuverUpdate.Index");
            VarTrace(cls,(int)var.DrivingSide,"tDiPORouteGuidanceManeuverUpdate.DrivingSide");
            VarTrace(cls,(int)var.DistanceBetweenManeuverDisplayUnits,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayUnits");
            VarTrace(cls,var.DistanceBetweenManeuverDisplayStr,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayStr");
            VarTrace(cls,(int)var.DistanceBetweenManeuver,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuver");
            VarTrace(cls,var.AfterManeuverRoadName,"tDiPORouteGuidanceManeuverUpdate.AfterManeuverRoadName");

        }
}
void VarTrace(tClassType cls, tDiPORouteGuidanceUpdate var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
            {
                if (file != NULL && line != -1)
                {
                    ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceUpdate(%50s): [(%d)%s]", name,line,removePath(file)));
                }
                else
                {
                    ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceUpdate(%s):", name));
                }
                VarTrace(cls,var.RouteGuidanceDisplayComponentID,"tDiPORouteGuidanceUpdate.RouteGuidanceDisplayComponentID");
                VarTrace(cls,(int)var.RouteGuidanceState,"tDiPORouteGuidanceUpdate.RouteGuidanceState");
                VarTrace(cls,var.CurrentRoadName,"tDiPORouteGuidanceUpdate.CurrentRoadName");
                VarTrace(cls,(int)var.ManeuverState,"tDiPORouteGuidanceUpdate.ManeuverState");
                VarTrace(cls,var.DestinationName,"tDiPORouteGuidanceUpdate.DestinationName");
                VarTrace(cls,(int)var.DistanceRemaining,"tDiPORouteGuidanceUpdate.DistanceRemaining");
                VarTrace(cls,var.DistanceRemainingDisplayStr,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayStr");
                VarTrace(cls,var.RouteGuidanceVisibleInApp,"tDiPORouteGuidanceUpdate.RouteGuidanceVisibleInApp");
                VarTrace(cls,(int)var.DistanceRemainingDisplayUnits,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayUnits");
                VarTrace(cls,(int)var.DistanceToNextManeuver,"tDiPORouteGuidanceUpdate.DistanceToNextManeuver");
                VarTrace(cls,var.EstimatedTimeOfArrival,"tDiPORouteGuidanceUpdate.DistanceBetweenManeuver");
                VarTrace(cls,var.DistanceToNextManeuverDisplayStr,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayStr");
                VarTrace(cls,var.TimeRemainingToDestination,"tDiPORouteGuidanceUpdate.TimeRemainingToDestination");
                VarTrace(cls,var.RouteGuidanceManeuverCount,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCount");
                VarTrace(cls,(int)var.DistanceToNextManeuverDisplayUnits,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayUnits");
                //VarTrace(cls,var.RouteGuidanceManeuverCurrentList.ManeuverListSize,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCurrentList.ManeuverListSize");
            }
}
#else
void VarTrace(tClassType cls, tDiPORouteGuidanceManeuverUpdate var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
        {
            if (file != NULL && line != -1)
            {
                ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceManeuverUpdate(%50s): [(%d)%s]", name,line,removePath(file)));
            }
            else
            {
                ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceManeuverUpdate(%s):", name));
            }
//            VarTrace(cls,var.RouteGuidanceDisplayComponentID,"tDiPORouteGuidanceManeuverUpdate.RouteGuidanceDisplayComponentID");
            VarTrace(cls,(int)var.ManeuverType,"tDiPORouteGuidanceManeuverUpdate.ManeuverType");
            VarTrace(cls,var.ManeuverDescription,"tDiPORouteGuidanceManeuverUpdate.ManeuverDescription");
            VarTrace(cls,(int)var.JunctionType,"tDiPORouteGuidanceManeuverUpdate.JunctionType");
            VarTrace(cls,var.JunctionElementExitAngle,"tDiPORouteGuidanceManeuverUpdate.JunctionElementExitAngle");
            //VarTrace(cls,var.JunctionElementAngle,"tDiPORouteGuidanceManeuverUpdate.JunctionElementAngle");
            VarTrace(cls,var.Index,"tDiPORouteGuidanceManeuverUpdate.Index");
            VarTrace(cls,(int)var.DrivingSide,"tDiPORouteGuidanceManeuverUpdate.DrivingSide");
            VarTrace(cls,(int)var.DistanceBetweenManeuverDisplayUnits,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayUnits");
            VarTrace(cls,var.DistanceBetweenManeuverDisplayStr,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayStr");
            VarTrace(cls,(int)var.DistanceBetweenManeuver,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuver");
            VarTrace(cls,var.AfterManeuverRoadName,"tDiPORouteGuidanceManeuverUpdate.AfterManeuverRoadName");

            VarTrace(cls,var.RouteGuidanceDisplayComponentIDsAvailable,"tDiPORouteGuidanceManeuverUpdate.RouteGuidanceDisplayComponentIDsAvailable");
            VarTrace(cls,var.ManeuverTypeAvailable,"tDiPORouteGuidanceManeuverUpdate.ManeuverTypAvailablee");
            VarTrace(cls,var.ManeuverDescriptionAvailable,"tDiPORouteGuidanceManeuverUpdate.ManeuverDescriptionAvailable");
            VarTrace(cls,var.JunctionTypeAvailable,"tDiPORouteGuidanceManeuverUpdate.JunctionTypeAvailable");
            VarTrace(cls,var.JunctionElementExitAngleAvailable,"tDiPORouteGuidanceManeuverUpdate.JunctionElementExitAngleAvailable");
            VarTrace(cls,var.JunctionElementAngleAvailable,"tDiPORouteGuidanceManeuverUpdate.JunctionElementAngleAvailable");
            VarTrace(cls,var.IndexAvailable,"tDiPORouteGuidanceManeuverUpdate.IndexAvailable");
            VarTrace(cls,var.DrivingSideAvailable,"tDiPORouteGuidanceManeuverUpdate.DrivingSideAvailable");
            VarTrace(cls,var.DistanceBetweenManeuverDisplayUnitsAvailable,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayUnitsAvailable");
            VarTrace(cls,var.DistanceBetweenManeuverDisplayStrAvailable,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayStrAvailable");
            VarTrace(cls,var.DistanceBetweenManeuverAvailable,"tDiPORouteGuidanceManeuverUpdate.DistanceBetweenManeuverAvailable");
            VarTrace(cls,var.AfterManeuverRoadNameAvailable,"tDiPORouteGuidanceManeuverUpdate.AfterManeuverRoadNameAvailable");

        }
}
void VarTrace(tClassType cls, tDiPORouteGuidanceUpdate var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
            {
                if (file != NULL && line != -1)
                {
                    ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceUpdate(%50s): [(%d)%s]", name,line,removePath(file)));
                }
                else
                {
                    ETG_TRACE_USR3_DCL((cls, "tDiPORouteGuidanceUpdate(%s):", name));
                }
               // VarTrace(cls,var.RouteGuidanceDisplayComponentID,"tDiPORouteGuidanceUpdate.RouteGuidanceDisplayComponentID");
                VarTrace(cls,(int)var.RouteGuidanceState,"tDiPORouteGuidanceUpdate.RouteGuidanceState");
                VarTrace(cls,var.CurrentRoadName,"tDiPORouteGuidanceUpdate.CurrentRoadName");
                VarTrace(cls,(int)var.ManeuverState,"tDiPORouteGuidanceUpdate.ManeuverState");
                VarTrace(cls,var.DestinationName,"tDiPORouteGuidanceUpdate.DestinationName");
                VarTrace(cls,(int)var.DistanceRemaining,"tDiPORouteGuidanceUpdate.DistanceRemaining");
                VarTrace(cls,var.DistanceRemainingDisplayStr,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayStr");
                VarTrace(cls,var.RouteGuidanceVisibleInApp,"tDiPORouteGuidanceUpdate.RouteGuidanceVisibleInApp");
                VarTrace(cls,(int)var.DistanceRemainingDisplayUnits,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayUnits");
                VarTrace(cls,(int)var.DistanceToNextManeuver,"tDiPORouteGuidanceUpdate.DistanceToNextManeuver");
                VarTrace(cls,var.EstimatedTimeOfArrival,"tDiPORouteGuidanceUpdate.DistanceBetweenManeuver");
                VarTrace(cls,var.DistanceToNextManeuverDisplayStr,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayStr");
                VarTrace(cls,var.TimeRemainingToDestination,"tDiPORouteGuidanceUpdate.TimeRemainingToDestination");
                VarTrace(cls,var.RouteGuidanceManeuverCount,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCount");
                VarTrace(cls,(int)var.DistanceToNextManeuverDisplayUnits,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayUnits");
                //VarTrace(cls,var.RouteGuidanceManeuverCurrentList.ManeuverListSize,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCurrentList.ManeuverListSize");
                VarTrace(cls,var.SourceName,"tDiPORouteGuidanceUpdate.SourceName");
                VarTrace(cls,(int)var.SourceSupportsRouteGuidance,"tDiPORouteGuidanceUpdate.SourceSupportsRouteGuidance");

                 VarTrace(cls,var.RouteGuidanceDisplayComponentIDsAvailable,"tDiPORouteGuidanceUpdate.RouteGuidanceDisplayComponentIDsAvailable");
                 VarTrace(cls,var.RouteGuidanceStateAvailable,"tDiPORouteGuidanceUpdate.RouteGuidanceStateAvailable");
                 VarTrace(cls,var.CurrentRoadNameAvailable,"tDiPORouteGuidanceUpdate.CurrentRoadNameAvailable");
                 VarTrace(cls,var.ManeuverStateAvailable,"tDiPORouteGuidanceUpdate.ManeuverStateAvailable");
                 VarTrace(cls,var.DestinationNameAvailable,"tDiPORouteGuidanceUpdate.DestinationNameAvailable");
                 VarTrace(cls,var.DistanceRemainingAvailable,"tDiPORouteGuidanceUpdate.DistanceRemainingAvailable");
                 VarTrace(cls,var.DistanceRemainingDisplayStrAvailable,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayStrAvailable");
                 VarTrace(cls,var.RouteGuidanceVisibleInAppAvailable,"tDiPORouteGuidanceUpdate.RouteGuidanceVisibleInAppAvailable");
                 VarTrace(cls,var.DistanceRemainingDisplayUnitsAvailable,"tDiPORouteGuidanceUpdate.DistanceRemainingDisplayUnitsAvailable");
                 VarTrace(cls,var.DistanceToNextManeuverAvailable,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverAvailable");
                 VarTrace(cls,var.EstimatedTimeOfArrivalAvailable,"tDiPORouteGuidanceUpdate.DistanceBetweenManeuverAvailable");
                 VarTrace(cls,var.DistanceToNextManeuverDisplayStrAvailable,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayStrAvailable");
                 VarTrace(cls,var.TimeRemainingToDestinationAvailable,"tDiPORouteGuidanceUpdate.TimeRemainingToDestinationAvailable");
                 VarTrace(cls,var.RouteGuidanceManeuverCountAvailable,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCountAvailable");
                 VarTrace(cls,var.DistanceToNextManeuverDisplayUnitsAvailable,"tDiPORouteGuidanceUpdate.DistanceToNextManeuverDisplayUnitsAvailable");
                 VarTrace(cls,var.RouteGuidanceManeuverCurrentListAvailable,"tDiPORouteGuidanceUpdate.RouteGuidanceManeuverCurrentListAvailable");
                 VarTrace(cls,var.SourceNameAvailable,"tDiPORouteGuidanceUpdate.SourceNameAvailable");
                 VarTrace(cls,var.SourceSupportsRouteGuidanceAvailable,"tDiPORouteGuidanceUpdate.SourceSupportsRouteGuidanceAvailable");
            }
}
#endif

void VarTrace(tClassType cls,tEditMetaDataByUrl var,const char *name, const char *file, const int line)
{

    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
       if (file != NULL && line != -1)
       {
           ETG_TRACE_USR3_DCL((cls, "tEditMetaDataByUrl(%50s): [(%d)%s]", name,line,removePath(file)));
       }
       VarTrace(cls, var.MediaObjectUrl, "tEditMetaDataByUrl.MediaObjectUrl");
       VarTrace(cls, var.GenreField, "tEditMetaDataByUrl.GenreField");
       VarTrace(cls, var.AlbumField, "tEditMetaDataByUrl.AlbumField");
       VarTrace(cls, var.ArtistField, "tEditMetaDataByUrl.ArtistField");
       VarTrace(cls, var.TitleField, "tEditMetaDataByUrl.TitleField");
       VarTrace(cls, var.ComposerField, "tEditMetaDataByUrl.ComposerField");
       VarTrace(cls,(int) var.YearField, "tEditMetaDataByUrl.YearField");
       VarTrace(cls,(int) var.deviceID, "tEditMetaDataByUrl.deviceID");

    }
}

void VarTrace(tClassType cls,tYomiMetadata var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tYomiMetadata(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        VarTrace(cls, var.YomiTitle, "tYomiMetadata.YomiTitle");
        VarTrace(cls, var.YomiArtist, "tYomiMetadata.YomiArtist");
        VarTrace(cls, var.YomiAlbum, "tYomiMetadata.YomiAlbum");


    }

}

void VarTrace(tClassType cls, tDiPORGDisplayComponentInfo var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPORGDisplayComponentInfo(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPORGDisplayComponentInfo(%s):", name));
        }

        VarTrace(cls, var.Identifier, "tDiPORGDisplayComponentInfo.Identifier");
        VarTrace(cls, var.Name, "tDiPORGDisplayComponentInfo.Name");
        VarTrace(cls, var.CurrentRoadNameLength, "tDiPORGDisplayComponentInfo.CurrentRoadNameLength");
        VarTrace(cls, var.DestinationNameLength, "tDiPORGDisplayComponentInfo.DestinationNameLength");
        VarTrace(cls, var.AfterManeuverRoadNameLength, "tDiPORGDisplayComponentInfo.AfterManeuverRoadNameLength");
        VarTrace(cls, var.ManeuverDescriptionLength, "tDiPORGDisplayComponentInfo.ManeuverDescriptionLength");
        VarTrace(cls, var.GuidanceManeuverCapacity, "tDiPORGDisplayComponentInfo.GuidanceManeuverCapacity");
    }
}

void VarTrace(tClassType cls, vector<tDiPORGDisplayComponentInfo> var,const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDiPORGDisplayComponentInfo>(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "vector<tDiPORGDisplayComponentInfo>(%s):", name));
        }
        vector<tDiPORGDisplayComponentInfo>::iterator it;
        int i;
        char elementName[MAXNAME];
        for(it = var.begin(), i=0; it < var.end(); it++, i++)
        {
            snprintf(elementName,MAXNAME-1,"%s[%d]",name,i);
            VarTrace(cls, *it, elementName);
        }
    }
}

void VarTrace(tClassType cls,tDiPODeviceTime var, const char *name, const char *file, const int line)
{
    if (true == etg_bIsTraceActive(cls, TR_LEVEL_USER_3))
    {
        if (file != NULL && line != -1)
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPODeviceTime(%50s): [(%d)%s]", name,line,removePath(file)));
        }
        else
        {
            ETG_TRACE_USR3_DCL((cls, "tDiPODeviceTime(%s):", name));
        }
        VarTrace(cls, var.s8DaylightSavingsOffsetMinutes, "tDiPODeviceTime.s8DaylightSavingsOffsetMinutes");
        VarTrace(cls, var.u64SecondsSinceReferenceDate, "tDiPODeviceTime.u64SecondsSinceReferenceDate");
        VarTrace(cls, var.s16TimeZoneOffsetMinutes, "tDiPODeviceTime.s16TimeZoneOffsetMinutes");
    }
}
