/*
 * StructTrace.h
 *
 *  Created on: Sep 20, 2012
 *      Author: tritonsu
 */

#ifndef VARTRACE_H_
#define VARTRACE_H_

#include "TypeDefinitions.h"

#include <vector>
#include <string>
using namespace std;

#define CHECK_NULL(a) (a ? a : "NULL")

#ifdef TARGET_BUILD
typedef unsigned short tClassType;
#else
typedef  const char * tClassType;
#endif

#ifdef TARGET_BUILD
#define VARTRACE_ON 1 /* = 1: variable tracing switched on, = 0: off */
#else
#define VARTRACE_ON 0 /* = 1: variable tracing switched on, = 0: off */
#endif

#if VARTRACE_ON
    #define VARTRACE(a) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, __FILE__,__LINE__);
    #define VARTRACE2(a,b) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, __FILE__,__LINE__);
    #define VARTRACE3(a,b,c) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b,  c, #c, __FILE__,__LINE__);
    #define VARTRACE4(a,b,c,d) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, __FILE__,__LINE__);
    #define VARTRACE5(a,b,c,d,e) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, __FILE__,__LINE__);
    #define VARTRACE6(a,b,c,d,e,f) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, f, #f, __FILE__,__LINE__);
   #define VARTRACE7(a,b,c,d,e,f,g) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, f, #f, g, #g,__FILE__,__LINE__);

    #define VARTRACEMIN(a) VarTraceMin(ETG_DEFAULT_TRACE_CLASS, a, #a, __FILE__,__LINE__);
#else
    #define VARTRACE(a)
    #define VARTRACE2(a,b)
    #define VARTRACE3(a,b,c)
    #define VARTRACE4(a,b,c,d)
    #define VARTRACE5(a,b,c,d,e)
    #define VARTRACE6(a,b,c,d,e,f)
   #define VARTRACE7(a,b,c,d,e,f,g)

#endif


void VarTrace(tClassType cls, const tMountPoint varA, const char *nameA, tDeviceID varB, const char *nameB, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPlaytime varA, const char *nameA, tPlaytime varB, const char *nameB, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tListID varA, const char *nameA, tIndex varB, const char *nameB, tPlaytime varC, const char *nameC, const char *file=NULL, const int line=-1);

void VarTrace(  tClassType cls,
                tDeviceType varA, const char *nameA,
                tDeviceID varB, const char *nameB,
                const tURL varC, const char *nameC,
                const tMountPoint varD, const char *nameD,
                const char *file=NULL, const int line=-1);

void VarTrace(  tClassType cls,
                tPEPlaybackState varA, const char *nameA,
                const tMetadata varB, const char *nameB,
                const tMetadata varC, const char *nameC,
                const tMetadata varD, const char *nameD,
                const tMetadata varE, const char *nameE,
                tMediaType varF, const char *nameF,
                const char *file=NULL, const int line=-1);

void VarTrace(  tClassType cls,
                const tMetadata varA, const char *nameA,
                const tMetadata varB, const char *nameB,
                const tMetadata varC, const char *nameC,
                const tMetadata varD, const char *nameD,
                const tMetadata varE, const char *nameE,
                const char *file=NULL, const int line=-1);



void VarTrace(tClassType cls, tDiPOLocationInfoType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOInitiateCall var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOAcceptCall var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOEndCall var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tBTProfile var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPEDuration var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPEPosition var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPETimeInfoStruct var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPlaybackMode var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tConnectionType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tRepeatMode var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tIndexingState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tConnectionState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tListType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFileType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFileFormat var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tCategoryType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPlaybackAction var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tHMIPlaybackState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tNowPlayingState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPlaypointFormat var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tListChangeType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tSourceActivity var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMediaType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDeviceType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tTagTransferStatus var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tLogicalAVChannel var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tLanguageType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDMConnectStatus var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMimeType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tViewStatus var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPlayContinuation var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tComponentID var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tComponentState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPositionInList var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPEPlaybackState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tPEErrorCode var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFingerprintStatus var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMetadataStatus var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tNoObjectReason var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tIndexingMode var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMuteState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDeviceState var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFileSystemType var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOCaps var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDisconnectReason var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tNotPlayable var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tError var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFilterTag1 var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFilterTag2 var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFilterTag3 var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFilterTag4 var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, const char* var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, unsigned int var,const char *name, const char *file=NULL, const int line=-1);

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT // todo: first attemp: must be changed for target linux 64 bit compiler
void VarTrace(tClassType cls, size_t var,const char *name, const char *file=NULL, const int line=-1);
#endif

void VarTrace(tClassType cls, int var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, float var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, char var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, short var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, unsigned char* var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, unsigned char var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, unsigned short var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, long long var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, unsigned long long var,const char *name, const char *file=NULL, const int line=-1);

#ifndef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT // todo: make the following only available in 32-bit builds to solve ambiguities
// Ch. Simon-Klar: the following line does not compile in 64 enviroments
void VarTrace(tClassType cls, unsigned long var,const char *name, const char *file=NULL, const int line=-1);
#endif

void VarTrace(tClassType cls, long int var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tAlbumArtObject var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDeviceInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTraceMin(tClassType cls, tDeviceInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tDeviceInfo> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDeviceProperty var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tDeviceProperty> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMediaObjectInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFiles var,const char *name, const char *file=NULL, const int line=-1);
void VarTraceMin(tClassType cls, tFiles var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tFiles> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tSearchKeyboard var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tSearchKeyboard> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tListInfo var,const char *name, const char *file=NULL, const int line=-1);
void VarTraceMin(tClassType cls, tListInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tMediaObject var,const char *name, const char *file=NULL, const int line=-1);
void VarTraceMin(tClassType cls, tMediaObject var,const char *name, const char *file=NULL, const int line=-1);


void VarTrace(tClassType cls, vector<tMediaObject> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tNowPlaying var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPONowPlaying var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOCallStateItem var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOCommunications var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tUserContext var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tIndexingStateResult var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector <tIndexingStateResult> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tFavoriteInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tFavoriteInfo> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector <tUInt> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tTagTransfer var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector <tTagTransfer> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tUntransferredTag var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector <tUntransferredTag> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tNowShowing var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, me::vprops_t var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPOPower var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPORouteGuidanceManeuverUpdate var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPORouteGuidanceUpdate var,const char *name, const char *file=NULL, const int line=-1);
#if USE_IMAGE_OBJECT
void VarTrace(tClassType cls, tImageObject var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tImageObject> var,const char *name, const char *file=NULL, const int line=-1);
#endif

void VarTrace(tClassType cls,tEditMetaDataByUrl var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls,tYomiMetadata var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, tDiPORGDisplayComponentInfo var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls, vector<tDiPORGDisplayComponentInfo> var,const char *name, const char *file=NULL, const int line=-1);

void VarTrace(tClassType cls,tDiPODeviceTime var, const char *name, const char *file=NULL, const int line=-1);
#endif /* STRUCTTRACE_H_ */
