#ifndef _IPCTEST_H_
#define _IPCTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"
#include "TypeDefinitions.h"

#include "IpcClient.h"

#include "ThreadFactory.h"

class IpcTest : public IpcClient , public TFThread ,public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( IpcTest );

    CPPUNIT_TEST( testPECreate );
    CPPUNIT_TEST( testPERegisterObserver );
    CPPUNIT_TEST( testPEPlayTrack );

    CPPUNIT_TEST_SUITE_END();

public:
    IpcTest();

    void Do(int functionID, void *userPtr);

    /*PlayerEngine test cases*/
    void testPECreate();
    void testPERegisterObserver();
    void testPEPlayTrack();

    /*common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

private:
    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/
    pthread_cond_t   condition ;    /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;        /**< lock used during asynchronous test case execution*/

    unsigned int   mCreateSerial;   /**< dbus serial received from a method call CreatePlayerInstance, required to track n match the method answer*/

    tBoolean SignalReceived(const char* name , const char* params);
    tBoolean MethodRequested(dbus_uint32_t serial, const char* name , const char* params);
    tBoolean MethodAnswered(dbus_uint32_t serial , const char* params);
    tBoolean Error(dbus_uint32_t serial , const char* error);

    void IpcDispatcher(void *userPtr);
};

#endif  // _MEDIAPLAYERTEST_H_
