#ifndef _MYSMIMPL_H_
#define _MYSMIMPL_H_

#include "ILocalSPM.h"
#include "ThreadFactory.h"
#include "ReferenceSM.h"
#include "LocalSPM.h"

class mySMImpl : public ReferenceSM , public TFThread
{
public:

	void Do(int functionID, void * /*userPtr*/) {
				switch (functionID) {
				case 0:
				{
					while(mySMImpl::STATE_MACHINE_FINISHED != StateMachine_Main())
						{}
					break;
				}
				case 1:
				{
					DoProcessing();
					break;
				}
                default:
                    break;
		}
	}
	/* member */
	int mConditionStore; // just for testing
	int mI1;
	int mI2;

	/* state machine callbacks */
	virtual int myConditionAction(int cond)
	{
		mConditionStore = cond;
		return cond;
	}

	virtual int myAction(const tListID listID, const tSongID songId, const tTestString myString, const tPosition position)
	{
	    char cbuf[1024];
		(void)listID;
		(void)songId;
		(void)position;
		(void)myString;

		sprintf(cbuf, "listID=%d, songID=%d, position=%d, myString=%s", listID, songId, position, myString); fflush(stdout);
		Expect(cbuf);
		return 0;
	}

	/* state machine callbacks */
	virtual int isAtFirstSongPlayback(const int cond)
	{
		return cond;
	}
	
	int atFirstSongAction(int argument)
	{
	    char cbuf[16];
	    snprintf(cbuf, sizeof(cbuf)-1, "%d", argument);
	    Expect(cbuf);
	    return 0;
	}

	int myGuard() { return 1; }

	static bool TimerCallBack(int timerID , void* instance ,const void *userData);

	virtual int endProcessing()
	{
		LocalSPM::GetThreadFactory().Do(IN this,IN 1, IN NULL);
		return 0;
	}

	int DoProcessing()
	{
		sleep(1);
        char parameterString[1024];

        /* do not react if both values are 4
         * this tests the local ANSWER_TIMEOUT functionality
         */
        if (mI1 == 4 && mI2 == 4) return 0;

        /*
         * forward the parameters as usual
         */
        ParameterPROCESSED(parameterString, sizeof(parameterString), mI2, mI1); //send back integers in swapped order
		SendEvent(PROCESSED, parameterString);
		return 0;
	}

	virtual int AnswerTimeout()
	{
		SendAnswer("8,8");
		return 0;
	}

	virtual int sendProcessing(const tInteger i1, const tInteger i2)
	{
	    char parameterString[1024];
	    snprintf(parameterString, sizeof(parameterString), "%d,%d", i1, i2); // format the paramaters to fetch by the request/answer state machine
		SendAnswer(parameterString);
		return 0;
	}

	virtual int startProcessing(const tInteger i1, const tInteger i2)
	{
		char cbuf[128];
		snprintf(cbuf, sizeof(cbuf), "startProcessing: i1=%d, i2=%d", i1, i2);
		Expect(cbuf);

		// for testing, set members to received values
		mI1 = i1;
		mI2 = i2;

		// define the release event for the waiting state
		RegisterReleaseEvent(PROCESSED);

		return 0;
	}

	virtual int RemoveDelayedEvent()
	{
	    char cbuf[128];
        snprintf(cbuf, sizeof(cbuf), "RemoveMessageByName");
        Expect(cbuf);

	    RemoveMessageByName("SEEK_BACKW_EVENT");
	    return 0;
	}

	int internalCondition(const tInteger cond)
	{
		return cond;
	}

	tResult ErrorHandler(const tResult /*error*/, const tTransition* /*trans*/, const char* /*fnName*/)
	{
		Expect("ErrorHandler");
		if (!--mErrorHandlerRetryCounter) return 1; // stop the retry loop
		return 0; // continue retry loop
	}

	int seekBackwardFn(const tInteger returnValue)
	{
		return returnValue;
	}

	int mErrorHandlerRetryCounter;

private:
	Timer mTimer;

};

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include "RequestResponseSM.h"
#include "Dispatcher.h"

class SMFTest : public CppUnit::TestFixture, public TFThread
{
    CPPUNIT_TEST_SUITE( SMFTest );
    CPPUNIT_TEST( ReferenceStateMachineTest );
    CPPUNIT_TEST_SUITE_END(); //lint -e578

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void Do(int param, void *userPtr);
    void ReferenceStateMachineTest();

private:
    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;    /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;        /**< lock used during asynchronous test case execution*/
};

#endif 
