/*
 * MediaplayerTestSuites.cpp
 *
 *  Created on: Jul 18, 2013
 *      Author: Dinesh
 */

/* list all the CppUnit test suite headers */
#include "ConfigTest.h"
#include "SMF_Validation.h"
#include "MediaPlayerStartupTest.h"
#include "MediaPlayerShutdownTest.h"
#include "MediaPlayerSPMRegression.h"
#include "MediaPlayerTest.h"
#include "ListControlTest.h"
#include "DBManagerTest.h"
#include "DataProviderTest.h"
#include "CustomControlTest.h"
#include "FavoritesManagerTest.h"
#include "IpcTest.h"
#include "USBControlTest.h"
#include "CDDAControlTest.h"
#include "DVDControlInterfaceTest.h"
#include "MTPControlTest.h"
#include "MTPControlUnitTest.h"
#include "MTPControlUnitTestStubbed.h"
#include "MTPControlTestCombined.h"
#include "MTPControlTestRealDevice.h"
#include "iPodControlTest.h"
#include "DeviceDispatcherTest.h"
#include "PlayerManagerTest.h"
#include "IndexerTest.h"
#include "AlbumArtIndexerTest.h"
#include "DBTriggerTest.h"
#include "FileSystemVTTest.h"
#include "IPODVTTest.h"
#include "CDDAVTTest.h"
#include "BluetoothVTTest.h"
#include "UTF8FileNameTest.h"
#include "MediaPlayerInterfaceTest.h"
#include "MessageQueueTest.h"
#include "BTControlTest.h"
#include "MTPVTTest.h"
#include "PictureManagerTest.h"
#include "5_test/MediaEngineOperationTest.h"
#include "LongRunnerCatcherTest.h"
#include "RipperControlTest.h"

/* register all the CppUnit test suites here*/

// tests for the long runner error catcher
// thm3hi: LongRunnerCatcher is switched off, see: LongRunnerCatcher.h for details
// CPPUNIT_TEST_SUITE_REGISTRATION( LongRunnerCatcherTest);

// module test for message queue
CPPUNIT_TEST_SUITE_REGISTRATION( MessageQueueTest);

// prepare the SPM and start all components to normal
CPPUNIT_TEST_SUITE_REGISTRATION( MediaPlayerStartupTest );

#ifdef USE_TESTS_WITH_REAL_DVDDRIVE_ONLY
// module test for USBControl
CPPUNIT_TEST_SUITE_REGISTRATION( USBControlTest );
CPPUNIT_TEST_SUITE_REGISTRATION( DVDControlInterfaceTest );
CPPUNIT_TEST_SUITE_REGISTRATION( RipperControlTest );
#else
#define ALL_TESTS 1
#endif



#if ALL_TESTS
// prepare the SPM and start all components to normal
CPPUNIT_TEST_SUITE_REGISTRATION( MediaPlayerSPMRegression );

// test the new media engine stand alone
CPPUNIT_TEST_SUITE_REGISTRATION( MediaEngineOperationTest );

// module test the db manager
CPPUNIT_TEST_SUITE_REGISTRATION( DBManagerTest );

// module test the custom control
CPPUNIT_TEST_SUITE_REGISTRATION( CustomControlTest );

// module test the favorite manager
CPPUNIT_TEST_SUITE_REGISTRATION( FavoritesManagerTest );

// module test the state machine framework with the reference state machine
CPPUNIT_TEST_SUITE_REGISTRATION( SMFTest );

// module test the data provider
CPPUNIT_TEST_SUITE_REGISTRATION( DataProviderTest );

// module test the list control
CPPUNIT_TEST_SUITE_REGISTRATION( ListControlTest );

// module test for USBControl
CPPUNIT_TEST_SUITE_REGISTRATION( USBControlTest );

// module test for CDDAControl
CPPUNIT_TEST_SUITE_REGISTRATION( CDDAControlTest );
CPPUNIT_TEST_SUITE_REGISTRATION( DVDControlInterfaceTest );

// module test for MTPControl
CPPUNIT_TEST_SUITE_REGISTRATION( MTPControlUnitTest );
CPPUNIT_TEST_SUITE_REGISTRATION( MTPControlUnitTestStubbed );
CPPUNIT_TEST_SUITE_REGISTRATION( MTPControlTest );
CPPUNIT_TEST_SUITE_REGISTRATION( MTPControlTestCombined );
CPPUNIT_TEST_SUITE_REGISTRATION( MTPControlTestRealDevice );

//#ifndef TARGET_BUILD
#if 0
// module test for BTControl
CPPUNIT_TEST_SUITE_REGISTRATION( BTControlTest );
#endif

// module test for iPodControl
CPPUNIT_TEST_SUITE_REGISTRATION( iPodControlTest );

// module test for DeviceDispatcher
CPPUNIT_TEST_SUITE_REGISTRATION( DeviceDispatcherTest );

// module test for PlayerManager
CPPUNIT_TEST_SUITE_REGISTRATION( PlayerManagerTest );

// module test for Indexer
CPPUNIT_TEST_SUITE_REGISTRATION( IndexerTest );

// module test for AlbumArtIndexer
CPPUNIT_TEST_SUITE_REGISTRATION( AlbumArtIndexerTest );

// module test for PictureViewer
CPPUNIT_TEST_SUITE_REGISTRATION( PictureManagerTest );

// module test for the virtual table file system for sqlite
CPPUNIT_TEST_SUITE_REGISTRATION( FileSystemVTTest );

// module test for the virtual table IPOD for sqlite
CPPUNIT_TEST_SUITE_REGISTRATION( IPODVTTest );

#if 0
// module test for the virtual table Bluetooth for sqlite
CPPUNIT_TEST_SUITE_REGISTRATION( BluetoothVTTest );
#endif

// module test for the virtual table MTP for sqlite
CPPUNIT_TEST_SUITE_REGISTRATION( MTPVTTest );

// module test for the virtual table CDDA for sqlite
CPPUNIT_TEST_SUITE_REGISTRATION( CDDAVTTest );

// module test the utf8 file name class
CPPUNIT_TEST_SUITE_REGISTRATION( UTF8FileNameTest );

// do some general module tests (for example: ClearMediaPlayerData (which does a shutdown and restart))
CPPUNIT_TEST_SUITE_REGISTRATION( MediaPlayerTest );

// Module test for Interface
CPPUNIT_TEST_SUITE_REGISTRATION( MediaPlayerInterfaceTest );

#ifndef TARGET_BUILD
// module test for BTControl
CPPUNIT_TEST_SUITE_REGISTRATION( BTControlTest );
#endif

#if 0
CPPUNIT_TEST_SUITE_REGISTRATION( DBTriggerTest );
#endif
#endif // #if ALL_TESTS

CPPUNIT_TEST_SUITE_REGISTRATION( RipperControlTest );

// shut down the media player and spm
CPPUNIT_TEST_SUITE_REGISTRATION( MediaPlayerShutdownTest );


