#ifndef _MEDIAPLAYERTEST_H_
#define _MEDIAPLAYERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"

class MediaPlayerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MediaPlayerTest );

    CPPUNIT_TEST( ReadAndWriteStringFormat );
//    CPPUNIT_TEST( testClearMediaPlayerData ); // removed this test because it deletes the database :-)
    CPPUNIT_TEST( strncpy_rTest );
    CPPUNIT_TEST( timerTest );
    CPPUNIT_TEST( UTF8ConvertTest );
    // thoemel: only for testing new charsets CPPUNIT_TEST( UTF8CyrillicTest );
    CPPUNIT_TEST( UTF8Validation );

    CPPUNIT_TEST( ThreadFactoryKillTest );

    CPPUNIT_TEST_SUITE_END(); //lint -e578

public:
    MediaPlayerTest();

    /* test case functions */
    void testClearMediaPlayerData();
    void ReadAndWriteStringFormat();
    void strncpy_rTest();
    void timerTest();
    void UTF8ConvertTest();
    void UTF8CyrillicTest();
    void UTF8Validation();

    void ThreadFactoryKillTest();

    /*common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

private:
    TimeTrace          ticks;            /**< time object to trace the time taken by testcases*/
    pthread_cond_t   condition ;    /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;        /**< lock used during asynchronous test case execution*/
};

#endif  // _MEDIAPLAYERTEST_H_
