/*
 * MediaPlayerStartupTest.h
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#ifndef MEDIAPLAYERSTARTUPTEST_H_
#define MEDIAPLAYERSTARTUPTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"
#include "TypeDefinitions.h"
#include "SimulationConfiguration.h"
#include "SimulationOutputWrapper.h"
#include "SimulationCustomControl.h"

class MediaPlayerStartupTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MediaPlayerStartupTest );
    CPPUNIT_TEST( SPMCreate );
    CPPUNIT_TEST( SPMStateChangeNormal );
#if 0
    CPPUNIT_TEST( SPMUndervoltageStart );
    CPPUNIT_TEST( SPMUndervoltageEnd );
    CPPUNIT_TEST( InterfaceUndervoltageStart );
    CPPUNIT_TEST( InterfaceUndervoltageEnd );
#endif
    CPPUNIT_TEST( CreateTestDatabase );

    CPPUNIT_TEST( GetSubversionNissan_KnownStringGiven_SuccessReturnValidEnumeration);
    CPPUNIT_TEST( GetSubversionNissan_UnknownStringGiven_FailureReturneSubType_Undefined);
    CPPUNIT_TEST( GetSubversionNissan_EmptyStringGiven_FailureReturneSubType_Undefined);
    CPPUNIT_TEST( GetSubversionNissan_NullPointerGiven_FailureReturneSubType_Undefined);

#ifdef FILEFORMAT_SAVE_RESTORE_IMPLEMENTED
    CPPUNIT_TEST(SupportVideoFileFormats_BeginIndex13_SuccessAddedVideoFileFormatSupport);
    CPPUNIT_TEST(SupportVideoFileFormats_BeginIndex17_SuccessAddedVideoFileFormatSupport);
    CPPUNIT_TEST(SupportVideoFileFormats_BeginIndex14_FailureVideoFileFormatSupportNotAdded);
#endif
    CPPUNIT_TEST_SUITE_END(); //lint -e578

public:

    /*SPM test cases*/
    void SPMCreate();
    void SPMStateChangeNormal();
    void SPMUndervoltageStart();
    void SPMUndervoltageEnd();
    void InterfaceUndervoltageStart();
    void InterfaceUndervoltageEnd();
    void CreateTestDatabase();

    /*common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

    /*Constructor*/
    MediaPlayerStartupTest() :mSimulationConfiguration(COMPONENT_ID_CONFIGURATION),
                              mSimulationOutputWrapper(COMPONENT_ID_OUTPUTWRAPPER),
                              mSimulationCustomControl(COMPONENT_ID_CUSTOMCONTROL){}

    void GetSubversionNissan_KnownStringGiven_SuccessReturnValidEnumeration();
    void GetSubversionNissan_UnknownStringGiven_FailureReturneSubType_Undefined();
    void GetSubversionNissan_EmptyStringGiven_FailureReturneSubType_Undefined();
    void GetSubversionNissan_NullPointerGiven_FailureReturneSubType_Undefined();

#ifdef FILEFORMAT_SAVE_RESTORE_IMPLEMENTED
    void SupportVideoFileFormats_BeginIndex13_SuccessAddedVideoFileFormatSupport();
    void SupportVideoFileFormats_BeginIndex17_SuccessAddedVideoFileFormatSupport();
    void SupportVideoFileFormats_BeginIndex14_FailureVideoFileFormatSupportNotAdded();
#endif
private:
    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/

    SimulationConfiguration mSimulationConfiguration;
    SimulationOutputWrapper mSimulationOutputWrapper;
    SimulationCustomControl mSimulationCustomControl;
};

#endif /* MEDIAPLAYERSTARTUPTEST_H_ */
