/*
 * MediaPlayerStartupTest.cpp
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerStartupTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MediaPlayerStartupTest.h"
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "MediaPlayerInterface.h"
#include "CppUnitDefinitions.h"

#include "FunctionTracer.h"

static tAllocateState mAllocateState;
static tAudioOutputDevice mAudioOutputDevice;

typedef struct
{
    std::string extension;
    int fileFormat;
    int fileType;
} FileFormatEntry;

void MediaPlayerStartupTest::setUp()
{
    ticks.begin();
}

void MediaPlayerStartupTest::tearDown()
{
    ticks.elapsed();
}

void MediaPlayerStartupTest::SPMCreate()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    mAllocateState = ALS_DEALLOCATED;
    mAudioOutputDevice[0] = '\0';

    res = MediaPlayerInterface::GetInstance().UnregisterAll();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = MediaPlayerInterface::GetInstance().Register(&mSimulationConfiguration);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = MediaPlayerInterface::GetInstance().Register(&mSimulationOutputWrapper);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = MediaPlayerInterface::GetInstance().Register(&mSimulationCustomControl);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = MediaPlayerInterface::GetInstance().CreateMediaPlayer();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaPlayerStartupTest::SPMStateChangeNormal()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Disable auto register on DB trigger */
    res = LocalSPM::GetIndexer().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetAlbumArtIndexer().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetCustomControl().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetPlayerManager().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Request MediaPlayer to enter NORMAL state */
    res = MediaPlayerInterface::GetInstance().StateChangeNormal();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_NORMAL == SPMState);

    /* Create the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, false);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaPlayerStartupTest::SPMUndervoltageStart()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Call SendAllocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));
    res = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_ON;
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(2); //Wait a little bit until IPC is initialized by first Allocate call

    /* read current PlayerManager state and store it in member variables */
    res = LocalSPM::GetPlayerManager().GetAllocateState(OUT mAllocateState, OUT mAudioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    if(ALS_ACTIVE != mAllocateState)
    {
        /* read again current PlayerManager state */
        sleep(3);
        res = LocalSPM::GetPlayerManager().GetAllocateState(OUT mAllocateState, OUT mAudioOutputDevice);
        CPPUNIT_ASSERT(MP_NO_ERROR == res);
    }

    CPPUNIT_ASSERT(ALS_ACTIVE == mAllocateState);
    CPPUNIT_ASSERT(strcmp(audioOutputDevice, mAudioOutputDevice) == 0);

    /* Request MediaPlayer to switch to UNDERVOLTAGE state */
    res =  LocalSPM::GetInstance().StateChangeUndervoltage(true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current SPM state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_UNDERVOLTAGE == SPMState);
}

void MediaPlayerStartupTest::SPMUndervoltageEnd()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Request MediaPlayer to switch back to NORMAL state */
    res =  LocalSPM::GetInstance().StateChangeUndervoltage(false);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current SPM state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_NORMAL == SPMState);

    /* Get first USB device */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, true /*get all devices*/);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(DEVICE_ID_NOT_SET != deviceID);

    /* Get connection state via DeviceInfo */
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    //After undervoltage devices should stay in CS_UNDERVOLTAGE until they are recognized by VD_DeviceManager
    CPPUNIT_ASSERT(CS_UNDERVOLTAGE == deviceInfo.connectionState);

    /* restore PlayerManager state */
    res = LocalSPM::GetPlayerManager().RestoreAllocateState(IN mAllocateState, IN mAudioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1);

    /* check PlayerManager state */
    tAllocateState allocateState;
    tAudioOutputDevice audioOutputDevice;
    res = LocalSPM::GetPlayerManager().GetAllocateState(OUT allocateState, OUT audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
    CPPUNIT_ASSERT(allocateState == mAllocateState); //ALS_ACTIVE
    CPPUNIT_ASSERT(strcmp(audioOutputDevice, mAudioOutputDevice) == 0);

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_OFF;
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Call SendDeAllocate */
    res = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    sleep(1); //State machines stuck after reaching NORMAL again if any response comes in SPM state OFF before
}

void MediaPlayerStartupTest::InterfaceUndervoltageStart()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Set undervoltage via MediaPlayerInterface */
    vector<tDeviceInfo> deviceInfos;
    deviceInfos.clear();
    res =  MediaPlayerInterface::GetInstance().DeviceChanged(IN true, IN deviceInfos);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current SPM state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_UNDERVOLTAGE == SPMState);
}

void MediaPlayerStartupTest::InterfaceUndervoltageEnd()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Set undervoltage end via MediaPlayerInterface */
    vector<tDeviceInfo> deviceInfos;
    deviceInfos.clear();
    res =  MediaPlayerInterface::GetInstance().DeviceChanged(IN false, IN deviceInfos);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current SPM state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_NORMAL == SPMState);
}

void MediaPlayerStartupTest::CreateTestDatabase()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* (Re)create the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaPlayerStartupTest::GetSubversionNissan_KnownStringGiven_SuccessReturnValidEnumeration()
{
    ENTRY_TEST

    /*WARNING -To ease testing, elements at given index in below containers :nissanSubversionStrings,expectedEnumerations are TIGTHLY COUPLED i.e 1 to 1 mapped */

    std::vector<std::string> nissanSubversionStrings;
    nissanSubversionStrings.push_back(std::string("GMP_NisScope1"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2_WO_iAP1"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2_1AIVI"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2_1AIVI_WO_iAP1"));
    nissanSubversionStrings.push_back(std::string("GMP_NisSC2_1AIVI_VID"));
    nissanSubversionStrings.push_back(std::string("GMP_NisSC2_1AIVI_WO_iAP1_VID"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2_1RENAULT"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope2_1RENAULT_WO_iAP1"));
    nissanSubversionStrings.push_back(std::string("GMP_Nis_PIVI"));
    nissanSubversionStrings.push_back(std::string("GMP_Nis_PIVI_WO_iAP1"));
    nissanSubversionStrings.push_back(std::string("GMP_Nis_PIVI_VID"));
    nissanSubversionStrings.push_back(std::string("GMP_Nis_PIVI_WO_iAP1_VID"));
    //nissanSubversionStrings.push_back(std::string("GMP_NisScope3AIVI"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope3AIVI_WO_iAP1"));
    nissanSubversionStrings.push_back(std::string("GMP_NisSC3AIVI_VID"));
    nissanSubversionStrings.push_back(std::string("GMP_NisSC3AIVI_WO_iAP1_VID"));
    //nissanSubversionStrings.push_back(std::string("GMP_NisScope3RENAULT"));
    nissanSubversionStrings.push_back(std::string("GMP_NisScope3RENAULT_WO_iAP1"));

    std::vector<teSubversionType> expectedEnumerations;

    expectedEnumerations.push_back(eSubType_NisScope1);
    expectedEnumerations.push_back(eSubType_NisScope2);
    expectedEnumerations.push_back(eSubType_GMP_NisScope2_WO_iAP1);
    expectedEnumerations.push_back(eSubType_NisScope2_1AIVI);
    expectedEnumerations.push_back(eSubType_GMP_NisScope2_1AIVI_WO_iAP1);
    expectedEnumerations.push_back(eSubType_NisSC2_1AIVI_VID);
    expectedEnumerations.push_back(eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID);
    expectedEnumerations.push_back(eSubType_NisScope2_1RENAULT);
    expectedEnumerations.push_back(eSubType_GMP_NisScope2_1RENAULT_WO_iAP1);
    expectedEnumerations.push_back(eSubType_NIS_PIVI);
    expectedEnumerations.push_back(eSubType_GMP_Nis_PIVI_WO_iAP1);
    expectedEnumerations.push_back(eSubType_Nis_PIVI_VID);
    expectedEnumerations.push_back(eSubType_GMP_Nis_PIVI_WO_iAP1_VID);
    //expectedEnumerations.push_back(eSubType_NisScope3AIVI);
    expectedEnumerations.push_back(eSubType_GMP_NisScope3AIVI_WO_iAP1);
    expectedEnumerations.push_back(eSubType_NisScope3AIVI_VID);
    expectedEnumerations.push_back(eSubType_GMP_NisSC3AIVI_WO_iAP1_VID);
    //expectedEnumerations.push_back(eSubType_GMP_NisScope3RENAULT);
    expectedEnumerations.push_back(eSubType_GMP_NisScope3RENAULT_WO_iAP1);

    CPPUNIT_ASSERT(nissanSubversionStrings.size()  == 17);
    CPPUNIT_ASSERT(expectedEnumerations.size() == nissanSubversionStrings.size());

    teSubversionType type = eSubType_Undefined;
    std::vector<teSubversionType>::iterator enumIter = expectedEnumerations.begin();

    std::vector<std::string>::iterator stringIter;
    for(stringIter = nissanSubversionStrings.begin();stringIter != nissanSubversionStrings.end();stringIter++)
    {
        type = mSimulationConfiguration.GetSubversionEnum((*stringIter).c_str());

        CPPUNIT_ASSERT(type == (*enumIter));
        enumIter++;
    }
    CPPUNIT_ASSERT(enumIter == expectedEnumerations.end());
}

void MediaPlayerStartupTest::GetSubversionNissan_UnknownStringGiven_FailureReturneSubType_Undefined()
{
    ENTRY_TEST
    teSubversionType type = mSimulationConfiguration.GetSubversionEnum("GMP_NisScope3AIVI");
    CPPUNIT_ASSERT(type == eSubType_Undefined);

}
void MediaPlayerStartupTest::GetSubversionNissan_EmptyStringGiven_FailureReturneSubType_Undefined()
{
    ENTRY_TEST
    teSubversionType type = mSimulationConfiguration.GetSubversionEnum("");
    CPPUNIT_ASSERT(type == eSubType_Undefined);

}
void MediaPlayerStartupTest::GetSubversionNissan_NullPointerGiven_FailureReturneSubType_Undefined()
{
    ENTRY_TEST
    teSubversionType type = mSimulationConfiguration.GetSubversionEnum(NULL);
    CPPUNIT_ASSERT(type == eSubType_Undefined);
}

#ifdef FILEFORMAT_SAVE_RESTORE_IMPLEMENTED
void MediaPlayerStartupTest::SupportVideoFileFormats_BeginIndex13_SuccessAddedVideoFileFormatSupport()
{
    ENTRY_TEST

    FileFormatEntry entry_13_expected,entry_14_expected,entry_15_expected,entry_16_expected,entry_17_expected,entry_18_expected,entry_19_expected;
    entry_13_expected.extension = ".m4v";
    entry_13_expected.fileFormat = FFT_M4V;
    entry_13_expected.fileType = FT_VIDEO;

    entry_14_expected.extension = ".mp4";
    entry_14_expected.fileFormat = FFT_MP4;
    entry_14_expected.fileType = FT_VIDEO;

    entry_15_expected.extension = ".3gp";
    entry_15_expected.fileFormat = FFT_3GP;
    entry_15_expected.fileType = FT_VIDEO;

    entry_16_expected.extension = ".mpeg";
    entry_16_expected.fileFormat = FFT_MPEG;
    entry_16_expected.fileType = FT_VIDEO;

    entry_17_expected.extension = ".mpg";
    entry_17_expected.fileFormat = FFT_MPEG;
    entry_17_expected.fileType = FT_VIDEO;

    entry_18_expected.extension = ".avi";
    entry_18_expected.fileFormat = FFT_AVI;
    entry_18_expected.fileType = FT_VIDEO;

    entry_19_expected.extension = ".wmv";
    entry_19_expected.fileFormat = FFT_WMV;
    entry_19_expected.fileType = FT_VIDEO;

    LocalSPM::GetDataProvider().SupportedFileTypes = 12;

    mSimulationConfiguration.SupportVideoFileFormats();

    FileFormatEntry entry_13,entry_14,entry_15,entry_16,entry_17,entry_18,entry_19;
    entry_13.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_13();
    entry_13.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_13();
    entry_13.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_13();

    entry_14.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_14();
    entry_14.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_14();
    entry_14.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_14();

    entry_15.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_15();
    entry_15.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_15();
    entry_15.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_15();

    entry_16.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_16();
    entry_16.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_16();
    entry_16.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_16();

    entry_17.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_17();
    entry_17.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_17();
    entry_17.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_17();

    entry_18.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_18();
    entry_18.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_18();
    entry_18.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_18();

    entry_19.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_19();
    entry_19.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_19();
    entry_19.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_19();

    CPPUNIT_ASSERT(entry_13_expected.extension == entry_13.extension);
    CPPUNIT_ASSERT(entry_13_expected.fileFormat == entry_13.fileFormat);
    CPPUNIT_ASSERT(entry_13_expected.fileType == entry_13.fileType);

    CPPUNIT_ASSERT(entry_14_expected.extension == entry_14.extension);
    CPPUNIT_ASSERT(entry_14_expected.fileFormat == entry_14.fileFormat);
    CPPUNIT_ASSERT(entry_14_expected.fileType == entry_14.fileType);

    CPPUNIT_ASSERT(entry_15_expected.extension == entry_15.extension);
    CPPUNIT_ASSERT(entry_15_expected.fileFormat == entry_15.fileFormat);
    CPPUNIT_ASSERT(entry_15_expected.fileType == entry_15.fileType);

    CPPUNIT_ASSERT(entry_16_expected.extension == entry_16.extension);
    CPPUNIT_ASSERT(entry_16_expected.fileFormat == entry_16.fileFormat);
    CPPUNIT_ASSERT(entry_16_expected.fileType == entry_16.fileType);

    CPPUNIT_ASSERT(entry_17_expected.extension == entry_17.extension);
    CPPUNIT_ASSERT(entry_17_expected.fileFormat == entry_17.fileFormat);
    CPPUNIT_ASSERT(entry_17_expected.fileType == entry_17.fileType);

    CPPUNIT_ASSERT(entry_18_expected.extension == entry_18.extension);
    CPPUNIT_ASSERT(entry_18_expected.fileFormat == entry_18.fileFormat);
    CPPUNIT_ASSERT(entry_18_expected.fileType == entry_18.fileType);

    CPPUNIT_ASSERT(entry_19_expected.extension == entry_19.extension);
    CPPUNIT_ASSERT(entry_19_expected.fileFormat == entry_19.fileFormat);
    CPPUNIT_ASSERT(entry_19_expected.fileType == entry_19.fileType);

    CPPUNIT_ASSERT(LocalSPM::GetDataProvider().SupportedFileTypes() == 19);
}

void MediaPlayerStartupTest::SupportVideoFileFormats_BeginIndex17_SuccessAddedVideoFileFormatSupport()
{
    ENTRY_TEST

    FileFormatEntry entry_17_expected,entry_18_expected,entry_19_expected,entry_20_expected,entry_21_expected,entry_22_expected,entry_23_expected;
    entry_17_expected.extension = ".m4v";
    entry_17_expected.fileFormat = FFT_M4V;
    entry_17_expected.fileType = FT_VIDEO;

    entry_18_expected.extension = ".mp4";
    entry_18_expected.fileFormat = FFT_MP4;
    entry_18_expected.fileType = FT_VIDEO;

    entry_19_expected.extension = ".3gp";
    entry_19_expected.fileFormat = FFT_3GP;
    entry_19_expected.fileType = FT_VIDEO;

    entry_20_expected.extension = ".mpeg";
    entry_20_expected.fileFormat = FFT_MPEG;
    entry_20_expected.fileType = FT_VIDEO;

    entry_21_expected.extension = ".mpg";
    entry_21_expected.fileFormat = FFT_MPEG;
    entry_21_expected.fileType = FT_VIDEO;

    entry_22_expected.extension = ".avi";
    entry_22_expected.fileFormat = FFT_AVI;
    entry_22_expected.fileType = FT_VIDEO;

    entry_23_expected.extension = ".wmv";
    entry_23_expected.fileFormat = FFT_WMV;
    entry_23_expected.fileType = FT_VIDEO;

    LocalSPM::GetDataProvider().SupportedFileTypes = 16;

    mSimulationConfiguration.SupportVideoFileFormats();


    FileFormatEntry entry_17,entry_18,entry_19,entry_20,entry_21,entry_22,entry_23;

    entry_17.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_17();
    entry_17.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_17();
    entry_17.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_17();

    entry_18.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_18();
    entry_18.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_18();
    entry_18.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_18();

    entry_19.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_19();
    entry_19.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_19();
    entry_19.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_19();

    entry_20.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_20();
    entry_20.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_20();
    entry_20.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_20();

    entry_21.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_21();
    entry_21.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_21();
    entry_21.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_21();

    entry_22.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_22();
    entry_22.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_22();
    entry_22.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_22();

    entry_23.extension = LocalSPM::GetDataProvider().SupportedFileTypeExtension_23();
    entry_23.fileFormat = LocalSPM::GetDataProvider().SupportedFileTypeFormat_23();
    entry_23.fileType = LocalSPM::GetDataProvider().SupportedFileTypeType_23();

    CPPUNIT_ASSERT(entry_17_expected.extension == entry_17.extension);
    CPPUNIT_ASSERT(entry_17_expected.fileFormat == entry_17.fileFormat);
    CPPUNIT_ASSERT(entry_17_expected.fileType == entry_17.fileType);

    CPPUNIT_ASSERT(entry_18_expected.extension == entry_18.extension);
    CPPUNIT_ASSERT(entry_18_expected.fileFormat == entry_18.fileFormat);
    CPPUNIT_ASSERT(entry_18_expected.fileType == entry_18.fileType);

    CPPUNIT_ASSERT(entry_19_expected.extension == entry_19.extension);
    CPPUNIT_ASSERT(entry_19_expected.fileFormat == entry_19.fileFormat);
    CPPUNIT_ASSERT(entry_19_expected.fileType == entry_19.fileType);

    CPPUNIT_ASSERT(entry_20_expected.extension == entry_20.extension);
    CPPUNIT_ASSERT(entry_20_expected.fileFormat == entry_20.fileFormat);
    CPPUNIT_ASSERT(entry_20_expected.fileType == entry_20.fileType);

    CPPUNIT_ASSERT(entry_21_expected.extension == entry_21.extension);
    CPPUNIT_ASSERT(entry_21_expected.fileFormat == entry_21.fileFormat);
    CPPUNIT_ASSERT(entry_21_expected.fileType == entry_21.fileType);

    CPPUNIT_ASSERT(entry_22_expected.extension == entry_22.extension);
    CPPUNIT_ASSERT(entry_22_expected.fileFormat == entry_22.fileFormat);
    CPPUNIT_ASSERT(entry_22_expected.fileType == entry_22.fileType);

    CPPUNIT_ASSERT(entry_23_expected.extension == entry_23.extension);
    CPPUNIT_ASSERT(entry_23_expected.fileFormat == entry_23.fileFormat);
    CPPUNIT_ASSERT(entry_23_expected.fileType == entry_23.fileType);

    CPPUNIT_ASSERT(LocalSPM::GetDataProvider().SupportedFileTypes() == 23);
}

void MediaPlayerStartupTest::SupportVideoFileFormats_BeginIndex14_FailureVideoFileFormatSupportNotAdded()
{
    LocalSPM::GetDataProvider().SupportedFileTypes = 14;

    mSimulationConfiguration.SupportVideoFileFormats();

    CPPUNIT_ASSERT(LocalSPM::GetDataProvider().SupportedFileTypes() == 14);
}
#endif
