/*
 * MediaPlayerStartupTest.h
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#ifndef MEDIAPLAYERSPMREGRESSION_H_
#define MEDIAPLAYERSPMREGRESSION_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"
#include "TypeDefinitions.h"
#include "SimulationConfiguration.h"
#include "SimulationOutputWrapper.h"
#include "SimulationCustomControl.h"

class MediaPlayerSPMRegression : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MediaPlayerSPMRegression );

    CPPUNIT_TEST( InitTestsuite );
    //CPPUNIT_TEST( SPMRegression ); //To be enabled after fixing the test failure
    CPPUNIT_TEST( EndTestsuite );

    CPPUNIT_TEST_SUITE_END(); //lint -e578

public:

    /*SPM test cases*/
    void InitTestsuite();
    void EndTestsuite();
    void SPMRegression();

    /*common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

private:
    void SPMRegressionOn();
    void SPMRegressionOff();
    tResult WaitForPlaytimeUpdate(int sec);

    TimeTrace ticks;    /**< time object to trace the time taken by testcases*/

};

#endif /* MEDIAPLAYERSPMREGRESSION_H_ */
