/*
 * ConfigTestData.h
 *
 *  Created on: July 16, 2019
 *      Author: koe2hi
 */



#include "ConfigTestData.h"
#include "TypeDefinitions.h"



#define TESTDATAPATH_FROMSOURCETREE (char*)"/ai_mediaplayer/components/Customer/Simulation/CustomControl" //depricated
#define TESTDATAPATH_FROMSOFTLINK    (char*)"/ai_mediaplayer/components/GenericMediaPlayer/0_testmedia_softlink"
//#define TESTDATAPATH_FROMARTIFACTORY (char*)"/generated/components/GenericMediaPlayer/artifactory/cmd-media-player/testdata/testdata_basic" //envvar GMP_TESTFILES_BASEPATH used instead

#define TESTDATAPATH TESTDATAPATH_FROMSOFTLINK

void get_testfiles_basepath(OUT char *dest, IN size_t sizeOfDest)
{

    if(dest)
    {
        dest[0]='\0';
#ifdef TARGET_BUILD
        strncpy_r(OUT dest, IN "/opt/bosch/test/data/GMP/", IN sizeOfDest);  //Use Case: Tests running @target
#else

        //check for environment variables
        char *pPath           = getenv("GMP_TESTFILES_BASEPATH"); //Use Case: Tests running in  eclipse genMP_env.sh called which calls eclipse;
        char *pPathBoschSrc   = getenv("_SWROOT");                //Use Case: Tests running after build with bosch environment - Test data still i source tree;
        char *pPathBoschGen   = getenv("_SWBUILDROOT");           //Use Case: Tests running after build with bosch environment ;
        char *pPathSourceTree = getenv("_SWROOT_GMP");

        //genMP_env.sh called which sets pPath
        if(pPath)
        {
            strncpy_r(OUT dest, IN pPath, IN sizeOfDest);
        }
        //set_env.sh called, genMP_env.sh to start eclispe and build. Then call in console ./Debug/MediaPlayer to run tests
        else if( (pPathBoschSrc!=NULL) && (pPathBoschGen!=NULL))
        {
            strncpy_r(OUT dest, IN pPathBoschSrc, IN sizeOfDest);
            strncat_r(OUT dest, IN TESTDATAPATH , IN sizeOfDest);
        }
        //genMP_env.sh to start eclipse and build. Then call in console ./Debug/MediaPlayer to run tests
        else
        {
           //derive from current dirname prepath with ai_mediaplayer and add the rest
           std::string pPathGenMP=get_current_dir_name();
           //find in path ai_mediaplayer and ignore subpath
           std::string basepath0(pPathGenMP);
           std::string searchstr("ai_mediaplayer");
           int pos = basepath0.find(searchstr);

           if(pos != -1)
           {
               std::string basepath1(basepath0, 0, pos);
               strncpy_r(OUT dest, IN basepath1.c_str(), IN sizeOfDest);
               strncat_r(OUT dest, IN TESTDATAPATH_FROMSOFTLINK, IN sizeOfDest);
           }
           else
           {
               cout << "[ERROR] no path available to test data (CppUnitDefinitions.cpp: get_testfiles_basepath())" << endl;
           }
        }

        cout << "CppUnitDefinitions.cpp: get_testfiles_basepath() : " << dest << endl;


#endif
    }


}


void add_testfiles_basepath(OUT char *dest, IN char *testfile, IN size_t sizeOfDest)
{
    get_testfiles_basepath(dest,sizeOfDest);
    if(testfile)
    {
        strncat_r(OUT dest, IN testfile, IN sizeOfDest);
    }
    else
    {
        MP_NORMAL_ASSERT(0);
        #ifndef TARGET_BUILD
           cout << "[ERROR] testfile==NULL (CppUnitDefinitions.cpp: add_testfiles_basepath())" << endl;
        #endif
    }

}



