/**
 * @defgroup SimulationConfiguration Configuration
 * @author Stefan Scherber, Matthias Thömel
 *
 * Public interface for configuration of the simulation
 * @{
 */
#include "ConfigTest.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SimulationConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "DataProvider.h"
#include "SimulationConfiguration.h"
#include "LocalSPM.h"
#include "FunctionTracer.h"

//todo(pee1cob):reorder subversionValueDescription - relative version kept sequential
trSubVersionValueDescription SimulationConfiguration::m_rSubVersionValueDescriptions[eSubTypeLastElem] =
{
        //enum                                                Registry name                               Description                                                                                                  Use Registry (alternative is to harcoded feature set for this subversion (level1 implementation))
        {eSubType_Undefined                              , "-"                              ,"KDS-entry has value 'undefined' hence default setting is used", FALSE },
        {eSubType_NisScope1                              , "GMP_NisScope1"                  ,"KDS-entry has value GMP_NisScope1.reg"                        , FALSE /*false means use corresponding LoadSettingsSubVersion and not registry to fill configuration*/},
        {eSubType_NisScope2                              , "GMP_NisScope2"                  ,"KDS-entry has value GMP_NisScope2.reg"                        , FALSE },
        {eSubType_NisScope2_1AIVI                        , "GMP_NisScope2_1AIVI"            ,"KDS-entry has value GMP_NisScope2_1AIVI.reg"                  , FALSE },
        {eSubType_GMP_NisScope2_WO_iAP1                  , "GMP_NisScope2_WO_iAP1"          ,"KDS-entry has value GMP_NisScope2_WO_iAP1.reg"                , FALSE },
        {eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID           , "GMP_NisSC2_1AIVI_WO_iAP1_VID"   ,"KDS-entry has value GMP_NisSC2_1AIVI_WO_iAP1_VID.reg"         , FALSE },
        {eSubType_GMP_NisScope3AIVI_WO_iAP1              , "GMP_NisScope3AIVI_WO_iAP1"      ,"KDS-entry has value GMP_NisScope3AIVI_WO_iAP1.reg"            , FALSE },
        {eSubType_GMP_NisSC3AIVI_WO_iAP1_VID             , "GMP_NisSC3AIVI_WO_iAP1_VID"     ,"KDS-entry has value GMP_NisSC3AIVI_WO_iAP1_VID.reg"           , FALSE },
        {eSubType_NisScope2_1RENAULT                     , "GMP_NisScope2_1RENAULT"         ,"KDS-entry has value GMP_NisScope2_1RENAULT.reg"               , FALSE },
        {eSubType_GMP_NisScope3RENAULT_WO_iAP1           , "GMP_NisScope3RENAULT_WO_iAP1"   ,"KDS-entry has value GMP_NisScope3RENAULT_WO_iAP1.reg"         , FALSE },
        {eSubType_GMP_NisScope2_1RENAULT_WO_iAP1         , "GMP_NisScope2_1RENAULT_WO_iAP1" ,"KDS-entry has value GMP_NisScope2_1RENAULT_WO_iAP1.reg"       , FALSE },
        {eSubType_GMP_NisScope2_1AIVI_WO_iAP1            , "GMP_NisScope2_1AIVI_WO_iAP1"    ,"KDS-entry has value GMP_NisScope2_1AIVI_WO_iAP1.reg"          , FALSE },
        {eSubType_NIS_PIVI                               , "GMP_Nis_PIVI"                   ,"KDS-entry has value GMP_Nis_PIVI.reg"                         , FALSE },
        {eSubType_GMP_Nis_PIVI_WO_iAP1                   , "GMP_Nis_PIVI_WO_iAP1"           ,"KDS-entry has value GMP_Nis_PIVI_WO_iAP1.reg"                 , FALSE },
        {eSubType_GMP_Nis_PIVI_WO_iAP1_VID               , "GMP_Nis_PIVI_WO_iAP1_VID"       ,"KDS-entry has value GMP_Nis_PIVI_WO_iAP1_VID.reg"             , FALSE },
        {eSubType_NisSC2_1AIVI_VID                       , "GMP_NisSC2_1AIVI_VID"           ,"KDS-entry has value GMP_NisSC2_1AIVI_VID.reg"                 , FALSE },
        {eSubType_NisScope3AIVI_VID                      , "GMP_NisSC3AIVI_VID"             ,"KDS-entry has value GMP_NisSC3AIVI_VID.reg"                   , FALSE },
        {eSubType_Nis_PIVI_VID                           , "GMP_Nis_PIVI_VID"               ,"KDS-entry has value GMP_Nis_PIVI_VID.reg"                     , FALSE }
};

SimulationConfiguration::SimulationConfiguration(tComponentID componentId):Configuration(componentId)
{
    ENTRY
    
    PreLoadSettings();
}

tResult SimulationConfiguration::PreLoadSettings(void) // finished: 100%
{
    ENTRY

    //LocalSPM::GetDataProvider().UseMediaEngine = 0; // default: 1
    LocalSPM::GetDataProvider().SyncMediaEngineStartup = 0; // default: 1

    LocalSPM::GetDataProvider().SupportedDeviceTypes = 9;
    LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
    LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
    LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
    LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
    LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_MTP;
    LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDDA;
    LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_BLUETOOTH;
    LocalSPM::GetDataProvider().SupportedDeviceType_08 = DTY_FLASH;
    LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_DVD_DRIVE;

    LocalSPM::GetDataProvider().UsePictureManager = 1;

    //LocalSPM::GetDataProvider().ContentSharingEnabled = 1;
    LocalSPM::GetDataProvider().UseDVDControl = 0;
    LocalSPM::GetDataProvider().CDRippingSupport = 0;
    LocalSPM::GetDataProvider().YearMetadataSupported = 1;
    LocalSPM::GetDataProvider().CoverArtFlow = 1;
    LocalSPM::GetDataProvider().AlbumArtThumbnail = 1;
	LocalSPM::GetDataProvider().PermanentStreamingDeviceTypes = 4;

    LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB = 10;
    LocalSPM::GetDataProvider().MaxNoOfDevicesInDB = 21;


    return MP_NO_ERROR;
}

tResult SimulationConfiguration::LoadSettings(void)
{
    ENTRY

    // simulate config settings for GMP simulation test run

    //Do we start playback automatically if last mode is paused
    LocalSPM::GetDataProvider().AutoPlayInLastModePause = 1;

    //Do we continue cueing at the end/begin of a media object while ffwd/frev is ongoing
    LocalSPM::GetDataProvider().ContinuousCueing = 1;

    // Roadmap 13016 PreviousInShuffledList - stack length
    LocalSPM::GetDataProvider().ShuffleSkippingStackLength = 5;

    // timeout for custom control to wait for desired device
    // initially set to 0 to disable the timeout. the timeout test will set it to another value
    // and will restart the custom control SM
    LocalSPM::GetDataProvider().StartupTimeMS = 0L;

    // supported recurse level concatenated playlists
    LocalSPM::GetDataProvider().DBVTFileMaxDepthForPlaylistRecurse = 2;

    LocalSPM::GetDataProvider().SearchForFirstPlayableFile = 0;

    LocalSPM::GetDataProvider().AlbumArtFromFromSeparateFile = 1;

    LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename = 0;

    LocalSPM::GetDataProvider().SetVideoProperty = 0;
	
	//The default value changed to 0 for feature branches.
	LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 1;

    LocalSPM::GetDataProvider().UnitTestEnabled = 1;

    return MP_NO_ERROR;
}

void sortlib_initialize_sort_table( unsigned sortTable[] );//Prototype

void SimulationConfiguration::CreateSortlibRuleTable()
{
    sortlib_initialize_sort_table(sortTable);
}

teSubversionType SimulationConfiguration::GetSubversionEnum(const char* subversionString)
{
    ENTRY

    teSubversionType type = eSubType_Undefined;

    int stringLength = strlen_r(subversionString);
    if(stringLength)
    {
        ETG_TRACE_USR2(("subversionString :%s",subversionString));

        unsigned int iter;
        for(iter = eSubType_Undefined ;iter < eSubTypeLastElem; iter++)
        {
            if(!strcmp(subversionString, (m_rSubVersionValueDescriptions[iter].strBoundRegistryValue.c_str())))
            {
                ETG_TRACE_USR2(("GetSubversionEnum: %d",ETG_CENUM(teSubversionType,m_rSubVersionValueDescriptions[iter].enSubType)));
                type = m_rSubVersionValueDescriptions[iter].enSubType;
                break;
            }
        }
        if(iter == eSubTypeLastElem)
        {
            ETG_TRACE_ERR(("No Subversion Enum defined for given subversionString"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("subversionString Length is zero"));
    }

    return type;
}

void SimulationConfiguration::SupportVideoFileFormats()
{
    ENTRY

    int beginIndex = (LocalSPM::GetDataProvider().SupportedFileTypes() +1);//Start with index following the current last index of the supportedFileTypes
    if((13 == beginIndex) || (17 == beginIndex))
    {
        if(13 == beginIndex)
        {
            SUPPORTED_FILE_TYPE(13, ".m4v", FFT_M4V, FT_VIDEO);
            SUPPORTED_FILE_TYPE(14, ".mp4", FFT_MP4, FT_VIDEO);
            SUPPORTED_FILE_TYPE(15, ".3gp", FFT_3GP, FT_VIDEO);
            SUPPORTED_FILE_TYPE(16, ".mpeg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(17, ".mpg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(18, ".avi", FFT_AVI, FT_VIDEO);
            SUPPORTED_FILE_TYPE(19, ".wmv", FFT_WMV, FT_VIDEO);
        }
        else
        {
            SUPPORTED_FILE_TYPE(17, ".m4v", FFT_M4V, FT_VIDEO);
            SUPPORTED_FILE_TYPE(18, ".mp4", FFT_MP4, FT_VIDEO);
            SUPPORTED_FILE_TYPE(19, ".3gp", FFT_3GP, FT_VIDEO);
            SUPPORTED_FILE_TYPE(20, ".mpeg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(21, ".mpg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(22, ".avi", FFT_AVI, FT_VIDEO);
            SUPPORTED_FILE_TYPE(23, ".wmv", FFT_WMV, FT_VIDEO);
        }
        LocalSPM::GetDataProvider().SupportedFileTypes = LocalSPM::GetDataProvider().SupportedFileTypes() + 7; //In addition to other filetypes ,7-FT_VIDEO are also supported
    }
    else
    {
        ETG_TRACE_ERR(("SupportVideoFileFormats beginIndex is currently not supported"));
    }
}

/** @} */
