#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SMARTConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif
#endif

#include "SMARTConfiguration.h"
#include "DataProvider.h"
#include "LocalSPM.h"

#include "FunctionTracer.h"
#include "VarTrace.h"
#include "ReaderKDS.h"

#include "ilm_client.h"
#include "ilm_control.h"
#include "ilm_common.h"

// Includes all header files for FI of datapool
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


#define GENERIC_KDSADRESS 0xA0C1
//#define MCH_MITSUMI_HUB_VER2 //first trial. Hub usable carplay possible with port in the middle
#define VARIANTCODING_CD 0x08
#define VARIANTCODING_DVD 0x80
const tUInt screenID =1;
enum
{
    enUNDEF = 0x00,   //i.e. not applicable
    enEU    = 0x01,
    enGEX   = 0x02,
    enChina = 0x03
};

CustomerConfiguration::CustomerConfiguration(tComponentID componentId):Configuration(componentId)
{
    ENTRY

    PreLoadSettings();
}

tResult CustomerConfiguration::PreLoadSettings(void) // finished: 100%
{
    ENTRY
    ReaderKDS oPersistentReader;
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH] = {0};
    tU16  l_u8ByteNum      = 32;
    tU16 l_KDSAddress     = 0x0DF4;//CMVariantCoding


    tU8 CMVariantType=0;

    ETG_TRACE_COMP(("CMVariantCoding(NIS): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("CMVariantCoding(NIS): l_KDSAddress:0x%x read, l_u8PayloadByte:%d start reading",l_KDSAddress, l_u8ByteNum));
    if(TRUE == oPersistentReader.bReadKDS(IN  l_KDSAddress/*address*/, IN l_u8ByteNum, OUT l_u8Array))
    {
        CMVariantType = l_u8Array[4];
        ETG_TRACE_COMP(("CMVariantCoding(NIS):%d", CMVariantType));

    }
    //LocalSPM::GetDataProvider().UseMediaEngine = 0; // default: 1
    LocalSPM::GetDataProvider().PEConfigDisplayLayer_01 = 3300; // 0x0ce4
    LocalSPM::GetDataProvider().VideoLayerName = "0x0ce4";
    LocalSPM::GetDataProvider().CueingRate = 16;
    LocalSPM::GetDataProvider().PEConfigRampStepPercentage_01 =   100; /**< percentage of speed */
    LocalSPM::GetDataProvider().PEConfigRampStepDuration_01   = 16000; /**< duration in milliseconds */
    LocalSPM::GetDataProvider().PEConfigRampStepPercentage_02 =   -1; /**< percentage of speed */
    LocalSPM::GetDataProvider().PEConfigRampStepDuration_02   = -1; /**< duration in milliseconds */
    //LocalSPM::GetDataProvider().MediaEngineProcessPriority =  "99"; // maximum priority; RT in top; default: 30;
    //LocalSPM::GetDataProvider().MediaEngineProcessNiceness = "-20"; // minimum niceness; default: -4;

    GetMFiCertificationStatus(); //Get MFiCertification from KDS
    //NOTE: GetMFiCertificationStatus() must be called before setting SupportedDeviceTypes
    SetSupportedDeviceTypes(); //Set Supported device type based on MFiCertification

    LocalSPM::GetDataProvider().CoverArtFlow = 1;
    LocalSPM::GetDataProvider().AlbumArtThumbnail = 1;
    LocalSPM::GetDataProvider().UsePictureManager = 1;  //Enabled As FT_IMAGE Supported for 2.1 Renault
    LocalSPM::GetDataProvider().MediaEngineUseFork = 1;
    // activate usage of RootDaemon;
    LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;
    LocalSPM::GetDataProvider().UnmuteRampTypeForStartOfTrack = FAST_RAMP; // Fast ramp for start of the track

    GetResolution();


    return MP_NO_ERROR;
}


tResult CustomerConfiguration::LoadSettings(void)
{
    ENTRY

    ETG_TRACE_USR2(("Load settings : Common load settings"));

    LocalSPM::GetDataProvider().FavoritesSupported = 0;
    LocalSPM::GetDataProvider().FavGenreSupported = 0;
    LocalSPM::GetDataProvider().FavArtistsSupported = 0;
    LocalSPM::GetDataProvider().FavAlbumsSupported = 0;
    LocalSPM::GetDataProvider().FavSongsSupported = 0;
    LocalSPM::GetDataProvider().FavPlaylistsSupported = 0;
    LocalSPM::GetDataProvider().FavPodcastsSupported = 0;
    LocalSPM::GetDataProvider().FavAudiobooksSupported = 0;
    LocalSPM::GetDataProvider().FavVideosSupported = 0;

    LocalSPM::GetDataProvider().GBKSupported = 0;

    LocalSPM::GetDataProvider().MyMediaVisible = 0;

    LocalSPM::GetDataProvider().PlayObjectFromActiveDevice = 1;
    LocalSPM::GetDataProvider().PrevBufferTime = 3000;
    LocalSPM::GetDataProvider().iPodControlPrevBufferTimeMS = 3000;

    LocalSPM::GetDataProvider().DBVTFileMaxDepthForScan = 9;

    LocalSPM::GetDataProvider().FileFilterCount = 4;
    LocalSPM::GetDataProvider().FileFilter_01 = "^\\.";
    LocalSPM::GetDataProvider().FileFilter_02 = "recycle";
    LocalSPM::GetDataProvider().FileFilter_03 = "CRYPTNAV";
    LocalSPM::GetDataProvider().FileFilter_04 = "TrueDelete";

    SetIndexingSupportedDevices(); //Set Indexing supported devices based on MFiCertified KDS value

    LocalSPM::GetDataProvider().SupportedFileSystems   = 4;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_EXT4; //FSTY_EXT4
    LocalSPM::GetDataProvider().SupportedFileSystem_04 = FSTY_HFS; //FSTY_HFS
    LocalSPM::GetDataProvider().SupportedFileSystem_05 = FSTY_UNKNOWN; //FSTY_EXFAT
    LocalSPM::GetDataProvider().SupportedFileSystem_06 = FSTY_UNKNOWN; //FSTY_ISO9660
    LocalSPM::GetDataProvider().SupportedFileSystem_07 = FSTY_UNKNOWN; //FSTY_UDF

    SetPermanentStreamingDeviceTypes(); //Set Permanent Streaming devices based on MFiCertified KDS value

    LocalSPM::GetDataProvider().LimitNumberObjectsPerDevice = 32000;
    LocalSPM::GetDataProvider().LimitNumberObjectsInDB = 100000;

    LocalSPM::GetDataProvider().NowPlayingUnknownText = "UNKNOWN";

    LocalSPM::GetDataProvider().SupportedFileTypes = 15;
    SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
    SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
    SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
    SUPPORTED_FILE_TYPE(05, ".aiff",FFT_AIFF, FT_AUDIO);
    SUPPORTED_FILE_TYPE(06, ".aif",FFT_AIFF, FT_AUDIO);
    SUPPORTED_FILE_TYPE(07, ".m3u", FFT_M3U, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(08, ".pls", FFT_PLS, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(09, ".xspf", FFT_XSPF, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(10, ".wpl", FFT_WPL, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(11, ".b4s", FFT_B4S, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(12, ".asx", FFT_ASX, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(13, ".wav", FFT_WAV, FT_AUDIO);
    SUPPORTED_FILE_TYPE(14, ".flac", FFT_FLAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(15, ".3gp", FFT_3GP, FT_VIDEO);

    LocalSPM::GetDataProvider().UnsupportedDeviceTypeVisible = 1;
    LocalSPM::GetDataProvider().UnsupportedFileSystemVisible = 1;
    LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename = 0;
    LocalSPM::GetDataProvider().FileErrorHandling = FEH_MARK_OBJECT_PERMANENT;
    //LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL; -> since default should be RPT_LIST_WITH_SUBLISTS for scope 2.1 Renault
    LocalSPM::GetDataProvider().ClearPlaybackMode = 0;
    LocalSPM::GetDataProvider().ClearRepeatMode = 0;
    LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    LocalSPM::GetDataProvider().DBFileListWhileIndexing = 1;


    LocalSPM::GetDataProvider().iPodControlAppInfos   = 1;
    LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "rcconn";
    LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.bosch.rcconn";
    LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "EJBH66899E";//"com.suzuki.remotecontrolapp";
    LocalSPM::GetDataProvider().iPodControlAppInfoOption_1 = AIO_DEVICE_MODE_ONLY;
    LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 1;   /**< enable iAP2 app control */
    LocalSPM::GetDataProvider().iPodControlIAP2CheckRoleSwitchRequired = 1; /**< CarPlay speed up */
    LocalSPM::GetDataProvider().iPodControlIAP2CheckRoleSwitchRequiredTimeOutMS = 0; /**< no timeout, wait for user choice */
    LocalSPM::GetDataProvider().iPodControlIAP2BatchLimit = 500; /**< batch size reduced according to NCG3D-3411 */
    LocalSPM::GetDataProvider().iPodCommunicationError = 1;      /* CMG3G-8083 iPod Communication Error to HMI */
    LocalSPM::GetDataProvider().DipoCommunicationError = 1;      /* DIPO Communication Error for SPI */
    LocalSPM::GetDataProvider().iPodControlGPRMCDataStatusValuesNotification = 1;     /**< Enable GPRMC DataStatus Values Notification */
    LocalSPM::GetDataProvider().iPodControlSupportIAP1 = 0; /*Disable iAP1 support RTC-Bug 469591 */

    LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled = 0; // RTC-913130: Disable Start/Stop Route Guidance Updates

    if(!m_MFiCertified)
    {
        LocalSPM::GetDataProvider().iPodControlSupportIAP2 = 0; /*Disable iAP2 support */
    }

    LocalSPM::GetDataProvider().iPodControlAlbumArtWaitTimer = 1; //RTC-992278: Enable to send proper AlbumArt string
    LocalSPM::GetDataProvider().MicroMutes = 1;//Enable micromute option

    iPodControl::ReadAuthParameterFromRootFS(); //apply values from /etc/pfcfg/IPOD_AUTH.cfg

    LocalSPM::GetDataProvider().MultipleNextWaitTime = 0;            /**< multiple next disabled */
    LocalSPM::GetDataProvider().ScaleUpAlbumArt = 0;
    LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext = 1;   /**< enable ignore of RPT_ONE in case of user Next/Prev */
    LocalSPM::GetDataProvider().SaveLastModeInNotActive = 1;

    LocalSPM::GetDataProvider().ShuffleReshuffleOnListWrap = 1; /* switch on reshuffling on wrap around shuffled lists */

    LocalSPM::GetDataProvider().FFVolumeReduction = 1;
    LocalSPM::GetDataProvider().FFVolumeReductionDB = -12;

    LocalSPM::GetDataProvider().InformVideoFileAsAudio = 1; /*for 3gp video files to be listed and played as audio files */

    //enable CDDA real device
    //LocalSPM::GetDataProvider().CDDAUseRealDevice = 1;

    /* codec restrictions (no., codec, profile, supported, maxLevel, maxWidth, maxHeight, maxBitRate, maxFrameRate) */
    //CODEC_RESTRICTION(01, CDC_MPEG4,    "SIMPLE",      1,   6, 1920, 1080, 40000000, 30);
    //CODEC_RESTRICTION(02, CDC_MPEG4,    "ADVANCED",    1,   6, 1920, 1080, 40000000, 30);   //ADVANCED=ADVANCED SIMPLE
    //CODEC_RESTRICTION(03, CDC_DIVX,     "QMOBILE",     0,  -1,  176,  144,   460000, 15);   //Not supported
    //CODEC_RESTRICTION(04, CDC_DIVX,     "MOBILE",      0,  -1,  320,  240,  1240000, 30);   //Not supported
    //CODEC_RESTRICTION(05, CDC_DIVX,     "HOMETHEATRE", 0,  -1,  720,  576,  6000000, 25);   //Not supported
    CODEC_RESTRICTION(06, CDC_XVID,     "MOBILE",      0,  -1,  352,  288,  1300000, 25);   //Not supported
    CODEC_RESTRICTION(07, CDC_XVID,     "PORTABLE",    0,  -1,  640,  480,  4800000, 30);   //Not supported
    CODEC_RESTRICTION(08, CDC_XVID,     "HOME",        0,  -1,  720,  576,  4800000, 25);   //Not supported
    //CODEC_RESTRICTION(09, CDC_AVC,      "CONSTRAINED", 1, 4.2, 1920, 1080, 50000000, 30);   //CONSTRAINED=CONSTRAINED BASELINE
    //CODEC_RESTRICTION(10, CDC_AVC,      "BASELINE",    1, 4.2, 1920, 1080, 50000000, 30);
    //CODEC_RESTRICTION(11, CDC_AVC,      "MAIN",        1, 4.2, 1920, 1080, 50000000, 30);
    //CODEC_RESTRICTION(12, CDC_AVC,      "HIGH",        1, 4.2, 1920, 1080, 62500000, 30);
    //CODEC_RESTRICTION(13, CDC_WMV7,     "",            0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(14, CDC_WMV8,     "",            0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(15, CDC_WMV9,     "SIMPLE",      1,  -1,  352,  288,   384000, 15);   //No maxLevel restriction (only MEDIUM, but which number is it?)
    //CODEC_RESTRICTION(16, CDC_WMV9,     "MP",          1,  -1, 1920, 1080, 20000000, 30);   //MP=MAIN, no maxLevel restriction (only MEDIUM, but which number is it?)
    //CODEC_RESTRICTION(17, CDC_WMV9,     "ADVANCED",    1,  -1, 1920, 1080, 45000000, 30);
    //CODEC_RESTRICTION(18, CDC_VP6,      "SIMPLE",      0,  -1,  720,  576,   768000, 25);   //Not supported
    //CODEC_RESTRICTION(19, CDC_VP6,      "ADVANCED",    0,  -1,  720,  576,   768000, 25);   //Not supported
    //CODEC_RESTRICTION(20, CDC_SORENSON, "",            0,  -1,  720,  576,  6000000, 25);   //Not supported
    CODEC_RESTRICTION(21, CDC_H263,     "0",           0,  70, 1408, 1152,  6000000, 25);   //0=0 BASELINE, not supported
    CODEC_RESTRICTION(22, CDC_H263,     "3",           0,  70, 1408, 1152, 20000000, 30);   //Not supported
    //CODEC_RESTRICTION(23, CDC_VP8,      "",            0,  -1, 1280,  720, 20000000, 30);   //Not supported
    //CODEC_RESTRICTION(24, CDC_MPEG2,    "",            1,  -1, 1920, 1080, 50000000, 30);   //No maxLevel restriction
    //CODEC_RESTRICTION(25, CDC_WMA,      "VERSION 1",   0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(26, CDC_WMA,      "VERSION 3",   0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(27, CDC_WMA,      "VERSION 4",   0,   0,    0,    0,        0,  0);   //Not supported
    //LocalSPM::GetDataProvider().CodecRestrictions = 27;

    LocalSPM::GetDataProvider().FallbackActions = 5;             /* number of fallback actions */
    LocalSPM::GetDataProvider().FallbackInAction_01 = CTA_PLAY_DB_LAST_MODE_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_01 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_02 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_02 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_03 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_03 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_04 = CTA_PLAY_DB_ALL_VIDEOS_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_04 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_05 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_05 = CTA_PLAY_FOLDER_STREAMING_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_06 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_06 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackInAction_07 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_07 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackInAction_08 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_08 = CTA_NONE;

    LocalSPM::GetDataProvider().ListSelectionTableColumns = 6;
    LocalSPM::GetDataProvider().ListSelectionTableRows = 12;
    LocalSPM::GetDataProvider().ListSelectionTableUsedCriteria = "10,11,12,13";
    //USB
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_01 = CTP_USB;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_01 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_01 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_02 = CTP_USB;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_02 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_02 = CTA_PLAY_DB_LAST_MODE_LIST;
    //MTP
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_03 = CTP_MTP;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_03 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_03 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_04 = CTP_MTP;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_04 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_04 = CTA_PLAY_DB_LAST_MODE_LIST;
    //iPod
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_05 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_05 = "0,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_05 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_06 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_06 = "0,1,-1,1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_06 = CTA_PLAY_DB_LAST_MODE_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_07 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_07 = "0,1,-1,0";
    LocalSPM::GetDataProvider().ListSelectionTableAction_07 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_08 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_08 = "1,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_08 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    //Bluetooth
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_09 = CTP_BT;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_09 = "0,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_09 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_10 = CTP_BT;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_10 = "1,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_10 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    //CDDA
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_11 = CTP_CDDA;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_11 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_11 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_12 = CTP_CDDA;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_12 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_12 = CTA_PLAY_DB_LAST_MODE_LIST;

    LocalSPM::GetDataProvider().AVRCPLowerProfileSupported = 1;
    LocalSPM::GetDataProvider().FirstAvailableCoverArtSupport = 1;

    LocalSPM::GetDataProvider().UseArlSrcBtAudio = 1;

    /*Enabling codesetconversion(if not in UTF-8 format)of media metadata depending on System Language - CMG3G-6919*/
    LocalSPM::GetDataProvider().CodeSetConversionSupported = 1;
    LocalSPM::GetDataProvider().RemoteActivitySupportForNonAppleDevice = 1;
    LocalSPM::GetDataProvider().AutoPlayBTOnRequestviaSiri = 1;
    LocalSPM::GetDataProvider().DBUnknownText = "Unknown";

    LocalSPM::GetDataProvider().SetDefaultRepeatModeToRPTListAppleDevice = 0;
    LocalSPM::GetDataProvider().BTAudioSourceAsStatic = 1;

    LocalSPM::GetDataProvider().KeepLastPlaybackStateForStreamingDevicesEnabled = 1;
    LocalSPM::GetDataProvider().MaximumMTPFileSizeInMB = 10;

    CheckBluetoothStack();
    LocalSPM::GetDataProvider().IgnoreSpecialCharachters = 1;
    LocalSPM::GetDataProvider().BtNowPlayingListSupport = 0;
    LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled = 1;


    //IAP2BT Support only for smart apps.
    LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp = 1;

    //SPP connection request
    LocalSPM::GetDataProvider().RequestIAP2SPPConnection = 1;

    //Disable RequestAppLaunch :  NCG3D-41348
    LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 1;

    //Add Device Syspath to DeviceInfo structure and send to clients in MediaplayerDeviceConnections-  CRQ  CMG3G-12660
    LocalSPM::GetDataProvider().AddDeviceSysPath = 1;

    //Ignore IAP to BT fallback on failure of IAP device initialization  (IAP device connected via Bluetooth)
    LocalSPM::GetDataProvider().IgnoreBTfallbackFromIAP = 1;

    // Play Back mass storage device while no list is available
    LocalSPM::GetDataProvider().PlayOnUserRequestWhenListFinished = 1;

    //Roleswitch request for Carlife app
    //LocalSPM::GetDataProvider().iPodControlSupportCarlife = 1;

    LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT = 1;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled = 1; /**< Enable DelPhi Hub support */

    LocalSPM::GetDataProvider().VideoIndexingOn = 0;

    //Enable ConfigFS
    LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 1;

    LocalSPM::GetDataProvider().iPodControliAP2ProductPlanUUID = "817a8727";

    //Fix for RTC1-665437 MultiPartitionSupport Enabled
    LocalSPM::GetDataProvider().MultiPartitionSupported = 1;

    //Enabled BT CoverArt feature
    LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt = 1;

    //Enabled Wired CarPlay
    LocalSPM::GetDataProvider().iPodControlWiredCarPlayEnabled = 1;

    LocalSPM::GetDataProvider().updateReadyToPlay = 1;

    // Fix for Audio Ramp issue
    LocalSPM::GetDataProvider().ExclusiveAlsaDevice = 0;

    //read persistent settings from KDS
    GetAllianceMCH1MountType();
    GetManufacturerandModelName();
    GetSerialNumber();
    GetAccessoryHwFwVersion();
    GetGNSSMountedInfo();
    GetCarPlayWirelessFeature(); // Fix for CRQ: 688345 Enable Carplay wireless feature support for SMART project in MP

    return MP_NO_ERROR;
}



void sortlib_initialize_sort_table( unsigned sortTable[] );//Prototype

void CustomerConfiguration::CreateSortlibRuleTable()
{
    sortlib_initialize_sort_table(sortTable);

}
void CustomerConfiguration::GetDVDRegionCode()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA110
        Identifier: Identifier ($DAB1)
        byte index 28 of 64 byte array
        Bit 0,1,2
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8ByteNum      = 28;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    memset(l_u8Array,0,sizeof(l_u8Array));//CID 185327 : Memset fill value of '0'

    ETG_TRACE_COMP(("GetDVDregioncode(SMART): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetDVDregioncode(SMART): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        tU8 CMRegionCode = l_u8Array[l_u8ByteNum];
        ETG_TRACE_COMP(("CMRegionCode byte(SMART):%d", CMRegionCode));
        CMRegionCode = CMRegionCode & 0x07 ;
        ETG_TRACE_COMP(("CM DVD RegionCode(SMART):%d", CMRegionCode));
        LocalSPM::GetDataProvider().DVDRegionCode  = CMRegionCode ;

    }
    else
    {
        ETG_TRACE_FATAL (("GetDVDregioncode(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetDVDregioncode(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}
void CustomerConfiguration::GetCarPlayWirelessFeature()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA110
        Identifier: Identifier ($DAB1)
        byte index 58 of 64 byte array
        Bit 1
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 58;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    memset(l_u8Array,0,sizeof(l_u8Array));//CID 185463 : Memset fill value of '0'

    ETG_TRACE_COMP(("GetCarPlayWirelessFeature(SMART): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetCarPlayWirelessFeature(SMART): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        bool isCPWBitEnabled = 0;
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];
        isCPWBitEnabled = l_u8PayloadByte & 0x02;


        if(l_u8PayloadByte & 0x02)  // bit 1 is Wireless_Carplay_function.
        {
            LocalSPM::GetDataProvider().iPodControlCarPlayWifiEnabled = 1;
            LocalSPM::GetDataProvider().MaxNoOfDevicesInDB = 21;
            LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB = 10;
        }
        ETG_TRACE_COMP(("GetCarPlayWirelessFeature(SMART): byte 58 data: %d, CPW bit %d",l_u8PayloadByte, isCPWBitEnabled));
    }
    else
    {
        ETG_TRACE_FATAL (("GetCarPlayWirelessFeature(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetCarPlayWirelessFeature(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}

void CustomerConfiguration::GetAllianceMCH1MountType()
{
    ENTRY

    tU8 MCH1Mount = 0;

    /*
    Identifier: Identifier ($3000)
    byte index 29
    Bit 2-3

    AllianceMCH1MountType
    [0x00] No MCH1 mounted in car
    [0x01] 1 USB port (MCH1, w/o HUB)
    [0x02] 2 USB ports (MCH1, with HUB)
    [0x03] 1 USB port (MCH1, with HUB)
    */

    LocalSPM::GetDataProvider().AvailableCurrentDefault = 500; //mA

    tS32 s32Res = DP_s32GetConfigItem("SystemConfiguration1", "MCH1MountInformation", &MCH1Mount, sizeof(tU8));

    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_COMP(("GetAllianceMCH1MountType AllianceMCH1MountType(SMART):%d ", MCH1Mount));

        if(MCH1Mount == 0X02 || MCH1Mount == 0X03)
        {
            LocalSPM::GetDataProvider().AvailableCurrentDefault = 2400; //mA
            ETG_TRACE_COMP(("GetAllianceMCH1MountType(SMART): USB 2.4A charging"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetAllianceMCH1MountType: Could not read MCH1MountInformation with 'DP_s32GetConfigItem'"))
    }
}
void CustomerConfiguration::GetResolution()
{
    ENTRY
    tUInt pWidth,pHeight;
    ilm_init();

    if (ilm_getScreenResolution(screenID,&pWidth, &pHeight) != 0)
    {
        ETG_TRACE_USR2(("ilm_getScreenResolution failed"));
    }
    else
    {
        LocalSPM::GetDataProvider().PEConfigDisplayWidth_01 = pWidth;
        LocalSPM::GetDataProvider().PEConfigDisplayHeight_01 = pHeight;
        ETG_TRACE_COMP(("GetResolution(RIVI): PEConfigDisplayWidth_01:%d",pWidth));
        ETG_TRACE_COMP(("GetResolution(RIVI): PEConfigDisplayHeight_01:%d",pHeight));
    }
}

void CustomerConfiguration::GetManufacturerandModelName()
{
    ENTRY;

    /*
    reference see: DAI_SMART_G3INF4CV_PD_v2.13.pdf

    Identifier: SmartphoneIntegration ($811C)
    Byte index: 54 to 103 ( manufacturerName )
     */

    tU8  l_u8ManufacturerName[KDS_MAX_ENTRY_LENGTH] = {0};
    tS32 s32Res = DP_s32GetConfigItem("SmartphoneIntegration", "ManufacturerName", l_u8ManufacturerName, KDS_MAX_ENTRY_LENGTH);

    if ( DP_S32_NO_ERR == s32Res )
    {
        ETG_TRACE_COMP(("SmartphoneIntegration_ManufacturerName(SMART):%s ", l_u8ManufacturerName));

        string tmp = string((const char*)l_u8ManufacturerName);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer = tmp;
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetManufacturerandModelName: Could not read manufacturerName with 'DP_s32GetConfigItem'"))
    }

    ETG_TRACE_COMP((" iPodControlAccessoryInfoManufacturer : %s ", LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str()));

    /*
    reference see: DAI_SMART_G3INF4CV_PD_v2.13.pdf

    Identifier: SmartphoneIntegration ($811C)
    Bytes: 104 to 153 ( manufacturerModelName  )
     */

    tU8  l_u8ModelName[KDS_MAX_ENTRY_LENGTH] = {0};
    s32Res = DP_s32GetConfigItem("SmartphoneIntegration", "ManufacturerModelName", l_u8ModelName, KDS_MAX_ENTRY_LENGTH);

    if ( DP_S32_NO_ERR == s32Res )
    {
        ETG_TRACE_COMP((" SmartphoneIntegration_manufacturerModelName (SMART):%s ", l_u8ModelName));

        string tmp = string((const char*)l_u8ModelName);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName = tmp;
    }
    else
    {
        ETG_TRACE_FATAL((" [ERROR] GetManufacturerandModelName: Could not read manufacturerModelName with 'DP_s32GetConfigItem'"))
    }

    ETG_TRACE_COMP((" iPodControlAccessoryInfoModelName : %s ", LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str()));

}

void CustomerConfiguration::GetSerialNumber()
{
    ENTRY;
    /*
        Serial Number
        Got address from project team
        KDS-Address: 0x0D02
        7 bytes
     */
    ReaderKDS oPersistentReader;
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 7;
    tU16 l_KDSAddress     = 0x0D02;

    ETG_TRACE_COMP(("GetSerialNumber(SMART): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8Array[l_u8ByteNum2Read] = 0; //string termination
        ETG_TRACE_COMP(("GetSerialNumber(SMART): SerialNumber: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetSerialNumber(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}

void CustomerConfiguration::GetAccessoryHwFwVersion()
{
    ENTRY;

    /*
        FW Version
        datapool regVersions CustomerVersion
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    dp_tclregVersionsCustomerVersion oData;

    //extract data and validate the pointer
    int ret = oData.u8GetData((char*)l_u8Array, KDS_MAX_ENTRY_LENGTH);
    if (ret == DP_U8_ELEM_STATUS_VALID)
    {
        l_u8Array[KDS_MAX_ENTRY_LENGTH-1] = 0; //string termination
        ETG_TRACE_COMP(("GetAccessoryHwFwVersion(SMART): SW Version: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetAccessoryHwFwVersion(SMART): failed to Read SW Version from datapool: error %d", ret));
    }

    /*
        HW Version
        Got address from project team
        KDS-Address: 0x010E
        3 bytes
     */
    ReaderKDS oPersistentReader;
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 3;
    tU16 l_KDSAddress     = 0x010E;

    memset(l_u8Array,0,sizeof(l_u8Array));

    ETG_TRACE_COMP(("GetAccessoryHwFwVersion(SMART): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8Array[l_u8ByteNum2Read] = 0; //string termination
        ETG_TRACE_COMP(("GetAccessoryHwFwVersion(SMART): HWVersion: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetAccessoryHwFwVersion(SMART): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::CheckBluetoothStack()
{
    ENTRY

    //If bluetoothservice_out.out process is not running, then create interface for evolution stack else for fusion stack.
    if(access(LocalSPM::GetDataProvider().BTServiceFilePath().c_str(), F_OK) == -1)
    {
        LocalSPM::GetDataProvider().UseEvolutionBtStack = 1;
        ETG_TRACE_USR4(("bluetoothservice_out.out is not available, evolution interface is used."));
    }
}

void CustomerConfiguration::GetCMVariantCodingDVD()
{
    ENTRY

    tU8 u8DVD;
    tS32 s32Res = DP_s32GetConfigItem("CMVariantCoding", "DVD", &u8DVD, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        //Function is triggered per TTFIS only that's why we use Fatal trace
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]GetCMVariantCodingDVD: CMVariantCoding.HW Assembly Info.DVD :%d",u8DVD ));
        ETG_TRACE_FATAL(("==============================================================================================================="));

        if(u8DVD == 1)
        {
            LocalSPM::GetDataProvider().UseDVDControl    = 1;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetCMVariantCodingDVD: Could not read u8DVD with 'DP_s32GetConfigItem'"))
    }


}


void CustomerConfiguration::GetVehicleInformationDestinationRegion()
{
    ENTRY;


    //see: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714/Alliance_IVI_DiagnosticServices_V3.7.pdf
    //Fund this 5 Bit [0x00] US [0x01] CAN [0x02] MEX [0x03] UK [0x04] TKY [0x05] RUS [0x06] other EUR [0x07] PRC [0x08] TWN [0x09] HKG/Macau
    //[0x0A]GCC [0x0B] EGP [0x0C] ASR/NZE [0x0D] BRA [0x0E] AGT [0x0F] other LAC [0x10] SAF [0x11] THI [0x12] SGP [0x13] MLY [0x14] BRN [0x15] INN
    //[0x16] VNM [0x17] PHL [0x18] IND [0x19] JPN [0x1A] KOR [0x1B] other GOM [0x1C] ISR
    enum
    {
        eUS        = 0x00,
        eCAN       = 0x01,
        eMEX       = 0x02,
        eUK        = 0x03,
        eTKY       = 0x04,
        eRUS       = 0x05,
        eOtherEU   = 0x06,
        ePRC       = 0x07,
        eTWN       = 0x08,
        eHKG_Macau = 0x09,
        eGCC       = 0x0A,
        eEGP       = 0x0B,
        eASR_NZE   = 0x0C,
        eBRA       = 0x0D,
        eAGT       = 0x0E,
        eOtherLAC  = 0x0F,
        eSAF       = 0x10,
        eTHI       = 0x11,
        eSGP       = 0x12,
        eMLY       = 0x13,
        eBRN       = 0x14,
        eINN       = 0x15,
        eVNM       = 0x16,
        ePHL       = 0x17,
        eIND       = 0x18,
        eJPN       = 0x19, //25 decimal
        eKOR       = 0x1A,
        eOtherGOM  = 0x1B,
        eISR       = 0x1C,
        eLastVal   = 0x1D
    }tenAIVIRegion;

    std::string strRegionName[eLastVal];

    strRegionName[eUS]         = "US";
    strRegionName[eCAN]        = "CAN";
    strRegionName[eMEX]        = "MEX";
    strRegionName[eUK]         = "UK";
    strRegionName[eTKY]        = "TKY";
    strRegionName[eRUS]        = "RUS";
    strRegionName[eOtherEU]    = "other EU";
    strRegionName[ePRC]        = "PRC";
    strRegionName[eTWN]        = "TWN";
    strRegionName[eHKG_Macau]  = "HKG / Macau";
    strRegionName[eGCC]        = "GCC";
    strRegionName[eEGP]        = "EGP";
    strRegionName[eASR_NZE]    = "ASR / NZE";
    strRegionName[eBRA]        = "BRA";
    strRegionName[eAGT]        = "AGT";
    strRegionName[eOtherLAC]   = "other LAC";
    strRegionName[eSAF]        = "SAF";
    strRegionName[eTHI]        = "THI";
    strRegionName[eSGP]        = "SGP";
    strRegionName[eMLY]        = "MLY";
    strRegionName[eBRN]        = "BRN";
    strRegionName[eINN]        = "INN";
    strRegionName[eVNM]        = "VNM";
    strRegionName[ePHL]        = "PHL";
    strRegionName[eIND]        = "IND";
    strRegionName[eJPN]        = "JPN";
    strRegionName[eKOR]        = "KOR";
    strRegionName[eOtherGOM]   = "other GOM";
    strRegionName[eISR]        = "ISR";

    tU8 u8Region;
    tS32 s32Res = DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8Region, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%d",u8Region ));
        if(u8Region<(tU8)eLastVal)
        {
            ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%s",strRegionName[u8Region].c_str() ));
            if(u8Region == (tU8)eJPN)
            {
                GetCMVariantCodingDVD(); //called to ensure dependent configuration valueUseDVDControl is set

                if(LocalSPM::GetDataProvider().UseDVDControl())
                {
                    LocalSPM::GetDataProvider().CDRippingSupport = 1;
                    LocalSPM::GetDataProvider().YomiMetadataSupport = 1;
                    LocalSPM::GetDataProvider().InternalPlaylistStoragePath = LocalSPM::GetDataProvider().RippedFilePath();
                }
            }
        }
        ETG_TRACE_FATAL(("==============================================================================================================="));
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: Could not read u8Region with 'DP_s32GetConfigItem'"))
    }
}

void CustomerConfiguration::GetMFiCertificationStatus()
{
    ENTRY;

    /*
     * Get MFi support from KDS and enable/disable iAP accordingly.
     */

    m_MFiCertified = 0;
    tS32 s32Res = DP_s32GetConfigItem("AIVIVariantCoding", "MFICertified", &m_MFiCertified, sizeof(tU8));

    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_COMP(("AIVIVariantCoding_MFICertified(SMART):%d ", m_MFiCertified));
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetMFiCertificationStatus: Could not read MFICertified with 'DP_s32GetConfigItem'"))
    }
}

void CustomerConfiguration::SetSupportedDeviceTypes()
{
    ENTRY;

    /*
     * Set Supported device types based on MFiCertified KDS value
     */

    if(m_MFiCertified)
    {
        LocalSPM::GetDataProvider().SupportedDeviceTypes = 6;
        LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
        LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
        LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
        LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
        LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
        LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_MTP;
    }
    else
    {
        LocalSPM::GetDataProvider().SupportedDeviceTypes = 4;
        LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
        LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
        LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_BLUETOOTH;
        LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_MTP;
    }
}

void CustomerConfiguration::SetIndexingSupportedDevices()
{
    ENTRY;

    /*
     * Set Indexing supported device types based on MFiCertified KDS value
     */

    if(m_MFiCertified)
    {
        //Indexingsupported device types
        LocalSPM::GetDataProvider().IndexingSupportDeviceTypes   = 5;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_MTP;
    }
    else
    {
        //Indexingsupported device types
        LocalSPM::GetDataProvider().IndexingSupportDeviceTypes   = 3;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_USB;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_SD;
        LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_MTP;
    }
}

void CustomerConfiguration::SetPermanentStreamingDeviceTypes()
{
    ENTRY;

    /*
     * Set Permanent Streaming device types based on MFiCertified KDS value
     */

    if(m_MFiCertified)
    {
        //PermanentStreaming device types
        LocalSPM::GetDataProvider().PermanentStreamingDeviceTypes = 3;
        LocalSPM::GetDataProvider().PermanentStreamingDeviceType_1 = DTY_BLUETOOTH;
        LocalSPM::GetDataProvider().PermanentStreamingDeviceType_2 = DTY_IPOD;
        LocalSPM::GetDataProvider().PermanentStreamingDeviceType_3 = DTY_IPHONE;
    }
    else
    {
        //PermanentStreaming device types
        LocalSPM::GetDataProvider().PermanentStreamingDeviceTypes = 1;
        LocalSPM::GetDataProvider().PermanentStreamingDeviceType_1 = DTY_BLUETOOTH;
    }
}

void CustomerConfiguration::GetGNSSMountedInfo()
{
    ENTRY;

    /*
     * Get GNSS Mount Information from KDS
     */

    tU8 GNSSMount;
    tS32 s32Res = DP_s32GetConfigItem("CMVariantCoding", "GNSS", &GNSSMount, sizeof(tU8));

    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_COMP(("CMVariantCoding_GNSS(SMART):%d ", GNSSMount));

        if(GNSSMount == 0x01)
        {
            /*Sensor Data - addeded(pee1cob):Discussed with Anand Chandragandhi (RBEI/ECG5) <Anand.Chandragandhi@in.bosch.com>
             Only when GNSSMount == 0x01, the sensor data is expected to be enabled.
            */
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 1; //Sensor data

            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 1;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 1;
        }
        else
        {
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 0; //Sensor data
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 0;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 0;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetGNSSMountedInfo: Could not read GNSS with 'DP_s32GetConfigItem'"))
    }
}
