/**
 * @defgroup Configuration Configuration
 * @author Keerthana Peruvoyal Ravi
 *
 * public interface for SMART configuration
 * @{
 */

#ifndef SMART_CONFIGURATION_H_
#define SMART_CONFIGURATION_H_

#include <string>

#include "TypeDefinitions.h"
#include "Configuration.h"


class CustomerConfiguration : public Configuration
{

public:
    CustomerConfiguration(tComponentID componentId);

    /**
    * This function sets early Generic MediaPlayer configuration values.
    *
    */
    virtual tResult PreLoadSettings(void);

    /**
    * This function sets all Generic MediaPlayer configuration values.
    *
    */
    virtual tResult LoadSettings(void);




protected:

      virtual void CreateSortlibRuleTable();

      void CheckBluetoothStack();

      //KDS read methods
      void GetAllianceMCH1MountType();
      void GetBTName();
      void GetManufacturerandModelName();
      void GetSerialNumber();
      void GetAccessoryHwFwVersion();
      void GetResolution();
      void GetDVDRegionCode();
      //uses Datapoolfunction. Which rely on KDS entries //02.03.17
      void GetVehicleInformationDestinationRegion();
      void GetCMVariantCodingDVD();
      void GetCarPlayWirelessFeature();
      void GetGNSSMountedInfo();

      /*
       * Read MFiCertified bit from KDS and set Devices types accordingly
       */

      void GetMFiCertificationStatus();
      void SetSupportedDeviceTypes();
      void SetIndexingSupportedDevices();
      void SetPermanentStreamingDeviceTypes();

private:

      tU8 m_MFiCertified;

};

#endif /*SMART_CONFIGURATION_H_*/

/** @} */
