#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/NISConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif
#endif

#include "NISConfiguration.h"
#include "DataProvider.h"
#include "LocalSPM.h"

#include "FunctionTracer.h"
#include "VarTrace.h"
#include "ReaderKDS.h"

#include "ilm_client.h"
#include "ilm_control.h"
#include "ilm_common.h"

// Includes all header files for FI of datapool
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


#define GENERIC_KDSADRESS 0xA0C1
//#define MCH_MITSUMI_HUB_VER2 //first trial. Hub usable carplay possible with port in the middle
#define VARIANTCODING_CD 0x08
#define VARIANTCODING_DVD 0x80
const tUInt screenID =1;
enum
{
    enUNDEF = 0x00,   //i.e. not applicable
    enEU    = 0x01,
    enGEX   = 0x02,
    enChina = 0x03
};


//--------------------------------------------------------------
//see fct. GetSubversion(),teSubversionType,trSubVersionValueDescription

//#define DISABLE_READING_KDS_SUBVERSION

trSubVersionValueDescription CustomerConfiguration::m_rSubVersionValueDescriptions[eSubTypeLastElem] =
{
        //enum                                                     Registry name                                Description          Use Registry (alternative is to harcoded feature set for this subversion (level1 implementation))
        {eSubType_Undefined                                  , "-"                                     ,"KDS-entry has value 'undefined' hence default setting is used", FALSE },
        {eSubType_GMP_NisScope1                              , "GMP_NisScope1"                         ,"KDS-entry has value GMP_NisScope1.reg"                        , FALSE },/*false means use corresponding LoadSettingsSubVersion and not registry to fill configuration*/
        {eSubType_GMP_NisScope2                              , "GMP_NisScope2"                         ,"KDS-entry has value GMP_NisScope2.reg"                        , FALSE },
        {eSubType_GMP_NisScope2_WO_iAP1                      , "GMP_NisScope2_WO_iAP1"                 ,"KDS-entry has value GMP_NisScope2_WO_iAP1.reg"                , FALSE },
        {eSubType_GMP_NisScope2_1AIVI                        , "GMP_NisScope2_1AIVI"                   ,"KDS-entry has value GMP_NisScope2_1AIVI.reg"                  , FALSE },
        {eSubType_GMP_NisScope2_1AIVI_WO_iAP1                , "GMP_NisScope2_1AIVI_WO_iAP1"           ,"KDS-entry has value GMP_NisScope2_1AIVI_WO_iAP1.reg"          , FALSE },
        {eSubType_GMP_NisSC2_1AIVI_VID                       , "GMP_NisSC2_1AIVI_VID"                  ,"KDS-entry has value GMP_NisSC2_1AIVI_VID.reg"                 , FALSE },
        {eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID               , "GMP_NisSC2_1AIVI_WO_iAP1_VID"          ,"KDS-entry has value GMP_NisSC2_1AIVI_WO_iAP1_VID.reg"         , FALSE },
        {eSubType_GMP_NisScope2_1RENAULT                     , "GMP_NisScope2_1RENAULT"                ,"KDS-entry has value GMP_NisScope2_1RENAULT.reg"               , FALSE },
        {eSubType_GMP_NisScope2_1RENAULT_WO_iAP1             , "GMP_NisScope2_1RENAULT_WO_iAP1"        ,"KDS-entry has value GMP_NisScope2_1RENAULT_WO_iAP1.reg"       , FALSE },
        {eSubType_GMP_Nis_PIVI                               , "GMP_Nis_PIVI"                          ,"KDS-entry has value GMP_Nis_PIVI.reg"                         , FALSE },
        {eSubType_GMP_Nis_PIVI_WO_iAP1                       , "GMP_Nis_PIVI_WO_iAP1"                  ,"KDS-entry has value GMP_Nis_PIVI_WO_iAP1.reg"                 , FALSE },
        {eSubType_GMP_Nis_PIVI_VID                           , "GMP_Nis_PIVI_VID"                      ,"KDS-entry has value GMP_Nis_PIVI_VID.reg"                     , FALSE },
        {eSubType_GMP_Nis_PIVI_WO_iAP1_VID                   , "GMP_Nis_PIVI_WO_iAP1_VID"              ,"KDS-entry has value GMP_Nis_PIVI_WO_iAP1_VID.reg"             , FALSE },
        {eSubType_GMP_NisScope3AIVI                          , "GMP_NisScope3AIVI"                     ,"KDS-entry has value GMP_NisScope3AIVI.reg"                    , FALSE },
        {eSubType_GMP_NisScope3AIVI_WO_iAP1                  , "GMP_NisScope3AIVI_WO_iAP1"             ,"KDS-entry has value GMP_NisScope3AIVI_WO_iAP1.reg"            , FALSE },
        {eSubType_GMP_NisSC3AIVI_VID                         , "GMP_NisSC3AIVI_VID"                    ,"KDS-entry has value GMP_NisSC3AIVI_VID.reg"                   , FALSE },
        {eSubType_GMP_NisSC3AIVI_WO_iAP1_VID                 , "GMP_NisSC3AIVI_WO_iAP1_VID"            ,"KDS-entry has value GMP_NisSC3AIVI_WO_iAP1_VID.reg"           , FALSE },
        {eSubType_GMP_NisScope3RENAULT                       , "GMP_NisScope3RENAULT"                  ,"KDS-entry has value GMP_NisScope3RENAULT.reg"                 , FALSE },
        {eSubType_GMP_NisScope3RENAULT_WO_iAP1               , "GMP_NisScope3RENAULT_WO_iAP1"          ,"KDS-entry has value GMP_NisScope3RENAULT_WO_iAP1.reg"         , FALSE }
};
//--------------------------------------------------------------

CustomerConfiguration::CustomerConfiguration(tComponentID componentId):Configuration(componentId)
{
    ENTRY

    PreLoadSettings();
}

tResult CustomerConfiguration::PreLoadSettings(void) // finished: 100%
{
    ENTRY
    ReaderKDS oPersistentReader;
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH] = {0};
    tU16  l_u8ByteNum      = 32;
    tU16 l_KDSAddress     = 0x0DF4;//CMVariantCoding


    tU8 CMVariantType=0;

    ETG_TRACE_COMP(("CMVariantCoding(NIS): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("CMVariantCoding(NIS): l_KDSAddress:0x%x read, l_u8PayloadByte:%d start reading",l_KDSAddress, l_u8ByteNum));
    if(TRUE == oPersistentReader.bReadKDS(IN  l_KDSAddress/*address*/, IN l_u8ByteNum, OUT l_u8Array))
    {
        CMVariantType = l_u8Array[4];
        ETG_TRACE_COMP(("CMVariantCoding(NIS):%d", CMVariantType));

    }
    //LocalSPM::GetDataProvider().UseMediaEngine = 0; // default: 1
    LocalSPM::GetDataProvider().PEConfigDisplayLayer_01 = 3300; // 0x0ce4
    LocalSPM::GetDataProvider().VideoLayerName = "0x0ce4";
    LocalSPM::GetDataProvider().CueingRate = 16;
    LocalSPM::GetDataProvider().PEConfigRampStepPercentage_01 =   100; /**< percentage of speed */
    LocalSPM::GetDataProvider().PEConfigRampStepDuration_01   = 16000; /**< duration in milliseconds */
    LocalSPM::GetDataProvider().PEConfigRampStepPercentage_02 =   -1; /**< percentage of speed */
    LocalSPM::GetDataProvider().PEConfigRampStepDuration_02   = -1; /**< duration in milliseconds */
    //LocalSPM::GetDataProvider().MediaEngineProcessPriority =  "99"; // maximum priority; RT in top; default: 30;
    //LocalSPM::GetDataProvider().MediaEngineProcessNiceness = "-20"; // minimum niceness; default: -4;
    mSubVersion = GetSubversion();

    ETG_TRACE_USR2(("PreLoadSettings: eSubVersion: %d",ETG_CENUM(teSubversionType,mSubVersion)));

    //GetCMVariantCodingDVD();//start of SM's depend on it

    switch(mSubVersion)
    {

        case eSubType_GMP_NisScope1:
            LocalSPM::GetDataProvider().SupportedDeviceTypes = 6;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_UNKNOWN;

            break;
        case eSubType_GMP_NisScope2:
        case eSubType_GMP_NisScope2_WO_iAP1:
            LocalSPM::GetDataProvider().SupportedDeviceTypes = 8;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;
            LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_CDDA;
            LocalSPM::GetDataProvider().SupportedDeviceType_08 = DTY_MTP;
            //LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_UNKNOWN;
            LocalSPM::GetDataProvider().MediaEngineUseFork = 1;
            // activate usage of RootDaemon;
            LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;

            break;
        case eSubType_GMP_NisScope2_1AIVI:
        case eSubType_GMP_NisScope2_1AIVI_WO_iAP1:
        case eSubType_GMP_NisSC2_1AIVI_VID:
        case eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID:
        case eSubType_GMP_NisScope3AIVI:
        case eSubType_GMP_NisSC3AIVI_VID:
        case eSubType_GMP_NisScope3AIVI_WO_iAP1:
        case eSubType_GMP_NisSC3AIVI_WO_iAP1_VID:
            LocalSPM::GetDataProvider().SupportedDeviceTypes = 8;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;
            LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_CDDA;
            LocalSPM::GetDataProvider().SupportedDeviceType_08 = DTY_MTP;

            LocalSPM::GetDataProvider().CoverArtFlow = 1;
            LocalSPM::GetDataProvider().UsePictureManager = 1;  //Enabled As FT_IMAGE Supported for 2.1 AIVI
            LocalSPM::GetDataProvider().MediaEngineUseFork = 1;
            // activate usage of RootDaemon;
            LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;
            if(CMVariantType & VARIANTCODING_DVD)
            {
                LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_DVD_DRIVE;
                LocalSPM::GetDataProvider().UseDVDControl    = 1;
                LocalSPM::GetDataProvider().SetFPGARegistryforDVD = 1;
                LocalSPM::GetDataProvider().SetDVDVideoProperty = 1;
                GetDVDRegionCode();


            }
            break;
        case eSubType_GMP_NisScope2_1RENAULT:
        case eSubType_GMP_NisScope3RENAULT:
        case eSubType_GMP_NisScope2_1RENAULT_WO_iAP1:
        case eSubType_GMP_NisScope3RENAULT_WO_iAP1:
            LocalSPM::GetDataProvider().SupportedDeviceTypes = 6;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            LocalSPM::GetDataProvider().DBDefaultMediaContext = MC_AUDIO;

            //LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;  //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            //LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_CDDA;   //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_MTP;
            //LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_UNKNOWN;

            LocalSPM::GetDataProvider().CoverArtFlow = 1;
            LocalSPM::GetDataProvider().AlbumArtThumbnail = 1;
            LocalSPM::GetDataProvider().UsePictureManager = 1;  //Enabled As FT_IMAGE Supported for 2.1 Renault
            LocalSPM::GetDataProvider().MediaEngineUseFork = 1;
            // activate usage of RootDaemon;
            LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;
            GetResolution();

            LocalSPM::GetDataProvider().PlayParentFolderInsteadOfGivenFolder = true;

            break;
        case eSubType_GMP_Nis_PIVI:
        case eSubType_GMP_Nis_PIVI_WO_iAP1:
        case eSubType_GMP_Nis_PIVI_VID:
        case eSubType_GMP_Nis_PIVI_WO_iAP1_VID:
            LocalSPM::GetDataProvider().SupportedDeviceTypes = 9;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;
            LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_MTP;
            LocalSPM::GetDataProvider().SupportedDeviceType_08 = DTY_FLASH;
            LocalSPM::GetDataProvider().DBDefaultMediaContext = MC_AUDIO;

            if(CMVariantType & VARIANTCODING_CD)
            {
                LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_CDDA;
            }
            else if(CMVariantType & VARIANTCODING_DVD)
            {
                LocalSPM::GetDataProvider().SupportedDeviceTypes = 10;
                LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_DVD_DRIVE;
                LocalSPM::GetDataProvider().SupportedDeviceType_10 = DTY_MUSICBOX;
                LocalSPM::GetDataProvider().UseDVDControl    = 1;
                LocalSPM::GetDataProvider().SetDVDVideoProperty = 1;
                GetDVDRegionCode();
                GetResolution();
                GetVehicleInformationDestinationRegion();
            }
            //LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_UNKNOWN;
            LocalSPM::GetDataProvider().UsePictureManager = 0;  //Enabled As FT_IMAGE Supported for PIVI
            LocalSPM::GetDataProvider().MediaEngineUseFork = 1;
            // activate usage of RootDaemon;
            LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;
            //    GetVehicleInformationDestinationRegion();
            //sets LocalSPM::GetDataProvider().CDRippingSupport = 1; in dependency of region and availability of  DVDDrive
            break;
        case eSubType_Undefined:

            //Default type is scope 2.1 to support video and picture

            LocalSPM::GetDataProvider().SupportedDeviceTypes = 6;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            //LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;  //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            //LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_CDDA;   //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_MTP;
            //LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_UNKNOWN;

            LocalSPM::GetDataProvider().CoverArtFlow = 1;
            LocalSPM::GetDataProvider().AlbumArtThumbnail = 1;
            LocalSPM::GetDataProvider().UsePictureManager = 1;  //Enabled As FT_IMAGE Supported for 2.1 Renault

            LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands = 0;
            break;
        case eSubTypeLastElem: //never used added for lint
        default:

            //Default type is scope 2.1 to support video and picture

            LocalSPM::GetDataProvider().SupportedDeviceTypes = 6;
            LocalSPM::GetDataProvider().SupportedDeviceType_01 = DTY_USB;
            LocalSPM::GetDataProvider().SupportedDeviceType_02 = DTY_SD;
            LocalSPM::GetDataProvider().SupportedDeviceType_03 = DTY_IPOD;
            LocalSPM::GetDataProvider().SupportedDeviceType_04 = DTY_IPHONE;
            LocalSPM::GetDataProvider().SupportedDeviceType_05 = DTY_BLUETOOTH;
            //LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_CDROM;  //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            //LocalSPM::GetDataProvider().SupportedDeviceType_07 = DTY_CDDA;   //Added for NCG3D-27301 --Only for Scope2 //commented as there is no CD drive in NisScope2_1RENAULT target
            LocalSPM::GetDataProvider().SupportedDeviceType_06 = DTY_MTP;
            //LocalSPM::GetDataProvider().SupportedDeviceType_09 = DTY_UNKNOWN;

            LocalSPM::GetDataProvider().CoverArtFlow = 1;
            LocalSPM::GetDataProvider().AlbumArtThumbnail = 1;
            LocalSPM::GetDataProvider().UsePictureManager = 1;  //Enabled As FT_IMAGE Supported for 2.1 Renault

            break;


    }
    return MP_NO_ERROR;
}


tResult CustomerConfiguration::LoadSettings(void)
{
    ENTRY

    ETG_TRACE_USR2(("LoadSettings: eSubVersion: %d",ETG_CENUM(teSubversionType,mSubVersion)));

    LoadSettingsBaseRNAIVI();

    switch(mSubVersion)
    {


        //the following values currently
        case eSubType_GMP_NisScope1:
            LoadSettingsSubversionNisScop1();
            break;
        case eSubType_GMP_NisScope2:
        case eSubType_GMP_NisScope2_WO_iAP1:
            LoadSettingsSubversionNisScop2(mSubVersion);
            break;
        case eSubType_GMP_NisScope2_1AIVI:
        case eSubType_GMP_NisScope2_1AIVI_WO_iAP1:
        case eSubType_GMP_NisSC2_1AIVI_VID:
        case eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID:
        case eSubType_GMP_NisScope3AIVI:
        case eSubType_GMP_NisScope3AIVI_WO_iAP1:
        case eSubType_GMP_NisSC3AIVI_VID:
        case eSubType_GMP_NisSC3AIVI_WO_iAP1_VID:
            LoadSettingsSubversionScope2AIVIAndRenault(mSubVersion); //----------
            break;                                                                                       //                |_____________same function used but with parameter: Assumtions is that  difference between these 2 versions is low (if not one would have extra functions like)
        case eSubType_GMP_NisScope2_1RENAULT:                            //                 |
        case eSubType_GMP_NisScope2_1RENAULT_WO_iAP1:
        case eSubType_GMP_NisScope3RENAULT:
        case eSubType_GMP_NisScope3RENAULT_WO_iAP1:
            LoadSettingsSubversionScope2AIVIAndRenault(mSubVersion);//----------
            break;
        case eSubType_GMP_Nis_PIVI:
        case eSubType_GMP_Nis_PIVI_WO_iAP1:
        case eSubType_GMP_Nis_PIVI_VID:
        case eSubType_GMP_Nis_PIVI_WO_iAP1_VID:
            LoadSettingsSubversionNisPivi(mSubVersion);
            break;
        case eSubType_Undefined:
            ErrmemPrintMissingKDSEnty(mSubVersion);
            LoadSettingsSubversionScope2AIVIAndRenault(eSubType_GMP_NisScope2_1RENAULT);//Default type is scope 2.1 to support video and picture
            //LoadSettingsDefault();
            break;
        case eSubTypeLastElem: //never used added for lint
        default:
            ErrmemPrintMissingKDSEnty(mSubVersion);
            LoadSettingsSubversionScope2AIVIAndRenault(eSubType_GMP_NisScope2_1RENAULT);//Default type is scope 2.1 to support video and picture
            //LoadSettingsDefault();
            break;

    }

    return MP_NO_ERROR;
}

void CustomerConfiguration::ErrmemPrintMissingKDSEnty(teSubversionType eSubVersion)
{
    ENTRY
    ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!"));
    ETG_TRACE_ERRMEM(("!!!!!!!!!!!!!!!!!!!!!!"));

    ETG_TRACE_FATAL(("NIS_CONFIG: Project did not set configuration values bound KDS-Entry ADDRESS: %d (eSubVersion:%d)",(int)GENERIC_KDSADRESS,(int)eSubVersion));
    ETG_TRACE_ERRMEM(("NIS_CONFIG: Project did not set configuration values bound KDS-Entry ADDRESS %d (eSubVersion:%d)",(int)GENERIC_KDSADRESS,(int)eSubVersion));

    ETG_TRACE_FATAL(("NIS_CONFIG: Possible values:"));

    for(int i=(int)eSubType_Undefined; i<(int)eSubTypeLastElem ; i++)
    {
        ETG_TRACE_FATAL(("NIS_CONFIG: %d : %s",i,m_rSubVersionValueDescriptions[i].strBoundRegistryValue.c_str()));
    }

    ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!"));
    ETG_TRACE_ERRMEM(("!!!!!!!!!!!!!!!!!!!!!!"));


}

tResult CustomerConfiguration::LoadSettingsSubversionNisScop1(void) //this is the previoulsy
{
    ENTRY
    LocalSPM::GetDataProvider().VideoIndexingOn = 0;
    ETG_TRACE_USR2(("Load settings : SCOPE 1"));
    /* supported file types
    SUPPORTED_FILE_TYPE(no., extension, format, type) */\
    LocalSPM::GetDataProvider().SupportedFileTypes = 11;
    SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
    SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
    SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
    SUPPORTED_FILE_TYPE(05, ".m4v", FFT_M4V, FT_VIDEO);
    SUPPORTED_FILE_TYPE(06, ".m4b", FFT_M4B, FT_AUDIO);
    SUPPORTED_FILE_TYPE(07, ".m4p", FFT_M4P, FT_AUDIO);
    SUPPORTED_FILE_TYPE(08, ".m4r", FFT_M4R, FT_AUDIO);
    SUPPORTED_FILE_TYPE(09, ".m3u", FFT_M3U, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(10, ".pls", FFT_PLS, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(11, ".wpl", FFT_WPL, FT_PLAYLIST);
    LocalSPM::GetDataProvider().IndexingSupportDeviceTypes = 5;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_UNKNOWN;

    LocalSPM::GetDataProvider().SupportedFileSystems = 3;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_UNKNOWN;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled = 1; /**< UnwiredHub used for development */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled       = 0; /**covered by iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled which does additional bcdDevice check */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled = 1; /**< Mitsumi 2 Port ES2 Hub*/
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled = 1; /**< Mitsumi 2 Port ES4 Hub*/

    LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSettingsSubversionNisScop2(teSubversionType eSubVersion)
{
    ENTRY

    ETG_TRACE_USR2(("Load settings : SCOPE 2"));
    LocalSPM::GetDataProvider().VideoIndexingOn = 0;

    /* supported file types
    SUPPORTED_FILE_TYPE(no., extension, format, type) */\
    LocalSPM::GetDataProvider().SupportedFileTypes = 13;
    SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
    SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
    SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
    SUPPORTED_FILE_TYPE(05, ".m4v", FFT_M4V, FT_VIDEO);
    SUPPORTED_FILE_TYPE(06, ".m4b", FFT_M4B, FT_AUDIO);
    SUPPORTED_FILE_TYPE(07, ".m4p", FFT_M4P, FT_AUDIO);
    SUPPORTED_FILE_TYPE(08, ".m4r", FFT_M4R, FT_AUDIO);
    SUPPORTED_FILE_TYPE(09, ".m3u", FFT_M3U, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(10, ".pls", FFT_PLS, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(11, ".wpl", FFT_WPL, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(12, ".wav", FFT_WAV, FT_AUDIO);
    SUPPORTED_FILE_TYPE(13, ".flac", FFT_FLAC, FT_AUDIO);
    LocalSPM::GetDataProvider().IndexingSupportDeviceTypes = 7;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_MTP;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_6 = DTY_CDROM;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;

    LocalSPM::GetDataProvider().SupportedFileSystems = 5;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_ISO9660;
    LocalSPM::GetDataProvider().SupportedFileSystem_04 = FSTY_UDF;
    LocalSPM::GetDataProvider().SupportedFileSystem_05 = FSTY_UNKNOWN;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled = 1; /**< UnwiredHub used for development */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled       = 0; /**covered by iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled which does additional bcdDevice check */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled = 1; /**< Mitsumi 2 Port ES2 Hub*/
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled = 1; /**< Mitsumi 2 Port ES4 Hub*/

    //AppControl
    LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled = 0;   /**< enable iAP1 app control */
    LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 1;   /**< enable iAP2 app control */
    LocalSPM::GetDataProvider().iPodControlAppInfos = 1;
    LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "AiviCompanion";
    LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.tomtom.aivicompanion";
    LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "";
    LocalSPM::GetDataProvider().iPodControlAppInfoOption_1  = AIO_HOST_AND_DEVICE_MODE;
    LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
    if((eSubType_GMP_NisScope2_WO_iAP1 == eSubVersion))
    {
        LocalSPM::GetDataProvider().iPodControlSupportIAP1 = 0;
    }
    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSettingsSubversionScope2AIVIAndRenault(teSubversionType eSubVersion)
{
    ENTRY

    ETG_TRACE_USR2(("Load settings : SCOPE 2 AIVI and RENAULT"));
    LocalSPM::GetDataProvider().VideoIndexingOn = 1; //For all scope 2.1/3  NissanAIVI,RenaultNissan;also reading subversion is failed/invalid read; - it is enabled!!! Enable only for RenaultNissan
    LocalSPM::GetDataProvider().SetVideoProperty = 1;

    LocalSPM::GetDataProvider().IndexingSupportDeviceTypes = 7;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_MTP;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_6 = DTY_CDROM;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;

    LocalSPM::GetDataProvider().SupportedFileSystems = 5;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_ISO9660;
    LocalSPM::GetDataProvider().SupportedFileSystem_04 = FSTY_UDF;
    LocalSPM::GetDataProvider().SupportedFileSystem_05 = FSTY_UNKNOWN;

    /*NCG3D-86873*/
#ifdef VARIANT_S_FTR_ENABLE_MP_NEXT_POSSIBLE_SOURCE
    LocalSPM::GetDataProvider().nextPossibleSourceEnabled = 1;
#endif

    //Scene Recorder enable  - todo(pee1cob):why enabled for all projects ?!
    LocalSPM::GetDataProvider().EnableSRdevice = 1;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled         = 1; /**< UnwiredHub used for development */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled       = 0; /**covered by iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled which does additional bcdDevice check */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled = 1; /**< Mitsumi 2 Port ES2 Hub*/
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled = 1; /**< Mitsumi 2 Port ES4 Hub*/
    LocalSPM::GetDataProvider().MicroMutes = 1;//Enable micromute option
    LocalSPM::GetDataProvider().UnmuteRampTypeForStartOfTrack = FAST_RAMP; // Fast ramp for start of the track
    LocalSPM::GetDataProvider().EnableBTNowPlayingHighlight = 1;//Enable nowplaying song highlight in BT Current list of folder browse.

    GetCMOEMTypeFromPD(); //Read Display name of Accessory shown in iPhone from PD Config

    //scope 2.1/3 NissanAIVI;
    if((eSubType_GMP_NisScope2_1AIVI == eSubVersion) ||
            (eSubType_GMP_NisScope2_1AIVI_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisSC2_1AIVI_VID == eSubVersion) ||
            (eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID == eSubVersion) ||
            (eSubType_GMP_NisScope3AIVI == eSubVersion) ||
            (eSubType_GMP_NisScope3AIVI_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisSC3AIVI_VID == eSubVersion) ||
            (eSubType_GMP_NisSC3AIVI_WO_iAP1_VID == eSubVersion))
    {
        LocalSPM::GetDataProvider().SupportedFileTypes = 12;//9-FT_AUDIO + 3-FT_PLAYLIST

        SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
        SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
        SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
        SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
        SUPPORTED_FILE_TYPE(05, ".m4b", FFT_M4B, FT_AUDIO);
        SUPPORTED_FILE_TYPE(06, ".m4p", FFT_M4P, FT_AUDIO);
        SUPPORTED_FILE_TYPE(07, ".m4r", FFT_M4R, FT_AUDIO);
        SUPPORTED_FILE_TYPE(08, ".m3u", FFT_M3U, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(09, ".pls", FFT_PLS, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(10, ".wpl", FFT_WPL, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(11, ".wav", FFT_WAV, FT_AUDIO);
        SUPPORTED_FILE_TYPE(12, ".flac", FFT_FLAC, FT_AUDIO);

        if(((eSubType_GMP_NisSC2_1AIVI_VID == eSubVersion) ||(eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID == eSubVersion))||
                ((eSubType_GMP_NisSC3AIVI_VID == eSubVersion) ||(eSubType_GMP_NisSC3AIVI_WO_iAP1_VID == eSubVersion)))
        {
            SupportVideoFileFormats();
            SupportVideoIndexingInMSCDevices();
            SupportVideoIndexingInMTPDevices();
            AnnounceSeparateSources();
        }

        LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
        LocalSPM::GetDataProvider().PreferredNewListContent = RPT_LIST_WITH_SUBLISTS;

        LocalSPM::GetDataProvider().V4lInterfaceName = "ipu1_csi1 capture";
        LocalSPM::GetDataProvider().V4lInputName = "DS90UH940 Media In";
        LocalSPM::GetDataProvider().V4lCaptureWidth = 720;
        LocalSPM::GetDataProvider().V4lCaptureHeight = 480;
        LocalSPM::GetDataProvider().V4lFPSNumerator = 30000;
        LocalSPM::GetDataProvider().V4lFPSDenominator = 1001;
        LocalSPM::GetDataProvider().V4lMotion = 2;
        LocalSPM::GetDataProvider().V4lPixFormat = 6;
        LocalSPM::GetDataProvider().ControlCPUThtreadLoad = 1;
        if((eSubType_GMP_NisScope2_1AIVI_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisScope3AIVI_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisSC3AIVI_WO_iAP1_VID == eSubVersion) ||
            (eSubType_GMP_NisScope3AIVI == eSubVersion))
        {
            LocalSPM::GetDataProvider().iPodControlSupportIAP1 = 0;
        }
        LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled = 0;
    }
    //scope 2.1/3 RenaultNissan;
    else if((eSubType_GMP_NisScope2_1RENAULT == eSubVersion) ||
                (eSubType_GMP_NisScope3RENAULT_WO_iAP1 == eSubVersion) ||
                (eSubType_GMP_NisScope2_1RENAULT_WO_iAP1 == eSubVersion) ||
                (eSubType_GMP_NisScope3RENAULT == eSubVersion))
    {
        LocalSPM::GetDataProvider().SupportedFileTypes = 23;//9-FT_AUDIO + 3-FT_PLAYLIST + 7-FT_VIDEO + 4-FT_IMAGE
        SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
        SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
        SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
        SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
        SUPPORTED_FILE_TYPE(05, ".m4v", FFT_M4V, FT_VIDEO);
        SUPPORTED_FILE_TYPE(06, ".m4b", FFT_M4B, FT_AUDIO);
        SUPPORTED_FILE_TYPE(07, ".m4p", FFT_M4P, FT_AUDIO);
        SUPPORTED_FILE_TYPE(08, ".m4r", FFT_M4R, FT_AUDIO);
        SUPPORTED_FILE_TYPE(09, ".m3u", FFT_M3U, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(10, ".pls", FFT_PLS, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(11, ".wpl", FFT_WPL, FT_PLAYLIST);
        SUPPORTED_FILE_TYPE(12, ".wav", FFT_WAV, FT_AUDIO);
        SUPPORTED_FILE_TYPE(13, ".flac", FFT_FLAC, FT_AUDIO);
        SUPPORTED_FILE_TYPE(14, ".mp4", FFT_MP4, FT_VIDEO);
        SUPPORTED_FILE_TYPE(15, ".3gp", FFT_3GP, FT_VIDEO);
        SUPPORTED_FILE_TYPE(16, ".mpeg", FFT_MPEG, FT_VIDEO);
        SUPPORTED_FILE_TYPE(17, ".mpg", FFT_MPEG, FT_VIDEO);
        SUPPORTED_FILE_TYPE(18, ".avi", FFT_AVI, FT_VIDEO);
        SUPPORTED_FILE_TYPE(19, ".wmv", FFT_WMV, FT_VIDEO);
        SUPPORTED_FILE_TYPE(20, ".bmp", FFT_BMP, FT_IMAGE);
        SUPPORTED_FILE_TYPE(21, ".png", FFT_PNG, FT_IMAGE);
        SUPPORTED_FILE_TYPE(22, ".jpg", FFT_JPEG, FT_IMAGE);
        SUPPORTED_FILE_TYPE(23, ".jpeg", FFT_JPEG, FT_IMAGE);

        LocalSPM::GetDataProvider().PowerHubVendorID = "2c48";
        LocalSPM::GetDataProvider().PowerHubProductID_A = "0105";

        LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_LIST_WITH_SUBLISTS;
        LocalSPM::GetDataProvider().PreferredNewListContent = RPT_LIST_WITH_SUBLISTS;

        LocalSPM::GetDataProvider().SeparateMediaContent = 1;    // Flag to enable/disable AutoPlay for video
        LocalSPM::GetDataProvider().DBDefaultMediaContext = MC_AUDIO;
        GetCarPlayWirelessFeature();  // CarPlay WIFI for Renault Sc2.1
        LocalSPM::GetDataProvider().MTPVideoSupport = 1; //Enabled MTP video support
        LocalSPM::GetDataProvider().ControlCPUThtreadLoad = 1;
        GetGNSSMountedInfo();
        if((eSubType_GMP_NisScope3RENAULT_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisScope2_1RENAULT_WO_iAP1 == eSubVersion) ||
            (eSubType_GMP_NisScope3RENAULT == eSubVersion))
        {
            LocalSPM::GetDataProvider().iPodControlSupportIAP1 = 0;
        }
    }
    else
    {
        LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
    }

    //GetRegionType();   //RTC Task 428918 -  As SPI is reading KDS to restrict enabling MySpin for iOS based on regions.

    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSettingsSubversionNisPivi(teSubversionType eSubVersion) //
{
    ENTRY
    ETG_TRACE_USR2(("Load settings : PIVI"));
    LocalSPM::GetDataProvider().SetVideoProperty = 1;

    LocalSPM::GetDataProvider().SupportedFileTypes = 16;//9-FT_AUDIO + 3-FT_PLAYLIST + 4-FT_IMAGE

    /* supported file types
    SUPPORTED_FILE_TYPE(no., extension, format, type) */\
    /* supported file types
    SUPPORTED_FILE_TYPE(no., extension, format, type) */\
    SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
    SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
    SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
    SUPPORTED_FILE_TYPE(05, ".m4b", FFT_M4B, FT_AUDIO);
    SUPPORTED_FILE_TYPE(06, ".m4p", FFT_M4P, FT_AUDIO);
    SUPPORTED_FILE_TYPE(07, ".m4r", FFT_M4R, FT_AUDIO);
    SUPPORTED_FILE_TYPE(08, ".m3u", FFT_M3U, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(09, ".pls", FFT_PLS, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(10, ".wpl", FFT_WPL, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(11, ".wav", FFT_WAV, FT_AUDIO);
    SUPPORTED_FILE_TYPE(12, ".flac", FFT_FLAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(13, ".bmp", FFT_BMP, FT_IMAGE);
    SUPPORTED_FILE_TYPE(14, ".png", FFT_PNG, FT_IMAGE);
    SUPPORTED_FILE_TYPE(15, ".jpg", FFT_JPEG, FT_IMAGE);
    SUPPORTED_FILE_TYPE(16, ".jpeg", FFT_JPEG, FT_IMAGE);

    if((eSubVersion == eSubType_GMP_Nis_PIVI_VID)||(eSubVersion == eSubType_GMP_Nis_PIVI_WO_iAP1_VID))
    {
        SupportVideoFileFormats();
        SupportVideoIndexingInMSCDevices();
        SupportVideoIndexingInMTPDevices();
        AnnounceSeparateSources();
    }

    LocalSPM::GetDataProvider().IndexingSupportDeviceTypes = 7;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_MTP;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_6 = DTY_CDROM;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;

    LocalSPM::GetDataProvider().SupportedFileSystems = 5;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_ISO9660;
    LocalSPM::GetDataProvider().SupportedFileSystem_04 = FSTY_UDF;
    LocalSPM::GetDataProvider().SupportedFileSystem_05 = FSTY_UNKNOWN;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled         = 1; /**< UnwiredHub used for development */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled       = 0; /**covered by iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled which does additional bcdDevice check */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled = 1; /**< Mitsumi 2 Port ES2 Hub*/
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled = 1; /**< Mitsumi 2 Port ES4 Hub*/

    LocalSPM::GetDataProvider().MicroMutes = 1;//Enable micromute option
    LocalSPM::GetDataProvider().UnmuteRampTypeForStartOfTrack = FAST_RAMP; // Fast ramp for start of the track

    LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
    LocalSPM::GetDataProvider().PreferredNewListContent = RPT_LIST_WITH_SUBLISTS;

    GetCarPlayWirelessFeature();  //NCG3D-63935 -- Read KDS for CarPlay Wireless.

    LocalSPM::GetDataProvider().V4lInterfaceName = "ipu1_csi0 capture";
    LocalSPM::GetDataProvider().V4lInputName = "ADV7182 YPbPr on AIN1/2/3";
    LocalSPM::GetDataProvider().V4lMotion = 2;
    LocalSPM::GetDataProvider().EnableBTNowPlayingHighlight = 1;//Enable nowplaying song highlight in BT Current list of folder browse.

    LocalSPM::GetDataProvider().ControlCPUThtreadLoad = 1;

    if((eSubType_GMP_Nis_PIVI_WO_iAP1 == eSubVersion) || (eSubType_GMP_Nis_PIVI_WO_iAP1_VID == eSubVersion))
    {
        LocalSPM::GetDataProvider().iPodControlSupportIAP1 = 0;
    }

    LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled = 0; // NCG3D-136504 - Disable RouteGuidance

    GetAllianceBrandTypeFromCD(); //Read Display name of Accessory shown in iPhone from CD config

    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSettingsDefault(void) //this is the previoulsy
{
    ENTRY

    ETG_TRACE_USR2(("Load settings : Default"));

    LocalSPM::GetDataProvider().VideoIndexingOn = 0;

    /* supported file types
    SUPPORTED_FILE_TYPE(no., extension, format, type) */
    SUPPORTED_FILE_TYPE(01, ".mp3", FFT_MP3, FT_AUDIO);
    SUPPORTED_FILE_TYPE(02, ".wma", FFT_WMA, FT_AUDIO);
    SUPPORTED_FILE_TYPE(03, ".aac", FFT_AAC, FT_AUDIO);
    SUPPORTED_FILE_TYPE(04, ".m4a", FFT_M4A, FT_AUDIO);
    SUPPORTED_FILE_TYPE(05, ".wav", FFT_WAV, FT_AUDIO);
    SUPPORTED_FILE_TYPE(06, ".m4b", FFT_M4B, FT_AUDIO);     //new file format
    SUPPORTED_FILE_TYPE(07, ".m4p", FFT_M4P, FT_AUDIO);     //new file format
    SUPPORTED_FILE_TYPE(08, ".m4r", FFT_M4R, FT_AUDIO);     //new file format
    SUPPORTED_FILE_TYPE(09, ".flac", FFT_FLAC, FT_AUDIO);   //new file format
    SUPPORTED_FILE_TYPE(10, ".m3u", FFT_M3U, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(11, ".pls", FFT_PLS, FT_PLAYLIST);
    SUPPORTED_FILE_TYPE(12, ".wpl", FFT_WPL, FT_PLAYLIST);
    //SUPPORTED_FILE_TYPE(13, ".mp4", FFT_MP4, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(14, ".3gp", FFT_3GP, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(15, ".mpeg", FFT_MPEG, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(16, ".mpg", FFT_MPEG, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(17, ".avi", FFT_AVI, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(18, ".m4v", FFT_M4V, FT_VIDEO);
    //SUPPORTED_FILE_TYPE(19, ".wmv", FFT_WMV, FT_VIDEO);
    LocalSPM::GetDataProvider().SupportedFileTypes = 12;

    LocalSPM::GetDataProvider().IndexingSupportDeviceTypes = 6;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_1 = DTY_IPHONE;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_3 = DTY_USB;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_4 = DTY_SD;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_5 = DTY_CDROM;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_6 = DTY_MTP;
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN; //DTY_BLUETOOTH
    LocalSPM::GetDataProvider().IndexingSupportDeviceType_8 = DTY_UNKNOWN; //DTY_FLASH

    LocalSPM::GetDataProvider().SupportedFileSystems = 4;
    LocalSPM::GetDataProvider().SupportedFileSystem_01 = FSTY_FAT;
    LocalSPM::GetDataProvider().SupportedFileSystem_02 = FSTY_NTFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_03 = FSTY_ISO9660;
    LocalSPM::GetDataProvider().SupportedFileSystem_04 = FSTY_UDF; // typical for CDROM
    LocalSPM::GetDataProvider().SupportedFileSystem_05 = FSTY_UNKNOWN; // FSTY_EXT4;
    LocalSPM::GetDataProvider().SupportedFileSystem_06 = FSTY_UNKNOWN; // FSTY_HFS;
    LocalSPM::GetDataProvider().SupportedFileSystem_07 = FSTY_UNKNOWN; // FSTY_EXFAT;

    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled = 1; /**< UnwiredHub used for development */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled       = 0; /**covered by iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled which does additional bcdDevice check */
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled = 1; /**< Mitsumi 2 Port ES2 Hub*/
    LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled = 1; /**< Mitsumi 2 Port ES4 Hub*/

    LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL;
    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSupportedLanguages(void)
{
    ENTRY
    ETG_TRACE_USR2(("Load Supported Languages setting"));

    // Total count of supported languages types
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguageCount = 38;

    // Supported languages types
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_1 = "en";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_2 = "ar";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_3 = "bg";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_4 = "zh";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_5 = "hr";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_6 = "cs";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_7 = "da";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_8 = "nl";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_9 = "sq";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_10 = "et";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_11 = "fi";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_12 = "fr";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_13 = "de";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_14 = "el";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_15 = "he";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_16 = "hi";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_17 = "hu";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_18 = "id";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_19 = "it";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_20 = "ja";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_21 = "ko";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_22 = "lv";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_23 = "lt";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_24 = "no";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_25 = "fa";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_26 = "pl";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_27 = "pt";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_28 = "ro";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_29 = "ru";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_30 = "sr";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_31 = "sk";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_32 = "sl";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_33 = "es";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_34 = "sv";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_35 = "th";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_36 = "tr";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_37 = "uk";
    LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_38 = "vi";

    return MP_NO_ERROR;
}
tResult CustomerConfiguration::LoadSettingsBaseRNAIVI(void) //this is the previoulsy
{
    ENTRY

    ETG_TRACE_USR2(("Load settings : Common load settings"));

    LocalSPM::GetDataProvider().FavoritesSupported = 0;
    LocalSPM::GetDataProvider().FavGenreSupported = 0;
    LocalSPM::GetDataProvider().FavArtistsSupported = 0;
    LocalSPM::GetDataProvider().FavAlbumsSupported = 0;
    LocalSPM::GetDataProvider().FavSongsSupported = 0;
    LocalSPM::GetDataProvider().FavPlaylistsSupported = 0;
    LocalSPM::GetDataProvider().FavPodcastsSupported = 0;
    LocalSPM::GetDataProvider().FavAudiobooksSupported = 0;
    LocalSPM::GetDataProvider().FavVideosSupported = 0;

    LocalSPM::GetDataProvider().GBKSupported = 0;

    LocalSPM::GetDataProvider().MyMediaVisible = 0;

    LocalSPM::GetDataProvider().PrevBufferTime = 3000;
    LocalSPM::GetDataProvider().iPodControlPrevBufferTimeMS = 3000;

    LocalSPM::GetDataProvider().DBVTFileMaxDepthForScan = 9;

    LocalSPM::GetDataProvider().FileFilterCount = 4;
    LocalSPM::GetDataProvider().FileFilter_01 = "^\\.";
    LocalSPM::GetDataProvider().FileFilter_02 = "recycle";
    LocalSPM::GetDataProvider().FileFilter_03 = "CRYPTNAV";
    LocalSPM::GetDataProvider().FileFilter_04 = "TrueDelete";

    //Apple certification requirement NCG3D-18642/NCG3D-18644
    LocalSPM::GetDataProvider().PermanentStreamingDeviceTypes = 4;
    LocalSPM::GetDataProvider().PermanentStreamingDeviceType_1 = DTY_BLUETOOTH;
    LocalSPM::GetDataProvider().PermanentStreamingDeviceType_2 = DTY_IPOD;
    LocalSPM::GetDataProvider().PermanentStreamingDeviceType_3 = DTY_IPHONE;
    LocalSPM::GetDataProvider().PermanentStreamingDeviceType_4 = DTY_DVD_DRIVE;

    LocalSPM::GetDataProvider().LimitNumberObjectsPerDevice = 32000;

    LocalSPM::GetDataProvider().LimitCoverArtMemoryOnFlashKB = 307200; //300 MB

    LocalSPM::GetDataProvider().UnsupportedDeviceTypeVisible = 1;
    LocalSPM::GetDataProvider().UnsupportedFileSystemVisible = 1;
    LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename = 0;
    LocalSPM::GetDataProvider().FileErrorHandling = FEH_MARK_OBJECT_PERMANENT;
    //LocalSPM::GetDataProvider().DBDefaultRepeatMode = RPT_ALL; -> since default should be RPT_LIST_WITH_SUBLISTS for scope 2.1 Renault
    LocalSPM::GetDataProvider().ClearPlaybackMode = 0;
    LocalSPM::GetDataProvider().ClearRepeatMode = 0;
    LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    LocalSPM::GetDataProvider().DBFileListWhileIndexing = 1;


    LocalSPM::GetDataProvider().iPodControlIAP2CheckRoleSwitchRequired = 1; /**< CarPlay speed up */
    LocalSPM::GetDataProvider().iPodControlIAP2CheckRoleSwitchRequiredTimeOutMS = 0; /**< no timeout, wait for user choice */
    LocalSPM::GetDataProvider().iPodControlIAP2BatchLimit = 500; /**< batch size reduced according to NCG3D-3411 */
    LocalSPM::GetDataProvider().iPodCommunicationError = 1;      /* CMG3G-8083 iPod Communication Error to HMI */
    LocalSPM::GetDataProvider().DipoCommunicationError = 1;      /* DIPO Communication Error for SPI */
    LocalSPM::GetDataProvider().iPodControlGPRMCDataStatusValuesNotification = 1;     /**< Enable GPRMC DataStatus Values Notification */




    iPodControl::ReadAuthParameterFromRootFS(); //apply values from /etc/pfcfg/IPOD_AUTH.cfg

    LocalSPM::GetDataProvider().MultipleNextWaitTime = 0;            /**< multiple next disabled */
    LocalSPM::GetDataProvider().ScaleUpAlbumArt = 0;
    LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext = 1;   /**< enable ignore of RPT_ONE in case of user Next/Prev */
    LocalSPM::GetDataProvider().SaveLastModeInNotActive = 1;

    LocalSPM::GetDataProvider().ShuffleReshuffleOnListWrap = 1; /* switch on reshuffling on wrap around shuffled lists */

    LocalSPM::GetDataProvider().FFVolumeReduction = 1;
    LocalSPM::GetDataProvider().FFVolumeReductionDB = -12;

    //enable CDDA real device
    LocalSPM::GetDataProvider().CDDAUseRealDevice = 1;

    /* codec restrictions (no., codec, profile, supported, maxLevel, maxWidth, maxHeight, maxBitRate, maxFrameRate) */
    //CODEC_RESTRICTION(01, CDC_MPEG4,    "SIMPLE",      1,   6, 1920, 1080, 40000000, 30);
    //CODEC_RESTRICTION(02, CDC_MPEG4,    "ADVANCED",    1,   6, 1920, 1080, 40000000, 30);   //ADVANCED=ADVANCED SIMPLE
    //CODEC_RESTRICTION(03, CDC_DIVX,     "QMOBILE",     0,  -1,  176,  144,   460000, 15);   //Not supported
    //CODEC_RESTRICTION(04, CDC_DIVX,     "MOBILE",      0,  -1,  320,  240,  1240000, 30);   //Not supported
    //CODEC_RESTRICTION(05, CDC_DIVX,     "HOMETHEATRE", 0,  -1,  720,  576,  6000000, 25);   //Not supported
    CODEC_RESTRICTION(06, CDC_XVID,     "MOBILE",      0,  -1,  352,  288,  1300000, 25);   //Not supported
    CODEC_RESTRICTION(07, CDC_XVID,     "PORTABLE",    0,  -1,  640,  480,  4800000, 30);   //Not supported
    CODEC_RESTRICTION(08, CDC_XVID,     "HOME",        0,  -1,  720,  576,  4800000, 25);   //Not supported
    //CODEC_RESTRICTION(09, CDC_AVC,      "CONSTRAINED", 1, 4.2, 1920, 1080, 50000000, 30);   //CONSTRAINED=CONSTRAINED BASELINE
    //CODEC_RESTRICTION(10, CDC_AVC,      "BASELINE",    1, 4.2, 1920, 1080, 50000000, 30);
    //CODEC_RESTRICTION(11, CDC_AVC,      "MAIN",        1, 4.2, 1920, 1080, 50000000, 30);
    //CODEC_RESTRICTION(12, CDC_AVC,      "HIGH",        1, 4.2, 1920, 1080, 62500000, 30);
    //CODEC_RESTRICTION(13, CDC_WMV7,     "",            0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(14, CDC_WMV8,     "",            0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(15, CDC_WMV9,     "SIMPLE",      1,  -1,  352,  288,   384000, 15);   //No maxLevel restriction (only MEDIUM, but which number is it?)
    //CODEC_RESTRICTION(16, CDC_WMV9,     "MP",          1,  -1, 1920, 1080, 20000000, 30);   //MP=MAIN, no maxLevel restriction (only MEDIUM, but which number is it?)
    //CODEC_RESTRICTION(17, CDC_WMV9,     "ADVANCED",    1,  -1, 1920, 1080, 45000000, 30);
    //CODEC_RESTRICTION(18, CDC_VP6,      "SIMPLE",      0,  -1,  720,  576,   768000, 25);   //Not supported
    //CODEC_RESTRICTION(19, CDC_VP6,      "ADVANCED",    0,  -1,  720,  576,   768000, 25);   //Not supported
    //CODEC_RESTRICTION(20, CDC_SORENSON, "",            0,  -1,  720,  576,  6000000, 25);   //Not supported
    CODEC_RESTRICTION(21, CDC_H263,     "0",           0,  70, 1408, 1152,  6000000, 25);   //0=0 BASELINE, not supported
    CODEC_RESTRICTION(22, CDC_H263,     "3",           0,  70, 1408, 1152, 20000000, 30);   //Not supported
    //CODEC_RESTRICTION(23, CDC_VP8,      "",            0,  -1, 1280,  720, 20000000, 30);   //Not supported
    //CODEC_RESTRICTION(24, CDC_MPEG2,    "",            1,  -1, 1920, 1080, 50000000, 30);   //No maxLevel restriction
    //CODEC_RESTRICTION(25, CDC_WMA,      "VERSION 1",   0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(26, CDC_WMA,      "VERSION 3",   0,   0,    0,    0,        0,  0);   //Not supported
    //CODEC_RESTRICTION(27, CDC_WMA,      "VERSION 4",   0,   0,    0,    0,        0,  0);   //Not supported
    //LocalSPM::GetDataProvider().CodecRestrictions = 27;

    LocalSPM::GetDataProvider().FallbackActions = 5;            /* number of fallback actions */
    LocalSPM::GetDataProvider().FallbackInAction_01 = CTA_PLAY_DB_LAST_MODE_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_01 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_02 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_02 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_03 = CTA_PLAY_DB_ALL_SONGS_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_03 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_04 = CTA_PLAY_DB_ALL_VIDEOS_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_04 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_05 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    LocalSPM::GetDataProvider().FallbackOutAction_05 = CTA_PLAY_FOLDER_STREAMING_LIST;
    LocalSPM::GetDataProvider().FallbackInAction_06 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_06 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackInAction_07 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_07 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackInAction_08 = CTA_NONE;
    LocalSPM::GetDataProvider().FallbackOutAction_08 = CTA_NONE;

    LocalSPM::GetDataProvider().ListSelectionTableColumns = 6;
    LocalSPM::GetDataProvider().ListSelectionTableRows = 12;
    LocalSPM::GetDataProvider().ListSelectionTableUsedCriteria = "10,11,12,13";
    //USB
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_01 = CTP_USB;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_01 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_01 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_02 = CTP_USB;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_02 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_02 = CTA_PLAY_DB_LAST_MODE_LIST;
    //MTP
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_03 = CTP_MTP;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_03 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_03 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_04 = CTP_MTP;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_04 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_04 = CTA_PLAY_DB_LAST_MODE_LIST;
    //iPod
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_05 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_05 = "0,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_05 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_06 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_06 = "0,1,-1,1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_06 = CTA_PLAY_DB_LAST_MODE_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_07 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_07 = "0,1,-1,0";
    LocalSPM::GetDataProvider().ListSelectionTableAction_07 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_08 = CTP_IPOD;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_08 = "1,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_08 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    //Bluetooth
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_09 = CTP_BT;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_09 = "0,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_09 = CTA_PLAY_CURRENT_SELECTION_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_10 = CTP_BT;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_10 = "1,-1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_10 = CTA_PLAY_CURRENT_SELECTION_STREAMING_LIST;
    //CDDA
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_11 = CTP_CDDA;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_11 = "-1,0,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_11 = CTA_PLAY_FOLDER_LIST;
    LocalSPM::GetDataProvider().ListSelectionTablePrecondition_12 = CTP_CDDA;
    LocalSPM::GetDataProvider().ListSelectionTableCriteria_12 = "-1,1,-1,-1";
    LocalSPM::GetDataProvider().ListSelectionTableAction_12 = CTA_PLAY_DB_LAST_MODE_LIST;

    LocalSPM::GetDataProvider().AVRCPLowerProfileSupported = 1;
    LocalSPM::GetDataProvider().FirstAvailableCoverArtSupport = 1;

    LocalSPM::GetDataProvider().UseArlSrcBtAudio = 1;

    /*Enabling codesetconversion(if not in UTF-8 format)of media metadata depending on System Language - CMG3G-6919*/
    LocalSPM::GetDataProvider().CodeSetConversionSupported = 1;
    LocalSPM::GetDataProvider().RemoteActivitySupportForNonAppleDevice = 1;
    LocalSPM::GetDataProvider().AutoPlayBTOnRequestviaSiri = 1;
    LocalSPM::GetDataProvider().DBUnknownText = "Unknown";

    LocalSPM::GetDataProvider().SetDefaultRepeatModeToRPTListAppleDevice = 0;
    LocalSPM::GetDataProvider().BTAudioSourceAsStatic = 1;

    LocalSPM::GetDataProvider().KeepLastPlaybackStateForStreamingDevicesEnabled = 1;
    LocalSPM::GetDataProvider().MaximumMTPFileSizeInMB = 10;

    CheckBluetoothStack();
    LocalSPM::GetDataProvider().IgnoreSpecialCharachters = 1;
    LocalSPM::GetDataProvider().BtNowPlayingListSupport = 1;
    LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled = 1;


    //IAP2BT Support only for smart apps.
    LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp = 1;

    //SPP connection request
    LocalSPM::GetDataProvider().RequestIAP2SPPConnection = 1;

    //Add Device Syspath to DeviceInfo structure and send to clients in MediaplayerDeviceConnections-  CRQ  CMG3G-12660
    LocalSPM::GetDataProvider().AddDeviceSysPath = 1;

    //Ignore IAP to BT fallback on failure of IAP device initialization  (IAP device connected via Bluetooth)
    LocalSPM::GetDataProvider().IgnoreBTfallbackFromIAP = 1;

    // Play Back mass storage device while no list is available
    LocalSPM::GetDataProvider().PlayOnUserRequestWhenListFinished = 1;

    LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT = 1;

    LocalSPM::GetDataProvider().iPodControlAccessoryInfoWIFIName = IAP2_WIRELESS_CARPLAY_TRANS_COMP_NAME;

    LocalSPM::GetDataProvider().iPodControlAlbumArtWaitTimer = 1;

    //Enabled BT CoverArt feature
    LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt = 1;

    //read persistent settings from KDS
    GetAllianceMCH1MountType();
    GetBTName();
    GetManufacturerName();
    GetManufacturerModelName();
    GetSerialNumber();
    GetAccessoryHwFwVersion();
    GetVariantType();
    LoadSupportedLanguages();

    //CarLife & MySPIN features (maintain the order of calling the below functions)
    GetCarLifeFeature();
    GetMySpinFeature();
    if(LocalSPM::GetDataProvider().iPodControlSupportCarlife() || LocalSPM::GetDataProvider().iPodControlSupportMySpin() )
    {
        LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 1;
        LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 1;
        LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 1;
    }

    return MP_NO_ERROR;
}

void sortlib_initialize_sort_table( unsigned sortTable[] );//Prototype

void CustomerConfiguration::CreateSortlibRuleTable()
{
    sortlib_initialize_sort_table(sortTable);

}
void CustomerConfiguration::GetDVDRegionCode()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714
     */


    tU8 u8DVDRegionCode;
    tS32 s32Res = DP_s32GetConfigItem("CMVariantCoding", "DVDRegionCode", &u8DVDRegionCode, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        //Function is triggered per TTFIS only that's why we use Fatal trace
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]GetCMVariantCodingDVD: CMVariantCoding.HW Assembly Info.DVD :%d",u8DVDRegionCode ));
        ETG_TRACE_FATAL(("==============================================================================================================="));

        ETG_TRACE_COMP(("CMVariantCoding_DVDRegionCode(NIS):%d ", u8DVDRegionCode));
        LocalSPM::GetDataProvider().DVDRegionCode  = u8DVDRegionCode ;

    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetCMVariantCodingDVD: Could not read DVDRegionCode with 'DP_s32GetConfigItem'"))
    }

}
tU8 CustomerConfiguration::GetRegionType()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA112
        Identifier: Identifier ($DAB1)
        byte index 0 of 64 byte array
        Bit 3,4,5,6,7
        [0x00] US [0x01] CAN [0x02] MEX [0x03] UK [0x04] TKY
        [0x05] RUS [0x06] other EUR [0x07] PRC [0x08] TWN
        [0x09] HKG/Macau [0x0A] GCC [0x0B] EGP [0x0C] ASR/NZE
        [0x0D] BRA [0x0E] AGT [0x0F] other LAC [0x10] SAF [0x11] THI
        [0x12] SGP [0x13] MLY [0x14] BRN [0x15] INN [0x16] VNM [0x17] PHL
        [0x18] IND [0x19] JPN [0x1A] KOR [0x1B] other
     */

    tU8  regionType = 0;
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA112;

    memset(l_u8Array,0,sizeof(l_u8Array));

    ETG_TRACE_COMP(("GetRegionType(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetRegionType(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        regionType = (tU8)((l_u8Array[l_u8ByteNum])>>3);
        ETG_TRACE_COMP(("RegionType byte:%d", regionType));
    }
    else
    {
        ETG_TRACE_FATAL (("GetRegionType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetRegionType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

    return regionType;

}
void CustomerConfiguration::GetCarPlayWirelessFeature()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA110
        Identifier: Identifier ($DAB1)
        byte index 58 of 64 byte array
        Bit 1
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 58;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    memset(l_u8Array,0,sizeof(l_u8Array));

    ETG_TRACE_COMP(("GetCarPlayWirelessFeature(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetCarPlayWirelessFeature(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        bool isCPWBitEnabled = 0;
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];
        isCPWBitEnabled = l_u8PayloadByte & 0x02;


        if(l_u8PayloadByte & 0x02)  // bit 1 is Wireless_Carplay_function.
        {
            LocalSPM::GetDataProvider().iPodControlCarPlayWifiEnabled = 1;
            LocalSPM::GetDataProvider().MaxNoOfDevicesInDB = 21;
            LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB = 10;
        }
        ETG_TRACE_COMP(("GetCarPlayWirelessFeature(RNAIVI): byte 58 data: %d, CPW bit %d",l_u8PayloadByte, isCPWBitEnabled));
    }
    else
    {
        ETG_TRACE_FATAL (("GetCarPlayWirelessFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetCarPlayWirelessFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}

void CustomerConfiguration::GetAllianceMCH1MountType()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
    reference see: Alliance_IVI_DiagnosticServices.pdf
    https://hi-dms.de.bosch.com/docushare/dsweb/View/Collection-262754

    KDS-Address: 0xA110
    Identifier: Identifier ($DAB1)
    byte index 29 of 64 byte array
    Bit 2-3

    AllianceMCH1MountType
    [0x00] No MCH1 mounted in car
    [0x01] AUX + 1 USB port (MCH1, w/o HUB)
    [0x02] AUX + 2 USB ports (MCH1, with HUB)
    [0x03] AUX + 2 USB ports + SD slot (3rd USB MSC device) (MCH1, with HUB
     */


    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 29;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    //set default chanrging current
    LocalSPM::GetDataProvider().AvailableCurrentDefault = 2100; //mA. //Fix for NCG3D-134045

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];

        ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));

        //shift and mask out bit 2-3
        l_u8PayloadByte = (l_u8PayloadByte>>2) & 0x03;

        ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): AllianceMCH1MountType:  0x%x", l_u8PayloadByte));

        if(l_u8PayloadByte == 0x00) {
            //LocalSPM::GetDataProvider().AvailableCurrentDefault = 2100; //mA
            ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): USB 2100mA charging"));
        }else {
            LocalSPM::GetDataProvider().AvailableCurrentDefault = 2400; //mA
            ETG_TRACE_COMP(("GetAllianceMCH1MountType(RNAIVI): USB 2.4A charging"));
        }
    }
    else
    {
        ETG_TRACE_FATAL (("GetAllianceMCH1MountType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetAllianceMCH1MountType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}
void CustomerConfiguration::GetResolution()
{
    ENTRY
    tUInt pWidth,pHeight;
    ilm_init();

    if (ilm_getScreenResolution(screenID,&pWidth, &pHeight) != 0)
    {
        ETG_TRACE_USR2(("ilm_getScreenResolution failed"));
    }
    else
    {
        LocalSPM::GetDataProvider().PEConfigDisplayWidth_01 = pWidth;
        LocalSPM::GetDataProvider().PEConfigDisplayHeight_01 = pHeight;
        ETG_TRACE_COMP(("GetResolution(RIVI): PEConfigDisplayWidth_01:%d",pWidth));
        ETG_TRACE_COMP(("GetResolution(RIVI): PEConfigDisplayHeight_01:%d",pHeight));
    }
}
void CustomerConfiguration::GetBTName()
{
    ENTRY;
    ReaderKDS oPersistentReader;

    /*
        reference see: Alliance_IVI_DiagnosticServices.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/View/Collection-262754

        KDS-Address: 0xA030
        Identifier: Identifier ($DAF4)
        bytes 0 - 21

        BT Name
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 22;
    tU16 l_KDSAddress     = 0xA030;

    ETG_TRACE_COMP(("GetBTName(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetBTName(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    //LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName = "My Car";

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8Array[l_u8ByteNum2Read] = 0; //string termination
        ETG_TRACE_COMP(("GetBTName(RNAIVI): BT_Name: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetBTName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetBTName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetCMOEMTypeFromPD()
{
    ENTRY;
    ReaderKDS oPersistentReader;
    /*
    reference see: A-IVI_CMDS_1v13.pdf
    https:/https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-722373/A-IVI_CMDS_1v13.pdf

    KDS-Address: 0x0DF4
    Identifier: Identifier ($8100)
    byte index 3 of 32 byte array
    Bit 0-7

    CMVariantCoding / CMOEMType
    [0x06] Nissan -> NissanConnect
    [0x08] Renault -> Renault
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 3;
    tU8  l_u8ByteNum2Read = 32;
    tU16 l_KDSAddress     = 0x0DF4;

    ETG_TRACE_COMP(("GetCMOEMTypeFromPD(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];

        ETG_TRACE_COMP(("GetCMOEMTypeFromPD(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));

        if(l_u8PayloadByte == 0x06) {
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoDisplayName = "NissanConnect"; //NCG3D-9931
            ETG_TRACE_COMP(("GetCMOEMTypeFromPD(RNAIVI): CMOEMType Nissan"));
        } else if(l_u8PayloadByte == 0x08) {
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoDisplayName = "Renault";
            ETG_TRACE_COMP(("GetCMOEMTypeFromPD(RNAIVI): CMOEMType Renault"));
        } else {
            ETG_TRACE_ERRMEM(("GetCMOEMTypeFromPD(RNAIVI): CMOEMType unknown, Default DisplayName is Accessory BT Name"));
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("GetCMOEMTypeFromPD(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetAllianceBrandTypeFromCD()
{
    ENTRY;
    ReaderKDS oPersistentReader;
    /*
    https://hi-dms.de.bosch.com/docushare/dsweb/Get/Version-1527533/Alliance_IVI_DiagnosticServices_V3.20.pdf

    KDS-Address: 0xA110
    Identifier: Identifier ($DAB1)
    byte index 4 of 64 byte array
    Bit 0-2

    [0x01] Nissan -> NissanConnect
    [0x02] Infiniti -> INIFINITI InTouch
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 4;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    ETG_TRACE_COMP(("GetAllianceBrandTypeFromCD(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8PayloadByte = (l_u8Array[l_u8ByteNum]) & 0x07;

        ETG_TRACE_COMP(("GetAllianceBrandTypeFromCD(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));

        if(l_u8PayloadByte == 0x01) {
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoDisplayName = "NissanConnect"; //NCG3D-9931, NCG3D-109541
            ETG_TRACE_COMP(("GetAllianceBrandTypeFromCD(RNAIVI): AllianceBrandType NissanConnect"));
        } else if(l_u8PayloadByte == 0x02) {
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoDisplayName = "INFINITI InTouch"; //NCG3D-109541
            ETG_TRACE_COMP(("GetAllianceBrandTypeFromCD(RNAIVI): AllianceBrandType INFINITI InTouch"));
        } else {
            ETG_TRACE_ERRMEM(("GetAllianceBrandTypeFromCD(RNAIVI): AllianceBrandType unknown, Default DisplayName is Accessory BT Name"));
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("GetAllianceBrandTypeFromCD(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetManufacturerName()
{
    ENTRY;
    ReaderKDS oPersistentReader;
    /*
    reference see: A-IVI_CMDS_1v13.pdf
    https:/https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-722373/A-IVI_CMDS_1v13.pdf

    KDS-Address: 0xA0C4
    Identifier: Identifier ($811C)
    byte 54 - 103

    Manufacturer Name:
    Nissan
    Renault
    Infiniti
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8ArrayTmp[KDS_MAX_ENTRY_LENGTH];
    const int modelName_StartString = 54;    //Holds a string registry name :Starting byte
    const int modelName_StringLen   = 50;   //Holds the length of the string to be read
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 54;
    tU8  l_u8ByteNum2Read = 224;
    tU16 l_KDSAddress     = 0xA0C4;


    ETG_TRACE_COMP(("GetManufacturerName(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetManufacturerName(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8ArrayTmp))
    {
        memcpy(l_u8Array,l_u8ArrayTmp+modelName_StartString,modelName_StringLen);
        ETG_TRACE_COMP(("GetSubversion: l_u8ArraySubversion: %s",l_u8Array));
        char tmp[modelName_StringLen+1]= {0} ; //Null Termination
        strncpy(tmp, (const char*)l_u8Array, modelName_StringLen);
        ETG_TRACE_COMP(("GetManufacturerModelName(RNAIVI): ManufacturerModelName: %s", tmp));
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetManufacturerName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetManufacturerName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetManufacturerModelName()
{
    ENTRY;
    ReaderKDS oPersistentReader;
    /*
    reference see: A-IVI_CMDS_1v13.pdf
    https:/https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-722373/A-IVI_CMDS_1v13.pdf

    KDS-Address: 0xA0C4
    Identifier: Identifier ($811C)
    byte 104 - 153

    Manufacturer Model Name:
    Nissan_Bosch_01
    Renault_Bosch_01
    Infiniti_Bosch_01
     */
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8ArrayTmp[KDS_MAX_ENTRY_LENGTH];
    const int modelName_StartString = 104 ;  //Holds a string registry name :Starting byte
    const int modelName_StringLen   = 50;   //Holds the length of the string to be read
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 104;
    tU8  l_u8ByteNum2Read = 224;
    tU16 l_KDSAddress     = 0xA0C4;

    ETG_TRACE_COMP(("GetManufacturerModelName(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetManufacturerModelName(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8ArrayTmp))
    {
        memcpy(l_u8Array,l_u8ArrayTmp+modelName_StartString,modelName_StringLen);
        ETG_TRACE_COMP(("GetSubversion: l_u8ArraySubversion: %s",l_u8Array));
        char tmp[modelName_StringLen+1]= {0} ; //Null Termination
        strncpy(tmp, (const char*)l_u8Array, modelName_StringLen);
        ETG_TRACE_COMP(("GetManufacturerModelName(RNAIVI): ManufacturerModelName: %s", tmp));
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetManufacturerModelName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetManufacturerModelName(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetSerialNumber()
{
    ENTRY;
    /*
        Serial Number
        Got address from diagnose team

        KDS-Address: 0x0106
        7 bytes
     */
    ReaderKDS oPersistentReader;
    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 7;
    tU16 l_KDSAddress     = 0x0106;

    ETG_TRACE_COMP(("GetSerialNumber(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetSerialNumber(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8Array[l_u8ByteNum2Read] = 0; //string termination
        ETG_TRACE_COMP(("GetSerialNumber(RNAIVI): SerialNumber: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetSerialNumber(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetSerialNumber(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::GetAccessoryHwFwVersion()
{
    ENTRY;

    /*
        FW Version
        datapool regVersions CustomerVersion
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    dp_tclregVersionsCustomerVersion oData;

    //extract data and validate the pointer
    int ret = oData.u8GetData((char*)l_u8Array, KDS_MAX_ENTRY_LENGTH);
    if (ret == DP_U8_ELEM_STATUS_VALID)
    {
        l_u8Array[KDS_MAX_ENTRY_LENGTH-1] = 0; //string termination
        ETG_TRACE_COMP(("GetAccessoryHwFwVersion(RNAIVI): SW Version: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetAccessoryHwFwVersion(RNAIVI): failed to Read SW Version from datapool: error %d", ret));
        ETG_TRACE_ERRMEM(("GetAccessoryHwFwVersion(RNAIVI): failed to Read SW Version from datapool: error %d", ret));
    }


    /*
        HW Version
        Got address from diagnose team

        KDS-Address: 0x010E
        3 bytes
     */
    ReaderKDS oPersistentReader;
    //tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 3;
    tU16 l_KDSAddress     = 0x010E;

    ETG_TRACE_COMP(("GetAccessoryHwFwVersion(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetAccessoryHwFwVersion(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8Array[l_u8ByteNum2Read] = 0; //string termination
        ETG_TRACE_COMP(("GetAccessoryHwFwVersion(RNAIVI): HWVersion: %s", l_u8Array));
        string tmp = string((const char*)l_u8Array);
        LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion = tmp;
    }
    else
    {
        ETG_TRACE_FATAL (("GetAccessoryHwFwVersion(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetAccessoryHwFwVersion(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::CheckBluetoothStack()
{
    ENTRY

    //If bluetoothservice_out.out process is not running, then create interface for evolution stack else for fusion stack.
    if(access(LocalSPM::GetDataProvider().BTServiceFilePath().c_str(), F_OK) == -1)
    {
        LocalSPM::GetDataProvider().UseEvolutionBtStack = 1;
        ETG_TRACE_USR4(("bluetoothservice_out.out is not available, evolution interface is used."));
    }
}


teSubversionType CustomerConfiguration::GetSubversion()
{
    ENTRY

    teSubversionType res = eSubType_Undefined;

#ifndef DISABLE_READING_KDS_SUBVERSION

#define GMP_SUBVERSION_ADDRESS GENERIC_KDSADRESS//defined in cooperation with diagnosis team
#define GMP_SUBVERSION_STRING_LEN  32 //holds a string registry name.TODO(pee1cob):subversion string length reached 31.check to make this higher .

    ReaderKDS oReaderKDS;  //include this element later from ai_mediaplayer/components/customer/common/ConfigPeristent/Inc

    tU8 l_u8ArrayTmp[KDS_MAX_ENTRY_LENGTH] = {0};


    if(TRUE==oReaderKDS.bReadKDS(IN GMP_SUBVERSION_ADDRESS,      /*address*/
            IN GMP_SUBVERSION_STRING_LEN,  /*len of bytes to read - we start to count with 0 as first byte*/
            OUT l_u8ArrayTmp))
    {
        res = GetSubversionEnum(IN (const char*)l_u8ArrayTmp);
    }
    else
    {
        ETG_TRACE_FATAL (("GetSubversion: failed to read KDS value"));
        ETG_TRACE_ERRMEM(("GetSubversion: failed to read KDS value"));
    }

#endif

    return res;

}
teSubversionType CustomerConfiguration::GetSubversionEnum(const char* subversionString)
{
    ENTRY

    teSubversionType type = eSubType_Undefined;

    int stringLength = strlen_r(subversionString);
    if(stringLength)
    {
        ETG_TRACE_USR2(("subversionString :%s",subversionString));

        unsigned int iter;
        for(iter = eSubType_Undefined ;iter < eSubTypeLastElem; ++iter)
        {
            if(!strcmp(subversionString, (m_rSubVersionValueDescriptions[iter].strBoundRegistryValue.c_str())))
            {
                ETG_TRACE_USR2(("GetSubversionEnum: %d",ETG_CENUM(teSubversionType,m_rSubVersionValueDescriptions[iter].enSubType)));
                type = m_rSubVersionValueDescriptions[iter].enSubType;
                break;
            }
        }
        if(iter == eSubTypeLastElem)
        {
            ETG_TRACE_ERR(("No SubversionEnum defined for given subversionString"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("subversionString Length is zero"));
    }

    return type;
}

void CustomerConfiguration::GetVariantType()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
    reference see: A-IVI_CMDS_1v20.pdf
    KDS-Address: 0xA114
     */


    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 0;
    tU8  l_u8ByteNum2Read = 1;
    tU16 l_KDSAddress     = 0xA114;

    ETG_TRACE_COMP(("GetVariantType(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetVariantType(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));

    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];

        ETG_TRACE_COMP(("GetVariantType(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));

        l_u8PayloadByte = (l_u8PayloadByte) & 0x03;

        ETG_TRACE_COMP(("GetVariantType(RNAIVI): VariantType:  0x%x", l_u8PayloadByte));

        if(l_u8PayloadByte == 0x02) {
            //Sensor Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 1;
            //GPS Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 0;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 0;
        }else {
            //Sensor Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 1;
            //GPS Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 1;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 1;
        }
    }
    else
    {
        ETG_TRACE_FATAL (("GetVariantType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetVariantType(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}


void CustomerConfiguration::GetCMVariantCodingDVD()
{
    ENTRY

    tU8 u8DVD;
    tS32 s32Res = DP_s32GetConfigItem("CMVariantCoding", "DVD", &u8DVD, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        //Function is triggered per TTFIS only that's why we use Fatal trace
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]GetCMVariantCodingDVD: CMVariantCoding.HW Assembly Info.DVD :%d",u8DVD ));
        ETG_TRACE_FATAL(("==============================================================================================================="));

        if(u8DVD == 1)
        {
            LocalSPM::GetDataProvider().UseDVDControl    = 1;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] GetCMVariantCodingDVD: Could not read u8DVD with 'DP_s32GetConfigItem'"))
    }


}


void CustomerConfiguration::GetVehicleInformationDestinationRegion()
{
    ENTRY;


    //see: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714/Alliance_IVI_DiagnosticServices_V3.7.pdf
    //Fund this 5 Bit [0x00] US [0x01] CAN [0x02] MEX [0x03] UK [0x04] TKY [0x05] RUS [0x06] other EUR [0x07] PRC [0x08] TWN [0x09] HKG/Macau
    //[0x0A]GCC [0x0B] EGP [0x0C] ASR/NZE [0x0D] BRA [0x0E] AGT [0x0F] other LAC [0x10] SAF [0x11] THI [0x12] SGP [0x13] MLY [0x14] BRN [0x15] INN
    //[0x16] VNM [0x17] PHL [0x18] IND [0x19] JPN [0x1A] KOR [0x1B] other GOM [0x1C] ISR
    enum
    {
        eUS        = 0x00,
        eCAN       = 0x01,
        eMEX       = 0x02,
        eUK        = 0x03,
        eTKY       = 0x04,
        eRUS       = 0x05,
        eOtherEU   = 0x06,
        ePRC       = 0x07,
        eTWN       = 0x08,
        eHKG_Macau = 0x09,
        eGCC       = 0x0A,
        eEGP       = 0x0B,
        eASR_NZE   = 0x0C,
        eBRA       = 0x0D,
        eAGT       = 0x0E,
        eOtherLAC  = 0x0F,
        eSAF       = 0x10,
        eTHI       = 0x11,
        eSGP       = 0x12,
        eMLY       = 0x13,
        eBRN       = 0x14,
        eINN       = 0x15,
        eVNM       = 0x16,
        ePHL       = 0x17,
        eIND       = 0x18,
        eJPN       = 0x19, //25 decimal
        eKOR       = 0x1A,
        eOtherGOM  = 0x1B,
        eISR       = 0x1C,
        eLastVal   = 0x1D
    }tenAIVIRegion;

    std::string strRegionName[eLastVal];

    strRegionName[eUS]         = "US";
    strRegionName[eCAN]        = "CAN";
    strRegionName[eMEX]        = "MEX";
    strRegionName[eUK]         = "UK";
    strRegionName[eTKY]        = "TKY";
    strRegionName[eRUS]        = "RUS";
    strRegionName[eOtherEU]    = "other EU";
    strRegionName[ePRC]        = "PRC";
    strRegionName[eTWN]        = "TWN";
    strRegionName[eHKG_Macau]  = "HKG / Macau";
    strRegionName[eGCC]        = "GCC";
    strRegionName[eEGP]        = "EGP";
    strRegionName[eASR_NZE]    = "ASR / NZE";
    strRegionName[eBRA]        = "BRA";
    strRegionName[eAGT]        = "AGT";
    strRegionName[eOtherLAC]   = "other LAC";
    strRegionName[eSAF]        = "SAF";
    strRegionName[eTHI]        = "THI";
    strRegionName[eSGP]        = "SGP";
    strRegionName[eMLY]        = "MLY";
    strRegionName[eBRN]        = "BRN";
    strRegionName[eINN]        = "INN";
    strRegionName[eVNM]        = "VNM";
    strRegionName[ePHL]        = "PHL";
    strRegionName[eIND]        = "IND";
    strRegionName[eJPN]        = "JPN";
    strRegionName[eKOR]        = "KOR";
    strRegionName[eOtherGOM]   = "other GOM";
    strRegionName[eISR]        = "ISR";

    tU8 u8Region;
    tS32 s32Res = DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8Region, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%d",u8Region ));
        if(u8Region<(tU8)eLastVal)
        {
            ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%s",strRegionName[u8Region].c_str() ));
            if(u8Region == (tU8)eJPN)
            {
                GetCMVariantCodingDVD(); //called to ensure dependent configuration valueUseDVDControl is set

                if(LocalSPM::GetDataProvider().UseDVDControl())
                {
                    LocalSPM::GetDataProvider().CDRippingSupport = 1;
                    LocalSPM::GetDataProvider().YomiMetadataSupport = 1;
                    LocalSPM::GetDataProvider().RippedFilePath = "/var/opt/bosch/musicbox/";
                    LocalSPM::GetDataProvider().InternalPlaylistStoragePath = LocalSPM::GetDataProvider().RippedFilePath();
                }
            }
        }
        ETG_TRACE_FATAL(("==============================================================================================================="));
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: Could not read u8Region with 'DP_s32GetConfigItem'"))
    }


}

void CustomerConfiguration::GetCarLifeFeature()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA110
        Identifier: Identifier ($DAB1)
        byte index 58 of 64 byte array
        Bit 0
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 58;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    memset(l_u8Array,0,sizeof(l_u8Array));

    ETG_TRACE_COMP(("GetCarLifeFeature(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetCarLifeFeature(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        bool isCarLifeBitEnabled = 0;
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];
        isCarLifeBitEnabled = l_u8PayloadByte & 0x01;


        if(isCarLifeBitEnabled)  // bit 0 is Baidu Carlife
        {
            LocalSPM::GetDataProvider().iPodControlSupportCarlife = 1;
            LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 1;
            LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled = 0;   /**< enable iAP1 app control */
            LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 1;   /**< enable iAP2 app control */
            LocalSPM::GetDataProvider().iPodControlAppInfos = 1;
            LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "AiviCompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.tomtom.aivicompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "";
            LocalSPM::GetDataProvider().iPodControlAppInfoOption_1  = AIO_HOST_AND_DEVICE_MODE;
            LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 1;
        }
        else
        {
            LocalSPM::GetDataProvider().iPodControlSupportCarlife = 0;
            LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 0;
            LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled = 0;   /**< enable iAP1 app control */
            LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 0;   /**< enable iAP2 app control */
            LocalSPM::GetDataProvider().iPodControlAppInfos = 1;
            LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "AiviCompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.tomtom.aivicompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "";
            LocalSPM::GetDataProvider().iPodControlAppInfoOption_1  = AIO_HOST_AND_DEVICE_MODE;
            LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 0;
        }
        ETG_TRACE_COMP(("GetCarLifeFeature(RNAIVI): byte 58 data: %d, CarLife bit %d",l_u8PayloadByte, isCarLifeBitEnabled));
    }
    else
    {
        ETG_TRACE_FATAL (("GetCarLifeFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetCarLifeFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}

void CustomerConfiguration::GetMySpinFeature()
{
    ENTRY
    ReaderKDS oPersistentReader;

    /*
        reference see:Alliance_IVI_DiagnosticServices_V3.12.pdf
        https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714

        KDS-Address: 0xA110
        Identifier: Identifier ($DAB1)
        byte index 32 of 64 byte array
        Bit 5
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 32;
    tU8  l_u8ByteNum2Read = 64;
    tU16 l_KDSAddress     = 0xA110;

    memset(l_u8Array,0,sizeof(l_u8Array));

    ETG_TRACE_COMP(("GetMySpinFeature(RNAIVI): KDS_MAX_ENTRY_LENGTH:%d",KDS_MAX_ENTRY_LENGTH));
    ETG_TRACE_COMP(("GetMySpinFeature(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {

        bool isMySpinBitEnabled = 0;
        l_u8PayloadByte = tU8((l_u8Array[l_u8ByteNum])>>5);
        isMySpinBitEnabled = l_u8PayloadByte & 0x01;


        if(isMySpinBitEnabled)  // bit 5 is Myspin
        {
            LocalSPM::GetDataProvider().iPodControlSupportMySpin = 1;
            LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 1;
            //AppControl
            LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled = 0;   /**< enable iAP1 app control */
            LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 1;   /**< enable iAP2 app control */
            LocalSPM::GetDataProvider().iPodControlAppInfos = 1;
            LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "com.bosch.myspin.launcherapp.cn";
            LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.bosch.m";
            LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "com.bosch.myspin.launcherapp.cn";
            LocalSPM::GetDataProvider().iPodControlAppInfoOption_1  = AIO_EA_NATIVE_TRANSPORT;

            LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 1;
        }
        else
        {
            LocalSPM::GetDataProvider().iPodControlSupportMySpin = 0;
            LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled = 0;
            LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled = 0;   /**< enable iAP1 app control */
            LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled = 0;   /**< enable iAP2 app control */
            LocalSPM::GetDataProvider().iPodControlAppInfos = 1;
            LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1 = "AiviCompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1 = "com.tomtom.aivicompanion";
            LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1 = "";
            LocalSPM::GetDataProvider().iPodControlAppInfoOption_1  = AIO_HOST_AND_DEVICE_MODE;
            LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled = 0;
        }
        ETG_TRACE_COMP(("GetMySpinFeature(RNAIVI): byte 58 data: %d, MySpin bit %d",l_u8PayloadByte, isMySpinBitEnabled));
    }
    else
    {
        ETG_TRACE_FATAL (("GetMySpinFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
        ETG_TRACE_ERRMEM(("GetMySpinFeature(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }

}
void CustomerConfiguration::GetGNSSMountedInfo()
{
    ENTRY;
    ReaderKDS oPersistentReader;
    /*
    reference see: A-IVI_CMDS_1v13.pdf
    https:/https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-722373/A-IVI_CMDS_1v13.pdf

    KDS-Address: 0x0DF4
    Identifier: Identifier ($8100)
    byte index 14 of 32 byte array
    Bit 2-3

    CMVariantCoding / CMOEMType
    [0x00] Info Not Available
    [0x01] GNSS Mounted
    [0x02] GNSS not mounted
     */

    tU8  l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8  l_u8PayloadByte;
    tU8  l_u8ByteNum      = 14;
    tU8  l_u8ByteNum2Read = 32;
    tU16 l_KDSAddress     = 0x0DF4;

    ETG_TRACE_COMP(("GetGNSSMountedInfo(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d start reading",l_KDSAddress, l_u8ByteNum));


    if(FALSE != oPersistentReader.bReadKDS(IN  l_KDSAddress      /*address*/,
            IN l_u8ByteNum2Read  ,
            OUT l_u8Array))
    {
        l_u8PayloadByte = l_u8Array[l_u8ByteNum];
        ETG_TRACE_COMP(("GetGNSSMountedInfo(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));
        l_u8PayloadByte = (l_u8PayloadByte>>2) & 0x03;
        ETG_TRACE_COMP(("GetGNSSMountedInfo(RNAIVI): l_KDSAddress:0x%x read, l_u8PayloadByte%d :  0x%x received result",l_KDSAddress,l_u8ByteNum, l_u8PayloadByte));

        if(l_u8PayloadByte == 0x01) {
            //Sensor Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 1;
            //GPS Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 1;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 1;
        } else if(l_u8PayloadByte == 0x02){
            //Sensor Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD = 1;
            //GPS Data
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA = 0;
            LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC = 0;
        } else {
            ETG_TRACE_FATAL (("GetGNSSMountedInfo(RNAIVI): GNSS Info Not Available"));
            ETG_TRACE_ERRMEM(("GetGNSSMountedInfo(RNAIVI): GNSS Info Not Available"));
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("GetGNSSMountedInfo(RNAIVI): failed to Read configuration from KDS: l_KDSAddress:0x%x read, l_u8PayloadByte%d",l_KDSAddress, l_u8ByteNum));
    }
}

void CustomerConfiguration::SupportVideoFileFormats()
{
    ENTRY;

    int beginIndex = (LocalSPM::GetDataProvider().SupportedFileTypes() +1);//Start with index following the current last index of the supportedFileTypes
    if((13 == beginIndex) || (17 == beginIndex))
    {
        if(13 == beginIndex)
        {
            SUPPORTED_FILE_TYPE(13, ".m4v", FFT_M4V, FT_VIDEO);
            SUPPORTED_FILE_TYPE(14, ".mp4", FFT_MP4, FT_VIDEO);
            SUPPORTED_FILE_TYPE(15, ".3gp", FFT_3GP, FT_VIDEO);
            SUPPORTED_FILE_TYPE(16, ".mpeg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(17, ".mpg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(18, ".avi", FFT_AVI, FT_VIDEO);
            SUPPORTED_FILE_TYPE(19, ".wmv", FFT_WMV, FT_VIDEO);
        }
        else
        {
            SUPPORTED_FILE_TYPE(17, ".m4v", FFT_M4V, FT_VIDEO);
            SUPPORTED_FILE_TYPE(18, ".mp4", FFT_MP4, FT_VIDEO);
            SUPPORTED_FILE_TYPE(19, ".3gp", FFT_3GP, FT_VIDEO);
            SUPPORTED_FILE_TYPE(20, ".mpeg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(21, ".mpg", FFT_MPEG, FT_VIDEO);
            SUPPORTED_FILE_TYPE(22, ".avi", FFT_AVI, FT_VIDEO);
            SUPPORTED_FILE_TYPE(23, ".wmv", FFT_WMV, FT_VIDEO);
        }
        LocalSPM::GetDataProvider().SupportedFileTypes = LocalSPM::GetDataProvider().SupportedFileTypes() + 7; //In addition to other filetypes ,7-FT_VIDEO are also supported
    }
    else
    {
        ETG_TRACE_ERR(("SupportVideoFileFormats beginIndex is currently not supported"));
    }
}

void CustomerConfiguration::SupportVideoIndexingInMSCDevices()
{
    ENTRY;

    LocalSPM::GetDataProvider().VideoIndexingOn = 1;
}

void CustomerConfiguration::SupportVideoIndexingInMTPDevices()
{
    ENTRY;

    //todo(pee1cob):Remove the dependency on this configuration.cofiguration "MTPVideoSupport" must be sufficient
    LocalSPM::GetDataProvider().VideoIndexingOn = 1;

    LocalSPM::GetDataProvider().MTPVideoSupport = 1;
}

void CustomerConfiguration::AnnounceSeparateSources()
{
    ENTRY;

    /* In general if a USB has audio + video files, Mediaplayer announces 1 source available to AudioRoutingLib(in which both audio and videos can play)
     * With this function,instead of 1 source announcement, 2 sources announced
     * i.e 1 audio source (to play audio files from device)
     *     1 video source (to play video files from device)
     */
    LocalSPM::GetDataProvider().SeparateMediaContent = 1;
    LocalSPM::GetDataProvider().DBDefaultMediaContext = MC_AUDIO;
}

