/**
 * @defgroup Configuration Configuration
 * @author Stephan Pieper
 *
 * public interface for Nissan configuration
 * @{
 */

#ifndef NIS_CONFIGURATION_H_
#define NIS_CONFIGURATION_H_

#include <string>

#include "TypeDefinitions.h"
#include "Configuration.h"



///--------------------------------------------------------------
//see fct. GetSubversion(),teSubversionType,trSubVersionValueDescription
/*todo(pee1cob):1.enums values be given names differ with minor change ; 2.Remove value assigned from enumerations.Thus,keep relative enumerations sequential;
 *              3.Extend enum SubversionTypes_E for new KDS subversion strings:GMP_NisScope3AIVI;GMP_NisScope3RENAULT
 */
/*Note:[Video playback support]
 * OEM                  VARIANT             SUPPORT
 * Nissan           scope 1,scope 2      Not supported
 * NissanAIVI       scope 2.1,scope 3    supported only in sub-versions having substring "_VID"
 * RenaultNissan    scope 2.1,scope 3    supported in all sub-versions
 * PIVI                                  supported only sub-versions having substring "_VID"
*/
typedef enum SubversionTypes_E
{
    eSubType_Undefined                          = 0,
    eSubType_GMP_NisScope1                      = 1,
    eSubType_GMP_NisScope2                      = 2,
    eSubType_GMP_NisScope2_WO_iAP1              = 3,
    eSubType_GMP_NisScope2_1AIVI                = 4,
    eSubType_GMP_NisScope2_1AIVI_WO_iAP1        = 5,
    eSubType_GMP_NisSC2_1AIVI_VID               = 6,
    eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID       = 7,
    eSubType_GMP_NisScope2_1RENAULT             = 8,
    eSubType_GMP_NisScope2_1RENAULT_WO_iAP1     = 9,
    eSubType_GMP_Nis_PIVI                       = 10,
    eSubType_GMP_Nis_PIVI_WO_iAP1               = 11,
    eSubType_GMP_Nis_PIVI_VID                   = 12,
    eSubType_GMP_Nis_PIVI_WO_iAP1_VID           = 13,
    eSubType_GMP_NisScope3AIVI                  = 14,
    eSubType_GMP_NisScope3AIVI_WO_iAP1          = 15,
    eSubType_GMP_NisSC3AIVI_VID                 = 16,
    eSubType_GMP_NisSC3AIVI_WO_iAP1_VID         = 17,
    eSubType_GMP_NisScope3RENAULT               = 18,
    eSubType_GMP_NisScope3RENAULT_WO_iAP1       = 19,
    eSubTypeLastElem                            = 20
}teSubversionType;

typedef struct
{
    teSubversionType                  enSubType;
    std::string                       strBoundRegistryValue;
    std::string                       strDescription;
    tBool                             bUseRegistry; //is set then instead of the versions hardcoded - registry will be read to update values.
} trSubVersionValueDescription;
//-------------------------------------------------------------------


class CustomerConfiguration : public Configuration
{

public:
    CustomerConfiguration(tComponentID componentId);

    /**
    * This function sets early Generic MediaPlayer configuration values.
    *
    */
    virtual tResult PreLoadSettings(void);

    /**
    * This function sets all Generic MediaPlayer configuration values.
    *
    */
    virtual tResult LoadSettings(void);




protected:

      virtual void CreateSortlibRuleTable();

      void CheckBluetoothStack();

      //KDS read methods
      void GetAllianceMCH1MountType();
      void GetBTName();
      void GetManufacturerName();
      void GetSerialNumber();
      void GetAccessoryHwFwVersion();
      void GetResolution();
      void GetDVDRegionCode();
      //uses Datapoolfunction. Which rely on KDS entries //02.03.17
      void GetVehicleInformationDestinationRegion();
      void GetCMVariantCodingDVD();
      void GetCarPlayWirelessFeature();
      void GetManufacturerModelName();
      void GetCMOEMTypeFromPD();
      void GetAllianceBrandTypeFromCD();
      tU8 GetRegionType();
      void GetCarLifeFeature();
      void GetMySpinFeature();
      void GetGNSSMountedInfo();



    /**
        * This function sets all Generic MediaPlayer configurations of relatet subversion
        * If less distinction between different subversion use eSubVersion to set individual values
        * If difference is more difficult then declare and define additional functions to be called instead from
        * above function LoadSettings which calls this function
        */
      tResult LoadSettingsBaseRNAIVI(void);
      tResult LoadSettingsSubversionNisScop1(void);
      tResult LoadSettingsSubversionNisScop2(teSubversionType eSubVersion);
      tResult LoadSettingsSubversionScope2AIVIAndRenault(teSubversionType eSubVersion);
      tResult LoadSettingsSubversionNisPivi(teSubversionType eSubVersion);
      tResult LoadSettingsDefault(void);
      tResult LoadSupportedLanguages(void);

      /**
       * print waring to errmem that kds entry is missing
       *
       */
      void ErrmemPrintMissingKDSEnty(teSubversionType eSubVersion);

    /**
        * This function reads a KDS value and converts it into teSubversionType
        * via call GetSubversionEnum()
        *
        * return  !=eSubTypeLastElem:ok  ==eSubTypeLastElem:error
        */
      teSubversionType GetSubversion();

      /**
      * This function looks up the array :m_rSubVersionValueDescriptions to find the entry whose  strBoundRegistryValue matches given string.
      * If found,returnss the entry's enSubType
      *
      * return  !=eSubTypeLastElem:ok  ==eSubTypeLastElem:error
      */
      teSubversionType GetSubversionEnum(const char* subversionString);

      void GetVariantType();

      /**
      * This function extends the file formats supported with  videoFile formats
      *
      */
      void SupportVideoFileFormats();

      /**
      * This function sets up configurations needed to support videoFile indexing in USB MSC(i.e Mass Storage Class) Devices
      *
      */
      void SupportVideoIndexingInMSCDevices();

      /**
      * This function sets up configurations needed to support videoFile indexing in MTP Devices
      *
      */
      void SupportVideoIndexingInMTPDevices();

      /**
      * This function sets up configurations needed to announce Audio Contents in a device as one source and
      *  Video contents in the same device as another source. Thus 2 sources are announced for 1 physical Device.
      *
      */
      void AnnounceSeparateSources();

      static trSubVersionValueDescription m_rSubVersionValueDescriptions[eSubTypeLastElem];//first implementation for NIS - later

private:
      teSubversionType mSubVersion;

};

#endif /*NIS_CONFIGURATION_H_*/

/** @} */
