/**
 * @defgroup Configuration Configuration
 * @author Pauvithraa Karuppaiah Thiyagarajan
 *
 * public interface for INF4CV configuration
 * @{
 */

#ifndef INF4CV_CONFIGURATION_H_
#define INF4CV_CONFIGURATION_H_

#include <string>

#include "TypeDefinitions.h"
#include "Configuration.h"


class CustomerConfiguration : public Configuration
{

public:
    CustomerConfiguration(tComponentID componentId);

    /**
    * This function sets early Generic MediaPlayer configuration values.
    *
    */
    virtual tResult PreLoadSettings(void);

    /**
    * This function sets all Generic MediaPlayer configuration values.
    *
    */
    virtual tResult LoadSettings(void);




protected:

      virtual void CreateSortlibRuleTable();

      void CheckBluetoothStack();

      //KDS read methods
      void GetAllianceMCH1MountType();
      void GetBTName();
      void GetSerialNumber();
      void GetAccessoryHwFwVersion();
      void GetVariantType();
      void GetResolution();
      void GetDVDRegionCode();
      //uses Datapoolfunction. Which rely on KDS entries //02.03.17
      void GetVehicleInformationDestinationRegion();
      void GetCMVariantCodingDVD();
      void GetCarPlayWirelessFeature();

      /*
       * Read MFiCertified bit from KDS and set Devices types accordingly
       */

      void GetMFiCertificationStatus();
      void SetSupportedDeviceTypes();
      void SetIndexingSupportedDevices();
      void SetPermanentStreamingDeviceTypes();
      void SetMySpinFeatureSupport();

private:

      tU8 m_MFiCertified;

};

#endif /*INF4CV_CONFIGURATION_H_*/

/** @} */
