/**
 * @author Stefan Scherber
 *
 * Implentation of CCAServiceAppControl
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER  //ToDo: must be replaced
#include "trcGenProj/Header/FC_MediaPlayer_service_AppControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_service_AppControl.h"
#include "MediaPlayerInterface.h"
#include "OutputWrapper.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION  MPLAY_APPCONTROLFI_C_U16_SERVICE_MAJORVERSION
#define FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MINOR_VERSION  MPLAY_APPCONTROLFI_C_U16_SERVICE_MINORVERSION

#include "VarTrace.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclService_AppControl, ahl_tclBaseWork)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_CONNECT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onConnect)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_COMMAND, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onCommand)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_CLOSE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onClose)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_STARTAUDIO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onStartAudio)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_STOPAUDIO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onStopAudio)

    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOACTIVEDEVICE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOActiveDevice)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOROLESWITCHREQUEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPORoleSwitchRequest)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOTRANSFERGPSDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOTransferGPSData)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOTRANSFERDRDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOTransferDRData)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOGETMEDIAOBJECTALBUMART, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onGetMediaObjectAlbumArt)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOGETMEDIAOBJECTALBUMARTINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onGetMediaObjectAlbumArtInfo)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOREQUESTAUDIODEVICE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPORequestAudioDevice)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPORELEASEAUDIODEVICE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOReleaseAudioDevice)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOREQUESTPLAYBACKACTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPORequestPlaybackAction)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSTARTIAP2OVERCARPLAYWIFI, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOStartIAP2OverCarplayWiFi)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_SWAPCALLS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onSwapCalls)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSTARTROUTEGUIDANCE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOStartRG)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSTOPROUTEGUIDANCE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOStopRG)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSTARTROUTEGUIDANCE2, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOStartRG2)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSTOPROUTEGUIDANCE2, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOStopRG2)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSETROUTEGUIDANCEDISPLAYCOMPONENTINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOSetRGDisplayComponentInfo)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSETCALLCONTROLSCONFIGURATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOSetCallControlsConfiguration)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOINITIATECALL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOInitiateCall)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOACCEPTCALL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOAcceptCall)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOENDCALL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOEndCall)
    ON_MESSAGE_SVCDATA(MPLAY_APPCONTROLFI_C_U16_DIPOSWAPCALLS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onDiPOSwapCalls)
END_MSG_MAP()


/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclService_AppControl::fc_mediaplayer_tclService_AppControl(fc_mediaplayer_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class ahl_tclBaseOneThreadService
*              with a pointer to this application, the service identifier,
*              the application identifier and the service version as parameters.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclService_AppControl::fc_mediaplayer_tclService_AppControl(fc_mediaplayer_tclApp* poMainAppl):ahl_tclBaseOneThreadService( //finished: 100%
      /* Application Pointer              */ poMainAppl,
      /* ID of offered Service            */ CCA_C_U16_SRV_IPOD_APP_CONTROL,
      /* MajorVersion of offered Service  */ FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MINOR_VERSION)
{
    ENTRY
    m_poMainAppInstance = poMainAppl;
    userContextForRequestAudio.sourceAppID = 0;
    userContextForRequestAudio.registerID = 0;
    userContextForRequestAudio.cmdCounter = 0;
    userContextForRequestAudio.functionID = 0;
    userContextForRequestAudio.serviceID = 0;
    memset(m_sCurrentRoleSwitchUSBSerialNumber,'\0',sizeof(m_sCurrentRoleSwitchUSBSerialNumber));
}

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclService_AppControl::~fc_mediaplayer_tclService_AppControl(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclService_AppControl::~fc_mediaplayer_tclService_AppControl(tVoid) //finished: 100%
{
    ENTRY
}


tVoid fc_mediaplayer_tclService_AppControl::onConnect(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgConnectMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint mountPoint;
        tProtocolName protocol;
        tBundleSeedID bundleSeedID;
        tAppName appName;
        tAppLaunchOption launchOption = tAppLaunchOption_init;

        ConvertAppLaunchOptionToInternal(launchOption, oFiDataObjectMethodStart.e8AppLaunchOption);
        strncpy(mountPoint, oFiDataObjectMethodStart.szDeviceId.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof mountPoint -1);
        strncpy(protocol, oFiDataObjectMethodStart.szProtocol.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof protocol -1);
        strncpy(bundleSeedID, oFiDataObjectMethodStart.szBundleSeedID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof bundleSeedID -1);
        strncpy(appName, oFiDataObjectMethodStart.szAppName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof appName -1);
        result = MediaPlayerInterface::GetInstance().SendAppControlConnect(mountPoint, protocol, bundleSeedID, appName, launchOption);
        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgConnectMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.szDeviceId.bSet(mountPoint, mplay_fi_tclString::FI_EN_UTF8);
            oFiDataObjectMethodResult.szAppName.bSet(appName, mplay_fi_tclString::FI_EN_UTF8);
            oFiDataObjectMethodResult.u16SessionId = 0; //sessionID not used here, updates via property
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onCommand(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgCommandMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint mountPoint;
        tAppName appName;
        tSessionID sessionID;
        tSize sizeOfBuffer = 0;
        tCommandBufferPtr commandBuffer = 0;
        tUserContext userContext;
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        strncpy(mountPoint, oFiDataObjectMethodStart.szDeviceId.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof mountPoint -1);
        strncpy(appName, oFiDataObjectMethodStart.szAppName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof appName -1);
        sessionID = oFiDataObjectMethodStart.u16SessionId;
        sizeOfBuffer = oFiDataObjectMethodStart.au8CommandBuffer.ContainerDataList.size();
        if(sizeOfBuffer) {
            commandBuffer = &oFiDataObjectMethodStart.au8CommandBuffer.ContainerDataList[0];
        }
        result = MediaPlayerInterface::GetInstance().SendAppControlCommand(mountPoint, appName, sessionID, sizeOfBuffer, commandBuffer, userContext);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tResult fc_mediaplayer_tclService_AppControl::SendCommandAnswer(const tMountPoint mountPoint, const tAppName appName, const tSessionID sessionID,const tUserContext userContext)
{
    ENTRY

    mplay_appcontrolfi_tclMsgCommandMethodResult oFiDataObjectMethodResult;
    oFiDataObjectMethodResult.szDeviceId.bSet(mountPoint, mplay_fi_tclString::FI_EN_UTF8);
    oFiDataObjectMethodResult.szAppName.bSet(appName, mplay_fi_tclString::FI_EN_UTF8);
    oFiDataObjectMethodResult.u16SessionId = sessionID;
    // au8CommandResponseBuffer is not filled

    fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    oFiDataObjectMethodResult.vDestroy();
    return 0;
}

tVoid fc_mediaplayer_tclService_AppControl::onClose(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgCloseMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint mountPoint;
        tAppName appName;
        tSessionID sessionID;

        strncpy(mountPoint, oFiDataObjectMethodStart.szDeviceId.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof mountPoint -1);
        strncpy(appName, oFiDataObjectMethodStart.szAppName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof appName -1);
        sessionID = oFiDataObjectMethodStart.u16SessionId;

        result = MediaPlayerInterface::GetInstance().SendAppControlClose(mountPoint, appName, sessionID);
        if (0 == result)
        {   mplay_appcontrolfi_tclMsgCloseMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onStartAudio(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgStartAudioMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint mountPoint;

        strncpy(mountPoint, oFiDataObjectMethodStart.szDeviceId.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof mountPoint -1);

        result = MediaPlayerInterface::GetInstance().StartAudio(mountPoint);
        if (0 == result)
        {   mplay_appcontrolfi_tclMsgStartAudioMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onStopAudio(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgStopAudioMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint mountPoint;

        strncpy(mountPoint, oFiDataObjectMethodStart.szDeviceId.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof mountPoint -1);

        result = MediaPlayerInterface::GetInstance().StopAudio(mountPoint);
        if (0 == result)
        {   mplay_appcontrolfi_tclMsgStopAudioMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onGetMediaObjectAlbumArtInfo (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tAlbumArt albumArtString;
        tUserContext userContext;
        strncpy(albumArtString, oFiDataObjectMethodStart.sAlbumArt.szValue, sizeof albumArtString -1);

        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().GetMediaObjectAlbumArtInfo(albumArtString, 160, 160, MMT_PNG, userContext);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onGetMediaObjectAlbumArt (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tAlbumArt albumArtString;
        tUserContext userContext;
        strncpy(albumArtString, oFiDataObjectMethodStart.sAlbumArt.szValue, sizeof albumArtString -1);
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().GetMediaObjectAlbumArt(albumArtString, 160, 160, MMT_PNG, userContext);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOActiveDevice (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        tDiPOActive diPOActive;
        tUserContext userContext;

        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        diPOActive = oFiDataObjectMethodStart.bDiPOActive;

        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().DiPOActiveDevice(IN deviceID, IN diPOActive, IN userContext);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPORoleSwitchRequest (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        //tUSBSerial sDeviceUSBSerialNumber;
        strncpy_r(m_sCurrentRoleSwitchUSBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(m_sCurrentRoleSwitchUSBSerialNumber) -1);
        VARTRACE(m_sCurrentRoleSwitchUSBSerialNumber);
        tDiPORoleStatus diPORoleStatus;
        tAppInfo appInfo;
        tUserContext userContext;

        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        VARTRACE(deviceID);
        if(!deviceID)
        {
            int res = MediaPlayerInterface::GetInstance().GetDeviceID(OUT deviceID, IN m_sCurrentRoleSwitchUSBSerialNumber);
        }
        ConvertDiPORoleStatusToInternal(OUT diPORoleStatus, oFiDataObjectMethodStart.e8DiPORoleStatus);

        ConvertAppInfoToInternal(appInfo,oFiDataObjectMethodStart.oAppInfo);

        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

       result = MediaPlayerInterface::GetInstance().DiPORoleSwitchRequest(IN deviceID, IN diPORoleStatus, IN userContext,IN appInfo);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOTransferGPSData (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        tMountPoint USBSerialNumber;
        tDiPOGPGGAData diPOGPGGAData;
        tDiPOGPRMCData diPOGPRMCData;
        tDiPOGPGSVData diPOGPGSVData;
        tDiPOGPHDTData diPOGPHDTData;
        tUserContext userContext;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);
        strncpy_r(diPOGPGGAData, oFiDataObjectMethodStart.sGPGGAData.szValue, sizeof diPOGPGGAData);
        strncpy_r(diPOGPRMCData, oFiDataObjectMethodStart.sGPRMCData.szValue, sizeof diPOGPRMCData);
        strncpy_r(diPOGPGSVData, oFiDataObjectMethodStart.sGPGSVData.szValue, sizeof diPOGPGSVData);
        strncpy_r(diPOGPHDTData, oFiDataObjectMethodStart.sGPHDTData.szValue, sizeof diPOGPHDTData);

        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().DiPOTransferGPSData(IN deviceID, IN USBSerialNumber, IN diPOGPGGAData, IN diPOGPRMCData, IN diPOGPGSVData, IN diPOGPHDTData, IN userContext);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOTransferDRData (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        tMountPoint USBSerialNumber;
        tDiPOPASCDData diPOPASCDData;
        tDiPOPAGCDData diPOPAGCDData;
        tDiPOPAACDData diPOPAACDData;
        tUserContext userContext;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);
        //strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclstring::FI_EN_UTF8), sizeof(USBSerialNumber) -1);
        strncpy_r(diPOPASCDData, oFiDataObjectMethodStart.sPASCDData.szValue, sizeof diPOPASCDData);
        strncpy_r(diPOPAGCDData, oFiDataObjectMethodStart.sPAGCDData.szValue, sizeof diPOPAGCDData);
        strncpy_r(diPOPAACDData, oFiDataObjectMethodStart.sPAACDData.szValue, sizeof diPOPAACDData);

        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().DiPOTransferDRData(IN deviceID, IN USBSerialNumber, IN diPOPASCDData, IN diPOPAGCDData, IN diPOPAACDData,IN userContext);
     }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPORequestAudioDevice (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    // check if already a request is pending
    if (0 != userContextForRequestAudio.sourceAppID)
    {
        ETG_TRACE_ERR(("DiPORequestAudioDevice is already in work"));
    }
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        userContextForRequestAudio.sourceAppID = poMessage->u16GetSourceAppID();
        userContextForRequestAudio.registerID = poMessage->u16GetRegisterID();
        userContextForRequestAudio.cmdCounter = poMessage->u16GetCmdCounter();
        userContextForRequestAudio.functionID = poMessage->u16GetFunctionID();
        userContextForRequestAudio.serviceID = poMessage->u16GetServiceID();
        tDeviceID deviceID;
        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        result = MediaPlayerInterface::GetInstance().DiPORequestAudioDevice(IN deviceID);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOReleaseAudioDevice (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        // this function is currently not implemented !!!
        result = MediaPlayerInterface::GetInstance().DiPOReleaseAudioDevice(IN deviceID);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPORequestPlaybackAction(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {

        tDeviceID deviceID = oFiDataObjectMethodStart.u8DeviceTag;
        tPlaybackAction playbackAction;
        ConvertPlaybackActionToInternal(playbackAction, oFiDataObjectMethodStart.e8Action);
        tNextPrevSkipCount nextPrevSkipCount = oFiDataObjectMethodStart.u8NextPrevSkipCount;

        result = MediaPlayerInterface::GetInstance().DiPORequestPlaybackAction(deviceID, playbackAction, nextPrevSkipCount);
        if (0 == result)
        {   mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_AppControl::onDiPOStartIAP2OverCarplayWiFi(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {

        tGeneralString sBTMacAddress;
        strncpy(sBTMacAddress, oFiDataObjectMethodStart.sDeviceBTMacAddress.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(sBTMacAddress) -1);
        VARTRACE(sBTMacAddress);
        result = MediaPlayerInterface::GetInstance().DiPOStartIAP2OverCarplayWiFi(sBTMacAddress);
        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onSwapCalls(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;
    mplay_appcontrolfi_tclMsgSwapCallsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;

        deviceID = oFiDataObjectMethodStart.u8DeviceTag;

        result = MediaPlayerInterface::GetInstance().SendSwapCalls(deviceID);

        if (MP_NO_ERROR == result)
        {   mplay_appcontrolfi_tclMsgSwapCallsMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOSwapCalls(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;
    mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint USBSerialNumber;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.deviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);

        tDiPOCallControlsConfiguration callControlsConfig;
        callControlsConfig = LocalSPM::GetDataProvider().GetDiPOCallControlsConfiguration();
        if(callControlsConfig.bits.isSwapCallsAvailable)
        {
            result = MediaPlayerInterface::GetInstance().DiPOSendSwapCalls(USBSerialNumber);
        }
        else
        {
            ETG_TRACE_USR3(("onSwapCalls: feature not enabled, CallControl config = %d",callControlsConfig.value));
        }
        if (MP_NO_ERROR == result)
        {   mplay_appcontrolfi_tclMsgSwapCallsMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tResult fc_mediaplayer_tclService_AppControl::SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tImageSize size, tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult resultMessage;
    // Set values
    switch(mimeType)
    {
    case MMT_PNG:
        resultMessage.sMIMEImageSubtype.bSet("image/png",mplay_fi_tclString::FI_EN_UTF8);
        break;
    case MMT_BMP:
        resultMessage.sMIMEImageSubtype.bSet("image/x-ms-bmp",mplay_fi_tclString::FI_EN_UTF8);
        break;
    case MMT_GIF:
        resultMessage.sMIMEImageSubtype.bSet("image/gif",mplay_fi_tclString::FI_EN_UTF8);
        break;
    case MMT_JPG:
        resultMessage.sMIMEImageSubtype.bSet("image/jpeg",mplay_fi_tclString::FI_EN_UTF8);
        break;
    default:
        resultMessage.sMIMEImageSubtype.bSet("image/png",mplay_fi_tclString::FI_EN_UTF8);
        break;
    }
    resultMessage.u32PhotoSize = size;

    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}


tResult fc_mediaplayer_tclService_AppControl::SendGetMediaObjectAlbumArtAnswer(tImageData imageData, tImageSize imageSize, tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult resultMessage;

    resultMessage.oImageData.u8Items.resize(imageSize);
    copy(imageData, imageData + imageSize,resultMessage.oImageData.u8Items.begin());
    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tResult fc_mediaplayer_tclService_AppControl::SendDiPOActiveDeviceAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult resultMessage;
    ConvertDiPOResponseToAppControl(resultMessage.e8DiPOResponse, diPOResponse);

    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tResult fc_mediaplayer_tclService_AppControl::SendDiPORoleSwitchRequestAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult resultMessage;
    resultMessage.sDeviceUSBSerialNumber.bSet(m_sCurrentRoleSwitchUSBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
    ConvertDiPOResponseToAppControl(resultMessage.e8DiPOResponse, diPOResponse);

    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tResult fc_mediaplayer_tclService_AppControl::SendDiPOTransferGPSDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult resultMessage;
    ConvertDiPOResponseToAppControl(resultMessage.e8DiPOResponse, diPOResponse);

    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}


tResult fc_mediaplayer_tclService_AppControl::SendDiPOTransferDRDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult resultMessage;
    ConvertDiPOResponseToAppControl(resultMessage.e8DiPOResponse, diPOResponse);

    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
       ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
       SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tResult fc_mediaplayer_tclService_AppControl::SendDiPORequestAudioDeviceAnswer(const tDeviceID /*deviceID*/, const tAudioOutputDevice audioOutputDevice)
{

    ENTRY
    if (0 != userContextForRequestAudio.sourceAppID)
    {
        mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult resultMessage;
        resultMessage.sDeviceName.bSet(audioOutputDevice,mplay_fi_tclString::FI_EN_UTF8);
        resultMessage.e8Error.enType = mplay_fi_tcl_e8_AudioError::FI_EN_E8NO_ERROR;

        fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
        vInitServiceData(oVisitorMsgOutput, userContextForRequestAudio.sourceAppID, userContextForRequestAudio.registerID, userContextForRequestAudio.cmdCounter, userContextForRequestAudio.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
        ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult )
        {
            ETG_TRACE_ERR(("enPostMessage failed: %d", enResult));
            SendError(0, userContextForRequestAudio);
        }
        resultMessage.vDestroy();
        userContextForRequestAudio.sourceAppID = 0;
    }
    else
    {
        ETG_TRACE_ERR(("SendDiPORequestAudioDeviceAnswer: no answer expected"));
    }
    return 0;
}


tResult fc_mediaplayer_tclService_AppControl::SendDiPORequestAudioDeviceError(const tDeviceID /*deviceID*/)
{

    ENTRY
    if (0 != userContextForRequestAudio.sourceAppID)
    {
        mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult resultMessage;
        resultMessage.sDeviceName.bSet("",mplay_fi_tclString::FI_EN_UTF8);
        resultMessage.e8Error.enType = mplay_fi_tcl_e8_AudioError::FI_EN_E8UNKNOWN_ERROR;

        fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);
        vInitServiceData(oVisitorMsgOutput, userContextForRequestAudio.sourceAppID, userContextForRequestAudio.registerID, userContextForRequestAudio.cmdCounter, userContextForRequestAudio.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
        ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult )
        {
            ETG_TRACE_ERR(("enPostMessage failed: %d", enResult));
            SendError(0, userContextForRequestAudio);
        }
        resultMessage.vDestroy();
        userContextForRequestAudio.sourceAppID = 0;
    }
    else
    {
        ETG_TRACE_ERR(("SendDiPORequestAudioDeviceAnswer: no answer expected"));
    }
    return 0;
}

tResult fc_mediaplayer_tclService_AppControl::SendError(tErrorCode /*errorCode*/, tUserContext userContext)  //finished 100%
{
    amt_tclServiceDataError oErrorMsg;

    // Init error message
    vInitServiceData(oErrorMsg, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_ERROR);

    ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oErrorMsg, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult)
    {
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }
    return 0;
};


/******************************************************************************/
/*                                                                            */
/* bStatusMessageFactory                                                      */
/*                                                                            */
/******************************************************************************/
tBool fc_mediaplayer_tclService_AppControl::bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* /*poInMsg*/) //finished: 100%
{
    ENTRY
    tResult bSuccess = false;
    tResult result;
    ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.",u16FunctionId));
    switch(u16FunctionId)
    {
        case MPLAY_APPCONTROLFI_C_U16_SESSIONOPENED:
        {
            tMountPoint deviceID;
            tAppName appName;
            tSessionID sessionID;
            tProtocolName protocolName;
            result = m_poMainAppInstance->GetOutputWrapper().GetAppControlConnect(deviceID, appName, sessionID,protocolName);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgSessionOpenedStatus oFiDataObjectStatus;
                oFiDataObjectStatus.szDeviceId.bSet(deviceID,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.szAppName.bSet(appName,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.u16SessionId = sessionID;
                oFiDataObjectStatus.szProtocolName.bSet(protocolName,mplay_fi_tclString::FI_EN_UTF8);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DATARESPONSE:
        {
            tMountPoint deviceID;
            tAppName appName;
            tSessionID sessionID;
            tSize sizeOfBuffer;
            tCommandBufferPtr commandBuffer;
            result = m_poMainAppInstance->GetOutputWrapper().GetAppControlCommand(deviceID, appName, sessionID, sizeOfBuffer, commandBuffer);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDataResponseStatus oFiDataObjectStatus;
                oFiDataObjectStatus.szDeviceId.bSet(deviceID,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.szAppName.bSet(appName,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.u16SessionId = sessionID;
                oFiDataObjectStatus.au8CommandResponseBuffer.ContainerDataList.reserve(sizeOfBuffer);
                oFiDataObjectStatus.au8CommandResponseBuffer.ContainerDataList.assign(commandBuffer, commandBuffer + sizeOfBuffer);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_SESSIONCLOSED:
        {
            tMountPoint deviceID;
            tAppName appName;
            tSessionID sessionID;
            result = m_poMainAppInstance->GetOutputWrapper().GetAppControlClose(deviceID, appName, sessionID);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgSessionClosedStatus oFiDataObjectStatus;
                oFiDataObjectStatus.szDeviceId.bSet(deviceID,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.szAppName.bSet(appName,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.u16SessionId = sessionID;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_NATIVETRANSPORTSTART:
        {
            tDeviceID deviceId;
            tU8 iAP2iOSAppIdentifier;
            tU8 sinkEndpoint;
            tU8 sourceEndpoint;

            result = m_poMainAppInstance->GetOutputWrapper().GetNativeTransportStart(deviceId,iAP2iOSAppIdentifier,sinkEndpoint,sourceEndpoint);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgNativeTransportStartStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32DeviceId = deviceId;
                oFiDataObjectStatus.u8IAP2iOSAppIdentifier = iAP2iOSAppIdentifier;
                oFiDataObjectStatus.u8SinkEndpoint = sinkEndpoint;
                oFiDataObjectStatus.u8SourceEndpoint = sourceEndpoint;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_NATIVETRANSPORTSTOP:
        {
            tDeviceID deviceId;
            tU8 iAP2iOSAppIdentifier;
            tU8 sinkEndpoint;
            tU8 sourceEndpoint;

            result = m_poMainAppInstance->GetOutputWrapper().GetNativeTransportStop(deviceId,iAP2iOSAppIdentifier,sinkEndpoint,sourceEndpoint);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgNativeTransportStopStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32DeviceId = deviceId;
                oFiDataObjectStatus.u8IAP2iOSAppIdentifier = iAP2iOSAppIdentifier;
                oFiDataObjectStatus.u8SinkEndpoint = sinkEndpoint;
                oFiDataObjectStatus.u8SourceEndpoint = sourceEndpoint;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS"));
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInformation;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices, deviceInformation, true); //Fix for PSARCCB-7593..Set flag isForDipo=true
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus oFiDataObjectStatus;
                vector<tDeviceInfo>::iterator it;
                for(it = deviceInformation.begin(); it < deviceInformation.end(); it++)
                {
                    mplay_fi_tcl_DiPODeviceInfoItem item;
                    ConvertDeviceInfoToAppControl(item, *it);
                    oFiDataObjectStatus.oDeviceInfo.oItems.push_back(item);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPLAYTIME:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPLAYTIME"));
            tDeviceID deviceID;
            tPlaytime elapsedPlaytime;
            tPlaytime totalPlaytime;
            result = MediaPlayerInterface::GetInstance().GetDiPOPlaytime(deviceID, elapsedPlaytime, totalPlaytime);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                oFiDataObjectStatus.u32ElapsedPlaytime = elapsedPlaytime/1000;
                oFiDataObjectStatus.u32TotalPlaytime = totalPlaytime/1000;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOMETADATA:
        {
            //Deprecated
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOMETADATA"));
            tDeviceID deviceID;
            tDiPONowPlaying nowPlaying;
            result = MediaPlayerInterface::GetInstance().GetDiPONowPlaying(deviceID, nowPlaying);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOMetaDataStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                oFiDataObjectStatus.sTitle.bSet(nowPlaying.title, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sArtist.bSet(nowPlaying.artist, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAlbum.bSet(nowPlaying.album, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sGenre.bSet(nowPlaying.genre, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAlbumArt.bSet(nowPlaying.albumArt, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAppName.bSet(nowPlaying.appName, mplay_fi_tclString::FI_EN_UTF8);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPHONEDATA:
        {
            //Deprecated
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPHONEDATA"));
            tDeviceID deviceID;
            tDiPOCallState callStateList;
            result = MediaPlayerInterface::GetInstance().GetDiPOCallState(deviceID, callStateList);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus oFiDataObjectStatus;
                tDiPOCallState::iterator it;
                for(it = callStateList.begin(); it < callStateList.end(); it++) {
                    if(it->status != DIPO_CALL_STATUS_DISCONNECTED) {
                        //first item only
                        if(it->displayName[0] != 0) {
                            //use caller name if exists
                            oFiDataObjectStatus.sPhoneCaller.bSet(it->displayName, mplay_fi_tclString::FI_EN_UTF8);
                        } else {
                            //no caller, use phone number
                            oFiDataObjectStatus.sPhoneCaller.bSet(it->remoteID, mplay_fi_tclString::FI_EN_UTF8);
                        }
                    }
                    break;
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOLOCATIONINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOLOCATIONINFO"));
            tDeviceID deviceID;
            tBool startStopLocationInfo;
            tDiPOLocationInfoType locationInfoType;
            result = MediaPlayerInterface::GetInstance().GetDiPOLocationInfo(deviceID,startStopLocationInfo,locationInfoType);

            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bStartStopLocationInfo = startStopLocationInfo;
                if (1==locationInfoType.GPGGA)
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPGGA(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPGGA(FALSE);
                if (1==locationInfoType.GPRMC)
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPRMC(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPRMC(FALSE);
                if (1==locationInfoType.GPGSV)
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPGSV(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPGSV(FALSE);
                if (1==locationInfoType.GPHDT)
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPHDT(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetGPHDT(FALSE);
                if (1==locationInfoType.PASCD)
                    oFiDataObjectStatus.b8LocationInfoType.vSetPASCD(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetPASCD(FALSE);
                if (1==locationInfoType.PAGCD)
                    oFiDataObjectStatus.b8LocationInfoType.vSetPAGCD(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetPAGCD(FALSE);
                if (1==locationInfoType.PAACD)
                    oFiDataObjectStatus.b8LocationInfoType.vSetPAACD(TRUE);
                else
                    oFiDataObjectStatus.b8LocationInfoType.vSetPAACD(FALSE);

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_CONNECTEDBLUETOOTHPROFILES:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_CONNECTEDBLUETOOTHPROFILES"));
            tBTProfileList profileList;
            result = MediaPlayerInterface::GetInstance().GetBTProfileInfo(profileList);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus oFiDataObjectStatus;
                tBTProfileList::iterator it;
                for(it = profileList.begin(); it < profileList.end(); it++) {
                    mplay_fi_tcl_BTProfileItem item;
                    item.u8DeviceId = it->deviceID;
                    item.b32BTProfile.vSetHandsFree(it->BTProfile.HandsFree);
                    item.b32BTProfile.vSetPhoneBookAccess(it->BTProfile.PhoneBookAccess);
                    item.b32BTProfile.vSetAudioVideoRemoteControl(it->BTProfile.AudioVideoRemoteControl);
                    item.b32BTProfile.vSetAdvancedAudioDistribution(it->BTProfile.AdvancedAudioDistribution);
                    item.b32BTProfile.vSetHumanInterfaceDevice(it->BTProfile.HumanInterfaceDevice);
                    item.b32BTProfile.vSetiAP2Link(it->BTProfile.iAP2Link);
                    item.b32BTProfile.vSetPersonalAreaNetworkAccessPoint(it->BTProfile.PersonalAreaNetworkAccessPoint);
                    item.b32BTProfile.vSetMessageAccess(it->BTProfile.MessageAccess);
                    item.b32BTProfile.vSetPersonalAreaNetworkClient(it->BTProfile.PersonalAreaNetworkClient);
                    oFiDataObjectStatus.oBTProfileInfo.oItems.push_back(item);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPONOWPLAYING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPONOWPLAYING"));
            tDeviceID deviceID;
            tDiPONowPlaying nowPlaying;
            result = MediaPlayerInterface::GetInstance().GetDiPONowPlaying(deviceID, nowPlaying);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPONowPlayingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                oFiDataObjectStatus.sTitle.bSet(nowPlaying.title, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sArtist.bSet(nowPlaying.artist, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAlbum.bSet(nowPlaying.album, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sGenre.bSet(nowPlaying.genre, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sComposer.bSet(nowPlaying.composer, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAlbumArt.bSet(nowPlaying.albumArt, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.sAppName.bSet(nowPlaying.appName, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.u16AlbumTrackNumber = nowPlaying.albumTrackNumber;
                oFiDataObjectStatus.u16AlbumTrackCount = nowPlaying.albumTrackCount;
                oFiDataObjectStatus.u16AlbumDiscNumber = nowPlaying.albumDiscNumber;
                oFiDataObjectStatus.u16AlbumDiscCount = nowPlaying.albumDiscCount;
                oFiDataObjectStatus.u16ChapterCount = nowPlaying.chapterCount;
                oFiDataObjectStatus.u32QueueIndex = nowPlaying.queueIndex;
                oFiDataObjectStatus.u32QueueCount = nowPlaying.queueCount;
                oFiDataObjectStatus.u32QueueChapterIndex = nowPlaying.queueChapterIndex;
                oFiDataObjectStatus.biTunesRadioAd = nowPlaying.iTunesRadioAd;
                oFiDataObjectStatus.siTunesRadioStationName.bSet(nowPlaying.iTunesRadioStationName, mplay_fi_tclString::FI_EN_UTF8);

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSTATUS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSTATUS"));
            tDeviceID deviceID;
            tHMIPlaybackState playbackState;
            result = MediaPlayerInterface::GetInstance().GetDiPOPlaybackStatus(deviceID, playbackState);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                ConvertPlaybackStateToAppControl(oFiDataObjectStatus.e8State, playbackState);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSHUFFLEMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSHUFFLEMODE"));
            tPlaybackMode playbackMode;
            tDeviceID deviceID;
            result = MediaPlayerInterface::GetInstance().GetDiPOPlaybackShuffleMode(deviceID, playbackMode);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                ConvertPlaybackModeToAppControl(oFiDataObjectStatus.e8Mode, playbackMode);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKREPEATMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKREPEATMODE"));
            tRepeatMode repeatMode;
            tDeviceID deviceID;
            result = MediaPlayerInterface::GetInstance().GetDiPOPlaybackRepeatMode(deviceID, repeatMode);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                ConvertRepeatModeToAppControl(oFiDataObjectStatus.e8Mode, repeatMode);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOCALLSTATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOCALLSTATE"));
            tDeviceID deviceID;
            tDiPOCallState callStateList;
            result = MediaPlayerInterface::GetInstance().GetDiPOCallState(deviceID, callStateList);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOCallStateStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                tDiPOCallState::iterator it;
                for(it = callStateList.begin(); it < callStateList.end(); it++) {
                    mplay_fi_tcl_DiPOCallStateItem item;
                    item.sRemoteID.bSet(it->remoteID, mplay_fi_tclString::FI_EN_UTF8);
                    item.sDisplayName.bSet(it->displayName, mplay_fi_tclString::FI_EN_UTF8);
                    ConvertDiPOCallStatusToAppControl(item.eStatus, it->status);
                    ConvertDiPOCallDirectionToAppControl(item.eDirection, it->direction);
                    item.sCallUUID.bSet(it->callUUID, mplay_fi_tclString::FI_EN_UTF8);
                    item.sAddressBookID.bSet(it->addressBookID, mplay_fi_tclString::FI_EN_UTF8);
                    item.sLabel.bSet(it->label, mplay_fi_tclString::FI_EN_UTF8);
                    ConvertDiPOCallServiceToAppControl(item.eService, it->service);
                    item.bIsConferenced = it->isConferenced;
                    item.u8ConferenceGroup = it->conferenceGroup;
                    ConvertDiPOCallDisconnectReasonToAppControl(item.eDisconnectReason, it->disconnectReason);
                    item.u64StartTimestamp = it->startTimestamp;
                    oFiDataObjectStatus.oCallStateUpdate.oItems.push_back(item);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOCOMMUNICATIONS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOCOMMUNICATIONS"));
            tDeviceID deviceID;
            tDiPOCommunications communications;
            result = MediaPlayerInterface::GetInstance().GetDiPOCommunications(deviceID, communications);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                ConvertDiPOCommunicationsSignalStrengthToAppControl(oFiDataObjectStatus.eSignalStrength, communications.signalStrength);
                ConvertDiPOCommunicationsRegistrationStatusToAppControl(oFiDataObjectStatus.eRegistrationStatus, communications.registrationStatus);
                oFiDataObjectStatus.bAirplaneModeStatus = communications.airplaneModeStatus;
                oFiDataObjectStatus.sCarrierName.bSet(communications.carrierName, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.bCellularSupported = communications.cellularSupported;
                oFiDataObjectStatus.bTelephonyEnabled = communications.telephonyEnabled;
                oFiDataObjectStatus.bFaceTimeAudioEnabled = communications.faceTimeAudioEnabled;
                oFiDataObjectStatus.bFaceTimeVideoEnabled = communications.faceTimeVideoEnabled;
                oFiDataObjectStatus.bMuteStatus = communications.muteStatus;
                oFiDataObjectStatus.u8CurrentCallCount = communications.currentCallCount;
                oFiDataObjectStatus.u8NewVoicemailCount = communications.newVoicemailCount;
                oFiDataObjectStatus.bInitiateCallAvalable = communications.initiateCallAvalable;
                oFiDataObjectStatus.bEndAndAcceptAvailable = communications.endAndAcceptAvailable;
                oFiDataObjectStatus.bHoldAndAcceptAvailable = communications.holdAndAcceptAvailable;
                oFiDataObjectStatus.bSwapAvailable = communications.swapAvailable;
                oFiDataObjectStatus.bMergeAvailable = communications.mergeAvailable;
                oFiDataObjectStatus.bHoldAvailable = communications.holdAvailable;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOCOMMUNICATIONERROR:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DIPOCOMMUNICATIONERROR"));
            tDeviceID deviceID;
            tIpodCommError iPodCommError;
            tMountPoint USBSerialNumber;
            result = m_poMainAppInstance->GetOutputWrapper().GetDipoCommunicationError(deviceID, iPodCommError, USBSerialNumber);
            if(0 == result){
                mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus oFiDataObjectStatus;
                ConvertDeviceTagToAppControl(oFiDataObjectStatus.u8DeviceTag, deviceID);
                if(IPOD_COMM_ERROR == iPodCommError)
                {
                    oFiDataObjectStatus.e8DiPOCommunicationError.enType =  mplay_fi_tcl_e8_DiPOCommunicationError::FI_EN_E8IPOD_COMM_ERROR;
                }
                else if(IPOD_NO_ERROR == iPodCommError)
                {
                    oFiDataObjectStatus.e8DiPOCommunicationError.enType =  mplay_fi_tcl_e8_DiPOCommunicationError::FI_EN_E8IPOD_NO_ERROR;
                }
                else if(IPOD_ROLESWITCH_ERROR == iPodCommError)
                {
                    oFiDataObjectStatus.e8DiPOCommunicationError.enType =  mplay_fi_tcl_e8_DiPOCommunicationError::FI_EN_E8IPOD_ROLESWITCH_ERROR;
                }

                oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOCALLDURATION:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOCALLDURATION"));

            tDeviceID deviceID;
            tPlaytime callDuratiuon;
            result = MediaPlayerInterface::GetInstance().GetDiPOCallDuration(deviceID, callDuratiuon);
            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOCallDurationStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceId = deviceID;
                oFiDataObjectStatus.u32CallDuration = callDuratiuon;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPOPOWER:
                {
                    ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOPOWER"));
                    tDeviceID deviceID;
                    tDiPOPower power;
                    result = MediaPlayerInterface::GetInstance().GetDiPOPower(deviceID, power);
                    if (0 == result)
                    {
                        mplay_appcontrolfi_tclMsgDiPOPowerStatus oFiDataObjectStatus;
                        oFiDataObjectStatus.u8DeviceId = deviceID;
                        ConvertDiPOAccessoryPowerModeToAppControl(oFiDataObjectStatus.e8AccessoryPowerMode, power.AccessoryPowerMode);
                        ConvertDiPOBatteryChargingStateToAppControl(oFiDataObjectStatus.e8BatteryChargingState, power.BatteryChargingState);
                        oFiDataObjectStatus.u16MaximumCurrentDrawnFromAccessory = power.MaximumCurrentDrawnFromAccessory;
                        oFiDataObjectStatus.u16BatteryChargeLevel = power.BatteryChargeLevel;
                        oFiDataObjectStatus.bDeviceBatteryWillChargeIfPowerIsPresent = power.DeviceBatteryWillChargeIfPowerIsPresent;
                        oFiDataObjectStatus.bIsExternalChargerConnected = power.IsExternalChargerConnected;
                        bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
                    }
                    break;
                }
#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
        case MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE:
                {
                    ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE"));
                    tDeviceID deviceID;
                    tMountPoint USBSerialNumber;
                    tDiPORouteGuidanceUpdate RGUpdate;
                    result = MediaPlayerInterface::GetInstance().GetRGUpdate(deviceID,RGUpdate);
                    if (0 == result)
                    {
                        int res = MediaPlayerInterface::GetInstance().DiPOGetUSBSerialNumber(IN deviceID,OUT USBSerialNumber);

                        mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus oFiDataObjectStatus;
                        if(!res)
                        {
                            oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
                        }

                        oFiDataObjectStatus.u16RouteGuidanceDisplayComponentID = RGUpdate.RouteGuidanceDisplayComponentID;
                        ConvertDiPORouteGuidanceStateToAppControl(oFiDataObjectStatus.e8RouteGuidanceState,RGUpdate.RouteGuidanceState);
                        ConvertDiPOManeuverStateManeuverStateToAppControl(oFiDataObjectStatus.e8ManeuverState,RGUpdate.ManeuverState);
                        oFiDataObjectStatus.szCurrentRoadName.bSet(RGUpdate.CurrentRoadName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.szDestinationName.bSet(RGUpdate.DestinationName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.u64EstimatedTimeOfArrival = RGUpdate.EstimatedTimeOfArrival;
                        oFiDataObjectStatus.u64TimeRemainingToDestination = RGUpdate.TimeRemainingToDestination;
                        oFiDataObjectStatus.u32DistanceRemaining = RGUpdate.DistanceRemaining;
                        oFiDataObjectStatus.szDistanceRemainingDisplayStr.bSet(RGUpdate.DistanceRemainingDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.e8DistanceRemainingDisplayUnits,RGUpdate.DistanceRemainingDisplayUnits);
                        oFiDataObjectStatus.u32DistanceToNextManeuver = RGUpdate.DistanceToNextManeuver;
                        oFiDataObjectStatus.szDistanceToNextManeuverDisplayStr.bSet(RGUpdate.DistanceToNextManeuverDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.e8DistanceToNextManeuverDisplayUnits,RGUpdate.DistanceToNextManeuverDisplayUnits);
                        ConvertManeuverListToAppControl(oFiDataObjectStatus.u16RouteGuidanceManeuverCurrentList,RGUpdate.RouteGuidanceManeuverCurrentList);
                        oFiDataObjectStatus.u16RouteGuidanceManeuverCount = RGUpdate.RouteGuidanceManeuverCount;
                        oFiDataObjectStatus.bIsRouteGuidanceVisibleInApp = RGUpdate.RouteGuidanceVisibleInApp;
                        oFiDataObjectStatus.SourceName = RGUpdate.SourceName;
                        oFiDataObjectStatus.SourceSupportsRouteGuidance = RGUpdate.SourceSupportsRouteGuidance;
                        bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
                    }
                    break;
                 }
        case MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER:
                 {
                    ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER"));
                    tDeviceID deviceID;
                    tMountPoint USBSerialNumber;
                    tDiPORouteGuidanceManeuverUpdate RGManeuverUpdate;
                    result = MediaPlayerInterface::GetInstance().GetRGManeuverUpdate(deviceID,RGManeuverUpdate);
                    if (0 == result)
                    {
                        int res = MediaPlayerInterface::GetInstance().DiPOGetUSBSerialNumber(IN deviceID,OUT USBSerialNumber);
                        mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus oFiDataObjectStatus;
                        if(!res)
                        {
                            oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
                        }
                        oFiDataObjectStatus.u16RouteGuidanceDisplayComponentID = RGManeuverUpdate.RouteGuidanceDisplayComponentID;
                        oFiDataObjectStatus.u16Index = RGManeuverUpdate.Index;
                        oFiDataObjectStatus.szManeuverDescription.bSet(RGManeuverUpdate.ManeuverDescription,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoManeuverTypeToAppControl(oFiDataObjectStatus.e8ManeuverType,RGManeuverUpdate.ManeuverType);
                        oFiDataObjectStatus.szAfterManeuverRoadName.bSet(RGManeuverUpdate.AfterManeuverRoadName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.u32DistanceBetweenManeuver = RGManeuverUpdate.DistanceBetweenManeuver;
                        oFiDataObjectStatus.szDistanceBetweenManeuverDisplayStr.bSet(RGManeuverUpdate.DistanceBetweenManeuverDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.e8DistanceBetweenManeuverDisplayUnits,RGManeuverUpdate.DistanceBetweenManeuverDisplayUnits);
                        ConvertDiPoDrivingSideToAppControl(oFiDataObjectStatus.e8DrivingSide,RGManeuverUpdate.DrivingSide);
                        ConvertDiPoJunctionTypeToAppControl(oFiDataObjectStatus.e8JunctionType,RGManeuverUpdate.JunctionType);
                        oFiDataObjectStatus.s16JunctionElementAngle = RGManeuverUpdate.JunctionElementAngle;
                        oFiDataObjectStatus.s16JunctionElementExitAngle = RGManeuverUpdate.JunctionElementExitAngle;
                        bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
                    }
                    break;
                 }
#else
        case MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE2:
                {
                    ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE2"));
                    tDeviceID deviceID;
                    tMountPoint USBSerialNumber;
                    tDiPORouteGuidanceUpdate RGUpdate;
                    result = MediaPlayerInterface::GetInstance().PullRGUpdate(deviceID,RGUpdate);
                    if (0 == result)
                    {
                        int res = MediaPlayerInterface::GetInstance().DiPOGetUSBSerialNumber(IN deviceID,OUT USBSerialNumber);

                        mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status oFiDataObjectStatus;
                        if(!res)
                        {
                            oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
                        }

                        size_t size = RGUpdate.RouteGuidanceDisplayComponentIDs.size();
                        for(int i=0; i<size; ++i)
                        {
                            oFiDataObjectStatus.RouteGuidanceUpdate.RouteGuidanceDisplayComponentIDs.Items.push_back(RGUpdate.RouteGuidanceDisplayComponentIDs[i]);
                        }
                        ConvertDiPORouteGuidanceStateToAppControl(oFiDataObjectStatus.RouteGuidanceUpdate.e8RouteGuidanceState,RGUpdate.RouteGuidanceState);
                        ConvertDiPOManeuverStateManeuverStateToAppControl(oFiDataObjectStatus.RouteGuidanceUpdate.e8ManeuverState,RGUpdate.ManeuverState);
                        oFiDataObjectStatus.RouteGuidanceUpdate.CurrentRoadName.bSet(RGUpdate.CurrentRoadName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.RouteGuidanceUpdate.DestinationName.bSet(RGUpdate.DestinationName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.RouteGuidanceUpdate.EstimatedTimeOfArrival = RGUpdate.EstimatedTimeOfArrival;
                        oFiDataObjectStatus.RouteGuidanceUpdate.TimeRemainingToDestination = RGUpdate.TimeRemainingToDestination;
                        oFiDataObjectStatus.RouteGuidanceUpdate.DistanceRemaining = RGUpdate.DistanceRemaining;
                        oFiDataObjectStatus.RouteGuidanceUpdate.DistanceRemainingDisplayStr.bSet(RGUpdate.DistanceRemainingDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.RouteGuidanceUpdate.e8DistanceRemainingDisplayUnits,RGUpdate.DistanceRemainingDisplayUnits);
                        oFiDataObjectStatus.RouteGuidanceUpdate.DistanceToNextManeuver = RGUpdate.DistanceToNextManeuver;
                        oFiDataObjectStatus.RouteGuidanceUpdate.DistanceToNextManeuverDisplayStr.bSet(RGUpdate.DistanceToNextManeuverDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.RouteGuidanceUpdate.e8DistanceToNextManeuverDisplayUnits,RGUpdate.DistanceToNextManeuverDisplayUnits);
                        ConvertManeuverListToAppControl(oFiDataObjectStatus.RouteGuidanceUpdate.RouteGuidanceManeuverCurrentList,RGUpdate.RouteGuidanceManeuverCurrentList);
                        oFiDataObjectStatus. RouteGuidanceUpdate.RouteGuidanceManeuverCount = RGUpdate.RouteGuidanceManeuverCount;
                        oFiDataObjectStatus.RouteGuidanceUpdate.RouteGuidanceVisibleInApp = RGUpdate.RouteGuidanceVisibleInApp;
                        oFiDataObjectStatus.RouteGuidanceUpdate.SourceName.bSet(RGUpdate.SourceName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.RouteGuidanceUpdate.SourceSupportsRouteGuidance = RGUpdate.SourceSupportsRouteGuidance;

                        oFiDataObjectStatus.RouteGuidanceUpdate.bRouteGuidanceDisplayComponentIDsAvailable = RGUpdate.RouteGuidanceDisplayComponentIDsAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bRouteGuidanceStateAvailable = RGUpdate.RouteGuidanceStateAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bManeuverStateAvailable = RGUpdate.ManeuverStateAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bCurrentRoadNameAvailable = RGUpdate.CurrentRoadNameAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDestinationNameAvailable = RGUpdate.DestinationNameAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bEstimatedTimeOfArrivalAvailable = RGUpdate.EstimatedTimeOfArrivalAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bTimeRemainingToDestinationAvailable = RGUpdate.TimeRemainingToDestinationAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceRemainingAvailable = RGUpdate.DistanceRemainingAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceRemainingDisplayStrAvailable = RGUpdate.DistanceRemainingDisplayStrAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceRemainingDisplayUnitsAvailable = RGUpdate.DistanceRemainingDisplayUnitsAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceToNextManeuverAvailable = RGUpdate.DistanceToNextManeuverAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceToNextManeuverDisplayStrAvailable = RGUpdate.DistanceToNextManeuverDisplayStrAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bDistanceToNextManeuverDisplayUnitsAvailable = RGUpdate.DistanceToNextManeuverDisplayUnitsAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bRouteGuidanceManeuverCurrentListAvailable = RGUpdate.RouteGuidanceManeuverCurrentListAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bRouteGuidanceManeuverCountAvailable = RGUpdate.RouteGuidanceManeuverCountAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bRouteGuidanceVisibleInAppAvailable = RGUpdate.RouteGuidanceVisibleInAppAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bSourceNameAvailable = RGUpdate.SourceNameAvailable;
                        oFiDataObjectStatus.RouteGuidanceUpdate.bSourceSupportsRouteGuidanceAvailable = RGUpdate.SourceSupportsRouteGuidanceAvailable;
                        bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
                    }
                    break;
                 }
        case MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER2:
                 {
                    ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER2"));
                    tDeviceID deviceID;
                    tMountPoint USBSerialNumber;
                    tDiPORouteGuidanceManeuverUpdate RGManeuverUpdate;
                    result = MediaPlayerInterface::GetInstance().PullRGManeuverUpdate(deviceID,RGManeuverUpdate);
                    if (0 == result)
                    {
                        int res = MediaPlayerInterface::GetInstance().DiPOGetUSBSerialNumber(IN deviceID,OUT USBSerialNumber);
                        mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status oFiDataObjectStatus;
                        if(!res)
                        {
                            oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
                        }

                        size_t size = RGManeuverUpdate.RouteGuidanceDisplayComponentIDs.size();
                        for(int i=0; i<size; ++i){
                            oFiDataObjectStatus.RouteGuidanceManeuverUpdate.RouteGuidanceDisplayComponentIDs.Items.push_back(RGManeuverUpdate.RouteGuidanceDisplayComponentIDs[i]);
                        }
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.Index = RGManeuverUpdate.Index;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.ManeuverDescription.bSet(RGManeuverUpdate.ManeuverDescription,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoManeuverTypeToAppControl(oFiDataObjectStatus.RouteGuidanceManeuverUpdate.e8ManeuverType,RGManeuverUpdate.ManeuverType);
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.AfterManeuverRoadName.bSet(RGManeuverUpdate.AfterManeuverRoadName,mplay_fi_tclString::FI_EN_UTF8);
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.DistanceBetweenManeuver = RGManeuverUpdate.DistanceBetweenManeuver;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.DistanceBetweenManeuverDisplayStr.bSet(RGManeuverUpdate.DistanceBetweenManeuverDisplayStr,mplay_fi_tclString::FI_EN_UTF8);
                        ConvertDiPoDistanceDisplayUnitsToAppControl(oFiDataObjectStatus.RouteGuidanceManeuverUpdate.e8DistanceBetweenManeuverDisplayUnits,RGManeuverUpdate.DistanceBetweenManeuverDisplayUnits);
                        ConvertDiPoDrivingSideToAppControl(oFiDataObjectStatus.RouteGuidanceManeuverUpdate.e8DrivingSide,RGManeuverUpdate.DrivingSide);
                        ConvertDiPoJunctionTypeToAppControl(oFiDataObjectStatus.RouteGuidanceManeuverUpdate.e8JunctionType,RGManeuverUpdate.JunctionType);
                        for(int j=0; j<RGManeuverUpdate.JunctionElementAngle.size(); ++j){
                            oFiDataObjectStatus.RouteGuidanceManeuverUpdate.JunctionElementAngle.Items.push_back(RGManeuverUpdate.JunctionElementAngle[j]);
                        }
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.JunctionElementExitAngle = RGManeuverUpdate.JunctionElementExitAngle;

                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bRouteGuidanceDisplayComponentIDsAvailable = RGManeuverUpdate.RouteGuidanceDisplayComponentIDsAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bIndexAvailable = RGManeuverUpdate.IndexAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bManeuverDescriptionAvailable = RGManeuverUpdate.ManeuverDescriptionAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bManeuverTypeAvailable = RGManeuverUpdate.ManeuverTypeAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bAfterManeuverRoadNameAvailable = RGManeuverUpdate.AfterManeuverRoadNameAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverAvailable = RGManeuverUpdate.DistanceBetweenManeuverAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverDisplayStrAvailable = RGManeuverUpdate.DistanceBetweenManeuverDisplayStrAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverDisplayUnitsAvailable = RGManeuverUpdate.DistanceBetweenManeuverDisplayUnitsAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bDrivingSideAvailable = RGManeuverUpdate.DrivingSideAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bJunctionTypeAvailable = RGManeuverUpdate.JunctionTypeAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bJunctionElementAngleAvailable = RGManeuverUpdate.JunctionElementAngleAvailable;
                        oFiDataObjectStatus.RouteGuidanceManeuverUpdate.bJunctionElementExitAngleAvailable = RGManeuverUpdate.JunctionElementExitAngleAvailable;

                        bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
                    }
                    break;
                 }
#endif
        case MPLAY_APPCONTROLFI_C_U16_DIPOGPRMCDATASTATUSVALUES:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPOGPRMCDATASTATUSVALUES"));
            tDeviceID deviceID;
            tMountPoint USBSerialNumber;
            tDiPOGPRMCDataStatusValues GPRMCDataStatusValues;
            result = MediaPlayerInterface::GetInstance().GetDiPOGPRMCDataStatusValues(deviceID,USBSerialNumber,GPRMCDataStatusValues);

            if (0 == result)
            {
                mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus oFiDataObjectStatus;

                oFiDataObjectStatus.u8DeviceId = deviceID;
                oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);

                if (1==GPRMCDataStatusValues.GPRMCDataStatusValueA)
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueA(TRUE);
                else
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueA(FALSE);
                if (1==GPRMCDataStatusValues.GPRMCDataStatusValueV)
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueV(TRUE);
                else
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueV(FALSE);
                if (1==GPRMCDataStatusValues.GPRMCDataStatusValueX)
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueX(TRUE);
                else
                    oFiDataObjectStatus.b8GPRMCDataStatusValues.vSetGPRMCDataStatusValueX(FALSE);

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_APPCONTROLFI_C_U16_DIPODEVICETIMEUPDATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_APPCONTROLFI_C_U16_DIPODEVICETIMEUPDATE"));
            tDeviceID deviceID = DEVICE_ID_NOT_SET;
            tMountPoint USBSerialNumber = {};
            tDiPODeviceTime deviceTime;
            InitDiPODeviceTime(deviceTime);
            result = MediaPlayerInterface::GetInstance().GetDiPODeviceTime(deviceID, deviceTime);
            if (MP_NO_ERROR == result)
            {
                mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus oFiDataObjectStatus;
                result = MediaPlayerInterface::GetInstance().DiPOGetUSBSerialNumber(IN deviceID, OUT USBSerialNumber);
                if(MP_NO_ERROR == result)
                {
                    oFiDataObjectStatus.sDeviceUSBSerialNumber.bSet(USBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
                    oFiDataObjectStatus.DeviceTimeUpdate.u64SecondsSinceReferenceDate = deviceTime.u64SecondsSinceReferenceDate;
                    oFiDataObjectStatus.DeviceTimeUpdate.s16TimeZoneOffsetMinutes = deviceTime.s16TimeZoneOffsetMinutes;
                    oFiDataObjectStatus.DeviceTimeUpdate.s8DaylightSavingsOffsetMinutes = deviceTime.s8DaylightSavingsOffsetMinutes;
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
        }
        break;
        default:
        {
            bSuccess = false;
            break;
        }
    }
    if (false == bSuccess)
    {
        ETG_TRACE_ERR(("bStatusMessageFactory: Creation of message with 'FID = %u' failed.", u16FunctionId));
    }
    return bSuccess;
}

/******************************************************************************/
/*                                                                            */
/* bProcessSet                                                                */
/*                                                                            */
/******************************************************************************/
tBool fc_mediaplayer_tclService_AppControl::bProcessSet(amt_tclServiceData* /*poMessage*/, tBool& bPropertyChanged, tU16& /*u16Error*/)
{
    ENTRY
    bPropertyChanged = false;
    return true;
}



/******************************************************************************/
/*                                                                            */
/* Internal post functions                                                    */
/*                                                                            */
/******************************************************************************/

tVoid fc_mediaplayer_tclService_AppControl::vPostResult(mplay_appcontrolfi_tclMsgBaseMessage &rBaseMessage, amt_tclServiceData &rServiceMethodStart) //finished: 100%
{
    // Create FI VisitorMessage.
    fi_tclVisitorMessage oVisitorMsgOutput(rBaseMessage, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION);

    // Init Method result message
    vInitServiceData(
            oVisitorMsgOutput,
            rServiceMethodStart.u16GetSourceAppID(),
            rServiceMethodStart.u16GetRegisterID(),
            rServiceMethodStart.u16GetCmdCounter(),
            rServiceMethodStart.u16GetFunctionID(),
            AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

    // Post the message
    ail_tenCommunicationError ailResult =  _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult )
    {
        // fatal error, because a server can post in all use cases
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }

    // Destroy the (Message related) FI data object (output)
    rBaseMessage.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::vPostError(amt_tclServiceData &rServiceMethodStart,  tU16 u16ErrorCode) //finished: 100%
{
    // create error message and set error value
    amt_tclServiceDataError oError(rServiceMethodStart, u16ErrorCode);
    ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oError, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult)
    {
        // fatal error, because a server can post in all use cases
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }

}


void fc_mediaplayer_tclService_AppControl::ConvertDeviceInfoToAppControl(mplay_fi_tcl_DiPODeviceInfoItem &appControlDeviceInfo ,const tDeviceInfo &deviceInfo) //finished: 100%
{
    ENTRY_INTERNAL
    ConvertDeviceTagToAppControl(appControlDeviceInfo.u8DeviceTag, deviceInfo.deviceID);
    appControlDeviceInfo.sDeviceName.bSet(deviceInfo.deviceName, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceTypeToAppControl(appControlDeviceInfo.e8DeviceType,deviceInfo.deviceType);
    appControlDeviceInfo.sDeviceSerialNumber.bSet(deviceInfo.serialNumber, mplay_fi_tclString::FI_EN_UTF8);
    appControlDeviceInfo.bDeviceConnected = deviceInfo.connected;
    appControlDeviceInfo.bDeviceActiveSource = deviceInfo.activeSource;
    appControlDeviceInfo.bDiPOCapable = IsDiPOCapability_CarPlay(deviceInfo.diPOCaps); //deprecated, use enum diPOCaps
    appControlDeviceInfo.bDiPOActive = deviceInfo.diPOActive; //deprecated
    appControlDeviceInfo.sDiPOVersion.bSet(deviceInfo.diPOVersion, mplay_fi_tclString::FI_EN_UTF8);
    ConvertConnectionTypeToAppControl(appControlDeviceInfo.e8ConnectionType,deviceInfo.connectionType);
    appControlDeviceInfo.sMountPoint.bSet(deviceInfo.mountPoint, mplay_fi_tclString::FI_EN_UTF8);
    appControlDeviceInfo.sAccessoryName.bSet(deviceInfo.accessoryName, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDiPOCapsToAppControl(appControlDeviceInfo.e8DiPOCaps, deviceInfo.diPOCaps);
    ConvertDeviceStateToAppControl(appControlDeviceInfo.e8DeviceState, deviceInfo.deviceState);
    appControlDeviceInfo.sDeviceUUID.bSet(deviceInfo.deviceUUID, mplay_fi_tclString::FI_EN_UTF8);
    if(DCT_USB == deviceInfo.connectionType)
    {
    appControlDeviceInfo.sDeviceUSBSerialNumber.bSet(deviceInfo.mountPoint,mplay_fi_tclString::FI_EN_UTF8);
    }
    else
    {
        appControlDeviceInfo.sDeviceUSBSerialNumber.bSet(deviceInfo.appleDeviceUSBSerialNumber,mplay_fi_tclString::FI_EN_UTF8);
    }
    appControlDeviceInfo.sDeviceBTMacAddress.bSet(deviceInfo.appleDeviceMACAddress, mplay_fi_tclString::FI_EN_UTF8);
    ConvertConnectionStateToAppControl(appControlDeviceInfo.e8ConnectionState,deviceInfo.connectionState);
}

void fc_mediaplayer_tclService_AppControl::ConvertDeviceTagToAppControl(tU8 &deviceTag, const tDeviceID deviceID) //finished: 100%
{
    ENTRY_INTERNAL
    if (deviceID > 255)
        deviceTag = 0;
    deviceTag = deviceID;
}


void fc_mediaplayer_tclService_AppControl::ConvertDeviceTypeToAppControl(mplay_fi_tcl_e8_DiPODeviceType &appControlDeviceType, const tDeviceType deviceType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(deviceType)
    {
    case DTY_UNKNOWN:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_UNKNOWN;
        break;
    case DTY_USB:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_USB;
        break;
    case DTY_IPOD:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPOD;
        break;
    case DTY_SD:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_SD;
        break;
    case DTY_BLUETOOTH:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_BLUETOOTH;
        break;
    case DTY_IPHONE:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPHONE;
        break;
    case DTY_MTP:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_MTP;
        break;
    case DTY_MSZUNE:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_UNKNOWN;
        break;
    case DTY_CDROM:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_CDROM;
        break;
    case DTY_FLASH:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_FLASH;
        break;
    case DTY_CDDA: //TODO: Add new DTY_CDDA to FI und use it here instead of DTY_CDROM
        //appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_CDDA;
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_CDROM;
        break;
    case DTY_UNSUPPORTED:
    case DTY_MYMEDIA:
    case DTY_CS:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_UNSUPPORTED;
        break;
    default:
        appControlDeviceType.enType = mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_UNKNOWN;
        VARTRACE(deviceType);
        ETG_TRACE_ERR(("Invalid device type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOResponseToAppControl(mplay_fi_tcl_e8_DiPOResponse &diPOResponseAppControl, const tDiPOResponse diPOResponse) //finished: 100%
{
    ENTRY_INTERNAL
    switch(diPOResponse)
    {
    case DIPO_OK:
        diPOResponseAppControl.enType = mplay_fi_tcl_e8_DiPOResponse::FI_EN_E8DIPO_OK;
        break;
    case DIPO_ERROR_UNKNOWN:
        diPOResponseAppControl.enType = mplay_fi_tcl_e8_DiPOResponse::FI_EN_E8DIPO_ERROR_UNKNOWN;
        break;
    case DIPO_ERROR_INVALIDHANLDE:
        diPOResponseAppControl.enType = mplay_fi_tcl_e8_DiPOResponse::FI_EN_E8DIPO_ERROR_INVALIDHANLDE;
        break;
    case DIPO_ERROR_NOTSUPPORTED:
        diPOResponseAppControl.enType = mplay_fi_tcl_e8_DiPOResponse::FI_EN_E8DIPO_ERROR_NOTSUPPORTED;
        break;
    default:
        diPOResponseAppControl.enType = mplay_fi_tcl_e8_DiPOResponse::FI_EN_E8DIPO_OK;
        VARTRACE(diPOResponse);
        ETG_TRACE_ERR(("Invalid DiPOResponse type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPORoleStatusToInternal(tDiPORoleStatus &diPORoleStatusInternal, const mplay_fi_tcl_e8_DiPORoleStatus diPORoleStatus) //finished: 100%
{
    ENTRY_INTERNAL
    switch(diPORoleStatus.enType)
    {
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_CLIENTMODE:
        diPORoleStatusInternal = DIPO_CLIENT_MODE;
        break;
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_HOSTMODE: //deprecated
        diPORoleStatusInternal = DIPO_CARPLAY_MODE;
        break;
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_CARPLAY_MODE:
        diPORoleStatusInternal = DIPO_CARPLAY_MODE;
        break;
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_NATIVE_TRANSPORT_MODE:
        diPORoleStatusInternal = DIPO_NATIVE_TRANSPORT_MODE;
        break;
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_CARPLAY_NATIVE_TRANSPORT_MODE:
        diPORoleStatusInternal = DIPO_CARPLAY_NATIVE_TRANSPORT_MODE;
        break;
    case mplay_fi_tcl_e8_DiPORoleStatus::FI_EN_E8DIPO_CARLIFE_NATIVE_TRANSPORT_MODE:
        diPORoleStatusInternal = DIPO_CARLIFE_NATIVE_TRANSPORT_MODE;
        break;
    default:
        diPORoleStatusInternal = DIPO_CLIENT_MODE;
        ETG_TRACE_ERR(("Invalid DiPORoleStatus type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertConnectionTypeToAppControl(mplay_fi_tcl_e8_DiPOConnectionType &appControlConnectionType, const tConnectionType connectionType)
{
    ENTRY_INTERNAL
    switch(connectionType)
    {
    case DCT_UNKNOWN:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_UNKNOWN;
        break;
    case DCT_USB:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_USB;
        break;
    case DCT_BLUETOOTH:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_BLUETOOTH;
        break;
    case DCT_CDROM:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_CDROM;
        break;
    case DCT_FLASH:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_FLASH;
        break;
    case DCT_WIFI:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_WIFI;
        break;
    default:
        appControlConnectionType.enType = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_UNKNOWN;
        VARTRACE(connectionType);
        ETG_TRACE_ERR(("Invalid connection type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertConnectionStateToAppControl(mplay_fi_tcl_e8_DiPOConnectionState &appControlConnectionState, const tConnectionState connectionState)
{
    ENTRY_INTERNAL
    switch(connectionState)
    {
        case CS_CONNECTED:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_CONNECTED;
            break;
        case CS_ATTACHED:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_ATTACHED;
            break;
        case CS_DISCONNECTED:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_DISCONNECTED;
            break;
        case CS_HW_MALFUNCTION:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_HW_MALFUNCTION;
            break;
        case CS_UNDERVOLTAGE:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_UNDERVOLTAGE;
            break;
        case CS_UNSUPPORTED:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_UNSUPPORTED;
            break;
        case CS_OVERTEMP:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_OVERTEMP;
            break;
        case CS_ON_HOLD:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_ON_HOLD;
            break;
        default:
            appControlConnectionState.enType = mplay_fi_tcl_e8_DiPOConnectionState::FI_EN_E8CS_UNDEFINED;
            VARTRACE(connectionState);
            ETG_TRACE_ERR(("Invalid connection State"));
            break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertAppLaunchOptionToInternal(tAppLaunchOption &appLaunchOptionInternal, const mplay_fi_tcl_e8_AppLaunchOption appLaunchOption) //finished: 100%
{
    ENTRY_INTERNAL
    switch(appLaunchOption.enType)
    {
    case mplay_fi_tcl_e8_AppLaunchOption::FI_EN_E8LAUNCH_WITH_USER_ALERT:
        appLaunchOptionInternal = ALO_LAUNCH_WITH_USER_ALERT;
        break;
    case mplay_fi_tcl_e8_AppLaunchOption::FI_EN_E8LAUNCH_WITHOUT_USER_ALERT:
        appLaunchOptionInternal = ALO_LAUNCH_WITHOUT_USER_ALERT;
        break;
    default:
        appLaunchOptionInternal = ALO_LAUNCH_WITH_USER_ALERT;
        ETG_TRACE_ERR(("Invalid AppLaunchOption type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCapsToAppControl(mplay_fi_tcl_e8_DiPOCaps &diPOCapsAppControl, const tDiPOCaps diPOCaps)
{
    ENTRY_INTERNAL
    switch(diPOCaps)
    {
    case DIPO_CAP_NONE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_NONE;
        break;
    case DIPO_CAP_CARPLAY:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY;
        break;
    case DIPO_CAP_NATIVE_TRANSPORT:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_NATIVE_TRANSPORT;
        break;
    case DIPO_CAP_CARPLAY_NATIVE_TRANSPORT:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY_NATIVE_TRANSPORT;
        break;
    case DIPO_CAP_HOSTMODE_FEASIBLE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_HOSTMODE_FEASIBLE;
        break;
    case DIPO_CAP_CARPLAY_FEASIBLE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY_FEASIBLE;
        break;
    case DIPO_CAP_CARPLAY_WIFI_FEASIBLE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY_WIFI_FEASIBLE;
        break;
    case DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE;
        break;
    case DIPO_CAP_CARPLAY_WIFI:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARPLAY_WIFI;
        break;
    case DIPO_CAP_IAP2BT:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_IAP2BT;
        break;
    case DIPO_CAP_CARLIFE:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_CARLIFE;
        break;
    default:
        diPOCapsAppControl.enType = mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_NONE;
        VARTRACE(diPOCaps);
        ETG_TRACE_ERR(("Invalid DiPOCaps type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertPlaybackActionToInternal(tPlaybackAction &internalPlaybackAction, const mplay_fi_tcl_e8_DiPOPlaypackAction playbackAction)
{
    ENTRY_INTERNAL
    switch(playbackAction.enType)
    {
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_PLAY:
        internalPlaybackAction = PBA_PLAY;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_PAUSE:
        internalPlaybackAction = PBA_PAUSE;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_STOP:
        internalPlaybackAction = PBA_STOP;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_PREV:
        internalPlaybackAction = PBA_PREV;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_NEXT:
        internalPlaybackAction = PBA_NEXT;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_FREV_START:
        internalPlaybackAction = PBA_FREV_START;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_FREV_STOP:
        internalPlaybackAction = PBA_FREV_STOP;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_FFWD_START:
        internalPlaybackAction = PBA_FFWD_START;
        break;
    case mplay_fi_tcl_e8_DiPOPlaypackAction::FI_EN_E8DIPO_PBA_FFWD_STOP:
        internalPlaybackAction = PBA_FFWD_STOP;
        break;
    default:
        internalPlaybackAction = PBA_PLAY;
        ETG_TRACE_ERR(("Invalid play action type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertPlaybackStateToAppControl(mplay_fi_tcl_e8_DiPOPlaybackStatus &playbackstateAppControl, const tHMIPlaybackState playbackState)
{
    ENTRY_INTERNAL
    switch (playbackState)
    {
    case HMI_PBS_PLAYING:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_PLAYING;
        break;
    case HMI_PBS_PAUSED:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_PAUSED;
        break;
    case HMI_PBS_STOPPED:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_STOPPED;
        break;
    case HMI_PBS_FFWD:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_SEEKFORWARD;
        break;
    case HMI_PBS_FREV:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_SEEKBACKWARD;
        break;
    default:
        playbackstateAppControl.enType = mplay_fi_tcl_e8_DiPOPlaybackStatus::FI_EN_E8DIPO_PBS_STOPPED;
        ETG_TRACE_ERR(("Invalid playback state type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertPlaybackModeToAppControl(mplay_fi_tcl_e8_DiPOPlaybackShuffleMode &appControlPlaybackMode, const tPlaybackMode playbackMode)
{
    ENTRY_INTERNAL
    switch (playbackMode)
    {
    case PBM_NORMAL:
        appControlPlaybackMode.enType = mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::FI_EN_E8DIPO_PBSM_OFF;
        break;
    case PBM_RANDOM:
        appControlPlaybackMode.enType = mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::FI_EN_E8DIPO_PBSM_SONGS;
        break;
    default:
        appControlPlaybackMode.enType = mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::FI_EN_E8DIPO_PBSM_OFF;
        ETG_TRACE_ERR(("Invalid playback mode type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertRepeatModeToAppControl(mplay_fi_tcl_e8_DiPOPlaybackRepeatMode &appControlRepeatMode, const tRepeatMode repeatMode)
{
    ENTRY_INTERNAL
    switch (repeatMode)
    {
    case RPT_NONE:
        appControlRepeatMode.enType = mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::FI_EN_E8DIPO_PBRM_OFF;
        break;
    case RPT_ONE:
        appControlRepeatMode.enType = mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::FI_EN_E8DIPO_PBRM_ONE;
        break;
    case RPT_ALL:
    case RPT_LIST:
    case RPT_LIST_WITH_SUBLISTS:
        appControlRepeatMode.enType = mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::FI_EN_E8DIPO_PBRM_ALL;
        break;
    default:
        appControlRepeatMode.enType = mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::FI_EN_E8DIPO_PBRM_OFF;
        ETG_TRACE_ERR(("Invalid repeat mode type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCallStatusToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateStatus &eStatus, const tDiPOCallStatus status)
{
    ENTRY_INTERNAL
    switch (status)
    {
    case DIPO_CALL_STATUS_DISCONNECTED:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_DISCONNECTED;
        break;
    case DIPO_CALL_STATUS_SENDING:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_SENDING;
        break;
    case DIPO_CALL_STATUS_RINGING:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_RINGING;
        break;
    case DIPO_CALL_STATUS_CONNECTING:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_CONNECTING;
        break;
    case DIPO_CALL_STATUS_ACTIVE:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_ACTIVE;
        break;
    case DIPO_CALL_STATUS_HELD:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_HELD;
        break;
    case DIPO_CALL_STATUS_DISCONNECTING:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_DISCONNECTING;
        break;
    default:
        eStatus.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::FI_EN_E8DIPO_CSUS_DISCONNECTED;
        ETG_TRACE_ERR(("Invalid status type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCallDirectionToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateDirection &eDirection, const tDiPOCallDirection direction)
{
    ENTRY_INTERNAL
    switch (direction)
    {
    case DIPO_CALL_DIRECTION_UNKNOWN:
        eDirection.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::FI_EN_E8DIPO_CSUD_UNKNOWN;
        break;
    case DIPO_CALL_DIRECTION_INCOMING:
        eDirection.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::FI_EN_E8DIPO_CSUD_INCOMING;
        break;
    case DIPO_CALL_DIRECTION_OUTGOING:
        eDirection.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::FI_EN_E8DIPO_CSUD_OUTGOING;
        break;
    default:
        eDirection.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::FI_EN_E8DIPO_CSUD_UNKNOWN;
        ETG_TRACE_ERR(("Invalid direction type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCallServiceToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateService &eService, const tDiPOCallService service)
{
    ENTRY_INTERNAL
    switch (service)
    {
    case DIPO_CALL_SERVICE_UNKNOWN:
        eService.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateService::FI_EN_E8DIPO_CSEV_UNKNOWN;
        break;
    case DIPO_CALL_SERVICE_TELEPHONY:
        eService.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateService::FI_EN_E8DIPO_CSEV_TELEPHONY;
        break;
    case DIPO_CALL_SERVICE_FACETIMEAUDIO:
        eService.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateService::FI_EN_E8DIPO_CSEV_FACETIMEAUDIO;
        break;
    case DIPO_CALL_SERVICE_FACETIMEVIDEO:
        eService.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateService::FI_EN_E8DIPO_CSEV_FACETIMEVIDEO;
        break;
    default:
        eService.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateService::FI_EN_E8DIPO_CSEV_UNKNOWN;
        ETG_TRACE_ERR(("Invalid service type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCallDisconnectReasonToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason &eDisconnectReason, const tDiPOCallDisconnectReason disconnectReason)
{
    ENTRY_INTERNAL
    switch (disconnectReason)
    {
    case DIPO_CALL_DISCONNECT_REASON_ENDED:
        eDisconnectReason.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::FI_EN_E8DIPO_CSDR_ENDED;
        break;
    case DIPO_CALL_DISCONNECT_REASON_DECLINED:
        eDisconnectReason.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::FI_EN_E8DIPO_CSDR_DECLINED;
        break;
    case DIPO_CALL_DISCONNECT_REASON_FAILED:
        eDisconnectReason.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::FI_EN_E8DIPO_CSDR_FAILED;
        break;
    default:
        eDisconnectReason.enType = mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::FI_EN_E8DIPO_CSDR_ENDED;
        ETG_TRACE_ERR(("Invalid disconnectReason type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCommunicationsSignalStrengthToAppControl(mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength &eSignalStrength, const tDiPOCommunicationsSignalStrength signalStrength)
{
    ENTRY_INTERNAL
    switch (signalStrength)
    {
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_0BARS:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_0BARS;
        break;
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_1BAR:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_1BAR;
        break;
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_2BARS:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_2BARS;
        break;
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_3BARS:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_3BARS;
        break;
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_4BARS:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_4BARS;
        break;
    case DIPO_COMMUNICATIONS_SIGNAL_STRENGTH_5BARS:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_5BARS;
        break;
    default:
        eSignalStrength.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::FI_EN_E8DIPO_CUSS_0BARS;
        ETG_TRACE_ERR(("Invalid signalStrength type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOCommunicationsRegistrationStatusToAppControl(mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus &eRegistrationStatus, const tDiPOCommunicationsRegistrationStatus registrationStatus)
{
    ENTRY_INTERNAL
    switch (registrationStatus)
    {
    case DIPO_COMMUNICATIONS_REGISTRATION_UNKNOWN:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_UNKNONW;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_NOTREGISTERED:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_NOTREGISTERED;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_SEARCHING:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_SEARCHING;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_DENIED:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_DENIED;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_REGISTEREDHOME:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_REGISTEREDHOME;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_REGISTEREDROAMING:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_REGISTEREDROAMING;
        break;
    case DIPO_COMMUNICATIONS_REGISTRATION_EMERGENCYCALLONLY:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_EMERGENCYCALLONLY;
        break;
    default:
        eRegistrationStatus.enType = mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::FI_EN_E8DIPO_CURS_UNKNONW;
        ETG_TRACE_ERR(("Invalid registrationStatus type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDeviceStateToAppControl(mplay_fi_tcl_e8_DiPODeviceStatus &eDeviceStatus,  const tDeviceState deviceState)
{
    ENTRY_INTERNAL
    switch(deviceState)
    {
    case DS_NONE:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_NONE;
        break;
    case DS_INITIALIZING:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_INITIALIZING;
        break;
    case DS_OK:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_OK;
        break;
    case DS_UNSUPPORTED:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_UNSUPPORTED;
        break;
    case DS_UNSUPPORTED_FILESYSTEM:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_UNSUPPORTED_FILESYSTEM;
        break;
    case DS_UNSUPPORTED_PARTITION:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_UNSUPPORTED_PARTITION;
        break;
    case DS_COMMUNICATION_ERROR:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_COMMUNICATION_ERROR;
        break;
    default:
        eDeviceStatus.enType = mplay_fi_tcl_e8_DiPODeviceStatus::FI_EN_E8DS_NONE;
        ETG_TRACE_ERR(("Invalid device state type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOBatteryChargingStateToAppControl(mplay_fi_tcl_e8_BatteryChargingState &e8BatteryChargingState, const tDiPOBatteryChargingState BatteryChargingState)
{
    ENTRY_INTERNAL
    switch (BatteryChargingState)
    {
    case DIPO_BATTERY_CHARGE_STATE_DISABLED:
        e8BatteryChargingState.enType = mplay_fi_tcl_e8_BatteryChargingState::FI_EN_E8DIPO_BCS_DISABLED;
        break;
    case DIPO_BATTERY_CHARGE_STATE_CHARGING:
        e8BatteryChargingState.enType = mplay_fi_tcl_e8_BatteryChargingState::FI_EN_E8DIPO_BCS_CHARGING;
        break;
    case DIPO_BATTERY_CHARGE_STATE_CHARGED:
        e8BatteryChargingState.enType = mplay_fi_tcl_e8_BatteryChargingState::FI_EN_E8DIPO_BCS_CHARGED;
        break;
    default:
        e8BatteryChargingState.enType = mplay_fi_tcl_e8_BatteryChargingState::FI_EN_E8DIPO_BCS_DISABLED;
        ETG_TRACE_ERR(("Invalid BatteryChargingState type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOAccessoryPowerModeToAppControl(mplay_fi_tcl_e8_AccessoryPowerMode &e8AccessoryPowerMode, const tDiPOAccessoryPowerMode AccessoryPowerMode)
{
    ENTRY_INTERNAL
    switch (AccessoryPowerMode)
    {
    case DIPO_ACCESSORY_MODE_RESERVED:
        e8AccessoryPowerMode.enType = mplay_fi_tcl_e8_AccessoryPowerMode::FI_EN_E8DIPO_APM_RESERVED;
        break;
    case DIPO_ACCESSORY_MODE_LOW_POWER_MODE:
        e8AccessoryPowerMode.enType = mplay_fi_tcl_e8_AccessoryPowerMode::FI_EN_E8DIPO_APM_LOW_POWER_MODE;
        break;
    case DIPO_ACCESSORY_MODE_INTERMITTENT_HIGH_POWER_MODE:
        e8AccessoryPowerMode.enType = mplay_fi_tcl_e8_AccessoryPowerMode::FI_EN_E8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE;
        break;
    default:
        e8AccessoryPowerMode.enType = mplay_fi_tcl_e8_AccessoryPowerMode::FI_EN_E8DIPO_APM_RESERVED;
        ETG_TRACE_ERR(("Invalid AccessoryPowerMode type"));
        break;
    }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPORouteGuidanceStateToAppControl(mplay_fi_tcl_e8_RouteGuidanceState &e8RouteGuidanceState, const tDiPORouteGuidanceState RouteGuidanceState)
{
    ENTRY_INTERNAL
    switch(RouteGuidanceState){

                case DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_ARRIVED:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_LOADING:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOADING;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_LOCATING:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_REROUTING:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING;
                    break;

                case DIPO_ROUTE_GUIDANCE_STATE_ROUTE_PROCEEDTOROUTE:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE;
                    break;

                default:
                    e8RouteGuidanceState.enType = mplay_fi_tcl_e8_RouteGuidanceState::FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET;
                    ETG_TRACE_ERR(("Invalid RouteGuidanceState type"));
                    break;
            }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPOManeuverStateManeuverStateToAppControl(mplay_fi_tcl_e8_ManeuverState &e8ManeuverState, const tDiPOManeuverState ManeuverState)
{
    ENTRY_INTERNAL
     switch(ManeuverState){

                case DIPO_MANEUVER_STATE_CONTINUE:
                    e8ManeuverState.enType = mplay_fi_tcl_e8_ManeuverState::FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE;
                    break;

                case DIPO_MANEUVER_STATE_INITIAL:
                    e8ManeuverState.enType = mplay_fi_tcl_e8_ManeuverState::FI_EN_E8DIPO_MANEUVER_STATE_INITIAL;
                    break;

                case DIPO_MANEUVER_STATE_PREPARE:
                    e8ManeuverState.enType = mplay_fi_tcl_e8_ManeuverState::FI_EN_E8DIPO_MANEUVER_STATE_PREPARE;
                    break;

                case DIPO_MANEUVER_STATE_EXECUTE:
                    e8ManeuverState.enType = mplay_fi_tcl_e8_ManeuverState::FI_EN_E8DIPO_MANEUVER_STATE_EXECUTE;
                    break;

                default:
                    ETG_TRACE_ERR(("Invalid ManeuverState type"));
                    break;
            }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPoDistanceDisplayUnitsToAppControl(mplay_fi_tcl_e8_DistanceDisplayUnits &e8DistanceDisplayUnits, const tDiPoDistanceDisplayUnits DistanceDisplayUnits)
{
    ENTRY_INTERNAL
    switch(DistanceDisplayUnits){

                case DIPO_DISTANCE_DISPLAY_UNIT_KM:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_KM;
                    break;

                case DIPO_DISTANCE_DISPLAY_UNIT_MILES:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_MILES;
                    break;

                case DIPO_DISTANCE_DISPLAY_UNIT_M:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_M;
                    break;

                case DIPO_DISTANCE_DISPLAY_UNIT_YARDS:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_YARDS;
                    break;

                case DIPO_DISTANCE_DISPLAY_UNIT_FT:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_FT;
                    break;

                default:
                    e8DistanceDisplayUnits.enType = mplay_fi_tcl_e8_DistanceDisplayUnits::FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_KM;
                    ETG_TRACE_ERR(("Invalid DistanceDisplayUnits type"));
                    break;
            }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPoManeuverTypeToAppControl(mplay_fi_tcl_e8_ManeuverType &e8ManeuverType, const tDiPoManeuverType ManeuverType)
{
    ENTRY_INTERNAL
      switch(ManeuverType){

                case DIPO_MANEUVER_TYPE_NO_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_LEFT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_LEFT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_RIGHT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_RIGHT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD;
                    break;

                case DIPO_MANEUVER_TYPE_MAKE_U_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_CONTINUE:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_CONTINUE;
                    break;

                case DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT;
                    break;

                case DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT;
                    break;

                case DIPO_MANEUVER_TYPE_OFF_RAMP:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_OFF_RAMP;
                    break;

                case DIPO_MANEUVER_TYPE_ON_RAMP:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ON_RAMP;
                    break;

                case DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION;
                    break;

                case DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE;
                    break;

                case DIPO_MANEUVER_TYPE_ARRIVED_AT_DESTINATION:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION;
                    break;

                case DIPO_MANEUVER_TYPE_KEEP_LEFT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_LEFT;
                    break;

                case DIPO_MANEUVER_TYPE_KEEP_RIGHT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_RIGHT;
                    break;

                case DIPO_MANEUVER_TYPE_ENTER_FERRY:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_FERRY;
                    break;

                case DIPO_MANEUVER_TYPE_EXIT_FERRY:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_FERRY;
                    break;

                case DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY;
                    break;

                case DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE;
                    break;

                case DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT;
                    break;

                case DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT;
                    break;

                case DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT;
                    break;

                case DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT;
                    break;

                case DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT;
                    break;

                case DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT;
                    break;

                case DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE;
                    break;

                case DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTION:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18;
                    break;

                case DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19;
                    break;

                case DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN;
                    break;

                case DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY;
                    break;

                case DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT;
                    break;

                case DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT:
                    e8ManeuverType.enType = mplay_fi_tcl_e8_ManeuverType::FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT;
                    break;

                default:
                    ETG_TRACE_ERR(("Invalid Maneuver Type"));
                    break;
            }

}

void fc_mediaplayer_tclService_AppControl::ConvertDiPoDrivingSideToAppControl(mplay_fi_tcl_e8_DrivingSide &e8DrivingSide, const tDiPODrivingSide DrivingSide)
{
    ENTRY_INTERNAL
     switch(DrivingSide){

                case DIPO_DRIVING_SIDE_RIGHT:
                    e8DrivingSide.enType = mplay_fi_tcl_e8_DrivingSide::FI_EN_E8DIPO_DRIVING_SIDE_RIGHT;
                    break;

                case DIPO_DRIVING_SIDE_LEFT:
                    e8DrivingSide.enType = mplay_fi_tcl_e8_DrivingSide::FI_EN_E8DIPO_DRIVING_SIDE_LEFT;
                    break;

                default:
                    ETG_TRACE_ERR(("Invalid DrivingSide Type"));
                    break;
            }
}

void fc_mediaplayer_tclService_AppControl::ConvertDiPoJunctionTypeToAppControl(mplay_fi_tcl_e8_JunctionType &e8JunctionType, const tDiPoJunctionType JunctionType)
{
    ENTRY_INTERNAL
    switch(JunctionType){

                case DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION:
                    e8JunctionType.enType = mplay_fi_tcl_e8_JunctionType::FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION;
                    break;

                case DIPO_JUNCTION_TYPE_ROUNDABOUT:
                    e8JunctionType.enType = mplay_fi_tcl_e8_JunctionType::FI_EN_E8DIPO_JUNCTION_TYPE_ROUNDABOUT;
                    break;

                default:
                    ETG_TRACE_ERR(("Invalid JunctionType Type"));
                    break;
            }
}

void fc_mediaplayer_tclService_AppControl::ConvertManeuverListToAppControl(mplay_fi_tcl_RouteGuidanceManeuverCurrentList &u16RouteGuidanceManeuverCurrentList, const tManeuverList RouteGuidanceManeuverCurrentList)
{
    ENTRY_INTERNAL

    tU16 listSize = RouteGuidanceManeuverCurrentList.size();
    ETG_TRACE_USR3(("RouteGuidanceManeuverCurrentList size : %d ",listSize));

    for(tU16 i = 0; i < listSize; i++)
    {
        u16RouteGuidanceManeuverCurrentList.u16Items.push_back(RouteGuidanceManeuverCurrentList.at(i));
    }
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOStartRG(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {

        tMountPoint USBSerialNumber;
        tUInt RouteGuidanceDisplayComponentID = RGDISPLAYCOMPONENTIDS_NONE;
        tBool SourceName =  FALSE;
        tBool SourceSupportsRouteGuidance = FALSE;
        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(tMountPoint));
        VARTRACE(USBSerialNumber);
        RouteGuidanceDisplayComponentID = oFiDataObjectMethodStart.u16RouteGuidanceDisplayComponentID;
        tRouteGuidanceDisplayComponentIDList RouteGuidanceDisplayComponentIDs;
        RouteGuidanceDisplayComponentIDs.push_back(RouteGuidanceDisplayComponentID);

        SourceName = oFiDataObjectMethodStart.SourceName;
        VARTRACE(SourceName);
        SourceSupportsRouteGuidance = oFiDataObjectMethodStart.SourceSupportsRouteGuidance;
        VARTRACE(SourceSupportsRouteGuidance);

        /* MP should check for Route Guidance support" before sending RG data received from SPI to iPhone */
        if(LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled())
        {
            result = MediaPlayerInterface::GetInstance().DiPOStartRouteGuidance(IN USBSerialNumber,IN RouteGuidanceDisplayComponentIDs, SourceName, SourceSupportsRouteGuidance);
        }
        else
        {
            ETG_TRACE_USR3(("onDiPOStartRG: Route Guidance feature not enabled"));
        }

        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOStartRG2(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint USBSerialNumber;
        size_t size = oFiDataObjectMethodStart.RouteGuidanceDisplayComponentIDs.Items.size();
        tRouteGuidanceDisplayComponentIDList RouteGuidanceDisplayComponentIDs;
        tBool SourceName = FALSE;
        tBool SourceSupportsRouteGuidance = FALSE;

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(tMountPoint));
        VARTRACE(USBSerialNumber);

        for(int i = 0; i < size; ++i){

            RouteGuidanceDisplayComponentIDs.push_back(oFiDataObjectMethodStart.RouteGuidanceDisplayComponentIDs.Items[i]);
            VARTRACE(RouteGuidanceDisplayComponentIDs[i]);
        }

        SourceName = oFiDataObjectMethodStart.SourceName;
        VARTRACE(SourceName);

        SourceSupportsRouteGuidance = oFiDataObjectMethodStart.SourceSupportsRouteGuidance;
        VARTRACE(SourceSupportsRouteGuidance);

        /* MP should check for Route Guidance support" before sending RG data received from SPI to iPhone */
        if(LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled())
        {
            result = MediaPlayerInterface::GetInstance().DiPOStartRouteGuidance(IN USBSerialNumber,IN RouteGuidanceDisplayComponentIDs, SourceName, SourceSupportsRouteGuidance);
        }
        else
        {
            ETG_TRACE_USR3(("onDiPOStartRG: Route Guidance feature not enabled"));
        }

        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOStopRG(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {

        tMountPoint USBSerialNumber;
        tUInt RouteGuidanceDisplayComponentID = RGDISPLAYCOMPONENTIDS_NONE;
        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(tMountPoint));
        VARTRACE(USBSerialNumber);
        RouteGuidanceDisplayComponentID = oFiDataObjectMethodStart.u16RouteGuidanceDisplayComponentID;
        tRouteGuidanceDisplayComponentIDList RouteGuidanceDisplayComponentIDs;
        RouteGuidanceDisplayComponentIDs.push_back(RouteGuidanceDisplayComponentID);
        /* MP should check for Route Guidance support" before sending RG data received from SPI to iPhone */
        if(LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled())
        {
            result = MediaPlayerInterface::GetInstance().DiPOStopRouteGuidance(IN USBSerialNumber,IN RouteGuidanceDisplayComponentIDs);
        }
        else
        {
            ETG_TRACE_USR3(("onDiPOStopRG: Route Guidance feature not enabled"));
        }

        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOStopRG2(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tMountPoint USBSerialNumber;
        //vector<mplay_appcontrolfi_tcl_RouteGuidanceDisplayComponentIDs>RGDisplayComponentIDs = oFiDataObjectMethodStart.Items;
        size_t size = oFiDataObjectMethodStart.RouteGuidanceDisplayComponentIDs.Items.size();
        tRouteGuidanceDisplayComponentIDList RouteGuidanceDisplayComponentIDs;

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.sDeviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(tMountPoint));
        VARTRACE(USBSerialNumber);

        for(int i = 0; i < size; ++i){

            RouteGuidanceDisplayComponentIDs.push_back(oFiDataObjectMethodStart.RouteGuidanceDisplayComponentIDs.Items[i]);
            VARTRACE(RouteGuidanceDisplayComponentIDs[i]);
        }

        /* MP should check for Route Guidance support" before sending RG data received from SPI to iPhone */
        if(LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled())
        {
            result = MediaPlayerInterface::GetInstance().DiPOStopRouteGuidance(IN USBSerialNumber,IN RouteGuidanceDisplayComponentIDs);
        }
        else
        {
            ETG_TRACE_USR3(("onDiPOStopRG: Route Guidance feature not enabled"));
        }

        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOSetRGDisplayComponentInfo(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;

    mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDiPORGDisplayComponentList RGDisplayComponentList;

        //vector<mplay_appcontrolfi_tcl_RouteGuidanceDisplayComponents> RGDisplayComponentItems = oFiDataObjectMethodStart.oItems;
        size_t size = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.size();

        if(size > 0){                    // not an empty update.
            ETG_TRACE_USR2(("RGDisplayComponentItems.size() : %d",size));
            for(int i = 0; i < size; ++i)  // Print relevant data
            {
                tDiPORGDisplayComponentInfo RGDisplayComponentInfo;
                InitDiPOSetRGDisplayInfo(RGDisplayComponentInfo);
                RGDisplayComponentInfo.Identifier                     = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).Identifier;
                strncpy_r(RGDisplayComponentInfo.Name, oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).Name.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(tGeneralString));
                VARTRACE(oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).Name);
                RGDisplayComponentInfo.CurrentRoadNameLength          = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).MaxCurrentRoadNameLength;
                RGDisplayComponentInfo.DestinationNameLength          = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).MaxDestinationNameLength;
                RGDisplayComponentInfo.AfterManeuverRoadNameLength    = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).MaxAfterManeuverRoadNameLength;
                RGDisplayComponentInfo.ManeuverDescriptionLength      = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).MaxManeuverDescriptionLength;
                RGDisplayComponentInfo.GuidanceManeuverCapacity       = oFiDataObjectMethodStart.RouteGuidanceDisplayComponents.oItems.at(i).MaxGuidanceManeuverCapacity;
                RGDisplayComponentList.push_back(RGDisplayComponentInfo);
            }
            VARTRACE(RGDisplayComponentList.size());
            VARTRACE(RGDisplayComponentList);
        }


        /* MP should check for Route Guidance support" before storing the DisplayComponentInfos in DB received from SPI */
        if(LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled())
        {
            result = MediaPlayerInterface::GetInstance().DiPOSetRGDisplayComponentInfo(IN RGDisplayComponentList);
        }
        else
        {
            ETG_TRACE_USR3(("onDiPOSetRGDisplayComponentInfo: Route Guidance feature not enabled"));
        }

        if (0 == result)
        {
            mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOSetCallControlsConfiguration(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;

    mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDiPOCallControlsConfiguration callControlsConfiguration;

        callControlsConfiguration.bits.isInitiateCallAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bInitiateCall();
        callControlsConfiguration.bits.isAcceptCallAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bAcceptCall();
        callControlsConfiguration.bits.isEndCallAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bEndCall();
        callControlsConfiguration.bits.isSwapCallsAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bSwapCalls();
        callControlsConfiguration.bits.isMergeCallsAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bMergeCalls();
        callControlsConfiguration.bits.isHoldStatusUpdateAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bHoldStatusUpdate();
        callControlsConfiguration.bits.isMuteStatusUpdateAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bMuteStatusUpdate();
        callControlsConfiguration.bits.isSendDTMFAvailable = oFiDataObjectMethodStart.callControlsConfiguration.bSendDTMF();

        tDiPOCallControlsConfiguration dpCallControlsConfig;
        dpCallControlsConfig = LocalSPM::GetDataProvider().GetDiPOCallControlsConfiguration();

        VARTRACE(dpCallControlsConfig.value);
        VARTRACE(callControlsConfiguration.value);

        if(dpCallControlsConfig.value != callControlsConfiguration.value)
        {
            result = LocalSPM::GetDataProvider().SetDiPOCallControlsConfiguration(callControlsConfiguration);
        }

        if (MP_NO_ERROR == result)
        {
            mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOInitiateCall(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;

    mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDiPOInitiateCall initiateCall;

        tMountPoint USBSerialNumber;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.deviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);


        ConvertInitiateCallTypeToInternal(initiateCall.type,oFiDataObjectMethodStart.type);
        ConvertInitiateCallServiceToInternal(initiateCall.service, oFiDataObjectMethodStart.service);
        strncpy_r(initiateCall.destinationID, oFiDataObjectMethodStart.destinationID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(initiateCall.destinationID));
        strncpy_r(initiateCall.addressBookID, oFiDataObjectMethodStart.addressBookID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(initiateCall.addressBookID));
        VARTRACE(initiateCall);

        result = MediaPlayerInterface::GetInstance().DiPOSendInitiateCall(IN USBSerialNumber,IN initiateCall);

        mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult oFiDataObjectMethodResult;
        if (MP_NO_ERROR == result)
        {
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOAcceptCall(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;

    mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDiPOAcceptCall acceptCall;

        tMountPoint USBSerialNumber;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.deviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);

        ConvertAcceptCallActionToInternal(acceptCall.acceptAction,oFiDataObjectMethodStart.acceptAction);

        strncpy_r(acceptCall.callUUID, oFiDataObjectMethodStart.callUUID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(acceptCall.callUUID));
        VARTRACE(acceptCall);

        result = MediaPlayerInterface::GetInstance().DiPOSendAcceptCall(IN USBSerialNumber,IN acceptCall);

        mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult oFiDataObjectMethodResult;
        if (MP_NO_ERROR == result)
        {
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_AppControl::onDiPOEndCall(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_ERROR;

    mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_APPCONTROL_FI_MAJOR_VERSION))
    {
        tDiPOEndCall endCall;
        tMountPoint USBSerialNumber;
        memset(USBSerialNumber,'\0',sizeof(USBSerialNumber));

        strncpy_r(USBSerialNumber, oFiDataObjectMethodStart.deviceUSBSerialNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(USBSerialNumber) -1);

        ConvertEndCallActionToInternal(endCall.endAction,oFiDataObjectMethodStart.endAction);

        strncpy_r(endCall.callUUID, oFiDataObjectMethodStart.callUUID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(endCall.callUUID));
        VARTRACE(endCall);

        result = MediaPlayerInterface::GetInstance().DiPOSendEndCall(IN USBSerialNumber,IN endCall);

        mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult oFiDataObjectMethodResult;
        if (MP_NO_ERROR == result)
        {
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

void fc_mediaplayer_tclService_AppControl::ConvertAppInfoToInternal(tAppInfo &appInfo, const mplay_fi_tcl_AppInfo info) //finished: 100%
{
     InitAppInfo(appInfo);
     strncpy(appInfo.AppName, info.sAppName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(appInfo.AppName) -1);
     strncpy(appInfo.ProtocolName, info.sProtocol.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(appInfo.ProtocolName) -1);
     strncpy(appInfo.BundleID, info.sBundleID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof(appInfo.BundleID) -1);
}

void fc_mediaplayer_tclService_AppControl::ConvertInitiateCallTypeToInternal(tDiPOInitiateCallType &initiateCallType, mplay_fi_tcl_e_InitiateCallType callType)
{
    switch(callType.enType)
    {
        case mplay_fi_tcl_e_InitiateCallType::FI_EN_EDESTINATION:
            initiateCallType = DIPO_INITIATECALLTYPE_DESTINATION;
            break;
        case mplay_fi_tcl_e_InitiateCallType::FI_EN_EVOICE_MAIL:
            initiateCallType = DIPO_INITIATECALLTYPE_VOICEMAIL;
            break;
        case mplay_fi_tcl_e_InitiateCallType::FI_EN_EREDIAL:
            initiateCallType = DIPO_INITIATECALLTYPE_REDIAL;
            break;
        default:
            initiateCallType = DIPO_INITIATECALLTYPE_DESTINATION;
            break;
    }

    VARTRACE(initiateCallType);
}

void fc_mediaplayer_tclService_AppControl::ConvertInitiateCallServiceToInternal(tDiPOInitiateCallSevice &initiateCallService, mplay_fi_tcl_e_InitiateCallService callService)
{
    switch(callService.enType)
    {
        case mplay_fi_tcl_e_InitiateCallService::FI_EN_ETELEPHONY:
            initiateCallService = DIPO_INITIATECALLSERVICE_TELEPHONY;
            break;
        case mplay_fi_tcl_e_InitiateCallService::FI_EN_EFACE_TIME_AUDIO:
            initiateCallService = DIPO_INITIATECALLSERVICE_FACE_TIME_AUDIO;
            break;
        case mplay_fi_tcl_e_InitiateCallService::FI_EN_EFACE_TIME_VIDEO:
            initiateCallService = DIPO_INITIATECALLSERVICE_FACE_TIME_VIDEO;
            break;
        default:
            initiateCallService = DIPO_INITIATECALLSERVICE_TELEPHONY;
            break;
    }

    VARTRACE(initiateCallService);
}

void fc_mediaplayer_tclService_AppControl::ConvertAcceptCallActionToInternal(tDiPOAcceptAction &acceptCallAction, mplay_fi_tcl_e_AcceptAction acceptAction)
{
    switch(acceptAction.enType)
    {
        case mplay_fi_tcl_e_AcceptAction::FI_EN_EACCEPT_OR_HOLD_AND_ACCEPT:
            acceptCallAction = DIPO_ACCEPTACTION_ACCEPT_OR_HOLD_AND_ACCEPT;
            break;
        case mplay_fi_tcl_e_AcceptAction::FI_EN_EEND_AND_ACCEPT:
            acceptCallAction = DIPO_ACCEPTACTION_END_AND_ACCEPT;
            break;
        default:
            acceptCallAction = DIPO_ACCEPTACTION_ACCEPT_OR_HOLD_AND_ACCEPT;
            break;
    }

    VARTRACE(acceptCallAction);
}

void fc_mediaplayer_tclService_AppControl::ConvertEndCallActionToInternal(tDiPOEndAction &endCallAction, mplay_fi_tcl_e_EndAction endAction)
{
    switch(endAction.enType)
    {
        case mplay_fi_tcl_e_EndAction::FI_EN_EEND_OR_DECLINE:
            endCallAction = DIPO_ENDACTION_END_OR_DECLINE;
            break;
        case mplay_fi_tcl_e_EndAction::FI_EN_EEND_ALL:
            endCallAction = DIPO_ENDACTION_END_ALL;
            break;
        default:
            endCallAction = DIPO_ENDACTION_END_OR_DECLINE;
            break;
    }

    VARTRACE(endCallAction);
}
