/**
 * @author Stefan Scherber
 * 
 * Implentation of CCAClientHandlerIPODAuthentication
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_IPODAUTHENTICATION
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_IpodAuth.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_IPODAUTHENTICATION
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_IpodAuth.h"
#include "FC_MediaPlayer_clienthandler_DeviceManager.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"

#include "ipodcommon.h"     //defines: IPOD_OK, IPOD_ERROR, etc.
#include "authentication.h"



/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Version defines for used service
#define IPODAUTH_SERVICE_MAJOR_VER  1
#define IPODAUTH_SERVICE_MINOR_VER  0


#define IPODAUTH_ACC_CERTIF_MAX_LEN       IPOD_AUTH_CP_MAX_CERTLENGTH   // 1920 bytes
#define IPODAUTH_CP_SIGN_MAX_LEN          IPOD_AUTH_CP_SIGN_DATA_SIZE   // 128 bytes
#define IPODAUTH_CP_CHALLENGE_MAX_LEN     20                            // 20 bytes
#define IPODAUTH_CP_IPOD_CERTIF_MAX_LEN   1024                          // 1024 bytes

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_IPodAuthentication, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding 
  // method should be called on receiving a specific message.

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclClientHandler_IPodAuthentication::
*             fc_mediaplayer_tclClientHandler_IPodAuthentication(fc_mediaplayer_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclClientHandler_IPodAuthentication::
  fc_mediaplayer_tclClientHandler_IPodAuthentication(fc_mediaplayer_tclApp* poMainAppl) //finished 100%
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_IPODAUTH,
      /* MajorVersion of used Service */ IPODAUTH_SERVICE_MAJOR_VER,
      /* MinorVersion of used Service */ IPODAUTH_SERVICE_MINOR_VER )
{
    ENTRY
	_tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL);
	_tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF);
    mpoMainAppl = poMainAppl;
}

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclClientHandler_IPodAuthentication::
*             ~fc_mediaplayer_tclClientHandler_IPodAuthentication(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclClientHandler_IPodAuthentication::
  ~fc_mediaplayer_tclClientHandler_IPodAuthentication(tVoid) //finished 100%
{
    ENTRY
}



tVoid fc_mediaplayer_tclClientHandler_IPodAuthentication::vOnServiceAvailable() // finished: 100 %
{
    ENTRY
    if (mpoMainAppl)
    {
        mpoMainAppl->GetCCAClientHandlerDeviceManager().vRegisterProperties();
    }
}

tVoid fc_mediaplayer_tclClientHandler_IPodAuthentication::vOnServiceUnavailable() // finished: 100 %
{
    ENTRY
    if (mpoMainAppl)
    {
        mpoMainAppl->GetCCAClientHandlerDeviceManager().vDeregisterProperties();
    }
}


/******************************************************************************
** FUNCTION:  tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::AuthenticationInit(tBool bInit)
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::AuthenticationInit(tBool bInit) //finished 100%
{
    ENTRY
    midw_ipodauthfi_tclMsgAuthenticationInitMethodStart  oStart; 
    oStart.bInit = bInit; //TRUE:=init FALSE:=deinit 
    midw_ipodauthfi_tclMsgAuthenticationInitMethodResult oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgAuthenticationInitMethodStart, midw_ipodauthfi_tclMsgAuthenticationInitMethodResult>(oStart, oResult);

    // Destroy the FI data object before leaving its creation scope
    oStart.vDestroy();
    oResult.vDestroy();

    ETG_TRACE_USR2(("AuthenticationInit(%d) returned %s", bInit, bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}   

/******************************************************************************
** FUNCTION:  tVoid fc_mediaplayer_tclClientHandler_IPodAuthentication::AccessoryCertificate(tU16 *CertLength, tU8 *CertData)
******************************************************************************/
tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::AccessoryCertificate(tU16 *CertLength, tU8 *CertData)//finished 100%
{
    ENTRY

    midw_ipodauthfi_tclMsgAccessoryCertificateGet   oGet; 
    midw_ipodauthfi_tclMsgAccessoryCertificateStatus oStatus;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgAccessoryCertificateGet, midw_ipodauthfi_tclMsgAccessoryCertificateStatus>(oGet, oStatus);

    if (bRetVal)
    {
        tU16 u16iPodCertLen  =  (tU16)oStatus.Certificate.ContainerDataList.size();
        // Check if the length is more than expected?
        NORMAL_M_ASSERT(IPODAUTH_ACC_CERTIF_MAX_LEN >= u16iPodCertLen);

        *CertLength = u16iPodCertLen;
        ETG_TRACE_USR4(("AccessoryCertificate() CertLength=%d", u16iPodCertLen));
        // Copy the iPod certificate to the buffer.
        for (tU16 u16Loop = 0; u16Loop < u16iPodCertLen; ++u16Loop)
        {
            CertData[u16Loop] =  oStatus.Certificate.ContainerDataList[u16Loop];
        }
    }

    // Destroy the FI data object before leaving its creation scope
    oGet.vDestroy();
    oStatus.vDestroy();

    ETG_TRACE_USR2(("AccessoryCertificate() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;
}  

/******************************************************************************
** FUNCTION:  tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::IPodCertificate(...
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::IPodCertificate(tU16 certLen, tU8 *certData)//finished 100%
{
    ENTRY

    NORMAL_M_ASSERT(IPODAUTH_CP_IPOD_CERTIF_MAX_LEN >= certLen);
    if (0 == certLen || IPODAUTH_CP_IPOD_CERTIF_MAX_LEN < certLen)
    {
        ETG_TRACE_ERR(("IPodCertificate failed: certLen=%u", certLen));
        return IPOD_CERT_LENGTH_INCORRECT;
    }
    midw_ipodauthfi_tclMsgiPodCertificateMethodStart  oStart;

    // Copy the iPod certificate to the buffer.
    for (tU16 u16Loop = 0; u16Loop < certLen; ++u16Loop)
    {
        oStart.Certificate.ContainerDataList.push_back(certData[u16Loop]);
    }
    midw_ipodauthfi_tclMsgiPodCertificateMethodResult oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgiPodCertificateMethodStart, midw_ipodauthfi_tclMsgiPodCertificateMethodResult>(oStart, oResult);

    // Destroy the FI data object before leaving its creation scope
    oStart.vDestroy();
    oResult.vDestroy();
    
    ETG_TRACE_USR2(("IPodCertificate() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}  

/******************************************************************************
** FUNCTION:  tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::GenSignature(...
******************************************************************************/
tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::GenSignature(const tU8  *ResponseBuffer, tU16 *SignatureDataLength, tU8 *SignatureData)//finished 100%
{
    ENTRY

    midw_ipodauthfi_tclMsgGenSignatureMethodStart  oStart;

    // Copy the iPod signatus to the buffer.
    for (tU16 u16Loop = 0; u16Loop < IPODAUTH_CP_CHALLENGE_MAX_LEN; ++u16Loop)
    {
        oStart.iPodChallenge.ContainerDataList.push_back(ResponseBuffer[u16Loop]);
    }

    midw_ipodauthfi_tclMsgGenSignatureMethodResult  oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgGenSignatureMethodStart, midw_ipodauthfi_tclMsgGenSignatureMethodResult>(oStart, oResult);

    if (bRetVal)
    {
        tU16 u16iPodSigLen  =  (tU16)oResult.Signature.ContainerDataList.size();
        // Check if the length is more than expected?
        NORMAL_M_ASSERT(IPODAUTH_CP_SIGN_MAX_LEN >= u16iPodSigLen);

        *SignatureDataLength = u16iPodSigLen;
        ETG_TRACE_USR4(("GenSignature() SignatureDataLength=%d", u16iPodSigLen));
        
        // Copy the iPod challengedata to the buffer.
        for (tU16 u16Loop = 0; u16Loop < u16iPodSigLen; ++u16Loop)
        {
            SignatureData[u16Loop] =  oResult.Signature.ContainerDataList[u16Loop];
        }
    }

    // Destroy the FI data object before leaving its creation scope
    oResult.vDestroy();
    oStart.vDestroy();

    ETG_TRACE_USR2(("GenSignature() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}  
/******************************************************************************
** FUNCTION:  tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::SetSignature(tU...
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::SetSignature(tU16 sigDataLen, tU8 *sigData)//finished 100%
{
    ENTRY

    NORMAL_M_ASSERT(IPODAUTH_CP_SIGN_MAX_LEN >= sigDataLen);
    if (0 == sigDataLen || IPODAUTH_CP_SIGN_MAX_LEN < sigDataLen)
    {
        ETG_TRACE_ERR(("SetSignature failed: sigDataLen=%u", sigDataLen));
        return IPOD_ERROR;
    }

    midw_ipodauthfi_tclMsgSetSignatureMethodStart  oStart;

    // Copy the iPod signatus to the buffer.
    for (tU16 u16Loop = 0; u16Loop < sigDataLen; ++u16Loop)
    {
        oStart.Signature.ContainerDataList.push_back(sigData[u16Loop]);
    }

    midw_ipodauthfi_tclMsgSetSignatureMethodResult oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgSetSignatureMethodStart, midw_ipodauthfi_tclMsgSetSignatureMethodResult>(oStart, oResult);

    // Destroy the FI data object before leaving its creation scope
    oStart.vDestroy();
    oResult.vDestroy();

    ETG_TRACE_USR2(("SetSignature() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}   

/******************************************************************************
** FUNCTION: tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::GetChallenge(...
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::GetChallenge(tU16 *ChallengeDataLength, tU8 *ChallengeData)//finished 100%
{
    ENTRY

    midw_ipodauthfi_tclMsgGetChallengeMethodStart   oStart; 
    midw_ipodauthfi_tclMsgGetChallengeMethodResult  oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgGetChallengeMethodStart, midw_ipodauthfi_tclMsgGetChallengeMethodResult>(oStart, oResult);

    if (bRetVal)
    {
        tU16 u16iPodChalLen  =  (tU16)oResult.CPChallenge.ContainerDataList.size();
        // Check if the length is more than expected?
        NORMAL_M_ASSERT(IPODAUTH_CP_CHALLENGE_MAX_LEN >= u16iPodChalLen);

        *ChallengeDataLength = u16iPodChalLen;
        ETG_TRACE_USR4(("GetChallenge() ChallengeDataLength=%d", u16iPodChalLen));
        
        // Copy the iPod challengedata to the buffer.
        for (tU16 u16Loop = 0; u16Loop < u16iPodChalLen; ++u16Loop)
        {
            ChallengeData[u16Loop] =  oResult.CPChallenge.ContainerDataList[u16Loop];
        }
    }

    // Destroy the FI data object before leaving its creation scope
    oResult.vDestroy();
    oStart.vDestroy();

    ETG_TRACE_USR2(("GetChallenge() returned %s", bRetVal?"TRUE":"FALSE"));

    return bRetVal ? IPOD_OK : IPOD_ERROR;

}   

/******************************************************************************
** FUNCTION: tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::DeviceID (tU32...
******************************************************************************/
tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::DeviceID (tU32 *DeviceID)//finished 100%
{
    ENTRY
    midw_ipodauthfi_tclMsgDeviceIDGet    oGet; 
    midw_ipodauthfi_tclMsgDeviceIDStatus oStatus;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgDeviceIDGet, midw_ipodauthfi_tclMsgDeviceIDStatus>(oGet, oStatus);

    if (bRetVal)
    {
        *DeviceID = oStatus.u32DeviceID;
    }

    // Destroy the FI data object before leaving its creation scope
    oStatus.vDestroy();
    oGet.vDestroy();

    ETG_TRACE_USR2(("DeviceID() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}   

/******************************************************************************
** FUNCTION: tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::FirmwareVersion(...
******************************************************************************/
tS32 fc_mediaplayer_tclClientHandler_IPodAuthentication::FirmwareVersion (tU8 *majorVer, tU8 *minorVer)//finished 100%
{
    ENTRY
    midw_ipodauthfi_tclMsgFirmwareVersionGet    oGet; 
    midw_ipodauthfi_tclMsgFirmwareVersionStatus oStatus;
    
    tBool bRetVal   =   
        bSentMsg<midw_ipodauthfi_tclMsgFirmwareVersionGet, midw_ipodauthfi_tclMsgFirmwareVersionStatus>(oGet, oStatus);

    if (bRetVal)
    {
        *majorVer = oStatus.u8MajorVersion;
        *minorVer = oStatus.u8MinorVersion;
    }

    // Destroy the FI data object before leaving its creation scope
    oStatus.vDestroy();
    oGet.vDestroy();

    ETG_TRACE_USR2(("FirmwareVersion() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

} 

/******************************************************************************
** FUNCTION: tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::AuthenticationProtocolVersion(...
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::AuthenticationProtocolVersion (tU8 *majorVer, tU8 *minorVer)//finished 100%
{
    ENTRY
    midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet    oGet; 
    midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus oStatus;
    
    tBool bRetVal   =   
        bSentMsg<midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet, midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus>(oGet, oStatus);

    if (bRetVal)
    {
        *majorVer = oStatus.u8MajorVersion;
        *minorVer = oStatus.u8MinorVersion;
    }

    // Destroy the FI data object before leaving its creation scope
    oStatus.vDestroy();
    oGet.vDestroy();

    ETG_TRACE_USR2(("AuthenticationProtocolVersion() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}   

/******************************************************************************
** FUNCTION: tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::IPodAuthenticationSelftest (tU8 *c...
******************************************************************************/
tS32  fc_mediaplayer_tclClientHandler_IPodAuthentication::IPodAuthenticationSelftest (tU8 * /*certificate*/, tU8 */*private_key*/, tU8 */*ram_check*/, tU8 */*checksum*/)//finished 100%
{
    ENTRY
    midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart  oStart; 
    midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult oResult;
    
    tBool bRetVal = bSentMsg<midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart, midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult>(oStart, oResult);

    if(oResult.enResult.enType != midw_fi_tcl_e16_iPodAuthSelfTestResult::FI_EN_IPODAUTHPASSED) {
        bRetVal = FALSE;
    }

    // Destroy the FI data object before leaving its creation scope
    oStart.vDestroy();
    oResult.vDestroy();

    ETG_TRACE_USR2(("IPodAuthenticationSelftest() returned %s", bRetVal?"TRUE":"FALSE"));

    // return error codes, see ipodcommon.h
    return bRetVal ? IPOD_OK : IPOD_ERROR;

}  //lint !e715


/*******************************************************************************
** FUNCTION:   tBool bSentMsg(T1 &OutMsg, T2 &InMsg)
*******************************************************************************/
template<typename T1, typename T2>
tBool fc_mediaplayer_tclClientHandler_IPodAuthentication::bSentMsg(T1 &OutMsg, T2 &InMsg)//finished 100%
{
    ENTRY_INTERNAL
    tBool bRetVal   =   FALSE;
    
    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg(OutMsg, IPODAUTH_SERVICE_MAJOR_VER);

    static tU32 CmdCounter = 0;
    // Message related header information 
    vInitServiceData (oMsg,          // ServiceDataMsg
        CmdCounter++,                // CmdCounter
        OutMsg.u16GetFunctionID(),   // Function ID
        OutMsg.u8GetOpCode());       // Opcode

    amt_tclServiceData *poMessage	=	&oMsg;

    tBool bDel	=	FALSE;
    
    // Post the message
    ail_tenCommunicationError enError	=	_poMainAppl->enSendMessage(&poMessage, 60000, bDel);

    if(AIL_EN_N_NO_ERROR == enError)
    {
        // result extract here. Check for opcode != ERROR
        if(AMT_C_U8_CCAMSG_OPCODE_ERROR != poMessage->u8GetOpCode())  
        {
            // result
            fi_tclVisitorMessage oMsgResult(poMessage);

            if(OSAL_OK != oMsgResult.s32GetData(InMsg, IPODAUTH_SERVICE_MAJOR_VER))
            {
                // error
                ETG_TRACE_ERR(("bSentMsg - Error getting the data"));
            }
            else
            {
                // success
                bRetVal =   TRUE;
                ETG_TRACE_USR4(("bSentMsg - SUCCESS"));
            }
        }
        else
        {
            amt_tclServiceDataError oMyError(poMessage);
            ETG_TRACE_ERR(("bSentMsg - AMT_C_U8_CCAMSG_OPCODE_ERROR - ErrorCode %d", oMyError.u16GetErrorData()));
        }
        // Delete poMessage as enSendMessage is 'classic' CCA framework and not CCX.
        poMessage->bDelete();
    }
    else
    {
        ETG_TRACE_ERR(("bSentMsg - enSendMessage() failed error=%d", enError));
    }   
    
    return bRetVal;
}

