#ifndef AUTH_MSC_H
#define AUTH_MSC_H

#include "adit_typedef.h"

#ifdef __cplusplus
extern "C" {
#endif

#define IPOD_WAIT_FOR_CP_TIME_MS	10
#define T_SOMI_READY_US			50

#define AUTH_DEV_VER_SIZE		1
#define AUTH_FW_VER_SIZE		1
#define AUTH_PROT_MAJOR_VERS_SIZE	1
#define AUTH_PROT_MINOR_VERS_SIZE	1
#define AUTH_DEV_ID_SIZE		4
#define AUTH_ERROR_CODE_SIZE		1
#define AUTH_AUTH_CTL_STAT_SIZE		1
#define AUTH_SIG_DATA_LEN_SIZE		2
#define AUTH_SIG_DATA_SIZE		128
#define AUTH_CHALL_DAT_LEN_SIZE		2
#define AUTH_CHALL_DAT_SIZE		20
#define AUTH_ACC_CERT_DAT_LEN_SIZE	2
#define AUTH_ACC_CERT_DAT_PAG_SIZE	128
#define AUTH_SELF_TEST_CTL_STAT_SIZE	1
#define AUTH_IPOD_CERT_DAT_LEN_SIZE	2
#define AUTH_IPOD_CERT_DAT_PAGE_SIZE	128

#define AUTH_DEV_VER_ADDR		0x00
#define AUTH_FW_VER_ADDR		0x01
#define AUTH_PROT_MAJOR_VERS_ADDR	0x02
#define AUTH_PROT_MINOR_VERS_ADDR	0x03
#define AUTH_DEV_ID_ADDR		0x04
#define AUTH_ERROR_CODE_ADDR		0x05
#define AUTH_AUTH_CTL_STAT_ADDR		0x10
#define AUTH_SIG_DATA_LEN_ADDR		0x11
#define AUTH_SIG_DATA_ADDR		0x12
#define AUTH_CHALL_DAT_LEN_ADDR		0x20
#define AUTH_CHALL_DAT_ADDR		0x21
#define AUTH_ACC_CERT_DAT_LEN_ADDR	0x30
#define AUTH_ACC_CERT_DAT_ADDR		0x31
#define AUTH_SELF_TEST_CTL_STAT_ADDR	0x40
#define AUTH_IPOD_CERT_DAT_LEN_ADDR	0x50
#define AUTH_IPOD_CERT_DAT_ADDR		0x51

#define AUTH_MAX_IPOD_CERT_LEN	1024


IMPORT S32 AUTH_init_cp(void);
IMPORT S32 AUTH_deinit_cp(void);
IMPORT S32 AUTH_reset_cp(void);
IMPORT S32 AUTH_ready_cp(U16 *retry_cnt);
IMPORT S32 AUTH_write_cp(S32 write_addr, VP buf, U32 length);
IMPORT S32 AUTH_read_cp(S32 read_addr, VP buf, U32 length);

#ifdef __cplusplus
}
#endif

#endif
