/*!
********************************************************************************
* \file              ipodauth_tclDiagRoutineCtrlHandler.cpp
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Dignosis RoutineControl Listener
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 12.07.2011 \version 1.3 \author Ramkumar Muniraj (RBEI/ECV1)
* - GMNGA-12212 - Self test retrial mechanism
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.1 \author Ramkumar Muniraj (RBEI/ECV1)
* - Modified for Ipod Self test. 
*
* \date 12.11.2010 \version 1.0 \author TMS Plischke 
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ipodauth_tclDiagRoutineCtrlHandler.h"
#include "ipodauth_Wrapper.h"
#include "ipodauth_Trace.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IPODAUTH_SERVICE
#include "trcGenProj/Header/ipodauth_tclDiagRoutineCtrlHandler.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/
#define IPOD_SELFTEST_RETRIAL_COUNT 3 
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::u32ProcessSelfTestRequ..
******************************************************************************/

tU32 ipodauth_tclDiagRoutineCtrlHandler::u32ProcessSelfTestRequest(tContext MsgContext)
{
   ETG_TRACE_USR4(("--> Entered : u32ProcessSelfTestRequest"));
   tU8 u8Certificate =  0;
   tU8 u8PriKey      =  0;
   tU8 u8RamCheck    =  0; // Depricated w.r.t new Apple Co-processor
   tU8 u8CheckSum    =  0; // Depricated w.r.t new Apple Co-processor

   tU32 u32Return                      =     U32_DIAGLIB_RETURN_NOT_OK;
   tenRoutineCtrlResult oCtrlResult    =     EN_ROUTINE_CONTROL_NOT_OK;

   tclParameterVector oTmpVec; // create object for response

   ETG_TRACE_USR4(("---Self test started"));

	for (tU8 u8SelfTestCount = 1; u8SelfTestCount <= (tU8) IPOD_SELFTEST_RETRIAL_COUNT; u8SelfTestCount++) {
		tS32 s32Result = IPODAUTH_S32SELFTEST(&u8Certificate, &u8PriKey, &u8RamCheck, &u8CheckSum);

		if (IPOD_OK == s32Result) {
			ETG_TRACE_USR4(("---Ipod Self test passed"));
			oCtrlResult = EN_ROUTINE_CONTROL_OK; // data valid
			trParameter paramaStatus;
			paramaStatus.enType = static_cast<tenParameterType>(ROUTINEID_IPOD_SELF_RESULT_PARAM1);
			paramaStatus.u8Value = static_cast<tU8>(EN_IpodSelftestResultSUCCESFULL);
			oTmpVec.push_back(paramaStatus);
			break; // Self test is passed, come out from retry mechanism
		} // if (IPOD_OK == s32Result)
		else {
			ETG_TRACE_ERR(("!!! Ipod Self test failed"));
			oCtrlResult = EN_ROUTINE_CONTROL_NOT_OK;
			trParameter paramaError;
			paramaError.enType = static_cast<tenParameterType>(EN_PARAMETER_TYPE_U8ERROR);
			paramaError.u8ErrorValue = EN_ERROR_FATAL_INTERNAL;
			oTmpVec.push_back(paramaError);

		} // End of if-else; if (IPOD_OK == s32Result)

		if (u8SelfTestCount > 1) {
			ETG_TRACE_USR4(("---Retrying Selt test, Retrial number = %d ", u8SelfTestCount));
		}

	}
   ETG_TRACE_USR4(("---iPod Self test status: %d. Cert: %d, PriKey: %d" 
      , ETG_ENUM(IPODAUTH_SELFTESTRESULT, oCtrlResult)
      , ETG_ENUM(IPODAUTH_PRESENT, u8Certificate)
      , ETG_ENUM(IPODAUTH_PRESENT, u8PriKey)));

   // Send message back to diagnosis
   if ((OSAL_NULL != m_poDiaglibService) && (OSAL_NULL != m_poRoutineCtrlIf))
   {
      if (TRUE == m_poRoutineCtrlIf->bSendRoutineCtrlMethodResult(oCtrlResult
         , oTmpVec, MsgContext))
      {
         u32Return = U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR4(("--- bSendRoutineCtrlMethodResult successful"));

      }  // if (TRUE == m_poRoutineCtrlIf->bSendRoutineCtrlMethodResult(oC..
      else
      {
         u32Return = U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("!!! ERROR : bSendRoutineCtrlMethodResult failed"));

      }  // End of if-else; if (TRUE == m_poRoutineCtrlIf->bSendRoutineCtrlMet..

   }  // if ((OSAL_NULL != m_poDiaglibService) && (OSAL_NULL != m_poRoutineCtr..
   else
   {
      u32Return = U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("!!! ERROR: Null ptr exception"));

   }  // End of if-else; if ((m_poDiaglibService != OSAL_NULL) && (m_poRoutine..

   ETG_TRACE_USR4(("<-- Exit : u32ProcessSelfTestRequest"));
   return u32Return;

}  // tU32 ipodauth_tclDiagRoutineCtrlHandler::u32ProcessSelfTestRequest(tCont..

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler::ipodauth_tclDiagRoutineCtrl..
******************************************************************************/
ipodauth_tclDiagRoutineCtrlHandler::ipodauth_tclDiagRoutineCtrlHandler
(
   tclServiceDiaglib* const cpoDiaglibService
): m_poDiaglibService(cpoDiaglibService), m_poRoutineCtrlIf(OSAL_NULL)
{
   if(OSAL_NULL != m_poDiaglibService)
   {
      m_poRoutineCtrlIf = m_poDiaglibService->poGetRoutineCtrl(); 

      if(OSAL_NULL != m_poRoutineCtrlIf)
      {
         m_poRoutineCtrlIf->vRegisterListener(ROUTINEID_IPOD_SELF, this);
         ETG_TRACE_USR4(("--- Self Test Registration With Dialib is done"));  
      }
      else
      {
         ETG_TRACE_ERR(("!!! Self Test Registration failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! Registration failed : Diag service NULL"));
   }
}

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler::~ipodauth_tclDiagRoutineCtr..
******************************************************************************/

/*virtual*/
ipodauth_tclDiagRoutineCtrlHandler::~ipodauth_tclDiagRoutineCtrlHandler()
{
   m_poDiaglibService = OSAL_NULL;
   m_poRoutineCtrlIf  = OSAL_NULL;
}

/******************************************************************************
** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnRoutineControlSt. 
******************************************************************************/
tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnRoutineControlStart 
(
   tU32 u32RoutineId
   , tU32 /*u32Bitmask*/
   , const tclParameterVector& /*rfcoParamVector*/
   , tContext MsgContext
)
{
   ETG_TRACE_USR4(("--> Entered : vOnRoutineControlStart"));
   tU32 u32Return    =  U32_DIAGLIB_RETURN_NOT_OK;

   // Check for expected Routine ID
   if (ROUTINEID_IPOD_SELF == u32RoutineId)
   {
     u32Return = u32ProcessSelfTestRequest(MsgContext);
   }  // if (ROUTINEID_IPOD_SELF == u32RoutineId)
  
   ETG_TRACE_USR4(("<-- Exit:vOnRoutineControlStart(%x)", u32Return));

   return u32Return;

}  // tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnRoutineControlStart(tU32 u3..

////////////////////////////////////////////////////////////////////////////////
// <EOF>
