/*!
********************************************************************************
* \file              ipodauth_tclDiagLibHandler.cpp
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Diagnosis Dialib handlers.
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - DiagLib service changed from main app to Diaglib handler.
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.0 \author Ramkumar Muniraj (RBEI/ECV1)
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ipodauth_tclDiagLibHandler.h"
#include "ipodauth_tclDiagRoutineCtrlHandler.h"
#include "ipodauth_tclDiagDataIDHandler.h"
#include "ipodauth_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IPODAUTH_SERVICE
#include "trcGenProj/Header/ipodauth_tclDiagLibHandler.cpp.trc.h"
#endif 

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagLibHandler::ipodauth_tclDiagLibHandler(t..
******************************************************************************/

ipodauth_tclDiagLibHandler::ipodauth_tclDiagLibHandler
(
   ahl_tclBaseOneThreadApp* const cpoApp
): m_poDiagLibService(OSAL_NULL), m_poDiagRoutineCtrl(OSAL_NULL)
, m_poDiagDataID(OSAL_NULL)
{
   m_poDiagLibService   =  OSAL_NEW tclServiceDiaglib(cpoApp, 1);

   if (OSAL_NULL != m_poDiagLibService)
   {   
      m_poDiagRoutineCtrl = OSAL_NEW ipodauth_tclDiagRoutineCtrlHandler(m_poDiagLibService); 

      if (OSAL_NULL != m_poDiagRoutineCtrl)
      {
         ETG_TRACE_USR4(("m_poDiagRoutineCtrl object address: 0x%x", m_poDiagRoutineCtrl));
      }
      else
      {
         ETG_TRACE_FATAL(( "!!!Creation of m_poDiagRoutineCtrl service failed" ));
      }

      m_poDiagDataID =  OSAL_NEW ipodauth_tclDiagDataIDHandler(m_poDiagLibService);

      if(OSAL_NULL != m_poDiagDataID)
      {
         ETG_TRACE_USR4(("---m_poDiagDataID object address: 0x%x", m_poDiagDataID));
      }
      else
      {
         ETG_TRACE_FATAL(( "!!!Creation of m_poDiagRoutineCtrl service failed" ));

      }      
   }  // if (OSAL_NULL != m_poDiagLibService)
   else
   {  
      ETG_TRACE_USR4(("!!! Registration failed : DiagLib service is OSAL_NULL"));
   }  // End of if-else; if (OSAL_NULL != m_poDiagLibService)

}  // ipodauth_tclDiagLibHandler::ipodauth_tclDiagLibHandler(ahl_tclBaseOneThr..

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagLibHandler::~ipodauth_tclDiagLibHandler()
******************************************************************************/

/*virtual*/
ipodauth_tclDiagLibHandler::~ipodauth_tclDiagLibHandler()
{
   try
   {
      OSAL_DELETE m_poDiagDataID;
      OSAL_DELETE m_poDiagRoutineCtrl;
      OSAL_DELETE m_poDiagLibService;   
   }
   catch (...)
   {
   }

   m_poDiagDataID       =  OSAL_NULL;
   m_poDiagRoutineCtrl  =  OSAL_NULL;
   m_poDiagLibService   =  OSAL_NULL;
}  // ipodauth_tclDiagLibHandler::~ipodauth_tclDiagLibHandler()

////////////////////////////////////////////////////////////////////////////////
// <EOF>
