/*!
********************************************************************************
* \file              ipodauth_tclDiagDataIDHandler.cpp
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Dignosis Diaglib Data ID Listener
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.1 \author Ramkumar Muniraj (RBEI/ECV1)
* - Modified to get Ipod Firmware version. 
*
* \date 12.11.2010 \version 1.0 \author TMS Plischke 
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ipodauth_tclDiagDataIDHandler.h"
#include "ipodauth_Wrapper.h"
#include "ipodauth_Trace.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IPODAUTH_SERVICE
#include "trcGenProj/Header/ipodauth_tclDiagDataIDHandler.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  tU32 ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareReque..
******************************************************************************/

tU32 ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareRequest(tContext MsgContext)
{
   ETG_TRACE_USR4(("--> ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareRequest"));
   tU8 u8MinVer         =  0;
   tU8 u8FirmwareMajVer =  0 ;  

   tU32 u32Return                =  U32_DIAGLIB_RETURN_NOT_OK;
   tenDiagDataResult oDataResult =  EN_DIAGDATA_NOT_OK;
   
   tclParameterVector oTmpVec;  // create object for response

   tS32 s32Result = IPODAUTH_S32GETFIRMWAREVERSION(&u8FirmwareMajVer, &u8MinVer);

	if (IPOD_OK == s32Result) {
		oDataResult = EN_DIAGDATA_OK; // data valid
		trParameter paramaMajorVersion, paramaMinorVersion;

		paramaMajorVersion.enType = static_cast<tenParameterType>(ROUTINEID_IPOD_FIRMWARE_RESULT_PARAM1);
		paramaMajorVersion.u8Value = u8FirmwareMajVer; // Major verion
		paramaMinorVersion.enType = static_cast<tenParameterType>(ROUTINEID_IPOD_FIRMWARE_RESULT_PARAM2);
		paramaMinorVersion.u8Value = u8MinVer; // Minor verion
		oTmpVec.push_back(paramaMajorVersion);
		oTmpVec.push_back(paramaMinorVersion);

		ETG_TRACE_USR4(
				("--- IpodFirmware Ver: Major Ver = %d & Minor Ver = %d", u8FirmwareMajVer, u8MinVer));

	} // if (IPOD_OK == s32Result)
	else {
		ETG_TRACE_ERR(
				("!!! Failed to retrieve Firmware version with error: %d", s32Result));
		oDataResult = EN_DIAGDATA_NOT_OK; // Routine Control failed use u8ErrorValue
		trParameter paramaError;
		paramaError.enType = static_cast<tenParameterType>(EN_PARAMETER_TYPE_U8ERROR);
		paramaError.u8ErrorValue = EN_ERROR_FATAL_INTERNAL;
		oTmpVec.push_back(paramaError);

	} // End of if-else; if (IPOD_OK == s32Result)


   // Send message back to diagnosis
   if ((OSAL_NULL != m_poDiaglibService) && (OSAL_NULL != m_poDataIDIf))
   {  
      if (TRUE == m_poDataIDIf->bSendDiagnosisDataResult(oDataResult
         , oTmpVec, MsgContext))
      {
         u32Return = U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR4(("--- bSendDiagnosisDataResult successfull"));

      }  // if (TRUE == m_poDataIDIf->bSendDiagnosisDataResult(oDataResult
      else
      {
         u32Return = U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("!!! bSendDiagnosisDataResult failed"));

      }  // End of if-else; if (TRUE == m_poDataIDIf->bSendDiagnosisDataResul..

   }  // if ((OSAL_NULL != m_poDiaglibService) && (OSAL_NULL != m_poDataIDIf))
   else
   {
      u32Return = U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_USR4(("!!! m_poDiaglibService or m_poDataIDIf  == OSAL_NULL"));
   }  // End of if-else; if ((OSAL_NULL != m_poDiaglibService) && (OSAL_NULL !..

   ETG_TRACE_USR4(("<-- ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareRequest"));
   return u32Return;

}  // tU32 ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareRequest(tConte..

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler(di..
******************************************************************************/

ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler
(
   tclServiceDiaglib* const cpoDiaglibService
): m_poDiaglibService(cpoDiaglibService), m_poDataIDIf(OSAL_NULL)
{
   if(OSAL_NULL != m_poDiaglibService)
   {
      m_poDataIDIf   =  m_poDiaglibService->poGetDiagData(); 
      
      if (OSAL_NULL != m_poDataIDIf)
      {
         m_poDataIDIf->vRegisterListener(DATAID_IPOD_FIRMWARE, this);
         ETG_TRACE_USR4(("--- Ipod Firware Registration With Dialib is done"));  
      }
      else
      {
         ETG_TRACE_ERR(("!!! Ipod Firware Registration failed : m_poDataIDIf==OSAL_NULL"));
      }
   }else
   {
      ETG_TRACE_ERR(("!!! Ipod Firware Registration failed : m_poDiaglibService==OSAL_NULL"));
   }
}

/******************************************************************************
** FUNCTION:  ipodauth_tclDiagDataIDHandler::~ipodauth_tclDiagDataIDHandler()..
******************************************************************************/

ipodauth_tclDiagDataIDHandler::~ipodauth_tclDiagDataIDHandler()
{
   m_poDiaglibService   =  OSAL_NULL;
   m_poDataIDIf         =  OSAL_NULL;
}

/******************************************************************************
** FUNCTION:  tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataRead (..
** DESCRIPTION: Command from Diagnois for simple Read request   
******************************************************************************/

tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataRead
(
   tU32 u32DiagDataId
   , tContext MsgContext
)
{
   ETG_TRACE_USR4(("--> ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataRead"));
   tU32 u32Return    =  U32_DIAGLIB_RETURN_NOT_OK;

   // Check for expected DiagData ID
   if (DATAID_IPOD_FIRMWARE == u32DiagDataId)
   {
      u32Return = u32ProcessIpodFirmwareRequest(MsgContext);
   }

   ETG_TRACE_USR4(("<-- ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataRead(%x)",u32Return));

   return u32Return;
}

/******************************************************************************
** FUNCTION:  tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataWrite (..
******************************************************************************/

tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisDataWrite 
( 
   tU32 /*u32DiagDataId*/
   , const tclParameterVector& /*rfcoParamVector*/
   , tContext /*MsgContext*/
)
{
   ETG_TRACE_ERR(("!!! ipodauth_tclDiagDataIDHandler::vOnDiagDataWrite => ERROR : not supported"));
   return U32_DIAGLIB_RETURN_NOT_OK;
}

////////////////////////////////////////////////////////////////////////////////
// <EOF>
