/*!
*******************************************************************************
* \file              ipodauth_tcliPodAuthService.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment - Virtual Device iPod Authentication
*  - DESCRIPTION:    iPod Authentication service handler.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 13.01.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Migrated codebase to use Infotainment Helper Library (IHL).
* - Added function to send error messages to clients.
*
* \date 18.10.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IPODAUTH_TCLIPODAUTHSERVICE_H_
#define IPODAUTH_TCLIPODAUTHSERVICE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

// :INFO: 
// 1. Interface: BASE_TYPES - Definition of the basic framework parts 
// used by all FIs.
// 2. Interface: MESSAGE - Definition of an AMT class suitable but not 
// exclusively usable together with the visitor and type framework.
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE  
#include <common_fi_if.h>

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include <generic_msgs_if.h>

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#define IHL_S_IMPORT_INTERFACE_BUFFER
#include <ihl_if.h>
using namespace ihl::buffer;

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/

/*! 
 * \class ipodauth_tcliPodAuthService
 * \brief iPod Authentication service handler class.
 *
 */

class ipodauth_tcliPodAuthService : public ahl_tclBaseOneThreadService
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tcliPodAuthService::ipodauth_tcliPodAuthService(a ...
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection 
    *          Principle (DIP)
    * \param   [cpoApp]:        (->I) Pointer to the main application
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ipodauth_tcliPodAuthService(ahl_tclBaseOneThreadApp* const cpoApp);

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tcliPodAuthService::~ipodauth_tcliPodAuthS..
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ipodauth_tcliPodAuthService();
  
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/
   
   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnLoopbackService(amt_tc...
   ***************************************************************************/
   /*!
    * \brief   Loopback service for AudioCue service.
    * \param   [poMessage]:   (->I) Pointer to incoming message.
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnLoopback(tU16 u16ServiceId, amt_tclServiceData* poMessage);

   /****************************************************************************
   ** FUNCTION:    tBool ipodauth_tcliPodAuthService::bStatusMessageFactory(tU..
   ****************************************************************************/
   /*!
    * \brief   This function shall create for every supported property a status 
    *          message, which then is used by the framework to update registered
    *          clients. Typically this function is called when the service 
    *          issues a function call like eUpdateClients(..) or 
    *          eUpdateRequestingClient(..) or for framework related reasons 
    *          (e.g. our service becomes available again).
    * \param   [u16FunctionId]:  (I) Function Id
    * \param   [roOutMsg]: (O) Reference to Out message.
    * \param   [poInMsg]: (->I) Pointer to incoming message
    * \retval  [tBool] : TRUE if message factory generated a valid msg, FALSE
    *          otherwise.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    ***************************************************************************/
   tBool bStatusMessageFactory(tU16 u16FunctionId
      , amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsAuthInit(a..
   ***************************************************************************/
   /*!
    * \brief   Function to service the initialization/deinit CP method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 09.11.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsAuthInit(amt_tclServiceData* poServData);

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsSetSign(amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to service the set signature from iPod method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 06.11.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsSetSign(amt_tclServiceData* poServData);

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsGenSign(amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to service the generate signature method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 09.11.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsGenSign(amt_tclServiceData* poServData);
   
   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsGetChallenge(amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to service the get challenge method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 06.11.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsGetChallenge(amt_tclServiceData* poServData);
   
   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsiPodCertif(amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to service the iPod certificate method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 06.11.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsiPodCertif(amt_tclServiceData* poServData);

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vOnMsiPodSelfTest(amt_tc..
   ***************************************************************************/
   /*!
    * \brief   Function to service the iPod Self test method start.
    * \param   [poServData]:    (->I)   Pointer to service data.
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vOnMsiPodSelfTest(amt_tclServiceData* poServData);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tcliPodAuthService::ipodauth_tcliPodAuthService()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So 
    *          that any attempt to create without parameter will be caught by 
    *          the compiler.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tcliPodAuthService();     // No definition exists.
   
   /***************************************************************************
   ** FUNCTION:  ipodauth_tcliPodAuthService::ipodauth_tcliPodAuthService(co..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoiPodAuthServ]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tcliPodAuthService(const ipodauth_tcliPodAuthService& rfcoiPodAuthServ);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tcliPodAuthService& ipodauth_tcliPodAuthService::op..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoiPodAuthServ]: (I) Const reference to object to be copied
    * \retval  [ipodauth_tcliPodAuthService&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tcliPodAuthService& operator= (const ipodauth_tcliPodAuthService& rfcoiPodAuthServ);
   
   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /*!
   * \addtogroup tclMem
   */
   /*! @{*/

   /// Firmware Major version
   tU8 m_u8FirmwareMajVer;

   /// Authentication Protocol Major version
   tU8 m_u8AuthProMajVer;

   /// Authentication Protocol Minor version
   tU8 m_u8AuthProMinVer;

   /// Device Id
   tU32 m_u32DeviceId;

   /// Accessory Certificate Length.
   tU16 m_u16AccCertifLen;

   /// Accessory Certificate data.
   ihl_tclRawData m_oAccCertificate;

   /*! @}*/

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vSendMessage( const amt_t..
   ***************************************************************************/
   /*!
    * \brief   Generic Interface to send errors to clients.
    * \param   [rfcoServiceData]:   (->I)    Service data to be sent.
    * \param   [cu16Error]:         (I)      Error code.
    * \retval  NONE
    * \date 13.01.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vSendError(const amt_tclServiceData &rfcoServiceData
      , tCU16 cu16Error = CCA_C_U16_ERROR_INTERNAL_FAILURE);

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vSendMessage( const amt_t..
   ***************************************************************************/
   /*!
    * \brief   Generic Interface to send messages to next clients.
    * \param   [rfcoServiceData]: (->I)   Service data to be sent.
    * \param   [rfcoTypeBase]:    (->I)   Reference to the Fi object - Base 
    *          class of the Fi object.
    * \param   [u8OpCode]: Opcode, Method result by default.
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vSendMessage
   (
      const amt_tclServiceData &rfcoServiceData,
      const fi_tclTypeBase &rfcoTypeBase,
      tU8 u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT
   );
   
   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tcliPodAuthService::vPostMessage( amt_tclSe..
   ***************************************************************************/
   /*!
    * \brief   Posts the messages into the resultant message queue.
    * \param   [rfoServiceData]: (->I)   Service data to be sent.
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vPostMessage(amt_tclServiceData &rfoServiceData);

   /***************************************************************************
   * Declare Msg Map - Utilizing the Framework for message map abstraction.
   ***************************************************************************/
   
   DECLARE_MSG_MAP(ipodauth_tcliPodAuthService)

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ipodauth_tcliPodAuthService : public ahl_tclBaseOneThreadService

#endif   // #ifndef IPODAUTH_TCLIPODAUTHSERVICE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
