/*!
*******************************************************************************
* \file              ipodauth_tclRegistry.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-IPod authentication
*  - DESCRIPTION:    Registry handler.
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 14.03.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IPODAUTH_TCLREGISTRY_H_
#define IPODAUTH_TCLREGISTRY_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define REG_S_IMPORT_INTERFACE_GENERIC
#include <reg_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/*! \enum ipodauth_enRegAccess
 * Registry access type. To distinguish access type, to rw, create or remove a
 * registry entry.
 */

enum ipodauth_enRegAccess
{
   IPODAUTH_EN_RDWR     =  OSAL_EN_READWRITE,  ///< Enum value for RW access.
   IPODAUTH_EN_CREAT                           ///< Enum value for create a file.
}; // enum ihl_enFileAccess

/*! 
 * \class ipodauth_tclRegistry
 * \brief Registry handler derived from the Registry Key interface.
 * Extended implementation to automate the creation/removal/access by default 
 * implicitly.
 * 
 */

class ipodauth_tclRegistry : public reg_tclRegKey
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclRegistry::ipodauth_tclRegistry(tCString cszRegKe..)
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor
    * \param   [cszRegKey]:   (->I) Registry value (full path)
    * \param   [enAccess]:    (I)   Registry access type.
    * \retval  NONE
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclRegistry(tCString cszRegKey, ipodauth_enRegAccess enAccess = IPODAUTH_EN_CREAT);

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tclRegistry::~ipodauth_tclRegistry()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ipodauth_tclRegistry();

   /***************************************************************************
   ** FUNCTION:  tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey, tU32..
   ***************************************************************************/
   /*!
    * \brief   Add a key, value pair to the registry.
    * \param   [cszRegSubKey]:   (I)   Sub registry key name.
    * \param   [u32Value]:       (I)   Value assigned to the registry key.
    * \retval  [tBool]: TRUE if adding succeeded, FALSE otherwise.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tBool bAdd(tCString cszRegSubKey, tU32 u32Value);

   /***************************************************************************
   ** FUNCTION:  tBool ipodauth_tclRegistry::bAdd(tCString szValue, tCString..
   ***************************************************************************/
   /*!
    * \brief   Add a key, value pair to the registry.
    * \param   [cszRegSubKey]:   (I)   Sub registry key name.
    * \param   [cszValue]:       (I)   String value assigned to the registry key.
    * \retval  [tBool]: TRUE if adding succeeded, FALSE otherwise.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tBool bAdd(tCString cszRegSubKey, tCString cszValue);
   
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/
   
   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class ipodauth_tclRegistry : public reg_tclRegKey

#endif   // #ifndef IPODAUTH_TCLREGISTRY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
