/*!
********************************************************************************
* \file              ipodauth_tclMainApp.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Main VD-iPodAuth Application - based on eXtended CCA
*  - COPYRIGHT:      &copy; 2010 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 13.01.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Migrated codebase to use Infotainment Helper Library (IHL).
*
* \date 18.10.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef IPODAUTH_TCLMAINAPP_H_
#define IPODAUTH_TCLMAINAPP_H_

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#define IHL_S_IMPORT_INTERFACE_LOOPBACK
#include <ihl_if.h>
using namespace ihl::loopback;

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| forward declarations
|-----------------------------------------------------------------------------*/

class ipodauth_tcliPodAuthService;
class ipodauth_tclDiagLibHandler;

/*! 
 * \class ipodauth_tclMainApp
 * \brief VD-iPodAuth main class - derived from the extended CCA framework.
 * 
 */

class ipodauth_tclMainApp : public ahl_tclBaseOneThreadApp
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclMainApp::ipodauth_tclMainApp()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclMainApp();

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tclMainApp::~ipodauth_tclMainApp()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ipodauth_tclMainApp();

   /***************************************************************************
   ** FUNCTION:  virtual tBool uam_tclMainApp::bOnInit()
   ***************************************************************************/
   /*!
    * \brief   The interface framework calls "bOnInit()" before starting any 
    *          communication action.  As default this function always returns 
    *          TRUE. The user has to implement all his local application 
    *          initialization ( creating required threads, allocate application
    *          memory, ... ). If returns TRUE, initializing could be 
    *          successfully performed and framework will register application at
    *          the LocalPower	Management, else, the application would end itself
    * \param   NONE
    * \retval  [tBool]: TRUE, if initialization succeeds, FALSE otherwise.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tBool bOnInit();

   /***************************************************************************
   ** FUNCTION:  virtual tVoid uam_tclMainApp::vOnApplicationClose()
   ***************************************************************************/
   /*!
    * \brief   This function is called, when the application shall be 
    *          immediatley closed. Called by the framework.
    * \param   NONE
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnApplicationClose();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/
protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tclMainApp::vCleanup()
   ***************************************************************************/
   /*!
    * \brief   Resource clean up function.
    * \param   NONE
    * \retval  NONE
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vCleanup();

   /***************************************************************************
   ** FUNCTION:  tVoid ipodauth_tclMainApp::vHandleTraceCmd(const tPU8 cpu8Buffer)
   ***************************************************************************/
   /*!
    * \brief   Trace Command interface handler.
    * \param   [cpu8Buffer] (->I) Pointer to the Trace command buffer
    * \retval  NONE
    * \date 17.09.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   static tVoid vHandleTraceCmd(tU8 const* const cpu8Buffer);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclMainApp::ipodauth_tclMainApp(const ipodauth_tclM..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoiPodAuthApp]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclMainApp(const ipodauth_tclMainApp &rfcoiPodAuthApp);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclMainApp& ipodauth_tclMainApp::operator=(const i..)
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoiPodAuthApp]: (I) Const reference to object to be copied
    * \retval  [ipodauth_tclMainApp&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 18.10.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclMainApp& operator=(const ipodauth_tclMainApp &rfcoiPodAuthApp);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /*!
   * \addtogroup tclMem
   */
   /*! @{*/

   /// Pointer to iPod Authentication service handler.
   ipodauth_tcliPodAuthService* m_poiPodAuthService;
   /// Pointer to Diag Lib Interface
   ipodauth_tclDiagLibHandler* m_poiPodDiagLibHandler;
   /// Pointer to Trace Command handler.
   static ihl_tclTraceStreamable* m_poTraceStreamer; 

   /*! @}*/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ipodauth_tclMainApp : public ahl_tclBaseOneThreadApp

#endif   // #ifndef IPODAUTH_TCLMAINAPP_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
