/*!
********************************************************************************
* \file              ipodauth_Trace.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   iPod Authentication
*  - DESCRIPTION:    Trace defines
*  - COPYRIGHT:      &copy; 2010 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 01.06.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Adapted the registry path due to rearranging of "base.reg" after ProcBase 
* splitup.
*
* \date 17.03.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Added the registry paths & registry key paths.
*
* \date 01.10.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef IPODAUTH_TRACE_H_
#define IPODAUTH_TRACE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#define TR_COMP_IPODAUTH               (TR_COMP_AUDIOPLAYER + 16)

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*! 
 * \enum ipodauth_tenTraceClass
 * Trace Class Enumeration.
 */

typedef enum 
{
   TR_CLASS_IPODAUTH_APP               =  TR_COMP_IPODAUTH + 0   ///< Enum value for Main App trace
   , TR_CLASS_IPODAUTH_SERVICE         =  TR_COMP_IPODAUTH + 1    ///< Enum value for iPod Authentication Service trace
   , TR_CLASS_IPODAUTH_CMD_IF          =  TR_COMP_IPODAUTH + 2    ///< Enum value for iPod Authentication Cmd trace
} ipodauth_tenTraceClass;

/*! 
 * \enum ipodauth_tenSuccess
 * Enumeration which defines success or failure. ;-)
 */
typedef enum
{
   IPODAUTH_EN_FAILURE     =  0
   , IPODAUTH_EN_SUCCESS   =  1
} ipodauth_tenSuccess;

#ifdef TR_TTFIS_IPODAUTH
   #define IPODAUTH_TRACE_CHANNEL      TR_TTFIS_IPODAUTH
#else
   #define IPODAUTH_TRACE_CHANNEL      ((TR_tenTraceChan)73)  
#endif

/// Registry path for the Apple co processor registry values
#define IPODAUTH_CP_REG_PATH           "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS/VD_IPODAUTH/COPROCESSOR"

/// Registry kery name for the Apple co processor firmware major version.
#define IPODAUTH_CP_FIRMWARE_VER       "FIRMWARE_MAJOR_VER"

/// Registry kery name for the Apple co processor firmware minor version.
#define IPODAUTH_CP_FIRMWARE_MIN_VER   "FIRMWARE_MINOR_VER"

#endif   // #ifndef IPODAUTH_TRACE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
