/*-----------------------------------------------------------------------------*
 * ReaderKDS.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ReaderKDS.h
 *
 * \brief Implementation to open, read and close persistent configuration
 *
 * \version 05.03.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef READER_EOL_H
#define READER_EOL_H  

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ReaderEOL
 */

class ReaderEOL
{
    public:

        /*!
         * \brief Default constructor
         */
        ReaderEOL();

        /*!
         * \brief Destructor
         */
        virtual ~ReaderEOL();


        /*!
         * \brief 
         */
        tBool bReadEOL(IN tCU8 cu8Table, IN tCU16 cu16Offset, tU8 &rfu8Value); //EOL specific

    private:
         OSAL_tIODescriptor m_ioEolDesc;  ///< EOL file descriptor.
};
// class ReaderKDS

#endif // READER_EOL_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

