/**
 * @author Stefan Scherber
 *
 * Implentation of CCServiceMediaPlayer
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#include "trcGenProj/Header/FC_MediaPlayer_service_GenMediaPlayer.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_service_GenMediaPlayer.h"
#include "OutputWrapper.h"
#include "MediaPlayerInterface.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION  MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MAJORVERSION
#define FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MINOR_VERSION  MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MINORVERSION
#define FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_PATCH_VERSION  1

#include "VarTrace.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
#include "FC_MediaPlayer_AudioDbusHandlingProxy.h"
#endif

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/
BEGIN_MSG_MAP(fc_mediaplayer_tclService_MediaPlayer, ahl_tclBaseWork)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTPLAYBACKACTION,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestPlaybackAction)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SEEKTO,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSeekTo)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_PLAYITEMFROMLISTBYTAG, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onPlayItemFromListByTag)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_PLAYITEMFROMLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onPlayItemFromList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_PLAYMEDIAPLAYEROBJECT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onPlayMediaPlayerObject)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_GETMEDIAOBJECT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onGetMediaObject)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERINDEXEDLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerIndexedList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERQUICKPLAYLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerQuickPlayList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERFILELIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerFileList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERFILELISTEXT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerFileListExt)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERPLAYLISTLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerPlaylistList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERLISTSEARCHSTRING,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerListSearchString) /*Roadmap 160014 'Full text search'*/

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERINDEXEDLISTSLICE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerIndexedListSlice)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERFILELISTSLICE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerFileListSlice)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERQUICKPLAYLISTSLICE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerQuickPlayListSlice)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERPLAYLISTLISTSLICE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerPlaylistListSlice)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTLISTINFORMATION,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestListInformation)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_QUICKSEARCH,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onQuickSearch)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SEARCHKEYBOARDMEDIAPLAYERLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSearchKeyboardMediaPlayerList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_RELEASEMEDIAPLAYERLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onReleaseMediaPlayerList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_GETMEDIAOBJECTALBUMARTINFO,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onGetMediaObjectAlbumArtInfo)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_GETMEDIAOBJECTALBUMART,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onGetMediaObjectAlbumArt)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CLEARMEDIAPLAYERDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onClearMediaPlayerData)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_TRANSFERTAGSTODEVICE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onTransferTagsToDevice)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_UMOUNT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onUmount)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DIAGNOSISPLAYSONG, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDiagnosisPlaySong)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REINDEXING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onReindexing)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEINTERNALFILENAMEPLAYLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateInternalFileNamePlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_ADDFILENAMETOINTERNALPLAYLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onAddFileNameToPlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEENTRYFROMPLAYLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeleteEntryFromPlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_RENAMEINTERNALPLAYLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRenameInternalPlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEINTERNALPLAYLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeleteInternalPlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERINTERNALPLAYLISTLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerInternalPlaylistList)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERINTERNALPLAYLISTLISTSLICE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerInternalPlaylistListSlice)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_GETLISTPOSITIONOFOBJECT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onGetListPositionOfObject)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_STARTSLIDESHOW, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, onStartSlideshow)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTSLIDESHOWACTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestSlideshowAction)

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_EJECTOPTICALDISC,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onEjectOpticalDiscMethodStart) /*Roadmap 15002_CDAudio_DetectionAndDiagnosis*/

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERINDEXEDIMAGEFOLDERLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerIndexedImageFolderList) /*CMG3G-7935*/
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERINDEXEDIMAGEFOLDERLISTSLICE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaPlayerIndexedImageFolderListSlice) /*CMG3G-7935*/
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CREATEMEDIAPLAYERCDLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onCreateMediaPlayerCDList)
//for DVD
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDISCOPERATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestDiscOperation)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTVCDAUDIOCHANNEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestVCDAudioChannel)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDAUDIOCHANNEL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestDVDAudioChannel)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SENDNAVIGATIONKEY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSendNavigationKey)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SENDTOUCHCOMMAND, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSendTouchCommand)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDIRECTSEARCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestDirectSearch)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTANGLECHANGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestAngleChange)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SETMENUPLAYBACKCONTROL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSetMenuPlaybackControl)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SELECTDIRECTNUMBER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSelectDirectNumber)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTTITLESEARCH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestTitleSearch)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTSUBTITLECHANGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestSubtitleChange)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTCMSKIP, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestCMSkip)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKSPEEDSET, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onPlaybackSpeed)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestDVDTemperature)
// for DVD
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_CLEARLASTMODEPAUSE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,OnClearLastModePause) //NCG3D-25268


//>--Roadmap 16003 : 'CD Ripping With Gracenote'
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REORDERINTERNALPLAYLIST,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onReorderInternalPlaylist)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEMEDIACONTENTBYFILTERTAGS,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeleteMediaContentByFilterTags)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEMEDIACONTENTBYMEDIAOBJECTTAGS,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeleteMediaContentByMediaObjectTags)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEMEDIACONTENTBYURLS,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeleteMediaContentByMediaObjectUrls)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_EDITMETADATABYMEDIAOBJECTTAG,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onEditMetaDataByMediaObjectTag)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_EDITMETADATABYMEDIAOBJECTURL,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onEditMetaDataByMediaObjectUrl)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_STARTRIPPING,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onStartRipping)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_STOPRIPPING,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onStopRipping)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_ADDFILENAMETOINTERNALPLAYLISTBYTAGS,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onAddFilenameToInternalPlaylistByTags)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_EXTRACTGRACENOTEMETADATA,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onExtractGracenoteMetadata)
//<--Roadmap 16003 : 'CD Ripping With Gracenote'

//>--Roadmap CMG3G-10221 : 'Scene Recorder '
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SETFILEPERMISSIONBYMEDIAOBJECTTAGS,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSetFilePermissionByMediaObjectTags)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTMEDIAPLAYERFOLDERINFO,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onRequestMediaplayerFolderInfo)
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

//>--Roadmap CMG3G-11800  17001: 'Personalization'
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_STOREPERSONALIZEDFAVORITE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onStorePersonalizedFavorite)
ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_DELETEPERSONALIZEDFAVORITE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onDeletePersonalizedFavorite)
//>--Roadmap CMG3G-11800  17001: 'Personalization'

ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_SENDAPPLEHIDCOMMAND,AMT_C_U8_CCAMSG_OPCODE_METHODSTART,onSendAppleHIDCommand)


END_MSG_MAP()


/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclService_MediaPlayer::fc_mediaplayer_tclService_MediaPlayer(fc_mediaplayer_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class ahl_tclBaseOneThreadService
 *              with a pointer to this application, the service identifier,
 *              the application identifier and the service version as parameters.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclService_MediaPlayer::fc_mediaplayer_tclService_MediaPlayer(fc_mediaplayer_tclApp* poMainAppl):ahl_tclBaseOneThreadService( //finished: 100%  ahl_tclBaseOneThreadService
        /* Application Pointer              */ poMainAppl,
        /* ID of offered Service            */ CCA_C_U16_SRV_FB_MEDIAPLAYER,
        /* MajorVersion of offered Service  */ FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION,
        /* MinoreVersion of offered Service */ FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MINOR_VERSION)
{
    ENTRY
    m_poMainAppInstance = poMainAppl;

    bEjectopticalDiscCmdValid                 = FALSE;
    u16EjectopticalDiscCmdGetSourceAppID      = 0;
    u16EjectopticalDiscCmdGetRegisterID       = 0;
    u16EjectopticalDiscCmdGetCmdCounter       = 0;
    u16EjectopticalDiscCmdGetFunctionID       = 0;
    //added for Roadmap 16003
    memset((void*)&m_pAddFileNamesToPlaylistByTagUserContext,0,sizeof(tUserContext));
    memset((void*)&m_pAddFileNamesToPlaylistByUrlsUserContext,0,sizeof(tUserContext));
    memset((void*)&m_pDeleteEntryFromPlaylistUserContext,0,sizeof(tUserContext));
    #ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
    LocalSPM::GetInstance().GetIPCProvider().RegisterListener(&AudioDbusHandlingProxy::GetInstance());
    #endif
}

/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclService_MediaPlayer::~fc_mediaplayer_tclService_MediaPlayer(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclService_MediaPlayer::~fc_mediaplayer_tclService_MediaPlayer(tVoid) //finished: 100%
{
    ENTRY
}

/******************************************************************************/
/*                                                                            */
/* Play functions                                                             */
/*                                                                            */
/******************************************************************************/
tVoid fc_mediaplayer_tclService_MediaPlayer::onPlaybackSpeed(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPEPlaybackDirection playbackDirection;
        tPlaybackSpeed playbackSpeed;
        ConvertPlaybackDirectionToInternal(playbackDirection, oFiDataObjectMethodStart.e8PlaybackDirection);
        ConvertPlaybackSpeedToInternal(playbackSpeed, oFiDataObjectMethodStart.e8PlaybackSpeed);

        result = MediaPlayerInterface::GetInstance().SendPlaybackSpeed(playbackDirection, playbackSpeed);
        if (0 == result)
        {
           mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult oFiDataObjectMethodResult;
           ConvertPlaybackDirectionToMPLAY(oFiDataObjectMethodResult.e8PlaybackDirection, playbackDirection);
           ConvertPlaybackSpeedToMPLAY(oFiDataObjectMethodResult.e8PlaybackSpeed, playbackSpeed);
           vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

         }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}
tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestPlaybackAction (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPlaybackAction playbackAction;
        tNextPrevSkipCount nextPrevSkipCount;

        ConvertPlaybackActionToInternal(playbackAction, oFiDataObjectMethodStart.e8Action);
        nextPrevSkipCount = oFiDataObjectMethodStart.u8NextPrevSkipCount;
        result = MediaPlayerInterface::GetInstance().SendPlaybackAction(playbackAction,nextPrevSkipCount);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSeekTo (amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgSeekToMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPlaytime playpointPosition;
        tPlaypointFormat playpointFormat;
        playpointPosition = oFiDataObjectMethodStart.u32PlaypointPosition;
        ConvertPlaypointFormatToInternal(playpointFormat, oFiDataObjectMethodStart.e8PlaypointFormat);
        result = MediaPlayerInterface::GetInstance().SendSeekTo(playpointPosition,playpointFormat);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgSeekToMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onPlayItemFromList (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListSize listSize;
        tListID listID;
        tIndex indexMP;
        tPlaytime offset;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        indexMP = oFiDataObjectMethodStart.u32StartIndex;
        offset = oFiDataObjectMethodStart.u32StartOffset;

        result = MediaPlayerInterface::GetInstance().PlayItemFromList(listSize, listID, indexMP, offset);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onPlayItemFromListByTag (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListSize listSize;
        tListID listID;
        tObjectID objectID;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        objectID = oFiDataObjectMethodStart.u32Tag;

        result = MediaPlayerInterface::GetInstance().PlayItemFromListByTag(listSize, listID, objectID);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onPlayMediaPlayerObject (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tListSize listSize;
        tObjectID objectID;
        tPlayContinuation playContinuation;

        ConvertAutoPlayToPlayContinuation(playContinuation, oFiDataObjectMethodStart.bAutoPlay);
        objectID = oFiDataObjectMethodStart.u32Tag;
        result = MediaPlayerInterface::GetInstance().PlayMediaPlayerObject(listID,listSize,objectID,playContinuation);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

/******************************************************************************/
/*                                                                            */
/* List create function                                                       */
/*                                                                            */
/******************************************************************************/

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerQuickPlayList(amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListInfo listInfo;
        tListType listType;
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;
        tPlayContinuation playContinuation;
        tDeviceID deviceID;

        ConvertListTypeToInternal(listType, oFiDataObjectMethodStart.e8ListType);
        tag1.tag = oFiDataObjectMethodStart.u32FilterTag1;
        tag2.tag = oFiDataObjectMethodStart.u32FilterTag2;
        tag3.tag = oFiDataObjectMethodStart.u32FilterTag3;
        tag4.tag = oFiDataObjectMethodStart.u32FilterTag4;
        ConvertAutoPlayToPlayContinuation(playContinuation, oFiDataObjectMethodStart.bAutoPlay);
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        MapTagsFromGM2GenMP(IN listType, IN tag1, IN tag2, IN tag3, IN tag4);
        result = MediaPlayerInterface::GetInstance().CreateQuickPlayList(listInfo, listType, tag1, tag2, tag3, tag4, playContinuation, deviceID);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listInfo.listID;
            oFiDataObjectMethodResult.u32ListSize = listInfo.listSize;
            oFiDataObjectMethodResult.u8DeviceTag = listInfo.deviceID;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerPlaylistList (amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listId;
        tListSize listSize;
        tPath filename;

        strncpy(filename, oFiDataObjectMethodStart.sFilename.szValue, sizeof filename - 1);

        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerPlaylistList(listId, listSize, filename);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listId;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
};

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerFileList (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listId;
        tListSize listSize;
        tNumberOfMediaObjects numberOfMediaObjects;
        tNumberOfPlayLists numberOfPlayLists;
        tNumberOfFolders numberOfFolders;

        tPath path;
        tDeviceID deviceID;
        tFileTypeSelection filetypeSelection;

        strncpy(path, oFiDataObjectMethodStart.sPath.szValue, sizeof path - 1);
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        ConvertFileTypeToInternal(filetypeSelection, oFiDataObjectMethodStart.e8MPlayFileTypeSelection);

        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerFileList(listId, listSize, numberOfMediaObjects, numberOfPlayLists, numberOfFolders, path, deviceID, filetypeSelection);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult oFiDataObjectMethodResult;

            oFiDataObjectMethodResult.u32ListHandle = listId;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            oFiDataObjectMethodResult.u32TotalNumFiles = numberOfMediaObjects + numberOfPlayLists;
            oFiDataObjectMethodResult.u32TotalNumFolders = numberOfFolders;
            oFiDataObjectMethodResult.u32TotalNumMediaObjects = numberOfMediaObjects;
            oFiDataObjectMethodResult.u32TotalNumPlaylists = numberOfPlayLists;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerFileListExt (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listId;
        tListSize listSize;
        tNumberOfMediaObjects numberOfMediaObjects;
        tNumberOfPlayLists numberOfPlayLists;
        tNumberOfFolders numberOfFolders;
        tPosition position;

        tPath filename;
        tDeviceID deviceID;
        tFileTypeSelection filetypeSelection;

        strncpy(filename, oFiDataObjectMethodStart.sFilename.szValue, sizeof filename - 1);
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        ConvertFileTypeToInternal(filetypeSelection, oFiDataObjectMethodStart.e8MPlayFileTypeSelection);

        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerFileListExt(listId, listSize, numberOfMediaObjects, numberOfPlayLists, numberOfFolders, position, filename, deviceID, filetypeSelection);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult oFiDataObjectMethodResult;

            oFiDataObjectMethodResult.u32ListHandle = listId;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            oFiDataObjectMethodResult.u32TotalNumFiles = numberOfMediaObjects + numberOfPlayLists;
            oFiDataObjectMethodResult.u32TotalNumFolders = numberOfFolders;
            oFiDataObjectMethodResult.u32Position = position;
            oFiDataObjectMethodResult.u32TotalNumMediaObjects = numberOfMediaObjects;
            oFiDataObjectMethodResult.u32TotalNumPlaylists = numberOfPlayLists;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerIndexedList(amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tListSize listSize;
        tListType listType;
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;
        tDeviceID deviceID;
        tUserID userID;

        ConvertListTypeToInternal(listType, oFiDataObjectMethodStart.e8ListType);
        tag1.tag = oFiDataObjectMethodStart.u32FilterTag1;
        tag2.tag = oFiDataObjectMethodStart.u32FilterTag2;
        tag3.tag = oFiDataObjectMethodStart.u32FilterTag3;
        tag4.tag = 0;
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        userID = oFiDataObjectMethodStart.u8UserID;
        VARTRACE(userID);
        MapTagsFromGM2GenMP(IN listType, INOUT tag1, INOUT tag2, INOUT tag3, INOUT tag4);
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)
        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerIndexedList(listID, listSize, listType, tag1, tag2, tag3, tag4, deviceID, userID);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}


//Roadmap 16014 'Full text search'
tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerListSearchString(amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tListID listID,listIDParent,listIDReplaceable;
        tListSize listSize;
        tDeviceID deviceID;
        tSearchString searchString;

        //extract method parms
        listIDParent      = oFiDataObjectMethodStart.u32ListHandleOfParent;
        listIDReplaceable = oFiDataObjectMethodStart.u32ListHandleOfReplaceableList;
        snprintf(searchString,sizeof(tSearchString),"%s",oFiDataObjectMethodStart.sSearchString.szValue);

        //log parms
        VARTRACE(listIDParent)
        VARTRACE(listIDReplaceable)
        VARTRACE(searchString)

        //store visitor
        //store information necessary to send MethodReultFirst, MethodReultMiddle and MethodResultLast
        //which means call of Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle will succeed from now on
        //mapVisitorMsg.insert(std::pair<tListID,fi_tclVisitorMessage>(listIDParent,oVisitorMsg) ); - RTC-254181
        mListSearchStringSerializeLock.lock();

        result =  MediaPlayerInterface::GetInstance().CreateMediaPlayerListSearchString( OUT listID,
                OUT listSize,
                OUT deviceID,
                IN listIDParent,
                IN listIDReplaceable,
                IN searchString); //Roadmap 16014 'Full text search'
                VARTRACE(result)

        tUserContext rUserContext;
        rUserContext.sourceAppID  = poMessage->u16GetSourceAppID();
        rUserContext.registerID   = poMessage->u16GetRegisterID();
        rUserContext.cmdCounter   = poMessage->u16GetCmdCounter();
        rUserContext.functionID   = poMessage->u16GetFunctionID();

        mListSearchStringMapLock.lock();
        mapVisitorMsg.insert(std::pair<tListID,tUserContext>(listID,rUserContext) );
        mListSearchStringMapLock.unlock();
        mListSearchStringSerializeLock.unlock();
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}



//called by CCA-OutputWrapper
tVoid fc_mediaplayer_tclService_MediaPlayer::Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN tListID listIDParent, tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    mListSearchStringSerializeLock.lock();
    mListSearchStringMapLock.lock();
    std::map<tListID,tUserContext>::iterator it = mapVisitorMsg.find(listID);

    if (it != mapVisitorMsg.end())
    {
        tUserContext rUserContext;
        rUserContext.sourceAppID  = it->second.sourceAppID;
        rUserContext.registerID   = it->second.registerID;
        rUserContext.cmdCounter   = it->second.cmdCounter;
        rUserContext.functionID   = it->second.functionID;
        mListSearchStringMapLock.unlock();
        mListSearchStringSerializeLock.unlock();

        ETG_TRACE_COMP(("Send_onCreateMediaPlayerListSearchString_MethodReturnFirst: listID:%d",listID));
        mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst oFiDataObjectMethodResultFirst;
        oFiDataObjectMethodResultFirst.u32ListHandle = listID;
        oFiDataObjectMethodResultFirst.u32ListSize   = listSize;
        oFiDataObjectMethodResultFirst.u8DeviceTag   = deviceID;
        vPostResult(oFiDataObjectMethodResultFirst, rUserContext, AMT_C_U8_CCAMSG_OPCODE_METHODRESULTFIRST);
    }
    else
    {
        mListSearchStringMapLock.unlock();
        mListSearchStringSerializeLock.unlock();
        ETG_TRACE_FATAL(("[ERROR]: Send_onCreateMediaPlayerListSearchString_MethodReturnFirst: No oVisitorMsg found in map  - nothing send"));
    }
}



//called by CCA-OutputWrapper
tVoid fc_mediaplayer_tclService_MediaPlayer::Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN tListID listIDParent,tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    mListSearchStringMapLock.lock();
    std::map<tListID,tUserContext>::iterator it = mapVisitorMsg.find(listID);

    if (it != mapVisitorMsg.end())
    {
        tUserContext rUserContext;
        rUserContext.sourceAppID  = it->second.sourceAppID;
        rUserContext.registerID   = it->second.registerID;
        rUserContext.cmdCounter   = it->second.cmdCounter;
        rUserContext.functionID   = it->second.functionID;
        mListSearchStringMapLock.unlock();

        ETG_TRACE_COMP(("Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle: listID:%d",listID));
        mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle oFiDataObjectMethodResultMiddle;
        oFiDataObjectMethodResultMiddle.u32ListHandle = listID;
        oFiDataObjectMethodResultMiddle.u32ListSize   = listSize;
        oFiDataObjectMethodResultMiddle.u8DeviceTag   = deviceID;
        vPostResult(oFiDataObjectMethodResultMiddle, rUserContext, AMT_C_U8_CCAMSG_OPCODE_METHODRESULTMIDDLE);
    }
    else
    {
        mListSearchStringMapLock.unlock();
        ETG_TRACE_FATAL(("[ERROR]: Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle: No oVisitorMsg found in map  - nothing send"));
    }
}
//called ba CCA-OutputWrapper
tVoid fc_mediaplayer_tclService_MediaPlayer::Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    mListSearchStringMapLock.lock();
    std::map<tListID,tUserContext>::iterator it = mapVisitorMsg.find(listID);

    if (it != mapVisitorMsg.end())
    {
        tUserContext rUserContext;
        rUserContext.sourceAppID  = it->second.sourceAppID;
        rUserContext.registerID   = it->second.registerID;
        rUserContext.cmdCounter   = it->second.cmdCounter;
        rUserContext.functionID   = it->second.functionID;
        mListSearchStringMapLock.unlock();

        ETG_TRACE_COMP(("Send_onCreateMediaPlayerListSearchString_MethodReturnLast: listID:%d",listID));
        mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast oFiDataObjectMethodResultLast;
        oFiDataObjectMethodResultLast.u32ListHandle = listID;
        oFiDataObjectMethodResultLast.u32ListSize   = listSize;
        oFiDataObjectMethodResultLast.u8DeviceTag   = deviceID;
        vPostResult(oFiDataObjectMethodResultLast, rUserContext, AMT_C_U8_CCAMSG_OPCODE_METHODRESULTLAST);

        mListSearchStringMapLock.lock();
        mapVisitorMsg.erase(it);
        mListSearchStringMapLock.unlock();
    }
    else
    {
        mListSearchStringMapLock.unlock();
        ETG_TRACE_FATAL(("[ERROR]: Send_onCreateMediaPlayerListSearchString_MethodReturnLast: No oVisitorMsg found in map- nothing send"));
    }
}

tVoid fc_mediaplayer_tclService_MediaPlayer::Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY
    mListSearchStringMapLock.lock();
    std::map<tListID,tUserContext>::iterator it = mapVisitorMsg.find(listID);

    if (it != mapVisitorMsg.end())
    {
        tUserContext rUserContext;
        rUserContext.sourceAppID  = it->second.sourceAppID;
        rUserContext.registerID   = it->second.registerID;
        rUserContext.cmdCounter   = it->second.cmdCounter;
        rUserContext.functionID   = it->second.functionID;
        mListSearchStringMapLock.unlock();

        ETG_TRACE_COMP(("Send_onCreateMediaPlayerListSearchString_MethodReturnAbort: listID:%d",listID));
        mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort oFiDataObjectMethodResultAbort;
        oFiDataObjectMethodResultAbort.u32ListHandle = listID;
        oFiDataObjectMethodResultAbort.u32ListSize   = listSize;
        oFiDataObjectMethodResultAbort.u8DeviceTag   = deviceID;
        vPostResult(oFiDataObjectMethodResultAbort, rUserContext, AMT_C_U8_CCAMSG_OPCODE_METHODABORT);

        mListSearchStringMapLock.lock();
        mapVisitorMsg.erase(it);
        mListSearchStringMapLock.unlock();
    }
    else
    {
        mListSearchStringMapLock.unlock();
        ETG_TRACE_FATAL(("[ERROR]: Send_onCreateMediaPlayerListSearchString_MethodReturnLast: No oVisitorMsg found in map- nothing send"));
    }
}







/******************************************************************************/
/*                                                                            */
/* Request slice functions                                                    */
/*                                                                            */
/******************************************************************************/
tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerQuickPlayListSlice (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
        vector<tMediaObject> mediaObjectVector;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(mediaObjectVector, listID, startIndex, sliceSize);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult oFiDataObjectMethodResult;
            vector<tMediaObject>::iterator it;
            for(it = mediaObjectVector.begin(); it < mediaObjectVector.end(); it++)
            {
                mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
                ConvertMediaObjectsItemToMPLAY(mplayMediaObject, *it);
                oFiDataObjectMethodResult.oMediaObjects.oItems.push_back(mplayMediaObject);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerPlaylistListSlice (amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
        vector<tFiles> mediaFileVector;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerFileListSlice(mediaFileVector, listID, startIndex, sliceSize);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult oFiDataObjectMethodResult;
            vector<tFiles>::iterator it;
            for(it = mediaFileVector.begin(); it < mediaFileVector.end(); it++)
            {
                mplay_fi_tcl_MPlayFileListItem fileListItem;
                ConvertFileItemToMPLAY(fileListItem, *it);
                oFiDataObjectMethodResult.oFileList.oItems.push_back(fileListItem);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerFileListSlice (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
        vector<tFiles> mediaFileVector;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerFileListSlice(mediaFileVector, listID, startIndex, sliceSize);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult oFiDataObjectMethodResult;
            vector<tFiles>::iterator it;
            for(it = mediaFileVector.begin(); it < mediaFileVector.end(); it++)
            {
                mplay_fi_tcl_MPlayFileListItem fileListItem;
                ConvertFileItemToMPLAY(fileListItem, *it);
                oFiDataObjectMethodResult.oFileList.oItems.push_back(fileListItem);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerIndexedListSlice (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
        vector<tMediaObject> mediaObjectVector;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(mediaObjectVector, listID, startIndex, sliceSize);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult oFiDataObjectMethodResult;
            vector<tMediaObject>::iterator it;
            for(it = mediaObjectVector.begin(); it < mediaObjectVector.end(); it++)
            {
                mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
                ConvertMediaObjectsItemToMPLAY(mplayMediaObject, *it);
                oFiDataObjectMethodResult.oMediaObjects.oItems.push_back(mplayMediaObject);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

/******************************************************************************/
/*                                                                            */
/* Further functions                                                          */
/*                                                                            */
/******************************************************************************/

tVoid fc_mediaplayer_tclService_MediaPlayer::onGetMediaObject (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tMediaObject mediaObject;
        tMediaObjectID mediaObjectID;
        tCategoryType categoryType;

        mediaObjectID = oFiDataObjectMethodStart.u32Tag;
        ConvertCategoryTypeToInternal(categoryType,oFiDataObjectMethodStart.e8CategoryType);

        result = MediaPlayerInterface::GetInstance().GetMediaObject(mediaObject, mediaObjectID, categoryType);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult oFiDataObjectMethodResult;
            ConvertMediaObjectToMPLAY(oFiDataObjectMethodResult.oMediaObject, mediaObject);
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onReleaseMediaPlayerList (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        listID = oFiDataObjectMethodStart.u32ListHandle;
        //result = MediaPlayerInterface::GetInstance().ReleaseList(listID);
        result = 0;
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestListInformation (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tListType listType;
        tListID parentListID;
        tDeviceID deviceID;
        tPosition position;
        tListSize listSize;
        tPath path;

        listID = oFiDataObjectMethodStart.u32ListHandle;

        result = MediaPlayerInterface::GetInstance().RequestListInformation(listType, parentListID, deviceID, position, listSize, path, listID);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult oFiDataObjectMethodResult;
            ConvertListTypeToMPLAY(oFiDataObjectMethodResult.e8ListType, listType);
            oFiDataObjectMethodResult.u32ParentListHandle = parentListID;
            ConvertDeviceTagToMPLAY(oFiDataObjectMethodResult.u8DeviceTag, deviceID);
            oFiDataObjectMethodResult.u32Position = position;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            oFiDataObjectMethodResult.sPath.bSet(path,mplay_fi_tclString::FI_EN_UTF8);
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onQuickSearch (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgQuicksearchMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPosition outposition = 0; // CID 17567 (#1 of 1): Uninitialized scalar variable (UNINIT)
        tSearchResult quicksearchresult = ENDOFLIST; // CID 17568 (#1 of 1): Uninitialized scalar variable (UNINIT)
        tListID listID;
        tPosition startposition;
        tSearchString searchstring;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startposition = oFiDataObjectMethodStart.u32Position;
        strncpy_r(searchstring, oFiDataObjectMethodStart.sSearchChar.sText, sizeof searchstring);
        result = MediaPlayerInterface::GetInstance().Quicksearch(outposition,quicksearchresult,listID,startposition,searchstring);
        if ((0 == result))
        {
            mplay_mediaplayerfi_tclMsgQuicksearchMethodResult oFiDataObjectMethodResult;
            ConvertQuickSearchResultToMPLAY(oFiDataObjectMethodResult.oSearchResult, quicksearchresult);
            oFiDataObjectMethodResult.u32Position = outposition;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if ((0 != result))
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSearchKeyboardMediaPlayerList (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        vector<tSearchKeyboard> searchKeyboardList;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        result = MediaPlayerInterface::GetInstance().SearchKeyboardMediaPlayerList(searchKeyboardList,listID);
        if ((0 == result) || (MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED == result))
        {
            mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            vector<tSearchKeyboard>::iterator it;
            for(it = searchKeyboardList.begin(); it < searchKeyboardList.end(); it++)
            {
                mplay_fi_tcl_MPlaySearchKeyboardListItem mplayItem;
                mplayItem.sSearchKeyboardLetter.bSet(it->letter, mplay_fi_tclString::FI_EN_UTF8);
                mplayItem.bLetterAvailable = (tBool)it->available;
                mplayItem.u32LetterStartIndex = it->startIndex;
                mplayItem.u32LetterEndIndex = it->endIndex;
                oFiDataObjectMethodResult.oSearchKeyboardList.oItems.push_back(mplayItem);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if ((0 != result) && (MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED != result))
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onClearMediaPlayerData (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        result = MediaPlayerInterface::GetInstance().ClearMediaPlayerData();
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onGetMediaObjectAlbumArtInfo (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tAlbumArt albumArtString;
        tSize x;
        tSize y;
        tUserContext userContext;
        strncpy(albumArtString, oFiDataObjectMethodStart.sAlbumArt.szValue, sizeof albumArtString -1);
        if (oFiDataObjectMethodStart.u32SizeX > 0 && oFiDataObjectMethodStart.u32SizeY > 0)
        {
            x = oFiDataObjectMethodStart.u32SizeX;
            y = oFiDataObjectMethodStart.u32SizeY;
        }
        else
        {
            // use default values
            x = 160;
            y = 160;
        }
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().GetMediaObjectAlbumArtInfo(albumArtString, x, y, MMT_PNG, userContext);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onGetMediaObjectAlbumArt (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tAlbumArt albumArtString;
        tUserContext userContext;
        tSize x;
        tSize y;
        strncpy(albumArtString, oFiDataObjectMethodStart.sAlbumArt.szValue, sizeof albumArtString -1);
        if (oFiDataObjectMethodStart.u32SizeX > 0 && oFiDataObjectMethodStart.u32SizeY > 0)
        {
            x = oFiDataObjectMethodStart.u32SizeX;
            y = oFiDataObjectMethodStart.u32SizeY;
        }
        else
        {
            // use default values
            x = 160;
            y = 160;
        }
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().GetMediaObjectAlbumArt(albumArtString, x, y, MMT_PNG, userContext);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tResult fc_mediaplayer_tclService_MediaPlayer::SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tImageSize size, tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult resultMessage;
    // Set values
    switch(mimeType)
    {
        case MMT_PNG:
            resultMessage.sMIMEImageSubtype.bSet("image/png",mplay_fi_tclString::FI_EN_UTF8);
            break;
        case MMT_BMP:
            resultMessage.sMIMEImageSubtype.bSet("image/x-ms-bmp",mplay_fi_tclString::FI_EN_UTF8);
            break;
        case MMT_GIF:
            resultMessage.sMIMEImageSubtype.bSet("image/gif",mplay_fi_tclString::FI_EN_UTF8);
            break;
        case MMT_JPG:
            resultMessage.sMIMEImageSubtype.bSet("image/jpeg",mplay_fi_tclString::FI_EN_UTF8);
            break;
        default:
            resultMessage.sMIMEImageSubtype.bSet("image/png",mplay_fi_tclString::FI_EN_UTF8);
            break;
    }
    resultMessage.u32PhotoSize = size;
    // Create FI VisitorMessage.
    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_NUMBER_OF_VERSIONS);
    // Init Method result message
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    // Post message
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
        ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
        // Try to send error message
        SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onTransferTagsToDevice (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        vector<tTagTransfer> transferTags;
        tTagTransferStatus transferStatus = TAG_TRANSFER_SUCCESS; //CID 17557 (#1 of 2): Uninitialized scalar variable (UNINIT)
        vector<tUntransferredTag> untransferredTags;

        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        //bpstl::vector<mplay_fi_tcl_MPlayTagTransferItem_2>::iterator it;
        std::vector<mplay_fi_tcl_MPlayTagTransferItem_2>::iterator it;
        for(it = oFiDataObjectMethodStart.oTagTransfer.oItems.begin(); it < oFiDataObjectMethodStart.oTagTransfer.oItems.end(); it++)
        {
            tTagTransfer tagTransfer;
            InitTagTransfer(tagTransfer);
            ConvertTransferTagToInternal(tagTransfer, *it);
            transferTags.push_back(tagTransfer);
        }

        result = MediaPlayerInterface::GetInstance().TransferTags(deviceTag,transferTags,transferStatus,untransferredTags);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            ConvertTransferStatusToMPLAY(oFiDataObjectMethodResult.e8TagTransferStatus, transferStatus);
            vector<tUntransferredTag>::iterator itResult;
            for(itResult = untransferredTags.begin(); itResult < untransferredTags.end(); itResult++)
            {
                mplay_fi_tcl_MPlayUntransferredTagStreamItem item;
                ConvertUntransferredTagsToMPLAY(item, *itResult);
                oFiDataObjectMethodResult.oUntransferredTagStream.oItems.push_back(item);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onUmount (amt_tclServiceData* poMessage) //Roadmap 13003 SDCard
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgUmountMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        tErrorCode errorCode = MP_NO_ERROR;
        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        result = MediaPlayerInterface::GetInstance().Umount(errorCode, deviceTag);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgUmountMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            ConvertUmountResultToMPLAY(oFiDataObjectMethodResult.e8UmountResult, errorCode);
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onDiagnosisPlaySong (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceType deviceType = DTY_UNKNOWN;
        tFilename filename;
        ConvertDeviceTypeToInternal(deviceType, oFiDataObjectMethodStart.e8DeviceType);
        strncpy(filename, oFiDataObjectMethodStart.sFilename.szValue, sizeof filename - 1);
        result = MediaPlayerInterface::GetInstance().DiagnosisPlaySong(deviceType, filename);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onReindexing (amt_tclServiceData* poMessage) //Roadmap 13003 SDCard
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgReindexingMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        result = MediaPlayerInterface::GetInstance().Reindexing(deviceTag);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgReindexingMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateInternalFileNamePlaylist (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPlaylistName playlistName;
        tDeviceID deviceTag;
        tPath path;
        strncpy(playlistName, oFiDataObjectMethodStart.sName.szValue, sizeof playlistName - 1);
        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);

        result = MediaPlayerInterface::GetInstance().CreateInternalFileNamePlaylist(OUT path, IN deviceTag, IN playlistName);
        mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult oFiDataObjectMethodResult;
        ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,result);
        oFiDataObjectMethodResult.sPlaylistPath.bSet(path,mplay_fi_tclString::FI_EN_UTF8);
        vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onAddFileNameToPlaylist (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        tPath playlistPath;
        vector<string> playlistFilenameVector;
        vector<tPosition> playlistPositionVector;

        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);


        std::vector<tU32> oPlaylistPositionVector = oFiDataObjectMethodStart.oMPlayPlayListPosition.Position;
        std::vector<tU32>::iterator posit;

        for(posit = oPlaylistPositionVector.begin();posit< oPlaylistPositionVector.end();posit++)
            playlistPositionVector.push_back(*posit);

        std::vector<mplay_fi_tclString> omediaObjectFileNameVector = oFiDataObjectMethodStart.oMPlayMediaObjectUrls.sMediaObjectUrl;
        std::vector<mplay_fi_tclString>::iterator it;

        for(it = omediaObjectFileNameVector.begin();it< omediaObjectFileNameVector.end();it++)
            playlistFilenameVector.push_back((string)it->szValue);

        //store visitor
        //store information necessary to send MethodResult
        //which means call of Send_OnAddFileNameToPlaylistMethodResult will succeed from now on
        fillUserContext(poMessage,m_pAddFileNamesToPlaylistByUrlsUserContext);


        result = MediaPlayerInterface::GetInstance().AddFileNamesToPlaylist(IN playlistPath, IN deviceTag, IN playlistFilenameVector, IN playlistPositionVector);
        if (result)
        {
            vPostError(oVisitorMsg);

        }

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onDeleteEntryFromPlaylist (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        tPath playlistPath;



        vector<tPosition> playlistPositionVector;

        std::vector<tU32> oPlaylistPositionVector = oFiDataObjectMethodStart.oMPlayPlayListPosition.Position;
        std::vector<tU32>::iterator posit;
        for(posit = oPlaylistPositionVector.begin();posit< oPlaylistPositionVector.end();posit++)
            playlistPositionVector.push_back(*posit);
        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);

        fillUserContext(poMessage,m_pDeleteEntryFromPlaylistUserContext);

        result = MediaPlayerInterface::GetInstance().DeleteEntriesFromPlaylist(IN playlistPath, IN deviceTag, IN playlistPositionVector);
        if (0 != result)
        {
            vPostError(oVisitorMsg);
        }

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRenameInternalPlaylist (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPath playlistPath;
        tPlaylistName playlistName;
        tDeviceID deviceTag;

        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);
        strncpy(playlistName, oFiDataObjectMethodStart.sNewName.szValue, sizeof playlistName - 1);

        result = MediaPlayerInterface::GetInstance().RenameInternalPlaylist(IN deviceTag, IN playlistPath, IN playlistName);
        mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult oFiDataObjectMethodResult;
        ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,result);
        vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onDeleteInternalPlaylist (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPath playlistPath;
        tDeviceID deviceTag;

        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);

        result = MediaPlayerInterface::GetInstance().DeleteInternalPlaylist(IN deviceTag, IN playlistPath);
        mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult oFiDataObjectMethodResult;
        ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,result);
        vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerInternalPlaylistList (amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceTag;
        tListSize listSize;
        tListID listID;
        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);

        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerInternalPlaylistList(OUT listID, OUT listSize, IN deviceTag);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerInternalPlaylistListSlice (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
        vector<tMediaObject> mediaObjectVector;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(mediaObjectVector, listID, startIndex, sliceSize);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult oFiDataObjectMethodResult;
            vector<tMediaObject>::iterator it;
            for(it = mediaObjectVector.begin(); it < mediaObjectVector.end(); it++)
            {
                mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
                ConvertMediaObjectsItemToMPLAY(mplayMediaObject, *it);
                oFiDataObjectMethodResult.oMediaObjects.oItems.push_back(mplayMediaObject);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onGetListPositionOfObject(amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tObjectID objectID;
        tPosition position;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        objectID = oFiDataObjectMethodStart.u32Tag;

        result = MediaPlayerInterface::GetInstance().GetListPositionOfObject(OUT position, IN listID, IN objectID);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32Position = position;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onStartSlideshow (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tObjectID objectID;

        listID = oFiDataObjectMethodStart.u32ListHandle;
        objectID = oFiDataObjectMethodStart.u32Tag;

        result = MediaPlayerInterface::GetInstance().StartSlideshow(IN listID, IN objectID);

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}


tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestSlideshowAction (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPlaybackAction playbackAction;
        tNextPrevSkipCount nextPrevSkipCount;

        ConvertPlaybackActionToInternal(playbackAction, oFiDataObjectMethodStart.e8Action);
        nextPrevSkipCount = oFiDataObjectMethodStart.u8NextPrevSkipCount;
        result = MediaPlayerInterface::GetInstance().SendSlideshowAction(playbackAction,nextPrevSkipCount);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}





tResult fc_mediaplayer_tclService_MediaPlayer::SendError(tErrorCode errorCode, tUserContext userContext)  //finished 100%
{
    amt_tclServiceDataError oErrorMsg;
    oErrorMsg.vSetErrorData(errorCode);

    // Init error message
    vInitServiceData(oErrorMsg, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_ERROR);

    ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oErrorMsg, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult)
    {
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }
    return 0;
};



tResult fc_mediaplayer_tclService_MediaPlayer::SendGetMediaObjectAlbumArtAnswer(tImageData imageData, tImageSize imageSize, tUserContext userContext)  //finished 100%
{
    ENTRY

    mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult resultMessage;
    // Set values
    resultMessage.oImageData.u8Items.resize(imageSize);
    copy(imageData, imageData + imageSize,resultMessage.oImageData.u8Items.begin());
    // Create FI VisitorMessage.
    fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_NUMBER_OF_VERSIONS);
    // Init Method result message
    vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    // Post message
    ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult )
    {
        ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
        // Try to send error message
        SendError(0, userContext);
    }
    resultMessage.vDestroy();
    return 0;
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestDiscOperation(amt_tclServiceData* poMessage)
{
    ENTRY
    tBool bSend = FALSE;
    tResult result = -1;
    ETG_TRACE_USR3((" MethodStart :  MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDISCOPERATION"));
    mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart   oFiDataObject_Get;
    mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);


    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 Operation = (tU8)oFiDataObjectMethodStart.e8DiscOperation.enType;
        mplay_fi_tcl_e8_EjectParmType enCmdEjectParam  = (mplay_fi_tcl_e8_EjectParmType)oFiDataObject_Get.eCmdParam;
        if(  MediaPlayerInterface::GetInstance().IsDVDDrive() == true)           //for diagnosis (Kenwood or MASCA) NCG3D-82391
        {
            result = MediaPlayerInterface::GetInstance().RequestDiscOperation(Operation);
        }
        else
        {
            //for diagnosis (Kenwood or MASCA) NCG3D-82391
            tDMOpticalDiscEjectCmd emOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;

            switch(enCmdEjectParam.enType)
            {
                case mplay_fi_tcl_e8_MDiscOperation::FI_EN_E8DISC_EJECT :
                    bSend = TRUE;
                    emOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;

                    break;
                case mplay_fi_tcl_e8_MDiscOperation::FI_EN_E8DISC_LOAD:
                    bSend = TRUE;
                    emOpticalDiscEjectCmd = DM_OPTDISC_CMD_INSERT;
                    break;
                default:
                    ETG_TRACE_FATAL(("onRequestDiscOperation: Unexpected value: enCmdEjectParam: %d",(int)enCmdEjectParam.enType));
                    break;
            }

            ETG_TRACE_USR4(("onRequestDiscOperation; bEjectopticalDiscCmdValid:0x%x bSend:0x%x",bEjectopticalDiscCmdValid,bSend));
            if(bSend)
            {
                //store sender id's used in SendopticalDiscEjectMethodResult later
                bEjectopticalDiscCmdValid            = TRUE;
                u16EjectopticalDiscCmdGetSourceAppID = poMessage->u16GetSourceAppID();
                u16EjectopticalDiscCmdGetRegisterID  = poMessage->u16GetRegisterID();
                u16EjectopticalDiscCmdGetCmdCounter  = poMessage->u16GetCmdCounter();
                u16EjectopticalDiscCmdGetFunctionID  = poMessage->u16GetFunctionID();

                result = MediaPlayerInterface::GetInstance().SendEjectOpticalDisc(emOpticalDiscEjectCmd);

            }
            else
            {
                ETG_TRACE_FATAL(("onRequestDiscOperation: Ignore Message. Reason: Previous message still executing in lower layer components"));
            }
          }

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestVCDAudioChannel(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart : MPLAY_MEDIAPLAYERFI_C_U16_REQUESTVCDAUDIOCHANNEL"));
    mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 selectionType = (tU8)oFiDataObjectMethodStart.e8SelectionType.enType;
        tU8 audioMode = (tU8)oFiDataObjectMethodStart.e8AudioMode.enType;
        result = MediaPlayerInterface::GetInstance().RequestVCDAudioChannel(selectionType, audioMode);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestDVDAudioChannel(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDAUDIOCHANNEL"));
    mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 selectionType = (tU8)oFiDataObjectMethodStart.e8SelectionType.enType;
        tU8 audioNum = (tU8)oFiDataObjectMethodStart.e8AudioNumber.enType;
        result = MediaPlayerInterface::GetInstance().RequestDVDAudioChannel(selectionType, audioNum);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}


tVoid fc_mediaplayer_tclService_MediaPlayer::onSendNavigationKey(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onSendNavigationKey MPLAY_MEDIAPLAYERFI_C_U16_SENDNAVIGATIONKEY"));
    mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 action = (tU8)oFiDataObjectMethodStart.e8Action.enType;
        result = MediaPlayerInterface::GetInstance().SendNavigationKey(action);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSendTouchCommand(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onSendTouchCommand MPLAY_MEDIAPLAYERFI_C_U16_SENDTOUCHCOMMAND"));
    mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tU8 action = (tU8)oFiDataObjectMethodStart.e8TouchAction.enType;
        tU16 xCoord = oFiDataObjectMethodStart.u16Xcoordinate;
        tU16 yCoord = oFiDataObjectMethodStart.u16Xcoordinate;
        tU16 xMaxCoord = oFiDataObjectMethodStart.u16Xcoordinate;
        tU16 yMaxCoord = oFiDataObjectMethodStart.u16Xcoordinate;

        result = MediaPlayerInterface::GetInstance().SendTouchCommand(action, xCoord, yCoord, xMaxCoord, yMaxCoord);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}


tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestDirectSearch(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onRequestDirectSearch MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDIRECTSEARCH"));
    mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU32 Titel = oFiDataObjectMethodStart.TitleNumber;
        tU32 Chapter = oFiDataObjectMethodStart.ChapterNumber;
        result = MediaPlayerInterface::GetInstance().RequestDirectSearch(Titel, Chapter);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestAngleChange(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onRequestAngleChange MPLAY_MEDIAPLAYERFI_C_U16_REQUESTANGLECHANGE"));
    mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 SelectionType = (tU8)oFiDataObjectMethodStart.e8SelectionType.enType;
        tU8 Angle = (tU8)oFiDataObjectMethodStart.e8Angle.enType;

        result = MediaPlayerInterface::GetInstance().RequestAngleChange(SelectionType, Angle);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSetMenuPlaybackControl(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onSetMenuPlaybackControl MPLAY_MEDIAPLAYERFI_C_U16_SETMENUPLAYBACKCONTROL"));
    mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 menu = (tU8)oFiDataObjectMethodStart.e8MenuControlData.enType;
        result = MediaPlayerInterface::GetInstance().SetMenuPlayBackControl(menu);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSelectDirectNumber(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onSelectDirectNumber MPLAY_MEDIAPLAYERFI_C_U16_REQUESTTITLESEARCH"));
    mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU32 number = oFiDataObjectMethodStart.u32Number;
        result = MediaPlayerInterface::GetInstance().SelectDirectNumber(number);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestTitleSearch(amt_tclServiceData* poMessage)
{
    ENTRY
    ETG_TRACE_USR3(("MethodStart: onRequestTitleSearch MPLAY_MEDIAPLAYERFI_C_U16_REQUESTTITLESEARCH"));
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU32 number = oFiDataObjectMethodStart.u32SearchNumber;
        result = MediaPlayerInterface::GetInstance().RequestTitleSearch(number);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestSubtitleChange(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onRequestSubtitleChange MPLAY_MEDIAPLAYERFI_C_U16_REQUESTSUBTITLECHANGE"));
    mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tBool State = oFiDataObjectMethodStart.subtitleSwitchState;
        tU8 SelectionType = oFiDataObjectMethodStart.e8SelectionType.enType;
        tU8 Subtitle = oFiDataObjectMethodStart.u8SubtitleSelection;
        result = MediaPlayerInterface::GetInstance().RequestSubtitleChange(State, SelectionType, Subtitle);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestCMSkip(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    ETG_TRACE_USR3(("MethodStart: onRequestCMSkip MPLAY_MEDIAPLAYERFI_C_U16_REQUESTCMSKIP"));
    mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tU8 SkipValue = (tU8)oFiDataObjectMethodStart.e8CMSkipValue.enType;
        result = MediaPlayerInterface::GetInstance().RequestCMSkip(SkipValue);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();

}
tVoid fc_mediaplayer_tclService_MediaPlayer::OnClearLastModePause(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = MP_NO_ERROR;

    mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID = DEVICE_ID_NOT_SET;
        ConvertDeviceTagToInternal(OUT deviceID, IN oFiDataObjectMethodStart.u8DeviceTag);
        result = MediaPlayerInterface::GetInstance().ClearLastModePause(deviceID);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if(MP_NO_ERROR != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

/******************************************************************************/
/*                                                                            */
/* bStatusMessageFactory                                                      */
/*                                                                            */
/******************************************************************************/
tBool fc_mediaplayer_tclService_MediaPlayer::bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* /*poInMsg*/) //finished: 100%
{
    ENTRY
    tResult bSuccess = false;
    tResult result = -1;
    ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.",u16FunctionId));
    switch(u16FunctionId)
    {
        case MPLAY_MEDIAPLAYERFI_C_U16_NOWPLAYING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_NOWPLAYING"));
            tNowPlaying nowPlaying;
            result = MediaPlayerInterface::GetInstance().GetNowPlaying(nowPlaying);

            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgNowPlayingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32ListHandle = nowPlaying.listID;
                ConvertNowPlayingStateToMPLAY(oFiDataObjectStatus.e8NowPlayingState, nowPlaying.state);
                oFiDataObjectStatus.u32Position = nowPlaying.position;
                oFiDataObjectStatus.u32Tag = nowPlaying.objectID;
                ConvertMediaObjectToMPLAY(oFiDataObjectStatus.oMediaObject, nowPlaying.object);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_CURRENTFOLDERPATH:
        {

            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_CURRENTFOLDERPATH"));
            tPath currentFolderPath;
            tListID listID;
            result = MediaPlayerInterface::GetInstance().GetCurrentFolderPath(currentFolderPath,listID);
            mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus oFiDataObjectStatus;
            if (0 == result)
            {
                oFiDataObjectStatus.sCurrentFolderPath.bSet(currentFolderPath,mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.u32ListHandle = listID;
            }
            bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYTIME:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_PLAYTIME"));
            tPlaytime elapsedPlaytime;
            tPlaytime totalPlaytime;
            tObjectID objectID;
            result = MediaPlayerInterface::GetInstance().GetPlaytime(elapsedPlaytime, totalPlaytime,objectID);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgPlaytimeStatus oFiDataObjectStatus;
                if(elapsedPlaytime%1000 >= 500)
                {
                    oFiDataObjectStatus.u32ElapsedPlaytime = (elapsedPlaytime + IPOD_CTRL_SM_PLAYTIME_SYNC_MS)/1000;
                }
                else
                {
                    oFiDataObjectStatus.u32ElapsedPlaytime = elapsedPlaytime/1000;
                }
                oFiDataObjectStatus.u32TotalPlaytime = totalPlaytime/1000;
                /*In some cases elapsedPlaytime may exceed totalPlaytime by few milli seconds, correct it*/
                /*in some cases totalPlaytime might be zero due to metadata extraction failure, avoid updating elapsedPlaytime in those cases*/
                if((0 != oFiDataObjectStatus.u32TotalPlaytime) && (oFiDataObjectStatus.u32ElapsedPlaytime > oFiDataObjectStatus.u32TotalPlaytime))
                    oFiDataObjectStatus.u32ElapsedPlaytime = oFiDataObjectStatus.u32TotalPlaytime;
                oFiDataObjectStatus.u32Tag = objectID;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKSTATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKSTATE"));
            tHMIPlaybackState playbackState;
            result = MediaPlayerInterface::GetInstance().GetPlaybackState(playbackState);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgPlaybackStateStatus oFiDataObjectStatus;
                ConvertPlaybackStateToMPLAY(oFiDataObjectStatus.e8State, playbackState);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKMODE"));
            tPlaybackMode playbackMode;
            result = MediaPlayerInterface::GetInstance().GetPlaybackMode(playbackMode);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgPlaybackModeStatus oFiDataObjectStatus;
                ConvertPlaybackModeToMPLAY(oFiDataObjectStatus.e8Mode, playbackMode);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_REPEATMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_REPEATMODE"));
            tRepeatMode repeatMode;
            result = MediaPlayerInterface::GetInstance().GetRepeatMode(repeatMode);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgRepeatModeStatus oFiDataObjectStatus;
                ConvertRepeatModeToMPLAY(oFiDataObjectStatus.e8Repeat, repeatMode);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKREPEATMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKREPEATMODE"));
            tRepeatMode repeatMode;
            result = MediaPlayerInterface::GetInstance().GetRepeatMode(repeatMode);
            tPlaybackMode playbackMode;
            result = MediaPlayerInterface::GetInstance().GetPlaybackMode(playbackMode);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus oFiDataObjectStatus;
                ConvertRepeatModeToMPLAY(oFiDataObjectStatus.e8Repeat, repeatMode);
                ConvertPlaybackModeToMPLAY(oFiDataObjectStatus.e8Mode, playbackMode);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_INDEXINGSTATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_INDEXINGSTATE"));
            vector<tIndexingStateResult> indexingStates;
            result = MediaPlayerInterface::GetInstance().GetIndexingState(indexingStates);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgIndexingStateStatus oFiDataObjectStatus;
                vector<tIndexingStateResult>::iterator it;
                for(it = indexingStates.begin(); it < indexingStates.end(); it++)
                {
                    mplay_fi_tcl_MPlayIndexingStateResultItem item;
                    ConvertIndexingStateResultToMPLAY(item, *it);
                    oFiDataObjectStatus.oIndexingStateResult.oItems.push_back(item);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }

            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_ACTIVEMEDIADEVICE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_ACTIVEMEDIADEVICE"));
            tDeviceInfo deviceInfo;
            result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(deviceInfo);
            mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus oFiDataObjectStatus;
            if (0 == result)
            {
                ConvertDeviceTagToMPLAY(oFiDataObjectStatus.u8DeviceTag, deviceInfo.deviceID);
                oFiDataObjectStatus.bDeviceActiveSource = (tBool)deviceInfo.activeSource;

                //For 15008_SCAN
                oFiDataObjectStatus.bScanSupported =  LocalSPM::GetDataProvider().TrackScanningSupported() && LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceInfo.deviceType);
            }
            bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERLISTCHANGE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERLISTCHANGE"));
            tListID listID;
            tListChangeType listChangeType;
            tListSize listSize;
            vector<tPosition> changedItems;
            result = m_poMainAppInstance->GetOutputWrapper().GetMediaPlayerListChanged(listID, listChangeType, listSize, changedItems);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32ListHandle = listID;
                ConvertListChangeTypeToMPlay(oFiDataObjectStatus.e8Change, listChangeType);
                oFiDataObjectStatus.u32ListSize = listSize;
                vector<tPosition>::iterator it;
                for(it = changedItems.begin(); it < changedItems.end(); it++)
                {
                    oFiDataObjectStatus.oItems.u32Items.push_back(*it);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS"));
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInformation;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices, deviceInformation);
            if (0 == result)
            {
                /* Get count of currently connected devices. GetMediaplayerDeviceConnections delivers count of ever connected devices */
                result = MediaPlayerInterface::GetInstance().GetConnectedDeviceCount(numberOfDevices);

                mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus oFiDataObjectStatus;
                vector<tDeviceInfo>::iterator it;
                for(it = deviceInformation.begin(); it < deviceInformation.end(); it++)
                {
                    mplay_fi_tcl_MPlayDeviceInfoItem item;
                    ConvertDeviceInfoToMPLAY(item, *it);
                    oFiDataObjectStatus.oDeviceInfo.oItems.push_back(item);
                }
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_MYMEDIASUPPORTED:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_MYMEDIASUPPORTED"));
            mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus oFiDataObjectStatus;
            oFiDataObjectStatus.bMyMediaSupportedFlag = MediaPlayerInterface::GetInstance().MyMediaSupported();
            bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWTIME:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWTIME"));
            tSlideshowTime slideshowTime = 0; // CID 17572 (#1 of 1): Uninitialized scalar variable (UNINIT)
            result = MediaPlayerInterface::GetInstance().GetSlideshowTime(OUT slideshowTime);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgSlideshowTimeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32Time = slideshowTime;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_NOWSHOWING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_NOWSHOWING"));
            tNowShowing nowShowing; // CID 17570 (#1 of 1): Uninitialized scalar variable (UNINIT)
            InitNowShowing(nowShowing);
            result = MediaPlayerInterface::GetInstance().GetNowShowing(nowShowing);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgNowShowingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u32ListHandle = nowShowing.listID;
                ConvertNowPlayingStateToMPLAY(oFiDataObjectStatus.e8NowPlayingState, nowShowing.state);
                oFiDataObjectStatus.u32Position = nowShowing.position;
                ConvertMediaObjectToMPLAY(oFiDataObjectStatus.oMediaObject, nowShowing.object);
                oFiDataObjectStatus.sNextFile.bSet(nowShowing.nextFile,mplay_fi_tclString::FI_EN_UTF8);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWSTATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWSTATE"));
            tHMIPlaybackState playbackState = HMI_PBS_STOPPED; // CID 17571 (#1 of 1): Uninitialized scalar variable (UNINIT)
            result = MediaPlayerInterface::GetInstance().GetSlideshowState(playbackState);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgSlideshowStateStatus oFiDataObjectStatus;
                ConvertPlaybackStateToMPLAY(oFiDataObjectStatus.e8State, playbackState);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_LANGUAGE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_LANGUAGE"));
            mplay_mediaplayerfi_tclMsgLanguageStatus oFiDataObjectStatus;
            tLanguageType language = LNG_NA_ENGLISH; //CID 17569 (#1 of 1): Uninitialized scalar variable (UNINIT)
            result = MediaPlayerInterface::GetInstance().GetLanguage(OUT language);
            if(0 == result)
            {
                ConvertLanguageTypeToMPLAY(oFiDataObjectStatus.e8Language, language);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCSLOTSTATE: /*Roadmap: 15002_CDAudio_DetectionAndDiagnosis*/
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCSLOTSTATE"));

            tDMOpticalDiscSlotState opticalDiscSlotState;
            mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus oFiDataObjectStatus;

            result = MediaPlayerInterface::GetInstance().GetOpticalDiscSlotStatus(OUT opticalDiscSlotState);
            if (0 == result)
            {
                ConvertDiscSlotStateToMPLAY(OUT oFiDataObjectStatus.e8State, IN opticalDiscSlotState);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }

            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_SCANMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_SCANMODEE"));
            tScanMode isScanMode = false;
            result = MediaPlayerInterface::GetInstance().GetScanMode(isScanMode);
            if (MP_NO_ERROR == result)
            {
                mplay_mediaplayerfi_tclMsgScanModeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bScanMode = isScanMode;
                ETG_TRACE_USR3(("oFiDataObjectStatus.bScanMode:%u",oFiDataObjectStatus.bScanMode));
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCCDINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCCDINFO"));

            trOpticalDiskCDInfo OpticalDiskCDInfo;
            mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus oFiDataObjectStatus;

            result = MediaPlayerInterface::GetInstance().GetOpticalDiscCDInfo(OUT OpticalDiskCDInfo);
            if (0 == result)
            {
                ConvertOpticalDeviceStateToMPLAY(OUT oFiDataObjectStatus.CDInfo.e8DeviceState , IN OpticalDiskCDInfo.OpticalDeviceState);
                oFiDataObjectStatus.CDInfo.DriveVersion.bSet((tCString)OpticalDiskCDInfo.OpticalDriveVersion,mplay_fi_tclString::FI_EN_UTF8);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }

            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_IPODCOMMUNICATIONERROR:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_IPODCOMMUNICATIONERROR"));
            tDeviceID deviceID;
            tIpodCommError iPodCommError;
            result = LocalSPM::GetOutputWrapper().GetIpodCommunicationError(deviceID, iPodCommError);
            if(0 == result){
                mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus oFiDataObjectStatus;
                ConvertDeviceTagToMPLAY(oFiDataObjectStatus.u8DeviceTag, deviceID);
                if(IPOD_COMM_ERROR == iPodCommError)
                {
                    oFiDataObjectStatus.e8iPodCommunicationError.enType =  mplay_fi_tcl_e8_MPlayiPodCommunicationError::FI_EN_E8IPOD_COMM_ERROR;
                }
                else if(IPOD_NO_ERROR == iPodCommError)
                {
                    oFiDataObjectStatus.e8iPodCommunicationError.enType =  mplay_fi_tcl_e8_MPlayiPodCommunicationError::FI_EN_E8IPOD_NO_ERROR;
                }

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESS"));
            tVideoBrightness videoBrightness;
            result = MediaPlayerInterface::GetInstance().GetVideoBrightness(videoBrightness);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoBrightnessStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8VideoBrightness = videoBrightness;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUE"));
            tVideoHue videoHue;
            result = MediaPlayerInterface::GetInstance().GetVideoHue(videoHue);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoHueStatus oFiDataObjectStatus;
                oFiDataObjectStatus.s16VideoHue = videoHue;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATION:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATION"));
            tVideoSaturation videoSaturation;
            result = MediaPlayerInterface::GetInstance().GetVideoSaturation(videoSaturation);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoSaturationStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8VideoSaturation = videoSaturation;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOCONTRAST:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOCONTRAST"));
            tVideoContrast videoContrast;
            result = MediaPlayerInterface::GetInstance().GetVideoContrast(videoContrast);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoContrastStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8VideoContrast = videoContrast;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESSOFFSET:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESSOFFSET"));
            tVideoBrightnessOffset videoBrightnessOffset;
            result = MediaPlayerInterface::GetInstance().GetVideoBrightnessOffset(videoBrightnessOffset);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus oFiDataObjectStatus;
                oFiDataObjectStatus.s16VideoBrightnessOffset = videoBrightnessOffset;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUEOFFSET:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUEOFFSET"));
            tVideoHueOffset videoHueOffset;
            result = MediaPlayerInterface::GetInstance().GetVideoHueOffset(videoHueOffset);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus oFiDataObjectStatus;
                oFiDataObjectStatus.s16VideoHueOffset = videoHueOffset;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATIONOFFSET:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATIONOFFSET"));
            tVideoSaturationOffset videoSaturationOffset;
            result = MediaPlayerInterface::GetInstance().GetVideoSaturationOffset(videoSaturationOffset);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8VideoSaturationOffset = videoSaturationOffset;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DISCERROR:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DISCERROR"));
            result = 0 ;
            tU8 Info;
            tBool isError;
            result = MediaPlayerInterface::GetInstance().GetDiskError(isError, Info);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDiscErrorStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8DiscError.enType = (mplay_fi_tcl_e8_MDiscError::tenType)Info;
                oFiDataObjectStatus.bIsError = isError;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DISCMECHANICALINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DISCMECHANICALINFO"));
            tU8 info;
            result = MediaPlayerInterface::GetInstance().GetDiskMechanicalInfo(info);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8DiscMechanicalInfo.enType = (mplay_fi_tcl_e8_MDiscMechanicalInfo::tenType)info ;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDDRIVEINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDDRIVEINFO"));
            tU8 discType;
            tU8 driveMode;
            result = MediaPlayerInterface::GetInstance().GetDVDDriveInfo(discType,driveMode);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8DVDDiscType.enType = (mplay_fi_tcl_e8_MDVDDiscType::tenType)discType ;
                oFiDataObjectStatus.e8DVDDriveMode.enType = (mplay_fi_tcl_e8_MDVDDriveMode::tenType)driveMode ;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_CMSKIPAVAILABLE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_CMSKIPAVAILABLE"));
            tBool skipInfo;
            result = MediaPlayerInterface::GetInstance().GetSkipInfo(skipInfo);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bCMSkipAvailable = skipInfo ;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDMENUPLAYBACKONGOING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDMENUPLAYBACKONGOING"));
            //CID 185035 : Uninitialized scalar variable
            tBool menuPlayback = false;
            result = MediaPlayerInterface::GetInstance().GetDVDMenuPlaybackOngoing(menuPlayback);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bDVDMenuPlaybackOngoing = menuPlayback ;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }

        case MPLAY_MEDIAPLAYERFI_C_U16_DIRECTSELECTAVAILABLE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DIRECTSELECTAVAILABLE"));
            tBool bDirSelectAvailable;
            result = MediaPlayerInterface::GetInstance().GetDirectSelectInfo(bDirSelectAvailable);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bDirectSelectAvailable = bDirSelectAvailable ;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDANGLEINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDANGLEINFO"));
            //result = MediaPlayerInterface::GetInstance().GetVideoSaturationOffset(videoSaturationOffset);
            tU8 angletrack;
            tU8 totalangle;
            result = MediaPlayerInterface::GetInstance().GetAngleInfo(angletrack, totalangle);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8CurrentAngle.enType = (mplay_fi_tcl_e8_MAngle::tenType) angletrack;
                oFiDataObjectStatus.e8TotalAngle.enType = (mplay_fi_tcl_e8_MAngle::tenType) totalangle;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDSUBTITLEINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDSUBTITLEINFO"));
            tBool state = false;
            tU8 current = 0;
            tU8 total = 0;
            tU16 subtitleLang = 0;
            result = MediaPlayerInterface::GetInstance().GetSubtitleInfo(state, current, total,subtitleLang);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.subtitleState = state;
                oFiDataObjectStatus.u8CurrentSubtitle = current;
                oFiDataObjectStatus.u8TotalSubtitle = total;
                oFiDataObjectStatus.u16SubtitleLang = subtitleLang;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDAUDIOCHANNELINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDAUDIOCHANNELINFO"));
            tU8 totalChannels;
            tU8 subWoofer;
            tU8 Assignment;
            result = MediaPlayerInterface::GetInstance().GetAudioChannelInfo(totalChannels, subWoofer, Assignment);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8totalChannels.enType = (mplay_fi_tcl_e8_MTotalChannel::tenType) totalChannels;
                oFiDataObjectStatus.bSubWooferAvailable = subWoofer;
                oFiDataObjectStatus.e8CurrentAssignment.enType = (mplay_fi_tcl_e8_MChannelAssignment::tenType) Assignment;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDCURRENTAUDIOINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDCURRENTAUDIOINFO"));
            tU8 soundformat = 0;
            tU8 VcdAudio = 0;
            tU8 DvdAudio = 0;
            tU8 totalOutput = 0;
            tU16 audioLang = 0;
            result = MediaPlayerInterface::GetInstance().GetCurrentAudioInfo(soundformat, VcdAudio, DvdAudio,totalOutput ,audioLang);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8SoundFormat.enType = (mplay_fi_tcl_e8_MSoundFormat::tenType) soundformat;
                oFiDataObjectStatus.e8VCDAudioOutput.enType = (mplay_fi_tcl_e8_MVCDAudioMode::tenType) VcdAudio;
                oFiDataObjectStatus.e8DVDAudioChannel.enType = (mplay_fi_tcl_e8_MAudioOutputNumber::tenType) DvdAudio;
                oFiDataObjectStatus.e8DVDTotalAudio.enType = (mplay_fi_tcl_e8_MAudioOutputNumber::tenType) totalOutput;
                oFiDataObjectStatus.u16DVDAudioLang = audioLang;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DISPLAYMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DISPLAYMODE"));
            tU8 diplay;
            result = MediaPlayerInterface::GetInstance().GetDisplayMode(diplay);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDisplayModeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8DisplayMode.enType = (mplay_fi_tcl_e8_MDisplayMode::tenType) diplay;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDPLAYERLANGSETTING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDPLAYERLANGSETTING"));
            tU16 Audio;
            tU16 SubTitel;
            tU16 Menu;
            result = MediaPlayerInterface::GetInstance().GetLanguageSetting(Audio, SubTitel, Menu);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.langSetting.u16AudioLanguage = Audio;
                oFiDataObjectStatus.langSetting.u16SubtitleLanguage = SubTitel;
                oFiDataObjectStatus.langSetting.u16MenuLanguage = Menu;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_ANGLEMARKSETTING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_ANGLEMARKSETTING"));
            tBool AngleMark;
            result = MediaPlayerInterface::GetInstance().GetAngleMarkSetting(AngleMark);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bAngleMark = AngleMark;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYSTATUSSETTING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_PLAYSTATUSSETTING"));
            tBool playStatus;
            result = MediaPlayerInterface::GetInstance().GetPlayStatusSetting(playStatus);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bPlayStatus = playStatus;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DRCSETTING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DRCSETTING"));
            tU8 drc;
            result = MediaPlayerInterface::GetInstance().GetDRCSetting(drc);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDRCSettingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8DRCSetting.enType = (mplay_fi_tcl_e8_MDRCSetting::tenType) drc;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGSTATE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGSTATE"));
            tUInt RippingState;
            tUInt TotalTracks;
            tUInt CurrentRippingIndex;
            tUInt Percentage;

            result = MediaPlayerInterface::GetInstance().GetRippingStatus(RippingState, TotalTracks, CurrentRippingIndex, Percentage);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgRippingStateStatus oFiDataObjectStatus;
                oFiDataObjectStatus.oRippingStateResult.u8DeviceTag = 1;
                oFiDataObjectStatus.oRippingStateResult.e8DeviceRippingState.enType = (mplay_fi_tcl_e8_MPlayDeviceRippingState::tenType)RippingState;
                oFiDataObjectStatus.oRippingStateResult.u8RippingPercentComplete = Percentage;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }

        case MPLAY_MEDIAPLAYERFI_C_U16_RESOLVEGRACENOTEAMBUIGUITIES:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_RESOLVEGRACENOTEAMBUIGUITIES"));
            vector<string> albumStringVector;
            result = MediaPlayerInterface::GetInstance().GetAlbumStringsforGracenote(albumStringVector);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus oFiDataObjectStatus;
                vector<string>::iterator it;
                mplay_fi_tclString albumStringConverted;
                for(it = albumStringVector.begin();it< albumStringVector.end();it++)
                {
                    VARTRACE((*it).c_str());
                    albumStringConverted.bSet((*it).c_str(),mplay_fi_tclString::FI_EN_UTF8);
                    oFiDataObjectStatus.oAlbums.sAlbumTitle.push_back(albumStringConverted);
                }

                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGENCODINGQUALITY:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGENCODINGQUALITY"));
            tEncodingQuality rippingEncodingQuality;

            result = MediaPlayerInterface::GetInstance().GetRippingEncodingQuality(OUT rippingEncodingQuality);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus oFiDataObjectStatus;
                ConvertEncodingQualityTypeToMPlay(OUT oFiDataObjectStatus.e8EncodingQuality,IN rippingEncodingQuality);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
             break;
        }

        case MPLAY_MEDIAPLAYERFI_C_U16_AUTORIPPING:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_AUTORIPPING"));
            tBoolean AutpRippingStatus;

            result = MediaPlayerInterface::GetInstance().GetAutoRippingStatus(AutpRippingStatus);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgAutoRippingStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bAutoRipping = (tBool)AutpRippingStatus;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGERRORS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGERRORS"));
            tResult RippingError;
            result = MediaPlayerInterface::GetInstance().GetRippingError(RippingError);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgRippingErrorsStatus oFiDataObjectStatus;
                oFiDataObjectStatus.oRippingErrors.enType = (mplay_fi_tcl_MPlayRippingErrors::tenType) RippingError;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTEVERSION:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTEVERSION"));
            tGracenoteVersion GracenoteVersion;
            result = MediaPlayerInterface::GetInstance().GetGracenoteVersion(GracenoteVersion);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgGracenoteVersionStatus oFiDataObjectStatus;
                oFiDataObjectStatus.sVersion.bSet(GracenoteVersion,mplay_fi_tclString::FI_EN_UTF8);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
    case MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTELOOKUPMODE:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTELOOKUPMODE"));
            tGracenoteLookupMode GracenoteLookupMode = GRACENOTE_OFFLINE;
            result = MediaPlayerInterface::GetInstance().GetGracenoteLookupMode(OUT GracenoteLookupMode);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus oFiDataObjectStatus;
                oFiDataObjectStatus.bLookupMode = GracenoteLookupMode;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
    case MPLAY_MEDIAPLAYERFI_C_U16_GNMETADATAEXTRACTIONSTATUS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_GNMETADATAEXTRACTIONSTATUS"));
            tGNmetadataExtractionResult GNmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
            result = MediaPlayerInterface::GetInstance().GetGNMetadataExtractionStatus(OUT GNmetadataExtractionResult);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus oFiDataObjectStatus;
        oFiDataObjectStatus.e8GNmetadataExtractionResult.enType = (mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::tenType)GNmetadataExtractionResult;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
             break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DEVICESTREAMINGINFO:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DEVICESTREAMINGINFO"));
            //CID 146004 ,146005,146006: Uninitialized scalar variable
            tU8 DeviceType = DTY_UNKNOWN;
            tU8 DeviceTag = 0;
            tS16 StreamInfo = REASON_OK;
            result = MediaPlayerInterface::GetInstance().getStreamingInfo(DeviceType, DeviceTag,StreamInfo);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus oFiDataObjectStatus;
                oFiDataObjectStatus.u8DeviceType = DeviceType;
                oFiDataObjectStatus.u8DeviceTag = DeviceTag;
                oFiDataObjectStatus.e8StreamingInfo.enType = (mplay_fi_tcl_e8_MPlayStreamingInfo::tenType)StreamInfo;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDCOMMANDSTATUS:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_DVDCOMMANDSTATUS"));
            tU8 DvdCommandStatus;
            result = MediaPlayerInterface::GetInstance().GetKeyCommandResponse(DvdCommandStatus);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus oFiDataObjectStatus;
                oFiDataObjectStatus.e8CommandStatus.enType = (mplay_fi_tcl_e8_DVDCommandStatus::tenType) DvdCommandStatus;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_UPDATEPLAYBACKSPEED:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_UPDATEPLAYBACKSPEED"));
            tPlaybackSpeed playbackSpeed;
            result = MediaPlayerInterface::GetInstance().GetPlaybackSpeed(playbackSpeed);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus oFiDataObjectStatus;
                ConvertPlaybackSpeedToMPLAY(oFiDataObjectStatus.e8PlaybackSpeed, playbackSpeed);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_FOLDERBROWSESTRUCTURECLEARED:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_FOLDERBROWSESTRUCTURECLEARED"));
            tDeviceID deviceID;
            result = MediaPlayerInterface::GetInstance().GetDeviceIDForFolderStructureCleared(deviceID);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus oFiDataObjectStatus;
                ConvertDeviceTagToMPLAY(oFiDataObjectStatus.u8DeviceTag, deviceID);
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_READYTOPLAY:
        {
            ETG_TRACE_USR3(("bStatusMessageFactory: MPLAY_MEDIAPLAYERFI_C_U16_READYTOPLAY"));
            tDeviceSerialNumber deviceSerialNumber;
            tBool playingStatus = 0;
            result = MediaPlayerInterface::GetInstance().GetValuesForReadyToPlay(OUT deviceSerialNumber,OUT playingStatus);
            if (0 == result)
            {
                mplay_mediaplayerfi_tclMsgReadyToPlayStatus oFiDataObjectStatus;
                oFiDataObjectStatus.sDeviceSerialNumber.bSet(deviceSerialNumber, mplay_fi_tclString::FI_EN_UTF8);
                oFiDataObjectStatus.bPlayingStatus = playingStatus;
                bSuccess = fi_tclVisitorMessage(oFiDataObjectStatus,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
            }
            break;
        }
        default:
        {
            bSuccess = false;
            break;
        }
    }
    if (false == bSuccess)
    {
        ETG_TRACE_ERR(("bStatusMessageFactory: Creation of message with 'FID = %u' failed.", u16FunctionId));
    }
    return bSuccess;
}

/******************************************************************************/
/*                                                                            */
/* bProcessSet                                                                */
/*                                                                            */
/******************************************************************************/
tBool fc_mediaplayer_tclService_MediaPlayer::bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error) //finished: 100%
{
    (tVoid) u16Error;     // This line is added to avoid LINT warnings
    ENTRY
    tResult bSuccess = false;
    tResult result;

    tU16 u16FunctionId = poMessage->u16GetFunctionID();
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

    switch(u16FunctionId)
    {
        case MPLAY_MEDIAPLAYERFI_C_U16_ACTIVEMEDIADEVICE:
        {
            mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tDeviceID deviceID = oFiDataObject.u8DeviceTag;
                tBoolean activeSource = (tBoolean)oFiDataObject.bDeviceActiveSource;
                result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceID, IN activeSource);
                /* Answer request with true in every case to be able to toggle through media sources */
                //if (0 == result)
                //{
                bSuccess = TRUE;
                //}
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_REPEATMODE:
        {
            mplay_mediaplayerfi_tclMsgRepeatModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tRepeatMode repeatMode;
                ConvertRepeatModeToInternal(repeatMode, oFiDataObject.e8Repeat);
                result = MediaPlayerInterface::GetInstance().SendRepeatMode(repeatMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }

        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKREPEATMODE:
        {
            mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tRepeatMode repeatMode;
                ConvertRepeatModeToInternal(repeatMode, oFiDataObject.e8Repeat);
                result = MediaPlayerInterface::GetInstance().SendRepeatMode(repeatMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }

                tPlaybackMode playbackMode;
                ConvertPlaybackModeToInternal(playbackMode, oFiDataObject.e8Mode);
                result = MediaPlayerInterface::GetInstance().SendPlaybackMode(playbackMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }

        case MPLAY_MEDIAPLAYERFI_C_U16_LANGUAGE:
        {
            mplay_mediaplayerfi_tclMsgLanguageSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tLanguageType language;
                ConvertLanguageTypeToInternal(language, oFiDataObject.e8Language);
                result = MediaPlayerInterface::GetInstance().SetLanguage(language);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKMODE:
        {
            mplay_mediaplayerfi_tclMsgPlaybackModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPlaybackMode playbackMode;
                ConvertPlaybackModeToInternal(playbackMode, oFiDataObject.e8Mode);
                result = MediaPlayerInterface::GetInstance().SendPlaybackMode(playbackMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWTIME:
        {
            mplay_mediaplayerfi_tclMsgSlideshowTimeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tSlideshowTime slideshowTime;
                slideshowTime = oFiDataObject.u32Time;
                result = MediaPlayerInterface::GetInstance().SetSlideshowTime(slideshowTime);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_SCANMODE:
        {
            mplay_mediaplayerfi_tclMsgScanModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tScanMode scanMode = oFiDataObject.bScanMode;
                result = MediaPlayerInterface::GetInstance().SendScanMode(scanMode);
                if (MP_NO_ERROR == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESS:
        {
            mplay_mediaplayerfi_tclMsgVideoBrightnessSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoBrightness = (tPropertyValue)oFiDataObject.u8VideoBrightness;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_BRIGHTNESS,videoBrightness);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUE:
        {
            mplay_mediaplayerfi_tclMsgVideoHueSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoHue = oFiDataObject.s16VideoHue;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_HUE,videoHue);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATION:
        {
            mplay_mediaplayerfi_tclMsgVideoSaturationSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoSaturation = (tPropertyValue)oFiDataObject.u8VideoSaturation;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_SATURATION,videoSaturation);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOCONTRAST:
        {
            mplay_mediaplayerfi_tclMsgVideoContrastSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoContrast = (tPropertyValue)oFiDataObject.u8VideoContrast;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_CONTRAST,videoContrast);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESSOFFSET:
        {
            mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoBrightnessOffset = oFiDataObject.s16VideoBrightnessOffset;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_BRIGHTNESS_OFFSET,videoBrightnessOffset);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUEOFFSET:
        {
            mplay_mediaplayerfi_tclMsgVideoHueOffsetSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoHueOffset = oFiDataObject.s16VideoHueOffset;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_HUE_OFFSET,videoHueOffset);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATIONOFFSET:
        {
            mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tPropertyValue videoSaturationOffset = (tPropertyValue)oFiDataObject.u8VideoSaturationOffset;
                result = MediaPlayerInterface::GetInstance().SendVideoProperty(VP_SATURATION_OFFSET,videoSaturationOffset);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DISPLAYMODE:
        {

            mplay_mediaplayerfi_tclMsgDisplayModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tU8 e8DisplayMode = (tU8)oFiDataObject.e8DisplayMode.enType;
                result = MediaPlayerInterface::GetInstance().SetDisplayMode(e8DisplayMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DVDPLAYERLANGSETTING:
        {

            mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tU16 Audio = oFiDataObject.langSetting.u16AudioLanguage;
                tU16 subtitel = oFiDataObject.langSetting.u16SubtitleLanguage;
                tU16 menu = oFiDataObject.langSetting.u16MenuLanguage;
                result = MediaPlayerInterface::GetInstance().SetLanguageSetting(Audio, subtitel, menu);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_ANGLEMARKSETTING:
        {

            mplay_mediaplayerfi_tclMsgAngleMarkSettingSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tU8 bAngle = (tU8)oFiDataObject.bAngleMark;
                result = MediaPlayerInterface::GetInstance().SetAngleMarkSetting(bAngle);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_PLAYSTATUSSETTING:
        {

            mplay_mediaplayerfi_tclMsgPlayStatusSettingSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tU8 bPlayStatus = (tU8)oFiDataObject.bPlayStatus;
                result = MediaPlayerInterface::GetInstance().SetPlayStatusSetting(bPlayStatus);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;

        }
        case MPLAY_MEDIAPLAYERFI_C_U16_DRCSETTING:
        {

            mplay_mediaplayerfi_tclMsgDRCSettingSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tU8 drc = (tU8)oFiDataObject.e8DRCSetting.enType;
                result = MediaPlayerInterface::GetInstance().SetDRCSetting(drc);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;

        }
        case MPLAY_MEDIAPLAYERFI_C_U16_AUTORIPPING:
        {
            mplay_mediaplayerfi_tclMsgAutoRippingSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                result = MediaPlayerInterface::GetInstance().SetAutoRipping(oFiDataObject.bAutoRipping);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTELOOKUPMODE:
        {
            mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                result = MediaPlayerInterface::GetInstance().SetGracenoteLookupMode(oFiDataObject.bLookupMode);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }
        case MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGENCODINGQUALITY:
        {
            mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet oFiDataObject;
            if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
            {
                tEncodingQuality rippingEncodingQuality;
                ConvertMplayTypeToEncodingQuality(OUT rippingEncodingQuality,IN oFiDataObject.e8EncodingQuality);
                result = MediaPlayerInterface::GetInstance().SetRippingEncodingQuality(IN rippingEncodingQuality);
                if (0 == result)
                {
                    bSuccess = TRUE;
                }
            }
            break;
        }

        default:
            ETG_TRACE_ERR(("bProcessSet(). Invalid 'FID = %u'.", u16FunctionId));
            break;
    }

    if (FALSE == bSuccess)
    {
        ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.", u16FunctionId));
    }
    else
    {
        bPropertyChanged = true;
    }

    return bSuccess;
}

/******************************************************************************/
/*                                                                            */
/* Service availability functions                                             */
/*                                                                            */
/******************************************************************************/
tVoid fc_mediaplayer_tclService_MediaPlayer::vOnServiceAvailable() //finished: 100%
{
    ENTRY
}

tVoid fc_mediaplayer_tclService_MediaPlayer::vOnServiceUnavailable() //finished: 100%
{
    ENTRY
}


/******************************************************************************/
/*                                                                            */
/* Convert functions                                                          */
/*                                                                            */
/******************************************************************************/

void fc_mediaplayer_tclService_MediaPlayer::ConvertTransferTagToInternal(tTagTransfer &tagTransfer, mplay_fi_tcl_MPlayTagTransferItem_2 &transferTagMPLAY)
{
    ENTRY_INTERNAL
    tagTransfer.ambiguousTag = transferTagMPLAY.u8AmbiguousTag;
    tagTransfer.buttonPressed = transferTagMPLAY.u8ButtonPressed;
    strncpy(tagTransfer.tagTrackName, transferTagMPLAY.sTagTrackName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagTrackName -1);
    strncpy(tagTransfer.tagArtistName, transferTagMPLAY.sTagArtistName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagArtistName -1);
    strncpy(tagTransfer.tagAlbumName, transferTagMPLAY.sTagAlbum.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagAlbumName -1);
    strncpy(tagTransfer.tagGenreName, transferTagMPLAY.sTagGenre.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagGenreName -1);
    tagTransfer.tagSongID = transferTagMPLAY.u32TagSongID;
    tagTransfer.tagStorefrontID = transferTagMPLAY.u32TagStorefrontID;
    strncpy(tagTransfer.tagChannelNumber, transferTagMPLAY.sTagChannelNumber.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagChannelNumber -1);
    strncpy(tagTransfer.tagChannelName, transferTagMPLAY.sTagChannelName.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagChannelName -1);
    strncpy(tagTransfer.tagTimeStamp, transferTagMPLAY.sTagTimeStamp.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagTimeStamp -1);
    strncpy(tagTransfer.podcastFeedURL, transferTagMPLAY.sPodCastFeedURL.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.podcastFeedURL -1);
    strncpy(tagTransfer.stationURL, transferTagMPLAY.sStationURL.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.stationURL -1);
    tagTransfer.tagProgramNumber = transferTagMPLAY.u8TagProgramNumber;
    strncpy(tagTransfer.tagAffiliateID, transferTagMPLAY.sTagAffiliateID.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.tagAffiliateID -1);
    tagTransfer.unknownDataSize = transferTagMPLAY.oUnknownData.u8Data.size();
    memcpy(tagTransfer.unknownData, &transferTagMPLAY.oUnknownData.u8Data[0],transferTagMPLAY.oUnknownData.u8Data.size());
    strncpy(tagTransfer.stationURLFrequency, transferTagMPLAY.sStationURLFrequency.szGet(mplay_fi_tclString::FI_EN_UTF8), sizeof tagTransfer.stationURLFrequency -1);
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertTransferStatusToMPLAY(mplay_fi_tcl_e8_MPlayTagTransferStatus &transferStatusMPLAY, const tTagTransferStatus transferStatus)
{
    ENTRY_INTERNAL
    switch(transferStatus)
    {
        case TAG_TRANSFER_SUCCESS:
            transferStatusMPLAY.enType = mplay_fi_tcl_e8_MPlayTagTransferStatus::FI_EN_E8TAG_TRANSFER_SUCCESS;
            break;
        case TAG_TRANSFER_COMM_ERROR:
            transferStatusMPLAY.enType = mplay_fi_tcl_e8_MPlayTagTransferStatus::FI_EN_E8TAG_TRANSFER_COMM_ERROR;
            break;
        case TAG_TRANSFER_DEVICE_FULL:
            transferStatusMPLAY.enType = mplay_fi_tcl_e8_MPlayTagTransferStatus::FI_EN_E8TAG_TRANSFER_DEVICE_FULL;
            break;
        case TAG_TRANSFER_NOT_SUPPORTED:
            transferStatusMPLAY.enType = mplay_fi_tcl_e8_MPlayTagTransferStatus::FI_EN_E8TAG_TRANSFER_NOT_SUPPORTED;
            break;
        default:
            transferStatusMPLAY.enType = mplay_fi_tcl_e8_MPlayTagTransferStatus::FI_EN_E8TAG_TRANSFER_SUCCESS;
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertUntransferredTagsToMPLAY(mplay_fi_tcl_MPlayUntransferredTagStreamItem &untransferredTagMPLAY,const tUntransferredTag &untransferredTag)
{
    ENTRY_INTERNAL
    untransferredTagMPLAY.u32TagSongID = untransferredTag.tagSongID;
    untransferredTagMPLAY.sTagArtistName.bSet(untransferredTag.tagArtistName,mplay_fi_tclString::FI_EN_UTF8);
    untransferredTagMPLAY.sTagTrackName.bSet(untransferredTag.tagTrackName,mplay_fi_tclString::FI_EN_UTF8);
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertUmountResultToMPLAY(mplay_fi_tcl_e8_MPlayUmountResult &umountResultMPLAY, const tErrorCode umountResult)
{
    ENTRY_INTERNAL
    switch(umountResult)
    {
        case MP_NO_ERROR:
            umountResultMPLAY.enType = mplay_fi_tcl_e8_MPlayUmountResult::FI_EN_E8UMOUNT_OK;
            break;
        case MP_ERR_UMOUNT_BUSY:
            umountResultMPLAY.enType = mplay_fi_tcl_e8_MPlayUmountResult::FI_EN_E8UMOUNT_BUSY;
            break;
        case MP_ERR_UMOUNT_NOT_SUPPORTED:
            umountResultMPLAY.enType = mplay_fi_tcl_e8_MPlayUmountResult::FI_EN_E8UMOUNT_NOT_SUPPORTED;
            break;
        case MP_ERR_UMOUNT_ERROR:
            umountResultMPLAY.enType = mplay_fi_tcl_e8_MPlayUmountResult::FI_EN_E8UMOUNT_ERROR;
            break;
        default:
            umountResultMPLAY.enType = mplay_fi_tcl_e8_MPlayUmountResult::FI_EN_E8UMOUNT_ERROR;
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackModeToInternal(tPlaybackMode &playbackMode, const mplay_fi_tcl_e8_MPlayMode mplayPlaybackMode)  //finished: 100%
{
    ENTRY_INTERNAL
    switch(mplayPlaybackMode.enType)
    {
        case mplay_fi_tcl_e8_MPlayMode::FI_EN_E8PBM_NORMAL:
            playbackMode = PBM_NORMAL;
            break;
        case mplay_fi_tcl_e8_MPlayMode::FI_EN_E8PBM_RANDOM:
            playbackMode = PBM_RANDOM;
            break;
        default:
            playbackMode = PBM_NORMAL;
            ETG_TRACE_ERR(("Invalid playback mode type"));
            break;
    }

}

// Todo: must be extended to support new raneges
void fc_mediaplayer_tclService_MediaPlayer::ConvertRepeatModeToInternal(tRepeatMode &repeatMode, const mplay_fi_tcl_e8_MPlayRepeat mplayRepeatMode)  //finished: 100%
{
    ENTRY_INTERNAL
    switch(mplayRepeatMode.enType)
    {
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_NONE:
            repeatMode = RPT_NONE;
            break;
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ONE:
            repeatMode = RPT_ONE;
            break;
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_LIST:
            repeatMode = RPT_LIST;
            break;
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_LIST_WITH_SUBLISTS:
            repeatMode = RPT_LIST_WITH_SUBLISTS;
            break;
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ALL_LISTS:
            repeatMode = RPT_ALL_LISTS;
            break;
        case mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ALL:
            repeatMode = RPT_ALL;
            break;
        default:
            repeatMode = RPT_NONE;
            ETG_TRACE_ERR(("Invalid repeat mode type"));
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertListChangeTypeToMPlay(mplay_fi_tcl_e8_MPlayChange &mplayListType, const tListChangeType listChangeType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(listChangeType)
    {
        case LCH_CONTENT_CHANGED:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayChange::FI_EN_E8LCH_CONTENT_CHANGED;
            break;
        case LCH_ITEMS_ADDED:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayChange::FI_EN_E8LCH_ITEMS_ADDED;
            break;
        case LCH_ITEMS_REMOVED:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayChange::FI_EN_E8LCH_ITEMS_REMOVED;
            break;
        case LCH_ITEMS_CHANGED:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayChange::FI_EN_E8LCH_ITEMS_CHANGED;
            break;
        default:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayChange::FI_EN_E8LCH_CONTENT_CHANGED;
            ETG_TRACE_ERR(("Invalid fav list change type"));
            break;
    }

}

void fc_mediaplayer_tclService_MediaPlayer::ConvertCategoryTypeToMPLAY(mplay_fi_tcl_e8_MPlayCategoryType &mplayCategoryType, const tCategoryType categoryType) //finished: 100%
{
    ENTRY_INTERNAL
    switch (categoryType)
    {
        case CTY_NONE:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_NONE;
            break;
        case CTY_GENRE:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_GENRE;
            break;
        case CTY_ARTIST:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_ARTIST;
            break;
        case CTY_ALBUM:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_ALBUM;
            break;
        case CTY_SONG:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_SONG;
            break;
        case CTY_COMPOSER:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_COMPOSER;
            break;
        case CTY_AUTHOR:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_AUTHOR;
            break;
        case CTY_TITLE:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_TITLE;
            break;
        case CTY_CHAPTER:
        case CTY_AUDIOBOOK:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_CHAPTER;
            break;
        case CTY_NAME:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_NAME;
            break;
        case CTY_EPISODE:
        case CTY_VIDEO:
        case CTY_PODCAST:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_EPISODE;
            break;
        case CTY_PLAYLIST:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_PLAYLIST;
            break;
        case CTY_PLAYLIST_INTERNAL:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_PLAYLIST_INTERNAL;
            break;
        case CTY_IMAGE:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_IMAGE;
            break;
        case CTY_YEAR:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_YEAR;
            break;
        default:
            mplayCategoryType.enType = mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_NONE;
            ETG_TRACE_ERR(("Invalid category type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertListTypeToMPLAY(mplay_fi_tcl_e8_MPlayListType &mplayListType, const tListType listType) //finished: 100%
{
    ENTRY_INTERNAL
    switch (listType)
    {
        case LTY_GENRE:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE;
            break;
        case LTY_ARTIST:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST;
            break;
        case LTY_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ALBUM;
            break;
        case LTY_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ALBUM_SONG;
            break;
        case LTY_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_SONG;
            break;
        case LTY_GENRE_ARTIST:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST;
            break;
        case LTY_GENRE_ARTIST_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_ALBUM;
            break;
        case LTY_GENRE_ARTIST_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_ALBUM_SONG;
            break;
        case LTY_GENRE_ARTIST_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_SONG;
            break;
        case LTY_GENRE_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ALBUM;
            break;
        case LTY_GENRE_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ALBUM_SONG;
            break;
        case LTY_GENRE_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_SONG;
            break;
        case LTY_ARTIST_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_ALBUM;
            break;
        case LTY_ARTIST_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_ALBUM_SONG;
            break;
        case LTY_ARTIST_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_SONG;
            break;
        case LTY_PODCAST:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PODCAST;
            break;
        case LTY_PODCAST_EPISODE:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PODCAST_EPISODE;
            break;
        case LTY_AUDIOBOOK:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUDIOBOOK;
            break;
        case LTY_BOOKTITLE_CHAPTER:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_BOOKTITLE_CHAPTER;
            break;
        case LTY_AUTHOR:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR;
            break;
        case LTY_AUTHOR_BOOKTITLE:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR_BOOKTITLE;
            break;
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR_BOOKTITLE_CHAPTER;
            break;
        case LTY_COMPOSER:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER;
            break;
        case LTY_COMPOSER_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_ALBUM;
            break;
        case LTY_COMPOSER_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_ALBUM_SONG;
            break;
        case LTY_COMPOSER_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_SONG;
            break;
        case LTY_VIDEO:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_VIDEO;
            break;
        case LTY_VIDEO_EPISODE:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_VIDEO_EPISODE;
            break;
        case LTY_PLAYLIST:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PLAYLIST;
            break;
        case LTY_PLAYLIST_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PLAYLIST_SONG;
            break;
        case LTY_IMAGE:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE;
            break;
        case LTY_IMAGE_FOLDER:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE_FOLDER;
            break;
        case LTY_IMAGE_FOLDER_ITEM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE_FOLDER_ITEM;
            break;
        case LTY_COMPILATION:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPILATION;
            break;
        case LTY_COMPILATION_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPILATION_SONG;
            break;
        case LTY_YEAR:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR;
            break;
        case LTY_YEAR_ALBUM:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR_ALBUM;
            break;
        case LTY_YEAR_ALBUM_SONG:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR_ALBUM_SONG;
            break;
        case LTY_CURRENT_SELECTION:
        case LTY_FILELIST:
        case LTY_FILELIST_MEDIAOBJECTS:
        case LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
        case LTY_MTP_FILELIST:
        case LTY_BLUETOOTH_FILELIST:
        case LTY_BROWSELIST:
        case LTY_BROWSELIST_MEDIAOBJECTS:
        case LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_CURRENT_SELECTION;
            break;
        default:
            mplayListType.enType = mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_SONG;
            ETG_TRACE_ERR(("Invalid list type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertListTypeToInternal(tListType &internalListType, const mplay_fi_tcl_e8_MPlayListType listType) //finished: 100%
{
    ENTRY_INTERNAL
    switch (listType.enType)
    {
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE:
            internalListType = LTY_GENRE;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST:
            internalListType = LTY_ARTIST;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ALBUM:
            internalListType = LTY_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ALBUM_SONG:
            internalListType = LTY_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_SONG:
            internalListType = LTY_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST:
            internalListType = LTY_GENRE_ARTIST;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_ALBUM:
            internalListType = LTY_GENRE_ARTIST_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_ALBUM_SONG:
            internalListType = LTY_GENRE_ARTIST_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ARTIST_SONG:
            internalListType = LTY_GENRE_ARTIST_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ALBUM:
            internalListType = LTY_GENRE_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_ALBUM_SONG:
            internalListType = LTY_GENRE_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_GENRE_SONG:
            internalListType = LTY_GENRE_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_ALBUM:
            internalListType = LTY_ARTIST_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_ALBUM_SONG:
            internalListType = LTY_ARTIST_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_ARTIST_SONG:
            internalListType = LTY_ARTIST_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PODCAST:
            internalListType = LTY_PODCAST;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PODCAST_EPISODE:
            internalListType = LTY_PODCAST_EPISODE;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUDIOBOOK:
            internalListType = LTY_AUDIOBOOK;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_BOOKTITLE_CHAPTER:
            internalListType = LTY_BOOKTITLE_CHAPTER;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR:
            internalListType = LTY_AUTHOR;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR_BOOKTITLE:
            internalListType = LTY_AUTHOR_BOOKTITLE;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_AUTHOR_BOOKTITLE_CHAPTER:
            internalListType = LTY_AUTHOR_BOOKTITLE_CHAPTER;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER:
            internalListType = LTY_COMPOSER;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_ALBUM:
            internalListType = LTY_COMPOSER_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_ALBUM_SONG:
            internalListType = LTY_COMPOSER_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPOSER_SONG:
            internalListType = LTY_COMPOSER_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_VIDEO:
            internalListType = LTY_VIDEO;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_VIDEO_EPISODE:
            internalListType = LTY_VIDEO_EPISODE;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PLAYLIST:
            internalListType = LTY_PLAYLIST;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_PLAYLIST_SONG:
            internalListType = LTY_PLAYLIST_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE:
            internalListType = LTY_IMAGE;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE_FOLDER:
            internalListType = LTY_IMAGE_FOLDER;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_IMAGE_FOLDER_ITEM:
            internalListType = LTY_IMAGE_FOLDER_ITEM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPILATION:
            internalListType = LTY_COMPILATION;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_COMPILATION_SONG:
            internalListType = LTY_COMPILATION_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR:
            internalListType = LTY_YEAR;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR_ALBUM:
            internalListType = LTY_YEAR_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_YEAR_ALBUM_SONG:
            internalListType = LTY_YEAR_ALBUM_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayListType::FI_EN_E8LTY_USER_FAVORITES_SONG:
            internalListType = LTY_USER_FAVORITES_SONG;
            break;
        default:
            internalListType = LTY_SONG;
            ETG_TRACE_ERR(("Invalid list type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertIndexingStateResultToMPLAY(mplay_fi_tcl_MPlayIndexingStateResultItem &mplayIndexingStateResult, const tIndexingStateResult indexingStateResult) //finished: 100 %
{
    ENTRY_INTERNAL;
    ConvertDeviceTagToMPLAY(mplayIndexingStateResult.u8DeviceTag, indexingStateResult.deviceID);
    ConvertIndexingStateToMPLAY(mplayIndexingStateResult.e8DeviceIndexedState, indexingStateResult.state);
    mplayIndexingStateResult.u8IndexingPercentComplete = indexingStateResult.percent;
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceTagToInternal(tDeviceID &deviceID, const tU8 u8DeviceTag) //finished: 100%
{
    ENTRY_INTERNAL
    deviceID = u8DeviceTag;
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceTagToMPLAY(tU8 &deviceTag, const tDeviceID deviceID) //finished: 100%
{
    ENTRY_INTERNAL
    if (deviceID > 255)
        deviceTag = 0;
    deviceTag = deviceID;
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertNowPlayingStateToMPLAY(mplay_fi_tcl_e8_MPlayNowPlayingState &mplayNowPlayingState, const tNowPlayingState nowPlayingState) //finished: 100%
{
    ENTRY_INTERNAL
    switch (nowPlayingState)
    {
        case NP_NEW_TRACK:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_NEW_TRACK;
            break;
        case NP_SAME_TRACK:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_SAME_TRACK;
            break;
        case NP_TRACK_START:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_TRACK_START;
            break;
        case NP_TRACK_COMPLETE:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_TRACK_COMPLETE;
            break;
        case NP_LIST_START:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_LIST_START;
            break;
        case NP_LIST_COMPLETE:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_LIST_COMPLETE;
            break;
        case NP_NO_DEVICE:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_NO_DEVICE;
            break;
        case NP_INVALID:
        default:
            mplayNowPlayingState.enType = mplay_fi_tcl_e8_MPlayNowPlayingState::FI_EN_E8NP_INVALID;
            ETG_TRACE_ERR(("Invalid now playing state type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceTypeToMPLAY(mplay_fi_tcl_e8_MPlayDeviceType &mplayDeviceType, const tDeviceType deviceType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(deviceType)
    {
        case DTY_UNKNOWN:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNKNOWN;
            break;
        case DTY_USB:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_USB;
            break;
        case DTY_IPOD:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPOD;
            break;
        case DTY_SD:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_SD;
            break;
        case DTY_BLUETOOTH:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_BLUETOOTH;
            break;
        case DTY_IPHONE:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPHONE;
            break;
        case DTY_MTP:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MTP;
            break;
        case DTY_MSZUNE:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNKNOWN;
            break;
        case DTY_CDROM:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDROM;
            break;
        case DTY_CDDA:  //TODO: Add new DTY_CDDA to FI und use it here instead of DTY_CDROM
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDDA;
            break;
        case DTY_DVD_DRIVE:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_DVD_DRIVE;
            break;
        case DTY_MUSICBOX:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MUSICBOX;
            break;
        case DTY_FLASH:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_FLASH;
            break;
        case DTY_UNSUPPORTED:
        case DTY_MYMEDIA:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNSUPPORTED;
            break;
        default:
            mplayDeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNKNOWN;
            VARTRACE(deviceType);
            ETG_TRACE_ERR(("Invalid device type"));
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertDiscTypeToMPLAY(mplay_fi_tcl_e8_MDiscType &mplayDiscType, const tDiscType discType)
{
    ENTRY_INTERNAL
    switch(discType)
    {
        case DISC_AUDIO_CD:
        case DISC_AUDIO_CD_WITH_TEXT:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8AUDIO_CD_DISC;
            break;
        case DISC_VCD_VER_1:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8VCD_VER1_DISC;
            break;
        case DISC_VCD_VER_2_PBC_OFF:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8VCD_VER2_DISC_PBC_OFF;
            break;
        case DISC_VCD_VER_2_PBC_ON:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8VCD_VER2_DISC_PBC_ON;
            break;
        case DISC_SUPER_VCD_PBC_OFF:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8SUPER_VCD_DISC_PBC_OFF;
            break;
        case DISC_SUPER_VCD_PBC_ON:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8SUPER_VCD_DISC_PBC_ON;
            break;
        case DISC_DVD_VIDEO:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8DVD_VIDEO_DISC;
            break;
        case DISC_DVD_AUDIO:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8DVD_AUDIO_DISC;
            break;
        case DISC_DVD_VR:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8DVD_VR_DISC;
            break;
        case DISC_DATA:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8DATA_DISC;
            break;
        default:
            mplayDiscType.enType = mplay_fi_tcl_e8_MDiscType::FI_EN_E8DVD_ERROR_DISC;
            ETG_TRACE_ERR(("Invalid DEVICE TYPE"));
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertConnectionStateToMPLAY(mplay_fi_tcl_e8_MPlayConnectionState &mplayDeviceConnectionState, const tConnectionState connectionState)
{
    ENTRY_INTERNAL
    switch(connectionState)
    {
        case CS_CONNECTED:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_CONNECTED;
            break;
        case CS_ATTACHED:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_ATTACHED;
            break;
        case CS_DISCONNECTED:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_DISCONNECTED;
            break;
        case CS_HW_MALFUNCTION:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_HW_MALFUNCTION;
            break;
        case CS_UNDERVOLTAGE:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNDERVOLTAGE;
            break;
        case CS_UNSUPPORTED:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNSUPPORTED;
            break;
        case CS_OVERTEMP:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_OVERTEMP;
            break;
        case CS_ON_HOLD:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_ON_HOLD;
            break;
        default:
            mplayDeviceConnectionState.enType = mplay_fi_tcl_e8_MPlayConnectionState::FI_EN_E8CS_UNDEFINED;
            VARTRACE(connectionState);
            ETG_TRACE_ERR(("Invalid connection State"));
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertQuickSearchResultToMPLAY(mplay_fi_tcl_e8_QuickSearchResult &QuickSearchResult, const tSearchResult quicksearchresult) //finished: 100%
{
    ENTRY_INTERNAL
    switch(quicksearchresult)
    {
        case FOUND:
            QuickSearchResult.enType = mplay_fi_tcl_e8_QuickSearchResult::FI_EN_E8FOUND;
            break;
        case FOLLOWING:
            QuickSearchResult.enType = mplay_fi_tcl_e8_QuickSearchResult::FI_EN_E8FOLLOWING;
            break;
        case ENDOFLIST:
            QuickSearchResult.enType = mplay_fi_tcl_e8_QuickSearchResult::FI_EN_E8ENDOFLIST;
            break;
        case NOTSUPPORTED:
            QuickSearchResult.enType = mplay_fi_tcl_e8_QuickSearchResult::FI_EN_E8NOTSUPPORTED;
            ETG_TRACE_ERR(("Unsupported List type"));
            break;
        default:
            QuickSearchResult.enType = mplay_fi_tcl_e8_QuickSearchResult::FI_EN_E8ENDOFLIST;
            ETG_TRACE_ERR(("Error"));
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertConnectionTypeToMPLAY(mplay_fi_tcl_e8_MPlayConnectionType &mplayConnectionType, const tConnectionType connectionType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(connectionType)
    {
        case DCT_UNKNOWN:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_UNKNOWN;
            break;
        case DCT_USB:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_USB;
            break;
        case DCT_BLUETOOTH:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_BLUETOOTH;
            break;
        case DCT_CDROM:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_CDROM;
            break;
        case DCT_FLASH:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_FLASH;
            break;
        default:
            mplayConnectionType.enType = mplay_fi_tcl_e8_MPlayConnectionType::FI_EN_E8DCT_UNKNOWN;
            VARTRACE(connectionType);
            ETG_TRACE_ERR(("Invalid connection type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceTypeToInternal(tDeviceType &deviceType, const mplay_fi_tcl_e8_MPlayDeviceType mplayDeviceType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(mplayDeviceType.enType)
    {
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNKNOWN:
            deviceType = DTY_UNKNOWN;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_USB:
            deviceType = DTY_USB;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPOD:
            deviceType = DTY_IPOD;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_SD:
            deviceType = DTY_SD;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_BLUETOOTH:
            deviceType = DTY_BLUETOOTH;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPHONE:
            deviceType = DTY_IPHONE;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MTP:
            deviceType = DTY_MTP;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDROM:
            deviceType = DTY_CDROM;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_FLASH:
            deviceType = DTY_FLASH;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_DVD_DRIVE:
            deviceType = DTY_DVD_DRIVE;
            break;
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MUSICBOX:
        deviceType = DTY_MUSICBOX;
        break;
#if 0 //TODO: Add new DTY_CDDA to FI und use it here
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDDA:
            deviceType = DTY_CDDA;
            break;
#endif
        case mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_UNSUPPORTED:
            deviceType = DTY_UNSUPPORTED;
            break;
        default:
            deviceType = DTY_UNKNOWN;
            ETG_TRACE_ERR(("Invalid device type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceFileFormatToMPLAY(mplay_fi_tcl_e8_MPlayFileFormat &mplayFileFormat, const tFileFormat fileFormat) //finished: 100%
{
    ENTRY_INTERNAL
    switch(fileFormat)
    {
        case FFT_MP3:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MP3;
            break;
        case FFT_WMA:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_WMA;
            break;
        case FFT_AAC:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_AAC;
            break;
        case FFT_AAC_PLUS:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_AAC_PLUS;
            break;
        case FFT_M4A:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M4A;
            break;
        case FFT_MP4:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MP4;
            break;
        case FFT_WAV:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_WAV;
            break;
        case FFT_OGG:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_OGG;
            break;
        case FFT_3GP:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_3GP;
            break;
        case FFT_3G2:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_3G2;
            break;
        case FFT_AIFF:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_AIFF;
            break;
        case FFT_AA:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_AA;
            break;
        case FFT_SBC:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_SBC;
            break;
        case FFT_MPEG:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MPEG;
            break;
        case FFT_AVI:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_AVI;
            break;
        case FFT_MOV:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MOV;
            break;
        case FFT_DIVX:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_DIVX;
            break;
        case FFT_WMV:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_WMV;
            break;
        case FFT_M4V:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M4V;
            break;
        case FFT_FLV:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_FLV;
            break;
        case FFT_M3U:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M3U;
            break;
        case FFT_PLS:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_PLS;
            break;
        case FFT_XSPF:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_XSPF;
            break;
        case FFT_WPL:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_WPL;
            break;
        case FFT_B4S:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_B4S;
            break;
        case FFT_ASX:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_ASX;
            break;
        case FFT_JPEG:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_JPEG;
            break;
        case FFT_GIF:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_GIF;
            break;
        case FFT_BMP:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_BMP;
            break;
        case FFT_PNG:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_PNG;
            break;
        case FFT_TIF:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_TIF;
            break;
        case FFT_FLAC:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_FLAC;
            break;
        case FFT_M4B:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M4B;
            break;
        case FFT_M4P:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M4P;
            break;
        case FFT_M4R:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_M4R;
            break;
        case FFT_MKV:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MKV;
            break;
        case FFT_UNKNOWN:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MP3;
            break;
        default:
            mplayFileFormat.enType = mplay_fi_tcl_e8_MPlayFileFormat::FI_EN_E8FFT_MP3;
            ETG_TRACE_ERR(("Invalid file format type"));
            break;

    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertMediaTypeToMPLAY(mplay_fi_tcl_e8_MPlayMediaType &mplayMediaType, const tMediaType mediaType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(mediaType)
    {
        case MTY_UNKNOWN:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_UNKNOWN;
            break;
        case MTY_MUSIC_FILE:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_MUSIC_FILE;
            break;
        case MTY_PODCAST:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_PODCAST;
            break;
        case MTY_AUDIOBOOK:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_AUDIOBOOK;
            break;
        case MTY_VIDEO:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_VIDEO;
            break;
        case MTY_PLAYLIST:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_PLAYLIST;
            break;
        case MTY_AUDIO_STREAM:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MRY_AUDIO_STREAM;
            break;
        case MTY_PLAYLIST_INTERNAL:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_PLAYLIST_INTERNAL;
            break;
        case MTY_IMAGE:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_IMAGE;
            break;
        default:
            mplayMediaType.enType = mplay_fi_tcl_e8_MPlayMediaType::FI_EN_E8MTY_UNKNOWN;
            ETG_TRACE_ERR(("Invalid media type"));
            break;

    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlayableStatusToMPLAY(mplay_fi_tcl_e8_MPlayPlayableStatus &mplayPlayableStatus, const tNotPlayable playable) //finished: 100%
{
    ENTRY_INTERNAL
    switch(playable)
    {
        case FNP_PLAYABLE:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_PLAYABLE;
            break;
        case FNP_FORMAT_ERROR:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_FORMAT_ERROR;
            break;
        case FNP_READ_ERROR:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_READ_ERROR;
            break;
        case FNP_NOT_PLAYABLE:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_NOT_PLAYABLE;
            break;
        case FNP_DRM_PROTECTED:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_DRM_PROTECTED;
            break;
        default:
            mplayPlayableStatus.enType = mplay_fi_tcl_e8_MPlayPlayableStatus::FI_EN_E8FP_PLAYABLE;
            ETG_TRACE_ERR(("Invalid playable status"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertAudioChannelFormatToMPLAY(mplay_fi_tcl_e8_MPlayAudioChannelFormat &mplayAudioChannelFormat, const tAudioChannelFormat audioChannelFormat) //finished: 100%
{
    ENTRY_INTERNAL
    switch(audioChannelFormat)
    {
        case ACF_UNKNOWN:
            mplayAudioChannelFormat.enType = mplay_fi_tcl_e8_MPlayAudioChannelFormat::FI_EN_E8ACF_UNKNOWN;
            break;
        case ACF_MONO:
            mplayAudioChannelFormat.enType = mplay_fi_tcl_e8_MPlayAudioChannelFormat::FI_EN_E8ACF_MONO;
            break;
        case ACF_STEREO:
            mplayAudioChannelFormat.enType = mplay_fi_tcl_e8_MPlayAudioChannelFormat::FI_EN_E8ACF_STEREO;
            break;
        default:
            mplayAudioChannelFormat.enType = mplay_fi_tcl_e8_MPlayAudioChannelFormat::FI_EN_E8ACF_UNKNOWN;
            ETG_TRACE_ERR(("Invalid audio channel format"));
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertMediaObjectToMPLAY(mplay_fi_tcl_MPlayMediaObject &mplayMediaObject, tMediaObject &mediaObject) //finished: 100%
{
    ENTRY_INTERNAL

    /* convert from genMP tag mapping to GM tag mapping */
    tMetadata resolution;
    MapTagsFromGenMP2GM(INOUT mediaObject, OUT resolution);

    mplayMediaObject.sAlbumArt.bSet(mediaObject.albumArtString, mplay_fi_tclString::FI_EN_UTF8);
    ConvertCategoryTypeToMPLAY(mplayMediaObject.e8CategoryType, mediaObject.catType);
    ConvertDeviceTagToMPLAY(mplayMediaObject.u8DeviceTag, mediaObject.deviceID);
    ConvertDeviceTypeToMPLAY(mplayMediaObject.e8DeviceType, mediaObject.deviceType);
    mplayMediaObject.sDeviceVersion.bSet(mediaObject.deviceVersion, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceFileFormatToMPLAY(mplayMediaObject.e8FileFormat, mediaObject.fileFormat);
    mplayMediaObject.sFilename.bSet(mediaObject.fileName, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.bIsPlaying = (tBool)mediaObject.isPlaying;
    ConvertMediaTypeToMPLAY(mplayMediaObject.e8MediaType, mediaObject.mediaType);
    mplayMediaObject.sMetaDataField1.bSet(mediaObject.MetadataField1, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField2.bSet(mediaObject.MetadataField2, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField3.bSet(mediaObject.MetadataField3, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField4.bSet(mediaObject.MetadataField4, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sYomiMetaDataTitle.bSet(mediaObject.YomiTitle, mplay_fi_tclString::FI_EN_UTF8); //for storing yomi metadata title
    mplayMediaObject.sYomiMetaDataArtist.bSet(mediaObject.YomiArtist, mplay_fi_tclString::FI_EN_UTF8);//for storing yomi metadata Artist
    mplayMediaObject.sYomiMetaDataAlbum.bSet(mediaObject.YomiAlbum, mplay_fi_tclString::FI_EN_UTF8); //for storing yomi metadata Album
    mplayMediaObject.u32MetaDataTag1 = mediaObject.MetadataTag1;
    mplayMediaObject.u32MetaDataTag2 = mediaObject.MetadataTag2;
    mplayMediaObject.u32MetaDataTag3 = mediaObject.MetadataTag3;
    mplayMediaObject.u32MetaDataTag4 = mediaObject.MetadataTag4;
    mplayMediaObject.u32Tag = mediaObject.objectID;
    mplayMediaObject.u32Year = mediaObject.year;
    mplayMediaObject.u32YearID = mediaObject.yearID;
    mplayMediaObject.u32TotalPlaytime = mediaObject.totalPlaytime/1000;
    if (mediaObject.trackNumber > 0xFFFF)
    {
        mplayMediaObject.u16ExtendedTrackNumber = 0xFFFF;
    }
    else
    {
        mplayMediaObject.u16ExtendedTrackNumber = mediaObject.trackNumber;
    }
    if (mediaObject.trackNumber > 0xFF)
    {
        mplayMediaObject.u8TrackNumber = 0;
    }
    else
    {
        mplayMediaObject.u8TrackNumber = mediaObject.trackNumber;
    }
    mplayMediaObject.u32BitRate = mediaObject.bitRate;
    mplayMediaObject.u32SampleRate = mediaObject.sampleRate;
    ConvertAudioChannelFormatToMPLAY(mplayMediaObject.e8AudioChannelFormat,mediaObject.audioChannelFormat);
    mplayMediaObject.bVBR = (tBool)mediaObject.vbr;
    ConvertPlayableStatusToMPLAY(mplayMediaObject.e8PlayableStatus, mediaObject.notPlayable);
    mplayMediaObject.u64FileSize = mediaObject.fileSize;
    mplayMediaObject.sDateTime.bSet(mediaObject.dateTime, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sResolution.bSet(resolution, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.bIsFavorite = (tBool)mediaObject.isFavorite;
}

void fc_mediaplayer_tclService_MediaPlayer::MapTagsFromGenMP2GM(tMediaObject &mediaObject, tMetadata &resolution)
{
    ENTRY;
    resolution[0] = '\0';

    /* convert the tags */
    switch(mediaObject.catType) {
        case CTY_ALBUM:
            mediaObject.MetadataTag3 = mediaObject.MetadataTag4;
            mediaObject.MetadataTag4 = 0;
            strncpy_r(OUT mediaObject.MetadataField3, IN mediaObject.MetadataField4, sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, IN "", sizeof(mediaObject.MetadataField4));
            break;
        case CTY_SONG:
            mediaObject.MetadataTag3 = mediaObject.MetadataTag4;
            mediaObject.MetadataTag4 = mediaObject.objectID; // song
            strncpy_r(OUT mediaObject.MetadataField3, IN mediaObject.MetadataField4, sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, IN mediaObject.title, sizeof(mediaObject.MetadataField4));
            break;
        case CTY_COMPOSER:
            mediaObject.MetadataTag1 = mediaObject.MetadataTag3;
            mediaObject.MetadataTag3 = 0;
            strncpy_r(OUT mediaObject.MetadataField1, IN mediaObject.MetadataField3, sizeof(mediaObject.MetadataField1));
            strncpy_r(OUT mediaObject.MetadataField3, IN "", sizeof(mediaObject.MetadataField3));
            break;
        case CTY_CHAPTER:
        case CTY_AUDIOBOOK:
            //case CTY_TITLE:
            mediaObject.MetadataTag3 = mediaObject.objectID; // chapter
            strncpy_r(OUT mediaObject.MetadataField3, IN mediaObject.title, sizeof(mediaObject.MetadataField3));
            break;
        case CTY_EPISODE:
        case CTY_VIDEO:
        case CTY_PODCAST:
            //case CTY_NAME:
            mediaObject.MetadataTag2 = mediaObject.objectID; // episode
            strncpy_r(OUT resolution, IN mediaObject.MetadataField2, sizeof(resolution));
            strncpy_r(OUT mediaObject.MetadataField2, IN mediaObject.title, sizeof(mediaObject.MetadataField2));
            break;
        case CTY_IMAGE:
            mediaObject.MetadataTag1 = mediaObject.objectID; // image
            strncpy_r(OUT resolution, IN mediaObject.MetadataField2, sizeof(resolution));
            strncpy_r(OUT mediaObject.MetadataField2, IN mediaObject.MetadataField1, sizeof(mediaObject.MetadataField2));
            strncpy_r(OUT mediaObject.MetadataField1, IN mediaObject.title, sizeof(mediaObject.MetadataField1));
            break;
        default:
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::MapTagsFromGM2GenMP(
        const tListType listType,
        tFilterTag1 &tag1,
        tFilterTag2 &tag2,
        tFilterTag3 &tag3,
        tFilterTag4 &tag4)
{
    ENTRY;

    /* special mapping between GM's strange tag maps to the logic one in the media player */
    switch(listType) {
        case LTY_COMPOSER_ALBUM_SONG:
            tag3.tag = tag1.tag; // composer
            tag1.tag = 0;
            tag4.tag = tag2.tag; // album
            tag2.tag = 0;
            break;
        case LTY_COMPOSER_ALBUM:
        case LTY_COMPOSER_SONG:
            tag3.tag = tag1.tag; // composer
            tag1.tag = 0;
            break;
        case LTY_ARTIST_ALBUM_SONG:
        case LTY_ALBUM_SONG:
        case LTY_GENRE_ALBUM_SONG:
        case LTY_YEAR_ALBUM_SONG:
        case LTY_GENRE_ARTIST_ALBUM_SONG:
        case LTY_COMPILATION_SONG:
            tag4.tag = tag3.tag; // album
            tag3.tag = 0;
            break;
        default:
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertMediaObjectsItemToMPLAY(mplay_fi_tcl_MPlayMediaObjectsItem &mplayMediaObject, tMediaObject mediaObject) //finished: 100%
{
    ENTRY_INTERNAL

    /* convert from genMP tag mapping to GM tag mapping */
    tMetadata resolution;
    MapTagsFromGenMP2GM(INOUT mediaObject, OUT resolution);

    mplayMediaObject.sAlbumArt.bSet(mediaObject.albumArtString, mplay_fi_tclString::FI_EN_UTF8);
    ConvertCategoryTypeToMPLAY(mplayMediaObject.e8CategoryType, mediaObject.catType);
    ConvertDeviceTagToMPLAY(mplayMediaObject.u8DeviceTag, mediaObject.deviceID);
    ConvertDeviceTypeToMPLAY(mplayMediaObject.e8DeviceType, mediaObject.deviceType);
    mplayMediaObject.sDeviceVersion.bSet(mediaObject.deviceVersion, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceFileFormatToMPLAY(mplayMediaObject.e8FileFormat, mediaObject.fileFormat);
    mplayMediaObject.sFilename.bSet(mediaObject.fileName, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.bIsPlaying = (tBool)mediaObject.isPlaying;
    ConvertMediaTypeToMPLAY(mplayMediaObject.e8MediaType, mediaObject.mediaType);
    mplayMediaObject.sMetaDataField1.bSet(mediaObject.MetadataField1, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField2.bSet(mediaObject.MetadataField2, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField3.bSet(mediaObject.MetadataField3, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sMetaDataField4.bSet(mediaObject.MetadataField4, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.sYomiMetaDataTitle.bSet(mediaObject.YomiTitle, mplay_fi_tclString::FI_EN_UTF8); //for storing yomi metadata title
    mplayMediaObject.sYomiMetaDataArtist.bSet(mediaObject.YomiArtist, mplay_fi_tclString::FI_EN_UTF8);//for storing yomi metadata Artist
    mplayMediaObject.sYomiMetaDataAlbum.bSet(mediaObject.YomiAlbum, mplay_fi_tclString::FI_EN_UTF8); //for storing yomi metadata Album
    mplayMediaObject.u32MetaDataTag1 = mediaObject.MetadataTag1;
    mplayMediaObject.u32MetaDataTag2 = mediaObject.MetadataTag2;
    mplayMediaObject.u32MetaDataTag3 = mediaObject.MetadataTag3;
    mplayMediaObject.u32MetaDataTag4 = mediaObject.MetadataTag4;
    mplayMediaObject.u32Tag = mediaObject.objectID;
    mplayMediaObject.u32Year = mediaObject.year;
    mplayMediaObject.u32YearID = mediaObject.yearID;
    mplayMediaObject.u32TotalPlaytime = mediaObject.totalPlaytime/1000;
    if (mediaObject.trackNumber > 0xFF)
    {
        mplayMediaObject.u8TrackNumber = 0;
    }
    else
    {
        mplayMediaObject.u8TrackNumber = mediaObject.trackNumber;
    }
    ConvertPlayableStatusToMPLAY(mplayMediaObject.e8PlayableStatus, mediaObject.notPlayable);
    mplayMediaObject.sCoverArt.bSet(mediaObject.coverArtString, mplay_fi_tclString::FI_EN_UTF8);
    mplayMediaObject.oThumbnailData.u8Items.resize(mediaObject.thumbnailBlob.imageSize);
    if (mediaObject.thumbnailBlob.imageSize > 0)
    {
        copy(mediaObject.thumbnailBlob.imageData, mediaObject.thumbnailBlob.imageData + mediaObject.thumbnailBlob.imageSize, mplayMediaObject.oThumbnailData.u8Items.begin());
    }
    mplayMediaObject.u64FileSize = mediaObject.fileSize;
    mplayMediaObject.sDateTime.bSet(mediaObject.dateTime, mplay_fi_tclString::FI_EN_UTF8);
    tBoolean bReadOnlyFlag;
    LocalSPM::GetDataProvider().GetReadOnlyFlag(OUT bReadOnlyFlag, IN mediaObject.fileMode, IN mediaObject.userID, IN mediaObject.groupID);
    mplayMediaObject.bReadOnlyFlag = (tBool)bReadOnlyFlag;
    mplayMediaObject.bIsFavorite = (tBool)mediaObject.isFavorite;
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackStateToMPLAY(mplay_fi_tcl_e8_MPlayState &mplayPlaybackstate, const tHMIPlaybackState playbackState)  //finished: 100%
{
    ENTRY_INTERNAL
    switch (playbackState)
    {
        case HMI_PBS_PLAYING:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_PLAYING;
            break;
        case HMI_PBS_PAUSED:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_PAUSED;
            break;
        case HMI_PBS_STOPPED:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_STOPPED;
            break;
        case HMI_PBS_FFWD:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_FFWD;
            break;
        case HMI_PBS_FREV:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_FREV;
            break;
        default:
            mplayPlaybackstate.enType = mplay_fi_tcl_e8_MPlayState::FI_EN_E8PBS_STOPPED;
            ETG_TRACE_ERR(("Invalid playback state type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackModeToMPLAY(mplay_fi_tcl_e8_MPlayMode &mplayPlaybackMode, const tPlaybackMode playbackMode) //finished: 100%
{
    ENTRY_INTERNAL
    switch (playbackMode)
    {
        case PBM_NORMAL:
            mplayPlaybackMode.enType = mplay_fi_tcl_e8_MPlayMode::FI_EN_E8PBM_NORMAL;
            break;
        case PBM_RANDOM:
            mplayPlaybackMode.enType = mplay_fi_tcl_e8_MPlayMode::FI_EN_E8PBM_RANDOM;
            break;
        default:
            mplayPlaybackMode.enType = mplay_fi_tcl_e8_MPlayMode::FI_EN_E8PBM_NORMAL;
            ETG_TRACE_ERR(("Invalid playback mode type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertRepeatModeToMPLAY(mplay_fi_tcl_e8_MPlayRepeat &mplayRepeatMode, const tRepeatMode repeatMode) //finished: 100%
{
    ENTRY_INTERNAL
    switch (repeatMode)
    {
        case RPT_NONE:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_NONE;
            break;
        case RPT_ONE:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ONE;
            break;
        case RPT_LIST:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_LIST;
            break;
        case RPT_LIST_WITH_SUBLISTS:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_LIST_WITH_SUBLISTS;
            break;
        case RPT_ALL_LISTS:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ALL_LISTS;
            break;
        case RPT_ALL:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_ALL;
            break;
        default:
            mplayRepeatMode.enType = mplay_fi_tcl_e8_MPlayRepeat::FI_EN_E8RPT_NONE;
            ETG_TRACE_ERR(("Invalid repeat mode type"));
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertIndexingStateToMPLAY(mplay_fi_tcl_e8_MPlayDeviceIndexedState &mplayIndexingState,  const tIndexingState indexedState) //finished: 100%
{
    ENTRY_INTERNAL
    switch(indexedState)
    {
        case IDS_NOT_SUPPORTED:
        case IDS_CURRENTLY_NOT_SUPPORTED:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_NOT_SUPPORTED;
            break;
        case IDS_NOT_STARTED:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_NOT_STARTED;
            break;
        case IDS_PARTIAL:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_PARTIAL;
            break;
        case IDS_COMPLETE:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_COMPLETE;
            break;
        case IDS_COMPLETE_FULL_DB:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_COMPLETE;
            break;
        default:
            mplayIndexingState.enType = mplay_fi_tcl_e8_MPlayDeviceIndexedState::FI_EN_E8IDS_NOT_SUPPORTED;
            ETG_TRACE_ERR(("Invalid indexing state type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceStateToMPLAY(mplay_fi_tcl_e8_MPlayDeviceStatus &mplayDeviceStatus,  const tDeviceState deviceState) //finished: 100%
{
    ENTRY_INTERNAL
    switch(deviceState)
    {
        case DS_NONE:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_NONE;
            break;
        case DS_INITIALIZING:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_INITIALIZING;
            break;
        case DS_OK:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_OK;
            break;
        case DS_UNSUPPORTED:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_UNSUPPORTED;
            break;
        case DS_UNSUPPORTED_FILESYSTEM:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_UNSUPPORTED_FILESYSTEM;
            break;
        case DS_UNSUPPORTED_PARTITION:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_UNSUPPORTED_PARTITION;
            break;
        case DS_COMMUNICATION_ERROR:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_COMMUNICATION_ERROR;
            break;
        default:
            mplayDeviceStatus.enType = mplay_fi_tcl_e8_MPlayDeviceStatus::FI_EN_E8DS_NONE;
            ETG_TRACE_ERR(("Invalid device state type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertFileSystemTypeToMPLAY(mplay_fi_tcl_e8_MPlayFileSystemType &mplayFileSystemType,  const tFileSystemType fileSystemType) //finished: 100%
{
    ENTRY_INTERNAL
    switch(fileSystemType)
    {
        case FSTY_UNKNOWN:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_UNKNOWN;
            break;
        case FSTY_FAT:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_FAT;
            break;
        case FSTY_NTFS:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_NTFS;
            break;
        case FSTY_EXT4:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_EXT4;
            break;
        case FSTY_HFS:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_HFS;
            break;
        case FSTY_EXFAT:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_EXFAT;
            break;
        case FSTY_UDF:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_UDF;
            break;
        case FSTY_ISO9660:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_ISO9660;
            break;
        default:
            mplayFileSystemType.enType = mplay_fi_tcl_e8_MPlayFileSystemType::FI_EN_E8FSTY_UNKNOWN;
            ETG_TRACE_ERR(("Invalid file system type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDisconnectReasonToMPLAY(mplay_fi_tcl_e8_MPlayDisconnectReason &mplayDisconnectReason, const tDisconnectReason disconnectReason) //finished: 100%
{
    ENTRY_INTERNAL
    switch (disconnectReason)
    {
        case DR_REMOVED:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_REMOVED;
            break;
        case DR_TEMPERATURE:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_TEMPERATURE;
            break;
        case DR_HW_MALFUNC:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_HW_MALFUNC;
            break;
        case DR_INTERNALDISCONNECT:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_INTERNALDISCONNECT;
            break;
        case DR_AVP_DISCONNECTED:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_AVP_DISCONNECTED;
            break;
        case DR_CONNECTED_OVER_USB:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_CONNECTED_OVER_USB;
            break;
        case DR_NOT_APPLICABLE:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_NOT_APPLICABLE;
            break;
        case DR_DEVICE_REQUEST:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_DEVICE_REQUEST;
            break;
        case DR_MODULE_REQUEST:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_MODULE_REQUEST;
            break;
        case DR_AUTOMATIC:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_AUTOMATIC;
            break;
        case DR_OUT_OF_RANGE:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_OUT_OF_RANGE;
            break;
        case DR_CONNECT_TIMEOUT:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_CONNECT_TIMEOUT;
            break;
        case DR_CONNECT_REJECTED:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_CONNECT_REJECTED;
            break;
        case DR_PROTOCOL_NOT_SUPPORTED:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_PROTOCOL_NOT_SUPPORTED;
            break;
        case DR_CONNECT_FAILED:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_CONNECT_FAILED;
            break;
        default:
            mplayDisconnectReason.enType = mplay_fi_tcl_e8_MPlayDisconnectReason::FI_EN_E8DR_REMOVED;
            ETG_TRACE_ERR(("Invalid disconnect reason"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertDeviceInfoToMPLAY(mplay_fi_tcl_MPlayDeviceInfoItem &mplayDeviceInfo, const tDeviceInfo &deviceInfo) //finished: 100%
{
    ENTRY_INTERNAL
    ConvertDeviceTagToMPLAY(mplayDeviceInfo.u8DeviceTag, deviceInfo.deviceID);
    mplayDeviceInfo.sDeviceName.bSet(deviceInfo.deviceName, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceTypeToMPLAY(mplayDeviceInfo.e8DeviceType,deviceInfo.deviceType);
    mplayDeviceInfo.sDeviceSerialNumber.bSet(deviceInfo.serialNumber, mplay_fi_tclString::FI_EN_UTF8);
    mplayDeviceInfo.bDeviceConnected = (tBool)deviceInfo.connected;
    ConvertIndexingStateToMPLAY(mplayDeviceInfo.e8DeviceIndexedState,deviceInfo.indexedState);
    mplayDeviceInfo.bDeviceActiveSource = (tBool)deviceInfo.activeSource;
    if(deviceInfo.numberOfVideoFiles != -1)
        mplayDeviceInfo.u32NumberOfVideoFiles = deviceInfo.numberOfVideoFiles;
    else
        mplayDeviceInfo.u32NumberOfVideoFiles = 0;
    if(deviceInfo.numberOfImageFiles != -1)
        mplayDeviceInfo.u32NumberOfImageFiles = deviceInfo.numberOfImageFiles;
    else
        mplayDeviceInfo.u32NumberOfImageFiles = 0;
    if(deviceInfo.numberOfAudioFiles != -1) /*For HMI we need to send total count of files.Hence add Audio, Video and Image file count and send */
        mplayDeviceInfo.u32NumberOfFiles = deviceInfo.numberOfAudioFiles + mplayDeviceInfo.u32NumberOfVideoFiles + mplayDeviceInfo.u32NumberOfImageFiles;
    else
        mplayDeviceInfo.u32NumberOfFiles =  mplayDeviceInfo.u32NumberOfVideoFiles + mplayDeviceInfo.u32NumberOfImageFiles;


    ConvertDeviceStateToMPLAY(mplayDeviceInfo.e8DeviceState, deviceInfo.deviceState);
    ConvertFileSystemTypeToMPLAY(mplayDeviceInfo.e8FileSystemType, deviceInfo.fileSystemType);
    mplayDeviceInfo.u32PartitionNumber = deviceInfo.partitionNumber;
    mplayDeviceInfo.u32TotalSize = deviceInfo.totalSize;
    mplayDeviceInfo.u32FreeSize = deviceInfo.freeSize;
    ConvertConnectionTypeToMPLAY(mplayDeviceInfo.e8ConnectionType, deviceInfo.connectionType);
    mplayDeviceInfo.sLastPlayedFile.bSet(deviceInfo.lastPlayedFile, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDisconnectReasonToMPLAY(mplayDeviceInfo.e8DisconnectReason, deviceInfo.disconnectReason);
    mplayDeviceInfo.sDeviceVersion.bSet(deviceInfo.deviceVersion, mplay_fi_tclString::FI_EN_UTF8);
    mplayDeviceInfo.bShuffleSupported = true;
    mplayDeviceInfo.bRepeatSupported  = true;
    mplayDeviceInfo.sMountPoint.bSet(deviceInfo.mountPoint, mplay_fi_tclString::FI_EN_UTF8);
    mplayDeviceInfo.bIsNowPlayingListAvailable = (tBool)deviceInfo.isNowPlayingListAvailable;
    ConvertConnectionStateToMPLAY(mplayDeviceInfo.e8ConnectionState , deviceInfo.connectionState);
    ConvertDiscTypeToMPLAY(mplayDeviceInfo.e8DiscType , deviceInfo.discType);
    mplayDeviceInfo.sDeviceSysPath.bSet(deviceInfo.deviceSyspath, mplay_fi_tclString::FI_EN_UTF8);


    //For :15001_AVRCP_Device_Playback_Control -Start

    /*By Default, Browsing=YES  for BTAVRCP 1.4(but may get changed based on Browse support by Player), USB, IPOD ,MTP Devices.
      By Default, ShuffleSupport=YES, RepeatSupport=YES  for BTAVRCP(but may get changed based on support by Player or DeviceVersion), USB, IPOD ,MTP Devices*/
    mplayDeviceInfo.e8DeviceControlSupport.enType = mplay_fi_tcl_e8_MPlayDeviceControlSupport::FI_EN_E8DCS_BROWSING;

    if (LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        mplayDeviceInfo.bShuffleSupported = (tBool)deviceInfo.isShuffleSupported;
        mplayDeviceInfo.bRepeatSupported  = (tBool)deviceInfo.isRepeatSupported;

        if(DTY_BLUETOOTH  == deviceInfo.deviceType)
        {
            if("1.0" == string(deviceInfo.deviceVersion))
            {
                /* BTAVRCP1.0 and further streaming devices.Is Metadata of NowPlaying supported=NO,Is track time uptate of NowPlaying supported =NO,Browsing=NO*/
                mplayDeviceInfo.e8DeviceControlSupport.enType = mplay_fi_tcl_e8_MPlayDeviceControlSupport::FI_EN_E8DCS_NO_METADATA;
            }
            else if("1.3" == string(deviceInfo.deviceVersion))
            {
                /* BTAVRCP1.3, and maybe further streaming devices.Is Metadata of NowPlaying supported=YES,Is track time uptate of NowPlaying supported =YES,Browsing=NO*/
                mplayDeviceInfo.e8DeviceControlSupport.enType = mplay_fi_tcl_e8_MPlayDeviceControlSupport::FI_EN_E8DCS_METADATA;
            }
        }
    }
    //For :15001_AVRCP_Device_Playback_Control - End

    //For 15008_SCAN
    mplayDeviceInfo.bScanSupported =  LocalSPM::GetDataProvider().TrackScanningSupported() && LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceInfo.deviceType);

    //Support of arl_tenAvailabilityReason also in MPlay_FI (NCG3D-11203 and NCG3D-9781)
    if ((deviceInfo.numberOfAudioFiles == 0) && (deviceInfo.deviceType != DTY_BLUETOOTH))
    {
        mplayDeviceInfo.e8AvailabilityReason.enType = mplay_fi_tcl_e8_MPlayAvailabilityReason::FI_EN_E8AR_NO_CONTENT;
    }
    if ((deviceInfo.connectionState == CS_CONNECTED) && (deviceInfo.formerConnectionState == CS_CONNECTED))
    {
        mplayDeviceInfo.e8AvailabilityReason.enType = mplay_fi_tcl_e8_MPlayAvailabilityReason::FI_EN_E8AR_SAME_MEDIA;
    }
    else
    {
        mplayDeviceInfo.e8AvailabilityReason.enType = mplay_fi_tcl_e8_MPlayAvailabilityReason::FI_EN_E8AR_NEW_MEDIA;
    }

    ETG_TRACE_USR4(("mplayDeviceInfo.bShuffleSupported:%d,mplayDeviceInfo.bRepeatSupported:%d,mplayDeviceInfo.bScanSupported:%d",mplayDeviceInfo.bShuffleSupported,mplayDeviceInfo.bRepeatSupported,mplayDeviceInfo.bScanSupported));
    ETG_TRACE_USR4(("mplayDeviceInfo.e8DeviceControlSupport.enType:%d",mplayDeviceInfo.e8DeviceControlSupport.enType));
    ETG_TRACE_USR4(("mplayDeviceInfo.u32NumberOfFiles:%d, mplayDeviceInfo.u32NumberOfVideoFiles:%d, mplayDeviceInfo.u32NumberOfImageFiles:%d ", mplayDeviceInfo.u32NumberOfFiles, mplayDeviceInfo.u32NumberOfVideoFiles, mplayDeviceInfo.u32NumberOfImageFiles ));

}


void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackActionToInternal(tPlaybackAction &internalPlaybackAction, const mplay_fi_tcl_e8_MPlayAction playbackAction) //finished: 100%
{
    ENTRY_INTERNAL
    switch(playbackAction.enType)
    {
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_PLAY:
            internalPlaybackAction = PBA_PLAY;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_PAUSE:
            internalPlaybackAction = PBA_PAUSE;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_STOP:
            internalPlaybackAction = PBA_STOP;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_PREV:
            internalPlaybackAction = PBA_PREV;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_NEXT:
            internalPlaybackAction = PBA_NEXT;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FREV_START:
            internalPlaybackAction = PBA_FREV_START;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FREV_STOP:
            internalPlaybackAction = PBA_FREV_STOP;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FFWD_START:
            internalPlaybackAction = PBA_FFWD_START;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FFWD_STOP:
            internalPlaybackAction = PBA_FFWD_STOP;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FOLDER_UP:
            internalPlaybackAction = PBA_FOLDER_UP;
            break;
        case mplay_fi_tcl_e8_MPlayAction::FI_EN_E8PBA_FOLDER_DOWN:
            internalPlaybackAction = PBA_FOLDER_DOWN;
            break;
        default:
            internalPlaybackAction = PBA_PLAY;
            ETG_TRACE_ERR(("Invalid play action type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackDirectionToInternal(tPEPlaybackDirection &internalPlaybackDirection, const mplay_fi_tcl_e8_MPlaybackDirection playbackDirection)
{
    ENTRY_INTERNAL
    switch(playbackDirection.enType)
    {
        case mplay_fi_tcl_e8_MPlaybackDirection::FI_EN_E8PBK_FORWARD:
            internalPlaybackDirection = PBK_FORWARD;
            break;
        case mplay_fi_tcl_e8_MPlaybackDirection::FI_EN_E8PBK_BACKWARD:
            internalPlaybackDirection = PBK_BACKWARD;
            break;
        default:
            internalPlaybackDirection = PBK_FORWARD;
            ETG_TRACE_ERR(("Invalid playback direction type"));
            break;

    }

}
void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackDirectionToMPLAY(mplay_fi_tcl_e8_MPlaybackDirection &mPlaybackDirection,const tPEPlaybackDirection playbackDirection)
{
    ENTRY_INTERNAL
    switch(playbackDirection)
    {
        case PBK_FORWARD:
            mPlaybackDirection.enType = mplay_fi_tcl_e8_MPlaybackDirection::FI_EN_E8PBK_FORWARD;
        break;
        case PBK_BACKWARD:
            mPlaybackDirection.enType = mplay_fi_tcl_e8_MPlaybackDirection::FI_EN_E8PBK_BACKWARD;
            break;
        default:
            mPlaybackDirection.enType = mplay_fi_tcl_e8_MPlaybackDirection::FI_EN_E8PBK_FORWARD;
            ETG_TRACE_ERR(("Invalid playbackdirection type"));
            break;
    }

}
void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackSpeedToInternal(tPlaybackSpeed &internalPlaybackSpeed, const mplay_fi_tcl_e8_MPlaybackSpeed playbackSpeed)
{
    ENTRY_INTERNAL
    switch(playbackSpeed.enType)
    {
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_0_2X:
            internalPlaybackSpeed = PBK_SPEED_0_2X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_0_5X:
            internalPlaybackSpeed = PBK_SPEED_0_5X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_1X:
            internalPlaybackSpeed = PBK_SPEED_1X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_2X:
            internalPlaybackSpeed = PBK_SPEED_2X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_4X:
            internalPlaybackSpeed = PBK_SPEED_4X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_8X:
            internalPlaybackSpeed = PBK_SPEED_8X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_16X:
            internalPlaybackSpeed = PBK_SPEED_16X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_32X:
            internalPlaybackSpeed = PBK_SPEED_32X;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_INCREASE:
            internalPlaybackSpeed = PBK_SPEED_INCREASE;
            break;
        case mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_DECREASE:
            internalPlaybackSpeed = PBK_SPEED_DECREASE;
            break;
        default:
            internalPlaybackSpeed = PBK_SPEED_1X;
            ETG_TRACE_ERR(("Invalid playback direction type"));
            break;

    }

}
void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackSpeedToMPLAY(mplay_fi_tcl_e8_MPlaybackSpeed &mPlaybackSpeed,const tPlaybackSpeed playbackSpeed )
{
    ENTRY_INTERNAL
    switch(playbackSpeed)
    {
        case PBK_SPEED_0_2X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_0_2X;
        break;
        case PBK_SPEED_0_5X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_0_5X;
            break;
        case PBK_SPEED_1X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_1X;
        break;
        case PBK_SPEED_2X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_2X;
            break;
        case PBK_SPEED_4X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_4X;
        break;
        case PBK_SPEED_8X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_8X;
            break;
        case PBK_SPEED_16X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_16X;
                        break;
        case PBK_SPEED_32X:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_32X;
                        break;
        case PBK_SPEED_INCREASE:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_INCREASE;
            break;
        case PBK_SPEED_DECREASE:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_DECREASE;
            break;
        default:
            mPlaybackSpeed.enType = mplay_fi_tcl_e8_MPlaybackSpeed::FI_EN_E8PBK_SPEED_1X;
            ETG_TRACE_ERR(("Invalid mPlaybackSpeed type"));
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertFileItemToMPLAY(mplay_fi_tcl_MPlayFileListItem &mplayFileItem, const tFiles item)  //finished: 100 %
{
    ENTRY_INTERNAL
    ConvertFileTypeToMPLAY(mplayFileItem.e8FileType, item.type);
    mplayFileItem.u8TrackNumber = item.trackNumber;
    mplayFileItem.u32Tag = item.objectID;
    mplayFileItem.sFilename.bSet(item.fileName, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceFileFormatToMPLAY(mplayFileItem.e8FileFormat,item.fileFormat);
    mplayFileItem.bIsPlaying = (tBool)item.isPlaying;
    mplayFileItem.bReadOnlyFlag = item.readOnlyFlag;
    mplayFileItem.sDateTime.bSet(item.dateTime, mplay_fi_tclString::FI_EN_UTF8);
    mplayFileItem.u32TotalPlaytime = item.playTime/1000;
    mplayFileItem.u64FileSize = item.fileSize;
    ConvertPlayableStatusToMPLAY(mplayFileItem.e8PlayableStatus, item.notPlayable);
    mplayFileItem.sCoverArt.bSet(item.coverArtString, mplay_fi_tclString::FI_EN_UTF8);

}


void fc_mediaplayer_tclService_MediaPlayer::ConvertFileTypeToMPLAY(mplay_fi_tcl_e8_MPlayFileType &mplayFileType, tFileType type) //finished: 100%
{
    ENTRY_INTERNAL
    switch (type)
    {
        case FT_FOLDER:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_FOLDER;
            break;
        case FT_AUDIO:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_AUDIO;
            break;
        case FT_VIDEO:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_VIDEO;
            break;
        case FT_PLAYLIST:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_PLAYLIST;
            break;
        case FT_IMAGE:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_IMAGE;
            break;
        case FT_UNKNOWN:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_AUDIO;
            break;
        default:
            mplayFileType.enType = mplay_fi_tcl_e8_MPlayFileType::FI_EN_E8FT_AUDIO;
            ETG_TRACE_ERR(("Invalid file type"));
            break;

    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertFileTypeToInternal(tFileTypeSelection &filetypeSelection, mplay_fi_tcl_e8_MPlayFileTypeSelection mplayFiletypeSelection) //finished: 100%
{
    ENTRY_INTERNAL
    switch (mplayFiletypeSelection.enType)
    {
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_AUDIO_VIDEO_PLAYLIST:
            filetypeSelection = FTS_AUDIO_VIDEO_PLAYLIST;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_AUDIO:
            filetypeSelection = FTS_AUDIO;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_VIDEO:
            filetypeSelection = FTS_VIDEO;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_PLAYLIST:
            filetypeSelection = FTS_PLAYLIST;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_IMAGE:
            filetypeSelection = FTS_IMAGE;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_AUDIO_PLAYLIST:
            filetypeSelection = FTS_AUDIO_PLAYLIST;
            break;
        case mplay_fi_tcl_e8_MPlayFileTypeSelection::FI_EN_E8FTS_ALL:
            filetypeSelection = FTS_ALL;
            break;
        default:
            filetypeSelection = FTS_AUDIO_VIDEO_PLAYLIST;
            ETG_TRACE_ERR(("Invalid file type selection"));
            break;

    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaypointFormatToInternal(tPlaypointFormat &internalPlaypointFormat, const mplay_fi_tcl_e8_MPlayPlaypointFormat playpointFormat)
{
    ENTRY_INTERNAL
    switch(playpointFormat.enType)
    {
        case mplay_fi_tcl_e8_MPlayPlaypointFormat::FI_EN_E8PPF_PERCENTAGE:
            internalPlaypointFormat = PPF_PERCENTAGE;
            break;
        case mplay_fi_tcl_e8_MPlayPlaypointFormat::FI_EN_E8PPF_ABSOLUTE:
            internalPlaypointFormat = PPF_ABSOLUTE;
            break;
        default:
            internalPlaypointFormat = PPF_ABSOLUTE;
            ETG_TRACE_ERR(("Invalid playpoint format type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertAutoPlayToPlayContinuation(tPlayContinuation &playContinuation, const tBool autoPlay)  //finished: 100 %
{
    ENTRY_INTERNAL
    if (FALSE == autoPlay)
    {
        playContinuation = PC_NO_REPEAT;
    }
    else
    {
        playContinuation = PC_STEPUP_ONE_LEVEL;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertCategoryTypeToInternal(tCategoryType &categoryType, const mplay_fi_tcl_e8_MPlayCategoryType mplayCategoryType)
{
    ENTRY_INTERNAL
    switch(mplayCategoryType.enType)
    {
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_NONE:
            categoryType = CTY_NONE;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_GENRE:
            categoryType = CTY_GENRE;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_ARTIST:
            categoryType = CTY_ARTIST;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_ALBUM:
            categoryType = CTY_ALBUM;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_SONG:
            categoryType = CTY_SONG;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_COMPOSER:
            categoryType = CTY_COMPOSER;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_AUTHOR:
            categoryType = CTY_AUTHOR;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_TITLE:
            categoryType = CTY_TITLE;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_CHAPTER:
            categoryType = CTY_CHAPTER;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_NAME:
            categoryType = CTY_NAME;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_EPISODE:
            categoryType = CTY_EPISODE;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_PLAYLIST:
            categoryType = CTY_PLAYLIST;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_PLAYLIST_INTERNAL:
            categoryType = CTY_PLAYLIST_INTERNAL;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_IMAGE:
            categoryType = CTY_IMAGE;
            break;
        case mplay_fi_tcl_e8_MPlayCategoryType::FI_EN_E8CTY_YEAR:
            categoryType = CTY_YEAR;
            break;
        default:
            categoryType = CTY_NONE;
            ETG_TRACE_ERR(("Invalid category type"));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertLanguageTypeToInternal(tLanguageType &internalLanguageType, const mplay_fi_tcl_e8_MPlayLanguage languageType) //finished: 100%
{
    ENTRY_INTERNAL
    switch (languageType.enType)
    {
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_ENGLISH:
            internalLanguageType = LNG_NA_ENGLISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_GERMAN:
            internalLanguageType = LNG_GERMAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ITALIAN:
            internalLanguageType = LNG_ITALIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SWEDISH:
            internalLanguageType = LNG_SWEDISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_FRENCH:
            internalLanguageType = LNG_FRENCH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SPANISH:
            internalLanguageType = LNG_SPANISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_DUTCH:
            internalLanguageType = LNG_DUTCH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_PORTUGUESE:
            internalLanguageType = LNG_PORTUGUESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NORWEGIAN:
            internalLanguageType = LNG_NORWEGIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_FINNISH:
            internalLanguageType = LNG_FINNISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_DANISH:
            internalLanguageType = LNG_DANISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_GREEK:
            internalLanguageType = LNG_GREEK;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_JAPANESE:
            internalLanguageType = LNG_JAPANESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ARABIC:
            internalLanguageType = LNG_ARABIC;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_STANDARD_CHINESE:
            internalLanguageType = LNG_STANDARD_CHINESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_POLISH:
            internalLanguageType = LNG_POLISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_TURKISH:
            internalLanguageType = LNG_TURKISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_KOREAN:
            internalLanguageType = LNG_KOREAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_TRADITIONAL_CHINESE:
            internalLanguageType = LNG_TRADITIONAL_CHINESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_UK_ENGLISH:
            internalLanguageType = LNG_UK_ENGLISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_HUNGARIAN:
            internalLanguageType = LNG_HUNGARIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CZECH:
            internalLanguageType = LNG_CZECH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SLOVAK:
            internalLanguageType = LNG_SLOVAK;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_RUSSIAN:
            internalLanguageType = LNG_RUSSIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_BRAZILIAN_PORTUGUESE:
            internalLanguageType = LNG_BRAZILIAN_PORTUGUESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_THAI:
            internalLanguageType = LNG_THAI;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_BULGARIAN:
            internalLanguageType = LNG_BULGARIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ROMANIAN:
            internalLanguageType = LNG_ROMANIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SLOVENIAN:
            internalLanguageType = LNG_SLOVENIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CROATIAN:
            internalLanguageType = LNG_CROATIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_UKRAINIAN:
            internalLanguageType = LNG_UKRAINIAN;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_FRENCH:
            internalLanguageType = LNG_NA_FRENCH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_SPANISH:
            internalLanguageType = LNG_NA_SPANISH;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CANTONESE:
            internalLanguageType = LNG_CANTONESE;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_HEBREW:
            internalLanguageType = LNG_HEBREW;
            break;
        case mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_DEVANAGARI:
            internalLanguageType = LNG_DEVANAGARI;
            break;
        default:
            internalLanguageType = LNG_NA_ENGLISH;
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertLanguageTypeToMPLAY(mplay_fi_tcl_e8_MPlayLanguage &mplayLanguage, tLanguageType language) //finished: 100%
{
    ENTRY_INTERNAL
    switch (language)
    {
        case LNG_NA_ENGLISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_ENGLISH;
            break;
        case LNG_GERMAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_GERMAN;
            break;
        case LNG_ITALIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ITALIAN;
            break;
        case LNG_SWEDISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SWEDISH;
            break;
        case LNG_FRENCH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_FRENCH;
            break;
        case LNG_SPANISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SPANISH;
            break;
        case LNG_DUTCH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_DUTCH;
            break;
        case LNG_PORTUGUESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_PORTUGUESE;
            break;
        case LNG_NORWEGIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NORWEGIAN;
            break;
        case LNG_FINNISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_FINNISH;
            break;
        case LNG_DANISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_DANISH;
            break;
        case LNG_GREEK:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_GREEK;
            break;
        case LNG_JAPANESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_JAPANESE;
            break;
        case LNG_ARABIC:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ARABIC;
            break;
        case LNG_STANDARD_CHINESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_STANDARD_CHINESE;
            break;
        case LNG_POLISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_POLISH;
            break;
        case LNG_TURKISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_TURKISH;
            break;
        case LNG_KOREAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_KOREAN;
            break;
        case LNG_TRADITIONAL_CHINESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_TRADITIONAL_CHINESE;
            break;
        case LNG_UK_ENGLISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_UK_ENGLISH;
            break;
        case LNG_HUNGARIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_HUNGARIAN;
            break;
        case LNG_CZECH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CZECH;
            break;
        case LNG_SLOVAK:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SLOVAK;
            break;
        case LNG_RUSSIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_RUSSIAN;
            break;
        case LNG_BRAZILIAN_PORTUGUESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_BRAZILIAN_PORTUGUESE;
            break;
        case LNG_THAI:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_THAI;
            break;
        case LNG_BULGARIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_BULGARIAN;
            break;
        case LNG_ROMANIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_ROMANIAN;
            break;
        case LNG_SLOVENIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_SLOVENIAN;
            break;
        case LNG_CROATIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CROATIAN;
            break;
        case LNG_UKRAINIAN:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_UKRAINIAN;
            break;
        case LNG_NA_FRENCH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_FRENCH;
            break;
        case LNG_NA_SPANISH:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_SPANISH;
            break;
        case LNG_CANTONESE:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_CANTONESE;
            break;
        default:
            mplayLanguage.enType = mplay_fi_tcl_e8_MPlayLanguage::FI_EN_E8LANGUAGE_SELECTION_NA_ENGLISH;
            break;
    }
}

#if USE_IMAGE_OBJECT
void fc_mediaplayer_tclService_MediaPlayer::ConvertImageObjectItemToMPLAY(mplay_fi_tcl_MPlayImageObjectItem &mplayImageObjectItem, tImageObject &ImageObject) //finished: 100%
{
    ENTRY_INTERNAL
    ConvertFileTypeToMPLAY(mplayImageObjectItem.e8FileType, ImageObject.type);
    mplayImageObjectItem.sFolderTitle.bSet(ImageObject.folderTitle, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.u32NumberOfImages = ImageObject.numberofImages;
#if IMAGE_ATTRIBUTES_IN_METADATA
    mplayImageObjectItem.sImageSize.bSet(ImageObject.imageSize, mplay_fi_tclString::FI_EN_UTF8);
#else
    tMetadata imageSize;
    snprintf(imageSize, sizeof(imageSize) - 1, "%llu", mediaObject.fileSize);
    mplayImageObjectItem.sImageSize.bSet(imageSize, mplay_fi_tclString::FI_EN_UTF8);
#endif
    mplayImageObjectItem.sDateTime.bSet(ImageObject.dateTime, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sDimension.bSet(ImageObject.dimension, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sResolution.bSet(ImageObject.resolution, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceFileFormatToMPLAY(mplayImageObjectItem.e8FileFormat, ImageObject.fileFormat);
    mplayImageObjectItem.u32Tag = ImageObject.objectID;
    mplayImageObjectItem.sImageTitle.bSet(ImageObject.imageTitle, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sPath.bSet(ImageObject.path, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sImageFile.bSet(ImageObject.imageFile, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceTagToMPLAY(mplayImageObjectItem.u8DeviceTag, ImageObject.deviceID);
    mplayImageObjectItem.sMountPoint.bSet(ImageObject.mountPoint, mplay_fi_tclString::FI_EN_UTF8);
}
#else
void fc_mediaplayer_tclService_MediaPlayer::ConvertImageObjectItemToMPLAY(mplay_fi_tcl_MPlayImageObjectItem &mplayImageObjectItem, tMediaObject &mediaObject) //finished: 100%
{
    ENTRY_INTERNAL
    ConvertFileTypeToMPLAY(mplayImageObjectItem.e8FileType, mediaObject.fileType);
    mplayImageObjectItem.u32NumberOfImages = 0;
    if (FT_FOLDER == mediaObject.fileType)
    {
        tNumberOfMediaObjects numberOfImages = 0;
        tResult result = MediaPlayerInterface::GetInstance().GetNumberOfImagesByPath(OUT numberOfImages, IN mediaObject.deviceID, IN mediaObject.path);
        if (0 == result)
        {
            mplayImageObjectItem.u32NumberOfImages = numberOfImages;
        }
    }

    if (strncmp(mediaObject.path, PATH_DELIMITER, strlen_r(mediaObject.path)))
    {
        tUInt len = strlen_r(mediaObject.path);
        if (len)
        {
            tPath folderTitle;
            strncpy_r(OUT folderTitle, IN  mediaObject.path, IN sizeof(mediaObject.path));
            folderTitle[len - 1] = '\0';
            string path(folderTitle);
            tS32 found = path.find_last_of(PATH_DELIMITER);

            if (INVALID_PATH != found)
            {
                VARTRACE(found);
                mplayImageObjectItem.sFolderTitle.bSet((path.substr(found + 1)).c_str(), mplay_fi_tclString::FI_EN_UTF8);
            }
            else
            {
                ETG_TRACE_ERR(("Path without / is invalid : %s", mediaObject.path));
            }
        }
        else
        {
            ETG_TRACE_ERR(("%s is not a valid path", mediaObject.path));
        }
    }
    else
    {
        mplayImageObjectItem.sFolderTitle.bSet(mediaObject.path, mplay_fi_tclString::FI_EN_UTF8);
    }

#if IMAGE_ATTRIBUTES_IN_METADATA
    mplayImageObjectItem.sImageSize.bSet(mediaObject.MetadataField1, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sDateTime.bSet(mediaObject.MetadataField2, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sDimension.bSet(mediaObject.MetadataField3, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sResolution.bSet(mediaObject.MetadataField4, mplay_fi_tclString::FI_EN_UTF8);
#else
    tMetadata imageSize;
    snprintf(imageSize, sizeof(imageSize) - 1, "%llu", mediaObject.fileSize);
    mplayImageObjectItem.sImageSize.bSet(imageSize, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sDateTime.bSet(mediaObject.dateTime, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sDimension.bSet(mediaObject.MetadataField2, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sResolution.bSet(mediaObject.MetadataField1, mplay_fi_tclString::FI_EN_UTF8);
#endif
    ConvertDeviceFileFormatToMPLAY(mplayImageObjectItem.e8FileFormat, mediaObject.fileFormat);
    mplayImageObjectItem.u32Tag = mediaObject.objectID;
    mplayImageObjectItem.sImageTitle.bSet(mediaObject.title, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sPath.bSet(mediaObject.path, mplay_fi_tclString::FI_EN_UTF8);
    mplayImageObjectItem.sImageFile.bSet(mediaObject.fileName, mplay_fi_tclString::FI_EN_UTF8);
    ConvertDeviceTagToMPLAY(mplayImageObjectItem.u8DeviceTag, mediaObject.deviceID);
    mplayImageObjectItem.sMountPoint.bSet(mediaObject.mountPoint, mplay_fi_tclString::FI_EN_UTF8);
}
#endif

/******************************************************************************/
/*                                                                            */
/* Internal post functions                                                    */
/*                                                                            */
/******************************************************************************/

tVoid fc_mediaplayer_tclService_MediaPlayer::vPostResult(mplay_mediaplayerfi_tclMsgBaseMessage &rBaseMessage, amt_tclServiceData &rServiceMethodStart,
        tU8 u8Opcode /*t=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT*/) //finished: 100%
{
    // Create FI VisitorMessage.
    fi_tclVisitorMessage oVisitorMsgOutput(rBaseMessage, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_NUMBER_OF_VERSIONS);

    // Init Method result message
    vInitServiceData(
            oVisitorMsgOutput,
            rServiceMethodStart.u16GetSourceAppID(),
            rServiceMethodStart.u16GetRegisterID(),
            rServiceMethodStart.u16GetCmdCounter(),
            rServiceMethodStart.u16GetFunctionID(),
            u8Opcode);

    // Post the message
    ail_tenCommunicationError ailResult =  _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult )
    {
        // fatal error, because a server can post in all use cases
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }

    // Destroy the (Message related) FI data object (output)
    rBaseMessage.vDestroy();
}
tVoid fc_mediaplayer_tclService_MediaPlayer::vPostResult(mplay_mediaplayerfi_tclMsgBaseMessage &rBaseMessage, IN tUserContext &userContext,
        IN tU8 u8Opcode /*t=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT*/)//finished: 100%
{
    ENTRY
    fi_tclVisitorMessage oVisitorMsgOutput(rBaseMessage, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_NUMBER_OF_VERSIONS);
    vInitServiceData(
            oVisitorMsgOutput,
            userContext.sourceAppID,
            userContext.registerID,
            userContext.cmdCounter,
            userContext.functionID,
            u8Opcode);
    ail_tenCommunicationError ailResult =  _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult )
    {
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }
    rBaseMessage.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::vPostError(amt_tclServiceData &rServiceMethodStart) //finished: 100%
{
    amt_tclServiceDataError oErrorMsg(rServiceMethodStart, 0);

    ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oErrorMsg, TRUE);
    if (AIL_EN_N_NO_ERROR != ailResult)
    {
        // fatal error, because a server can post in all use cases
        ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
    }
}

//HMI sends eject to VD_DVM then this is the asynchronous return value triggered by the answer of VD_Devicemanger
IN tVoid fc_mediaplayer_tclService_MediaPlayer::onEjectOpticalDiscMethodStart(amt_tclServiceData* poMessage) ////Roadmap 15002 CD Audio device Detection
{
    ENTRY
    tBool bSend = FALSE;
    tDMOpticalDiscEjectCmd emOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;    // preset the variable

    if(poMessage)
    {
        ETG_TRACE_USR4(("onEjectOpticalDiscMethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart   oFiDataObject_Get;        // create the object of FIDEVMGR_EJECTOPTICALDISC_METHODSTART
        fi_tclVisitorMessage                                      oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
        {
            mplay_fi_tcl_e8_EjectParmType enCmdEjectParam  = (mplay_fi_tcl_e8_EjectParmType)oFiDataObject_Get.eCmdParam;

            // Retrieve the serial number of device from message
            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("onEjectOpticalDiscMethodStart: enCmdEjectParam       = 0x%x",enCmdEjectParam.enType));
            ETG_TRACE_SYS (("************************************************************************************************"));

            switch(enCmdEjectParam.enType)
            {
                case mplay_fi_tcl_e8_EjectParmType::FI_EN_E8CMD_EJECT:
                    bSend = TRUE;
                    emOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;

                    break;
                case mplay_fi_tcl_e8_EjectParmType::FI_EN_E8CMD_INSERT:
                    bSend = TRUE;
                    emOpticalDiscEjectCmd = DM_OPTDISC_CMD_INSERT;
                    break;
                default:
                    ETG_TRACE_FATAL(("onEjectOpticalDiscMethodStart: Unexpected value: enCmdEjectParam: %d",(int)enCmdEjectParam.enType));
                    break;
            }

            ETG_TRACE_USR4(("onEjectOpticalDiscMethodStart; bEjectopticalDiscCmdValid:0x%x bSend:0x%x",bEjectopticalDiscCmdValid,bSend));
            if(bSend)
            {
                //store sender id's used in SendopticalDiscEjectMethodResult later
                bEjectopticalDiscCmdValid            = TRUE;
                u16EjectopticalDiscCmdGetSourceAppID = poMessage->u16GetSourceAppID();
                u16EjectopticalDiscCmdGetRegisterID  = poMessage->u16GetRegisterID();
                u16EjectopticalDiscCmdGetCmdCounter  = poMessage->u16GetCmdCounter();
                u16EjectopticalDiscCmdGetFunctionID  = poMessage->u16GetFunctionID();

                MediaPlayerInterface::GetInstance().SendEjectOpticalDisc(emOpticalDiscEjectCmd);

            }
            else
            {
                ETG_TRACE_FATAL(("onEjectOpticalDiscMethodStart: Ignore Message. Reason: Previous message still executing in lower layer components"));
            }

        }

        oFiDataObject_Get.vDestroy();


    }
    ETG_TRACE_USR4(("End  : onEjectOpticalDiscMethodStart"));
}


//VD_DVM to HMI after HMI has called onEjectOpticalDisc(...)
tResult fc_mediaplayer_tclService_MediaPlayer::SendOpticalDiscEjectMethodResult(tDMOpticalDiscEjectMethodResult entOpticalDiscEjectMethodResult)//Roadmap 15002_CDAudio_DetectionAndDiagnosis
{
    ENTRY

    tBool bSend = TRUE;

    mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult oFiDataObject;    // send the result back to the client


    switch(entOpticalDiscEjectMethodResult)
    {
        case ACCEPTED:
            oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_ACCEPTED;
            break;
        case NOTACCEPTED:
            oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_NOTACCEPTED;
            break;
        case DEVICENOTREADY:
            oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_DEVICENOTREADY;
            break;
        default:
            bSend = FALSE;
            ETG_TRACE_FATAL(("SendOpticalDiscEjectMethodResult: unexpected value: %d",ETG_CENUM(tDMOpticalDiscEjectMethodResult,entOpticalDiscEjectMethodResult)));
            break;
    }

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION);
    ETG_TRACE_USR4(("SendOpticalDiscEjectMethodResult: bSend=0x%x bEjectopticalDiscCmdValid=0x%x",bSend,bEjectopticalDiscCmdValid));
    if(bSend && bEjectopticalDiscCmdValid)
    {
        // Here the message related header information is added and by this the
        // creation of the message is completed.
        vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                u16EjectopticalDiscCmdGetSourceAppID,    // Target AppID
                u16EjectopticalDiscCmdGetRegisterID,     // RegisterID
                u16EjectopticalDiscCmdGetCmdCounter,     // CmdCounter,
                u16EjectopticalDiscCmdGetFunctionID,     // Function ID
                AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

        // Post the message to the client
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

        // Check for Error after posting message
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR (("SendOpticalDiscEjectMethodResult: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
            // Try to send error message
            //SendError(0, userContext);
        }
        //-------------------------------------
        //clear sender ID's since result has been send
        //-------------------------------------
        bEjectopticalDiscCmdValid            = FALSE;
        u16EjectopticalDiscCmdGetSourceAppID = 0;
        u16EjectopticalDiscCmdGetRegisterID  = 0;
        u16EjectopticalDiscCmdGetCmdCounter  = 0;
        u16EjectopticalDiscCmdGetFunctionID  = 0;


    }


    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
    return 0;
}

//conversion function used to forward OpticaldiscSlotStatus - usee usage in bStatusMessageFactory
void  fc_mediaplayer_tclService_MediaPlayer::ConvertDiscSlotStateToMPLAY(OUT mplay_fi_tcl_e8_SlotStateOpticalDiscType &e8SlotStateOpticalDisc , IN const tDMOpticalDiscSlotState enOpticalDiscSlotState)//Roadmap: 15002_CDAudio_DetectionAndDiagnosis
{
    ENTRY
    ETG_TRACE_USR4(("ConvertDiscSlotStateToMPLAY: eOpticalDiscSlotState: %d",ETG_CENUM(tDMOpticalDiscSlotState,enOpticalDiscSlotState) ));
    switch(enOpticalDiscSlotState)
    {
        case DM_OPTDISC_INITIALISING:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INITIALISING;
            break;
        case DM_OPTDISC_INITIALISED:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INITIALISED;
            break;
        case DM_OPTDISC_LASTMODE_EMTPY:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_EMTPY;
            break;
        case DM_OPTDISC_LASTMODE_INSERTED_CDDA:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDDA;
            break;
        case DM_OPTDISC_LASTMODE_INSERTED_CDROM:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDROM;
            break;
        case DM_OPTDISC_LASTMODE_INSERTED_CDERROR:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDERROR;
            break;
        case DM_OPTDISC_INSERTING:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTING;
            break;
        case DM_OPTDISC_INSERTED_CDAUDIO:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDAUDIO;
            break;
        case DM_OPTDISC_INSERTED_CDROM:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDROM;
            break;
        case DM_OPTDISC_INSERTED_CDERROR:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDERROR;
            break;
        case DM_OPTDISC_INSERTED_AUTOMATIC_CDAUDIO:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDAUDIO;
            break;
        case DM_OPTDISC_INSERTED_AUTOMATIC_CDROM:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDROM;
            break;
        case DM_OPTDISC_INSERTED_AUTOMATIC_CDERROR:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDERROR;
            break;
        case DM_OPTDISC_EJECTING:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTING;
            break;
        case DM_OPTDISC_EJECTED_READY_TO_REMOVE:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTED_READY_TO_REMOVE;
            break;
        case DM_OPTDISC_EJECTED_EMPTY:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTED_EMPTY;
            break;
        case DM_OPTDISC_UNDEFINED_STATE:
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_UNDEFINED;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertDiscSlotStateToMPLAY: Unexpected state: enOpticalDiscSlotState:%d",(int)enOpticalDiscSlotState));
            e8SlotStateOpticalDisc.enType = mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_UNDEFINED;
            break;
    }


}

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerIndexedImageFolderList(amt_tclServiceData* poMessage)  //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tListSize listSize;
        tPath path;
        tDeviceID deviceID;
        tListType listType;
        strncpy(path, oFiDataObjectMethodStart.sPath.szValue, sizeof path - 1);
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        ConvertListTypeToInternal(listType, oFiDataObjectMethodStart.e8ListType);
        if (listType == LTY_IMAGE_FOLDER)
        {
            result = MediaPlayerInterface::GetInstance().CreateMediaPlayerIndexedImageFolderList(listID, listSize, listType, deviceID);
        }
        else
        {
            result = MediaPlayerInterface::GetInstance().CreateMediaPlayerIndexedImageFolderItemList(listID, listSize, path, deviceID);
        }
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ListHandle = listID;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaPlayerIndexedImageFolderListSlice (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listID;
        tRowNumber startIndex;
        tRowNumber sliceSize;
#if USE_IMAGE_OBJECT
        vector<tImageObject> ImageObjectVector;
#else
        vector<tMediaObject> mediaObjectVector;
#endif

        listID = oFiDataObjectMethodStart.u32ListHandle;
        startIndex = oFiDataObjectMethodStart.u32WindowStart;
        sliceSize = oFiDataObjectMethodStart.u16WindowSize;

#if USE_IMAGE_OBJECT
        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedImageFolderListSlice(ImageObjectVector, listID, startIndex, sliceSize);
#else
        result = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(mediaObjectVector, listID, startIndex, sliceSize);
#endif

        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult oFiDataObjectMethodResult;
#if USE_IMAGE_OBJECT
            vector<tImageObject>::iterator it;
            for (it = ImageObjectVector.begin(); it < ImageObjectVector.end(); it++)
#else
                vector<tMediaObject>::iterator it;
            for (it = mediaObjectVector.begin(); it < mediaObjectVector.end(); it++)
#endif
            {
                mplay_fi_tcl_MPlayImageObjectItem mplayImageObjectItem;
                ConvertImageObjectItemToMPLAY(mplayImageObjectItem, *it);
                oFiDataObjectMethodResult.oImageObjects.oItems.push_back(mplayImageObjectItem);
            }
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onCreateMediaPlayerCDList (amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;

    mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListID listId;
        tListSize listSize;
        tNumberOfMediaObjects numberOfMediaObjects;
        tNumberOfPlayLists numberOfPlayLists;
        tNumberOfFolders numberOfFolders;

        tPath path;
        tDeviceID deviceID;
        tFileTypeSelection filetypeSelection;

        strncpy(path, oFiDataObjectMethodStart.sPath.szValue, sizeof path - 1);
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        ConvertFileTypeToInternal(filetypeSelection, oFiDataObjectMethodStart.e8MPlayFileTypeSelection);

        result = MediaPlayerInterface::GetInstance().CreateMediaPlayerCDList(listId, listSize, numberOfMediaObjects, numberOfPlayLists, numberOfFolders, path, deviceID, filetypeSelection);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult oFiDataObjectMethodResult;

            oFiDataObjectMethodResult.u32ListHandle = listId;
            oFiDataObjectMethodResult.u32ListSize = listSize;
            oFiDataObjectMethodResult.u8DeviceTag = oFiDataObjectMethodStart.u8DeviceTag;
            oFiDataObjectMethodResult.u32TotalNumFiles = numberOfMediaObjects + numberOfPlayLists;
            oFiDataObjectMethodResult.u32TotalNumFolders = numberOfFolders;
            oFiDataObjectMethodResult.u32TotalNumMediaObjects = numberOfMediaObjects;
            oFiDataObjectMethodResult.u32TotalNumPlaylists = numberOfPlayLists;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }

    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::GetImageFileCount(mplay_fi_tcl_MPlayDeviceInfoItem &mplayDeviceInfo, const tDeviceInfo &deviceInfo) //finished: 100%
{
    ENTRY
    tResult result = -1;
    tListSize listSize;

    if (deviceInfo.indexedState == IDS_COMPLETE)
    {
        result = MediaPlayerInterface::GetInstance().GetImageFileCount(listSize, deviceInfo.deviceID);
        if (0 == result)
        {
            mplayDeviceInfo.u32NumberOfImageFiles = listSize;
        }
        else
        {
            mplayDeviceInfo.u32NumberOfImageFiles = 0;
        }
    }
    else
    {
        mplayDeviceInfo.u32NumberOfImageFiles = -1;
    }
}

//conversion function used to forward OpticalDeviceState - see usage in bStatusMessageFactory
void  fc_mediaplayer_tclService_MediaPlayer::ConvertOpticalDeviceStateToMPLAY(OUT mplay_fi_tcl_e8DeviceState &e8DeviceState , IN const tenOpticalDeviceState OpticalDeviceState)// CD Info
{
    ENTRY
    ETG_TRACE_USR4(("ConvertOpticalDeviceStateToMPLAY: OpticalDeviceState: %d",OpticalDeviceState ));
    switch(OpticalDeviceState)
    {
        case DEVICE_NOT_READY:
            e8DeviceState.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_NOT_READY;
            break;
        case DEVICE_READY:
            e8DeviceState.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_READY;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertOpticalDeviceStateToMPLAY: Unexpected state: OpticalDeviceState:%d",(int)OpticalDeviceState));
            e8DeviceState.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_NOT_READY;
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertInternalPlaylistTaskResultToMplay(OUT mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult& e8TaskResult,IN const int result )
{
    ENTRY
    ETG_TRACE_USR4(("ConvertInternalPlaylistTaskResultToMplay: Task Result: %d",result ));
    switch(result)
    {
        case MP_NO_ERROR:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_OK;
            break;
        case MP_ERR_LC_PLAYLIST_FILE_CREATE:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8FILE_CREATE_ERROR;
            break;
        case MP_ERR_LC_PLAYLIST_FILE_PERMISSION:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8PERM_ISSUE;
            break;
        case MP_ERR_LC_PLAYLIST_DATABASE_ERROR:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8DATABASE_ERROR;
            break;
        case MP_ERR_LC_PLAYLIST_NOT_FOUND:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8FILE_NOT_EXIST;
            break;
        case MP_ERR_LC_PLAYLIST_DISK_FULL:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8DISK_FULL;
            break;
        case MP_ERR_LC_PLAYLIST_FILE_OPERATATION:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
        case MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND:
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8MULTIPLE_ENTRIES_FOUND;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertInternalPlaylistTaskResultToMplay: Unexpected state: Task Result:%d",result));
            e8TaskResult.enType = mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
    }
}


void fc_mediaplayer_tclService_MediaPlayer::onReorderInternalPlaylist(IN amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPath playlistPath;
        tDeviceID deviceTag;
        tPosition oldPosition;
        tPosition newposition;

        ConvertDeviceTagToInternal(deviceTag, oFiDataObjectMethodStart.u8DeviceTag);
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);
        oldPosition = oFiDataObjectMethodStart.u32OldPosition;
        newposition = oFiDataObjectMethodStart.u32NewPosition;

        result = MediaPlayerInterface::GetInstance().ReorderInternalPlaylist(IN playlistPath, IN deviceTag, IN oldPosition, IN newposition);

        mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult oFiDataObjectMethodResult;
        ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,result);
        vPostResult(oFiDataObjectMethodResult, oVisitorMsg);

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();

}


tVoid fc_mediaplayer_tclService_MediaPlayer::onDeleteMediaContentByFilterTags(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tListType listType;
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;
        tDeviceID deviceID;

        ConvertListTypeToInternal(listType, oFiDataObjectMethodStart.e8ListType);
        tag1.tag = oFiDataObjectMethodStart.u32FilterTag1;
        tag2.tag = oFiDataObjectMethodStart.u32FilterTag2;
        tag3.tag = oFiDataObjectMethodStart.u32FilterTag3;
        tag4.tag = 0;
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        MapTagsFromGM2GenMP(IN listType, INOUT tag1, INOUT tag2, INOUT tag3, INOUT tag4);
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)

        std::map<tDeleteMediaContentType,tUserContext>::iterator it = mapVisitorMsgDeleteMediaContent.find(DELETEMEDIACONTENTBYFILERTAGS);
        if (it == mapVisitorMsgDeleteMediaContent.end())
        {
            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on
        tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));
        fillUserContext(poMessage,userContext);
        mapVisitorMsgDeleteMediaContent.insert(std::pair<tDeleteMediaContentType,tUserContext>(DELETEMEDIACONTENTBYFILERTAGS,userContext));
        }
        result = MediaPlayerInterface::GetInstance().DeleteMediaContent(listType, tag1, tag2, tag3, tag4, deviceID);
        if (result)
        {
            vPostError(oVisitorMsg);
        }
            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onDeleteMediaContentByMediaObjectTags(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tDeviceID deviceID;
        vector<tObjectID> mediaObjectIDVector;
        std::vector<tU32> omediaObjectIDVector = oFiDataObjectMethodStart.oMediaObjectTags.MediaObjectTag;
        std::vector<tU32>::iterator it;

        for(it = omediaObjectIDVector.begin();it< omediaObjectIDVector.end();it++)
            mediaObjectIDVector.push_back((tObjectID)*it);


        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);

        std::map<tDeleteMediaContentType,tUserContext>::iterator itr = mapVisitorMsgDeleteMediaContent.find(DELETEMEDIACONTENTBYMEDIAOBJECTTAGS);
        if (itr == mapVisitorMsgDeleteMediaContent.end())
        {
            tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));
            fillUserContext(poMessage,userContext);
            mapVisitorMsgDeleteMediaContent.insert(std::pair<tDeleteMediaContentType,tUserContext>(DELETEMEDIACONTENTBYMEDIAOBJECTTAGS,userContext));
        }
        result = MediaPlayerInterface::GetInstance().DeleteMediaContent(mediaObjectIDVector, deviceID);
        if (result)
        {
            vPostError(oVisitorMsg);
        }
            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on

    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onDeleteMediaContentByMediaObjectUrls(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tDeviceID deviceID;
        vector<string> mediaObjectUrlVector;
        std::vector<mplay_fi_tclString> omediaObjectIDVector = oFiDataObjectMethodStart.oMPlayMediaObjectUrls.sMediaObjectUrl;
        std::vector<mplay_fi_tclString>::iterator it;

        for(it = omediaObjectIDVector.begin();it< omediaObjectIDVector.end();it++)
            mediaObjectUrlVector.push_back((string)it->szValue);


        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);

        std::map<tDeleteMediaContentType,tUserContext>::iterator itr = mapVisitorMsgDeleteMediaContent.find(DELETEMEDIACONTENTBYURLS);
        if (itr == mapVisitorMsgDeleteMediaContent.end())
        {
            //store userContext
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on
            tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));

            fillUserContext(poMessage,userContext);
            mapVisitorMsgDeleteMediaContent.insert(std::pair<tDeleteMediaContentType,tUserContext>(DELETEMEDIACONTENTBYURLS,userContext));
        }
        result = MediaPlayerInterface::GetInstance().DeleteMediaContent(mediaObjectUrlVector, deviceID);
        if (result)
        {
            vPostError(oVisitorMsg);
        }
            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on


    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();

}

tResult fc_mediaplayer_tclService_MediaPlayer::Send_OnDeleteMediaContentMethodResult(IN tDeleteMediaContentType deleteMediaContentType, IN tFileOperationErrorCodes fileOperationErrorCodes, IN tU16 numofFilesDeleted)
{
    ENTRY
    tResult result = -1;

    mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult mplayDeleteMediaContentTaskResult;
    mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DEVICE_ERROR;
    std::map<tDeleteMediaContentType,tUserContext>::iterator it = mapVisitorMsgDeleteMediaContent.find(deleteMediaContentType);
    ConvertDeleteMediaContentErrorTypeToMPlay(mplayDeleteMediaContentTaskResult,fileOperationErrorCodes);


    if (it != mapVisitorMsgDeleteMediaContent.end())
    {
        ETG_TRACE_COMP(("Send_OnDeleteMediaContentMethodResult: deleteMediaContentType:%d  ",deleteMediaContentType));
        tUserContext userContext = (it->second);
        switch(deleteMediaContentType)
        {
            case DELETEMEDIACONTENTBYFILERTAGS:
            {
                mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult oFiDataObject;
                oFiDataObject.u32Status = mplayDeleteMediaContentTaskResult;
                oFiDataObject.u32NumberOfFiles = numofFilesDeleted;
                vPostResult(oFiDataObject, userContext);
                oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
                break;
            }
            case DELETEMEDIACONTENTBYMEDIAOBJECTTAGS:
            {
                mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult oFiDataObject;
                oFiDataObject.u32Status = mplayDeleteMediaContentTaskResult;
                oFiDataObject.u32NumberOfFiles = numofFilesDeleted;
                vPostResult(oFiDataObject, userContext);
                oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
                break;
            }
            case DELETEMEDIACONTENTBYURLS:
            {
                mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult oFiDataObject;
                oFiDataObject.u32Status = mplayDeleteMediaContentTaskResult;
                oFiDataObject.u32NumberOfFiles = numofFilesDeleted;
                vPostResult(oFiDataObject, userContext);
                oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
                break;
            }
            default:
                ETG_TRACE_FATAL(("Send_OnDeleteMediaContentMethodResult: unexpected value: %d",ETG_CENUM(tDeleteMediaContentType,deleteMediaContentType)));
                break;
        }
        mapVisitorMsgDeleteMediaContent.erase (it);
        result = MP_NO_ERROR;



    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR]: Send_OnDeleteMediaContentMethodResult: No oVisitorMsg found in map  - nothing send"));
    }
    return result;
}


void fc_mediaplayer_tclService_MediaPlayer::ConvertDeleteMediaContentErrorTypeToMPlay(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult &mplayDeleteMediaContentTaskResult, const tFileOperationErrorCodes fileOperationErrorCodes)
{
    switch(fileOperationErrorCodes)
    {
        case FILE_OPERATION_OK:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_OK;
            break;
        case FILEPERM_ISSUE:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8PERM_ISSUE;
            break;
        case DATABASE_ERROR:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DATABASE_ERROR;
            break;
        case DEVICE_NOT_EXISITS:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DEVICE_NOT_EXIST;
            break;
        case LISTTYPE_NOT_FOUND:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8LISTTYPE_NOT_FOUND;
            break;
        case FILE_OPERATION_ERROR:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
        case DEVICE_ERROR:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DEVICE_ERROR;
            break;


        default:
            ETG_TRACE_FATAL(("ConvertDeleteMediaContentErrorTypeToMPlay: unexpected value: %d",ETG_CENUM(tFileOperationErrorCodes,fileOperationErrorCodes)));
    }
}

tVoid fc_mediaplayer_tclService_MediaPlayer:: onEditMetaDataByMediaObjectTag(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tDeviceID deviceID;
        oFiDataObjectMethodStart;
        tEditMetaDataByID editMetaDataByID;
        memset((void*)&editMetaDataByID,0,sizeof(editMetaDataByID));
        editMetaDataByID.MediaObjectID = oFiDataObjectMethodStart.u32Tag;
        strncpy_r(OUT editMetaDataByID.GenreField, IN oFiDataObjectMethodStart.sTagGenre.szValue, IN sizeof(editMetaDataByID.GenreField));
        strncpy_r(OUT editMetaDataByID.AlbumField, IN oFiDataObjectMethodStart.sTagAlbum.szValue, IN sizeof(editMetaDataByID.AlbumField));
        strncpy_r(OUT editMetaDataByID.ArtistField, IN oFiDataObjectMethodStart.sTagArtist.szValue, IN sizeof(editMetaDataByID.ArtistField));
        strncpy_r(OUT editMetaDataByID.TitleField, IN oFiDataObjectMethodStart.sTagTitle.szValue, IN sizeof(editMetaDataByID.TitleField));
        strncpy_r(OUT editMetaDataByID.ComposerField, IN oFiDataObjectMethodStart.sTagComposer.szValue, IN sizeof(editMetaDataByID.ComposerField));
        strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiTitle, IN oFiDataObjectMethodStart.sTagYomiTitle.szValue, IN sizeof(editMetaDataByID.yomiMetaData.YomiTitle));
        strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiArtist, IN oFiDataObjectMethodStart.sTagYomiArtist.szValue, IN sizeof(editMetaDataByID.yomiMetaData.YomiArtist));
        strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiAlbum, IN oFiDataObjectMethodStart.sTagYomiAlbum.szValue, IN sizeof(editMetaDataByID.yomiMetaData.YomiAlbum));
#ifdef BLOCKEDF_FIRST
        editMetaDataByID.YearField = oFiDataObjectMethodStart.u16TagYear;
#endif
        ConvertDeviceTagToInternal(editMetaDataByID.deviceID, oFiDataObjectMethodStart.u8DeviceTag);

        std::map<tEditMetadatatType,tUserContext>::iterator it = mapVisitorEditMetadataMsg.find(EDITMETADATABYMEDIAOBJECTTAG);
        if (it == mapVisitorEditMetadataMsg.end())
        {
            //store visitor
            //store information necessary to send MethodResult
            //which means call of 'Send_OnEditMetaDataMethodResult' will succeed from now on
            tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));
            fillUserContext(poMessage,userContext);
            mapVisitorEditMetadataMsg.insert(std::pair<tEditMetadatatType,tUserContext>(EDITMETADATABYMEDIAOBJECTTAG,userContext));
        }
        result = MediaPlayerInterface::GetInstance().EditMetaData(editMetaDataByID);
        if (result)
        {
            vPostError(oVisitorMsg);
            //store visitor
            //store information necessary to send MethodResult
            //which means call of 'Send_OnEditMetaDataMethodResult' will succeed from now on
        }


    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer:: onEditMetaDataByMediaObjectUrl(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tDeviceID deviceID;
        oFiDataObjectMethodStart;
        tEditMetaDataByUrl editMetaDataByUrl;
        memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));
        strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN oFiDataObjectMethodStart.sMediaObjectUrl.szValue,IN sizeof(editMetaDataByUrl.MediaObjectUrl));
        strncpy_r(OUT editMetaDataByUrl.GenreField, IN oFiDataObjectMethodStart.sTagGenre.szValue, IN sizeof(editMetaDataByUrl.GenreField));
        strncpy_r(OUT editMetaDataByUrl.AlbumField, IN oFiDataObjectMethodStart.sTagAlbum.szValue, IN sizeof(editMetaDataByUrl.AlbumField));
        strncpy_r(OUT editMetaDataByUrl.ArtistField, IN oFiDataObjectMethodStart.sTagArtist.szValue, IN sizeof(editMetaDataByUrl.ArtistField));
        strncpy_r(OUT editMetaDataByUrl.TitleField, IN oFiDataObjectMethodStart.sTagTitle.szValue, IN sizeof(editMetaDataByUrl.TitleField));
        strncpy_r(OUT editMetaDataByUrl.ComposerField, IN oFiDataObjectMethodStart.sTagComposer.szValue, IN sizeof(editMetaDataByUrl.ComposerField));
        strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiTitle, IN oFiDataObjectMethodStart.sTagYomiTitle.szValue, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiTitle));
        strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiArtist, IN oFiDataObjectMethodStart.sTagYomiArtist.szValue, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiArtist));
        strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiAlbum, IN oFiDataObjectMethodStart.sTagYomiAlbum.szValue, IN sizeof(editMetaDataByUrl.yomiMetaData.YomiAlbum));
        editMetaDataByUrl.YearField = oFiDataObjectMethodStart.u16TagYear;
        ConvertDeviceTagToInternal(editMetaDataByUrl.deviceID, oFiDataObjectMethodStart.u8DeviceTag);

        std::map<tEditMetadatatType,tUserContext>::iterator it = mapVisitorEditMetadataMsg.find(EDITMETADATABYURL);
        if (it == mapVisitorEditMetadataMsg.end())
        {
            tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));
            fillUserContext(poMessage,userContext);
            mapVisitorEditMetadataMsg.insert(std::pair<tEditMetadatatType,tUserContext>(EDITMETADATABYURL,userContext));
        }
        result = MediaPlayerInterface::GetInstance().EditMetaData(editMetaDataByUrl);
        if (result)
        {
            vPostError(oVisitorMsg);
        }
            //store visitor
            //store information necessary to send MethodResult
            //which means call of 'Send_OnEditMetaDataMethodResult' will succeed from now on


    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onStartRipping(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgStartRippingMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        result = MediaPlayerInterface::GetInstance().StartRipping();
        if (0 != result)
        {
            vPostError(oVisitorMsg);
        }
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgStartRippingMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();

}

tVoid fc_mediaplayer_tclService_MediaPlayer::onStopRipping(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgStopRippingMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        result = MediaPlayerInterface::GetInstance().StopRipping();
        if (0 != result)
        {
            vPostError(oVisitorMsg);
        }
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgStopRippingMethodResult oFiDataObjectMethodResult;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();

}

//>--rOADMAP 16003 : 'CD Ripping with Gracenote'
tVoid fc_mediaplayer_tclService_MediaPlayer::onExtractGracenoteMetadata(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        string albumTitle(oFiDataObjectMethodStart.sAlbumTitle.szGet(mplay_fi_tclString::FI_EN_UTF8));
        tBool multipleAlbumSelection = oFiDataObjectMethodStart.bMultipleAlbumSelection;
        VARTRACE(albumTitle.c_str());
        result = MediaPlayerInterface::GetInstance().ExtractGracenoteMetadata(albumTitle,multipleAlbumSelection);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObjectMethodStart.vDestroy();
}
//<--rOADMAP 16003 : 'CD Ripping with Gracenote'

tResult fc_mediaplayer_tclService_MediaPlayer::Send_OnEditMetaDataMethodResult(IN tEditMetadatatType editMetadatatType, IN tFileOperationErrorCodes fileOperationErrorCodes)
{
    ENTRY
    tResult result = -1;

    mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult mplayEditMetadataTaskResult;
    mplayEditMetadataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8DEVICE_ERROR;
    std::map<tEditMetadatatType,tUserContext>::iterator it = mapVisitorEditMetadataMsg.find(editMetadatatType);
    ConvertEditMetaDataErrorTypeToMPlay(mplayEditMetadataTaskResult,fileOperationErrorCodes);


    if (it != mapVisitorEditMetadataMsg.end())
    {
        ETG_TRACE_COMP(("Send_OnEditMetaDataMethodResult: fileOperationErrorCodes:%d",fileOperationErrorCodes));
        tUserContext userContext = (it->second);
        switch(editMetadatatType)
        {
            case EDITMETADATABYMEDIAOBJECTTAG:
            {
                mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult oFiDataObject;
                oFiDataObject.u32Status = mplayEditMetadataTaskResult;
                vPostResult(oFiDataObject, userContext);
                oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
                break;
            }
            case EDITMETADATABYURL:
            {
                mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult oFiDataObject;
                oFiDataObject.u32Status = mplayEditMetadataTaskResult;
                vPostResult(oFiDataObject, userContext);
                oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
                break;
            }
            default:
                ETG_TRACE_FATAL(("Send_OnEditMetaDataMethodResult: unexpected value: %d",ETG_CENUM(tEditMetadatatType,editMetadatatType)));
                break;
        }
        result = MP_NO_ERROR;
        mapVisitorEditMetadataMsg.erase(it);

    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR]: Send_OnEditMetaDataMethodResult: No oVisitorMsg found in map  - nothing send"));
    }
    return result;
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertEditMetaDataErrorTypeToMPlay(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult &mplayEditMetaDataTaskResult, IN const tFileOperationErrorCodes fileOperationErrorCodes)
{
    switch(fileOperationErrorCodes)
    {
        case FILE_OPERATION_OK:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_OK;
            break;
        case FILEPERM_ISSUE:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8PERM_ISSUE;
            break;
        case DATABASE_ERROR:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8DATABASE_ERROR;
            break;
        case DEVICE_NOT_EXISITS:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8DEVICE_NOT_EXIST;
            break;
        case OBJECT_NOT_FOUND:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8MEDIAOBJECT_NOT_FOUND;
            break;
        case FILE_OPERATION_ERROR:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
        case TAG_EDIT_ERROR:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8TAG_EDIT_ERROR;
            break;
        case DEVICE_ERROR:
            mplayEditMetaDataTaskResult.enType = mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::FI_EN_E8DEVICE_ERROR;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertEditMetaDataErrorTypeToMPlay: unexpected value: %d",ETG_CENUM(tFileOperationErrorCodes,fileOperationErrorCodes)));
    }

}

tVoid fc_mediaplayer_tclService_MediaPlayer::Send_OnAddFileNameToPlaylistMethodResult (IN tResult playListOperationErrorCodes)
{
    ENTRY

        if(m_pAddFileNamesToPlaylistByUrlsUserContext.sourceAppID)
        {
            mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult oFiDataObjectMethodResult;
            ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,playListOperationErrorCodes);
            vPostResult(oFiDataObjectMethodResult,m_pAddFileNamesToPlaylistByUrlsUserContext);
            memset((void*)&m_pAddFileNamesToPlaylistByUrlsUserContext,0,sizeof(tUserContext));

        }
        else if(m_pAddFileNamesToPlaylistByTagUserContext.sourceAppID)
        {
            mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult oFiDataObjectMethodResult;
            ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,playListOperationErrorCodes);
            vPostResult(oFiDataObjectMethodResult,m_pAddFileNamesToPlaylistByTagUserContext);
            memset((void*)&m_pAddFileNamesToPlaylistByTagUserContext,0,sizeof(tUserContext));
        }
}
tVoid fc_mediaplayer_tclService_MediaPlayer::Send_OnDeleteEntryFromPlaylistMethodResult(IN tResult playListOperationErrorCodes)
{
    ENTRY

        mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult oFiDataObjectMethodResult;
        ConvertInternalPlaylistTaskResultToMplay(oFiDataObjectMethodResult.Status,playListOperationErrorCodes);
        vPostResult(oFiDataObjectMethodResult, m_pDeleteEntryFromPlaylistUserContext);
        memset((void*)&m_pDeleteEntryFromPlaylistUserContext,0,sizeof(tUserContext));


}
tVoid fc_mediaplayer_tclService_MediaPlayer::ConvertEncodingQualityTypeToMPlay(OUT mplay_fi_tcl_e8_MPlayEncodingQuality &mplayEncodingQuality, IN const tEncodingQuality rippingEncodingQuality)
{
    ENTRY
    switch(rippingEncodingQuality)
    {
        case Encoding_Quality_FM:
            mplayEncodingQuality.enType = mplay_fi_tcl_e8_MPlayEncodingQuality::FI_EN_E8FM_QUALITY ;
            break;
        case Encoding_Quality_CD:
            mplayEncodingQuality.enType = mplay_fi_tcl_e8_MPlayEncodingQuality::FI_EN_E8CD_QUALIY;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertEncodingQualityTypeToMPlay: unexpected value: %d",ETG_CENUM(tEncodingQuality,rippingEncodingQuality)));
            break;
    }
}
void fc_mediaplayer_tclService_MediaPlayer::ConvertMplayTypeToEncodingQuality(OUT tEncodingQuality &rippingEncodingQuality, IN const mplay_fi_tcl_e8_MPlayEncodingQuality mplayEncodingQuality )
{
    ENTRY
    switch(mplayEncodingQuality.enType)
    {
        case mplay_fi_tcl_e8_MPlayEncodingQuality::FI_EN_E8FM_QUALITY:
            rippingEncodingQuality = Encoding_Quality_FM;
            break;
        case mplay_fi_tcl_e8_MPlayEncodingQuality::FI_EN_E8CD_QUALIY:
            rippingEncodingQuality = Encoding_Quality_CD;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertMplayTypeToEncodingQuality: unexpected value: %d",mplayEncodingQuality.enType));
            break;
    }
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
tVoid fc_mediaplayer_tclService_MediaPlayer::onSetFilePermissionByMediaObjectTags(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID;
        tFilePermission ofilepermission;
        memset((void*)&ofilepermission,0,sizeof(tFilePermission));//CID 920746 : Uninitialized scalar variable
        std::vector<tFilePermission> ofilePermissions;

        for ( unsigned int l_uiCount=0; l_uiCount < oFiDataObjectMethodStart.oFilePermissionObjectTags.PermissionTag.size();l_uiCount++)
        {

            ofilepermission.objectID = oFiDataObjectMethodStart.oFilePermissionObjectTags.PermissionTag[l_uiCount].MediaObjectTag;
            ofilepermission.readOnly = oFiDataObjectMethodStart.oFilePermissionObjectTags.PermissionTag[l_uiCount].bReadOnlyFlag;
            ofilePermissions.push_back(ofilepermission);
        }
        //ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        deviceID = (tDeviceID)oFiDataObjectMethodStart.u8DeviceTag;
        std::map<tDeleteMediaContentType,tUserContext>::iterator it = mapVisitorMsgDeleteMediaContent.find(SETFILEPERMISSIONBYMEDIAOBJECTTAGS);
        if(it == mapVisitorMsgDeleteMediaContent.end())
        {

            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on
            tUserContext userContext;
            memset((void*)&userContext,0,sizeof(tUserContext));
            fillUserContext(poMessage,userContext);
            mapVisitorMsgDeleteMediaContent.insert(std::pair<tDeleteMediaContentType,tUserContext>(SETFILEPERMISSIONBYMEDIAOBJECTTAGS,userContext));
        }
        result = MediaPlayerInterface::GetInstance().SetFilePermissions(ofilePermissions, deviceID);
        if (result)
        {
            vPostError(oVisitorMsg);
        }

            //store visitor
            //store information necessary to send MethodResult
            //which means call of Send_OnDeleteMediaContentMethodResult will succeed from now on
    }
    oFiDataObjectMethodStart.vDestroy();
}
tResult fc_mediaplayer_tclService_MediaPlayer::Send_SetfilePermissionByMediaobjectTagsMethodResult(IN tResult filePermissionError, IN tU16 numofFiles)
{
    ENTRY
    tResult result = -1;
    std::map<tDeleteMediaContentType,tUserContext>::iterator it = mapVisitorMsgDeleteMediaContent.find(SETFILEPERMISSIONBYMEDIAOBJECTTAGS);
    mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult mplayDeleteMediaContentTaskResult;
    mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DEVICE_ERROR;

    switch(filePermissionError)
    {
        case MP_NO_ERROR:
           mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_OK;
           break;
        case DATABASE_ERROR:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DATABASE_ERROR;
            break;
        case MP_ERR_RD_FILE_PERMISSION:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8PERM_ISSUE;
            break;
        case MP_ERR_DB_UNEXPECTED:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8DATABASE_ERROR;
            break;
        case MP_ERR_LC_UNDEFINED_LIST_ID:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
        default:
            mplayDeleteMediaContentTaskResult.enType = mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::FI_EN_E8FILE_OP_ERROR;
            break;
    }
    if (it != mapVisitorMsgDeleteMediaContent.end())
    {
        ETG_TRACE_COMP(("Send_SetfilePermissionByMediaobjectTagsMethodResult"));
        tUserContext userContext = (it->second);
        mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult oFiDataObject;
        oFiDataObject.u32Status = mplayDeleteMediaContentTaskResult;
        oFiDataObject.u32NumberOfFiles = numofFiles;
        vPostResult(oFiDataObject, userContext);
        oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)
        result = MP_NO_ERROR;
    }
    return result;
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestMediaplayerFolderInfo(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID = (tDeviceID)oFiDataObjectMethodStart.u8DeviceTag;
        tPath Path = {0};
        tFolderInfo folderinfo;

        folderinfo.totalSize = 0;
        folderinfo.totalNumber = 0;
        folderinfo.protectedSize = 0;
        folderinfo.protectedNumber = 0;
        strncpy(Path, oFiDataObjectMethodStart.sPath.szValue, sizeof (Path)-1);
        tFileTypeSelection FileTypeSelection = (tFileTypeSelection)oFiDataObjectMethodStart.e8MPlayFileTypeSelection.enType;
        result = MediaPlayerInterface::GetInstance().MediaplayerFolderInfo(deviceID, Path,FileTypeSelection,folderinfo);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult oFiDataObjectMethodResult;

            oFiDataObjectMethodResult.u8DeviceTag = deviceID;
            oFiDataObjectMethodResult.u64TotalSize = folderinfo.totalSize;
            oFiDataObjectMethodResult.u32TotalNumber = folderinfo.totalNumber;
            oFiDataObjectMethodResult.u64ProtectedSize = folderinfo.protectedSize;
            oFiDataObjectMethodResult.u32ProtectedNumber = folderinfo.protectedNumber;
            oFiDataObjectMethodResult.sPath.bSet(Path, mplay_fi_tclString::FI_EN_UTF8);
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
            ETG_TRACE_USR3(("Total Size of the folder  %lu number %d", folderinfo.totalSize, folderinfo.totalNumber));
            ETG_TRACE_USR3(("Protected :- Total Size of the folder is %lu number %d", folderinfo.protectedSize, folderinfo.protectedNumber));
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

//>--Roadmap 16003 : 'CD Ripping With Gracenote'
tVoid fc_mediaplayer_tclService_MediaPlayer::onAddFilenameToInternalPlaylistByTags(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tListType listType;
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;
        tDeviceID deviceID;
        tPath playlistPath;

        ConvertListTypeToInternal(listType, oFiDataObjectMethodStart.e8ListType);
        tag1.tag = oFiDataObjectMethodStart.u32FilterTag1;
        tag2.tag = oFiDataObjectMethodStart.u32FilterTag2;
        tag3.tag = oFiDataObjectMethodStart.u32FilterTag3;
        tag4.tag = 0;
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)
        ConvertDeviceTagToInternal(deviceID, oFiDataObjectMethodStart.u8DeviceTag);
        MapTagsFromGM2GenMP(IN listType, INOUT tag1, INOUT tag2, INOUT tag3, INOUT tag4);
        VARTRACE(tag1)
        VARTRACE(tag2)
        VARTRACE(tag3)
        VARTRACE(tag4)
        strncpy(playlistPath, oFiDataObjectMethodStart.sPlaylistPath.szValue, sizeof playlistPath - 1);
        //store visitor
        //store information necessary to send MethodResult
        //which means call of Send_OnAddFileNameToPlaylistMethodResult will succeed from now on
        fillUserContext(poMessage,m_pAddFileNamesToPlaylistByTagUserContext);

        result = MediaPlayerInterface::GetInstance().AddFileNamesToPlaylistByTag(IN listType, IN tag1, IN tag2, IN tag3, IN tag4, IN playlistPath, IN deviceID);
        if (result)
        {
            vPostError(oVisitorMsg);
        }



    }
    oFiDataObjectMethodStart.vDestroy();


}

//<--Roadmap 16003 : 'CD Ripping With Gracenote'

//>--Roadmap 17001 : 'Personalization'
tVoid fc_mediaplayer_tclService_MediaPlayer::onStorePersonalizedFavorite(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tObjectID objectID;
        tUserID userID;
        tFavoriteID favID;

        objectID = oFiDataObjectMethodStart.u32ObjectID;
        userID = oFiDataObjectMethodStart.u8UserID;
        result = MediaPlayerInterface::GetInstance().StorePersonalizedFavorite(favID, objectID, userID);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult oFiDataObjectMethodResult;

            oFiDataObjectMethodResult.u64FavoriteID = favID;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
            ETG_TRACE_USR3(("User Favorite (FavoriteID : %d) added for User:%d", favID,userID));
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();

}

//>--Roadmap 17001 : 'Personalization'

//>--Roadmap 17001 : 'Personalization'
tVoid fc_mediaplayer_tclService_MediaPlayer::onDeletePersonalizedFavorite(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tObjectID objectID;
        tUserID userID;

        objectID = oFiDataObjectMethodStart.u32ObjectID;
        userID = oFiDataObjectMethodStart.u8UserID;
        result = MediaPlayerInterface::GetInstance().DeletePersonalizedFavorite(objectID, userID);
        if (0 == result)
        {
            mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult oFiDataObjectMethodResult;
            oFiDataObjectMethodResult.u32ObjectID = objectID;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
            ETG_TRACE_USR3(("User Favorite (objectID : %d) deleted for User:%d", objectID,userID));
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();

}

//>--Roadmap 17001 : 'Personalization'

tVoid fc_mediaplayer_tclService_MediaPlayer::onRequestDVDTemperature (amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart oFiDataObjectMethodStart;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {

        tUserContext userContext;
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();

        result = MediaPlayerInterface::GetInstance().RequestDVDTemperature(userContext);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    if (0 != result)
    {
        vPostError(oVisitorMsg);
    }
    oFiDataObjectMethodStart.vDestroy();
}

tVoid fc_mediaplayer_tclService_MediaPlayer::SendRequestDVDTemperatureAnswer(tU16 temperature , tUserContext userContext)
{
    ENTRY

        mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult resultMessage;

        resultMessage.u16Temperature = temperature;
        // Create FI VisitorMessage.
        fi_tclVisitorMessage oVisitorMsgOutput(resultMessage, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_NUMBER_OF_VERSIONS);
        // Init Method result message
        vInitServiceData(oVisitorMsgOutput, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
        // Post message
        ail_tenCommunicationError enResult =_poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult )
        {
            ETG_TRACE_FATAL(("enPostMessage failed: %d", enResult));
            // Try to send error message
            SendError(0, userContext);
        }
        resultMessage.vDestroy();
        return ;
}

tVoid fc_mediaplayer_tclService_MediaPlayer::onSendAppleHIDCommand(amt_tclServiceData* poMessage)  //finished 100%
{
    ENTRY
    tResult result = -1;
    mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart oFiDataObjectMethodStart;
    mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult oFiDataObjectMethodResult;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_MEDIAPLAYER_SERVICE_MEDIAPLAYER_FI_MAJOR_VERSION))
    {
        tPlaybackHIDCommand playbackHIDCommand;
        tBTButtonEvent keyEvent;

        ConvertPlaybackHIDCommandToInternal(playbackHIDCommand, oFiDataObjectMethodStart.eHIDCommand);
        ConvertKeyEventToInternal(keyEvent, oFiDataObjectMethodStart.eKeyEvent);
        result = MediaPlayerInterface::GetInstance().SendAppleHIDCommand(playbackHIDCommand,keyEvent);
        if (0 == result)
        {
            oFiDataObjectMethodResult.result = true;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
        }
        else
        {
            oFiDataObjectMethodResult.result = false;
            vPostResult(oFiDataObjectMethodResult, oVisitorMsg);
            vPostError(oVisitorMsg);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    oFiDataObjectMethodStart.vDestroy();
}

void fillUserContext(IN amt_tclServiceData* poMessage,OUT tUserContext &userContext)
{
    if(!userContext.sourceAppID)
    {
        userContext.sourceAppID = poMessage->u16GetSourceAppID();
        userContext.registerID = poMessage->u16GetRegisterID();
        userContext.cmdCounter = poMessage->u16GetCmdCounter();
        userContext.functionID = poMessage->u16GetFunctionID();
        userContext.serviceID = poMessage->u16GetServiceID();
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertPlaybackHIDCommandToInternal(tPlaybackHIDCommand &internalPlaybackHIDCommand, const mplay_fi_tcl_e_MPlayHIDCommand mplayHIDCommand)
{
    ENTRY_INTERNAL
    switch(mplayHIDCommand.enType)
    {
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_PLAY:
            internalPlaybackHIDCommand = HID_PLAY;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_PAUSE:
            internalPlaybackHIDCommand = HID_PAUSE;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_SCAN_NEXT_TRACK:
            internalPlaybackHIDCommand = HID_SCAN_NEXT_TRACK;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_SCAN_PREV_TRACK:
            internalPlaybackHIDCommand = HID_SCAN_PREV_TRACK;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_RANDOM:
            internalPlaybackHIDCommand = HID_RANDOM;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_REPEAT:
            internalPlaybackHIDCommand = HID_REPEAT;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_VOICE:
            internalPlaybackHIDCommand = HID_VOICE;
            break;
        case mplay_fi_tcl_e_MPlayHIDCommand::FI_EN_HID_MUTE:
            internalPlaybackHIDCommand = HID_MUTE;
            break;
        default:
            internalPlaybackHIDCommand = HID_PLAY;
            ETG_TRACE_ERR(("Invalid playback HID command "));
            break;
    }
}

void fc_mediaplayer_tclService_MediaPlayer::ConvertKeyEventToInternal(tBTButtonEvent &internalKeyEvent, const mplay_fi_tcl_e_MPlayKeyEvent mplayKeyEvent)
{
    ENTRY_INTERNAL
    switch(mplayKeyEvent.enType)
    {
        case mplay_fi_tcl_e_MPlayKeyEvent::FI_EN_KEY_PRESS:
            internalKeyEvent = BUTTON_PRESS;
            break;
        case mplay_fi_tcl_e_MPlayKeyEvent::FI_EN_KEY_RELEASE:
            internalKeyEvent = BUTTON_RELEASE;
            break;
        default:
            internalKeyEvent = BUTTON_PRESS;
            ETG_TRACE_ERR(("Invalid Key Event for HID command "));
            break;
    }
}
